# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, IO, Union

from azure.identity import DefaultAzureCredential

from azure.mgmt.network import NetworkManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-network
# USAGE
    python application_gateway_create.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = NetworkManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="subid",
    )

    response = client.application_gateways.begin_create_or_update(
        resource_group_name="rg1",
        application_gateway_name="appgw",
        parameters={
            "identity": {
                "type": "UserAssigned",
                "userAssignedIdentities": {
                    "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity1": {}
                },
            },
            "location": "eastus",
            "properties": {
                "backendAddressPools": [
                    {
                        "name": "appgwpool",
                        "properties": {"backendAddresses": [{"ipAddress": "10.0.1.1"}, {"ipAddress": "10.0.1.2"}]},
                    },
                    {
                        "id": "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendAddressPools/appgwpool1",
                        "name": "appgwpool1",
                        "properties": {"backendAddresses": [{"ipAddress": "10.0.0.1"}, {"ipAddress": "10.0.0.2"}]},
                    },
                ],
                "backendHttpSettingsCollection": [
                    {
                        "name": "appgwbhs",
                        "properties": {
                            "cookieBasedAffinity": "Disabled",
                            "port": 80,
                            "protocol": "Http",
                            "requestTimeout": 30,
                        },
                    }
                ],
                "frontendIPConfigurations": [
                    {
                        "name": "appgwfip",
                        "properties": {
                            "publicIPAddress": {
                                "id": "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/appgwpip"
                            }
                        },
                    }
                ],
                "frontendPorts": [
                    {"name": "appgwfp", "properties": {"port": 443}},
                    {"name": "appgwfp80", "properties": {"port": 80}},
                ],
                "gatewayIPConfigurations": [
                    {
                        "name": "appgwipc",
                        "properties": {
                            "subnet": {
                                "id": "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet/subnets/appgwsubnet"
                            }
                        },
                    }
                ],
                "globalConfiguration": {"enableRequestBuffering": True, "enableResponseBuffering": True},
                "httpListeners": [
                    {
                        "name": "appgwhl",
                        "properties": {
                            "frontendIPConfiguration": {
                                "id": "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendIPConfigurations/appgwfip"
                            },
                            "frontendPort": {
                                "id": "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendPorts/appgwfp"
                            },
                            "protocol": "Https",
                            "requireServerNameIndication": False,
                            "sslCertificate": {
                                "id": "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/sslCertificates/sslcert"
                            },
                            "sslProfile": {
                                "id": "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/sslProfiles/sslProfile1"
                            },
                        },
                    },
                    {
                        "name": "appgwhttplistener",
                        "properties": {
                            "frontendIPConfiguration": {
                                "id": "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendIPConfigurations/appgwfip"
                            },
                            "frontendPort": {
                                "id": "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendPorts/appgwfp80"
                            },
                            "protocol": "Http",
                        },
                    },
                ],
                "requestRoutingRules": [
                    {
                        "name": "appgwrule",
                        "properties": {
                            "backendAddressPool": {
                                "id": "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendAddressPools/appgwpool"
                            },
                            "backendHttpSettings": {
                                "id": "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendHttpSettingsCollection/appgwbhs"
                            },
                            "httpListener": {
                                "id": "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/httpListeners/appgwhl"
                            },
                            "priority": 10,
                            "rewriteRuleSet": {
                                "id": "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/rewriteRuleSets/rewriteRuleSet1"
                            },
                            "ruleType": "Basic",
                        },
                    }
                ],
                "rewriteRuleSets": [
                    {
                        "name": "rewriteRuleSet1",
                        "properties": {
                            "rewriteRules": [
                                {
                                    "actionSet": {
                                        "requestHeaderConfigurations": [
                                            {
                                                "headerName": "X-Forwarded-For",
                                                "headerValue": "{var_add_x_forwarded_for_proxy}",
                                            }
                                        ],
                                        "responseHeaderConfigurations": [
                                            {
                                                "headerName": "Strict-Transport-Security",
                                                "headerValue": "max-age=31536000",
                                            }
                                        ],
                                        "urlConfiguration": {"modifiedPath": "/abc"},
                                    },
                                    "conditions": [
                                        {
                                            "ignoreCase": True,
                                            "negate": False,
                                            "pattern": "^Bearer",
                                            "variable": "http_req_Authorization",
                                        }
                                    ],
                                    "name": "Set X-Forwarded-For",
                                    "ruleSequence": 102,
                                }
                            ]
                        },
                    }
                ],
                "sku": {"capacity": 3, "name": "Standard_v2", "tier": "Standard_v2"},
                "sslCertificates": [
                    {"name": "sslcert", "properties": {"data": "****", "password": "****"}},
                    {"name": "sslcert2", "properties": {"keyVaultSecretId": "https://kv/secret"}},
                ],
                "sslProfiles": [
                    {
                        "name": "sslProfile1",
                        "properties": {
                            "clientAuthConfiguration": {"verifyClientCertIssuerDN": True},
                            "sslPolicy": {
                                "cipherSuites": ["TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256"],
                                "minProtocolVersion": "TLSv1_1",
                                "policyType": "Custom",
                            },
                            "trustedClientCertificates": [
                                {
                                    "id": "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/trustedClientCertificates/clientcert"
                                }
                            ],
                        },
                    }
                ],
                "trustedClientCertificates": [{"name": "clientcert", "properties": {"data": "****"}}],
                "trustedRootCertificates": [
                    {"name": "rootcert", "properties": {"data": "****"}},
                    {"name": "rootcert1", "properties": {"keyVaultSecretId": "https://kv/secret"}},
                ],
            },
        },
    ).result()
    print(response)


# x-ms-original-file: specification/network/resource-manager/Microsoft.Network/stable/2023-11-01/examples/ApplicationGatewayCreate.json
if __name__ == "__main__":
    main()
