# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class DimensionProperties(_serialization.Model):
    """Type of operation: get, read, delete, etc.

    :ivar name: Name of dimension.
    :vartype name: str
    :ivar display_name: Display name of dimension.
    :vartype display_name: str
    :ivar to_be_exported_for_shoebox: Legacy usage, should not set.
    :vartype to_be_exported_for_shoebox: bool
    :ivar is_hidden: When set, the dimension is hidden from the customer, used in conjunction with
     the defaultDimensionValues field below.
    :vartype is_hidden: bool
    :ivar default_dimension_values: Default dimension value to be sent down for the hidden
     dimension during query.
    :vartype default_dimension_values: JSON
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "to_be_exported_for_shoebox": {"key": "toBeExportedForShoebox", "type": "bool"},
        "is_hidden": {"key": "isHidden", "type": "bool"},
        "default_dimension_values": {"key": "defaultDimensionValues", "type": "object"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        to_be_exported_for_shoebox: Optional[bool] = None,
        is_hidden: Optional[bool] = None,
        default_dimension_values: Optional[JSON] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of dimension.
        :paramtype name: str
        :keyword display_name: Display name of dimension.
        :paramtype display_name: str
        :keyword to_be_exported_for_shoebox: Legacy usage, should not set.
        :paramtype to_be_exported_for_shoebox: bool
        :keyword is_hidden: When set, the dimension is hidden from the customer, used in conjunction
         with the defaultDimensionValues field below.
        :paramtype is_hidden: bool
        :keyword default_dimension_values: Default dimension value to be sent down for the hidden
         dimension during query.
        :paramtype default_dimension_values: JSON
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.to_be_exported_for_shoebox = to_be_exported_for_shoebox
        self.is_hidden = is_hidden
        self.default_dimension_values = default_dimension_values


class ErrorContract(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.monitor.v2021_05_01.models.ErrorResponse
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorResponse"},
    }

    def __init__(self, *, error: Optional["_models.ErrorResponse"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.monitor.v2021_05_01.models.ErrorResponse
        """
        super().__init__(**kwargs)
        self.error = error


class ErrorResponse(_serialization.Model):
    """Describes the format of Error response.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword message: Error message indicating why the operation failed.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class LocalizableString(_serialization.Model):
    """The localizable string class.

    All required parameters must be populated in order to send to Azure.

    :ivar value: the invariant value. Required.
    :vartype value: str
    :ivar localized_value: the locale specific value.
    :vartype localized_value: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, *, value: str, localized_value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: the invariant value. Required.
        :paramtype value: str
        :keyword localized_value: the locale specific value.
        :paramtype localized_value: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class LogSpecification(_serialization.Model):
    """Log specification of operation.

    :ivar name: Name of log specification.
    :vartype name: str
    :ivar display_name: Display name of log specification.
    :vartype display_name: str
    :ivar blob_duration: Blob duration of specification.
    :vartype blob_duration: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "blob_duration": {"key": "blobDuration", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        blob_duration: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of log specification.
        :paramtype name: str
        :keyword display_name: Display name of log specification.
        :paramtype display_name: str
        :keyword blob_duration: Blob duration of specification.
        :paramtype blob_duration: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.blob_duration = blob_duration


class MetadataValue(_serialization.Model):
    """Represents a metric metadata value.

    :ivar name: the name of the metadata.
    :vartype name: ~azure.mgmt.monitor.v2021_05_01.models.LocalizableString
    :ivar value: the value of the metadata.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "LocalizableString"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(
        self, *, name: Optional["_models.LocalizableString"] = None, value: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: the name of the metadata.
        :paramtype name: ~azure.mgmt.monitor.v2021_05_01.models.LocalizableString
        :keyword value: the value of the metadata.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class Metric(_serialization.Model):
    """The result data of a query.

    All required parameters must be populated in order to send to Azure.

    :ivar id: the metric Id. Required.
    :vartype id: str
    :ivar type: the resource type of the metric resource. Required.
    :vartype type: str
    :ivar name: the name and the display name of the metric, i.e. it is localizable string.
     Required.
    :vartype name: ~azure.mgmt.monitor.v2021_05_01.models.LocalizableString
    :ivar display_description: Detailed description of this metric.
    :vartype display_description: str
    :ivar error_code: 'Success' or the error details on query failures for this metric.
    :vartype error_code: str
    :ivar error_message: Error message encountered querying this specific metric.
    :vartype error_message: str
    :ivar unit: The unit of the metric. Required. Known values are: "Count", "Bytes", "Seconds",
     "CountPerSecond", "BytesPerSecond", "Percent", "MilliSeconds", "ByteSeconds", "Unspecified",
     "Cores", "MilliCores", "NanoCores", and "BitsPerSecond".
    :vartype unit: str or ~azure.mgmt.monitor.v2021_05_01.models.Unit
    :ivar timeseries: the time series returned when a data query is performed. Required.
    :vartype timeseries: list[~azure.mgmt.monitor.v2021_05_01.models.TimeSeriesElement]
    """

    _validation = {
        "id": {"required": True},
        "type": {"required": True},
        "name": {"required": True},
        "unit": {"required": True},
        "timeseries": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "LocalizableString"},
        "display_description": {"key": "displayDescription", "type": "str"},
        "error_code": {"key": "errorCode", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "timeseries": {"key": "timeseries", "type": "[TimeSeriesElement]"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        type: str,
        name: "_models.LocalizableString",
        unit: Union[str, "_models.Unit"],
        timeseries: List["_models.TimeSeriesElement"],
        display_description: Optional[str] = None,
        error_code: Optional[str] = None,
        error_message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: the metric Id. Required.
        :paramtype id: str
        :keyword type: the resource type of the metric resource. Required.
        :paramtype type: str
        :keyword name: the name and the display name of the metric, i.e. it is localizable string.
         Required.
        :paramtype name: ~azure.mgmt.monitor.v2021_05_01.models.LocalizableString
        :keyword display_description: Detailed description of this metric.
        :paramtype display_description: str
        :keyword error_code: 'Success' or the error details on query failures for this metric.
        :paramtype error_code: str
        :keyword error_message: Error message encountered querying this specific metric.
        :paramtype error_message: str
        :keyword unit: The unit of the metric. Required. Known values are: "Count", "Bytes", "Seconds",
         "CountPerSecond", "BytesPerSecond", "Percent", "MilliSeconds", "ByteSeconds", "Unspecified",
         "Cores", "MilliCores", "NanoCores", and "BitsPerSecond".
        :paramtype unit: str or ~azure.mgmt.monitor.v2021_05_01.models.Unit
        :keyword timeseries: the time series returned when a data query is performed. Required.
        :paramtype timeseries: list[~azure.mgmt.monitor.v2021_05_01.models.TimeSeriesElement]
        """
        super().__init__(**kwargs)
        self.id = id
        self.type = type
        self.name = name
        self.display_description = display_description
        self.error_code = error_code
        self.error_message = error_message
        self.unit = unit
        self.timeseries = timeseries


class MetricAvailability(_serialization.Model):
    """Metric availability specifies the time grain (aggregation interval or frequency) and the
    retention period for that time grain.

    :ivar time_grain: the time grain specifies the aggregation interval for the metric. Expressed
     as a duration 'PT1M', 'P1D', etc.
    :vartype time_grain: ~datetime.timedelta
    :ivar retention: the retention period for the metric at the specified timegrain.  Expressed as
     a duration 'PT1M', 'P1D', etc.
    :vartype retention: ~datetime.timedelta
    """

    _attribute_map = {
        "time_grain": {"key": "timeGrain", "type": "duration"},
        "retention": {"key": "retention", "type": "duration"},
    }

    def __init__(
        self,
        *,
        time_grain: Optional[datetime.timedelta] = None,
        retention: Optional[datetime.timedelta] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword time_grain: the time grain specifies the aggregation interval for the metric.
         Expressed as a duration 'PT1M', 'P1D', etc.
        :paramtype time_grain: ~datetime.timedelta
        :keyword retention: the retention period for the metric at the specified timegrain.  Expressed
         as a duration 'PT1M', 'P1D', etc.
        :paramtype retention: ~datetime.timedelta
        """
        super().__init__(**kwargs)
        self.time_grain = time_grain
        self.retention = retention


class MetricDefinition(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Metric definition class specifies the metadata for a metric.

    :ivar is_dimension_required: Flag to indicate whether the dimension is required.
    :vartype is_dimension_required: bool
    :ivar resource_id: the resource identifier of the resource that emitted the metric.
    :vartype resource_id: str
    :ivar namespace: the namespace the metric belongs to.
    :vartype namespace: str
    :ivar name: the name and the display name of the metric, i.e. it is a localizable string.
    :vartype name: ~azure.mgmt.monitor.v2021_05_01.models.LocalizableString
    :ivar display_description: Detailed description of this metric.
    :vartype display_description: str
    :ivar category: Custom category name for this metric.
    :vartype category: str
    :ivar metric_class: The class of the metric. Known values are: "Availability", "Transactions",
     "Errors", "Latency", and "Saturation".
    :vartype metric_class: str or ~azure.mgmt.monitor.v2021_05_01.models.MetricClass
    :ivar unit: the unit of the metric. Known values are: "Count", "Bytes", "Seconds",
     "CountPerSecond", "BytesPerSecond", "Percent", "MilliSeconds", "ByteSeconds", "Unspecified",
     "Cores", "MilliCores", "NanoCores", and "BitsPerSecond".
    :vartype unit: str or ~azure.mgmt.monitor.v2021_05_01.models.MetricUnit
    :ivar primary_aggregation_type: the primary aggregation type value defining how to use the
     values for display. Known values are: "None", "Average", "Count", "Minimum", "Maximum", and
     "Total".
    :vartype primary_aggregation_type: str or
     ~azure.mgmt.monitor.v2021_05_01.models.AggregationType
    :ivar supported_aggregation_types: the collection of what aggregation types are supported.
    :vartype supported_aggregation_types: list[str or
     ~azure.mgmt.monitor.v2021_05_01.models.AggregationType]
    :ivar metric_availabilities: the collection of what aggregation intervals are available to be
     queried.
    :vartype metric_availabilities: list[~azure.mgmt.monitor.v2021_05_01.models.MetricAvailability]
    :ivar id: the resource identifier of the metric definition.
    :vartype id: str
    :ivar dimensions: the name and the display name of the dimension, i.e. it is a localizable
     string.
    :vartype dimensions: list[~azure.mgmt.monitor.v2021_05_01.models.LocalizableString]
    """

    _attribute_map = {
        "is_dimension_required": {"key": "isDimensionRequired", "type": "bool"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "namespace": {"key": "namespace", "type": "str"},
        "name": {"key": "name", "type": "LocalizableString"},
        "display_description": {"key": "displayDescription", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "metric_class": {"key": "metricClass", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "primary_aggregation_type": {"key": "primaryAggregationType", "type": "str"},
        "supported_aggregation_types": {"key": "supportedAggregationTypes", "type": "[str]"},
        "metric_availabilities": {"key": "metricAvailabilities", "type": "[MetricAvailability]"},
        "id": {"key": "id", "type": "str"},
        "dimensions": {"key": "dimensions", "type": "[LocalizableString]"},
    }

    def __init__(
        self,
        *,
        is_dimension_required: Optional[bool] = None,
        resource_id: Optional[str] = None,
        namespace: Optional[str] = None,
        name: Optional["_models.LocalizableString"] = None,
        display_description: Optional[str] = None,
        category: Optional[str] = None,
        metric_class: Optional[Union[str, "_models.MetricClass"]] = None,
        unit: Optional[Union[str, "_models.MetricUnit"]] = None,
        primary_aggregation_type: Optional[Union[str, "_models.AggregationType"]] = None,
        supported_aggregation_types: Optional[List[Union[str, "_models.AggregationType"]]] = None,
        metric_availabilities: Optional[List["_models.MetricAvailability"]] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        dimensions: Optional[List["_models.LocalizableString"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_dimension_required: Flag to indicate whether the dimension is required.
        :paramtype is_dimension_required: bool
        :keyword resource_id: the resource identifier of the resource that emitted the metric.
        :paramtype resource_id: str
        :keyword namespace: the namespace the metric belongs to.
        :paramtype namespace: str
        :keyword name: the name and the display name of the metric, i.e. it is a localizable string.
        :paramtype name: ~azure.mgmt.monitor.v2021_05_01.models.LocalizableString
        :keyword display_description: Detailed description of this metric.
        :paramtype display_description: str
        :keyword category: Custom category name for this metric.
        :paramtype category: str
        :keyword metric_class: The class of the metric. Known values are: "Availability",
         "Transactions", "Errors", "Latency", and "Saturation".
        :paramtype metric_class: str or ~azure.mgmt.monitor.v2021_05_01.models.MetricClass
        :keyword unit: the unit of the metric. Known values are: "Count", "Bytes", "Seconds",
         "CountPerSecond", "BytesPerSecond", "Percent", "MilliSeconds", "ByteSeconds", "Unspecified",
         "Cores", "MilliCores", "NanoCores", and "BitsPerSecond".
        :paramtype unit: str or ~azure.mgmt.monitor.v2021_05_01.models.MetricUnit
        :keyword primary_aggregation_type: the primary aggregation type value defining how to use the
         values for display. Known values are: "None", "Average", "Count", "Minimum", "Maximum", and
         "Total".
        :paramtype primary_aggregation_type: str or
         ~azure.mgmt.monitor.v2021_05_01.models.AggregationType
        :keyword supported_aggregation_types: the collection of what aggregation types are supported.
        :paramtype supported_aggregation_types: list[str or
         ~azure.mgmt.monitor.v2021_05_01.models.AggregationType]
        :keyword metric_availabilities: the collection of what aggregation intervals are available to
         be queried.
        :paramtype metric_availabilities:
         list[~azure.mgmt.monitor.v2021_05_01.models.MetricAvailability]
        :keyword id: the resource identifier of the metric definition.
        :paramtype id: str
        :keyword dimensions: the name and the display name of the dimension, i.e. it is a localizable
         string.
        :paramtype dimensions: list[~azure.mgmt.monitor.v2021_05_01.models.LocalizableString]
        """
        super().__init__(**kwargs)
        self.is_dimension_required = is_dimension_required
        self.resource_id = resource_id
        self.namespace = namespace
        self.name = name
        self.display_description = display_description
        self.category = category
        self.metric_class = metric_class
        self.unit = unit
        self.primary_aggregation_type = primary_aggregation_type
        self.supported_aggregation_types = supported_aggregation_types
        self.metric_availabilities = metric_availabilities
        self.id = id
        self.dimensions = dimensions


class MetricDefinitionCollection(_serialization.Model):
    """Represents collection of metric definitions.

    All required parameters must be populated in order to send to Azure.

    :ivar value: the values for the metric definitions. Required.
    :vartype value: list[~azure.mgmt.monitor.v2021_05_01.models.MetricDefinition]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[MetricDefinition]"},
    }

    def __init__(self, *, value: List["_models.MetricDefinition"], **kwargs: Any) -> None:
        """
        :keyword value: the values for the metric definitions. Required.
        :paramtype value: list[~azure.mgmt.monitor.v2021_05_01.models.MetricDefinition]
        """
        super().__init__(**kwargs)
        self.value = value


class MetricSpecification(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Metric specification of operation.

    :ivar name: The name of the metric.
    :vartype name: str
    :ivar display_name: Display name of the metric.
    :vartype display_name: str
    :ivar display_description: Display description of the metric.
    :vartype display_description: str
    :ivar unit: The metric unit. Possible values include:
     Count,Bytes,Seconds,Percent,CountPerSecond,BytesPerSecond,MilliSeconds,ByteSeconds,Unspecified,BitsPerSecond,Cores,MilliCores,NanoCores.
    :vartype unit: str
    :ivar aggregation_type: The default metric aggregation type. Possible values include:
     Total,Average,Maximum,Minimum,Count.
    :vartype aggregation_type: str
    :ivar supported_aggregation_types: The supported aggregation types for the metrics.
    :vartype supported_aggregation_types: list[str]
    :ivar supported_time_grain_types: The supported time grain types for the metrics.
    :vartype supported_time_grain_types: list[str]
    :ivar availabilities: The supported time grain types for the metrics.
    :vartype availabilities: list[str]
    :ivar lock_aggregation_type: The metric lock aggregation type.
    :vartype lock_aggregation_type: str
    :ivar category: Category or type of metric.
    :vartype category: str
    :ivar dimensions: The dimensions of metric.
    :vartype dimensions: list[~azure.mgmt.monitor.v2021_05_01.models.DimensionProperties]
    :ivar fill_gap_with_zero: Property to specify whether to fill empty gaps with zero.
    :vartype fill_gap_with_zero: bool
    :ivar internal_metric_name: The internal metric name.
    :vartype internal_metric_name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "display_description": {"key": "displayDescription", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "aggregation_type": {"key": "aggregationType", "type": "str"},
        "supported_aggregation_types": {"key": "supportedAggregationTypes", "type": "[str]"},
        "supported_time_grain_types": {"key": "supportedTimeGrainTypes", "type": "[str]"},
        "availabilities": {"key": "availabilities", "type": "[str]"},
        "lock_aggregation_type": {"key": "lockAggregationType", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "dimensions": {"key": "dimensions", "type": "[DimensionProperties]"},
        "fill_gap_with_zero": {"key": "fillGapWithZero", "type": "bool"},
        "internal_metric_name": {"key": "internalMetricName", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        aggregation_type: Optional[str] = None,
        supported_aggregation_types: Optional[List[str]] = None,
        supported_time_grain_types: Optional[List[str]] = None,
        availabilities: Optional[List[str]] = None,
        lock_aggregation_type: Optional[str] = None,
        category: Optional[str] = None,
        dimensions: Optional[List["_models.DimensionProperties"]] = None,
        fill_gap_with_zero: Optional[bool] = None,
        internal_metric_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the metric.
        :paramtype name: str
        :keyword display_name: Display name of the metric.
        :paramtype display_name: str
        :keyword display_description: Display description of the metric.
        :paramtype display_description: str
        :keyword unit: The metric unit. Possible values include:
         Count,Bytes,Seconds,Percent,CountPerSecond,BytesPerSecond,MilliSeconds,ByteSeconds,Unspecified,BitsPerSecond,Cores,MilliCores,NanoCores.
        :paramtype unit: str
        :keyword aggregation_type: The default metric aggregation type. Possible values include:
         Total,Average,Maximum,Minimum,Count.
        :paramtype aggregation_type: str
        :keyword supported_aggregation_types: The supported aggregation types for the metrics.
        :paramtype supported_aggregation_types: list[str]
        :keyword supported_time_grain_types: The supported time grain types for the metrics.
        :paramtype supported_time_grain_types: list[str]
        :keyword availabilities: The supported time grain types for the metrics.
        :paramtype availabilities: list[str]
        :keyword lock_aggregation_type: The metric lock aggregation type.
        :paramtype lock_aggregation_type: str
        :keyword category: Category or type of metric.
        :paramtype category: str
        :keyword dimensions: The dimensions of metric.
        :paramtype dimensions: list[~azure.mgmt.monitor.v2021_05_01.models.DimensionProperties]
        :keyword fill_gap_with_zero: Property to specify whether to fill empty gaps with zero.
        :paramtype fill_gap_with_zero: bool
        :keyword internal_metric_name: The internal metric name.
        :paramtype internal_metric_name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.aggregation_type = aggregation_type
        self.supported_aggregation_types = supported_aggregation_types
        self.supported_time_grain_types = supported_time_grain_types
        self.availabilities = availabilities
        self.lock_aggregation_type = lock_aggregation_type
        self.category = category
        self.dimensions = dimensions
        self.fill_gap_with_zero = fill_gap_with_zero
        self.internal_metric_name = internal_metric_name


class MetricValue(_serialization.Model):
    """Represents a metric value.

    All required parameters must be populated in order to send to Azure.

    :ivar time_stamp: the timestamp for the metric value in ISO 8601 format. Required.
    :vartype time_stamp: ~datetime.datetime
    :ivar average: the average value in the time range.
    :vartype average: float
    :ivar minimum: the least value in the time range.
    :vartype minimum: float
    :ivar maximum: the greatest value in the time range.
    :vartype maximum: float
    :ivar total: the sum of all of the values in the time range.
    :vartype total: float
    :ivar count: the number of samples in the time range. Can be used to determine the number of
     values that contributed to the average value.
    :vartype count: float
    """

    _validation = {
        "time_stamp": {"required": True},
    }

    _attribute_map = {
        "time_stamp": {"key": "timeStamp", "type": "iso-8601"},
        "average": {"key": "average", "type": "float"},
        "minimum": {"key": "minimum", "type": "float"},
        "maximum": {"key": "maximum", "type": "float"},
        "total": {"key": "total", "type": "float"},
        "count": {"key": "count", "type": "float"},
    }

    def __init__(
        self,
        *,
        time_stamp: datetime.datetime,
        average: Optional[float] = None,
        minimum: Optional[float] = None,
        maximum: Optional[float] = None,
        total: Optional[float] = None,
        count: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword time_stamp: the timestamp for the metric value in ISO 8601 format. Required.
        :paramtype time_stamp: ~datetime.datetime
        :keyword average: the average value in the time range.
        :paramtype average: float
        :keyword minimum: the least value in the time range.
        :paramtype minimum: float
        :keyword maximum: the greatest value in the time range.
        :paramtype maximum: float
        :keyword total: the sum of all of the values in the time range.
        :paramtype total: float
        :keyword count: the number of samples in the time range. Can be used to determine the number of
         values that contributed to the average value.
        :paramtype count: float
        """
        super().__init__(**kwargs)
        self.time_stamp = time_stamp
        self.average = average
        self.minimum = minimum
        self.maximum = maximum
        self.total = total
        self.count = count


class Operation(_serialization.Model):
    """Microsoft Insights API operation definition.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar is_data_action: Property to specify whether the action is a data action.
    :vartype is_data_action: bool
    :ivar display: Display metadata associated with the operation.
    :vartype display: ~azure.mgmt.monitor.v2021_05_01.models.OperationDisplay
    :ivar service_specification: One property of operation, include metric specifications.
    :vartype service_specification: ~azure.mgmt.monitor.v2021_05_01.models.ServiceSpecification
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "service_specification": {"key": "properties.serviceSpecification", "type": "ServiceSpecification"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        display: Optional["_models.OperationDisplay"] = None,
        service_specification: Optional["_models.ServiceSpecification"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword is_data_action: Property to specify whether the action is a data action.
        :paramtype is_data_action: bool
        :keyword display: Display metadata associated with the operation.
        :paramtype display: ~azure.mgmt.monitor.v2021_05_01.models.OperationDisplay
        :keyword service_specification: One property of operation, include metric specifications.
        :paramtype service_specification: ~azure.mgmt.monitor.v2021_05_01.models.ServiceSpecification
        """
        super().__init__(**kwargs)
        self.name = name
        self.is_data_action = is_data_action
        self.display = display
        self.service_specification = service_specification


class OperationDisplay(_serialization.Model):
    """Display metadata associated with the operation.

    :ivar publisher: The publisher of this operation.
    :vartype publisher: str
    :ivar provider: Service provider: Microsoft.Insights.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: AlertRules, Autoscale, etc.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    :ivar description: The description of the operation.
    :vartype description: str
    """

    _attribute_map = {
        "publisher": {"key": "publisher", "type": "str"},
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        publisher: Optional[str] = None,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword publisher: The publisher of this operation.
        :paramtype publisher: str
        :keyword provider: Service provider: Microsoft.Insights.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed: AlertRules, Autoscale, etc.
        :paramtype resource: str
        :keyword operation: Operation type: Read, write, delete, etc.
        :paramtype operation: str
        :keyword description: The description of the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.publisher = publisher
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(_serialization.Model):
    """Result of the request to list Microsoft.Insights operations. It contains a list of operations
    and a URL link to get the next set of results.

    :ivar value: List of operations supported by the Microsoft.Insights provider.
    :vartype value: list[~azure.mgmt.monitor.v2021_05_01.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Operation"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of operations supported by the Microsoft.Insights provider.
        :paramtype value: list[~azure.mgmt.monitor.v2021_05_01.models.Operation]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Response(_serialization.Model):
    """The response to a metrics query.

    All required parameters must be populated in order to send to Azure.

    :ivar cost: The integer value representing the relative cost of the query.
    :vartype cost: int
    :ivar timespan: The timespan for which the data was retrieved. Its value consists of two
     datetimes concatenated, separated by '/'.  This may be adjusted in the future and returned back
     from what was originally requested. Required.
    :vartype timespan: str
    :ivar interval: The interval (window size) for which the metric data was returned in.  This may
     be adjusted in the future and returned back from what was originally requested.  This is not
     present if a metadata request was made.
    :vartype interval: ~datetime.timedelta
    :ivar namespace: The namespace of the metrics being queried.
    :vartype namespace: str
    :ivar resourceregion: The region of the resource being queried for metrics.
    :vartype resourceregion: str
    :ivar value: the value of the collection. Required.
    :vartype value: list[~azure.mgmt.monitor.v2021_05_01.models.Metric]
    """

    _validation = {
        "cost": {"minimum": 0},
        "timespan": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "cost": {"key": "cost", "type": "int"},
        "timespan": {"key": "timespan", "type": "str"},
        "interval": {"key": "interval", "type": "duration"},
        "namespace": {"key": "namespace", "type": "str"},
        "resourceregion": {"key": "resourceregion", "type": "str"},
        "value": {"key": "value", "type": "[Metric]"},
    }

    def __init__(
        self,
        *,
        timespan: str,
        value: List["_models.Metric"],
        cost: Optional[int] = None,
        interval: Optional[datetime.timedelta] = None,
        namespace: Optional[str] = None,
        resourceregion: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword cost: The integer value representing the relative cost of the query.
        :paramtype cost: int
        :keyword timespan: The timespan for which the data was retrieved. Its value consists of two
         datetimes concatenated, separated by '/'.  This may be adjusted in the future and returned back
         from what was originally requested. Required.
        :paramtype timespan: str
        :keyword interval: The interval (window size) for which the metric data was returned in.  This
         may be adjusted in the future and returned back from what was originally requested.  This is
         not present if a metadata request was made.
        :paramtype interval: ~datetime.timedelta
        :keyword namespace: The namespace of the metrics being queried.
        :paramtype namespace: str
        :keyword resourceregion: The region of the resource being queried for metrics.
        :paramtype resourceregion: str
        :keyword value: the value of the collection. Required.
        :paramtype value: list[~azure.mgmt.monitor.v2021_05_01.models.Metric]
        """
        super().__init__(**kwargs)
        self.cost = cost
        self.timespan = timespan
        self.interval = interval
        self.namespace = namespace
        self.resourceregion = resourceregion
        self.value = value


class ServiceSpecification(_serialization.Model):
    """One property of operation, include log specifications.

    :ivar log_specifications: Log specifications of operation.
    :vartype log_specifications: list[~azure.mgmt.monitor.v2021_05_01.models.LogSpecification]
    :ivar metric_specifications: Metric specifications of operation.
    :vartype metric_specifications:
     list[~azure.mgmt.monitor.v2021_05_01.models.MetricSpecification]
    :ivar legacy_metric_specifications: Legacy Metric specifications for operation. Deprecated, do
     not use.
    :vartype legacy_metric_specifications: JSON
    """

    _attribute_map = {
        "log_specifications": {"key": "logSpecifications", "type": "[LogSpecification]"},
        "metric_specifications": {"key": "metricSpecifications", "type": "[MetricSpecification]"},
        "legacy_metric_specifications": {"key": "legacyMetricSpecifications", "type": "object"},
    }

    def __init__(
        self,
        *,
        log_specifications: Optional[List["_models.LogSpecification"]] = None,
        metric_specifications: Optional[List["_models.MetricSpecification"]] = None,
        legacy_metric_specifications: Optional[JSON] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword log_specifications: Log specifications of operation.
        :paramtype log_specifications: list[~azure.mgmt.monitor.v2021_05_01.models.LogSpecification]
        :keyword metric_specifications: Metric specifications of operation.
        :paramtype metric_specifications:
         list[~azure.mgmt.monitor.v2021_05_01.models.MetricSpecification]
        :keyword legacy_metric_specifications: Legacy Metric specifications for operation. Deprecated,
         do not use.
        :paramtype legacy_metric_specifications: JSON
        """
        super().__init__(**kwargs)
        self.log_specifications = log_specifications
        self.metric_specifications = metric_specifications
        self.legacy_metric_specifications = legacy_metric_specifications


class SubscriptionScopeMetric(_serialization.Model):
    """The result data of a query.

    All required parameters must be populated in order to send to Azure.

    :ivar id: the metric Id. Required.
    :vartype id: str
    :ivar type: the resource type of the metric resource. Required.
    :vartype type: str
    :ivar name: the name and the display name of the metric, i.e. it is localizable string.
     Required.
    :vartype name: ~azure.mgmt.monitor.v2021_05_01.models.LocalizableString
    :ivar display_description: Detailed description of this metric.
    :vartype display_description: str
    :ivar error_code: 'Success' or the error details on query failures for this metric.
    :vartype error_code: str
    :ivar error_message: Error message encountered querying this specific metric.
    :vartype error_message: str
    :ivar unit: The unit of the metric. Required. Known values are: "Count", "Bytes", "Seconds",
     "CountPerSecond", "BytesPerSecond", "Percent", "MilliSeconds", "ByteSeconds", "Unspecified",
     "Cores", "MilliCores", "NanoCores", and "BitsPerSecond".
    :vartype unit: str or ~azure.mgmt.monitor.v2021_05_01.models.MetricUnit
    :ivar timeseries: the time series returned when a data query is performed. Required.
    :vartype timeseries: list[~azure.mgmt.monitor.v2021_05_01.models.TimeSeriesElement]
    """

    _validation = {
        "id": {"required": True},
        "type": {"required": True},
        "name": {"required": True},
        "unit": {"required": True},
        "timeseries": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "LocalizableString"},
        "display_description": {"key": "displayDescription", "type": "str"},
        "error_code": {"key": "errorCode", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "timeseries": {"key": "timeseries", "type": "[TimeSeriesElement]"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        type: str,
        name: "_models.LocalizableString",
        unit: Union[str, "_models.MetricUnit"],
        timeseries: List["_models.TimeSeriesElement"],
        display_description: Optional[str] = None,
        error_code: Optional[str] = None,
        error_message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: the metric Id. Required.
        :paramtype id: str
        :keyword type: the resource type of the metric resource. Required.
        :paramtype type: str
        :keyword name: the name and the display name of the metric, i.e. it is localizable string.
         Required.
        :paramtype name: ~azure.mgmt.monitor.v2021_05_01.models.LocalizableString
        :keyword display_description: Detailed description of this metric.
        :paramtype display_description: str
        :keyword error_code: 'Success' or the error details on query failures for this metric.
        :paramtype error_code: str
        :keyword error_message: Error message encountered querying this specific metric.
        :paramtype error_message: str
        :keyword unit: The unit of the metric. Required. Known values are: "Count", "Bytes", "Seconds",
         "CountPerSecond", "BytesPerSecond", "Percent", "MilliSeconds", "ByteSeconds", "Unspecified",
         "Cores", "MilliCores", "NanoCores", and "BitsPerSecond".
        :paramtype unit: str or ~azure.mgmt.monitor.v2021_05_01.models.MetricUnit
        :keyword timeseries: the time series returned when a data query is performed. Required.
        :paramtype timeseries: list[~azure.mgmt.monitor.v2021_05_01.models.TimeSeriesElement]
        """
        super().__init__(**kwargs)
        self.id = id
        self.type = type
        self.name = name
        self.display_description = display_description
        self.error_code = error_code
        self.error_message = error_message
        self.unit = unit
        self.timeseries = timeseries


class SubscriptionScopeMetricDefinition(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Metric definition class specifies the metadata for a metric.

    :ivar is_dimension_required: Flag to indicate whether the dimension is required.
    :vartype is_dimension_required: bool
    :ivar resource_id: the resource identifier of the resource that emitted the metric.
    :vartype resource_id: str
    :ivar namespace: the namespace the metric belongs to.
    :vartype namespace: str
    :ivar name: the name and the display name of the metric, i.e. it is a localizable string.
    :vartype name: ~azure.mgmt.monitor.v2021_05_01.models.LocalizableString
    :ivar display_description: Detailed description of this metric.
    :vartype display_description: str
    :ivar category: Custom category name for this metric.
    :vartype category: str
    :ivar metric_class: The class of the metric. Known values are: "Availability", "Transactions",
     "Errors", "Latency", and "Saturation".
    :vartype metric_class: str or ~azure.mgmt.monitor.v2021_05_01.models.MetricClass
    :ivar unit: the unit of the metric. Known values are: "Count", "Bytes", "Seconds",
     "CountPerSecond", "BytesPerSecond", "Percent", "MilliSeconds", "ByteSeconds", "Unspecified",
     "Cores", "MilliCores", "NanoCores", and "BitsPerSecond".
    :vartype unit: str or ~azure.mgmt.monitor.v2021_05_01.models.MetricUnit
    :ivar primary_aggregation_type: the primary aggregation type value defining how to use the
     values for display. Known values are: "None", "Average", "Count", "Minimum", "Maximum", and
     "Total".
    :vartype primary_aggregation_type: str or
     ~azure.mgmt.monitor.v2021_05_01.models.MetricAggregationType
    :ivar supported_aggregation_types: the collection of what aggregation types are supported.
    :vartype supported_aggregation_types: list[str or
     ~azure.mgmt.monitor.v2021_05_01.models.MetricAggregationType]
    :ivar metric_availabilities: the collection of what aggregation intervals are available to be
     queried.
    :vartype metric_availabilities: list[~azure.mgmt.monitor.v2021_05_01.models.MetricAvailability]
    :ivar id: the resource identifier of the metric definition.
    :vartype id: str
    :ivar dimensions: the name and the display name of the dimension, i.e. it is a localizable
     string.
    :vartype dimensions: list[~azure.mgmt.monitor.v2021_05_01.models.LocalizableString]
    """

    _attribute_map = {
        "is_dimension_required": {"key": "isDimensionRequired", "type": "bool"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "namespace": {"key": "namespace", "type": "str"},
        "name": {"key": "name", "type": "LocalizableString"},
        "display_description": {"key": "displayDescription", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "metric_class": {"key": "metricClass", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "primary_aggregation_type": {"key": "primaryAggregationType", "type": "str"},
        "supported_aggregation_types": {"key": "supportedAggregationTypes", "type": "[str]"},
        "metric_availabilities": {"key": "metricAvailabilities", "type": "[MetricAvailability]"},
        "id": {"key": "id", "type": "str"},
        "dimensions": {"key": "dimensions", "type": "[LocalizableString]"},
    }

    def __init__(
        self,
        *,
        is_dimension_required: Optional[bool] = None,
        resource_id: Optional[str] = None,
        namespace: Optional[str] = None,
        name: Optional["_models.LocalizableString"] = None,
        display_description: Optional[str] = None,
        category: Optional[str] = None,
        metric_class: Optional[Union[str, "_models.MetricClass"]] = None,
        unit: Optional[Union[str, "_models.MetricUnit"]] = None,
        primary_aggregation_type: Optional[Union[str, "_models.MetricAggregationType"]] = None,
        supported_aggregation_types: Optional[List[Union[str, "_models.MetricAggregationType"]]] = None,
        metric_availabilities: Optional[List["_models.MetricAvailability"]] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        dimensions: Optional[List["_models.LocalizableString"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_dimension_required: Flag to indicate whether the dimension is required.
        :paramtype is_dimension_required: bool
        :keyword resource_id: the resource identifier of the resource that emitted the metric.
        :paramtype resource_id: str
        :keyword namespace: the namespace the metric belongs to.
        :paramtype namespace: str
        :keyword name: the name and the display name of the metric, i.e. it is a localizable string.
        :paramtype name: ~azure.mgmt.monitor.v2021_05_01.models.LocalizableString
        :keyword display_description: Detailed description of this metric.
        :paramtype display_description: str
        :keyword category: Custom category name for this metric.
        :paramtype category: str
        :keyword metric_class: The class of the metric. Known values are: "Availability",
         "Transactions", "Errors", "Latency", and "Saturation".
        :paramtype metric_class: str or ~azure.mgmt.monitor.v2021_05_01.models.MetricClass
        :keyword unit: the unit of the metric. Known values are: "Count", "Bytes", "Seconds",
         "CountPerSecond", "BytesPerSecond", "Percent", "MilliSeconds", "ByteSeconds", "Unspecified",
         "Cores", "MilliCores", "NanoCores", and "BitsPerSecond".
        :paramtype unit: str or ~azure.mgmt.monitor.v2021_05_01.models.MetricUnit
        :keyword primary_aggregation_type: the primary aggregation type value defining how to use the
         values for display. Known values are: "None", "Average", "Count", "Minimum", "Maximum", and
         "Total".
        :paramtype primary_aggregation_type: str or
         ~azure.mgmt.monitor.v2021_05_01.models.MetricAggregationType
        :keyword supported_aggregation_types: the collection of what aggregation types are supported.
        :paramtype supported_aggregation_types: list[str or
         ~azure.mgmt.monitor.v2021_05_01.models.MetricAggregationType]
        :keyword metric_availabilities: the collection of what aggregation intervals are available to
         be queried.
        :paramtype metric_availabilities:
         list[~azure.mgmt.monitor.v2021_05_01.models.MetricAvailability]
        :keyword id: the resource identifier of the metric definition.
        :paramtype id: str
        :keyword dimensions: the name and the display name of the dimension, i.e. it is a localizable
         string.
        :paramtype dimensions: list[~azure.mgmt.monitor.v2021_05_01.models.LocalizableString]
        """
        super().__init__(**kwargs)
        self.is_dimension_required = is_dimension_required
        self.resource_id = resource_id
        self.namespace = namespace
        self.name = name
        self.display_description = display_description
        self.category = category
        self.metric_class = metric_class
        self.unit = unit
        self.primary_aggregation_type = primary_aggregation_type
        self.supported_aggregation_types = supported_aggregation_types
        self.metric_availabilities = metric_availabilities
        self.id = id
        self.dimensions = dimensions


class SubscriptionScopeMetricDefinitionCollection(_serialization.Model):
    """Represents collection of metric definitions.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The values for the metric definitions. Required.
    :vartype value: list[~azure.mgmt.monitor.v2021_05_01.models.SubscriptionScopeMetricDefinition]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SubscriptionScopeMetricDefinition]"},
    }

    def __init__(self, *, value: List["_models.SubscriptionScopeMetricDefinition"], **kwargs: Any) -> None:
        """
        :keyword value: The values for the metric definitions. Required.
        :paramtype value:
         list[~azure.mgmt.monitor.v2021_05_01.models.SubscriptionScopeMetricDefinition]
        """
        super().__init__(**kwargs)
        self.value = value


class SubscriptionScopeMetricResponse(_serialization.Model):
    """The response to a subscription scope metrics query.

    All required parameters must be populated in order to send to Azure.

    :ivar cost: The integer value representing the relative cost of the query.
    :vartype cost: int
    :ivar timespan: The timespan for which the data was retrieved. Its value consists of two
     datetimes concatenated, separated by '/'.  This may be adjusted in the future and returned back
     from what was originally requested. Required.
    :vartype timespan: str
    :ivar interval: The interval (window size) for which the metric data was returned in.  This may
     be adjusted in the future and returned back from what was originally requested.  This is not
     present if a metadata request was made.
    :vartype interval: ~datetime.timedelta
    :ivar namespace: The namespace of the metrics being queried.
    :vartype namespace: str
    :ivar resourceregion: The region of the resource being queried for metrics.
    :vartype resourceregion: str
    :ivar value: the value of the collection. Required.
    :vartype value: list[~azure.mgmt.monitor.v2021_05_01.models.SubscriptionScopeMetric]
    """

    _validation = {
        "cost": {"minimum": 0},
        "timespan": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "cost": {"key": "cost", "type": "int"},
        "timespan": {"key": "timespan", "type": "str"},
        "interval": {"key": "interval", "type": "duration"},
        "namespace": {"key": "namespace", "type": "str"},
        "resourceregion": {"key": "resourceregion", "type": "str"},
        "value": {"key": "value", "type": "[SubscriptionScopeMetric]"},
    }

    def __init__(
        self,
        *,
        timespan: str,
        value: List["_models.SubscriptionScopeMetric"],
        cost: Optional[int] = None,
        interval: Optional[datetime.timedelta] = None,
        namespace: Optional[str] = None,
        resourceregion: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword cost: The integer value representing the relative cost of the query.
        :paramtype cost: int
        :keyword timespan: The timespan for which the data was retrieved. Its value consists of two
         datetimes concatenated, separated by '/'.  This may be adjusted in the future and returned back
         from what was originally requested. Required.
        :paramtype timespan: str
        :keyword interval: The interval (window size) for which the metric data was returned in.  This
         may be adjusted in the future and returned back from what was originally requested.  This is
         not present if a metadata request was made.
        :paramtype interval: ~datetime.timedelta
        :keyword namespace: The namespace of the metrics being queried.
        :paramtype namespace: str
        :keyword resourceregion: The region of the resource being queried for metrics.
        :paramtype resourceregion: str
        :keyword value: the value of the collection. Required.
        :paramtype value: list[~azure.mgmt.monitor.v2021_05_01.models.SubscriptionScopeMetric]
        """
        super().__init__(**kwargs)
        self.cost = cost
        self.timespan = timespan
        self.interval = interval
        self.namespace = namespace
        self.resourceregion = resourceregion
        self.value = value


class SubscriptionScopeMetricsRequestBodyParameters(
    _serialization.Model
):  # pylint: disable=too-many-instance-attributes
    """Query parameters can also be specified in the body, specifying the same parameter in both the
    body and query parameters will result in an error.

    :ivar timespan: The timespan of the query. It is a string with the following format
     'startDateTime_ISO/endDateTime_ISO'.
    :vartype timespan: ~datetime.time
    :ivar interval: The interval (i.e. timegrain) of the query.
    :vartype interval: ~datetime.timedelta
    :ivar metric_names: The names of the metrics (comma separated) to retrieve.
    :vartype metric_names: str
    :ivar aggregation: The list of aggregation types (comma separated) to retrieve.
    :vartype aggregation: str
    :ivar filter: The **$filter** is used to reduce the set of metric data
     returned.:code:`<br>`Example::code:`<br>`Metric contains metadata A, B and C.:code:`<br>`-
     Return all time series of C where A = a1 and B = b1 or b2:code:`<br>`\ **$filter=A eq ‘a1’ and
     B eq ‘b1’ or B eq ‘b2’ and C eq ‘*’**\ :code:`<br>`- Invalid variant::code:`<br>`\ **$filter=A
     eq ‘a1’ and B eq ‘b1’ and C eq ‘*’ or B = ‘b2’**\ :code:`<br>`This is invalid because the
     logical or operator cannot separate two different metadata names.:code:`<br>`- Return all time
     series where A = a1, B = b1 and C = c1::code:`<br>`\ **$filter=A eq ‘a1’ and B eq ‘b1’ and C eq
     ‘c1’**\ :code:`<br>`- Return all time series where A = a1:code:`<br>`\ **$filter=A eq ‘a1’ and
     B eq ‘\ *’ and C eq ‘*\ ’**.
    :vartype filter: str
    :ivar top: The maximum number of records to retrieve.
     Valid only if $filter is specified.
     Defaults to 10.
    :vartype top: int
    :ivar order_by: The aggregation to use for sorting results and the direction of the sort.
     Only one order can be specified.
     Examples: sum asc.
    :vartype order_by: str
    :ivar roll_up_by: Dimension name(s) to rollup results by. For example if you only want to see
     metric values with a filter like 'City eq Seattle or City eq Tacoma' but don't want to see
     separate values for each city, you can specify 'RollUpBy=City' to see the results for Seattle
     and Tacoma rolled up into one timeseries.
    :vartype roll_up_by: str
    :ivar result_type: Reduces the set of data collected. The syntax allowed depends on the
     operation. See the operation's description for details. Known values are: "Data" and
     "Metadata".
    :vartype result_type: str or ~azure.mgmt.monitor.v2021_05_01.models.MetricResultType
    :ivar metric_namespace: Metric namespace where the metrics you want reside.
    :vartype metric_namespace: str
    :ivar auto_adjust_timegrain: When set to true, if the timespan passed in is not supported by
     this metric, the API will return the result using the closest supported timespan. When set to
     false, an error is returned for invalid timespan parameters. Defaults to false.
    :vartype auto_adjust_timegrain: bool
    :ivar validate_dimensions: When set to false, invalid filter parameter values will be ignored.
     When set to true, an error is returned for invalid filter parameters. Defaults to true.
    :vartype validate_dimensions: bool
    """

    _attribute_map = {
        "timespan": {"key": "timespan", "type": "time"},
        "interval": {"key": "interval", "type": "duration"},
        "metric_names": {"key": "metricNames", "type": "str"},
        "aggregation": {"key": "aggregation", "type": "str"},
        "filter": {"key": "filter", "type": "str"},
        "top": {"key": "top", "type": "int"},
        "order_by": {"key": "orderBy", "type": "str"},
        "roll_up_by": {"key": "rollUpBy", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "metric_namespace": {"key": "metricNamespace", "type": "str"},
        "auto_adjust_timegrain": {"key": "autoAdjustTimegrain", "type": "bool"},
        "validate_dimensions": {"key": "validateDimensions", "type": "bool"},
    }

    def __init__(
        self,
        *,
        timespan: Optional[datetime.time] = None,
        interval: Optional[datetime.timedelta] = None,
        metric_names: Optional[str] = None,
        aggregation: Optional[str] = None,
        filter: Optional[str] = None,  # pylint: disable=redefined-builtin
        top: Optional[int] = None,
        order_by: Optional[str] = None,
        roll_up_by: Optional[str] = None,
        result_type: Optional[Union[str, "_models.MetricResultType"]] = None,
        metric_namespace: Optional[str] = None,
        auto_adjust_timegrain: Optional[bool] = None,
        validate_dimensions: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword timespan: The timespan of the query. It is a string with the following format
         'startDateTime_ISO/endDateTime_ISO'.
        :paramtype timespan: ~datetime.time
        :keyword interval: The interval (i.e. timegrain) of the query.
        :paramtype interval: ~datetime.timedelta
        :keyword metric_names: The names of the metrics (comma separated) to retrieve.
        :paramtype metric_names: str
        :keyword aggregation: The list of aggregation types (comma separated) to retrieve.
        :paramtype aggregation: str
        :keyword filter: The **$filter** is used to reduce the set of metric data
         returned.:code:`<br>`Example::code:`<br>`Metric contains metadata A, B and C.:code:`<br>`-
         Return all time series of C where A = a1 and B = b1 or b2:code:`<br>`\ **$filter=A eq ‘a1’ and
         B eq ‘b1’ or B eq ‘b2’ and C eq ‘*’**\ :code:`<br>`- Invalid variant::code:`<br>`\ **$filter=A
         eq ‘a1’ and B eq ‘b1’ and C eq ‘*’ or B = ‘b2’**\ :code:`<br>`This is invalid because the
         logical or operator cannot separate two different metadata names.:code:`<br>`- Return all time
         series where A = a1, B = b1 and C = c1::code:`<br>`\ **$filter=A eq ‘a1’ and B eq ‘b1’ and C eq
         ‘c1’**\ :code:`<br>`- Return all time series where A = a1:code:`<br>`\ **$filter=A eq ‘a1’ and
         B eq ‘\ *’ and C eq ‘*\ ’**.
        :paramtype filter: str
        :keyword top: The maximum number of records to retrieve.
         Valid only if $filter is specified.
         Defaults to 10.
        :paramtype top: int
        :keyword order_by: The aggregation to use for sorting results and the direction of the sort.
         Only one order can be specified.
         Examples: sum asc.
        :paramtype order_by: str
        :keyword roll_up_by: Dimension name(s) to rollup results by. For example if you only want to
         see metric values with a filter like 'City eq Seattle or City eq Tacoma' but don't want to see
         separate values for each city, you can specify 'RollUpBy=City' to see the results for Seattle
         and Tacoma rolled up into one timeseries.
        :paramtype roll_up_by: str
        :keyword result_type: Reduces the set of data collected. The syntax allowed depends on the
         operation. See the operation's description for details. Known values are: "Data" and
         "Metadata".
        :paramtype result_type: str or ~azure.mgmt.monitor.v2021_05_01.models.MetricResultType
        :keyword metric_namespace: Metric namespace where the metrics you want reside.
        :paramtype metric_namespace: str
        :keyword auto_adjust_timegrain: When set to true, if the timespan passed in is not supported by
         this metric, the API will return the result using the closest supported timespan. When set to
         false, an error is returned for invalid timespan parameters. Defaults to false.
        :paramtype auto_adjust_timegrain: bool
        :keyword validate_dimensions: When set to false, invalid filter parameter values will be
         ignored. When set to true, an error is returned for invalid filter parameters. Defaults to
         true.
        :paramtype validate_dimensions: bool
        """
        super().__init__(**kwargs)
        self.timespan = timespan
        self.interval = interval
        self.metric_names = metric_names
        self.aggregation = aggregation
        self.filter = filter
        self.top = top
        self.order_by = order_by
        self.roll_up_by = roll_up_by
        self.result_type = result_type
        self.metric_namespace = metric_namespace
        self.auto_adjust_timegrain = auto_adjust_timegrain
        self.validate_dimensions = validate_dimensions


class TimeSeriesElement(_serialization.Model):
    """A time series result type. The discriminator value is always TimeSeries in this case.

    :ivar metadatavalues: the metadata values returned if $filter was specified in the call.
    :vartype metadatavalues: list[~azure.mgmt.monitor.v2021_05_01.models.MetadataValue]
    :ivar data: An array of data points representing the metric values.  This is only returned if a
     result type of data is specified.
    :vartype data: list[~azure.mgmt.monitor.v2021_05_01.models.MetricValue]
    """

    _attribute_map = {
        "metadatavalues": {"key": "metadatavalues", "type": "[MetadataValue]"},
        "data": {"key": "data", "type": "[MetricValue]"},
    }

    def __init__(
        self,
        *,
        metadatavalues: Optional[List["_models.MetadataValue"]] = None,
        data: Optional[List["_models.MetricValue"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword metadatavalues: the metadata values returned if $filter was specified in the call.
        :paramtype metadatavalues: list[~azure.mgmt.monitor.v2021_05_01.models.MetadataValue]
        :keyword data: An array of data points representing the metric values.  This is only returned
         if a result type of data is specified.
        :paramtype data: list[~azure.mgmt.monitor.v2021_05_01.models.MetricValue]
        """
        super().__init__(**kwargs)
        self.metadatavalues = metadatavalues
        self.data = data
