# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._search_client_enums import *


class Address(msrest.serialization.Model):
    """The address of the result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar building_number: The building number on the street. DEPRECATED, use streetNumber instead.
    :vartype building_number: str
    :ivar street: The street name. DEPRECATED, use streetName instead.
    :vartype street: str
    :ivar cross_street: The name of the street being crossed.
    :vartype cross_street: str
    :ivar street_number: The building number on the street.
    :vartype street_number: str
    :ivar route_numbers: The codes used to unambiguously identify the street.
    :vartype route_numbers: list[int]
    :ivar street_name: The street name.
    :vartype street_name: str
    :ivar street_name_and_number: The street name and number.
    :vartype street_name_and_number: str
    :ivar municipality: City / Town.
    :vartype municipality: str
    :ivar municipality_subdivision: Sub / Super City.
    :vartype municipality_subdivision: str
    :ivar country_tertiary_subdivision: Named Area.
    :vartype country_tertiary_subdivision: str
    :ivar country_secondary_subdivision: County.
    :vartype country_secondary_subdivision: str
    :ivar country_subdivision: State or Province.
    :vartype country_subdivision: str
    :ivar postal_code: Postal Code / Zip Code.
    :vartype postal_code: str
    :ivar extended_postal_code: Extended postal code (availability is dependent on the region).
    :vartype extended_postal_code: str
    :ivar country_code: Country (Note: This is a two-letter code, not a country name.).
    :vartype country_code: str
    :ivar country: Country name.
    :vartype country: str
    :ivar country_code_iso3: ISO alpha-3 country code.
    :vartype country_code_iso3: str
    :ivar freeform_address: An address line formatted according to the formatting rules of a
     Result's country of origin, or in the case of a country, its full country name.
    :vartype freeform_address: str
    :ivar country_subdivision_name: The full name of a first level of country administrative
     hierarchy. This field appears only in case countrySubdivision is presented in an abbreviated
     form. Only supported for USA, Canada, and Great Britain.
    :vartype country_subdivision_name: str
    :ivar local_name: An address component which represents the name of a geographic area or
     locality that groups a number of addressable objects for addressing purposes, without being an
     administrative unit. This field is used to build the ``freeformAddress`` property.
    :vartype local_name: str
    :ivar bounding_box: Bounding box coordinates.
    :vartype bounding_box: object
    """

    _validation = {
        'building_number': {'readonly': True},
        'street': {'readonly': True},
        'cross_street': {'readonly': True},
        'street_number': {'readonly': True},
        'route_numbers': {'readonly': True},
        'street_name': {'readonly': True},
        'street_name_and_number': {'readonly': True},
        'municipality': {'readonly': True},
        'municipality_subdivision': {'readonly': True},
        'country_tertiary_subdivision': {'readonly': True},
        'country_secondary_subdivision': {'readonly': True},
        'country_subdivision': {'readonly': True},
        'postal_code': {'readonly': True},
        'extended_postal_code': {'readonly': True},
        'country_code': {'readonly': True},
        'country': {'readonly': True},
        'country_code_iso3': {'readonly': True},
        'freeform_address': {'readonly': True},
        'country_subdivision_name': {'readonly': True},
        'local_name': {'readonly': True},
        'bounding_box': {'readonly': True},
    }

    _attribute_map = {
        'building_number': {'key': 'buildingNumber', 'type': 'str'},
        'street': {'key': 'street', 'type': 'str'},
        'cross_street': {'key': 'crossStreet', 'type': 'str'},
        'street_number': {'key': 'streetNumber', 'type': 'str'},
        'route_numbers': {'key': 'routeNumbers', 'type': '[str]'},
        'street_name': {'key': 'streetName', 'type': 'str'},
        'street_name_and_number': {'key': 'streetNameAndNumber', 'type': 'str'},
        'municipality': {'key': 'municipality', 'type': 'str'},
        'municipality_subdivision': {'key': 'municipalitySubdivision', 'type': 'str'},
        'country_tertiary_subdivision': {'key': 'countryTertiarySubdivision', 'type': 'str'},
        'country_secondary_subdivision': {'key': 'countrySecondarySubdivision', 'type': 'str'},
        'country_subdivision': {'key': 'countrySubdivision', 'type': 'str'},
        'postal_code': {'key': 'postalCode', 'type': 'str'},
        'extended_postal_code': {'key': 'extendedPostalCode', 'type': 'str'},
        'country_code': {'key': 'countryCode', 'type': 'str'},
        'country': {'key': 'country', 'type': 'str'},
        'country_code_iso3': {'key': 'countryCodeISO3', 'type': 'str'},
        'freeform_address': {'key': 'freeformAddress', 'type': 'str'},
        'country_subdivision_name': {'key': 'countrySubdivisionName', 'type': 'str'},
        'local_name': {'key': 'localName', 'type': 'str'},
        'bounding_box': {'key': 'boundingBox', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Address, self).__init__(**kwargs)
        self.building_number = None
        self.street = None
        self.cross_street = None
        self.street_number = None
        self.route_numbers = None
        self.street_name = None
        self.street_name_and_number = None
        self.municipality = None
        self.municipality_subdivision = None
        self.country_tertiary_subdivision = None
        self.country_secondary_subdivision = None
        self.country_subdivision = None
        self.postal_code = None
        self.extended_postal_code = None
        self.country_code = None
        self.country = None
        self.country_code_iso3 = None
        self.freeform_address = None
        self.country_subdivision_name = None
        self.local_name = None
        self.bounding_box = None


class AddressRanges(msrest.serialization.Model):
    """Describes the address range on both sides of the street for a search result. Coordinates for the start and end locations of the address range are included.

    :param range_left: Address range on the left side of the street.
    :type range_left: str
    :param range_right: Address range on the right side of the street.
    :type range_right: str
    :param from_property: A location represented as a latitude and longitude using short names
     'lat' & 'lon'.
    :type from_property: ~azure.maps.search.models.LatLongPairAbbreviated
    :param to: A location represented as a latitude and longitude using short names 'lat' & 'lon'.
    :type to: ~azure.maps.search.models.LatLongPairAbbreviated
    """

    _attribute_map = {
        'range_left': {'key': 'rangeLeft', 'type': 'str'},
        'range_right': {'key': 'rangeRight', 'type': 'str'},
        'from_property': {'key': 'from', 'type': 'LatLongPairAbbreviated'},
        'to': {'key': 'to', 'type': 'LatLongPairAbbreviated'},
    }

    def __init__(
        self,
        *,
        range_left: Optional[str] = None,
        range_right: Optional[str] = None,
        from_property: Optional["LatLongPairAbbreviated"] = None,
        to: Optional["LatLongPairAbbreviated"] = None,
        **kwargs
    ):
        super(AddressRanges, self).__init__(**kwargs)
        self.range_left = range_left
        self.range_right = range_right
        self.from_property = from_property
        self.to = to


class BatchRequest(msrest.serialization.Model):
    """This type represents the request body for the Batch service.

    :param batch_items: The list of queries to process.
    :type batch_items: list[~azure.maps.search.models.BatchRequestItem]
    """

    _attribute_map = {
        'batch_items': {'key': 'batchItems', 'type': '[BatchRequestItem]'},
    }

    def __init__(
        self,
        *,
        batch_items: Optional[List["BatchRequestItem"]] = None,
        **kwargs
    ):
        super(BatchRequest, self).__init__(**kwargs)
        self.batch_items = batch_items


class BatchRequestItem(msrest.serialization.Model):
    """Batch request object.

    :param query: This parameter contains a query string used to perform an unstructured geocoding
     operation. The query string will be passed verbatim to the search API for processing.
    :type query: str
    """

    _attribute_map = {
        'query': {'key': 'query', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        query: Optional[str] = None,
        **kwargs
    ):
        super(BatchRequestItem, self).__init__(**kwargs)
        self.query = query


class BatchResult(msrest.serialization.Model):
    """This object is returned from a successful Batch service call. Extend with 'batchItems' property.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar batch_summary: Summary of the results for the batch request.
    :vartype batch_summary: ~azure.maps.search.models.BatchResultSummary
    """

    _validation = {
        'batch_summary': {'readonly': True},
    }

    _attribute_map = {
        'batch_summary': {'key': 'summary', 'type': 'BatchResultSummary'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BatchResult, self).__init__(**kwargs)
        self.batch_summary = None


class BatchResultItem(msrest.serialization.Model):
    """An item returned from Batch API. Extend with 'response' property.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status_code: HTTP request status code.
    :vartype status_code: int
    """

    _validation = {
        'status_code': {'readonly': True},
    }

    _attribute_map = {
        'status_code': {'key': 'statusCode', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BatchResultItem, self).__init__(**kwargs)
        self.status_code = None


class BatchResultSummary(msrest.serialization.Model):
    """Summary of the results for the batch request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar successful_requests: Number of successful requests in the batch.
    :vartype successful_requests: int
    :ivar total_requests: Total number of requests in the batch.
    :vartype total_requests: int
    """

    _validation = {
        'successful_requests': {'readonly': True},
        'total_requests': {'readonly': True},
    }

    _attribute_map = {
        'successful_requests': {'key': 'successfulRequests', 'type': 'int'},
        'total_requests': {'key': 'totalRequests', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BatchResultSummary, self).__init__(**kwargs)
        self.successful_requests = None
        self.total_requests = None


class BoundingBox(msrest.serialization.Model):
    """The viewport that covers the result represented by the top-left and bottom-right coordinates of the viewport.

    :param top_left: A location represented as a latitude and longitude using short names 'lat' &
     'lon'.
    :type top_left: ~azure.maps.search.models.LatLongPairAbbreviated
    :param bottom_right: A location represented as a latitude and longitude using short names 'lat'
     & 'lon'.
    :type bottom_right: ~azure.maps.search.models.LatLongPairAbbreviated
    """

    _attribute_map = {
        'top_left': {'key': 'topLeftPoint', 'type': 'LatLongPairAbbreviated'},
        'bottom_right': {'key': 'btmRightPoint', 'type': 'LatLongPairAbbreviated'},
    }

    def __init__(
        self,
        *,
        top_left: Optional["LatLongPairAbbreviated"] = None,
        bottom_right: Optional["LatLongPairAbbreviated"] = None,
        **kwargs
    ):
        super(BoundingBox, self).__init__(**kwargs)
        self.top_left = top_left
        self.bottom_right = bottom_right


class BrandName(msrest.serialization.Model):
    """The name of the brand for the POI being returned.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the brand.
    :vartype name: str
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BrandName, self).__init__(**kwargs)
        self.name = None


class Classification(msrest.serialization.Model):
    """The classification for the POI being returned.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Code property.
    :vartype code: str
    :ivar names: Names array.
    :vartype names: list[~azure.maps.search.models.ClassificationName]
    """

    _validation = {
        'code': {'readonly': True},
        'names': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'names': {'key': 'names', 'type': '[ClassificationName]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Classification, self).__init__(**kwargs)
        self.code = None
        self.names = None


class ClassificationName(msrest.serialization.Model):
    """Name for the classification.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_locale: Name Locale property.
    :vartype name_locale: str
    :ivar name: Name property.
    :vartype name: str
    """

    _validation = {
        'name_locale': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'name_locale': {'key': 'nameLocale', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClassificationName, self).__init__(**kwargs)
        self.name_locale = None
        self.name = None


class DataSource(msrest.serialization.Model):
    """Optional section. Reference ids for use with the `Get Search Polygon <https://docs.microsoft.com/rest/api/maps/search/getsearchpolygon>`_ API.

    :param geometry: Information about the geometric shape of the result. Only present if type ==
     Geography.
    :type geometry: ~azure.maps.search.models.GeometryIdentifier
    """

    _attribute_map = {
        'geometry': {'key': 'geometry', 'type': 'GeometryIdentifier'},
    }

    def __init__(
        self,
        *,
        geometry: Optional["GeometryIdentifier"] = None,
        **kwargs
    ):
        super(DataSource, self).__init__(**kwargs)
        self.geometry = geometry


class EntryPoint(msrest.serialization.Model):
    """The entry point for the POI being returned.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of entry point. Value can be either *main* or *minor*. Possible values
     include: "main", "minor".
    :vartype type: str or ~azure.maps.search.models.EntryPointType
    :param position: A location represented as a latitude and longitude using short names 'lat' &
     'lon'.
    :type position: ~azure.maps.search.models.LatLongPairAbbreviated
    """

    _validation = {
        'type': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'position': {'key': 'position', 'type': 'LatLongPairAbbreviated'},
    }

    def __init__(
        self,
        *,
        position: Optional["LatLongPairAbbreviated"] = None,
        **kwargs
    ):
        super(EntryPoint, self).__init__(**kwargs)
        self.type = None
        self.position = position


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: object
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(msrest.serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.maps.search.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.maps.search.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :param error: The error object.
    :type error: ~azure.maps.search.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorDetail"] = None,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class GeoJsonFeatureData(msrest.serialization.Model):
    """GeoJsonFeatureData.

    All required parameters must be populated in order to send to Azure.

    :param geometry: Required. A valid ``GeoJSON`` object. Please refer to `RFC 7946
     <https://tools.ietf.org/html/rfc7946#section-3>`__ for details.
    :type geometry: ~azure.maps.search.models.GeoJsonObject
    :param properties: Properties can contain any additional metadata about the ``Feature``. Value
     can be any JSON object or a JSON null value.
    :type properties: object
    :param id: Identifier for the feature.
    :type id: str
    :param feature_type: The type of the feature. The value depends on the data model the current
     feature is part of. Some data models may have an empty value.
    :type feature_type: str
    """

    _validation = {
        'geometry': {'required': True},
    }

    _attribute_map = {
        'geometry': {'key': 'geometry', 'type': 'GeoJsonObject'},
        'properties': {'key': 'properties', 'type': 'object'},
        'id': {'key': 'id', 'type': 'str'},
        'feature_type': {'key': 'featureType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        geometry: "GeoJsonObject",
        properties: Optional[object] = None,
        id: Optional[str] = None,
        feature_type: Optional[str] = None,
        **kwargs
    ):
        super(GeoJsonFeatureData, self).__init__(**kwargs)
        self.geometry = geometry
        self.properties = properties
        self.id = id
        self.feature_type = feature_type


class GeoJsonObject(msrest.serialization.Model):
    """A valid ``GeoJSON`` object. Please refer to `RFC 7946 <https://tools.ietf.org/html/rfc7946#section-3>`__ for details.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: GeoJsonFeature, GeoJsonFeatureCollection, GeoJsonGeometry, GeoJsonGeometryCollection, GeoJsonLineString, GeoJsonMultiLineString, GeoJsonMultiPoint, GeoJsonMultiPolygon, GeoJsonPoint, GeoJsonPolygon.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Specifies the ``GeoJSON`` type. Must be one of the nine valid GeoJSON
     object types - Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon,
     GeometryCollection, Feature and FeatureCollection.Constant filled by server.  Possible values
     include: "Point", "MultiPoint", "LineString", "MultiLineString", "Polygon", "MultiPolygon",
     "GeometryCollection", "Feature", "FeatureCollection".
    :type type: str or ~azure.maps.search.models.GeoJsonObjectType
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'Feature': 'GeoJsonFeature', 'FeatureCollection': 'GeoJsonFeatureCollection', 'GeoJsonGeometry': 'GeoJsonGeometry', 'GeometryCollection': 'GeoJsonGeometryCollection', 'LineString': 'GeoJsonLineString', 'MultiLineString': 'GeoJsonMultiLineString', 'MultiPoint': 'GeoJsonMultiPoint', 'MultiPolygon': 'GeoJsonMultiPolygon', 'Point': 'GeoJsonPoint', 'Polygon': 'GeoJsonPolygon'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GeoJsonObject, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class GeoJsonFeature(GeoJsonObject, GeoJsonFeatureData):
    """A valid ``GeoJSON Feature`` object type. Please refer to `RFC 7946 <https://tools.ietf.org/html/rfc7946#section-3.2>`__ for details.

    All required parameters must be populated in order to send to Azure.

    :param geometry: Required. A valid ``GeoJSON`` object. Please refer to `RFC 7946
     <https://tools.ietf.org/html/rfc7946#section-3>`__ for details.
    :type geometry: ~azure.maps.search.models.GeoJsonObject
    :param properties: Properties can contain any additional metadata about the ``Feature``. Value
     can be any JSON object or a JSON null value.
    :type properties: object
    :param id: Identifier for the feature.
    :type id: str
    :param feature_type: The type of the feature. The value depends on the data model the current
     feature is part of. Some data models may have an empty value.
    :type feature_type: str
    :param type: Required. Specifies the ``GeoJSON`` type. Must be one of the nine valid GeoJSON
     object types - Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon,
     GeometryCollection, Feature and FeatureCollection.Constant filled by server.  Possible values
     include: "Point", "MultiPoint", "LineString", "MultiLineString", "Polygon", "MultiPolygon",
     "GeometryCollection", "Feature", "FeatureCollection".
    :type type: str or ~azure.maps.search.models.GeoJsonObjectType
    """

    _validation = {
        'geometry': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'geometry': {'key': 'geometry', 'type': 'GeoJsonObject'},
        'properties': {'key': 'properties', 'type': 'object'},
        'id': {'key': 'id', 'type': 'str'},
        'feature_type': {'key': 'featureType', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        geometry: "GeoJsonObject",
        properties: Optional[object] = None,
        id: Optional[str] = None,
        feature_type: Optional[str] = None,
        **kwargs
    ):
        super(GeoJsonFeature, self).__init__(geometry=geometry, properties=properties, id=id, feature_type=feature_type, **kwargs)
        self.geometry = geometry
        self.properties = properties
        self.id = id
        self.feature_type = feature_type
        self.type = 'Feature'  # type: str
        self.type = 'Feature'  # type: str


class GeoJsonFeatureCollectionData(msrest.serialization.Model):
    """GeoJsonFeatureCollectionData.

    All required parameters must be populated in order to send to Azure.

    :param features: Required. Contains a list of valid ``GeoJSON Feature`` objects.
    :type features: list[~azure.maps.search.models.GeoJsonFeature]
    """

    _validation = {
        'features': {'required': True},
    }

    _attribute_map = {
        'features': {'key': 'features', 'type': '[GeoJsonFeature]'},
    }

    def __init__(
        self,
        *,
        features: List["GeoJsonFeature"],
        **kwargs
    ):
        super(GeoJsonFeatureCollectionData, self).__init__(**kwargs)
        self.features = features


class GeoJsonFeatureCollection(GeoJsonObject, GeoJsonFeatureCollectionData):
    """A valid ``GeoJSON FeatureCollection`` object type. Please refer to `RFC 7946 <https://tools.ietf.org/html/rfc7946#section-3.3>`__ for details.

    All required parameters must be populated in order to send to Azure.

    :param features: Required. Contains a list of valid ``GeoJSON Feature`` objects.
    :type features: list[~azure.maps.search.models.GeoJsonFeature]
    :param type: Required. Specifies the ``GeoJSON`` type. Must be one of the nine valid GeoJSON
     object types - Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon,
     GeometryCollection, Feature and FeatureCollection.Constant filled by server.  Possible values
     include: "Point", "MultiPoint", "LineString", "MultiLineString", "Polygon", "MultiPolygon",
     "GeometryCollection", "Feature", "FeatureCollection".
    :type type: str or ~azure.maps.search.models.GeoJsonObjectType
    """

    _validation = {
        'features': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'features': {'key': 'features', 'type': '[GeoJsonFeature]'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        features: List["GeoJsonFeature"],
        **kwargs
    ):
        super(GeoJsonFeatureCollection, self).__init__(features=features, **kwargs)
        self.features = features
        self.type = 'FeatureCollection'  # type: str
        self.type = 'FeatureCollection'  # type: str


class GeoJsonGeometry(GeoJsonObject):
    """A valid ``GeoJSON`` geometry object. The type must be one of the seven valid GeoJSON geometry types - Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon and GeometryCollection. Please refer to `RFC 7946 <https://tools.ietf.org/html/rfc7946#section-3.1>`__ for details.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Specifies the ``GeoJSON`` type. Must be one of the nine valid GeoJSON
     object types - Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon,
     GeometryCollection, Feature and FeatureCollection.Constant filled by server.  Possible values
     include: "Point", "MultiPoint", "LineString", "MultiLineString", "Polygon", "MultiPolygon",
     "GeometryCollection", "Feature", "FeatureCollection".
    :type type: str or ~azure.maps.search.models.GeoJsonObjectType
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GeoJsonGeometry, self).__init__(**kwargs)
        self.type = 'GeoJsonGeometry'  # type: str


class GeoJsonGeometryCollectionData(msrest.serialization.Model):
    """GeoJsonGeometryCollectionData.

    All required parameters must be populated in order to send to Azure.

    :param geometries: Required. Contains a list of valid ``GeoJSON`` geometry objects. **Note**
     that coordinates in GeoJSON are in x, y order (longitude, latitude).
    :type geometries: list[~azure.maps.search.models.GeoJsonObject]
    """

    _validation = {
        'geometries': {'required': True},
    }

    _attribute_map = {
        'geometries': {'key': 'geometries', 'type': '[GeoJsonObject]'},
    }

    def __init__(
        self,
        *,
        geometries: List["GeoJsonObject"],
        **kwargs
    ):
        super(GeoJsonGeometryCollectionData, self).__init__(**kwargs)
        self.geometries = geometries


class GeoJsonGeometryCollection(GeoJsonObject, GeoJsonGeometryCollectionData):
    """A valid ``GeoJSON GeometryCollection`` object type. Please refer to `RFC 7946 <https://tools.ietf.org/html/rfc7946#section-3.1.8>`__ for details.

    All required parameters must be populated in order to send to Azure.

    :param geometries: Required. Contains a list of valid ``GeoJSON`` geometry objects. **Note**
     that coordinates in GeoJSON are in x, y order (longitude, latitude).
    :type geometries: list[~azure.maps.search.models.GeoJsonObject]
    :param type: Required. Specifies the ``GeoJSON`` type. Must be one of the nine valid GeoJSON
     object types - Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon,
     GeometryCollection, Feature and FeatureCollection.Constant filled by server.  Possible values
     include: "Point", "MultiPoint", "LineString", "MultiLineString", "Polygon", "MultiPolygon",
     "GeometryCollection", "Feature", "FeatureCollection".
    :type type: str or ~azure.maps.search.models.GeoJsonObjectType
    """

    _validation = {
        'geometries': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'geometries': {'key': 'geometries', 'type': '[GeoJsonObject]'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        geometries: List["GeoJsonObject"],
        **kwargs
    ):
        super(GeoJsonGeometryCollection, self).__init__(geometries=geometries, **kwargs)
        self.geometries = geometries
        self.type = 'GeometryCollection'  # type: str
        self.type = 'GeometryCollection'  # type: str


class GeoJsonLineStringData(msrest.serialization.Model):
    """GeoJsonLineStringData.

    All required parameters must be populated in order to send to Azure.

    :param coordinates: Required. Coordinates for the ``GeoJson LineString`` geometry.
    :type coordinates: list[list[float]]
    """

    _validation = {
        'coordinates': {'required': True},
    }

    _attribute_map = {
        'coordinates': {'key': 'coordinates', 'type': '[[float]]'},
    }

    def __init__(
        self,
        *,
        coordinates: List[List[float]],
        **kwargs
    ):
        super(GeoJsonLineStringData, self).__init__(**kwargs)
        self.coordinates = coordinates


class GeoJsonLineString(GeoJsonObject, GeoJsonLineStringData):
    """A valid ``GeoJSON LineString`` geometry type. Please refer to `RFC 7946 <https://tools.ietf.org/html/rfc7946#section-3.1.4>`__ for details.

    All required parameters must be populated in order to send to Azure.

    :param coordinates: Required. Coordinates for the ``GeoJson LineString`` geometry.
    :type coordinates: list[list[float]]
    :param type: Required. Specifies the ``GeoJSON`` type. Must be one of the nine valid GeoJSON
     object types - Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon,
     GeometryCollection, Feature and FeatureCollection.Constant filled by server.  Possible values
     include: "Point", "MultiPoint", "LineString", "MultiLineString", "Polygon", "MultiPolygon",
     "GeometryCollection", "Feature", "FeatureCollection".
    :type type: str or ~azure.maps.search.models.GeoJsonObjectType
    """

    _validation = {
        'coordinates': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'coordinates': {'key': 'coordinates', 'type': '[[float]]'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        coordinates: List[List[float]],
        **kwargs
    ):
        super(GeoJsonLineString, self).__init__(coordinates=coordinates, **kwargs)
        self.coordinates = coordinates
        self.type = 'LineString'  # type: str
        self.type = 'LineString'  # type: str


class GeoJsonMultiLineStringData(msrest.serialization.Model):
    """GeoJsonMultiLineStringData.

    All required parameters must be populated in order to send to Azure.

    :param coordinates: Required. Coordinates for the ``GeoJson MultiLineString`` geometry.
    :type coordinates: list[list[list[float]]]
    """

    _validation = {
        'coordinates': {'required': True},
    }

    _attribute_map = {
        'coordinates': {'key': 'coordinates', 'type': '[[[float]]]'},
    }

    def __init__(
        self,
        *,
        coordinates: List[List[List[float]]],
        **kwargs
    ):
        super(GeoJsonMultiLineStringData, self).__init__(**kwargs)
        self.coordinates = coordinates


class GeoJsonMultiLineString(GeoJsonObject, GeoJsonMultiLineStringData):
    """A valid ``GeoJSON MultiLineString`` geometry type. Please refer to `RFC 7946 <https://tools.ietf.org/html/rfc7946#section-3.1.5>`__ for details.

    All required parameters must be populated in order to send to Azure.

    :param coordinates: Required. Coordinates for the ``GeoJson MultiLineString`` geometry.
    :type coordinates: list[list[list[float]]]
    :param type: Required. Specifies the ``GeoJSON`` type. Must be one of the nine valid GeoJSON
     object types - Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon,
     GeometryCollection, Feature and FeatureCollection.Constant filled by server.  Possible values
     include: "Point", "MultiPoint", "LineString", "MultiLineString", "Polygon", "MultiPolygon",
     "GeometryCollection", "Feature", "FeatureCollection".
    :type type: str or ~azure.maps.search.models.GeoJsonObjectType
    """

    _validation = {
        'coordinates': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'coordinates': {'key': 'coordinates', 'type': '[[[float]]]'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        coordinates: List[List[List[float]]],
        **kwargs
    ):
        super(GeoJsonMultiLineString, self).__init__(coordinates=coordinates, **kwargs)
        self.coordinates = coordinates
        self.type = 'MultiLineString'  # type: str
        self.type = 'MultiLineString'  # type: str


class GeoJsonMultiPointData(msrest.serialization.Model):
    """Data contained by a ``GeoJson MultiPoint``.

    All required parameters must be populated in order to send to Azure.

    :param coordinates: Required. Coordinates for the ``GeoJson MultiPoint`` geometry.
    :type coordinates: list[list[float]]
    """

    _validation = {
        'coordinates': {'required': True},
    }

    _attribute_map = {
        'coordinates': {'key': 'coordinates', 'type': '[[float]]'},
    }

    def __init__(
        self,
        *,
        coordinates: List[List[float]],
        **kwargs
    ):
        super(GeoJsonMultiPointData, self).__init__(**kwargs)
        self.coordinates = coordinates


class GeoJsonMultiPoint(GeoJsonObject, GeoJsonMultiPointData):
    """A valid ``GeoJSON MultiPoint`` geometry type. Please refer to `RFC 7946 <https://tools.ietf.org/html/rfc7946#section-3.1.3>`__ for details.

    All required parameters must be populated in order to send to Azure.

    :param coordinates: Required. Coordinates for the ``GeoJson MultiPoint`` geometry.
    :type coordinates: list[list[float]]
    :param type: Required. Specifies the ``GeoJSON`` type. Must be one of the nine valid GeoJSON
     object types - Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon,
     GeometryCollection, Feature and FeatureCollection.Constant filled by server.  Possible values
     include: "Point", "MultiPoint", "LineString", "MultiLineString", "Polygon", "MultiPolygon",
     "GeometryCollection", "Feature", "FeatureCollection".
    :type type: str or ~azure.maps.search.models.GeoJsonObjectType
    """

    _validation = {
        'coordinates': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'coordinates': {'key': 'coordinates', 'type': '[[float]]'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        coordinates: List[List[float]],
        **kwargs
    ):
        super(GeoJsonMultiPoint, self).__init__(coordinates=coordinates, **kwargs)
        self.coordinates = coordinates
        self.type = 'MultiPoint'  # type: str
        self.type = 'MultiPoint'  # type: str


class GeoJsonMultiPolygonData(msrest.serialization.Model):
    """GeoJsonMultiPolygonData.

    All required parameters must be populated in order to send to Azure.

    :param coordinates: Required. Contains a list of valid ``GeoJSON Polygon`` objects. **Note**
     that coordinates in GeoJSON are in x, y order (longitude, latitude).
    :type coordinates: list[list[list[list[float]]]]
    """

    _validation = {
        'coordinates': {'required': True},
    }

    _attribute_map = {
        'coordinates': {'key': 'coordinates', 'type': '[[[[float]]]]'},
    }

    def __init__(
        self,
        *,
        coordinates: List[List[List[List[float]]]],
        **kwargs
    ):
        super(GeoJsonMultiPolygonData, self).__init__(**kwargs)
        self.coordinates = coordinates


class GeoJsonMultiPolygon(GeoJsonObject, GeoJsonMultiPolygonData):
    """A valid ``GeoJSON MultiPolygon`` object type. Please refer to `RFC 7946 <https://tools.ietf.org/html/rfc7946#section-3.1.7>`__ for details.

    All required parameters must be populated in order to send to Azure.

    :param coordinates: Required. Contains a list of valid ``GeoJSON Polygon`` objects. **Note**
     that coordinates in GeoJSON are in x, y order (longitude, latitude).
    :type coordinates: list[list[list[list[float]]]]
    :param type: Required. Specifies the ``GeoJSON`` type. Must be one of the nine valid GeoJSON
     object types - Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon,
     GeometryCollection, Feature and FeatureCollection.Constant filled by server.  Possible values
     include: "Point", "MultiPoint", "LineString", "MultiLineString", "Polygon", "MultiPolygon",
     "GeometryCollection", "Feature", "FeatureCollection".
    :type type: str or ~azure.maps.search.models.GeoJsonObjectType
    """

    _validation = {
        'coordinates': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'coordinates': {'key': 'coordinates', 'type': '[[[[float]]]]'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        coordinates: List[List[List[List[float]]]],
        **kwargs
    ):
        super(GeoJsonMultiPolygon, self).__init__(coordinates=coordinates, **kwargs)
        self.coordinates = coordinates
        self.type = 'MultiPolygon'  # type: str
        self.type = 'MultiPolygon'  # type: str


class GeoJsonPointData(msrest.serialization.Model):
    """Data contained by a ``GeoJson Point``.

    All required parameters must be populated in order to send to Azure.

    :param coordinates: Required. A ``Position`` is an array of numbers with two or more elements.
     The first two elements are *longitude* and *latitude*\ , precisely in that order.
     *Altitude/Elevation* is an optional third element. Please refer to `RFC 7946
     <https://tools.ietf.org/html/rfc7946#section-3.1.1>`__ for details.
    :type coordinates: list[float]
    """

    _validation = {
        'coordinates': {'required': True},
    }

    _attribute_map = {
        'coordinates': {'key': 'coordinates', 'type': '[float]'},
    }

    def __init__(
        self,
        *,
        coordinates: List[float],
        **kwargs
    ):
        super(GeoJsonPointData, self).__init__(**kwargs)
        self.coordinates = coordinates


class GeoJsonPoint(GeoJsonObject, GeoJsonPointData):
    """A valid ``GeoJSON Point`` geometry type. Please refer to `RFC 7946 <https://tools.ietf.org/html/rfc7946#section-3.1.2>`__ for details.

    All required parameters must be populated in order to send to Azure.

    :param coordinates: Required. A ``Position`` is an array of numbers with two or more elements.
     The first two elements are *longitude* and *latitude*\ , precisely in that order.
     *Altitude/Elevation* is an optional third element. Please refer to `RFC 7946
     <https://tools.ietf.org/html/rfc7946#section-3.1.1>`__ for details.
    :type coordinates: list[float]
    :param type: Required. Specifies the ``GeoJSON`` type. Must be one of the nine valid GeoJSON
     object types - Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon,
     GeometryCollection, Feature and FeatureCollection.Constant filled by server.  Possible values
     include: "Point", "MultiPoint", "LineString", "MultiLineString", "Polygon", "MultiPolygon",
     "GeometryCollection", "Feature", "FeatureCollection".
    :type type: str or ~azure.maps.search.models.GeoJsonObjectType
    """

    _validation = {
        'coordinates': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'coordinates': {'key': 'coordinates', 'type': '[float]'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        coordinates: List[float],
        **kwargs
    ):
        super(GeoJsonPoint, self).__init__(coordinates=coordinates, **kwargs)
        self.coordinates = coordinates
        self.type = 'Point'  # type: str
        self.type = 'Point'  # type: str


class GeoJsonPolygonData(msrest.serialization.Model):
    """GeoJsonPolygonData.

    All required parameters must be populated in order to send to Azure.

    :param coordinates: Required. Coordinates for the ``GeoJson Polygon`` geometry type.
    :type coordinates: list[list[list[float]]]
    """

    _validation = {
        'coordinates': {'required': True},
    }

    _attribute_map = {
        'coordinates': {'key': 'coordinates', 'type': '[[[float]]]'},
    }

    def __init__(
        self,
        *,
        coordinates: List[List[List[float]]],
        **kwargs
    ):
        super(GeoJsonPolygonData, self).__init__(**kwargs)
        self.coordinates = coordinates


class GeoJsonPolygon(GeoJsonObject, GeoJsonPolygonData):
    """A valid ``GeoJSON Polygon`` geometry type. Please refer to `RFC 7946 <https://tools.ietf.org/html/rfc7946#section-3.1.6>`__ for details.

    All required parameters must be populated in order to send to Azure.

    :param coordinates: Required. Coordinates for the ``GeoJson Polygon`` geometry type.
    :type coordinates: list[list[list[float]]]
    :param type: Required. Specifies the ``GeoJSON`` type. Must be one of the nine valid GeoJSON
     object types - Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon,
     GeometryCollection, Feature and FeatureCollection.Constant filled by server.  Possible values
     include: "Point", "MultiPoint", "LineString", "MultiLineString", "Polygon", "MultiPolygon",
     "GeometryCollection", "Feature", "FeatureCollection".
    :type type: str or ~azure.maps.search.models.GeoJsonObjectType
    """

    _validation = {
        'coordinates': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'coordinates': {'key': 'coordinates', 'type': '[[[float]]]'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        coordinates: List[List[List[float]]],
        **kwargs
    ):
        super(GeoJsonPolygon, self).__init__(coordinates=coordinates, **kwargs)
        self.coordinates = coordinates
        self.type = 'Polygon'  # type: str
        self.type = 'Polygon'  # type: str


class GeometryIdentifier(msrest.serialization.Model):
    """Information about the geometric shape of the result. Only present if type == Geography.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Pass this as geometryId to the `Get Search Polygon
     <https://docs.microsoft.com/rest/api/maps/search/getsearchpolygon>`_ API to fetch geometry
     information for this result.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GeometryIdentifier, self).__init__(**kwargs)
        self.id = None


class LatLongPairAbbreviated(msrest.serialization.Model):
    """A location represented as a latitude and longitude using short names 'lat' & 'lon'.

    :param lat: Latitude property.
    :type lat: float
    :param lon: Longitude property.
    :type lon: float
    """

    _attribute_map = {
        'lat': {'key': 'lat', 'type': 'float'},
        'lon': {'key': 'lon', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        lat: Optional[float] = None,
        lon: Optional[float] = None,
        **kwargs
    ):
        super(LatLongPairAbbreviated, self).__init__(**kwargs)
        self.lat = lat
        self.lon = lon


class OperatingHours(msrest.serialization.Model):
    """Opening hours for a POI (Points of Interest).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar mode: Value used in the request: none or "nextSevenDays".
    :vartype mode: str
    :ivar time_ranges: List of time ranges for the next 7 days.
    :vartype time_ranges: list[~azure.maps.search.models.OperatingHoursTimeRange]
    """

    _validation = {
        'mode': {'readonly': True},
        'time_ranges': {'readonly': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'time_ranges': {'key': 'timeRanges', 'type': '[OperatingHoursTimeRange]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperatingHours, self).__init__(**kwargs)
        self.mode = None
        self.time_ranges = None


class OperatingHoursTime(msrest.serialization.Model):
    """Represents a date and time.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar date: Represents current calendar date in POI time zone, e.g. "2019-02-07".
    :vartype date: str
    :ivar hour: Hours are in the 24 hour format in the local time of a POI; possible values are 0 -
     23.
    :vartype hour: int
    :ivar minute: Minutes are in the local time of a POI; possible values are 0 - 59.
    :vartype minute: int
    """

    _validation = {
        'date': {'readonly': True},
        'hour': {'readonly': True},
        'minute': {'readonly': True},
    }

    _attribute_map = {
        'date': {'key': 'date', 'type': 'str'},
        'hour': {'key': 'hour', 'type': 'int'},
        'minute': {'key': 'minute', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperatingHoursTime, self).__init__(**kwargs)
        self.date = None
        self.hour = None
        self.minute = None


class OperatingHoursTimeRange(msrest.serialization.Model):
    """Open time range for a day.

    :param start_time: The point in the next 7 days range when a given POI is being opened, or the
     beginning of the range if it was opened before the range.
    :type start_time: ~azure.maps.search.models.OperatingHoursTime
    :param end_time: The point in the next 7 days range when a given POI is being closed, or the
     beginning of the range if it was closed before the range.
    :type end_time: ~azure.maps.search.models.OperatingHoursTime
    """

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'OperatingHoursTime'},
        'end_time': {'key': 'endTime', 'type': 'OperatingHoursTime'},
    }

    def __init__(
        self,
        *,
        start_time: Optional["OperatingHoursTime"] = None,
        end_time: Optional["OperatingHoursTime"] = None,
        **kwargs
    ):
        super(OperatingHoursTimeRange, self).__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time


class PointOfInterest(msrest.serialization.Model):
    """Details of the returned POI including information such as the name, phone, url address, and classifications.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the POI property.
    :vartype name: str
    :ivar phone: Telephone number property.
    :vartype phone: str
    :ivar url: Website URL property.
    :vartype url: str
    :ivar category_set: The list of the most specific POI categories.
    :vartype category_set: list[~azure.maps.search.models.PointOfInterestCategorySet]
    :ivar classifications: Classification array.
    :vartype classifications: list[~azure.maps.search.models.Classification]
    :ivar brands: Brands array. The name of the brand for the POI being returned.
    :vartype brands: list[~azure.maps.search.models.BrandName]
    :param operating_hours: Opening hours for a POI (Points of Interest).
    :type operating_hours: ~azure.maps.search.models.OperatingHours
    """

    _validation = {
        'name': {'readonly': True},
        'phone': {'readonly': True},
        'url': {'readonly': True},
        'category_set': {'readonly': True},
        'classifications': {'readonly': True},
        'brands': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'phone': {'key': 'phone', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'category_set': {'key': 'categorySet', 'type': '[PointOfInterestCategorySet]'},
        'classifications': {'key': 'classifications', 'type': '[Classification]'},
        'brands': {'key': 'brands', 'type': '[BrandName]'},
        'operating_hours': {'key': 'openingHours', 'type': 'OperatingHours'},
    }

    def __init__(
        self,
        *,
        operating_hours: Optional["OperatingHours"] = None,
        **kwargs
    ):
        super(PointOfInterest, self).__init__(**kwargs)
        self.name = None
        self.phone = None
        self.url = None
        self.category_set = None
        self.classifications = None
        self.brands = None
        self.operating_hours = operating_hours


class PointOfInterestCategory(msrest.serialization.Model):
    """POI category result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Unique ID for the category. ID can be used to restrict search results to specific
     categories through other Search Service APIs, like `Get Search POI
     <https://docs.microsoft.com/rest/api/maps/search/getsearchpoi>`_.
    :vartype id: int
    :ivar name: Name of the category.
    :vartype name: str
    :ivar child_ids: Array of child category ids.
    :vartype child_ids: list[int]
    :ivar synonyms: Array of alternative names of the category.
    :vartype synonyms: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'child_ids': {'readonly': True},
        'synonyms': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'int'},
        'name': {'key': 'name', 'type': 'str'},
        'child_ids': {'key': 'childCategoryIds', 'type': '[int]'},
        'synonyms': {'key': 'synonyms', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PointOfInterestCategory, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.child_ids = None
        self.synonyms = None


class PointOfInterestCategorySet(msrest.serialization.Model):
    """POI category.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Category ID.
    :vartype id: int
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PointOfInterestCategorySet, self).__init__(**kwargs)
        self.id = None


class PointOfInterestCategoryTreeResult(msrest.serialization.Model):
    """This object is returned from a successful POI Category Tree call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar categories: Categories array.
    :vartype categories: list[~azure.maps.search.models.PointOfInterestCategory]
    """

    _validation = {
        'categories': {'readonly': True},
    }

    _attribute_map = {
        'categories': {'key': 'poiCategories', 'type': '[PointOfInterestCategory]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PointOfInterestCategoryTreeResult, self).__init__(**kwargs)
        self.categories = None


class Polygon(msrest.serialization.Model):
    """Polygon.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider_id: ID of the returned entity.
    :vartype provider_id: str
    :param geometry_data: Geometry data in GeoJSON format. Please refer to `RFC 7946
     <https://tools.ietf.org/html/rfc7946>`__ for details. Present only if "error" is not present.
    :type geometry_data: ~azure.maps.search.models.GeoJsonObject
    """

    _validation = {
        'provider_id': {'readonly': True},
    }

    _attribute_map = {
        'provider_id': {'key': 'providerID', 'type': 'str'},
        'geometry_data': {'key': 'geometryData', 'type': 'GeoJsonObject'},
    }

    def __init__(
        self,
        *,
        geometry_data: Optional["GeoJsonObject"] = None,
        **kwargs
    ):
        super(Polygon, self).__init__(**kwargs)
        self.provider_id = None
        self.geometry_data = geometry_data


class PolygonResult(msrest.serialization.Model):
    """This object is returned from a successful Search Polygon call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar polygons: Results array.
    :vartype polygons: list[~azure.maps.search.models.Polygon]
    """

    _validation = {
        'polygons': {'readonly': True},
    }

    _attribute_map = {
        'polygons': {'key': 'additionalData', 'type': '[Polygon]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolygonResult, self).__init__(**kwargs)
        self.polygons = None


class ReverseSearchAddressBatchItem(BatchResultItem):
    """An item returned from Search Address Reverse Batch service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status_code: HTTP request status code.
    :vartype status_code: int
    :ivar response: The result of the query. SearchAddressReverseResponse if the query completed
     successfully, ErrorResponse otherwise.
    :vartype response: ~azure.maps.search.models.ReverseSearchAddressBatchItemResponse
    """

    _validation = {
        'status_code': {'readonly': True},
        'response': {'readonly': True},
    }

    _attribute_map = {
        'status_code': {'key': 'statusCode', 'type': 'int'},
        'response': {'key': 'response', 'type': 'ReverseSearchAddressBatchItemResponse'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReverseSearchAddressBatchItem, self).__init__(**kwargs)
        self.response = None


class ReverseSearchAddressResult(msrest.serialization.Model):
    """This object is returned from a successful Search Address Reverse call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar summary: Summary object for a Search Address Reverse response.
    :vartype summary: ~azure.maps.search.models.SearchSummary
    :ivar addresses: Addresses array.
    :vartype addresses: list[~azure.maps.search.models.ReverseSearchAddressResultItem]
    """

    _validation = {
        'summary': {'readonly': True},
        'addresses': {'readonly': True},
    }

    _attribute_map = {
        'summary': {'key': 'summary', 'type': 'SearchSummary'},
        'addresses': {'key': 'addresses', 'type': '[ReverseSearchAddressResultItem]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReverseSearchAddressResult, self).__init__(**kwargs)
        self.summary = None
        self.addresses = None


class ReverseSearchAddressBatchItemResponse(ErrorResponse, ReverseSearchAddressResult):
    """The result of the query. SearchAddressReverseResponse if the query completed successfully, ErrorResponse otherwise.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar summary: Summary object for a Search Address Reverse response.
    :vartype summary: ~azure.maps.search.models.SearchSummary
    :ivar addresses: Addresses array.
    :vartype addresses: list[~azure.maps.search.models.ReverseSearchAddressResultItem]
    :param error: The error object.
    :type error: ~azure.maps.search.models.ErrorDetail
    """

    _validation = {
        'summary': {'readonly': True},
        'addresses': {'readonly': True},
    }

    _attribute_map = {
        'summary': {'key': 'summary', 'type': 'SearchSummary'},
        'addresses': {'key': 'addresses', 'type': '[ReverseSearchAddressResultItem]'},
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorDetail"] = None,
        **kwargs
    ):
        super(ReverseSearchAddressBatchItemResponse, self).__init__(error=error, **kwargs)
        self.summary = None
        self.addresses = None
        self.error = error


class ReverseSearchAddressBatchProcessResult(BatchResult):
    """This object is returned from a successful Search Address Reverse Batch service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar batch_summary: Summary of the results for the batch request.
    :vartype batch_summary: ~azure.maps.search.models.BatchResultSummary
    :ivar batch_items: Array containing the batch results.
    :vartype batch_items: list[~azure.maps.search.models.ReverseSearchAddressBatchItem]
    """

    _validation = {
        'batch_summary': {'readonly': True},
        'batch_items': {'readonly': True},
    }

    _attribute_map = {
        'batch_summary': {'key': 'summary', 'type': 'BatchResultSummary'},
        'batch_items': {'key': 'batchItems', 'type': '[ReverseSearchAddressBatchItem]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReverseSearchAddressBatchProcessResult, self).__init__(**kwargs)
        self.batch_items = None


class ReverseSearchAddressResultItem(msrest.serialization.Model):
    """Result object for a Search Address Reverse response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar address: The address of the result.
    :vartype address: ~azure.maps.search.models.Address
    :ivar position: Position property in the form of "{latitude},{longitude}".
    :vartype position: str
    :ivar road_use:
    :vartype road_use: list[str or ~azure.maps.search.models.RoadUseType]
    :ivar match_type: Information on the type of match.
    
     One of:
    
    
     * AddressPoint
     * HouseNumberRange
     * Street. Possible values include: "AddressPoint", "HouseNumberRange", "Street".
    :vartype match_type: str or ~azure.maps.search.models.MatchType
    """

    _validation = {
        'address': {'readonly': True},
        'position': {'readonly': True},
        'road_use': {'readonly': True},
        'match_type': {'readonly': True},
    }

    _attribute_map = {
        'address': {'key': 'address', 'type': 'Address'},
        'position': {'key': 'position', 'type': 'str'},
        'road_use': {'key': 'roadUse', 'type': '[str]'},
        'match_type': {'key': 'matchType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReverseSearchAddressResultItem, self).__init__(**kwargs)
        self.address = None
        self.position = None
        self.road_use = None
        self.match_type = None


class ReverseSearchCrossStreetAddressResult(msrest.serialization.Model):
    """This object is returned from a successful Search Address Reverse CrossStreet call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar summary: Summary object for a Search Address Reverse Cross Street response.
    :vartype summary: ~azure.maps.search.models.SearchSummary
    :ivar addresses: Addresses array.
    :vartype addresses: list[~azure.maps.search.models.ReverseSearchCrossStreetAddressResultItem]
    """

    _validation = {
        'summary': {'readonly': True},
        'addresses': {'readonly': True},
    }

    _attribute_map = {
        'summary': {'key': 'summary', 'type': 'SearchSummary'},
        'addresses': {'key': 'addresses', 'type': '[ReverseSearchCrossStreetAddressResultItem]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReverseSearchCrossStreetAddressResult, self).__init__(**kwargs)
        self.summary = None
        self.addresses = None


class ReverseSearchCrossStreetAddressResultItem(msrest.serialization.Model):
    """Result object for a Search Address Reverse Cross Street response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar address: The address of the result.
    :vartype address: ~azure.maps.search.models.Address
    :ivar position: Position property in the form of "{latitude},{longitude}".
    :vartype position: str
    """

    _validation = {
        'address': {'readonly': True},
        'position': {'readonly': True},
    }

    _attribute_map = {
        'address': {'key': 'address', 'type': 'Address'},
        'position': {'key': 'position', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReverseSearchCrossStreetAddressResultItem, self).__init__(**kwargs)
        self.address = None
        self.position = None


class SearchAddressBatchItem(BatchResultItem):
    """An item returned from Search Address Batch service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status_code: HTTP request status code.
    :vartype status_code: int
    :ivar response: The result of the query. SearchAddressResponse if the query completed
     successfully, ErrorResponse otherwise.
    :vartype response: ~azure.maps.search.models.SearchAddressBatchItemResponse
    """

    _validation = {
        'status_code': {'readonly': True},
        'response': {'readonly': True},
    }

    _attribute_map = {
        'status_code': {'key': 'statusCode', 'type': 'int'},
        'response': {'key': 'response', 'type': 'SearchAddressBatchItemResponse'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SearchAddressBatchItem, self).__init__(**kwargs)
        self.response = None


class SearchAddressResult(msrest.serialization.Model):
    """This object is returned from a successful Search calls.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar summary: Summary object for a Search API response.
    :vartype summary: ~azure.maps.search.models.SearchSummary
    :ivar results: A list of Search API results.
    :vartype results: list[~azure.maps.search.models.SearchAddressResultItem]
    """

    _validation = {
        'summary': {'readonly': True},
        'results': {'readonly': True},
    }

    _attribute_map = {
        'summary': {'key': 'summary', 'type': 'SearchSummary'},
        'results': {'key': 'results', 'type': '[SearchAddressResultItem]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SearchAddressResult, self).__init__(**kwargs)
        self.summary = None
        self.results = None


class SearchAddressBatchItemResponse(ErrorResponse, SearchAddressResult):
    """The result of the query. SearchAddressResponse if the query completed successfully, ErrorResponse otherwise.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar summary: Summary object for a Search API response.
    :vartype summary: ~azure.maps.search.models.SearchSummary
    :ivar results: A list of Search API results.
    :vartype results: list[~azure.maps.search.models.SearchAddressResultItem]
    :param error: The error object.
    :type error: ~azure.maps.search.models.ErrorDetail
    """

    _validation = {
        'summary': {'readonly': True},
        'results': {'readonly': True},
    }

    _attribute_map = {
        'summary': {'key': 'summary', 'type': 'SearchSummary'},
        'results': {'key': 'results', 'type': '[SearchAddressResultItem]'},
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorDetail"] = None,
        **kwargs
    ):
        super(SearchAddressBatchItemResponse, self).__init__(error=error, **kwargs)
        self.summary = None
        self.results = None
        self.error = error


class SearchAddressBatchResult(BatchResult):
    """This object is returned from a successful Search Address Batch service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar batch_summary: Summary of the results for the batch request.
    :vartype batch_summary: ~azure.maps.search.models.BatchResultSummary
    :ivar batch_items: Array containing the batch results.
    :vartype batch_items: list[~azure.maps.search.models.SearchAddressBatchItem]
    """

    _validation = {
        'batch_summary': {'readonly': True},
        'batch_items': {'readonly': True},
    }

    _attribute_map = {
        'batch_summary': {'key': 'summary', 'type': 'BatchResultSummary'},
        'batch_items': {'key': 'batchItems', 'type': '[SearchAddressBatchItem]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SearchAddressBatchResult, self).__init__(**kwargs)
        self.batch_items = None


class SearchAddressResultItem(msrest.serialization.Model):
    """Result object for a Search API response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: One of:
    
    
     * POI
     * Street
     * Geography
     * Point Address
     * Address Range
     * Cross Street. Possible values include: "POI", "Street", "Geography", "Point Address",
     "Address Range", "Cross Street".
    :vartype type: str or ~azure.maps.search.models.SearchAddressResultType
    :ivar id: Id property.
    :vartype id: str
    :ivar score: The value within a result set to indicate the relative matching score between
     results.  You can use this to  determine that result x is twice as likely to be as relevant as
     result y if the value of x is 2x the value of y.   The values vary between queries and is only
     meant as a relative value for one result set.
    :vartype score: float
    :ivar distance_in_meters: Straight line distance between the result and geobias location in
     meters.
    :vartype distance_in_meters: float
    :ivar info: Information about the original data source of the Result. Used for support
     requests.
    :vartype info: str
    :param entity_type:  Possible values include: "Country", "CountrySubdivision",
     "CountrySecondarySubdivision", "CountryTertiarySubdivision", "Municipality",
     "MunicipalitySubdivision", "Neighbourhood", "PostalCodeArea".
    :type entity_type: str or ~azure.maps.search.models.GeographicEntityType
    :ivar point_of_interest: Details of the returned POI including information such as the name,
     phone, url address, and classifications.
    :vartype point_of_interest: ~azure.maps.search.models.PointOfInterest
    :ivar address: The address of the result.
    :vartype address: ~azure.maps.search.models.Address
    :param position: A location represented as a latitude and longitude using short names 'lat' &
     'lon'.
    :type position: ~azure.maps.search.models.LatLongPairAbbreviated
    :ivar viewport: The viewport that covers the result represented by the top-left and bottom-
     right coordinates of the viewport.
    :vartype viewport: ~azure.maps.search.models.BoundingBox
    :ivar entry_points: Array of EntryPoints. Those describe the types of entrances available at
     the location. The type can be "main" for main entrances such as a front door, or a lobby, and
     "minor", for side and back doors.
    :vartype entry_points: list[~azure.maps.search.models.EntryPoint]
    :ivar address_ranges: Describes the address range on both sides of the street for a search
     result. Coordinates for the start and end locations of the address range are included.
    :vartype address_ranges: ~azure.maps.search.models.AddressRanges
    :ivar data_sources: Optional section. Reference geometry id for use with the `Get Search
     Polygon <https://docs.microsoft.com/rest/api/maps/search/getsearchpolygon>`_ API.
    :vartype data_sources: ~azure.maps.search.models.DataSource
    :ivar match_type: Information on the type of match.
    
     One of:
    
    
     * AddressPoint
     * HouseNumberRange
     * Street. Possible values include: "AddressPoint", "HouseNumberRange", "Street".
    :vartype match_type: str or ~azure.maps.search.models.MatchType
    :ivar detour_time: Detour time in seconds. Only returned for calls to the Search Along Route
     API.
    :vartype detour_time: int
    """

    _validation = {
        'type': {'readonly': True},
        'id': {'readonly': True},
        'score': {'readonly': True},
        'distance_in_meters': {'readonly': True},
        'info': {'readonly': True},
        'point_of_interest': {'readonly': True},
        'address': {'readonly': True},
        'viewport': {'readonly': True},
        'entry_points': {'readonly': True},
        'address_ranges': {'readonly': True},
        'data_sources': {'readonly': True},
        'match_type': {'readonly': True},
        'detour_time': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'score': {'key': 'score', 'type': 'float'},
        'distance_in_meters': {'key': 'dist', 'type': 'float'},
        'info': {'key': 'info', 'type': 'str'},
        'entity_type': {'key': 'entityType', 'type': 'str'},
        'point_of_interest': {'key': 'poi', 'type': 'PointOfInterest'},
        'address': {'key': 'address', 'type': 'Address'},
        'position': {'key': 'position', 'type': 'LatLongPairAbbreviated'},
        'viewport': {'key': 'viewport', 'type': 'BoundingBox'},
        'entry_points': {'key': 'entryPoints', 'type': '[EntryPoint]'},
        'address_ranges': {'key': 'addressRanges', 'type': 'AddressRanges'},
        'data_sources': {'key': 'dataSources', 'type': 'DataSource'},
        'match_type': {'key': 'matchType', 'type': 'str'},
        'detour_time': {'key': 'detourTime', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        entity_type: Optional[Union[str, "GeographicEntityType"]] = None,
        position: Optional["LatLongPairAbbreviated"] = None,
        **kwargs
    ):
        super(SearchAddressResultItem, self).__init__(**kwargs)
        self.type = None
        self.id = None
        self.score = None
        self.distance_in_meters = None
        self.info = None
        self.entity_type = entity_type
        self.point_of_interest = None
        self.address = None
        self.position = position
        self.viewport = None
        self.entry_points = None
        self.address_ranges = None
        self.data_sources = None
        self.match_type = None
        self.detour_time = None


class SearchAlongRouteRequest(msrest.serialization.Model):
    """This type represents the request body for the Search Along Route service.

    :param route: A valid ``GeoJSON LineString`` geometry type. Please refer to `RFC 7946
     <https://tools.ietf.org/html/rfc7946#section-3.1.4>`__ for details.
    :type route: ~azure.maps.search.models.GeoJsonLineString
    """

    _attribute_map = {
        'route': {'key': 'route', 'type': 'GeoJsonLineString'},
    }

    def __init__(
        self,
        *,
        route: Optional["GeoJsonLineString"] = None,
        **kwargs
    ):
        super(SearchAlongRouteRequest, self).__init__(**kwargs)
        self.route = route


class SearchInsideGeometryRequest(msrest.serialization.Model):
    """This type represents the request body for the Search Inside Geometry service.

    :param geometry: A valid ``GeoJSON`` object. Please refer to `RFC 7946
     <https://tools.ietf.org/html/rfc7946#section-3>`__ for details.
    :type geometry: ~azure.maps.search.models.GeoJsonObject
    """

    _attribute_map = {
        'geometry': {'key': 'geometry', 'type': 'GeoJsonObject'},
    }

    def __init__(
        self,
        *,
        geometry: Optional["GeoJsonObject"] = None,
        **kwargs
    ):
        super(SearchInsideGeometryRequest, self).__init__(**kwargs)
        self.geometry = geometry


class SearchSummary(msrest.serialization.Model):
    """Summary object for a Search API response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar query: The query parameter that was used to produce these search results.
    :vartype query: str
    :ivar query_type: The type of query being returned: NEARBY or NON_NEAR. Possible values
     include: "NEARBY", "NON_NEAR".
    :vartype query_type: str or ~azure.maps.search.models.QueryType
    :ivar query_time: Time spent resolving the query, in milliseconds.
    :vartype query_time: int
    :ivar num_results: Number of results in the response.
    :vartype num_results: int
    :ivar top: Maximum number of responses that will be returned.
    :vartype top: int
    :ivar skip: The starting offset of the returned Results within the full Result set.
    :vartype skip: int
    :ivar total_results: The total number of Results found.
    :vartype total_results: int
    :ivar fuzzy_level: The maximum fuzzy level required to provide Results.
    :vartype fuzzy_level: int
    :ivar geo_bias: Indication when the internal search engine has applied a geospatial bias to
     improve the ranking of results.  In  some methods, this can be affected by setting the lat and
     lon parameters where available.  In other cases it is  purely internal.
    :vartype geo_bias: ~azure.maps.search.models.LatLongPairAbbreviated
    """

    _validation = {
        'query': {'readonly': True},
        'query_type': {'readonly': True},
        'query_time': {'readonly': True},
        'num_results': {'readonly': True},
        'top': {'readonly': True},
        'skip': {'readonly': True},
        'total_results': {'readonly': True},
        'fuzzy_level': {'readonly': True},
        'geo_bias': {'readonly': True},
    }

    _attribute_map = {
        'query': {'key': 'query', 'type': 'str'},
        'query_type': {'key': 'queryType', 'type': 'str'},
        'query_time': {'key': 'queryTime', 'type': 'int'},
        'num_results': {'key': 'numResults', 'type': 'int'},
        'top': {'key': 'limit', 'type': 'int'},
        'skip': {'key': 'offset', 'type': 'int'},
        'total_results': {'key': 'totalResults', 'type': 'int'},
        'fuzzy_level': {'key': 'fuzzyLevel', 'type': 'int'},
        'geo_bias': {'key': 'geoBias', 'type': 'LatLongPairAbbreviated'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SearchSummary, self).__init__(**kwargs)
        self.query = None
        self.query_type = None
        self.query_time = None
        self.num_results = None
        self.top = None
        self.skip = None
        self.total_results = None
        self.fuzzy_level = None
        self.geo_bias = None


class Viewport(msrest.serialization.Model):
    """The viewport that covers the result represented by the top-left and bottom-right coordinates of the viewport.

    :param top_left_point: A location represented as a latitude and longitude using short names
     'lat' & 'lon'.
    :type top_left_point: ~azure.maps.search.models.LatLongPairAbbreviated
    :param btm_right_point: A location represented as a latitude and longitude using short names
     'lat' & 'lon'.
    :type btm_right_point: ~azure.maps.search.models.LatLongPairAbbreviated
    """

    _attribute_map = {
        'top_left_point': {'key': 'topLeftPoint', 'type': 'LatLongPairAbbreviated'},
        'btm_right_point': {'key': 'btmRightPoint', 'type': 'LatLongPairAbbreviated'},
    }

    def __init__(
        self,
        *,
        top_left_point: Optional["LatLongPairAbbreviated"] = None,
        btm_right_point: Optional["LatLongPairAbbreviated"] = None,
        **kwargs
    ):
        super(Viewport, self).__init__(**kwargs)
        self.top_left_point = top_left_point
        self.btm_right_point = btm_right_point
