# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Attributes(_serialization.Model):
    """The object attributes managed by the KeyVault service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar enabled: Determines whether the object is enabled.
    :vartype enabled: bool
    :ivar not_before: Not before date in UTC.
    :vartype not_before: ~datetime.datetime
    :ivar expires: Expiry date in UTC.
    :vartype expires: ~datetime.datetime
    :ivar created: Creation time in UTC.
    :vartype created: ~datetime.datetime
    :ivar updated: Last updated time in UTC.
    :vartype updated: ~datetime.datetime
    """

    _validation = {
        "created": {"readonly": True},
        "updated": {"readonly": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "not_before": {"key": "nbf", "type": "unix-time"},
        "expires": {"key": "exp", "type": "unix-time"},
        "created": {"key": "created", "type": "unix-time"},
        "updated": {"key": "updated", "type": "unix-time"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        not_before: Optional[datetime.datetime] = None,
        expires: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Determines whether the object is enabled.
        :paramtype enabled: bool
        :keyword not_before: Not before date in UTC.
        :paramtype not_before: ~datetime.datetime
        :keyword expires: Expiry date in UTC.
        :paramtype expires: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.not_before = not_before
        self.expires = expires
        self.created = None
        self.updated = None


class Error(_serialization.Model):
    """The key vault server error.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar inner_error: The key vault server error.
    :vartype inner_error: ~azure.keyvault.v7_6_preview_1.models.Error
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "inner_error": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "inner_error": {"key": "innererror", "type": "Error"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.inner_error = None


class FullBackupOperation(_serialization.Model):
    """Full backup operation.

    :ivar status: Status of the backup operation.
    :vartype status: str
    :ivar status_details: The status details of backup operation.
    :vartype status_details: str
    :ivar error: Error encountered, if any, during the full backup operation.
    :vartype error: ~azure.keyvault.v7_6_preview_1.models.Error
    :ivar start_time: The start time of the backup operation in UTC.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the backup operation in UTC.
    :vartype end_time: ~datetime.datetime
    :ivar job_id: Identifier for the full backup operation.
    :vartype job_id: str
    :ivar azure_storage_blob_container_uri: The Azure blob storage container Uri which contains the
     full backup.
    :vartype azure_storage_blob_container_uri: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "status_details": {"key": "statusDetails", "type": "str"},
        "error": {"key": "error", "type": "Error"},
        "start_time": {"key": "startTime", "type": "unix-time"},
        "end_time": {"key": "endTime", "type": "unix-time"},
        "job_id": {"key": "jobId", "type": "str"},
        "azure_storage_blob_container_uri": {"key": "azureStorageBlobContainerUri", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[str] = None,
        status_details: Optional[str] = None,
        error: Optional["_models.Error"] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        job_id: Optional[str] = None,
        azure_storage_blob_container_uri: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Status of the backup operation.
        :paramtype status: str
        :keyword status_details: The status details of backup operation.
        :paramtype status_details: str
        :keyword error: Error encountered, if any, during the full backup operation.
        :paramtype error: ~azure.keyvault.v7_6_preview_1.models.Error
        :keyword start_time: The start time of the backup operation in UTC.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time of the backup operation in UTC.
        :paramtype end_time: ~datetime.datetime
        :keyword job_id: Identifier for the full backup operation.
        :paramtype job_id: str
        :keyword azure_storage_blob_container_uri: The Azure blob storage container Uri which contains
         the full backup.
        :paramtype azure_storage_blob_container_uri: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.status_details = status_details
        self.error = error
        self.start_time = start_time
        self.end_time = end_time
        self.job_id = job_id
        self.azure_storage_blob_container_uri = azure_storage_blob_container_uri


class KeyVaultError(_serialization.Model):
    """The key vault error exception.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: The key vault server error.
    :vartype error: ~azure.keyvault.v7_6_preview_1.models.Error
    """

    _validation = {
        "error": {"readonly": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "Error"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.error = None


class Permission(_serialization.Model):
    """Role definition permissions.

    :ivar actions: Action permissions that are granted.
    :vartype actions: list[str]
    :ivar not_actions: Action permissions that are excluded but not denied. They may be granted by
     other role definitions assigned to a principal.
    :vartype not_actions: list[str]
    :ivar data_actions: Data action permissions that are granted.
    :vartype data_actions: list[str or ~azure.keyvault.v7_6_preview_1.models.DataAction]
    :ivar not_data_actions: Data action permissions that are excluded but not denied. They may be
     granted by other role definitions assigned to a principal.
    :vartype not_data_actions: list[str or ~azure.keyvault.v7_6_preview_1.models.DataAction]
    """

    _attribute_map = {
        "actions": {"key": "actions", "type": "[str]"},
        "not_actions": {"key": "notActions", "type": "[str]"},
        "data_actions": {"key": "dataActions", "type": "[str]"},
        "not_data_actions": {"key": "notDataActions", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        actions: Optional[List[str]] = None,
        not_actions: Optional[List[str]] = None,
        data_actions: Optional[List[Union[str, "_models.DataAction"]]] = None,
        not_data_actions: Optional[List[Union[str, "_models.DataAction"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword actions: Action permissions that are granted.
        :paramtype actions: list[str]
        :keyword not_actions: Action permissions that are excluded but not denied. They may be granted
         by other role definitions assigned to a principal.
        :paramtype not_actions: list[str]
        :keyword data_actions: Data action permissions that are granted.
        :paramtype data_actions: list[str or ~azure.keyvault.v7_6_preview_1.models.DataAction]
        :keyword not_data_actions: Data action permissions that are excluded but not denied. They may
         be granted by other role definitions assigned to a principal.
        :paramtype not_data_actions: list[str or ~azure.keyvault.v7_6_preview_1.models.DataAction]
        """
        super().__init__(**kwargs)
        self.actions = actions
        self.not_actions = not_actions
        self.data_actions = data_actions
        self.not_data_actions = not_data_actions


class PreBackupOperationParameters(_serialization.Model):
    """PreBackupOperationParameters.

    :ivar storage_resource_uri: Azure Blob storage container Uri.
    :vartype storage_resource_uri: str
    :ivar token: The SAS token pointing to an Azure Blob storage container.
    :vartype token: str
    :ivar use_managed_identity: Indicates which authentication method should be used. If set to
     true, Managed HSM will use the configured user-assigned managed identity to authenticate with
     Azure Storage. Otherwise, a SAS token has to be specified.
    :vartype use_managed_identity: bool
    """

    _attribute_map = {
        "storage_resource_uri": {"key": "storageResourceUri", "type": "str"},
        "token": {"key": "token", "type": "str"},
        "use_managed_identity": {"key": "useManagedIdentity", "type": "bool"},
    }

    def __init__(
        self,
        *,
        storage_resource_uri: Optional[str] = None,
        token: Optional[str] = None,
        use_managed_identity: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword storage_resource_uri: Azure Blob storage container Uri.
        :paramtype storage_resource_uri: str
        :keyword token: The SAS token pointing to an Azure Blob storage container.
        :paramtype token: str
        :keyword use_managed_identity: Indicates which authentication method should be used. If set to
         true, Managed HSM will use the configured user-assigned managed identity to authenticate with
         Azure Storage. Otherwise, a SAS token has to be specified.
        :paramtype use_managed_identity: bool
        """
        super().__init__(**kwargs)
        self.storage_resource_uri = storage_resource_uri
        self.token = token
        self.use_managed_identity = use_managed_identity


class PreRestoreOperationParameters(_serialization.Model):
    """PreRestoreOperationParameters.

    :ivar sas_token_parameters:
    :vartype sas_token_parameters: ~azure.keyvault.v7_6_preview_1.models.SASTokenParameter
    :ivar folder_to_restore: The Folder name of the blob where the previous successful full backup
     was stored.
    :vartype folder_to_restore: str
    """

    _attribute_map = {
        "sas_token_parameters": {"key": "sasTokenParameters", "type": "SASTokenParameter"},
        "folder_to_restore": {"key": "folderToRestore", "type": "str"},
    }

    def __init__(
        self,
        *,
        sas_token_parameters: Optional["_models.SASTokenParameter"] = None,
        folder_to_restore: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sas_token_parameters:
        :paramtype sas_token_parameters: ~azure.keyvault.v7_6_preview_1.models.SASTokenParameter
        :keyword folder_to_restore: The Folder name of the blob where the previous successful full
         backup was stored.
        :paramtype folder_to_restore: str
        """
        super().__init__(**kwargs)
        self.sas_token_parameters = sas_token_parameters
        self.folder_to_restore = folder_to_restore


class RestoreOperation(_serialization.Model):
    """Restore operation.

    :ivar status: Status of the restore operation.
    :vartype status: str
    :ivar status_details: The status details of restore operation.
    :vartype status_details: str
    :ivar error: Error encountered, if any, during the restore operation.
    :vartype error: ~azure.keyvault.v7_6_preview_1.models.Error
    :ivar job_id: Identifier for the restore operation.
    :vartype job_id: str
    :ivar start_time: The start time of the restore operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the restore operation.
    :vartype end_time: ~datetime.datetime
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "status_details": {"key": "statusDetails", "type": "str"},
        "error": {"key": "error", "type": "Error"},
        "job_id": {"key": "jobId", "type": "str"},
        "start_time": {"key": "startTime", "type": "unix-time"},
        "end_time": {"key": "endTime", "type": "unix-time"},
    }

    def __init__(
        self,
        *,
        status: Optional[str] = None,
        status_details: Optional[str] = None,
        error: Optional["_models.Error"] = None,
        job_id: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Status of the restore operation.
        :paramtype status: str
        :keyword status_details: The status details of restore operation.
        :paramtype status_details: str
        :keyword error: Error encountered, if any, during the restore operation.
        :paramtype error: ~azure.keyvault.v7_6_preview_1.models.Error
        :keyword job_id: Identifier for the restore operation.
        :paramtype job_id: str
        :keyword start_time: The start time of the restore operation.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time of the restore operation.
        :paramtype end_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.status = status
        self.status_details = status_details
        self.error = error
        self.job_id = job_id
        self.start_time = start_time
        self.end_time = end_time


class RestoreOperationParameters(_serialization.Model):
    """RestoreOperationParameters.

    All required parameters must be populated in order to send to server.

    :ivar sas_token_parameters: Required.
    :vartype sas_token_parameters: ~azure.keyvault.v7_6_preview_1.models.SASTokenParameter
    :ivar folder_to_restore: The Folder name of the blob where the previous successful full backup
     was stored. Required.
    :vartype folder_to_restore: str
    """

    _validation = {
        "sas_token_parameters": {"required": True},
        "folder_to_restore": {"required": True},
    }

    _attribute_map = {
        "sas_token_parameters": {"key": "sasTokenParameters", "type": "SASTokenParameter"},
        "folder_to_restore": {"key": "folderToRestore", "type": "str"},
    }

    def __init__(
        self, *, sas_token_parameters: "_models.SASTokenParameter", folder_to_restore: str, **kwargs: Any
    ) -> None:
        """
        :keyword sas_token_parameters: Required.
        :paramtype sas_token_parameters: ~azure.keyvault.v7_6_preview_1.models.SASTokenParameter
        :keyword folder_to_restore: The Folder name of the blob where the previous successful full
         backup was stored. Required.
        :paramtype folder_to_restore: str
        """
        super().__init__(**kwargs)
        self.sas_token_parameters = sas_token_parameters
        self.folder_to_restore = folder_to_restore


class RoleAssignment(_serialization.Model):
    """Role Assignments.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The role assignment ID.
    :vartype id: str
    :ivar name: The role assignment name.
    :vartype name: str
    :ivar type: The role assignment type.
    :vartype type: str
    :ivar properties: Role assignment properties.
    :vartype properties: ~azure.keyvault.v7_6_preview_1.models.RoleAssignmentPropertiesWithScope
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "RoleAssignmentPropertiesWithScope"},
    }

    def __init__(
        self, *, properties: Optional["_models.RoleAssignmentPropertiesWithScope"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Role assignment properties.
        :paramtype properties: ~azure.keyvault.v7_6_preview_1.models.RoleAssignmentPropertiesWithScope
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = properties


class RoleAssignmentCreateParameters(_serialization.Model):
    """Role assignment create parameters.

    All required parameters must be populated in order to send to server.

    :ivar properties: Role assignment properties. Required.
    :vartype properties: ~azure.keyvault.v7_6_preview_1.models.RoleAssignmentProperties
    """

    _validation = {
        "properties": {"required": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "RoleAssignmentProperties"},
    }

    def __init__(self, *, properties: "_models.RoleAssignmentProperties", **kwargs: Any) -> None:
        """
        :keyword properties: Role assignment properties. Required.
        :paramtype properties: ~azure.keyvault.v7_6_preview_1.models.RoleAssignmentProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class RoleAssignmentFilter(_serialization.Model):
    """Role Assignments filter.

    :ivar principal_id: Returns role assignment of the specific principal.
    :vartype principal_id: str
    """

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
    }

    def __init__(self, *, principal_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword principal_id: Returns role assignment of the specific principal.
        :paramtype principal_id: str
        """
        super().__init__(**kwargs)
        self.principal_id = principal_id


class RoleAssignmentListResult(_serialization.Model):
    """Role assignment list operation result.

    :ivar value: Role assignment list.
    :vartype value: list[~azure.keyvault.v7_6_preview_1.models.RoleAssignment]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RoleAssignment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.RoleAssignment"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Role assignment list.
        :paramtype value: list[~azure.keyvault.v7_6_preview_1.models.RoleAssignment]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RoleAssignmentProperties(_serialization.Model):
    """Role assignment properties.

    All required parameters must be populated in order to send to server.

    :ivar role_definition_id: The role definition ID used in the role assignment. Required.
    :vartype role_definition_id: str
    :ivar principal_id: The principal ID assigned to the role. This maps to the ID inside the
     Active Directory. It can point to a user, service principal, or security group. Required.
    :vartype principal_id: str
    """

    _validation = {
        "role_definition_id": {"required": True},
        "principal_id": {"required": True},
    }

    _attribute_map = {
        "role_definition_id": {"key": "roleDefinitionId", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
    }

    def __init__(self, *, role_definition_id: str, principal_id: str, **kwargs: Any) -> None:
        """
        :keyword role_definition_id: The role definition ID used in the role assignment. Required.
        :paramtype role_definition_id: str
        :keyword principal_id: The principal ID assigned to the role. This maps to the ID inside the
         Active Directory. It can point to a user, service principal, or security group. Required.
        :paramtype principal_id: str
        """
        super().__init__(**kwargs)
        self.role_definition_id = role_definition_id
        self.principal_id = principal_id


class RoleAssignmentPropertiesWithScope(_serialization.Model):
    """Role assignment properties with scope.

    :ivar scope: The role scope. Known values are: "/" and "/keys".
    :vartype scope: str or ~azure.keyvault.v7_6_preview_1.models.RoleScope
    :ivar role_definition_id: The role definition ID.
    :vartype role_definition_id: str
    :ivar principal_id: The principal ID.
    :vartype principal_id: str
    """

    _attribute_map = {
        "scope": {"key": "scope", "type": "str"},
        "role_definition_id": {"key": "roleDefinitionId", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
    }

    def __init__(
        self,
        *,
        scope: Optional[Union[str, "_models.RoleScope"]] = None,
        role_definition_id: Optional[str] = None,
        principal_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword scope: The role scope. Known values are: "/" and "/keys".
        :paramtype scope: str or ~azure.keyvault.v7_6_preview_1.models.RoleScope
        :keyword role_definition_id: The role definition ID.
        :paramtype role_definition_id: str
        :keyword principal_id: The principal ID.
        :paramtype principal_id: str
        """
        super().__init__(**kwargs)
        self.scope = scope
        self.role_definition_id = role_definition_id
        self.principal_id = principal_id


class RoleDefinition(_serialization.Model):
    """Role definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The role definition ID.
    :vartype id: str
    :ivar name: The role definition name.
    :vartype name: str
    :ivar type: The role definition type. "Microsoft.Authorization/roleDefinitions"
    :vartype type: str or ~azure.keyvault.v7_6_preview_1.models.RoleDefinitionType
    :ivar properties: Role definition properties.
    :vartype properties: ~azure.keyvault.v7_6_preview_1.models.RoleDefinitionProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "RoleDefinitionProperties"},
    }

    def __init__(self, *, properties: Optional["_models.RoleDefinitionProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Role definition properties.
        :paramtype properties: ~azure.keyvault.v7_6_preview_1.models.RoleDefinitionProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = properties


class RoleDefinitionCreateParameters(_serialization.Model):
    """Role definition create parameters.

    All required parameters must be populated in order to send to server.

    :ivar properties: Role definition properties. Required.
    :vartype properties: ~azure.keyvault.v7_6_preview_1.models.RoleDefinitionProperties
    """

    _validation = {
        "properties": {"required": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "RoleDefinitionProperties"},
    }

    def __init__(self, *, properties: "_models.RoleDefinitionProperties", **kwargs: Any) -> None:
        """
        :keyword properties: Role definition properties. Required.
        :paramtype properties: ~azure.keyvault.v7_6_preview_1.models.RoleDefinitionProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class RoleDefinitionFilter(_serialization.Model):
    """Role Definitions filter.

    :ivar role_name: Returns role definition with the specific name.
    :vartype role_name: str
    """

    _attribute_map = {
        "role_name": {"key": "roleName", "type": "str"},
    }

    def __init__(self, *, role_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword role_name: Returns role definition with the specific name.
        :paramtype role_name: str
        """
        super().__init__(**kwargs)
        self.role_name = role_name


class RoleDefinitionListResult(_serialization.Model):
    """Role definition list operation result.

    :ivar value: Role definition list.
    :vartype value: list[~azure.keyvault.v7_6_preview_1.models.RoleDefinition]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RoleDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.RoleDefinition"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Role definition list.
        :paramtype value: list[~azure.keyvault.v7_6_preview_1.models.RoleDefinition]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RoleDefinitionProperties(_serialization.Model):
    """Role definition properties.

    :ivar role_name: The role name.
    :vartype role_name: str
    :ivar description: The role definition description.
    :vartype description: str
    :ivar role_type: The role type. Known values are: "AKVBuiltInRole" and "CustomRole".
    :vartype role_type: str or ~azure.keyvault.v7_6_preview_1.models.RoleType
    :ivar permissions: Role definition permissions.
    :vartype permissions: list[~azure.keyvault.v7_6_preview_1.models.Permission]
    :ivar assignable_scopes: Role definition assignable scopes.
    :vartype assignable_scopes: list[str or ~azure.keyvault.v7_6_preview_1.models.RoleScope]
    """

    _attribute_map = {
        "role_name": {"key": "roleName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "role_type": {"key": "type", "type": "str"},
        "permissions": {"key": "permissions", "type": "[Permission]"},
        "assignable_scopes": {"key": "assignableScopes", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        role_name: Optional[str] = None,
        description: Optional[str] = None,
        role_type: Optional[Union[str, "_models.RoleType"]] = None,
        permissions: Optional[List["_models.Permission"]] = None,
        assignable_scopes: Optional[List[Union[str, "_models.RoleScope"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword role_name: The role name.
        :paramtype role_name: str
        :keyword description: The role definition description.
        :paramtype description: str
        :keyword role_type: The role type. Known values are: "AKVBuiltInRole" and "CustomRole".
        :paramtype role_type: str or ~azure.keyvault.v7_6_preview_1.models.RoleType
        :keyword permissions: Role definition permissions.
        :paramtype permissions: list[~azure.keyvault.v7_6_preview_1.models.Permission]
        :keyword assignable_scopes: Role definition assignable scopes.
        :paramtype assignable_scopes: list[str or ~azure.keyvault.v7_6_preview_1.models.RoleScope]
        """
        super().__init__(**kwargs)
        self.role_name = role_name
        self.description = description
        self.role_type = role_type
        self.permissions = permissions
        self.assignable_scopes = assignable_scopes


class SASTokenParameter(_serialization.Model):
    """SASTokenParameter.

    All required parameters must be populated in order to send to server.

    :ivar storage_resource_uri: Azure Blob storage container Uri. Required.
    :vartype storage_resource_uri: str
    :ivar token: The SAS token pointing to an Azure Blob storage container.
    :vartype token: str
    :ivar use_managed_identity: Indicates which authentication method should be used. If set to
     true, Managed HSM will use the configured user-assigned managed identity to authenticate with
     Azure Storage. Otherwise, a SAS token has to be specified.
    :vartype use_managed_identity: bool
    """

    _validation = {
        "storage_resource_uri": {"required": True},
    }

    _attribute_map = {
        "storage_resource_uri": {"key": "storageResourceUri", "type": "str"},
        "token": {"key": "token", "type": "str"},
        "use_managed_identity": {"key": "useManagedIdentity", "type": "bool"},
    }

    def __init__(
        self,
        *,
        storage_resource_uri: str,
        token: Optional[str] = None,
        use_managed_identity: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword storage_resource_uri: Azure Blob storage container Uri. Required.
        :paramtype storage_resource_uri: str
        :keyword token: The SAS token pointing to an Azure Blob storage container.
        :paramtype token: str
        :keyword use_managed_identity: Indicates which authentication method should be used. If set to
         true, Managed HSM will use the configured user-assigned managed identity to authenticate with
         Azure Storage. Otherwise, a SAS token has to be specified.
        :paramtype use_managed_identity: bool
        """
        super().__init__(**kwargs)
        self.storage_resource_uri = storage_resource_uri
        self.token = token
        self.use_managed_identity = use_managed_identity


class SelectiveKeyRestoreOperation(_serialization.Model):
    """Selective Key Restore operation.

    :ivar status: Status of the restore operation.
    :vartype status: str
    :ivar status_details: The status details of restore operation.
    :vartype status_details: str
    :ivar error: Error encountered, if any, during the selective key restore operation.
    :vartype error: ~azure.keyvault.v7_6_preview_1.models.Error
    :ivar job_id: Identifier for the selective key restore operation.
    :vartype job_id: str
    :ivar start_time: The start time of the restore operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the restore operation.
    :vartype end_time: ~datetime.datetime
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "status_details": {"key": "statusDetails", "type": "str"},
        "error": {"key": "error", "type": "Error"},
        "job_id": {"key": "jobId", "type": "str"},
        "start_time": {"key": "startTime", "type": "unix-time"},
        "end_time": {"key": "endTime", "type": "unix-time"},
    }

    def __init__(
        self,
        *,
        status: Optional[str] = None,
        status_details: Optional[str] = None,
        error: Optional["_models.Error"] = None,
        job_id: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Status of the restore operation.
        :paramtype status: str
        :keyword status_details: The status details of restore operation.
        :paramtype status_details: str
        :keyword error: Error encountered, if any, during the selective key restore operation.
        :paramtype error: ~azure.keyvault.v7_6_preview_1.models.Error
        :keyword job_id: Identifier for the selective key restore operation.
        :paramtype job_id: str
        :keyword start_time: The start time of the restore operation.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time of the restore operation.
        :paramtype end_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.status = status
        self.status_details = status_details
        self.error = error
        self.job_id = job_id
        self.start_time = start_time
        self.end_time = end_time


class SelectiveKeyRestoreOperationParameters(_serialization.Model):
    """SelectiveKeyRestoreOperationParameters.

    All required parameters must be populated in order to send to server.

    :ivar sas_token_parameters: Required.
    :vartype sas_token_parameters: ~azure.keyvault.v7_6_preview_1.models.SASTokenParameter
    :ivar folder: The Folder name of the blob where the previous successful full backup was stored.
     Required.
    :vartype folder: str
    """

    _validation = {
        "sas_token_parameters": {"required": True},
        "folder": {"required": True},
    }

    _attribute_map = {
        "sas_token_parameters": {"key": "sasTokenParameters", "type": "SASTokenParameter"},
        "folder": {"key": "folder", "type": "str"},
    }

    def __init__(self, *, sas_token_parameters: "_models.SASTokenParameter", folder: str, **kwargs: Any) -> None:
        """
        :keyword sas_token_parameters: Required.
        :paramtype sas_token_parameters: ~azure.keyvault.v7_6_preview_1.models.SASTokenParameter
        :keyword folder: The Folder name of the blob where the previous successful full backup was
         stored. Required.
        :paramtype folder: str
        """
        super().__init__(**kwargs)
        self.sas_token_parameters = sas_token_parameters
        self.folder = folder


class Setting(_serialization.Model):
    """Setting.

    All required parameters must be populated in order to send to server.

    :ivar name: The account setting to be updated. Required.
    :vartype name: str
    :ivar value: The value of the pool setting. Required.
    :vartype value: str
    :ivar type: The type specifier of the value. "boolean"
    :vartype type: str or ~azure.keyvault.v7_6_preview_1.models.SettingTypeEnum
    """

    _validation = {
        "name": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self, *, name: str, value: str, type: Optional[Union[str, "_models.SettingTypeEnum"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: The account setting to be updated. Required.
        :paramtype name: str
        :keyword value: The value of the pool setting. Required.
        :paramtype value: str
        :keyword type: The type specifier of the value. "boolean"
        :paramtype type: str or ~azure.keyvault.v7_6_preview_1.models.SettingTypeEnum
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value
        self.type = type


class SettingsListResult(_serialization.Model):
    """The settings list result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar settings: A response message containing a list of account settings with their associated
     value.
    :vartype settings: list[~azure.keyvault.v7_6_preview_1.models.Setting]
    """

    _validation = {
        "settings": {"readonly": True},
    }

    _attribute_map = {
        "settings": {"key": "settings", "type": "[Setting]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.settings = None


class UpdateSettingRequest(_serialization.Model):
    """The update settings request object.

    All required parameters must be populated in order to send to server.

    :ivar value: The value of the pool setting. Required.
    :vartype value: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, value: str, **kwargs: Any) -> None:
        """
        :keyword value: The value of the pool setting. Required.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.value = value
