# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_field

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AdvancedCustomProperties(_model_base.Model):
    """Informatica Serverless advanced custom properties.

    :ivar key: advanced custom properties key.
    :vartype key: str
    :ivar value: advanced custom properties value.
    :vartype value: str
    """

    key: Optional[str] = rest_field()
    """advanced custom properties key."""
    value: Optional[str] = rest_field()
    """advanced custom properties value."""

    @overload
    def __init__(
        self,
        *,
        key: Optional[str] = None,
        value: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ApplicationConfigs(_model_base.Model):
    """Application configs.

    All required parameters must be populated in order to send to server.

    :ivar type: Type of the application config. Required.
    :vartype type: str
    :ivar name: Name of the application config. Required.
    :vartype name: str
    :ivar value: Value of the application config. Required.
    :vartype value: str
    :ivar platform: Platform type of the application config. Required.
    :vartype platform: str
    :ivar customized: Customized value of the application config. Required.
    :vartype customized: str
    :ivar default_value: Default value of the application config. Required.
    :vartype default_value: str
    """

    type: str = rest_field()
    """Type of the application config. Required."""
    name: str = rest_field()
    """Name of the application config. Required."""
    value: str = rest_field()
    """Value of the application config. Required."""
    platform: str = rest_field()
    """Platform type of the application config. Required."""
    customized: str = rest_field()
    """Customized value of the application config. Required."""
    default_value: str = rest_field(name="defaultValue")
    """Default value of the application config. Required."""

    @overload
    def __init__(
        self,
        *,
        type: str,
        name: str,
        value: str,
        platform: str,
        customized: str,
        default_value: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ApplicationTypeMetadata(_model_base.Model):
    """Informatica Serverless Runtime Application type Metadata.

    :ivar name: Application type name.
    :vartype name: str
    :ivar value: Application type value.
    :vartype value: str
    """

    name: Optional[str] = rest_field()
    """Application type name."""
    value: Optional[str] = rest_field()
    """Application type value."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class CdiConfigProps(_model_base.Model):
    """Informatica CDI Configuration Properties.

    All required parameters must be populated in order to send to server.

    :ivar engine_name: EngineName of the application config. Required.
    :vartype engine_name: str
    :ivar engine_version: EngineVersion of the application config. Required.
    :vartype engine_version: str
    :ivar application_configs: ApplicationConfigs of the CDI or CDIE. Required.
    :vartype application_configs:
     list[~azure.mgmt.informaticadatamanagement.models.ApplicationConfigs]
    """

    engine_name: str = rest_field(name="engineName")
    """EngineName of the application config. Required."""
    engine_version: str = rest_field(name="engineVersion")
    """EngineVersion of the application config. Required."""
    application_configs: List["_models.ApplicationConfigs"] = rest_field(name="applicationConfigs")
    """ApplicationConfigs of the CDI or CDIE. Required."""

    @overload
    def __init__(
        self,
        *,
        engine_name: str,
        engine_version: str,
        application_configs: List["_models.ApplicationConfigs"],
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class CheckDependenciesResponse(_model_base.Model):
    """Model for the check dependencies API for an informatica serverless runtime resource.

    All required parameters must be populated in order to send to server.

    :ivar count: Count of dependencies. Required.
    :vartype count: int
    :ivar id: id of resource. Required.
    :vartype id: str
    :ivar references: List of dependencies. Required.
    :vartype references:
     list[~azure.mgmt.informaticadatamanagement.models.ServerlessRuntimeDependency]
    """

    count: int = rest_field()
    """Count of dependencies. Required."""
    id: str = rest_field()
    """id of resource. Required."""
    references: List["_models.ServerlessRuntimeDependency"] = rest_field()
    """List of dependencies. Required."""

    @overload
    def __init__(
        self,
        *,
        count: int,
        id: str,  # pylint: disable=redefined-builtin
        references: List["_models.ServerlessRuntimeDependency"],
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class CompanyDetails(_model_base.Model):
    """Company Details.

    :ivar company_name: company Name.
    :vartype company_name: str
    :ivar office_address: Office Address.
    :vartype office_address: str
    :ivar country: Country name.
    :vartype country: str
    :ivar domain: Domain name.
    :vartype domain: str
    :ivar business: Business phone number.
    :vartype business: str
    :ivar number_of_employees: Number Of Employees.
    :vartype number_of_employees: int
    """

    company_name: Optional[str] = rest_field(name="companyName")
    """company Name."""
    office_address: Optional[str] = rest_field(name="officeAddress")
    """Office Address."""
    country: Optional[str] = rest_field()
    """Country name."""
    domain: Optional[str] = rest_field()
    """Domain name."""
    business: Optional[str] = rest_field()
    """Business phone number."""
    number_of_employees: Optional[int] = rest_field(name="numberOfEmployees")
    """Number Of Employees."""

    @overload
    def __init__(
        self,
        *,
        company_name: Optional[str] = None,
        office_address: Optional[str] = None,
        country: Optional[str] = None,
        domain: Optional[str] = None,
        business: Optional[str] = None,
        number_of_employees: Optional[int] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class CompanyDetailsUpdate(_model_base.Model):
    """Company details of Informatica Organization resource.

    :ivar company_name: company Name.
    :vartype company_name: str
    :ivar office_address: Office Address.
    :vartype office_address: str
    :ivar country: Country name.
    :vartype country: str
    :ivar domain: Domain name.
    :vartype domain: str
    :ivar business: Business phone number.
    :vartype business: str
    :ivar number_of_employees: Number Of Employees.
    :vartype number_of_employees: int
    """

    company_name: Optional[str] = rest_field(name="companyName")
    """company Name."""
    office_address: Optional[str] = rest_field(name="officeAddress")
    """Office Address."""
    country: Optional[str] = rest_field()
    """Country name."""
    domain: Optional[str] = rest_field()
    """Domain name."""
    business: Optional[str] = rest_field()
    """Business phone number."""
    number_of_employees: Optional[int] = rest_field(name="numberOfEmployees")
    """Number Of Employees."""

    @overload
    def __init__(
        self,
        *,
        company_name: Optional[str] = None,
        office_address: Optional[str] = None,
        country: Optional[str] = None,
        domain: Optional[str] = None,
        business: Optional[str] = None,
        number_of_employees: Optional[int] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ComputeUnitsMetadata(_model_base.Model):
    """Informatica Serverless Runtime Application type Metadata.

    :ivar name: ComputeUnit name.
    :vartype name: str
    :ivar value: ComputeUnit value.
    :vartype value: list[str]
    """

    name: Optional[str] = rest_field()
    """ComputeUnit name."""
    value: Optional[List[str]] = rest_field()
    """ComputeUnit value."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[List[str]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_model_base.Model):
    """The resource management error additional info.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_model_base.Model):
    """The error detail.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.informaticadatamanagement.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.informaticadatamanagement.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_model_base.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.informaticadatamanagement.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field()
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class InfaRuntimeResourceFetchMetaData(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """Informatica runtime resource metadata as received via the informatica fetch all runtime
    environments API.

    All required parameters must be populated in order to send to server.

    :ivar name: Environment name. Required.
    :vartype name: str
    :ivar created_time: Created time. Required.
    :vartype created_time: str
    :ivar updated_time: Updated Time. Required.
    :vartype updated_time: str
    :ivar created_by: Created by. Required.
    :vartype created_by: str
    :ivar updated_by: Last Updated by. Required.
    :vartype updated_by: str
    :ivar id: Informatica serverless runtime id. Required.
    :vartype id: str
    :ivar type: Environment Type. Required. "SERVERLESS"
    :vartype type: str or ~azure.mgmt.informaticadatamanagement.models.RuntimeType
    :ivar status: Status of the environment. Required.
    :vartype status: str
    :ivar status_localized: Display message for the given status. Required.
    :vartype status_localized: str
    :ivar status_message: status message. Required.
    :vartype status_message: str
    :ivar serverless_config_properties: Serverless Config Properties. Required.
    :vartype serverless_config_properties:
     ~azure.mgmt.informaticadatamanagement.models.InfaServerlessFetchConfigProperties
    :ivar description: Description of the runtime resource.
    :vartype description: str
    """

    name: str = rest_field()
    """Environment name. Required."""
    created_time: str = rest_field(name="createdTime")
    """Created time. Required."""
    updated_time: str = rest_field(name="updatedTime")
    """Updated Time. Required."""
    created_by: str = rest_field(name="createdBy")
    """Created by. Required."""
    updated_by: str = rest_field(name="updatedBy")
    """Last Updated by. Required."""
    id: str = rest_field()
    """Informatica serverless runtime id. Required."""
    type: Union[str, "_models.RuntimeType"] = rest_field()
    """Environment Type. Required. \"SERVERLESS\""""
    status: str = rest_field()
    """Status of the environment. Required."""
    status_localized: str = rest_field(name="statusLocalized")
    """Display message for the given status. Required."""
    status_message: str = rest_field(name="statusMessage")
    """status message. Required."""
    serverless_config_properties: "_models.InfaServerlessFetchConfigProperties" = rest_field(
        name="serverlessConfigProperties"
    )
    """Serverless Config Properties. Required."""
    description: Optional[str] = rest_field()
    """Description of the runtime resource."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        created_time: str,
        updated_time: str,
        created_by: str,
        updated_by: str,
        id: str,  # pylint: disable=redefined-builtin
        type: Union[str, "_models.RuntimeType"],
        status: str,
        status_localized: str,
        status_message: str,
        serverless_config_properties: "_models.InfaServerlessFetchConfigProperties",
        description: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class InfaServerlessFetchConfigProperties(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """InfaServerlessFetchConfigProperties for the fetch all serverless API as received from
    informatica API response.

    :ivar subnet: subnet name.
    :vartype subnet: str
    :ivar application_type: applicationType name.
    :vartype application_type: str
    :ivar resource_group_name: Resource group name.
    :vartype resource_group_name: str
    :ivar advanced_custom_properties: Advanced custom properties.
    :vartype advanced_custom_properties: str
    :ivar supplementary_file_location: Supplementary File location.
    :vartype supplementary_file_location: str
    :ivar platform: Serverless Account Platform.
    :vartype platform: str
    :ivar tags: Tags for the resource.
    :vartype tags: str
    :ivar vnet: virtual network.
    :vartype vnet: str
    :ivar execution_timeout: Execution timeout.
    :vartype execution_timeout: str
    :ivar compute_units: Compute Units.
    :vartype compute_units: str
    :ivar tenant_id: Tenant ID.
    :vartype tenant_id: str
    :ivar subscription_id: subscription ID.
    :vartype subscription_id: str
    :ivar region: region name for the runtime environment.
    :vartype region: str
    :ivar serverless_arm_resource_id: Serverless Arm Resource ID.
    :vartype serverless_arm_resource_id: str
    """

    subnet: Optional[str] = rest_field()
    """subnet name."""
    application_type: Optional[str] = rest_field(name="applicationType")
    """applicationType name."""
    resource_group_name: Optional[str] = rest_field(name="resourceGroupName")
    """Resource group name."""
    advanced_custom_properties: Optional[str] = rest_field(name="advancedCustomProperties")
    """Advanced custom properties."""
    supplementary_file_location: Optional[str] = rest_field(name="supplementaryFileLocation")
    """Supplementary File location."""
    platform: Optional[str] = rest_field()
    """Serverless Account Platform."""
    tags: Optional[str] = rest_field()
    """Tags for the resource."""
    vnet: Optional[str] = rest_field()
    """virtual network."""
    execution_timeout: Optional[str] = rest_field(name="executionTimeout")
    """Execution timeout."""
    compute_units: Optional[str] = rest_field(name="computeUnits")
    """Compute Units."""
    tenant_id: Optional[str] = rest_field(name="tenantId")
    """Tenant ID."""
    subscription_id: Optional[str] = rest_field(name="subscriptionId")
    """subscription ID."""
    region: Optional[str] = rest_field()
    """region name for the runtime environment."""
    serverless_arm_resource_id: Optional[str] = rest_field(name="serverlessArmResourceId")
    """Serverless Arm Resource ID."""

    @overload
    def __init__(
        self,
        *,
        subnet: Optional[str] = None,
        application_type: Optional[str] = None,
        resource_group_name: Optional[str] = None,
        advanced_custom_properties: Optional[str] = None,
        supplementary_file_location: Optional[str] = None,
        platform: Optional[str] = None,
        tags: Optional[str] = None,
        vnet: Optional[str] = None,
        execution_timeout: Optional[str] = None,
        compute_units: Optional[str] = None,
        tenant_id: Optional[str] = None,
        subscription_id: Optional[str] = None,
        region: Optional[str] = None,
        serverless_arm_resource_id: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Resource(_model_base.Model):
    """Common properties for all Azure Resource Manager resources.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.informaticadatamanagement.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long"""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.informaticadatamanagement.models.SystemData
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""
    tags: Optional[Dict[str, str]] = rest_field()
    """Resource tags."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class InformaticaOrganizationResource(TrackedResource):
    """An Organization Resource by Informatica.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.informaticadatamanagement.models.SystemData
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.informaticadatamanagement.models.OrganizationProperties
    """

    properties: Optional["_models.OrganizationProperties"] = rest_field(visibility=["read", "create"])
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.OrganizationProperties"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class InformaticaOrganizationResourceUpdate(_model_base.Model):
    """The template for adding optional properties.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: Patchable PropertieInformaticaOrganizationPropertiesUpdates of the
     Organization observability resource.
    :vartype properties:
     ~azure.mgmt.informaticadatamanagement.models.OrganizationPropertiesCustomUpdate
    """

    tags: Optional[Dict[str, str]] = rest_field()
    """Resource tags."""
    properties: Optional["_models.OrganizationPropertiesCustomUpdate"] = rest_field()
    """Patchable PropertieInformaticaOrganizationPropertiesUpdates of the Organization observability
     resource."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.OrganizationPropertiesCustomUpdate"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class InformaticaProperties(_model_base.Model):
    """Properties of the Informatica organization.

    :ivar organization_id: Organization id.
    :vartype organization_id: str
    :ivar organization_name: Organization name.
    :vartype organization_name: str
    :ivar informatica_region: Informatica organization region.
    :vartype informatica_region: str
    :ivar single_sign_on_url: Single sing on URL for informatica organization.
    :vartype single_sign_on_url: str
    """

    organization_id: Optional[str] = rest_field(name="organizationId")
    """Organization id."""
    organization_name: Optional[str] = rest_field(name="organizationName")
    """Organization name."""
    informatica_region: Optional[str] = rest_field(name="informaticaRegion")
    """Informatica organization region."""
    single_sign_on_url: Optional[str] = rest_field(name="singleSignOnUrl")
    """Single sing on URL for informatica organization."""

    @overload
    def __init__(
        self,
        *,
        organization_id: Optional[str] = None,
        organization_name: Optional[str] = None,
        informatica_region: Optional[str] = None,
        single_sign_on_url: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class InformaticaServerlessRuntimeProperties(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """Serverless Runtime properties.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar provisioning_state: Provisioning State of the resource. Known values are: "Accepted",
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and
     "NotSpecified".
    :vartype provisioning_state: str or
     ~azure.mgmt.informaticadatamanagement.models.ProvisioningState
    :ivar description: description of the serverless runtime.
    :vartype description: str
    :ivar platform: Platform type of the Serverless Runtime. "AZURE"
    :vartype platform: str or ~azure.mgmt.informaticadatamanagement.models.PlatformType
    :ivar application_type: Application type of the Serverless Runtime environment. Known values
     are: "CDI" and "CDIE".
    :vartype application_type: str or ~azure.mgmt.informaticadatamanagement.models.ApplicationType
    :ivar compute_units: Compute units of the serverless runtime.
    :vartype compute_units: str
    :ivar execution_timeout: Serverless Execution timeout.
    :vartype execution_timeout: str
    :ivar serverless_account_location: Serverless account creation location. Required.
    :vartype serverless_account_location: str
    :ivar serverless_runtime_network_profile: Informatica Serverless Network profile properties.
    :vartype serverless_runtime_network_profile:
     ~azure.mgmt.informaticadatamanagement.models.ServerlessRuntimeNetworkProfile
    :ivar advanced_custom_properties: String KV pairs indicating Advanced custom properties.
    :vartype advanced_custom_properties:
     list[~azure.mgmt.informaticadatamanagement.models.AdvancedCustomProperties]
    :ivar supplementary_file_location: Supplementary file location.
    :vartype supplementary_file_location: str
    :ivar serverless_runtime_config: Serverless config properties.
    :vartype serverless_runtime_config:
     ~azure.mgmt.informaticadatamanagement.models.ServerlessRuntimeConfigProperties
    :ivar serverless_runtime_tags: Serverless Runtime Tags.
    :vartype serverless_runtime_tags:
     list[~azure.mgmt.informaticadatamanagement.models.ServerlessRuntimeTag]
    :ivar serverless_runtime_user_context_properties: Serverless runtime user context properties.
    :vartype serverless_runtime_user_context_properties:
     ~azure.mgmt.informaticadatamanagement.models.ServerlessRuntimeUserContextProperties
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning State of the resource. Known values are: \"Accepted\", \"Creating\", \"Updating\",
     \"Deleting\", \"Succeeded\", \"Failed\", \"Canceled\", \"Deleted\", and \"NotSpecified\"."""
    description: Optional[str] = rest_field()
    """description of the serverless runtime."""
    platform: Optional[Union[str, "_models.PlatformType"]] = rest_field()
    """Platform type of the Serverless Runtime. \"AZURE\""""
    application_type: Optional[Union[str, "_models.ApplicationType"]] = rest_field(name="applicationType")
    """Application type of the Serverless Runtime environment. Known values are: \"CDI\" and \"CDIE\"."""
    compute_units: Optional[str] = rest_field(name="computeUnits")
    """Compute units of the serverless runtime."""
    execution_timeout: Optional[str] = rest_field(name="executionTimeout")
    """Serverless Execution timeout."""
    serverless_account_location: str = rest_field(name="serverlessAccountLocation")
    """Serverless account creation location. Required."""
    serverless_runtime_network_profile: Optional["_models.ServerlessRuntimeNetworkProfile"] = rest_field(
        name="serverlessRuntimeNetworkProfile"
    )
    """Informatica Serverless Network profile properties."""
    advanced_custom_properties: Optional[List["_models.AdvancedCustomProperties"]] = rest_field(
        name="advancedCustomProperties"
    )
    """String KV pairs indicating Advanced custom properties."""
    supplementary_file_location: Optional[str] = rest_field(name="supplementaryFileLocation")
    """Supplementary file location."""
    serverless_runtime_config: Optional["_models.ServerlessRuntimeConfigProperties"] = rest_field(
        name="serverlessRuntimeConfig"
    )
    """Serverless config properties."""
    serverless_runtime_tags: Optional[List["_models.ServerlessRuntimeTag"]] = rest_field(name="serverlessRuntimeTags")
    """Serverless Runtime Tags."""
    serverless_runtime_user_context_properties: Optional["_models.ServerlessRuntimeUserContextProperties"] = rest_field(
        name="serverlessRuntimeUserContextProperties"
    )
    """Serverless runtime user context properties."""

    @overload
    def __init__(
        self,
        *,
        serverless_account_location: str,
        description: Optional[str] = None,
        platform: Optional[Union[str, "_models.PlatformType"]] = None,
        application_type: Optional[Union[str, "_models.ApplicationType"]] = None,
        compute_units: Optional[str] = None,
        execution_timeout: Optional[str] = None,
        serverless_runtime_network_profile: Optional["_models.ServerlessRuntimeNetworkProfile"] = None,
        advanced_custom_properties: Optional[List["_models.AdvancedCustomProperties"]] = None,
        supplementary_file_location: Optional[str] = None,
        serverless_runtime_config: Optional["_models.ServerlessRuntimeConfigProperties"] = None,
        serverless_runtime_tags: Optional[List["_models.ServerlessRuntimeTag"]] = None,
        serverless_runtime_user_context_properties: Optional["_models.ServerlessRuntimeUserContextProperties"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ProxyResource(Resource):
    """The base proxy resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.informaticadatamanagement.models.SystemData
    """


class InformaticaServerlessRuntimeResource(ProxyResource):
    """A Serverless Runtime environment  resource by Informatica.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.informaticadatamanagement.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.informaticadatamanagement.models.InformaticaServerlessRuntimeProperties
    """

    properties: Optional["_models.InformaticaServerlessRuntimeProperties"] = rest_field(visibility=["read", "create"])
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.InformaticaServerlessRuntimeProperties"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class InformaticaServerlessRuntimeResourceList(_model_base.Model):
    """A list of serverless runtime resources as fetched using the informatica APIs.

    All required parameters must be populated in order to send to server.

    :ivar informatica_runtime_resources: List of runtime resources for the fetch all API. Required.
    :vartype informatica_runtime_resources:
     list[~azure.mgmt.informaticadatamanagement.models.InfaRuntimeResourceFetchMetaData]
    """

    informatica_runtime_resources: List["_models.InfaRuntimeResourceFetchMetaData"] = rest_field(
        name="informaticaRuntimeResources"
    )
    """List of runtime resources for the fetch all API. Required."""

    @overload
    def __init__(
        self,
        *,
        informatica_runtime_resources: List["_models.InfaRuntimeResourceFetchMetaData"],
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class InformaticaServerlessRuntimeResourceUpdate(_model_base.Model):  # pylint: disable=name-too-long
    """The template for adding optional properties.

    :ivar properties: Patchable PropertieInformaticaOrganizationPropertiesUpdates of the
     Organization observability resource.
    :vartype properties:
     ~azure.mgmt.informaticadatamanagement.models.ServerlessRuntimePropertiesCustomUpdate
    """

    properties: Optional["_models.ServerlessRuntimePropertiesCustomUpdate"] = rest_field()
    """Patchable PropertieInformaticaOrganizationPropertiesUpdates of the Organization observability
     resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ServerlessRuntimePropertiesCustomUpdate"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class LinkOrganization(_model_base.Model):
    """Link Organization.

    :ivar token: Link organization token.
    :vartype token: str
    """

    token: Optional[str] = rest_field()
    """Link organization token."""

    @overload
    def __init__(
        self,
        *,
        token: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class MarketplaceDetails(_model_base.Model):
    """Marketplace details.

    All required parameters must be populated in order to send to server.

    :ivar marketplace_subscription_id: Marketplace Subscription Id. Required.
    :vartype marketplace_subscription_id: str
    :ivar offer_details: Marketplace offer details. Required.
    :vartype offer_details: ~azure.mgmt.informaticadatamanagement.models.OfferDetails
    """

    marketplace_subscription_id: str = rest_field(name="marketplaceSubscriptionId")
    """Marketplace Subscription Id. Required."""
    offer_details: "_models.OfferDetails" = rest_field(name="offerDetails")
    """Marketplace offer details. Required."""

    @overload
    def __init__(
        self,
        *,
        marketplace_subscription_id: str,
        offer_details: "_models.OfferDetails",
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class MarketplaceDetailsUpdate(_model_base.Model):
    """Marketplace details.

    :ivar marketplace_subscription_id: Marketplace Subscription Id.
    :vartype marketplace_subscription_id: str
    :ivar offer_details: Marketplace offer details.
    :vartype offer_details: ~azure.mgmt.informaticadatamanagement.models.OfferDetailsUpdate
    """

    marketplace_subscription_id: Optional[str] = rest_field(name="marketplaceSubscriptionId")
    """Marketplace Subscription Id."""
    offer_details: Optional["_models.OfferDetailsUpdate"] = rest_field(name="offerDetails")
    """Marketplace offer details."""

    @overload
    def __init__(
        self,
        *,
        marketplace_subscription_id: Optional[str] = None,
        offer_details: Optional["_models.OfferDetailsUpdate"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class NetworkInterfaceConfiguration(_model_base.Model):
    """Informatica Serverless Runtime Network Interface configurations.

    All required parameters must be populated in order to send to server.

    :ivar vnet_id: Virtual network resource id. Required.
    :vartype vnet_id: str
    :ivar subnet_id: Virtual network subnet resource id. Required.
    :vartype subnet_id: str
    :ivar vnet_resource_guid: Virtual network resource guid.
    :vartype vnet_resource_guid: str
    """

    vnet_id: str = rest_field(name="vnetId")
    """Virtual network resource id. Required."""
    subnet_id: str = rest_field(name="subnetId")
    """Virtual network subnet resource id. Required."""
    vnet_resource_guid: Optional[str] = rest_field(name="vnetResourceGuid")
    """Virtual network resource guid."""

    @overload
    def __init__(
        self,
        *,
        vnet_id: str,
        subnet_id: str,
        vnet_resource_guid: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class NetworkInterfaceConfigurationUpdate(_model_base.Model):
    """The template for adding optional properties.

    :ivar vnet_id: Virtual network resource id.
    :vartype vnet_id: str
    :ivar subnet_id: Virtual network subnet resource id.
    :vartype subnet_id: str
    :ivar vnet_resource_guid: Virtual network resource guid.
    :vartype vnet_resource_guid: str
    """

    vnet_id: Optional[str] = rest_field(name="vnetId")
    """Virtual network resource id."""
    subnet_id: Optional[str] = rest_field(name="subnetId")
    """Virtual network subnet resource id."""
    vnet_resource_guid: Optional[str] = rest_field(name="vnetResourceGuid")
    """Virtual network resource guid."""

    @overload
    def __init__(
        self,
        *,
        vnet_id: Optional[str] = None,
        subnet_id: Optional[str] = None,
        vnet_resource_guid: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class OfferDetails(_model_base.Model):
    """Details of the product offering.

    All required parameters must be populated in order to send to server.

    :ivar publisher_id: Id of the product publisher. Required.
    :vartype publisher_id: str
    :ivar offer_id: Id of the product offering. Required.
    :vartype offer_id: str
    :ivar plan_id: Id of the product offer plan. Required.
    :vartype plan_id: str
    :ivar plan_name: Name of the product offer plan. Required.
    :vartype plan_name: str
    :ivar term_unit: Offer plan term unit.
    :vartype term_unit: str
    :ivar term_id: Offer plan term id. Required.
    :vartype term_id: str
    """

    publisher_id: str = rest_field(name="publisherId")
    """Id of the product publisher. Required."""
    offer_id: str = rest_field(name="offerId")
    """Id of the product offering. Required."""
    plan_id: str = rest_field(name="planId")
    """Id of the product offer plan. Required."""
    plan_name: str = rest_field(name="planName")
    """Name of the product offer plan. Required."""
    term_unit: Optional[str] = rest_field(name="termUnit")
    """Offer plan term unit."""
    term_id: str = rest_field(name="termId")
    """Offer plan term id. Required."""

    @overload
    def __init__(
        self,
        *,
        publisher_id: str,
        offer_id: str,
        plan_id: str,
        plan_name: str,
        term_id: str,
        term_unit: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class OfferDetailsUpdate(_model_base.Model):
    """Details of the product offering.

    :ivar publisher_id: Id of the product publisher.
    :vartype publisher_id: str
    :ivar offer_id: Id of the product offering.
    :vartype offer_id: str
    :ivar plan_id: Id of the product offer plan.
    :vartype plan_id: str
    :ivar plan_name: Name of the product offer plan.
    :vartype plan_name: str
    :ivar term_unit: Offer plan term unit.
    :vartype term_unit: str
    :ivar term_id: Offer plan term id.
    :vartype term_id: str
    """

    publisher_id: Optional[str] = rest_field(name="publisherId")
    """Id of the product publisher."""
    offer_id: Optional[str] = rest_field(name="offerId")
    """Id of the product offering."""
    plan_id: Optional[str] = rest_field(name="planId")
    """Id of the product offer plan."""
    plan_name: Optional[str] = rest_field(name="planName")
    """Name of the product offer plan."""
    term_unit: Optional[str] = rest_field(name="termUnit")
    """Offer plan term unit."""
    term_id: Optional[str] = rest_field(name="termId")
    """Offer plan term id."""

    @overload
    def __init__(
        self,
        *,
        publisher_id: Optional[str] = None,
        offer_id: Optional[str] = None,
        plan_id: Optional[str] = None,
        plan_name: Optional[str] = None,
        term_unit: Optional[str] = None,
        term_id: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Operation(_model_base.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.informaticadatamanagement.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.informaticadatamanagement.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.informaticadatamanagement.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field()
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType")
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
        action_type: Optional[Union[str, "_models.ActionType"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class OperationDisplay(_model_base.Model):
    """Localized display information for and operation.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field()
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field()
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field()
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field()
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""

    @overload
    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class OrganizationProperties(_model_base.Model):
    """Properties specific to the Informatica DataManagement Organization resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning State of the resource. Known values are: "Accepted",
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and
     "NotSpecified".
    :vartype provisioning_state: str or
     ~azure.mgmt.informaticadatamanagement.models.ProvisioningState
    :ivar informatica_properties: Informatica Organization properties.
    :vartype informatica_properties:
     ~azure.mgmt.informaticadatamanagement.models.InformaticaProperties
    :ivar marketplace_details: Marketplace details.
    :vartype marketplace_details: ~azure.mgmt.informaticadatamanagement.models.MarketplaceDetails
    :ivar user_details: User details.
    :vartype user_details: ~azure.mgmt.informaticadatamanagement.models.UserDetails
    :ivar company_details: Company details.
    :vartype company_details: ~azure.mgmt.informaticadatamanagement.models.CompanyDetails
    :ivar link_organization: Link Organization.
    :vartype link_organization: ~azure.mgmt.informaticadatamanagement.models.LinkOrganization
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning State of the resource. Known values are: \"Accepted\", \"Creating\", \"Updating\",
     \"Deleting\", \"Succeeded\", \"Failed\", \"Canceled\", \"Deleted\", and \"NotSpecified\"."""
    informatica_properties: Optional["_models.InformaticaProperties"] = rest_field(name="informaticaProperties")
    """Informatica Organization properties."""
    marketplace_details: Optional["_models.MarketplaceDetails"] = rest_field(name="marketplaceDetails")
    """Marketplace details."""
    user_details: Optional["_models.UserDetails"] = rest_field(name="userDetails")
    """User details."""
    company_details: Optional["_models.CompanyDetails"] = rest_field(name="companyDetails")
    """Company details."""
    link_organization: Optional["_models.LinkOrganization"] = rest_field(name="linkOrganization")
    """Link Organization."""

    @overload
    def __init__(
        self,
        *,
        informatica_properties: Optional["_models.InformaticaProperties"] = None,
        marketplace_details: Optional["_models.MarketplaceDetails"] = None,
        user_details: Optional["_models.UserDetails"] = None,
        company_details: Optional["_models.CompanyDetails"] = None,
        link_organization: Optional["_models.LinkOrganization"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class OrganizationPropertiesCustomUpdate(_model_base.Model):
    """Patchable Properties of the Informatica Organization resource.

    :ivar informatica_organization_properties: Informatica Organization properties.
    :vartype informatica_organization_properties:
     ~azure.mgmt.informaticadatamanagement.models.InformaticaOrganizationResourceUpdate
    :ivar marketplace_details: Marketplace details.
    :vartype marketplace_details:
     ~azure.mgmt.informaticadatamanagement.models.MarketplaceDetailsUpdate
    :ivar user_details: User details.
    :vartype user_details: ~azure.mgmt.informaticadatamanagement.models.UserDetailsUpdate
    :ivar company_details: Company Details.
    :vartype company_details: ~azure.mgmt.informaticadatamanagement.models.CompanyDetailsUpdate
    :ivar existing_resource_id: Existing Resource Id.
    :vartype existing_resource_id: str
    """

    informatica_organization_properties: Optional["_models.InformaticaOrganizationResourceUpdate"] = rest_field(
        name="informaticaOrganizationProperties"
    )
    """Informatica Organization properties."""
    marketplace_details: Optional["_models.MarketplaceDetailsUpdate"] = rest_field(name="marketplaceDetails")
    """Marketplace details."""
    user_details: Optional["_models.UserDetailsUpdate"] = rest_field(name="userDetails")
    """User details."""
    company_details: Optional["_models.CompanyDetailsUpdate"] = rest_field(name="companyDetails")
    """Company Details."""
    existing_resource_id: Optional[str] = rest_field(name="existingResourceId")
    """Existing Resource Id."""

    @overload
    def __init__(
        self,
        *,
        informatica_organization_properties: Optional["_models.InformaticaOrganizationResourceUpdate"] = None,
        marketplace_details: Optional["_models.MarketplaceDetailsUpdate"] = None,
        user_details: Optional["_models.UserDetailsUpdate"] = None,
        company_details: Optional["_models.CompanyDetailsUpdate"] = None,
        existing_resource_id: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class RegionsMetadata(_model_base.Model):
    """Informatica Serverless Runtime Regions Metadata.

    :ivar id: Region Id.
    :vartype id: str
    :ivar name: Region name.
    :vartype name: str
    """

    id: Optional[str] = rest_field()
    """Region Id."""
    name: Optional[str] = rest_field()
    """Region name."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ServerlessConfigProperties(_model_base.Model):
    """Metadata Serverless Config Properties.

    :ivar platform: Platform types. "AZURE"
    :vartype platform: str or ~azure.mgmt.informaticadatamanagement.models.PlatformType
    :ivar application_types: List of application types supported by informatica.
    :vartype application_types:
     list[~azure.mgmt.informaticadatamanagement.models.ApplicationTypeMetadata]
    :ivar compute_units: The list of compute units with possible array of values.
    :vartype compute_units: list[~azure.mgmt.informaticadatamanagement.models.ComputeUnitsMetadata]
    :ivar execution_timeout: Serverless Runtime execution timeout.
    :vartype execution_timeout: str
    :ivar regions: List of supported serverless informatica regions.
    :vartype regions: list[~azure.mgmt.informaticadatamanagement.models.RegionsMetadata]
    """

    platform: Optional[Union[str, "_models.PlatformType"]] = rest_field()
    """Platform types. \"AZURE\""""
    application_types: Optional[List["_models.ApplicationTypeMetadata"]] = rest_field(name="applicationTypes")
    """List of application types supported by informatica."""
    compute_units: Optional[List["_models.ComputeUnitsMetadata"]] = rest_field(name="computeUnits")
    """The list of compute units with possible array of values."""
    execution_timeout: Optional[str] = rest_field(name="executionTimeout")
    """Serverless Runtime execution timeout."""
    regions: Optional[List["_models.RegionsMetadata"]] = rest_field()
    """List of supported serverless informatica regions."""

    @overload
    def __init__(
        self,
        *,
        platform: Optional[Union[str, "_models.PlatformType"]] = None,
        application_types: Optional[List["_models.ApplicationTypeMetadata"]] = None,
        compute_units: Optional[List["_models.ComputeUnitsMetadata"]] = None,
        execution_timeout: Optional[str] = None,
        regions: Optional[List["_models.RegionsMetadata"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ServerlessMetadataResponse(_model_base.Model):
    """Serverless Runtime environment Metadata response.

    :ivar type: type of the runtime environment. "SERVERLESS"
    :vartype type: str or ~azure.mgmt.informaticadatamanagement.models.RuntimeType
    :ivar serverless_config_properties: serverless config properties.
    :vartype serverless_config_properties:
     ~azure.mgmt.informaticadatamanagement.models.ServerlessConfigProperties
    :ivar serverless_runtime_config_properties: serverless runtime config properties.
    :vartype serverless_runtime_config_properties:
     ~azure.mgmt.informaticadatamanagement.models.ServerlessRuntimeConfigProperties
    """

    type: Optional[Union[str, "_models.RuntimeType"]] = rest_field()
    """type of the runtime environment. \"SERVERLESS\""""
    serverless_config_properties: Optional["_models.ServerlessConfigProperties"] = rest_field(
        name="serverlessConfigProperties"
    )
    """serverless config properties."""
    serverless_runtime_config_properties: Optional["_models.ServerlessRuntimeConfigProperties"] = rest_field(
        name="serverlessRuntimeConfigProperties"
    )
    """serverless runtime config properties."""

    @overload
    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.RuntimeType"]] = None,
        serverless_config_properties: Optional["_models.ServerlessConfigProperties"] = None,
        serverless_runtime_config_properties: Optional["_models.ServerlessRuntimeConfigProperties"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ServerlessRuntimeConfigProperties(_model_base.Model):
    """Serverless Runtime config properties.

    :ivar cdi_config_props: The List of Informatica Serverless Runtime CDI Config Properties.
    :vartype cdi_config_props: list[~azure.mgmt.informaticadatamanagement.models.CdiConfigProps]
    :ivar cdie_config_props: The List of Informatica Serverless Runtime CDIE Config Properties.
    :vartype cdie_config_props: list[~azure.mgmt.informaticadatamanagement.models.CdiConfigProps]
    """

    cdi_config_props: Optional[List["_models.CdiConfigProps"]] = rest_field(name="cdiConfigProps")
    """The List of Informatica Serverless Runtime CDI Config Properties."""
    cdie_config_props: Optional[List["_models.CdiConfigProps"]] = rest_field(name="cdieConfigProps")
    """The List of Informatica Serverless Runtime CDIE Config Properties."""

    @overload
    def __init__(
        self,
        *,
        cdi_config_props: Optional[List["_models.CdiConfigProps"]] = None,
        cdie_config_props: Optional[List["_models.CdiConfigProps"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ServerlessRuntimeConfigPropertiesUpdate(_model_base.Model):
    """The template for adding optional properties.

    :ivar cdi_config_props: The List of Informatica Serverless Runtime CDI Config Properties.
    :vartype cdi_config_props: list[~azure.mgmt.informaticadatamanagement.models.CdiConfigProps]
    :ivar cdie_config_props: The List of Informatica Serverless Runtime CDIE Config Properties.
    :vartype cdie_config_props: list[~azure.mgmt.informaticadatamanagement.models.CdiConfigProps]
    """

    cdi_config_props: Optional[List["_models.CdiConfigProps"]] = rest_field(name="cdiConfigProps")
    """The List of Informatica Serverless Runtime CDI Config Properties."""
    cdie_config_props: Optional[List["_models.CdiConfigProps"]] = rest_field(name="cdieConfigProps")
    """The List of Informatica Serverless Runtime CDIE Config Properties."""

    @overload
    def __init__(
        self,
        *,
        cdi_config_props: Optional[List["_models.CdiConfigProps"]] = None,
        cdie_config_props: Optional[List["_models.CdiConfigProps"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ServerlessRuntimeDependency(_model_base.Model):
    """Dependency reference for a serverless runtime resource.

    All required parameters must be populated in order to send to server.

    :ivar id: Dependency ID. Required.
    :vartype id: str
    :ivar app_context_id: Application context ID. Required.
    :vartype app_context_id: str
    :ivar path: Dependency path. Required.
    :vartype path: str
    :ivar document_type: document type. Required.
    :vartype document_type: str
    :ivar description: description of Dependency. Required.
    :vartype description: str
    :ivar last_updated_time: Last Update Time. Required.
    :vartype last_updated_time: str
    """

    id: str = rest_field()
    """Dependency ID. Required."""
    app_context_id: str = rest_field(name="appContextId")
    """Application context ID. Required."""
    path: str = rest_field()
    """Dependency path. Required."""
    document_type: str = rest_field(name="documentType")
    """document type. Required."""
    description: str = rest_field()
    """description of Dependency. Required."""
    last_updated_time: str = rest_field(name="lastUpdatedTime")
    """Last Update Time. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        app_context_id: str,
        path: str,
        document_type: str,
        description: str,
        last_updated_time: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ServerlessRuntimeNetworkProfile(_model_base.Model):
    """Informatica Serverless Runtime Network Profile.

    All required parameters must be populated in order to send to server.

    :ivar network_interface_configuration: Network Interface Configuration Profile. Required.
    :vartype network_interface_configuration:
     ~azure.mgmt.informaticadatamanagement.models.NetworkInterfaceConfiguration
    """

    network_interface_configuration: "_models.NetworkInterfaceConfiguration" = rest_field(
        name="networkInterfaceConfiguration"
    )
    """Network Interface Configuration Profile. Required."""

    @overload
    def __init__(
        self,
        *,
        network_interface_configuration: "_models.NetworkInterfaceConfiguration",
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ServerlessRuntimeNetworkProfileUpdate(_model_base.Model):
    """Informatica Serverless Network profile properties update.

    All required parameters must be populated in order to send to server.

    :ivar network_interface_configuration: Network Interface Configuration Profile Update.
     Required.
    :vartype network_interface_configuration:
     ~azure.mgmt.informaticadatamanagement.models.NetworkInterfaceConfigurationUpdate
    """

    network_interface_configuration: "_models.NetworkInterfaceConfigurationUpdate" = rest_field(
        name="networkInterfaceConfiguration"
    )
    """Network Interface Configuration Profile Update. Required."""

    @overload
    def __init__(
        self,
        *,
        network_interface_configuration: "_models.NetworkInterfaceConfigurationUpdate",
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ServerlessRuntimePropertiesCustomUpdate(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """Patchable Properties of the Informatica Serverless Runtime resource.

    :ivar description: description of the serverless runtime.
    :vartype description: str
    :ivar platform: Platform type of the Serverless Runtime. "AZURE"
    :vartype platform: str or ~azure.mgmt.informaticadatamanagement.models.PlatformType
    :ivar application_type: Application type of the Serverless Runtime environment. Known values
     are: "CDI" and "CDIE".
    :vartype application_type: str or ~azure.mgmt.informaticadatamanagement.models.ApplicationType
    :ivar compute_units: Compute units of the serverless runtime.
    :vartype compute_units: str
    :ivar execution_timeout: Serverless Execution timeout.
    :vartype execution_timeout: str
    :ivar serverless_account_location: Serverless account creation location.
    :vartype serverless_account_location: str
    :ivar serverless_runtime_network_profile: Informatica Serverless Network profile properties.
    :vartype serverless_runtime_network_profile:
     ~azure.mgmt.informaticadatamanagement.models.ServerlessRuntimeNetworkProfileUpdate
    :ivar advanced_custom_properties: String KV pairs indicating Advanced custom properties.
    :vartype advanced_custom_properties:
     list[~azure.mgmt.informaticadatamanagement.models.AdvancedCustomProperties]
    :ivar supplementary_file_location: Supplementary file location.
    :vartype supplementary_file_location: str
    :ivar serverless_runtime_config: Serverless config properties.
    :vartype serverless_runtime_config:
     ~azure.mgmt.informaticadatamanagement.models.ServerlessRuntimeConfigPropertiesUpdate
    :ivar serverless_runtime_tags: Serverless Runtime Tags.
    :vartype serverless_runtime_tags:
     list[~azure.mgmt.informaticadatamanagement.models.ServerlessRuntimeTag]
    :ivar serverless_runtime_user_context_properties: Serverless runtime user context properties.
    :vartype serverless_runtime_user_context_properties:
     ~azure.mgmt.informaticadatamanagement.models.ServerlessRuntimeUserContextPropertiesUpdate
    """

    description: Optional[str] = rest_field()
    """description of the serverless runtime."""
    platform: Optional[Union[str, "_models.PlatformType"]] = rest_field()
    """Platform type of the Serverless Runtime. \"AZURE\""""
    application_type: Optional[Union[str, "_models.ApplicationType"]] = rest_field(name="applicationType")
    """Application type of the Serverless Runtime environment. Known values are: \"CDI\" and \"CDIE\"."""
    compute_units: Optional[str] = rest_field(name="computeUnits")
    """Compute units of the serverless runtime."""
    execution_timeout: Optional[str] = rest_field(name="executionTimeout")
    """Serverless Execution timeout."""
    serverless_account_location: Optional[str] = rest_field(name="serverlessAccountLocation")
    """Serverless account creation location."""
    serverless_runtime_network_profile: Optional["_models.ServerlessRuntimeNetworkProfileUpdate"] = rest_field(
        name="serverlessRuntimeNetworkProfile"
    )
    """Informatica Serverless Network profile properties."""
    advanced_custom_properties: Optional[List["_models.AdvancedCustomProperties"]] = rest_field(
        name="advancedCustomProperties"
    )
    """String KV pairs indicating Advanced custom properties."""
    supplementary_file_location: Optional[str] = rest_field(name="supplementaryFileLocation")
    """Supplementary file location."""
    serverless_runtime_config: Optional["_models.ServerlessRuntimeConfigPropertiesUpdate"] = rest_field(
        name="serverlessRuntimeConfig"
    )
    """Serverless config properties."""
    serverless_runtime_tags: Optional[List["_models.ServerlessRuntimeTag"]] = rest_field(name="serverlessRuntimeTags")
    """Serverless Runtime Tags."""
    serverless_runtime_user_context_properties: Optional["_models.ServerlessRuntimeUserContextPropertiesUpdate"] = (
        rest_field(name="serverlessRuntimeUserContextProperties")
    )
    """Serverless runtime user context properties."""

    @overload
    def __init__(
        self,
        *,
        description: Optional[str] = None,
        platform: Optional[Union[str, "_models.PlatformType"]] = None,
        application_type: Optional[Union[str, "_models.ApplicationType"]] = None,
        compute_units: Optional[str] = None,
        execution_timeout: Optional[str] = None,
        serverless_account_location: Optional[str] = None,
        serverless_runtime_network_profile: Optional["_models.ServerlessRuntimeNetworkProfileUpdate"] = None,
        advanced_custom_properties: Optional[List["_models.AdvancedCustomProperties"]] = None,
        supplementary_file_location: Optional[str] = None,
        serverless_runtime_config: Optional["_models.ServerlessRuntimeConfigPropertiesUpdate"] = None,
        serverless_runtime_tags: Optional[List["_models.ServerlessRuntimeTag"]] = None,
        serverless_runtime_user_context_properties: Optional[
            "_models.ServerlessRuntimeUserContextPropertiesUpdate"
        ] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ServerlessRuntimeTag(_model_base.Model):
    """Serverless Runtime Tags.

    :ivar name: The name (also known as the key) of the tag.
    :vartype name: str
    :ivar value: The value of the tag.
    :vartype value: str
    """

    name: Optional[str] = rest_field()
    """The name (also known as the key) of the tag."""
    value: Optional[str] = rest_field()
    """The value of the tag."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ServerlessRuntimeUserContextProperties(_model_base.Model):
    """Informatica Serverless Runtime User context properties.

    All required parameters must be populated in order to send to server.

    :ivar user_context_token: User context token for OBO flow. Required.
    :vartype user_context_token: str
    """

    user_context_token: str = rest_field(name="userContextToken")
    """User context token for OBO flow. Required."""

    @overload
    def __init__(
        self,
        *,
        user_context_token: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ServerlessRuntimeUserContextPropertiesUpdate(_model_base.Model):  # pylint: disable=name-too-long
    """The template for adding optional properties.

    :ivar user_context_token: User context token for OBO flow.
    :vartype user_context_token: str
    """

    user_context_token: Optional[str] = rest_field(name="userContextToken")
    """User context token for OBO flow."""

    @overload
    def __init__(
        self,
        *,
        user_context_token: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SystemData(_model_base.Model):
    """Metadata pertaining to creation and last modification of the resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.informaticadatamanagement.models.CreatedByType
    :ivar created_at: The type of identity that created the resource.
    :vartype created_at: ~datetime.date
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.informaticadatamanagement.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.date
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.date] = rest_field(name="createdAt", visibility=["read"])
    """The type of identity that created the resource."""
    last_modified_by: Optional[str] = rest_field(name="lastModifiedBy", visibility=["read"])
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.date] = rest_field(name="lastModifiedAt", visibility=["read"])
    """The timestamp of resource last modification (UTC)."""


class UserDetails(_model_base.Model):
    """User Info of Informatica Organization resource.

    :ivar first_name: User first name.
    :vartype first_name: str
    :ivar last_name: User last name.
    :vartype last_name: str
    :ivar email_address: User email address.
    :vartype email_address: str
    :ivar upn: UPN of user.
    :vartype upn: str
    :ivar phone_number: Phone number of the user used by for contacting them if needed.
    :vartype phone_number: str
    """

    first_name: Optional[str] = rest_field(name="firstName")
    """User first name."""
    last_name: Optional[str] = rest_field(name="lastName")
    """User last name."""
    email_address: Optional[str] = rest_field(name="emailAddress")
    """User email address."""
    upn: Optional[str] = rest_field()
    """UPN of user."""
    phone_number: Optional[str] = rest_field(name="phoneNumber")
    """Phone number of the user used by for contacting them if needed."""

    @overload
    def __init__(
        self,
        *,
        first_name: Optional[str] = None,
        last_name: Optional[str] = None,
        email_address: Optional[str] = None,
        upn: Optional[str] = None,
        phone_number: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class UserDetailsUpdate(_model_base.Model):
    """User Info of Informatica Organization resource.

    :ivar first_name: User first name.
    :vartype first_name: str
    :ivar last_name: User last name.
    :vartype last_name: str
    :ivar email_address: User email address.
    :vartype email_address: str
    :ivar upn: UPN of user.
    :vartype upn: str
    :ivar phone_number: Phone number of the user used by for contacting them if needed.
    :vartype phone_number: str
    """

    first_name: Optional[str] = rest_field(name="firstName")
    """User first name."""
    last_name: Optional[str] = rest_field(name="lastName")
    """User last name."""
    email_address: Optional[str] = rest_field(name="emailAddress")
    """User email address."""
    upn: Optional[str] = rest_field()
    """UPN of user."""
    phone_number: Optional[str] = rest_field(name="phoneNumber")
    """Phone number of the user used by for contacting them if needed."""

    @overload
    def __init__(
        self,
        *,
        first_name: Optional[str] = None,
        last_name: Optional[str] = None,
        email_address: Optional[str] = None,
        upn: Optional[str] = None,
        phone_number: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)
