# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class ApplicationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Various application types of the Serverless Runtime environments."""

    CDI = "CDI"
    """Data Integration"""
    CDIE = "CDIE"
    """Advanced Data Integration"""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class PlatformType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Various types of the Platform types."""

    AZURE = "AZURE"
    """Azure platform type"""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning State of the Organization resource."""

    ACCEPTED = "Accepted"
    """Organization resource creation request accepted"""
    CREATING = "Creating"
    """Organization resource creation started"""
    UPDATING = "Updating"
    """Organization resource is being updated"""
    DELETING = "Deleting"
    """Organization resource deletion started"""
    SUCCEEDED = "Succeeded"
    """Organization resource creation successful"""
    FAILED = "Failed"
    """Organization resource creation failed"""
    CANCELED = "Canceled"
    """Organization resource creation canceled"""
    DELETED = "Deleted"
    """Organization resource is deleted"""
    NOT_SPECIFIED = "NotSpecified"
    """Organization resource state is unknown"""


class RuntimeType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Various types of the runtime types."""

    SERVERLESS = "SERVERLESS"
    """Serverless Runtime type"""
