# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import json
import sys
from typing import Any, AsyncIterable, Callable, Dict, IO, List, Optional, Type, TypeVar, Union, cast, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.async_arm_polling import AsyncARMPolling

from ... import models as _models
from ..._model_base import SdkJSONEncoder, _deserialize
from ...operations._operations import (
    build_operations_list_request,
    build_organizations_create_or_update_request,
    build_organizations_delete_request,
    build_organizations_get_all_serverless_runtimes_request,
    build_organizations_get_request,
    build_organizations_get_serverless_metadata_request,
    build_organizations_list_by_resource_group_request,
    build_organizations_list_by_subscription_request,
    build_organizations_update_request,
    build_serverless_runtimes_check_dependencies_request,
    build_serverless_runtimes_create_or_update_request,
    build_serverless_runtimes_delete_request,
    build_serverless_runtimes_get_request,
    build_serverless_runtimes_list_by_informatica_organization_resource_request,
    build_serverless_runtimes_serverless_resource_by_id_request,
    build_serverless_runtimes_start_failed_serverless_runtime_request,
    build_serverless_runtimes_update_request,
)

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class Operations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.informaticadatamanagement.aio.InformaticaDataMgmtClient`'s
        :attr:`operations` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(self, **kwargs: Any) -> AsyncIterable["_models.Operation"]:
        # pylint: disable=line-too-long
        """List the operations for the provider.

        :return: An iterator like instance of Operation
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.informaticadatamanagement.models.Operation]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "actionType": "str",  # Optional. Extensible enum. Indicates the action type.
                      "Internal" refers to actions that are for internal only APIs. "Internal"
                    "display": {
                        "description": "str",  # Optional. The short, localized friendly
                          description of the operation; suitable for tool tips and detailed views.
                        "operation": "str",  # Optional. The concise, localized friendly name
                          for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
                          Machine", "Restart Virtual Machine".
                        "provider": "str",  # Optional. The localized friendly form of the
                          resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
                          Compute".
                        "resource": "str"  # Optional. The localized friendly name of the
                          resource type related to this operation. E.g. "Virtual Machines" or "Job
                          Schedule Collections".
                    },
                    "isDataAction": bool,  # Optional. Whether the operation applies to
                      data-plane. This is "true" for data-plane operations and "false" for Azure
                      Resource Manager/control-plane operations.
                    "name": "str",  # Optional. The name of the operation, as per Resource-Based
                      Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
                      "Microsoft.Compute/virtualMachines/capture/action".
                    "origin": "str"  # Optional. The intended executor of the operation; as in
                      Resource Based Access Control (RBAC) and audit logs UX. Default value is
                      "user,system". Known values are: "user", "system", and "user,system".
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.Operation]] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_operations_list_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.Operation], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _deserialize(_models.ErrorResponse, response.json())
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class OrganizationsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.informaticadatamanagement.aio.InformaticaDataMgmtClient`'s
        :attr:`organizations` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, organization_name: str, **kwargs: Any
    ) -> _models.InformaticaOrganizationResource:
        # pylint: disable=line-too-long
        """Get a InformaticaOrganizationResource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Name of the Organizations resource. Required.
        :type organization_name: str
        :return: InformaticaOrganizationResource. The InformaticaOrganizationResource is compatible
         with MutableMapping
        :rtype: ~azure.mgmt.informaticadatamanagement.models.InformaticaOrganizationResource
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "location": "str",  # The geo-location where the resource lives. Required.
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "companyDetails": {
                            "business": "str",  # Optional. Business phone number.
                            "companyName": "str",  # Optional. company Name.
                            "country": "str",  # Optional. Country name.
                            "domain": "str",  # Optional. Domain name.
                            "numberOfEmployees": 0,  # Optional. Number Of Employees.
                            "officeAddress": "str"  # Optional. Office Address.
                        },
                        "informaticaProperties": {
                            "informaticaRegion": "str",  # Optional. Informatica
                              organization region.
                            "organizationId": "str",  # Optional. Organization id.
                            "organizationName": "str",  # Optional. Organization name.
                            "singleSignOnUrl": "str"  # Optional. Single sing on URL for
                              informatica organization.
                        },
                        "linkOrganization": {
                            "token": "str"  # Optional. Link organization token.
                        },
                        "marketplaceDetails": {
                            "marketplaceSubscriptionId": "str",  # Marketplace
                              Subscription Id. Required.
                            "offerDetails": {
                                "offerId": "str",  # Id of the product offering.
                                  Required.
                                "planId": "str",  # Id of the product offer plan.
                                  Required.
                                "planName": "str",  # Name of the product offer plan.
                                  Required.
                                "publisherId": "str",  # Id of the product publisher.
                                  Required.
                                "termId": "str",  # Offer plan term id. Required.
                                "termUnit": "str"  # Optional. Offer plan term unit.
                            }
                        },
                        "provisioningState": "str",  # Optional. Provisioning State of the
                          resource. Known values are: "Accepted", "Creating", "Updating", "Deleting",
                          "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
                        "userDetails": {
                            "emailAddress": "str",  # Optional. User email address.
                            "firstName": "str",  # Optional. User first name.
                            "lastName": "str",  # Optional. User last name.
                            "phoneNumber": "str",  # Optional. Phone number of the user
                              used by for contacting them if needed.
                            "upn": "str"  # Optional. UPN of user.
                        }
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "tags": {
                        "str": "str"  # Optional. Resource tags.
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.InformaticaOrganizationResource] = kwargs.pop("cls", None)

        _request = build_organizations_get_request(
            resource_group_name=resource_group_name,
            organization_name=organization_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.InformaticaOrganizationResource, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_or_update_initial(
        self,
        resource_group_name: str,
        organization_name: str,
        resource: Union[_models.InformaticaOrganizationResource, JSON, IO[bytes]],
        **kwargs: Any
    ) -> JSON:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(resource, (IOBase, bytes)):
            _content = resource
        else:
            _content = json.dumps(resource, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_organizations_create_or_update_request(
            resource_group_name=resource_group_name,
            organization_name=organization_name,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 200:
            deserialized = _deserialize(JSON, response.json())

        if response.status_code == 201:
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

            deserialized = _deserialize(JSON, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        organization_name: str,
        resource: _models.InformaticaOrganizationResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.InformaticaOrganizationResource]:
        # pylint: disable=line-too-long
        """Create a InformaticaOrganizationResource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Name of the Organizations resource. Required.
        :type organization_name: str
        :param resource: Resource create parameters. Required.
        :type resource: ~azure.mgmt.informaticadatamanagement.models.InformaticaOrganizationResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns InformaticaOrganizationResource. The
         InformaticaOrganizationResource is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.informaticadatamanagement.models.InformaticaOrganizationResource]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                resource = {
                    "location": "str",  # The geo-location where the resource lives. Required.
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "companyDetails": {
                            "business": "str",  # Optional. Business phone number.
                            "companyName": "str",  # Optional. company Name.
                            "country": "str",  # Optional. Country name.
                            "domain": "str",  # Optional. Domain name.
                            "numberOfEmployees": 0,  # Optional. Number Of Employees.
                            "officeAddress": "str"  # Optional. Office Address.
                        },
                        "informaticaProperties": {
                            "informaticaRegion": "str",  # Optional. Informatica
                              organization region.
                            "organizationId": "str",  # Optional. Organization id.
                            "organizationName": "str",  # Optional. Organization name.
                            "singleSignOnUrl": "str"  # Optional. Single sing on URL for
                              informatica organization.
                        },
                        "linkOrganization": {
                            "token": "str"  # Optional. Link organization token.
                        },
                        "marketplaceDetails": {
                            "marketplaceSubscriptionId": "str",  # Marketplace
                              Subscription Id. Required.
                            "offerDetails": {
                                "offerId": "str",  # Id of the product offering.
                                  Required.
                                "planId": "str",  # Id of the product offer plan.
                                  Required.
                                "planName": "str",  # Name of the product offer plan.
                                  Required.
                                "publisherId": "str",  # Id of the product publisher.
                                  Required.
                                "termId": "str",  # Offer plan term id. Required.
                                "termUnit": "str"  # Optional. Offer plan term unit.
                            }
                        },
                        "provisioningState": "str",  # Optional. Provisioning State of the
                          resource. Known values are: "Accepted", "Creating", "Updating", "Deleting",
                          "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
                        "userDetails": {
                            "emailAddress": "str",  # Optional. User email address.
                            "firstName": "str",  # Optional. User first name.
                            "lastName": "str",  # Optional. User last name.
                            "phoneNumber": "str",  # Optional. Phone number of the user
                              used by for contacting them if needed.
                            "upn": "str"  # Optional. UPN of user.
                        }
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "tags": {
                        "str": "str"  # Optional. Resource tags.
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }

                # response body for status code(s): 200, 201
                response == {
                    "location": "str",  # The geo-location where the resource lives. Required.
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "companyDetails": {
                            "business": "str",  # Optional. Business phone number.
                            "companyName": "str",  # Optional. company Name.
                            "country": "str",  # Optional. Country name.
                            "domain": "str",  # Optional. Domain name.
                            "numberOfEmployees": 0,  # Optional. Number Of Employees.
                            "officeAddress": "str"  # Optional. Office Address.
                        },
                        "informaticaProperties": {
                            "informaticaRegion": "str",  # Optional. Informatica
                              organization region.
                            "organizationId": "str",  # Optional. Organization id.
                            "organizationName": "str",  # Optional. Organization name.
                            "singleSignOnUrl": "str"  # Optional. Single sing on URL for
                              informatica organization.
                        },
                        "linkOrganization": {
                            "token": "str"  # Optional. Link organization token.
                        },
                        "marketplaceDetails": {
                            "marketplaceSubscriptionId": "str",  # Marketplace
                              Subscription Id. Required.
                            "offerDetails": {
                                "offerId": "str",  # Id of the product offering.
                                  Required.
                                "planId": "str",  # Id of the product offer plan.
                                  Required.
                                "planName": "str",  # Name of the product offer plan.
                                  Required.
                                "publisherId": "str",  # Id of the product publisher.
                                  Required.
                                "termId": "str",  # Offer plan term id. Required.
                                "termUnit": "str"  # Optional. Offer plan term unit.
                            }
                        },
                        "provisioningState": "str",  # Optional. Provisioning State of the
                          resource. Known values are: "Accepted", "Creating", "Updating", "Deleting",
                          "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
                        "userDetails": {
                            "emailAddress": "str",  # Optional. User email address.
                            "firstName": "str",  # Optional. User first name.
                            "lastName": "str",  # Optional. User last name.
                            "phoneNumber": "str",  # Optional. Phone number of the user
                              used by for contacting them if needed.
                            "upn": "str"  # Optional. UPN of user.
                        }
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "tags": {
                        "str": "str"  # Optional. Resource tags.
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        organization_name: str,
        resource: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.InformaticaOrganizationResource]:
        # pylint: disable=line-too-long
        """Create a InformaticaOrganizationResource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Name of the Organizations resource. Required.
        :type organization_name: str
        :param resource: Resource create parameters. Required.
        :type resource: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns InformaticaOrganizationResource. The
         InformaticaOrganizationResource is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.informaticadatamanagement.models.InformaticaOrganizationResource]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "location": "str",  # The geo-location where the resource lives. Required.
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "companyDetails": {
                            "business": "str",  # Optional. Business phone number.
                            "companyName": "str",  # Optional. company Name.
                            "country": "str",  # Optional. Country name.
                            "domain": "str",  # Optional. Domain name.
                            "numberOfEmployees": 0,  # Optional. Number Of Employees.
                            "officeAddress": "str"  # Optional. Office Address.
                        },
                        "informaticaProperties": {
                            "informaticaRegion": "str",  # Optional. Informatica
                              organization region.
                            "organizationId": "str",  # Optional. Organization id.
                            "organizationName": "str",  # Optional. Organization name.
                            "singleSignOnUrl": "str"  # Optional. Single sing on URL for
                              informatica organization.
                        },
                        "linkOrganization": {
                            "token": "str"  # Optional. Link organization token.
                        },
                        "marketplaceDetails": {
                            "marketplaceSubscriptionId": "str",  # Marketplace
                              Subscription Id. Required.
                            "offerDetails": {
                                "offerId": "str",  # Id of the product offering.
                                  Required.
                                "planId": "str",  # Id of the product offer plan.
                                  Required.
                                "planName": "str",  # Name of the product offer plan.
                                  Required.
                                "publisherId": "str",  # Id of the product publisher.
                                  Required.
                                "termId": "str",  # Offer plan term id. Required.
                                "termUnit": "str"  # Optional. Offer plan term unit.
                            }
                        },
                        "provisioningState": "str",  # Optional. Provisioning State of the
                          resource. Known values are: "Accepted", "Creating", "Updating", "Deleting",
                          "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
                        "userDetails": {
                            "emailAddress": "str",  # Optional. User email address.
                            "firstName": "str",  # Optional. User first name.
                            "lastName": "str",  # Optional. User last name.
                            "phoneNumber": "str",  # Optional. Phone number of the user
                              used by for contacting them if needed.
                            "upn": "str"  # Optional. UPN of user.
                        }
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "tags": {
                        "str": "str"  # Optional. Resource tags.
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        organization_name: str,
        resource: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.InformaticaOrganizationResource]:
        # pylint: disable=line-too-long
        """Create a InformaticaOrganizationResource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Name of the Organizations resource. Required.
        :type organization_name: str
        :param resource: Resource create parameters. Required.
        :type resource: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns InformaticaOrganizationResource. The
         InformaticaOrganizationResource is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.informaticadatamanagement.models.InformaticaOrganizationResource]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "location": "str",  # The geo-location where the resource lives. Required.
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "companyDetails": {
                            "business": "str",  # Optional. Business phone number.
                            "companyName": "str",  # Optional. company Name.
                            "country": "str",  # Optional. Country name.
                            "domain": "str",  # Optional. Domain name.
                            "numberOfEmployees": 0,  # Optional. Number Of Employees.
                            "officeAddress": "str"  # Optional. Office Address.
                        },
                        "informaticaProperties": {
                            "informaticaRegion": "str",  # Optional. Informatica
                              organization region.
                            "organizationId": "str",  # Optional. Organization id.
                            "organizationName": "str",  # Optional. Organization name.
                            "singleSignOnUrl": "str"  # Optional. Single sing on URL for
                              informatica organization.
                        },
                        "linkOrganization": {
                            "token": "str"  # Optional. Link organization token.
                        },
                        "marketplaceDetails": {
                            "marketplaceSubscriptionId": "str",  # Marketplace
                              Subscription Id. Required.
                            "offerDetails": {
                                "offerId": "str",  # Id of the product offering.
                                  Required.
                                "planId": "str",  # Id of the product offer plan.
                                  Required.
                                "planName": "str",  # Name of the product offer plan.
                                  Required.
                                "publisherId": "str",  # Id of the product publisher.
                                  Required.
                                "termId": "str",  # Offer plan term id. Required.
                                "termUnit": "str"  # Optional. Offer plan term unit.
                            }
                        },
                        "provisioningState": "str",  # Optional. Provisioning State of the
                          resource. Known values are: "Accepted", "Creating", "Updating", "Deleting",
                          "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
                        "userDetails": {
                            "emailAddress": "str",  # Optional. User email address.
                            "firstName": "str",  # Optional. User first name.
                            "lastName": "str",  # Optional. User last name.
                            "phoneNumber": "str",  # Optional. Phone number of the user
                              used by for contacting them if needed.
                            "upn": "str"  # Optional. UPN of user.
                        }
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "tags": {
                        "str": "str"  # Optional. Resource tags.
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        organization_name: str,
        resource: Union[_models.InformaticaOrganizationResource, JSON, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.InformaticaOrganizationResource]:
        # pylint: disable=line-too-long
        """Create a InformaticaOrganizationResource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Name of the Organizations resource. Required.
        :type organization_name: str
        :param resource: Resource create parameters. Is one of the following types:
         InformaticaOrganizationResource, JSON, IO[bytes] Required.
        :type resource: ~azure.mgmt.informaticadatamanagement.models.InformaticaOrganizationResource or
         JSON or IO[bytes]
        :return: An instance of AsyncLROPoller that returns InformaticaOrganizationResource. The
         InformaticaOrganizationResource is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.informaticadatamanagement.models.InformaticaOrganizationResource]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                resource = {
                    "location": "str",  # The geo-location where the resource lives. Required.
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "companyDetails": {
                            "business": "str",  # Optional. Business phone number.
                            "companyName": "str",  # Optional. company Name.
                            "country": "str",  # Optional. Country name.
                            "domain": "str",  # Optional. Domain name.
                            "numberOfEmployees": 0,  # Optional. Number Of Employees.
                            "officeAddress": "str"  # Optional. Office Address.
                        },
                        "informaticaProperties": {
                            "informaticaRegion": "str",  # Optional. Informatica
                              organization region.
                            "organizationId": "str",  # Optional. Organization id.
                            "organizationName": "str",  # Optional. Organization name.
                            "singleSignOnUrl": "str"  # Optional. Single sing on URL for
                              informatica organization.
                        },
                        "linkOrganization": {
                            "token": "str"  # Optional. Link organization token.
                        },
                        "marketplaceDetails": {
                            "marketplaceSubscriptionId": "str",  # Marketplace
                              Subscription Id. Required.
                            "offerDetails": {
                                "offerId": "str",  # Id of the product offering.
                                  Required.
                                "planId": "str",  # Id of the product offer plan.
                                  Required.
                                "planName": "str",  # Name of the product offer plan.
                                  Required.
                                "publisherId": "str",  # Id of the product publisher.
                                  Required.
                                "termId": "str",  # Offer plan term id. Required.
                                "termUnit": "str"  # Optional. Offer plan term unit.
                            }
                        },
                        "provisioningState": "str",  # Optional. Provisioning State of the
                          resource. Known values are: "Accepted", "Creating", "Updating", "Deleting",
                          "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
                        "userDetails": {
                            "emailAddress": "str",  # Optional. User email address.
                            "firstName": "str",  # Optional. User first name.
                            "lastName": "str",  # Optional. User last name.
                            "phoneNumber": "str",  # Optional. Phone number of the user
                              used by for contacting them if needed.
                            "upn": "str"  # Optional. UPN of user.
                        }
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "tags": {
                        "str": "str"  # Optional. Resource tags.
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }

                # response body for status code(s): 200, 201
                response == {
                    "location": "str",  # The geo-location where the resource lives. Required.
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "companyDetails": {
                            "business": "str",  # Optional. Business phone number.
                            "companyName": "str",  # Optional. company Name.
                            "country": "str",  # Optional. Country name.
                            "domain": "str",  # Optional. Domain name.
                            "numberOfEmployees": 0,  # Optional. Number Of Employees.
                            "officeAddress": "str"  # Optional. Office Address.
                        },
                        "informaticaProperties": {
                            "informaticaRegion": "str",  # Optional. Informatica
                              organization region.
                            "organizationId": "str",  # Optional. Organization id.
                            "organizationName": "str",  # Optional. Organization name.
                            "singleSignOnUrl": "str"  # Optional. Single sing on URL for
                              informatica organization.
                        },
                        "linkOrganization": {
                            "token": "str"  # Optional. Link organization token.
                        },
                        "marketplaceDetails": {
                            "marketplaceSubscriptionId": "str",  # Marketplace
                              Subscription Id. Required.
                            "offerDetails": {
                                "offerId": "str",  # Id of the product offering.
                                  Required.
                                "planId": "str",  # Id of the product offer plan.
                                  Required.
                                "planName": "str",  # Name of the product offer plan.
                                  Required.
                                "publisherId": "str",  # Id of the product publisher.
                                  Required.
                                "termId": "str",  # Offer plan term id. Required.
                                "termUnit": "str"  # Optional. Offer plan term unit.
                            }
                        },
                        "provisioningState": "str",  # Optional. Provisioning State of the
                          resource. Known values are: "Accepted", "Creating", "Updating", "Deleting",
                          "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
                        "userDetails": {
                            "emailAddress": "str",  # Optional. User email address.
                            "firstName": "str",  # Optional. User first name.
                            "lastName": "str",  # Optional. User last name.
                            "phoneNumber": "str",  # Optional. Phone number of the user
                              used by for contacting them if needed.
                            "upn": "str"  # Optional. UPN of user.
                        }
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "tags": {
                        "str": "str"  # Optional. Resource tags.
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.InformaticaOrganizationResource] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                organization_name=organization_name,
                resource=resource,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = _deserialize(_models.InformaticaOrganizationResource, response.json())
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.InformaticaOrganizationResource].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.InformaticaOrganizationResource](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @overload
    async def update(
        self,
        resource_group_name: str,
        organization_name: str,
        properties: _models.InformaticaOrganizationResourceUpdate,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.InformaticaOrganizationResource:
        # pylint: disable=line-too-long
        """Update a InformaticaOrganizationResource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Name of the Organizations resource. Required.
        :type organization_name: str
        :param properties: The resource properties to be updated. Required.
        :type properties:
         ~azure.mgmt.informaticadatamanagement.models.InformaticaOrganizationResourceUpdate
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: InformaticaOrganizationResource. The InformaticaOrganizationResource is compatible
         with MutableMapping
        :rtype: ~azure.mgmt.informaticadatamanagement.models.InformaticaOrganizationResource
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                properties = {
                    "properties": {
                        "companyDetails": {
                            "business": "str",  # Optional. Business phone number.
                            "companyName": "str",  # Optional. company Name.
                            "country": "str",  # Optional. Country name.
                            "domain": "str",  # Optional. Domain name.
                            "numberOfEmployees": 0,  # Optional. Number Of Employees.
                            "officeAddress": "str"  # Optional. Office Address.
                        },
                        "existingResourceId": "str",  # Optional. Existing Resource Id.
                        "informaticaOrganizationProperties": ...,
                        "marketplaceDetails": {
                            "marketplaceSubscriptionId": "str",  # Optional. Marketplace
                              Subscription Id.
                            "offerDetails": {
                                "offerId": "str",  # Optional. Id of the product
                                  offering.
                                "planId": "str",  # Optional. Id of the product offer
                                  plan.
                                "planName": "str",  # Optional. Name of the product
                                  offer plan.
                                "publisherId": "str",  # Optional. Id of the product
                                  publisher.
                                "termId": "str",  # Optional. Offer plan term id.
                                "termUnit": "str"  # Optional. Offer plan term unit.
                            }
                        },
                        "userDetails": {
                            "emailAddress": "str",  # Optional. User email address.
                            "firstName": "str",  # Optional. User first name.
                            "lastName": "str",  # Optional. User last name.
                            "phoneNumber": "str",  # Optional. Phone number of the user
                              used by for contacting them if needed.
                            "upn": "str"  # Optional. UPN of user.
                        }
                    },
                    "tags": {
                        "str": "str"  # Optional. Resource tags.
                    }
                }

                # response body for status code(s): 200
                response == {
                    "location": "str",  # The geo-location where the resource lives. Required.
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "companyDetails": {
                            "business": "str",  # Optional. Business phone number.
                            "companyName": "str",  # Optional. company Name.
                            "country": "str",  # Optional. Country name.
                            "domain": "str",  # Optional. Domain name.
                            "numberOfEmployees": 0,  # Optional. Number Of Employees.
                            "officeAddress": "str"  # Optional. Office Address.
                        },
                        "informaticaProperties": {
                            "informaticaRegion": "str",  # Optional. Informatica
                              organization region.
                            "organizationId": "str",  # Optional. Organization id.
                            "organizationName": "str",  # Optional. Organization name.
                            "singleSignOnUrl": "str"  # Optional. Single sing on URL for
                              informatica organization.
                        },
                        "linkOrganization": {
                            "token": "str"  # Optional. Link organization token.
                        },
                        "marketplaceDetails": {
                            "marketplaceSubscriptionId": "str",  # Marketplace
                              Subscription Id. Required.
                            "offerDetails": {
                                "offerId": "str",  # Id of the product offering.
                                  Required.
                                "planId": "str",  # Id of the product offer plan.
                                  Required.
                                "planName": "str",  # Name of the product offer plan.
                                  Required.
                                "publisherId": "str",  # Id of the product publisher.
                                  Required.
                                "termId": "str",  # Offer plan term id. Required.
                                "termUnit": "str"  # Optional. Offer plan term unit.
                            }
                        },
                        "provisioningState": "str",  # Optional. Provisioning State of the
                          resource. Known values are: "Accepted", "Creating", "Updating", "Deleting",
                          "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
                        "userDetails": {
                            "emailAddress": "str",  # Optional. User email address.
                            "firstName": "str",  # Optional. User first name.
                            "lastName": "str",  # Optional. User last name.
                            "phoneNumber": "str",  # Optional. Phone number of the user
                              used by for contacting them if needed.
                            "upn": "str"  # Optional. UPN of user.
                        }
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "tags": {
                        "str": "str"  # Optional. Resource tags.
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """

    @overload
    async def update(
        self,
        resource_group_name: str,
        organization_name: str,
        properties: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.InformaticaOrganizationResource:
        # pylint: disable=line-too-long
        """Update a InformaticaOrganizationResource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Name of the Organizations resource. Required.
        :type organization_name: str
        :param properties: The resource properties to be updated. Required.
        :type properties: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: InformaticaOrganizationResource. The InformaticaOrganizationResource is compatible
         with MutableMapping
        :rtype: ~azure.mgmt.informaticadatamanagement.models.InformaticaOrganizationResource
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "location": "str",  # The geo-location where the resource lives. Required.
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "companyDetails": {
                            "business": "str",  # Optional. Business phone number.
                            "companyName": "str",  # Optional. company Name.
                            "country": "str",  # Optional. Country name.
                            "domain": "str",  # Optional. Domain name.
                            "numberOfEmployees": 0,  # Optional. Number Of Employees.
                            "officeAddress": "str"  # Optional. Office Address.
                        },
                        "informaticaProperties": {
                            "informaticaRegion": "str",  # Optional. Informatica
                              organization region.
                            "organizationId": "str",  # Optional. Organization id.
                            "organizationName": "str",  # Optional. Organization name.
                            "singleSignOnUrl": "str"  # Optional. Single sing on URL for
                              informatica organization.
                        },
                        "linkOrganization": {
                            "token": "str"  # Optional. Link organization token.
                        },
                        "marketplaceDetails": {
                            "marketplaceSubscriptionId": "str",  # Marketplace
                              Subscription Id. Required.
                            "offerDetails": {
                                "offerId": "str",  # Id of the product offering.
                                  Required.
                                "planId": "str",  # Id of the product offer plan.
                                  Required.
                                "planName": "str",  # Name of the product offer plan.
                                  Required.
                                "publisherId": "str",  # Id of the product publisher.
                                  Required.
                                "termId": "str",  # Offer plan term id. Required.
                                "termUnit": "str"  # Optional. Offer plan term unit.
                            }
                        },
                        "provisioningState": "str",  # Optional. Provisioning State of the
                          resource. Known values are: "Accepted", "Creating", "Updating", "Deleting",
                          "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
                        "userDetails": {
                            "emailAddress": "str",  # Optional. User email address.
                            "firstName": "str",  # Optional. User first name.
                            "lastName": "str",  # Optional. User last name.
                            "phoneNumber": "str",  # Optional. Phone number of the user
                              used by for contacting them if needed.
                            "upn": "str"  # Optional. UPN of user.
                        }
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "tags": {
                        "str": "str"  # Optional. Resource tags.
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """

    @overload
    async def update(
        self,
        resource_group_name: str,
        organization_name: str,
        properties: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.InformaticaOrganizationResource:
        # pylint: disable=line-too-long
        """Update a InformaticaOrganizationResource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Name of the Organizations resource. Required.
        :type organization_name: str
        :param properties: The resource properties to be updated. Required.
        :type properties: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: InformaticaOrganizationResource. The InformaticaOrganizationResource is compatible
         with MutableMapping
        :rtype: ~azure.mgmt.informaticadatamanagement.models.InformaticaOrganizationResource
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "location": "str",  # The geo-location where the resource lives. Required.
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "companyDetails": {
                            "business": "str",  # Optional. Business phone number.
                            "companyName": "str",  # Optional. company Name.
                            "country": "str",  # Optional. Country name.
                            "domain": "str",  # Optional. Domain name.
                            "numberOfEmployees": 0,  # Optional. Number Of Employees.
                            "officeAddress": "str"  # Optional. Office Address.
                        },
                        "informaticaProperties": {
                            "informaticaRegion": "str",  # Optional. Informatica
                              organization region.
                            "organizationId": "str",  # Optional. Organization id.
                            "organizationName": "str",  # Optional. Organization name.
                            "singleSignOnUrl": "str"  # Optional. Single sing on URL for
                              informatica organization.
                        },
                        "linkOrganization": {
                            "token": "str"  # Optional. Link organization token.
                        },
                        "marketplaceDetails": {
                            "marketplaceSubscriptionId": "str",  # Marketplace
                              Subscription Id. Required.
                            "offerDetails": {
                                "offerId": "str",  # Id of the product offering.
                                  Required.
                                "planId": "str",  # Id of the product offer plan.
                                  Required.
                                "planName": "str",  # Name of the product offer plan.
                                  Required.
                                "publisherId": "str",  # Id of the product publisher.
                                  Required.
                                "termId": "str",  # Offer plan term id. Required.
                                "termUnit": "str"  # Optional. Offer plan term unit.
                            }
                        },
                        "provisioningState": "str",  # Optional. Provisioning State of the
                          resource. Known values are: "Accepted", "Creating", "Updating", "Deleting",
                          "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
                        "userDetails": {
                            "emailAddress": "str",  # Optional. User email address.
                            "firstName": "str",  # Optional. User first name.
                            "lastName": "str",  # Optional. User last name.
                            "phoneNumber": "str",  # Optional. Phone number of the user
                              used by for contacting them if needed.
                            "upn": "str"  # Optional. UPN of user.
                        }
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "tags": {
                        "str": "str"  # Optional. Resource tags.
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """

    @distributed_trace_async
    async def update(
        self,
        resource_group_name: str,
        organization_name: str,
        properties: Union[_models.InformaticaOrganizationResourceUpdate, JSON, IO[bytes]],
        **kwargs: Any
    ) -> _models.InformaticaOrganizationResource:
        # pylint: disable=line-too-long
        """Update a InformaticaOrganizationResource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Name of the Organizations resource. Required.
        :type organization_name: str
        :param properties: The resource properties to be updated. Is one of the following types:
         InformaticaOrganizationResourceUpdate, JSON, IO[bytes] Required.
        :type properties:
         ~azure.mgmt.informaticadatamanagement.models.InformaticaOrganizationResourceUpdate or JSON or
         IO[bytes]
        :return: InformaticaOrganizationResource. The InformaticaOrganizationResource is compatible
         with MutableMapping
        :rtype: ~azure.mgmt.informaticadatamanagement.models.InformaticaOrganizationResource
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                properties = {
                    "properties": {
                        "companyDetails": {
                            "business": "str",  # Optional. Business phone number.
                            "companyName": "str",  # Optional. company Name.
                            "country": "str",  # Optional. Country name.
                            "domain": "str",  # Optional. Domain name.
                            "numberOfEmployees": 0,  # Optional. Number Of Employees.
                            "officeAddress": "str"  # Optional. Office Address.
                        },
                        "existingResourceId": "str",  # Optional. Existing Resource Id.
                        "informaticaOrganizationProperties": ...,
                        "marketplaceDetails": {
                            "marketplaceSubscriptionId": "str",  # Optional. Marketplace
                              Subscription Id.
                            "offerDetails": {
                                "offerId": "str",  # Optional. Id of the product
                                  offering.
                                "planId": "str",  # Optional. Id of the product offer
                                  plan.
                                "planName": "str",  # Optional. Name of the product
                                  offer plan.
                                "publisherId": "str",  # Optional. Id of the product
                                  publisher.
                                "termId": "str",  # Optional. Offer plan term id.
                                "termUnit": "str"  # Optional. Offer plan term unit.
                            }
                        },
                        "userDetails": {
                            "emailAddress": "str",  # Optional. User email address.
                            "firstName": "str",  # Optional. User first name.
                            "lastName": "str",  # Optional. User last name.
                            "phoneNumber": "str",  # Optional. Phone number of the user
                              used by for contacting them if needed.
                            "upn": "str"  # Optional. UPN of user.
                        }
                    },
                    "tags": {
                        "str": "str"  # Optional. Resource tags.
                    }
                }

                # response body for status code(s): 200
                response == {
                    "location": "str",  # The geo-location where the resource lives. Required.
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "companyDetails": {
                            "business": "str",  # Optional. Business phone number.
                            "companyName": "str",  # Optional. company Name.
                            "country": "str",  # Optional. Country name.
                            "domain": "str",  # Optional. Domain name.
                            "numberOfEmployees": 0,  # Optional. Number Of Employees.
                            "officeAddress": "str"  # Optional. Office Address.
                        },
                        "informaticaProperties": {
                            "informaticaRegion": "str",  # Optional. Informatica
                              organization region.
                            "organizationId": "str",  # Optional. Organization id.
                            "organizationName": "str",  # Optional. Organization name.
                            "singleSignOnUrl": "str"  # Optional. Single sing on URL for
                              informatica organization.
                        },
                        "linkOrganization": {
                            "token": "str"  # Optional. Link organization token.
                        },
                        "marketplaceDetails": {
                            "marketplaceSubscriptionId": "str",  # Marketplace
                              Subscription Id. Required.
                            "offerDetails": {
                                "offerId": "str",  # Id of the product offering.
                                  Required.
                                "planId": "str",  # Id of the product offer plan.
                                  Required.
                                "planName": "str",  # Name of the product offer plan.
                                  Required.
                                "publisherId": "str",  # Id of the product publisher.
                                  Required.
                                "termId": "str",  # Offer plan term id. Required.
                                "termUnit": "str"  # Optional. Offer plan term unit.
                            }
                        },
                        "provisioningState": "str",  # Optional. Provisioning State of the
                          resource. Known values are: "Accepted", "Creating", "Updating", "Deleting",
                          "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
                        "userDetails": {
                            "emailAddress": "str",  # Optional. User email address.
                            "firstName": "str",  # Optional. User first name.
                            "lastName": "str",  # Optional. User last name.
                            "phoneNumber": "str",  # Optional. Phone number of the user
                              used by for contacting them if needed.
                            "upn": "str"  # Optional. UPN of user.
                        }
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "tags": {
                        "str": "str"  # Optional. Resource tags.
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.InformaticaOrganizationResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(properties, (IOBase, bytes)):
            _content = properties
        else:
            _content = json.dumps(properties, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_organizations_update_request(
            resource_group_name=resource_group_name,
            organization_name=organization_name,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.InformaticaOrganizationResource, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, organization_name: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_organizations_delete_request(
            resource_group_name=resource_group_name,
            organization_name=organization_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202, 204]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace_async
    async def begin_delete(
        self, resource_group_name: str, organization_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Delete a InformaticaOrganizationResource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Name of the Organizations resource. Required.
        :type organization_name: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(  # type: ignore
                resource_group_name=resource_group_name,
                organization_name=organization_name,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace
    def list_by_resource_group(
        self, resource_group_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.InformaticaOrganizationResource"]:
        # pylint: disable=line-too-long
        """List InformaticaOrganizationResource resources by resource group.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :return: An iterator like instance of InformaticaOrganizationResource
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.informaticadatamanagement.models.InformaticaOrganizationResource]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "location": "str",  # The geo-location where the resource lives. Required.
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "companyDetails": {
                            "business": "str",  # Optional. Business phone number.
                            "companyName": "str",  # Optional. company Name.
                            "country": "str",  # Optional. Country name.
                            "domain": "str",  # Optional. Domain name.
                            "numberOfEmployees": 0,  # Optional. Number Of Employees.
                            "officeAddress": "str"  # Optional. Office Address.
                        },
                        "informaticaProperties": {
                            "informaticaRegion": "str",  # Optional. Informatica
                              organization region.
                            "organizationId": "str",  # Optional. Organization id.
                            "organizationName": "str",  # Optional. Organization name.
                            "singleSignOnUrl": "str"  # Optional. Single sing on URL for
                              informatica organization.
                        },
                        "linkOrganization": {
                            "token": "str"  # Optional. Link organization token.
                        },
                        "marketplaceDetails": {
                            "marketplaceSubscriptionId": "str",  # Marketplace
                              Subscription Id. Required.
                            "offerDetails": {
                                "offerId": "str",  # Id of the product offering.
                                  Required.
                                "planId": "str",  # Id of the product offer plan.
                                  Required.
                                "planName": "str",  # Name of the product offer plan.
                                  Required.
                                "publisherId": "str",  # Id of the product publisher.
                                  Required.
                                "termId": "str",  # Offer plan term id. Required.
                                "termUnit": "str"  # Optional. Offer plan term unit.
                            }
                        },
                        "provisioningState": "str",  # Optional. Provisioning State of the
                          resource. Known values are: "Accepted", "Creating", "Updating", "Deleting",
                          "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
                        "userDetails": {
                            "emailAddress": "str",  # Optional. User email address.
                            "firstName": "str",  # Optional. User first name.
                            "lastName": "str",  # Optional. User last name.
                            "phoneNumber": "str",  # Optional. Phone number of the user
                              used by for contacting them if needed.
                            "upn": "str"  # Optional. UPN of user.
                        }
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "tags": {
                        "str": "str"  # Optional. Resource tags.
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.InformaticaOrganizationResource]] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_organizations_list_by_resource_group_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.InformaticaOrganizationResource], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _deserialize(_models.ErrorResponse, response.json())
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_by_subscription(self, **kwargs: Any) -> AsyncIterable["_models.InformaticaOrganizationResource"]:
        # pylint: disable=line-too-long
        """List InformaticaOrganizationResource resources by subscription ID.

        :return: An iterator like instance of InformaticaOrganizationResource
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.informaticadatamanagement.models.InformaticaOrganizationResource]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "location": "str",  # The geo-location where the resource lives. Required.
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "companyDetails": {
                            "business": "str",  # Optional. Business phone number.
                            "companyName": "str",  # Optional. company Name.
                            "country": "str",  # Optional. Country name.
                            "domain": "str",  # Optional. Domain name.
                            "numberOfEmployees": 0,  # Optional. Number Of Employees.
                            "officeAddress": "str"  # Optional. Office Address.
                        },
                        "informaticaProperties": {
                            "informaticaRegion": "str",  # Optional. Informatica
                              organization region.
                            "organizationId": "str",  # Optional. Organization id.
                            "organizationName": "str",  # Optional. Organization name.
                            "singleSignOnUrl": "str"  # Optional. Single sing on URL for
                              informatica organization.
                        },
                        "linkOrganization": {
                            "token": "str"  # Optional. Link organization token.
                        },
                        "marketplaceDetails": {
                            "marketplaceSubscriptionId": "str",  # Marketplace
                              Subscription Id. Required.
                            "offerDetails": {
                                "offerId": "str",  # Id of the product offering.
                                  Required.
                                "planId": "str",  # Id of the product offer plan.
                                  Required.
                                "planName": "str",  # Name of the product offer plan.
                                  Required.
                                "publisherId": "str",  # Id of the product publisher.
                                  Required.
                                "termId": "str",  # Offer plan term id. Required.
                                "termUnit": "str"  # Optional. Offer plan term unit.
                            }
                        },
                        "provisioningState": "str",  # Optional. Provisioning State of the
                          resource. Known values are: "Accepted", "Creating", "Updating", "Deleting",
                          "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
                        "userDetails": {
                            "emailAddress": "str",  # Optional. User email address.
                            "firstName": "str",  # Optional. User first name.
                            "lastName": "str",  # Optional. User last name.
                            "phoneNumber": "str",  # Optional. Phone number of the user
                              used by for contacting them if needed.
                            "upn": "str"  # Optional. UPN of user.
                        }
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "tags": {
                        "str": "str"  # Optional. Resource tags.
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.InformaticaOrganizationResource]] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_organizations_list_by_subscription_request(
                    subscription_id=self._config.subscription_id,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.InformaticaOrganizationResource], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _deserialize(_models.ErrorResponse, response.json())
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_serverless_metadata(
        self, resource_group_name: str, organization_name: str, **kwargs: Any
    ) -> _models.ServerlessMetadataResponse:
        """Gets Metadata of the serverless runtime environment.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Name of the Organizations resource. Required.
        :type organization_name: str
        :return: ServerlessMetadataResponse. The ServerlessMetadataResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.informaticadatamanagement.models.ServerlessMetadataResponse
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "serverlessConfigProperties": {
                        "applicationTypes": [
                            {
                                "name": "str",  # Optional. Application type name.
                                "value": "str"  # Optional. Application type value.
                            }
                        ],
                        "computeUnits": [
                            {
                                "name": "str",  # Optional. ComputeUnit name.
                                "value": [
                                    "str"  # Optional. ComputeUnit value.
                                ]
                            }
                        ],
                        "executionTimeout": "str",  # Optional. Serverless Runtime execution
                          timeout.
                        "platform": "str",  # Optional. Platform types. "AZURE"
                        "regions": [
                            {
                                "id": "str",  # Optional. Region Id.
                                "name": "str"  # Optional. Region name.
                            }
                        ]
                    },
                    "serverlessRuntimeConfigProperties": {
                        "cdiConfigProps": [
                            {
                                "applicationConfigs": [
                                    {
                                        "customized": "str",  # Customized
                                          value of the application config. Required.
                                        "defaultValue": "str",  # Default
                                          value of the application config. Required.
                                        "name": "str",  # Name of the
                                          application config. Required.
                                        "platform": "str",  # Platform type
                                          of the application config. Required.
                                        "type": "str",  # Type of the
                                          application config. Required.
                                        "value": "str"  # Value of the
                                          application config. Required.
                                    }
                                ],
                                "engineName": "str",  # EngineName of the application
                                  config. Required.
                                "engineVersion": "str"  # EngineVersion of the
                                  application config. Required.
                            }
                        ],
                        "cdieConfigProps": [
                            {
                                "applicationConfigs": [
                                    {
                                        "customized": "str",  # Customized
                                          value of the application config. Required.
                                        "defaultValue": "str",  # Default
                                          value of the application config. Required.
                                        "name": "str",  # Name of the
                                          application config. Required.
                                        "platform": "str",  # Platform type
                                          of the application config. Required.
                                        "type": "str",  # Type of the
                                          application config. Required.
                                        "value": "str"  # Value of the
                                          application config. Required.
                                    }
                                ],
                                "engineName": "str",  # EngineName of the application
                                  config. Required.
                                "engineVersion": "str"  # EngineVersion of the
                                  application config. Required.
                            }
                        ]
                    },
                    "type": "str"  # Optional. type of the runtime environment. "SERVERLESS"
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.ServerlessMetadataResponse] = kwargs.pop("cls", None)

        _request = build_organizations_get_serverless_metadata_request(
            resource_group_name=resource_group_name,
            organization_name=organization_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.ServerlessMetadataResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_all_serverless_runtimes(
        self, resource_group_name: str, organization_name: str, **kwargs: Any
    ) -> _models.InformaticaServerlessRuntimeResourceList:
        """Gets all serverless runtime resources in a given informatica organization resource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Name of the Organizations resource. Required.
        :type organization_name: str
        :return: InformaticaServerlessRuntimeResourceList. The InformaticaServerlessRuntimeResourceList
         is compatible with MutableMapping
        :rtype: ~azure.mgmt.informaticadatamanagement.models.InformaticaServerlessRuntimeResourceList
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "informaticaRuntimeResources": [
                        {
                            "createdBy": "str",  # Created by. Required.
                            "createdTime": "str",  # Created time. Required.
                            "id": "str",  # Informatica serverless runtime id. Required.
                            "name": "str",  # Environment name. Required.
                            "serverlessConfigProperties": {
                                "advancedCustomProperties": "str",  # Optional.
                                  Advanced custom properties.
                                "applicationType": "str",  # Optional.
                                  applicationType name.
                                "computeUnits": "str",  # Optional. Compute Units.
                                "executionTimeout": "str",  # Optional. Execution
                                  timeout.
                                "platform": "str",  # Optional. Serverless Account
                                  Platform.
                                "region": "str",  # Optional. region name for the
                                  runtime environment.
                                "resourceGroupName": "str",  # Optional. Resource
                                  group name.
                                "serverlessArmResourceId": "str",  # Optional.
                                  Serverless Arm Resource ID.
                                "subnet": "str",  # Optional. subnet name.
                                "subscriptionId": "str",  # Optional. subscription
                                  ID.
                                "supplementaryFileLocation": "str",  # Optional.
                                  Supplementary File location.
                                "tags": "str",  # Optional. Tags for the resource.
                                "tenantId": "str",  # Optional. Tenant ID.
                                "vnet": "str"  # Optional. virtual network.
                            },
                            "status": "str",  # Status of the environment. Required.
                            "statusLocalized": "str",  # Display message for the given
                              status. Required.
                            "statusMessage": "str",  # status message. Required.
                            "type": "str",  # Environment Type. Required. "SERVERLESS"
                            "updatedBy": "str",  # Last Updated by. Required.
                            "updatedTime": "str",  # Updated Time. Required.
                            "description": "str"  # Optional. Description of the runtime
                              resource.
                        }
                    ]
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.InformaticaServerlessRuntimeResourceList] = kwargs.pop("cls", None)

        _request = build_organizations_get_all_serverless_runtimes_request(
            resource_group_name=resource_group_name,
            organization_name=organization_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.InformaticaServerlessRuntimeResourceList, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class ServerlessRuntimesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.informaticadatamanagement.aio.InformaticaDataMgmtClient`'s
        :attr:`serverless_runtimes` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, organization_name: str, serverless_runtime_name: str, **kwargs: Any
    ) -> _models.InformaticaServerlessRuntimeResource:
        # pylint: disable=line-too-long
        """Get a InformaticaServerlessRuntimeResource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Name of the Organizations resource. Required.
        :type organization_name: str
        :param serverless_runtime_name: Name of the Serverless Runtime resource. Required.
        :type serverless_runtime_name: str
        :return: InformaticaServerlessRuntimeResource. The InformaticaServerlessRuntimeResource is
         compatible with MutableMapping
        :rtype: ~azure.mgmt.informaticadatamanagement.models.InformaticaServerlessRuntimeResource
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "serverlessAccountLocation": "str",  # Serverless account creation
                          location. Required.
                        "advancedCustomProperties": [
                            {
                                "key": "str",  # Optional. advanced custom properties
                                  key.
                                "value": "str"  # Optional. advanced custom
                                  properties value.
                            }
                        ],
                        "applicationType": "str",  # Optional. Application type of the
                          Serverless Runtime environment. Known values are: "CDI" and "CDIE".
                        "computeUnits": "str",  # Optional. Compute units of the serverless
                          runtime.
                        "description": "str",  # Optional. description of the serverless
                          runtime.
                        "executionTimeout": "str",  # Optional. Serverless Execution timeout.
                        "platform": "str",  # Optional. Platform type of the Serverless
                          Runtime. "AZURE"
                        "provisioningState": "str",  # Optional. Provisioning State of the
                          resource. Known values are: "Accepted", "Creating", "Updating", "Deleting",
                          "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
                        "serverlessRuntimeConfig": {
                            "cdiConfigProps": [
                                {
                                    "applicationConfigs": [
                                        {
                                            "customized": "str",  #
                                              Customized value of the application config. Required.
                                            "defaultValue": "str",  #
                                              Default value of the application config. Required.
                                            "name": "str",  # Name of the
                                              application config. Required.
                                            "platform": "str",  #
                                              Platform type of the application config. Required.
                                            "type": "str",  # Type of the
                                              application config. Required.
                                            "value": "str"  # Value of
                                              the application config. Required.
                                        }
                                    ],
                                    "engineName": "str",  # EngineName of the
                                      application config. Required.
                                    "engineVersion": "str"  # EngineVersion of
                                      the application config. Required.
                                }
                            ],
                            "cdieConfigProps": [
                                {
                                    "applicationConfigs": [
                                        {
                                            "customized": "str",  #
                                              Customized value of the application config. Required.
                                            "defaultValue": "str",  #
                                              Default value of the application config. Required.
                                            "name": "str",  # Name of the
                                              application config. Required.
                                            "platform": "str",  #
                                              Platform type of the application config. Required.
                                            "type": "str",  # Type of the
                                              application config. Required.
                                            "value": "str"  # Value of
                                              the application config. Required.
                                        }
                                    ],
                                    "engineName": "str",  # EngineName of the
                                      application config. Required.
                                    "engineVersion": "str"  # EngineVersion of
                                      the application config. Required.
                                }
                            ]
                        },
                        "serverlessRuntimeNetworkProfile": {
                            "networkInterfaceConfiguration": {
                                "subnetId": "str",  # Virtual network subnet resource
                                  id. Required.
                                "vnetId": "str",  # Virtual network resource id.
                                  Required.
                                "vnetResourceGuid": "str"  # Optional. Virtual
                                  network resource guid.
                            }
                        },
                        "serverlessRuntimeTags": [
                            {
                                "name": "str",  # Optional. The name (also known as
                                  the key) of the tag.
                                "value": "str"  # Optional. The value of the tag.
                            }
                        ],
                        "serverlessRuntimeUserContextProperties": {
                            "userContextToken": "str"  # User context token for OBO flow.
                              Required.
                        },
                        "supplementaryFileLocation": "str"  # Optional. Supplementary file
                          location.
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.InformaticaServerlessRuntimeResource] = kwargs.pop("cls", None)

        _request = build_serverless_runtimes_get_request(
            resource_group_name=resource_group_name,
            organization_name=organization_name,
            serverless_runtime_name=serverless_runtime_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.InformaticaServerlessRuntimeResource, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_or_update_initial(
        self,
        resource_group_name: str,
        organization_name: str,
        serverless_runtime_name: str,
        resource: Union[_models.InformaticaServerlessRuntimeResource, JSON, IO[bytes]],
        **kwargs: Any
    ) -> JSON:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(resource, (IOBase, bytes)):
            _content = resource
        else:
            _content = json.dumps(resource, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_serverless_runtimes_create_or_update_request(
            resource_group_name=resource_group_name,
            organization_name=organization_name,
            serverless_runtime_name=serverless_runtime_name,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 200:
            deserialized = _deserialize(JSON, response.json())

        if response.status_code == 201:
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

            deserialized = _deserialize(JSON, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        organization_name: str,
        serverless_runtime_name: str,
        resource: _models.InformaticaServerlessRuntimeResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.InformaticaServerlessRuntimeResource]:
        # pylint: disable=line-too-long
        """Create a InformaticaServerlessRuntimeResource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Name of the Organizations resource. Required.
        :type organization_name: str
        :param serverless_runtime_name: Name of the Serverless Runtime resource. Required.
        :type serverless_runtime_name: str
        :param resource: Resource create parameters. Required.
        :type resource:
         ~azure.mgmt.informaticadatamanagement.models.InformaticaServerlessRuntimeResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns InformaticaServerlessRuntimeResource. The
         InformaticaServerlessRuntimeResource is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.informaticadatamanagement.models.InformaticaServerlessRuntimeResource]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                resource = {
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "serverlessAccountLocation": "str",  # Serverless account creation
                          location. Required.
                        "advancedCustomProperties": [
                            {
                                "key": "str",  # Optional. advanced custom properties
                                  key.
                                "value": "str"  # Optional. advanced custom
                                  properties value.
                            }
                        ],
                        "applicationType": "str",  # Optional. Application type of the
                          Serverless Runtime environment. Known values are: "CDI" and "CDIE".
                        "computeUnits": "str",  # Optional. Compute units of the serverless
                          runtime.
                        "description": "str",  # Optional. description of the serverless
                          runtime.
                        "executionTimeout": "str",  # Optional. Serverless Execution timeout.
                        "platform": "str",  # Optional. Platform type of the Serverless
                          Runtime. "AZURE"
                        "provisioningState": "str",  # Optional. Provisioning State of the
                          resource. Known values are: "Accepted", "Creating", "Updating", "Deleting",
                          "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
                        "serverlessRuntimeConfig": {
                            "cdiConfigProps": [
                                {
                                    "applicationConfigs": [
                                        {
                                            "customized": "str",  #
                                              Customized value of the application config. Required.
                                            "defaultValue": "str",  #
                                              Default value of the application config. Required.
                                            "name": "str",  # Name of the
                                              application config. Required.
                                            "platform": "str",  #
                                              Platform type of the application config. Required.
                                            "type": "str",  # Type of the
                                              application config. Required.
                                            "value": "str"  # Value of
                                              the application config. Required.
                                        }
                                    ],
                                    "engineName": "str",  # EngineName of the
                                      application config. Required.
                                    "engineVersion": "str"  # EngineVersion of
                                      the application config. Required.
                                }
                            ],
                            "cdieConfigProps": [
                                {
                                    "applicationConfigs": [
                                        {
                                            "customized": "str",  #
                                              Customized value of the application config. Required.
                                            "defaultValue": "str",  #
                                              Default value of the application config. Required.
                                            "name": "str",  # Name of the
                                              application config. Required.
                                            "platform": "str",  #
                                              Platform type of the application config. Required.
                                            "type": "str",  # Type of the
                                              application config. Required.
                                            "value": "str"  # Value of
                                              the application config. Required.
                                        }
                                    ],
                                    "engineName": "str",  # EngineName of the
                                      application config. Required.
                                    "engineVersion": "str"  # EngineVersion of
                                      the application config. Required.
                                }
                            ]
                        },
                        "serverlessRuntimeNetworkProfile": {
                            "networkInterfaceConfiguration": {
                                "subnetId": "str",  # Virtual network subnet resource
                                  id. Required.
                                "vnetId": "str",  # Virtual network resource id.
                                  Required.
                                "vnetResourceGuid": "str"  # Optional. Virtual
                                  network resource guid.
                            }
                        },
                        "serverlessRuntimeTags": [
                            {
                                "name": "str",  # Optional. The name (also known as
                                  the key) of the tag.
                                "value": "str"  # Optional. The value of the tag.
                            }
                        ],
                        "serverlessRuntimeUserContextProperties": {
                            "userContextToken": "str"  # User context token for OBO flow.
                              Required.
                        },
                        "supplementaryFileLocation": "str"  # Optional. Supplementary file
                          location.
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }

                # response body for status code(s): 200, 201
                response == {
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "serverlessAccountLocation": "str",  # Serverless account creation
                          location. Required.
                        "advancedCustomProperties": [
                            {
                                "key": "str",  # Optional. advanced custom properties
                                  key.
                                "value": "str"  # Optional. advanced custom
                                  properties value.
                            }
                        ],
                        "applicationType": "str",  # Optional. Application type of the
                          Serverless Runtime environment. Known values are: "CDI" and "CDIE".
                        "computeUnits": "str",  # Optional. Compute units of the serverless
                          runtime.
                        "description": "str",  # Optional. description of the serverless
                          runtime.
                        "executionTimeout": "str",  # Optional. Serverless Execution timeout.
                        "platform": "str",  # Optional. Platform type of the Serverless
                          Runtime. "AZURE"
                        "provisioningState": "str",  # Optional. Provisioning State of the
                          resource. Known values are: "Accepted", "Creating", "Updating", "Deleting",
                          "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
                        "serverlessRuntimeConfig": {
                            "cdiConfigProps": [
                                {
                                    "applicationConfigs": [
                                        {
                                            "customized": "str",  #
                                              Customized value of the application config. Required.
                                            "defaultValue": "str",  #
                                              Default value of the application config. Required.
                                            "name": "str",  # Name of the
                                              application config. Required.
                                            "platform": "str",  #
                                              Platform type of the application config. Required.
                                            "type": "str",  # Type of the
                                              application config. Required.
                                            "value": "str"  # Value of
                                              the application config. Required.
                                        }
                                    ],
                                    "engineName": "str",  # EngineName of the
                                      application config. Required.
                                    "engineVersion": "str"  # EngineVersion of
                                      the application config. Required.
                                }
                            ],
                            "cdieConfigProps": [
                                {
                                    "applicationConfigs": [
                                        {
                                            "customized": "str",  #
                                              Customized value of the application config. Required.
                                            "defaultValue": "str",  #
                                              Default value of the application config. Required.
                                            "name": "str",  # Name of the
                                              application config. Required.
                                            "platform": "str",  #
                                              Platform type of the application config. Required.
                                            "type": "str",  # Type of the
                                              application config. Required.
                                            "value": "str"  # Value of
                                              the application config. Required.
                                        }
                                    ],
                                    "engineName": "str",  # EngineName of the
                                      application config. Required.
                                    "engineVersion": "str"  # EngineVersion of
                                      the application config. Required.
                                }
                            ]
                        },
                        "serverlessRuntimeNetworkProfile": {
                            "networkInterfaceConfiguration": {
                                "subnetId": "str",  # Virtual network subnet resource
                                  id. Required.
                                "vnetId": "str",  # Virtual network resource id.
                                  Required.
                                "vnetResourceGuid": "str"  # Optional. Virtual
                                  network resource guid.
                            }
                        },
                        "serverlessRuntimeTags": [
                            {
                                "name": "str",  # Optional. The name (also known as
                                  the key) of the tag.
                                "value": "str"  # Optional. The value of the tag.
                            }
                        ],
                        "serverlessRuntimeUserContextProperties": {
                            "userContextToken": "str"  # User context token for OBO flow.
                              Required.
                        },
                        "supplementaryFileLocation": "str"  # Optional. Supplementary file
                          location.
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        organization_name: str,
        serverless_runtime_name: str,
        resource: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.InformaticaServerlessRuntimeResource]:
        # pylint: disable=line-too-long
        """Create a InformaticaServerlessRuntimeResource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Name of the Organizations resource. Required.
        :type organization_name: str
        :param serverless_runtime_name: Name of the Serverless Runtime resource. Required.
        :type serverless_runtime_name: str
        :param resource: Resource create parameters. Required.
        :type resource: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns InformaticaServerlessRuntimeResource. The
         InformaticaServerlessRuntimeResource is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.informaticadatamanagement.models.InformaticaServerlessRuntimeResource]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "serverlessAccountLocation": "str",  # Serverless account creation
                          location. Required.
                        "advancedCustomProperties": [
                            {
                                "key": "str",  # Optional. advanced custom properties
                                  key.
                                "value": "str"  # Optional. advanced custom
                                  properties value.
                            }
                        ],
                        "applicationType": "str",  # Optional. Application type of the
                          Serverless Runtime environment. Known values are: "CDI" and "CDIE".
                        "computeUnits": "str",  # Optional. Compute units of the serverless
                          runtime.
                        "description": "str",  # Optional. description of the serverless
                          runtime.
                        "executionTimeout": "str",  # Optional. Serverless Execution timeout.
                        "platform": "str",  # Optional. Platform type of the Serverless
                          Runtime. "AZURE"
                        "provisioningState": "str",  # Optional. Provisioning State of the
                          resource. Known values are: "Accepted", "Creating", "Updating", "Deleting",
                          "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
                        "serverlessRuntimeConfig": {
                            "cdiConfigProps": [
                                {
                                    "applicationConfigs": [
                                        {
                                            "customized": "str",  #
                                              Customized value of the application config. Required.
                                            "defaultValue": "str",  #
                                              Default value of the application config. Required.
                                            "name": "str",  # Name of the
                                              application config. Required.
                                            "platform": "str",  #
                                              Platform type of the application config. Required.
                                            "type": "str",  # Type of the
                                              application config. Required.
                                            "value": "str"  # Value of
                                              the application config. Required.
                                        }
                                    ],
                                    "engineName": "str",  # EngineName of the
                                      application config. Required.
                                    "engineVersion": "str"  # EngineVersion of
                                      the application config. Required.
                                }
                            ],
                            "cdieConfigProps": [
                                {
                                    "applicationConfigs": [
                                        {
                                            "customized": "str",  #
                                              Customized value of the application config. Required.
                                            "defaultValue": "str",  #
                                              Default value of the application config. Required.
                                            "name": "str",  # Name of the
                                              application config. Required.
                                            "platform": "str",  #
                                              Platform type of the application config. Required.
                                            "type": "str",  # Type of the
                                              application config. Required.
                                            "value": "str"  # Value of
                                              the application config. Required.
                                        }
                                    ],
                                    "engineName": "str",  # EngineName of the
                                      application config. Required.
                                    "engineVersion": "str"  # EngineVersion of
                                      the application config. Required.
                                }
                            ]
                        },
                        "serverlessRuntimeNetworkProfile": {
                            "networkInterfaceConfiguration": {
                                "subnetId": "str",  # Virtual network subnet resource
                                  id. Required.
                                "vnetId": "str",  # Virtual network resource id.
                                  Required.
                                "vnetResourceGuid": "str"  # Optional. Virtual
                                  network resource guid.
                            }
                        },
                        "serverlessRuntimeTags": [
                            {
                                "name": "str",  # Optional. The name (also known as
                                  the key) of the tag.
                                "value": "str"  # Optional. The value of the tag.
                            }
                        ],
                        "serverlessRuntimeUserContextProperties": {
                            "userContextToken": "str"  # User context token for OBO flow.
                              Required.
                        },
                        "supplementaryFileLocation": "str"  # Optional. Supplementary file
                          location.
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        organization_name: str,
        serverless_runtime_name: str,
        resource: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.InformaticaServerlessRuntimeResource]:
        # pylint: disable=line-too-long
        """Create a InformaticaServerlessRuntimeResource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Name of the Organizations resource. Required.
        :type organization_name: str
        :param serverless_runtime_name: Name of the Serverless Runtime resource. Required.
        :type serverless_runtime_name: str
        :param resource: Resource create parameters. Required.
        :type resource: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns InformaticaServerlessRuntimeResource. The
         InformaticaServerlessRuntimeResource is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.informaticadatamanagement.models.InformaticaServerlessRuntimeResource]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "serverlessAccountLocation": "str",  # Serverless account creation
                          location. Required.
                        "advancedCustomProperties": [
                            {
                                "key": "str",  # Optional. advanced custom properties
                                  key.
                                "value": "str"  # Optional. advanced custom
                                  properties value.
                            }
                        ],
                        "applicationType": "str",  # Optional. Application type of the
                          Serverless Runtime environment. Known values are: "CDI" and "CDIE".
                        "computeUnits": "str",  # Optional. Compute units of the serverless
                          runtime.
                        "description": "str",  # Optional. description of the serverless
                          runtime.
                        "executionTimeout": "str",  # Optional. Serverless Execution timeout.
                        "platform": "str",  # Optional. Platform type of the Serverless
                          Runtime. "AZURE"
                        "provisioningState": "str",  # Optional. Provisioning State of the
                          resource. Known values are: "Accepted", "Creating", "Updating", "Deleting",
                          "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
                        "serverlessRuntimeConfig": {
                            "cdiConfigProps": [
                                {
                                    "applicationConfigs": [
                                        {
                                            "customized": "str",  #
                                              Customized value of the application config. Required.
                                            "defaultValue": "str",  #
                                              Default value of the application config. Required.
                                            "name": "str",  # Name of the
                                              application config. Required.
                                            "platform": "str",  #
                                              Platform type of the application config. Required.
                                            "type": "str",  # Type of the
                                              application config. Required.
                                            "value": "str"  # Value of
                                              the application config. Required.
                                        }
                                    ],
                                    "engineName": "str",  # EngineName of the
                                      application config. Required.
                                    "engineVersion": "str"  # EngineVersion of
                                      the application config. Required.
                                }
                            ],
                            "cdieConfigProps": [
                                {
                                    "applicationConfigs": [
                                        {
                                            "customized": "str",  #
                                              Customized value of the application config. Required.
                                            "defaultValue": "str",  #
                                              Default value of the application config. Required.
                                            "name": "str",  # Name of the
                                              application config. Required.
                                            "platform": "str",  #
                                              Platform type of the application config. Required.
                                            "type": "str",  # Type of the
                                              application config. Required.
                                            "value": "str"  # Value of
                                              the application config. Required.
                                        }
                                    ],
                                    "engineName": "str",  # EngineName of the
                                      application config. Required.
                                    "engineVersion": "str"  # EngineVersion of
                                      the application config. Required.
                                }
                            ]
                        },
                        "serverlessRuntimeNetworkProfile": {
                            "networkInterfaceConfiguration": {
                                "subnetId": "str",  # Virtual network subnet resource
                                  id. Required.
                                "vnetId": "str",  # Virtual network resource id.
                                  Required.
                                "vnetResourceGuid": "str"  # Optional. Virtual
                                  network resource guid.
                            }
                        },
                        "serverlessRuntimeTags": [
                            {
                                "name": "str",  # Optional. The name (also known as
                                  the key) of the tag.
                                "value": "str"  # Optional. The value of the tag.
                            }
                        ],
                        "serverlessRuntimeUserContextProperties": {
                            "userContextToken": "str"  # User context token for OBO flow.
                              Required.
                        },
                        "supplementaryFileLocation": "str"  # Optional. Supplementary file
                          location.
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        organization_name: str,
        serverless_runtime_name: str,
        resource: Union[_models.InformaticaServerlessRuntimeResource, JSON, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.InformaticaServerlessRuntimeResource]:
        # pylint: disable=line-too-long
        """Create a InformaticaServerlessRuntimeResource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Name of the Organizations resource. Required.
        :type organization_name: str
        :param serverless_runtime_name: Name of the Serverless Runtime resource. Required.
        :type serverless_runtime_name: str
        :param resource: Resource create parameters. Is one of the following types:
         InformaticaServerlessRuntimeResource, JSON, IO[bytes] Required.
        :type resource:
         ~azure.mgmt.informaticadatamanagement.models.InformaticaServerlessRuntimeResource or JSON or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns InformaticaServerlessRuntimeResource. The
         InformaticaServerlessRuntimeResource is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.informaticadatamanagement.models.InformaticaServerlessRuntimeResource]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                resource = {
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "serverlessAccountLocation": "str",  # Serverless account creation
                          location. Required.
                        "advancedCustomProperties": [
                            {
                                "key": "str",  # Optional. advanced custom properties
                                  key.
                                "value": "str"  # Optional. advanced custom
                                  properties value.
                            }
                        ],
                        "applicationType": "str",  # Optional. Application type of the
                          Serverless Runtime environment. Known values are: "CDI" and "CDIE".
                        "computeUnits": "str",  # Optional. Compute units of the serverless
                          runtime.
                        "description": "str",  # Optional. description of the serverless
                          runtime.
                        "executionTimeout": "str",  # Optional. Serverless Execution timeout.
                        "platform": "str",  # Optional. Platform type of the Serverless
                          Runtime. "AZURE"
                        "provisioningState": "str",  # Optional. Provisioning State of the
                          resource. Known values are: "Accepted", "Creating", "Updating", "Deleting",
                          "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
                        "serverlessRuntimeConfig": {
                            "cdiConfigProps": [
                                {
                                    "applicationConfigs": [
                                        {
                                            "customized": "str",  #
                                              Customized value of the application config. Required.
                                            "defaultValue": "str",  #
                                              Default value of the application config. Required.
                                            "name": "str",  # Name of the
                                              application config. Required.
                                            "platform": "str",  #
                                              Platform type of the application config. Required.
                                            "type": "str",  # Type of the
                                              application config. Required.
                                            "value": "str"  # Value of
                                              the application config. Required.
                                        }
                                    ],
                                    "engineName": "str",  # EngineName of the
                                      application config. Required.
                                    "engineVersion": "str"  # EngineVersion of
                                      the application config. Required.
                                }
                            ],
                            "cdieConfigProps": [
                                {
                                    "applicationConfigs": [
                                        {
                                            "customized": "str",  #
                                              Customized value of the application config. Required.
                                            "defaultValue": "str",  #
                                              Default value of the application config. Required.
                                            "name": "str",  # Name of the
                                              application config. Required.
                                            "platform": "str",  #
                                              Platform type of the application config. Required.
                                            "type": "str",  # Type of the
                                              application config. Required.
                                            "value": "str"  # Value of
                                              the application config. Required.
                                        }
                                    ],
                                    "engineName": "str",  # EngineName of the
                                      application config. Required.
                                    "engineVersion": "str"  # EngineVersion of
                                      the application config. Required.
                                }
                            ]
                        },
                        "serverlessRuntimeNetworkProfile": {
                            "networkInterfaceConfiguration": {
                                "subnetId": "str",  # Virtual network subnet resource
                                  id. Required.
                                "vnetId": "str",  # Virtual network resource id.
                                  Required.
                                "vnetResourceGuid": "str"  # Optional. Virtual
                                  network resource guid.
                            }
                        },
                        "serverlessRuntimeTags": [
                            {
                                "name": "str",  # Optional. The name (also known as
                                  the key) of the tag.
                                "value": "str"  # Optional. The value of the tag.
                            }
                        ],
                        "serverlessRuntimeUserContextProperties": {
                            "userContextToken": "str"  # User context token for OBO flow.
                              Required.
                        },
                        "supplementaryFileLocation": "str"  # Optional. Supplementary file
                          location.
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }

                # response body for status code(s): 200, 201
                response == {
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "serverlessAccountLocation": "str",  # Serverless account creation
                          location. Required.
                        "advancedCustomProperties": [
                            {
                                "key": "str",  # Optional. advanced custom properties
                                  key.
                                "value": "str"  # Optional. advanced custom
                                  properties value.
                            }
                        ],
                        "applicationType": "str",  # Optional. Application type of the
                          Serverless Runtime environment. Known values are: "CDI" and "CDIE".
                        "computeUnits": "str",  # Optional. Compute units of the serverless
                          runtime.
                        "description": "str",  # Optional. description of the serverless
                          runtime.
                        "executionTimeout": "str",  # Optional. Serverless Execution timeout.
                        "platform": "str",  # Optional. Platform type of the Serverless
                          Runtime. "AZURE"
                        "provisioningState": "str",  # Optional. Provisioning State of the
                          resource. Known values are: "Accepted", "Creating", "Updating", "Deleting",
                          "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
                        "serverlessRuntimeConfig": {
                            "cdiConfigProps": [
                                {
                                    "applicationConfigs": [
                                        {
                                            "customized": "str",  #
                                              Customized value of the application config. Required.
                                            "defaultValue": "str",  #
                                              Default value of the application config. Required.
                                            "name": "str",  # Name of the
                                              application config. Required.
                                            "platform": "str",  #
                                              Platform type of the application config. Required.
                                            "type": "str",  # Type of the
                                              application config. Required.
                                            "value": "str"  # Value of
                                              the application config. Required.
                                        }
                                    ],
                                    "engineName": "str",  # EngineName of the
                                      application config. Required.
                                    "engineVersion": "str"  # EngineVersion of
                                      the application config. Required.
                                }
                            ],
                            "cdieConfigProps": [
                                {
                                    "applicationConfigs": [
                                        {
                                            "customized": "str",  #
                                              Customized value of the application config. Required.
                                            "defaultValue": "str",  #
                                              Default value of the application config. Required.
                                            "name": "str",  # Name of the
                                              application config. Required.
                                            "platform": "str",  #
                                              Platform type of the application config. Required.
                                            "type": "str",  # Type of the
                                              application config. Required.
                                            "value": "str"  # Value of
                                              the application config. Required.
                                        }
                                    ],
                                    "engineName": "str",  # EngineName of the
                                      application config. Required.
                                    "engineVersion": "str"  # EngineVersion of
                                      the application config. Required.
                                }
                            ]
                        },
                        "serverlessRuntimeNetworkProfile": {
                            "networkInterfaceConfiguration": {
                                "subnetId": "str",  # Virtual network subnet resource
                                  id. Required.
                                "vnetId": "str",  # Virtual network resource id.
                                  Required.
                                "vnetResourceGuid": "str"  # Optional. Virtual
                                  network resource guid.
                            }
                        },
                        "serverlessRuntimeTags": [
                            {
                                "name": "str",  # Optional. The name (also known as
                                  the key) of the tag.
                                "value": "str"  # Optional. The value of the tag.
                            }
                        ],
                        "serverlessRuntimeUserContextProperties": {
                            "userContextToken": "str"  # User context token for OBO flow.
                              Required.
                        },
                        "supplementaryFileLocation": "str"  # Optional. Supplementary file
                          location.
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.InformaticaServerlessRuntimeResource] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                organization_name=organization_name,
                serverless_runtime_name=serverless_runtime_name,
                resource=resource,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = _deserialize(_models.InformaticaServerlessRuntimeResource, response.json())
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.InformaticaServerlessRuntimeResource].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.InformaticaServerlessRuntimeResource](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, organization_name: str, serverless_runtime_name: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_serverless_runtimes_delete_request(
            resource_group_name=resource_group_name,
            organization_name=organization_name,
            serverless_runtime_name=serverless_runtime_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202, 204]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace_async
    async def begin_delete(
        self, resource_group_name: str, organization_name: str, serverless_runtime_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Delete a InformaticaServerlessRuntimeResource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Name of the Organizations resource. Required.
        :type organization_name: str
        :param serverless_runtime_name: Name of the Serverless Runtime resource. Required.
        :type serverless_runtime_name: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(  # type: ignore
                resource_group_name=resource_group_name,
                organization_name=organization_name,
                serverless_runtime_name=serverless_runtime_name,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace
    def list_by_informatica_organization_resource(  # pylint: disable=name-too-long
        self, resource_group_name: str, organization_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.InformaticaServerlessRuntimeResource"]:
        # pylint: disable=line-too-long
        """List InformaticaServerlessRuntimeResource resources by InformaticaOrganizationResource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Name of the Organizations resource. Required.
        :type organization_name: str
        :return: An iterator like instance of InformaticaServerlessRuntimeResource
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.informaticadatamanagement.models.InformaticaServerlessRuntimeResource]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "serverlessAccountLocation": "str",  # Serverless account creation
                          location. Required.
                        "advancedCustomProperties": [
                            {
                                "key": "str",  # Optional. advanced custom properties
                                  key.
                                "value": "str"  # Optional. advanced custom
                                  properties value.
                            }
                        ],
                        "applicationType": "str",  # Optional. Application type of the
                          Serverless Runtime environment. Known values are: "CDI" and "CDIE".
                        "computeUnits": "str",  # Optional. Compute units of the serverless
                          runtime.
                        "description": "str",  # Optional. description of the serverless
                          runtime.
                        "executionTimeout": "str",  # Optional. Serverless Execution timeout.
                        "platform": "str",  # Optional. Platform type of the Serverless
                          Runtime. "AZURE"
                        "provisioningState": "str",  # Optional. Provisioning State of the
                          resource. Known values are: "Accepted", "Creating", "Updating", "Deleting",
                          "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
                        "serverlessRuntimeConfig": {
                            "cdiConfigProps": [
                                {
                                    "applicationConfigs": [
                                        {
                                            "customized": "str",  #
                                              Customized value of the application config. Required.
                                            "defaultValue": "str",  #
                                              Default value of the application config. Required.
                                            "name": "str",  # Name of the
                                              application config. Required.
                                            "platform": "str",  #
                                              Platform type of the application config. Required.
                                            "type": "str",  # Type of the
                                              application config. Required.
                                            "value": "str"  # Value of
                                              the application config. Required.
                                        }
                                    ],
                                    "engineName": "str",  # EngineName of the
                                      application config. Required.
                                    "engineVersion": "str"  # EngineVersion of
                                      the application config. Required.
                                }
                            ],
                            "cdieConfigProps": [
                                {
                                    "applicationConfigs": [
                                        {
                                            "customized": "str",  #
                                              Customized value of the application config. Required.
                                            "defaultValue": "str",  #
                                              Default value of the application config. Required.
                                            "name": "str",  # Name of the
                                              application config. Required.
                                            "platform": "str",  #
                                              Platform type of the application config. Required.
                                            "type": "str",  # Type of the
                                              application config. Required.
                                            "value": "str"  # Value of
                                              the application config. Required.
                                        }
                                    ],
                                    "engineName": "str",  # EngineName of the
                                      application config. Required.
                                    "engineVersion": "str"  # EngineVersion of
                                      the application config. Required.
                                }
                            ]
                        },
                        "serverlessRuntimeNetworkProfile": {
                            "networkInterfaceConfiguration": {
                                "subnetId": "str",  # Virtual network subnet resource
                                  id. Required.
                                "vnetId": "str",  # Virtual network resource id.
                                  Required.
                                "vnetResourceGuid": "str"  # Optional. Virtual
                                  network resource guid.
                            }
                        },
                        "serverlessRuntimeTags": [
                            {
                                "name": "str",  # Optional. The name (also known as
                                  the key) of the tag.
                                "value": "str"  # Optional. The value of the tag.
                            }
                        ],
                        "serverlessRuntimeUserContextProperties": {
                            "userContextToken": "str"  # User context token for OBO flow.
                              Required.
                        },
                        "supplementaryFileLocation": "str"  # Optional. Supplementary file
                          location.
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.InformaticaServerlessRuntimeResource]] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_serverless_runtimes_list_by_informatica_organization_resource_request(
                    resource_group_name=resource_group_name,
                    organization_name=organization_name,
                    subscription_id=self._config.subscription_id,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.InformaticaServerlessRuntimeResource], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _deserialize(_models.ErrorResponse, response.json())
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def update(
        self,
        resource_group_name: str,
        organization_name: str,
        serverless_runtime_name: str,
        properties: _models.InformaticaServerlessRuntimeResourceUpdate,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.InformaticaServerlessRuntimeResource:
        # pylint: disable=line-too-long
        """Update a InformaticaServerlessRuntimeResource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Name of the Organizations resource. Required.
        :type organization_name: str
        :param serverless_runtime_name: Name of the Serverless Runtime resource. Required.
        :type serverless_runtime_name: str
        :param properties: The resource properties to be updated. Required.
        :type properties:
         ~azure.mgmt.informaticadatamanagement.models.InformaticaServerlessRuntimeResourceUpdate
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: InformaticaServerlessRuntimeResource. The InformaticaServerlessRuntimeResource is
         compatible with MutableMapping
        :rtype: ~azure.mgmt.informaticadatamanagement.models.InformaticaServerlessRuntimeResource
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                properties = {
                    "properties": {
                        "advancedCustomProperties": [
                            {
                                "key": "str",  # Optional. advanced custom properties
                                  key.
                                "value": "str"  # Optional. advanced custom
                                  properties value.
                            }
                        ],
                        "applicationType": "str",  # Optional. Application type of the
                          Serverless Runtime environment. Known values are: "CDI" and "CDIE".
                        "computeUnits": "str",  # Optional. Compute units of the serverless
                          runtime.
                        "description": "str",  # Optional. description of the serverless
                          runtime.
                        "executionTimeout": "str",  # Optional. Serverless Execution timeout.
                        "platform": "str",  # Optional. Platform type of the Serverless
                          Runtime. "AZURE"
                        "serverlessAccountLocation": "str",  # Optional. Serverless account
                          creation location.
                        "serverlessRuntimeConfig": {
                            "cdiConfigProps": [
                                {
                                    "applicationConfigs": [
                                        {
                                            "customized": "str",  #
                                              Customized value of the application config. Required.
                                            "defaultValue": "str",  #
                                              Default value of the application config. Required.
                                            "name": "str",  # Name of the
                                              application config. Required.
                                            "platform": "str",  #
                                              Platform type of the application config. Required.
                                            "type": "str",  # Type of the
                                              application config. Required.
                                            "value": "str"  # Value of
                                              the application config. Required.
                                        }
                                    ],
                                    "engineName": "str",  # EngineName of the
                                      application config. Required.
                                    "engineVersion": "str"  # EngineVersion of
                                      the application config. Required.
                                }
                            ],
                            "cdieConfigProps": [
                                {
                                    "applicationConfigs": [
                                        {
                                            "customized": "str",  #
                                              Customized value of the application config. Required.
                                            "defaultValue": "str",  #
                                              Default value of the application config. Required.
                                            "name": "str",  # Name of the
                                              application config. Required.
                                            "platform": "str",  #
                                              Platform type of the application config. Required.
                                            "type": "str",  # Type of the
                                              application config. Required.
                                            "value": "str"  # Value of
                                              the application config. Required.
                                        }
                                    ],
                                    "engineName": "str",  # EngineName of the
                                      application config. Required.
                                    "engineVersion": "str"  # EngineVersion of
                                      the application config. Required.
                                }
                            ]
                        },
                        "serverlessRuntimeNetworkProfile": {
                            "networkInterfaceConfiguration": {
                                "subnetId": "str",  # Optional. Virtual network
                                  subnet resource id.
                                "vnetId": "str",  # Optional. Virtual network
                                  resource id.
                                "vnetResourceGuid": "str"  # Optional. Virtual
                                  network resource guid.
                            }
                        },
                        "serverlessRuntimeTags": [
                            {
                                "name": "str",  # Optional. The name (also known as
                                  the key) of the tag.
                                "value": "str"  # Optional. The value of the tag.
                            }
                        ],
                        "serverlessRuntimeUserContextProperties": {
                            "userContextToken": "str"  # Optional. User context token for
                              OBO flow.
                        },
                        "supplementaryFileLocation": "str"  # Optional. Supplementary file
                          location.
                    }
                }

                # response body for status code(s): 200
                response == {
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "serverlessAccountLocation": "str",  # Serverless account creation
                          location. Required.
                        "advancedCustomProperties": [
                            {
                                "key": "str",  # Optional. advanced custom properties
                                  key.
                                "value": "str"  # Optional. advanced custom
                                  properties value.
                            }
                        ],
                        "applicationType": "str",  # Optional. Application type of the
                          Serverless Runtime environment. Known values are: "CDI" and "CDIE".
                        "computeUnits": "str",  # Optional. Compute units of the serverless
                          runtime.
                        "description": "str",  # Optional. description of the serverless
                          runtime.
                        "executionTimeout": "str",  # Optional. Serverless Execution timeout.
                        "platform": "str",  # Optional. Platform type of the Serverless
                          Runtime. "AZURE"
                        "provisioningState": "str",  # Optional. Provisioning State of the
                          resource. Known values are: "Accepted", "Creating", "Updating", "Deleting",
                          "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
                        "serverlessRuntimeConfig": {
                            "cdiConfigProps": [
                                {
                                    "applicationConfigs": [
                                        {
                                            "customized": "str",  #
                                              Customized value of the application config. Required.
                                            "defaultValue": "str",  #
                                              Default value of the application config. Required.
                                            "name": "str",  # Name of the
                                              application config. Required.
                                            "platform": "str",  #
                                              Platform type of the application config. Required.
                                            "type": "str",  # Type of the
                                              application config. Required.
                                            "value": "str"  # Value of
                                              the application config. Required.
                                        }
                                    ],
                                    "engineName": "str",  # EngineName of the
                                      application config. Required.
                                    "engineVersion": "str"  # EngineVersion of
                                      the application config. Required.
                                }
                            ],
                            "cdieConfigProps": [
                                {
                                    "applicationConfigs": [
                                        {
                                            "customized": "str",  #
                                              Customized value of the application config. Required.
                                            "defaultValue": "str",  #
                                              Default value of the application config. Required.
                                            "name": "str",  # Name of the
                                              application config. Required.
                                            "platform": "str",  #
                                              Platform type of the application config. Required.
                                            "type": "str",  # Type of the
                                              application config. Required.
                                            "value": "str"  # Value of
                                              the application config. Required.
                                        }
                                    ],
                                    "engineName": "str",  # EngineName of the
                                      application config. Required.
                                    "engineVersion": "str"  # EngineVersion of
                                      the application config. Required.
                                }
                            ]
                        },
                        "serverlessRuntimeNetworkProfile": {
                            "networkInterfaceConfiguration": {
                                "subnetId": "str",  # Virtual network subnet resource
                                  id. Required.
                                "vnetId": "str",  # Virtual network resource id.
                                  Required.
                                "vnetResourceGuid": "str"  # Optional. Virtual
                                  network resource guid.
                            }
                        },
                        "serverlessRuntimeTags": [
                            {
                                "name": "str",  # Optional. The name (also known as
                                  the key) of the tag.
                                "value": "str"  # Optional. The value of the tag.
                            }
                        ],
                        "serverlessRuntimeUserContextProperties": {
                            "userContextToken": "str"  # User context token for OBO flow.
                              Required.
                        },
                        "supplementaryFileLocation": "str"  # Optional. Supplementary file
                          location.
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """

    @overload
    async def update(
        self,
        resource_group_name: str,
        organization_name: str,
        serverless_runtime_name: str,
        properties: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.InformaticaServerlessRuntimeResource:
        # pylint: disable=line-too-long
        """Update a InformaticaServerlessRuntimeResource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Name of the Organizations resource. Required.
        :type organization_name: str
        :param serverless_runtime_name: Name of the Serverless Runtime resource. Required.
        :type serverless_runtime_name: str
        :param properties: The resource properties to be updated. Required.
        :type properties: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: InformaticaServerlessRuntimeResource. The InformaticaServerlessRuntimeResource is
         compatible with MutableMapping
        :rtype: ~azure.mgmt.informaticadatamanagement.models.InformaticaServerlessRuntimeResource
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "serverlessAccountLocation": "str",  # Serverless account creation
                          location. Required.
                        "advancedCustomProperties": [
                            {
                                "key": "str",  # Optional. advanced custom properties
                                  key.
                                "value": "str"  # Optional. advanced custom
                                  properties value.
                            }
                        ],
                        "applicationType": "str",  # Optional. Application type of the
                          Serverless Runtime environment. Known values are: "CDI" and "CDIE".
                        "computeUnits": "str",  # Optional. Compute units of the serverless
                          runtime.
                        "description": "str",  # Optional. description of the serverless
                          runtime.
                        "executionTimeout": "str",  # Optional. Serverless Execution timeout.
                        "platform": "str",  # Optional. Platform type of the Serverless
                          Runtime. "AZURE"
                        "provisioningState": "str",  # Optional. Provisioning State of the
                          resource. Known values are: "Accepted", "Creating", "Updating", "Deleting",
                          "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
                        "serverlessRuntimeConfig": {
                            "cdiConfigProps": [
                                {
                                    "applicationConfigs": [
                                        {
                                            "customized": "str",  #
                                              Customized value of the application config. Required.
                                            "defaultValue": "str",  #
                                              Default value of the application config. Required.
                                            "name": "str",  # Name of the
                                              application config. Required.
                                            "platform": "str",  #
                                              Platform type of the application config. Required.
                                            "type": "str",  # Type of the
                                              application config. Required.
                                            "value": "str"  # Value of
                                              the application config. Required.
                                        }
                                    ],
                                    "engineName": "str",  # EngineName of the
                                      application config. Required.
                                    "engineVersion": "str"  # EngineVersion of
                                      the application config. Required.
                                }
                            ],
                            "cdieConfigProps": [
                                {
                                    "applicationConfigs": [
                                        {
                                            "customized": "str",  #
                                              Customized value of the application config. Required.
                                            "defaultValue": "str",  #
                                              Default value of the application config. Required.
                                            "name": "str",  # Name of the
                                              application config. Required.
                                            "platform": "str",  #
                                              Platform type of the application config. Required.
                                            "type": "str",  # Type of the
                                              application config. Required.
                                            "value": "str"  # Value of
                                              the application config. Required.
                                        }
                                    ],
                                    "engineName": "str",  # EngineName of the
                                      application config. Required.
                                    "engineVersion": "str"  # EngineVersion of
                                      the application config. Required.
                                }
                            ]
                        },
                        "serverlessRuntimeNetworkProfile": {
                            "networkInterfaceConfiguration": {
                                "subnetId": "str",  # Virtual network subnet resource
                                  id. Required.
                                "vnetId": "str",  # Virtual network resource id.
                                  Required.
                                "vnetResourceGuid": "str"  # Optional. Virtual
                                  network resource guid.
                            }
                        },
                        "serverlessRuntimeTags": [
                            {
                                "name": "str",  # Optional. The name (also known as
                                  the key) of the tag.
                                "value": "str"  # Optional. The value of the tag.
                            }
                        ],
                        "serverlessRuntimeUserContextProperties": {
                            "userContextToken": "str"  # User context token for OBO flow.
                              Required.
                        },
                        "supplementaryFileLocation": "str"  # Optional. Supplementary file
                          location.
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """

    @overload
    async def update(
        self,
        resource_group_name: str,
        organization_name: str,
        serverless_runtime_name: str,
        properties: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.InformaticaServerlessRuntimeResource:
        # pylint: disable=line-too-long
        """Update a InformaticaServerlessRuntimeResource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Name of the Organizations resource. Required.
        :type organization_name: str
        :param serverless_runtime_name: Name of the Serverless Runtime resource. Required.
        :type serverless_runtime_name: str
        :param properties: The resource properties to be updated. Required.
        :type properties: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: InformaticaServerlessRuntimeResource. The InformaticaServerlessRuntimeResource is
         compatible with MutableMapping
        :rtype: ~azure.mgmt.informaticadatamanagement.models.InformaticaServerlessRuntimeResource
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "serverlessAccountLocation": "str",  # Serverless account creation
                          location. Required.
                        "advancedCustomProperties": [
                            {
                                "key": "str",  # Optional. advanced custom properties
                                  key.
                                "value": "str"  # Optional. advanced custom
                                  properties value.
                            }
                        ],
                        "applicationType": "str",  # Optional. Application type of the
                          Serverless Runtime environment. Known values are: "CDI" and "CDIE".
                        "computeUnits": "str",  # Optional. Compute units of the serverless
                          runtime.
                        "description": "str",  # Optional. description of the serverless
                          runtime.
                        "executionTimeout": "str",  # Optional. Serverless Execution timeout.
                        "platform": "str",  # Optional. Platform type of the Serverless
                          Runtime. "AZURE"
                        "provisioningState": "str",  # Optional. Provisioning State of the
                          resource. Known values are: "Accepted", "Creating", "Updating", "Deleting",
                          "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
                        "serverlessRuntimeConfig": {
                            "cdiConfigProps": [
                                {
                                    "applicationConfigs": [
                                        {
                                            "customized": "str",  #
                                              Customized value of the application config. Required.
                                            "defaultValue": "str",  #
                                              Default value of the application config. Required.
                                            "name": "str",  # Name of the
                                              application config. Required.
                                            "platform": "str",  #
                                              Platform type of the application config. Required.
                                            "type": "str",  # Type of the
                                              application config. Required.
                                            "value": "str"  # Value of
                                              the application config. Required.
                                        }
                                    ],
                                    "engineName": "str",  # EngineName of the
                                      application config. Required.
                                    "engineVersion": "str"  # EngineVersion of
                                      the application config. Required.
                                }
                            ],
                            "cdieConfigProps": [
                                {
                                    "applicationConfigs": [
                                        {
                                            "customized": "str",  #
                                              Customized value of the application config. Required.
                                            "defaultValue": "str",  #
                                              Default value of the application config. Required.
                                            "name": "str",  # Name of the
                                              application config. Required.
                                            "platform": "str",  #
                                              Platform type of the application config. Required.
                                            "type": "str",  # Type of the
                                              application config. Required.
                                            "value": "str"  # Value of
                                              the application config. Required.
                                        }
                                    ],
                                    "engineName": "str",  # EngineName of the
                                      application config. Required.
                                    "engineVersion": "str"  # EngineVersion of
                                      the application config. Required.
                                }
                            ]
                        },
                        "serverlessRuntimeNetworkProfile": {
                            "networkInterfaceConfiguration": {
                                "subnetId": "str",  # Virtual network subnet resource
                                  id. Required.
                                "vnetId": "str",  # Virtual network resource id.
                                  Required.
                                "vnetResourceGuid": "str"  # Optional. Virtual
                                  network resource guid.
                            }
                        },
                        "serverlessRuntimeTags": [
                            {
                                "name": "str",  # Optional. The name (also known as
                                  the key) of the tag.
                                "value": "str"  # Optional. The value of the tag.
                            }
                        ],
                        "serverlessRuntimeUserContextProperties": {
                            "userContextToken": "str"  # User context token for OBO flow.
                              Required.
                        },
                        "supplementaryFileLocation": "str"  # Optional. Supplementary file
                          location.
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """

    @distributed_trace_async
    async def update(
        self,
        resource_group_name: str,
        organization_name: str,
        serverless_runtime_name: str,
        properties: Union[_models.InformaticaServerlessRuntimeResourceUpdate, JSON, IO[bytes]],
        **kwargs: Any
    ) -> _models.InformaticaServerlessRuntimeResource:
        # pylint: disable=line-too-long
        """Update a InformaticaServerlessRuntimeResource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Name of the Organizations resource. Required.
        :type organization_name: str
        :param serverless_runtime_name: Name of the Serverless Runtime resource. Required.
        :type serverless_runtime_name: str
        :param properties: The resource properties to be updated. Is one of the following types:
         InformaticaServerlessRuntimeResourceUpdate, JSON, IO[bytes] Required.
        :type properties:
         ~azure.mgmt.informaticadatamanagement.models.InformaticaServerlessRuntimeResourceUpdate or JSON
         or IO[bytes]
        :return: InformaticaServerlessRuntimeResource. The InformaticaServerlessRuntimeResource is
         compatible with MutableMapping
        :rtype: ~azure.mgmt.informaticadatamanagement.models.InformaticaServerlessRuntimeResource
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                properties = {
                    "properties": {
                        "advancedCustomProperties": [
                            {
                                "key": "str",  # Optional. advanced custom properties
                                  key.
                                "value": "str"  # Optional. advanced custom
                                  properties value.
                            }
                        ],
                        "applicationType": "str",  # Optional. Application type of the
                          Serverless Runtime environment. Known values are: "CDI" and "CDIE".
                        "computeUnits": "str",  # Optional. Compute units of the serverless
                          runtime.
                        "description": "str",  # Optional. description of the serverless
                          runtime.
                        "executionTimeout": "str",  # Optional. Serverless Execution timeout.
                        "platform": "str",  # Optional. Platform type of the Serverless
                          Runtime. "AZURE"
                        "serverlessAccountLocation": "str",  # Optional. Serverless account
                          creation location.
                        "serverlessRuntimeConfig": {
                            "cdiConfigProps": [
                                {
                                    "applicationConfigs": [
                                        {
                                            "customized": "str",  #
                                              Customized value of the application config. Required.
                                            "defaultValue": "str",  #
                                              Default value of the application config. Required.
                                            "name": "str",  # Name of the
                                              application config. Required.
                                            "platform": "str",  #
                                              Platform type of the application config. Required.
                                            "type": "str",  # Type of the
                                              application config. Required.
                                            "value": "str"  # Value of
                                              the application config. Required.
                                        }
                                    ],
                                    "engineName": "str",  # EngineName of the
                                      application config. Required.
                                    "engineVersion": "str"  # EngineVersion of
                                      the application config. Required.
                                }
                            ],
                            "cdieConfigProps": [
                                {
                                    "applicationConfigs": [
                                        {
                                            "customized": "str",  #
                                              Customized value of the application config. Required.
                                            "defaultValue": "str",  #
                                              Default value of the application config. Required.
                                            "name": "str",  # Name of the
                                              application config. Required.
                                            "platform": "str",  #
                                              Platform type of the application config. Required.
                                            "type": "str",  # Type of the
                                              application config. Required.
                                            "value": "str"  # Value of
                                              the application config. Required.
                                        }
                                    ],
                                    "engineName": "str",  # EngineName of the
                                      application config. Required.
                                    "engineVersion": "str"  # EngineVersion of
                                      the application config. Required.
                                }
                            ]
                        },
                        "serverlessRuntimeNetworkProfile": {
                            "networkInterfaceConfiguration": {
                                "subnetId": "str",  # Optional. Virtual network
                                  subnet resource id.
                                "vnetId": "str",  # Optional. Virtual network
                                  resource id.
                                "vnetResourceGuid": "str"  # Optional. Virtual
                                  network resource guid.
                            }
                        },
                        "serverlessRuntimeTags": [
                            {
                                "name": "str",  # Optional. The name (also known as
                                  the key) of the tag.
                                "value": "str"  # Optional. The value of the tag.
                            }
                        ],
                        "serverlessRuntimeUserContextProperties": {
                            "userContextToken": "str"  # Optional. User context token for
                              OBO flow.
                        },
                        "supplementaryFileLocation": "str"  # Optional. Supplementary file
                          location.
                    }
                }

                # response body for status code(s): 200
                response == {
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "serverlessAccountLocation": "str",  # Serverless account creation
                          location. Required.
                        "advancedCustomProperties": [
                            {
                                "key": "str",  # Optional. advanced custom properties
                                  key.
                                "value": "str"  # Optional. advanced custom
                                  properties value.
                            }
                        ],
                        "applicationType": "str",  # Optional. Application type of the
                          Serverless Runtime environment. Known values are: "CDI" and "CDIE".
                        "computeUnits": "str",  # Optional. Compute units of the serverless
                          runtime.
                        "description": "str",  # Optional. description of the serverless
                          runtime.
                        "executionTimeout": "str",  # Optional. Serverless Execution timeout.
                        "platform": "str",  # Optional. Platform type of the Serverless
                          Runtime. "AZURE"
                        "provisioningState": "str",  # Optional. Provisioning State of the
                          resource. Known values are: "Accepted", "Creating", "Updating", "Deleting",
                          "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
                        "serverlessRuntimeConfig": {
                            "cdiConfigProps": [
                                {
                                    "applicationConfigs": [
                                        {
                                            "customized": "str",  #
                                              Customized value of the application config. Required.
                                            "defaultValue": "str",  #
                                              Default value of the application config. Required.
                                            "name": "str",  # Name of the
                                              application config. Required.
                                            "platform": "str",  #
                                              Platform type of the application config. Required.
                                            "type": "str",  # Type of the
                                              application config. Required.
                                            "value": "str"  # Value of
                                              the application config. Required.
                                        }
                                    ],
                                    "engineName": "str",  # EngineName of the
                                      application config. Required.
                                    "engineVersion": "str"  # EngineVersion of
                                      the application config. Required.
                                }
                            ],
                            "cdieConfigProps": [
                                {
                                    "applicationConfigs": [
                                        {
                                            "customized": "str",  #
                                              Customized value of the application config. Required.
                                            "defaultValue": "str",  #
                                              Default value of the application config. Required.
                                            "name": "str",  # Name of the
                                              application config. Required.
                                            "platform": "str",  #
                                              Platform type of the application config. Required.
                                            "type": "str",  # Type of the
                                              application config. Required.
                                            "value": "str"  # Value of
                                              the application config. Required.
                                        }
                                    ],
                                    "engineName": "str",  # EngineName of the
                                      application config. Required.
                                    "engineVersion": "str"  # EngineVersion of
                                      the application config. Required.
                                }
                            ]
                        },
                        "serverlessRuntimeNetworkProfile": {
                            "networkInterfaceConfiguration": {
                                "subnetId": "str",  # Virtual network subnet resource
                                  id. Required.
                                "vnetId": "str",  # Virtual network resource id.
                                  Required.
                                "vnetResourceGuid": "str"  # Optional. Virtual
                                  network resource guid.
                            }
                        },
                        "serverlessRuntimeTags": [
                            {
                                "name": "str",  # Optional. The name (also known as
                                  the key) of the tag.
                                "value": "str"  # Optional. The value of the tag.
                            }
                        ],
                        "serverlessRuntimeUserContextProperties": {
                            "userContextToken": "str"  # User context token for OBO flow.
                              Required.
                        },
                        "supplementaryFileLocation": "str"  # Optional. Supplementary file
                          location.
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.InformaticaServerlessRuntimeResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(properties, (IOBase, bytes)):
            _content = properties
        else:
            _content = json.dumps(properties, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_serverless_runtimes_update_request(
            resource_group_name=resource_group_name,
            organization_name=organization_name,
            serverless_runtime_name=serverless_runtime_name,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.InformaticaServerlessRuntimeResource, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def check_dependencies(
        self, resource_group_name: str, organization_name: str, serverless_runtime_name: str, **kwargs: Any
    ) -> _models.CheckDependenciesResponse:
        """Checks all dependencies for a serverless runtime resource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Name of the Organizations resource. Required.
        :type organization_name: str
        :param serverless_runtime_name: Name of the Serverless Runtime resource. Required.
        :type serverless_runtime_name: str
        :return: CheckDependenciesResponse. The CheckDependenciesResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.informaticadatamanagement.models.CheckDependenciesResponse
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "count": 0,  # Count of dependencies. Required.
                    "id": "str",  # id of resource. Required.
                    "references": [
                        {
                            "appContextId": "str",  # Application context ID. Required.
                            "description": "str",  # description of Dependency. Required.
                            "documentType": "str",  # document type. Required.
                            "id": "str",  # Dependency ID. Required.
                            "lastUpdatedTime": "str",  # Last Update Time. Required.
                            "path": "str"  # Dependency path. Required.
                        }
                    ]
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.CheckDependenciesResponse] = kwargs.pop("cls", None)

        _request = build_serverless_runtimes_check_dependencies_request(
            resource_group_name=resource_group_name,
            organization_name=organization_name,
            serverless_runtime_name=serverless_runtime_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CheckDependenciesResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def start_failed_serverless_runtime(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, organization_name: str, serverless_runtime_name: str, **kwargs: Any
    ) -> None:
        """Starts a failed runtime resource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Name of the Organizations resource. Required.
        :type organization_name: str
        :param serverless_runtime_name: Name of the Serverless Runtime resource. Required.
        :type serverless_runtime_name: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_serverless_runtimes_start_failed_serverless_runtime_request(
            resource_group_name=resource_group_name,
            organization_name=organization_name,
            serverless_runtime_name=serverless_runtime_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def serverless_resource_by_id(
        self, resource_group_name: str, organization_name: str, serverless_runtime_name: str, **kwargs: Any
    ) -> _models.InformaticaServerlessRuntimeResource:
        # pylint: disable=line-too-long
        """Returns a serverless runtime resource by ID.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Name of the Organizations resource. Required.
        :type organization_name: str
        :param serverless_runtime_name: Name of the Serverless Runtime resource. Required.
        :type serverless_runtime_name: str
        :return: InformaticaServerlessRuntimeResource. The InformaticaServerlessRuntimeResource is
         compatible with MutableMapping
        :rtype: ~azure.mgmt.informaticadatamanagement.models.InformaticaServerlessRuntimeResource
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "serverlessAccountLocation": "str",  # Serverless account creation
                          location. Required.
                        "advancedCustomProperties": [
                            {
                                "key": "str",  # Optional. advanced custom properties
                                  key.
                                "value": "str"  # Optional. advanced custom
                                  properties value.
                            }
                        ],
                        "applicationType": "str",  # Optional. Application type of the
                          Serverless Runtime environment. Known values are: "CDI" and "CDIE".
                        "computeUnits": "str",  # Optional. Compute units of the serverless
                          runtime.
                        "description": "str",  # Optional. description of the serverless
                          runtime.
                        "executionTimeout": "str",  # Optional. Serverless Execution timeout.
                        "platform": "str",  # Optional. Platform type of the Serverless
                          Runtime. "AZURE"
                        "provisioningState": "str",  # Optional. Provisioning State of the
                          resource. Known values are: "Accepted", "Creating", "Updating", "Deleting",
                          "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
                        "serverlessRuntimeConfig": {
                            "cdiConfigProps": [
                                {
                                    "applicationConfigs": [
                                        {
                                            "customized": "str",  #
                                              Customized value of the application config. Required.
                                            "defaultValue": "str",  #
                                              Default value of the application config. Required.
                                            "name": "str",  # Name of the
                                              application config. Required.
                                            "platform": "str",  #
                                              Platform type of the application config. Required.
                                            "type": "str",  # Type of the
                                              application config. Required.
                                            "value": "str"  # Value of
                                              the application config. Required.
                                        }
                                    ],
                                    "engineName": "str",  # EngineName of the
                                      application config. Required.
                                    "engineVersion": "str"  # EngineVersion of
                                      the application config. Required.
                                }
                            ],
                            "cdieConfigProps": [
                                {
                                    "applicationConfigs": [
                                        {
                                            "customized": "str",  #
                                              Customized value of the application config. Required.
                                            "defaultValue": "str",  #
                                              Default value of the application config. Required.
                                            "name": "str",  # Name of the
                                              application config. Required.
                                            "platform": "str",  #
                                              Platform type of the application config. Required.
                                            "type": "str",  # Type of the
                                              application config. Required.
                                            "value": "str"  # Value of
                                              the application config. Required.
                                        }
                                    ],
                                    "engineName": "str",  # EngineName of the
                                      application config. Required.
                                    "engineVersion": "str"  # EngineVersion of
                                      the application config. Required.
                                }
                            ]
                        },
                        "serverlessRuntimeNetworkProfile": {
                            "networkInterfaceConfiguration": {
                                "subnetId": "str",  # Virtual network subnet resource
                                  id. Required.
                                "vnetId": "str",  # Virtual network resource id.
                                  Required.
                                "vnetResourceGuid": "str"  # Optional. Virtual
                                  network resource guid.
                            }
                        },
                        "serverlessRuntimeTags": [
                            {
                                "name": "str",  # Optional. The name (also known as
                                  the key) of the tag.
                                "value": "str"  # Optional. The value of the tag.
                            }
                        ],
                        "serverlessRuntimeUserContextProperties": {
                            "userContextToken": "str"  # User context token for OBO flow.
                              Required.
                        },
                        "supplementaryFileLocation": "str"  # Optional. Supplementary file
                          location.
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.InformaticaServerlessRuntimeResource] = kwargs.pop("cls", None)

        _request = build_serverless_runtimes_serverless_resource_by_id_request(
            resource_group_name=resource_group_name,
            organization_name=organization_name,
            serverless_runtime_name=serverless_runtime_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.InformaticaServerlessRuntimeResource, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
