# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, IO, Union

from azure.identity import DefaultAzureCredential

from azure.mgmt.appcontainers import ContainerAppsAPIClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-appcontainers
# USAGE
    python builds_create_or_update.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ContainerAppsAPIClient(
        credential=DefaultAzureCredential(),
        subscription_id="00000000-0000-0000-0000-000000000000",
    )

    response = client.builds.begin_create_or_update(
        resource_group_name="rg",
        builder_name="testBuilder",
        build_name="testBuild-123456789az",
        build_envelope={
            "properties": {
                "configuration": {
                    "baseOs": "DebianBullseye",
                    "environmentVariables": [{"name": "foo1", "value": "bar1"}, {"name": "foo2", "value": "bar2"}],
                    "platform": "dotnetcore",
                    "platformVersion": "7.0",
                    "preBuildSteps": [
                        {
                            "description": "First pre build step.",
                            "httpGet": {
                                "fileName": "output.txt",
                                "headers": ["foo", "bar"],
                                "url": "https://microsoft.com",
                            },
                            "scripts": ["echo 'hello'", "echo 'world'"],
                        },
                        {
                            "description": "Second pre build step.",
                            "httpGet": {"fileName": "output.txt", "headers": ["foo"], "url": "https://microsoft.com"},
                            "scripts": ["echo 'hello'", "echo 'again'"],
                        },
                    ],
                },
                "destinationContainerRegistry": {"image": "test.azurecr.io/repo:tag", "server": "test.azurecr.io"},
            }
        },
    ).result()
    print(response)


# x-ms-original-file: specification/app/resource-manager/Microsoft.App/preview/2023-11-02-preview/examples/Builds_CreateOrUpdate.json
if __name__ == "__main__":
    main()
