# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.storagecache.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.storagecache.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class AmlFilesystem(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """An AML file system instance. Follows Azure Resource Manager standards:
    https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/resource-api-reference.md.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.storagecache.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar identity: The managed identity used by the AML file system, if configured.
    :vartype identity: ~azure.mgmt.storagecache.models.AmlFilesystemIdentity
    :ivar sku: SKU for the resource.
    :vartype sku: ~azure.mgmt.storagecache.models.SkuName
    :ivar zones: Availability zones for resources. This field should only contain a single element
     in the array.
    :vartype zones: list[str]
    :ivar storage_capacity_ti_b: The size of the AML file system, in TiB. This might be rounded up.
    :vartype storage_capacity_ti_b: float
    :ivar health: Health of the AML file system.
    :vartype health: ~azure.mgmt.storagecache.models.AmlFilesystemHealth
    :ivar provisioning_state: ARM provisioning state. Known values are: "Succeeded", "Failed",
     "Creating", "Deleting", "Updating", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.storagecache.models.AmlFilesystemProvisioningStateType
    :ivar filesystem_subnet: Subnet used for managing the AML file system and for client-facing
     operations. This subnet should have at least a /24 subnet mask within the VNET's address space.
    :vartype filesystem_subnet: str
    :ivar client_info: Client information for the AML file system.
    :vartype client_info: ~azure.mgmt.storagecache.models.AmlFilesystemClientInfo
    :ivar throughput_provisioned_m_bps: Throughput provisioned in MB per sec, calculated as
     storageCapacityTiB * per-unit storage throughput.
    :vartype throughput_provisioned_m_bps: int
    :ivar encryption_settings: Specifies encryption settings of the AML file system.
    :vartype encryption_settings: ~azure.mgmt.storagecache.models.AmlFilesystemEncryptionSettings
    :ivar maintenance_window: Start time of a 30-minute weekly maintenance window.
    :vartype maintenance_window:
     ~azure.mgmt.storagecache.models.AmlFilesystemPropertiesMaintenanceWindow
    :ivar hsm: Hydration and archive settings and status.
    :vartype hsm: ~azure.mgmt.storagecache.models.AmlFilesystemPropertiesHsm
    :ivar root_squash_settings: Specifies root squash settings of the AML file system.
    :vartype root_squash_settings: ~azure.mgmt.storagecache.models.AmlFilesystemRootSquashSettings
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "health": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "client_info": {"readonly": True},
        "throughput_provisioned_m_bps": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "AmlFilesystemIdentity"},
        "sku": {"key": "sku", "type": "SkuName"},
        "zones": {"key": "zones", "type": "[str]"},
        "storage_capacity_ti_b": {"key": "properties.storageCapacityTiB", "type": "float"},
        "health": {"key": "properties.health", "type": "AmlFilesystemHealth"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "filesystem_subnet": {"key": "properties.filesystemSubnet", "type": "str"},
        "client_info": {"key": "properties.clientInfo", "type": "AmlFilesystemClientInfo"},
        "throughput_provisioned_m_bps": {"key": "properties.throughputProvisionedMBps", "type": "int"},
        "encryption_settings": {"key": "properties.encryptionSettings", "type": "AmlFilesystemEncryptionSettings"},
        "maintenance_window": {
            "key": "properties.maintenanceWindow",
            "type": "AmlFilesystemPropertiesMaintenanceWindow",
        },
        "hsm": {"key": "properties.hsm", "type": "AmlFilesystemPropertiesHsm"},
        "root_squash_settings": {"key": "properties.rootSquashSettings", "type": "AmlFilesystemRootSquashSettings"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.AmlFilesystemIdentity"] = None,
        sku: Optional["_models.SkuName"] = None,
        zones: Optional[List[str]] = None,
        storage_capacity_ti_b: Optional[float] = None,
        filesystem_subnet: Optional[str] = None,
        encryption_settings: Optional["_models.AmlFilesystemEncryptionSettings"] = None,
        maintenance_window: Optional["_models.AmlFilesystemPropertiesMaintenanceWindow"] = None,
        hsm: Optional["_models.AmlFilesystemPropertiesHsm"] = None,
        root_squash_settings: Optional["_models.AmlFilesystemRootSquashSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: The managed identity used by the AML file system, if configured.
        :paramtype identity: ~azure.mgmt.storagecache.models.AmlFilesystemIdentity
        :keyword sku: SKU for the resource.
        :paramtype sku: ~azure.mgmt.storagecache.models.SkuName
        :keyword zones: Availability zones for resources. This field should only contain a single
         element in the array.
        :paramtype zones: list[str]
        :keyword storage_capacity_ti_b: The size of the AML file system, in TiB. This might be rounded
         up.
        :paramtype storage_capacity_ti_b: float
        :keyword filesystem_subnet: Subnet used for managing the AML file system and for client-facing
         operations. This subnet should have at least a /24 subnet mask within the VNET's address space.
        :paramtype filesystem_subnet: str
        :keyword encryption_settings: Specifies encryption settings of the AML file system.
        :paramtype encryption_settings: ~azure.mgmt.storagecache.models.AmlFilesystemEncryptionSettings
        :keyword maintenance_window: Start time of a 30-minute weekly maintenance window.
        :paramtype maintenance_window:
         ~azure.mgmt.storagecache.models.AmlFilesystemPropertiesMaintenanceWindow
        :keyword hsm: Hydration and archive settings and status.
        :paramtype hsm: ~azure.mgmt.storagecache.models.AmlFilesystemPropertiesHsm
        :keyword root_squash_settings: Specifies root squash settings of the AML file system.
        :paramtype root_squash_settings:
         ~azure.mgmt.storagecache.models.AmlFilesystemRootSquashSettings
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.sku = sku
        self.zones = zones
        self.storage_capacity_ti_b = storage_capacity_ti_b
        self.health = None
        self.provisioning_state = None
        self.filesystem_subnet = filesystem_subnet
        self.client_info = None
        self.throughput_provisioned_m_bps = None
        self.encryption_settings = encryption_settings
        self.maintenance_window = maintenance_window
        self.hsm = hsm
        self.root_squash_settings = root_squash_settings


class AmlFilesystemArchive(_serialization.Model):
    """Information about the AML file system archive.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar filesystem_path: Lustre file system path to archive relative to the file system root.
     Specify '/' to archive all modified data.
    :vartype filesystem_path: str
    :ivar status: The status of the archive.
    :vartype status: ~azure.mgmt.storagecache.models.AmlFilesystemArchiveStatus
    """

    _validation = {
        "filesystem_path": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "filesystem_path": {"key": "filesystemPath", "type": "str"},
        "status": {"key": "status", "type": "AmlFilesystemArchiveStatus"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.filesystem_path = None
        self.status = None


class AmlFilesystemArchiveInfo(_serialization.Model):
    """Information required to execute the archive operation.

    :ivar filesystem_path: Lustre file system path to archive relative to the file system root.
     Specify '/' to archive all modified data.
    :vartype filesystem_path: str
    """

    _attribute_map = {
        "filesystem_path": {"key": "filesystemPath", "type": "str"},
    }

    def __init__(self, *, filesystem_path: str = "/", **kwargs: Any) -> None:
        """
        :keyword filesystem_path: Lustre file system path to archive relative to the file system root.
         Specify '/' to archive all modified data.
        :paramtype filesystem_path: str
        """
        super().__init__(**kwargs)
        self.filesystem_path = filesystem_path


class AmlFilesystemArchiveStatus(_serialization.Model):
    """The status of the archive.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar state: The state of the archive operation. Known values are: "NotConfigured", "Idle",
     "InProgress", "Canceled", "Completed", "Failed", "Cancelling", and "FSScanInProgress".
    :vartype state: str or ~azure.mgmt.storagecache.models.ArchiveStatusType
    :ivar last_completion_time: The time of the last completed archive operation.
    :vartype last_completion_time: ~datetime.datetime
    :ivar last_started_time: The time the latest archive operation started.
    :vartype last_started_time: ~datetime.datetime
    :ivar percent_complete: The completion percentage of the archive operation.
    :vartype percent_complete: int
    :ivar error_code: Server-defined error code for the archive operation.
    :vartype error_code: str
    :ivar error_message: Server-defined error message for the archive operation.
    :vartype error_message: str
    """

    _validation = {
        "state": {"readonly": True},
        "last_completion_time": {"readonly": True},
        "last_started_time": {"readonly": True},
        "percent_complete": {"readonly": True},
        "error_code": {"readonly": True},
        "error_message": {"readonly": True},
    }

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
        "last_completion_time": {"key": "lastCompletionTime", "type": "iso-8601"},
        "last_started_time": {"key": "lastStartedTime", "type": "iso-8601"},
        "percent_complete": {"key": "percentComplete", "type": "int"},
        "error_code": {"key": "errorCode", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.state = None
        self.last_completion_time = None
        self.last_started_time = None
        self.percent_complete = None
        self.error_code = None
        self.error_message = None


class AmlFilesystemCheckSubnetError(_serialization.Model):
    """The error details provided when the checkAmlFSSubnets call fails.

    :ivar filesystem_subnet: The error details for the AML file system's subnet.
    :vartype filesystem_subnet:
     ~azure.mgmt.storagecache.models.AmlFilesystemCheckSubnetErrorFilesystemSubnet
    """

    _attribute_map = {
        "filesystem_subnet": {"key": "filesystemSubnet", "type": "AmlFilesystemCheckSubnetErrorFilesystemSubnet"},
    }

    def __init__(
        self,
        *,
        filesystem_subnet: Optional["_models.AmlFilesystemCheckSubnetErrorFilesystemSubnet"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword filesystem_subnet: The error details for the AML file system's subnet.
        :paramtype filesystem_subnet:
         ~azure.mgmt.storagecache.models.AmlFilesystemCheckSubnetErrorFilesystemSubnet
        """
        super().__init__(**kwargs)
        self.filesystem_subnet = filesystem_subnet


class AmlFilesystemCheckSubnetErrorFilesystemSubnet(_serialization.Model):
    """The error details for the AML file system's subnet.

    :ivar status: The status of the AML file system subnet check. Known values are: "Ok" and
     "Invalid".
    :vartype status: str or ~azure.mgmt.storagecache.models.FilesystemSubnetStatusType
    :ivar message: The details of the AML file system subnet check.
    :vartype message: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.FilesystemSubnetStatusType"]] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: The status of the AML file system subnet check. Known values are: "Ok" and
         "Invalid".
        :paramtype status: str or ~azure.mgmt.storagecache.models.FilesystemSubnetStatusType
        :keyword message: The details of the AML file system subnet check.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.message = message


class AmlFilesystemClientInfo(_serialization.Model):
    """AML file system client information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar mgs_address: The IPv4 address used by clients to mount the AML file system's Lustre
     Management Service (MGS).
    :vartype mgs_address: str
    :ivar mount_command: Recommended command to mount the AML file system.
    :vartype mount_command: str
    :ivar lustre_version: The version of Lustre running in the AML file system.
    :vartype lustre_version: str
    :ivar container_storage_interface: Container Storage Interface information for the AML file
     system.
    :vartype container_storage_interface:
     ~azure.mgmt.storagecache.models.AmlFilesystemContainerStorageInterface
    """

    _validation = {
        "mgs_address": {"readonly": True},
        "mount_command": {"readonly": True},
        "lustre_version": {"readonly": True},
        "container_storage_interface": {"readonly": True},
    }

    _attribute_map = {
        "mgs_address": {"key": "mgsAddress", "type": "str"},
        "mount_command": {"key": "mountCommand", "type": "str"},
        "lustre_version": {"key": "lustreVersion", "type": "str"},
        "container_storage_interface": {
            "key": "containerStorageInterface",
            "type": "AmlFilesystemContainerStorageInterface",
        },
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.mgs_address = None
        self.mount_command = None
        self.lustre_version = None
        self.container_storage_interface = None


class AmlFilesystemContainerStorageInterface(_serialization.Model):
    """AML file system container storage interface information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar persistent_volume_claim: Recommended AKS Persistent Volume Claim for the CSI driver, in
     Base64 encoded YAML.
    :vartype persistent_volume_claim: str
    :ivar persistent_volume: Recommended AKS Persistent Volume for the CSI driver, in Base64
     encoded YAML.
    :vartype persistent_volume: str
    :ivar storage_class: Recommended AKS Storage Class for the CSI driver, in Base64 encoded YAML.
    :vartype storage_class: str
    """

    _validation = {
        "persistent_volume_claim": {"readonly": True},
        "persistent_volume": {"readonly": True},
        "storage_class": {"readonly": True},
    }

    _attribute_map = {
        "persistent_volume_claim": {"key": "persistentVolumeClaim", "type": "str"},
        "persistent_volume": {"key": "persistentVolume", "type": "str"},
        "storage_class": {"key": "storageClass", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.persistent_volume_claim = None
        self.persistent_volume = None
        self.storage_class = None


class AmlFilesystemEncryptionSettings(_serialization.Model):
    """AML file system encryption settings.

    :ivar key_encryption_key: Specifies the location of the encryption key in Key Vault.
    :vartype key_encryption_key: ~azure.mgmt.storagecache.models.KeyVaultKeyReference
    """

    _attribute_map = {
        "key_encryption_key": {"key": "keyEncryptionKey", "type": "KeyVaultKeyReference"},
    }

    def __init__(self, *, key_encryption_key: Optional["_models.KeyVaultKeyReference"] = None, **kwargs: Any) -> None:
        """
        :keyword key_encryption_key: Specifies the location of the encryption key in Key Vault.
        :paramtype key_encryption_key: ~azure.mgmt.storagecache.models.KeyVaultKeyReference
        """
        super().__init__(**kwargs)
        self.key_encryption_key = key_encryption_key


class AmlFilesystemHealth(_serialization.Model):
    """An indication of AML file system health. Gives more information about health than just that
    related to provisioning.

    :ivar state: List of AML file system health states. Known values are: "Unavailable",
     "Available", "Degraded", "Transitioning", and "Maintenance".
    :vartype state: str or ~azure.mgmt.storagecache.models.AmlFilesystemHealthStateType
    :ivar status_code: Server-defined error code for the AML file system health.
    :vartype status_code: str
    :ivar status_description: Describes the health state.
    :vartype status_description: str
    """

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
        "status_code": {"key": "statusCode", "type": "str"},
        "status_description": {"key": "statusDescription", "type": "str"},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.AmlFilesystemHealthStateType"]] = None,
        status_code: Optional[str] = None,
        status_description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword state: List of AML file system health states. Known values are: "Unavailable",
         "Available", "Degraded", "Transitioning", and "Maintenance".
        :paramtype state: str or ~azure.mgmt.storagecache.models.AmlFilesystemHealthStateType
        :keyword status_code: Server-defined error code for the AML file system health.
        :paramtype status_code: str
        :keyword status_description: Describes the health state.
        :paramtype status_description: str
        """
        super().__init__(**kwargs)
        self.state = state
        self.status_code = status_code
        self.status_description = status_description


class AmlFilesystemHsmSettings(_serialization.Model):
    """AML file system HSM settings.

    All required parameters must be populated in order to send to Azure.

    :ivar container: Resource ID of storage container used for hydrating the namespace and
     archiving from the namespace. The resource provider must have permission to create SAS tokens
     on the storage account. Required.
    :vartype container: str
    :ivar logging_container: Resource ID of storage container used for logging events and errors.
     Must be a separate container in the same storage account as the hydration and archive
     container. The resource provider must have permission to create SAS tokens on the storage
     account. Required.
    :vartype logging_container: str
    :ivar import_prefix: Only blobs in the non-logging container that start with this path/prefix
     get hydrated into the cluster namespace.
    :vartype import_prefix: str
    """

    _validation = {
        "container": {"required": True},
        "logging_container": {"required": True},
    }

    _attribute_map = {
        "container": {"key": "container", "type": "str"},
        "logging_container": {"key": "loggingContainer", "type": "str"},
        "import_prefix": {"key": "importPrefix", "type": "str"},
    }

    def __init__(self, *, container: str, logging_container: str, import_prefix: str = "/", **kwargs: Any) -> None:
        """
        :keyword container: Resource ID of storage container used for hydrating the namespace and
         archiving from the namespace. The resource provider must have permission to create SAS tokens
         on the storage account. Required.
        :paramtype container: str
        :keyword logging_container: Resource ID of storage container used for logging events and
         errors.  Must be a separate container in the same storage account as the hydration and archive
         container. The resource provider must have permission to create SAS tokens on the storage
         account. Required.
        :paramtype logging_container: str
        :keyword import_prefix: Only blobs in the non-logging container that start with this
         path/prefix get hydrated into the cluster namespace.
        :paramtype import_prefix: str
        """
        super().__init__(**kwargs)
        self.container = container
        self.logging_container = logging_container
        self.import_prefix = import_prefix


class AmlFilesystemIdentity(_serialization.Model):
    """Managed Identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID for the user-assigned identity of the resource.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID associated with the resource.
    :vartype tenant_id: str
    :ivar type: The type of identity used for the resource. Known values are: "UserAssigned" and
     "None".
    :vartype type: str or ~azure.mgmt.storagecache.models.AmlFilesystemIdentityType
    :ivar user_assigned_identities: A dictionary where each key is a user assigned identity
     resource ID, and each key's value is an empty dictionary.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.storagecache.models.UserAssignedIdentitiesValue]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentitiesValue}"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.AmlFilesystemIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentitiesValue"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of identity used for the resource. Known values are: "UserAssigned" and
         "None".
        :paramtype type: str or ~azure.mgmt.storagecache.models.AmlFilesystemIdentityType
        :keyword user_assigned_identities: A dictionary where each key is a user assigned identity
         resource ID, and each key's value is an empty dictionary.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.storagecache.models.UserAssignedIdentitiesValue]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class AmlFilesystemPropertiesHsm(_serialization.Model):
    """Hydration and archive settings and status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar settings: Specifies HSM settings of the AML file system.
    :vartype settings: ~azure.mgmt.storagecache.models.AmlFilesystemHsmSettings
    :ivar archive_status: Archive status.
    :vartype archive_status: list[~azure.mgmt.storagecache.models.AmlFilesystemArchive]
    """

    _validation = {
        "archive_status": {"readonly": True},
    }

    _attribute_map = {
        "settings": {"key": "settings", "type": "AmlFilesystemHsmSettings"},
        "archive_status": {"key": "archiveStatus", "type": "[AmlFilesystemArchive]"},
    }

    def __init__(self, *, settings: Optional["_models.AmlFilesystemHsmSettings"] = None, **kwargs: Any) -> None:
        """
        :keyword settings: Specifies HSM settings of the AML file system.
        :paramtype settings: ~azure.mgmt.storagecache.models.AmlFilesystemHsmSettings
        """
        super().__init__(**kwargs)
        self.settings = settings
        self.archive_status = None


class AmlFilesystemPropertiesMaintenanceWindow(_serialization.Model):
    """Start time of a 30-minute weekly maintenance window.

    :ivar day_of_week: Day of the week on which the maintenance window will occur. Known values
     are: "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", and "Sunday".
    :vartype day_of_week: str or ~azure.mgmt.storagecache.models.MaintenanceDayOfWeekType
    :ivar time_of_day_utc: The time of day (in UTC) to start the maintenance window.
    :vartype time_of_day_utc: str
    """

    _validation = {
        "time_of_day_utc": {"pattern": r"^([0-9]|0[0-9]|1[0-9]|2[0-3]):[0-5][0-9]$"},
    }

    _attribute_map = {
        "day_of_week": {"key": "dayOfWeek", "type": "str"},
        "time_of_day_utc": {"key": "timeOfDayUTC", "type": "str"},
    }

    def __init__(
        self,
        *,
        day_of_week: Optional[Union[str, "_models.MaintenanceDayOfWeekType"]] = None,
        time_of_day_utc: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword day_of_week: Day of the week on which the maintenance window will occur. Known values
         are: "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", and "Sunday".
        :paramtype day_of_week: str or ~azure.mgmt.storagecache.models.MaintenanceDayOfWeekType
        :keyword time_of_day_utc: The time of day (in UTC) to start the maintenance window.
        :paramtype time_of_day_utc: str
        """
        super().__init__(**kwargs)
        self.day_of_week = day_of_week
        self.time_of_day_utc = time_of_day_utc


class AmlFilesystemRootSquashSettings(_serialization.Model):
    """AML file system squash settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar mode: Squash mode of the AML file system. 'All': User and Group IDs on files will be
     squashed to the provided values for all users on non-trusted systems. 'RootOnly': User and
     Group IDs on files will be squashed to provided values for solely the root user on non-trusted
     systems. 'None': No squashing of User and Group IDs is performed for any users on any systems.
     Known values are: "None", "RootOnly", and "All".
    :vartype mode: str or ~azure.mgmt.storagecache.models.AmlFilesystemSquashMode
    :ivar no_squash_nid_lists: Semicolon separated NID IP Address list(s) to be added to the
     TrustedSystems.
    :vartype no_squash_nid_lists: str
    :ivar squash_uid: User ID to squash to.
    :vartype squash_uid: int
    :ivar squash_gid: Group ID to squash to.
    :vartype squash_gid: int
    :ivar status: AML file system squash status.
    :vartype status: str
    """

    _validation = {
        "status": {"readonly": True},
    }

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
        "no_squash_nid_lists": {"key": "noSquashNidLists", "type": "str"},
        "squash_uid": {"key": "squashUID", "type": "int"},
        "squash_gid": {"key": "squashGID", "type": "int"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        mode: Optional[Union[str, "_models.AmlFilesystemSquashMode"]] = None,
        no_squash_nid_lists: Optional[str] = None,
        squash_uid: Optional[int] = None,
        squash_gid: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mode: Squash mode of the AML file system. 'All': User and Group IDs on files will be
         squashed to the provided values for all users on non-trusted systems. 'RootOnly': User and
         Group IDs on files will be squashed to provided values for solely the root user on non-trusted
         systems. 'None': No squashing of User and Group IDs is performed for any users on any systems.
         Known values are: "None", "RootOnly", and "All".
        :paramtype mode: str or ~azure.mgmt.storagecache.models.AmlFilesystemSquashMode
        :keyword no_squash_nid_lists: Semicolon separated NID IP Address list(s) to be added to the
         TrustedSystems.
        :paramtype no_squash_nid_lists: str
        :keyword squash_uid: User ID to squash to.
        :paramtype squash_uid: int
        :keyword squash_gid: Group ID to squash to.
        :paramtype squash_gid: int
        """
        super().__init__(**kwargs)
        self.mode = mode
        self.no_squash_nid_lists = no_squash_nid_lists
        self.squash_uid = squash_uid
        self.squash_gid = squash_gid
        self.status = None


class AmlFilesystemsListResult(_serialization.Model):
    """Result of the request to list AML file systems. It contains a list of AML file systems and a
    URL link to get the next set of results.

    :ivar next_link: URL to get the next set of AML file system list results, if there are any.
    :vartype next_link: str
    :ivar value: List of AML file systems.
    :vartype value: list[~azure.mgmt.storagecache.models.AmlFilesystem]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[AmlFilesystem]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.AmlFilesystem"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: URL to get the next set of AML file system list results, if there are any.
        :paramtype next_link: str
        :keyword value: List of AML file systems.
        :paramtype value: list[~azure.mgmt.storagecache.models.AmlFilesystem]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class AmlFilesystemSubnetInfo(_serialization.Model):
    """Information required to validate the subnet that will be used in AML file system create.

    :ivar filesystem_subnet: Subnet used for managing the AML file system and for client-facing
     operations. This subnet should have at least a /24 subnet mask within the VNET's address space.
    :vartype filesystem_subnet: str
    :ivar storage_capacity_ti_b: The size of the AML file system, in TiB.
    :vartype storage_capacity_ti_b: float
    :ivar sku: SKU for the resource.
    :vartype sku: ~azure.mgmt.storagecache.models.SkuName
    :ivar location: Region that the AML file system will be created in.
    :vartype location: str
    """

    _attribute_map = {
        "filesystem_subnet": {"key": "filesystemSubnet", "type": "str"},
        "storage_capacity_ti_b": {"key": "storageCapacityTiB", "type": "float"},
        "sku": {"key": "sku", "type": "SkuName"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(
        self,
        *,
        filesystem_subnet: Optional[str] = None,
        storage_capacity_ti_b: Optional[float] = None,
        sku: Optional["_models.SkuName"] = None,
        location: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword filesystem_subnet: Subnet used for managing the AML file system and for client-facing
         operations. This subnet should have at least a /24 subnet mask within the VNET's address space.
        :paramtype filesystem_subnet: str
        :keyword storage_capacity_ti_b: The size of the AML file system, in TiB.
        :paramtype storage_capacity_ti_b: float
        :keyword sku: SKU for the resource.
        :paramtype sku: ~azure.mgmt.storagecache.models.SkuName
        :keyword location: Region that the AML file system will be created in.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.filesystem_subnet = filesystem_subnet
        self.storage_capacity_ti_b = storage_capacity_ti_b
        self.sku = sku
        self.location = location


class AmlFilesystemUpdate(_serialization.Model):
    """An AML file system update instance.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar encryption_settings: Specifies encryption settings of the AML file system.
    :vartype encryption_settings: ~azure.mgmt.storagecache.models.AmlFilesystemEncryptionSettings
    :ivar maintenance_window: Start time of a 30-minute weekly maintenance window.
    :vartype maintenance_window:
     ~azure.mgmt.storagecache.models.AmlFilesystemUpdatePropertiesMaintenanceWindow
    :ivar root_squash_settings: Specifies root squash settings of the AML file system.
    :vartype root_squash_settings: ~azure.mgmt.storagecache.models.AmlFilesystemRootSquashSettings
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "encryption_settings": {"key": "properties.encryptionSettings", "type": "AmlFilesystemEncryptionSettings"},
        "maintenance_window": {
            "key": "properties.maintenanceWindow",
            "type": "AmlFilesystemUpdatePropertiesMaintenanceWindow",
        },
        "root_squash_settings": {"key": "properties.rootSquashSettings", "type": "AmlFilesystemRootSquashSettings"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        encryption_settings: Optional["_models.AmlFilesystemEncryptionSettings"] = None,
        maintenance_window: Optional["_models.AmlFilesystemUpdatePropertiesMaintenanceWindow"] = None,
        root_squash_settings: Optional["_models.AmlFilesystemRootSquashSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword encryption_settings: Specifies encryption settings of the AML file system.
        :paramtype encryption_settings: ~azure.mgmt.storagecache.models.AmlFilesystemEncryptionSettings
        :keyword maintenance_window: Start time of a 30-minute weekly maintenance window.
        :paramtype maintenance_window:
         ~azure.mgmt.storagecache.models.AmlFilesystemUpdatePropertiesMaintenanceWindow
        :keyword root_squash_settings: Specifies root squash settings of the AML file system.
        :paramtype root_squash_settings:
         ~azure.mgmt.storagecache.models.AmlFilesystemRootSquashSettings
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.encryption_settings = encryption_settings
        self.maintenance_window = maintenance_window
        self.root_squash_settings = root_squash_settings


class AmlFilesystemUpdatePropertiesMaintenanceWindow(_serialization.Model):
    """Start time of a 30-minute weekly maintenance window.

    :ivar day_of_week: Day of the week on which the maintenance window will occur. Known values
     are: "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", and "Sunday".
    :vartype day_of_week: str or ~azure.mgmt.storagecache.models.MaintenanceDayOfWeekType
    :ivar time_of_day_utc: The time of day (in UTC) to start the maintenance window.
    :vartype time_of_day_utc: str
    """

    _validation = {
        "time_of_day_utc": {"pattern": r"^([0-9]|0[0-9]|1[0-9]|2[0-3]):[0-5][0-9]$"},
    }

    _attribute_map = {
        "day_of_week": {"key": "dayOfWeek", "type": "str"},
        "time_of_day_utc": {"key": "timeOfDayUTC", "type": "str"},
    }

    def __init__(
        self,
        *,
        day_of_week: Optional[Union[str, "_models.MaintenanceDayOfWeekType"]] = None,
        time_of_day_utc: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword day_of_week: Day of the week on which the maintenance window will occur. Known values
         are: "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", and "Sunday".
        :paramtype day_of_week: str or ~azure.mgmt.storagecache.models.MaintenanceDayOfWeekType
        :keyword time_of_day_utc: The time of day (in UTC) to start the maintenance window.
        :paramtype time_of_day_utc: str
        """
        super().__init__(**kwargs)
        self.day_of_week = day_of_week
        self.time_of_day_utc = time_of_day_utc


class ApiOperation(_serialization.Model):
    """REST API operation description: see
    https://github.com/Azure/azure-rest-api-specs/blob/master/documentation/openapi-authoring-automated-guidelines.md#r3023-operationsapiimplementation.

    :ivar display: The object that represents the operation.
    :vartype display: ~azure.mgmt.storagecache.models.ApiOperationDisplay
    :ivar origin: Origin of the operation.
    :vartype origin: str
    :ivar is_data_action: The flag that indicates whether the operation applies to data plane.
    :vartype is_data_action: bool
    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar service_specification: Specification of the all the metrics provided for a resource type.
    :vartype service_specification:
     ~azure.mgmt.storagecache.models.ApiOperationPropertiesServiceSpecification
    """

    _attribute_map = {
        "display": {"key": "display", "type": "ApiOperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "name": {"key": "name", "type": "str"},
        "service_specification": {
            "key": "properties.serviceSpecification",
            "type": "ApiOperationPropertiesServiceSpecification",
        },
    }

    def __init__(
        self,
        *,
        display: Optional["_models.ApiOperationDisplay"] = None,
        origin: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        name: Optional[str] = None,
        service_specification: Optional["_models.ApiOperationPropertiesServiceSpecification"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display: The object that represents the operation.
        :paramtype display: ~azure.mgmt.storagecache.models.ApiOperationDisplay
        :keyword origin: Origin of the operation.
        :paramtype origin: str
        :keyword is_data_action: The flag that indicates whether the operation applies to data plane.
        :paramtype is_data_action: bool
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword service_specification: Specification of the all the metrics provided for a resource
         type.
        :paramtype service_specification:
         ~azure.mgmt.storagecache.models.ApiOperationPropertiesServiceSpecification
        """
        super().__init__(**kwargs)
        self.display = display
        self.origin = origin
        self.is_data_action = is_data_action
        self.name = name
        self.service_specification = service_specification


class ApiOperationDisplay(_serialization.Model):
    """The object that represents the operation.

    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    :ivar provider: Service provider: Microsoft.StorageCache.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: Cache, etc.
    :vartype resource: str
    :ivar description: The description of the operation.
    :vartype description: str
    """

    _attribute_map = {
        "operation": {"key": "operation", "type": "str"},
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        operation: Optional[str] = None,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword operation: Operation type: Read, write, delete, etc.
        :paramtype operation: str
        :keyword provider: Service provider: Microsoft.StorageCache.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed: Cache, etc.
        :paramtype resource: str
        :keyword description: The description of the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.operation = operation
        self.provider = provider
        self.resource = resource
        self.description = description


class ApiOperationListResult(_serialization.Model):
    """Result of the request to list Resource Provider operations. It contains a list of operations
    and a URL link to get the next set of results.

    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    :ivar value: List of Resource Provider operations supported by the Microsoft.StorageCache
     resource provider.
    :vartype value: list[~azure.mgmt.storagecache.models.ApiOperation]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[ApiOperation]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.ApiOperation"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        :keyword value: List of Resource Provider operations supported by the Microsoft.StorageCache
         resource provider.
        :paramtype value: list[~azure.mgmt.storagecache.models.ApiOperation]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ApiOperationPropertiesServiceSpecification(_serialization.Model):
    """Specification of the all the metrics provided for a resource type.

    :ivar metric_specifications: Details about operations related to metrics.
    :vartype metric_specifications: list[~azure.mgmt.storagecache.models.MetricSpecification]
    :ivar log_specifications: Details about operations related to logs.
    :vartype log_specifications: list[~azure.mgmt.storagecache.models.LogSpecification]
    """

    _attribute_map = {
        "metric_specifications": {"key": "metricSpecifications", "type": "[MetricSpecification]"},
        "log_specifications": {"key": "logSpecifications", "type": "[LogSpecification]"},
    }

    def __init__(
        self,
        *,
        metric_specifications: Optional[List["_models.MetricSpecification"]] = None,
        log_specifications: Optional[List["_models.LogSpecification"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword metric_specifications: Details about operations related to metrics.
        :paramtype metric_specifications: list[~azure.mgmt.storagecache.models.MetricSpecification]
        :keyword log_specifications: Details about operations related to logs.
        :paramtype log_specifications: list[~azure.mgmt.storagecache.models.LogSpecification]
        """
        super().__init__(**kwargs)
        self.metric_specifications = metric_specifications
        self.log_specifications = log_specifications


class AscOperation(_serialization.Model):
    """The status of operation.

    :ivar id: The operation Id.
    :vartype id: str
    :ivar name: The operation name.
    :vartype name: str
    :ivar start_time: The start time of the operation.
    :vartype start_time: str
    :ivar end_time: The end time of the operation.
    :vartype end_time: str
    :ivar status: The status of the operation.
    :vartype status: str
    :ivar error: The error detail of the operation if any.
    :vartype error: ~azure.mgmt.storagecache.models.ErrorResponse
    :ivar output: Additional operation-specific output.
    :vartype output: dict[str, JSON]
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "start_time": {"key": "startTime", "type": "str"},
        "end_time": {"key": "endTime", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "error": {"key": "error", "type": "ErrorResponse"},
        "output": {"key": "properties.output", "type": "{object}"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        start_time: Optional[str] = None,
        end_time: Optional[str] = None,
        status: Optional[str] = None,
        error: Optional["_models.ErrorResponse"] = None,
        output: Optional[Dict[str, JSON]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The operation Id.
        :paramtype id: str
        :keyword name: The operation name.
        :paramtype name: str
        :keyword start_time: The start time of the operation.
        :paramtype start_time: str
        :keyword end_time: The end time of the operation.
        :paramtype end_time: str
        :keyword status: The status of the operation.
        :paramtype status: str
        :keyword error: The error detail of the operation if any.
        :paramtype error: ~azure.mgmt.storagecache.models.ErrorResponse
        :keyword output: Additional operation-specific output.
        :paramtype output: dict[str, JSON]
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.start_time = start_time
        self.end_time = end_time
        self.status = status
        self.error = error
        self.output = output


class BlobNfsTarget(_serialization.Model):
    """Properties pertaining to the BlobNfsTarget.

    :ivar target: Resource ID of the storage container.
    :vartype target: str
    :ivar usage_model: Identifies the StorageCache usage model to be used for this storage target.
    :vartype usage_model: str
    :ivar verification_timer: Amount of time (in seconds) the cache waits before it checks the
     back-end storage for file updates.
    :vartype verification_timer: int
    :ivar write_back_timer: Amount of time (in seconds) the cache waits after the last file change
     before it copies the changed file to back-end storage.
    :vartype write_back_timer: int
    """

    _attribute_map = {
        "target": {"key": "target", "type": "str"},
        "usage_model": {"key": "usageModel", "type": "str"},
        "verification_timer": {"key": "verificationTimer", "type": "int"},
        "write_back_timer": {"key": "writeBackTimer", "type": "int"},
    }

    def __init__(
        self,
        *,
        target: Optional[str] = None,
        usage_model: Optional[str] = None,
        verification_timer: Optional[int] = None,
        write_back_timer: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target: Resource ID of the storage container.
        :paramtype target: str
        :keyword usage_model: Identifies the StorageCache usage model to be used for this storage
         target.
        :paramtype usage_model: str
        :keyword verification_timer: Amount of time (in seconds) the cache waits before it checks the
         back-end storage for file updates.
        :paramtype verification_timer: int
        :keyword write_back_timer: Amount of time (in seconds) the cache waits after the last file
         change before it copies the changed file to back-end storage.
        :paramtype write_back_timer: int
        """
        super().__init__(**kwargs)
        self.target = target
        self.usage_model = usage_model
        self.verification_timer = verification_timer
        self.write_back_timer = write_back_timer


class Cache(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """A cache instance. Follows Azure Resource Manager standards:
    https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/resource-api-reference.md.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar id: Resource ID of the cache.
    :vartype id: str
    :ivar location: Region name string.
    :vartype location: str
    :ivar name: Name of cache.
    :vartype name: str
    :ivar type: Type of the cache; Microsoft.StorageCache/Cache.
    :vartype type: str
    :ivar identity: The identity of the cache, if configured.
    :vartype identity: ~azure.mgmt.storagecache.models.CacheIdentity
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.storagecache.models.SystemData
    :ivar sku: SKU for the cache.
    :vartype sku: ~azure.mgmt.storagecache.models.CacheSku
    :ivar cache_size_gb: The size of this Cache, in GB.
    :vartype cache_size_gb: int
    :ivar health: Health of the cache.
    :vartype health: ~azure.mgmt.storagecache.models.CacheHealth
    :ivar mount_addresses: Array of IPv4 addresses that can be used by clients mounting this cache.
    :vartype mount_addresses: list[str]
    :ivar provisioning_state: ARM provisioning state, see
     https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/Addendum.md#provisioningstate-property.
     Known values are: "Succeeded", "Failed", "Canceled", "Creating", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.storagecache.models.ProvisioningStateType
    :ivar subnet: Subnet used for the cache.
    :vartype subnet: str
    :ivar upgrade_status: Upgrade status of the cache.
    :vartype upgrade_status: ~azure.mgmt.storagecache.models.CacheUpgradeStatus
    :ivar upgrade_settings: Upgrade settings of the cache.
    :vartype upgrade_settings: ~azure.mgmt.storagecache.models.CacheUpgradeSettings
    :ivar network_settings: Specifies network settings of the cache.
    :vartype network_settings: ~azure.mgmt.storagecache.models.CacheNetworkSettings
    :ivar encryption_settings: Specifies encryption settings of the cache.
    :vartype encryption_settings: ~azure.mgmt.storagecache.models.CacheEncryptionSettings
    :ivar security_settings: Specifies security settings of the cache.
    :vartype security_settings: ~azure.mgmt.storagecache.models.CacheSecuritySettings
    :ivar directory_services_settings: Specifies Directory Services settings of the cache.
    :vartype directory_services_settings: ~azure.mgmt.storagecache.models.CacheDirectorySettings
    :ivar zones: Availability zones for resources. This field should only contain a single element
     in the array.
    :vartype zones: list[str]
    :ivar priming_jobs: Specifies the priming jobs defined in the cache.
    :vartype priming_jobs: list[~azure.mgmt.storagecache.models.PrimingJob]
    :ivar space_allocation: Specifies the space allocation percentage for each storage target in
     the cache.
    :vartype space_allocation: list[~azure.mgmt.storagecache.models.StorageTargetSpaceAllocation]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True, "pattern": r"^[-0-9a-zA-Z_]{1,80}$"},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "health": {"readonly": True},
        "mount_addresses": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "upgrade_status": {"readonly": True},
        "priming_jobs": {"readonly": True},
        "space_allocation": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "id": {"key": "id", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "identity": {"key": "identity", "type": "CacheIdentity"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "sku": {"key": "sku", "type": "CacheSku"},
        "cache_size_gb": {"key": "properties.cacheSizeGB", "type": "int"},
        "health": {"key": "properties.health", "type": "CacheHealth"},
        "mount_addresses": {"key": "properties.mountAddresses", "type": "[str]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "str"},
        "upgrade_status": {"key": "properties.upgradeStatus", "type": "CacheUpgradeStatus"},
        "upgrade_settings": {"key": "properties.upgradeSettings", "type": "CacheUpgradeSettings"},
        "network_settings": {"key": "properties.networkSettings", "type": "CacheNetworkSettings"},
        "encryption_settings": {"key": "properties.encryptionSettings", "type": "CacheEncryptionSettings"},
        "security_settings": {"key": "properties.securitySettings", "type": "CacheSecuritySettings"},
        "directory_services_settings": {
            "key": "properties.directoryServicesSettings",
            "type": "CacheDirectorySettings",
        },
        "zones": {"key": "properties.zones", "type": "[str]"},
        "priming_jobs": {"key": "properties.primingJobs", "type": "[PrimingJob]"},
        "space_allocation": {"key": "properties.spaceAllocation", "type": "[StorageTargetSpaceAllocation]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        identity: Optional["_models.CacheIdentity"] = None,
        sku: Optional["_models.CacheSku"] = None,
        cache_size_gb: Optional[int] = None,
        subnet: Optional[str] = None,
        upgrade_settings: Optional["_models.CacheUpgradeSettings"] = None,
        network_settings: Optional["_models.CacheNetworkSettings"] = None,
        encryption_settings: Optional["_models.CacheEncryptionSettings"] = None,
        security_settings: Optional["_models.CacheSecuritySettings"] = None,
        directory_services_settings: Optional["_models.CacheDirectorySettings"] = None,
        zones: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Region name string.
        :paramtype location: str
        :keyword identity: The identity of the cache, if configured.
        :paramtype identity: ~azure.mgmt.storagecache.models.CacheIdentity
        :keyword sku: SKU for the cache.
        :paramtype sku: ~azure.mgmt.storagecache.models.CacheSku
        :keyword cache_size_gb: The size of this Cache, in GB.
        :paramtype cache_size_gb: int
        :keyword subnet: Subnet used for the cache.
        :paramtype subnet: str
        :keyword upgrade_settings: Upgrade settings of the cache.
        :paramtype upgrade_settings: ~azure.mgmt.storagecache.models.CacheUpgradeSettings
        :keyword network_settings: Specifies network settings of the cache.
        :paramtype network_settings: ~azure.mgmt.storagecache.models.CacheNetworkSettings
        :keyword encryption_settings: Specifies encryption settings of the cache.
        :paramtype encryption_settings: ~azure.mgmt.storagecache.models.CacheEncryptionSettings
        :keyword security_settings: Specifies security settings of the cache.
        :paramtype security_settings: ~azure.mgmt.storagecache.models.CacheSecuritySettings
        :keyword directory_services_settings: Specifies Directory Services settings of the cache.
        :paramtype directory_services_settings: ~azure.mgmt.storagecache.models.CacheDirectorySettings
        :keyword zones: Availability zones for resources. This field should only contain a single
         element in the array.
        :paramtype zones: list[str]
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.id = None
        self.location = location
        self.name = None
        self.type = None
        self.identity = identity
        self.system_data = None
        self.sku = sku
        self.cache_size_gb = cache_size_gb
        self.health = None
        self.mount_addresses = None
        self.provisioning_state = None
        self.subnet = subnet
        self.upgrade_status = None
        self.upgrade_settings = upgrade_settings
        self.network_settings = network_settings
        self.encryption_settings = encryption_settings
        self.security_settings = security_settings
        self.directory_services_settings = directory_services_settings
        self.zones = zones
        self.priming_jobs = None
        self.space_allocation = None


class CacheActiveDirectorySettings(_serialization.Model):
    """Active Directory settings used to join a cache to a domain.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar primary_dns_ip_address: Primary DNS IP address used to resolve the Active Directory
     domain controller's fully qualified domain name. Required.
    :vartype primary_dns_ip_address: str
    :ivar secondary_dns_ip_address: Secondary DNS IP address used to resolve the Active Directory
     domain controller's fully qualified domain name.
    :vartype secondary_dns_ip_address: str
    :ivar domain_name: The fully qualified domain name of the Active Directory domain controller.
     Required.
    :vartype domain_name: str
    :ivar domain_net_bios_name: The Active Directory domain's NetBIOS name. Required.
    :vartype domain_net_bios_name: str
    :ivar cache_net_bios_name: The NetBIOS name to assign to the HPC Cache when it joins the Active
     Directory domain as a server. Length must 1-15 characters from the class [-0-9a-zA-Z].
     Required.
    :vartype cache_net_bios_name: str
    :ivar domain_joined: True if the HPC Cache is joined to the Active Directory domain. Known
     values are: "Yes", "No", and "Error".
    :vartype domain_joined: str or ~azure.mgmt.storagecache.models.DomainJoinedType
    :ivar credentials: Active Directory admin credentials used to join the HPC Cache to a domain.
    :vartype credentials: ~azure.mgmt.storagecache.models.CacheActiveDirectorySettingsCredentials
    """

    _validation = {
        "primary_dns_ip_address": {"required": True},
        "domain_name": {"required": True},
        "domain_net_bios_name": {"required": True},
        "cache_net_bios_name": {"required": True, "pattern": r"^[-0-9a-zA-Z]{1,15}$"},
        "domain_joined": {"readonly": True},
    }

    _attribute_map = {
        "primary_dns_ip_address": {"key": "primaryDnsIpAddress", "type": "str"},
        "secondary_dns_ip_address": {"key": "secondaryDnsIpAddress", "type": "str"},
        "domain_name": {"key": "domainName", "type": "str"},
        "domain_net_bios_name": {"key": "domainNetBiosName", "type": "str"},
        "cache_net_bios_name": {"key": "cacheNetBiosName", "type": "str"},
        "domain_joined": {"key": "domainJoined", "type": "str"},
        "credentials": {"key": "credentials", "type": "CacheActiveDirectorySettingsCredentials"},
    }

    def __init__(
        self,
        *,
        primary_dns_ip_address: str,
        domain_name: str,
        domain_net_bios_name: str,
        cache_net_bios_name: str,
        secondary_dns_ip_address: Optional[str] = None,
        credentials: Optional["_models.CacheActiveDirectorySettingsCredentials"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword primary_dns_ip_address: Primary DNS IP address used to resolve the Active Directory
         domain controller's fully qualified domain name. Required.
        :paramtype primary_dns_ip_address: str
        :keyword secondary_dns_ip_address: Secondary DNS IP address used to resolve the Active
         Directory domain controller's fully qualified domain name.
        :paramtype secondary_dns_ip_address: str
        :keyword domain_name: The fully qualified domain name of the Active Directory domain
         controller. Required.
        :paramtype domain_name: str
        :keyword domain_net_bios_name: The Active Directory domain's NetBIOS name. Required.
        :paramtype domain_net_bios_name: str
        :keyword cache_net_bios_name: The NetBIOS name to assign to the HPC Cache when it joins the
         Active Directory domain as a server. Length must 1-15 characters from the class [-0-9a-zA-Z].
         Required.
        :paramtype cache_net_bios_name: str
        :keyword credentials: Active Directory admin credentials used to join the HPC Cache to a
         domain.
        :paramtype credentials: ~azure.mgmt.storagecache.models.CacheActiveDirectorySettingsCredentials
        """
        super().__init__(**kwargs)
        self.primary_dns_ip_address = primary_dns_ip_address
        self.secondary_dns_ip_address = secondary_dns_ip_address
        self.domain_name = domain_name
        self.domain_net_bios_name = domain_net_bios_name
        self.cache_net_bios_name = cache_net_bios_name
        self.domain_joined = None
        self.credentials = credentials


class CacheActiveDirectorySettingsCredentials(_serialization.Model):
    """Active Directory admin credentials used to join the HPC Cache to a domain.

    All required parameters must be populated in order to send to Azure.

    :ivar username: Username of the Active Directory domain administrator. This value is stored
     encrypted and not returned on response. Required.
    :vartype username: str
    :ivar password: Plain text password of the Active Directory domain administrator. This value is
     stored encrypted and not returned on response.
    :vartype password: str
    """

    _validation = {
        "username": {"required": True},
    }

    _attribute_map = {
        "username": {"key": "username", "type": "str"},
        "password": {"key": "password", "type": "str"},
    }

    def __init__(self, *, username: str, password: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword username: Username of the Active Directory domain administrator. This value is stored
         encrypted and not returned on response. Required.
        :paramtype username: str
        :keyword password: Plain text password of the Active Directory domain administrator. This value
         is stored encrypted and not returned on response.
        :paramtype password: str
        """
        super().__init__(**kwargs)
        self.username = username
        self.password = password


class CacheDirectorySettings(_serialization.Model):
    """Cache Directory Services settings.

    :ivar active_directory: Specifies settings for joining the HPC Cache to an Active Directory
     domain.
    :vartype active_directory: ~azure.mgmt.storagecache.models.CacheActiveDirectorySettings
    :ivar username_download: Specifies settings for Extended Groups. Extended Groups allows users
     to be members of more than 16 groups.
    :vartype username_download: ~azure.mgmt.storagecache.models.CacheUsernameDownloadSettings
    """

    _attribute_map = {
        "active_directory": {"key": "activeDirectory", "type": "CacheActiveDirectorySettings"},
        "username_download": {"key": "usernameDownload", "type": "CacheUsernameDownloadSettings"},
    }

    def __init__(
        self,
        *,
        active_directory: Optional["_models.CacheActiveDirectorySettings"] = None,
        username_download: Optional["_models.CacheUsernameDownloadSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword active_directory: Specifies settings for joining the HPC Cache to an Active Directory
         domain.
        :paramtype active_directory: ~azure.mgmt.storagecache.models.CacheActiveDirectorySettings
        :keyword username_download: Specifies settings for Extended Groups. Extended Groups allows
         users to be members of more than 16 groups.
        :paramtype username_download: ~azure.mgmt.storagecache.models.CacheUsernameDownloadSettings
        """
        super().__init__(**kwargs)
        self.active_directory = active_directory
        self.username_download = username_download


class CacheEncryptionSettings(_serialization.Model):
    """Cache encryption settings.

    :ivar key_encryption_key: Specifies the location of the key encryption key in key vault.
    :vartype key_encryption_key: ~azure.mgmt.storagecache.models.KeyVaultKeyReference
    :ivar rotation_to_latest_key_version_enabled: Specifies whether the service will automatically
     rotate to the newest version of the key in the key vault.
    :vartype rotation_to_latest_key_version_enabled: bool
    """

    _attribute_map = {
        "key_encryption_key": {"key": "keyEncryptionKey", "type": "KeyVaultKeyReference"},
        "rotation_to_latest_key_version_enabled": {"key": "rotationToLatestKeyVersionEnabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        key_encryption_key: Optional["_models.KeyVaultKeyReference"] = None,
        rotation_to_latest_key_version_enabled: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key_encryption_key: Specifies the location of the key encryption key in key vault.
        :paramtype key_encryption_key: ~azure.mgmt.storagecache.models.KeyVaultKeyReference
        :keyword rotation_to_latest_key_version_enabled: Specifies whether the service will
         automatically rotate to the newest version of the key in the key vault.
        :paramtype rotation_to_latest_key_version_enabled: bool
        """
        super().__init__(**kwargs)
        self.key_encryption_key = key_encryption_key
        self.rotation_to_latest_key_version_enabled = rotation_to_latest_key_version_enabled


class CacheHealth(_serialization.Model):
    """An indication of cache health. Gives more information about health than just that related to
    provisioning.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar state: List of cache health states. Down is when the cluster is not responding.  Degraded
     is when its functioning but has some alerts. Transitioning when it is creating or deleting.
     Unknown will be returned in old api versions when a new value is added in future versions.
     WaitingForKey is when the create is waiting for the system assigned identity to be given access
     to the encryption key in the encryption settings. Known values are: "Unknown", "Healthy",
     "Degraded", "Down", "Transitioning", "Stopping", "Stopped", "Upgrading", "Flushing",
     "WaitingForKey", "StartFailed", and "UpgradeFailed".
    :vartype state: str or ~azure.mgmt.storagecache.models.HealthStateType
    :ivar status_description: Describes explanation of state.
    :vartype status_description: str
    :ivar conditions: Outstanding conditions that need to be investigated and resolved.
    :vartype conditions: list[~azure.mgmt.storagecache.models.Condition]
    """

    _validation = {
        "conditions": {"readonly": True},
    }

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
        "status_description": {"key": "statusDescription", "type": "str"},
        "conditions": {"key": "conditions", "type": "[Condition]"},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.HealthStateType"]] = None,
        status_description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword state: List of cache health states. Down is when the cluster is not responding.
         Degraded is when its functioning but has some alerts. Transitioning when it is creating or
         deleting. Unknown will be returned in old api versions when a new value is added in future
         versions. WaitingForKey is when the create is waiting for the system assigned identity to be
         given access to the encryption key in the encryption settings. Known values are: "Unknown",
         "Healthy", "Degraded", "Down", "Transitioning", "Stopping", "Stopped", "Upgrading", "Flushing",
         "WaitingForKey", "StartFailed", and "UpgradeFailed".
        :paramtype state: str or ~azure.mgmt.storagecache.models.HealthStateType
        :keyword status_description: Describes explanation of state.
        :paramtype status_description: str
        """
        super().__init__(**kwargs)
        self.state = state
        self.status_description = status_description
        self.conditions = None


class CacheIdentity(_serialization.Model):
    """Cache identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID for the system-assigned identity of the cache.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID associated with the cache.
    :vartype tenant_id: str
    :ivar type: The type of identity used for the cache. Known values are: "SystemAssigned",
     "UserAssigned", "SystemAssigned, UserAssigned", and "None".
    :vartype type: str or ~azure.mgmt.storagecache.models.CacheIdentityType
    :ivar user_assigned_identities: A dictionary where each key is a user assigned identity
     resource ID, and each key's value is an empty dictionary.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.storagecache.models.UserAssignedIdentitiesValueAutoGenerated]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {
            "key": "userAssignedIdentities",
            "type": "{UserAssignedIdentitiesValueAutoGenerated}",
        },
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.CacheIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentitiesValueAutoGenerated"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of identity used for the cache. Known values are: "SystemAssigned",
         "UserAssigned", "SystemAssigned, UserAssigned", and "None".
        :paramtype type: str or ~azure.mgmt.storagecache.models.CacheIdentityType
        :keyword user_assigned_identities: A dictionary where each key is a user assigned identity
         resource ID, and each key's value is an empty dictionary.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.storagecache.models.UserAssignedIdentitiesValueAutoGenerated]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class CacheNetworkSettings(_serialization.Model):
    """Cache network settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar mtu: The IPv4 maximum transmission unit configured for the subnet.
    :vartype mtu: int
    :ivar utility_addresses: Array of additional IP addresses used by this cache.
    :vartype utility_addresses: list[str]
    :ivar dns_servers: DNS servers for the cache to use.  It will be set from the network
     configuration if no value is provided.
    :vartype dns_servers: list[str]
    :ivar dns_search_domain: DNS search domain.
    :vartype dns_search_domain: str
    :ivar ntp_server: NTP server IP Address or FQDN for the cache to use. The default is
     time.windows.com.
    :vartype ntp_server: str
    """

    _validation = {
        "mtu": {"maximum": 1500, "minimum": 576},
        "utility_addresses": {"readonly": True},
    }

    _attribute_map = {
        "mtu": {"key": "mtu", "type": "int"},
        "utility_addresses": {"key": "utilityAddresses", "type": "[str]"},
        "dns_servers": {"key": "dnsServers", "type": "[str]"},
        "dns_search_domain": {"key": "dnsSearchDomain", "type": "str"},
        "ntp_server": {"key": "ntpServer", "type": "str"},
    }

    def __init__(
        self,
        *,
        mtu: int = 1500,
        dns_servers: Optional[List[str]] = None,
        dns_search_domain: Optional[str] = None,
        ntp_server: str = "time.windows.com",
        **kwargs: Any
    ) -> None:
        """
        :keyword mtu: The IPv4 maximum transmission unit configured for the subnet.
        :paramtype mtu: int
        :keyword dns_servers: DNS servers for the cache to use.  It will be set from the network
         configuration if no value is provided.
        :paramtype dns_servers: list[str]
        :keyword dns_search_domain: DNS search domain.
        :paramtype dns_search_domain: str
        :keyword ntp_server: NTP server IP Address or FQDN for the cache to use. The default is
         time.windows.com.
        :paramtype ntp_server: str
        """
        super().__init__(**kwargs)
        self.mtu = mtu
        self.utility_addresses = None
        self.dns_servers = dns_servers
        self.dns_search_domain = dns_search_domain
        self.ntp_server = ntp_server


class CacheSecuritySettings(_serialization.Model):
    """Cache security settings.

    :ivar access_policies: NFS access policies defined for this cache.
    :vartype access_policies: list[~azure.mgmt.storagecache.models.NfsAccessPolicy]
    """

    _attribute_map = {
        "access_policies": {"key": "accessPolicies", "type": "[NfsAccessPolicy]"},
    }

    def __init__(self, *, access_policies: Optional[List["_models.NfsAccessPolicy"]] = None, **kwargs: Any) -> None:
        """
        :keyword access_policies: NFS access policies defined for this cache.
        :paramtype access_policies: list[~azure.mgmt.storagecache.models.NfsAccessPolicy]
        """
        super().__init__(**kwargs)
        self.access_policies = access_policies


class CacheSku(_serialization.Model):
    """SKU for the cache.

    :ivar name: SKU name for this cache.
    :vartype name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: SKU name for this cache.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class CachesListResult(_serialization.Model):
    """Result of the request to list caches. It contains a list of caches and a URL link to get the
    next set of results.

    :ivar next_link: URL to get the next set of cache list results, if there are any.
    :vartype next_link: str
    :ivar value: List of Caches.
    :vartype value: list[~azure.mgmt.storagecache.models.Cache]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[Cache]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.Cache"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: URL to get the next set of cache list results, if there are any.
        :paramtype next_link: str
        :keyword value: List of Caches.
        :paramtype value: list[~azure.mgmt.storagecache.models.Cache]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class CacheUpgradeSettings(_serialization.Model):
    """Cache Upgrade Settings.

    :ivar upgrade_schedule_enabled: True if the user chooses to select an installation time between
     now and firmwareUpdateDeadline. Else the firmware will automatically be installed after
     firmwareUpdateDeadline if not triggered earlier via the upgrade operation.
    :vartype upgrade_schedule_enabled: bool
    :ivar scheduled_time: When upgradeScheduleEnabled is true, this field holds the user-chosen
     upgrade time. At the user-chosen time, the firmware update will automatically be installed on
     the cache.
    :vartype scheduled_time: ~datetime.datetime
    """

    _attribute_map = {
        "upgrade_schedule_enabled": {"key": "upgradeScheduleEnabled", "type": "bool"},
        "scheduled_time": {"key": "scheduledTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        upgrade_schedule_enabled: Optional[bool] = None,
        scheduled_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword upgrade_schedule_enabled: True if the user chooses to select an installation time
         between now and firmwareUpdateDeadline. Else the firmware will automatically be installed after
         firmwareUpdateDeadline if not triggered earlier via the upgrade operation.
        :paramtype upgrade_schedule_enabled: bool
        :keyword scheduled_time: When upgradeScheduleEnabled is true, this field holds the user-chosen
         upgrade time. At the user-chosen time, the firmware update will automatically be installed on
         the cache.
        :paramtype scheduled_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.upgrade_schedule_enabled = upgrade_schedule_enabled
        self.scheduled_time = scheduled_time


class CacheUpgradeStatus(_serialization.Model):
    """Properties describing the software upgrade state of the cache.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar current_firmware_version: Version string of the firmware currently installed on this
     cache.
    :vartype current_firmware_version: str
    :ivar firmware_update_status: True if there is a firmware update ready to install on this
     cache. The firmware will automatically be installed after firmwareUpdateDeadline if not
     triggered earlier via the upgrade operation. Known values are: "available" and "unavailable".
    :vartype firmware_update_status: str or ~azure.mgmt.storagecache.models.FirmwareStatusType
    :ivar firmware_update_deadline: Time at which the pending firmware update will automatically be
     installed on the cache.
    :vartype firmware_update_deadline: ~datetime.datetime
    :ivar last_firmware_update: Time of the last successful firmware update.
    :vartype last_firmware_update: ~datetime.datetime
    :ivar pending_firmware_version: When firmwareUpdateAvailable is true, this field holds the
     version string for the update.
    :vartype pending_firmware_version: str
    """

    _validation = {
        "current_firmware_version": {"readonly": True},
        "firmware_update_status": {"readonly": True},
        "firmware_update_deadline": {"readonly": True},
        "last_firmware_update": {"readonly": True},
        "pending_firmware_version": {"readonly": True},
    }

    _attribute_map = {
        "current_firmware_version": {"key": "currentFirmwareVersion", "type": "str"},
        "firmware_update_status": {"key": "firmwareUpdateStatus", "type": "str"},
        "firmware_update_deadline": {"key": "firmwareUpdateDeadline", "type": "iso-8601"},
        "last_firmware_update": {"key": "lastFirmwareUpdate", "type": "iso-8601"},
        "pending_firmware_version": {"key": "pendingFirmwareVersion", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.current_firmware_version = None
        self.firmware_update_status = None
        self.firmware_update_deadline = None
        self.last_firmware_update = None
        self.pending_firmware_version = None


class CacheUsernameDownloadSettings(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Settings for Extended Groups username and group download.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar extended_groups: Whether or not Extended Groups is enabled.
    :vartype extended_groups: bool
    :ivar username_source: This setting determines how the cache gets username and group names for
     clients. Known values are: "AD", "LDAP", "File", and "None".
    :vartype username_source: str or ~azure.mgmt.storagecache.models.UsernameSource
    :ivar group_file_uri: The URI of the file containing group information (in /etc/group file
     format). This field must be populated when 'usernameSource' is set to 'File'.
    :vartype group_file_uri: str
    :ivar user_file_uri: The URI of the file containing user information (in /etc/passwd file
     format). This field must be populated when 'usernameSource' is set to 'File'.
    :vartype user_file_uri: str
    :ivar ldap_server: The fully qualified domain name or IP address of the LDAP server to use.
    :vartype ldap_server: str
    :ivar ldap_base_dn: The base distinguished name for the LDAP domain.
    :vartype ldap_base_dn: str
    :ivar encrypt_ldap_connection: Whether or not the LDAP connection should be encrypted.
    :vartype encrypt_ldap_connection: bool
    :ivar require_valid_certificate: Determines if the certificates must be validated by a
     certificate authority. When true, caCertificateURI must be provided.
    :vartype require_valid_certificate: bool
    :ivar auto_download_certificate: Determines if the certificate should be automatically
     downloaded. This applies to 'caCertificateURI' only if 'requireValidCertificate' is true.
    :vartype auto_download_certificate: bool
    :ivar ca_certificate_uri: The URI of the CA certificate to validate the LDAP secure connection.
     This field must be populated when 'requireValidCertificate' is set to true.
    :vartype ca_certificate_uri: str
    :ivar username_downloaded: Indicates whether or not the HPC Cache has performed the username
     download successfully. Known values are: "Yes", "No", and "Error".
    :vartype username_downloaded: str or ~azure.mgmt.storagecache.models.UsernameDownloadedType
    :ivar credentials: When present, these are the credentials for the secure LDAP connection.
    :vartype credentials: ~azure.mgmt.storagecache.models.CacheUsernameDownloadSettingsCredentials
    """

    _validation = {
        "username_downloaded": {"readonly": True},
    }

    _attribute_map = {
        "extended_groups": {"key": "extendedGroups", "type": "bool"},
        "username_source": {"key": "usernameSource", "type": "str"},
        "group_file_uri": {"key": "groupFileURI", "type": "str"},
        "user_file_uri": {"key": "userFileURI", "type": "str"},
        "ldap_server": {"key": "ldapServer", "type": "str"},
        "ldap_base_dn": {"key": "ldapBaseDN", "type": "str"},
        "encrypt_ldap_connection": {"key": "encryptLdapConnection", "type": "bool"},
        "require_valid_certificate": {"key": "requireValidCertificate", "type": "bool"},
        "auto_download_certificate": {"key": "autoDownloadCertificate", "type": "bool"},
        "ca_certificate_uri": {"key": "caCertificateURI", "type": "str"},
        "username_downloaded": {"key": "usernameDownloaded", "type": "str"},
        "credentials": {"key": "credentials", "type": "CacheUsernameDownloadSettingsCredentials"},
    }

    def __init__(
        self,
        *,
        extended_groups: Optional[bool] = None,
        username_source: Union[str, "_models.UsernameSource"] = "None",
        group_file_uri: Optional[str] = None,
        user_file_uri: Optional[str] = None,
        ldap_server: Optional[str] = None,
        ldap_base_dn: Optional[str] = None,
        encrypt_ldap_connection: bool = False,
        require_valid_certificate: bool = False,
        auto_download_certificate: bool = False,
        ca_certificate_uri: Optional[str] = None,
        credentials: Optional["_models.CacheUsernameDownloadSettingsCredentials"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword extended_groups: Whether or not Extended Groups is enabled.
        :paramtype extended_groups: bool
        :keyword username_source: This setting determines how the cache gets username and group names
         for clients. Known values are: "AD", "LDAP", "File", and "None".
        :paramtype username_source: str or ~azure.mgmt.storagecache.models.UsernameSource
        :keyword group_file_uri: The URI of the file containing group information (in /etc/group file
         format). This field must be populated when 'usernameSource' is set to 'File'.
        :paramtype group_file_uri: str
        :keyword user_file_uri: The URI of the file containing user information (in /etc/passwd file
         format). This field must be populated when 'usernameSource' is set to 'File'.
        :paramtype user_file_uri: str
        :keyword ldap_server: The fully qualified domain name or IP address of the LDAP server to use.
        :paramtype ldap_server: str
        :keyword ldap_base_dn: The base distinguished name for the LDAP domain.
        :paramtype ldap_base_dn: str
        :keyword encrypt_ldap_connection: Whether or not the LDAP connection should be encrypted.
        :paramtype encrypt_ldap_connection: bool
        :keyword require_valid_certificate: Determines if the certificates must be validated by a
         certificate authority. When true, caCertificateURI must be provided.
        :paramtype require_valid_certificate: bool
        :keyword auto_download_certificate: Determines if the certificate should be automatically
         downloaded. This applies to 'caCertificateURI' only if 'requireValidCertificate' is true.
        :paramtype auto_download_certificate: bool
        :keyword ca_certificate_uri: The URI of the CA certificate to validate the LDAP secure
         connection. This field must be populated when 'requireValidCertificate' is set to true.
        :paramtype ca_certificate_uri: str
        :keyword credentials: When present, these are the credentials for the secure LDAP connection.
        :paramtype credentials:
         ~azure.mgmt.storagecache.models.CacheUsernameDownloadSettingsCredentials
        """
        super().__init__(**kwargs)
        self.extended_groups = extended_groups
        self.username_source = username_source
        self.group_file_uri = group_file_uri
        self.user_file_uri = user_file_uri
        self.ldap_server = ldap_server
        self.ldap_base_dn = ldap_base_dn
        self.encrypt_ldap_connection = encrypt_ldap_connection
        self.require_valid_certificate = require_valid_certificate
        self.auto_download_certificate = auto_download_certificate
        self.ca_certificate_uri = ca_certificate_uri
        self.username_downloaded = None
        self.credentials = credentials


class CacheUsernameDownloadSettingsCredentials(_serialization.Model):
    """When present, these are the credentials for the secure LDAP connection.

    :ivar bind_dn: The Bind Distinguished Name identity to be used in the secure LDAP connection.
     This value is stored encrypted and not returned on response.
    :vartype bind_dn: str
    :ivar bind_password: The Bind password to be used in the secure LDAP connection. This value is
     stored encrypted and not returned on response.
    :vartype bind_password: str
    """

    _attribute_map = {
        "bind_dn": {"key": "bindDn", "type": "str"},
        "bind_password": {"key": "bindPassword", "type": "str"},
    }

    def __init__(self, *, bind_dn: Optional[str] = None, bind_password: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword bind_dn: The Bind Distinguished Name identity to be used in the secure LDAP
         connection. This value is stored encrypted and not returned on response.
        :paramtype bind_dn: str
        :keyword bind_password: The Bind password to be used in the secure LDAP connection. This value
         is stored encrypted and not returned on response.
        :paramtype bind_password: str
        """
        super().__init__(**kwargs)
        self.bind_dn = bind_dn
        self.bind_password = bind_password


class ClfsTarget(_serialization.Model):
    """Properties pertaining to the ClfsTarget.

    :ivar target: Resource ID of storage container.
    :vartype target: str
    """

    _attribute_map = {
        "target": {"key": "target", "type": "str"},
    }

    def __init__(self, *, target: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword target: Resource ID of storage container.
        :paramtype target: str
        """
        super().__init__(**kwargs)
        self.target = target


class CloudErrorBody(_serialization.Model):
    """An error response.

    :ivar code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :vartype code: str
    :ivar details: A list of additional details about the error.
    :vartype details: list[~azure.mgmt.storagecache.models.CloudErrorBody]
    :ivar message: A message describing the error, intended to be suitable for display in a user
     interface.
    :vartype message: str
    :ivar target: The target of the particular error. For example, the name of the property in
     error.
    :vartype target: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        details: Optional[List["_models.CloudErrorBody"]] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: An identifier for the error. Codes are invariant and are intended to be consumed
         programmatically.
        :paramtype code: str
        :keyword details: A list of additional details about the error.
        :paramtype details: list[~azure.mgmt.storagecache.models.CloudErrorBody]
        :keyword message: A message describing the error, intended to be suitable for display in a user
         interface.
        :paramtype message: str
        :keyword target: The target of the particular error. For example, the name of the property in
         error.
        :paramtype target: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.details = details
        self.message = message
        self.target = target


class Condition(_serialization.Model):
    """Outstanding conditions that will need to be resolved.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar timestamp: The time when the condition was raised.
    :vartype timestamp: ~datetime.datetime
    :ivar message: The issue requiring attention.
    :vartype message: str
    """

    _validation = {
        "timestamp": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.timestamp = None
        self.message = None


class ErrorResponse(_serialization.Model):
    """Describes the format of Error response.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword message: Error message indicating why the operation failed.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class KeyVaultKeyReference(_serialization.Model):
    """Describes a reference to key vault key.

    All required parameters must be populated in order to send to Azure.

    :ivar key_url: The URL referencing a key encryption key in key vault. Required.
    :vartype key_url: str
    :ivar source_vault: Describes a resource Id to source key vault. Required.
    :vartype source_vault: ~azure.mgmt.storagecache.models.KeyVaultKeyReferenceSourceVault
    """

    _validation = {
        "key_url": {"required": True},
        "source_vault": {"required": True},
    }

    _attribute_map = {
        "key_url": {"key": "keyUrl", "type": "str"},
        "source_vault": {"key": "sourceVault", "type": "KeyVaultKeyReferenceSourceVault"},
    }

    def __init__(self, *, key_url: str, source_vault: "_models.KeyVaultKeyReferenceSourceVault", **kwargs: Any) -> None:
        """
        :keyword key_url: The URL referencing a key encryption key in key vault. Required.
        :paramtype key_url: str
        :keyword source_vault: Describes a resource Id to source key vault. Required.
        :paramtype source_vault: ~azure.mgmt.storagecache.models.KeyVaultKeyReferenceSourceVault
        """
        super().__init__(**kwargs)
        self.key_url = key_url
        self.source_vault = source_vault


class KeyVaultKeyReferenceSourceVault(_serialization.Model):
    """Describes a resource Id to source key vault.

    :ivar id: Resource Id.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource Id.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class LogSpecification(_serialization.Model):
    """Details about operation related to logs.

    :ivar name: The name of the log.
    :vartype name: str
    :ivar display_name: Localized display name of the log.
    :vartype display_name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, display_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of the log.
        :paramtype name: str
        :keyword display_name: Localized display name of the log.
        :paramtype display_name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name


class MetricDimension(_serialization.Model):
    """Specifications of the Dimension of metrics.

    :ivar name: Name of the dimension.
    :vartype name: str
    :ivar display_name: Localized friendly display name of the dimension.
    :vartype display_name: str
    :ivar internal_name: Internal name of the dimension.
    :vartype internal_name: str
    :ivar to_be_exported_for_shoebox: To be exported to shoe box.
    :vartype to_be_exported_for_shoebox: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "internal_name": {"key": "internalName", "type": "str"},
        "to_be_exported_for_shoebox": {"key": "toBeExportedForShoebox", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        internal_name: Optional[str] = None,
        to_be_exported_for_shoebox: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the dimension.
        :paramtype name: str
        :keyword display_name: Localized friendly display name of the dimension.
        :paramtype display_name: str
        :keyword internal_name: Internal name of the dimension.
        :paramtype internal_name: str
        :keyword to_be_exported_for_shoebox: To be exported to shoe box.
        :paramtype to_be_exported_for_shoebox: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.internal_name = internal_name
        self.to_be_exported_for_shoebox = to_be_exported_for_shoebox


class MetricSpecification(_serialization.Model):
    """Details about operation related to metrics.

    :ivar name: The name of the metric.
    :vartype name: str
    :ivar display_name: Localized display name of the metric.
    :vartype display_name: str
    :ivar display_description: The description of the metric.
    :vartype display_description: str
    :ivar unit: The unit that the metric is measured in.
    :vartype unit: str
    :ivar aggregation_type: The type of metric aggregation.
    :vartype aggregation_type: str
    :ivar supported_aggregation_types: Support metric aggregation type.
    :vartype supported_aggregation_types: list[str or
     ~azure.mgmt.storagecache.models.MetricAggregationType]
    :ivar metric_class: Type of metrics.
    :vartype metric_class: str
    :ivar dimensions: Dimensions of the metric.
    :vartype dimensions: list[~azure.mgmt.storagecache.models.MetricDimension]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "display_description": {"key": "displayDescription", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "aggregation_type": {"key": "aggregationType", "type": "str"},
        "supported_aggregation_types": {"key": "supportedAggregationTypes", "type": "[str]"},
        "metric_class": {"key": "metricClass", "type": "str"},
        "dimensions": {"key": "dimensions", "type": "[MetricDimension]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        aggregation_type: Optional[str] = None,
        supported_aggregation_types: Optional[List[Union[str, "_models.MetricAggregationType"]]] = None,
        metric_class: Optional[str] = None,
        dimensions: Optional[List["_models.MetricDimension"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the metric.
        :paramtype name: str
        :keyword display_name: Localized display name of the metric.
        :paramtype display_name: str
        :keyword display_description: The description of the metric.
        :paramtype display_description: str
        :keyword unit: The unit that the metric is measured in.
        :paramtype unit: str
        :keyword aggregation_type: The type of metric aggregation.
        :paramtype aggregation_type: str
        :keyword supported_aggregation_types: Support metric aggregation type.
        :paramtype supported_aggregation_types: list[str or
         ~azure.mgmt.storagecache.models.MetricAggregationType]
        :keyword metric_class: Type of metrics.
        :paramtype metric_class: str
        :keyword dimensions: Dimensions of the metric.
        :paramtype dimensions: list[~azure.mgmt.storagecache.models.MetricDimension]
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.aggregation_type = aggregation_type
        self.supported_aggregation_types = supported_aggregation_types
        self.metric_class = metric_class
        self.dimensions = dimensions


class NamespaceJunction(_serialization.Model):
    """A namespace junction.

    :ivar namespace_path: Namespace path on a cache for a Storage Target.
    :vartype namespace_path: str
    :ivar target_path: Path in Storage Target to which namespacePath points.
    :vartype target_path: str
    :ivar nfs_export: NFS export where targetPath exists.
    :vartype nfs_export: str
    :ivar nfs_access_policy: Name of the access policy applied to this junction.
    :vartype nfs_access_policy: str
    """

    _attribute_map = {
        "namespace_path": {"key": "namespacePath", "type": "str"},
        "target_path": {"key": "targetPath", "type": "str"},
        "nfs_export": {"key": "nfsExport", "type": "str"},
        "nfs_access_policy": {"key": "nfsAccessPolicy", "type": "str"},
    }

    def __init__(
        self,
        *,
        namespace_path: Optional[str] = None,
        target_path: Optional[str] = None,
        nfs_export: Optional[str] = None,
        nfs_access_policy: str = "default",
        **kwargs: Any
    ) -> None:
        """
        :keyword namespace_path: Namespace path on a cache for a Storage Target.
        :paramtype namespace_path: str
        :keyword target_path: Path in Storage Target to which namespacePath points.
        :paramtype target_path: str
        :keyword nfs_export: NFS export where targetPath exists.
        :paramtype nfs_export: str
        :keyword nfs_access_policy: Name of the access policy applied to this junction.
        :paramtype nfs_access_policy: str
        """
        super().__init__(**kwargs)
        self.namespace_path = namespace_path
        self.target_path = target_path
        self.nfs_export = nfs_export
        self.nfs_access_policy = nfs_access_policy


class Nfs3Target(_serialization.Model):
    """Properties pertaining to the Nfs3Target.

    :ivar target: IP address or host name of an NFSv3 host (e.g., 10.0.44.44).
    :vartype target: str
    :ivar usage_model: Identifies the StorageCache usage model to be used for this storage target.
    :vartype usage_model: str
    :ivar verification_timer: Amount of time (in seconds) the cache waits before it checks the
     back-end storage for file updates.
    :vartype verification_timer: int
    :ivar write_back_timer: Amount of time (in seconds) the cache waits after the last file change
     before it copies the changed file to back-end storage.
    :vartype write_back_timer: int
    """

    _validation = {
        "target": {"pattern": r"^[-.,0-9a-zA-Z]+$"},
    }

    _attribute_map = {
        "target": {"key": "target", "type": "str"},
        "usage_model": {"key": "usageModel", "type": "str"},
        "verification_timer": {"key": "verificationTimer", "type": "int"},
        "write_back_timer": {"key": "writeBackTimer", "type": "int"},
    }

    def __init__(
        self,
        *,
        target: Optional[str] = None,
        usage_model: Optional[str] = None,
        verification_timer: Optional[int] = None,
        write_back_timer: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target: IP address or host name of an NFSv3 host (e.g., 10.0.44.44).
        :paramtype target: str
        :keyword usage_model: Identifies the StorageCache usage model to be used for this storage
         target.
        :paramtype usage_model: str
        :keyword verification_timer: Amount of time (in seconds) the cache waits before it checks the
         back-end storage for file updates.
        :paramtype verification_timer: int
        :keyword write_back_timer: Amount of time (in seconds) the cache waits after the last file
         change before it copies the changed file to back-end storage.
        :paramtype write_back_timer: int
        """
        super().__init__(**kwargs)
        self.target = target
        self.usage_model = usage_model
        self.verification_timer = verification_timer
        self.write_back_timer = write_back_timer


class NfsAccessPolicy(_serialization.Model):
    """A set of rules describing access policies applied to NFSv3 clients of the cache.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Name identifying this policy. Access Policy names are not case sensitive. Required.
    :vartype name: str
    :ivar access_rules: The set of rules describing client accesses allowed under this policy.
     Required.
    :vartype access_rules: list[~azure.mgmt.storagecache.models.NfsAccessRule]
    """

    _validation = {
        "name": {"required": True},
        "access_rules": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "access_rules": {"key": "accessRules", "type": "[NfsAccessRule]"},
    }

    def __init__(self, *, name: str, access_rules: List["_models.NfsAccessRule"], **kwargs: Any) -> None:
        """
        :keyword name: Name identifying this policy. Access Policy names are not case sensitive.
         Required.
        :paramtype name: str
        :keyword access_rules: The set of rules describing client accesses allowed under this policy.
         Required.
        :paramtype access_rules: list[~azure.mgmt.storagecache.models.NfsAccessRule]
        """
        super().__init__(**kwargs)
        self.name = name
        self.access_rules = access_rules


class NfsAccessRule(_serialization.Model):
    """Rule to place restrictions on portions of the cache namespace being presented to clients.

    All required parameters must be populated in order to send to Azure.

    :ivar scope: Scope for this rule. The scope and filter determine which clients match the rule.
     Required. Known values are: "default", "network", and "host".
    :vartype scope: str or ~azure.mgmt.storagecache.models.NfsAccessRuleScope
    :ivar filter: Filter applied to the scope for this rule. The filter's format depends on its
     scope. 'default' scope matches all clients and has no filter value. 'network' scope takes a
     filter in CIDR format (for example, 10.99.1.0/24). 'host' takes an IP address or fully
     qualified domain name as filter. If a client does not match any filter rule and there is no
     default rule, access is denied.
    :vartype filter: str
    :ivar access: Access allowed by this rule. Required. Known values are: "no", "ro", and "rw".
    :vartype access: str or ~azure.mgmt.storagecache.models.NfsAccessRuleAccess
    :ivar suid: Allow SUID semantics.
    :vartype suid: bool
    :ivar submount_access: For the default policy, allow access to subdirectories under the root
     export. If this is set to no, clients can only mount the path '/'. If set to yes, clients can
     mount a deeper path, like '/a/b'.
    :vartype submount_access: bool
    :ivar root_squash: Map root accesses to anonymousUID and anonymousGID.
    :vartype root_squash: bool
    :ivar anonymous_uid: UID value that replaces 0 when rootSquash is true. 65534 will be used if
     not provided.
    :vartype anonymous_uid: str
    :ivar anonymous_gid: GID value that replaces 0 when rootSquash is true. This will use the value
     of anonymousUID if not provided.
    :vartype anonymous_gid: str
    """

    _validation = {
        "scope": {"required": True},
        "access": {"required": True},
    }

    _attribute_map = {
        "scope": {"key": "scope", "type": "str"},
        "filter": {"key": "filter", "type": "str"},
        "access": {"key": "access", "type": "str"},
        "suid": {"key": "suid", "type": "bool"},
        "submount_access": {"key": "submountAccess", "type": "bool"},
        "root_squash": {"key": "rootSquash", "type": "bool"},
        "anonymous_uid": {"key": "anonymousUID", "type": "str"},
        "anonymous_gid": {"key": "anonymousGID", "type": "str"},
    }

    def __init__(
        self,
        *,
        scope: Union[str, "_models.NfsAccessRuleScope"],
        access: Union[str, "_models.NfsAccessRuleAccess"],
        filter: Optional[str] = None,  # pylint: disable=redefined-builtin
        suid: Optional[bool] = None,
        submount_access: Optional[bool] = None,
        root_squash: Optional[bool] = None,
        anonymous_uid: Optional[str] = None,
        anonymous_gid: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword scope: Scope for this rule. The scope and filter determine which clients match the
         rule. Required. Known values are: "default", "network", and "host".
        :paramtype scope: str or ~azure.mgmt.storagecache.models.NfsAccessRuleScope
        :keyword filter: Filter applied to the scope for this rule. The filter's format depends on its
         scope. 'default' scope matches all clients and has no filter value. 'network' scope takes a
         filter in CIDR format (for example, 10.99.1.0/24). 'host' takes an IP address or fully
         qualified domain name as filter. If a client does not match any filter rule and there is no
         default rule, access is denied.
        :paramtype filter: str
        :keyword access: Access allowed by this rule. Required. Known values are: "no", "ro", and "rw".
        :paramtype access: str or ~azure.mgmt.storagecache.models.NfsAccessRuleAccess
        :keyword suid: Allow SUID semantics.
        :paramtype suid: bool
        :keyword submount_access: For the default policy, allow access to subdirectories under the root
         export. If this is set to no, clients can only mount the path '/'. If set to yes, clients can
         mount a deeper path, like '/a/b'.
        :paramtype submount_access: bool
        :keyword root_squash: Map root accesses to anonymousUID and anonymousGID.
        :paramtype root_squash: bool
        :keyword anonymous_uid: UID value that replaces 0 when rootSquash is true. 65534 will be used
         if not provided.
        :paramtype anonymous_uid: str
        :keyword anonymous_gid: GID value that replaces 0 when rootSquash is true. This will use the
         value of anonymousUID if not provided.
        :paramtype anonymous_gid: str
        """
        super().__init__(**kwargs)
        self.scope = scope
        self.filter = filter
        self.access = access
        self.suid = suid
        self.submount_access = submount_access
        self.root_squash = root_squash
        self.anonymous_uid = anonymous_uid
        self.anonymous_gid = anonymous_gid


class PrimingJob(_serialization.Model):
    """A priming job instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar priming_job_name: The priming job name. Required.
    :vartype priming_job_name: str
    :ivar priming_manifest_url: The URL for the priming manifest file to download. This file must
     be readable from the HPC Cache. When the file is in Azure blob storage the URL should include a
     Shared Access Signature (SAS) granting read permissions on the blob. Required.
    :vartype priming_manifest_url: str
    :ivar priming_job_id: The unique identifier of the priming job.
    :vartype priming_job_id: str
    :ivar priming_job_state: The state of the priming operation. Known values are: "Queued",
     "Running", "Paused", and "Complete".
    :vartype priming_job_state: str or ~azure.mgmt.storagecache.models.PrimingJobState
    :ivar priming_job_status: The status code of the priming job.
    :vartype priming_job_status: str
    :ivar priming_job_details: The job details or error information if any.
    :vartype priming_job_details: str
    :ivar priming_job_percent_complete: The current progress of the priming job, as a percentage.
    :vartype priming_job_percent_complete: float
    """

    _validation = {
        "priming_job_name": {"required": True, "pattern": r"^[-0-9a-zA-Z_]{1,80}$"},
        "priming_manifest_url": {"required": True},
        "priming_job_id": {"readonly": True, "pattern": r"^[-0-9a-zA-Z_]{1,80}$"},
        "priming_job_state": {"readonly": True},
        "priming_job_status": {"readonly": True},
        "priming_job_details": {"readonly": True},
        "priming_job_percent_complete": {"readonly": True, "maximum": 100, "minimum": 0},
    }

    _attribute_map = {
        "priming_job_name": {"key": "primingJobName", "type": "str"},
        "priming_manifest_url": {"key": "primingManifestUrl", "type": "str"},
        "priming_job_id": {"key": "primingJobId", "type": "str"},
        "priming_job_state": {"key": "primingJobState", "type": "str"},
        "priming_job_status": {"key": "primingJobStatus", "type": "str"},
        "priming_job_details": {"key": "primingJobDetails", "type": "str"},
        "priming_job_percent_complete": {"key": "primingJobPercentComplete", "type": "float"},
    }

    def __init__(self, *, priming_job_name: str, priming_manifest_url: str, **kwargs: Any) -> None:
        """
        :keyword priming_job_name: The priming job name. Required.
        :paramtype priming_job_name: str
        :keyword priming_manifest_url: The URL for the priming manifest file to download. This file
         must be readable from the HPC Cache. When the file is in Azure blob storage the URL should
         include a Shared Access Signature (SAS) granting read permissions on the blob. Required.
        :paramtype priming_manifest_url: str
        """
        super().__init__(**kwargs)
        self.priming_job_name = priming_job_name
        self.priming_manifest_url = priming_manifest_url
        self.priming_job_id = None
        self.priming_job_state = None
        self.priming_job_status = None
        self.priming_job_details = None
        self.priming_job_percent_complete = None


class PrimingJobIdParameter(_serialization.Model):
    """Object containing the priming job ID.

    All required parameters must be populated in order to send to Azure.

    :ivar priming_job_id: The unique identifier of the priming job. Required.
    :vartype priming_job_id: str
    """

    _validation = {
        "priming_job_id": {"required": True, "pattern": r"^[-0-9a-zA-Z_]{1,80}$"},
    }

    _attribute_map = {
        "priming_job_id": {"key": "primingJobId", "type": "str"},
    }

    def __init__(self, *, priming_job_id: str, **kwargs: Any) -> None:
        """
        :keyword priming_job_id: The unique identifier of the priming job. Required.
        :paramtype priming_job_id: str
        """
        super().__init__(**kwargs)
        self.priming_job_id = priming_job_id


class RequiredAmlFilesystemSubnetsSize(_serialization.Model):
    """Information about the number of available IP addresses that are required for the AML file
    system.

    :ivar filesystem_subnet_size: The number of available IP addresses that are required for the
     AML file system.
    :vartype filesystem_subnet_size: int
    """

    _attribute_map = {
        "filesystem_subnet_size": {"key": "filesystemSubnetSize", "type": "int"},
    }

    def __init__(self, *, filesystem_subnet_size: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword filesystem_subnet_size: The number of available IP addresses that are required for the
         AML file system.
        :paramtype filesystem_subnet_size: int
        """
        super().__init__(**kwargs)
        self.filesystem_subnet_size = filesystem_subnet_size


class RequiredAmlFilesystemSubnetsSizeInfo(_serialization.Model):
    """Information required to get the number of available IP addresses a subnet should have that will
    be used in AML file system create.

    :ivar storage_capacity_ti_b: The size of the AML file system, in TiB.
    :vartype storage_capacity_ti_b: float
    :ivar sku: SKU for the resource.
    :vartype sku: ~azure.mgmt.storagecache.models.SkuName
    """

    _attribute_map = {
        "storage_capacity_ti_b": {"key": "storageCapacityTiB", "type": "float"},
        "sku": {"key": "sku", "type": "SkuName"},
    }

    def __init__(
        self, *, storage_capacity_ti_b: Optional[float] = None, sku: Optional["_models.SkuName"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword storage_capacity_ti_b: The size of the AML file system, in TiB.
        :paramtype storage_capacity_ti_b: float
        :keyword sku: SKU for the resource.
        :paramtype sku: ~azure.mgmt.storagecache.models.SkuName
        """
        super().__init__(**kwargs)
        self.storage_capacity_ti_b = storage_capacity_ti_b
        self.sku = sku


class ResourceSku(_serialization.Model):
    """A resource SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: The type of resource the SKU applies to.
    :vartype resource_type: str
    :ivar capabilities: A list of capabilities of this SKU, such as throughput or ops/sec.
    :vartype capabilities: list[~azure.mgmt.storagecache.models.ResourceSkuCapabilities]
    :ivar locations: The set of locations where the SKU is available. This is the supported and
     registered Azure Geo Regions (e.g., West US, East US, Southeast Asia, etc.).
    :vartype locations: list[str]
    :ivar location_info: The set of locations where the SKU is available.
    :vartype location_info: list[~azure.mgmt.storagecache.models.ResourceSkuLocationInfo]
    :ivar name: The name of this SKU.
    :vartype name: str
    :ivar restrictions: The restrictions preventing this SKU from being used. This is empty if
     there are no restrictions.
    :vartype restrictions: list[~azure.mgmt.storagecache.models.Restriction]
    """

    _validation = {
        "resource_type": {"readonly": True},
        "locations": {"readonly": True},
    }

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "capabilities": {"key": "capabilities", "type": "[ResourceSkuCapabilities]"},
        "locations": {"key": "locations", "type": "[str]"},
        "location_info": {"key": "locationInfo", "type": "[ResourceSkuLocationInfo]"},
        "name": {"key": "name", "type": "str"},
        "restrictions": {"key": "restrictions", "type": "[Restriction]"},
    }

    def __init__(
        self,
        *,
        capabilities: Optional[List["_models.ResourceSkuCapabilities"]] = None,
        location_info: Optional[List["_models.ResourceSkuLocationInfo"]] = None,
        name: Optional[str] = None,
        restrictions: Optional[List["_models.Restriction"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword capabilities: A list of capabilities of this SKU, such as throughput or ops/sec.
        :paramtype capabilities: list[~azure.mgmt.storagecache.models.ResourceSkuCapabilities]
        :keyword location_info: The set of locations where the SKU is available.
        :paramtype location_info: list[~azure.mgmt.storagecache.models.ResourceSkuLocationInfo]
        :keyword name: The name of this SKU.
        :paramtype name: str
        :keyword restrictions: The restrictions preventing this SKU from being used. This is empty if
         there are no restrictions.
        :paramtype restrictions: list[~azure.mgmt.storagecache.models.Restriction]
        """
        super().__init__(**kwargs)
        self.resource_type = None
        self.capabilities = capabilities
        self.locations = None
        self.location_info = location_info
        self.name = name
        self.restrictions = restrictions


class ResourceSkuCapabilities(_serialization.Model):
    """A resource SKU capability.

    :ivar name: Name of a capability, such as ops/sec.
    :vartype name: str
    :ivar value: Quantity, if the capability is measured by quantity.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name of a capability, such as ops/sec.
        :paramtype name: str
        :keyword value: Quantity, if the capability is measured by quantity.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class ResourceSkuLocationInfo(_serialization.Model):
    """Resource SKU location information.

    :ivar location: Location where this SKU is available.
    :vartype location: str
    :ivar zones: Zones if any.
    :vartype zones: list[str]
    """

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "zones": {"key": "zones", "type": "[str]"},
    }

    def __init__(self, *, location: Optional[str] = None, zones: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Location where this SKU is available.
        :paramtype location: str
        :keyword zones: Zones if any.
        :paramtype zones: list[str]
        """
        super().__init__(**kwargs)
        self.location = location
        self.zones = zones


class ResourceSkusResult(_serialization.Model):
    """The response from the List Cache SKUs operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar next_link: The URI to fetch the next page of cache SKUs.
    :vartype next_link: str
    :ivar value: The list of SKUs available for the subscription.
    :vartype value: list[~azure.mgmt.storagecache.models.ResourceSku]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[ResourceSku]"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: The URI to fetch the next page of cache SKUs.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = None


class ResourceUsage(_serialization.Model):
    """The usage and limit (quota) for a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar limit: The limit (quota) for this resource.
    :vartype limit: int
    :ivar unit: Unit that the limit and usages are expressed in, such as 'Count'.
    :vartype unit: str
    :ivar current_value: The current usage of this resource.
    :vartype current_value: int
    :ivar name: Naming information for this resource type.
    :vartype name: ~azure.mgmt.storagecache.models.ResourceUsageName
    """

    _validation = {
        "limit": {"readonly": True, "minimum": 0},
        "unit": {"readonly": True},
        "current_value": {"readonly": True, "minimum": 0},
        "name": {"readonly": True},
    }

    _attribute_map = {
        "limit": {"key": "limit", "type": "int"},
        "unit": {"key": "unit", "type": "str"},
        "current_value": {"key": "currentValue", "type": "int"},
        "name": {"key": "name", "type": "ResourceUsageName"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.limit = None
        self.unit = None
        self.current_value = None
        self.name = None


class ResourceUsageName(_serialization.Model):
    """Naming information for this resource type.

    :ivar value: Canonical name for this resource type.
    :vartype value: str
    :ivar localized_value: Localized name for this resource type.
    :vartype localized_value: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, localized_value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: Canonical name for this resource type.
        :paramtype value: str
        :keyword localized_value: Localized name for this resource type.
        :paramtype localized_value: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class ResourceUsagesListResult(_serialization.Model):
    """Result of the request to list resource usages. It contains a list of resource usages & limits
    and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar next_link: URL to get the next set of resource usage list results if there are any.
    :vartype next_link: str
    :ivar value: List of usages and limits for resources controlled by the Microsoft.StorageCache
     resource provider.
    :vartype value: list[~azure.mgmt.storagecache.models.ResourceUsage]
    """

    _validation = {
        "next_link": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[ResourceUsage]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.next_link = None
        self.value = None


class Restriction(_serialization.Model):
    """The restrictions preventing this SKU from being used.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of restrictions. In this version, the only possible value for this is
     location.
    :vartype type: str
    :ivar values: The value of restrictions. If the restriction type is set to location, then this
     would be the different locations where the SKU is restricted.
    :vartype values: list[str]
    :ivar reason_code: The reason for the restriction. As of now this can be "QuotaId" or
     "NotAvailableForSubscription". "QuotaId" is set when the SKU has requiredQuotas parameter as
     the subscription does not belong to that quota. "NotAvailableForSubscription" is related to
     capacity at the datacenter. Known values are: "QuotaId" and "NotAvailableForSubscription".
    :vartype reason_code: str or ~azure.mgmt.storagecache.models.ReasonCode
    """

    _validation = {
        "type": {"readonly": True},
        "values": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
        "reason_code": {"key": "reasonCode", "type": "str"},
    }

    def __init__(self, *, reason_code: Optional[Union[str, "_models.ReasonCode"]] = None, **kwargs: Any) -> None:
        """
        :keyword reason_code: The reason for the restriction. As of now this can be "QuotaId" or
         "NotAvailableForSubscription". "QuotaId" is set when the SKU has requiredQuotas parameter as
         the subscription does not belong to that quota. "NotAvailableForSubscription" is related to
         capacity at the datacenter. Known values are: "QuotaId" and "NotAvailableForSubscription".
        :paramtype reason_code: str or ~azure.mgmt.storagecache.models.ReasonCode
        """
        super().__init__(**kwargs)
        self.type = None
        self.values = None
        self.reason_code = reason_code


class SkuName(_serialization.Model):
    """SKU for the resource.

    :ivar name: SKU name for this resource.
    :vartype name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: SKU name for this resource.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class StorageTargetResource(_serialization.Model):
    """Resource used by a cache.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the Storage Target.
    :vartype name: str
    :ivar id: Resource ID of the Storage Target.
    :vartype id: str
    :ivar type: Type of the Storage Target; Microsoft.StorageCache/Cache/StorageTarget.
    :vartype type: str
    :ivar location: Region name string.
    :vartype location: str
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.storagecache.models.SystemData
    """

    _validation = {
        "name": {"readonly": True, "pattern": r"^[-0-9a-zA-Z_]{1,80}$"},
        "id": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.id = None
        self.type = None
        self.location = None
        self.system_data = None


class StorageTarget(StorageTargetResource):  # pylint: disable=too-many-instance-attributes
    """Type of the Storage Target.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the Storage Target.
    :vartype name: str
    :ivar id: Resource ID of the Storage Target.
    :vartype id: str
    :ivar type: Type of the Storage Target; Microsoft.StorageCache/Cache/StorageTarget.
    :vartype type: str
    :ivar location: Region name string.
    :vartype location: str
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.storagecache.models.SystemData
    :ivar junctions: List of cache namespace junctions to target for namespace associations.
    :vartype junctions: list[~azure.mgmt.storagecache.models.NamespaceJunction]
    :ivar target_type: Type of the Storage Target. Known values are: "nfs3", "clfs", "unknown", and
     "blobNfs".
    :vartype target_type: str or ~azure.mgmt.storagecache.models.StorageTargetType
    :ivar provisioning_state: ARM provisioning state, see
     https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/Addendum.md#provisioningstate-property.
     Known values are: "Succeeded", "Failed", "Canceled", "Creating", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.storagecache.models.ProvisioningStateType
    :ivar state: Storage target operational state. Known values are: "Ready", "Busy", "Suspended",
     and "Flushing".
    :vartype state: str or ~azure.mgmt.storagecache.models.OperationalStateType
    :ivar nfs3: Properties when targetType is nfs3.
    :vartype nfs3: ~azure.mgmt.storagecache.models.Nfs3Target
    :ivar clfs: Properties when targetType is clfs.
    :vartype clfs: ~azure.mgmt.storagecache.models.ClfsTarget
    :ivar unknown: Properties when targetType is unknown.
    :vartype unknown: ~azure.mgmt.storagecache.models.UnknownTarget
    :ivar blob_nfs: Properties when targetType is blobNfs.
    :vartype blob_nfs: ~azure.mgmt.storagecache.models.BlobNfsTarget
    :ivar allocation_percentage: The percentage of cache space allocated for this storage target.
    :vartype allocation_percentage: int
    """

    _validation = {
        "name": {"readonly": True, "pattern": r"^[-0-9a-zA-Z_]{1,80}$"},
        "id": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "allocation_percentage": {"readonly": True, "maximum": 100, "minimum": 1},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "junctions": {"key": "properties.junctions", "type": "[NamespaceJunction]"},
        "target_type": {"key": "properties.targetType", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "nfs3": {"key": "properties.nfs3", "type": "Nfs3Target"},
        "clfs": {"key": "properties.clfs", "type": "ClfsTarget"},
        "unknown": {"key": "properties.unknown", "type": "UnknownTarget"},
        "blob_nfs": {"key": "properties.blobNfs", "type": "BlobNfsTarget"},
        "allocation_percentage": {"key": "properties.allocationPercentage", "type": "int"},
    }

    def __init__(
        self,
        *,
        junctions: Optional[List["_models.NamespaceJunction"]] = None,
        target_type: Optional[Union[str, "_models.StorageTargetType"]] = None,
        state: Optional[Union[str, "_models.OperationalStateType"]] = None,
        nfs3: Optional["_models.Nfs3Target"] = None,
        clfs: Optional["_models.ClfsTarget"] = None,
        unknown: Optional["_models.UnknownTarget"] = None,
        blob_nfs: Optional["_models.BlobNfsTarget"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword junctions: List of cache namespace junctions to target for namespace associations.
        :paramtype junctions: list[~azure.mgmt.storagecache.models.NamespaceJunction]
        :keyword target_type: Type of the Storage Target. Known values are: "nfs3", "clfs", "unknown",
         and "blobNfs".
        :paramtype target_type: str or ~azure.mgmt.storagecache.models.StorageTargetType
        :keyword state: Storage target operational state. Known values are: "Ready", "Busy",
         "Suspended", and "Flushing".
        :paramtype state: str or ~azure.mgmt.storagecache.models.OperationalStateType
        :keyword nfs3: Properties when targetType is nfs3.
        :paramtype nfs3: ~azure.mgmt.storagecache.models.Nfs3Target
        :keyword clfs: Properties when targetType is clfs.
        :paramtype clfs: ~azure.mgmt.storagecache.models.ClfsTarget
        :keyword unknown: Properties when targetType is unknown.
        :paramtype unknown: ~azure.mgmt.storagecache.models.UnknownTarget
        :keyword blob_nfs: Properties when targetType is blobNfs.
        :paramtype blob_nfs: ~azure.mgmt.storagecache.models.BlobNfsTarget
        """
        super().__init__(**kwargs)
        self.junctions = junctions
        self.target_type = target_type
        self.provisioning_state = None
        self.state = state
        self.nfs3 = nfs3
        self.clfs = clfs
        self.unknown = unknown
        self.blob_nfs = blob_nfs
        self.allocation_percentage = None


class StorageTargetSpaceAllocation(_serialization.Model):
    """Storage Target space allocation properties.

    :ivar name: Name of the storage target.
    :vartype name: str
    :ivar allocation_percentage: The percentage of cache space allocated for this storage target.
    :vartype allocation_percentage: int
    """

    _validation = {
        "name": {"pattern": r"^[-0-9a-zA-Z_]{1,80}$"},
        "allocation_percentage": {"maximum": 100, "minimum": 1},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "allocation_percentage": {"key": "allocationPercentage", "type": "int"},
    }

    def __init__(
        self, *, name: Optional[str] = None, allocation_percentage: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the storage target.
        :paramtype name: str
        :keyword allocation_percentage: The percentage of cache space allocated for this storage
         target.
        :paramtype allocation_percentage: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.allocation_percentage = allocation_percentage


class StorageTargetsResult(_serialization.Model):
    """A list of Storage Targets.

    :ivar next_link: The URI to fetch the next page of Storage Targets.
    :vartype next_link: str
    :ivar value: The list of Storage Targets defined for the cache.
    :vartype value: list[~azure.mgmt.storagecache.models.StorageTarget]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[StorageTarget]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.StorageTarget"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The URI to fetch the next page of Storage Targets.
        :paramtype next_link: str
        :keyword value: The list of Storage Targets defined for the cache.
        :paramtype value: list[~azure.mgmt.storagecache.models.StorageTarget]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.storagecache.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.storagecache.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.storagecache.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.storagecache.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UnknownTarget(_serialization.Model):
    """Properties pertaining to the UnknownTarget.

    :ivar attributes: Dictionary of string->string pairs containing information about the Storage
     Target.
    :vartype attributes: dict[str, str]
    """

    _attribute_map = {
        "attributes": {"key": "attributes", "type": "{str}"},
    }

    def __init__(self, *, attributes: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword attributes: Dictionary of string->string pairs containing information about the
         Storage Target.
        :paramtype attributes: dict[str, str]
        """
        super().__init__(**kwargs)
        self.attributes = attributes


class UsageModel(_serialization.Model):
    """A usage model.

    :ivar display: Localized information describing this usage model.
    :vartype display: ~azure.mgmt.storagecache.models.UsageModelDisplay
    :ivar model_name: Non-localized keyword name for this usage model.
    :vartype model_name: str
    :ivar target_type: The type of Storage Target to which this model is applicable (only nfs3 as
     of this version).
    :vartype target_type: str
    """

    _attribute_map = {
        "display": {"key": "display", "type": "UsageModelDisplay"},
        "model_name": {"key": "modelName", "type": "str"},
        "target_type": {"key": "targetType", "type": "str"},
    }

    def __init__(
        self,
        *,
        display: Optional["_models.UsageModelDisplay"] = None,
        model_name: Optional[str] = None,
        target_type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display: Localized information describing this usage model.
        :paramtype display: ~azure.mgmt.storagecache.models.UsageModelDisplay
        :keyword model_name: Non-localized keyword name for this usage model.
        :paramtype model_name: str
        :keyword target_type: The type of Storage Target to which this model is applicable (only nfs3
         as of this version).
        :paramtype target_type: str
        """
        super().__init__(**kwargs)
        self.display = display
        self.model_name = model_name
        self.target_type = target_type


class UsageModelDisplay(_serialization.Model):
    """Localized information describing this usage model.

    :ivar description: String to display for this usage model.
    :vartype description: str
    """

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, *, description: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword description: String to display for this usage model.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.description = description


class UsageModelsResult(_serialization.Model):
    """A list of cache usage models.

    :ivar next_link: The URI to fetch the next page of cache usage models.
    :vartype next_link: str
    :ivar value: The list of usage models available for the subscription.
    :vartype value: list[~azure.mgmt.storagecache.models.UsageModel]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[UsageModel]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.UsageModel"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The URI to fetch the next page of cache usage models.
        :paramtype next_link: str
        :keyword value: The list of usage models available for the subscription.
        :paramtype value: list[~azure.mgmt.storagecache.models.UsageModel]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class UserAssignedIdentitiesValue(_serialization.Model):
    """UserAssignedIdentitiesValue.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the user-assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the user-assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class UserAssignedIdentitiesValueAutoGenerated(_serialization.Model):
    """UserAssignedIdentitiesValueAutoGenerated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the user-assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the user-assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None
