# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.network import NetworkManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-network
# USAGE
    python private_link_service_create.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = NetworkManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="subId",
    )

    response = client.private_link_services.begin_create_or_update(
        resource_group_name="rg1",
        service_name="testPls",
        parameters={
            "location": "eastus",
            "properties": {
                "autoApproval": {"subscriptions": ["subscription1", "subscription2"]},
                "fqdns": ["fqdn1", "fqdn2", "fqdn3"],
                "ipConfigurations": [
                    {
                        "name": "fe-lb",
                        "properties": {
                            "privateIPAddress": "10.0.1.4",
                            "privateIPAddressVersion": "IPv4",
                            "privateIPAllocationMethod": "Static",
                            "subnet": {
                                "id": "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb"
                            },
                        },
                    }
                ],
                "loadBalancerFrontendIpConfigurations": [
                    {
                        "id": "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"
                    }
                ],
                "visibility": {"subscriptions": ["subscription1", "subscription2", "subscription3"]},
            },
        },
    ).result()
    print(response)


# x-ms-original-file: specification/network/resource-manager/Microsoft.Network/stable/2023-09-01/examples/PrivateLinkServiceCreate.json
if __name__ == "__main__":
    main()
