# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._azure_machine_learning_workspaces_enums import *


class WorkspaceConnectionPropertiesV2(msrest.serialization.Model):
    """WorkspaceConnectionPropertiesV2.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AADAuthTypeWorkspaceConnectionProperties, AccessKeyAuthTypeWorkspaceConnectionProperties, AccountKeyAuthTypeWorkspaceConnectionProperties, ApiKeyAuthWorkspaceConnectionProperties, CustomKeysWorkspaceConnectionProperties, ManagedIdentityAuthTypeWorkspaceConnectionProperties, NoneAuthTypeWorkspaceConnectionProperties, OAuth2AuthTypeWorkspaceConnectionProperties, PATAuthTypeWorkspaceConnectionProperties, SASAuthTypeWorkspaceConnectionProperties, ServicePrincipalAuthTypeWorkspaceConnectionProperties, UsernamePasswordAuthTypeWorkspaceConnectionProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. Authentication type of the connection target.Constant filled by
     server. Possible values include: "PAT", "ManagedIdentity", "UsernamePassword", "None", "SAS",
     "AccountKey", "ServicePrincipal", "AccessKey", "ApiKey", "CustomKeys", "OAuth2", "AAD".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection. Possible values include: "PythonFeed",
     "ContainerRegistry", "Git", "S3", "Snowflake", "AzureSqlDb", "AzureSynapseAnalytics",
     "AzureMySqlDb", "AzurePostgresDb", "ADLSGen2", "Redis", "ApiKey", "AzureOpenAI",
     "CognitiveSearch", "CognitiveService", "CustomKeys", "AzureBlob", "AzureOneLake", "CosmosDb",
     "CosmosDbMongoDbApi", "AzureDataExplorer", "AzureMariaDb", "AzureDatabricksDeltaLake",
     "AzureSqlMi", "AzureTableStorage", "AmazonRdsForOracle", "AmazonRdsForSqlServer",
     "AmazonRedshift", "Db2", "Drill", "GoogleBigQuery", "Greenplum", "Hbase", "Hive", "Impala",
     "Informix", "MariaDb", "MicrosoftAccess", "MySql", "Netezza", "Oracle", "Phoenix",
     "PostgreSql", "Presto", "SapOpenHub", "SapBw", "SapHana", "SapTable", "Spark", "SqlServer",
     "Sybase", "Teradata", "Vertica", "Cassandra", "Couchbase", "MongoDbV2", "MongoDbAtlas",
     "AmazonS3Compatible", "FileServer", "FtpServer", "GoogleCloudStorage", "Hdfs",
     "OracleCloudStorage", "Sftp", "GenericHttp", "ODataRest", "Odbc", "GenericRest", "AmazonMws",
     "Concur", "Dynamics", "DynamicsAx", "DynamicsCrm", "GoogleAdWords", "Hubspot", "Jira",
     "Magento", "Marketo", "Office365", "Eloqua", "Responsys", "OracleServiceCloud", "PayPal",
     "QuickBooks", "Salesforce", "SalesforceServiceCloud", "SalesforceMarketingCloud",
     "SapCloudForCustomer", "SapEcc", "ServiceNow", "SharePointOnlineList", "Shopify", "Square",
     "WebTable", "Xero", "Zoho", "GenericContainerRegistry", "OpenAI", "Serp", "BingLLMSearch",
     "Serverless".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
    :ivar created_by_workspace_arm_id:
    :vartype created_by_workspace_arm_id: str
    :ivar expiry_time:
    :vartype expiry_time: ~datetime.datetime
    :ivar group: Group based on connection category. Possible values include: "Azure", "AzureAI",
     "Database", "NoSQL", "File", "GenericProtocol", "ServicesAndApps".
    :vartype group: str or ~azure.mgmt.machinelearningservices.models.ConnectionGroup
    :ivar is_shared_to_all:
    :vartype is_shared_to_all: bool
    :ivar metadata: Store user metadata for this connection.
    :vartype metadata: dict[str, str]
    :ivar shared_user_list:
    :vartype shared_user_list: list[str]
    :ivar target:
    :vartype target: str
    """

    _validation = {
        'auth_type': {'required': True},
        'created_by_workspace_arm_id': {'readonly': True},
        'group': {'readonly': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'created_by_workspace_arm_id': {'key': 'createdByWorkspaceArmId', 'type': 'str'},
        'expiry_time': {'key': 'expiryTime', 'type': 'iso-8601'},
        'group': {'key': 'group', 'type': 'str'},
        'is_shared_to_all': {'key': 'isSharedToAll', 'type': 'bool'},
        'metadata': {'key': 'metadata', 'type': '{str}'},
        'shared_user_list': {'key': 'sharedUserList', 'type': '[str]'},
        'target': {'key': 'target', 'type': 'str'},
    }

    _subtype_map = {
        'auth_type': {'AAD': 'AADAuthTypeWorkspaceConnectionProperties', 'AccessKey': 'AccessKeyAuthTypeWorkspaceConnectionProperties', 'AccountKey': 'AccountKeyAuthTypeWorkspaceConnectionProperties', 'ApiKey': 'ApiKeyAuthWorkspaceConnectionProperties', 'CustomKeys': 'CustomKeysWorkspaceConnectionProperties', 'ManagedIdentity': 'ManagedIdentityAuthTypeWorkspaceConnectionProperties', 'None': 'NoneAuthTypeWorkspaceConnectionProperties', 'OAuth2': 'OAuth2AuthTypeWorkspaceConnectionProperties', 'PAT': 'PATAuthTypeWorkspaceConnectionProperties', 'SAS': 'SASAuthTypeWorkspaceConnectionProperties', 'ServicePrincipal': 'ServicePrincipalAuthTypeWorkspaceConnectionProperties', 'UsernamePassword': 'UsernamePasswordAuthTypeWorkspaceConnectionProperties'}
    }

    def __init__(
        self,
        *,
        category: Optional[Union[str, "ConnectionCategory"]] = None,
        expiry_time: Optional[datetime.datetime] = None,
        is_shared_to_all: Optional[bool] = None,
        metadata: Optional[Dict[str, str]] = None,
        shared_user_list: Optional[List[str]] = None,
        target: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword category: Category of the connection. Possible values include: "PythonFeed",
         "ContainerRegistry", "Git", "S3", "Snowflake", "AzureSqlDb", "AzureSynapseAnalytics",
         "AzureMySqlDb", "AzurePostgresDb", "ADLSGen2", "Redis", "ApiKey", "AzureOpenAI",
         "CognitiveSearch", "CognitiveService", "CustomKeys", "AzureBlob", "AzureOneLake", "CosmosDb",
         "CosmosDbMongoDbApi", "AzureDataExplorer", "AzureMariaDb", "AzureDatabricksDeltaLake",
         "AzureSqlMi", "AzureTableStorage", "AmazonRdsForOracle", "AmazonRdsForSqlServer",
         "AmazonRedshift", "Db2", "Drill", "GoogleBigQuery", "Greenplum", "Hbase", "Hive", "Impala",
         "Informix", "MariaDb", "MicrosoftAccess", "MySql", "Netezza", "Oracle", "Phoenix",
         "PostgreSql", "Presto", "SapOpenHub", "SapBw", "SapHana", "SapTable", "Spark", "SqlServer",
         "Sybase", "Teradata", "Vertica", "Cassandra", "Couchbase", "MongoDbV2", "MongoDbAtlas",
         "AmazonS3Compatible", "FileServer", "FtpServer", "GoogleCloudStorage", "Hdfs",
         "OracleCloudStorage", "Sftp", "GenericHttp", "ODataRest", "Odbc", "GenericRest", "AmazonMws",
         "Concur", "Dynamics", "DynamicsAx", "DynamicsCrm", "GoogleAdWords", "Hubspot", "Jira",
         "Magento", "Marketo", "Office365", "Eloqua", "Responsys", "OracleServiceCloud", "PayPal",
         "QuickBooks", "Salesforce", "SalesforceServiceCloud", "SalesforceMarketingCloud",
         "SapCloudForCustomer", "SapEcc", "ServiceNow", "SharePointOnlineList", "Shopify", "Square",
         "WebTable", "Xero", "Zoho", "GenericContainerRegistry", "OpenAI", "Serp", "BingLLMSearch",
         "Serverless".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
        :keyword expiry_time:
        :paramtype expiry_time: ~datetime.datetime
        :keyword is_shared_to_all:
        :paramtype is_shared_to_all: bool
        :keyword metadata: Store user metadata for this connection.
        :paramtype metadata: dict[str, str]
        :keyword shared_user_list:
        :paramtype shared_user_list: list[str]
        :keyword target:
        :paramtype target: str
        """
        super(WorkspaceConnectionPropertiesV2, self).__init__(**kwargs)
        self.auth_type = None  # type: Optional[str]
        self.category = category
        self.created_by_workspace_arm_id = None
        self.expiry_time = expiry_time
        self.group = None
        self.is_shared_to_all = is_shared_to_all
        self.metadata = metadata
        self.shared_user_list = shared_user_list
        self.target = target


class AADAuthTypeWorkspaceConnectionProperties(WorkspaceConnectionPropertiesV2):
    """This connection type covers the AAD auth for any applicable Azure service.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. Authentication type of the connection target.Constant filled by
     server. Possible values include: "PAT", "ManagedIdentity", "UsernamePassword", "None", "SAS",
     "AccountKey", "ServicePrincipal", "AccessKey", "ApiKey", "CustomKeys", "OAuth2", "AAD".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection. Possible values include: "PythonFeed",
     "ContainerRegistry", "Git", "S3", "Snowflake", "AzureSqlDb", "AzureSynapseAnalytics",
     "AzureMySqlDb", "AzurePostgresDb", "ADLSGen2", "Redis", "ApiKey", "AzureOpenAI",
     "CognitiveSearch", "CognitiveService", "CustomKeys", "AzureBlob", "AzureOneLake", "CosmosDb",
     "CosmosDbMongoDbApi", "AzureDataExplorer", "AzureMariaDb", "AzureDatabricksDeltaLake",
     "AzureSqlMi", "AzureTableStorage", "AmazonRdsForOracle", "AmazonRdsForSqlServer",
     "AmazonRedshift", "Db2", "Drill", "GoogleBigQuery", "Greenplum", "Hbase", "Hive", "Impala",
     "Informix", "MariaDb", "MicrosoftAccess", "MySql", "Netezza", "Oracle", "Phoenix",
     "PostgreSql", "Presto", "SapOpenHub", "SapBw", "SapHana", "SapTable", "Spark", "SqlServer",
     "Sybase", "Teradata", "Vertica", "Cassandra", "Couchbase", "MongoDbV2", "MongoDbAtlas",
     "AmazonS3Compatible", "FileServer", "FtpServer", "GoogleCloudStorage", "Hdfs",
     "OracleCloudStorage", "Sftp", "GenericHttp", "ODataRest", "Odbc", "GenericRest", "AmazonMws",
     "Concur", "Dynamics", "DynamicsAx", "DynamicsCrm", "GoogleAdWords", "Hubspot", "Jira",
     "Magento", "Marketo", "Office365", "Eloqua", "Responsys", "OracleServiceCloud", "PayPal",
     "QuickBooks", "Salesforce", "SalesforceServiceCloud", "SalesforceMarketingCloud",
     "SapCloudForCustomer", "SapEcc", "ServiceNow", "SharePointOnlineList", "Shopify", "Square",
     "WebTable", "Xero", "Zoho", "GenericContainerRegistry", "OpenAI", "Serp", "BingLLMSearch",
     "Serverless".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
    :ivar created_by_workspace_arm_id:
    :vartype created_by_workspace_arm_id: str
    :ivar expiry_time:
    :vartype expiry_time: ~datetime.datetime
    :ivar group: Group based on connection category. Possible values include: "Azure", "AzureAI",
     "Database", "NoSQL", "File", "GenericProtocol", "ServicesAndApps".
    :vartype group: str or ~azure.mgmt.machinelearningservices.models.ConnectionGroup
    :ivar is_shared_to_all:
    :vartype is_shared_to_all: bool
    :ivar metadata: Store user metadata for this connection.
    :vartype metadata: dict[str, str]
    :ivar shared_user_list:
    :vartype shared_user_list: list[str]
    :ivar target:
    :vartype target: str
    """

    _validation = {
        'auth_type': {'required': True},
        'created_by_workspace_arm_id': {'readonly': True},
        'group': {'readonly': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'created_by_workspace_arm_id': {'key': 'createdByWorkspaceArmId', 'type': 'str'},
        'expiry_time': {'key': 'expiryTime', 'type': 'iso-8601'},
        'group': {'key': 'group', 'type': 'str'},
        'is_shared_to_all': {'key': 'isSharedToAll', 'type': 'bool'},
        'metadata': {'key': 'metadata', 'type': '{str}'},
        'shared_user_list': {'key': 'sharedUserList', 'type': '[str]'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        category: Optional[Union[str, "ConnectionCategory"]] = None,
        expiry_time: Optional[datetime.datetime] = None,
        is_shared_to_all: Optional[bool] = None,
        metadata: Optional[Dict[str, str]] = None,
        shared_user_list: Optional[List[str]] = None,
        target: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword category: Category of the connection. Possible values include: "PythonFeed",
         "ContainerRegistry", "Git", "S3", "Snowflake", "AzureSqlDb", "AzureSynapseAnalytics",
         "AzureMySqlDb", "AzurePostgresDb", "ADLSGen2", "Redis", "ApiKey", "AzureOpenAI",
         "CognitiveSearch", "CognitiveService", "CustomKeys", "AzureBlob", "AzureOneLake", "CosmosDb",
         "CosmosDbMongoDbApi", "AzureDataExplorer", "AzureMariaDb", "AzureDatabricksDeltaLake",
         "AzureSqlMi", "AzureTableStorage", "AmazonRdsForOracle", "AmazonRdsForSqlServer",
         "AmazonRedshift", "Db2", "Drill", "GoogleBigQuery", "Greenplum", "Hbase", "Hive", "Impala",
         "Informix", "MariaDb", "MicrosoftAccess", "MySql", "Netezza", "Oracle", "Phoenix",
         "PostgreSql", "Presto", "SapOpenHub", "SapBw", "SapHana", "SapTable", "Spark", "SqlServer",
         "Sybase", "Teradata", "Vertica", "Cassandra", "Couchbase", "MongoDbV2", "MongoDbAtlas",
         "AmazonS3Compatible", "FileServer", "FtpServer", "GoogleCloudStorage", "Hdfs",
         "OracleCloudStorage", "Sftp", "GenericHttp", "ODataRest", "Odbc", "GenericRest", "AmazonMws",
         "Concur", "Dynamics", "DynamicsAx", "DynamicsCrm", "GoogleAdWords", "Hubspot", "Jira",
         "Magento", "Marketo", "Office365", "Eloqua", "Responsys", "OracleServiceCloud", "PayPal",
         "QuickBooks", "Salesforce", "SalesforceServiceCloud", "SalesforceMarketingCloud",
         "SapCloudForCustomer", "SapEcc", "ServiceNow", "SharePointOnlineList", "Shopify", "Square",
         "WebTable", "Xero", "Zoho", "GenericContainerRegistry", "OpenAI", "Serp", "BingLLMSearch",
         "Serverless".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
        :keyword expiry_time:
        :paramtype expiry_time: ~datetime.datetime
        :keyword is_shared_to_all:
        :paramtype is_shared_to_all: bool
        :keyword metadata: Store user metadata for this connection.
        :paramtype metadata: dict[str, str]
        :keyword shared_user_list:
        :paramtype shared_user_list: list[str]
        :keyword target:
        :paramtype target: str
        """
        super(AADAuthTypeWorkspaceConnectionProperties, self).__init__(category=category, expiry_time=expiry_time, is_shared_to_all=is_shared_to_all, metadata=metadata, shared_user_list=shared_user_list, target=target, **kwargs)
        self.auth_type = 'AAD'  # type: str


class AccessKeyAuthTypeWorkspaceConnectionProperties(WorkspaceConnectionPropertiesV2):
    """AccessKeyAuthTypeWorkspaceConnectionProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. Authentication type of the connection target.Constant filled by
     server. Possible values include: "PAT", "ManagedIdentity", "UsernamePassword", "None", "SAS",
     "AccountKey", "ServicePrincipal", "AccessKey", "ApiKey", "CustomKeys", "OAuth2", "AAD".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection. Possible values include: "PythonFeed",
     "ContainerRegistry", "Git", "S3", "Snowflake", "AzureSqlDb", "AzureSynapseAnalytics",
     "AzureMySqlDb", "AzurePostgresDb", "ADLSGen2", "Redis", "ApiKey", "AzureOpenAI",
     "CognitiveSearch", "CognitiveService", "CustomKeys", "AzureBlob", "AzureOneLake", "CosmosDb",
     "CosmosDbMongoDbApi", "AzureDataExplorer", "AzureMariaDb", "AzureDatabricksDeltaLake",
     "AzureSqlMi", "AzureTableStorage", "AmazonRdsForOracle", "AmazonRdsForSqlServer",
     "AmazonRedshift", "Db2", "Drill", "GoogleBigQuery", "Greenplum", "Hbase", "Hive", "Impala",
     "Informix", "MariaDb", "MicrosoftAccess", "MySql", "Netezza", "Oracle", "Phoenix",
     "PostgreSql", "Presto", "SapOpenHub", "SapBw", "SapHana", "SapTable", "Spark", "SqlServer",
     "Sybase", "Teradata", "Vertica", "Cassandra", "Couchbase", "MongoDbV2", "MongoDbAtlas",
     "AmazonS3Compatible", "FileServer", "FtpServer", "GoogleCloudStorage", "Hdfs",
     "OracleCloudStorage", "Sftp", "GenericHttp", "ODataRest", "Odbc", "GenericRest", "AmazonMws",
     "Concur", "Dynamics", "DynamicsAx", "DynamicsCrm", "GoogleAdWords", "Hubspot", "Jira",
     "Magento", "Marketo", "Office365", "Eloqua", "Responsys", "OracleServiceCloud", "PayPal",
     "QuickBooks", "Salesforce", "SalesforceServiceCloud", "SalesforceMarketingCloud",
     "SapCloudForCustomer", "SapEcc", "ServiceNow", "SharePointOnlineList", "Shopify", "Square",
     "WebTable", "Xero", "Zoho", "GenericContainerRegistry", "OpenAI", "Serp", "BingLLMSearch",
     "Serverless".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
    :ivar created_by_workspace_arm_id:
    :vartype created_by_workspace_arm_id: str
    :ivar expiry_time:
    :vartype expiry_time: ~datetime.datetime
    :ivar group: Group based on connection category. Possible values include: "Azure", "AzureAI",
     "Database", "NoSQL", "File", "GenericProtocol", "ServicesAndApps".
    :vartype group: str or ~azure.mgmt.machinelearningservices.models.ConnectionGroup
    :ivar is_shared_to_all:
    :vartype is_shared_to_all: bool
    :ivar metadata: Store user metadata for this connection.
    :vartype metadata: dict[str, str]
    :ivar shared_user_list:
    :vartype shared_user_list: list[str]
    :ivar target:
    :vartype target: str
    :ivar credentials:
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionAccessKey
    """

    _validation = {
        'auth_type': {'required': True},
        'created_by_workspace_arm_id': {'readonly': True},
        'group': {'readonly': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'created_by_workspace_arm_id': {'key': 'createdByWorkspaceArmId', 'type': 'str'},
        'expiry_time': {'key': 'expiryTime', 'type': 'iso-8601'},
        'group': {'key': 'group', 'type': 'str'},
        'is_shared_to_all': {'key': 'isSharedToAll', 'type': 'bool'},
        'metadata': {'key': 'metadata', 'type': '{str}'},
        'shared_user_list': {'key': 'sharedUserList', 'type': '[str]'},
        'target': {'key': 'target', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'WorkspaceConnectionAccessKey'},
    }

    def __init__(
        self,
        *,
        category: Optional[Union[str, "ConnectionCategory"]] = None,
        expiry_time: Optional[datetime.datetime] = None,
        is_shared_to_all: Optional[bool] = None,
        metadata: Optional[Dict[str, str]] = None,
        shared_user_list: Optional[List[str]] = None,
        target: Optional[str] = None,
        credentials: Optional["WorkspaceConnectionAccessKey"] = None,
        **kwargs
    ):
        """
        :keyword category: Category of the connection. Possible values include: "PythonFeed",
         "ContainerRegistry", "Git", "S3", "Snowflake", "AzureSqlDb", "AzureSynapseAnalytics",
         "AzureMySqlDb", "AzurePostgresDb", "ADLSGen2", "Redis", "ApiKey", "AzureOpenAI",
         "CognitiveSearch", "CognitiveService", "CustomKeys", "AzureBlob", "AzureOneLake", "CosmosDb",
         "CosmosDbMongoDbApi", "AzureDataExplorer", "AzureMariaDb", "AzureDatabricksDeltaLake",
         "AzureSqlMi", "AzureTableStorage", "AmazonRdsForOracle", "AmazonRdsForSqlServer",
         "AmazonRedshift", "Db2", "Drill", "GoogleBigQuery", "Greenplum", "Hbase", "Hive", "Impala",
         "Informix", "MariaDb", "MicrosoftAccess", "MySql", "Netezza", "Oracle", "Phoenix",
         "PostgreSql", "Presto", "SapOpenHub", "SapBw", "SapHana", "SapTable", "Spark", "SqlServer",
         "Sybase", "Teradata", "Vertica", "Cassandra", "Couchbase", "MongoDbV2", "MongoDbAtlas",
         "AmazonS3Compatible", "FileServer", "FtpServer", "GoogleCloudStorage", "Hdfs",
         "OracleCloudStorage", "Sftp", "GenericHttp", "ODataRest", "Odbc", "GenericRest", "AmazonMws",
         "Concur", "Dynamics", "DynamicsAx", "DynamicsCrm", "GoogleAdWords", "Hubspot", "Jira",
         "Magento", "Marketo", "Office365", "Eloqua", "Responsys", "OracleServiceCloud", "PayPal",
         "QuickBooks", "Salesforce", "SalesforceServiceCloud", "SalesforceMarketingCloud",
         "SapCloudForCustomer", "SapEcc", "ServiceNow", "SharePointOnlineList", "Shopify", "Square",
         "WebTable", "Xero", "Zoho", "GenericContainerRegistry", "OpenAI", "Serp", "BingLLMSearch",
         "Serverless".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
        :keyword expiry_time:
        :paramtype expiry_time: ~datetime.datetime
        :keyword is_shared_to_all:
        :paramtype is_shared_to_all: bool
        :keyword metadata: Store user metadata for this connection.
        :paramtype metadata: dict[str, str]
        :keyword shared_user_list:
        :paramtype shared_user_list: list[str]
        :keyword target:
        :paramtype target: str
        :keyword credentials:
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionAccessKey
        """
        super(AccessKeyAuthTypeWorkspaceConnectionProperties, self).__init__(category=category, expiry_time=expiry_time, is_shared_to_all=is_shared_to_all, metadata=metadata, shared_user_list=shared_user_list, target=target, **kwargs)
        self.auth_type = 'AccessKey'  # type: str
        self.credentials = credentials


class AccountApiKeys(msrest.serialization.Model):
    """AccountApiKeys.

    :ivar key1:
    :vartype key1: str
    :ivar key2:
    :vartype key2: str
    """

    _attribute_map = {
        'key1': {'key': 'key1', 'type': 'str'},
        'key2': {'key': 'key2', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key1: Optional[str] = None,
        key2: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword key1:
        :paramtype key1: str
        :keyword key2:
        :paramtype key2: str
        """
        super(AccountApiKeys, self).__init__(**kwargs)
        self.key1 = key1
        self.key2 = key2


class AccountKeyAuthTypeWorkspaceConnectionProperties(WorkspaceConnectionPropertiesV2):
    """This connection type covers the account key connection for Azure storage.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. Authentication type of the connection target.Constant filled by
     server. Possible values include: "PAT", "ManagedIdentity", "UsernamePassword", "None", "SAS",
     "AccountKey", "ServicePrincipal", "AccessKey", "ApiKey", "CustomKeys", "OAuth2", "AAD".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection. Possible values include: "PythonFeed",
     "ContainerRegistry", "Git", "S3", "Snowflake", "AzureSqlDb", "AzureSynapseAnalytics",
     "AzureMySqlDb", "AzurePostgresDb", "ADLSGen2", "Redis", "ApiKey", "AzureOpenAI",
     "CognitiveSearch", "CognitiveService", "CustomKeys", "AzureBlob", "AzureOneLake", "CosmosDb",
     "CosmosDbMongoDbApi", "AzureDataExplorer", "AzureMariaDb", "AzureDatabricksDeltaLake",
     "AzureSqlMi", "AzureTableStorage", "AmazonRdsForOracle", "AmazonRdsForSqlServer",
     "AmazonRedshift", "Db2", "Drill", "GoogleBigQuery", "Greenplum", "Hbase", "Hive", "Impala",
     "Informix", "MariaDb", "MicrosoftAccess", "MySql", "Netezza", "Oracle", "Phoenix",
     "PostgreSql", "Presto", "SapOpenHub", "SapBw", "SapHana", "SapTable", "Spark", "SqlServer",
     "Sybase", "Teradata", "Vertica", "Cassandra", "Couchbase", "MongoDbV2", "MongoDbAtlas",
     "AmazonS3Compatible", "FileServer", "FtpServer", "GoogleCloudStorage", "Hdfs",
     "OracleCloudStorage", "Sftp", "GenericHttp", "ODataRest", "Odbc", "GenericRest", "AmazonMws",
     "Concur", "Dynamics", "DynamicsAx", "DynamicsCrm", "GoogleAdWords", "Hubspot", "Jira",
     "Magento", "Marketo", "Office365", "Eloqua", "Responsys", "OracleServiceCloud", "PayPal",
     "QuickBooks", "Salesforce", "SalesforceServiceCloud", "SalesforceMarketingCloud",
     "SapCloudForCustomer", "SapEcc", "ServiceNow", "SharePointOnlineList", "Shopify", "Square",
     "WebTable", "Xero", "Zoho", "GenericContainerRegistry", "OpenAI", "Serp", "BingLLMSearch",
     "Serverless".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
    :ivar created_by_workspace_arm_id:
    :vartype created_by_workspace_arm_id: str
    :ivar expiry_time:
    :vartype expiry_time: ~datetime.datetime
    :ivar group: Group based on connection category. Possible values include: "Azure", "AzureAI",
     "Database", "NoSQL", "File", "GenericProtocol", "ServicesAndApps".
    :vartype group: str or ~azure.mgmt.machinelearningservices.models.ConnectionGroup
    :ivar is_shared_to_all:
    :vartype is_shared_to_all: bool
    :ivar metadata: Store user metadata for this connection.
    :vartype metadata: dict[str, str]
    :ivar shared_user_list:
    :vartype shared_user_list: list[str]
    :ivar target:
    :vartype target: str
    :ivar credentials:
    :vartype credentials:
     ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionSharedAccessSignature
    """

    _validation = {
        'auth_type': {'required': True},
        'created_by_workspace_arm_id': {'readonly': True},
        'group': {'readonly': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'created_by_workspace_arm_id': {'key': 'createdByWorkspaceArmId', 'type': 'str'},
        'expiry_time': {'key': 'expiryTime', 'type': 'iso-8601'},
        'group': {'key': 'group', 'type': 'str'},
        'is_shared_to_all': {'key': 'isSharedToAll', 'type': 'bool'},
        'metadata': {'key': 'metadata', 'type': '{str}'},
        'shared_user_list': {'key': 'sharedUserList', 'type': '[str]'},
        'target': {'key': 'target', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'WorkspaceConnectionSharedAccessSignature'},
    }

    def __init__(
        self,
        *,
        category: Optional[Union[str, "ConnectionCategory"]] = None,
        expiry_time: Optional[datetime.datetime] = None,
        is_shared_to_all: Optional[bool] = None,
        metadata: Optional[Dict[str, str]] = None,
        shared_user_list: Optional[List[str]] = None,
        target: Optional[str] = None,
        credentials: Optional["WorkspaceConnectionSharedAccessSignature"] = None,
        **kwargs
    ):
        """
        :keyword category: Category of the connection. Possible values include: "PythonFeed",
         "ContainerRegistry", "Git", "S3", "Snowflake", "AzureSqlDb", "AzureSynapseAnalytics",
         "AzureMySqlDb", "AzurePostgresDb", "ADLSGen2", "Redis", "ApiKey", "AzureOpenAI",
         "CognitiveSearch", "CognitiveService", "CustomKeys", "AzureBlob", "AzureOneLake", "CosmosDb",
         "CosmosDbMongoDbApi", "AzureDataExplorer", "AzureMariaDb", "AzureDatabricksDeltaLake",
         "AzureSqlMi", "AzureTableStorage", "AmazonRdsForOracle", "AmazonRdsForSqlServer",
         "AmazonRedshift", "Db2", "Drill", "GoogleBigQuery", "Greenplum", "Hbase", "Hive", "Impala",
         "Informix", "MariaDb", "MicrosoftAccess", "MySql", "Netezza", "Oracle", "Phoenix",
         "PostgreSql", "Presto", "SapOpenHub", "SapBw", "SapHana", "SapTable", "Spark", "SqlServer",
         "Sybase", "Teradata", "Vertica", "Cassandra", "Couchbase", "MongoDbV2", "MongoDbAtlas",
         "AmazonS3Compatible", "FileServer", "FtpServer", "GoogleCloudStorage", "Hdfs",
         "OracleCloudStorage", "Sftp", "GenericHttp", "ODataRest", "Odbc", "GenericRest", "AmazonMws",
         "Concur", "Dynamics", "DynamicsAx", "DynamicsCrm", "GoogleAdWords", "Hubspot", "Jira",
         "Magento", "Marketo", "Office365", "Eloqua", "Responsys", "OracleServiceCloud", "PayPal",
         "QuickBooks", "Salesforce", "SalesforceServiceCloud", "SalesforceMarketingCloud",
         "SapCloudForCustomer", "SapEcc", "ServiceNow", "SharePointOnlineList", "Shopify", "Square",
         "WebTable", "Xero", "Zoho", "GenericContainerRegistry", "OpenAI", "Serp", "BingLLMSearch",
         "Serverless".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
        :keyword expiry_time:
        :paramtype expiry_time: ~datetime.datetime
        :keyword is_shared_to_all:
        :paramtype is_shared_to_all: bool
        :keyword metadata: Store user metadata for this connection.
        :paramtype metadata: dict[str, str]
        :keyword shared_user_list:
        :paramtype shared_user_list: list[str]
        :keyword target:
        :paramtype target: str
        :keyword credentials:
        :paramtype credentials:
         ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionSharedAccessSignature
        """
        super(AccountKeyAuthTypeWorkspaceConnectionProperties, self).__init__(category=category, expiry_time=expiry_time, is_shared_to_all=is_shared_to_all, metadata=metadata, shared_user_list=shared_user_list, target=target, **kwargs)
        self.auth_type = 'AccountKey'  # type: str
        self.credentials = credentials


class DatastoreCredentials(msrest.serialization.Model):
    """Base definition for datastore credentials.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AccountKeyDatastoreCredentials, CertificateDatastoreCredentials, KerberosKeytabCredentials, KerberosPasswordCredentials, NoneDatastoreCredentials, SasDatastoreCredentials, ServicePrincipalDatastoreCredentials.

    All required parameters must be populated in order to send to Azure.

    :ivar credentials_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate",
     "None", "Sas", "ServicePrincipal", "KerberosKeytab", "KerberosPassword".
    :vartype credentials_type: str or ~azure.mgmt.machinelearningservices.models.CredentialsType
    """

    _validation = {
        'credentials_type': {'required': True},
    }

    _attribute_map = {
        'credentials_type': {'key': 'credentialsType', 'type': 'str'},
    }

    _subtype_map = {
        'credentials_type': {'AccountKey': 'AccountKeyDatastoreCredentials', 'Certificate': 'CertificateDatastoreCredentials', 'KerberosKeytab': 'KerberosKeytabCredentials', 'KerberosPassword': 'KerberosPasswordCredentials', 'None': 'NoneDatastoreCredentials', 'Sas': 'SasDatastoreCredentials', 'ServicePrincipal': 'ServicePrincipalDatastoreCredentials'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DatastoreCredentials, self).__init__(**kwargs)
        self.credentials_type = None  # type: Optional[str]


class AccountKeyDatastoreCredentials(DatastoreCredentials):
    """Account key datastore credentials configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar credentials_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate",
     "None", "Sas", "ServicePrincipal", "KerberosKeytab", "KerberosPassword".
    :vartype credentials_type: str or ~azure.mgmt.machinelearningservices.models.CredentialsType
    :ivar secrets: Required. [Required] Storage account secrets.
    :vartype secrets: ~azure.mgmt.machinelearningservices.models.AccountKeyDatastoreSecrets
    """

    _validation = {
        'credentials_type': {'required': True},
        'secrets': {'required': True},
    }

    _attribute_map = {
        'credentials_type': {'key': 'credentialsType', 'type': 'str'},
        'secrets': {'key': 'secrets', 'type': 'AccountKeyDatastoreSecrets'},
    }

    def __init__(
        self,
        *,
        secrets: "AccountKeyDatastoreSecrets",
        **kwargs
    ):
        """
        :keyword secrets: Required. [Required] Storage account secrets.
        :paramtype secrets: ~azure.mgmt.machinelearningservices.models.AccountKeyDatastoreSecrets
        """
        super(AccountKeyDatastoreCredentials, self).__init__(**kwargs)
        self.credentials_type = 'AccountKey'  # type: str
        self.secrets = secrets


class DatastoreSecrets(msrest.serialization.Model):
    """Base definition for datastore secrets.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AccountKeyDatastoreSecrets, CertificateDatastoreSecrets, KerberosKeytabSecrets, KerberosPasswordSecrets, SasDatastoreSecrets, ServicePrincipalDatastoreSecrets.

    All required parameters must be populated in order to send to Azure.

    :ivar secrets_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate", "Sas",
     "ServicePrincipal", "KerberosPassword", "KerberosKeytab".
    :vartype secrets_type: str or ~azure.mgmt.machinelearningservices.models.SecretsType
    """

    _validation = {
        'secrets_type': {'required': True},
    }

    _attribute_map = {
        'secrets_type': {'key': 'secretsType', 'type': 'str'},
    }

    _subtype_map = {
        'secrets_type': {'AccountKey': 'AccountKeyDatastoreSecrets', 'Certificate': 'CertificateDatastoreSecrets', 'KerberosKeytab': 'KerberosKeytabSecrets', 'KerberosPassword': 'KerberosPasswordSecrets', 'Sas': 'SasDatastoreSecrets', 'ServicePrincipal': 'ServicePrincipalDatastoreSecrets'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DatastoreSecrets, self).__init__(**kwargs)
        self.secrets_type = None  # type: Optional[str]


class AccountKeyDatastoreSecrets(DatastoreSecrets):
    """Datastore account key secrets.

    All required parameters must be populated in order to send to Azure.

    :ivar secrets_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate", "Sas",
     "ServicePrincipal", "KerberosPassword", "KerberosKeytab".
    :vartype secrets_type: str or ~azure.mgmt.machinelearningservices.models.SecretsType
    :ivar key: Storage account key.
    :vartype key: str
    """

    _validation = {
        'secrets_type': {'required': True},
    }

    _attribute_map = {
        'secrets_type': {'key': 'secretsType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword key: Storage account key.
        :paramtype key: str
        """
        super(AccountKeyDatastoreSecrets, self).__init__(**kwargs)
        self.secrets_type = 'AccountKey'  # type: str
        self.key = key


class DeploymentModel(msrest.serialization.Model):
    """Properties of Cognitive Services account deployment model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar format: Deployment model format.
    :vartype format: str
    :ivar name: Deployment model name.
    :vartype name: str
    :ivar version: Optional. Deployment model version. If version is not specified, a default
     version will be assigned. The default version is different for different models and might
     change when there is new version available for a model. Default version for a model could be
     found from list models API.
    :vartype version: str
    :ivar source: Optional. Deployment model source ARM resource ID.
    :vartype source: str
    :ivar call_rate_limit: The call rate limit Cognitive Services account.
    :vartype call_rate_limit: ~azure.mgmt.machinelearningservices.models.CallRateLimit
    """

    _validation = {
        'call_rate_limit': {'readonly': True},
    }

    _attribute_map = {
        'format': {'key': 'format', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'call_rate_limit': {'key': 'callRateLimit', 'type': 'CallRateLimit'},
    }

    def __init__(
        self,
        *,
        format: Optional[str] = None,
        name: Optional[str] = None,
        version: Optional[str] = None,
        source: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword format: Deployment model format.
        :paramtype format: str
        :keyword name: Deployment model name.
        :paramtype name: str
        :keyword version: Optional. Deployment model version. If version is not specified, a default
         version will be assigned. The default version is different for different models and might
         change when there is new version available for a model. Default version for a model could be
         found from list models API.
        :paramtype version: str
        :keyword source: Optional. Deployment model source ARM resource ID.
        :paramtype source: str
        """
        super(DeploymentModel, self).__init__(**kwargs)
        self.format = format
        self.name = name
        self.version = version
        self.source = source
        self.call_rate_limit = None


class AccountModel(DeploymentModel):
    """Cognitive Services account Model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar format: Deployment model format.
    :vartype format: str
    :ivar name: Deployment model name.
    :vartype name: str
    :ivar version: Optional. Deployment model version. If version is not specified, a default
     version will be assigned. The default version is different for different models and might
     change when there is new version available for a model. Default version for a model could be
     found from list models API.
    :vartype version: str
    :ivar source: Optional. Deployment model source ARM resource ID.
    :vartype source: str
    :ivar call_rate_limit: The call rate limit Cognitive Services account.
    :vartype call_rate_limit: ~azure.mgmt.machinelearningservices.models.CallRateLimit
    :ivar base_model: Base Model Identifier.
    :vartype base_model: ~azure.mgmt.machinelearningservices.models.DeploymentModel
    :ivar is_default_version: If the model is default version.
    :vartype is_default_version: bool
    :ivar skus: The list of Model Sku.
    :vartype skus: list[~azure.mgmt.machinelearningservices.models.ModelSku]
    :ivar max_capacity: The max capacity.
    :vartype max_capacity: int
    :ivar capabilities: The capabilities.
    :vartype capabilities: dict[str, str]
    :ivar finetune_capabilities: The capabilities for finetune models.
    :vartype finetune_capabilities: dict[str, str]
    :ivar deprecation: Cognitive Services account ModelDeprecationInfo.
    :vartype deprecation: ~azure.mgmt.machinelearningservices.models.ModelDeprecationInfo
    :ivar lifecycle_status: Model lifecycle status. Possible values include: "GenerallyAvailable",
     "Preview".
    :vartype lifecycle_status: str or
     ~azure.mgmt.machinelearningservices.models.ModelLifecycleStatus
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    """

    _validation = {
        'call_rate_limit': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'format': {'key': 'format', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'call_rate_limit': {'key': 'callRateLimit', 'type': 'CallRateLimit'},
        'base_model': {'key': 'baseModel', 'type': 'DeploymentModel'},
        'is_default_version': {'key': 'isDefaultVersion', 'type': 'bool'},
        'skus': {'key': 'skus', 'type': '[ModelSku]'},
        'max_capacity': {'key': 'maxCapacity', 'type': 'int'},
        'capabilities': {'key': 'capabilities', 'type': '{str}'},
        'finetune_capabilities': {'key': 'finetuneCapabilities', 'type': '{str}'},
        'deprecation': {'key': 'deprecation', 'type': 'ModelDeprecationInfo'},
        'lifecycle_status': {'key': 'lifecycleStatus', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        *,
        format: Optional[str] = None,
        name: Optional[str] = None,
        version: Optional[str] = None,
        source: Optional[str] = None,
        base_model: Optional["DeploymentModel"] = None,
        is_default_version: Optional[bool] = None,
        skus: Optional[List["ModelSku"]] = None,
        max_capacity: Optional[int] = None,
        capabilities: Optional[Dict[str, str]] = None,
        finetune_capabilities: Optional[Dict[str, str]] = None,
        deprecation: Optional["ModelDeprecationInfo"] = None,
        lifecycle_status: Optional[Union[str, "ModelLifecycleStatus"]] = None,
        **kwargs
    ):
        """
        :keyword format: Deployment model format.
        :paramtype format: str
        :keyword name: Deployment model name.
        :paramtype name: str
        :keyword version: Optional. Deployment model version. If version is not specified, a default
         version will be assigned. The default version is different for different models and might
         change when there is new version available for a model. Default version for a model could be
         found from list models API.
        :paramtype version: str
        :keyword source: Optional. Deployment model source ARM resource ID.
        :paramtype source: str
        :keyword base_model: Base Model Identifier.
        :paramtype base_model: ~azure.mgmt.machinelearningservices.models.DeploymentModel
        :keyword is_default_version: If the model is default version.
        :paramtype is_default_version: bool
        :keyword skus: The list of Model Sku.
        :paramtype skus: list[~azure.mgmt.machinelearningservices.models.ModelSku]
        :keyword max_capacity: The max capacity.
        :paramtype max_capacity: int
        :keyword capabilities: The capabilities.
        :paramtype capabilities: dict[str, str]
        :keyword finetune_capabilities: The capabilities for finetune models.
        :paramtype finetune_capabilities: dict[str, str]
        :keyword deprecation: Cognitive Services account ModelDeprecationInfo.
        :paramtype deprecation: ~azure.mgmt.machinelearningservices.models.ModelDeprecationInfo
        :keyword lifecycle_status: Model lifecycle status. Possible values include:
         "GenerallyAvailable", "Preview".
        :paramtype lifecycle_status: str or
         ~azure.mgmt.machinelearningservices.models.ModelLifecycleStatus
        """
        super(AccountModel, self).__init__(format=format, name=name, version=version, source=source, **kwargs)
        self.base_model = base_model
        self.is_default_version = is_default_version
        self.skus = skus
        self.max_capacity = max_capacity
        self.capabilities = capabilities
        self.finetune_capabilities = finetune_capabilities
        self.deprecation = deprecation
        self.lifecycle_status = lifecycle_status
        self.system_data = None


class AcrDetails(msrest.serialization.Model):
    """Details of ACR account to be used for the Registry.

    :ivar system_created_acr_account: Details of system created ACR account to be used for the
     Registry.
    :vartype system_created_acr_account:
     ~azure.mgmt.machinelearningservices.models.SystemCreatedAcrAccount
    :ivar user_created_acr_account: Details of user created ACR account to be used for the
     Registry.
    :vartype user_created_acr_account:
     ~azure.mgmt.machinelearningservices.models.UserCreatedAcrAccount
    """

    _attribute_map = {
        'system_created_acr_account': {'key': 'systemCreatedAcrAccount', 'type': 'SystemCreatedAcrAccount'},
        'user_created_acr_account': {'key': 'userCreatedAcrAccount', 'type': 'UserCreatedAcrAccount'},
    }

    def __init__(
        self,
        *,
        system_created_acr_account: Optional["SystemCreatedAcrAccount"] = None,
        user_created_acr_account: Optional["UserCreatedAcrAccount"] = None,
        **kwargs
    ):
        """
        :keyword system_created_acr_account: Details of system created ACR account to be used for the
         Registry.
        :paramtype system_created_acr_account:
         ~azure.mgmt.machinelearningservices.models.SystemCreatedAcrAccount
        :keyword user_created_acr_account: Details of user created ACR account to be used for the
         Registry.
        :paramtype user_created_acr_account:
         ~azure.mgmt.machinelearningservices.models.UserCreatedAcrAccount
        """
        super(AcrDetails, self).__init__(**kwargs)
        self.system_created_acr_account = system_created_acr_account
        self.user_created_acr_account = user_created_acr_account


class ActualCapacityInfo(msrest.serialization.Model):
    """ActualCapacityInfo.

    :ivar allocated: Gets or sets the total number of instances for the group.
    :vartype allocated: int
    :ivar assignment_failed: Gets or sets the number of instances which failed to successfully
     complete assignment.
    :vartype assignment_failed: int
    :ivar assignment_success: Gets or sets the number of instances which successfully completed
     assignment.
    :vartype assignment_success: int
    """

    _attribute_map = {
        'allocated': {'key': 'allocated', 'type': 'int'},
        'assignment_failed': {'key': 'assignmentFailed', 'type': 'int'},
        'assignment_success': {'key': 'assignmentSuccess', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        allocated: Optional[int] = 0,
        assignment_failed: Optional[int] = 0,
        assignment_success: Optional[int] = 0,
        **kwargs
    ):
        """
        :keyword allocated: Gets or sets the total number of instances for the group.
        :paramtype allocated: int
        :keyword assignment_failed: Gets or sets the number of instances which failed to successfully
         complete assignment.
        :paramtype assignment_failed: int
        :keyword assignment_success: Gets or sets the number of instances which successfully completed
         assignment.
        :paramtype assignment_success: int
        """
        super(ActualCapacityInfo, self).__init__(**kwargs)
        self.allocated = allocated
        self.assignment_failed = assignment_failed
        self.assignment_success = assignment_success


class AKSSchema(msrest.serialization.Model):
    """AKSSchema.

    :ivar properties: AKS properties.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.AKSSchemaProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'AKSSchemaProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["AKSSchemaProperties"] = None,
        **kwargs
    ):
        """
        :keyword properties: AKS properties.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.AKSSchemaProperties
        """
        super(AKSSchema, self).__init__(**kwargs)
        self.properties = properties


class Compute(msrest.serialization.Model):
    """Machine Learning compute object.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AKS, AmlCompute, ComputeInstance, DataFactory, DataLakeAnalytics, Databricks, HDInsight, Kubernetes, SynapseSpark, VirtualMachine.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    """

    _validation = {
        'compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[ErrorResponse]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'disable_local_auth': {'key': 'disableLocalAuth', 'type': 'bool'},
    }

    _subtype_map = {
        'compute_type': {'AKS': 'AKS', 'AmlCompute': 'AmlCompute', 'ComputeInstance': 'ComputeInstance', 'DataFactory': 'DataFactory', 'DataLakeAnalytics': 'DataLakeAnalytics', 'Databricks': 'Databricks', 'HDInsight': 'HDInsight', 'Kubernetes': 'Kubernetes', 'SynapseSpark': 'SynapseSpark', 'VirtualMachine': 'VirtualMachine'}
    }

    def __init__(
        self,
        *,
        compute_location: Optional[str] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        disable_local_auth: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword compute_location: Location for the underlying compute.
        :paramtype compute_location: str
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        :keyword disable_local_auth: Opt-out of local authentication and ensure customers can use only
         MSI and AAD exclusively for authentication.
        :paramtype disable_local_auth: bool
        """
        super(Compute, self).__init__(**kwargs)
        self.compute_type = None  # type: Optional[str]
        self.compute_location = compute_location
        self.provisioning_state = None
        self.description = description
        self.created_on = None
        self.modified_on = None
        self.resource_id = resource_id
        self.provisioning_errors = None
        self.is_attached_compute = None
        self.disable_local_auth = disable_local_auth


class AKS(Compute, AKSSchema):
    """A Machine Learning compute based on AKS.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: AKS properties.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.AKSSchemaProperties
    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    """

    _validation = {
        'compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'AKSSchemaProperties'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[ErrorResponse]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'disable_local_auth': {'key': 'disableLocalAuth', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        properties: Optional["AKSSchemaProperties"] = None,
        compute_location: Optional[str] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        disable_local_auth: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword properties: AKS properties.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.AKSSchemaProperties
        :keyword compute_location: Location for the underlying compute.
        :paramtype compute_location: str
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        :keyword disable_local_auth: Opt-out of local authentication and ensure customers can use only
         MSI and AAD exclusively for authentication.
        :paramtype disable_local_auth: bool
        """
        super(AKS, self).__init__(compute_location=compute_location, description=description, resource_id=resource_id, disable_local_auth=disable_local_auth, properties=properties, **kwargs)
        self.properties = properties
        self.compute_type = 'AKS'  # type: str
        self.compute_location = compute_location
        self.provisioning_state = None
        self.description = description
        self.created_on = None
        self.modified_on = None
        self.resource_id = resource_id
        self.provisioning_errors = None
        self.is_attached_compute = None
        self.disable_local_auth = disable_local_auth


class AksComputeSecretsProperties(msrest.serialization.Model):
    """Properties of AksComputeSecrets.

    :ivar user_kube_config: Content of kubeconfig file that can be used to connect to the
     Kubernetes cluster.
    :vartype user_kube_config: str
    :ivar admin_kube_config: Content of kubeconfig file that can be used to connect to the
     Kubernetes cluster.
    :vartype admin_kube_config: str
    :ivar image_pull_secret_name: Image registry pull secret.
    :vartype image_pull_secret_name: str
    """

    _attribute_map = {
        'user_kube_config': {'key': 'userKubeConfig', 'type': 'str'},
        'admin_kube_config': {'key': 'adminKubeConfig', 'type': 'str'},
        'image_pull_secret_name': {'key': 'imagePullSecretName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        user_kube_config: Optional[str] = None,
        admin_kube_config: Optional[str] = None,
        image_pull_secret_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword user_kube_config: Content of kubeconfig file that can be used to connect to the
         Kubernetes cluster.
        :paramtype user_kube_config: str
        :keyword admin_kube_config: Content of kubeconfig file that can be used to connect to the
         Kubernetes cluster.
        :paramtype admin_kube_config: str
        :keyword image_pull_secret_name: Image registry pull secret.
        :paramtype image_pull_secret_name: str
        """
        super(AksComputeSecretsProperties, self).__init__(**kwargs)
        self.user_kube_config = user_kube_config
        self.admin_kube_config = admin_kube_config
        self.image_pull_secret_name = image_pull_secret_name


class ComputeSecrets(msrest.serialization.Model):
    """Secrets related to a Machine Learning compute. Might differ for every type of compute.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AksComputeSecrets, DatabricksComputeSecrets, VirtualMachineSecrets.

    All required parameters must be populated in order to send to Azure.

    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    """

    _validation = {
        'compute_type': {'required': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
    }

    _subtype_map = {
        'compute_type': {'AKS': 'AksComputeSecrets', 'Databricks': 'DatabricksComputeSecrets', 'VirtualMachine': 'VirtualMachineSecrets'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ComputeSecrets, self).__init__(**kwargs)
        self.compute_type = None  # type: Optional[str]


class AksComputeSecrets(ComputeSecrets, AksComputeSecretsProperties):
    """Secrets related to a Machine Learning compute based on AKS.

    All required parameters must be populated in order to send to Azure.

    :ivar user_kube_config: Content of kubeconfig file that can be used to connect to the
     Kubernetes cluster.
    :vartype user_kube_config: str
    :ivar admin_kube_config: Content of kubeconfig file that can be used to connect to the
     Kubernetes cluster.
    :vartype admin_kube_config: str
    :ivar image_pull_secret_name: Image registry pull secret.
    :vartype image_pull_secret_name: str
    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    """

    _validation = {
        'compute_type': {'required': True},
    }

    _attribute_map = {
        'user_kube_config': {'key': 'userKubeConfig', 'type': 'str'},
        'admin_kube_config': {'key': 'adminKubeConfig', 'type': 'str'},
        'image_pull_secret_name': {'key': 'imagePullSecretName', 'type': 'str'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        user_kube_config: Optional[str] = None,
        admin_kube_config: Optional[str] = None,
        image_pull_secret_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword user_kube_config: Content of kubeconfig file that can be used to connect to the
         Kubernetes cluster.
        :paramtype user_kube_config: str
        :keyword admin_kube_config: Content of kubeconfig file that can be used to connect to the
         Kubernetes cluster.
        :paramtype admin_kube_config: str
        :keyword image_pull_secret_name: Image registry pull secret.
        :paramtype image_pull_secret_name: str
        """
        super(AksComputeSecrets, self).__init__(user_kube_config=user_kube_config, admin_kube_config=admin_kube_config, image_pull_secret_name=image_pull_secret_name, **kwargs)
        self.user_kube_config = user_kube_config
        self.admin_kube_config = admin_kube_config
        self.image_pull_secret_name = image_pull_secret_name
        self.compute_type = 'AKS'  # type: str


class AksNetworkingConfiguration(msrest.serialization.Model):
    """Advance configuration for AKS networking.

    :ivar subnet_id: Virtual network subnet resource ID the compute nodes belong to.
    :vartype subnet_id: str
    :ivar service_cidr: A CIDR notation IP range from which to assign service cluster IPs. It must
     not overlap with any Subnet IP ranges.
    :vartype service_cidr: str
    :ivar dns_service_ip: An IP address assigned to the Kubernetes DNS service. It must be within
     the Kubernetes service address range specified in serviceCidr.
    :vartype dns_service_ip: str
    :ivar docker_bridge_cidr: A CIDR notation IP range assigned to the Docker bridge network. It
     must not overlap with any Subnet IP ranges or the Kubernetes service address range.
    :vartype docker_bridge_cidr: str
    """

    _validation = {
        'service_cidr': {'pattern': r'^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$'},
        'dns_service_ip': {'pattern': r'^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$'},
        'docker_bridge_cidr': {'pattern': r'^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$'},
    }

    _attribute_map = {
        'subnet_id': {'key': 'subnetId', 'type': 'str'},
        'service_cidr': {'key': 'serviceCidr', 'type': 'str'},
        'dns_service_ip': {'key': 'dnsServiceIP', 'type': 'str'},
        'docker_bridge_cidr': {'key': 'dockerBridgeCidr', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        subnet_id: Optional[str] = None,
        service_cidr: Optional[str] = None,
        dns_service_ip: Optional[str] = None,
        docker_bridge_cidr: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword subnet_id: Virtual network subnet resource ID the compute nodes belong to.
        :paramtype subnet_id: str
        :keyword service_cidr: A CIDR notation IP range from which to assign service cluster IPs. It
         must not overlap with any Subnet IP ranges.
        :paramtype service_cidr: str
        :keyword dns_service_ip: An IP address assigned to the Kubernetes DNS service. It must be
         within the Kubernetes service address range specified in serviceCidr.
        :paramtype dns_service_ip: str
        :keyword docker_bridge_cidr: A CIDR notation IP range assigned to the Docker bridge network. It
         must not overlap with any Subnet IP ranges or the Kubernetes service address range.
        :paramtype docker_bridge_cidr: str
        """
        super(AksNetworkingConfiguration, self).__init__(**kwargs)
        self.subnet_id = subnet_id
        self.service_cidr = service_cidr
        self.dns_service_ip = dns_service_ip
        self.docker_bridge_cidr = docker_bridge_cidr


class AKSSchemaProperties(msrest.serialization.Model):
    """AKS properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar cluster_fqdn: Cluster full qualified domain name.
    :vartype cluster_fqdn: str
    :ivar system_services: System services.
    :vartype system_services: list[~azure.mgmt.machinelearningservices.models.SystemService]
    :ivar agent_count: Number of agents.
    :vartype agent_count: int
    :ivar agent_vm_size: Agent virtual machine size.
    :vartype agent_vm_size: str
    :ivar cluster_purpose: Intended usage of the cluster. Possible values include: "FastProd",
     "DenseProd", "DevTest". Default value: "FastProd".
    :vartype cluster_purpose: str or ~azure.mgmt.machinelearningservices.models.ClusterPurpose
    :ivar ssl_configuration: SSL configuration.
    :vartype ssl_configuration: ~azure.mgmt.machinelearningservices.models.SslConfiguration
    :ivar aks_networking_configuration: AKS networking configuration for vnet.
    :vartype aks_networking_configuration:
     ~azure.mgmt.machinelearningservices.models.AksNetworkingConfiguration
    :ivar load_balancer_type: Load Balancer Type. Possible values include: "PublicIp",
     "InternalLoadBalancer". Default value: "PublicIp".
    :vartype load_balancer_type: str or ~azure.mgmt.machinelearningservices.models.LoadBalancerType
    :ivar load_balancer_subnet: Load Balancer Subnet.
    :vartype load_balancer_subnet: str
    """

    _validation = {
        'system_services': {'readonly': True},
        'agent_count': {'minimum': 0},
    }

    _attribute_map = {
        'cluster_fqdn': {'key': 'clusterFqdn', 'type': 'str'},
        'system_services': {'key': 'systemServices', 'type': '[SystemService]'},
        'agent_count': {'key': 'agentCount', 'type': 'int'},
        'agent_vm_size': {'key': 'agentVmSize', 'type': 'str'},
        'cluster_purpose': {'key': 'clusterPurpose', 'type': 'str'},
        'ssl_configuration': {'key': 'sslConfiguration', 'type': 'SslConfiguration'},
        'aks_networking_configuration': {'key': 'aksNetworkingConfiguration', 'type': 'AksNetworkingConfiguration'},
        'load_balancer_type': {'key': 'loadBalancerType', 'type': 'str'},
        'load_balancer_subnet': {'key': 'loadBalancerSubnet', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        cluster_fqdn: Optional[str] = None,
        agent_count: Optional[int] = None,
        agent_vm_size: Optional[str] = None,
        cluster_purpose: Optional[Union[str, "ClusterPurpose"]] = "FastProd",
        ssl_configuration: Optional["SslConfiguration"] = None,
        aks_networking_configuration: Optional["AksNetworkingConfiguration"] = None,
        load_balancer_type: Optional[Union[str, "LoadBalancerType"]] = "PublicIp",
        load_balancer_subnet: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword cluster_fqdn: Cluster full qualified domain name.
        :paramtype cluster_fqdn: str
        :keyword agent_count: Number of agents.
        :paramtype agent_count: int
        :keyword agent_vm_size: Agent virtual machine size.
        :paramtype agent_vm_size: str
        :keyword cluster_purpose: Intended usage of the cluster. Possible values include: "FastProd",
         "DenseProd", "DevTest". Default value: "FastProd".
        :paramtype cluster_purpose: str or ~azure.mgmt.machinelearningservices.models.ClusterPurpose
        :keyword ssl_configuration: SSL configuration.
        :paramtype ssl_configuration: ~azure.mgmt.machinelearningservices.models.SslConfiguration
        :keyword aks_networking_configuration: AKS networking configuration for vnet.
        :paramtype aks_networking_configuration:
         ~azure.mgmt.machinelearningservices.models.AksNetworkingConfiguration
        :keyword load_balancer_type: Load Balancer Type. Possible values include: "PublicIp",
         "InternalLoadBalancer". Default value: "PublicIp".
        :paramtype load_balancer_type: str or
         ~azure.mgmt.machinelearningservices.models.LoadBalancerType
        :keyword load_balancer_subnet: Load Balancer Subnet.
        :paramtype load_balancer_subnet: str
        """
        super(AKSSchemaProperties, self).__init__(**kwargs)
        self.cluster_fqdn = cluster_fqdn
        self.system_services = None
        self.agent_count = agent_count
        self.agent_vm_size = agent_vm_size
        self.cluster_purpose = cluster_purpose
        self.ssl_configuration = ssl_configuration
        self.aks_networking_configuration = aks_networking_configuration
        self.load_balancer_type = load_balancer_type
        self.load_balancer_subnet = load_balancer_subnet


class MonitoringFeatureFilterBase(msrest.serialization.Model):
    """MonitoringFeatureFilterBase.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AllFeatures, FeatureSubset, TopNFeaturesByAttribution.

    All required parameters must be populated in order to send to Azure.

    :ivar filter_type: Required. [Required] Specifies the feature filter to leverage when selecting
     features to calculate metrics over.Constant filled by server. Possible values include:
     "AllFeatures", "TopNByAttribution", "FeatureSubset".
    :vartype filter_type: str or
     ~azure.mgmt.machinelearningservices.models.MonitoringFeatureFilterType
    """

    _validation = {
        'filter_type': {'required': True},
    }

    _attribute_map = {
        'filter_type': {'key': 'filterType', 'type': 'str'},
    }

    _subtype_map = {
        'filter_type': {'AllFeatures': 'AllFeatures', 'FeatureSubset': 'FeatureSubset', 'TopNByAttribution': 'TopNFeaturesByAttribution'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(MonitoringFeatureFilterBase, self).__init__(**kwargs)
        self.filter_type = None  # type: Optional[str]


class AllFeatures(MonitoringFeatureFilterBase):
    """AllFeatures.

    All required parameters must be populated in order to send to Azure.

    :ivar filter_type: Required. [Required] Specifies the feature filter to leverage when selecting
     features to calculate metrics over.Constant filled by server. Possible values include:
     "AllFeatures", "TopNByAttribution", "FeatureSubset".
    :vartype filter_type: str or
     ~azure.mgmt.machinelearningservices.models.MonitoringFeatureFilterType
    """

    _validation = {
        'filter_type': {'required': True},
    }

    _attribute_map = {
        'filter_type': {'key': 'filterType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AllFeatures, self).__init__(**kwargs)
        self.filter_type = 'AllFeatures'  # type: str


class Nodes(msrest.serialization.Model):
    """Abstract Nodes definition.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AllNodes.

    All required parameters must be populated in order to send to Azure.

    :ivar nodes_value_type: Required. [Required] Type of the Nodes value.Constant filled by server.
     Possible values include: "All", "Custom".
    :vartype nodes_value_type: str or ~azure.mgmt.machinelearningservices.models.NodesValueType
    """

    _validation = {
        'nodes_value_type': {'required': True},
    }

    _attribute_map = {
        'nodes_value_type': {'key': 'nodesValueType', 'type': 'str'},
    }

    _subtype_map = {
        'nodes_value_type': {'All': 'AllNodes'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Nodes, self).__init__(**kwargs)
        self.nodes_value_type = None  # type: Optional[str]


class AllNodes(Nodes):
    """All nodes means the service will be running on all of the nodes of the job.

    All required parameters must be populated in order to send to Azure.

    :ivar nodes_value_type: Required. [Required] Type of the Nodes value.Constant filled by server.
     Possible values include: "All", "Custom".
    :vartype nodes_value_type: str or ~azure.mgmt.machinelearningservices.models.NodesValueType
    """

    _validation = {
        'nodes_value_type': {'required': True},
    }

    _attribute_map = {
        'nodes_value_type': {'key': 'nodesValueType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AllNodes, self).__init__(**kwargs)
        self.nodes_value_type = 'All'  # type: str


class AmlComputeSchema(msrest.serialization.Model):
    """Properties(top level) of AmlCompute.

    :ivar properties: Properties of AmlCompute.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.AmlComputeProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'AmlComputeProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["AmlComputeProperties"] = None,
        **kwargs
    ):
        """
        :keyword properties: Properties of AmlCompute.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.AmlComputeProperties
        """
        super(AmlComputeSchema, self).__init__(**kwargs)
        self.properties = properties


class AmlCompute(Compute, AmlComputeSchema):
    """An Azure Machine Learning compute.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: Properties of AmlCompute.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.AmlComputeProperties
    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    """

    _validation = {
        'compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'AmlComputeProperties'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[ErrorResponse]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'disable_local_auth': {'key': 'disableLocalAuth', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        properties: Optional["AmlComputeProperties"] = None,
        compute_location: Optional[str] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        disable_local_auth: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword properties: Properties of AmlCompute.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.AmlComputeProperties
        :keyword compute_location: Location for the underlying compute.
        :paramtype compute_location: str
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        :keyword disable_local_auth: Opt-out of local authentication and ensure customers can use only
         MSI and AAD exclusively for authentication.
        :paramtype disable_local_auth: bool
        """
        super(AmlCompute, self).__init__(compute_location=compute_location, description=description, resource_id=resource_id, disable_local_auth=disable_local_auth, properties=properties, **kwargs)
        self.properties = properties
        self.compute_type = 'AmlCompute'  # type: str
        self.compute_location = compute_location
        self.provisioning_state = None
        self.description = description
        self.created_on = None
        self.modified_on = None
        self.resource_id = resource_id
        self.provisioning_errors = None
        self.is_attached_compute = None
        self.disable_local_auth = disable_local_auth


class AmlComputeNodeInformation(msrest.serialization.Model):
    """Compute node information related to a AmlCompute.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar node_id: ID of the compute node.
    :vartype node_id: str
    :ivar private_ip_address: Private IP address of the compute node.
    :vartype private_ip_address: str
    :ivar public_ip_address: Public IP address of the compute node.
    :vartype public_ip_address: str
    :ivar port: SSH port number of the node.
    :vartype port: int
    :ivar node_state: State of the compute node. Values are idle, running, preparing, unusable,
     leaving and preempted. Possible values include: "idle", "running", "preparing", "unusable",
     "leaving", "preempted".
    :vartype node_state: str or ~azure.mgmt.machinelearningservices.models.NodeState
    :ivar run_id: ID of the Experiment running on the node, if any else null.
    :vartype run_id: str
    """

    _validation = {
        'node_id': {'readonly': True},
        'private_ip_address': {'readonly': True},
        'public_ip_address': {'readonly': True},
        'port': {'readonly': True},
        'node_state': {'readonly': True},
        'run_id': {'readonly': True},
    }

    _attribute_map = {
        'node_id': {'key': 'nodeId', 'type': 'str'},
        'private_ip_address': {'key': 'privateIpAddress', 'type': 'str'},
        'public_ip_address': {'key': 'publicIpAddress', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
        'node_state': {'key': 'nodeState', 'type': 'str'},
        'run_id': {'key': 'runId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AmlComputeNodeInformation, self).__init__(**kwargs)
        self.node_id = None
        self.private_ip_address = None
        self.public_ip_address = None
        self.port = None
        self.node_state = None
        self.run_id = None


class AmlComputeNodesInformation(msrest.serialization.Model):
    """Result of AmlCompute Nodes.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar nodes: The collection of returned AmlCompute nodes details.
    :vartype nodes: list[~azure.mgmt.machinelearningservices.models.AmlComputeNodeInformation]
    :ivar next_link: The continuation token.
    :vartype next_link: str
    """

    _validation = {
        'nodes': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'nodes': {'key': 'nodes', 'type': '[AmlComputeNodeInformation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AmlComputeNodesInformation, self).__init__(**kwargs)
        self.nodes = None
        self.next_link = None


class AmlComputeProperties(msrest.serialization.Model):
    """AML Compute properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar os_type: Compute OS Type. Possible values include: "Linux", "Windows". Default value:
     "Linux".
    :vartype os_type: str or ~azure.mgmt.machinelearningservices.models.OsType
    :ivar vm_size: Virtual Machine Size.
    :vartype vm_size: str
    :ivar vm_priority: Virtual Machine priority. Possible values include: "Dedicated",
     "LowPriority".
    :vartype vm_priority: str or ~azure.mgmt.machinelearningservices.models.VmPriority
    :ivar virtual_machine_image: Virtual Machine image for AML Compute - windows only.
    :vartype virtual_machine_image: ~azure.mgmt.machinelearningservices.models.VirtualMachineImage
    :ivar isolated_network: Network is isolated or not.
    :vartype isolated_network: bool
    :ivar scale_settings: Scale settings for AML Compute.
    :vartype scale_settings: ~azure.mgmt.machinelearningservices.models.ScaleSettings
    :ivar user_account_credentials: Credentials for an administrator user account that will be
     created on each compute node.
    :vartype user_account_credentials:
     ~azure.mgmt.machinelearningservices.models.UserAccountCredentials
    :ivar subnet: Virtual network subnet resource ID the compute nodes belong to.
    :vartype subnet: ~azure.mgmt.machinelearningservices.models.ResourceId
    :ivar remote_login_port_public_access: State of the public SSH port. Possible values are:
     Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled -
     Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified -
     Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined,
     else is open all public nodes. It can be default only during cluster creation time, after
     creation it will be either enabled or disabled. Possible values include: "Enabled", "Disabled",
     "NotSpecified". Default value: "NotSpecified".
    :vartype remote_login_port_public_access: str or
     ~azure.mgmt.machinelearningservices.models.RemoteLoginPortPublicAccess
    :ivar allocation_state: Allocation state of the compute. Possible values are: steady -
     Indicates that the compute is not resizing. There are no changes to the number of compute nodes
     in the compute in progress. A compute enters this state when it is created and when no
     operations are being performed on the compute to change the number of compute nodes. resizing -
     Indicates that the compute is resizing; that is, compute nodes are being added to or removed
     from the compute. Possible values include: "Steady", "Resizing".
    :vartype allocation_state: str or ~azure.mgmt.machinelearningservices.models.AllocationState
    :ivar allocation_state_transition_time: The time at which the compute entered its current
     allocation state.
    :vartype allocation_state_transition_time: ~datetime.datetime
    :ivar errors: Collection of errors encountered by various compute nodes during node setup.
    :vartype errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar current_node_count: The number of compute nodes currently assigned to the compute.
    :vartype current_node_count: int
    :ivar target_node_count: The target number of compute nodes for the compute. If the
     allocationState is resizing, this property denotes the target node count for the ongoing resize
     operation. If the allocationState is steady, this property denotes the target node count for
     the previous resize operation.
    :vartype target_node_count: int
    :ivar node_state_counts: Counts of various node states on the compute.
    :vartype node_state_counts: ~azure.mgmt.machinelearningservices.models.NodeStateCounts
    :ivar enable_node_public_ip: Enable or disable node public IP address provisioning. Possible
     values are: Possible values are: true - Indicates that the compute nodes will have public IPs
     provisioned. false - Indicates that the compute nodes will have a private endpoint and no
     public IPs.
    :vartype enable_node_public_ip: bool
    :ivar property_bag: A property bag containing additional properties.
    :vartype property_bag: any
    """

    _validation = {
        'allocation_state': {'readonly': True},
        'allocation_state_transition_time': {'readonly': True},
        'errors': {'readonly': True},
        'current_node_count': {'readonly': True},
        'target_node_count': {'readonly': True},
        'node_state_counts': {'readonly': True},
    }

    _attribute_map = {
        'os_type': {'key': 'osType', 'type': 'str'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'vm_priority': {'key': 'vmPriority', 'type': 'str'},
        'virtual_machine_image': {'key': 'virtualMachineImage', 'type': 'VirtualMachineImage'},
        'isolated_network': {'key': 'isolatedNetwork', 'type': 'bool'},
        'scale_settings': {'key': 'scaleSettings', 'type': 'ScaleSettings'},
        'user_account_credentials': {'key': 'userAccountCredentials', 'type': 'UserAccountCredentials'},
        'subnet': {'key': 'subnet', 'type': 'ResourceId'},
        'remote_login_port_public_access': {'key': 'remoteLoginPortPublicAccess', 'type': 'str'},
        'allocation_state': {'key': 'allocationState', 'type': 'str'},
        'allocation_state_transition_time': {'key': 'allocationStateTransitionTime', 'type': 'iso-8601'},
        'errors': {'key': 'errors', 'type': '[ErrorResponse]'},
        'current_node_count': {'key': 'currentNodeCount', 'type': 'int'},
        'target_node_count': {'key': 'targetNodeCount', 'type': 'int'},
        'node_state_counts': {'key': 'nodeStateCounts', 'type': 'NodeStateCounts'},
        'enable_node_public_ip': {'key': 'enableNodePublicIp', 'type': 'bool'},
        'property_bag': {'key': 'propertyBag', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        os_type: Optional[Union[str, "OsType"]] = "Linux",
        vm_size: Optional[str] = None,
        vm_priority: Optional[Union[str, "VmPriority"]] = None,
        virtual_machine_image: Optional["VirtualMachineImage"] = None,
        isolated_network: Optional[bool] = None,
        scale_settings: Optional["ScaleSettings"] = None,
        user_account_credentials: Optional["UserAccountCredentials"] = None,
        subnet: Optional["ResourceId"] = None,
        remote_login_port_public_access: Optional[Union[str, "RemoteLoginPortPublicAccess"]] = "NotSpecified",
        enable_node_public_ip: Optional[bool] = True,
        property_bag: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword os_type: Compute OS Type. Possible values include: "Linux", "Windows". Default value:
         "Linux".
        :paramtype os_type: str or ~azure.mgmt.machinelearningservices.models.OsType
        :keyword vm_size: Virtual Machine Size.
        :paramtype vm_size: str
        :keyword vm_priority: Virtual Machine priority. Possible values include: "Dedicated",
         "LowPriority".
        :paramtype vm_priority: str or ~azure.mgmt.machinelearningservices.models.VmPriority
        :keyword virtual_machine_image: Virtual Machine image for AML Compute - windows only.
        :paramtype virtual_machine_image:
         ~azure.mgmt.machinelearningservices.models.VirtualMachineImage
        :keyword isolated_network: Network is isolated or not.
        :paramtype isolated_network: bool
        :keyword scale_settings: Scale settings for AML Compute.
        :paramtype scale_settings: ~azure.mgmt.machinelearningservices.models.ScaleSettings
        :keyword user_account_credentials: Credentials for an administrator user account that will be
         created on each compute node.
        :paramtype user_account_credentials:
         ~azure.mgmt.machinelearningservices.models.UserAccountCredentials
        :keyword subnet: Virtual network subnet resource ID the compute nodes belong to.
        :paramtype subnet: ~azure.mgmt.machinelearningservices.models.ResourceId
        :keyword remote_login_port_public_access: State of the public SSH port. Possible values are:
         Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled -
         Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified -
         Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined,
         else is open all public nodes. It can be default only during cluster creation time, after
         creation it will be either enabled or disabled. Possible values include: "Enabled", "Disabled",
         "NotSpecified". Default value: "NotSpecified".
        :paramtype remote_login_port_public_access: str or
         ~azure.mgmt.machinelearningservices.models.RemoteLoginPortPublicAccess
        :keyword enable_node_public_ip: Enable or disable node public IP address provisioning. Possible
         values are: Possible values are: true - Indicates that the compute nodes will have public IPs
         provisioned. false - Indicates that the compute nodes will have a private endpoint and no
         public IPs.
        :paramtype enable_node_public_ip: bool
        :keyword property_bag: A property bag containing additional properties.
        :paramtype property_bag: any
        """
        super(AmlComputeProperties, self).__init__(**kwargs)
        self.os_type = os_type
        self.vm_size = vm_size
        self.vm_priority = vm_priority
        self.virtual_machine_image = virtual_machine_image
        self.isolated_network = isolated_network
        self.scale_settings = scale_settings
        self.user_account_credentials = user_account_credentials
        self.subnet = subnet
        self.remote_login_port_public_access = remote_login_port_public_access
        self.allocation_state = None
        self.allocation_state_transition_time = None
        self.errors = None
        self.current_node_count = None
        self.target_node_count = None
        self.node_state_counts = None
        self.enable_node_public_ip = enable_node_public_ip
        self.property_bag = property_bag


class IdentityConfiguration(msrest.serialization.Model):
    """Base definition for identity configuration.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AmlToken, ManagedIdentity, UserIdentity.

    All required parameters must be populated in order to send to Azure.

    :ivar identity_type: Required. [Required] Specifies the type of identity framework.Constant
     filled by server. Possible values include: "Managed", "AMLToken", "UserIdentity".
    :vartype identity_type: str or
     ~azure.mgmt.machinelearningservices.models.IdentityConfigurationType
    """

    _validation = {
        'identity_type': {'required': True},
    }

    _attribute_map = {
        'identity_type': {'key': 'identityType', 'type': 'str'},
    }

    _subtype_map = {
        'identity_type': {'AMLToken': 'AmlToken', 'Managed': 'ManagedIdentity', 'UserIdentity': 'UserIdentity'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(IdentityConfiguration, self).__init__(**kwargs)
        self.identity_type = None  # type: Optional[str]


class AmlToken(IdentityConfiguration):
    """AML Token identity configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar identity_type: Required. [Required] Specifies the type of identity framework.Constant
     filled by server. Possible values include: "Managed", "AMLToken", "UserIdentity".
    :vartype identity_type: str or
     ~azure.mgmt.machinelearningservices.models.IdentityConfigurationType
    """

    _validation = {
        'identity_type': {'required': True},
    }

    _attribute_map = {
        'identity_type': {'key': 'identityType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AmlToken, self).__init__(**kwargs)
        self.identity_type = 'AMLToken'  # type: str


class MonitorComputeIdentityBase(msrest.serialization.Model):
    """Monitor compute identity base definition.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AmlTokenComputeIdentity, ManagedComputeIdentity.

    All required parameters must be populated in order to send to Azure.

    :ivar compute_identity_type: Required. [Required] Monitor compute identity type enum.Constant
     filled by server. Possible values include: "AmlToken", "ManagedIdentity".
    :vartype compute_identity_type: str or
     ~azure.mgmt.machinelearningservices.models.MonitorComputeIdentityType
    """

    _validation = {
        'compute_identity_type': {'required': True},
    }

    _attribute_map = {
        'compute_identity_type': {'key': 'computeIdentityType', 'type': 'str'},
    }

    _subtype_map = {
        'compute_identity_type': {'AmlToken': 'AmlTokenComputeIdentity', 'ManagedIdentity': 'ManagedComputeIdentity'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(MonitorComputeIdentityBase, self).__init__(**kwargs)
        self.compute_identity_type = None  # type: Optional[str]


class AmlTokenComputeIdentity(MonitorComputeIdentityBase):
    """AML token compute identity definition.

    All required parameters must be populated in order to send to Azure.

    :ivar compute_identity_type: Required. [Required] Monitor compute identity type enum.Constant
     filled by server. Possible values include: "AmlToken", "ManagedIdentity".
    :vartype compute_identity_type: str or
     ~azure.mgmt.machinelearningservices.models.MonitorComputeIdentityType
    """

    _validation = {
        'compute_identity_type': {'required': True},
    }

    _attribute_map = {
        'compute_identity_type': {'key': 'computeIdentityType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AmlTokenComputeIdentity, self).__init__(**kwargs)
        self.compute_identity_type = 'AmlToken'  # type: str


class AmlUserFeature(msrest.serialization.Model):
    """Features enabled for a workspace.

    :ivar id: Specifies the feature ID.
    :vartype id: str
    :ivar display_name: Specifies the feature name.
    :vartype display_name: str
    :ivar description: Describes the feature for user experience.
    :vartype description: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Specifies the feature ID.
        :paramtype id: str
        :keyword display_name: Specifies the feature name.
        :paramtype display_name: str
        :keyword description: Describes the feature for user experience.
        :paramtype description: str
        """
        super(AmlUserFeature, self).__init__(**kwargs)
        self.id = id
        self.display_name = display_name
        self.description = description


class DataReferenceCredential(msrest.serialization.Model):
    """DataReferenceCredential base class.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DockerCredential, ManagedIdentityCredential, AnonymousAccessCredential, SASCredential.

    All required parameters must be populated in order to send to Azure.

    :ivar credential_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "SAS", "DockerCredentials",
     "ManagedIdentity", "NoCredentials".
    :vartype credential_type: str or
     ~azure.mgmt.machinelearningservices.models.DataReferenceCredentialType
    """

    _validation = {
        'credential_type': {'required': True},
    }

    _attribute_map = {
        'credential_type': {'key': 'credentialType', 'type': 'str'},
    }

    _subtype_map = {
        'credential_type': {'DockerCredentials': 'DockerCredential', 'ManagedIdentity': 'ManagedIdentityCredential', 'NoCredentials': 'AnonymousAccessCredential', 'SAS': 'SASCredential'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DataReferenceCredential, self).__init__(**kwargs)
        self.credential_type = None  # type: Optional[str]


class AnonymousAccessCredential(DataReferenceCredential):
    """Access credential with no credentials.

    All required parameters must be populated in order to send to Azure.

    :ivar credential_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "SAS", "DockerCredentials",
     "ManagedIdentity", "NoCredentials".
    :vartype credential_type: str or
     ~azure.mgmt.machinelearningservices.models.DataReferenceCredentialType
    """

    _validation = {
        'credential_type': {'required': True},
    }

    _attribute_map = {
        'credential_type': {'key': 'credentialType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AnonymousAccessCredential, self).__init__(**kwargs)
        self.credential_type = 'NoCredentials'  # type: str


class ApiKeyAuthWorkspaceConnectionProperties(WorkspaceConnectionPropertiesV2):
    """This connection type covers the generic ApiKey auth connection categories, for examples:
AzureOpenAI:
    Category:= AzureOpenAI
    AuthType:= ApiKey (as type discriminator)
    Credentials:= {ApiKey} as Microsoft.MachineLearning.AccountRP.Contracts.WorkspaceConnection.ApiKey
    Target:= {ApiBase}

CognitiveService:
    Category:= CognitiveService
    AuthType:= ApiKey (as type discriminator)
    Credentials:= {SubscriptionKey} as Microsoft.MachineLearning.AccountRP.Contracts.WorkspaceConnection.ApiKey
    Target:= ServiceRegion={serviceRegion}

CognitiveSearch:
    Category:= CognitiveSearch
    AuthType:= ApiKey (as type discriminator)
    Credentials:= {Key} as Microsoft.MachineLearning.AccountRP.Contracts.WorkspaceConnection.ApiKey
    Target:= {Endpoint}

Use Metadata property bag for ApiType, ApiVersion, Kind and other metadata fields.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. Authentication type of the connection target.Constant filled by
     server. Possible values include: "PAT", "ManagedIdentity", "UsernamePassword", "None", "SAS",
     "AccountKey", "ServicePrincipal", "AccessKey", "ApiKey", "CustomKeys", "OAuth2", "AAD".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection. Possible values include: "PythonFeed",
     "ContainerRegistry", "Git", "S3", "Snowflake", "AzureSqlDb", "AzureSynapseAnalytics",
     "AzureMySqlDb", "AzurePostgresDb", "ADLSGen2", "Redis", "ApiKey", "AzureOpenAI",
     "CognitiveSearch", "CognitiveService", "CustomKeys", "AzureBlob", "AzureOneLake", "CosmosDb",
     "CosmosDbMongoDbApi", "AzureDataExplorer", "AzureMariaDb", "AzureDatabricksDeltaLake",
     "AzureSqlMi", "AzureTableStorage", "AmazonRdsForOracle", "AmazonRdsForSqlServer",
     "AmazonRedshift", "Db2", "Drill", "GoogleBigQuery", "Greenplum", "Hbase", "Hive", "Impala",
     "Informix", "MariaDb", "MicrosoftAccess", "MySql", "Netezza", "Oracle", "Phoenix",
     "PostgreSql", "Presto", "SapOpenHub", "SapBw", "SapHana", "SapTable", "Spark", "SqlServer",
     "Sybase", "Teradata", "Vertica", "Cassandra", "Couchbase", "MongoDbV2", "MongoDbAtlas",
     "AmazonS3Compatible", "FileServer", "FtpServer", "GoogleCloudStorage", "Hdfs",
     "OracleCloudStorage", "Sftp", "GenericHttp", "ODataRest", "Odbc", "GenericRest", "AmazonMws",
     "Concur", "Dynamics", "DynamicsAx", "DynamicsCrm", "GoogleAdWords", "Hubspot", "Jira",
     "Magento", "Marketo", "Office365", "Eloqua", "Responsys", "OracleServiceCloud", "PayPal",
     "QuickBooks", "Salesforce", "SalesforceServiceCloud", "SalesforceMarketingCloud",
     "SapCloudForCustomer", "SapEcc", "ServiceNow", "SharePointOnlineList", "Shopify", "Square",
     "WebTable", "Xero", "Zoho", "GenericContainerRegistry", "OpenAI", "Serp", "BingLLMSearch",
     "Serverless".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
    :ivar created_by_workspace_arm_id:
    :vartype created_by_workspace_arm_id: str
    :ivar expiry_time:
    :vartype expiry_time: ~datetime.datetime
    :ivar group: Group based on connection category. Possible values include: "Azure", "AzureAI",
     "Database", "NoSQL", "File", "GenericProtocol", "ServicesAndApps".
    :vartype group: str or ~azure.mgmt.machinelearningservices.models.ConnectionGroup
    :ivar is_shared_to_all:
    :vartype is_shared_to_all: bool
    :ivar metadata: Store user metadata for this connection.
    :vartype metadata: dict[str, str]
    :ivar shared_user_list:
    :vartype shared_user_list: list[str]
    :ivar target:
    :vartype target: str
    :ivar credentials: Api key object for workspace connection credential.
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionApiKey
    """

    _validation = {
        'auth_type': {'required': True},
        'created_by_workspace_arm_id': {'readonly': True},
        'group': {'readonly': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'created_by_workspace_arm_id': {'key': 'createdByWorkspaceArmId', 'type': 'str'},
        'expiry_time': {'key': 'expiryTime', 'type': 'iso-8601'},
        'group': {'key': 'group', 'type': 'str'},
        'is_shared_to_all': {'key': 'isSharedToAll', 'type': 'bool'},
        'metadata': {'key': 'metadata', 'type': '{str}'},
        'shared_user_list': {'key': 'sharedUserList', 'type': '[str]'},
        'target': {'key': 'target', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'WorkspaceConnectionApiKey'},
    }

    def __init__(
        self,
        *,
        category: Optional[Union[str, "ConnectionCategory"]] = None,
        expiry_time: Optional[datetime.datetime] = None,
        is_shared_to_all: Optional[bool] = None,
        metadata: Optional[Dict[str, str]] = None,
        shared_user_list: Optional[List[str]] = None,
        target: Optional[str] = None,
        credentials: Optional["WorkspaceConnectionApiKey"] = None,
        **kwargs
    ):
        """
        :keyword category: Category of the connection. Possible values include: "PythonFeed",
         "ContainerRegistry", "Git", "S3", "Snowflake", "AzureSqlDb", "AzureSynapseAnalytics",
         "AzureMySqlDb", "AzurePostgresDb", "ADLSGen2", "Redis", "ApiKey", "AzureOpenAI",
         "CognitiveSearch", "CognitiveService", "CustomKeys", "AzureBlob", "AzureOneLake", "CosmosDb",
         "CosmosDbMongoDbApi", "AzureDataExplorer", "AzureMariaDb", "AzureDatabricksDeltaLake",
         "AzureSqlMi", "AzureTableStorage", "AmazonRdsForOracle", "AmazonRdsForSqlServer",
         "AmazonRedshift", "Db2", "Drill", "GoogleBigQuery", "Greenplum", "Hbase", "Hive", "Impala",
         "Informix", "MariaDb", "MicrosoftAccess", "MySql", "Netezza", "Oracle", "Phoenix",
         "PostgreSql", "Presto", "SapOpenHub", "SapBw", "SapHana", "SapTable", "Spark", "SqlServer",
         "Sybase", "Teradata", "Vertica", "Cassandra", "Couchbase", "MongoDbV2", "MongoDbAtlas",
         "AmazonS3Compatible", "FileServer", "FtpServer", "GoogleCloudStorage", "Hdfs",
         "OracleCloudStorage", "Sftp", "GenericHttp", "ODataRest", "Odbc", "GenericRest", "AmazonMws",
         "Concur", "Dynamics", "DynamicsAx", "DynamicsCrm", "GoogleAdWords", "Hubspot", "Jira",
         "Magento", "Marketo", "Office365", "Eloqua", "Responsys", "OracleServiceCloud", "PayPal",
         "QuickBooks", "Salesforce", "SalesforceServiceCloud", "SalesforceMarketingCloud",
         "SapCloudForCustomer", "SapEcc", "ServiceNow", "SharePointOnlineList", "Shopify", "Square",
         "WebTable", "Xero", "Zoho", "GenericContainerRegistry", "OpenAI", "Serp", "BingLLMSearch",
         "Serverless".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
        :keyword expiry_time:
        :paramtype expiry_time: ~datetime.datetime
        :keyword is_shared_to_all:
        :paramtype is_shared_to_all: bool
        :keyword metadata: Store user metadata for this connection.
        :paramtype metadata: dict[str, str]
        :keyword shared_user_list:
        :paramtype shared_user_list: list[str]
        :keyword target:
        :paramtype target: str
        :keyword credentials: Api key object for workspace connection credential.
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionApiKey
        """
        super(ApiKeyAuthWorkspaceConnectionProperties, self).__init__(category=category, expiry_time=expiry_time, is_shared_to_all=is_shared_to_all, metadata=metadata, shared_user_list=shared_user_list, target=target, **kwargs)
        self.auth_type = 'ApiKey'  # type: str
        self.credentials = credentials


class ArmResourceId(msrest.serialization.Model):
    """ARM ResourceId of a resource.

    :ivar resource_id: Arm ResourceId is in the format
     "/subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Storage/storageAccounts/{StorageAccountName}"
     or
     "/subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{AcrName}".
    :vartype resource_id: str
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword resource_id: Arm ResourceId is in the format
         "/subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Storage/storageAccounts/{StorageAccountName}"
         or
         "/subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{AcrName}".
        :paramtype resource_id: str
        """
        super(ArmResourceId, self).__init__(**kwargs)
        self.resource_id = resource_id


class ResourceBase(msrest.serialization.Model):
    """ResourceBase.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        """
        super(ResourceBase, self).__init__(**kwargs)
        self.description = description
        self.properties = properties
        self.tags = tags


class AssetBase(ResourceBase):
    """AssetBase.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar auto_delete_setting: Specifies the lifecycle setting of managed data asset.
    :vartype auto_delete_setting: ~azure.mgmt.machinelearningservices.models.AutoDeleteSetting
    :ivar is_anonymous: If the name version are system generated (anonymous registration). For
     types where Stage is defined, when Stage is provided it will be used to populate IsAnonymous.
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived? For types where Stage is defined, when Stage is
     provided it will be used to populate IsArchived.
    :vartype is_archived: bool
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'auto_delete_setting': {'key': 'autoDeleteSetting', 'type': 'AutoDeleteSetting'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        auto_delete_setting: Optional["AutoDeleteSetting"] = None,
        is_anonymous: Optional[bool] = False,
        is_archived: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword auto_delete_setting: Specifies the lifecycle setting of managed data asset.
        :paramtype auto_delete_setting: ~azure.mgmt.machinelearningservices.models.AutoDeleteSetting
        :keyword is_anonymous: If the name version are system generated (anonymous registration). For
         types where Stage is defined, when Stage is provided it will be used to populate IsAnonymous.
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived? For types where Stage is defined, when Stage is
         provided it will be used to populate IsArchived.
        :paramtype is_archived: bool
        """
        super(AssetBase, self).__init__(description=description, properties=properties, tags=tags, **kwargs)
        self.auto_delete_setting = auto_delete_setting
        self.is_anonymous = is_anonymous
        self.is_archived = is_archived


class AssetContainer(ResourceBase):
    """AssetContainer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar latest_version: The latest version inside this container.
    :vartype latest_version: str
    :ivar next_version: The next auto incremental version.
    :vartype next_version: str
    """

    _validation = {
        'latest_version': {'readonly': True},
        'next_version': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'latest_version': {'key': 'latestVersion', 'type': 'str'},
        'next_version': {'key': 'nextVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_archived: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        """
        super(AssetContainer, self).__init__(description=description, properties=properties, tags=tags, **kwargs)
        self.is_archived = is_archived
        self.latest_version = None
        self.next_version = None


class AssetJobInput(msrest.serialization.Model):
    """Asset input type.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
     "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
    :ivar path_on_compute: Input Asset Delivery Path.
    :vartype path_on_compute: str
    :ivar uri: Required. [Required] Input Asset URI.
    :vartype uri: str
    """

    _validation = {
        'uri': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'path_on_compute': {'key': 'pathOnCompute', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        uri: str,
        mode: Optional[Union[str, "InputDeliveryMode"]] = None,
        path_on_compute: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
         "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
        :keyword path_on_compute: Input Asset Delivery Path.
        :paramtype path_on_compute: str
        :keyword uri: Required. [Required] Input Asset URI.
        :paramtype uri: str
        """
        super(AssetJobInput, self).__init__(**kwargs)
        self.mode = mode
        self.path_on_compute = path_on_compute
        self.uri = uri


class AssetJobOutput(msrest.serialization.Model):
    """Asset output type.

    :ivar asset_name: Output Asset Name.
    :vartype asset_name: str
    :ivar asset_version: Output Asset Version.
    :vartype asset_version: str
    :ivar auto_delete_setting: Auto delete setting of output data asset.
    :vartype auto_delete_setting: ~azure.mgmt.machinelearningservices.models.AutoDeleteSetting
    :ivar mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload",
     "Direct".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
    :ivar path_on_compute: Output Asset Delivery Path.
    :vartype path_on_compute: str
    :ivar uri: Output Asset URI.
    :vartype uri: str
    """

    _attribute_map = {
        'asset_name': {'key': 'assetName', 'type': 'str'},
        'asset_version': {'key': 'assetVersion', 'type': 'str'},
        'auto_delete_setting': {'key': 'autoDeleteSetting', 'type': 'AutoDeleteSetting'},
        'mode': {'key': 'mode', 'type': 'str'},
        'path_on_compute': {'key': 'pathOnCompute', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        asset_name: Optional[str] = None,
        asset_version: Optional[str] = None,
        auto_delete_setting: Optional["AutoDeleteSetting"] = None,
        mode: Optional[Union[str, "OutputDeliveryMode"]] = None,
        path_on_compute: Optional[str] = None,
        uri: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword asset_name: Output Asset Name.
        :paramtype asset_name: str
        :keyword asset_version: Output Asset Version.
        :paramtype asset_version: str
        :keyword auto_delete_setting: Auto delete setting of output data asset.
        :paramtype auto_delete_setting: ~azure.mgmt.machinelearningservices.models.AutoDeleteSetting
        :keyword mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload",
         "Direct".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
        :keyword path_on_compute: Output Asset Delivery Path.
        :paramtype path_on_compute: str
        :keyword uri: Output Asset URI.
        :paramtype uri: str
        """
        super(AssetJobOutput, self).__init__(**kwargs)
        self.asset_name = asset_name
        self.asset_version = asset_version
        self.auto_delete_setting = auto_delete_setting
        self.mode = mode
        self.path_on_compute = path_on_compute
        self.uri = uri


class AssetReferenceBase(msrest.serialization.Model):
    """Base definition for asset references.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DataPathAssetReference, IdAssetReference, OutputPathAssetReference.

    All required parameters must be populated in order to send to Azure.

    :ivar reference_type: Required. [Required] Specifies the type of asset reference.Constant
     filled by server. Possible values include: "Id", "DataPath", "OutputPath".
    :vartype reference_type: str or ~azure.mgmt.machinelearningservices.models.ReferenceType
    """

    _validation = {
        'reference_type': {'required': True},
    }

    _attribute_map = {
        'reference_type': {'key': 'referenceType', 'type': 'str'},
    }

    _subtype_map = {
        'reference_type': {'DataPath': 'DataPathAssetReference', 'Id': 'IdAssetReference', 'OutputPath': 'OutputPathAssetReference'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AssetReferenceBase, self).__init__(**kwargs)
        self.reference_type = None  # type: Optional[str]


class AssignedUser(msrest.serialization.Model):
    """A user that can be assigned to a compute instance.

    All required parameters must be populated in order to send to Azure.

    :ivar object_id: Required. User’s AAD Object Id.
    :vartype object_id: str
    :ivar tenant_id: Required. User’s AAD Tenant Id.
    :vartype tenant_id: str
    """

    _validation = {
        'object_id': {'required': True},
        'tenant_id': {'required': True},
    }

    _attribute_map = {
        'object_id': {'key': 'objectId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        object_id: str,
        tenant_id: str,
        **kwargs
    ):
        """
        :keyword object_id: Required. User’s AAD Object Id.
        :paramtype object_id: str
        :keyword tenant_id: Required. User’s AAD Tenant Id.
        :paramtype tenant_id: str
        """
        super(AssignedUser, self).__init__(**kwargs)
        self.object_id = object_id
        self.tenant_id = tenant_id


class AutoDeleteSetting(msrest.serialization.Model):
    """AutoDeleteSetting.

    :ivar condition: When to check if an asset is expired. Possible values include:
     "CreatedGreaterThan", "LastAccessedGreaterThan".
    :vartype condition: str or ~azure.mgmt.machinelearningservices.models.AutoDeleteCondition
    :ivar value: Expiration condition value.
    :vartype value: str
    """

    _attribute_map = {
        'condition': {'key': 'condition', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        condition: Optional[Union[str, "AutoDeleteCondition"]] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword condition: When to check if an asset is expired. Possible values include:
         "CreatedGreaterThan", "LastAccessedGreaterThan".
        :paramtype condition: str or ~azure.mgmt.machinelearningservices.models.AutoDeleteCondition
        :keyword value: Expiration condition value.
        :paramtype value: str
        """
        super(AutoDeleteSetting, self).__init__(**kwargs)
        self.condition = condition
        self.value = value


class ForecastHorizon(msrest.serialization.Model):
    """The desired maximum forecast horizon in units of time-series frequency.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AutoForecastHorizon, CustomForecastHorizon.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Set forecast horizon value selection mode.Constant filled by
     server. Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.ForecastHorizonMode
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
    }

    _subtype_map = {
        'mode': {'Auto': 'AutoForecastHorizon', 'Custom': 'CustomForecastHorizon'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ForecastHorizon, self).__init__(**kwargs)
        self.mode = None  # type: Optional[str]


class AutoForecastHorizon(ForecastHorizon):
    """Forecast horizon determined automatically by system.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Set forecast horizon value selection mode.Constant filled by
     server. Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.ForecastHorizonMode
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AutoForecastHorizon, self).__init__(**kwargs)
        self.mode = 'Auto'  # type: str


class AutologgerSettings(msrest.serialization.Model):
    """Settings for Autologger.

    All required parameters must be populated in order to send to Azure.

    :ivar mlflow_autologger: Required. [Required] Indicates whether mlflow autologger is enabled.
     Possible values include: "Enabled", "Disabled".
    :vartype mlflow_autologger: str or
     ~azure.mgmt.machinelearningservices.models.MLFlowAutologgerState
    """

    _validation = {
        'mlflow_autologger': {'required': True},
    }

    _attribute_map = {
        'mlflow_autologger': {'key': 'mlflowAutologger', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        mlflow_autologger: Union[str, "MLFlowAutologgerState"],
        **kwargs
    ):
        """
        :keyword mlflow_autologger: Required. [Required] Indicates whether mlflow autologger is
         enabled. Possible values include: "Enabled", "Disabled".
        :paramtype mlflow_autologger: str or
         ~azure.mgmt.machinelearningservices.models.MLFlowAutologgerState
        """
        super(AutologgerSettings, self).__init__(**kwargs)
        self.mlflow_autologger = mlflow_autologger


class JobBaseProperties(ResourceBase):
    """Base definition for a job.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AutoMLJob, CommandJob, FineTuningJob, LabelingJobProperties, PipelineJob, SparkJob, SweepJob.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar component_id: ARM resource ID of the component resource.
    :vartype component_id: str
    :ivar compute_id: ARM resource ID of the compute resource.
    :vartype compute_id: str
    :ivar display_name: Display name of job.
    :vartype display_name: str
    :ivar experiment_name: The name of the experiment the job belongs to. If not set, the job is
     placed in the "Default" experiment.
    :vartype experiment_name: str
    :ivar identity: Identity configuration. If set, this should be one of AmlToken,
     ManagedIdentity, UserIdentity or null.
     Defaults to AmlToken if null.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar job_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "AutoML", "Command", "Labeling", "Sweep", "Pipeline", "Spark",
     "FineTuning".
    :vartype job_type: str or ~azure.mgmt.machinelearningservices.models.JobType
    :ivar notification_setting: Notification setting for the job.
    :vartype notification_setting: ~azure.mgmt.machinelearningservices.models.NotificationSetting
    :ivar secrets_configuration: Configuration for secrets to be made available during runtime.
    :vartype secrets_configuration: dict[str,
     ~azure.mgmt.machinelearningservices.models.SecretConfiguration]
    :ivar services: List of JobEndpoints.
     For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
    :vartype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
    :ivar status: Status of the job. Possible values include: "NotStarted", "Starting",
     "Provisioning", "Preparing", "Queued", "Running", "Finalizing", "CancelRequested", "Completed",
     "Failed", "Canceled", "NotResponding", "Paused", "Unknown", "Scheduled".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.JobStatus
    """

    _validation = {
        'job_type': {'required': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'component_id': {'key': 'componentId', 'type': 'str'},
        'compute_id': {'key': 'computeId', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'experiment_name': {'key': 'experimentName', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'IdentityConfiguration'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'notification_setting': {'key': 'notificationSetting', 'type': 'NotificationSetting'},
        'secrets_configuration': {'key': 'secretsConfiguration', 'type': '{SecretConfiguration}'},
        'services': {'key': 'services', 'type': '{JobService}'},
        'status': {'key': 'status', 'type': 'str'},
    }

    _subtype_map = {
        'job_type': {'AutoML': 'AutoMLJob', 'Command': 'CommandJob', 'FineTuning': 'FineTuningJob', 'Labeling': 'LabelingJobProperties', 'Pipeline': 'PipelineJob', 'Spark': 'SparkJob', 'Sweep': 'SweepJob'}
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        component_id: Optional[str] = None,
        compute_id: Optional[str] = None,
        display_name: Optional[str] = None,
        experiment_name: Optional[str] = "Default",
        identity: Optional["IdentityConfiguration"] = None,
        is_archived: Optional[bool] = False,
        notification_setting: Optional["NotificationSetting"] = None,
        secrets_configuration: Optional[Dict[str, "SecretConfiguration"]] = None,
        services: Optional[Dict[str, "JobService"]] = None,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword component_id: ARM resource ID of the component resource.
        :paramtype component_id: str
        :keyword compute_id: ARM resource ID of the compute resource.
        :paramtype compute_id: str
        :keyword display_name: Display name of job.
        :paramtype display_name: str
        :keyword experiment_name: The name of the experiment the job belongs to. If not set, the job is
         placed in the "Default" experiment.
        :paramtype experiment_name: str
        :keyword identity: Identity configuration. If set, this should be one of AmlToken,
         ManagedIdentity, UserIdentity or null.
         Defaults to AmlToken if null.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword notification_setting: Notification setting for the job.
        :paramtype notification_setting: ~azure.mgmt.machinelearningservices.models.NotificationSetting
        :keyword secrets_configuration: Configuration for secrets to be made available during runtime.
        :paramtype secrets_configuration: dict[str,
         ~azure.mgmt.machinelearningservices.models.SecretConfiguration]
        :keyword services: List of JobEndpoints.
         For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :paramtype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
        """
        super(JobBaseProperties, self).__init__(description=description, properties=properties, tags=tags, **kwargs)
        self.component_id = component_id
        self.compute_id = compute_id
        self.display_name = display_name
        self.experiment_name = experiment_name
        self.identity = identity
        self.is_archived = is_archived
        self.job_type = 'JobBaseProperties'  # type: str
        self.notification_setting = notification_setting
        self.secrets_configuration = secrets_configuration
        self.services = services
        self.status = None


class AutoMLJob(JobBaseProperties):
    """AutoMLJob class.
Use this class for executing AutoML tasks like Classification/Regression etc.
See TaskType enum for all the tasks supported.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar component_id: ARM resource ID of the component resource.
    :vartype component_id: str
    :ivar compute_id: ARM resource ID of the compute resource.
    :vartype compute_id: str
    :ivar display_name: Display name of job.
    :vartype display_name: str
    :ivar experiment_name: The name of the experiment the job belongs to. If not set, the job is
     placed in the "Default" experiment.
    :vartype experiment_name: str
    :ivar identity: Identity configuration. If set, this should be one of AmlToken,
     ManagedIdentity, UserIdentity or null.
     Defaults to AmlToken if null.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar job_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "AutoML", "Command", "Labeling", "Sweep", "Pipeline", "Spark",
     "FineTuning".
    :vartype job_type: str or ~azure.mgmt.machinelearningservices.models.JobType
    :ivar notification_setting: Notification setting for the job.
    :vartype notification_setting: ~azure.mgmt.machinelearningservices.models.NotificationSetting
    :ivar secrets_configuration: Configuration for secrets to be made available during runtime.
    :vartype secrets_configuration: dict[str,
     ~azure.mgmt.machinelearningservices.models.SecretConfiguration]
    :ivar services: List of JobEndpoints.
     For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
    :vartype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
    :ivar status: Status of the job. Possible values include: "NotStarted", "Starting",
     "Provisioning", "Preparing", "Queued", "Running", "Finalizing", "CancelRequested", "Completed",
     "Failed", "Canceled", "NotResponding", "Paused", "Unknown", "Scheduled".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.JobStatus
    :ivar environment_id: The ARM resource ID of the Environment specification for the job.
     This is optional value to provide, if not provided, AutoML will default this to Production
     AutoML curated environment version when running the job.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables included in the job.
    :vartype environment_variables: dict[str, str]
    :ivar outputs: Mapping of output data bindings used in the job.
    :vartype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
    :ivar queue_settings: Queue settings for the job.
    :vartype queue_settings: ~azure.mgmt.machinelearningservices.models.QueueSettings
    :ivar resources: Compute Resource configuration for the job.
    :vartype resources: ~azure.mgmt.machinelearningservices.models.JobResourceConfiguration
    :ivar task_details: Required. [Required] This represents scenario which can be one of
     Tables/NLP/Image.
    :vartype task_details: ~azure.mgmt.machinelearningservices.models.AutoMLVertical
    """

    _validation = {
        'job_type': {'required': True},
        'status': {'readonly': True},
        'task_details': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'component_id': {'key': 'componentId', 'type': 'str'},
        'compute_id': {'key': 'computeId', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'experiment_name': {'key': 'experimentName', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'IdentityConfiguration'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'notification_setting': {'key': 'notificationSetting', 'type': 'NotificationSetting'},
        'secrets_configuration': {'key': 'secretsConfiguration', 'type': '{SecretConfiguration}'},
        'services': {'key': 'services', 'type': '{JobService}'},
        'status': {'key': 'status', 'type': 'str'},
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'environment_variables': {'key': 'environmentVariables', 'type': '{str}'},
        'outputs': {'key': 'outputs', 'type': '{JobOutput}'},
        'queue_settings': {'key': 'queueSettings', 'type': 'QueueSettings'},
        'resources': {'key': 'resources', 'type': 'JobResourceConfiguration'},
        'task_details': {'key': 'taskDetails', 'type': 'AutoMLVertical'},
    }

    def __init__(
        self,
        *,
        task_details: "AutoMLVertical",
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        component_id: Optional[str] = None,
        compute_id: Optional[str] = None,
        display_name: Optional[str] = None,
        experiment_name: Optional[str] = "Default",
        identity: Optional["IdentityConfiguration"] = None,
        is_archived: Optional[bool] = False,
        notification_setting: Optional["NotificationSetting"] = None,
        secrets_configuration: Optional[Dict[str, "SecretConfiguration"]] = None,
        services: Optional[Dict[str, "JobService"]] = None,
        environment_id: Optional[str] = None,
        environment_variables: Optional[Dict[str, str]] = None,
        outputs: Optional[Dict[str, "JobOutput"]] = None,
        queue_settings: Optional["QueueSettings"] = None,
        resources: Optional["JobResourceConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword component_id: ARM resource ID of the component resource.
        :paramtype component_id: str
        :keyword compute_id: ARM resource ID of the compute resource.
        :paramtype compute_id: str
        :keyword display_name: Display name of job.
        :paramtype display_name: str
        :keyword experiment_name: The name of the experiment the job belongs to. If not set, the job is
         placed in the "Default" experiment.
        :paramtype experiment_name: str
        :keyword identity: Identity configuration. If set, this should be one of AmlToken,
         ManagedIdentity, UserIdentity or null.
         Defaults to AmlToken if null.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword notification_setting: Notification setting for the job.
        :paramtype notification_setting: ~azure.mgmt.machinelearningservices.models.NotificationSetting
        :keyword secrets_configuration: Configuration for secrets to be made available during runtime.
        :paramtype secrets_configuration: dict[str,
         ~azure.mgmt.machinelearningservices.models.SecretConfiguration]
        :keyword services: List of JobEndpoints.
         For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :paramtype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
        :keyword environment_id: The ARM resource ID of the Environment specification for the job.
         This is optional value to provide, if not provided, AutoML will default this to Production
         AutoML curated environment version when running the job.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables included in the job.
        :paramtype environment_variables: dict[str, str]
        :keyword outputs: Mapping of output data bindings used in the job.
        :paramtype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
        :keyword queue_settings: Queue settings for the job.
        :paramtype queue_settings: ~azure.mgmt.machinelearningservices.models.QueueSettings
        :keyword resources: Compute Resource configuration for the job.
        :paramtype resources: ~azure.mgmt.machinelearningservices.models.JobResourceConfiguration
        :keyword task_details: Required. [Required] This represents scenario which can be one of
         Tables/NLP/Image.
        :paramtype task_details: ~azure.mgmt.machinelearningservices.models.AutoMLVertical
        """
        super(AutoMLJob, self).__init__(description=description, properties=properties, tags=tags, component_id=component_id, compute_id=compute_id, display_name=display_name, experiment_name=experiment_name, identity=identity, is_archived=is_archived, notification_setting=notification_setting, secrets_configuration=secrets_configuration, services=services, **kwargs)
        self.job_type = 'AutoML'  # type: str
        self.environment_id = environment_id
        self.environment_variables = environment_variables
        self.outputs = outputs
        self.queue_settings = queue_settings
        self.resources = resources
        self.task_details = task_details


class AutoMLVertical(msrest.serialization.Model):
    """AutoML vertical class.
Base class for AutoML verticals - TableVertical/ImageVertical/NLPVertical.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Classification, Forecasting, ImageClassification, ImageClassificationMultilabel, ImageInstanceSegmentation, ImageObjectDetection, Regression, TextClassification, TextClassificationMultilabel, TextNer.

    All required parameters must be populated in order to send to Azure.

    :ivar log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
     "Info", "Warning", "Error", "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar target_column_name: Target column name: This is prediction values column.
     Also known as label column name in context of classification tasks.
    :vartype target_column_name: str
    :ivar task_type: Required. [Required] Task type for AutoMLJob.Constant filled by server.
     Possible values include: "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    :ivar training_data: Required. [Required] Training data input.
    :vartype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    """

    _validation = {
        'task_type': {'required': True},
        'training_data': {'required': True},
    }

    _attribute_map = {
        'log_verbosity': {'key': 'logVerbosity', 'type': 'str'},
        'target_column_name': {'key': 'targetColumnName', 'type': 'str'},
        'task_type': {'key': 'taskType', 'type': 'str'},
        'training_data': {'key': 'trainingData', 'type': 'MLTableJobInput'},
    }

    _subtype_map = {
        'task_type': {'Classification': 'Classification', 'Forecasting': 'Forecasting', 'ImageClassification': 'ImageClassification', 'ImageClassificationMultilabel': 'ImageClassificationMultilabel', 'ImageInstanceSegmentation': 'ImageInstanceSegmentation', 'ImageObjectDetection': 'ImageObjectDetection', 'Regression': 'Regression', 'TextClassification': 'TextClassification', 'TextClassificationMultilabel': 'TextClassificationMultilabel', 'TextNER': 'TextNer'}
    }

    def __init__(
        self,
        *,
        training_data: "MLTableJobInput",
        log_verbosity: Optional[Union[str, "LogVerbosity"]] = None,
        target_column_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
         "Info", "Warning", "Error", "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        :keyword target_column_name: Target column name: This is prediction values column.
         Also known as label column name in context of classification tasks.
        :paramtype target_column_name: str
        :keyword training_data: Required. [Required] Training data input.
        :paramtype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        """
        super(AutoMLVertical, self).__init__(**kwargs)
        self.log_verbosity = log_verbosity
        self.target_column_name = target_column_name
        self.task_type = None  # type: Optional[str]
        self.training_data = training_data


class NCrossValidations(msrest.serialization.Model):
    """N-Cross validations value.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AutoNCrossValidations, CustomNCrossValidations.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Mode for determining N-Cross validations.Constant filled by
     server. Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.NCrossValidationsMode
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
    }

    _subtype_map = {
        'mode': {'Auto': 'AutoNCrossValidations', 'Custom': 'CustomNCrossValidations'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(NCrossValidations, self).__init__(**kwargs)
        self.mode = None  # type: Optional[str]


class AutoNCrossValidations(NCrossValidations):
    """N-Cross validations determined automatically.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Mode for determining N-Cross validations.Constant filled by
     server. Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.NCrossValidationsMode
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AutoNCrossValidations, self).__init__(**kwargs)
        self.mode = 'Auto'  # type: str


class AutoPauseProperties(msrest.serialization.Model):
    """Auto pause properties.

    :ivar delay_in_minutes:
    :vartype delay_in_minutes: int
    :ivar enabled:
    :vartype enabled: bool
    """

    _attribute_map = {
        'delay_in_minutes': {'key': 'delayInMinutes', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        delay_in_minutes: Optional[int] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword delay_in_minutes:
        :paramtype delay_in_minutes: int
        :keyword enabled:
        :paramtype enabled: bool
        """
        super(AutoPauseProperties, self).__init__(**kwargs)
        self.delay_in_minutes = delay_in_minutes
        self.enabled = enabled


class AutoScaleProperties(msrest.serialization.Model):
    """Auto scale properties.

    :ivar min_node_count:
    :vartype min_node_count: int
    :ivar enabled:
    :vartype enabled: bool
    :ivar max_node_count:
    :vartype max_node_count: int
    """

    _attribute_map = {
        'min_node_count': {'key': 'minNodeCount', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'max_node_count': {'key': 'maxNodeCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        min_node_count: Optional[int] = None,
        enabled: Optional[bool] = None,
        max_node_count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword min_node_count:
        :paramtype min_node_count: int
        :keyword enabled:
        :paramtype enabled: bool
        :keyword max_node_count:
        :paramtype max_node_count: int
        """
        super(AutoScaleProperties, self).__init__(**kwargs)
        self.min_node_count = min_node_count
        self.enabled = enabled
        self.max_node_count = max_node_count


class Seasonality(msrest.serialization.Model):
    """Forecasting seasonality.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AutoSeasonality, CustomSeasonality.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Seasonality mode.Constant filled by server. Possible values
     include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.SeasonalityMode
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
    }

    _subtype_map = {
        'mode': {'Auto': 'AutoSeasonality', 'Custom': 'CustomSeasonality'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Seasonality, self).__init__(**kwargs)
        self.mode = None  # type: Optional[str]


class AutoSeasonality(Seasonality):
    """AutoSeasonality.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Seasonality mode.Constant filled by server. Possible values
     include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.SeasonalityMode
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AutoSeasonality, self).__init__(**kwargs)
        self.mode = 'Auto'  # type: str


class TargetLags(msrest.serialization.Model):
    """The number of past periods to lag from the target column.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AutoTargetLags, CustomTargetLags.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Set target lags mode - Auto/Custom.Constant filled by server.
     Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.TargetLagsMode
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
    }

    _subtype_map = {
        'mode': {'Auto': 'AutoTargetLags', 'Custom': 'CustomTargetLags'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(TargetLags, self).__init__(**kwargs)
        self.mode = None  # type: Optional[str]


class AutoTargetLags(TargetLags):
    """AutoTargetLags.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Set target lags mode - Auto/Custom.Constant filled by server.
     Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.TargetLagsMode
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AutoTargetLags, self).__init__(**kwargs)
        self.mode = 'Auto'  # type: str


class TargetRollingWindowSize(msrest.serialization.Model):
    """Forecasting target rolling window size.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AutoTargetRollingWindowSize, CustomTargetRollingWindowSize.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] TargetRollingWindowSiz detection mode.Constant filled by
     server. Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.TargetRollingWindowSizeMode
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
    }

    _subtype_map = {
        'mode': {'Auto': 'AutoTargetRollingWindowSize', 'Custom': 'CustomTargetRollingWindowSize'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(TargetRollingWindowSize, self).__init__(**kwargs)
        self.mode = None  # type: Optional[str]


class AutoTargetRollingWindowSize(TargetRollingWindowSize):
    """Target lags rolling window determined automatically.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] TargetRollingWindowSiz detection mode.Constant filled by
     server. Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.TargetRollingWindowSizeMode
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AutoTargetRollingWindowSize, self).__init__(**kwargs)
        self.mode = 'Auto'  # type: str


class AzureDatastore(msrest.serialization.Model):
    """Base definition for Azure datastore contents configuration.

    :ivar resource_group: Azure Resource Group name.
    :vartype resource_group: str
    :ivar subscription_id: Azure Subscription Id.
    :vartype subscription_id: str
    """

    _attribute_map = {
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_group: Optional[str] = None,
        subscription_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword resource_group: Azure Resource Group name.
        :paramtype resource_group: str
        :keyword subscription_id: Azure Subscription Id.
        :paramtype subscription_id: str
        """
        super(AzureDatastore, self).__init__(**kwargs)
        self.resource_group = resource_group
        self.subscription_id = subscription_id


class DatastoreProperties(ResourceBase):
    """Base definition for datastore contents configuration.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureBlobDatastore, AzureDataLakeGen1Datastore, AzureDataLakeGen2Datastore, AzureFileDatastore, HdfsDatastore, OneLakeDatastore.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar credentials: Required. [Required] Account credentials.
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
    :ivar datastore_type: Required. [Required] Storage type backing the datastore.Constant filled
     by server. Possible values include: "AzureBlob", "AzureDataLakeGen1", "AzureDataLakeGen2",
     "AzureFile", "Hdfs", "OneLake".
    :vartype datastore_type: str or ~azure.mgmt.machinelearningservices.models.DatastoreType
    :ivar intellectual_property: Intellectual Property details.
    :vartype intellectual_property: ~azure.mgmt.machinelearningservices.models.IntellectualProperty
    :ivar is_default: Readonly property to indicate if datastore is the workspace default
     datastore.
    :vartype is_default: bool
    """

    _validation = {
        'credentials': {'required': True},
        'datastore_type': {'required': True},
        'is_default': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'credentials': {'key': 'credentials', 'type': 'DatastoreCredentials'},
        'datastore_type': {'key': 'datastoreType', 'type': 'str'},
        'intellectual_property': {'key': 'intellectualProperty', 'type': 'IntellectualProperty'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
    }

    _subtype_map = {
        'datastore_type': {'AzureBlob': 'AzureBlobDatastore', 'AzureDataLakeGen1': 'AzureDataLakeGen1Datastore', 'AzureDataLakeGen2': 'AzureDataLakeGen2Datastore', 'AzureFile': 'AzureFileDatastore', 'Hdfs': 'HdfsDatastore', 'OneLake': 'OneLakeDatastore'}
    }

    def __init__(
        self,
        *,
        credentials: "DatastoreCredentials",
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        intellectual_property: Optional["IntellectualProperty"] = None,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword credentials: Required. [Required] Account credentials.
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
        :keyword intellectual_property: Intellectual Property details.
        :paramtype intellectual_property:
         ~azure.mgmt.machinelearningservices.models.IntellectualProperty
        """
        super(DatastoreProperties, self).__init__(description=description, properties=properties, tags=tags, **kwargs)
        self.credentials = credentials
        self.datastore_type = 'DatastoreProperties'  # type: str
        self.intellectual_property = intellectual_property
        self.is_default = None


class AzureBlobDatastore(DatastoreProperties, AzureDatastore):
    """Azure Blob datastore configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_group: Azure Resource Group name.
    :vartype resource_group: str
    :ivar subscription_id: Azure Subscription Id.
    :vartype subscription_id: str
    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar credentials: Required. [Required] Account credentials.
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
    :ivar datastore_type: Required. [Required] Storage type backing the datastore.Constant filled
     by server. Possible values include: "AzureBlob", "AzureDataLakeGen1", "AzureDataLakeGen2",
     "AzureFile", "Hdfs", "OneLake".
    :vartype datastore_type: str or ~azure.mgmt.machinelearningservices.models.DatastoreType
    :ivar intellectual_property: Intellectual Property details.
    :vartype intellectual_property: ~azure.mgmt.machinelearningservices.models.IntellectualProperty
    :ivar is_default: Readonly property to indicate if datastore is the workspace default
     datastore.
    :vartype is_default: bool
    :ivar account_name: Storage account name.
    :vartype account_name: str
    :ivar container_name: Storage account container name.
    :vartype container_name: str
    :ivar endpoint: Azure cloud endpoint for the storage account.
    :vartype endpoint: str
    :ivar protocol: Protocol used to communicate with the storage account.
    :vartype protocol: str
    :ivar service_data_access_auth_identity: Indicates which identity to use to authenticate
     service data access to customer's storage. Possible values include: "None",
     "WorkspaceSystemAssignedIdentity", "WorkspaceUserAssignedIdentity".
    :vartype service_data_access_auth_identity: str or
     ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
    """

    _validation = {
        'credentials': {'required': True},
        'datastore_type': {'required': True},
        'is_default': {'readonly': True},
    }

    _attribute_map = {
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'credentials': {'key': 'credentials', 'type': 'DatastoreCredentials'},
        'datastore_type': {'key': 'datastoreType', 'type': 'str'},
        'intellectual_property': {'key': 'intellectualProperty', 'type': 'IntellectualProperty'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
        'account_name': {'key': 'accountName', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'endpoint': {'key': 'endpoint', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'service_data_access_auth_identity': {'key': 'serviceDataAccessAuthIdentity', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        credentials: "DatastoreCredentials",
        resource_group: Optional[str] = None,
        subscription_id: Optional[str] = None,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        intellectual_property: Optional["IntellectualProperty"] = None,
        account_name: Optional[str] = None,
        container_name: Optional[str] = None,
        endpoint: Optional[str] = None,
        protocol: Optional[str] = None,
        service_data_access_auth_identity: Optional[Union[str, "ServiceDataAccessAuthIdentity"]] = None,
        **kwargs
    ):
        """
        :keyword resource_group: Azure Resource Group name.
        :paramtype resource_group: str
        :keyword subscription_id: Azure Subscription Id.
        :paramtype subscription_id: str
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword credentials: Required. [Required] Account credentials.
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
        :keyword intellectual_property: Intellectual Property details.
        :paramtype intellectual_property:
         ~azure.mgmt.machinelearningservices.models.IntellectualProperty
        :keyword account_name: Storage account name.
        :paramtype account_name: str
        :keyword container_name: Storage account container name.
        :paramtype container_name: str
        :keyword endpoint: Azure cloud endpoint for the storage account.
        :paramtype endpoint: str
        :keyword protocol: Protocol used to communicate with the storage account.
        :paramtype protocol: str
        :keyword service_data_access_auth_identity: Indicates which identity to use to authenticate
         service data access to customer's storage. Possible values include: "None",
         "WorkspaceSystemAssignedIdentity", "WorkspaceUserAssignedIdentity".
        :paramtype service_data_access_auth_identity: str or
         ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
        """
        super(AzureBlobDatastore, self).__init__(description=description, properties=properties, tags=tags, credentials=credentials, intellectual_property=intellectual_property, resource_group=resource_group, subscription_id=subscription_id, **kwargs)
        self.resource_group = resource_group
        self.subscription_id = subscription_id
        self.datastore_type = 'AzureBlob'  # type: str
        self.account_name = account_name
        self.container_name = container_name
        self.endpoint = endpoint
        self.protocol = protocol
        self.service_data_access_auth_identity = service_data_access_auth_identity
        self.description = description
        self.properties = properties
        self.tags = tags
        self.credentials = credentials
        self.intellectual_property = intellectual_property
        self.is_default = None


class AzureDataLakeGen1Datastore(DatastoreProperties, AzureDatastore):
    """Azure Data Lake Gen1 datastore configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_group: Azure Resource Group name.
    :vartype resource_group: str
    :ivar subscription_id: Azure Subscription Id.
    :vartype subscription_id: str
    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar credentials: Required. [Required] Account credentials.
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
    :ivar datastore_type: Required. [Required] Storage type backing the datastore.Constant filled
     by server. Possible values include: "AzureBlob", "AzureDataLakeGen1", "AzureDataLakeGen2",
     "AzureFile", "Hdfs", "OneLake".
    :vartype datastore_type: str or ~azure.mgmt.machinelearningservices.models.DatastoreType
    :ivar intellectual_property: Intellectual Property details.
    :vartype intellectual_property: ~azure.mgmt.machinelearningservices.models.IntellectualProperty
    :ivar is_default: Readonly property to indicate if datastore is the workspace default
     datastore.
    :vartype is_default: bool
    :ivar service_data_access_auth_identity: Indicates which identity to use to authenticate
     service data access to customer's storage. Possible values include: "None",
     "WorkspaceSystemAssignedIdentity", "WorkspaceUserAssignedIdentity".
    :vartype service_data_access_auth_identity: str or
     ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
    :ivar store_name: Required. [Required] Azure Data Lake store name.
    :vartype store_name: str
    """

    _validation = {
        'credentials': {'required': True},
        'datastore_type': {'required': True},
        'is_default': {'readonly': True},
        'store_name': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'credentials': {'key': 'credentials', 'type': 'DatastoreCredentials'},
        'datastore_type': {'key': 'datastoreType', 'type': 'str'},
        'intellectual_property': {'key': 'intellectualProperty', 'type': 'IntellectualProperty'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
        'service_data_access_auth_identity': {'key': 'serviceDataAccessAuthIdentity', 'type': 'str'},
        'store_name': {'key': 'storeName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        credentials: "DatastoreCredentials",
        store_name: str,
        resource_group: Optional[str] = None,
        subscription_id: Optional[str] = None,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        intellectual_property: Optional["IntellectualProperty"] = None,
        service_data_access_auth_identity: Optional[Union[str, "ServiceDataAccessAuthIdentity"]] = None,
        **kwargs
    ):
        """
        :keyword resource_group: Azure Resource Group name.
        :paramtype resource_group: str
        :keyword subscription_id: Azure Subscription Id.
        :paramtype subscription_id: str
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword credentials: Required. [Required] Account credentials.
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
        :keyword intellectual_property: Intellectual Property details.
        :paramtype intellectual_property:
         ~azure.mgmt.machinelearningservices.models.IntellectualProperty
        :keyword service_data_access_auth_identity: Indicates which identity to use to authenticate
         service data access to customer's storage. Possible values include: "None",
         "WorkspaceSystemAssignedIdentity", "WorkspaceUserAssignedIdentity".
        :paramtype service_data_access_auth_identity: str or
         ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
        :keyword store_name: Required. [Required] Azure Data Lake store name.
        :paramtype store_name: str
        """
        super(AzureDataLakeGen1Datastore, self).__init__(description=description, properties=properties, tags=tags, credentials=credentials, intellectual_property=intellectual_property, resource_group=resource_group, subscription_id=subscription_id, **kwargs)
        self.resource_group = resource_group
        self.subscription_id = subscription_id
        self.datastore_type = 'AzureDataLakeGen1'  # type: str
        self.service_data_access_auth_identity = service_data_access_auth_identity
        self.store_name = store_name
        self.description = description
        self.properties = properties
        self.tags = tags
        self.credentials = credentials
        self.intellectual_property = intellectual_property
        self.is_default = None


class AzureDataLakeGen2Datastore(DatastoreProperties, AzureDatastore):
    """Azure Data Lake Gen2 datastore configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_group: Azure Resource Group name.
    :vartype resource_group: str
    :ivar subscription_id: Azure Subscription Id.
    :vartype subscription_id: str
    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar credentials: Required. [Required] Account credentials.
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
    :ivar datastore_type: Required. [Required] Storage type backing the datastore.Constant filled
     by server. Possible values include: "AzureBlob", "AzureDataLakeGen1", "AzureDataLakeGen2",
     "AzureFile", "Hdfs", "OneLake".
    :vartype datastore_type: str or ~azure.mgmt.machinelearningservices.models.DatastoreType
    :ivar intellectual_property: Intellectual Property details.
    :vartype intellectual_property: ~azure.mgmt.machinelearningservices.models.IntellectualProperty
    :ivar is_default: Readonly property to indicate if datastore is the workspace default
     datastore.
    :vartype is_default: bool
    :ivar account_name: Required. [Required] Storage account name.
    :vartype account_name: str
    :ivar endpoint: Azure cloud endpoint for the storage account.
    :vartype endpoint: str
    :ivar filesystem: Required. [Required] The name of the Data Lake Gen2 filesystem.
    :vartype filesystem: str
    :ivar protocol: Protocol used to communicate with the storage account.
    :vartype protocol: str
    :ivar service_data_access_auth_identity: Indicates which identity to use to authenticate
     service data access to customer's storage. Possible values include: "None",
     "WorkspaceSystemAssignedIdentity", "WorkspaceUserAssignedIdentity".
    :vartype service_data_access_auth_identity: str or
     ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
    """

    _validation = {
        'credentials': {'required': True},
        'datastore_type': {'required': True},
        'is_default': {'readonly': True},
        'account_name': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
        'filesystem': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'credentials': {'key': 'credentials', 'type': 'DatastoreCredentials'},
        'datastore_type': {'key': 'datastoreType', 'type': 'str'},
        'intellectual_property': {'key': 'intellectualProperty', 'type': 'IntellectualProperty'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
        'account_name': {'key': 'accountName', 'type': 'str'},
        'endpoint': {'key': 'endpoint', 'type': 'str'},
        'filesystem': {'key': 'filesystem', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'service_data_access_auth_identity': {'key': 'serviceDataAccessAuthIdentity', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        credentials: "DatastoreCredentials",
        account_name: str,
        filesystem: str,
        resource_group: Optional[str] = None,
        subscription_id: Optional[str] = None,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        intellectual_property: Optional["IntellectualProperty"] = None,
        endpoint: Optional[str] = None,
        protocol: Optional[str] = None,
        service_data_access_auth_identity: Optional[Union[str, "ServiceDataAccessAuthIdentity"]] = None,
        **kwargs
    ):
        """
        :keyword resource_group: Azure Resource Group name.
        :paramtype resource_group: str
        :keyword subscription_id: Azure Subscription Id.
        :paramtype subscription_id: str
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword credentials: Required. [Required] Account credentials.
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
        :keyword intellectual_property: Intellectual Property details.
        :paramtype intellectual_property:
         ~azure.mgmt.machinelearningservices.models.IntellectualProperty
        :keyword account_name: Required. [Required] Storage account name.
        :paramtype account_name: str
        :keyword endpoint: Azure cloud endpoint for the storage account.
        :paramtype endpoint: str
        :keyword filesystem: Required. [Required] The name of the Data Lake Gen2 filesystem.
        :paramtype filesystem: str
        :keyword protocol: Protocol used to communicate with the storage account.
        :paramtype protocol: str
        :keyword service_data_access_auth_identity: Indicates which identity to use to authenticate
         service data access to customer's storage. Possible values include: "None",
         "WorkspaceSystemAssignedIdentity", "WorkspaceUserAssignedIdentity".
        :paramtype service_data_access_auth_identity: str or
         ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
        """
        super(AzureDataLakeGen2Datastore, self).__init__(description=description, properties=properties, tags=tags, credentials=credentials, intellectual_property=intellectual_property, resource_group=resource_group, subscription_id=subscription_id, **kwargs)
        self.resource_group = resource_group
        self.subscription_id = subscription_id
        self.datastore_type = 'AzureDataLakeGen2'  # type: str
        self.account_name = account_name
        self.endpoint = endpoint
        self.filesystem = filesystem
        self.protocol = protocol
        self.service_data_access_auth_identity = service_data_access_auth_identity
        self.description = description
        self.properties = properties
        self.tags = tags
        self.credentials = credentials
        self.intellectual_property = intellectual_property
        self.is_default = None


class Webhook(msrest.serialization.Model):
    """Webhook base.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureDevOpsWebhook.

    All required parameters must be populated in order to send to Azure.

    :ivar event_type: Send callback on a specified notification event.
    :vartype event_type: str
    :ivar webhook_type: Required. [Required] Specifies the type of service to send a
     callback.Constant filled by server. Possible values include: "AzureDevOps".
    :vartype webhook_type: str or ~azure.mgmt.machinelearningservices.models.WebhookType
    """

    _validation = {
        'webhook_type': {'required': True},
    }

    _attribute_map = {
        'event_type': {'key': 'eventType', 'type': 'str'},
        'webhook_type': {'key': 'webhookType', 'type': 'str'},
    }

    _subtype_map = {
        'webhook_type': {'AzureDevOps': 'AzureDevOpsWebhook'}
    }

    def __init__(
        self,
        *,
        event_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword event_type: Send callback on a specified notification event.
        :paramtype event_type: str
        """
        super(Webhook, self).__init__(**kwargs)
        self.event_type = event_type
        self.webhook_type = None  # type: Optional[str]


class AzureDevOpsWebhook(Webhook):
    """Webhook details specific for Azure DevOps.

    All required parameters must be populated in order to send to Azure.

    :ivar event_type: Send callback on a specified notification event.
    :vartype event_type: str
    :ivar webhook_type: Required. [Required] Specifies the type of service to send a
     callback.Constant filled by server. Possible values include: "AzureDevOps".
    :vartype webhook_type: str or ~azure.mgmt.machinelearningservices.models.WebhookType
    """

    _validation = {
        'webhook_type': {'required': True},
    }

    _attribute_map = {
        'event_type': {'key': 'eventType', 'type': 'str'},
        'webhook_type': {'key': 'webhookType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        event_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword event_type: Send callback on a specified notification event.
        :paramtype event_type: str
        """
        super(AzureDevOpsWebhook, self).__init__(event_type=event_type, **kwargs)
        self.webhook_type = 'AzureDevOps'  # type: str


class AzureFileDatastore(DatastoreProperties, AzureDatastore):
    """Azure File datastore configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_group: Azure Resource Group name.
    :vartype resource_group: str
    :ivar subscription_id: Azure Subscription Id.
    :vartype subscription_id: str
    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar credentials: Required. [Required] Account credentials.
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
    :ivar datastore_type: Required. [Required] Storage type backing the datastore.Constant filled
     by server. Possible values include: "AzureBlob", "AzureDataLakeGen1", "AzureDataLakeGen2",
     "AzureFile", "Hdfs", "OneLake".
    :vartype datastore_type: str or ~azure.mgmt.machinelearningservices.models.DatastoreType
    :ivar intellectual_property: Intellectual Property details.
    :vartype intellectual_property: ~azure.mgmt.machinelearningservices.models.IntellectualProperty
    :ivar is_default: Readonly property to indicate if datastore is the workspace default
     datastore.
    :vartype is_default: bool
    :ivar account_name: Required. [Required] Storage account name.
    :vartype account_name: str
    :ivar endpoint: Azure cloud endpoint for the storage account.
    :vartype endpoint: str
    :ivar file_share_name: Required. [Required] The name of the Azure file share that the datastore
     points to.
    :vartype file_share_name: str
    :ivar protocol: Protocol used to communicate with the storage account.
    :vartype protocol: str
    :ivar service_data_access_auth_identity: Indicates which identity to use to authenticate
     service data access to customer's storage. Possible values include: "None",
     "WorkspaceSystemAssignedIdentity", "WorkspaceUserAssignedIdentity".
    :vartype service_data_access_auth_identity: str or
     ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
    """

    _validation = {
        'credentials': {'required': True},
        'datastore_type': {'required': True},
        'is_default': {'readonly': True},
        'account_name': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
        'file_share_name': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'credentials': {'key': 'credentials', 'type': 'DatastoreCredentials'},
        'datastore_type': {'key': 'datastoreType', 'type': 'str'},
        'intellectual_property': {'key': 'intellectualProperty', 'type': 'IntellectualProperty'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
        'account_name': {'key': 'accountName', 'type': 'str'},
        'endpoint': {'key': 'endpoint', 'type': 'str'},
        'file_share_name': {'key': 'fileShareName', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'service_data_access_auth_identity': {'key': 'serviceDataAccessAuthIdentity', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        credentials: "DatastoreCredentials",
        account_name: str,
        file_share_name: str,
        resource_group: Optional[str] = None,
        subscription_id: Optional[str] = None,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        intellectual_property: Optional["IntellectualProperty"] = None,
        endpoint: Optional[str] = None,
        protocol: Optional[str] = None,
        service_data_access_auth_identity: Optional[Union[str, "ServiceDataAccessAuthIdentity"]] = None,
        **kwargs
    ):
        """
        :keyword resource_group: Azure Resource Group name.
        :paramtype resource_group: str
        :keyword subscription_id: Azure Subscription Id.
        :paramtype subscription_id: str
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword credentials: Required. [Required] Account credentials.
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
        :keyword intellectual_property: Intellectual Property details.
        :paramtype intellectual_property:
         ~azure.mgmt.machinelearningservices.models.IntellectualProperty
        :keyword account_name: Required. [Required] Storage account name.
        :paramtype account_name: str
        :keyword endpoint: Azure cloud endpoint for the storage account.
        :paramtype endpoint: str
        :keyword file_share_name: Required. [Required] The name of the Azure file share that the
         datastore points to.
        :paramtype file_share_name: str
        :keyword protocol: Protocol used to communicate with the storage account.
        :paramtype protocol: str
        :keyword service_data_access_auth_identity: Indicates which identity to use to authenticate
         service data access to customer's storage. Possible values include: "None",
         "WorkspaceSystemAssignedIdentity", "WorkspaceUserAssignedIdentity".
        :paramtype service_data_access_auth_identity: str or
         ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
        """
        super(AzureFileDatastore, self).__init__(description=description, properties=properties, tags=tags, credentials=credentials, intellectual_property=intellectual_property, resource_group=resource_group, subscription_id=subscription_id, **kwargs)
        self.resource_group = resource_group
        self.subscription_id = subscription_id
        self.datastore_type = 'AzureFile'  # type: str
        self.account_name = account_name
        self.endpoint = endpoint
        self.file_share_name = file_share_name
        self.protocol = protocol
        self.service_data_access_auth_identity = service_data_access_auth_identity
        self.description = description
        self.properties = properties
        self.tags = tags
        self.credentials = credentials
        self.intellectual_property = intellectual_property
        self.is_default = None


class InferencingServer(msrest.serialization.Model):
    """InferencingServer.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureMLBatchInferencingServer, AzureMLOnlineInferencingServer, CustomInferencingServer, TritonInferencingServer.

    All required parameters must be populated in order to send to Azure.

    :ivar server_type: Required. [Required] Inferencing server type for various targets.Constant
     filled by server. Possible values include: "AzureMLOnline", "AzureMLBatch", "Triton", "Custom".
    :vartype server_type: str or ~azure.mgmt.machinelearningservices.models.InferencingServerType
    """

    _validation = {
        'server_type': {'required': True},
    }

    _attribute_map = {
        'server_type': {'key': 'serverType', 'type': 'str'},
    }

    _subtype_map = {
        'server_type': {'AzureMLBatch': 'AzureMLBatchInferencingServer', 'AzureMLOnline': 'AzureMLOnlineInferencingServer', 'Custom': 'CustomInferencingServer', 'Triton': 'TritonInferencingServer'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(InferencingServer, self).__init__(**kwargs)
        self.server_type = None  # type: Optional[str]


class AzureMLBatchInferencingServer(InferencingServer):
    """Azure ML batch inferencing server configurations.

    All required parameters must be populated in order to send to Azure.

    :ivar server_type: Required. [Required] Inferencing server type for various targets.Constant
     filled by server. Possible values include: "AzureMLOnline", "AzureMLBatch", "Triton", "Custom".
    :vartype server_type: str or ~azure.mgmt.machinelearningservices.models.InferencingServerType
    :ivar code_configuration: Code configuration for AML batch inferencing server.
    :vartype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
    """

    _validation = {
        'server_type': {'required': True},
    }

    _attribute_map = {
        'server_type': {'key': 'serverType', 'type': 'str'},
        'code_configuration': {'key': 'codeConfiguration', 'type': 'CodeConfiguration'},
    }

    def __init__(
        self,
        *,
        code_configuration: Optional["CodeConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword code_configuration: Code configuration for AML batch inferencing server.
        :paramtype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
        """
        super(AzureMLBatchInferencingServer, self).__init__(**kwargs)
        self.server_type = 'AzureMLBatch'  # type: str
        self.code_configuration = code_configuration


class AzureMLOnlineInferencingServer(InferencingServer):
    """Azure ML online inferencing configurations.

    All required parameters must be populated in order to send to Azure.

    :ivar server_type: Required. [Required] Inferencing server type for various targets.Constant
     filled by server. Possible values include: "AzureMLOnline", "AzureMLBatch", "Triton", "Custom".
    :vartype server_type: str or ~azure.mgmt.machinelearningservices.models.InferencingServerType
    :ivar code_configuration: Code configuration for AML inferencing server.
    :vartype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
    """

    _validation = {
        'server_type': {'required': True},
    }

    _attribute_map = {
        'server_type': {'key': 'serverType', 'type': 'str'},
        'code_configuration': {'key': 'codeConfiguration', 'type': 'CodeConfiguration'},
    }

    def __init__(
        self,
        *,
        code_configuration: Optional["CodeConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword code_configuration: Code configuration for AML inferencing server.
        :paramtype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
        """
        super(AzureMLOnlineInferencingServer, self).__init__(**kwargs)
        self.server_type = 'AzureMLOnline'  # type: str
        self.code_configuration = code_configuration


class FineTuningVertical(msrest.serialization.Model):
    """FineTuningVertical.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureOpenAiFineTuning, CustomModelFineTuning.

    All required parameters must be populated in order to send to Azure.

    :ivar model: Required. [Required] Input model for fine tuning.
    :vartype model: ~azure.mgmt.machinelearningservices.models.MLFlowModelJobInput
    :ivar model_provider: Required. [Required] Enum to determine the type of fine tuning.Constant
     filled by server. Possible values include: "AzureOpenAI", "Custom".
    :vartype model_provider: str or ~azure.mgmt.machinelearningservices.models.ModelProvider
    :ivar task_type: Required. [Required] Fine tuning task type. Possible values include:
     "ChatCompletion", "TextCompletion", "TextClassification", "QuestionAnswering",
     "TextSummarization", "TokenClassification", "TextTranslation", "ImageClassification",
     "ImageInstanceSegmentation", "ImageObjectDetection", "VideoMultiObjectTracking".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.FineTuningTaskType
    :ivar training_data: Required. [Required] Training data for fine tuning.
    :vartype training_data: ~azure.mgmt.machinelearningservices.models.JobInput
    :ivar validation_data: Validation data for fine tuning.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.JobInput
    """

    _validation = {
        'model': {'required': True},
        'model_provider': {'required': True},
        'task_type': {'required': True},
        'training_data': {'required': True},
    }

    _attribute_map = {
        'model': {'key': 'model', 'type': 'MLFlowModelJobInput'},
        'model_provider': {'key': 'modelProvider', 'type': 'str'},
        'task_type': {'key': 'taskType', 'type': 'str'},
        'training_data': {'key': 'trainingData', 'type': 'JobInput'},
        'validation_data': {'key': 'validationData', 'type': 'JobInput'},
    }

    _subtype_map = {
        'model_provider': {'AzureOpenAI': 'AzureOpenAiFineTuning', 'Custom': 'CustomModelFineTuning'}
    }

    def __init__(
        self,
        *,
        model: "MLFlowModelJobInput",
        task_type: Union[str, "FineTuningTaskType"],
        training_data: "JobInput",
        validation_data: Optional["JobInput"] = None,
        **kwargs
    ):
        """
        :keyword model: Required. [Required] Input model for fine tuning.
        :paramtype model: ~azure.mgmt.machinelearningservices.models.MLFlowModelJobInput
        :keyword task_type: Required. [Required] Fine tuning task type. Possible values include:
         "ChatCompletion", "TextCompletion", "TextClassification", "QuestionAnswering",
         "TextSummarization", "TokenClassification", "TextTranslation", "ImageClassification",
         "ImageInstanceSegmentation", "ImageObjectDetection", "VideoMultiObjectTracking".
        :paramtype task_type: str or ~azure.mgmt.machinelearningservices.models.FineTuningTaskType
        :keyword training_data: Required. [Required] Training data for fine tuning.
        :paramtype training_data: ~azure.mgmt.machinelearningservices.models.JobInput
        :keyword validation_data: Validation data for fine tuning.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.JobInput
        """
        super(FineTuningVertical, self).__init__(**kwargs)
        self.model = model
        self.model_provider = None  # type: Optional[str]
        self.task_type = task_type
        self.training_data = training_data
        self.validation_data = validation_data


class AzureOpenAiFineTuning(FineTuningVertical):
    """AzureOpenAiFineTuning.

    All required parameters must be populated in order to send to Azure.

    :ivar model: Required. [Required] Input model for fine tuning.
    :vartype model: ~azure.mgmt.machinelearningservices.models.MLFlowModelJobInput
    :ivar model_provider: Required. [Required] Enum to determine the type of fine tuning.Constant
     filled by server. Possible values include: "AzureOpenAI", "Custom".
    :vartype model_provider: str or ~azure.mgmt.machinelearningservices.models.ModelProvider
    :ivar task_type: Required. [Required] Fine tuning task type. Possible values include:
     "ChatCompletion", "TextCompletion", "TextClassification", "QuestionAnswering",
     "TextSummarization", "TokenClassification", "TextTranslation", "ImageClassification",
     "ImageInstanceSegmentation", "ImageObjectDetection", "VideoMultiObjectTracking".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.FineTuningTaskType
    :ivar training_data: Required. [Required] Training data for fine tuning.
    :vartype training_data: ~azure.mgmt.machinelearningservices.models.JobInput
    :ivar validation_data: Validation data for fine tuning.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.JobInput
    :ivar hyper_parameters: HyperParameters for fine tuning Azure Open AI model.
    :vartype hyper_parameters:
     ~azure.mgmt.machinelearningservices.models.AzureOpenAiHyperParameters
    """

    _validation = {
        'model': {'required': True},
        'model_provider': {'required': True},
        'task_type': {'required': True},
        'training_data': {'required': True},
    }

    _attribute_map = {
        'model': {'key': 'model', 'type': 'MLFlowModelJobInput'},
        'model_provider': {'key': 'modelProvider', 'type': 'str'},
        'task_type': {'key': 'taskType', 'type': 'str'},
        'training_data': {'key': 'trainingData', 'type': 'JobInput'},
        'validation_data': {'key': 'validationData', 'type': 'JobInput'},
        'hyper_parameters': {'key': 'hyperParameters', 'type': 'AzureOpenAiHyperParameters'},
    }

    def __init__(
        self,
        *,
        model: "MLFlowModelJobInput",
        task_type: Union[str, "FineTuningTaskType"],
        training_data: "JobInput",
        validation_data: Optional["JobInput"] = None,
        hyper_parameters: Optional["AzureOpenAiHyperParameters"] = None,
        **kwargs
    ):
        """
        :keyword model: Required. [Required] Input model for fine tuning.
        :paramtype model: ~azure.mgmt.machinelearningservices.models.MLFlowModelJobInput
        :keyword task_type: Required. [Required] Fine tuning task type. Possible values include:
         "ChatCompletion", "TextCompletion", "TextClassification", "QuestionAnswering",
         "TextSummarization", "TokenClassification", "TextTranslation", "ImageClassification",
         "ImageInstanceSegmentation", "ImageObjectDetection", "VideoMultiObjectTracking".
        :paramtype task_type: str or ~azure.mgmt.machinelearningservices.models.FineTuningTaskType
        :keyword training_data: Required. [Required] Training data for fine tuning.
        :paramtype training_data: ~azure.mgmt.machinelearningservices.models.JobInput
        :keyword validation_data: Validation data for fine tuning.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.JobInput
        :keyword hyper_parameters: HyperParameters for fine tuning Azure Open AI model.
        :paramtype hyper_parameters:
         ~azure.mgmt.machinelearningservices.models.AzureOpenAiHyperParameters
        """
        super(AzureOpenAiFineTuning, self).__init__(model=model, task_type=task_type, training_data=training_data, validation_data=validation_data, **kwargs)
        self.model_provider = 'AzureOpenAI'  # type: str
        self.hyper_parameters = hyper_parameters


class AzureOpenAiHyperParameters(msrest.serialization.Model):
    """Azure Open AI hyperparameters for fine tuning.

    :ivar batch_size: Number of examples in each batch. A larger batch size means that model
     parameters are updated less frequently, but with lower variance.
    :vartype batch_size: int
    :ivar learning_rate_multiplier: Scaling factor for the learning rate. A smaller learning rate
     may be useful to avoid over fitting.
    :vartype learning_rate_multiplier: float
    :ivar n_epochs: The number of epochs to train the model for. An epoch refers to one full cycle
     through the training dataset.
    :vartype n_epochs: int
    """

    _attribute_map = {
        'batch_size': {'key': 'batchSize', 'type': 'int'},
        'learning_rate_multiplier': {'key': 'learningRateMultiplier', 'type': 'float'},
        'n_epochs': {'key': 'nEpochs', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        batch_size: Optional[int] = None,
        learning_rate_multiplier: Optional[float] = None,
        n_epochs: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword batch_size: Number of examples in each batch. A larger batch size means that model
         parameters are updated less frequently, but with lower variance.
        :paramtype batch_size: int
        :keyword learning_rate_multiplier: Scaling factor for the learning rate. A smaller learning
         rate may be useful to avoid over fitting.
        :paramtype learning_rate_multiplier: float
        :keyword n_epochs: The number of epochs to train the model for. An epoch refers to one full
         cycle through the training dataset.
        :paramtype n_epochs: int
        """
        super(AzureOpenAiHyperParameters, self).__init__(**kwargs)
        self.batch_size = batch_size
        self.learning_rate_multiplier = learning_rate_multiplier
        self.n_epochs = n_epochs


class EarlyTerminationPolicy(msrest.serialization.Model):
    """Early termination policies enable canceling poor-performing runs before they complete.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: BanditPolicy, MedianStoppingPolicy, TruncationSelectionPolicy.

    All required parameters must be populated in order to send to Azure.

    :ivar delay_evaluation: Number of intervals by which to delay the first evaluation.
    :vartype delay_evaluation: int
    :ivar evaluation_interval: Interval (number of runs) between policy evaluations.
    :vartype evaluation_interval: int
    :ivar policy_type: Required. [Required] Name of policy configuration.Constant filled by server.
     Possible values include: "Bandit", "MedianStopping", "TruncationSelection".
    :vartype policy_type: str or
     ~azure.mgmt.machinelearningservices.models.EarlyTerminationPolicyType
    """

    _validation = {
        'policy_type': {'required': True},
    }

    _attribute_map = {
        'delay_evaluation': {'key': 'delayEvaluation', 'type': 'int'},
        'evaluation_interval': {'key': 'evaluationInterval', 'type': 'int'},
        'policy_type': {'key': 'policyType', 'type': 'str'},
    }

    _subtype_map = {
        'policy_type': {'Bandit': 'BanditPolicy', 'MedianStopping': 'MedianStoppingPolicy', 'TruncationSelection': 'TruncationSelectionPolicy'}
    }

    def __init__(
        self,
        *,
        delay_evaluation: Optional[int] = 0,
        evaluation_interval: Optional[int] = 0,
        **kwargs
    ):
        """
        :keyword delay_evaluation: Number of intervals by which to delay the first evaluation.
        :paramtype delay_evaluation: int
        :keyword evaluation_interval: Interval (number of runs) between policy evaluations.
        :paramtype evaluation_interval: int
        """
        super(EarlyTerminationPolicy, self).__init__(**kwargs)
        self.delay_evaluation = delay_evaluation
        self.evaluation_interval = evaluation_interval
        self.policy_type = None  # type: Optional[str]


class BanditPolicy(EarlyTerminationPolicy):
    """Defines an early termination policy based on slack criteria, and a frequency and delay interval for evaluation.

    All required parameters must be populated in order to send to Azure.

    :ivar delay_evaluation: Number of intervals by which to delay the first evaluation.
    :vartype delay_evaluation: int
    :ivar evaluation_interval: Interval (number of runs) between policy evaluations.
    :vartype evaluation_interval: int
    :ivar policy_type: Required. [Required] Name of policy configuration.Constant filled by server.
     Possible values include: "Bandit", "MedianStopping", "TruncationSelection".
    :vartype policy_type: str or
     ~azure.mgmt.machinelearningservices.models.EarlyTerminationPolicyType
    :ivar slack_amount: Absolute distance allowed from the best performing run.
    :vartype slack_amount: float
    :ivar slack_factor: Ratio of the allowed distance from the best performing run.
    :vartype slack_factor: float
    """

    _validation = {
        'policy_type': {'required': True},
    }

    _attribute_map = {
        'delay_evaluation': {'key': 'delayEvaluation', 'type': 'int'},
        'evaluation_interval': {'key': 'evaluationInterval', 'type': 'int'},
        'policy_type': {'key': 'policyType', 'type': 'str'},
        'slack_amount': {'key': 'slackAmount', 'type': 'float'},
        'slack_factor': {'key': 'slackFactor', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        delay_evaluation: Optional[int] = 0,
        evaluation_interval: Optional[int] = 0,
        slack_amount: Optional[float] = 0,
        slack_factor: Optional[float] = 0,
        **kwargs
    ):
        """
        :keyword delay_evaluation: Number of intervals by which to delay the first evaluation.
        :paramtype delay_evaluation: int
        :keyword evaluation_interval: Interval (number of runs) between policy evaluations.
        :paramtype evaluation_interval: int
        :keyword slack_amount: Absolute distance allowed from the best performing run.
        :paramtype slack_amount: float
        :keyword slack_factor: Ratio of the allowed distance from the best performing run.
        :paramtype slack_factor: float
        """
        super(BanditPolicy, self).__init__(delay_evaluation=delay_evaluation, evaluation_interval=evaluation_interval, **kwargs)
        self.policy_type = 'Bandit'  # type: str
        self.slack_amount = slack_amount
        self.slack_factor = slack_factor


class BaseEnvironmentSource(msrest.serialization.Model):
    """BaseEnvironmentSource.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: BaseEnvironmentId.

    All required parameters must be populated in order to send to Azure.

    :ivar base_environment_source_type: Required. [Required] Base environment type.Constant filled
     by server. Possible values include: "EnvironmentAsset".
    :vartype base_environment_source_type: str or
     ~azure.mgmt.machinelearningservices.models.BaseEnvironmentSourceType
    """

    _validation = {
        'base_environment_source_type': {'required': True},
    }

    _attribute_map = {
        'base_environment_source_type': {'key': 'baseEnvironmentSourceType', 'type': 'str'},
    }

    _subtype_map = {
        'base_environment_source_type': {'EnvironmentAsset': 'BaseEnvironmentId'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(BaseEnvironmentSource, self).__init__(**kwargs)
        self.base_environment_source_type = None  # type: Optional[str]


class BaseEnvironmentId(BaseEnvironmentSource):
    """Base environment type.

    All required parameters must be populated in order to send to Azure.

    :ivar base_environment_source_type: Required. [Required] Base environment type.Constant filled
     by server. Possible values include: "EnvironmentAsset".
    :vartype base_environment_source_type: str or
     ~azure.mgmt.machinelearningservices.models.BaseEnvironmentSourceType
    :ivar resource_id: Required. [Required] Resource id accepting ArmId or AzureMlId.
    :vartype resource_id: str
    """

    _validation = {
        'base_environment_source_type': {'required': True},
        'resource_id': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'base_environment_source_type': {'key': 'baseEnvironmentSourceType', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_id: str,
        **kwargs
    ):
        """
        :keyword resource_id: Required. [Required] Resource id accepting ArmId or AzureMlId.
        :paramtype resource_id: str
        """
        super(BaseEnvironmentId, self).__init__(**kwargs)
        self.base_environment_source_type = 'EnvironmentAsset'  # type: str
        self.resource_id = resource_id


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        """
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = tags
        self.location = location


class BatchDeployment(TrackedResource):
    """BatchDeployment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type.
    :vartype kind: str
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.BatchDeploymentProperties
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'BatchDeploymentProperties'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "BatchDeploymentProperties",
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["ManagedServiceIdentity"] = None,
        kind: Optional[str] = None,
        sku: Optional["Sku"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type.
        :paramtype kind: str
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.BatchDeploymentProperties
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        """
        super(BatchDeployment, self).__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.kind = kind
        self.properties = properties
        self.sku = sku


class BatchDeploymentConfiguration(msrest.serialization.Model):
    """Properties relevant to different deployment types.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: BatchPipelineComponentDeploymentConfiguration.

    All required parameters must be populated in order to send to Azure.

    :ivar deployment_configuration_type: Required. [Required] The type of the deployment.Constant
     filled by server. Possible values include: "Model", "PipelineComponent".
    :vartype deployment_configuration_type: str or
     ~azure.mgmt.machinelearningservices.models.BatchDeploymentConfigurationType
    """

    _validation = {
        'deployment_configuration_type': {'required': True},
    }

    _attribute_map = {
        'deployment_configuration_type': {'key': 'deploymentConfigurationType', 'type': 'str'},
    }

    _subtype_map = {
        'deployment_configuration_type': {'PipelineComponent': 'BatchPipelineComponentDeploymentConfiguration'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(BatchDeploymentConfiguration, self).__init__(**kwargs)
        self.deployment_configuration_type = None  # type: Optional[str]


class EndpointDeploymentPropertiesBase(msrest.serialization.Model):
    """Base definition for endpoint deployment.

    :ivar code_configuration: Code configuration for the endpoint deployment.
    :vartype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
    :ivar description: Description of the endpoint deployment.
    :vartype description: str
    :ivar environment_id: ARM resource ID of the environment specification for the endpoint
     deployment.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables configuration for the deployment.
    :vartype environment_variables: dict[str, str]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    """

    _attribute_map = {
        'code_configuration': {'key': 'codeConfiguration', 'type': 'CodeConfiguration'},
        'description': {'key': 'description', 'type': 'str'},
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'environment_variables': {'key': 'environmentVariables', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        code_configuration: Optional["CodeConfiguration"] = None,
        description: Optional[str] = None,
        environment_id: Optional[str] = None,
        environment_variables: Optional[Dict[str, str]] = None,
        properties: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword code_configuration: Code configuration for the endpoint deployment.
        :paramtype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
        :keyword description: Description of the endpoint deployment.
        :paramtype description: str
        :keyword environment_id: ARM resource ID of the environment specification for the endpoint
         deployment.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables configuration for the deployment.
        :paramtype environment_variables: dict[str, str]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        """
        super(EndpointDeploymentPropertiesBase, self).__init__(**kwargs)
        self.code_configuration = code_configuration
        self.description = description
        self.environment_id = environment_id
        self.environment_variables = environment_variables
        self.properties = properties


class BatchDeploymentProperties(EndpointDeploymentPropertiesBase):
    """Batch inference settings per deployment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code_configuration: Code configuration for the endpoint deployment.
    :vartype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
    :ivar description: Description of the endpoint deployment.
    :vartype description: str
    :ivar environment_id: ARM resource ID of the environment specification for the endpoint
     deployment.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables configuration for the deployment.
    :vartype environment_variables: dict[str, str]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar compute: Compute target for batch inference operation.
    :vartype compute: str
    :ivar deployment_configuration: Properties relevant to different deployment types.
    :vartype deployment_configuration:
     ~azure.mgmt.machinelearningservices.models.BatchDeploymentConfiguration
    :ivar error_threshold: Error threshold, if the error count for the entire input goes above this
     value,
     the batch inference will be aborted. Range is [-1, int.MaxValue].
     For FileDataset, this value is the count of file failures.
     For TabularDataset, this value is the count of record failures.
     If set to -1 (the lower bound), all failures during batch inference will be ignored.
    :vartype error_threshold: int
    :ivar logging_level: Logging level for batch inference operation. Possible values include:
     "Info", "Warning", "Debug".
    :vartype logging_level: str or ~azure.mgmt.machinelearningservices.models.BatchLoggingLevel
    :ivar max_concurrency_per_instance: Indicates maximum number of parallelism per instance.
    :vartype max_concurrency_per_instance: int
    :ivar mini_batch_size: Size of the mini-batch passed to each batch invocation.
     For FileDataset, this is the number of files per mini-batch.
     For TabularDataset, this is the size of the records in bytes, per mini-batch.
    :vartype mini_batch_size: long
    :ivar model: Reference to the model asset for the endpoint deployment.
    :vartype model: ~azure.mgmt.machinelearningservices.models.AssetReferenceBase
    :ivar output_action: Indicates how the output will be organized. Possible values include:
     "SummaryOnly", "AppendRow".
    :vartype output_action: str or ~azure.mgmt.machinelearningservices.models.BatchOutputAction
    :ivar output_file_name: Customized output file name for append_row output action.
    :vartype output_file_name: str
    :ivar provisioning_state: Provisioning state for the endpoint deployment. Possible values
     include: "Creating", "Deleting", "Scaling", "Updating", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.DeploymentProvisioningState
    :ivar resources: Indicates compute configuration for the job.
     If not provided, will default to the defaults defined in ResourceConfiguration.
    :vartype resources: ~azure.mgmt.machinelearningservices.models.DeploymentResourceConfiguration
    :ivar retry_settings: Retry Settings for the batch inference operation.
     If not provided, will default to the defaults defined in BatchRetrySettings.
    :vartype retry_settings: ~azure.mgmt.machinelearningservices.models.BatchRetrySettings
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'code_configuration': {'key': 'codeConfiguration', 'type': 'CodeConfiguration'},
        'description': {'key': 'description', 'type': 'str'},
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'environment_variables': {'key': 'environmentVariables', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'compute': {'key': 'compute', 'type': 'str'},
        'deployment_configuration': {'key': 'deploymentConfiguration', 'type': 'BatchDeploymentConfiguration'},
        'error_threshold': {'key': 'errorThreshold', 'type': 'int'},
        'logging_level': {'key': 'loggingLevel', 'type': 'str'},
        'max_concurrency_per_instance': {'key': 'maxConcurrencyPerInstance', 'type': 'int'},
        'mini_batch_size': {'key': 'miniBatchSize', 'type': 'long'},
        'model': {'key': 'model', 'type': 'AssetReferenceBase'},
        'output_action': {'key': 'outputAction', 'type': 'str'},
        'output_file_name': {'key': 'outputFileName', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'resources': {'key': 'resources', 'type': 'DeploymentResourceConfiguration'},
        'retry_settings': {'key': 'retrySettings', 'type': 'BatchRetrySettings'},
    }

    def __init__(
        self,
        *,
        code_configuration: Optional["CodeConfiguration"] = None,
        description: Optional[str] = None,
        environment_id: Optional[str] = None,
        environment_variables: Optional[Dict[str, str]] = None,
        properties: Optional[Dict[str, str]] = None,
        compute: Optional[str] = None,
        deployment_configuration: Optional["BatchDeploymentConfiguration"] = None,
        error_threshold: Optional[int] = -1,
        logging_level: Optional[Union[str, "BatchLoggingLevel"]] = None,
        max_concurrency_per_instance: Optional[int] = 1,
        mini_batch_size: Optional[int] = 10,
        model: Optional["AssetReferenceBase"] = None,
        output_action: Optional[Union[str, "BatchOutputAction"]] = None,
        output_file_name: Optional[str] = "predictions.csv",
        resources: Optional["DeploymentResourceConfiguration"] = None,
        retry_settings: Optional["BatchRetrySettings"] = None,
        **kwargs
    ):
        """
        :keyword code_configuration: Code configuration for the endpoint deployment.
        :paramtype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
        :keyword description: Description of the endpoint deployment.
        :paramtype description: str
        :keyword environment_id: ARM resource ID of the environment specification for the endpoint
         deployment.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables configuration for the deployment.
        :paramtype environment_variables: dict[str, str]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword compute: Compute target for batch inference operation.
        :paramtype compute: str
        :keyword deployment_configuration: Properties relevant to different deployment types.
        :paramtype deployment_configuration:
         ~azure.mgmt.machinelearningservices.models.BatchDeploymentConfiguration
        :keyword error_threshold: Error threshold, if the error count for the entire input goes above
         this value,
         the batch inference will be aborted. Range is [-1, int.MaxValue].
         For FileDataset, this value is the count of file failures.
         For TabularDataset, this value is the count of record failures.
         If set to -1 (the lower bound), all failures during batch inference will be ignored.
        :paramtype error_threshold: int
        :keyword logging_level: Logging level for batch inference operation. Possible values include:
         "Info", "Warning", "Debug".
        :paramtype logging_level: str or ~azure.mgmt.machinelearningservices.models.BatchLoggingLevel
        :keyword max_concurrency_per_instance: Indicates maximum number of parallelism per instance.
        :paramtype max_concurrency_per_instance: int
        :keyword mini_batch_size: Size of the mini-batch passed to each batch invocation.
         For FileDataset, this is the number of files per mini-batch.
         For TabularDataset, this is the size of the records in bytes, per mini-batch.
        :paramtype mini_batch_size: long
        :keyword model: Reference to the model asset for the endpoint deployment.
        :paramtype model: ~azure.mgmt.machinelearningservices.models.AssetReferenceBase
        :keyword output_action: Indicates how the output will be organized. Possible values include:
         "SummaryOnly", "AppendRow".
        :paramtype output_action: str or ~azure.mgmt.machinelearningservices.models.BatchOutputAction
        :keyword output_file_name: Customized output file name for append_row output action.
        :paramtype output_file_name: str
        :keyword resources: Indicates compute configuration for the job.
         If not provided, will default to the defaults defined in ResourceConfiguration.
        :paramtype resources:
         ~azure.mgmt.machinelearningservices.models.DeploymentResourceConfiguration
        :keyword retry_settings: Retry Settings for the batch inference operation.
         If not provided, will default to the defaults defined in BatchRetrySettings.
        :paramtype retry_settings: ~azure.mgmt.machinelearningservices.models.BatchRetrySettings
        """
        super(BatchDeploymentProperties, self).__init__(code_configuration=code_configuration, description=description, environment_id=environment_id, environment_variables=environment_variables, properties=properties, **kwargs)
        self.compute = compute
        self.deployment_configuration = deployment_configuration
        self.error_threshold = error_threshold
        self.logging_level = logging_level
        self.max_concurrency_per_instance = max_concurrency_per_instance
        self.mini_batch_size = mini_batch_size
        self.model = model
        self.output_action = output_action
        self.output_file_name = output_file_name
        self.provisioning_state = None
        self.resources = resources
        self.retry_settings = retry_settings


class BatchDeploymentTrackedResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of BatchDeployment entities.

    :ivar next_link: The link to the next page of BatchDeployment objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type BatchDeployment.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.BatchDeployment]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[BatchDeployment]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["BatchDeployment"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of BatchDeployment objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type BatchDeployment.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.BatchDeployment]
        """
        super(BatchDeploymentTrackedResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class BatchEndpoint(TrackedResource):
    """BatchEndpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type.
    :vartype kind: str
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.BatchEndpointProperties
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'BatchEndpointProperties'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "BatchEndpointProperties",
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["ManagedServiceIdentity"] = None,
        kind: Optional[str] = None,
        sku: Optional["Sku"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type.
        :paramtype kind: str
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.BatchEndpointProperties
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        """
        super(BatchEndpoint, self).__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.kind = kind
        self.properties = properties
        self.sku = sku


class BatchEndpointDefaults(msrest.serialization.Model):
    """Batch endpoint default values.

    :ivar deployment_name: Name of the deployment that will be default for the endpoint.
     This deployment will end up getting 100% traffic when the endpoint scoring URL is invoked.
    :vartype deployment_name: str
    """

    _attribute_map = {
        'deployment_name': {'key': 'deploymentName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        deployment_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword deployment_name: Name of the deployment that will be default for the endpoint.
         This deployment will end up getting 100% traffic when the endpoint scoring URL is invoked.
        :paramtype deployment_name: str
        """
        super(BatchEndpointDefaults, self).__init__(**kwargs)
        self.deployment_name = deployment_name


class EndpointPropertiesBase(msrest.serialization.Model):
    """Inference Endpoint base definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_mode: Required. [Required] Use 'Key' for key based authentication and 'AMLToken' for
     Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
     Possible values include: "AMLToken", "Key", "AADToken".
    :vartype auth_mode: str or ~azure.mgmt.machinelearningservices.models.EndpointAuthMode
    :ivar description: Description of the inference endpoint.
    :vartype description: str
    :ivar keys: EndpointAuthKeys to set initially on an Endpoint.
     This property will always be returned as null. AuthKey values must be retrieved using the
     ListKeys API.
    :vartype keys: ~azure.mgmt.machinelearningservices.models.EndpointAuthKeys
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar scoring_uri: Endpoint URI.
    :vartype scoring_uri: str
    :ivar swagger_uri: Endpoint Swagger URI.
    :vartype swagger_uri: str
    """

    _validation = {
        'auth_mode': {'required': True},
        'scoring_uri': {'readonly': True},
        'swagger_uri': {'readonly': True},
    }

    _attribute_map = {
        'auth_mode': {'key': 'authMode', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'keys': {'key': 'keys', 'type': 'EndpointAuthKeys'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'scoring_uri': {'key': 'scoringUri', 'type': 'str'},
        'swagger_uri': {'key': 'swaggerUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        auth_mode: Union[str, "EndpointAuthMode"],
        description: Optional[str] = None,
        keys: Optional["EndpointAuthKeys"] = None,
        properties: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword auth_mode: Required. [Required] Use 'Key' for key based authentication and 'AMLToken'
         for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken'
         does. Possible values include: "AMLToken", "Key", "AADToken".
        :paramtype auth_mode: str or ~azure.mgmt.machinelearningservices.models.EndpointAuthMode
        :keyword description: Description of the inference endpoint.
        :paramtype description: str
        :keyword keys: EndpointAuthKeys to set initially on an Endpoint.
         This property will always be returned as null. AuthKey values must be retrieved using the
         ListKeys API.
        :paramtype keys: ~azure.mgmt.machinelearningservices.models.EndpointAuthKeys
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        """
        super(EndpointPropertiesBase, self).__init__(**kwargs)
        self.auth_mode = auth_mode
        self.description = description
        self.keys = keys
        self.properties = properties
        self.scoring_uri = None
        self.swagger_uri = None


class BatchEndpointProperties(EndpointPropertiesBase):
    """Batch endpoint configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_mode: Required. [Required] Use 'Key' for key based authentication and 'AMLToken' for
     Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
     Possible values include: "AMLToken", "Key", "AADToken".
    :vartype auth_mode: str or ~azure.mgmt.machinelearningservices.models.EndpointAuthMode
    :ivar description: Description of the inference endpoint.
    :vartype description: str
    :ivar keys: EndpointAuthKeys to set initially on an Endpoint.
     This property will always be returned as null. AuthKey values must be retrieved using the
     ListKeys API.
    :vartype keys: ~azure.mgmt.machinelearningservices.models.EndpointAuthKeys
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar scoring_uri: Endpoint URI.
    :vartype scoring_uri: str
    :ivar swagger_uri: Endpoint Swagger URI.
    :vartype swagger_uri: str
    :ivar defaults: Default values for Batch Endpoint.
    :vartype defaults: ~azure.mgmt.machinelearningservices.models.BatchEndpointDefaults
    :ivar provisioning_state: Provisioning state for the endpoint. Possible values include:
     "Creating", "Deleting", "Succeeded", "Failed", "Updating", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.EndpointProvisioningState
    """

    _validation = {
        'auth_mode': {'required': True},
        'scoring_uri': {'readonly': True},
        'swagger_uri': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'auth_mode': {'key': 'authMode', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'keys': {'key': 'keys', 'type': 'EndpointAuthKeys'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'scoring_uri': {'key': 'scoringUri', 'type': 'str'},
        'swagger_uri': {'key': 'swaggerUri', 'type': 'str'},
        'defaults': {'key': 'defaults', 'type': 'BatchEndpointDefaults'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        auth_mode: Union[str, "EndpointAuthMode"],
        description: Optional[str] = None,
        keys: Optional["EndpointAuthKeys"] = None,
        properties: Optional[Dict[str, str]] = None,
        defaults: Optional["BatchEndpointDefaults"] = None,
        **kwargs
    ):
        """
        :keyword auth_mode: Required. [Required] Use 'Key' for key based authentication and 'AMLToken'
         for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken'
         does. Possible values include: "AMLToken", "Key", "AADToken".
        :paramtype auth_mode: str or ~azure.mgmt.machinelearningservices.models.EndpointAuthMode
        :keyword description: Description of the inference endpoint.
        :paramtype description: str
        :keyword keys: EndpointAuthKeys to set initially on an Endpoint.
         This property will always be returned as null. AuthKey values must be retrieved using the
         ListKeys API.
        :paramtype keys: ~azure.mgmt.machinelearningservices.models.EndpointAuthKeys
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword defaults: Default values for Batch Endpoint.
        :paramtype defaults: ~azure.mgmt.machinelearningservices.models.BatchEndpointDefaults
        """
        super(BatchEndpointProperties, self).__init__(auth_mode=auth_mode, description=description, keys=keys, properties=properties, **kwargs)
        self.defaults = defaults
        self.provisioning_state = None


class BatchEndpointTrackedResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of BatchEndpoint entities.

    :ivar next_link: The link to the next page of BatchEndpoint objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type BatchEndpoint.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.BatchEndpoint]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[BatchEndpoint]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["BatchEndpoint"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of BatchEndpoint objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type BatchEndpoint.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.BatchEndpoint]
        """
        super(BatchEndpointTrackedResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class BatchPipelineComponentDeploymentConfiguration(BatchDeploymentConfiguration):
    """Properties for a Batch Pipeline Component Deployment.

    All required parameters must be populated in order to send to Azure.

    :ivar deployment_configuration_type: Required. [Required] The type of the deployment.Constant
     filled by server. Possible values include: "Model", "PipelineComponent".
    :vartype deployment_configuration_type: str or
     ~azure.mgmt.machinelearningservices.models.BatchDeploymentConfigurationType
    :ivar component_id: The ARM id of the component to be run.
    :vartype component_id: ~azure.mgmt.machinelearningservices.models.IdAssetReference
    :ivar description: The description which will be applied to the job.
    :vartype description: str
    :ivar settings: Run-time settings for the pipeline job.
    :vartype settings: dict[str, str]
    :ivar tags: A set of tags. The tags which will be applied to the job.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'deployment_configuration_type': {'required': True},
    }

    _attribute_map = {
        'deployment_configuration_type': {'key': 'deploymentConfigurationType', 'type': 'str'},
        'component_id': {'key': 'componentId', 'type': 'IdAssetReference'},
        'description': {'key': 'description', 'type': 'str'},
        'settings': {'key': 'settings', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        component_id: Optional["IdAssetReference"] = None,
        description: Optional[str] = None,
        settings: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword component_id: The ARM id of the component to be run.
        :paramtype component_id: ~azure.mgmt.machinelearningservices.models.IdAssetReference
        :keyword description: The description which will be applied to the job.
        :paramtype description: str
        :keyword settings: Run-time settings for the pipeline job.
        :paramtype settings: dict[str, str]
        :keyword tags: A set of tags. The tags which will be applied to the job.
        :paramtype tags: dict[str, str]
        """
        super(BatchPipelineComponentDeploymentConfiguration, self).__init__(**kwargs)
        self.deployment_configuration_type = 'PipelineComponent'  # type: str
        self.component_id = component_id
        self.description = description
        self.settings = settings
        self.tags = tags


class BatchRetrySettings(msrest.serialization.Model):
    """Retry settings for a batch inference operation.

    :ivar max_retries: Maximum retry count for a mini-batch.
    :vartype max_retries: int
    :ivar timeout: Invocation timeout for a mini-batch, in ISO 8601 format.
    :vartype timeout: ~datetime.timedelta
    """

    _attribute_map = {
        'max_retries': {'key': 'maxRetries', 'type': 'int'},
        'timeout': {'key': 'timeout', 'type': 'duration'},
    }

    def __init__(
        self,
        *,
        max_retries: Optional[int] = 3,
        timeout: Optional[datetime.timedelta] = "PT30S",
        **kwargs
    ):
        """
        :keyword max_retries: Maximum retry count for a mini-batch.
        :paramtype max_retries: int
        :keyword timeout: Invocation timeout for a mini-batch, in ISO 8601 format.
        :paramtype timeout: ~datetime.timedelta
        """
        super(BatchRetrySettings, self).__init__(**kwargs)
        self.max_retries = max_retries
        self.timeout = timeout


class SamplingAlgorithm(msrest.serialization.Model):
    """The Sampling Algorithm used to generate hyperparameter values, along with properties to
configure the algorithm.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: BayesianSamplingAlgorithm, GridSamplingAlgorithm, RandomSamplingAlgorithm.

    All required parameters must be populated in order to send to Azure.

    :ivar sampling_algorithm_type: Required. [Required] The algorithm used for generating
     hyperparameter values, along with configuration properties.Constant filled by server. Possible
     values include: "Grid", "Random", "Bayesian".
    :vartype sampling_algorithm_type: str or
     ~azure.mgmt.machinelearningservices.models.SamplingAlgorithmType
    """

    _validation = {
        'sampling_algorithm_type': {'required': True},
    }

    _attribute_map = {
        'sampling_algorithm_type': {'key': 'samplingAlgorithmType', 'type': 'str'},
    }

    _subtype_map = {
        'sampling_algorithm_type': {'Bayesian': 'BayesianSamplingAlgorithm', 'Grid': 'GridSamplingAlgorithm', 'Random': 'RandomSamplingAlgorithm'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SamplingAlgorithm, self).__init__(**kwargs)
        self.sampling_algorithm_type = None  # type: Optional[str]


class BayesianSamplingAlgorithm(SamplingAlgorithm):
    """Defines a Sampling Algorithm that generates values based on previous values.

    All required parameters must be populated in order to send to Azure.

    :ivar sampling_algorithm_type: Required. [Required] The algorithm used for generating
     hyperparameter values, along with configuration properties.Constant filled by server. Possible
     values include: "Grid", "Random", "Bayesian".
    :vartype sampling_algorithm_type: str or
     ~azure.mgmt.machinelearningservices.models.SamplingAlgorithmType
    """

    _validation = {
        'sampling_algorithm_type': {'required': True},
    }

    _attribute_map = {
        'sampling_algorithm_type': {'key': 'samplingAlgorithmType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(BayesianSamplingAlgorithm, self).__init__(**kwargs)
        self.sampling_algorithm_type = 'Bayesian'  # type: str


class BindOptions(msrest.serialization.Model):
    """BindOptions.

    :ivar propagation: Type of Bind Option.
    :vartype propagation: str
    :ivar create_host_path: Indicate whether to create host path.
    :vartype create_host_path: bool
    :ivar selinux: Mention the selinux options.
    :vartype selinux: str
    """

    _attribute_map = {
        'propagation': {'key': 'propagation', 'type': 'str'},
        'create_host_path': {'key': 'createHostPath', 'type': 'bool'},
        'selinux': {'key': 'selinux', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        propagation: Optional[str] = None,
        create_host_path: Optional[bool] = None,
        selinux: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword propagation: Type of Bind Option.
        :paramtype propagation: str
        :keyword create_host_path: Indicate whether to create host path.
        :paramtype create_host_path: bool
        :keyword selinux: Mention the selinux options.
        :paramtype selinux: str
        """
        super(BindOptions, self).__init__(**kwargs)
        self.propagation = propagation
        self.create_host_path = create_host_path
        self.selinux = selinux


class BlobReferenceForConsumptionDto(msrest.serialization.Model):
    """BlobReferenceForConsumptionDto.

    :ivar blob_uri: Blob URI path for client to upload data.
     Example: https://blob.windows.core.net/Container/Path.
    :vartype blob_uri: str
    :ivar credential: Credential info to access storage account.
    :vartype credential: ~azure.mgmt.machinelearningservices.models.PendingUploadCredentialDto
    :ivar storage_account_arm_id: Arm ID of the storage account to use.
    :vartype storage_account_arm_id: str
    """

    _attribute_map = {
        'blob_uri': {'key': 'blobUri', 'type': 'str'},
        'credential': {'key': 'credential', 'type': 'PendingUploadCredentialDto'},
        'storage_account_arm_id': {'key': 'storageAccountArmId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        blob_uri: Optional[str] = None,
        credential: Optional["PendingUploadCredentialDto"] = None,
        storage_account_arm_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword blob_uri: Blob URI path for client to upload data.
         Example: https://blob.windows.core.net/Container/Path.
        :paramtype blob_uri: str
        :keyword credential: Credential info to access storage account.
        :paramtype credential: ~azure.mgmt.machinelearningservices.models.PendingUploadCredentialDto
        :keyword storage_account_arm_id: Arm ID of the storage account to use.
        :paramtype storage_account_arm_id: str
        """
        super(BlobReferenceForConsumptionDto, self).__init__(**kwargs)
        self.blob_uri = blob_uri
        self.credential = credential
        self.storage_account_arm_id = storage_account_arm_id


class BuildContext(msrest.serialization.Model):
    """Configuration settings for Docker build context.

    All required parameters must be populated in order to send to Azure.

    :ivar context_uri: Required. [Required] URI of the Docker build context used to build the
     image. Supports blob URIs on environment creation and may return blob or Git URIs.
    
    
     .. raw:: html
    
        <seealso
     href="https://docs.docker.com/engine/reference/commandline/build/#extended-description" />.
    :vartype context_uri: str
    :ivar dockerfile_path: Path to the Dockerfile in the build context.
    
    
     .. raw:: html
    
        <seealso href="https://docs.docker.com/engine/reference/builder/" />.
    :vartype dockerfile_path: str
    """

    _validation = {
        'context_uri': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'context_uri': {'key': 'contextUri', 'type': 'str'},
        'dockerfile_path': {'key': 'dockerfilePath', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        context_uri: str,
        dockerfile_path: Optional[str] = "Dockerfile",
        **kwargs
    ):
        """
        :keyword context_uri: Required. [Required] URI of the Docker build context used to build the
         image. Supports blob URIs on environment creation and may return blob or Git URIs.
        
        
         .. raw:: html
        
            <seealso
         href="https://docs.docker.com/engine/reference/commandline/build/#extended-description" />.
        :paramtype context_uri: str
        :keyword dockerfile_path: Path to the Dockerfile in the build context.
        
        
         .. raw:: html
        
            <seealso href="https://docs.docker.com/engine/reference/builder/" />.
        :paramtype dockerfile_path: str
        """
        super(BuildContext, self).__init__(**kwargs)
        self.context_uri = context_uri
        self.dockerfile_path = dockerfile_path


class CallRateLimit(msrest.serialization.Model):
    """The call rate limit Cognitive Services account.

    :ivar count: The count value of Call Rate Limit.
    :vartype count: float
    :ivar renewal_period: The renewal period in seconds of Call Rate Limit.
    :vartype renewal_period: float
    :ivar rules:
    :vartype rules: list[~azure.mgmt.machinelearningservices.models.ThrottlingRule]
    """

    _attribute_map = {
        'count': {'key': 'count', 'type': 'float'},
        'renewal_period': {'key': 'renewalPeriod', 'type': 'float'},
        'rules': {'key': 'rules', 'type': '[ThrottlingRule]'},
    }

    def __init__(
        self,
        *,
        count: Optional[float] = None,
        renewal_period: Optional[float] = None,
        rules: Optional[List["ThrottlingRule"]] = None,
        **kwargs
    ):
        """
        :keyword count: The count value of Call Rate Limit.
        :paramtype count: float
        :keyword renewal_period: The renewal period in seconds of Call Rate Limit.
        :paramtype renewal_period: float
        :keyword rules:
        :paramtype rules: list[~azure.mgmt.machinelearningservices.models.ThrottlingRule]
        """
        super(CallRateLimit, self).__init__(**kwargs)
        self.count = count
        self.renewal_period = renewal_period
        self.rules = rules


class CapacityConfig(msrest.serialization.Model):
    """The capacity configuration.

    :ivar minimum: The minimum capacity.
    :vartype minimum: int
    :ivar maximum: The maximum capacity.
    :vartype maximum: int
    :ivar step: The minimal incremental between allowed values for capacity.
    :vartype step: int
    :ivar default: The default capacity.
    :vartype default: int
    :ivar allowed_values: The array of allowed values for capacity.
    :vartype allowed_values: list[int]
    """

    _attribute_map = {
        'minimum': {'key': 'minimum', 'type': 'int'},
        'maximum': {'key': 'maximum', 'type': 'int'},
        'step': {'key': 'step', 'type': 'int'},
        'default': {'key': 'default', 'type': 'int'},
        'allowed_values': {'key': 'allowedValues', 'type': '[int]'},
    }

    def __init__(
        self,
        *,
        minimum: Optional[int] = None,
        maximum: Optional[int] = None,
        step: Optional[int] = None,
        default: Optional[int] = None,
        allowed_values: Optional[List[int]] = None,
        **kwargs
    ):
        """
        :keyword minimum: The minimum capacity.
        :paramtype minimum: int
        :keyword maximum: The maximum capacity.
        :paramtype maximum: int
        :keyword step: The minimal incremental between allowed values for capacity.
        :paramtype step: int
        :keyword default: The default capacity.
        :paramtype default: int
        :keyword allowed_values: The array of allowed values for capacity.
        :paramtype allowed_values: list[int]
        """
        super(CapacityConfig, self).__init__(**kwargs)
        self.minimum = minimum
        self.maximum = maximum
        self.step = step
        self.default = default
        self.allowed_values = allowed_values


class CapacityReservationGroup(TrackedResource):
    """CapacityReservationGroup.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type.
    :vartype kind: str
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties:
     ~azure.mgmt.machinelearningservices.models.CapacityReservationGroupProperties
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'CapacityReservationGroupProperties'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "CapacityReservationGroupProperties",
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["ManagedServiceIdentity"] = None,
        kind: Optional[str] = None,
        sku: Optional["Sku"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type.
        :paramtype kind: str
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties:
         ~azure.mgmt.machinelearningservices.models.CapacityReservationGroupProperties
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        """
        super(CapacityReservationGroup, self).__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.kind = kind
        self.properties = properties
        self.sku = sku


class CapacityReservationGroupProperties(msrest.serialization.Model):
    """CapacityReservationGroupProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar offer: Offer used by this capacity reservation group.
    :vartype offer: ~azure.mgmt.machinelearningservices.models.ServerlessOffer
    :ivar reserved_capacity: Required. [Required] Specifies the amount of capacity to reserve.
    :vartype reserved_capacity: int
    """

    _validation = {
        'reserved_capacity': {'required': True},
    }

    _attribute_map = {
        'offer': {'key': 'offer', 'type': 'ServerlessOffer'},
        'reserved_capacity': {'key': 'reservedCapacity', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        reserved_capacity: int,
        offer: Optional["ServerlessOffer"] = None,
        **kwargs
    ):
        """
        :keyword offer: Offer used by this capacity reservation group.
        :paramtype offer: ~azure.mgmt.machinelearningservices.models.ServerlessOffer
        :keyword reserved_capacity: Required. [Required] Specifies the amount of capacity to reserve.
        :paramtype reserved_capacity: int
        """
        super(CapacityReservationGroupProperties, self).__init__(**kwargs)
        self.offer = offer
        self.reserved_capacity = reserved_capacity


class CapacityReservationGroupTrackedResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of CapacityReservationGroup entities.

    :ivar next_link: The link to the next page of CapacityReservationGroup objects. If null, there
     are no additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type CapacityReservationGroup.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.CapacityReservationGroup]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[CapacityReservationGroup]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["CapacityReservationGroup"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of CapacityReservationGroup objects. If null,
         there are no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type CapacityReservationGroup.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.CapacityReservationGroup]
        """
        super(CapacityReservationGroupTrackedResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class DataDriftMetricThresholdBase(msrest.serialization.Model):
    """DataDriftMetricThresholdBase.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CategoricalDataDriftMetricThreshold, NumericalDataDriftMetricThreshold.

    All required parameters must be populated in order to send to Azure.

    :ivar data_type: Required. [Required] Specifies the data type of the metric threshold.Constant
     filled by server. Possible values include: "Numerical", "Categorical".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.MonitoringFeatureDataType
    :ivar threshold: The threshold value. If null, a default value will be set depending on the
     selected metric.
    :vartype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
    """

    _validation = {
        'data_type': {'required': True},
    }

    _attribute_map = {
        'data_type': {'key': 'dataType', 'type': 'str'},
        'threshold': {'key': 'threshold', 'type': 'MonitoringThreshold'},
    }

    _subtype_map = {
        'data_type': {'Categorical': 'CategoricalDataDriftMetricThreshold', 'Numerical': 'NumericalDataDriftMetricThreshold'}
    }

    def __init__(
        self,
        *,
        threshold: Optional["MonitoringThreshold"] = None,
        **kwargs
    ):
        """
        :keyword threshold: The threshold value. If null, a default value will be set depending on the
         selected metric.
        :paramtype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
        """
        super(DataDriftMetricThresholdBase, self).__init__(**kwargs)
        self.data_type = None  # type: Optional[str]
        self.threshold = threshold


class CategoricalDataDriftMetricThreshold(DataDriftMetricThresholdBase):
    """CategoricalDataDriftMetricThreshold.

    All required parameters must be populated in order to send to Azure.

    :ivar data_type: Required. [Required] Specifies the data type of the metric threshold.Constant
     filled by server. Possible values include: "Numerical", "Categorical".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.MonitoringFeatureDataType
    :ivar threshold: The threshold value. If null, a default value will be set depending on the
     selected metric.
    :vartype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
    :ivar metric: Required. [Required] The categorical data drift metric to calculate. Possible
     values include: "JensenShannonDistance", "PopulationStabilityIndex", "PearsonsChiSquaredTest".
    :vartype metric: str or ~azure.mgmt.machinelearningservices.models.CategoricalDataDriftMetric
    """

    _validation = {
        'data_type': {'required': True},
        'metric': {'required': True},
    }

    _attribute_map = {
        'data_type': {'key': 'dataType', 'type': 'str'},
        'threshold': {'key': 'threshold', 'type': 'MonitoringThreshold'},
        'metric': {'key': 'metric', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        metric: Union[str, "CategoricalDataDriftMetric"],
        threshold: Optional["MonitoringThreshold"] = None,
        **kwargs
    ):
        """
        :keyword threshold: The threshold value. If null, a default value will be set depending on the
         selected metric.
        :paramtype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
        :keyword metric: Required. [Required] The categorical data drift metric to calculate. Possible
         values include: "JensenShannonDistance", "PopulationStabilityIndex", "PearsonsChiSquaredTest".
        :paramtype metric: str or ~azure.mgmt.machinelearningservices.models.CategoricalDataDriftMetric
        """
        super(CategoricalDataDriftMetricThreshold, self).__init__(threshold=threshold, **kwargs)
        self.data_type = 'Categorical'  # type: str
        self.metric = metric


class DataQualityMetricThresholdBase(msrest.serialization.Model):
    """DataQualityMetricThresholdBase.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CategoricalDataQualityMetricThreshold, NumericalDataQualityMetricThreshold.

    All required parameters must be populated in order to send to Azure.

    :ivar data_type: Required. [Required] Specifies the data type of the metric threshold.Constant
     filled by server. Possible values include: "Numerical", "Categorical".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.MonitoringFeatureDataType
    :ivar threshold: The threshold value. If null, a default value will be set depending on the
     selected metric.
    :vartype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
    """

    _validation = {
        'data_type': {'required': True},
    }

    _attribute_map = {
        'data_type': {'key': 'dataType', 'type': 'str'},
        'threshold': {'key': 'threshold', 'type': 'MonitoringThreshold'},
    }

    _subtype_map = {
        'data_type': {'Categorical': 'CategoricalDataQualityMetricThreshold', 'Numerical': 'NumericalDataQualityMetricThreshold'}
    }

    def __init__(
        self,
        *,
        threshold: Optional["MonitoringThreshold"] = None,
        **kwargs
    ):
        """
        :keyword threshold: The threshold value. If null, a default value will be set depending on the
         selected metric.
        :paramtype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
        """
        super(DataQualityMetricThresholdBase, self).__init__(**kwargs)
        self.data_type = None  # type: Optional[str]
        self.threshold = threshold


class CategoricalDataQualityMetricThreshold(DataQualityMetricThresholdBase):
    """CategoricalDataQualityMetricThreshold.

    All required parameters must be populated in order to send to Azure.

    :ivar data_type: Required. [Required] Specifies the data type of the metric threshold.Constant
     filled by server. Possible values include: "Numerical", "Categorical".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.MonitoringFeatureDataType
    :ivar threshold: The threshold value. If null, a default value will be set depending on the
     selected metric.
    :vartype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
    :ivar metric: Required. [Required] The categorical data quality metric to calculate. Possible
     values include: "NullValueRate", "DataTypeErrorRate", "OutOfBoundsRate".
    :vartype metric: str or ~azure.mgmt.machinelearningservices.models.CategoricalDataQualityMetric
    """

    _validation = {
        'data_type': {'required': True},
        'metric': {'required': True},
    }

    _attribute_map = {
        'data_type': {'key': 'dataType', 'type': 'str'},
        'threshold': {'key': 'threshold', 'type': 'MonitoringThreshold'},
        'metric': {'key': 'metric', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        metric: Union[str, "CategoricalDataQualityMetric"],
        threshold: Optional["MonitoringThreshold"] = None,
        **kwargs
    ):
        """
        :keyword threshold: The threshold value. If null, a default value will be set depending on the
         selected metric.
        :paramtype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
        :keyword metric: Required. [Required] The categorical data quality metric to calculate.
         Possible values include: "NullValueRate", "DataTypeErrorRate", "OutOfBoundsRate".
        :paramtype metric: str or
         ~azure.mgmt.machinelearningservices.models.CategoricalDataQualityMetric
        """
        super(CategoricalDataQualityMetricThreshold, self).__init__(threshold=threshold, **kwargs)
        self.data_type = 'Categorical'  # type: str
        self.metric = metric


class PredictionDriftMetricThresholdBase(msrest.serialization.Model):
    """PredictionDriftMetricThresholdBase.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CategoricalPredictionDriftMetricThreshold, NumericalPredictionDriftMetricThreshold.

    All required parameters must be populated in order to send to Azure.

    :ivar data_type: Required. [Required] Specifies the data type of the metric threshold.Constant
     filled by server. Possible values include: "Numerical", "Categorical".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.MonitoringFeatureDataType
    :ivar threshold: The threshold value. If null, a default value will be set depending on the
     selected metric.
    :vartype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
    """

    _validation = {
        'data_type': {'required': True},
    }

    _attribute_map = {
        'data_type': {'key': 'dataType', 'type': 'str'},
        'threshold': {'key': 'threshold', 'type': 'MonitoringThreshold'},
    }

    _subtype_map = {
        'data_type': {'Categorical': 'CategoricalPredictionDriftMetricThreshold', 'Numerical': 'NumericalPredictionDriftMetricThreshold'}
    }

    def __init__(
        self,
        *,
        threshold: Optional["MonitoringThreshold"] = None,
        **kwargs
    ):
        """
        :keyword threshold: The threshold value. If null, a default value will be set depending on the
         selected metric.
        :paramtype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
        """
        super(PredictionDriftMetricThresholdBase, self).__init__(**kwargs)
        self.data_type = None  # type: Optional[str]
        self.threshold = threshold


class CategoricalPredictionDriftMetricThreshold(PredictionDriftMetricThresholdBase):
    """CategoricalPredictionDriftMetricThreshold.

    All required parameters must be populated in order to send to Azure.

    :ivar data_type: Required. [Required] Specifies the data type of the metric threshold.Constant
     filled by server. Possible values include: "Numerical", "Categorical".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.MonitoringFeatureDataType
    :ivar threshold: The threshold value. If null, a default value will be set depending on the
     selected metric.
    :vartype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
    :ivar metric: Required. [Required] The categorical prediction drift metric to calculate.
     Possible values include: "JensenShannonDistance", "PopulationStabilityIndex",
     "PearsonsChiSquaredTest".
    :vartype metric: str or
     ~azure.mgmt.machinelearningservices.models.CategoricalPredictionDriftMetric
    """

    _validation = {
        'data_type': {'required': True},
        'metric': {'required': True},
    }

    _attribute_map = {
        'data_type': {'key': 'dataType', 'type': 'str'},
        'threshold': {'key': 'threshold', 'type': 'MonitoringThreshold'},
        'metric': {'key': 'metric', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        metric: Union[str, "CategoricalPredictionDriftMetric"],
        threshold: Optional["MonitoringThreshold"] = None,
        **kwargs
    ):
        """
        :keyword threshold: The threshold value. If null, a default value will be set depending on the
         selected metric.
        :paramtype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
        :keyword metric: Required. [Required] The categorical prediction drift metric to calculate.
         Possible values include: "JensenShannonDistance", "PopulationStabilityIndex",
         "PearsonsChiSquaredTest".
        :paramtype metric: str or
         ~azure.mgmt.machinelearningservices.models.CategoricalPredictionDriftMetric
        """
        super(CategoricalPredictionDriftMetricThreshold, self).__init__(threshold=threshold, **kwargs)
        self.data_type = 'Categorical'  # type: str
        self.metric = metric


class CertificateDatastoreCredentials(DatastoreCredentials):
    """Certificate datastore credentials configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar credentials_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate",
     "None", "Sas", "ServicePrincipal", "KerberosKeytab", "KerberosPassword".
    :vartype credentials_type: str or ~azure.mgmt.machinelearningservices.models.CredentialsType
    :ivar authority_url: Authority URL used for authentication.
    :vartype authority_url: str
    :ivar client_id: Required. [Required] Service principal client ID.
    :vartype client_id: str
    :ivar resource_url: Resource the service principal has access to.
    :vartype resource_url: str
    :ivar secrets: Required. [Required] Service principal secrets.
    :vartype secrets: ~azure.mgmt.machinelearningservices.models.CertificateDatastoreSecrets
    :ivar tenant_id: Required. [Required] ID of the tenant to which the service principal belongs.
    :vartype tenant_id: str
    :ivar thumbprint: Required. [Required] Thumbprint of the certificate used for authentication.
    :vartype thumbprint: str
    """

    _validation = {
        'credentials_type': {'required': True},
        'client_id': {'required': True},
        'secrets': {'required': True},
        'tenant_id': {'required': True},
        'thumbprint': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'credentials_type': {'key': 'credentialsType', 'type': 'str'},
        'authority_url': {'key': 'authorityUrl', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'resource_url': {'key': 'resourceUrl', 'type': 'str'},
        'secrets': {'key': 'secrets', 'type': 'CertificateDatastoreSecrets'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_id: str,
        secrets: "CertificateDatastoreSecrets",
        tenant_id: str,
        thumbprint: str,
        authority_url: Optional[str] = None,
        resource_url: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword authority_url: Authority URL used for authentication.
        :paramtype authority_url: str
        :keyword client_id: Required. [Required] Service principal client ID.
        :paramtype client_id: str
        :keyword resource_url: Resource the service principal has access to.
        :paramtype resource_url: str
        :keyword secrets: Required. [Required] Service principal secrets.
        :paramtype secrets: ~azure.mgmt.machinelearningservices.models.CertificateDatastoreSecrets
        :keyword tenant_id: Required. [Required] ID of the tenant to which the service principal
         belongs.
        :paramtype tenant_id: str
        :keyword thumbprint: Required. [Required] Thumbprint of the certificate used for
         authentication.
        :paramtype thumbprint: str
        """
        super(CertificateDatastoreCredentials, self).__init__(**kwargs)
        self.credentials_type = 'Certificate'  # type: str
        self.authority_url = authority_url
        self.client_id = client_id
        self.resource_url = resource_url
        self.secrets = secrets
        self.tenant_id = tenant_id
        self.thumbprint = thumbprint


class CertificateDatastoreSecrets(DatastoreSecrets):
    """Datastore certificate secrets.

    All required parameters must be populated in order to send to Azure.

    :ivar secrets_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate", "Sas",
     "ServicePrincipal", "KerberosPassword", "KerberosKeytab".
    :vartype secrets_type: str or ~azure.mgmt.machinelearningservices.models.SecretsType
    :ivar certificate: Service principal certificate.
    :vartype certificate: str
    """

    _validation = {
        'secrets_type': {'required': True},
    }

    _attribute_map = {
        'secrets_type': {'key': 'secretsType', 'type': 'str'},
        'certificate': {'key': 'certificate', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        certificate: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword certificate: Service principal certificate.
        :paramtype certificate: str
        """
        super(CertificateDatastoreSecrets, self).__init__(**kwargs)
        self.secrets_type = 'Certificate'  # type: str
        self.certificate = certificate


class TableVertical(msrest.serialization.Model):
    """Abstract class for AutoML tasks that use table dataset as input - such as Classification/Regression/Forecasting.

    :ivar cv_split_column_names: Columns to use for CVSplit data.
    :vartype cv_split_column_names: list[str]
    :ivar featurization_settings: Featurization inputs needed for AutoML job.
    :vartype featurization_settings:
     ~azure.mgmt.machinelearningservices.models.TableVerticalFeaturizationSettings
    :ivar fixed_parameters: Model/training parameters that will remain constant throughout
     training.
    :vartype fixed_parameters: ~azure.mgmt.machinelearningservices.models.TableFixedParameters
    :ivar limit_settings: Execution constraints for AutoMLJob.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.TableVerticalLimitSettings
    :ivar n_cross_validations: Number of cross validation folds to be applied on training dataset
     when validation dataset is not provided.
    :vartype n_cross_validations: ~azure.mgmt.machinelearningservices.models.NCrossValidations
    :ivar search_space: Search space for sampling different combinations of models and their
     hyperparameters.
    :vartype search_space: list[~azure.mgmt.machinelearningservices.models.TableParameterSubspace]
    :ivar sweep_settings: Settings for model sweeping and hyperparameter tuning.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.TableSweepSettings
    :ivar test_data: Test data input.
    :vartype test_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar test_data_size: The fraction of test dataset that needs to be set aside for validation
     purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype test_data_size: float
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    :ivar weight_column_name: The name of the sample weight column. Automated ML supports a
     weighted column as an input, causing rows in the data to be weighted up or down.
    :vartype weight_column_name: str
    """

    _attribute_map = {
        'cv_split_column_names': {'key': 'cvSplitColumnNames', 'type': '[str]'},
        'featurization_settings': {'key': 'featurizationSettings', 'type': 'TableVerticalFeaturizationSettings'},
        'fixed_parameters': {'key': 'fixedParameters', 'type': 'TableFixedParameters'},
        'limit_settings': {'key': 'limitSettings', 'type': 'TableVerticalLimitSettings'},
        'n_cross_validations': {'key': 'nCrossValidations', 'type': 'NCrossValidations'},
        'search_space': {'key': 'searchSpace', 'type': '[TableParameterSubspace]'},
        'sweep_settings': {'key': 'sweepSettings', 'type': 'TableSweepSettings'},
        'test_data': {'key': 'testData', 'type': 'MLTableJobInput'},
        'test_data_size': {'key': 'testDataSize', 'type': 'float'},
        'validation_data': {'key': 'validationData', 'type': 'MLTableJobInput'},
        'validation_data_size': {'key': 'validationDataSize', 'type': 'float'},
        'weight_column_name': {'key': 'weightColumnName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        cv_split_column_names: Optional[List[str]] = None,
        featurization_settings: Optional["TableVerticalFeaturizationSettings"] = None,
        fixed_parameters: Optional["TableFixedParameters"] = None,
        limit_settings: Optional["TableVerticalLimitSettings"] = None,
        n_cross_validations: Optional["NCrossValidations"] = None,
        search_space: Optional[List["TableParameterSubspace"]] = None,
        sweep_settings: Optional["TableSweepSettings"] = None,
        test_data: Optional["MLTableJobInput"] = None,
        test_data_size: Optional[float] = None,
        validation_data: Optional["MLTableJobInput"] = None,
        validation_data_size: Optional[float] = None,
        weight_column_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword cv_split_column_names: Columns to use for CVSplit data.
        :paramtype cv_split_column_names: list[str]
        :keyword featurization_settings: Featurization inputs needed for AutoML job.
        :paramtype featurization_settings:
         ~azure.mgmt.machinelearningservices.models.TableVerticalFeaturizationSettings
        :keyword fixed_parameters: Model/training parameters that will remain constant throughout
         training.
        :paramtype fixed_parameters: ~azure.mgmt.machinelearningservices.models.TableFixedParameters
        :keyword limit_settings: Execution constraints for AutoMLJob.
        :paramtype limit_settings:
         ~azure.mgmt.machinelearningservices.models.TableVerticalLimitSettings
        :keyword n_cross_validations: Number of cross validation folds to be applied on training
         dataset
         when validation dataset is not provided.
        :paramtype n_cross_validations: ~azure.mgmt.machinelearningservices.models.NCrossValidations
        :keyword search_space: Search space for sampling different combinations of models and their
         hyperparameters.
        :paramtype search_space:
         list[~azure.mgmt.machinelearningservices.models.TableParameterSubspace]
        :keyword sweep_settings: Settings for model sweeping and hyperparameter tuning.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.TableSweepSettings
        :keyword test_data: Test data input.
        :paramtype test_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword test_data_size: The fraction of test dataset that needs to be set aside for validation
         purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype test_data_size: float
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        :keyword weight_column_name: The name of the sample weight column. Automated ML supports a
         weighted column as an input, causing rows in the data to be weighted up or down.
        :paramtype weight_column_name: str
        """
        super(TableVertical, self).__init__(**kwargs)
        self.cv_split_column_names = cv_split_column_names
        self.featurization_settings = featurization_settings
        self.fixed_parameters = fixed_parameters
        self.limit_settings = limit_settings
        self.n_cross_validations = n_cross_validations
        self.search_space = search_space
        self.sweep_settings = sweep_settings
        self.test_data = test_data
        self.test_data_size = test_data_size
        self.validation_data = validation_data
        self.validation_data_size = validation_data_size
        self.weight_column_name = weight_column_name


class Classification(AutoMLVertical, TableVertical):
    """Classification task in AutoML Table vertical.

    All required parameters must be populated in order to send to Azure.

    :ivar cv_split_column_names: Columns to use for CVSplit data.
    :vartype cv_split_column_names: list[str]
    :ivar featurization_settings: Featurization inputs needed for AutoML job.
    :vartype featurization_settings:
     ~azure.mgmt.machinelearningservices.models.TableVerticalFeaturizationSettings
    :ivar fixed_parameters: Model/training parameters that will remain constant throughout
     training.
    :vartype fixed_parameters: ~azure.mgmt.machinelearningservices.models.TableFixedParameters
    :ivar limit_settings: Execution constraints for AutoMLJob.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.TableVerticalLimitSettings
    :ivar n_cross_validations: Number of cross validation folds to be applied on training dataset
     when validation dataset is not provided.
    :vartype n_cross_validations: ~azure.mgmt.machinelearningservices.models.NCrossValidations
    :ivar search_space: Search space for sampling different combinations of models and their
     hyperparameters.
    :vartype search_space: list[~azure.mgmt.machinelearningservices.models.TableParameterSubspace]
    :ivar sweep_settings: Settings for model sweeping and hyperparameter tuning.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.TableSweepSettings
    :ivar test_data: Test data input.
    :vartype test_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar test_data_size: The fraction of test dataset that needs to be set aside for validation
     purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype test_data_size: float
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    :ivar weight_column_name: The name of the sample weight column. Automated ML supports a
     weighted column as an input, causing rows in the data to be weighted up or down.
    :vartype weight_column_name: str
    :ivar log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
     "Info", "Warning", "Error", "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar target_column_name: Target column name: This is prediction values column.
     Also known as label column name in context of classification tasks.
    :vartype target_column_name: str
    :ivar task_type: Required. [Required] Task type for AutoMLJob.Constant filled by server.
     Possible values include: "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    :ivar training_data: Required. [Required] Training data input.
    :vartype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar positive_label: Positive label for binary metrics calculation.
    :vartype positive_label: str
    :ivar primary_metric: Primary metric for the task. Possible values include: "AUCWeighted",
     "Accuracy", "NormMacroRecall", "AveragePrecisionScoreWeighted", "PrecisionScoreWeighted".
    :vartype primary_metric: str or
     ~azure.mgmt.machinelearningservices.models.ClassificationPrimaryMetrics
    :ivar training_settings: Inputs for training phase for an AutoML Job.
    :vartype training_settings:
     ~azure.mgmt.machinelearningservices.models.ClassificationTrainingSettings
    """

    _validation = {
        'task_type': {'required': True},
        'training_data': {'required': True},
    }

    _attribute_map = {
        'cv_split_column_names': {'key': 'cvSplitColumnNames', 'type': '[str]'},
        'featurization_settings': {'key': 'featurizationSettings', 'type': 'TableVerticalFeaturizationSettings'},
        'fixed_parameters': {'key': 'fixedParameters', 'type': 'TableFixedParameters'},
        'limit_settings': {'key': 'limitSettings', 'type': 'TableVerticalLimitSettings'},
        'n_cross_validations': {'key': 'nCrossValidations', 'type': 'NCrossValidations'},
        'search_space': {'key': 'searchSpace', 'type': '[TableParameterSubspace]'},
        'sweep_settings': {'key': 'sweepSettings', 'type': 'TableSweepSettings'},
        'test_data': {'key': 'testData', 'type': 'MLTableJobInput'},
        'test_data_size': {'key': 'testDataSize', 'type': 'float'},
        'validation_data': {'key': 'validationData', 'type': 'MLTableJobInput'},
        'validation_data_size': {'key': 'validationDataSize', 'type': 'float'},
        'weight_column_name': {'key': 'weightColumnName', 'type': 'str'},
        'log_verbosity': {'key': 'logVerbosity', 'type': 'str'},
        'target_column_name': {'key': 'targetColumnName', 'type': 'str'},
        'task_type': {'key': 'taskType', 'type': 'str'},
        'training_data': {'key': 'trainingData', 'type': 'MLTableJobInput'},
        'positive_label': {'key': 'positiveLabel', 'type': 'str'},
        'primary_metric': {'key': 'primaryMetric', 'type': 'str'},
        'training_settings': {'key': 'trainingSettings', 'type': 'ClassificationTrainingSettings'},
    }

    def __init__(
        self,
        *,
        training_data: "MLTableJobInput",
        cv_split_column_names: Optional[List[str]] = None,
        featurization_settings: Optional["TableVerticalFeaturizationSettings"] = None,
        fixed_parameters: Optional["TableFixedParameters"] = None,
        limit_settings: Optional["TableVerticalLimitSettings"] = None,
        n_cross_validations: Optional["NCrossValidations"] = None,
        search_space: Optional[List["TableParameterSubspace"]] = None,
        sweep_settings: Optional["TableSweepSettings"] = None,
        test_data: Optional["MLTableJobInput"] = None,
        test_data_size: Optional[float] = None,
        validation_data: Optional["MLTableJobInput"] = None,
        validation_data_size: Optional[float] = None,
        weight_column_name: Optional[str] = None,
        log_verbosity: Optional[Union[str, "LogVerbosity"]] = None,
        target_column_name: Optional[str] = None,
        positive_label: Optional[str] = None,
        primary_metric: Optional[Union[str, "ClassificationPrimaryMetrics"]] = None,
        training_settings: Optional["ClassificationTrainingSettings"] = None,
        **kwargs
    ):
        """
        :keyword cv_split_column_names: Columns to use for CVSplit data.
        :paramtype cv_split_column_names: list[str]
        :keyword featurization_settings: Featurization inputs needed for AutoML job.
        :paramtype featurization_settings:
         ~azure.mgmt.machinelearningservices.models.TableVerticalFeaturizationSettings
        :keyword fixed_parameters: Model/training parameters that will remain constant throughout
         training.
        :paramtype fixed_parameters: ~azure.mgmt.machinelearningservices.models.TableFixedParameters
        :keyword limit_settings: Execution constraints for AutoMLJob.
        :paramtype limit_settings:
         ~azure.mgmt.machinelearningservices.models.TableVerticalLimitSettings
        :keyword n_cross_validations: Number of cross validation folds to be applied on training
         dataset
         when validation dataset is not provided.
        :paramtype n_cross_validations: ~azure.mgmt.machinelearningservices.models.NCrossValidations
        :keyword search_space: Search space for sampling different combinations of models and their
         hyperparameters.
        :paramtype search_space:
         list[~azure.mgmt.machinelearningservices.models.TableParameterSubspace]
        :keyword sweep_settings: Settings for model sweeping and hyperparameter tuning.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.TableSweepSettings
        :keyword test_data: Test data input.
        :paramtype test_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword test_data_size: The fraction of test dataset that needs to be set aside for validation
         purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype test_data_size: float
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        :keyword weight_column_name: The name of the sample weight column. Automated ML supports a
         weighted column as an input, causing rows in the data to be weighted up or down.
        :paramtype weight_column_name: str
        :keyword log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
         "Info", "Warning", "Error", "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        :keyword target_column_name: Target column name: This is prediction values column.
         Also known as label column name in context of classification tasks.
        :paramtype target_column_name: str
        :keyword training_data: Required. [Required] Training data input.
        :paramtype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword positive_label: Positive label for binary metrics calculation.
        :paramtype positive_label: str
        :keyword primary_metric: Primary metric for the task. Possible values include: "AUCWeighted",
         "Accuracy", "NormMacroRecall", "AveragePrecisionScoreWeighted", "PrecisionScoreWeighted".
        :paramtype primary_metric: str or
         ~azure.mgmt.machinelearningservices.models.ClassificationPrimaryMetrics
        :keyword training_settings: Inputs for training phase for an AutoML Job.
        :paramtype training_settings:
         ~azure.mgmt.machinelearningservices.models.ClassificationTrainingSettings
        """
        super(Classification, self).__init__(log_verbosity=log_verbosity, target_column_name=target_column_name, training_data=training_data, cv_split_column_names=cv_split_column_names, featurization_settings=featurization_settings, fixed_parameters=fixed_parameters, limit_settings=limit_settings, n_cross_validations=n_cross_validations, search_space=search_space, sweep_settings=sweep_settings, test_data=test_data, test_data_size=test_data_size, validation_data=validation_data, validation_data_size=validation_data_size, weight_column_name=weight_column_name, **kwargs)
        self.cv_split_column_names = cv_split_column_names
        self.featurization_settings = featurization_settings
        self.fixed_parameters = fixed_parameters
        self.limit_settings = limit_settings
        self.n_cross_validations = n_cross_validations
        self.search_space = search_space
        self.sweep_settings = sweep_settings
        self.test_data = test_data
        self.test_data_size = test_data_size
        self.validation_data = validation_data
        self.validation_data_size = validation_data_size
        self.weight_column_name = weight_column_name
        self.task_type = 'Classification'  # type: str
        self.positive_label = positive_label
        self.primary_metric = primary_metric
        self.training_settings = training_settings
        self.log_verbosity = log_verbosity
        self.target_column_name = target_column_name
        self.training_data = training_data


class ModelPerformanceMetricThresholdBase(msrest.serialization.Model):
    """ModelPerformanceMetricThresholdBase.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ClassificationModelPerformanceMetricThreshold, RegressionModelPerformanceMetricThreshold.

    All required parameters must be populated in order to send to Azure.

    :ivar model_type: Required. [Required] Specifies the data type of the metric threshold.Constant
     filled by server. Possible values include: "Classification", "Regression".
    :vartype model_type: str or ~azure.mgmt.machinelearningservices.models.MonitoringModelType
    :ivar threshold: The threshold value. If null, a default value will be set depending on the
     selected metric.
    :vartype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
    """

    _validation = {
        'model_type': {'required': True},
    }

    _attribute_map = {
        'model_type': {'key': 'modelType', 'type': 'str'},
        'threshold': {'key': 'threshold', 'type': 'MonitoringThreshold'},
    }

    _subtype_map = {
        'model_type': {'Classification': 'ClassificationModelPerformanceMetricThreshold', 'Regression': 'RegressionModelPerformanceMetricThreshold'}
    }

    def __init__(
        self,
        *,
        threshold: Optional["MonitoringThreshold"] = None,
        **kwargs
    ):
        """
        :keyword threshold: The threshold value. If null, a default value will be set depending on the
         selected metric.
        :paramtype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
        """
        super(ModelPerformanceMetricThresholdBase, self).__init__(**kwargs)
        self.model_type = None  # type: Optional[str]
        self.threshold = threshold


class ClassificationModelPerformanceMetricThreshold(ModelPerformanceMetricThresholdBase):
    """ClassificationModelPerformanceMetricThreshold.

    All required parameters must be populated in order to send to Azure.

    :ivar model_type: Required. [Required] Specifies the data type of the metric threshold.Constant
     filled by server. Possible values include: "Classification", "Regression".
    :vartype model_type: str or ~azure.mgmt.machinelearningservices.models.MonitoringModelType
    :ivar threshold: The threshold value. If null, a default value will be set depending on the
     selected metric.
    :vartype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
    :ivar metric: Required. [Required] The classification model performance to calculate. Possible
     values include: "Accuracy", "Precision", "Recall".
    :vartype metric: str or
     ~azure.mgmt.machinelearningservices.models.ClassificationModelPerformanceMetric
    """

    _validation = {
        'model_type': {'required': True},
        'metric': {'required': True},
    }

    _attribute_map = {
        'model_type': {'key': 'modelType', 'type': 'str'},
        'threshold': {'key': 'threshold', 'type': 'MonitoringThreshold'},
        'metric': {'key': 'metric', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        metric: Union[str, "ClassificationModelPerformanceMetric"],
        threshold: Optional["MonitoringThreshold"] = None,
        **kwargs
    ):
        """
        :keyword threshold: The threshold value. If null, a default value will be set depending on the
         selected metric.
        :paramtype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
        :keyword metric: Required. [Required] The classification model performance to calculate.
         Possible values include: "Accuracy", "Precision", "Recall".
        :paramtype metric: str or
         ~azure.mgmt.machinelearningservices.models.ClassificationModelPerformanceMetric
        """
        super(ClassificationModelPerformanceMetricThreshold, self).__init__(threshold=threshold, **kwargs)
        self.model_type = 'Classification'  # type: str
        self.metric = metric


class TrainingSettings(msrest.serialization.Model):
    """Training related configuration.

    :ivar enable_dnn_training: Enable recommendation of DNN models.
    :vartype enable_dnn_training: bool
    :ivar enable_model_explainability: Flag to turn on explainability on best model.
    :vartype enable_model_explainability: bool
    :ivar enable_onnx_compatible_models: Flag for enabling onnx compatible models.
    :vartype enable_onnx_compatible_models: bool
    :ivar enable_stack_ensemble: Enable stack ensemble run.
    :vartype enable_stack_ensemble: bool
    :ivar enable_vote_ensemble: Enable voting ensemble run.
    :vartype enable_vote_ensemble: bool
    :ivar ensemble_model_download_timeout: During VotingEnsemble and StackEnsemble model
     generation, multiple fitted models from the previous child runs are downloaded.
     Configure this parameter with a higher value than 300 secs, if more time is needed.
    :vartype ensemble_model_download_timeout: ~datetime.timedelta
    :ivar stack_ensemble_settings: Stack ensemble settings for stack ensemble run.
    :vartype stack_ensemble_settings:
     ~azure.mgmt.machinelearningservices.models.StackEnsembleSettings
    :ivar training_mode: TrainingMode mode - Setting to 'auto' is same as setting it to
     'non-distributed' for now, however in the future may result in mixed mode or heuristics based
     mode selection. Default is 'auto'.
     If 'Distributed' then only distributed featurization is used and distributed algorithms are
     chosen.
     If 'NonDistributed' then only non distributed algorithms are chosen. Possible values include:
     "Auto", "Distributed", "NonDistributed".
    :vartype training_mode: str or ~azure.mgmt.machinelearningservices.models.TrainingMode
    """

    _attribute_map = {
        'enable_dnn_training': {'key': 'enableDnnTraining', 'type': 'bool'},
        'enable_model_explainability': {'key': 'enableModelExplainability', 'type': 'bool'},
        'enable_onnx_compatible_models': {'key': 'enableOnnxCompatibleModels', 'type': 'bool'},
        'enable_stack_ensemble': {'key': 'enableStackEnsemble', 'type': 'bool'},
        'enable_vote_ensemble': {'key': 'enableVoteEnsemble', 'type': 'bool'},
        'ensemble_model_download_timeout': {'key': 'ensembleModelDownloadTimeout', 'type': 'duration'},
        'stack_ensemble_settings': {'key': 'stackEnsembleSettings', 'type': 'StackEnsembleSettings'},
        'training_mode': {'key': 'trainingMode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        enable_dnn_training: Optional[bool] = False,
        enable_model_explainability: Optional[bool] = True,
        enable_onnx_compatible_models: Optional[bool] = False,
        enable_stack_ensemble: Optional[bool] = True,
        enable_vote_ensemble: Optional[bool] = True,
        ensemble_model_download_timeout: Optional[datetime.timedelta] = "PT5M",
        stack_ensemble_settings: Optional["StackEnsembleSettings"] = None,
        training_mode: Optional[Union[str, "TrainingMode"]] = None,
        **kwargs
    ):
        """
        :keyword enable_dnn_training: Enable recommendation of DNN models.
        :paramtype enable_dnn_training: bool
        :keyword enable_model_explainability: Flag to turn on explainability on best model.
        :paramtype enable_model_explainability: bool
        :keyword enable_onnx_compatible_models: Flag for enabling onnx compatible models.
        :paramtype enable_onnx_compatible_models: bool
        :keyword enable_stack_ensemble: Enable stack ensemble run.
        :paramtype enable_stack_ensemble: bool
        :keyword enable_vote_ensemble: Enable voting ensemble run.
        :paramtype enable_vote_ensemble: bool
        :keyword ensemble_model_download_timeout: During VotingEnsemble and StackEnsemble model
         generation, multiple fitted models from the previous child runs are downloaded.
         Configure this parameter with a higher value than 300 secs, if more time is needed.
        :paramtype ensemble_model_download_timeout: ~datetime.timedelta
        :keyword stack_ensemble_settings: Stack ensemble settings for stack ensemble run.
        :paramtype stack_ensemble_settings:
         ~azure.mgmt.machinelearningservices.models.StackEnsembleSettings
        :keyword training_mode: TrainingMode mode - Setting to 'auto' is same as setting it to
         'non-distributed' for now, however in the future may result in mixed mode or heuristics based
         mode selection. Default is 'auto'.
         If 'Distributed' then only distributed featurization is used and distributed algorithms are
         chosen.
         If 'NonDistributed' then only non distributed algorithms are chosen. Possible values include:
         "Auto", "Distributed", "NonDistributed".
        :paramtype training_mode: str or ~azure.mgmt.machinelearningservices.models.TrainingMode
        """
        super(TrainingSettings, self).__init__(**kwargs)
        self.enable_dnn_training = enable_dnn_training
        self.enable_model_explainability = enable_model_explainability
        self.enable_onnx_compatible_models = enable_onnx_compatible_models
        self.enable_stack_ensemble = enable_stack_ensemble
        self.enable_vote_ensemble = enable_vote_ensemble
        self.ensemble_model_download_timeout = ensemble_model_download_timeout
        self.stack_ensemble_settings = stack_ensemble_settings
        self.training_mode = training_mode


class ClassificationTrainingSettings(TrainingSettings):
    """Classification Training related configuration.

    :ivar enable_dnn_training: Enable recommendation of DNN models.
    :vartype enable_dnn_training: bool
    :ivar enable_model_explainability: Flag to turn on explainability on best model.
    :vartype enable_model_explainability: bool
    :ivar enable_onnx_compatible_models: Flag for enabling onnx compatible models.
    :vartype enable_onnx_compatible_models: bool
    :ivar enable_stack_ensemble: Enable stack ensemble run.
    :vartype enable_stack_ensemble: bool
    :ivar enable_vote_ensemble: Enable voting ensemble run.
    :vartype enable_vote_ensemble: bool
    :ivar ensemble_model_download_timeout: During VotingEnsemble and StackEnsemble model
     generation, multiple fitted models from the previous child runs are downloaded.
     Configure this parameter with a higher value than 300 secs, if more time is needed.
    :vartype ensemble_model_download_timeout: ~datetime.timedelta
    :ivar stack_ensemble_settings: Stack ensemble settings for stack ensemble run.
    :vartype stack_ensemble_settings:
     ~azure.mgmt.machinelearningservices.models.StackEnsembleSettings
    :ivar training_mode: TrainingMode mode - Setting to 'auto' is same as setting it to
     'non-distributed' for now, however in the future may result in mixed mode or heuristics based
     mode selection. Default is 'auto'.
     If 'Distributed' then only distributed featurization is used and distributed algorithms are
     chosen.
     If 'NonDistributed' then only non distributed algorithms are chosen. Possible values include:
     "Auto", "Distributed", "NonDistributed".
    :vartype training_mode: str or ~azure.mgmt.machinelearningservices.models.TrainingMode
    :ivar allowed_training_algorithms: Allowed models for classification task.
    :vartype allowed_training_algorithms: list[str or
     ~azure.mgmt.machinelearningservices.models.ClassificationModels]
    :ivar blocked_training_algorithms: Blocked models for classification task.
    :vartype blocked_training_algorithms: list[str or
     ~azure.mgmt.machinelearningservices.models.ClassificationModels]
    """

    _attribute_map = {
        'enable_dnn_training': {'key': 'enableDnnTraining', 'type': 'bool'},
        'enable_model_explainability': {'key': 'enableModelExplainability', 'type': 'bool'},
        'enable_onnx_compatible_models': {'key': 'enableOnnxCompatibleModels', 'type': 'bool'},
        'enable_stack_ensemble': {'key': 'enableStackEnsemble', 'type': 'bool'},
        'enable_vote_ensemble': {'key': 'enableVoteEnsemble', 'type': 'bool'},
        'ensemble_model_download_timeout': {'key': 'ensembleModelDownloadTimeout', 'type': 'duration'},
        'stack_ensemble_settings': {'key': 'stackEnsembleSettings', 'type': 'StackEnsembleSettings'},
        'training_mode': {'key': 'trainingMode', 'type': 'str'},
        'allowed_training_algorithms': {'key': 'allowedTrainingAlgorithms', 'type': '[str]'},
        'blocked_training_algorithms': {'key': 'blockedTrainingAlgorithms', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        enable_dnn_training: Optional[bool] = False,
        enable_model_explainability: Optional[bool] = True,
        enable_onnx_compatible_models: Optional[bool] = False,
        enable_stack_ensemble: Optional[bool] = True,
        enable_vote_ensemble: Optional[bool] = True,
        ensemble_model_download_timeout: Optional[datetime.timedelta] = "PT5M",
        stack_ensemble_settings: Optional["StackEnsembleSettings"] = None,
        training_mode: Optional[Union[str, "TrainingMode"]] = None,
        allowed_training_algorithms: Optional[List[Union[str, "ClassificationModels"]]] = None,
        blocked_training_algorithms: Optional[List[Union[str, "ClassificationModels"]]] = None,
        **kwargs
    ):
        """
        :keyword enable_dnn_training: Enable recommendation of DNN models.
        :paramtype enable_dnn_training: bool
        :keyword enable_model_explainability: Flag to turn on explainability on best model.
        :paramtype enable_model_explainability: bool
        :keyword enable_onnx_compatible_models: Flag for enabling onnx compatible models.
        :paramtype enable_onnx_compatible_models: bool
        :keyword enable_stack_ensemble: Enable stack ensemble run.
        :paramtype enable_stack_ensemble: bool
        :keyword enable_vote_ensemble: Enable voting ensemble run.
        :paramtype enable_vote_ensemble: bool
        :keyword ensemble_model_download_timeout: During VotingEnsemble and StackEnsemble model
         generation, multiple fitted models from the previous child runs are downloaded.
         Configure this parameter with a higher value than 300 secs, if more time is needed.
        :paramtype ensemble_model_download_timeout: ~datetime.timedelta
        :keyword stack_ensemble_settings: Stack ensemble settings for stack ensemble run.
        :paramtype stack_ensemble_settings:
         ~azure.mgmt.machinelearningservices.models.StackEnsembleSettings
        :keyword training_mode: TrainingMode mode - Setting to 'auto' is same as setting it to
         'non-distributed' for now, however in the future may result in mixed mode or heuristics based
         mode selection. Default is 'auto'.
         If 'Distributed' then only distributed featurization is used and distributed algorithms are
         chosen.
         If 'NonDistributed' then only non distributed algorithms are chosen. Possible values include:
         "Auto", "Distributed", "NonDistributed".
        :paramtype training_mode: str or ~azure.mgmt.machinelearningservices.models.TrainingMode
        :keyword allowed_training_algorithms: Allowed models for classification task.
        :paramtype allowed_training_algorithms: list[str or
         ~azure.mgmt.machinelearningservices.models.ClassificationModels]
        :keyword blocked_training_algorithms: Blocked models for classification task.
        :paramtype blocked_training_algorithms: list[str or
         ~azure.mgmt.machinelearningservices.models.ClassificationModels]
        """
        super(ClassificationTrainingSettings, self).__init__(enable_dnn_training=enable_dnn_training, enable_model_explainability=enable_model_explainability, enable_onnx_compatible_models=enable_onnx_compatible_models, enable_stack_ensemble=enable_stack_ensemble, enable_vote_ensemble=enable_vote_ensemble, ensemble_model_download_timeout=ensemble_model_download_timeout, stack_ensemble_settings=stack_ensemble_settings, training_mode=training_mode, **kwargs)
        self.allowed_training_algorithms = allowed_training_algorithms
        self.blocked_training_algorithms = blocked_training_algorithms


class ClusterUpdateParameters(msrest.serialization.Model):
    """AmlCompute update parameters.

    :ivar properties: Properties of ClusterUpdate.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.ScaleSettingsInformation
    """

    _attribute_map = {
        'properties': {'key': 'properties.properties', 'type': 'ScaleSettingsInformation'},
    }

    def __init__(
        self,
        *,
        properties: Optional["ScaleSettingsInformation"] = None,
        **kwargs
    ):
        """
        :keyword properties: Properties of ClusterUpdate.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.ScaleSettingsInformation
        """
        super(ClusterUpdateParameters, self).__init__(**kwargs)
        self.properties = properties


class ExportSummary(msrest.serialization.Model):
    """ExportSummary.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CsvExportSummary, CocoExportSummary, DatasetExportSummary.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar end_date_time: The time when the export was completed.
    :vartype end_date_time: ~datetime.datetime
    :ivar exported_row_count: The total number of labeled datapoints exported.
    :vartype exported_row_count: long
    :ivar format: Required. [Required] The format of exported labels, also as the
     discriminator.Constant filled by server. Possible values include: "Dataset", "Coco", "CSV".
    :vartype format: str or ~azure.mgmt.machinelearningservices.models.ExportFormatType
    :ivar labeling_job_id: Name and identifier of the job containing exported labels.
    :vartype labeling_job_id: str
    :ivar start_date_time: The time when the export was requested.
    :vartype start_date_time: ~datetime.datetime
    """

    _validation = {
        'end_date_time': {'readonly': True},
        'exported_row_count': {'readonly': True},
        'format': {'required': True},
        'labeling_job_id': {'readonly': True},
        'start_date_time': {'readonly': True},
    }

    _attribute_map = {
        'end_date_time': {'key': 'endDateTime', 'type': 'iso-8601'},
        'exported_row_count': {'key': 'exportedRowCount', 'type': 'long'},
        'format': {'key': 'format', 'type': 'str'},
        'labeling_job_id': {'key': 'labelingJobId', 'type': 'str'},
        'start_date_time': {'key': 'startDateTime', 'type': 'iso-8601'},
    }

    _subtype_map = {
        'format': {'CSV': 'CsvExportSummary', 'Coco': 'CocoExportSummary', 'Dataset': 'DatasetExportSummary'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ExportSummary, self).__init__(**kwargs)
        self.end_date_time = None
        self.exported_row_count = None
        self.format = None  # type: Optional[str]
        self.labeling_job_id = None
        self.start_date_time = None


class CocoExportSummary(ExportSummary):
    """CocoExportSummary.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar end_date_time: The time when the export was completed.
    :vartype end_date_time: ~datetime.datetime
    :ivar exported_row_count: The total number of labeled datapoints exported.
    :vartype exported_row_count: long
    :ivar format: Required. [Required] The format of exported labels, also as the
     discriminator.Constant filled by server. Possible values include: "Dataset", "Coco", "CSV".
    :vartype format: str or ~azure.mgmt.machinelearningservices.models.ExportFormatType
    :ivar labeling_job_id: Name and identifier of the job containing exported labels.
    :vartype labeling_job_id: str
    :ivar start_date_time: The time when the export was requested.
    :vartype start_date_time: ~datetime.datetime
    :ivar container_name: The container name to which the labels will be exported.
    :vartype container_name: str
    :ivar snapshot_path: The output path where the labels will be exported.
    :vartype snapshot_path: str
    """

    _validation = {
        'end_date_time': {'readonly': True},
        'exported_row_count': {'readonly': True},
        'format': {'required': True},
        'labeling_job_id': {'readonly': True},
        'start_date_time': {'readonly': True},
        'container_name': {'readonly': True},
        'snapshot_path': {'readonly': True},
    }

    _attribute_map = {
        'end_date_time': {'key': 'endDateTime', 'type': 'iso-8601'},
        'exported_row_count': {'key': 'exportedRowCount', 'type': 'long'},
        'format': {'key': 'format', 'type': 'str'},
        'labeling_job_id': {'key': 'labelingJobId', 'type': 'str'},
        'start_date_time': {'key': 'startDateTime', 'type': 'iso-8601'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'snapshot_path': {'key': 'snapshotPath', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(CocoExportSummary, self).__init__(**kwargs)
        self.format = 'Coco'  # type: str
        self.container_name = None
        self.snapshot_path = None


class CodeConfiguration(msrest.serialization.Model):
    """Configuration for a scoring code asset.

    All required parameters must be populated in order to send to Azure.

    :ivar code_id: ARM resource ID of the code asset.
    :vartype code_id: str
    :ivar scoring_script: Required. [Required] The script to execute on startup. eg. "score.py".
    :vartype scoring_script: str
    """

    _validation = {
        'scoring_script': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'code_id': {'key': 'codeId', 'type': 'str'},
        'scoring_script': {'key': 'scoringScript', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        scoring_script: str,
        code_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword code_id: ARM resource ID of the code asset.
        :paramtype code_id: str
        :keyword scoring_script: Required. [Required] The script to execute on startup. eg. "score.py".
        :paramtype scoring_script: str
        """
        super(CodeConfiguration, self).__init__(**kwargs)
        self.code_id = code_id
        self.scoring_script = scoring_script


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ProxyResource, self).__init__(**kwargs)


class CodeContainer(ProxyResource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.CodeContainerProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'CodeContainerProperties'},
    }

    def __init__(
        self,
        *,
        properties: "CodeContainerProperties",
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.CodeContainerProperties
        """
        super(CodeContainer, self).__init__(**kwargs)
        self.properties = properties


class CodeContainerProperties(AssetContainer):
    """Container for code asset versions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar latest_version: The latest version inside this container.
    :vartype latest_version: str
    :ivar next_version: The next auto incremental version.
    :vartype next_version: str
    :ivar provisioning_state: Provisioning state for the code container. Possible values include:
     "Succeeded", "Failed", "Canceled", "Creating", "Updating", "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.AssetProvisioningState
    """

    _validation = {
        'latest_version': {'readonly': True},
        'next_version': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'latest_version': {'key': 'latestVersion', 'type': 'str'},
        'next_version': {'key': 'nextVersion', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_archived: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        """
        super(CodeContainerProperties, self).__init__(description=description, properties=properties, tags=tags, is_archived=is_archived, **kwargs)
        self.provisioning_state = None


class CodeContainerResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of CodeContainer entities.

    :ivar next_link: The link to the next page of CodeContainer objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type CodeContainer.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.CodeContainer]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[CodeContainer]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["CodeContainer"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of CodeContainer objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type CodeContainer.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.CodeContainer]
        """
        super(CodeContainerResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class CodeVersion(ProxyResource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.CodeVersionProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'CodeVersionProperties'},
    }

    def __init__(
        self,
        *,
        properties: "CodeVersionProperties",
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.CodeVersionProperties
        """
        super(CodeVersion, self).__init__(**kwargs)
        self.properties = properties


class CodeVersionProperties(AssetBase):
    """Code asset version details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar auto_delete_setting: Specifies the lifecycle setting of managed data asset.
    :vartype auto_delete_setting: ~azure.mgmt.machinelearningservices.models.AutoDeleteSetting
    :ivar is_anonymous: If the name version are system generated (anonymous registration). For
     types where Stage is defined, when Stage is provided it will be used to populate IsAnonymous.
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived? For types where Stage is defined, when Stage is
     provided it will be used to populate IsArchived.
    :vartype is_archived: bool
    :ivar code_uri: Uri where code is located.
    :vartype code_uri: str
    :ivar provisioning_state: Provisioning state for the code version. Possible values include:
     "Succeeded", "Failed", "Canceled", "Creating", "Updating", "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.AssetProvisioningState
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'auto_delete_setting': {'key': 'autoDeleteSetting', 'type': 'AutoDeleteSetting'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'code_uri': {'key': 'codeUri', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        auto_delete_setting: Optional["AutoDeleteSetting"] = None,
        is_anonymous: Optional[bool] = False,
        is_archived: Optional[bool] = False,
        code_uri: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword auto_delete_setting: Specifies the lifecycle setting of managed data asset.
        :paramtype auto_delete_setting: ~azure.mgmt.machinelearningservices.models.AutoDeleteSetting
        :keyword is_anonymous: If the name version are system generated (anonymous registration). For
         types where Stage is defined, when Stage is provided it will be used to populate IsAnonymous.
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived? For types where Stage is defined, when Stage is
         provided it will be used to populate IsArchived.
        :paramtype is_archived: bool
        :keyword code_uri: Uri where code is located.
        :paramtype code_uri: str
        """
        super(CodeVersionProperties, self).__init__(description=description, properties=properties, tags=tags, auto_delete_setting=auto_delete_setting, is_anonymous=is_anonymous, is_archived=is_archived, **kwargs)
        self.code_uri = code_uri
        self.provisioning_state = None


class CodeVersionResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of CodeVersion entities.

    :ivar next_link: The link to the next page of CodeVersion objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type CodeVersion.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.CodeVersion]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[CodeVersion]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["CodeVersion"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of CodeVersion objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type CodeVersion.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.CodeVersion]
        """
        super(CodeVersionResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class CognitiveServiceEndpointDeploymentResourceProperties(msrest.serialization.Model):
    """CognitiveServiceEndpointDeploymentResourceProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar model: Required. Model used for the endpoint deployment.
    :vartype model: ~azure.mgmt.machinelearningservices.models.EndpointDeploymentModel
    :ivar rai_policy_name: The name of RAI policy.
    :vartype rai_policy_name: str
    :ivar sku:
    :vartype sku: ~azure.mgmt.machinelearningservices.models.CognitiveServicesSku
    :ivar version_upgrade_option: Deployment model version upgrade option. Possible values include:
     "OnceNewDefaultVersionAvailable", "OnceCurrentVersionExpired", "NoAutoUpgrade".
    :vartype version_upgrade_option: str or
     ~azure.mgmt.machinelearningservices.models.DeploymentModelVersionUpgradeOption
    """

    _validation = {
        'model': {'required': True},
    }

    _attribute_map = {
        'model': {'key': 'model', 'type': 'EndpointDeploymentModel'},
        'rai_policy_name': {'key': 'raiPolicyName', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'CognitiveServicesSku'},
        'version_upgrade_option': {'key': 'versionUpgradeOption', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        model: "EndpointDeploymentModel",
        rai_policy_name: Optional[str] = None,
        sku: Optional["CognitiveServicesSku"] = None,
        version_upgrade_option: Optional[Union[str, "DeploymentModelVersionUpgradeOption"]] = None,
        **kwargs
    ):
        """
        :keyword model: Required. Model used for the endpoint deployment.
        :paramtype model: ~azure.mgmt.machinelearningservices.models.EndpointDeploymentModel
        :keyword rai_policy_name: The name of RAI policy.
        :paramtype rai_policy_name: str
        :keyword sku:
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.CognitiveServicesSku
        :keyword version_upgrade_option: Deployment model version upgrade option. Possible values
         include: "OnceNewDefaultVersionAvailable", "OnceCurrentVersionExpired", "NoAutoUpgrade".
        :paramtype version_upgrade_option: str or
         ~azure.mgmt.machinelearningservices.models.DeploymentModelVersionUpgradeOption
        """
        super(CognitiveServiceEndpointDeploymentResourceProperties, self).__init__(**kwargs)
        self.model = model
        self.rai_policy_name = rai_policy_name
        self.sku = sku
        self.version_upgrade_option = version_upgrade_option


class CognitiveServicesSku(msrest.serialization.Model):
    """CognitiveServicesSku.

    :ivar capacity:
    :vartype capacity: int
    :ivar family:
    :vartype family: str
    :ivar name:
    :vartype name: str
    :ivar size:
    :vartype size: str
    :ivar tier:
    :vartype tier: str
    """

    _attribute_map = {
        'capacity': {'key': 'capacity', 'type': 'int'},
        'family': {'key': 'family', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        capacity: Optional[int] = None,
        family: Optional[str] = None,
        name: Optional[str] = None,
        size: Optional[str] = None,
        tier: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword capacity:
        :paramtype capacity: int
        :keyword family:
        :paramtype family: str
        :keyword name:
        :paramtype name: str
        :keyword size:
        :paramtype size: str
        :keyword tier:
        :paramtype tier: str
        """
        super(CognitiveServicesSku, self).__init__(**kwargs)
        self.capacity = capacity
        self.family = family
        self.name = name
        self.size = size
        self.tier = tier


class Collection(msrest.serialization.Model):
    """Collection.

    :ivar client_id: The msi client id used to collect logging to blob storage. If it's
     null,backend will pick a registered endpoint identity to auth.
    :vartype client_id: str
    :ivar data_collection_mode: Enable or disable data collection. Possible values include:
     "Enabled", "Disabled".
    :vartype data_collection_mode: str or
     ~azure.mgmt.machinelearningservices.models.DataCollectionMode
    :ivar data_id: The data asset arm resource id. Client side will ensure data asset is pointing
     to the blob storage, and backend will collect data to the blob storage.
    :vartype data_id: str
    :ivar sampling_rate: The sampling rate for collection. Sampling rate 1.0 means we collect 100%
     of data by default.
    :vartype sampling_rate: float
    """

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
        'data_collection_mode': {'key': 'dataCollectionMode', 'type': 'str'},
        'data_id': {'key': 'dataId', 'type': 'str'},
        'sampling_rate': {'key': 'samplingRate', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        client_id: Optional[str] = None,
        data_collection_mode: Optional[Union[str, "DataCollectionMode"]] = None,
        data_id: Optional[str] = None,
        sampling_rate: Optional[float] = 1,
        **kwargs
    ):
        """
        :keyword client_id: The msi client id used to collect logging to blob storage. If it's
         null,backend will pick a registered endpoint identity to auth.
        :paramtype client_id: str
        :keyword data_collection_mode: Enable or disable data collection. Possible values include:
         "Enabled", "Disabled".
        :paramtype data_collection_mode: str or
         ~azure.mgmt.machinelearningservices.models.DataCollectionMode
        :keyword data_id: The data asset arm resource id. Client side will ensure data asset is
         pointing to the blob storage, and backend will collect data to the blob storage.
        :paramtype data_id: str
        :keyword sampling_rate: The sampling rate for collection. Sampling rate 1.0 means we collect
         100% of data by default.
        :paramtype sampling_rate: float
        """
        super(Collection, self).__init__(**kwargs)
        self.client_id = client_id
        self.data_collection_mode = data_collection_mode
        self.data_id = data_id
        self.sampling_rate = sampling_rate


class ColumnTransformer(msrest.serialization.Model):
    """Column transformer parameters.

    :ivar fields: Fields to apply transformer logic on.
    :vartype fields: list[str]
    :ivar parameters: Different properties to be passed to transformer.
     Input expected is dictionary of key,value pairs in JSON format.
    :vartype parameters: any
    """

    _attribute_map = {
        'fields': {'key': 'fields', 'type': '[str]'},
        'parameters': {'key': 'parameters', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        fields: Optional[List[str]] = None,
        parameters: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword fields: Fields to apply transformer logic on.
        :paramtype fields: list[str]
        :keyword parameters: Different properties to be passed to transformer.
         Input expected is dictionary of key,value pairs in JSON format.
        :paramtype parameters: any
        """
        super(ColumnTransformer, self).__init__(**kwargs)
        self.fields = fields
        self.parameters = parameters


class CommandJob(JobBaseProperties):
    """Command job definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar component_id: ARM resource ID of the component resource.
    :vartype component_id: str
    :ivar compute_id: ARM resource ID of the compute resource.
    :vartype compute_id: str
    :ivar display_name: Display name of job.
    :vartype display_name: str
    :ivar experiment_name: The name of the experiment the job belongs to. If not set, the job is
     placed in the "Default" experiment.
    :vartype experiment_name: str
    :ivar identity: Identity configuration. If set, this should be one of AmlToken,
     ManagedIdentity, UserIdentity or null.
     Defaults to AmlToken if null.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar job_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "AutoML", "Command", "Labeling", "Sweep", "Pipeline", "Spark",
     "FineTuning".
    :vartype job_type: str or ~azure.mgmt.machinelearningservices.models.JobType
    :ivar notification_setting: Notification setting for the job.
    :vartype notification_setting: ~azure.mgmt.machinelearningservices.models.NotificationSetting
    :ivar secrets_configuration: Configuration for secrets to be made available during runtime.
    :vartype secrets_configuration: dict[str,
     ~azure.mgmt.machinelearningservices.models.SecretConfiguration]
    :ivar services: List of JobEndpoints.
     For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
    :vartype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
    :ivar status: Status of the job. Possible values include: "NotStarted", "Starting",
     "Provisioning", "Preparing", "Queued", "Running", "Finalizing", "CancelRequested", "Completed",
     "Failed", "Canceled", "NotResponding", "Paused", "Unknown", "Scheduled".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.JobStatus
    :ivar autologger_settings: Distribution configuration of the job. If set, this should be one of
     Mpi, Tensorflow, PyTorch, or null.
    :vartype autologger_settings: ~azure.mgmt.machinelearningservices.models.AutologgerSettings
    :ivar code_id: ARM resource ID of the code asset.
    :vartype code_id: str
    :ivar command: Required. [Required] The command to execute on startup of the job. eg. "python
     train.py".
    :vartype command: str
    :ivar distribution: Distribution configuration of the job. If set, this should be one of Mpi,
     Tensorflow, PyTorch, Ray, or null.
    :vartype distribution: ~azure.mgmt.machinelearningservices.models.DistributionConfiguration
    :ivar environment_id: Required. [Required] The ARM resource ID of the Environment specification
     for the job.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables included in the job.
    :vartype environment_variables: dict[str, str]
    :ivar inputs: Mapping of input data bindings used in the job.
    :vartype inputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobInput]
    :ivar limits: Command Job limit.
    :vartype limits: ~azure.mgmt.machinelearningservices.models.CommandJobLimits
    :ivar outputs: Mapping of output data bindings used in the job.
    :vartype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
    :ivar parameters: Input parameters.
    :vartype parameters: any
    :ivar queue_settings: Queue settings for the job.
    :vartype queue_settings: ~azure.mgmt.machinelearningservices.models.QueueSettings
    :ivar resources: Compute Resource configuration for the job.
    :vartype resources: ~azure.mgmt.machinelearningservices.models.JobResourceConfiguration
    """

    _validation = {
        'job_type': {'required': True},
        'status': {'readonly': True},
        'command': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
        'environment_id': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
        'parameters': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'component_id': {'key': 'componentId', 'type': 'str'},
        'compute_id': {'key': 'computeId', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'experiment_name': {'key': 'experimentName', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'IdentityConfiguration'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'notification_setting': {'key': 'notificationSetting', 'type': 'NotificationSetting'},
        'secrets_configuration': {'key': 'secretsConfiguration', 'type': '{SecretConfiguration}'},
        'services': {'key': 'services', 'type': '{JobService}'},
        'status': {'key': 'status', 'type': 'str'},
        'autologger_settings': {'key': 'autologgerSettings', 'type': 'AutologgerSettings'},
        'code_id': {'key': 'codeId', 'type': 'str'},
        'command': {'key': 'command', 'type': 'str'},
        'distribution': {'key': 'distribution', 'type': 'DistributionConfiguration'},
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'environment_variables': {'key': 'environmentVariables', 'type': '{str}'},
        'inputs': {'key': 'inputs', 'type': '{JobInput}'},
        'limits': {'key': 'limits', 'type': 'CommandJobLimits'},
        'outputs': {'key': 'outputs', 'type': '{JobOutput}'},
        'parameters': {'key': 'parameters', 'type': 'object'},
        'queue_settings': {'key': 'queueSettings', 'type': 'QueueSettings'},
        'resources': {'key': 'resources', 'type': 'JobResourceConfiguration'},
    }

    def __init__(
        self,
        *,
        command: str,
        environment_id: str,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        component_id: Optional[str] = None,
        compute_id: Optional[str] = None,
        display_name: Optional[str] = None,
        experiment_name: Optional[str] = "Default",
        identity: Optional["IdentityConfiguration"] = None,
        is_archived: Optional[bool] = False,
        notification_setting: Optional["NotificationSetting"] = None,
        secrets_configuration: Optional[Dict[str, "SecretConfiguration"]] = None,
        services: Optional[Dict[str, "JobService"]] = None,
        autologger_settings: Optional["AutologgerSettings"] = None,
        code_id: Optional[str] = None,
        distribution: Optional["DistributionConfiguration"] = None,
        environment_variables: Optional[Dict[str, str]] = None,
        inputs: Optional[Dict[str, "JobInput"]] = None,
        limits: Optional["CommandJobLimits"] = None,
        outputs: Optional[Dict[str, "JobOutput"]] = None,
        queue_settings: Optional["QueueSettings"] = None,
        resources: Optional["JobResourceConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword component_id: ARM resource ID of the component resource.
        :paramtype component_id: str
        :keyword compute_id: ARM resource ID of the compute resource.
        :paramtype compute_id: str
        :keyword display_name: Display name of job.
        :paramtype display_name: str
        :keyword experiment_name: The name of the experiment the job belongs to. If not set, the job is
         placed in the "Default" experiment.
        :paramtype experiment_name: str
        :keyword identity: Identity configuration. If set, this should be one of AmlToken,
         ManagedIdentity, UserIdentity or null.
         Defaults to AmlToken if null.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword notification_setting: Notification setting for the job.
        :paramtype notification_setting: ~azure.mgmt.machinelearningservices.models.NotificationSetting
        :keyword secrets_configuration: Configuration for secrets to be made available during runtime.
        :paramtype secrets_configuration: dict[str,
         ~azure.mgmt.machinelearningservices.models.SecretConfiguration]
        :keyword services: List of JobEndpoints.
         For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :paramtype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
        :keyword autologger_settings: Distribution configuration of the job. If set, this should be one
         of Mpi, Tensorflow, PyTorch, or null.
        :paramtype autologger_settings: ~azure.mgmt.machinelearningservices.models.AutologgerSettings
        :keyword code_id: ARM resource ID of the code asset.
        :paramtype code_id: str
        :keyword command: Required. [Required] The command to execute on startup of the job. eg.
         "python train.py".
        :paramtype command: str
        :keyword distribution: Distribution configuration of the job. If set, this should be one of
         Mpi, Tensorflow, PyTorch, Ray, or null.
        :paramtype distribution: ~azure.mgmt.machinelearningservices.models.DistributionConfiguration
        :keyword environment_id: Required. [Required] The ARM resource ID of the Environment
         specification for the job.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables included in the job.
        :paramtype environment_variables: dict[str, str]
        :keyword inputs: Mapping of input data bindings used in the job.
        :paramtype inputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobInput]
        :keyword limits: Command Job limit.
        :paramtype limits: ~azure.mgmt.machinelearningservices.models.CommandJobLimits
        :keyword outputs: Mapping of output data bindings used in the job.
        :paramtype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
        :keyword queue_settings: Queue settings for the job.
        :paramtype queue_settings: ~azure.mgmt.machinelearningservices.models.QueueSettings
        :keyword resources: Compute Resource configuration for the job.
        :paramtype resources: ~azure.mgmt.machinelearningservices.models.JobResourceConfiguration
        """
        super(CommandJob, self).__init__(description=description, properties=properties, tags=tags, component_id=component_id, compute_id=compute_id, display_name=display_name, experiment_name=experiment_name, identity=identity, is_archived=is_archived, notification_setting=notification_setting, secrets_configuration=secrets_configuration, services=services, **kwargs)
        self.job_type = 'Command'  # type: str
        self.autologger_settings = autologger_settings
        self.code_id = code_id
        self.command = command
        self.distribution = distribution
        self.environment_id = environment_id
        self.environment_variables = environment_variables
        self.inputs = inputs
        self.limits = limits
        self.outputs = outputs
        self.parameters = None
        self.queue_settings = queue_settings
        self.resources = resources


class JobLimits(msrest.serialization.Model):
    """JobLimits.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CommandJobLimits, SweepJobLimits.

    All required parameters must be populated in order to send to Azure.

    :ivar job_limits_type: Required. [Required] JobLimit type.Constant filled by server. Possible
     values include: "Command", "Sweep".
    :vartype job_limits_type: str or ~azure.mgmt.machinelearningservices.models.JobLimitsType
    :ivar timeout: The max run duration in ISO 8601 format, after which the job will be cancelled.
     Only supports duration with precision as low as Seconds.
    :vartype timeout: ~datetime.timedelta
    """

    _validation = {
        'job_limits_type': {'required': True},
    }

    _attribute_map = {
        'job_limits_type': {'key': 'jobLimitsType', 'type': 'str'},
        'timeout': {'key': 'timeout', 'type': 'duration'},
    }

    _subtype_map = {
        'job_limits_type': {'Command': 'CommandJobLimits', 'Sweep': 'SweepJobLimits'}
    }

    def __init__(
        self,
        *,
        timeout: Optional[datetime.timedelta] = None,
        **kwargs
    ):
        """
        :keyword timeout: The max run duration in ISO 8601 format, after which the job will be
         cancelled. Only supports duration with precision as low as Seconds.
        :paramtype timeout: ~datetime.timedelta
        """
        super(JobLimits, self).__init__(**kwargs)
        self.job_limits_type = None  # type: Optional[str]
        self.timeout = timeout


class CommandJobLimits(JobLimits):
    """Command Job limit class.

    All required parameters must be populated in order to send to Azure.

    :ivar job_limits_type: Required. [Required] JobLimit type.Constant filled by server. Possible
     values include: "Command", "Sweep".
    :vartype job_limits_type: str or ~azure.mgmt.machinelearningservices.models.JobLimitsType
    :ivar timeout: The max run duration in ISO 8601 format, after which the job will be cancelled.
     Only supports duration with precision as low as Seconds.
    :vartype timeout: ~datetime.timedelta
    """

    _validation = {
        'job_limits_type': {'required': True},
    }

    _attribute_map = {
        'job_limits_type': {'key': 'jobLimitsType', 'type': 'str'},
        'timeout': {'key': 'timeout', 'type': 'duration'},
    }

    def __init__(
        self,
        *,
        timeout: Optional[datetime.timedelta] = None,
        **kwargs
    ):
        """
        :keyword timeout: The max run duration in ISO 8601 format, after which the job will be
         cancelled. Only supports duration with precision as low as Seconds.
        :paramtype timeout: ~datetime.timedelta
        """
        super(CommandJobLimits, self).__init__(timeout=timeout, **kwargs)
        self.job_limits_type = 'Command'  # type: str


class ComponentConfiguration(msrest.serialization.Model):
    """Used for sweep over component.

    :ivar pipeline_settings: Pipeline settings, for things like ContinueRunOnStepFailure etc.
    :vartype pipeline_settings: any
    """

    _attribute_map = {
        'pipeline_settings': {'key': 'pipelineSettings', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        pipeline_settings: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword pipeline_settings: Pipeline settings, for things like ContinueRunOnStepFailure etc.
        :paramtype pipeline_settings: any
        """
        super(ComponentConfiguration, self).__init__(**kwargs)
        self.pipeline_settings = pipeline_settings


class ComponentContainer(ProxyResource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.ComponentContainerProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'ComponentContainerProperties'},
    }

    def __init__(
        self,
        *,
        properties: "ComponentContainerProperties",
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.ComponentContainerProperties
        """
        super(ComponentContainer, self).__init__(**kwargs)
        self.properties = properties


class ComponentContainerProperties(AssetContainer):
    """Component container definition.


.. raw:: html

   <see href="https://docs.microsoft.com/en-us/azure/machine-learning/reference-yaml-component-command" />.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar latest_version: The latest version inside this container.
    :vartype latest_version: str
    :ivar next_version: The next auto incremental version.
    :vartype next_version: str
    :ivar provisioning_state: Provisioning state for the component container. Possible values
     include: "Succeeded", "Failed", "Canceled", "Creating", "Updating", "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.AssetProvisioningState
    """

    _validation = {
        'latest_version': {'readonly': True},
        'next_version': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'latest_version': {'key': 'latestVersion', 'type': 'str'},
        'next_version': {'key': 'nextVersion', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_archived: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        """
        super(ComponentContainerProperties, self).__init__(description=description, properties=properties, tags=tags, is_archived=is_archived, **kwargs)
        self.provisioning_state = None


class ComponentContainerResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of ComponentContainer entities.

    :ivar next_link: The link to the next page of ComponentContainer objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type ComponentContainer.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.ComponentContainer]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ComponentContainer]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["ComponentContainer"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of ComponentContainer objects. If null, there are
         no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type ComponentContainer.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.ComponentContainer]
        """
        super(ComponentContainerResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ComponentVersion(ProxyResource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.ComponentVersionProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'ComponentVersionProperties'},
    }

    def __init__(
        self,
        *,
        properties: "ComponentVersionProperties",
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.ComponentVersionProperties
        """
        super(ComponentVersion, self).__init__(**kwargs)
        self.properties = properties


class ComponentVersionProperties(AssetBase):
    """Definition of a component version: defines resources that span component types.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar auto_delete_setting: Specifies the lifecycle setting of managed data asset.
    :vartype auto_delete_setting: ~azure.mgmt.machinelearningservices.models.AutoDeleteSetting
    :ivar is_anonymous: If the name version are system generated (anonymous registration). For
     types where Stage is defined, when Stage is provided it will be used to populate IsAnonymous.
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived? For types where Stage is defined, when Stage is
     provided it will be used to populate IsArchived.
    :vartype is_archived: bool
    :ivar component_spec: Defines Component definition details.
    
    
     .. raw:: html
    
        <see
     href="https://docs.microsoft.com/en-us/azure/machine-learning/reference-yaml-component-command"
     />.
    :vartype component_spec: any
    :ivar provisioning_state: Provisioning state for the component version. Possible values
     include: "Succeeded", "Failed", "Canceled", "Creating", "Updating", "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.AssetProvisioningState
    :ivar stage: Stage in the component lifecycle.
    :vartype stage: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'auto_delete_setting': {'key': 'autoDeleteSetting', 'type': 'AutoDeleteSetting'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'component_spec': {'key': 'componentSpec', 'type': 'object'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'stage': {'key': 'stage', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        auto_delete_setting: Optional["AutoDeleteSetting"] = None,
        is_anonymous: Optional[bool] = False,
        is_archived: Optional[bool] = False,
        component_spec: Optional[Any] = None,
        stage: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword auto_delete_setting: Specifies the lifecycle setting of managed data asset.
        :paramtype auto_delete_setting: ~azure.mgmt.machinelearningservices.models.AutoDeleteSetting
        :keyword is_anonymous: If the name version are system generated (anonymous registration). For
         types where Stage is defined, when Stage is provided it will be used to populate IsAnonymous.
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived? For types where Stage is defined, when Stage is
         provided it will be used to populate IsArchived.
        :paramtype is_archived: bool
        :keyword component_spec: Defines Component definition details.
        
        
         .. raw:: html
        
            <see
         href="https://docs.microsoft.com/en-us/azure/machine-learning/reference-yaml-component-command"
         />.
        :paramtype component_spec: any
        :keyword stage: Stage in the component lifecycle.
        :paramtype stage: str
        """
        super(ComponentVersionProperties, self).__init__(description=description, properties=properties, tags=tags, auto_delete_setting=auto_delete_setting, is_anonymous=is_anonymous, is_archived=is_archived, **kwargs)
        self.component_spec = component_spec
        self.provisioning_state = None
        self.stage = stage


class ComponentVersionResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of ComponentVersion entities.

    :ivar next_link: The link to the next page of ComponentVersion objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type ComponentVersion.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.ComponentVersion]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ComponentVersion]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["ComponentVersion"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of ComponentVersion objects. If null, there are
         no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type ComponentVersion.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.ComponentVersion]
        """
        super(ComponentVersionResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ComputeInstanceSchema(msrest.serialization.Model):
    """Properties(top level) of ComputeInstance.

    :ivar properties: Properties of ComputeInstance.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.ComputeInstanceProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'ComputeInstanceProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["ComputeInstanceProperties"] = None,
        **kwargs
    ):
        """
        :keyword properties: Properties of ComputeInstance.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.ComputeInstanceProperties
        """
        super(ComputeInstanceSchema, self).__init__(**kwargs)
        self.properties = properties


class ComputeInstance(Compute, ComputeInstanceSchema):
    """An Azure Machine Learning compute instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: Properties of ComputeInstance.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.ComputeInstanceProperties
    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    """

    _validation = {
        'compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'ComputeInstanceProperties'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[ErrorResponse]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'disable_local_auth': {'key': 'disableLocalAuth', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        properties: Optional["ComputeInstanceProperties"] = None,
        compute_location: Optional[str] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        disable_local_auth: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword properties: Properties of ComputeInstance.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.ComputeInstanceProperties
        :keyword compute_location: Location for the underlying compute.
        :paramtype compute_location: str
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        :keyword disable_local_auth: Opt-out of local authentication and ensure customers can use only
         MSI and AAD exclusively for authentication.
        :paramtype disable_local_auth: bool
        """
        super(ComputeInstance, self).__init__(compute_location=compute_location, description=description, resource_id=resource_id, disable_local_auth=disable_local_auth, properties=properties, **kwargs)
        self.properties = properties
        self.compute_type = 'ComputeInstance'  # type: str
        self.compute_location = compute_location
        self.provisioning_state = None
        self.description = description
        self.created_on = None
        self.modified_on = None
        self.resource_id = resource_id
        self.provisioning_errors = None
        self.is_attached_compute = None
        self.disable_local_auth = disable_local_auth


class ComputeInstanceApplication(msrest.serialization.Model):
    """Defines an Aml Instance application and its connectivity endpoint URI.

    :ivar display_name: Name of the ComputeInstance application.
    :vartype display_name: str
    :ivar endpoint_uri: Application' endpoint URI.
    :vartype endpoint_uri: str
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'endpoint_uri': {'key': 'endpointUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        endpoint_uri: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword display_name: Name of the ComputeInstance application.
        :paramtype display_name: str
        :keyword endpoint_uri: Application' endpoint URI.
        :paramtype endpoint_uri: str
        """
        super(ComputeInstanceApplication, self).__init__(**kwargs)
        self.display_name = display_name
        self.endpoint_uri = endpoint_uri


class ComputeInstanceAutologgerSettings(msrest.serialization.Model):
    """Specifies settings for autologger.

    :ivar mlflow_autologger: Indicates whether mlflow autologger is enabled for notebooks. Possible
     values include: "Enabled", "Disabled".
    :vartype mlflow_autologger: str or ~azure.mgmt.machinelearningservices.models.MlflowAutologger
    """

    _attribute_map = {
        'mlflow_autologger': {'key': 'mlflowAutologger', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        mlflow_autologger: Optional[Union[str, "MlflowAutologger"]] = None,
        **kwargs
    ):
        """
        :keyword mlflow_autologger: Indicates whether mlflow autologger is enabled for notebooks.
         Possible values include: "Enabled", "Disabled".
        :paramtype mlflow_autologger: str or
         ~azure.mgmt.machinelearningservices.models.MlflowAutologger
        """
        super(ComputeInstanceAutologgerSettings, self).__init__(**kwargs)
        self.mlflow_autologger = mlflow_autologger


class ComputeInstanceConnectivityEndpoints(msrest.serialization.Model):
    """Defines all connectivity endpoints and properties for an ComputeInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar public_ip_address: Public IP Address of this ComputeInstance.
    :vartype public_ip_address: str
    :ivar private_ip_address: Private IP Address of this ComputeInstance (local to the VNET in
     which the compute instance is deployed).
    :vartype private_ip_address: str
    """

    _validation = {
        'public_ip_address': {'readonly': True},
        'private_ip_address': {'readonly': True},
    }

    _attribute_map = {
        'public_ip_address': {'key': 'publicIpAddress', 'type': 'str'},
        'private_ip_address': {'key': 'privateIpAddress', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ComputeInstanceConnectivityEndpoints, self).__init__(**kwargs)
        self.public_ip_address = None
        self.private_ip_address = None


class ComputeInstanceContainer(msrest.serialization.Model):
    """Defines an Aml Instance container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the ComputeInstance container.
    :vartype name: str
    :ivar autosave: Auto save settings. Possible values include: "None", "Local", "Remote".
    :vartype autosave: str or ~azure.mgmt.machinelearningservices.models.Autosave
    :ivar gpu: Information of GPU.
    :vartype gpu: str
    :ivar network: network of this container. Possible values include: "Bridge", "Host".
    :vartype network: str or ~azure.mgmt.machinelearningservices.models.Network
    :ivar environment: Environment information of this container.
    :vartype environment: ~azure.mgmt.machinelearningservices.models.ComputeInstanceEnvironmentInfo
    :ivar services: services of this containers.
    :vartype services: list[any]
    """

    _validation = {
        'services': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'autosave': {'key': 'autosave', 'type': 'str'},
        'gpu': {'key': 'gpu', 'type': 'str'},
        'network': {'key': 'network', 'type': 'str'},
        'environment': {'key': 'environment', 'type': 'ComputeInstanceEnvironmentInfo'},
        'services': {'key': 'services', 'type': '[object]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        autosave: Optional[Union[str, "Autosave"]] = None,
        gpu: Optional[str] = None,
        network: Optional[Union[str, "Network"]] = None,
        environment: Optional["ComputeInstanceEnvironmentInfo"] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the ComputeInstance container.
        :paramtype name: str
        :keyword autosave: Auto save settings. Possible values include: "None", "Local", "Remote".
        :paramtype autosave: str or ~azure.mgmt.machinelearningservices.models.Autosave
        :keyword gpu: Information of GPU.
        :paramtype gpu: str
        :keyword network: network of this container. Possible values include: "Bridge", "Host".
        :paramtype network: str or ~azure.mgmt.machinelearningservices.models.Network
        :keyword environment: Environment information of this container.
        :paramtype environment:
         ~azure.mgmt.machinelearningservices.models.ComputeInstanceEnvironmentInfo
        """
        super(ComputeInstanceContainer, self).__init__(**kwargs)
        self.name = name
        self.autosave = autosave
        self.gpu = gpu
        self.network = network
        self.environment = environment
        self.services = None


class ComputeInstanceCreatedBy(msrest.serialization.Model):
    """Describes information on user who created this ComputeInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar user_name: Name of the user.
    :vartype user_name: str
    :ivar user_org_id: Uniquely identifies user' Azure Active Directory organization.
    :vartype user_org_id: str
    :ivar user_id: Uniquely identifies the user within his/her organization.
    :vartype user_id: str
    """

    _validation = {
        'user_name': {'readonly': True},
        'user_org_id': {'readonly': True},
        'user_id': {'readonly': True},
    }

    _attribute_map = {
        'user_name': {'key': 'userName', 'type': 'str'},
        'user_org_id': {'key': 'userOrgId', 'type': 'str'},
        'user_id': {'key': 'userId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ComputeInstanceCreatedBy, self).__init__(**kwargs)
        self.user_name = None
        self.user_org_id = None
        self.user_id = None


class ComputeInstanceDataDisk(msrest.serialization.Model):
    """Defines an Aml Instance DataDisk.

    :ivar caching: Caching type of Data Disk. Possible values include: "None", "ReadOnly",
     "ReadWrite".
    :vartype caching: str or ~azure.mgmt.machinelearningservices.models.Caching
    :ivar disk_size_gb: The initial disk size in gigabytes.
    :vartype disk_size_gb: int
    :ivar lun: The lun is used to uniquely identify each data disk. If attaching multiple disks,
     each should have a distinct lun.
    :vartype lun: int
    :ivar storage_account_type: type of this storage account. Possible values include:
     "Standard_LRS", "Premium_LRS". Default value: "Standard_LRS".
    :vartype storage_account_type: str or
     ~azure.mgmt.machinelearningservices.models.StorageAccountType
    """

    _attribute_map = {
        'caching': {'key': 'caching', 'type': 'str'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'lun': {'key': 'lun', 'type': 'int'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        caching: Optional[Union[str, "Caching"]] = None,
        disk_size_gb: Optional[int] = None,
        lun: Optional[int] = None,
        storage_account_type: Optional[Union[str, "StorageAccountType"]] = "Standard_LRS",
        **kwargs
    ):
        """
        :keyword caching: Caching type of Data Disk. Possible values include: "None", "ReadOnly",
         "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.machinelearningservices.models.Caching
        :keyword disk_size_gb: The initial disk size in gigabytes.
        :paramtype disk_size_gb: int
        :keyword lun: The lun is used to uniquely identify each data disk. If attaching multiple disks,
         each should have a distinct lun.
        :paramtype lun: int
        :keyword storage_account_type: type of this storage account. Possible values include:
         "Standard_LRS", "Premium_LRS". Default value: "Standard_LRS".
        :paramtype storage_account_type: str or
         ~azure.mgmt.machinelearningservices.models.StorageAccountType
        """
        super(ComputeInstanceDataDisk, self).__init__(**kwargs)
        self.caching = caching
        self.disk_size_gb = disk_size_gb
        self.lun = lun
        self.storage_account_type = storage_account_type


class ComputeInstanceDataMount(msrest.serialization.Model):
    """Defines an Aml Instance DataMount.

    :ivar source: Source of the ComputeInstance data mount.
    :vartype source: str
    :ivar source_type: Data source type. Possible values include: "Dataset", "Datastore", "URI".
    :vartype source_type: str or ~azure.mgmt.machinelearningservices.models.SourceType
    :ivar mount_name: name of the ComputeInstance data mount.
    :vartype mount_name: str
    :ivar mount_action: Mount Action. Possible values include: "Mount", "Unmount".
    :vartype mount_action: str or ~azure.mgmt.machinelearningservices.models.MountAction
    :ivar mount_mode: Mount Mode. Possible values include: "ReadOnly", "ReadWrite".
    :vartype mount_mode: str or ~azure.mgmt.machinelearningservices.models.MountMode
    :ivar created_by: who this data mount created by.
    :vartype created_by: str
    :ivar mount_path: Path of this data mount.
    :vartype mount_path: str
    :ivar mount_state: Mount state. Possible values include: "MountRequested", "Mounted",
     "MountFailed", "UnmountRequested", "UnmountFailed", "Unmounted".
    :vartype mount_state: str or ~azure.mgmt.machinelearningservices.models.MountState
    :ivar mounted_on: The time when the disk mounted.
    :vartype mounted_on: ~datetime.datetime
    :ivar error: Error of this data mount.
    :vartype error: str
    """

    _attribute_map = {
        'source': {'key': 'source', 'type': 'str'},
        'source_type': {'key': 'sourceType', 'type': 'str'},
        'mount_name': {'key': 'mountName', 'type': 'str'},
        'mount_action': {'key': 'mountAction', 'type': 'str'},
        'mount_mode': {'key': 'mountMode', 'type': 'str'},
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'mount_path': {'key': 'mountPath', 'type': 'str'},
        'mount_state': {'key': 'mountState', 'type': 'str'},
        'mounted_on': {'key': 'mountedOn', 'type': 'iso-8601'},
        'error': {'key': 'error', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source: Optional[str] = None,
        source_type: Optional[Union[str, "SourceType"]] = None,
        mount_name: Optional[str] = None,
        mount_action: Optional[Union[str, "MountAction"]] = None,
        mount_mode: Optional[Union[str, "MountMode"]] = None,
        created_by: Optional[str] = None,
        mount_path: Optional[str] = None,
        mount_state: Optional[Union[str, "MountState"]] = None,
        mounted_on: Optional[datetime.datetime] = None,
        error: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword source: Source of the ComputeInstance data mount.
        :paramtype source: str
        :keyword source_type: Data source type. Possible values include: "Dataset", "Datastore", "URI".
        :paramtype source_type: str or ~azure.mgmt.machinelearningservices.models.SourceType
        :keyword mount_name: name of the ComputeInstance data mount.
        :paramtype mount_name: str
        :keyword mount_action: Mount Action. Possible values include: "Mount", "Unmount".
        :paramtype mount_action: str or ~azure.mgmt.machinelearningservices.models.MountAction
        :keyword mount_mode: Mount Mode. Possible values include: "ReadOnly", "ReadWrite".
        :paramtype mount_mode: str or ~azure.mgmt.machinelearningservices.models.MountMode
        :keyword created_by: who this data mount created by.
        :paramtype created_by: str
        :keyword mount_path: Path of this data mount.
        :paramtype mount_path: str
        :keyword mount_state: Mount state. Possible values include: "MountRequested", "Mounted",
         "MountFailed", "UnmountRequested", "UnmountFailed", "Unmounted".
        :paramtype mount_state: str or ~azure.mgmt.machinelearningservices.models.MountState
        :keyword mounted_on: The time when the disk mounted.
        :paramtype mounted_on: ~datetime.datetime
        :keyword error: Error of this data mount.
        :paramtype error: str
        """
        super(ComputeInstanceDataMount, self).__init__(**kwargs)
        self.source = source
        self.source_type = source_type
        self.mount_name = mount_name
        self.mount_action = mount_action
        self.mount_mode = mount_mode
        self.created_by = created_by
        self.mount_path = mount_path
        self.mount_state = mount_state
        self.mounted_on = mounted_on
        self.error = error


class ComputeInstanceEnvironmentInfo(msrest.serialization.Model):
    """Environment information.

    :ivar name: name of environment.
    :vartype name: str
    :ivar version: version of environment.
    :vartype version: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: name of environment.
        :paramtype name: str
        :keyword version: version of environment.
        :paramtype version: str
        """
        super(ComputeInstanceEnvironmentInfo, self).__init__(**kwargs)
        self.name = name
        self.version = version


class ComputeInstanceLastOperation(msrest.serialization.Model):
    """The last operation on ComputeInstance.

    :ivar operation_name: Name of the last operation. Possible values include: "Create", "Start",
     "Stop", "Restart", "Resize", "Reimage", "Delete".
    :vartype operation_name: str or ~azure.mgmt.machinelearningservices.models.OperationName
    :ivar operation_time: Time of the last operation.
    :vartype operation_time: ~datetime.datetime
    :ivar operation_status: Operation status. Possible values include: "InProgress", "Succeeded",
     "CreateFailed", "StartFailed", "StopFailed", "RestartFailed", "ResizeFailed", "ReimageFailed",
     "DeleteFailed".
    :vartype operation_status: str or ~azure.mgmt.machinelearningservices.models.OperationStatus
    :ivar operation_trigger: Trigger of operation. Possible values include: "User", "Schedule",
     "IdleShutdown".
    :vartype operation_trigger: str or ~azure.mgmt.machinelearningservices.models.OperationTrigger
    """

    _attribute_map = {
        'operation_name': {'key': 'operationName', 'type': 'str'},
        'operation_time': {'key': 'operationTime', 'type': 'iso-8601'},
        'operation_status': {'key': 'operationStatus', 'type': 'str'},
        'operation_trigger': {'key': 'operationTrigger', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        operation_name: Optional[Union[str, "OperationName"]] = None,
        operation_time: Optional[datetime.datetime] = None,
        operation_status: Optional[Union[str, "OperationStatus"]] = None,
        operation_trigger: Optional[Union[str, "OperationTrigger"]] = None,
        **kwargs
    ):
        """
        :keyword operation_name: Name of the last operation. Possible values include: "Create",
         "Start", "Stop", "Restart", "Resize", "Reimage", "Delete".
        :paramtype operation_name: str or ~azure.mgmt.machinelearningservices.models.OperationName
        :keyword operation_time: Time of the last operation.
        :paramtype operation_time: ~datetime.datetime
        :keyword operation_status: Operation status. Possible values include: "InProgress",
         "Succeeded", "CreateFailed", "StartFailed", "StopFailed", "RestartFailed", "ResizeFailed",
         "ReimageFailed", "DeleteFailed".
        :paramtype operation_status: str or ~azure.mgmt.machinelearningservices.models.OperationStatus
        :keyword operation_trigger: Trigger of operation. Possible values include: "User", "Schedule",
         "IdleShutdown".
        :paramtype operation_trigger: str or
         ~azure.mgmt.machinelearningservices.models.OperationTrigger
        """
        super(ComputeInstanceLastOperation, self).__init__(**kwargs)
        self.operation_name = operation_name
        self.operation_time = operation_time
        self.operation_status = operation_status
        self.operation_trigger = operation_trigger


class ComputeInstanceProperties(msrest.serialization.Model):
    """Compute Instance properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar vm_size: Virtual Machine Size.
    :vartype vm_size: str
    :ivar subnet: Virtual network subnet resource ID the compute nodes belong to.
    :vartype subnet: ~azure.mgmt.machinelearningservices.models.ResourceId
    :ivar application_sharing_policy: Policy for sharing applications on this compute instance
     among users of parent workspace. If Personal, only the creator can access applications on this
     compute instance. When Shared, any workspace user can access applications on this instance
     depending on his/her assigned role. Possible values include: "Personal", "Shared". Default
     value: "Shared".
    :vartype application_sharing_policy: str or
     ~azure.mgmt.machinelearningservices.models.ApplicationSharingPolicy
    :ivar autologger_settings: Specifies settings for autologger.
    :vartype autologger_settings:
     ~azure.mgmt.machinelearningservices.models.ComputeInstanceAutologgerSettings
    :ivar ssh_settings: Specifies policy and settings for SSH access.
    :vartype ssh_settings: ~azure.mgmt.machinelearningservices.models.ComputeInstanceSshSettings
    :ivar custom_services: List of Custom Services added to the compute.
    :vartype custom_services: list[~azure.mgmt.machinelearningservices.models.CustomService]
    :ivar os_image_metadata: Returns metadata about the operating system image for this compute
     instance.
    :vartype os_image_metadata: ~azure.mgmt.machinelearningservices.models.ImageMetadata
    :ivar connectivity_endpoints: Describes all connectivity endpoints available for this
     ComputeInstance.
    :vartype connectivity_endpoints:
     ~azure.mgmt.machinelearningservices.models.ComputeInstanceConnectivityEndpoints
    :ivar applications: Describes available applications and their endpoints on this
     ComputeInstance.
    :vartype applications:
     list[~azure.mgmt.machinelearningservices.models.ComputeInstanceApplication]
    :ivar created_by: Describes information on user who created this ComputeInstance.
    :vartype created_by: ~azure.mgmt.machinelearningservices.models.ComputeInstanceCreatedBy
    :ivar errors: Collection of errors encountered on this ComputeInstance.
    :vartype errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar state: The current state of this ComputeInstance. Possible values include: "Creating",
     "CreateFailed", "Deleting", "Running", "Restarting", "Resizing", "JobRunning", "SettingUp",
     "SetupFailed", "Starting", "Stopped", "Stopping", "UserSettingUp", "UserSetupFailed",
     "Unknown", "Unusable".
    :vartype state: str or ~azure.mgmt.machinelearningservices.models.ComputeInstanceState
    :ivar compute_instance_authorization_type: The Compute Instance Authorization type. Available
     values are personal (default). Possible values include: "personal". Default value: "personal".
    :vartype compute_instance_authorization_type: str or
     ~azure.mgmt.machinelearningservices.models.ComputeInstanceAuthorizationType
    :ivar enable_os_patching: Enable Auto OS Patching. Possible values are: true, false.
    :vartype enable_os_patching: bool
    :ivar enable_root_access: Enable root access. Possible values are: true, false.
    :vartype enable_root_access: bool
    :ivar enable_sso: Enable SSO (single sign on). Possible values are: true, false.
    :vartype enable_sso: bool
    :ivar release_quota_on_stop: Release quota if compute instance stopped. Possible values are:
     true - release quota if compute instance stopped. false - don't release quota when compute
     instance stopped.
    :vartype release_quota_on_stop: bool
    :ivar personal_compute_instance_settings: Settings for a personal compute instance.
    :vartype personal_compute_instance_settings:
     ~azure.mgmt.machinelearningservices.models.PersonalComputeInstanceSettings
    :ivar setup_scripts: Details of customized scripts to execute for setting up the cluster.
    :vartype setup_scripts: ~azure.mgmt.machinelearningservices.models.SetupScripts
    :ivar last_operation: The last operation on ComputeInstance.
    :vartype last_operation:
     ~azure.mgmt.machinelearningservices.models.ComputeInstanceLastOperation
    :ivar schedules: The list of schedules to be applied on the computes.
    :vartype schedules: ~azure.mgmt.machinelearningservices.models.ComputeSchedules
    :ivar idle_time_before_shutdown: Stops compute instance after user defined period of
     inactivity. Time is defined in ISO8601 format. Minimum is 15 min, maximum is 3 days.
    :vartype idle_time_before_shutdown: str
    :ivar enable_node_public_ip: Enable or disable node public IP address provisioning. Possible
     values are: Possible values are: true - Indicates that the compute nodes will have public IPs
     provisioned. false - Indicates that the compute nodes will have a private endpoint and no
     public IPs.
    :vartype enable_node_public_ip: bool
    :ivar containers: Describes informations of containers on this ComputeInstance.
    :vartype containers: list[~azure.mgmt.machinelearningservices.models.ComputeInstanceContainer]
    :ivar data_disks: Describes informations of dataDisks on this ComputeInstance.
    :vartype data_disks: list[~azure.mgmt.machinelearningservices.models.ComputeInstanceDataDisk]
    :ivar data_mounts: Describes informations of dataMounts on this ComputeInstance.
    :vartype data_mounts: list[~azure.mgmt.machinelearningservices.models.ComputeInstanceDataMount]
    :ivar versions: ComputeInstance version.
    :vartype versions: ~azure.mgmt.machinelearningservices.models.ComputeInstanceVersion
    """

    _validation = {
        'os_image_metadata': {'readonly': True},
        'connectivity_endpoints': {'readonly': True},
        'applications': {'readonly': True},
        'created_by': {'readonly': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'last_operation': {'readonly': True},
        'containers': {'readonly': True},
        'data_disks': {'readonly': True},
        'data_mounts': {'readonly': True},
        'versions': {'readonly': True},
    }

    _attribute_map = {
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'subnet': {'key': 'subnet', 'type': 'ResourceId'},
        'application_sharing_policy': {'key': 'applicationSharingPolicy', 'type': 'str'},
        'autologger_settings': {'key': 'autologgerSettings', 'type': 'ComputeInstanceAutologgerSettings'},
        'ssh_settings': {'key': 'sshSettings', 'type': 'ComputeInstanceSshSettings'},
        'custom_services': {'key': 'customServices', 'type': '[CustomService]'},
        'os_image_metadata': {'key': 'osImageMetadata', 'type': 'ImageMetadata'},
        'connectivity_endpoints': {'key': 'connectivityEndpoints', 'type': 'ComputeInstanceConnectivityEndpoints'},
        'applications': {'key': 'applications', 'type': '[ComputeInstanceApplication]'},
        'created_by': {'key': 'createdBy', 'type': 'ComputeInstanceCreatedBy'},
        'errors': {'key': 'errors', 'type': '[ErrorResponse]'},
        'state': {'key': 'state', 'type': 'str'},
        'compute_instance_authorization_type': {'key': 'computeInstanceAuthorizationType', 'type': 'str'},
        'enable_os_patching': {'key': 'enableOSPatching', 'type': 'bool'},
        'enable_root_access': {'key': 'enableRootAccess', 'type': 'bool'},
        'enable_sso': {'key': 'enableSSO', 'type': 'bool'},
        'release_quota_on_stop': {'key': 'releaseQuotaOnStop', 'type': 'bool'},
        'personal_compute_instance_settings': {'key': 'personalComputeInstanceSettings', 'type': 'PersonalComputeInstanceSettings'},
        'setup_scripts': {'key': 'setupScripts', 'type': 'SetupScripts'},
        'last_operation': {'key': 'lastOperation', 'type': 'ComputeInstanceLastOperation'},
        'schedules': {'key': 'schedules', 'type': 'ComputeSchedules'},
        'idle_time_before_shutdown': {'key': 'idleTimeBeforeShutdown', 'type': 'str'},
        'enable_node_public_ip': {'key': 'enableNodePublicIp', 'type': 'bool'},
        'containers': {'key': 'containers', 'type': '[ComputeInstanceContainer]'},
        'data_disks': {'key': 'dataDisks', 'type': '[ComputeInstanceDataDisk]'},
        'data_mounts': {'key': 'dataMounts', 'type': '[ComputeInstanceDataMount]'},
        'versions': {'key': 'versions', 'type': 'ComputeInstanceVersion'},
    }

    def __init__(
        self,
        *,
        vm_size: Optional[str] = None,
        subnet: Optional["ResourceId"] = None,
        application_sharing_policy: Optional[Union[str, "ApplicationSharingPolicy"]] = "Shared",
        autologger_settings: Optional["ComputeInstanceAutologgerSettings"] = None,
        ssh_settings: Optional["ComputeInstanceSshSettings"] = None,
        custom_services: Optional[List["CustomService"]] = None,
        compute_instance_authorization_type: Optional[Union[str, "ComputeInstanceAuthorizationType"]] = "personal",
        enable_os_patching: Optional[bool] = False,
        enable_root_access: Optional[bool] = True,
        enable_sso: Optional[bool] = True,
        release_quota_on_stop: Optional[bool] = False,
        personal_compute_instance_settings: Optional["PersonalComputeInstanceSettings"] = None,
        setup_scripts: Optional["SetupScripts"] = None,
        schedules: Optional["ComputeSchedules"] = None,
        idle_time_before_shutdown: Optional[str] = None,
        enable_node_public_ip: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword vm_size: Virtual Machine Size.
        :paramtype vm_size: str
        :keyword subnet: Virtual network subnet resource ID the compute nodes belong to.
        :paramtype subnet: ~azure.mgmt.machinelearningservices.models.ResourceId
        :keyword application_sharing_policy: Policy for sharing applications on this compute instance
         among users of parent workspace. If Personal, only the creator can access applications on this
         compute instance. When Shared, any workspace user can access applications on this instance
         depending on his/her assigned role. Possible values include: "Personal", "Shared". Default
         value: "Shared".
        :paramtype application_sharing_policy: str or
         ~azure.mgmt.machinelearningservices.models.ApplicationSharingPolicy
        :keyword autologger_settings: Specifies settings for autologger.
        :paramtype autologger_settings:
         ~azure.mgmt.machinelearningservices.models.ComputeInstanceAutologgerSettings
        :keyword ssh_settings: Specifies policy and settings for SSH access.
        :paramtype ssh_settings: ~azure.mgmt.machinelearningservices.models.ComputeInstanceSshSettings
        :keyword custom_services: List of Custom Services added to the compute.
        :paramtype custom_services: list[~azure.mgmt.machinelearningservices.models.CustomService]
        :keyword compute_instance_authorization_type: The Compute Instance Authorization type.
         Available values are personal (default). Possible values include: "personal". Default value:
         "personal".
        :paramtype compute_instance_authorization_type: str or
         ~azure.mgmt.machinelearningservices.models.ComputeInstanceAuthorizationType
        :keyword enable_os_patching: Enable Auto OS Patching. Possible values are: true, false.
        :paramtype enable_os_patching: bool
        :keyword enable_root_access: Enable root access. Possible values are: true, false.
        :paramtype enable_root_access: bool
        :keyword enable_sso: Enable SSO (single sign on). Possible values are: true, false.
        :paramtype enable_sso: bool
        :keyword release_quota_on_stop: Release quota if compute instance stopped. Possible values are:
         true - release quota if compute instance stopped. false - don't release quota when compute
         instance stopped.
        :paramtype release_quota_on_stop: bool
        :keyword personal_compute_instance_settings: Settings for a personal compute instance.
        :paramtype personal_compute_instance_settings:
         ~azure.mgmt.machinelearningservices.models.PersonalComputeInstanceSettings
        :keyword setup_scripts: Details of customized scripts to execute for setting up the cluster.
        :paramtype setup_scripts: ~azure.mgmt.machinelearningservices.models.SetupScripts
        :keyword schedules: The list of schedules to be applied on the computes.
        :paramtype schedules: ~azure.mgmt.machinelearningservices.models.ComputeSchedules
        :keyword idle_time_before_shutdown: Stops compute instance after user defined period of
         inactivity. Time is defined in ISO8601 format. Minimum is 15 min, maximum is 3 days.
        :paramtype idle_time_before_shutdown: str
        :keyword enable_node_public_ip: Enable or disable node public IP address provisioning. Possible
         values are: Possible values are: true - Indicates that the compute nodes will have public IPs
         provisioned. false - Indicates that the compute nodes will have a private endpoint and no
         public IPs.
        :paramtype enable_node_public_ip: bool
        """
        super(ComputeInstanceProperties, self).__init__(**kwargs)
        self.vm_size = vm_size
        self.subnet = subnet
        self.application_sharing_policy = application_sharing_policy
        self.autologger_settings = autologger_settings
        self.ssh_settings = ssh_settings
        self.custom_services = custom_services
        self.os_image_metadata = None
        self.connectivity_endpoints = None
        self.applications = None
        self.created_by = None
        self.errors = None
        self.state = None
        self.compute_instance_authorization_type = compute_instance_authorization_type
        self.enable_os_patching = enable_os_patching
        self.enable_root_access = enable_root_access
        self.enable_sso = enable_sso
        self.release_quota_on_stop = release_quota_on_stop
        self.personal_compute_instance_settings = personal_compute_instance_settings
        self.setup_scripts = setup_scripts
        self.last_operation = None
        self.schedules = schedules
        self.idle_time_before_shutdown = idle_time_before_shutdown
        self.enable_node_public_ip = enable_node_public_ip
        self.containers = None
        self.data_disks = None
        self.data_mounts = None
        self.versions = None


class ComputeInstanceSshSettings(msrest.serialization.Model):
    """Specifies policy and settings for SSH access.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar ssh_public_access: State of the public SSH port. Possible values are: Disabled -
     Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the
     public ssh port is open and accessible according to the VNet/subnet policy if applicable.
     Possible values include: "Enabled", "Disabled". Default value: "Disabled".
    :vartype ssh_public_access: str or ~azure.mgmt.machinelearningservices.models.SshPublicAccess
    :ivar admin_user_name: Describes the admin user name.
    :vartype admin_user_name: str
    :ivar ssh_port: Describes the port for connecting through SSH.
    :vartype ssh_port: int
    :ivar admin_public_key: Specifies the SSH rsa public key file as a string. Use "ssh-keygen -t
     rsa -b 2048" to generate your SSH key pairs.
    :vartype admin_public_key: str
    """

    _validation = {
        'admin_user_name': {'readonly': True},
        'ssh_port': {'readonly': True},
    }

    _attribute_map = {
        'ssh_public_access': {'key': 'sshPublicAccess', 'type': 'str'},
        'admin_user_name': {'key': 'adminUserName', 'type': 'str'},
        'ssh_port': {'key': 'sshPort', 'type': 'int'},
        'admin_public_key': {'key': 'adminPublicKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ssh_public_access: Optional[Union[str, "SshPublicAccess"]] = "Disabled",
        admin_public_key: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword ssh_public_access: State of the public SSH port. Possible values are: Disabled -
         Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the
         public ssh port is open and accessible according to the VNet/subnet policy if applicable.
         Possible values include: "Enabled", "Disabled". Default value: "Disabled".
        :paramtype ssh_public_access: str or ~azure.mgmt.machinelearningservices.models.SshPublicAccess
        :keyword admin_public_key: Specifies the SSH rsa public key file as a string. Use "ssh-keygen
         -t rsa -b 2048" to generate your SSH key pairs.
        :paramtype admin_public_key: str
        """
        super(ComputeInstanceSshSettings, self).__init__(**kwargs)
        self.ssh_public_access = ssh_public_access
        self.admin_user_name = None
        self.ssh_port = None
        self.admin_public_key = admin_public_key


class ComputeInstanceVersion(msrest.serialization.Model):
    """Version of computeInstance.

    :ivar runtime: Runtime of compute instance.
    :vartype runtime: str
    """

    _attribute_map = {
        'runtime': {'key': 'runtime', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        runtime: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword runtime: Runtime of compute instance.
        :paramtype runtime: str
        """
        super(ComputeInstanceVersion, self).__init__(**kwargs)
        self.runtime = runtime


class ComputeRecurrenceSchedule(msrest.serialization.Model):
    """ComputeRecurrenceSchedule.

    All required parameters must be populated in order to send to Azure.

    :ivar hours: Required. [Required] List of hours for the schedule.
    :vartype hours: list[int]
    :ivar minutes: Required. [Required] List of minutes for the schedule.
    :vartype minutes: list[int]
    :ivar month_days: List of month days for the schedule.
    :vartype month_days: list[int]
    :ivar week_days: List of days for the schedule.
    :vartype week_days: list[str or ~azure.mgmt.machinelearningservices.models.ComputeWeekDay]
    """

    _validation = {
        'hours': {'required': True},
        'minutes': {'required': True},
    }

    _attribute_map = {
        'hours': {'key': 'hours', 'type': '[int]'},
        'minutes': {'key': 'minutes', 'type': '[int]'},
        'month_days': {'key': 'monthDays', 'type': '[int]'},
        'week_days': {'key': 'weekDays', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        hours: List[int],
        minutes: List[int],
        month_days: Optional[List[int]] = None,
        week_days: Optional[List[Union[str, "ComputeWeekDay"]]] = None,
        **kwargs
    ):
        """
        :keyword hours: Required. [Required] List of hours for the schedule.
        :paramtype hours: list[int]
        :keyword minutes: Required. [Required] List of minutes for the schedule.
        :paramtype minutes: list[int]
        :keyword month_days: List of month days for the schedule.
        :paramtype month_days: list[int]
        :keyword week_days: List of days for the schedule.
        :paramtype week_days: list[str or ~azure.mgmt.machinelearningservices.models.ComputeWeekDay]
        """
        super(ComputeRecurrenceSchedule, self).__init__(**kwargs)
        self.hours = hours
        self.minutes = minutes
        self.month_days = month_days
        self.week_days = week_days


class ComputeResourceSchema(msrest.serialization.Model):
    """ComputeResourceSchema.

    :ivar properties: Compute properties.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.Compute
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'Compute'},
    }

    def __init__(
        self,
        *,
        properties: Optional["Compute"] = None,
        **kwargs
    ):
        """
        :keyword properties: Compute properties.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.Compute
        """
        super(ComputeResourceSchema, self).__init__(**kwargs)
        self.properties = properties


class ComputeResource(Resource, ComputeResourceSchema):
    """Machine Learning compute object wrapped into ARM resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar properties: Compute properties.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.Compute
    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar location: Specifies the location of the resource.
    :vartype location: str
    :ivar tags: A set of tags. Contains resource tags defined as key/value pairs.
    :vartype tags: dict[str, str]
    :ivar sku: The sku of the workspace.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'Compute'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(
        self,
        *,
        properties: Optional["Compute"] = None,
        identity: Optional["ManagedServiceIdentity"] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        **kwargs
    ):
        """
        :keyword properties: Compute properties.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.Compute
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword location: Specifies the location of the resource.
        :paramtype location: str
        :keyword tags: A set of tags. Contains resource tags defined as key/value pairs.
        :paramtype tags: dict[str, str]
        :keyword sku: The sku of the workspace.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        """
        super(ComputeResource, self).__init__(properties=properties, **kwargs)
        self.properties = properties
        self.identity = identity
        self.location = location
        self.tags = tags
        self.sku = sku
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ComputeRuntimeDto(msrest.serialization.Model):
    """ComputeRuntimeDto.

    :ivar spark_runtime_version:
    :vartype spark_runtime_version: str
    """

    _attribute_map = {
        'spark_runtime_version': {'key': 'sparkRuntimeVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        spark_runtime_version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword spark_runtime_version:
        :paramtype spark_runtime_version: str
        """
        super(ComputeRuntimeDto, self).__init__(**kwargs)
        self.spark_runtime_version = spark_runtime_version


class ComputeSchedules(msrest.serialization.Model):
    """The list of schedules to be applied on the computes.

    :ivar compute_start_stop: The list of compute start stop schedules to be applied.
    :vartype compute_start_stop:
     list[~azure.mgmt.machinelearningservices.models.ComputeStartStopSchedule]
    """

    _attribute_map = {
        'compute_start_stop': {'key': 'computeStartStop', 'type': '[ComputeStartStopSchedule]'},
    }

    def __init__(
        self,
        *,
        compute_start_stop: Optional[List["ComputeStartStopSchedule"]] = None,
        **kwargs
    ):
        """
        :keyword compute_start_stop: The list of compute start stop schedules to be applied.
        :paramtype compute_start_stop:
         list[~azure.mgmt.machinelearningservices.models.ComputeStartStopSchedule]
        """
        super(ComputeSchedules, self).__init__(**kwargs)
        self.compute_start_stop = compute_start_stop


class ComputeStartStopSchedule(msrest.serialization.Model):
    """Compute start stop schedule properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: A system assigned id for the schedule.
    :vartype id: str
    :ivar provisioning_status: The current deployment state of schedule. Possible values include:
     "Completed", "Provisioning", "Failed".
    :vartype provisioning_status: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningStatus
    :ivar status: Is the schedule enabled or disabled?. Possible values include: "Enabled",
     "Disabled".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.ScheduleStatus
    :ivar action: [Required] The compute power action. Possible values include: "Start", "Stop".
    :vartype action: str or ~azure.mgmt.machinelearningservices.models.ComputePowerAction
    :ivar trigger_type: [Required] The schedule trigger type. Possible values include:
     "Recurrence", "Cron".
    :vartype trigger_type: str or ~azure.mgmt.machinelearningservices.models.ComputeTriggerType
    :ivar recurrence: Required if triggerType is Recurrence.
    :vartype recurrence: ~azure.mgmt.machinelearningservices.models.Recurrence
    :ivar cron: Required if triggerType is Cron.
    :vartype cron: ~azure.mgmt.machinelearningservices.models.Cron
    :ivar schedule: [Deprecated] Not used any more.
    :vartype schedule: ~azure.mgmt.machinelearningservices.models.ScheduleBase
    """

    _validation = {
        'id': {'readonly': True},
        'provisioning_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'provisioning_status': {'key': 'provisioningStatus', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
        'trigger_type': {'key': 'triggerType', 'type': 'str'},
        'recurrence': {'key': 'recurrence', 'type': 'Recurrence'},
        'cron': {'key': 'cron', 'type': 'Cron'},
        'schedule': {'key': 'schedule', 'type': 'ScheduleBase'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "ScheduleStatus"]] = None,
        action: Optional[Union[str, "ComputePowerAction"]] = None,
        trigger_type: Optional[Union[str, "ComputeTriggerType"]] = None,
        recurrence: Optional["Recurrence"] = None,
        cron: Optional["Cron"] = None,
        schedule: Optional["ScheduleBase"] = None,
        **kwargs
    ):
        """
        :keyword status: Is the schedule enabled or disabled?. Possible values include: "Enabled",
         "Disabled".
        :paramtype status: str or ~azure.mgmt.machinelearningservices.models.ScheduleStatus
        :keyword action: [Required] The compute power action. Possible values include: "Start", "Stop".
        :paramtype action: str or ~azure.mgmt.machinelearningservices.models.ComputePowerAction
        :keyword trigger_type: [Required] The schedule trigger type. Possible values include:
         "Recurrence", "Cron".
        :paramtype trigger_type: str or ~azure.mgmt.machinelearningservices.models.ComputeTriggerType
        :keyword recurrence: Required if triggerType is Recurrence.
        :paramtype recurrence: ~azure.mgmt.machinelearningservices.models.Recurrence
        :keyword cron: Required if triggerType is Cron.
        :paramtype cron: ~azure.mgmt.machinelearningservices.models.Cron
        :keyword schedule: [Deprecated] Not used any more.
        :paramtype schedule: ~azure.mgmt.machinelearningservices.models.ScheduleBase
        """
        super(ComputeStartStopSchedule, self).__init__(**kwargs)
        self.id = None
        self.provisioning_status = None
        self.status = status
        self.action = action
        self.trigger_type = trigger_type
        self.recurrence = recurrence
        self.cron = cron
        self.schedule = schedule


class ContainerResourceRequirements(msrest.serialization.Model):
    """Resource requirements for each container instance within an online deployment.

    :ivar container_resource_limits: Container resource limit info:.
    :vartype container_resource_limits:
     ~azure.mgmt.machinelearningservices.models.ContainerResourceSettings
    :ivar container_resource_requests: Container resource request info:.
    :vartype container_resource_requests:
     ~azure.mgmt.machinelearningservices.models.ContainerResourceSettings
    """

    _attribute_map = {
        'container_resource_limits': {'key': 'containerResourceLimits', 'type': 'ContainerResourceSettings'},
        'container_resource_requests': {'key': 'containerResourceRequests', 'type': 'ContainerResourceSettings'},
    }

    def __init__(
        self,
        *,
        container_resource_limits: Optional["ContainerResourceSettings"] = None,
        container_resource_requests: Optional["ContainerResourceSettings"] = None,
        **kwargs
    ):
        """
        :keyword container_resource_limits: Container resource limit info:.
        :paramtype container_resource_limits:
         ~azure.mgmt.machinelearningservices.models.ContainerResourceSettings
        :keyword container_resource_requests: Container resource request info:.
        :paramtype container_resource_requests:
         ~azure.mgmt.machinelearningservices.models.ContainerResourceSettings
        """
        super(ContainerResourceRequirements, self).__init__(**kwargs)
        self.container_resource_limits = container_resource_limits
        self.container_resource_requests = container_resource_requests


class ContainerResourceSettings(msrest.serialization.Model):
    """ContainerResourceSettings.

    :ivar cpu: Number of vCPUs request/limit for container. More info:
     https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
    :vartype cpu: str
    :ivar gpu: Number of Nvidia GPU cards request/limit for container. More info:
     https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
    :vartype gpu: str
    :ivar memory: Memory size request/limit for container. More info:
     https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
    :vartype memory: str
    """

    _attribute_map = {
        'cpu': {'key': 'cpu', 'type': 'str'},
        'gpu': {'key': 'gpu', 'type': 'str'},
        'memory': {'key': 'memory', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        cpu: Optional[str] = None,
        gpu: Optional[str] = None,
        memory: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword cpu: Number of vCPUs request/limit for container. More info:
         https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
        :paramtype cpu: str
        :keyword gpu: Number of Nvidia GPU cards request/limit for container. More info:
         https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
        :paramtype gpu: str
        :keyword memory: Memory size request/limit for container. More info:
         https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
        :paramtype memory: str
        """
        super(ContainerResourceSettings, self).__init__(**kwargs)
        self.cpu = cpu
        self.gpu = gpu
        self.memory = memory


class EndpointDeploymentResourceProperties(msrest.serialization.Model):
    """EndpointDeploymentResourceProperties.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ContentSafetyEndpointDeploymentResourceProperties, OpenAIEndpointDeploymentResourceProperties, SpeechEndpointDeploymentResourceProperties, ManagedOnlineEndpointDeploymentResourceProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar failure_reason: The failure reason if the creation failed.
    :vartype failure_reason: str
    :ivar provisioning_state: Read-only provision state status property. Possible values include:
     "NotStarted", "Failed", "Creating", "Updating", "Succeeded", "Deleting", "Accepted",
     "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.DefaultResourceProvisioningState
    :ivar type: Required. Kind of the deployment.Constant filled by server.
    :vartype type: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'type': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9._]'},
    }

    _attribute_map = {
        'failure_reason': {'key': 'failureReason', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'Azure.ContentSafety': 'ContentSafetyEndpointDeploymentResourceProperties', 'Azure.OpenAI': 'OpenAIEndpointDeploymentResourceProperties', 'Azure.Speech': 'SpeechEndpointDeploymentResourceProperties', 'managedOnlineEndpoint': 'ManagedOnlineEndpointDeploymentResourceProperties'}
    }

    def __init__(
        self,
        *,
        failure_reason: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword failure_reason: The failure reason if the creation failed.
        :paramtype failure_reason: str
        """
        super(EndpointDeploymentResourceProperties, self).__init__(**kwargs)
        self.failure_reason = failure_reason
        self.provisioning_state = None
        self.type = None  # type: Optional[str]


class ContentSafetyEndpointDeploymentResourceProperties(EndpointDeploymentResourceProperties, CognitiveServiceEndpointDeploymentResourceProperties):
    """ContentSafetyEndpointDeploymentResourceProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar model: Required. Model used for the endpoint deployment.
    :vartype model: ~azure.mgmt.machinelearningservices.models.EndpointDeploymentModel
    :ivar rai_policy_name: The name of RAI policy.
    :vartype rai_policy_name: str
    :ivar sku:
    :vartype sku: ~azure.mgmt.machinelearningservices.models.CognitiveServicesSku
    :ivar version_upgrade_option: Deployment model version upgrade option. Possible values include:
     "OnceNewDefaultVersionAvailable", "OnceCurrentVersionExpired", "NoAutoUpgrade".
    :vartype version_upgrade_option: str or
     ~azure.mgmt.machinelearningservices.models.DeploymentModelVersionUpgradeOption
    :ivar failure_reason: The failure reason if the creation failed.
    :vartype failure_reason: str
    :ivar provisioning_state: Read-only provision state status property. Possible values include:
     "NotStarted", "Failed", "Creating", "Updating", "Succeeded", "Deleting", "Accepted",
     "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.DefaultResourceProvisioningState
    :ivar type: Required. Kind of the deployment.Constant filled by server.
    :vartype type: str
    """

    _validation = {
        'model': {'required': True},
        'provisioning_state': {'readonly': True},
        'type': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9._]'},
    }

    _attribute_map = {
        'model': {'key': 'model', 'type': 'EndpointDeploymentModel'},
        'rai_policy_name': {'key': 'raiPolicyName', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'CognitiveServicesSku'},
        'version_upgrade_option': {'key': 'versionUpgradeOption', 'type': 'str'},
        'failure_reason': {'key': 'failureReason', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        model: "EndpointDeploymentModel",
        rai_policy_name: Optional[str] = None,
        sku: Optional["CognitiveServicesSku"] = None,
        version_upgrade_option: Optional[Union[str, "DeploymentModelVersionUpgradeOption"]] = None,
        failure_reason: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword model: Required. Model used for the endpoint deployment.
        :paramtype model: ~azure.mgmt.machinelearningservices.models.EndpointDeploymentModel
        :keyword rai_policy_name: The name of RAI policy.
        :paramtype rai_policy_name: str
        :keyword sku:
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.CognitiveServicesSku
        :keyword version_upgrade_option: Deployment model version upgrade option. Possible values
         include: "OnceNewDefaultVersionAvailable", "OnceCurrentVersionExpired", "NoAutoUpgrade".
        :paramtype version_upgrade_option: str or
         ~azure.mgmt.machinelearningservices.models.DeploymentModelVersionUpgradeOption
        :keyword failure_reason: The failure reason if the creation failed.
        :paramtype failure_reason: str
        """
        super(ContentSafetyEndpointDeploymentResourceProperties, self).__init__(failure_reason=failure_reason, model=model, rai_policy_name=rai_policy_name, sku=sku, version_upgrade_option=version_upgrade_option, **kwargs)
        self.model = model
        self.rai_policy_name = rai_policy_name
        self.sku = sku
        self.version_upgrade_option = version_upgrade_option
        self.type = 'Azure.ContentSafety'  # type: str
        self.failure_reason = failure_reason
        self.provisioning_state = None


class EndpointResourceProperties(msrest.serialization.Model):
    """EndpointResourceProperties.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ContentSafetyEndpointResourceProperties, OpenAIEndpointResourceProperties, SpeechEndpointResourceProperties, ManagedOnlineEndpointResourceProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar associated_resource_id: Byo resource id for creating the built-in model service
     endpoints.
    :vartype associated_resource_id: str
    :ivar endpoint_type: Required. Type of the endpoint.Constant filled by server. Possible values
     include: "Azure.OpenAI", "Azure.Speech", "Azure.ContentSafety", "Azure.Llama",
     "managedOnlineEndpoint".
    :vartype endpoint_type: str or ~azure.mgmt.machinelearningservices.models.EndpointType
    :ivar endpoint_uri: Uri of the endpoint.
    :vartype endpoint_uri: str
    :ivar failure_reason: The failure reason if the creation failed.
    :vartype failure_reason: str
    :ivar name: Name of the endpoint.
    :vartype name: str
    :ivar provisioning_state: Read-only provision state status property. Possible values include:
     "NotStarted", "Failed", "Creating", "Updating", "Succeeded", "Deleting", "Accepted",
     "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.DefaultResourceProvisioningState
    :ivar should_create_ai_services_endpoint: Whether the proxy (non-byo) endpoint is a regular
     endpoint or a OneKeyV2 AI services account endpoint.
    :vartype should_create_ai_services_endpoint: bool
    """

    _validation = {
        'endpoint_type': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'associated_resource_id': {'key': 'associatedResourceId', 'type': 'str'},
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'endpoint_uri': {'key': 'endpointUri', 'type': 'str'},
        'failure_reason': {'key': 'failureReason', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'should_create_ai_services_endpoint': {'key': 'shouldCreateAiServicesEndpoint', 'type': 'bool'},
    }

    _subtype_map = {
        'endpoint_type': {'Azure.ContentSafety': 'ContentSafetyEndpointResourceProperties', 'Azure.OpenAI': 'OpenAIEndpointResourceProperties', 'Azure.Speech': 'SpeechEndpointResourceProperties', 'managedOnlineEndpoint': 'ManagedOnlineEndpointResourceProperties'}
    }

    def __init__(
        self,
        *,
        associated_resource_id: Optional[str] = None,
        endpoint_uri: Optional[str] = None,
        failure_reason: Optional[str] = None,
        name: Optional[str] = None,
        should_create_ai_services_endpoint: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword associated_resource_id: Byo resource id for creating the built-in model service
         endpoints.
        :paramtype associated_resource_id: str
        :keyword endpoint_uri: Uri of the endpoint.
        :paramtype endpoint_uri: str
        :keyword failure_reason: The failure reason if the creation failed.
        :paramtype failure_reason: str
        :keyword name: Name of the endpoint.
        :paramtype name: str
        :keyword should_create_ai_services_endpoint: Whether the proxy (non-byo) endpoint is a regular
         endpoint or a OneKeyV2 AI services account endpoint.
        :paramtype should_create_ai_services_endpoint: bool
        """
        super(EndpointResourceProperties, self).__init__(**kwargs)
        self.associated_resource_id = associated_resource_id
        self.endpoint_type = None  # type: Optional[str]
        self.endpoint_uri = endpoint_uri
        self.failure_reason = failure_reason
        self.name = name
        self.provisioning_state = None
        self.should_create_ai_services_endpoint = should_create_ai_services_endpoint


class ContentSafetyEndpointResourceProperties(EndpointResourceProperties):
    """ContentSafetyEndpointResourceProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar associated_resource_id: Byo resource id for creating the built-in model service
     endpoints.
    :vartype associated_resource_id: str
    :ivar endpoint_type: Required. Type of the endpoint.Constant filled by server. Possible values
     include: "Azure.OpenAI", "Azure.Speech", "Azure.ContentSafety", "Azure.Llama",
     "managedOnlineEndpoint".
    :vartype endpoint_type: str or ~azure.mgmt.machinelearningservices.models.EndpointType
    :ivar endpoint_uri: Uri of the endpoint.
    :vartype endpoint_uri: str
    :ivar failure_reason: The failure reason if the creation failed.
    :vartype failure_reason: str
    :ivar name: Name of the endpoint.
    :vartype name: str
    :ivar provisioning_state: Read-only provision state status property. Possible values include:
     "NotStarted", "Failed", "Creating", "Updating", "Succeeded", "Deleting", "Accepted",
     "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.DefaultResourceProvisioningState
    :ivar should_create_ai_services_endpoint: Whether the proxy (non-byo) endpoint is a regular
     endpoint or a OneKeyV2 AI services account endpoint.
    :vartype should_create_ai_services_endpoint: bool
    """

    _validation = {
        'endpoint_type': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'associated_resource_id': {'key': 'associatedResourceId', 'type': 'str'},
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'endpoint_uri': {'key': 'endpointUri', 'type': 'str'},
        'failure_reason': {'key': 'failureReason', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'should_create_ai_services_endpoint': {'key': 'shouldCreateAiServicesEndpoint', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        associated_resource_id: Optional[str] = None,
        endpoint_uri: Optional[str] = None,
        failure_reason: Optional[str] = None,
        name: Optional[str] = None,
        should_create_ai_services_endpoint: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword associated_resource_id: Byo resource id for creating the built-in model service
         endpoints.
        :paramtype associated_resource_id: str
        :keyword endpoint_uri: Uri of the endpoint.
        :paramtype endpoint_uri: str
        :keyword failure_reason: The failure reason if the creation failed.
        :paramtype failure_reason: str
        :keyword name: Name of the endpoint.
        :paramtype name: str
        :keyword should_create_ai_services_endpoint: Whether the proxy (non-byo) endpoint is a regular
         endpoint or a OneKeyV2 AI services account endpoint.
        :paramtype should_create_ai_services_endpoint: bool
        """
        super(ContentSafetyEndpointResourceProperties, self).__init__(associated_resource_id=associated_resource_id, endpoint_uri=endpoint_uri, failure_reason=failure_reason, name=name, should_create_ai_services_endpoint=should_create_ai_services_endpoint, **kwargs)
        self.endpoint_type = 'Azure.ContentSafety'  # type: str


class CosmosDbSettings(msrest.serialization.Model):
    """CosmosDbSettings.

    :ivar collections_throughput:
    :vartype collections_throughput: int
    """

    _attribute_map = {
        'collections_throughput': {'key': 'collectionsThroughput', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        collections_throughput: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword collections_throughput:
        :paramtype collections_throughput: int
        """
        super(CosmosDbSettings, self).__init__(**kwargs)
        self.collections_throughput = collections_throughput


class ScheduleActionBase(msrest.serialization.Model):
    """ScheduleActionBase.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: JobScheduleAction, CreateMonitorAction, ImportDataAction, EndpointScheduleAction.

    All required parameters must be populated in order to send to Azure.

    :ivar action_type: Required. [Required] Specifies the action type of the schedule.Constant
     filled by server. Possible values include: "CreateJob", "InvokeBatchEndpoint", "ImportData",
     "CreateMonitor".
    :vartype action_type: str or ~azure.mgmt.machinelearningservices.models.ScheduleActionType
    """

    _validation = {
        'action_type': {'required': True},
    }

    _attribute_map = {
        'action_type': {'key': 'actionType', 'type': 'str'},
    }

    _subtype_map = {
        'action_type': {'CreateJob': 'JobScheduleAction', 'CreateMonitor': 'CreateMonitorAction', 'ImportData': 'ImportDataAction', 'InvokeBatchEndpoint': 'EndpointScheduleAction'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ScheduleActionBase, self).__init__(**kwargs)
        self.action_type = None  # type: Optional[str]


class CreateMonitorAction(ScheduleActionBase):
    """CreateMonitorAction.

    All required parameters must be populated in order to send to Azure.

    :ivar action_type: Required. [Required] Specifies the action type of the schedule.Constant
     filled by server. Possible values include: "CreateJob", "InvokeBatchEndpoint", "ImportData",
     "CreateMonitor".
    :vartype action_type: str or ~azure.mgmt.machinelearningservices.models.ScheduleActionType
    :ivar monitor_definition: Required. [Required] Defines the monitor.
    :vartype monitor_definition: ~azure.mgmt.machinelearningservices.models.MonitorDefinition
    """

    _validation = {
        'action_type': {'required': True},
        'monitor_definition': {'required': True},
    }

    _attribute_map = {
        'action_type': {'key': 'actionType', 'type': 'str'},
        'monitor_definition': {'key': 'monitorDefinition', 'type': 'MonitorDefinition'},
    }

    def __init__(
        self,
        *,
        monitor_definition: "MonitorDefinition",
        **kwargs
    ):
        """
        :keyword monitor_definition: Required. [Required] Defines the monitor.
        :paramtype monitor_definition: ~azure.mgmt.machinelearningservices.models.MonitorDefinition
        """
        super(CreateMonitorAction, self).__init__(**kwargs)
        self.action_type = 'CreateMonitor'  # type: str
        self.monitor_definition = monitor_definition


class Cron(msrest.serialization.Model):
    """The workflow trigger cron for ComputeStartStop schedule type.

    :ivar start_time: The start time in yyyy-MM-ddTHH:mm:ss format.
    :vartype start_time: str
    :ivar time_zone: Specifies time zone in which the schedule runs.
     TimeZone should follow Windows time zone format. Refer:
     https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11.
    :vartype time_zone: str
    :ivar expression: [Required] Specifies cron expression of schedule.
     The expression should follow NCronTab format.
    :vartype expression: str
    """

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'str'},
        'time_zone': {'key': 'timeZone', 'type': 'str'},
        'expression': {'key': 'expression', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        start_time: Optional[str] = None,
        time_zone: Optional[str] = "UTC",
        expression: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword start_time: The start time in yyyy-MM-ddTHH:mm:ss format.
        :paramtype start_time: str
        :keyword time_zone: Specifies time zone in which the schedule runs.
         TimeZone should follow Windows time zone format. Refer:
         https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11.
        :paramtype time_zone: str
        :keyword expression: [Required] Specifies cron expression of schedule.
         The expression should follow NCronTab format.
        :paramtype expression: str
        """
        super(Cron, self).__init__(**kwargs)
        self.start_time = start_time
        self.time_zone = time_zone
        self.expression = expression


class TriggerBase(msrest.serialization.Model):
    """TriggerBase.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CronTrigger, RecurrenceTrigger.

    All required parameters must be populated in order to send to Azure.

    :ivar end_time: Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer
     https://en.wikipedia.org/wiki/ISO_8601.
     Recommented format would be "2022-06-01T00:00:01"
     If not present, the schedule will run indefinitely.
    :vartype end_time: str
    :ivar start_time: Specifies start time of schedule in ISO 8601 format, but without a UTC
     offset.
    :vartype start_time: str
    :ivar time_zone: Specifies time zone in which the schedule runs.
     TimeZone should follow Windows time zone format. Refer:
     https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11.
    :vartype time_zone: str
    :ivar trigger_type: Required. [Required].Constant filled by server. Possible values include:
     "Recurrence", "Cron".
    :vartype trigger_type: str or ~azure.mgmt.machinelearningservices.models.TriggerType
    """

    _validation = {
        'trigger_type': {'required': True},
    }

    _attribute_map = {
        'end_time': {'key': 'endTime', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'time_zone': {'key': 'timeZone', 'type': 'str'},
        'trigger_type': {'key': 'triggerType', 'type': 'str'},
    }

    _subtype_map = {
        'trigger_type': {'Cron': 'CronTrigger', 'Recurrence': 'RecurrenceTrigger'}
    }

    def __init__(
        self,
        *,
        end_time: Optional[str] = None,
        start_time: Optional[str] = None,
        time_zone: Optional[str] = "UTC",
        **kwargs
    ):
        """
        :keyword end_time: Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer
         https://en.wikipedia.org/wiki/ISO_8601.
         Recommented format would be "2022-06-01T00:00:01"
         If not present, the schedule will run indefinitely.
        :paramtype end_time: str
        :keyword start_time: Specifies start time of schedule in ISO 8601 format, but without a UTC
         offset.
        :paramtype start_time: str
        :keyword time_zone: Specifies time zone in which the schedule runs.
         TimeZone should follow Windows time zone format. Refer:
         https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11.
        :paramtype time_zone: str
        """
        super(TriggerBase, self).__init__(**kwargs)
        self.end_time = end_time
        self.start_time = start_time
        self.time_zone = time_zone
        self.trigger_type = None  # type: Optional[str]


class CronTrigger(TriggerBase):
    """CronTrigger.

    All required parameters must be populated in order to send to Azure.

    :ivar end_time: Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer
     https://en.wikipedia.org/wiki/ISO_8601.
     Recommented format would be "2022-06-01T00:00:01"
     If not present, the schedule will run indefinitely.
    :vartype end_time: str
    :ivar start_time: Specifies start time of schedule in ISO 8601 format, but without a UTC
     offset.
    :vartype start_time: str
    :ivar time_zone: Specifies time zone in which the schedule runs.
     TimeZone should follow Windows time zone format. Refer:
     https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11.
    :vartype time_zone: str
    :ivar trigger_type: Required. [Required].Constant filled by server. Possible values include:
     "Recurrence", "Cron".
    :vartype trigger_type: str or ~azure.mgmt.machinelearningservices.models.TriggerType
    :ivar expression: Required. [Required] Specifies cron expression of schedule.
     The expression should follow NCronTab format.
    :vartype expression: str
    """

    _validation = {
        'trigger_type': {'required': True},
        'expression': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'end_time': {'key': 'endTime', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'time_zone': {'key': 'timeZone', 'type': 'str'},
        'trigger_type': {'key': 'triggerType', 'type': 'str'},
        'expression': {'key': 'expression', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        expression: str,
        end_time: Optional[str] = None,
        start_time: Optional[str] = None,
        time_zone: Optional[str] = "UTC",
        **kwargs
    ):
        """
        :keyword end_time: Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer
         https://en.wikipedia.org/wiki/ISO_8601.
         Recommented format would be "2022-06-01T00:00:01"
         If not present, the schedule will run indefinitely.
        :paramtype end_time: str
        :keyword start_time: Specifies start time of schedule in ISO 8601 format, but without a UTC
         offset.
        :paramtype start_time: str
        :keyword time_zone: Specifies time zone in which the schedule runs.
         TimeZone should follow Windows time zone format. Refer:
         https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11.
        :paramtype time_zone: str
        :keyword expression: Required. [Required] Specifies cron expression of schedule.
         The expression should follow NCronTab format.
        :paramtype expression: str
        """
        super(CronTrigger, self).__init__(end_time=end_time, start_time=start_time, time_zone=time_zone, **kwargs)
        self.trigger_type = 'Cron'  # type: str
        self.expression = expression


class CsvExportSummary(ExportSummary):
    """CsvExportSummary.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar end_date_time: The time when the export was completed.
    :vartype end_date_time: ~datetime.datetime
    :ivar exported_row_count: The total number of labeled datapoints exported.
    :vartype exported_row_count: long
    :ivar format: Required. [Required] The format of exported labels, also as the
     discriminator.Constant filled by server. Possible values include: "Dataset", "Coco", "CSV".
    :vartype format: str or ~azure.mgmt.machinelearningservices.models.ExportFormatType
    :ivar labeling_job_id: Name and identifier of the job containing exported labels.
    :vartype labeling_job_id: str
    :ivar start_date_time: The time when the export was requested.
    :vartype start_date_time: ~datetime.datetime
    :ivar container_name: The container name to which the labels will be exported.
    :vartype container_name: str
    :ivar snapshot_path: The output path where the labels will be exported.
    :vartype snapshot_path: str
    """

    _validation = {
        'end_date_time': {'readonly': True},
        'exported_row_count': {'readonly': True},
        'format': {'required': True},
        'labeling_job_id': {'readonly': True},
        'start_date_time': {'readonly': True},
        'container_name': {'readonly': True},
        'snapshot_path': {'readonly': True},
    }

    _attribute_map = {
        'end_date_time': {'key': 'endDateTime', 'type': 'iso-8601'},
        'exported_row_count': {'key': 'exportedRowCount', 'type': 'long'},
        'format': {'key': 'format', 'type': 'str'},
        'labeling_job_id': {'key': 'labelingJobId', 'type': 'str'},
        'start_date_time': {'key': 'startDateTime', 'type': 'iso-8601'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'snapshot_path': {'key': 'snapshotPath', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(CsvExportSummary, self).__init__(**kwargs)
        self.format = 'CSV'  # type: str
        self.container_name = None
        self.snapshot_path = None


class CustomForecastHorizon(ForecastHorizon):
    """The desired maximum forecast horizon in units of time-series frequency.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Set forecast horizon value selection mode.Constant filled by
     server. Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.ForecastHorizonMode
    :ivar value: Required. [Required] Forecast horizon value.
    :vartype value: int
    """

    _validation = {
        'mode': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'value': {'key': 'value', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        value: int,
        **kwargs
    ):
        """
        :keyword value: Required. [Required] Forecast horizon value.
        :paramtype value: int
        """
        super(CustomForecastHorizon, self).__init__(**kwargs)
        self.mode = 'Custom'  # type: str
        self.value = value


class CustomInferencingServer(InferencingServer):
    """Custom inference server configurations.

    All required parameters must be populated in order to send to Azure.

    :ivar server_type: Required. [Required] Inferencing server type for various targets.Constant
     filled by server. Possible values include: "AzureMLOnline", "AzureMLBatch", "Triton", "Custom".
    :vartype server_type: str or ~azure.mgmt.machinelearningservices.models.InferencingServerType
    :ivar inference_configuration: Inference configuration for custom inferencing.
    :vartype inference_configuration:
     ~azure.mgmt.machinelearningservices.models.OnlineInferenceConfiguration
    """

    _validation = {
        'server_type': {'required': True},
    }

    _attribute_map = {
        'server_type': {'key': 'serverType', 'type': 'str'},
        'inference_configuration': {'key': 'inferenceConfiguration', 'type': 'OnlineInferenceConfiguration'},
    }

    def __init__(
        self,
        *,
        inference_configuration: Optional["OnlineInferenceConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword inference_configuration: Inference configuration for custom inferencing.
        :paramtype inference_configuration:
         ~azure.mgmt.machinelearningservices.models.OnlineInferenceConfiguration
        """
        super(CustomInferencingServer, self).__init__(**kwargs)
        self.server_type = 'Custom'  # type: str
        self.inference_configuration = inference_configuration


class CustomKeys(msrest.serialization.Model):
    """Custom Keys credential object.

    :ivar keys: Dictionary of :code:`<string>`.
    :vartype keys: dict[str, str]
    """

    _attribute_map = {
        'keys': {'key': 'keys', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        keys: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword keys: Dictionary of :code:`<string>`.
        :paramtype keys: dict[str, str]
        """
        super(CustomKeys, self).__init__(**kwargs)
        self.keys = keys


class CustomKeysWorkspaceConnectionProperties(WorkspaceConnectionPropertiesV2):
    """Category:= CustomKeys
AuthType:= CustomKeys (as type discriminator)
Credentials:= {CustomKeys} as Microsoft.MachineLearning.AccountRP.Contracts.WorkspaceConnection.CustomKeys
Target:= {any value}
Use Metadata property bag for ApiVersion and other metadata fields.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. Authentication type of the connection target.Constant filled by
     server. Possible values include: "PAT", "ManagedIdentity", "UsernamePassword", "None", "SAS",
     "AccountKey", "ServicePrincipal", "AccessKey", "ApiKey", "CustomKeys", "OAuth2", "AAD".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection. Possible values include: "PythonFeed",
     "ContainerRegistry", "Git", "S3", "Snowflake", "AzureSqlDb", "AzureSynapseAnalytics",
     "AzureMySqlDb", "AzurePostgresDb", "ADLSGen2", "Redis", "ApiKey", "AzureOpenAI",
     "CognitiveSearch", "CognitiveService", "CustomKeys", "AzureBlob", "AzureOneLake", "CosmosDb",
     "CosmosDbMongoDbApi", "AzureDataExplorer", "AzureMariaDb", "AzureDatabricksDeltaLake",
     "AzureSqlMi", "AzureTableStorage", "AmazonRdsForOracle", "AmazonRdsForSqlServer",
     "AmazonRedshift", "Db2", "Drill", "GoogleBigQuery", "Greenplum", "Hbase", "Hive", "Impala",
     "Informix", "MariaDb", "MicrosoftAccess", "MySql", "Netezza", "Oracle", "Phoenix",
     "PostgreSql", "Presto", "SapOpenHub", "SapBw", "SapHana", "SapTable", "Spark", "SqlServer",
     "Sybase", "Teradata", "Vertica", "Cassandra", "Couchbase", "MongoDbV2", "MongoDbAtlas",
     "AmazonS3Compatible", "FileServer", "FtpServer", "GoogleCloudStorage", "Hdfs",
     "OracleCloudStorage", "Sftp", "GenericHttp", "ODataRest", "Odbc", "GenericRest", "AmazonMws",
     "Concur", "Dynamics", "DynamicsAx", "DynamicsCrm", "GoogleAdWords", "Hubspot", "Jira",
     "Magento", "Marketo", "Office365", "Eloqua", "Responsys", "OracleServiceCloud", "PayPal",
     "QuickBooks", "Salesforce", "SalesforceServiceCloud", "SalesforceMarketingCloud",
     "SapCloudForCustomer", "SapEcc", "ServiceNow", "SharePointOnlineList", "Shopify", "Square",
     "WebTable", "Xero", "Zoho", "GenericContainerRegistry", "OpenAI", "Serp", "BingLLMSearch",
     "Serverless".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
    :ivar created_by_workspace_arm_id:
    :vartype created_by_workspace_arm_id: str
    :ivar expiry_time:
    :vartype expiry_time: ~datetime.datetime
    :ivar group: Group based on connection category. Possible values include: "Azure", "AzureAI",
     "Database", "NoSQL", "File", "GenericProtocol", "ServicesAndApps".
    :vartype group: str or ~azure.mgmt.machinelearningservices.models.ConnectionGroup
    :ivar is_shared_to_all:
    :vartype is_shared_to_all: bool
    :ivar metadata: Store user metadata for this connection.
    :vartype metadata: dict[str, str]
    :ivar shared_user_list:
    :vartype shared_user_list: list[str]
    :ivar target:
    :vartype target: str
    :ivar credentials: Custom Keys credential object.
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.CustomKeys
    """

    _validation = {
        'auth_type': {'required': True},
        'created_by_workspace_arm_id': {'readonly': True},
        'group': {'readonly': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'created_by_workspace_arm_id': {'key': 'createdByWorkspaceArmId', 'type': 'str'},
        'expiry_time': {'key': 'expiryTime', 'type': 'iso-8601'},
        'group': {'key': 'group', 'type': 'str'},
        'is_shared_to_all': {'key': 'isSharedToAll', 'type': 'bool'},
        'metadata': {'key': 'metadata', 'type': '{str}'},
        'shared_user_list': {'key': 'sharedUserList', 'type': '[str]'},
        'target': {'key': 'target', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'CustomKeys'},
    }

    def __init__(
        self,
        *,
        category: Optional[Union[str, "ConnectionCategory"]] = None,
        expiry_time: Optional[datetime.datetime] = None,
        is_shared_to_all: Optional[bool] = None,
        metadata: Optional[Dict[str, str]] = None,
        shared_user_list: Optional[List[str]] = None,
        target: Optional[str] = None,
        credentials: Optional["CustomKeys"] = None,
        **kwargs
    ):
        """
        :keyword category: Category of the connection. Possible values include: "PythonFeed",
         "ContainerRegistry", "Git", "S3", "Snowflake", "AzureSqlDb", "AzureSynapseAnalytics",
         "AzureMySqlDb", "AzurePostgresDb", "ADLSGen2", "Redis", "ApiKey", "AzureOpenAI",
         "CognitiveSearch", "CognitiveService", "CustomKeys", "AzureBlob", "AzureOneLake", "CosmosDb",
         "CosmosDbMongoDbApi", "AzureDataExplorer", "AzureMariaDb", "AzureDatabricksDeltaLake",
         "AzureSqlMi", "AzureTableStorage", "AmazonRdsForOracle", "AmazonRdsForSqlServer",
         "AmazonRedshift", "Db2", "Drill", "GoogleBigQuery", "Greenplum", "Hbase", "Hive", "Impala",
         "Informix", "MariaDb", "MicrosoftAccess", "MySql", "Netezza", "Oracle", "Phoenix",
         "PostgreSql", "Presto", "SapOpenHub", "SapBw", "SapHana", "SapTable", "Spark", "SqlServer",
         "Sybase", "Teradata", "Vertica", "Cassandra", "Couchbase", "MongoDbV2", "MongoDbAtlas",
         "AmazonS3Compatible", "FileServer", "FtpServer", "GoogleCloudStorage", "Hdfs",
         "OracleCloudStorage", "Sftp", "GenericHttp", "ODataRest", "Odbc", "GenericRest", "AmazonMws",
         "Concur", "Dynamics", "DynamicsAx", "DynamicsCrm", "GoogleAdWords", "Hubspot", "Jira",
         "Magento", "Marketo", "Office365", "Eloqua", "Responsys", "OracleServiceCloud", "PayPal",
         "QuickBooks", "Salesforce", "SalesforceServiceCloud", "SalesforceMarketingCloud",
         "SapCloudForCustomer", "SapEcc", "ServiceNow", "SharePointOnlineList", "Shopify", "Square",
         "WebTable", "Xero", "Zoho", "GenericContainerRegistry", "OpenAI", "Serp", "BingLLMSearch",
         "Serverless".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
        :keyword expiry_time:
        :paramtype expiry_time: ~datetime.datetime
        :keyword is_shared_to_all:
        :paramtype is_shared_to_all: bool
        :keyword metadata: Store user metadata for this connection.
        :paramtype metadata: dict[str, str]
        :keyword shared_user_list:
        :paramtype shared_user_list: list[str]
        :keyword target:
        :paramtype target: str
        :keyword credentials: Custom Keys credential object.
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.CustomKeys
        """
        super(CustomKeysWorkspaceConnectionProperties, self).__init__(category=category, expiry_time=expiry_time, is_shared_to_all=is_shared_to_all, metadata=metadata, shared_user_list=shared_user_list, target=target, **kwargs)
        self.auth_type = 'CustomKeys'  # type: str
        self.credentials = credentials


class CustomMetricThreshold(msrest.serialization.Model):
    """CustomMetricThreshold.

    All required parameters must be populated in order to send to Azure.

    :ivar metric: Required. [Required] The user-defined metric to calculate.
    :vartype metric: str
    :ivar threshold: The threshold value. If null, a default value will be set depending on the
     selected metric.
    :vartype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
    """

    _validation = {
        'metric': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'metric': {'key': 'metric', 'type': 'str'},
        'threshold': {'key': 'threshold', 'type': 'MonitoringThreshold'},
    }

    def __init__(
        self,
        *,
        metric: str,
        threshold: Optional["MonitoringThreshold"] = None,
        **kwargs
    ):
        """
        :keyword metric: Required. [Required] The user-defined metric to calculate.
        :paramtype metric: str
        :keyword threshold: The threshold value. If null, a default value will be set depending on the
         selected metric.
        :paramtype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
        """
        super(CustomMetricThreshold, self).__init__(**kwargs)
        self.metric = metric
        self.threshold = threshold


class CustomModelFineTuning(FineTuningVertical):
    """CustomModelFineTuning.

    All required parameters must be populated in order to send to Azure.

    :ivar model: Required. [Required] Input model for fine tuning.
    :vartype model: ~azure.mgmt.machinelearningservices.models.MLFlowModelJobInput
    :ivar model_provider: Required. [Required] Enum to determine the type of fine tuning.Constant
     filled by server. Possible values include: "AzureOpenAI", "Custom".
    :vartype model_provider: str or ~azure.mgmt.machinelearningservices.models.ModelProvider
    :ivar task_type: Required. [Required] Fine tuning task type. Possible values include:
     "ChatCompletion", "TextCompletion", "TextClassification", "QuestionAnswering",
     "TextSummarization", "TokenClassification", "TextTranslation", "ImageClassification",
     "ImageInstanceSegmentation", "ImageObjectDetection", "VideoMultiObjectTracking".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.FineTuningTaskType
    :ivar training_data: Required. [Required] Training data for fine tuning.
    :vartype training_data: ~azure.mgmt.machinelearningservices.models.JobInput
    :ivar validation_data: Validation data for fine tuning.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.JobInput
    :ivar hyper_parameters: HyperParameters for fine tuning custom model.
    :vartype hyper_parameters: dict[str, str]
    """

    _validation = {
        'model': {'required': True},
        'model_provider': {'required': True},
        'task_type': {'required': True},
        'training_data': {'required': True},
    }

    _attribute_map = {
        'model': {'key': 'model', 'type': 'MLFlowModelJobInput'},
        'model_provider': {'key': 'modelProvider', 'type': 'str'},
        'task_type': {'key': 'taskType', 'type': 'str'},
        'training_data': {'key': 'trainingData', 'type': 'JobInput'},
        'validation_data': {'key': 'validationData', 'type': 'JobInput'},
        'hyper_parameters': {'key': 'hyperParameters', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        model: "MLFlowModelJobInput",
        task_type: Union[str, "FineTuningTaskType"],
        training_data: "JobInput",
        validation_data: Optional["JobInput"] = None,
        hyper_parameters: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword model: Required. [Required] Input model for fine tuning.
        :paramtype model: ~azure.mgmt.machinelearningservices.models.MLFlowModelJobInput
        :keyword task_type: Required. [Required] Fine tuning task type. Possible values include:
         "ChatCompletion", "TextCompletion", "TextClassification", "QuestionAnswering",
         "TextSummarization", "TokenClassification", "TextTranslation", "ImageClassification",
         "ImageInstanceSegmentation", "ImageObjectDetection", "VideoMultiObjectTracking".
        :paramtype task_type: str or ~azure.mgmt.machinelearningservices.models.FineTuningTaskType
        :keyword training_data: Required. [Required] Training data for fine tuning.
        :paramtype training_data: ~azure.mgmt.machinelearningservices.models.JobInput
        :keyword validation_data: Validation data for fine tuning.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.JobInput
        :keyword hyper_parameters: HyperParameters for fine tuning custom model.
        :paramtype hyper_parameters: dict[str, str]
        """
        super(CustomModelFineTuning, self).__init__(model=model, task_type=task_type, training_data=training_data, validation_data=validation_data, **kwargs)
        self.model_provider = 'Custom'  # type: str
        self.hyper_parameters = hyper_parameters


class JobInput(msrest.serialization.Model):
    """Command job definition.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CustomModelJobInput, LiteralJobInput, MLFlowModelJobInput, MLTableJobInput, TritonModelJobInput, UriFileJobInput, UriFolderJobInput.

    All required parameters must be populated in order to send to Azure.

    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "literal", "uri_file", "uri_folder", "mltable", "custom_model",
     "mlflow_model", "triton_model".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    """

    _validation = {
        'job_input_type': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'job_input_type': {'key': 'jobInputType', 'type': 'str'},
    }

    _subtype_map = {
        'job_input_type': {'custom_model': 'CustomModelJobInput', 'literal': 'LiteralJobInput', 'mlflow_model': 'MLFlowModelJobInput', 'mltable': 'MLTableJobInput', 'triton_model': 'TritonModelJobInput', 'uri_file': 'UriFileJobInput', 'uri_folder': 'UriFolderJobInput'}
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: Description for the input.
        :paramtype description: str
        """
        super(JobInput, self).__init__(**kwargs)
        self.description = description
        self.job_input_type = None  # type: Optional[str]


class CustomModelJobInput(JobInput, AssetJobInput):
    """CustomModelJobInput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
     "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
    :ivar path_on_compute: Input Asset Delivery Path.
    :vartype path_on_compute: str
    :ivar uri: Required. [Required] Input Asset URI.
    :vartype uri: str
    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "literal", "uri_file", "uri_folder", "mltable", "custom_model",
     "mlflow_model", "triton_model".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    """

    _validation = {
        'uri': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
        'job_input_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'path_on_compute': {'key': 'pathOnCompute', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_input_type': {'key': 'jobInputType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        uri: str,
        mode: Optional[Union[str, "InputDeliveryMode"]] = None,
        path_on_compute: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
         "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
        :keyword path_on_compute: Input Asset Delivery Path.
        :paramtype path_on_compute: str
        :keyword uri: Required. [Required] Input Asset URI.
        :paramtype uri: str
        :keyword description: Description for the input.
        :paramtype description: str
        """
        super(CustomModelJobInput, self).__init__(description=description, mode=mode, path_on_compute=path_on_compute, uri=uri, **kwargs)
        self.mode = mode
        self.path_on_compute = path_on_compute
        self.uri = uri
        self.job_input_type = 'custom_model'  # type: str
        self.description = description


class JobOutput(msrest.serialization.Model):
    """Job output definition container information on where to find job output/logs.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CustomModelJobOutput, MLFlowModelJobOutput, MLTableJobOutput, TritonModelJobOutput, UriFileJobOutput, UriFolderJobOutput.

    All required parameters must be populated in order to send to Azure.

    :ivar description: Description for the output.
    :vartype description: str
    :ivar job_output_type: Required. [Required] Specifies the type of job.Constant filled by
     server. Possible values include: "uri_file", "uri_folder", "mltable", "custom_model",
     "mlflow_model", "triton_model".
    :vartype job_output_type: str or ~azure.mgmt.machinelearningservices.models.JobOutputType
    """

    _validation = {
        'job_output_type': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'job_output_type': {'key': 'jobOutputType', 'type': 'str'},
    }

    _subtype_map = {
        'job_output_type': {'custom_model': 'CustomModelJobOutput', 'mlflow_model': 'MLFlowModelJobOutput', 'mltable': 'MLTableJobOutput', 'triton_model': 'TritonModelJobOutput', 'uri_file': 'UriFileJobOutput', 'uri_folder': 'UriFolderJobOutput'}
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: Description for the output.
        :paramtype description: str
        """
        super(JobOutput, self).__init__(**kwargs)
        self.description = description
        self.job_output_type = None  # type: Optional[str]


class CustomModelJobOutput(JobOutput, AssetJobOutput):
    """CustomModelJobOutput.

    All required parameters must be populated in order to send to Azure.

    :ivar asset_name: Output Asset Name.
    :vartype asset_name: str
    :ivar asset_version: Output Asset Version.
    :vartype asset_version: str
    :ivar auto_delete_setting: Auto delete setting of output data asset.
    :vartype auto_delete_setting: ~azure.mgmt.machinelearningservices.models.AutoDeleteSetting
    :ivar mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload",
     "Direct".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
    :ivar path_on_compute: Output Asset Delivery Path.
    :vartype path_on_compute: str
    :ivar uri: Output Asset URI.
    :vartype uri: str
    :ivar description: Description for the output.
    :vartype description: str
    :ivar job_output_type: Required. [Required] Specifies the type of job.Constant filled by
     server. Possible values include: "uri_file", "uri_folder", "mltable", "custom_model",
     "mlflow_model", "triton_model".
    :vartype job_output_type: str or ~azure.mgmt.machinelearningservices.models.JobOutputType
    """

    _validation = {
        'job_output_type': {'required': True},
    }

    _attribute_map = {
        'asset_name': {'key': 'assetName', 'type': 'str'},
        'asset_version': {'key': 'assetVersion', 'type': 'str'},
        'auto_delete_setting': {'key': 'autoDeleteSetting', 'type': 'AutoDeleteSetting'},
        'mode': {'key': 'mode', 'type': 'str'},
        'path_on_compute': {'key': 'pathOnCompute', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_output_type': {'key': 'jobOutputType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        asset_name: Optional[str] = None,
        asset_version: Optional[str] = None,
        auto_delete_setting: Optional["AutoDeleteSetting"] = None,
        mode: Optional[Union[str, "OutputDeliveryMode"]] = None,
        path_on_compute: Optional[str] = None,
        uri: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword asset_name: Output Asset Name.
        :paramtype asset_name: str
        :keyword asset_version: Output Asset Version.
        :paramtype asset_version: str
        :keyword auto_delete_setting: Auto delete setting of output data asset.
        :paramtype auto_delete_setting: ~azure.mgmt.machinelearningservices.models.AutoDeleteSetting
        :keyword mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload",
         "Direct".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
        :keyword path_on_compute: Output Asset Delivery Path.
        :paramtype path_on_compute: str
        :keyword uri: Output Asset URI.
        :paramtype uri: str
        :keyword description: Description for the output.
        :paramtype description: str
        """
        super(CustomModelJobOutput, self).__init__(description=description, asset_name=asset_name, asset_version=asset_version, auto_delete_setting=auto_delete_setting, mode=mode, path_on_compute=path_on_compute, uri=uri, **kwargs)
        self.asset_name = asset_name
        self.asset_version = asset_version
        self.auto_delete_setting = auto_delete_setting
        self.mode = mode
        self.path_on_compute = path_on_compute
        self.uri = uri
        self.job_output_type = 'custom_model'  # type: str
        self.description = description


class MonitoringSignalBase(msrest.serialization.Model):
    """MonitoringSignalBase.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CustomMonitoringSignal, DataDriftMonitoringSignal, DataQualityMonitoringSignal, FeatureAttributionDriftMonitoringSignal, GenerationSafetyQualityMonitoringSignal, GenerationTokenUsageSignal, ModelPerformanceSignal, PredictionDriftMonitoringSignal.

    All required parameters must be populated in order to send to Azure.

    :ivar notification_types: The current notification mode for this signal.
    :vartype notification_types: list[str or
     ~azure.mgmt.machinelearningservices.models.MonitoringNotificationType]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar signal_type: Required. [Required] Specifies the type of signal to monitor.Constant filled
     by server. Possible values include: "DataDrift", "PredictionDrift", "DataQuality",
     "FeatureAttributionDrift", "Custom", "ModelPerformance", "GenerationSafetyQuality",
     "GenerationTokenStatistics".
    :vartype signal_type: str or ~azure.mgmt.machinelearningservices.models.MonitoringSignalType
    """

    _validation = {
        'signal_type': {'required': True},
    }

    _attribute_map = {
        'notification_types': {'key': 'notificationTypes', 'type': '[str]'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'signal_type': {'key': 'signalType', 'type': 'str'},
    }

    _subtype_map = {
        'signal_type': {'Custom': 'CustomMonitoringSignal', 'DataDrift': 'DataDriftMonitoringSignal', 'DataQuality': 'DataQualityMonitoringSignal', 'FeatureAttributionDrift': 'FeatureAttributionDriftMonitoringSignal', 'GenerationSafetyQuality': 'GenerationSafetyQualityMonitoringSignal', 'GenerationTokenStatistics': 'GenerationTokenUsageSignal', 'ModelPerformance': 'ModelPerformanceSignal', 'PredictionDrift': 'PredictionDriftMonitoringSignal'}
    }

    def __init__(
        self,
        *,
        notification_types: Optional[List[Union[str, "MonitoringNotificationType"]]] = None,
        properties: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword notification_types: The current notification mode for this signal.
        :paramtype notification_types: list[str or
         ~azure.mgmt.machinelearningservices.models.MonitoringNotificationType]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        """
        super(MonitoringSignalBase, self).__init__(**kwargs)
        self.notification_types = notification_types
        self.properties = properties
        self.signal_type = None  # type: Optional[str]


class CustomMonitoringSignal(MonitoringSignalBase):
    """CustomMonitoringSignal.

    All required parameters must be populated in order to send to Azure.

    :ivar notification_types: The current notification mode for this signal.
    :vartype notification_types: list[str or
     ~azure.mgmt.machinelearningservices.models.MonitoringNotificationType]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar signal_type: Required. [Required] Specifies the type of signal to monitor.Constant filled
     by server. Possible values include: "DataDrift", "PredictionDrift", "DataQuality",
     "FeatureAttributionDrift", "Custom", "ModelPerformance", "GenerationSafetyQuality",
     "GenerationTokenStatistics".
    :vartype signal_type: str or ~azure.mgmt.machinelearningservices.models.MonitoringSignalType
    :ivar component_id: Required. [Required] ARM resource ID of the component resource used to
     calculate the custom metrics.
    :vartype component_id: str
    :ivar input_assets: Monitoring assets to take as input. Key is the component input port name,
     value is the data asset.
    :vartype input_assets: dict[str,
     ~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase]
    :ivar inputs: Extra component parameters to take as input. Key is the component literal input
     port name, value is the parameter value.
    :vartype inputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobInput]
    :ivar metric_thresholds: Required. [Required] A list of metrics to calculate and their
     associated thresholds.
    :vartype metric_thresholds:
     list[~azure.mgmt.machinelearningservices.models.CustomMetricThreshold]
    :ivar workspace_connection: A list of metrics to calculate and their associated thresholds.
    :vartype workspace_connection:
     ~azure.mgmt.machinelearningservices.models.MonitoringWorkspaceConnection
    """

    _validation = {
        'signal_type': {'required': True},
        'component_id': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
        'metric_thresholds': {'required': True},
    }

    _attribute_map = {
        'notification_types': {'key': 'notificationTypes', 'type': '[str]'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'signal_type': {'key': 'signalType', 'type': 'str'},
        'component_id': {'key': 'componentId', 'type': 'str'},
        'input_assets': {'key': 'inputAssets', 'type': '{MonitoringInputDataBase}'},
        'inputs': {'key': 'inputs', 'type': '{JobInput}'},
        'metric_thresholds': {'key': 'metricThresholds', 'type': '[CustomMetricThreshold]'},
        'workspace_connection': {'key': 'workspaceConnection', 'type': 'MonitoringWorkspaceConnection'},
    }

    def __init__(
        self,
        *,
        component_id: str,
        metric_thresholds: List["CustomMetricThreshold"],
        notification_types: Optional[List[Union[str, "MonitoringNotificationType"]]] = None,
        properties: Optional[Dict[str, str]] = None,
        input_assets: Optional[Dict[str, "MonitoringInputDataBase"]] = None,
        inputs: Optional[Dict[str, "JobInput"]] = None,
        workspace_connection: Optional["MonitoringWorkspaceConnection"] = None,
        **kwargs
    ):
        """
        :keyword notification_types: The current notification mode for this signal.
        :paramtype notification_types: list[str or
         ~azure.mgmt.machinelearningservices.models.MonitoringNotificationType]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword component_id: Required. [Required] ARM resource ID of the component resource used to
         calculate the custom metrics.
        :paramtype component_id: str
        :keyword input_assets: Monitoring assets to take as input. Key is the component input port
         name, value is the data asset.
        :paramtype input_assets: dict[str,
         ~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase]
        :keyword inputs: Extra component parameters to take as input. Key is the component literal
         input port name, value is the parameter value.
        :paramtype inputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobInput]
        :keyword metric_thresholds: Required. [Required] A list of metrics to calculate and their
         associated thresholds.
        :paramtype metric_thresholds:
         list[~azure.mgmt.machinelearningservices.models.CustomMetricThreshold]
        :keyword workspace_connection: A list of metrics to calculate and their associated thresholds.
        :paramtype workspace_connection:
         ~azure.mgmt.machinelearningservices.models.MonitoringWorkspaceConnection
        """
        super(CustomMonitoringSignal, self).__init__(notification_types=notification_types, properties=properties, **kwargs)
        self.signal_type = 'Custom'  # type: str
        self.component_id = component_id
        self.input_assets = input_assets
        self.inputs = inputs
        self.metric_thresholds = metric_thresholds
        self.workspace_connection = workspace_connection


class CustomNCrossValidations(NCrossValidations):
    """N-Cross validations are specified by user.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Mode for determining N-Cross validations.Constant filled by
     server. Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.NCrossValidationsMode
    :ivar value: Required. [Required] N-Cross validations value.
    :vartype value: int
    """

    _validation = {
        'mode': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'value': {'key': 'value', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        value: int,
        **kwargs
    ):
        """
        :keyword value: Required. [Required] N-Cross validations value.
        :paramtype value: int
        """
        super(CustomNCrossValidations, self).__init__(**kwargs)
        self.mode = 'Custom'  # type: str
        self.value = value


class CustomSeasonality(Seasonality):
    """CustomSeasonality.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Seasonality mode.Constant filled by server. Possible values
     include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.SeasonalityMode
    :ivar value: Required. [Required] Seasonality value.
    :vartype value: int
    """

    _validation = {
        'mode': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'value': {'key': 'value', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        value: int,
        **kwargs
    ):
        """
        :keyword value: Required. [Required] Seasonality value.
        :paramtype value: int
        """
        super(CustomSeasonality, self).__init__(**kwargs)
        self.mode = 'Custom'  # type: str
        self.value = value


class CustomService(msrest.serialization.Model):
    """Specifies the custom service configuration.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar name: Name of the Custom Service.
    :vartype name: str
    :ivar image: Describes the Image Specifications.
    :vartype image: ~azure.mgmt.machinelearningservices.models.Image
    :ivar environment_variables: Environment Variable for the container.
    :vartype environment_variables: dict[str,
     ~azure.mgmt.machinelearningservices.models.EnvironmentVariable]
    :ivar docker: Describes the docker settings for the image.
    :vartype docker: ~azure.mgmt.machinelearningservices.models.Docker
    :ivar endpoints: Configuring the endpoints for the container.
    :vartype endpoints: list[~azure.mgmt.machinelearningservices.models.Endpoint]
    :ivar volumes: Configuring the volumes for the container.
    :vartype volumes: list[~azure.mgmt.machinelearningservices.models.VolumeDefinition]
    :ivar kernel: Describes the jupyter kernel settings for the image if its a custom environment.
    :vartype kernel: ~azure.mgmt.machinelearningservices.models.JupyterKernelConfig
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'image': {'key': 'image', 'type': 'Image'},
        'environment_variables': {'key': 'environmentVariables', 'type': '{EnvironmentVariable}'},
        'docker': {'key': 'docker', 'type': 'Docker'},
        'endpoints': {'key': 'endpoints', 'type': '[Endpoint]'},
        'volumes': {'key': 'volumes', 'type': '[VolumeDefinition]'},
        'kernel': {'key': 'kernel', 'type': 'JupyterKernelConfig'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        image: Optional["Image"] = None,
        environment_variables: Optional[Dict[str, "EnvironmentVariable"]] = None,
        docker: Optional["Docker"] = None,
        endpoints: Optional[List["Endpoint"]] = None,
        volumes: Optional[List["VolumeDefinition"]] = None,
        kernel: Optional["JupyterKernelConfig"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword name: Name of the Custom Service.
        :paramtype name: str
        :keyword image: Describes the Image Specifications.
        :paramtype image: ~azure.mgmt.machinelearningservices.models.Image
        :keyword environment_variables: Environment Variable for the container.
        :paramtype environment_variables: dict[str,
         ~azure.mgmt.machinelearningservices.models.EnvironmentVariable]
        :keyword docker: Describes the docker settings for the image.
        :paramtype docker: ~azure.mgmt.machinelearningservices.models.Docker
        :keyword endpoints: Configuring the endpoints for the container.
        :paramtype endpoints: list[~azure.mgmt.machinelearningservices.models.Endpoint]
        :keyword volumes: Configuring the volumes for the container.
        :paramtype volumes: list[~azure.mgmt.machinelearningservices.models.VolumeDefinition]
        :keyword kernel: Describes the jupyter kernel settings for the image if its a custom
         environment.
        :paramtype kernel: ~azure.mgmt.machinelearningservices.models.JupyterKernelConfig
        """
        super(CustomService, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.name = name
        self.image = image
        self.environment_variables = environment_variables
        self.docker = docker
        self.endpoints = endpoints
        self.volumes = volumes
        self.kernel = kernel


class CustomTargetLags(TargetLags):
    """CustomTargetLags.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Set target lags mode - Auto/Custom.Constant filled by server.
     Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.TargetLagsMode
    :ivar values: Required. [Required] Set target lags values.
    :vartype values: list[int]
    """

    _validation = {
        'mode': {'required': True},
        'values': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'values': {'key': 'values', 'type': '[int]'},
    }

    def __init__(
        self,
        *,
        values: List[int],
        **kwargs
    ):
        """
        :keyword values: Required. [Required] Set target lags values.
        :paramtype values: list[int]
        """
        super(CustomTargetLags, self).__init__(**kwargs)
        self.mode = 'Custom'  # type: str
        self.values = values


class CustomTargetRollingWindowSize(TargetRollingWindowSize):
    """CustomTargetRollingWindowSize.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] TargetRollingWindowSiz detection mode.Constant filled by
     server. Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.TargetRollingWindowSizeMode
    :ivar value: Required. [Required] TargetRollingWindowSize value.
    :vartype value: int
    """

    _validation = {
        'mode': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'value': {'key': 'value', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        value: int,
        **kwargs
    ):
        """
        :keyword value: Required. [Required] TargetRollingWindowSize value.
        :paramtype value: int
        """
        super(CustomTargetRollingWindowSize, self).__init__(**kwargs)
        self.mode = 'Custom'  # type: str
        self.value = value


class DataImportSource(msrest.serialization.Model):
    """DataImportSource.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DatabaseSource, FileSystemSource.

    All required parameters must be populated in order to send to Azure.

    :ivar connection: Workspace connection for data import source storage.
    :vartype connection: str
    :ivar source_type: Required. [Required] Specifies the type of data.Constant filled by server.
     Possible values include: "database", "file_system".
    :vartype source_type: str or ~azure.mgmt.machinelearningservices.models.DataImportSourceType
    """

    _validation = {
        'source_type': {'required': True},
    }

    _attribute_map = {
        'connection': {'key': 'connection', 'type': 'str'},
        'source_type': {'key': 'sourceType', 'type': 'str'},
    }

    _subtype_map = {
        'source_type': {'database': 'DatabaseSource', 'file_system': 'FileSystemSource'}
    }

    def __init__(
        self,
        *,
        connection: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword connection: Workspace connection for data import source storage.
        :paramtype connection: str
        """
        super(DataImportSource, self).__init__(**kwargs)
        self.connection = connection
        self.source_type = None  # type: Optional[str]


class DatabaseSource(DataImportSource):
    """DatabaseSource.

    All required parameters must be populated in order to send to Azure.

    :ivar connection: Workspace connection for data import source storage.
    :vartype connection: str
    :ivar source_type: Required. [Required] Specifies the type of data.Constant filled by server.
     Possible values include: "database", "file_system".
    :vartype source_type: str or ~azure.mgmt.machinelearningservices.models.DataImportSourceType
    :ivar query: SQL Query statement for data import Database source.
    :vartype query: str
    :ivar stored_procedure: SQL StoredProcedure on data import Database source.
    :vartype stored_procedure: str
    :ivar stored_procedure_params: SQL StoredProcedure parameters.
    :vartype stored_procedure_params: list[dict[str, str]]
    :ivar table_name: Name of the table on data import Database source.
    :vartype table_name: str
    """

    _validation = {
        'source_type': {'required': True},
    }

    _attribute_map = {
        'connection': {'key': 'connection', 'type': 'str'},
        'source_type': {'key': 'sourceType', 'type': 'str'},
        'query': {'key': 'query', 'type': 'str'},
        'stored_procedure': {'key': 'storedProcedure', 'type': 'str'},
        'stored_procedure_params': {'key': 'storedProcedureParams', 'type': '[{str}]'},
        'table_name': {'key': 'tableName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        connection: Optional[str] = None,
        query: Optional[str] = None,
        stored_procedure: Optional[str] = None,
        stored_procedure_params: Optional[List[Dict[str, str]]] = None,
        table_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword connection: Workspace connection for data import source storage.
        :paramtype connection: str
        :keyword query: SQL Query statement for data import Database source.
        :paramtype query: str
        :keyword stored_procedure: SQL StoredProcedure on data import Database source.
        :paramtype stored_procedure: str
        :keyword stored_procedure_params: SQL StoredProcedure parameters.
        :paramtype stored_procedure_params: list[dict[str, str]]
        :keyword table_name: Name of the table on data import Database source.
        :paramtype table_name: str
        """
        super(DatabaseSource, self).__init__(connection=connection, **kwargs)
        self.source_type = 'database'  # type: str
        self.query = query
        self.stored_procedure = stored_procedure
        self.stored_procedure_params = stored_procedure_params
        self.table_name = table_name


class DatabricksSchema(msrest.serialization.Model):
    """DatabricksSchema.

    :ivar properties: Properties of Databricks.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.DatabricksProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'DatabricksProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["DatabricksProperties"] = None,
        **kwargs
    ):
        """
        :keyword properties: Properties of Databricks.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.DatabricksProperties
        """
        super(DatabricksSchema, self).__init__(**kwargs)
        self.properties = properties


class Databricks(Compute, DatabricksSchema):
    """A DataFactory compute.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: Properties of Databricks.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.DatabricksProperties
    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    """

    _validation = {
        'compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'DatabricksProperties'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[ErrorResponse]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'disable_local_auth': {'key': 'disableLocalAuth', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        properties: Optional["DatabricksProperties"] = None,
        compute_location: Optional[str] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        disable_local_auth: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword properties: Properties of Databricks.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.DatabricksProperties
        :keyword compute_location: Location for the underlying compute.
        :paramtype compute_location: str
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        :keyword disable_local_auth: Opt-out of local authentication and ensure customers can use only
         MSI and AAD exclusively for authentication.
        :paramtype disable_local_auth: bool
        """
        super(Databricks, self).__init__(compute_location=compute_location, description=description, resource_id=resource_id, disable_local_auth=disable_local_auth, properties=properties, **kwargs)
        self.properties = properties
        self.compute_type = 'Databricks'  # type: str
        self.compute_location = compute_location
        self.provisioning_state = None
        self.description = description
        self.created_on = None
        self.modified_on = None
        self.resource_id = resource_id
        self.provisioning_errors = None
        self.is_attached_compute = None
        self.disable_local_auth = disable_local_auth


class DatabricksComputeSecretsProperties(msrest.serialization.Model):
    """Properties of Databricks Compute Secrets.

    :ivar databricks_access_token: access token for databricks account.
    :vartype databricks_access_token: str
    """

    _attribute_map = {
        'databricks_access_token': {'key': 'databricksAccessToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        databricks_access_token: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword databricks_access_token: access token for databricks account.
        :paramtype databricks_access_token: str
        """
        super(DatabricksComputeSecretsProperties, self).__init__(**kwargs)
        self.databricks_access_token = databricks_access_token


class DatabricksComputeSecrets(ComputeSecrets, DatabricksComputeSecretsProperties):
    """Secrets related to a Machine Learning compute based on Databricks.

    All required parameters must be populated in order to send to Azure.

    :ivar databricks_access_token: access token for databricks account.
    :vartype databricks_access_token: str
    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    """

    _validation = {
        'compute_type': {'required': True},
    }

    _attribute_map = {
        'databricks_access_token': {'key': 'databricksAccessToken', 'type': 'str'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        databricks_access_token: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword databricks_access_token: access token for databricks account.
        :paramtype databricks_access_token: str
        """
        super(DatabricksComputeSecrets, self).__init__(databricks_access_token=databricks_access_token, **kwargs)
        self.databricks_access_token = databricks_access_token
        self.compute_type = 'Databricks'  # type: str


class DatabricksProperties(msrest.serialization.Model):
    """Properties of Databricks.

    :ivar databricks_access_token: Databricks access token.
    :vartype databricks_access_token: str
    :ivar workspace_url: Workspace Url.
    :vartype workspace_url: str
    """

    _attribute_map = {
        'databricks_access_token': {'key': 'databricksAccessToken', 'type': 'str'},
        'workspace_url': {'key': 'workspaceUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        databricks_access_token: Optional[str] = None,
        workspace_url: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword databricks_access_token: Databricks access token.
        :paramtype databricks_access_token: str
        :keyword workspace_url: Workspace Url.
        :paramtype workspace_url: str
        """
        super(DatabricksProperties, self).__init__(**kwargs)
        self.databricks_access_token = databricks_access_token
        self.workspace_url = workspace_url


class DataCollector(msrest.serialization.Model):
    """DataCollector.

    All required parameters must be populated in order to send to Azure.

    :ivar collections: Required. [Required] The collection configuration. Each collection has it
     own configuration to collect model data and the name of collection can be arbitrary string.
     Model data collector can be used for either payload logging or custom logging or both of them.
     Collection request and response are reserved for payload logging, others are for custom
     logging.
    :vartype collections: dict[str, ~azure.mgmt.machinelearningservices.models.Collection]
    :ivar request_logging: The request logging configuration for mdc, it includes advanced logging
     settings for all collections. It's optional.
    :vartype request_logging: ~azure.mgmt.machinelearningservices.models.RequestLogging
    :ivar rolling_rate: When model data is collected to blob storage, we need to roll the data to
     different path to avoid logging all of them in a single blob file.
     If the rolling rate is hour, all data will be collected in the blob path /yyyy/MM/dd/HH/.
     If it's day, all data will be collected in blob path /yyyy/MM/dd/.
     The other benefit of rolling path is that model monitoring ui is able to select a time range
     of data very quickly. Possible values include: "Year", "Month", "Day", "Hour", "Minute".
    :vartype rolling_rate: str or ~azure.mgmt.machinelearningservices.models.RollingRateType
    """

    _validation = {
        'collections': {'required': True},
    }

    _attribute_map = {
        'collections': {'key': 'collections', 'type': '{Collection}'},
        'request_logging': {'key': 'requestLogging', 'type': 'RequestLogging'},
        'rolling_rate': {'key': 'rollingRate', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        collections: Dict[str, "Collection"],
        request_logging: Optional["RequestLogging"] = None,
        rolling_rate: Optional[Union[str, "RollingRateType"]] = None,
        **kwargs
    ):
        """
        :keyword collections: Required. [Required] The collection configuration. Each collection has it
         own configuration to collect model data and the name of collection can be arbitrary string.
         Model data collector can be used for either payload logging or custom logging or both of them.
         Collection request and response are reserved for payload logging, others are for custom
         logging.
        :paramtype collections: dict[str, ~azure.mgmt.machinelearningservices.models.Collection]
        :keyword request_logging: The request logging configuration for mdc, it includes advanced
         logging settings for all collections. It's optional.
        :paramtype request_logging: ~azure.mgmt.machinelearningservices.models.RequestLogging
        :keyword rolling_rate: When model data is collected to blob storage, we need to roll the data
         to different path to avoid logging all of them in a single blob file.
         If the rolling rate is hour, all data will be collected in the blob path /yyyy/MM/dd/HH/.
         If it's day, all data will be collected in blob path /yyyy/MM/dd/.
         The other benefit of rolling path is that model monitoring ui is able to select a time range
         of data very quickly. Possible values include: "Year", "Month", "Day", "Hour", "Minute".
        :paramtype rolling_rate: str or ~azure.mgmt.machinelearningservices.models.RollingRateType
        """
        super(DataCollector, self).__init__(**kwargs)
        self.collections = collections
        self.request_logging = request_logging
        self.rolling_rate = rolling_rate


class DataContainer(ProxyResource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.DataContainerProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'DataContainerProperties'},
    }

    def __init__(
        self,
        *,
        properties: "DataContainerProperties",
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.DataContainerProperties
        """
        super(DataContainer, self).__init__(**kwargs)
        self.properties = properties


class DataContainerProperties(AssetContainer):
    """Container for data asset versions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar latest_version: The latest version inside this container.
    :vartype latest_version: str
    :ivar next_version: The next auto incremental version.
    :vartype next_version: str
    :ivar data_type: Required. [Required] Specifies the type of data. Possible values include:
     "uri_file", "uri_folder", "mltable".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.DataType
    """

    _validation = {
        'latest_version': {'readonly': True},
        'next_version': {'readonly': True},
        'data_type': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'latest_version': {'key': 'latestVersion', 'type': 'str'},
        'next_version': {'key': 'nextVersion', 'type': 'str'},
        'data_type': {'key': 'dataType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_type: Union[str, "DataType"],
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_archived: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword data_type: Required. [Required] Specifies the type of data. Possible values include:
         "uri_file", "uri_folder", "mltable".
        :paramtype data_type: str or ~azure.mgmt.machinelearningservices.models.DataType
        """
        super(DataContainerProperties, self).__init__(description=description, properties=properties, tags=tags, is_archived=is_archived, **kwargs)
        self.data_type = data_type


class DataContainerResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of DataContainer entities.

    :ivar next_link: The link to the next page of DataContainer objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type DataContainer.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.DataContainer]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[DataContainer]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["DataContainer"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of DataContainer objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type DataContainer.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.DataContainer]
        """
        super(DataContainerResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class DataDriftMonitoringSignal(MonitoringSignalBase):
    """DataDriftMonitoringSignal.

    All required parameters must be populated in order to send to Azure.

    :ivar notification_types: The current notification mode for this signal.
    :vartype notification_types: list[str or
     ~azure.mgmt.machinelearningservices.models.MonitoringNotificationType]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar signal_type: Required. [Required] Specifies the type of signal to monitor.Constant filled
     by server. Possible values include: "DataDrift", "PredictionDrift", "DataQuality",
     "FeatureAttributionDrift", "Custom", "ModelPerformance", "GenerationSafetyQuality",
     "GenerationTokenStatistics".
    :vartype signal_type: str or ~azure.mgmt.machinelearningservices.models.MonitoringSignalType
    :ivar data_segment: The data segment used for scoping on a subset of the data population.
    :vartype data_segment: ~azure.mgmt.machinelearningservices.models.MonitoringDataSegment
    :ivar feature_data_type_override: A dictionary that maps feature names to their respective data
     types.
    :vartype feature_data_type_override: dict[str, str or
     ~azure.mgmt.machinelearningservices.models.MonitoringFeatureDataType]
    :ivar feature_importance_settings: The settings for computing feature importance.
    :vartype feature_importance_settings:
     ~azure.mgmt.machinelearningservices.models.FeatureImportanceSettings
    :ivar features: The feature filter which identifies which feature to calculate drift over.
    :vartype features: ~azure.mgmt.machinelearningservices.models.MonitoringFeatureFilterBase
    :ivar metric_thresholds: Required. [Required] A list of metrics to calculate and their
     associated thresholds.
    :vartype metric_thresholds:
     list[~azure.mgmt.machinelearningservices.models.DataDriftMetricThresholdBase]
    :ivar production_data: Required. [Required] The data which drift will be calculated for.
    :vartype production_data: ~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase
    :ivar reference_data: Required. [Required] The data to calculate drift against.
    :vartype reference_data: ~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase
    """

    _validation = {
        'signal_type': {'required': True},
        'metric_thresholds': {'required': True},
        'production_data': {'required': True},
        'reference_data': {'required': True},
    }

    _attribute_map = {
        'notification_types': {'key': 'notificationTypes', 'type': '[str]'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'signal_type': {'key': 'signalType', 'type': 'str'},
        'data_segment': {'key': 'dataSegment', 'type': 'MonitoringDataSegment'},
        'feature_data_type_override': {'key': 'featureDataTypeOverride', 'type': '{str}'},
        'feature_importance_settings': {'key': 'featureImportanceSettings', 'type': 'FeatureImportanceSettings'},
        'features': {'key': 'features', 'type': 'MonitoringFeatureFilterBase'},
        'metric_thresholds': {'key': 'metricThresholds', 'type': '[DataDriftMetricThresholdBase]'},
        'production_data': {'key': 'productionData', 'type': 'MonitoringInputDataBase'},
        'reference_data': {'key': 'referenceData', 'type': 'MonitoringInputDataBase'},
    }

    def __init__(
        self,
        *,
        metric_thresholds: List["DataDriftMetricThresholdBase"],
        production_data: "MonitoringInputDataBase",
        reference_data: "MonitoringInputDataBase",
        notification_types: Optional[List[Union[str, "MonitoringNotificationType"]]] = None,
        properties: Optional[Dict[str, str]] = None,
        data_segment: Optional["MonitoringDataSegment"] = None,
        feature_data_type_override: Optional[Dict[str, Union[str, "MonitoringFeatureDataType"]]] = None,
        feature_importance_settings: Optional["FeatureImportanceSettings"] = None,
        features: Optional["MonitoringFeatureFilterBase"] = None,
        **kwargs
    ):
        """
        :keyword notification_types: The current notification mode for this signal.
        :paramtype notification_types: list[str or
         ~azure.mgmt.machinelearningservices.models.MonitoringNotificationType]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword data_segment: The data segment used for scoping on a subset of the data population.
        :paramtype data_segment: ~azure.mgmt.machinelearningservices.models.MonitoringDataSegment
        :keyword feature_data_type_override: A dictionary that maps feature names to their respective
         data types.
        :paramtype feature_data_type_override: dict[str, str or
         ~azure.mgmt.machinelearningservices.models.MonitoringFeatureDataType]
        :keyword feature_importance_settings: The settings for computing feature importance.
        :paramtype feature_importance_settings:
         ~azure.mgmt.machinelearningservices.models.FeatureImportanceSettings
        :keyword features: The feature filter which identifies which feature to calculate drift over.
        :paramtype features: ~azure.mgmt.machinelearningservices.models.MonitoringFeatureFilterBase
        :keyword metric_thresholds: Required. [Required] A list of metrics to calculate and their
         associated thresholds.
        :paramtype metric_thresholds:
         list[~azure.mgmt.machinelearningservices.models.DataDriftMetricThresholdBase]
        :keyword production_data: Required. [Required] The data which drift will be calculated for.
        :paramtype production_data: ~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase
        :keyword reference_data: Required. [Required] The data to calculate drift against.
        :paramtype reference_data: ~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase
        """
        super(DataDriftMonitoringSignal, self).__init__(notification_types=notification_types, properties=properties, **kwargs)
        self.signal_type = 'DataDrift'  # type: str
        self.data_segment = data_segment
        self.feature_data_type_override = feature_data_type_override
        self.feature_importance_settings = feature_importance_settings
        self.features = features
        self.metric_thresholds = metric_thresholds
        self.production_data = production_data
        self.reference_data = reference_data


class DataFactory(Compute):
    """A DataFactory compute.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    """

    _validation = {
        'compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[ErrorResponse]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'disable_local_auth': {'key': 'disableLocalAuth', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        compute_location: Optional[str] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        disable_local_auth: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword compute_location: Location for the underlying compute.
        :paramtype compute_location: str
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        :keyword disable_local_auth: Opt-out of local authentication and ensure customers can use only
         MSI and AAD exclusively for authentication.
        :paramtype disable_local_auth: bool
        """
        super(DataFactory, self).__init__(compute_location=compute_location, description=description, resource_id=resource_id, disable_local_auth=disable_local_auth, **kwargs)
        self.compute_type = 'DataFactory'  # type: str


class DataVersionBaseProperties(AssetBase):
    """Data version base definition.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MLTableData, UriFileDataVersion, UriFolderDataVersion.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar auto_delete_setting: Specifies the lifecycle setting of managed data asset.
    :vartype auto_delete_setting: ~azure.mgmt.machinelearningservices.models.AutoDeleteSetting
    :ivar is_anonymous: If the name version are system generated (anonymous registration). For
     types where Stage is defined, when Stage is provided it will be used to populate IsAnonymous.
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived? For types where Stage is defined, when Stage is
     provided it will be used to populate IsArchived.
    :vartype is_archived: bool
    :ivar data_type: Required. [Required] Specifies the type of data.Constant filled by server.
     Possible values include: "uri_file", "uri_folder", "mltable".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.DataType
    :ivar data_uri: Required. [Required] Uri of the data. Example:
     https://go.microsoft.com/fwlink/?linkid=2202330.
    :vartype data_uri: str
    :ivar intellectual_property: Intellectual Property details. Used if data is an Intellectual
     Property.
    :vartype intellectual_property: ~azure.mgmt.machinelearningservices.models.IntellectualProperty
    :ivar stage: Stage in the data lifecycle assigned to this data asset.
    :vartype stage: str
    """

    _validation = {
        'data_type': {'required': True},
        'data_uri': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'auto_delete_setting': {'key': 'autoDeleteSetting', 'type': 'AutoDeleteSetting'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'data_type': {'key': 'dataType', 'type': 'str'},
        'data_uri': {'key': 'dataUri', 'type': 'str'},
        'intellectual_property': {'key': 'intellectualProperty', 'type': 'IntellectualProperty'},
        'stage': {'key': 'stage', 'type': 'str'},
    }

    _subtype_map = {
        'data_type': {'mltable': 'MLTableData', 'uri_file': 'UriFileDataVersion', 'uri_folder': 'UriFolderDataVersion'}
    }

    def __init__(
        self,
        *,
        data_uri: str,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        auto_delete_setting: Optional["AutoDeleteSetting"] = None,
        is_anonymous: Optional[bool] = False,
        is_archived: Optional[bool] = False,
        intellectual_property: Optional["IntellectualProperty"] = None,
        stage: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword auto_delete_setting: Specifies the lifecycle setting of managed data asset.
        :paramtype auto_delete_setting: ~azure.mgmt.machinelearningservices.models.AutoDeleteSetting
        :keyword is_anonymous: If the name version are system generated (anonymous registration). For
         types where Stage is defined, when Stage is provided it will be used to populate IsAnonymous.
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived? For types where Stage is defined, when Stage is
         provided it will be used to populate IsArchived.
        :paramtype is_archived: bool
        :keyword data_uri: Required. [Required] Uri of the data. Example:
         https://go.microsoft.com/fwlink/?linkid=2202330.
        :paramtype data_uri: str
        :keyword intellectual_property: Intellectual Property details. Used if data is an Intellectual
         Property.
        :paramtype intellectual_property:
         ~azure.mgmt.machinelearningservices.models.IntellectualProperty
        :keyword stage: Stage in the data lifecycle assigned to this data asset.
        :paramtype stage: str
        """
        super(DataVersionBaseProperties, self).__init__(description=description, properties=properties, tags=tags, auto_delete_setting=auto_delete_setting, is_anonymous=is_anonymous, is_archived=is_archived, **kwargs)
        self.data_type = 'DataVersionBaseProperties'  # type: str
        self.data_uri = data_uri
        self.intellectual_property = intellectual_property
        self.stage = stage


class DataImport(DataVersionBaseProperties):
    """DataImport.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar auto_delete_setting: Specifies the lifecycle setting of managed data asset.
    :vartype auto_delete_setting: ~azure.mgmt.machinelearningservices.models.AutoDeleteSetting
    :ivar is_anonymous: If the name version are system generated (anonymous registration). For
     types where Stage is defined, when Stage is provided it will be used to populate IsAnonymous.
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived? For types where Stage is defined, when Stage is
     provided it will be used to populate IsArchived.
    :vartype is_archived: bool
    :ivar data_type: Required. [Required] Specifies the type of data.Constant filled by server.
     Possible values include: "uri_file", "uri_folder", "mltable".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.DataType
    :ivar data_uri: Required. [Required] Uri of the data. Example:
     https://go.microsoft.com/fwlink/?linkid=2202330.
    :vartype data_uri: str
    :ivar intellectual_property: Intellectual Property details. Used if data is an Intellectual
     Property.
    :vartype intellectual_property: ~azure.mgmt.machinelearningservices.models.IntellectualProperty
    :ivar stage: Stage in the data lifecycle assigned to this data asset.
    :vartype stage: str
    :ivar asset_name: Name of the asset for data import job to create.
    :vartype asset_name: str
    :ivar source: Source data of the asset to import from.
    :vartype source: ~azure.mgmt.machinelearningservices.models.DataImportSource
    """

    _validation = {
        'data_type': {'required': True},
        'data_uri': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'auto_delete_setting': {'key': 'autoDeleteSetting', 'type': 'AutoDeleteSetting'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'data_type': {'key': 'dataType', 'type': 'str'},
        'data_uri': {'key': 'dataUri', 'type': 'str'},
        'intellectual_property': {'key': 'intellectualProperty', 'type': 'IntellectualProperty'},
        'stage': {'key': 'stage', 'type': 'str'},
        'asset_name': {'key': 'assetName', 'type': 'str'},
        'source': {'key': 'source', 'type': 'DataImportSource'},
    }

    def __init__(
        self,
        *,
        data_uri: str,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        auto_delete_setting: Optional["AutoDeleteSetting"] = None,
        is_anonymous: Optional[bool] = False,
        is_archived: Optional[bool] = False,
        intellectual_property: Optional["IntellectualProperty"] = None,
        stage: Optional[str] = None,
        asset_name: Optional[str] = None,
        source: Optional["DataImportSource"] = None,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword auto_delete_setting: Specifies the lifecycle setting of managed data asset.
        :paramtype auto_delete_setting: ~azure.mgmt.machinelearningservices.models.AutoDeleteSetting
        :keyword is_anonymous: If the name version are system generated (anonymous registration). For
         types where Stage is defined, when Stage is provided it will be used to populate IsAnonymous.
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived? For types where Stage is defined, when Stage is
         provided it will be used to populate IsArchived.
        :paramtype is_archived: bool
        :keyword data_uri: Required. [Required] Uri of the data. Example:
         https://go.microsoft.com/fwlink/?linkid=2202330.
        :paramtype data_uri: str
        :keyword intellectual_property: Intellectual Property details. Used if data is an Intellectual
         Property.
        :paramtype intellectual_property:
         ~azure.mgmt.machinelearningservices.models.IntellectualProperty
        :keyword stage: Stage in the data lifecycle assigned to this data asset.
        :paramtype stage: str
        :keyword asset_name: Name of the asset for data import job to create.
        :paramtype asset_name: str
        :keyword source: Source data of the asset to import from.
        :paramtype source: ~azure.mgmt.machinelearningservices.models.DataImportSource
        """
        super(DataImport, self).__init__(description=description, properties=properties, tags=tags, auto_delete_setting=auto_delete_setting, is_anonymous=is_anonymous, is_archived=is_archived, data_uri=data_uri, intellectual_property=intellectual_property, stage=stage, **kwargs)
        self.data_type = 'uri_folder'  # type: str
        self.asset_name = asset_name
        self.source = source


class DataLakeAnalyticsSchema(msrest.serialization.Model):
    """DataLakeAnalyticsSchema.

    :ivar properties:
    :vartype properties:
     ~azure.mgmt.machinelearningservices.models.DataLakeAnalyticsSchemaProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'DataLakeAnalyticsSchemaProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["DataLakeAnalyticsSchemaProperties"] = None,
        **kwargs
    ):
        """
        :keyword properties:
        :paramtype properties:
         ~azure.mgmt.machinelearningservices.models.DataLakeAnalyticsSchemaProperties
        """
        super(DataLakeAnalyticsSchema, self).__init__(**kwargs)
        self.properties = properties


class DataLakeAnalytics(Compute, DataLakeAnalyticsSchema):
    """A DataLakeAnalytics compute.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar properties:
    :vartype properties:
     ~azure.mgmt.machinelearningservices.models.DataLakeAnalyticsSchemaProperties
    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    """

    _validation = {
        'compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'DataLakeAnalyticsSchemaProperties'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[ErrorResponse]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'disable_local_auth': {'key': 'disableLocalAuth', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        properties: Optional["DataLakeAnalyticsSchemaProperties"] = None,
        compute_location: Optional[str] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        disable_local_auth: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword properties:
        :paramtype properties:
         ~azure.mgmt.machinelearningservices.models.DataLakeAnalyticsSchemaProperties
        :keyword compute_location: Location for the underlying compute.
        :paramtype compute_location: str
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        :keyword disable_local_auth: Opt-out of local authentication and ensure customers can use only
         MSI and AAD exclusively for authentication.
        :paramtype disable_local_auth: bool
        """
        super(DataLakeAnalytics, self).__init__(compute_location=compute_location, description=description, resource_id=resource_id, disable_local_auth=disable_local_auth, properties=properties, **kwargs)
        self.properties = properties
        self.compute_type = 'DataLakeAnalytics'  # type: str
        self.compute_location = compute_location
        self.provisioning_state = None
        self.description = description
        self.created_on = None
        self.modified_on = None
        self.resource_id = resource_id
        self.provisioning_errors = None
        self.is_attached_compute = None
        self.disable_local_auth = disable_local_auth


class DataLakeAnalyticsSchemaProperties(msrest.serialization.Model):
    """DataLakeAnalyticsSchemaProperties.

    :ivar data_lake_store_account_name: DataLake Store Account Name.
    :vartype data_lake_store_account_name: str
    """

    _attribute_map = {
        'data_lake_store_account_name': {'key': 'dataLakeStoreAccountName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_lake_store_account_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword data_lake_store_account_name: DataLake Store Account Name.
        :paramtype data_lake_store_account_name: str
        """
        super(DataLakeAnalyticsSchemaProperties, self).__init__(**kwargs)
        self.data_lake_store_account_name = data_lake_store_account_name


class DataPathAssetReference(AssetReferenceBase):
    """Reference to an asset via its path in a datastore.

    All required parameters must be populated in order to send to Azure.

    :ivar reference_type: Required. [Required] Specifies the type of asset reference.Constant
     filled by server. Possible values include: "Id", "DataPath", "OutputPath".
    :vartype reference_type: str or ~azure.mgmt.machinelearningservices.models.ReferenceType
    :ivar datastore_id: ARM resource ID of the datastore where the asset is located.
    :vartype datastore_id: str
    :ivar path: The path of the file/directory in the datastore.
    :vartype path: str
    """

    _validation = {
        'reference_type': {'required': True},
    }

    _attribute_map = {
        'reference_type': {'key': 'referenceType', 'type': 'str'},
        'datastore_id': {'key': 'datastoreId', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        datastore_id: Optional[str] = None,
        path: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword datastore_id: ARM resource ID of the datastore where the asset is located.
        :paramtype datastore_id: str
        :keyword path: The path of the file/directory in the datastore.
        :paramtype path: str
        """
        super(DataPathAssetReference, self).__init__(**kwargs)
        self.reference_type = 'DataPath'  # type: str
        self.datastore_id = datastore_id
        self.path = path


class DataQualityMonitoringSignal(MonitoringSignalBase):
    """DataQualityMonitoringSignal.

    All required parameters must be populated in order to send to Azure.

    :ivar notification_types: The current notification mode for this signal.
    :vartype notification_types: list[str or
     ~azure.mgmt.machinelearningservices.models.MonitoringNotificationType]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar signal_type: Required. [Required] Specifies the type of signal to monitor.Constant filled
     by server. Possible values include: "DataDrift", "PredictionDrift", "DataQuality",
     "FeatureAttributionDrift", "Custom", "ModelPerformance", "GenerationSafetyQuality",
     "GenerationTokenStatistics".
    :vartype signal_type: str or ~azure.mgmt.machinelearningservices.models.MonitoringSignalType
    :ivar feature_data_type_override: A dictionary that maps feature names to their respective data
     types.
    :vartype feature_data_type_override: dict[str, str or
     ~azure.mgmt.machinelearningservices.models.MonitoringFeatureDataType]
    :ivar feature_importance_settings: The settings for computing feature importance.
    :vartype feature_importance_settings:
     ~azure.mgmt.machinelearningservices.models.FeatureImportanceSettings
    :ivar features: The features to calculate drift over.
    :vartype features: ~azure.mgmt.machinelearningservices.models.MonitoringFeatureFilterBase
    :ivar metric_thresholds: Required. [Required] A list of metrics to calculate and their
     associated thresholds.
    :vartype metric_thresholds:
     list[~azure.mgmt.machinelearningservices.models.DataQualityMetricThresholdBase]
    :ivar production_data: Required. [Required] The data produced by the production service which
     drift will be calculated for.
    :vartype production_data: ~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase
    :ivar reference_data: Required. [Required] The data to calculate drift against.
    :vartype reference_data: ~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase
    """

    _validation = {
        'signal_type': {'required': True},
        'metric_thresholds': {'required': True},
        'production_data': {'required': True},
        'reference_data': {'required': True},
    }

    _attribute_map = {
        'notification_types': {'key': 'notificationTypes', 'type': '[str]'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'signal_type': {'key': 'signalType', 'type': 'str'},
        'feature_data_type_override': {'key': 'featureDataTypeOverride', 'type': '{str}'},
        'feature_importance_settings': {'key': 'featureImportanceSettings', 'type': 'FeatureImportanceSettings'},
        'features': {'key': 'features', 'type': 'MonitoringFeatureFilterBase'},
        'metric_thresholds': {'key': 'metricThresholds', 'type': '[DataQualityMetricThresholdBase]'},
        'production_data': {'key': 'productionData', 'type': 'MonitoringInputDataBase'},
        'reference_data': {'key': 'referenceData', 'type': 'MonitoringInputDataBase'},
    }

    def __init__(
        self,
        *,
        metric_thresholds: List["DataQualityMetricThresholdBase"],
        production_data: "MonitoringInputDataBase",
        reference_data: "MonitoringInputDataBase",
        notification_types: Optional[List[Union[str, "MonitoringNotificationType"]]] = None,
        properties: Optional[Dict[str, str]] = None,
        feature_data_type_override: Optional[Dict[str, Union[str, "MonitoringFeatureDataType"]]] = None,
        feature_importance_settings: Optional["FeatureImportanceSettings"] = None,
        features: Optional["MonitoringFeatureFilterBase"] = None,
        **kwargs
    ):
        """
        :keyword notification_types: The current notification mode for this signal.
        :paramtype notification_types: list[str or
         ~azure.mgmt.machinelearningservices.models.MonitoringNotificationType]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword feature_data_type_override: A dictionary that maps feature names to their respective
         data types.
        :paramtype feature_data_type_override: dict[str, str or
         ~azure.mgmt.machinelearningservices.models.MonitoringFeatureDataType]
        :keyword feature_importance_settings: The settings for computing feature importance.
        :paramtype feature_importance_settings:
         ~azure.mgmt.machinelearningservices.models.FeatureImportanceSettings
        :keyword features: The features to calculate drift over.
        :paramtype features: ~azure.mgmt.machinelearningservices.models.MonitoringFeatureFilterBase
        :keyword metric_thresholds: Required. [Required] A list of metrics to calculate and their
         associated thresholds.
        :paramtype metric_thresholds:
         list[~azure.mgmt.machinelearningservices.models.DataQualityMetricThresholdBase]
        :keyword production_data: Required. [Required] The data produced by the production service
         which drift will be calculated for.
        :paramtype production_data: ~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase
        :keyword reference_data: Required. [Required] The data to calculate drift against.
        :paramtype reference_data: ~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase
        """
        super(DataQualityMonitoringSignal, self).__init__(notification_types=notification_types, properties=properties, **kwargs)
        self.signal_type = 'DataQuality'  # type: str
        self.feature_data_type_override = feature_data_type_override
        self.feature_importance_settings = feature_importance_settings
        self.features = features
        self.metric_thresholds = metric_thresholds
        self.production_data = production_data
        self.reference_data = reference_data


class DatasetExportSummary(ExportSummary):
    """DatasetExportSummary.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar end_date_time: The time when the export was completed.
    :vartype end_date_time: ~datetime.datetime
    :ivar exported_row_count: The total number of labeled datapoints exported.
    :vartype exported_row_count: long
    :ivar format: Required. [Required] The format of exported labels, also as the
     discriminator.Constant filled by server. Possible values include: "Dataset", "Coco", "CSV".
    :vartype format: str or ~azure.mgmt.machinelearningservices.models.ExportFormatType
    :ivar labeling_job_id: Name and identifier of the job containing exported labels.
    :vartype labeling_job_id: str
    :ivar start_date_time: The time when the export was requested.
    :vartype start_date_time: ~datetime.datetime
    :ivar labeled_asset_name: The unique name of the labeled data asset.
    :vartype labeled_asset_name: str
    """

    _validation = {
        'end_date_time': {'readonly': True},
        'exported_row_count': {'readonly': True},
        'format': {'required': True},
        'labeling_job_id': {'readonly': True},
        'start_date_time': {'readonly': True},
        'labeled_asset_name': {'readonly': True},
    }

    _attribute_map = {
        'end_date_time': {'key': 'endDateTime', 'type': 'iso-8601'},
        'exported_row_count': {'key': 'exportedRowCount', 'type': 'long'},
        'format': {'key': 'format', 'type': 'str'},
        'labeling_job_id': {'key': 'labelingJobId', 'type': 'str'},
        'start_date_time': {'key': 'startDateTime', 'type': 'iso-8601'},
        'labeled_asset_name': {'key': 'labeledAssetName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DatasetExportSummary, self).__init__(**kwargs)
        self.format = 'Dataset'  # type: str
        self.labeled_asset_name = None


class Datastore(ProxyResource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.DatastoreProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'DatastoreProperties'},
    }

    def __init__(
        self,
        *,
        properties: "DatastoreProperties",
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.DatastoreProperties
        """
        super(Datastore, self).__init__(**kwargs)
        self.properties = properties


class DatastoreResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of Datastore entities.

    :ivar next_link: The link to the next page of Datastore objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type Datastore.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.Datastore]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Datastore]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["Datastore"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of Datastore objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type Datastore.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.Datastore]
        """
        super(DatastoreResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class DataVersionBase(ProxyResource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.DataVersionBaseProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'DataVersionBaseProperties'},
    }

    def __init__(
        self,
        *,
        properties: "DataVersionBaseProperties",
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.DataVersionBaseProperties
        """
        super(DataVersionBase, self).__init__(**kwargs)
        self.properties = properties


class DataVersionBaseResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of DataVersionBase entities.

    :ivar next_link: The link to the next page of DataVersionBase objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type DataVersionBase.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.DataVersionBase]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[DataVersionBase]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["DataVersionBase"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of DataVersionBase objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type DataVersionBase.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.DataVersionBase]
        """
        super(DataVersionBaseResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class OnlineScaleSettings(msrest.serialization.Model):
    """Online deployment scaling configuration.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DefaultScaleSettings, TargetUtilizationScaleSettings.

    All required parameters must be populated in order to send to Azure.

    :ivar scale_type: Required. [Required] Type of deployment scaling algorithm.Constant filled by
     server. Possible values include: "Default", "TargetUtilization".
    :vartype scale_type: str or ~azure.mgmt.machinelearningservices.models.ScaleType
    """

    _validation = {
        'scale_type': {'required': True},
    }

    _attribute_map = {
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    _subtype_map = {
        'scale_type': {'Default': 'DefaultScaleSettings', 'TargetUtilization': 'TargetUtilizationScaleSettings'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(OnlineScaleSettings, self).__init__(**kwargs)
        self.scale_type = None  # type: Optional[str]


class DefaultScaleSettings(OnlineScaleSettings):
    """DefaultScaleSettings.

    All required parameters must be populated in order to send to Azure.

    :ivar scale_type: Required. [Required] Type of deployment scaling algorithm.Constant filled by
     server. Possible values include: "Default", "TargetUtilization".
    :vartype scale_type: str or ~azure.mgmt.machinelearningservices.models.ScaleType
    """

    _validation = {
        'scale_type': {'required': True},
    }

    _attribute_map = {
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DefaultScaleSettings, self).__init__(**kwargs)
        self.scale_type = 'Default'  # type: str


class DeploymentLogs(msrest.serialization.Model):
    """DeploymentLogs.

    :ivar content: The retrieved online deployment logs.
    :vartype content: str
    """

    _attribute_map = {
        'content': {'key': 'content', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        content: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword content: The retrieved online deployment logs.
        :paramtype content: str
        """
        super(DeploymentLogs, self).__init__(**kwargs)
        self.content = content


class DeploymentLogsRequest(msrest.serialization.Model):
    """DeploymentLogsRequest.

    :ivar container_type: The type of container to retrieve logs from. Possible values include:
     "StorageInitializer", "InferenceServer", "ModelDataCollector".
    :vartype container_type: str or ~azure.mgmt.machinelearningservices.models.ContainerType
    :ivar tail: The maximum number of lines to tail.
    :vartype tail: int
    """

    _attribute_map = {
        'container_type': {'key': 'containerType', 'type': 'str'},
        'tail': {'key': 'tail', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        container_type: Optional[Union[str, "ContainerType"]] = None,
        tail: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword container_type: The type of container to retrieve logs from. Possible values include:
         "StorageInitializer", "InferenceServer", "ModelDataCollector".
        :paramtype container_type: str or ~azure.mgmt.machinelearningservices.models.ContainerType
        :keyword tail: The maximum number of lines to tail.
        :paramtype tail: int
        """
        super(DeploymentLogsRequest, self).__init__(**kwargs)
        self.container_type = container_type
        self.tail = tail


class ResourceConfiguration(msrest.serialization.Model):
    """ResourceConfiguration.

    :ivar instance_count: Optional number of instances or nodes used by the compute target.
    :vartype instance_count: int
    :ivar instance_type: Optional type of VM used as supported by the compute target.
    :vartype instance_type: str
    :ivar locations: Locations where the job can run.
    :vartype locations: list[str]
    :ivar max_instance_count: Optional max allowed number of instances or nodes to be used by the
     compute target.
     For use with elastic training, currently supported by PyTorch distribution type only.
    :vartype max_instance_count: int
    :ivar properties: Additional properties bag.
    :vartype properties: dict[str, any]
    """

    _attribute_map = {
        'instance_count': {'key': 'instanceCount', 'type': 'int'},
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'max_instance_count': {'key': 'maxInstanceCount', 'type': 'int'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        instance_count: Optional[int] = 1,
        instance_type: Optional[str] = None,
        locations: Optional[List[str]] = None,
        max_instance_count: Optional[int] = None,
        properties: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        """
        :keyword instance_count: Optional number of instances or nodes used by the compute target.
        :paramtype instance_count: int
        :keyword instance_type: Optional type of VM used as supported by the compute target.
        :paramtype instance_type: str
        :keyword locations: Locations where the job can run.
        :paramtype locations: list[str]
        :keyword max_instance_count: Optional max allowed number of instances or nodes to be used by
         the compute target.
         For use with elastic training, currently supported by PyTorch distribution type only.
        :paramtype max_instance_count: int
        :keyword properties: Additional properties bag.
        :paramtype properties: dict[str, any]
        """
        super(ResourceConfiguration, self).__init__(**kwargs)
        self.instance_count = instance_count
        self.instance_type = instance_type
        self.locations = locations
        self.max_instance_count = max_instance_count
        self.properties = properties


class DeploymentResourceConfiguration(ResourceConfiguration):
    """DeploymentResourceConfiguration.

    :ivar instance_count: Optional number of instances or nodes used by the compute target.
    :vartype instance_count: int
    :ivar instance_type: Optional type of VM used as supported by the compute target.
    :vartype instance_type: str
    :ivar locations: Locations where the job can run.
    :vartype locations: list[str]
    :ivar max_instance_count: Optional max allowed number of instances or nodes to be used by the
     compute target.
     For use with elastic training, currently supported by PyTorch distribution type only.
    :vartype max_instance_count: int
    :ivar properties: Additional properties bag.
    :vartype properties: dict[str, any]
    """

    _attribute_map = {
        'instance_count': {'key': 'instanceCount', 'type': 'int'},
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'max_instance_count': {'key': 'maxInstanceCount', 'type': 'int'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        instance_count: Optional[int] = 1,
        instance_type: Optional[str] = None,
        locations: Optional[List[str]] = None,
        max_instance_count: Optional[int] = None,
        properties: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        """
        :keyword instance_count: Optional number of instances or nodes used by the compute target.
        :paramtype instance_count: int
        :keyword instance_type: Optional type of VM used as supported by the compute target.
        :paramtype instance_type: str
        :keyword locations: Locations where the job can run.
        :paramtype locations: list[str]
        :keyword max_instance_count: Optional max allowed number of instances or nodes to be used by
         the compute target.
         For use with elastic training, currently supported by PyTorch distribution type only.
        :paramtype max_instance_count: int
        :keyword properties: Additional properties bag.
        :paramtype properties: dict[str, any]
        """
        super(DeploymentResourceConfiguration, self).__init__(instance_count=instance_count, instance_type=instance_type, locations=locations, max_instance_count=max_instance_count, properties=properties, **kwargs)


class DestinationAsset(msrest.serialization.Model):
    """Publishing destination registry asset information.

    :ivar destination_name: Destination asset name.
    :vartype destination_name: str
    :ivar destination_version: Destination asset version.
    :vartype destination_version: str
    :ivar registry_name: Destination registry name.
    :vartype registry_name: str
    """

    _attribute_map = {
        'destination_name': {'key': 'destinationName', 'type': 'str'},
        'destination_version': {'key': 'destinationVersion', 'type': 'str'},
        'registry_name': {'key': 'registryName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        destination_name: Optional[str] = None,
        destination_version: Optional[str] = None,
        registry_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword destination_name: Destination asset name.
        :paramtype destination_name: str
        :keyword destination_version: Destination asset version.
        :paramtype destination_version: str
        :keyword registry_name: Destination registry name.
        :paramtype registry_name: str
        """
        super(DestinationAsset, self).__init__(**kwargs)
        self.destination_name = destination_name
        self.destination_version = destination_version
        self.registry_name = registry_name


class DiagnoseRequestProperties(msrest.serialization.Model):
    """DiagnoseRequestProperties.

    :ivar application_insights: Setting for diagnosing dependent application insights.
    :vartype application_insights: dict[str, any]
    :ivar container_registry: Setting for diagnosing dependent container registry.
    :vartype container_registry: dict[str, any]
    :ivar dns_resolution: Setting for diagnosing dns resolution.
    :vartype dns_resolution: dict[str, any]
    :ivar key_vault: Setting for diagnosing dependent key vault.
    :vartype key_vault: dict[str, any]
    :ivar nsg: Setting for diagnosing network security group.
    :vartype nsg: dict[str, any]
    :ivar others: Setting for diagnosing unclassified category of problems.
    :vartype others: dict[str, any]
    :ivar required_resource_providers: Setting for diagnosing the presence of required resource
     providers in the workspace.
    :vartype required_resource_providers: dict[str, any]
    :ivar resource_lock: Setting for diagnosing resource lock.
    :vartype resource_lock: dict[str, any]
    :ivar storage_account: Setting for diagnosing dependent storage account.
    :vartype storage_account: dict[str, any]
    :ivar udr: Setting for diagnosing user defined routing.
    :vartype udr: dict[str, any]
    """

    _attribute_map = {
        'application_insights': {'key': 'applicationInsights', 'type': '{object}'},
        'container_registry': {'key': 'containerRegistry', 'type': '{object}'},
        'dns_resolution': {'key': 'dnsResolution', 'type': '{object}'},
        'key_vault': {'key': 'keyVault', 'type': '{object}'},
        'nsg': {'key': 'nsg', 'type': '{object}'},
        'others': {'key': 'others', 'type': '{object}'},
        'required_resource_providers': {'key': 'requiredResourceProviders', 'type': '{object}'},
        'resource_lock': {'key': 'resourceLock', 'type': '{object}'},
        'storage_account': {'key': 'storageAccount', 'type': '{object}'},
        'udr': {'key': 'udr', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        application_insights: Optional[Dict[str, Any]] = None,
        container_registry: Optional[Dict[str, Any]] = None,
        dns_resolution: Optional[Dict[str, Any]] = None,
        key_vault: Optional[Dict[str, Any]] = None,
        nsg: Optional[Dict[str, Any]] = None,
        others: Optional[Dict[str, Any]] = None,
        required_resource_providers: Optional[Dict[str, Any]] = None,
        resource_lock: Optional[Dict[str, Any]] = None,
        storage_account: Optional[Dict[str, Any]] = None,
        udr: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        """
        :keyword application_insights: Setting for diagnosing dependent application insights.
        :paramtype application_insights: dict[str, any]
        :keyword container_registry: Setting for diagnosing dependent container registry.
        :paramtype container_registry: dict[str, any]
        :keyword dns_resolution: Setting for diagnosing dns resolution.
        :paramtype dns_resolution: dict[str, any]
        :keyword key_vault: Setting for diagnosing dependent key vault.
        :paramtype key_vault: dict[str, any]
        :keyword nsg: Setting for diagnosing network security group.
        :paramtype nsg: dict[str, any]
        :keyword others: Setting for diagnosing unclassified category of problems.
        :paramtype others: dict[str, any]
        :keyword required_resource_providers: Setting for diagnosing the presence of required resource
         providers in the workspace.
        :paramtype required_resource_providers: dict[str, any]
        :keyword resource_lock: Setting for diagnosing resource lock.
        :paramtype resource_lock: dict[str, any]
        :keyword storage_account: Setting for diagnosing dependent storage account.
        :paramtype storage_account: dict[str, any]
        :keyword udr: Setting for diagnosing user defined routing.
        :paramtype udr: dict[str, any]
        """
        super(DiagnoseRequestProperties, self).__init__(**kwargs)
        self.application_insights = application_insights
        self.container_registry = container_registry
        self.dns_resolution = dns_resolution
        self.key_vault = key_vault
        self.nsg = nsg
        self.others = others
        self.required_resource_providers = required_resource_providers
        self.resource_lock = resource_lock
        self.storage_account = storage_account
        self.udr = udr


class DiagnoseResponseResult(msrest.serialization.Model):
    """DiagnoseResponseResult.

    :ivar value:
    :vartype value: ~azure.mgmt.machinelearningservices.models.DiagnoseResponseResultValue
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'DiagnoseResponseResultValue'},
    }

    def __init__(
        self,
        *,
        value: Optional["DiagnoseResponseResultValue"] = None,
        **kwargs
    ):
        """
        :keyword value:
        :paramtype value: ~azure.mgmt.machinelearningservices.models.DiagnoseResponseResultValue
        """
        super(DiagnoseResponseResult, self).__init__(**kwargs)
        self.value = value


class DiagnoseResponseResultValue(msrest.serialization.Model):
    """DiagnoseResponseResultValue.

    :ivar user_defined_route_results:
    :vartype user_defined_route_results:
     list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar network_security_rule_results:
    :vartype network_security_rule_results:
     list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar resource_lock_results:
    :vartype resource_lock_results: list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar dns_resolution_results:
    :vartype dns_resolution_results:
     list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar storage_account_results:
    :vartype storage_account_results:
     list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar key_vault_results:
    :vartype key_vault_results: list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar container_registry_results:
    :vartype container_registry_results:
     list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar application_insights_results:
    :vartype application_insights_results:
     list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar other_results:
    :vartype other_results: list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    """

    _attribute_map = {
        'user_defined_route_results': {'key': 'userDefinedRouteResults', 'type': '[DiagnoseResult]'},
        'network_security_rule_results': {'key': 'networkSecurityRuleResults', 'type': '[DiagnoseResult]'},
        'resource_lock_results': {'key': 'resourceLockResults', 'type': '[DiagnoseResult]'},
        'dns_resolution_results': {'key': 'dnsResolutionResults', 'type': '[DiagnoseResult]'},
        'storage_account_results': {'key': 'storageAccountResults', 'type': '[DiagnoseResult]'},
        'key_vault_results': {'key': 'keyVaultResults', 'type': '[DiagnoseResult]'},
        'container_registry_results': {'key': 'containerRegistryResults', 'type': '[DiagnoseResult]'},
        'application_insights_results': {'key': 'applicationInsightsResults', 'type': '[DiagnoseResult]'},
        'other_results': {'key': 'otherResults', 'type': '[DiagnoseResult]'},
    }

    def __init__(
        self,
        *,
        user_defined_route_results: Optional[List["DiagnoseResult"]] = None,
        network_security_rule_results: Optional[List["DiagnoseResult"]] = None,
        resource_lock_results: Optional[List["DiagnoseResult"]] = None,
        dns_resolution_results: Optional[List["DiagnoseResult"]] = None,
        storage_account_results: Optional[List["DiagnoseResult"]] = None,
        key_vault_results: Optional[List["DiagnoseResult"]] = None,
        container_registry_results: Optional[List["DiagnoseResult"]] = None,
        application_insights_results: Optional[List["DiagnoseResult"]] = None,
        other_results: Optional[List["DiagnoseResult"]] = None,
        **kwargs
    ):
        """
        :keyword user_defined_route_results:
        :paramtype user_defined_route_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword network_security_rule_results:
        :paramtype network_security_rule_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword resource_lock_results:
        :paramtype resource_lock_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword dns_resolution_results:
        :paramtype dns_resolution_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword storage_account_results:
        :paramtype storage_account_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword key_vault_results:
        :paramtype key_vault_results: list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword container_registry_results:
        :paramtype container_registry_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword application_insights_results:
        :paramtype application_insights_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword other_results:
        :paramtype other_results: list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        """
        super(DiagnoseResponseResultValue, self).__init__(**kwargs)
        self.user_defined_route_results = user_defined_route_results
        self.network_security_rule_results = network_security_rule_results
        self.resource_lock_results = resource_lock_results
        self.dns_resolution_results = dns_resolution_results
        self.storage_account_results = storage_account_results
        self.key_vault_results = key_vault_results
        self.container_registry_results = container_registry_results
        self.application_insights_results = application_insights_results
        self.other_results = other_results


class DiagnoseResult(msrest.serialization.Model):
    """Result of Diagnose.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Code for workspace setup error.
    :vartype code: str
    :ivar level: Level of workspace setup error. Possible values include: "Warning", "Error",
     "Information".
    :vartype level: str or ~azure.mgmt.machinelearningservices.models.DiagnoseResultLevel
    :ivar message: Message of workspace setup error.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'level': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'level': {'key': 'level', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DiagnoseResult, self).__init__(**kwargs)
        self.code = None
        self.level = None
        self.message = None


class DiagnoseWorkspaceParameters(msrest.serialization.Model):
    """Parameters to diagnose a workspace.

    :ivar value:
    :vartype value: ~azure.mgmt.machinelearningservices.models.DiagnoseRequestProperties
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'DiagnoseRequestProperties'},
    }

    def __init__(
        self,
        *,
        value: Optional["DiagnoseRequestProperties"] = None,
        **kwargs
    ):
        """
        :keyword value:
        :paramtype value: ~azure.mgmt.machinelearningservices.models.DiagnoseRequestProperties
        """
        super(DiagnoseWorkspaceParameters, self).__init__(**kwargs)
        self.value = value


class DistributionConfiguration(msrest.serialization.Model):
    """Base definition for job distribution configuration.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Mpi, PyTorch, Ray, TensorFlow.

    All required parameters must be populated in order to send to Azure.

    :ivar distribution_type: Required. [Required] Specifies the type of distribution
     framework.Constant filled by server. Possible values include: "PyTorch", "TensorFlow", "Mpi",
     "Ray".
    :vartype distribution_type: str or ~azure.mgmt.machinelearningservices.models.DistributionType
    """

    _validation = {
        'distribution_type': {'required': True},
    }

    _attribute_map = {
        'distribution_type': {'key': 'distributionType', 'type': 'str'},
    }

    _subtype_map = {
        'distribution_type': {'Mpi': 'Mpi', 'PyTorch': 'PyTorch', 'Ray': 'Ray', 'TensorFlow': 'TensorFlow'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DistributionConfiguration, self).__init__(**kwargs)
        self.distribution_type = None  # type: Optional[str]


class Docker(msrest.serialization.Model):
    """Docker.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar privileged: Indicate whether container shall run in privileged or non-privileged mode.
    :vartype privileged: bool
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'privileged': {'key': 'privileged', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        privileged: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword privileged: Indicate whether container shall run in privileged or non-privileged mode.
        :paramtype privileged: bool
        """
        super(Docker, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.privileged = privileged


class DockerCredential(DataReferenceCredential):
    """Credential for docker with username and password.

    All required parameters must be populated in order to send to Azure.

    :ivar credential_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "SAS", "DockerCredentials",
     "ManagedIdentity", "NoCredentials".
    :vartype credential_type: str or
     ~azure.mgmt.machinelearningservices.models.DataReferenceCredentialType
    :ivar password: DockerCredential user password.
    :vartype password: str
    :ivar user_name: DockerCredential user name.
    :vartype user_name: str
    """

    _validation = {
        'credential_type': {'required': True},
    }

    _attribute_map = {
        'credential_type': {'key': 'credentialType', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'user_name': {'key': 'userName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        password: Optional[str] = None,
        user_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword password: DockerCredential user password.
        :paramtype password: str
        :keyword user_name: DockerCredential user name.
        :paramtype user_name: str
        """
        super(DockerCredential, self).__init__(**kwargs)
        self.credential_type = 'DockerCredentials'  # type: str
        self.password = password
        self.user_name = user_name


class EncryptionKeyVaultUpdateProperties(msrest.serialization.Model):
    """EncryptionKeyVaultUpdateProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar key_identifier: Required.
    :vartype key_identifier: str
    """

    _validation = {
        'key_identifier': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'key_identifier': {'key': 'keyIdentifier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_identifier: str,
        **kwargs
    ):
        """
        :keyword key_identifier: Required.
        :paramtype key_identifier: str
        """
        super(EncryptionKeyVaultUpdateProperties, self).__init__(**kwargs)
        self.key_identifier = key_identifier


class EncryptionProperty(msrest.serialization.Model):
    """EncryptionProperty.

    All required parameters must be populated in order to send to Azure.

    :ivar cosmos_db_resource_id: The byok cosmosdb account that customer brings to store customer's
     data
     with encryption.
    :vartype cosmos_db_resource_id: str
    :ivar identity: Identity to be used with the keyVault.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.IdentityForCmk
    :ivar key_vault_properties: Required. KeyVault details to do the encryption.
    :vartype key_vault_properties: ~azure.mgmt.machinelearningservices.models.KeyVaultProperties
    :ivar search_account_resource_id: The byok search account that customer brings to store
     customer's data
     with encryption.
    :vartype search_account_resource_id: str
    :ivar status: Required. Indicates whether or not the encryption is enabled for the workspace.
     Possible values include: "Enabled", "Disabled".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.EncryptionStatus
    :ivar storage_account_resource_id: The byok storage account that customer brings to store
     customer's data
     with encryption.
    :vartype storage_account_resource_id: str
    """

    _validation = {
        'key_vault_properties': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'cosmos_db_resource_id': {'key': 'cosmosDbResourceId', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'IdentityForCmk'},
        'key_vault_properties': {'key': 'keyVaultProperties', 'type': 'KeyVaultProperties'},
        'search_account_resource_id': {'key': 'searchAccountResourceId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'storage_account_resource_id': {'key': 'storageAccountResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_vault_properties: "KeyVaultProperties",
        status: Union[str, "EncryptionStatus"],
        cosmos_db_resource_id: Optional[str] = None,
        identity: Optional["IdentityForCmk"] = None,
        search_account_resource_id: Optional[str] = None,
        storage_account_resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword cosmos_db_resource_id: The byok cosmosdb account that customer brings to store
         customer's data
         with encryption.
        :paramtype cosmos_db_resource_id: str
        :keyword identity: Identity to be used with the keyVault.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.IdentityForCmk
        :keyword key_vault_properties: Required. KeyVault details to do the encryption.
        :paramtype key_vault_properties: ~azure.mgmt.machinelearningservices.models.KeyVaultProperties
        :keyword search_account_resource_id: The byok search account that customer brings to store
         customer's data
         with encryption.
        :paramtype search_account_resource_id: str
        :keyword status: Required. Indicates whether or not the encryption is enabled for the
         workspace. Possible values include: "Enabled", "Disabled".
        :paramtype status: str or ~azure.mgmt.machinelearningservices.models.EncryptionStatus
        :keyword storage_account_resource_id: The byok storage account that customer brings to store
         customer's data
         with encryption.
        :paramtype storage_account_resource_id: str
        """
        super(EncryptionProperty, self).__init__(**kwargs)
        self.cosmos_db_resource_id = cosmos_db_resource_id
        self.identity = identity
        self.key_vault_properties = key_vault_properties
        self.search_account_resource_id = search_account_resource_id
        self.status = status
        self.storage_account_resource_id = storage_account_resource_id


class EncryptionUpdateProperties(msrest.serialization.Model):
    """EncryptionUpdateProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar key_vault_properties: Required.
    :vartype key_vault_properties:
     ~azure.mgmt.machinelearningservices.models.EncryptionKeyVaultUpdateProperties
    """

    _validation = {
        'key_vault_properties': {'required': True},
    }

    _attribute_map = {
        'key_vault_properties': {'key': 'keyVaultProperties', 'type': 'EncryptionKeyVaultUpdateProperties'},
    }

    def __init__(
        self,
        *,
        key_vault_properties: "EncryptionKeyVaultUpdateProperties",
        **kwargs
    ):
        """
        :keyword key_vault_properties: Required.
        :paramtype key_vault_properties:
         ~azure.mgmt.machinelearningservices.models.EncryptionKeyVaultUpdateProperties
        """
        super(EncryptionUpdateProperties, self).__init__(**kwargs)
        self.key_vault_properties = key_vault_properties


class Endpoint(msrest.serialization.Model):
    """Endpoint.

    :ivar protocol: Protocol over which communication will happen over this endpoint. Possible
     values include: "tcp", "udp", "http". Default value: "tcp".
    :vartype protocol: str or ~azure.mgmt.machinelearningservices.models.Protocol
    :ivar name: Name of the Endpoint.
    :vartype name: str
    :ivar target: Application port inside the container.
    :vartype target: int
    :ivar published: Port over which the application is exposed from container.
    :vartype published: int
    :ivar host_ip: Host IP over which the application is exposed from the container.
    :vartype host_ip: str
    """

    _attribute_map = {
        'protocol': {'key': 'protocol', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'target': {'key': 'target', 'type': 'int'},
        'published': {'key': 'published', 'type': 'int'},
        'host_ip': {'key': 'hostIp', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        protocol: Optional[Union[str, "Protocol"]] = "tcp",
        name: Optional[str] = None,
        target: Optional[int] = None,
        published: Optional[int] = None,
        host_ip: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword protocol: Protocol over which communication will happen over this endpoint. Possible
         values include: "tcp", "udp", "http". Default value: "tcp".
        :paramtype protocol: str or ~azure.mgmt.machinelearningservices.models.Protocol
        :keyword name: Name of the Endpoint.
        :paramtype name: str
        :keyword target: Application port inside the container.
        :paramtype target: int
        :keyword published: Port over which the application is exposed from container.
        :paramtype published: int
        :keyword host_ip: Host IP over which the application is exposed from the container.
        :paramtype host_ip: str
        """
        super(Endpoint, self).__init__(**kwargs)
        self.protocol = protocol
        self.name = name
        self.target = target
        self.published = published
        self.host_ip = host_ip


class EndpointAuthKeys(msrest.serialization.Model):
    """Keys for endpoint authentication.

    :ivar primary_key: The primary key.
    :vartype primary_key: str
    :ivar secondary_key: The secondary key.
    :vartype secondary_key: str
    """

    _attribute_map = {
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'secondaryKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        primary_key: Optional[str] = None,
        secondary_key: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword primary_key: The primary key.
        :paramtype primary_key: str
        :keyword secondary_key: The secondary key.
        :paramtype secondary_key: str
        """
        super(EndpointAuthKeys, self).__init__(**kwargs)
        self.primary_key = primary_key
        self.secondary_key = secondary_key


class EndpointAuthToken(msrest.serialization.Model):
    """Service Token.

    :ivar access_token: Access token for endpoint authentication.
    :vartype access_token: str
    :ivar expiry_time_utc: Access token expiry time (UTC).
    :vartype expiry_time_utc: long
    :ivar refresh_after_time_utc: Refresh access token after time (UTC).
    :vartype refresh_after_time_utc: long
    :ivar token_type: Access token type.
    :vartype token_type: str
    """

    _attribute_map = {
        'access_token': {'key': 'accessToken', 'type': 'str'},
        'expiry_time_utc': {'key': 'expiryTimeUtc', 'type': 'long'},
        'refresh_after_time_utc': {'key': 'refreshAfterTimeUtc', 'type': 'long'},
        'token_type': {'key': 'tokenType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        access_token: Optional[str] = None,
        expiry_time_utc: Optional[int] = 0,
        refresh_after_time_utc: Optional[int] = 0,
        token_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword access_token: Access token for endpoint authentication.
        :paramtype access_token: str
        :keyword expiry_time_utc: Access token expiry time (UTC).
        :paramtype expiry_time_utc: long
        :keyword refresh_after_time_utc: Refresh access token after time (UTC).
        :paramtype refresh_after_time_utc: long
        :keyword token_type: Access token type.
        :paramtype token_type: str
        """
        super(EndpointAuthToken, self).__init__(**kwargs)
        self.access_token = access_token
        self.expiry_time_utc = expiry_time_utc
        self.refresh_after_time_utc = refresh_after_time_utc
        self.token_type = token_type


class EndpointDeploymentModel(msrest.serialization.Model):
    """EndpointDeploymentModel.

    :ivar format: Model format.
    :vartype format: str
    :ivar name: Model name.
    :vartype name: str
    :ivar source: Optional. Deployment model source ARM resource ID.
    :vartype source: str
    :ivar version: Model version.
    :vartype version: str
    """

    _attribute_map = {
        'format': {'key': 'format', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        format: Optional[str] = None,
        name: Optional[str] = None,
        source: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword format: Model format.
        :paramtype format: str
        :keyword name: Model name.
        :paramtype name: str
        :keyword source: Optional. Deployment model source ARM resource ID.
        :paramtype source: str
        :keyword version: Model version.
        :paramtype version: str
        """
        super(EndpointDeploymentModel, self).__init__(**kwargs)
        self.format = format
        self.name = name
        self.source = source
        self.version = version


class EndpointDeploymentResourcePropertiesBasicResource(Resource):
    """EndpointDeploymentResourcePropertiesBasicResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required.
    :vartype properties:
     ~azure.mgmt.machinelearningservices.models.EndpointDeploymentResourceProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'EndpointDeploymentResourceProperties'},
    }

    def __init__(
        self,
        *,
        properties: "EndpointDeploymentResourceProperties",
        **kwargs
    ):
        """
        :keyword properties: Required.
        :paramtype properties:
         ~azure.mgmt.machinelearningservices.models.EndpointDeploymentResourceProperties
        """
        super(EndpointDeploymentResourcePropertiesBasicResource, self).__init__(**kwargs)
        self.properties = properties


class EndpointDeploymentResourcePropertiesBasicResourceArmPaginatedResult(msrest.serialization.Model):
    """EndpointDeploymentResourcePropertiesBasicResourceArmPaginatedResult.

    :ivar next_link:
    :vartype next_link: str
    :ivar value:
    :vartype value:
     list[~azure.mgmt.machinelearningservices.models.EndpointDeploymentResourcePropertiesBasicResource]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[EndpointDeploymentResourcePropertiesBasicResource]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["EndpointDeploymentResourcePropertiesBasicResource"]] = None,
        **kwargs
    ):
        """
        :keyword next_link:
        :paramtype next_link: str
        :keyword value:
        :paramtype value:
         list[~azure.mgmt.machinelearningservices.models.EndpointDeploymentResourcePropertiesBasicResource]
        """
        super(EndpointDeploymentResourcePropertiesBasicResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class EndpointKeys(msrest.serialization.Model):
    """EndpointKeys.

    :ivar keys: Dictionary of Keys for the endpoint.
    :vartype keys: ~azure.mgmt.machinelearningservices.models.AccountApiKeys
    """

    _attribute_map = {
        'keys': {'key': 'keys', 'type': 'AccountApiKeys'},
    }

    def __init__(
        self,
        *,
        keys: Optional["AccountApiKeys"] = None,
        **kwargs
    ):
        """
        :keyword keys: Dictionary of Keys for the endpoint.
        :paramtype keys: ~azure.mgmt.machinelearningservices.models.AccountApiKeys
        """
        super(EndpointKeys, self).__init__(**kwargs)
        self.keys = keys


class EndpointModels(msrest.serialization.Model):
    """EndpointModels.

    :ivar next_link: The link to the next page constructed using the continuationToken.  If null,
     there are no additional pages.
    :vartype next_link: str
    :ivar value: List of models.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.AccountModel]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[AccountModel]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["AccountModel"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page constructed using the continuationToken.  If
         null, there are no additional pages.
        :paramtype next_link: str
        :keyword value: List of models.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.AccountModel]
        """
        super(EndpointModels, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class EndpointResourcePropertiesBasicResource(Resource):
    """EndpointResourcePropertiesBasicResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.EndpointResourceProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'EndpointResourceProperties'},
    }

    def __init__(
        self,
        *,
        properties: "EndpointResourceProperties",
        **kwargs
    ):
        """
        :keyword properties: Required.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.EndpointResourceProperties
        """
        super(EndpointResourcePropertiesBasicResource, self).__init__(**kwargs)
        self.properties = properties


class EndpointResourcePropertiesBasicResourceArmPaginatedResult(msrest.serialization.Model):
    """EndpointResourcePropertiesBasicResourceArmPaginatedResult.

    :ivar next_link:
    :vartype next_link: str
    :ivar value:
    :vartype value:
     list[~azure.mgmt.machinelearningservices.models.EndpointResourcePropertiesBasicResource]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[EndpointResourcePropertiesBasicResource]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["EndpointResourcePropertiesBasicResource"]] = None,
        **kwargs
    ):
        """
        :keyword next_link:
        :paramtype next_link: str
        :keyword value:
        :paramtype value:
         list[~azure.mgmt.machinelearningservices.models.EndpointResourcePropertiesBasicResource]
        """
        super(EndpointResourcePropertiesBasicResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class EndpointScheduleAction(ScheduleActionBase):
    """EndpointScheduleAction.

    All required parameters must be populated in order to send to Azure.

    :ivar action_type: Required. [Required] Specifies the action type of the schedule.Constant
     filled by server. Possible values include: "CreateJob", "InvokeBatchEndpoint", "ImportData",
     "CreateMonitor".
    :vartype action_type: str or ~azure.mgmt.machinelearningservices.models.ScheduleActionType
    :ivar endpoint_invocation_definition: Required. [Required] Defines Schedule action definition
     details.
    
    
     .. raw:: html
    
        <see href="TBD" />.
    :vartype endpoint_invocation_definition: any
    """

    _validation = {
        'action_type': {'required': True},
        'endpoint_invocation_definition': {'required': True},
    }

    _attribute_map = {
        'action_type': {'key': 'actionType', 'type': 'str'},
        'endpoint_invocation_definition': {'key': 'endpointInvocationDefinition', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        endpoint_invocation_definition: Any,
        **kwargs
    ):
        """
        :keyword endpoint_invocation_definition: Required. [Required] Defines Schedule action
         definition details.
        
        
         .. raw:: html
        
            <see href="TBD" />.
        :paramtype endpoint_invocation_definition: any
        """
        super(EndpointScheduleAction, self).__init__(**kwargs)
        self.action_type = 'InvokeBatchEndpoint'  # type: str
        self.endpoint_invocation_definition = endpoint_invocation_definition


class EnvironmentContainer(ProxyResource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.EnvironmentContainerProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'EnvironmentContainerProperties'},
    }

    def __init__(
        self,
        *,
        properties: "EnvironmentContainerProperties",
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties:
         ~azure.mgmt.machinelearningservices.models.EnvironmentContainerProperties
        """
        super(EnvironmentContainer, self).__init__(**kwargs)
        self.properties = properties


class EnvironmentContainerProperties(AssetContainer):
    """Container for environment specification versions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar latest_version: The latest version inside this container.
    :vartype latest_version: str
    :ivar next_version: The next auto incremental version.
    :vartype next_version: str
    :ivar provisioning_state: Provisioning state for the environment container. Possible values
     include: "Succeeded", "Failed", "Canceled", "Creating", "Updating", "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.AssetProvisioningState
    """

    _validation = {
        'latest_version': {'readonly': True},
        'next_version': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'latest_version': {'key': 'latestVersion', 'type': 'str'},
        'next_version': {'key': 'nextVersion', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_archived: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        """
        super(EnvironmentContainerProperties, self).__init__(description=description, properties=properties, tags=tags, is_archived=is_archived, **kwargs)
        self.provisioning_state = None


class EnvironmentContainerResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of EnvironmentContainer entities.

    :ivar next_link: The link to the next page of EnvironmentContainer objects. If null, there are
     no additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type EnvironmentContainer.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.EnvironmentContainer]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[EnvironmentContainer]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["EnvironmentContainer"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of EnvironmentContainer objects. If null, there
         are no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type EnvironmentContainer.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.EnvironmentContainer]
        """
        super(EnvironmentContainerResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class EnvironmentVariable(msrest.serialization.Model):
    """EnvironmentVariable.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar type: Type of the Environment Variable. Possible values are: local - For local variable.
     Possible values include: "local". Default value: "local".
    :vartype type: str or ~azure.mgmt.machinelearningservices.models.EnvironmentVariableType
    :ivar value: Value of the Environment variable.
    :vartype value: str
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        type: Optional[Union[str, "EnvironmentVariableType"]] = "local",
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword type: Type of the Environment Variable. Possible values are: local - For local
         variable. Possible values include: "local". Default value: "local".
        :paramtype type: str or ~azure.mgmt.machinelearningservices.models.EnvironmentVariableType
        :keyword value: Value of the Environment variable.
        :paramtype value: str
        """
        super(EnvironmentVariable, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = type
        self.value = value


class EnvironmentVersion(ProxyResource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.EnvironmentVersionProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'EnvironmentVersionProperties'},
    }

    def __init__(
        self,
        *,
        properties: "EnvironmentVersionProperties",
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.EnvironmentVersionProperties
        """
        super(EnvironmentVersion, self).__init__(**kwargs)
        self.properties = properties


class EnvironmentVersionProperties(AssetBase):
    """Environment version details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar auto_delete_setting: Specifies the lifecycle setting of managed data asset.
    :vartype auto_delete_setting: ~azure.mgmt.machinelearningservices.models.AutoDeleteSetting
    :ivar is_anonymous: If the name version are system generated (anonymous registration). For
     types where Stage is defined, when Stage is provided it will be used to populate IsAnonymous.
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived? For types where Stage is defined, when Stage is
     provided it will be used to populate IsArchived.
    :vartype is_archived: bool
    :ivar auto_rebuild: Defines if image needs to be rebuilt based on base image changes. Possible
     values include: "Disabled", "OnBaseImageUpdate".
    :vartype auto_rebuild: str or ~azure.mgmt.machinelearningservices.models.AutoRebuildSetting
    :ivar build: Configuration settings for Docker build context.
    :vartype build: ~azure.mgmt.machinelearningservices.models.BuildContext
    :ivar conda_file: Standard configuration file used by Conda that lets you install any kind of
     package, including Python, R, and C/C++ packages.
    
    
     .. raw:: html
    
        <see
     href="https://repo2docker.readthedocs.io/en/latest/config_files.html#environment-yml-install-a-conda-environment"
     />.
    :vartype conda_file: str
    :ivar environment_type: Environment type is either user managed or curated by the Azure ML
     service
    
    
     .. raw:: html
    
        <see
     href="https://docs.microsoft.com/en-us/azure/machine-learning/resource-curated-environments"
     />. Possible values include: "Curated", "UserCreated".
    :vartype environment_type: str or ~azure.mgmt.machinelearningservices.models.EnvironmentType
    :ivar image: Name of the image that will be used for the environment.
    
    
     .. raw:: html
    
        <seealso
     href="https://docs.microsoft.com/en-us/azure/machine-learning/how-to-deploy-custom-docker-image#use-a-custom-base-image"
     />.
    :vartype image: str
    :ivar inference_config: Defines configuration specific to inference.
    :vartype inference_config:
     ~azure.mgmt.machinelearningservices.models.InferenceContainerProperties
    :ivar intellectual_property: Intellectual Property details. Used if environment is an
     Intellectual Property.
    :vartype intellectual_property: ~azure.mgmt.machinelearningservices.models.IntellectualProperty
    :ivar os_type: The OS type of the environment. Possible values include: "Linux", "Windows".
    :vartype os_type: str or ~azure.mgmt.machinelearningservices.models.OperatingSystemType
    :ivar provisioning_state: Provisioning state for the environment version. Possible values
     include: "Succeeded", "Failed", "Canceled", "Creating", "Updating", "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.AssetProvisioningState
    :ivar stage: Stage in the environment lifecycle assigned to this environment.
    :vartype stage: str
    """

    _validation = {
        'environment_type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'auto_delete_setting': {'key': 'autoDeleteSetting', 'type': 'AutoDeleteSetting'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'auto_rebuild': {'key': 'autoRebuild', 'type': 'str'},
        'build': {'key': 'build', 'type': 'BuildContext'},
        'conda_file': {'key': 'condaFile', 'type': 'str'},
        'environment_type': {'key': 'environmentType', 'type': 'str'},
        'image': {'key': 'image', 'type': 'str'},
        'inference_config': {'key': 'inferenceConfig', 'type': 'InferenceContainerProperties'},
        'intellectual_property': {'key': 'intellectualProperty', 'type': 'IntellectualProperty'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'stage': {'key': 'stage', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        auto_delete_setting: Optional["AutoDeleteSetting"] = None,
        is_anonymous: Optional[bool] = False,
        is_archived: Optional[bool] = False,
        auto_rebuild: Optional[Union[str, "AutoRebuildSetting"]] = None,
        build: Optional["BuildContext"] = None,
        conda_file: Optional[str] = None,
        image: Optional[str] = None,
        inference_config: Optional["InferenceContainerProperties"] = None,
        intellectual_property: Optional["IntellectualProperty"] = None,
        os_type: Optional[Union[str, "OperatingSystemType"]] = None,
        stage: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword auto_delete_setting: Specifies the lifecycle setting of managed data asset.
        :paramtype auto_delete_setting: ~azure.mgmt.machinelearningservices.models.AutoDeleteSetting
        :keyword is_anonymous: If the name version are system generated (anonymous registration). For
         types where Stage is defined, when Stage is provided it will be used to populate IsAnonymous.
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived? For types where Stage is defined, when Stage is
         provided it will be used to populate IsArchived.
        :paramtype is_archived: bool
        :keyword auto_rebuild: Defines if image needs to be rebuilt based on base image changes.
         Possible values include: "Disabled", "OnBaseImageUpdate".
        :paramtype auto_rebuild: str or ~azure.mgmt.machinelearningservices.models.AutoRebuildSetting
        :keyword build: Configuration settings for Docker build context.
        :paramtype build: ~azure.mgmt.machinelearningservices.models.BuildContext
        :keyword conda_file: Standard configuration file used by Conda that lets you install any kind
         of package, including Python, R, and C/C++ packages.
        
        
         .. raw:: html
        
            <see
         href="https://repo2docker.readthedocs.io/en/latest/config_files.html#environment-yml-install-a-conda-environment"
         />.
        :paramtype conda_file: str
        :keyword image: Name of the image that will be used for the environment.
        
        
         .. raw:: html
        
            <seealso
         href="https://docs.microsoft.com/en-us/azure/machine-learning/how-to-deploy-custom-docker-image#use-a-custom-base-image"
         />.
        :paramtype image: str
        :keyword inference_config: Defines configuration specific to inference.
        :paramtype inference_config:
         ~azure.mgmt.machinelearningservices.models.InferenceContainerProperties
        :keyword intellectual_property: Intellectual Property details. Used if environment is an
         Intellectual Property.
        :paramtype intellectual_property:
         ~azure.mgmt.machinelearningservices.models.IntellectualProperty
        :keyword os_type: The OS type of the environment. Possible values include: "Linux", "Windows".
        :paramtype os_type: str or ~azure.mgmt.machinelearningservices.models.OperatingSystemType
        :keyword stage: Stage in the environment lifecycle assigned to this environment.
        :paramtype stage: str
        """
        super(EnvironmentVersionProperties, self).__init__(description=description, properties=properties, tags=tags, auto_delete_setting=auto_delete_setting, is_anonymous=is_anonymous, is_archived=is_archived, **kwargs)
        self.auto_rebuild = auto_rebuild
        self.build = build
        self.conda_file = conda_file
        self.environment_type = None
        self.image = image
        self.inference_config = inference_config
        self.intellectual_property = intellectual_property
        self.os_type = os_type
        self.provisioning_state = None
        self.stage = stage


class EnvironmentVersionResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of EnvironmentVersion entities.

    :ivar next_link: The link to the next page of EnvironmentVersion objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type EnvironmentVersion.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.EnvironmentVersion]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[EnvironmentVersion]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["EnvironmentVersion"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of EnvironmentVersion objects. If null, there are
         no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type EnvironmentVersion.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.EnvironmentVersion]
        """
        super(EnvironmentVersionResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(msrest.serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.machinelearningservices.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.machinelearningservices.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.machinelearningservices.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorDetail"] = None,
        **kwargs
    ):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.machinelearningservices.models.ErrorDetail
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class EstimatedVMPrice(msrest.serialization.Model):
    """The estimated price info for using a VM of a particular OS type, tier, etc.

    All required parameters must be populated in order to send to Azure.

    :ivar retail_price: Required. The price charged for using the VM.
    :vartype retail_price: float
    :ivar os_type: Required. Operating system type used by the VM. Possible values include:
     "Linux", "Windows".
    :vartype os_type: str or ~azure.mgmt.machinelearningservices.models.VMPriceOSType
    :ivar vm_tier: Required. The type of the VM. Possible values include: "Standard",
     "LowPriority", "Spot".
    :vartype vm_tier: str or ~azure.mgmt.machinelearningservices.models.VMTier
    """

    _validation = {
        'retail_price': {'required': True},
        'os_type': {'required': True},
        'vm_tier': {'required': True},
    }

    _attribute_map = {
        'retail_price': {'key': 'retailPrice', 'type': 'float'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'vm_tier': {'key': 'vmTier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        retail_price: float,
        os_type: Union[str, "VMPriceOSType"],
        vm_tier: Union[str, "VMTier"],
        **kwargs
    ):
        """
        :keyword retail_price: Required. The price charged for using the VM.
        :paramtype retail_price: float
        :keyword os_type: Required. Operating system type used by the VM. Possible values include:
         "Linux", "Windows".
        :paramtype os_type: str or ~azure.mgmt.machinelearningservices.models.VMPriceOSType
        :keyword vm_tier: Required. The type of the VM. Possible values include: "Standard",
         "LowPriority", "Spot".
        :paramtype vm_tier: str or ~azure.mgmt.machinelearningservices.models.VMTier
        """
        super(EstimatedVMPrice, self).__init__(**kwargs)
        self.retail_price = retail_price
        self.os_type = os_type
        self.vm_tier = vm_tier


class EstimatedVMPrices(msrest.serialization.Model):
    """The estimated price info for using a VM.

    All required parameters must be populated in order to send to Azure.

    :ivar billing_currency: Required. Three lettered code specifying the currency of the VM price.
     Example: USD. Possible values include: "USD".
    :vartype billing_currency: str or ~azure.mgmt.machinelearningservices.models.BillingCurrency
    :ivar unit_of_measure: Required. The unit of time measurement for the specified VM price.
     Example: OneHour. Possible values include: "OneHour".
    :vartype unit_of_measure: str or ~azure.mgmt.machinelearningservices.models.UnitOfMeasure
    :ivar values: Required. The list of estimated prices for using a VM of a particular OS type,
     tier, etc.
    :vartype values: list[~azure.mgmt.machinelearningservices.models.EstimatedVMPrice]
    """

    _validation = {
        'billing_currency': {'required': True},
        'unit_of_measure': {'required': True},
        'values': {'required': True},
    }

    _attribute_map = {
        'billing_currency': {'key': 'billingCurrency', 'type': 'str'},
        'unit_of_measure': {'key': 'unitOfMeasure', 'type': 'str'},
        'values': {'key': 'values', 'type': '[EstimatedVMPrice]'},
    }

    def __init__(
        self,
        *,
        billing_currency: Union[str, "BillingCurrency"],
        unit_of_measure: Union[str, "UnitOfMeasure"],
        values: List["EstimatedVMPrice"],
        **kwargs
    ):
        """
        :keyword billing_currency: Required. Three lettered code specifying the currency of the VM
         price. Example: USD. Possible values include: "USD".
        :paramtype billing_currency: str or ~azure.mgmt.machinelearningservices.models.BillingCurrency
        :keyword unit_of_measure: Required. The unit of time measurement for the specified VM price.
         Example: OneHour. Possible values include: "OneHour".
        :paramtype unit_of_measure: str or ~azure.mgmt.machinelearningservices.models.UnitOfMeasure
        :keyword values: Required. The list of estimated prices for using a VM of a particular OS type,
         tier, etc.
        :paramtype values: list[~azure.mgmt.machinelearningservices.models.EstimatedVMPrice]
        """
        super(EstimatedVMPrices, self).__init__(**kwargs)
        self.billing_currency = billing_currency
        self.unit_of_measure = unit_of_measure
        self.values = values


class ExternalFQDNResponse(msrest.serialization.Model):
    """ExternalFQDNResponse.

    :ivar value:
    :vartype value: list[~azure.mgmt.machinelearningservices.models.FQDNEndpointsPropertyBag]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FQDNEndpointsPropertyBag]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["FQDNEndpointsPropertyBag"]] = None,
        **kwargs
    ):
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.FQDNEndpointsPropertyBag]
        """
        super(ExternalFQDNResponse, self).__init__(**kwargs)
        self.value = value


class Feature(ProxyResource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.FeatureProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'FeatureProperties'},
    }

    def __init__(
        self,
        *,
        properties: "FeatureProperties",
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.FeatureProperties
        """
        super(Feature, self).__init__(**kwargs)
        self.properties = properties


class FeatureAttributionDriftMonitoringSignal(MonitoringSignalBase):
    """FeatureAttributionDriftMonitoringSignal.

    All required parameters must be populated in order to send to Azure.

    :ivar notification_types: The current notification mode for this signal.
    :vartype notification_types: list[str or
     ~azure.mgmt.machinelearningservices.models.MonitoringNotificationType]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar signal_type: Required. [Required] Specifies the type of signal to monitor.Constant filled
     by server. Possible values include: "DataDrift", "PredictionDrift", "DataQuality",
     "FeatureAttributionDrift", "Custom", "ModelPerformance", "GenerationSafetyQuality",
     "GenerationTokenStatistics".
    :vartype signal_type: str or ~azure.mgmt.machinelearningservices.models.MonitoringSignalType
    :ivar feature_data_type_override: A dictionary that maps feature names to their respective data
     types.
    :vartype feature_data_type_override: dict[str, str or
     ~azure.mgmt.machinelearningservices.models.MonitoringFeatureDataType]
    :ivar feature_importance_settings: Required. [Required] The settings for computing feature
     importance.
    :vartype feature_importance_settings:
     ~azure.mgmt.machinelearningservices.models.FeatureImportanceSettings
    :ivar metric_threshold: Required. [Required] A list of metrics to calculate and their
     associated thresholds.
    :vartype metric_threshold:
     ~azure.mgmt.machinelearningservices.models.FeatureAttributionMetricThreshold
    :ivar production_data: Required. [Required] The data which drift will be calculated for.
    :vartype production_data:
     list[~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase]
    :ivar reference_data: Required. [Required] The data to calculate drift against.
    :vartype reference_data: ~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase
    """

    _validation = {
        'signal_type': {'required': True},
        'feature_importance_settings': {'required': True},
        'metric_threshold': {'required': True},
        'production_data': {'required': True},
        'reference_data': {'required': True},
    }

    _attribute_map = {
        'notification_types': {'key': 'notificationTypes', 'type': '[str]'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'signal_type': {'key': 'signalType', 'type': 'str'},
        'feature_data_type_override': {'key': 'featureDataTypeOverride', 'type': '{str}'},
        'feature_importance_settings': {'key': 'featureImportanceSettings', 'type': 'FeatureImportanceSettings'},
        'metric_threshold': {'key': 'metricThreshold', 'type': 'FeatureAttributionMetricThreshold'},
        'production_data': {'key': 'productionData', 'type': '[MonitoringInputDataBase]'},
        'reference_data': {'key': 'referenceData', 'type': 'MonitoringInputDataBase'},
    }

    def __init__(
        self,
        *,
        feature_importance_settings: "FeatureImportanceSettings",
        metric_threshold: "FeatureAttributionMetricThreshold",
        production_data: List["MonitoringInputDataBase"],
        reference_data: "MonitoringInputDataBase",
        notification_types: Optional[List[Union[str, "MonitoringNotificationType"]]] = None,
        properties: Optional[Dict[str, str]] = None,
        feature_data_type_override: Optional[Dict[str, Union[str, "MonitoringFeatureDataType"]]] = None,
        **kwargs
    ):
        """
        :keyword notification_types: The current notification mode for this signal.
        :paramtype notification_types: list[str or
         ~azure.mgmt.machinelearningservices.models.MonitoringNotificationType]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword feature_data_type_override: A dictionary that maps feature names to their respective
         data types.
        :paramtype feature_data_type_override: dict[str, str or
         ~azure.mgmt.machinelearningservices.models.MonitoringFeatureDataType]
        :keyword feature_importance_settings: Required. [Required] The settings for computing feature
         importance.
        :paramtype feature_importance_settings:
         ~azure.mgmt.machinelearningservices.models.FeatureImportanceSettings
        :keyword metric_threshold: Required. [Required] A list of metrics to calculate and their
         associated thresholds.
        :paramtype metric_threshold:
         ~azure.mgmt.machinelearningservices.models.FeatureAttributionMetricThreshold
        :keyword production_data: Required. [Required] The data which drift will be calculated for.
        :paramtype production_data:
         list[~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase]
        :keyword reference_data: Required. [Required] The data to calculate drift against.
        :paramtype reference_data: ~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase
        """
        super(FeatureAttributionDriftMonitoringSignal, self).__init__(notification_types=notification_types, properties=properties, **kwargs)
        self.signal_type = 'FeatureAttributionDrift'  # type: str
        self.feature_data_type_override = feature_data_type_override
        self.feature_importance_settings = feature_importance_settings
        self.metric_threshold = metric_threshold
        self.production_data = production_data
        self.reference_data = reference_data


class FeatureAttributionMetricThreshold(msrest.serialization.Model):
    """FeatureAttributionMetricThreshold.

    All required parameters must be populated in order to send to Azure.

    :ivar metric: Required. [Required] The feature attribution metric to calculate. Possible values
     include: "NormalizedDiscountedCumulativeGain".
    :vartype metric: str or ~azure.mgmt.machinelearningservices.models.FeatureAttributionMetric
    :ivar threshold: The threshold value. If null, a default value will be set depending on the
     selected metric.
    :vartype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
    """

    _validation = {
        'metric': {'required': True},
    }

    _attribute_map = {
        'metric': {'key': 'metric', 'type': 'str'},
        'threshold': {'key': 'threshold', 'type': 'MonitoringThreshold'},
    }

    def __init__(
        self,
        *,
        metric: Union[str, "FeatureAttributionMetric"],
        threshold: Optional["MonitoringThreshold"] = None,
        **kwargs
    ):
        """
        :keyword metric: Required. [Required] The feature attribution metric to calculate. Possible
         values include: "NormalizedDiscountedCumulativeGain".
        :paramtype metric: str or ~azure.mgmt.machinelearningservices.models.FeatureAttributionMetric
        :keyword threshold: The threshold value. If null, a default value will be set depending on the
         selected metric.
        :paramtype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
        """
        super(FeatureAttributionMetricThreshold, self).__init__(**kwargs)
        self.metric = metric
        self.threshold = threshold


class FeatureImportanceSettings(msrest.serialization.Model):
    """FeatureImportanceSettings.

    :ivar mode: The mode of operation for computing feature importance. Possible values include:
     "Disabled", "Enabled".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.FeatureImportanceMode
    :ivar target_column: The name of the target column within the input data asset.
    :vartype target_column: str
    """

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'target_column': {'key': 'targetColumn', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        mode: Optional[Union[str, "FeatureImportanceMode"]] = None,
        target_column: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword mode: The mode of operation for computing feature importance. Possible values include:
         "Disabled", "Enabled".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.FeatureImportanceMode
        :keyword target_column: The name of the target column within the input data asset.
        :paramtype target_column: str
        """
        super(FeatureImportanceSettings, self).__init__(**kwargs)
        self.mode = mode
        self.target_column = target_column


class FeatureProperties(ResourceBase):
    """Dto object representing feature.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar data_type: Specifies type. Possible values include: "String", "Integer", "Long", "Float",
     "Double", "Binary", "Datetime", "Boolean".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.FeatureDataType
    :ivar feature_name: Specifies name.
    :vartype feature_name: str
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'data_type': {'key': 'dataType', 'type': 'str'},
        'feature_name': {'key': 'featureName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        data_type: Optional[Union[str, "FeatureDataType"]] = None,
        feature_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword data_type: Specifies type. Possible values include: "String", "Integer", "Long",
         "Float", "Double", "Binary", "Datetime", "Boolean".
        :paramtype data_type: str or ~azure.mgmt.machinelearningservices.models.FeatureDataType
        :keyword feature_name: Specifies name.
        :paramtype feature_name: str
        """
        super(FeatureProperties, self).__init__(description=description, properties=properties, tags=tags, **kwargs)
        self.data_type = data_type
        self.feature_name = feature_name


class FeatureResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of Feature entities.

    :ivar next_link: The link to the next page of Feature objects. If null, there are no additional
     pages.
    :vartype next_link: str
    :ivar value: An array of objects of type Feature.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.Feature]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Feature]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["Feature"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of Feature objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type Feature.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.Feature]
        """
        super(FeatureResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class FeaturesetContainer(ProxyResource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.FeaturesetContainerProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'FeaturesetContainerProperties'},
    }

    def __init__(
        self,
        *,
        properties: "FeaturesetContainerProperties",
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.FeaturesetContainerProperties
        """
        super(FeaturesetContainer, self).__init__(**kwargs)
        self.properties = properties


class FeaturesetContainerProperties(AssetContainer):
    """Dto object representing feature set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar latest_version: The latest version inside this container.
    :vartype latest_version: str
    :ivar next_version: The next auto incremental version.
    :vartype next_version: str
    :ivar provisioning_state: Provisioning state for the featureset container. Possible values
     include: "Succeeded", "Failed", "Canceled", "Creating", "Updating", "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.AssetProvisioningState
    """

    _validation = {
        'latest_version': {'readonly': True},
        'next_version': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'latest_version': {'key': 'latestVersion', 'type': 'str'},
        'next_version': {'key': 'nextVersion', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_archived: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        """
        super(FeaturesetContainerProperties, self).__init__(description=description, properties=properties, tags=tags, is_archived=is_archived, **kwargs)
        self.provisioning_state = None


class FeaturesetContainerResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of FeaturesetContainer entities.

    :ivar next_link: The link to the next page of FeaturesetContainer objects. If null, there are
     no additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type FeaturesetContainer.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.FeaturesetContainer]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[FeaturesetContainer]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["FeaturesetContainer"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of FeaturesetContainer objects. If null, there
         are no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type FeaturesetContainer.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.FeaturesetContainer]
        """
        super(FeaturesetContainerResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class FeaturesetSpecification(msrest.serialization.Model):
    """Dto object representing specification.

    :ivar path: Specifies the spec path.
    :vartype path: str
    """

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        path: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword path: Specifies the spec path.
        :paramtype path: str
        """
        super(FeaturesetSpecification, self).__init__(**kwargs)
        self.path = path


class FeaturesetVersion(ProxyResource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.FeaturesetVersionProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'FeaturesetVersionProperties'},
    }

    def __init__(
        self,
        *,
        properties: "FeaturesetVersionProperties",
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.FeaturesetVersionProperties
        """
        super(FeaturesetVersion, self).__init__(**kwargs)
        self.properties = properties


class FeaturesetVersionBackfillRequest(msrest.serialization.Model):
    """Request payload for creating a backfill request for a given feature set version.

    :ivar data_availability_status: Specified the data availability status that you want to
     backfill.
    :vartype data_availability_status: list[str or
     ~azure.mgmt.machinelearningservices.models.DataAvailabilityStatus]
    :ivar description: Specifies description.
    :vartype description: str
    :ivar display_name: Specifies description.
    :vartype display_name: str
    :ivar feature_window: Specifies the backfill feature window to be materialized.
    :vartype feature_window: ~azure.mgmt.machinelearningservices.models.FeatureWindow
    :ivar job_id: Specify the jobId to retry the failed materialization.
    :vartype job_id: str
    :ivar properties: Specifies the properties.
    :vartype properties: dict[str, str]
    :ivar resource: Specifies the compute resource settings.
    :vartype resource: ~azure.mgmt.machinelearningservices.models.MaterializationComputeResource
    :ivar spark_configuration: Specifies the spark compute settings.
    :vartype spark_configuration: dict[str, str]
    :ivar tags: A set of tags. Specifies the tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'data_availability_status': {'key': 'dataAvailabilityStatus', 'type': '[str]'},
        'description': {'key': 'description', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'feature_window': {'key': 'featureWindow', 'type': 'FeatureWindow'},
        'job_id': {'key': 'jobId', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'resource': {'key': 'resource', 'type': 'MaterializationComputeResource'},
        'spark_configuration': {'key': 'sparkConfiguration', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        data_availability_status: Optional[List[Union[str, "DataAvailabilityStatus"]]] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        feature_window: Optional["FeatureWindow"] = None,
        job_id: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        resource: Optional["MaterializationComputeResource"] = None,
        spark_configuration: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword data_availability_status: Specified the data availability status that you want to
         backfill.
        :paramtype data_availability_status: list[str or
         ~azure.mgmt.machinelearningservices.models.DataAvailabilityStatus]
        :keyword description: Specifies description.
        :paramtype description: str
        :keyword display_name: Specifies description.
        :paramtype display_name: str
        :keyword feature_window: Specifies the backfill feature window to be materialized.
        :paramtype feature_window: ~azure.mgmt.machinelearningservices.models.FeatureWindow
        :keyword job_id: Specify the jobId to retry the failed materialization.
        :paramtype job_id: str
        :keyword properties: Specifies the properties.
        :paramtype properties: dict[str, str]
        :keyword resource: Specifies the compute resource settings.
        :paramtype resource: ~azure.mgmt.machinelearningservices.models.MaterializationComputeResource
        :keyword spark_configuration: Specifies the spark compute settings.
        :paramtype spark_configuration: dict[str, str]
        :keyword tags: A set of tags. Specifies the tags.
        :paramtype tags: dict[str, str]
        """
        super(FeaturesetVersionBackfillRequest, self).__init__(**kwargs)
        self.data_availability_status = data_availability_status
        self.description = description
        self.display_name = display_name
        self.feature_window = feature_window
        self.job_id = job_id
        self.properties = properties
        self.resource = resource
        self.spark_configuration = spark_configuration
        self.tags = tags


class FeaturesetVersionBackfillResponse(msrest.serialization.Model):
    """Response payload for creating a backfill request for a given feature set version.

    :ivar job_ids: List of jobs submitted as part of the backfill request.
    :vartype job_ids: list[str]
    """

    _attribute_map = {
        'job_ids': {'key': 'jobIds', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        job_ids: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword job_ids: List of jobs submitted as part of the backfill request.
        :paramtype job_ids: list[str]
        """
        super(FeaturesetVersionBackfillResponse, self).__init__(**kwargs)
        self.job_ids = job_ids


class FeaturesetVersionProperties(AssetBase):
    """Dto object representing feature set version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar auto_delete_setting: Specifies the lifecycle setting of managed data asset.
    :vartype auto_delete_setting: ~azure.mgmt.machinelearningservices.models.AutoDeleteSetting
    :ivar is_anonymous: If the name version are system generated (anonymous registration). For
     types where Stage is defined, when Stage is provided it will be used to populate IsAnonymous.
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived? For types where Stage is defined, when Stage is
     provided it will be used to populate IsArchived.
    :vartype is_archived: bool
    :ivar entities: Specifies list of entities.
    :vartype entities: list[str]
    :ivar materialization_settings: Specifies the materialization settings.
    :vartype materialization_settings:
     ~azure.mgmt.machinelearningservices.models.MaterializationSettings
    :ivar provisioning_state: Provisioning state for the featureset version container. Possible
     values include: "Succeeded", "Failed", "Canceled", "Creating", "Updating", "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.AssetProvisioningState
    :ivar specification: Specifies the feature spec details.
    :vartype specification: ~azure.mgmt.machinelearningservices.models.FeaturesetSpecification
    :ivar stage: Specifies the asset stage.
    :vartype stage: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'auto_delete_setting': {'key': 'autoDeleteSetting', 'type': 'AutoDeleteSetting'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'entities': {'key': 'entities', 'type': '[str]'},
        'materialization_settings': {'key': 'materializationSettings', 'type': 'MaterializationSettings'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'specification': {'key': 'specification', 'type': 'FeaturesetSpecification'},
        'stage': {'key': 'stage', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        auto_delete_setting: Optional["AutoDeleteSetting"] = None,
        is_anonymous: Optional[bool] = False,
        is_archived: Optional[bool] = False,
        entities: Optional[List[str]] = None,
        materialization_settings: Optional["MaterializationSettings"] = None,
        specification: Optional["FeaturesetSpecification"] = None,
        stage: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword auto_delete_setting: Specifies the lifecycle setting of managed data asset.
        :paramtype auto_delete_setting: ~azure.mgmt.machinelearningservices.models.AutoDeleteSetting
        :keyword is_anonymous: If the name version are system generated (anonymous registration). For
         types where Stage is defined, when Stage is provided it will be used to populate IsAnonymous.
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived? For types where Stage is defined, when Stage is
         provided it will be used to populate IsArchived.
        :paramtype is_archived: bool
        :keyword entities: Specifies list of entities.
        :paramtype entities: list[str]
        :keyword materialization_settings: Specifies the materialization settings.
        :paramtype materialization_settings:
         ~azure.mgmt.machinelearningservices.models.MaterializationSettings
        :keyword specification: Specifies the feature spec details.
        :paramtype specification: ~azure.mgmt.machinelearningservices.models.FeaturesetSpecification
        :keyword stage: Specifies the asset stage.
        :paramtype stage: str
        """
        super(FeaturesetVersionProperties, self).__init__(description=description, properties=properties, tags=tags, auto_delete_setting=auto_delete_setting, is_anonymous=is_anonymous, is_archived=is_archived, **kwargs)
        self.entities = entities
        self.materialization_settings = materialization_settings
        self.provisioning_state = None
        self.specification = specification
        self.stage = stage


class FeaturesetVersionResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of FeaturesetVersion entities.

    :ivar next_link: The link to the next page of FeaturesetVersion objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type FeaturesetVersion.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.FeaturesetVersion]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[FeaturesetVersion]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["FeaturesetVersion"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of FeaturesetVersion objects. If null, there are
         no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type FeaturesetVersion.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.FeaturesetVersion]
        """
        super(FeaturesetVersionResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class FeaturestoreEntityContainer(ProxyResource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties:
     ~azure.mgmt.machinelearningservices.models.FeaturestoreEntityContainerProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'FeaturestoreEntityContainerProperties'},
    }

    def __init__(
        self,
        *,
        properties: "FeaturestoreEntityContainerProperties",
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties:
         ~azure.mgmt.machinelearningservices.models.FeaturestoreEntityContainerProperties
        """
        super(FeaturestoreEntityContainer, self).__init__(**kwargs)
        self.properties = properties


class FeaturestoreEntityContainerProperties(AssetContainer):
    """Dto object representing feature entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar latest_version: The latest version inside this container.
    :vartype latest_version: str
    :ivar next_version: The next auto incremental version.
    :vartype next_version: str
    :ivar provisioning_state: Provisioning state for the featurestore entity container. Possible
     values include: "Succeeded", "Failed", "Canceled", "Creating", "Updating", "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.AssetProvisioningState
    """

    _validation = {
        'latest_version': {'readonly': True},
        'next_version': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'latest_version': {'key': 'latestVersion', 'type': 'str'},
        'next_version': {'key': 'nextVersion', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_archived: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        """
        super(FeaturestoreEntityContainerProperties, self).__init__(description=description, properties=properties, tags=tags, is_archived=is_archived, **kwargs)
        self.provisioning_state = None


class FeaturestoreEntityContainerResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of FeaturestoreEntityContainer entities.

    :ivar next_link: The link to the next page of FeaturestoreEntityContainer objects. If null,
     there are no additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type FeaturestoreEntityContainer.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.FeaturestoreEntityContainer]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[FeaturestoreEntityContainer]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["FeaturestoreEntityContainer"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of FeaturestoreEntityContainer objects. If null,
         there are no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type FeaturestoreEntityContainer.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.FeaturestoreEntityContainer]
        """
        super(FeaturestoreEntityContainerResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class FeaturestoreEntityVersion(ProxyResource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties:
     ~azure.mgmt.machinelearningservices.models.FeaturestoreEntityVersionProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'FeaturestoreEntityVersionProperties'},
    }

    def __init__(
        self,
        *,
        properties: "FeaturestoreEntityVersionProperties",
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties:
         ~azure.mgmt.machinelearningservices.models.FeaturestoreEntityVersionProperties
        """
        super(FeaturestoreEntityVersion, self).__init__(**kwargs)
        self.properties = properties


class FeaturestoreEntityVersionProperties(AssetBase):
    """Dto object representing feature entity version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar auto_delete_setting: Specifies the lifecycle setting of managed data asset.
    :vartype auto_delete_setting: ~azure.mgmt.machinelearningservices.models.AutoDeleteSetting
    :ivar is_anonymous: If the name version are system generated (anonymous registration). For
     types where Stage is defined, when Stage is provided it will be used to populate IsAnonymous.
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived? For types where Stage is defined, when Stage is
     provided it will be used to populate IsArchived.
    :vartype is_archived: bool
    :ivar index_columns: Specifies index columns.
    :vartype index_columns: list[~azure.mgmt.machinelearningservices.models.IndexColumn]
    :ivar provisioning_state: Provisioning state for the featurestore entity version. Possible
     values include: "Succeeded", "Failed", "Canceled", "Creating", "Updating", "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.AssetProvisioningState
    :ivar stage: Specifies the asset stage.
    :vartype stage: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'auto_delete_setting': {'key': 'autoDeleteSetting', 'type': 'AutoDeleteSetting'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'index_columns': {'key': 'indexColumns', 'type': '[IndexColumn]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'stage': {'key': 'stage', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        auto_delete_setting: Optional["AutoDeleteSetting"] = None,
        is_anonymous: Optional[bool] = False,
        is_archived: Optional[bool] = False,
        index_columns: Optional[List["IndexColumn"]] = None,
        stage: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword auto_delete_setting: Specifies the lifecycle setting of managed data asset.
        :paramtype auto_delete_setting: ~azure.mgmt.machinelearningservices.models.AutoDeleteSetting
        :keyword is_anonymous: If the name version are system generated (anonymous registration). For
         types where Stage is defined, when Stage is provided it will be used to populate IsAnonymous.
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived? For types where Stage is defined, when Stage is
         provided it will be used to populate IsArchived.
        :paramtype is_archived: bool
        :keyword index_columns: Specifies index columns.
        :paramtype index_columns: list[~azure.mgmt.machinelearningservices.models.IndexColumn]
        :keyword stage: Specifies the asset stage.
        :paramtype stage: str
        """
        super(FeaturestoreEntityVersionProperties, self).__init__(description=description, properties=properties, tags=tags, auto_delete_setting=auto_delete_setting, is_anonymous=is_anonymous, is_archived=is_archived, **kwargs)
        self.index_columns = index_columns
        self.provisioning_state = None
        self.stage = stage


class FeaturestoreEntityVersionResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of FeaturestoreEntityVersion entities.

    :ivar next_link: The link to the next page of FeaturestoreEntityVersion objects. If null, there
     are no additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type FeaturestoreEntityVersion.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.FeaturestoreEntityVersion]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[FeaturestoreEntityVersion]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["FeaturestoreEntityVersion"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of FeaturestoreEntityVersion objects. If null,
         there are no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type FeaturestoreEntityVersion.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.FeaturestoreEntityVersion]
        """
        super(FeaturestoreEntityVersionResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class FeatureStoreSettings(msrest.serialization.Model):
    """FeatureStoreSettings.

    :ivar compute_runtime:
    :vartype compute_runtime: ~azure.mgmt.machinelearningservices.models.ComputeRuntimeDto
    :ivar offline_store_connection_name:
    :vartype offline_store_connection_name: str
    :ivar online_store_connection_name:
    :vartype online_store_connection_name: str
    """

    _attribute_map = {
        'compute_runtime': {'key': 'computeRuntime', 'type': 'ComputeRuntimeDto'},
        'offline_store_connection_name': {'key': 'offlineStoreConnectionName', 'type': 'str'},
        'online_store_connection_name': {'key': 'onlineStoreConnectionName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        compute_runtime: Optional["ComputeRuntimeDto"] = None,
        offline_store_connection_name: Optional[str] = None,
        online_store_connection_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword compute_runtime:
        :paramtype compute_runtime: ~azure.mgmt.machinelearningservices.models.ComputeRuntimeDto
        :keyword offline_store_connection_name:
        :paramtype offline_store_connection_name: str
        :keyword online_store_connection_name:
        :paramtype online_store_connection_name: str
        """
        super(FeatureStoreSettings, self).__init__(**kwargs)
        self.compute_runtime = compute_runtime
        self.offline_store_connection_name = offline_store_connection_name
        self.online_store_connection_name = online_store_connection_name


class FeatureSubset(MonitoringFeatureFilterBase):
    """FeatureSubset.

    All required parameters must be populated in order to send to Azure.

    :ivar filter_type: Required. [Required] Specifies the feature filter to leverage when selecting
     features to calculate metrics over.Constant filled by server. Possible values include:
     "AllFeatures", "TopNByAttribution", "FeatureSubset".
    :vartype filter_type: str or
     ~azure.mgmt.machinelearningservices.models.MonitoringFeatureFilterType
    :ivar features: Required. [Required] The list of features to include.
    :vartype features: list[str]
    """

    _validation = {
        'filter_type': {'required': True},
        'features': {'required': True},
    }

    _attribute_map = {
        'filter_type': {'key': 'filterType', 'type': 'str'},
        'features': {'key': 'features', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        features: List[str],
        **kwargs
    ):
        """
        :keyword features: Required. [Required] The list of features to include.
        :paramtype features: list[str]
        """
        super(FeatureSubset, self).__init__(**kwargs)
        self.filter_type = 'FeatureSubset'  # type: str
        self.features = features


class FeatureWindow(msrest.serialization.Model):
    """Specifies the feature window.

    :ivar feature_window_end: Specifies the feature window end time.
    :vartype feature_window_end: ~datetime.datetime
    :ivar feature_window_start: Specifies the feature window start time.
    :vartype feature_window_start: ~datetime.datetime
    """

    _attribute_map = {
        'feature_window_end': {'key': 'featureWindowEnd', 'type': 'iso-8601'},
        'feature_window_start': {'key': 'featureWindowStart', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        feature_window_end: Optional[datetime.datetime] = None,
        feature_window_start: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword feature_window_end: Specifies the feature window end time.
        :paramtype feature_window_end: ~datetime.datetime
        :keyword feature_window_start: Specifies the feature window start time.
        :paramtype feature_window_start: ~datetime.datetime
        """
        super(FeatureWindow, self).__init__(**kwargs)
        self.feature_window_end = feature_window_end
        self.feature_window_start = feature_window_start


class FeaturizationSettings(msrest.serialization.Model):
    """Featurization Configuration.

    :ivar dataset_language: Dataset language, useful for the text data.
    :vartype dataset_language: str
    """

    _attribute_map = {
        'dataset_language': {'key': 'datasetLanguage', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        dataset_language: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword dataset_language: Dataset language, useful for the text data.
        :paramtype dataset_language: str
        """
        super(FeaturizationSettings, self).__init__(**kwargs)
        self.dataset_language = dataset_language


class FileSystemSource(DataImportSource):
    """FileSystemSource.

    All required parameters must be populated in order to send to Azure.

    :ivar connection: Workspace connection for data import source storage.
    :vartype connection: str
    :ivar source_type: Required. [Required] Specifies the type of data.Constant filled by server.
     Possible values include: "database", "file_system".
    :vartype source_type: str or ~azure.mgmt.machinelearningservices.models.DataImportSourceType
    :ivar path: Path on data import FileSystem source.
    :vartype path: str
    """

    _validation = {
        'source_type': {'required': True},
    }

    _attribute_map = {
        'connection': {'key': 'connection', 'type': 'str'},
        'source_type': {'key': 'sourceType', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        connection: Optional[str] = None,
        path: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword connection: Workspace connection for data import source storage.
        :paramtype connection: str
        :keyword path: Path on data import FileSystem source.
        :paramtype path: str
        """
        super(FileSystemSource, self).__init__(connection=connection, **kwargs)
        self.source_type = 'file_system'  # type: str
        self.path = path


class FineTuningJob(JobBaseProperties):
    """FineTuning Job definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar component_id: ARM resource ID of the component resource.
    :vartype component_id: str
    :ivar compute_id: ARM resource ID of the compute resource.
    :vartype compute_id: str
    :ivar display_name: Display name of job.
    :vartype display_name: str
    :ivar experiment_name: The name of the experiment the job belongs to. If not set, the job is
     placed in the "Default" experiment.
    :vartype experiment_name: str
    :ivar identity: Identity configuration. If set, this should be one of AmlToken,
     ManagedIdentity, UserIdentity or null.
     Defaults to AmlToken if null.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar job_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "AutoML", "Command", "Labeling", "Sweep", "Pipeline", "Spark",
     "FineTuning".
    :vartype job_type: str or ~azure.mgmt.machinelearningservices.models.JobType
    :ivar notification_setting: Notification setting for the job.
    :vartype notification_setting: ~azure.mgmt.machinelearningservices.models.NotificationSetting
    :ivar secrets_configuration: Configuration for secrets to be made available during runtime.
    :vartype secrets_configuration: dict[str,
     ~azure.mgmt.machinelearningservices.models.SecretConfiguration]
    :ivar services: List of JobEndpoints.
     For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
    :vartype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
    :ivar status: Status of the job. Possible values include: "NotStarted", "Starting",
     "Provisioning", "Preparing", "Queued", "Running", "Finalizing", "CancelRequested", "Completed",
     "Failed", "Canceled", "NotResponding", "Paused", "Unknown", "Scheduled".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.JobStatus
    :ivar fine_tuning_details: Required. [Required].
    :vartype fine_tuning_details: ~azure.mgmt.machinelearningservices.models.FineTuningVertical
    :ivar outputs: Required. [Required].
    :vartype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
    """

    _validation = {
        'job_type': {'required': True},
        'status': {'readonly': True},
        'fine_tuning_details': {'required': True},
        'outputs': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'component_id': {'key': 'componentId', 'type': 'str'},
        'compute_id': {'key': 'computeId', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'experiment_name': {'key': 'experimentName', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'IdentityConfiguration'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'notification_setting': {'key': 'notificationSetting', 'type': 'NotificationSetting'},
        'secrets_configuration': {'key': 'secretsConfiguration', 'type': '{SecretConfiguration}'},
        'services': {'key': 'services', 'type': '{JobService}'},
        'status': {'key': 'status', 'type': 'str'},
        'fine_tuning_details': {'key': 'fineTuningDetails', 'type': 'FineTuningVertical'},
        'outputs': {'key': 'outputs', 'type': '{JobOutput}'},
    }

    def __init__(
        self,
        *,
        fine_tuning_details: "FineTuningVertical",
        outputs: Dict[str, "JobOutput"],
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        component_id: Optional[str] = None,
        compute_id: Optional[str] = None,
        display_name: Optional[str] = None,
        experiment_name: Optional[str] = "Default",
        identity: Optional["IdentityConfiguration"] = None,
        is_archived: Optional[bool] = False,
        notification_setting: Optional["NotificationSetting"] = None,
        secrets_configuration: Optional[Dict[str, "SecretConfiguration"]] = None,
        services: Optional[Dict[str, "JobService"]] = None,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword component_id: ARM resource ID of the component resource.
        :paramtype component_id: str
        :keyword compute_id: ARM resource ID of the compute resource.
        :paramtype compute_id: str
        :keyword display_name: Display name of job.
        :paramtype display_name: str
        :keyword experiment_name: The name of the experiment the job belongs to. If not set, the job is
         placed in the "Default" experiment.
        :paramtype experiment_name: str
        :keyword identity: Identity configuration. If set, this should be one of AmlToken,
         ManagedIdentity, UserIdentity or null.
         Defaults to AmlToken if null.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword notification_setting: Notification setting for the job.
        :paramtype notification_setting: ~azure.mgmt.machinelearningservices.models.NotificationSetting
        :keyword secrets_configuration: Configuration for secrets to be made available during runtime.
        :paramtype secrets_configuration: dict[str,
         ~azure.mgmt.machinelearningservices.models.SecretConfiguration]
        :keyword services: List of JobEndpoints.
         For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :paramtype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
        :keyword fine_tuning_details: Required. [Required].
        :paramtype fine_tuning_details: ~azure.mgmt.machinelearningservices.models.FineTuningVertical
        :keyword outputs: Required. [Required].
        :paramtype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
        """
        super(FineTuningJob, self).__init__(description=description, properties=properties, tags=tags, component_id=component_id, compute_id=compute_id, display_name=display_name, experiment_name=experiment_name, identity=identity, is_archived=is_archived, notification_setting=notification_setting, secrets_configuration=secrets_configuration, services=services, **kwargs)
        self.job_type = 'FineTuning'  # type: str
        self.fine_tuning_details = fine_tuning_details
        self.outputs = outputs


class MonitoringInputDataBase(msrest.serialization.Model):
    """Monitoring input data base definition.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: FixedInputData, RollingInputData, StaticInputData.

    All required parameters must be populated in order to send to Azure.

    :ivar columns: Mapping of column names to special uses.
    :vartype columns: dict[str, str]
    :ivar data_context: The context metadata of the data source.
    :vartype data_context: str
    :ivar input_data_type: Required. [Required] Specifies the type of signal to monitor.Constant
     filled by server. Possible values include: "Static", "Rolling", "Fixed".
    :vartype input_data_type: str or
     ~azure.mgmt.machinelearningservices.models.MonitoringInputDataType
    :ivar job_input_type: Required. [Required] Specifies the type of job. Possible values include:
     "literal", "uri_file", "uri_folder", "mltable", "custom_model", "mlflow_model", "triton_model".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    :ivar uri: Required. [Required] Input Asset URI.
    :vartype uri: str
    """

    _validation = {
        'input_data_type': {'required': True},
        'job_input_type': {'required': True},
        'uri': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'columns': {'key': 'columns', 'type': '{str}'},
        'data_context': {'key': 'dataContext', 'type': 'str'},
        'input_data_type': {'key': 'inputDataType', 'type': 'str'},
        'job_input_type': {'key': 'jobInputType', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
    }

    _subtype_map = {
        'input_data_type': {'Fixed': 'FixedInputData', 'Rolling': 'RollingInputData', 'Static': 'StaticInputData'}
    }

    def __init__(
        self,
        *,
        job_input_type: Union[str, "JobInputType"],
        uri: str,
        columns: Optional[Dict[str, str]] = None,
        data_context: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword columns: Mapping of column names to special uses.
        :paramtype columns: dict[str, str]
        :keyword data_context: The context metadata of the data source.
        :paramtype data_context: str
        :keyword job_input_type: Required. [Required] Specifies the type of job. Possible values
         include: "literal", "uri_file", "uri_folder", "mltable", "custom_model", "mlflow_model",
         "triton_model".
        :paramtype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
        :keyword uri: Required. [Required] Input Asset URI.
        :paramtype uri: str
        """
        super(MonitoringInputDataBase, self).__init__(**kwargs)
        self.columns = columns
        self.data_context = data_context
        self.input_data_type = None  # type: Optional[str]
        self.job_input_type = job_input_type
        self.uri = uri


class FixedInputData(MonitoringInputDataBase):
    """Fixed input data definition.

    All required parameters must be populated in order to send to Azure.

    :ivar columns: Mapping of column names to special uses.
    :vartype columns: dict[str, str]
    :ivar data_context: The context metadata of the data source.
    :vartype data_context: str
    :ivar input_data_type: Required. [Required] Specifies the type of signal to monitor.Constant
     filled by server. Possible values include: "Static", "Rolling", "Fixed".
    :vartype input_data_type: str or
     ~azure.mgmt.machinelearningservices.models.MonitoringInputDataType
    :ivar job_input_type: Required. [Required] Specifies the type of job. Possible values include:
     "literal", "uri_file", "uri_folder", "mltable", "custom_model", "mlflow_model", "triton_model".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    :ivar uri: Required. [Required] Input Asset URI.
    :vartype uri: str
    """

    _validation = {
        'input_data_type': {'required': True},
        'job_input_type': {'required': True},
        'uri': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'columns': {'key': 'columns', 'type': '{str}'},
        'data_context': {'key': 'dataContext', 'type': 'str'},
        'input_data_type': {'key': 'inputDataType', 'type': 'str'},
        'job_input_type': {'key': 'jobInputType', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        job_input_type: Union[str, "JobInputType"],
        uri: str,
        columns: Optional[Dict[str, str]] = None,
        data_context: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword columns: Mapping of column names to special uses.
        :paramtype columns: dict[str, str]
        :keyword data_context: The context metadata of the data source.
        :paramtype data_context: str
        :keyword job_input_type: Required. [Required] Specifies the type of job. Possible values
         include: "literal", "uri_file", "uri_folder", "mltable", "custom_model", "mlflow_model",
         "triton_model".
        :paramtype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
        :keyword uri: Required. [Required] Input Asset URI.
        :paramtype uri: str
        """
        super(FixedInputData, self).__init__(columns=columns, data_context=data_context, job_input_type=job_input_type, uri=uri, **kwargs)
        self.input_data_type = 'Fixed'  # type: str


class FlavorData(msrest.serialization.Model):
    """FlavorData.

    :ivar data: Model flavor-specific data.
    :vartype data: dict[str, str]
    """

    _attribute_map = {
        'data': {'key': 'data', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        data: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword data: Model flavor-specific data.
        :paramtype data: dict[str, str]
        """
        super(FlavorData, self).__init__(**kwargs)
        self.data = data


class Forecasting(AutoMLVertical, TableVertical):
    """Forecasting task in AutoML Table vertical.

    All required parameters must be populated in order to send to Azure.

    :ivar cv_split_column_names: Columns to use for CVSplit data.
    :vartype cv_split_column_names: list[str]
    :ivar featurization_settings: Featurization inputs needed for AutoML job.
    :vartype featurization_settings:
     ~azure.mgmt.machinelearningservices.models.TableVerticalFeaturizationSettings
    :ivar fixed_parameters: Model/training parameters that will remain constant throughout
     training.
    :vartype fixed_parameters: ~azure.mgmt.machinelearningservices.models.TableFixedParameters
    :ivar limit_settings: Execution constraints for AutoMLJob.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.TableVerticalLimitSettings
    :ivar n_cross_validations: Number of cross validation folds to be applied on training dataset
     when validation dataset is not provided.
    :vartype n_cross_validations: ~azure.mgmt.machinelearningservices.models.NCrossValidations
    :ivar search_space: Search space for sampling different combinations of models and their
     hyperparameters.
    :vartype search_space: list[~azure.mgmt.machinelearningservices.models.TableParameterSubspace]
    :ivar sweep_settings: Settings for model sweeping and hyperparameter tuning.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.TableSweepSettings
    :ivar test_data: Test data input.
    :vartype test_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar test_data_size: The fraction of test dataset that needs to be set aside for validation
     purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype test_data_size: float
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    :ivar weight_column_name: The name of the sample weight column. Automated ML supports a
     weighted column as an input, causing rows in the data to be weighted up or down.
    :vartype weight_column_name: str
    :ivar log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
     "Info", "Warning", "Error", "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar target_column_name: Target column name: This is prediction values column.
     Also known as label column name in context of classification tasks.
    :vartype target_column_name: str
    :ivar task_type: Required. [Required] Task type for AutoMLJob.Constant filled by server.
     Possible values include: "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    :ivar training_data: Required. [Required] Training data input.
    :vartype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar forecasting_settings: Forecasting task specific inputs.
    :vartype forecasting_settings: ~azure.mgmt.machinelearningservices.models.ForecastingSettings
    :ivar primary_metric: Primary metric for forecasting task. Possible values include:
     "SpearmanCorrelation", "NormalizedRootMeanSquaredError", "R2Score",
     "NormalizedMeanAbsoluteError".
    :vartype primary_metric: str or
     ~azure.mgmt.machinelearningservices.models.ForecastingPrimaryMetrics
    :ivar training_settings: Inputs for training phase for an AutoML Job.
    :vartype training_settings:
     ~azure.mgmt.machinelearningservices.models.ForecastingTrainingSettings
    """

    _validation = {
        'task_type': {'required': True},
        'training_data': {'required': True},
    }

    _attribute_map = {
        'cv_split_column_names': {'key': 'cvSplitColumnNames', 'type': '[str]'},
        'featurization_settings': {'key': 'featurizationSettings', 'type': 'TableVerticalFeaturizationSettings'},
        'fixed_parameters': {'key': 'fixedParameters', 'type': 'TableFixedParameters'},
        'limit_settings': {'key': 'limitSettings', 'type': 'TableVerticalLimitSettings'},
        'n_cross_validations': {'key': 'nCrossValidations', 'type': 'NCrossValidations'},
        'search_space': {'key': 'searchSpace', 'type': '[TableParameterSubspace]'},
        'sweep_settings': {'key': 'sweepSettings', 'type': 'TableSweepSettings'},
        'test_data': {'key': 'testData', 'type': 'MLTableJobInput'},
        'test_data_size': {'key': 'testDataSize', 'type': 'float'},
        'validation_data': {'key': 'validationData', 'type': 'MLTableJobInput'},
        'validation_data_size': {'key': 'validationDataSize', 'type': 'float'},
        'weight_column_name': {'key': 'weightColumnName', 'type': 'str'},
        'log_verbosity': {'key': 'logVerbosity', 'type': 'str'},
        'target_column_name': {'key': 'targetColumnName', 'type': 'str'},
        'task_type': {'key': 'taskType', 'type': 'str'},
        'training_data': {'key': 'trainingData', 'type': 'MLTableJobInput'},
        'forecasting_settings': {'key': 'forecastingSettings', 'type': 'ForecastingSettings'},
        'primary_metric': {'key': 'primaryMetric', 'type': 'str'},
        'training_settings': {'key': 'trainingSettings', 'type': 'ForecastingTrainingSettings'},
    }

    def __init__(
        self,
        *,
        training_data: "MLTableJobInput",
        cv_split_column_names: Optional[List[str]] = None,
        featurization_settings: Optional["TableVerticalFeaturizationSettings"] = None,
        fixed_parameters: Optional["TableFixedParameters"] = None,
        limit_settings: Optional["TableVerticalLimitSettings"] = None,
        n_cross_validations: Optional["NCrossValidations"] = None,
        search_space: Optional[List["TableParameterSubspace"]] = None,
        sweep_settings: Optional["TableSweepSettings"] = None,
        test_data: Optional["MLTableJobInput"] = None,
        test_data_size: Optional[float] = None,
        validation_data: Optional["MLTableJobInput"] = None,
        validation_data_size: Optional[float] = None,
        weight_column_name: Optional[str] = None,
        log_verbosity: Optional[Union[str, "LogVerbosity"]] = None,
        target_column_name: Optional[str] = None,
        forecasting_settings: Optional["ForecastingSettings"] = None,
        primary_metric: Optional[Union[str, "ForecastingPrimaryMetrics"]] = None,
        training_settings: Optional["ForecastingTrainingSettings"] = None,
        **kwargs
    ):
        """
        :keyword cv_split_column_names: Columns to use for CVSplit data.
        :paramtype cv_split_column_names: list[str]
        :keyword featurization_settings: Featurization inputs needed for AutoML job.
        :paramtype featurization_settings:
         ~azure.mgmt.machinelearningservices.models.TableVerticalFeaturizationSettings
        :keyword fixed_parameters: Model/training parameters that will remain constant throughout
         training.
        :paramtype fixed_parameters: ~azure.mgmt.machinelearningservices.models.TableFixedParameters
        :keyword limit_settings: Execution constraints for AutoMLJob.
        :paramtype limit_settings:
         ~azure.mgmt.machinelearningservices.models.TableVerticalLimitSettings
        :keyword n_cross_validations: Number of cross validation folds to be applied on training
         dataset
         when validation dataset is not provided.
        :paramtype n_cross_validations: ~azure.mgmt.machinelearningservices.models.NCrossValidations
        :keyword search_space: Search space for sampling different combinations of models and their
         hyperparameters.
        :paramtype search_space:
         list[~azure.mgmt.machinelearningservices.models.TableParameterSubspace]
        :keyword sweep_settings: Settings for model sweeping and hyperparameter tuning.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.TableSweepSettings
        :keyword test_data: Test data input.
        :paramtype test_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword test_data_size: The fraction of test dataset that needs to be set aside for validation
         purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype test_data_size: float
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        :keyword weight_column_name: The name of the sample weight column. Automated ML supports a
         weighted column as an input, causing rows in the data to be weighted up or down.
        :paramtype weight_column_name: str
        :keyword log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
         "Info", "Warning", "Error", "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        :keyword target_column_name: Target column name: This is prediction values column.
         Also known as label column name in context of classification tasks.
        :paramtype target_column_name: str
        :keyword training_data: Required. [Required] Training data input.
        :paramtype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword forecasting_settings: Forecasting task specific inputs.
        :paramtype forecasting_settings: ~azure.mgmt.machinelearningservices.models.ForecastingSettings
        :keyword primary_metric: Primary metric for forecasting task. Possible values include:
         "SpearmanCorrelation", "NormalizedRootMeanSquaredError", "R2Score",
         "NormalizedMeanAbsoluteError".
        :paramtype primary_metric: str or
         ~azure.mgmt.machinelearningservices.models.ForecastingPrimaryMetrics
        :keyword training_settings: Inputs for training phase for an AutoML Job.
        :paramtype training_settings:
         ~azure.mgmt.machinelearningservices.models.ForecastingTrainingSettings
        """
        super(Forecasting, self).__init__(log_verbosity=log_verbosity, target_column_name=target_column_name, training_data=training_data, cv_split_column_names=cv_split_column_names, featurization_settings=featurization_settings, fixed_parameters=fixed_parameters, limit_settings=limit_settings, n_cross_validations=n_cross_validations, search_space=search_space, sweep_settings=sweep_settings, test_data=test_data, test_data_size=test_data_size, validation_data=validation_data, validation_data_size=validation_data_size, weight_column_name=weight_column_name, **kwargs)
        self.cv_split_column_names = cv_split_column_names
        self.featurization_settings = featurization_settings
        self.fixed_parameters = fixed_parameters
        self.limit_settings = limit_settings
        self.n_cross_validations = n_cross_validations
        self.search_space = search_space
        self.sweep_settings = sweep_settings
        self.test_data = test_data
        self.test_data_size = test_data_size
        self.validation_data = validation_data
        self.validation_data_size = validation_data_size
        self.weight_column_name = weight_column_name
        self.task_type = 'Forecasting'  # type: str
        self.forecasting_settings = forecasting_settings
        self.primary_metric = primary_metric
        self.training_settings = training_settings
        self.log_verbosity = log_verbosity
        self.target_column_name = target_column_name
        self.training_data = training_data


class ForecastingSettings(msrest.serialization.Model):
    """Forecasting specific parameters.

    :ivar country_or_region_for_holidays: Country or region for holidays for forecasting tasks.
     These should be ISO 3166 two-letter country/region codes, for example 'US' or 'GB'.
    :vartype country_or_region_for_holidays: str
    :ivar cv_step_size: Number of periods between the origin time of one CV fold and the next fold.
     For
     example, if ``CVStepSize`` = 3 for daily data, the origin time for each fold will be
     three days apart.
    :vartype cv_step_size: int
    :ivar feature_lags: Flag for generating lags for the numeric features with 'auto' or null.
     Possible values include: "None", "Auto".
    :vartype feature_lags: str or ~azure.mgmt.machinelearningservices.models.FeatureLags
    :ivar features_unknown_at_forecast_time: The feature columns that are available for training
     but unknown at the time of forecast/inference.
     If features_unknown_at_forecast_time is not set, it is assumed that all the feature columns in
     the dataset are known at inference time.
    :vartype features_unknown_at_forecast_time: list[str]
    :ivar forecast_horizon: The desired maximum forecast horizon in units of time-series frequency.
    :vartype forecast_horizon: ~azure.mgmt.machinelearningservices.models.ForecastHorizon
    :ivar frequency: When forecasting, this parameter represents the period with which the forecast
     is desired, for example daily, weekly, yearly, etc. The forecast frequency is dataset frequency
     by default.
    :vartype frequency: str
    :ivar seasonality: Set time series seasonality as an integer multiple of the series frequency.
     If seasonality is set to 'auto', it will be inferred.
    :vartype seasonality: ~azure.mgmt.machinelearningservices.models.Seasonality
    :ivar short_series_handling_config: The parameter defining how if AutoML should handle short
     time series. Possible values include: "None", "Auto", "Pad", "Drop".
    :vartype short_series_handling_config: str or
     ~azure.mgmt.machinelearningservices.models.ShortSeriesHandlingConfiguration
    :ivar target_aggregate_function: The function to be used to aggregate the time series target
     column to conform to a user specified frequency.
     If the TargetAggregateFunction is set i.e. not 'None', but the freq parameter is not set, the
     error is raised. The possible target aggregation functions are: "sum", "max", "min" and "mean".
     Possible values include: "None", "Sum", "Max", "Min", "Mean".
    :vartype target_aggregate_function: str or
     ~azure.mgmt.machinelearningservices.models.TargetAggregationFunction
    :ivar target_lags: The number of past periods to lag from the target column.
    :vartype target_lags: ~azure.mgmt.machinelearningservices.models.TargetLags
    :ivar target_rolling_window_size: The number of past periods used to create a rolling window
     average of the target column.
    :vartype target_rolling_window_size:
     ~azure.mgmt.machinelearningservices.models.TargetRollingWindowSize
    :ivar time_column_name: The name of the time column. This parameter is required when
     forecasting to specify the datetime column in the input data used for building the time series
     and inferring its frequency.
    :vartype time_column_name: str
    :ivar time_series_id_column_names: The names of columns used to group a timeseries. It can be
     used to create multiple series.
     If grain is not defined, the data set is assumed to be one time-series. This parameter is used
     with task type forecasting.
    :vartype time_series_id_column_names: list[str]
    :ivar use_stl: Configure STL Decomposition of the time-series target column. Possible values
     include: "None", "Season", "SeasonTrend".
    :vartype use_stl: str or ~azure.mgmt.machinelearningservices.models.UseStl
    """

    _attribute_map = {
        'country_or_region_for_holidays': {'key': 'countryOrRegionForHolidays', 'type': 'str'},
        'cv_step_size': {'key': 'cvStepSize', 'type': 'int'},
        'feature_lags': {'key': 'featureLags', 'type': 'str'},
        'features_unknown_at_forecast_time': {'key': 'featuresUnknownAtForecastTime', 'type': '[str]'},
        'forecast_horizon': {'key': 'forecastHorizon', 'type': 'ForecastHorizon'},
        'frequency': {'key': 'frequency', 'type': 'str'},
        'seasonality': {'key': 'seasonality', 'type': 'Seasonality'},
        'short_series_handling_config': {'key': 'shortSeriesHandlingConfig', 'type': 'str'},
        'target_aggregate_function': {'key': 'targetAggregateFunction', 'type': 'str'},
        'target_lags': {'key': 'targetLags', 'type': 'TargetLags'},
        'target_rolling_window_size': {'key': 'targetRollingWindowSize', 'type': 'TargetRollingWindowSize'},
        'time_column_name': {'key': 'timeColumnName', 'type': 'str'},
        'time_series_id_column_names': {'key': 'timeSeriesIdColumnNames', 'type': '[str]'},
        'use_stl': {'key': 'useStl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        country_or_region_for_holidays: Optional[str] = None,
        cv_step_size: Optional[int] = None,
        feature_lags: Optional[Union[str, "FeatureLags"]] = None,
        features_unknown_at_forecast_time: Optional[List[str]] = None,
        forecast_horizon: Optional["ForecastHorizon"] = None,
        frequency: Optional[str] = None,
        seasonality: Optional["Seasonality"] = None,
        short_series_handling_config: Optional[Union[str, "ShortSeriesHandlingConfiguration"]] = None,
        target_aggregate_function: Optional[Union[str, "TargetAggregationFunction"]] = None,
        target_lags: Optional["TargetLags"] = None,
        target_rolling_window_size: Optional["TargetRollingWindowSize"] = None,
        time_column_name: Optional[str] = None,
        time_series_id_column_names: Optional[List[str]] = None,
        use_stl: Optional[Union[str, "UseStl"]] = None,
        **kwargs
    ):
        """
        :keyword country_or_region_for_holidays: Country or region for holidays for forecasting tasks.
         These should be ISO 3166 two-letter country/region codes, for example 'US' or 'GB'.
        :paramtype country_or_region_for_holidays: str
        :keyword cv_step_size: Number of periods between the origin time of one CV fold and the next
         fold. For
         example, if ``CVStepSize`` = 3 for daily data, the origin time for each fold will be
         three days apart.
        :paramtype cv_step_size: int
        :keyword feature_lags: Flag for generating lags for the numeric features with 'auto' or null.
         Possible values include: "None", "Auto".
        :paramtype feature_lags: str or ~azure.mgmt.machinelearningservices.models.FeatureLags
        :keyword features_unknown_at_forecast_time: The feature columns that are available for training
         but unknown at the time of forecast/inference.
         If features_unknown_at_forecast_time is not set, it is assumed that all the feature columns in
         the dataset are known at inference time.
        :paramtype features_unknown_at_forecast_time: list[str]
        :keyword forecast_horizon: The desired maximum forecast horizon in units of time-series
         frequency.
        :paramtype forecast_horizon: ~azure.mgmt.machinelearningservices.models.ForecastHorizon
        :keyword frequency: When forecasting, this parameter represents the period with which the
         forecast is desired, for example daily, weekly, yearly, etc. The forecast frequency is dataset
         frequency by default.
        :paramtype frequency: str
        :keyword seasonality: Set time series seasonality as an integer multiple of the series
         frequency.
         If seasonality is set to 'auto', it will be inferred.
        :paramtype seasonality: ~azure.mgmt.machinelearningservices.models.Seasonality
        :keyword short_series_handling_config: The parameter defining how if AutoML should handle short
         time series. Possible values include: "None", "Auto", "Pad", "Drop".
        :paramtype short_series_handling_config: str or
         ~azure.mgmt.machinelearningservices.models.ShortSeriesHandlingConfiguration
        :keyword target_aggregate_function: The function to be used to aggregate the time series target
         column to conform to a user specified frequency.
         If the TargetAggregateFunction is set i.e. not 'None', but the freq parameter is not set, the
         error is raised. The possible target aggregation functions are: "sum", "max", "min" and "mean".
         Possible values include: "None", "Sum", "Max", "Min", "Mean".
        :paramtype target_aggregate_function: str or
         ~azure.mgmt.machinelearningservices.models.TargetAggregationFunction
        :keyword target_lags: The number of past periods to lag from the target column.
        :paramtype target_lags: ~azure.mgmt.machinelearningservices.models.TargetLags
        :keyword target_rolling_window_size: The number of past periods used to create a rolling window
         average of the target column.
        :paramtype target_rolling_window_size:
         ~azure.mgmt.machinelearningservices.models.TargetRollingWindowSize
        :keyword time_column_name: The name of the time column. This parameter is required when
         forecasting to specify the datetime column in the input data used for building the time series
         and inferring its frequency.
        :paramtype time_column_name: str
        :keyword time_series_id_column_names: The names of columns used to group a timeseries. It can
         be used to create multiple series.
         If grain is not defined, the data set is assumed to be one time-series. This parameter is used
         with task type forecasting.
        :paramtype time_series_id_column_names: list[str]
        :keyword use_stl: Configure STL Decomposition of the time-series target column. Possible values
         include: "None", "Season", "SeasonTrend".
        :paramtype use_stl: str or ~azure.mgmt.machinelearningservices.models.UseStl
        """
        super(ForecastingSettings, self).__init__(**kwargs)
        self.country_or_region_for_holidays = country_or_region_for_holidays
        self.cv_step_size = cv_step_size
        self.feature_lags = feature_lags
        self.features_unknown_at_forecast_time = features_unknown_at_forecast_time
        self.forecast_horizon = forecast_horizon
        self.frequency = frequency
        self.seasonality = seasonality
        self.short_series_handling_config = short_series_handling_config
        self.target_aggregate_function = target_aggregate_function
        self.target_lags = target_lags
        self.target_rolling_window_size = target_rolling_window_size
        self.time_column_name = time_column_name
        self.time_series_id_column_names = time_series_id_column_names
        self.use_stl = use_stl


class ForecastingTrainingSettings(TrainingSettings):
    """Forecasting Training related configuration.

    :ivar enable_dnn_training: Enable recommendation of DNN models.
    :vartype enable_dnn_training: bool
    :ivar enable_model_explainability: Flag to turn on explainability on best model.
    :vartype enable_model_explainability: bool
    :ivar enable_onnx_compatible_models: Flag for enabling onnx compatible models.
    :vartype enable_onnx_compatible_models: bool
    :ivar enable_stack_ensemble: Enable stack ensemble run.
    :vartype enable_stack_ensemble: bool
    :ivar enable_vote_ensemble: Enable voting ensemble run.
    :vartype enable_vote_ensemble: bool
    :ivar ensemble_model_download_timeout: During VotingEnsemble and StackEnsemble model
     generation, multiple fitted models from the previous child runs are downloaded.
     Configure this parameter with a higher value than 300 secs, if more time is needed.
    :vartype ensemble_model_download_timeout: ~datetime.timedelta
    :ivar stack_ensemble_settings: Stack ensemble settings for stack ensemble run.
    :vartype stack_ensemble_settings:
     ~azure.mgmt.machinelearningservices.models.StackEnsembleSettings
    :ivar training_mode: TrainingMode mode - Setting to 'auto' is same as setting it to
     'non-distributed' for now, however in the future may result in mixed mode or heuristics based
     mode selection. Default is 'auto'.
     If 'Distributed' then only distributed featurization is used and distributed algorithms are
     chosen.
     If 'NonDistributed' then only non distributed algorithms are chosen. Possible values include:
     "Auto", "Distributed", "NonDistributed".
    :vartype training_mode: str or ~azure.mgmt.machinelearningservices.models.TrainingMode
    :ivar allowed_training_algorithms: Allowed models for forecasting task.
    :vartype allowed_training_algorithms: list[str or
     ~azure.mgmt.machinelearningservices.models.ForecastingModels]
    :ivar blocked_training_algorithms: Blocked models for forecasting task.
    :vartype blocked_training_algorithms: list[str or
     ~azure.mgmt.machinelearningservices.models.ForecastingModels]
    """

    _attribute_map = {
        'enable_dnn_training': {'key': 'enableDnnTraining', 'type': 'bool'},
        'enable_model_explainability': {'key': 'enableModelExplainability', 'type': 'bool'},
        'enable_onnx_compatible_models': {'key': 'enableOnnxCompatibleModels', 'type': 'bool'},
        'enable_stack_ensemble': {'key': 'enableStackEnsemble', 'type': 'bool'},
        'enable_vote_ensemble': {'key': 'enableVoteEnsemble', 'type': 'bool'},
        'ensemble_model_download_timeout': {'key': 'ensembleModelDownloadTimeout', 'type': 'duration'},
        'stack_ensemble_settings': {'key': 'stackEnsembleSettings', 'type': 'StackEnsembleSettings'},
        'training_mode': {'key': 'trainingMode', 'type': 'str'},
        'allowed_training_algorithms': {'key': 'allowedTrainingAlgorithms', 'type': '[str]'},
        'blocked_training_algorithms': {'key': 'blockedTrainingAlgorithms', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        enable_dnn_training: Optional[bool] = False,
        enable_model_explainability: Optional[bool] = True,
        enable_onnx_compatible_models: Optional[bool] = False,
        enable_stack_ensemble: Optional[bool] = True,
        enable_vote_ensemble: Optional[bool] = True,
        ensemble_model_download_timeout: Optional[datetime.timedelta] = "PT5M",
        stack_ensemble_settings: Optional["StackEnsembleSettings"] = None,
        training_mode: Optional[Union[str, "TrainingMode"]] = None,
        allowed_training_algorithms: Optional[List[Union[str, "ForecastingModels"]]] = None,
        blocked_training_algorithms: Optional[List[Union[str, "ForecastingModels"]]] = None,
        **kwargs
    ):
        """
        :keyword enable_dnn_training: Enable recommendation of DNN models.
        :paramtype enable_dnn_training: bool
        :keyword enable_model_explainability: Flag to turn on explainability on best model.
        :paramtype enable_model_explainability: bool
        :keyword enable_onnx_compatible_models: Flag for enabling onnx compatible models.
        :paramtype enable_onnx_compatible_models: bool
        :keyword enable_stack_ensemble: Enable stack ensemble run.
        :paramtype enable_stack_ensemble: bool
        :keyword enable_vote_ensemble: Enable voting ensemble run.
        :paramtype enable_vote_ensemble: bool
        :keyword ensemble_model_download_timeout: During VotingEnsemble and StackEnsemble model
         generation, multiple fitted models from the previous child runs are downloaded.
         Configure this parameter with a higher value than 300 secs, if more time is needed.
        :paramtype ensemble_model_download_timeout: ~datetime.timedelta
        :keyword stack_ensemble_settings: Stack ensemble settings for stack ensemble run.
        :paramtype stack_ensemble_settings:
         ~azure.mgmt.machinelearningservices.models.StackEnsembleSettings
        :keyword training_mode: TrainingMode mode - Setting to 'auto' is same as setting it to
         'non-distributed' for now, however in the future may result in mixed mode or heuristics based
         mode selection. Default is 'auto'.
         If 'Distributed' then only distributed featurization is used and distributed algorithms are
         chosen.
         If 'NonDistributed' then only non distributed algorithms are chosen. Possible values include:
         "Auto", "Distributed", "NonDistributed".
        :paramtype training_mode: str or ~azure.mgmt.machinelearningservices.models.TrainingMode
        :keyword allowed_training_algorithms: Allowed models for forecasting task.
        :paramtype allowed_training_algorithms: list[str or
         ~azure.mgmt.machinelearningservices.models.ForecastingModels]
        :keyword blocked_training_algorithms: Blocked models for forecasting task.
        :paramtype blocked_training_algorithms: list[str or
         ~azure.mgmt.machinelearningservices.models.ForecastingModels]
        """
        super(ForecastingTrainingSettings, self).__init__(enable_dnn_training=enable_dnn_training, enable_model_explainability=enable_model_explainability, enable_onnx_compatible_models=enable_onnx_compatible_models, enable_stack_ensemble=enable_stack_ensemble, enable_vote_ensemble=enable_vote_ensemble, ensemble_model_download_timeout=ensemble_model_download_timeout, stack_ensemble_settings=stack_ensemble_settings, training_mode=training_mode, **kwargs)
        self.allowed_training_algorithms = allowed_training_algorithms
        self.blocked_training_algorithms = blocked_training_algorithms


class FQDNEndpoint(msrest.serialization.Model):
    """FQDNEndpoint.

    :ivar domain_name:
    :vartype domain_name: str
    :ivar endpoint_details:
    :vartype endpoint_details: list[~azure.mgmt.machinelearningservices.models.FQDNEndpointDetail]
    """

    _attribute_map = {
        'domain_name': {'key': 'domainName', 'type': 'str'},
        'endpoint_details': {'key': 'endpointDetails', 'type': '[FQDNEndpointDetail]'},
    }

    def __init__(
        self,
        *,
        domain_name: Optional[str] = None,
        endpoint_details: Optional[List["FQDNEndpointDetail"]] = None,
        **kwargs
    ):
        """
        :keyword domain_name:
        :paramtype domain_name: str
        :keyword endpoint_details:
        :paramtype endpoint_details:
         list[~azure.mgmt.machinelearningservices.models.FQDNEndpointDetail]
        """
        super(FQDNEndpoint, self).__init__(**kwargs)
        self.domain_name = domain_name
        self.endpoint_details = endpoint_details


class FQDNEndpointDetail(msrest.serialization.Model):
    """FQDNEndpointDetail.

    :ivar port:
    :vartype port: int
    """

    _attribute_map = {
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        port: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword port:
        :paramtype port: int
        """
        super(FQDNEndpointDetail, self).__init__(**kwargs)
        self.port = port


class FQDNEndpoints(msrest.serialization.Model):
    """FQDNEndpoints.

    :ivar category:
    :vartype category: str
    :ivar endpoints:
    :vartype endpoints: list[~azure.mgmt.machinelearningservices.models.FQDNEndpoint]
    """

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'endpoints': {'key': 'endpoints', 'type': '[FQDNEndpoint]'},
    }

    def __init__(
        self,
        *,
        category: Optional[str] = None,
        endpoints: Optional[List["FQDNEndpoint"]] = None,
        **kwargs
    ):
        """
        :keyword category:
        :paramtype category: str
        :keyword endpoints:
        :paramtype endpoints: list[~azure.mgmt.machinelearningservices.models.FQDNEndpoint]
        """
        super(FQDNEndpoints, self).__init__(**kwargs)
        self.category = category
        self.endpoints = endpoints


class FQDNEndpointsPropertyBag(msrest.serialization.Model):
    """Property bag for FQDN endpoints result.

    :ivar properties:
    :vartype properties: ~azure.mgmt.machinelearningservices.models.FQDNEndpoints
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'FQDNEndpoints'},
    }

    def __init__(
        self,
        *,
        properties: Optional["FQDNEndpoints"] = None,
        **kwargs
    ):
        """
        :keyword properties:
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.FQDNEndpoints
        """
        super(FQDNEndpointsPropertyBag, self).__init__(**kwargs)
        self.properties = properties


class OutboundRule(msrest.serialization.Model):
    """Outbound Rule for the managed network of a machine learning workspace.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: FqdnOutboundRule, PrivateEndpointOutboundRule, ServiceTagOutboundRule.

    All required parameters must be populated in order to send to Azure.

    :ivar category: Category of a managed network Outbound Rule of a machine learning workspace.
     Possible values include: "Required", "Recommended", "UserDefined", "Dependency".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.RuleCategory
    :ivar status: Type of a managed network Outbound Rule of a machine learning workspace. Possible
     values include: "Inactive", "Active".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.RuleStatus
    :ivar type: Required. Type of a managed network Outbound Rule of a machine learning
     workspace.Constant filled by server. Possible values include: "FQDN", "PrivateEndpoint",
     "ServiceTag".
    :vartype type: str or ~azure.mgmt.machinelearningservices.models.RuleType
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'FQDN': 'FqdnOutboundRule', 'PrivateEndpoint': 'PrivateEndpointOutboundRule', 'ServiceTag': 'ServiceTagOutboundRule'}
    }

    def __init__(
        self,
        *,
        category: Optional[Union[str, "RuleCategory"]] = None,
        status: Optional[Union[str, "RuleStatus"]] = None,
        **kwargs
    ):
        """
        :keyword category: Category of a managed network Outbound Rule of a machine learning workspace.
         Possible values include: "Required", "Recommended", "UserDefined", "Dependency".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.RuleCategory
        :keyword status: Type of a managed network Outbound Rule of a machine learning workspace.
         Possible values include: "Inactive", "Active".
        :paramtype status: str or ~azure.mgmt.machinelearningservices.models.RuleStatus
        """
        super(OutboundRule, self).__init__(**kwargs)
        self.category = category
        self.status = status
        self.type = None  # type: Optional[str]


class FqdnOutboundRule(OutboundRule):
    """FQDN Outbound Rule for the managed network of a machine learning workspace.

    All required parameters must be populated in order to send to Azure.

    :ivar category: Category of a managed network Outbound Rule of a machine learning workspace.
     Possible values include: "Required", "Recommended", "UserDefined", "Dependency".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.RuleCategory
    :ivar status: Type of a managed network Outbound Rule of a machine learning workspace. Possible
     values include: "Inactive", "Active".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.RuleStatus
    :ivar type: Required. Type of a managed network Outbound Rule of a machine learning
     workspace.Constant filled by server. Possible values include: "FQDN", "PrivateEndpoint",
     "ServiceTag".
    :vartype type: str or ~azure.mgmt.machinelearningservices.models.RuleType
    :ivar destination:
    :vartype destination: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'destination': {'key': 'destination', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        category: Optional[Union[str, "RuleCategory"]] = None,
        status: Optional[Union[str, "RuleStatus"]] = None,
        destination: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword category: Category of a managed network Outbound Rule of a machine learning workspace.
         Possible values include: "Required", "Recommended", "UserDefined", "Dependency".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.RuleCategory
        :keyword status: Type of a managed network Outbound Rule of a machine learning workspace.
         Possible values include: "Inactive", "Active".
        :paramtype status: str or ~azure.mgmt.machinelearningservices.models.RuleStatus
        :keyword destination:
        :paramtype destination: str
        """
        super(FqdnOutboundRule, self).__init__(category=category, status=status, **kwargs)
        self.type = 'FQDN'  # type: str
        self.destination = destination


class GenerationSafetyQualityMetricThreshold(msrest.serialization.Model):
    """Generation safety quality metric threshold definition.

    All required parameters must be populated in order to send to Azure.

    :ivar metric: Required. [Required] Gets or sets the feature attribution metric to calculate.
     Possible values include: "AcceptableGroundednessScorePerInstance",
     "AggregatedGroundednessPassRate", "AcceptableCoherenceScorePerInstance",
     "AggregatedCoherencePassRate", "AcceptableFluencyScorePerInstance",
     "AggregatedFluencyPassRate", "AcceptableSimilarityScorePerInstance",
     "AggregatedSimilarityPassRate", "AcceptableRelevanceScorePerInstance",
     "AggregatedRelevancePassRate".
    :vartype metric: str or
     ~azure.mgmt.machinelearningservices.models.GenerationSafetyQualityMetric
    :ivar threshold: Gets or sets the threshold value.
     If null, a default value will be set depending on the selected metric.
    :vartype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
    """

    _validation = {
        'metric': {'required': True},
    }

    _attribute_map = {
        'metric': {'key': 'metric', 'type': 'str'},
        'threshold': {'key': 'threshold', 'type': 'MonitoringThreshold'},
    }

    def __init__(
        self,
        *,
        metric: Union[str, "GenerationSafetyQualityMetric"],
        threshold: Optional["MonitoringThreshold"] = None,
        **kwargs
    ):
        """
        :keyword metric: Required. [Required] Gets or sets the feature attribution metric to calculate.
         Possible values include: "AcceptableGroundednessScorePerInstance",
         "AggregatedGroundednessPassRate", "AcceptableCoherenceScorePerInstance",
         "AggregatedCoherencePassRate", "AcceptableFluencyScorePerInstance",
         "AggregatedFluencyPassRate", "AcceptableSimilarityScorePerInstance",
         "AggregatedSimilarityPassRate", "AcceptableRelevanceScorePerInstance",
         "AggregatedRelevancePassRate".
        :paramtype metric: str or
         ~azure.mgmt.machinelearningservices.models.GenerationSafetyQualityMetric
        :keyword threshold: Gets or sets the threshold value.
         If null, a default value will be set depending on the selected metric.
        :paramtype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
        """
        super(GenerationSafetyQualityMetricThreshold, self).__init__(**kwargs)
        self.metric = metric
        self.threshold = threshold


class GenerationSafetyQualityMonitoringSignal(MonitoringSignalBase):
    """Generation safety quality monitoring signal definition.

    All required parameters must be populated in order to send to Azure.

    :ivar notification_types: The current notification mode for this signal.
    :vartype notification_types: list[str or
     ~azure.mgmt.machinelearningservices.models.MonitoringNotificationType]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar signal_type: Required. [Required] Specifies the type of signal to monitor.Constant filled
     by server. Possible values include: "DataDrift", "PredictionDrift", "DataQuality",
     "FeatureAttributionDrift", "Custom", "ModelPerformance", "GenerationSafetyQuality",
     "GenerationTokenStatistics".
    :vartype signal_type: str or ~azure.mgmt.machinelearningservices.models.MonitoringSignalType
    :ivar metric_thresholds: Required. [Required] Gets or sets the metrics to calculate and the
     corresponding thresholds.
    :vartype metric_thresholds:
     list[~azure.mgmt.machinelearningservices.models.GenerationSafetyQualityMetricThreshold]
    :ivar production_data: Gets or sets the production data for computing metrics.
    :vartype production_data:
     list[~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase]
    :ivar sampling_rate: Required. [Required] The sample rate of the production data, should be
     greater than 0 and at most 1.
    :vartype sampling_rate: float
    :ivar workspace_connection_id: Gets or sets the workspace connection ID used to connect to the
     content generation endpoint.
    :vartype workspace_connection_id: str
    """

    _validation = {
        'signal_type': {'required': True},
        'metric_thresholds': {'required': True},
        'sampling_rate': {'required': True},
    }

    _attribute_map = {
        'notification_types': {'key': 'notificationTypes', 'type': '[str]'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'signal_type': {'key': 'signalType', 'type': 'str'},
        'metric_thresholds': {'key': 'metricThresholds', 'type': '[GenerationSafetyQualityMetricThreshold]'},
        'production_data': {'key': 'productionData', 'type': '[MonitoringInputDataBase]'},
        'sampling_rate': {'key': 'samplingRate', 'type': 'float'},
        'workspace_connection_id': {'key': 'workspaceConnectionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        metric_thresholds: List["GenerationSafetyQualityMetricThreshold"],
        sampling_rate: float,
        notification_types: Optional[List[Union[str, "MonitoringNotificationType"]]] = None,
        properties: Optional[Dict[str, str]] = None,
        production_data: Optional[List["MonitoringInputDataBase"]] = None,
        workspace_connection_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword notification_types: The current notification mode for this signal.
        :paramtype notification_types: list[str or
         ~azure.mgmt.machinelearningservices.models.MonitoringNotificationType]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword metric_thresholds: Required. [Required] Gets or sets the metrics to calculate and the
         corresponding thresholds.
        :paramtype metric_thresholds:
         list[~azure.mgmt.machinelearningservices.models.GenerationSafetyQualityMetricThreshold]
        :keyword production_data: Gets or sets the production data for computing metrics.
        :paramtype production_data:
         list[~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase]
        :keyword sampling_rate: Required. [Required] The sample rate of the production data, should be
         greater than 0 and at most 1.
        :paramtype sampling_rate: float
        :keyword workspace_connection_id: Gets or sets the workspace connection ID used to connect to
         the content generation endpoint.
        :paramtype workspace_connection_id: str
        """
        super(GenerationSafetyQualityMonitoringSignal, self).__init__(notification_types=notification_types, properties=properties, **kwargs)
        self.signal_type = 'GenerationSafetyQuality'  # type: str
        self.metric_thresholds = metric_thresholds
        self.production_data = production_data
        self.sampling_rate = sampling_rate
        self.workspace_connection_id = workspace_connection_id


class GenerationTokenUsageMetricThreshold(msrest.serialization.Model):
    """Generation token statistics metric threshold definition.

    All required parameters must be populated in order to send to Azure.

    :ivar metric: Required. [Required] Gets or sets the feature attribution metric to calculate.
     Possible values include: "TotalTokenCount", "TotalTokenCountPerGroup".
    :vartype metric: str or ~azure.mgmt.machinelearningservices.models.GenerationTokenUsageMetric
    :ivar threshold: Gets or sets the threshold value.
     If null, a default value will be set depending on the selected metric.
    :vartype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
    """

    _validation = {
        'metric': {'required': True},
    }

    _attribute_map = {
        'metric': {'key': 'metric', 'type': 'str'},
        'threshold': {'key': 'threshold', 'type': 'MonitoringThreshold'},
    }

    def __init__(
        self,
        *,
        metric: Union[str, "GenerationTokenUsageMetric"],
        threshold: Optional["MonitoringThreshold"] = None,
        **kwargs
    ):
        """
        :keyword metric: Required. [Required] Gets or sets the feature attribution metric to calculate.
         Possible values include: "TotalTokenCount", "TotalTokenCountPerGroup".
        :paramtype metric: str or ~azure.mgmt.machinelearningservices.models.GenerationTokenUsageMetric
        :keyword threshold: Gets or sets the threshold value.
         If null, a default value will be set depending on the selected metric.
        :paramtype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
        """
        super(GenerationTokenUsageMetricThreshold, self).__init__(**kwargs)
        self.metric = metric
        self.threshold = threshold


class GenerationTokenUsageSignal(MonitoringSignalBase):
    """Generation token usage signal definition.

    All required parameters must be populated in order to send to Azure.

    :ivar notification_types: The current notification mode for this signal.
    :vartype notification_types: list[str or
     ~azure.mgmt.machinelearningservices.models.MonitoringNotificationType]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar signal_type: Required. [Required] Specifies the type of signal to monitor.Constant filled
     by server. Possible values include: "DataDrift", "PredictionDrift", "DataQuality",
     "FeatureAttributionDrift", "Custom", "ModelPerformance", "GenerationSafetyQuality",
     "GenerationTokenStatistics".
    :vartype signal_type: str or ~azure.mgmt.machinelearningservices.models.MonitoringSignalType
    :ivar metric_thresholds: Required. [Required] Gets or sets the metrics to calculate and the
     corresponding thresholds.
    :vartype metric_thresholds:
     list[~azure.mgmt.machinelearningservices.models.GenerationTokenUsageMetricThreshold]
    :ivar production_data: Gets or sets the production data for computing metrics.
    :vartype production_data:
     list[~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase]
    :ivar sampling_rate: Required. [Required] The sample rate of the production data, should be
     greater than 0 and at most 1.
    :vartype sampling_rate: float
    """

    _validation = {
        'signal_type': {'required': True},
        'metric_thresholds': {'required': True},
        'sampling_rate': {'required': True},
    }

    _attribute_map = {
        'notification_types': {'key': 'notificationTypes', 'type': '[str]'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'signal_type': {'key': 'signalType', 'type': 'str'},
        'metric_thresholds': {'key': 'metricThresholds', 'type': '[GenerationTokenUsageMetricThreshold]'},
        'production_data': {'key': 'productionData', 'type': '[MonitoringInputDataBase]'},
        'sampling_rate': {'key': 'samplingRate', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        metric_thresholds: List["GenerationTokenUsageMetricThreshold"],
        sampling_rate: float,
        notification_types: Optional[List[Union[str, "MonitoringNotificationType"]]] = None,
        properties: Optional[Dict[str, str]] = None,
        production_data: Optional[List["MonitoringInputDataBase"]] = None,
        **kwargs
    ):
        """
        :keyword notification_types: The current notification mode for this signal.
        :paramtype notification_types: list[str or
         ~azure.mgmt.machinelearningservices.models.MonitoringNotificationType]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword metric_thresholds: Required. [Required] Gets or sets the metrics to calculate and the
         corresponding thresholds.
        :paramtype metric_thresholds:
         list[~azure.mgmt.machinelearningservices.models.GenerationTokenUsageMetricThreshold]
        :keyword production_data: Gets or sets the production data for computing metrics.
        :paramtype production_data:
         list[~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase]
        :keyword sampling_rate: Required. [Required] The sample rate of the production data, should be
         greater than 0 and at most 1.
        :paramtype sampling_rate: float
        """
        super(GenerationTokenUsageSignal, self).__init__(notification_types=notification_types, properties=properties, **kwargs)
        self.signal_type = 'GenerationTokenStatistics'  # type: str
        self.metric_thresholds = metric_thresholds
        self.production_data = production_data
        self.sampling_rate = sampling_rate


class GetBlobReferenceForConsumptionDto(msrest.serialization.Model):
    """GetBlobReferenceForConsumptionDto.

    :ivar blob_uri: Blob uri, example: https://blob.windows.core.net/Container/Path.
    :vartype blob_uri: str
    :ivar credential: Credential info to access storage account.
    :vartype credential: ~azure.mgmt.machinelearningservices.models.DataReferenceCredential
    :ivar storage_account_arm_id: The ARM id of the storage account.
    :vartype storage_account_arm_id: str
    """

    _attribute_map = {
        'blob_uri': {'key': 'blobUri', 'type': 'str'},
        'credential': {'key': 'credential', 'type': 'DataReferenceCredential'},
        'storage_account_arm_id': {'key': 'storageAccountArmId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        blob_uri: Optional[str] = None,
        credential: Optional["DataReferenceCredential"] = None,
        storage_account_arm_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword blob_uri: Blob uri, example: https://blob.windows.core.net/Container/Path.
        :paramtype blob_uri: str
        :keyword credential: Credential info to access storage account.
        :paramtype credential: ~azure.mgmt.machinelearningservices.models.DataReferenceCredential
        :keyword storage_account_arm_id: The ARM id of the storage account.
        :paramtype storage_account_arm_id: str
        """
        super(GetBlobReferenceForConsumptionDto, self).__init__(**kwargs)
        self.blob_uri = blob_uri
        self.credential = credential
        self.storage_account_arm_id = storage_account_arm_id


class GetBlobReferenceSASRequestDto(msrest.serialization.Model):
    """BlobReferenceSASRequest for getBlobReferenceSAS API.

    :ivar asset_id: Id of the asset to be accessed.
    :vartype asset_id: str
    :ivar blob_uri: Blob uri of the asset to be accessed.
    :vartype blob_uri: str
    """

    _attribute_map = {
        'asset_id': {'key': 'assetId', 'type': 'str'},
        'blob_uri': {'key': 'blobUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        asset_id: Optional[str] = None,
        blob_uri: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword asset_id: Id of the asset to be accessed.
        :paramtype asset_id: str
        :keyword blob_uri: Blob uri of the asset to be accessed.
        :paramtype blob_uri: str
        """
        super(GetBlobReferenceSASRequestDto, self).__init__(**kwargs)
        self.asset_id = asset_id
        self.blob_uri = blob_uri


class GetBlobReferenceSASResponseDto(msrest.serialization.Model):
    """BlobReferenceSASResponse for getBlobReferenceSAS API.

    :ivar blob_reference_for_consumption: Blob reference for consumption details.
    :vartype blob_reference_for_consumption:
     ~azure.mgmt.machinelearningservices.models.GetBlobReferenceForConsumptionDto
    """

    _attribute_map = {
        'blob_reference_for_consumption': {'key': 'blobReferenceForConsumption', 'type': 'GetBlobReferenceForConsumptionDto'},
    }

    def __init__(
        self,
        *,
        blob_reference_for_consumption: Optional["GetBlobReferenceForConsumptionDto"] = None,
        **kwargs
    ):
        """
        :keyword blob_reference_for_consumption: Blob reference for consumption details.
        :paramtype blob_reference_for_consumption:
         ~azure.mgmt.machinelearningservices.models.GetBlobReferenceForConsumptionDto
        """
        super(GetBlobReferenceSASResponseDto, self).__init__(**kwargs)
        self.blob_reference_for_consumption = blob_reference_for_consumption


class GridSamplingAlgorithm(SamplingAlgorithm):
    """Defines a Sampling Algorithm that exhaustively generates every value combination in the space.

    All required parameters must be populated in order to send to Azure.

    :ivar sampling_algorithm_type: Required. [Required] The algorithm used for generating
     hyperparameter values, along with configuration properties.Constant filled by server. Possible
     values include: "Grid", "Random", "Bayesian".
    :vartype sampling_algorithm_type: str or
     ~azure.mgmt.machinelearningservices.models.SamplingAlgorithmType
    """

    _validation = {
        'sampling_algorithm_type': {'required': True},
    }

    _attribute_map = {
        'sampling_algorithm_type': {'key': 'samplingAlgorithmType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(GridSamplingAlgorithm, self).__init__(**kwargs)
        self.sampling_algorithm_type = 'Grid'  # type: str


class GroupStatus(msrest.serialization.Model):
    """GroupStatus.

    :ivar actual_capacity_info: Gets or sets the actual capacity info for the group.
    :vartype actual_capacity_info: ~azure.mgmt.machinelearningservices.models.ActualCapacityInfo
    :ivar bonus_extra_capacity: Gets or sets capacity used from the pool's reserved capacity.
    :vartype bonus_extra_capacity: int
    :ivar endpoint_count: Gets or sets the actual number of endpoints in the group.
    :vartype endpoint_count: int
    :ivar requested_capacity: Gets or sets the request number of instances for the group.
    :vartype requested_capacity: int
    """

    _attribute_map = {
        'actual_capacity_info': {'key': 'actualCapacityInfo', 'type': 'ActualCapacityInfo'},
        'bonus_extra_capacity': {'key': 'bonusExtraCapacity', 'type': 'int'},
        'endpoint_count': {'key': 'endpointCount', 'type': 'int'},
        'requested_capacity': {'key': 'requestedCapacity', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        actual_capacity_info: Optional["ActualCapacityInfo"] = None,
        bonus_extra_capacity: Optional[int] = 0,
        endpoint_count: Optional[int] = 0,
        requested_capacity: Optional[int] = 0,
        **kwargs
    ):
        """
        :keyword actual_capacity_info: Gets or sets the actual capacity info for the group.
        :paramtype actual_capacity_info: ~azure.mgmt.machinelearningservices.models.ActualCapacityInfo
        :keyword bonus_extra_capacity: Gets or sets capacity used from the pool's reserved capacity.
        :paramtype bonus_extra_capacity: int
        :keyword endpoint_count: Gets or sets the actual number of endpoints in the group.
        :paramtype endpoint_count: int
        :keyword requested_capacity: Gets or sets the request number of instances for the group.
        :paramtype requested_capacity: int
        """
        super(GroupStatus, self).__init__(**kwargs)
        self.actual_capacity_info = actual_capacity_info
        self.bonus_extra_capacity = bonus_extra_capacity
        self.endpoint_count = endpoint_count
        self.requested_capacity = requested_capacity


class HdfsDatastore(DatastoreProperties):
    """HdfsDatastore.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar credentials: Required. [Required] Account credentials.
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
    :ivar datastore_type: Required. [Required] Storage type backing the datastore.Constant filled
     by server. Possible values include: "AzureBlob", "AzureDataLakeGen1", "AzureDataLakeGen2",
     "AzureFile", "Hdfs", "OneLake".
    :vartype datastore_type: str or ~azure.mgmt.machinelearningservices.models.DatastoreType
    :ivar intellectual_property: Intellectual Property details.
    :vartype intellectual_property: ~azure.mgmt.machinelearningservices.models.IntellectualProperty
    :ivar is_default: Readonly property to indicate if datastore is the workspace default
     datastore.
    :vartype is_default: bool
    :ivar hdfs_server_certificate: The TLS cert of the HDFS server. Needs to be a base64 encoded
     string. Required if "Https" protocol is selected.
    :vartype hdfs_server_certificate: str
    :ivar name_node_address: Required. [Required] IP Address or DNS HostName.
    :vartype name_node_address: str
    :ivar protocol: Protocol used to communicate with the storage account (Https/Http).
    :vartype protocol: str
    """

    _validation = {
        'credentials': {'required': True},
        'datastore_type': {'required': True},
        'is_default': {'readonly': True},
        'name_node_address': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'credentials': {'key': 'credentials', 'type': 'DatastoreCredentials'},
        'datastore_type': {'key': 'datastoreType', 'type': 'str'},
        'intellectual_property': {'key': 'intellectualProperty', 'type': 'IntellectualProperty'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
        'hdfs_server_certificate': {'key': 'hdfsServerCertificate', 'type': 'str'},
        'name_node_address': {'key': 'nameNodeAddress', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        credentials: "DatastoreCredentials",
        name_node_address: str,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        intellectual_property: Optional["IntellectualProperty"] = None,
        hdfs_server_certificate: Optional[str] = None,
        protocol: Optional[str] = "http",
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword credentials: Required. [Required] Account credentials.
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
        :keyword intellectual_property: Intellectual Property details.
        :paramtype intellectual_property:
         ~azure.mgmt.machinelearningservices.models.IntellectualProperty
        :keyword hdfs_server_certificate: The TLS cert of the HDFS server. Needs to be a base64 encoded
         string. Required if "Https" protocol is selected.
        :paramtype hdfs_server_certificate: str
        :keyword name_node_address: Required. [Required] IP Address or DNS HostName.
        :paramtype name_node_address: str
        :keyword protocol: Protocol used to communicate with the storage account (Https/Http).
        :paramtype protocol: str
        """
        super(HdfsDatastore, self).__init__(description=description, properties=properties, tags=tags, credentials=credentials, intellectual_property=intellectual_property, **kwargs)
        self.datastore_type = 'Hdfs'  # type: str
        self.hdfs_server_certificate = hdfs_server_certificate
        self.name_node_address = name_node_address
        self.protocol = protocol


class HDInsightSchema(msrest.serialization.Model):
    """HDInsightSchema.

    :ivar properties: HDInsight compute properties.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.HDInsightProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'HDInsightProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["HDInsightProperties"] = None,
        **kwargs
    ):
        """
        :keyword properties: HDInsight compute properties.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.HDInsightProperties
        """
        super(HDInsightSchema, self).__init__(**kwargs)
        self.properties = properties


class HDInsight(Compute, HDInsightSchema):
    """A HDInsight compute.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: HDInsight compute properties.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.HDInsightProperties
    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    """

    _validation = {
        'compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'HDInsightProperties'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[ErrorResponse]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'disable_local_auth': {'key': 'disableLocalAuth', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        properties: Optional["HDInsightProperties"] = None,
        compute_location: Optional[str] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        disable_local_auth: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword properties: HDInsight compute properties.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.HDInsightProperties
        :keyword compute_location: Location for the underlying compute.
        :paramtype compute_location: str
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        :keyword disable_local_auth: Opt-out of local authentication and ensure customers can use only
         MSI and AAD exclusively for authentication.
        :paramtype disable_local_auth: bool
        """
        super(HDInsight, self).__init__(compute_location=compute_location, description=description, resource_id=resource_id, disable_local_auth=disable_local_auth, properties=properties, **kwargs)
        self.properties = properties
        self.compute_type = 'HDInsight'  # type: str
        self.compute_location = compute_location
        self.provisioning_state = None
        self.description = description
        self.created_on = None
        self.modified_on = None
        self.resource_id = resource_id
        self.provisioning_errors = None
        self.is_attached_compute = None
        self.disable_local_auth = disable_local_auth


class HDInsightProperties(msrest.serialization.Model):
    """HDInsight compute properties.

    :ivar ssh_port: Port open for ssh connections on the master node of the cluster.
    :vartype ssh_port: int
    :ivar address: Public IP address of the master node of the cluster.
    :vartype address: str
    :ivar administrator_account: Admin credentials for master node of the cluster.
    :vartype administrator_account:
     ~azure.mgmt.machinelearningservices.models.VirtualMachineSshCredentials
    """

    _attribute_map = {
        'ssh_port': {'key': 'sshPort', 'type': 'int'},
        'address': {'key': 'address', 'type': 'str'},
        'administrator_account': {'key': 'administratorAccount', 'type': 'VirtualMachineSshCredentials'},
    }

    def __init__(
        self,
        *,
        ssh_port: Optional[int] = None,
        address: Optional[str] = None,
        administrator_account: Optional["VirtualMachineSshCredentials"] = None,
        **kwargs
    ):
        """
        :keyword ssh_port: Port open for ssh connections on the master node of the cluster.
        :paramtype ssh_port: int
        :keyword address: Public IP address of the master node of the cluster.
        :paramtype address: str
        :keyword administrator_account: Admin credentials for master node of the cluster.
        :paramtype administrator_account:
         ~azure.mgmt.machinelearningservices.models.VirtualMachineSshCredentials
        """
        super(HDInsightProperties, self).__init__(**kwargs)
        self.ssh_port = ssh_port
        self.address = address
        self.administrator_account = administrator_account


class IdAssetReference(AssetReferenceBase):
    """Reference to an asset via its ARM resource ID.

    All required parameters must be populated in order to send to Azure.

    :ivar reference_type: Required. [Required] Specifies the type of asset reference.Constant
     filled by server. Possible values include: "Id", "DataPath", "OutputPath".
    :vartype reference_type: str or ~azure.mgmt.machinelearningservices.models.ReferenceType
    :ivar asset_id: Required. [Required] ARM resource ID of the asset.
    :vartype asset_id: str
    """

    _validation = {
        'reference_type': {'required': True},
        'asset_id': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'reference_type': {'key': 'referenceType', 'type': 'str'},
        'asset_id': {'key': 'assetId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        asset_id: str,
        **kwargs
    ):
        """
        :keyword asset_id: Required. [Required] ARM resource ID of the asset.
        :paramtype asset_id: str
        """
        super(IdAssetReference, self).__init__(**kwargs)
        self.reference_type = 'Id'  # type: str
        self.asset_id = asset_id


class IdentityForCmk(msrest.serialization.Model):
    """Identity object used for encryption.

    :ivar user_assigned_identity: UserAssignedIdentity to be used to fetch the encryption key from
     keyVault.
    :vartype user_assigned_identity: str
    """

    _attribute_map = {
        'user_assigned_identity': {'key': 'userAssignedIdentity', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        user_assigned_identity: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword user_assigned_identity: UserAssignedIdentity to be used to fetch the encryption key
         from keyVault.
        :paramtype user_assigned_identity: str
        """
        super(IdentityForCmk, self).__init__(**kwargs)
        self.user_assigned_identity = user_assigned_identity


class IdleShutdownSetting(msrest.serialization.Model):
    """Stops compute instance after user defined period of inactivity.

    :ivar idle_time_before_shutdown: Time is defined in ISO8601 format. Minimum is 15 min, maximum
     is 3 days.
    :vartype idle_time_before_shutdown: str
    """

    _attribute_map = {
        'idle_time_before_shutdown': {'key': 'idleTimeBeforeShutdown', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        idle_time_before_shutdown: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword idle_time_before_shutdown: Time is defined in ISO8601 format. Minimum is 15 min,
         maximum is 3 days.
        :paramtype idle_time_before_shutdown: str
        """
        super(IdleShutdownSetting, self).__init__(**kwargs)
        self.idle_time_before_shutdown = idle_time_before_shutdown


class Image(msrest.serialization.Model):
    """Image.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar type: Type of the image. Possible values are: docker - For docker images. azureml - For
     AzureML Environment images (custom and curated). Possible values include: "docker", "azureml".
     Default value: "docker".
    :vartype type: str or ~azure.mgmt.machinelearningservices.models.ImageType
    :ivar reference: Image reference URL if type is docker. Environment name if type is azureml.
    :vartype reference: str
    :ivar version: Version of image being used. If latest then skip this field.
    :vartype version: str
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'reference': {'key': 'reference', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        type: Optional[Union[str, "ImageType"]] = "docker",
        reference: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword type: Type of the image. Possible values are: docker - For docker images. azureml -
         For AzureML Environment images (custom and curated). Possible values include: "docker",
         "azureml". Default value: "docker".
        :paramtype type: str or ~azure.mgmt.machinelearningservices.models.ImageType
        :keyword reference: Image reference URL if type is docker. Environment name if type is azureml.
        :paramtype reference: str
        :keyword version: Version of image being used. If latest then skip this field.
        :paramtype version: str
        """
        super(Image, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = type
        self.reference = reference
        self.version = version


class ImageVertical(msrest.serialization.Model):
    """Abstract class for AutoML tasks that train image (computer vision) models -
such as Image Classification / Image Classification Multilabel / Image Object Detection / Image Instance Segmentation.

    All required parameters must be populated in order to send to Azure.

    :ivar limit_settings: Required. [Required] Limit settings for the AutoML job.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
    :ivar sweep_settings: Model sweeping and hyperparameter sweeping related settings.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    """

    _validation = {
        'limit_settings': {'required': True},
    }

    _attribute_map = {
        'limit_settings': {'key': 'limitSettings', 'type': 'ImageLimitSettings'},
        'sweep_settings': {'key': 'sweepSettings', 'type': 'ImageSweepSettings'},
        'validation_data': {'key': 'validationData', 'type': 'MLTableJobInput'},
        'validation_data_size': {'key': 'validationDataSize', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        limit_settings: "ImageLimitSettings",
        sweep_settings: Optional["ImageSweepSettings"] = None,
        validation_data: Optional["MLTableJobInput"] = None,
        validation_data_size: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword limit_settings: Required. [Required] Limit settings for the AutoML job.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
        :keyword sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        """
        super(ImageVertical, self).__init__(**kwargs)
        self.limit_settings = limit_settings
        self.sweep_settings = sweep_settings
        self.validation_data = validation_data
        self.validation_data_size = validation_data_size


class ImageClassificationBase(ImageVertical):
    """ImageClassificationBase.

    All required parameters must be populated in order to send to Azure.

    :ivar limit_settings: Required. [Required] Limit settings for the AutoML job.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
    :ivar sweep_settings: Model sweeping and hyperparameter sweeping related settings.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    :ivar model_settings: Settings used for training the model.
    :vartype model_settings:
     ~azure.mgmt.machinelearningservices.models.ImageModelSettingsClassification
    :ivar search_space: Search space for sampling different combinations of models and their
     hyperparameters.
    :vartype search_space:
     list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsClassification]
    """

    _validation = {
        'limit_settings': {'required': True},
    }

    _attribute_map = {
        'limit_settings': {'key': 'limitSettings', 'type': 'ImageLimitSettings'},
        'sweep_settings': {'key': 'sweepSettings', 'type': 'ImageSweepSettings'},
        'validation_data': {'key': 'validationData', 'type': 'MLTableJobInput'},
        'validation_data_size': {'key': 'validationDataSize', 'type': 'float'},
        'model_settings': {'key': 'modelSettings', 'type': 'ImageModelSettingsClassification'},
        'search_space': {'key': 'searchSpace', 'type': '[ImageModelDistributionSettingsClassification]'},
    }

    def __init__(
        self,
        *,
        limit_settings: "ImageLimitSettings",
        sweep_settings: Optional["ImageSweepSettings"] = None,
        validation_data: Optional["MLTableJobInput"] = None,
        validation_data_size: Optional[float] = None,
        model_settings: Optional["ImageModelSettingsClassification"] = None,
        search_space: Optional[List["ImageModelDistributionSettingsClassification"]] = None,
        **kwargs
    ):
        """
        :keyword limit_settings: Required. [Required] Limit settings for the AutoML job.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
        :keyword sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        :keyword model_settings: Settings used for training the model.
        :paramtype model_settings:
         ~azure.mgmt.machinelearningservices.models.ImageModelSettingsClassification
        :keyword search_space: Search space for sampling different combinations of models and their
         hyperparameters.
        :paramtype search_space:
         list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsClassification]
        """
        super(ImageClassificationBase, self).__init__(limit_settings=limit_settings, sweep_settings=sweep_settings, validation_data=validation_data, validation_data_size=validation_data_size, **kwargs)
        self.model_settings = model_settings
        self.search_space = search_space


class ImageClassification(AutoMLVertical, ImageClassificationBase):
    """Image Classification. Multi-class image classification is used when an image is classified with only a single label
from a set of classes - e.g. each image is classified as either an image of a 'cat' or a 'dog' or a 'duck'.

    All required parameters must be populated in order to send to Azure.

    :ivar limit_settings: Required. [Required] Limit settings for the AutoML job.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
    :ivar sweep_settings: Model sweeping and hyperparameter sweeping related settings.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    :ivar model_settings: Settings used for training the model.
    :vartype model_settings:
     ~azure.mgmt.machinelearningservices.models.ImageModelSettingsClassification
    :ivar search_space: Search space for sampling different combinations of models and their
     hyperparameters.
    :vartype search_space:
     list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsClassification]
    :ivar log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
     "Info", "Warning", "Error", "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar target_column_name: Target column name: This is prediction values column.
     Also known as label column name in context of classification tasks.
    :vartype target_column_name: str
    :ivar task_type: Required. [Required] Task type for AutoMLJob.Constant filled by server.
     Possible values include: "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    :ivar training_data: Required. [Required] Training data input.
    :vartype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar primary_metric: Primary metric to optimize for this task. Possible values include:
     "AUCWeighted", "Accuracy", "NormMacroRecall", "AveragePrecisionScoreWeighted",
     "PrecisionScoreWeighted".
    :vartype primary_metric: str or
     ~azure.mgmt.machinelearningservices.models.ClassificationPrimaryMetrics
    """

    _validation = {
        'limit_settings': {'required': True},
        'task_type': {'required': True},
        'training_data': {'required': True},
    }

    _attribute_map = {
        'limit_settings': {'key': 'limitSettings', 'type': 'ImageLimitSettings'},
        'sweep_settings': {'key': 'sweepSettings', 'type': 'ImageSweepSettings'},
        'validation_data': {'key': 'validationData', 'type': 'MLTableJobInput'},
        'validation_data_size': {'key': 'validationDataSize', 'type': 'float'},
        'model_settings': {'key': 'modelSettings', 'type': 'ImageModelSettingsClassification'},
        'search_space': {'key': 'searchSpace', 'type': '[ImageModelDistributionSettingsClassification]'},
        'log_verbosity': {'key': 'logVerbosity', 'type': 'str'},
        'target_column_name': {'key': 'targetColumnName', 'type': 'str'},
        'task_type': {'key': 'taskType', 'type': 'str'},
        'training_data': {'key': 'trainingData', 'type': 'MLTableJobInput'},
        'primary_metric': {'key': 'primaryMetric', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        limit_settings: "ImageLimitSettings",
        training_data: "MLTableJobInput",
        sweep_settings: Optional["ImageSweepSettings"] = None,
        validation_data: Optional["MLTableJobInput"] = None,
        validation_data_size: Optional[float] = None,
        model_settings: Optional["ImageModelSettingsClassification"] = None,
        search_space: Optional[List["ImageModelDistributionSettingsClassification"]] = None,
        log_verbosity: Optional[Union[str, "LogVerbosity"]] = None,
        target_column_name: Optional[str] = None,
        primary_metric: Optional[Union[str, "ClassificationPrimaryMetrics"]] = None,
        **kwargs
    ):
        """
        :keyword limit_settings: Required. [Required] Limit settings for the AutoML job.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
        :keyword sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        :keyword model_settings: Settings used for training the model.
        :paramtype model_settings:
         ~azure.mgmt.machinelearningservices.models.ImageModelSettingsClassification
        :keyword search_space: Search space for sampling different combinations of models and their
         hyperparameters.
        :paramtype search_space:
         list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsClassification]
        :keyword log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
         "Info", "Warning", "Error", "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        :keyword target_column_name: Target column name: This is prediction values column.
         Also known as label column name in context of classification tasks.
        :paramtype target_column_name: str
        :keyword training_data: Required. [Required] Training data input.
        :paramtype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword primary_metric: Primary metric to optimize for this task. Possible values include:
         "AUCWeighted", "Accuracy", "NormMacroRecall", "AveragePrecisionScoreWeighted",
         "PrecisionScoreWeighted".
        :paramtype primary_metric: str or
         ~azure.mgmt.machinelearningservices.models.ClassificationPrimaryMetrics
        """
        super(ImageClassification, self).__init__(log_verbosity=log_verbosity, target_column_name=target_column_name, training_data=training_data, limit_settings=limit_settings, sweep_settings=sweep_settings, validation_data=validation_data, validation_data_size=validation_data_size, model_settings=model_settings, search_space=search_space, **kwargs)
        self.limit_settings = limit_settings
        self.sweep_settings = sweep_settings
        self.validation_data = validation_data
        self.validation_data_size = validation_data_size
        self.model_settings = model_settings
        self.search_space = search_space
        self.task_type = 'ImageClassification'  # type: str
        self.primary_metric = primary_metric
        self.log_verbosity = log_verbosity
        self.target_column_name = target_column_name
        self.training_data = training_data


class ImageClassificationMultilabel(AutoMLVertical, ImageClassificationBase):
    """Image Classification Multilabel. Multi-label image classification is used when an image could have one or more labels
from a set of labels - e.g. an image could be labeled with both 'cat' and 'dog'.

    All required parameters must be populated in order to send to Azure.

    :ivar limit_settings: Required. [Required] Limit settings for the AutoML job.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
    :ivar sweep_settings: Model sweeping and hyperparameter sweeping related settings.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    :ivar model_settings: Settings used for training the model.
    :vartype model_settings:
     ~azure.mgmt.machinelearningservices.models.ImageModelSettingsClassification
    :ivar search_space: Search space for sampling different combinations of models and their
     hyperparameters.
    :vartype search_space:
     list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsClassification]
    :ivar log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
     "Info", "Warning", "Error", "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar target_column_name: Target column name: This is prediction values column.
     Also known as label column name in context of classification tasks.
    :vartype target_column_name: str
    :ivar task_type: Required. [Required] Task type for AutoMLJob.Constant filled by server.
     Possible values include: "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    :ivar training_data: Required. [Required] Training data input.
    :vartype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar primary_metric: Primary metric to optimize for this task. Possible values include:
     "AUCWeighted", "Accuracy", "NormMacroRecall", "AveragePrecisionScoreWeighted",
     "PrecisionScoreWeighted", "IOU".
    :vartype primary_metric: str or
     ~azure.mgmt.machinelearningservices.models.ClassificationMultilabelPrimaryMetrics
    """

    _validation = {
        'limit_settings': {'required': True},
        'task_type': {'required': True},
        'training_data': {'required': True},
    }

    _attribute_map = {
        'limit_settings': {'key': 'limitSettings', 'type': 'ImageLimitSettings'},
        'sweep_settings': {'key': 'sweepSettings', 'type': 'ImageSweepSettings'},
        'validation_data': {'key': 'validationData', 'type': 'MLTableJobInput'},
        'validation_data_size': {'key': 'validationDataSize', 'type': 'float'},
        'model_settings': {'key': 'modelSettings', 'type': 'ImageModelSettingsClassification'},
        'search_space': {'key': 'searchSpace', 'type': '[ImageModelDistributionSettingsClassification]'},
        'log_verbosity': {'key': 'logVerbosity', 'type': 'str'},
        'target_column_name': {'key': 'targetColumnName', 'type': 'str'},
        'task_type': {'key': 'taskType', 'type': 'str'},
        'training_data': {'key': 'trainingData', 'type': 'MLTableJobInput'},
        'primary_metric': {'key': 'primaryMetric', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        limit_settings: "ImageLimitSettings",
        training_data: "MLTableJobInput",
        sweep_settings: Optional["ImageSweepSettings"] = None,
        validation_data: Optional["MLTableJobInput"] = None,
        validation_data_size: Optional[float] = None,
        model_settings: Optional["ImageModelSettingsClassification"] = None,
        search_space: Optional[List["ImageModelDistributionSettingsClassification"]] = None,
        log_verbosity: Optional[Union[str, "LogVerbosity"]] = None,
        target_column_name: Optional[str] = None,
        primary_metric: Optional[Union[str, "ClassificationMultilabelPrimaryMetrics"]] = None,
        **kwargs
    ):
        """
        :keyword limit_settings: Required. [Required] Limit settings for the AutoML job.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
        :keyword sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        :keyword model_settings: Settings used for training the model.
        :paramtype model_settings:
         ~azure.mgmt.machinelearningservices.models.ImageModelSettingsClassification
        :keyword search_space: Search space for sampling different combinations of models and their
         hyperparameters.
        :paramtype search_space:
         list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsClassification]
        :keyword log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
         "Info", "Warning", "Error", "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        :keyword target_column_name: Target column name: This is prediction values column.
         Also known as label column name in context of classification tasks.
        :paramtype target_column_name: str
        :keyword training_data: Required. [Required] Training data input.
        :paramtype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword primary_metric: Primary metric to optimize for this task. Possible values include:
         "AUCWeighted", "Accuracy", "NormMacroRecall", "AveragePrecisionScoreWeighted",
         "PrecisionScoreWeighted", "IOU".
        :paramtype primary_metric: str or
         ~azure.mgmt.machinelearningservices.models.ClassificationMultilabelPrimaryMetrics
        """
        super(ImageClassificationMultilabel, self).__init__(log_verbosity=log_verbosity, target_column_name=target_column_name, training_data=training_data, limit_settings=limit_settings, sweep_settings=sweep_settings, validation_data=validation_data, validation_data_size=validation_data_size, model_settings=model_settings, search_space=search_space, **kwargs)
        self.limit_settings = limit_settings
        self.sweep_settings = sweep_settings
        self.validation_data = validation_data
        self.validation_data_size = validation_data_size
        self.model_settings = model_settings
        self.search_space = search_space
        self.task_type = 'ImageClassificationMultilabel'  # type: str
        self.primary_metric = primary_metric
        self.log_verbosity = log_verbosity
        self.target_column_name = target_column_name
        self.training_data = training_data


class ImageObjectDetectionBase(ImageVertical):
    """ImageObjectDetectionBase.

    All required parameters must be populated in order to send to Azure.

    :ivar limit_settings: Required. [Required] Limit settings for the AutoML job.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
    :ivar sweep_settings: Model sweeping and hyperparameter sweeping related settings.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    :ivar model_settings: Settings used for training the model.
    :vartype model_settings:
     ~azure.mgmt.machinelearningservices.models.ImageModelSettingsObjectDetection
    :ivar search_space: Search space for sampling different combinations of models and their
     hyperparameters.
    :vartype search_space:
     list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsObjectDetection]
    """

    _validation = {
        'limit_settings': {'required': True},
    }

    _attribute_map = {
        'limit_settings': {'key': 'limitSettings', 'type': 'ImageLimitSettings'},
        'sweep_settings': {'key': 'sweepSettings', 'type': 'ImageSweepSettings'},
        'validation_data': {'key': 'validationData', 'type': 'MLTableJobInput'},
        'validation_data_size': {'key': 'validationDataSize', 'type': 'float'},
        'model_settings': {'key': 'modelSettings', 'type': 'ImageModelSettingsObjectDetection'},
        'search_space': {'key': 'searchSpace', 'type': '[ImageModelDistributionSettingsObjectDetection]'},
    }

    def __init__(
        self,
        *,
        limit_settings: "ImageLimitSettings",
        sweep_settings: Optional["ImageSweepSettings"] = None,
        validation_data: Optional["MLTableJobInput"] = None,
        validation_data_size: Optional[float] = None,
        model_settings: Optional["ImageModelSettingsObjectDetection"] = None,
        search_space: Optional[List["ImageModelDistributionSettingsObjectDetection"]] = None,
        **kwargs
    ):
        """
        :keyword limit_settings: Required. [Required] Limit settings for the AutoML job.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
        :keyword sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        :keyword model_settings: Settings used for training the model.
        :paramtype model_settings:
         ~azure.mgmt.machinelearningservices.models.ImageModelSettingsObjectDetection
        :keyword search_space: Search space for sampling different combinations of models and their
         hyperparameters.
        :paramtype search_space:
         list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsObjectDetection]
        """
        super(ImageObjectDetectionBase, self).__init__(limit_settings=limit_settings, sweep_settings=sweep_settings, validation_data=validation_data, validation_data_size=validation_data_size, **kwargs)
        self.model_settings = model_settings
        self.search_space = search_space


class ImageInstanceSegmentation(AutoMLVertical, ImageObjectDetectionBase):
    """Image Instance Segmentation. Instance segmentation is used to identify objects in an image at the pixel level,
drawing a polygon around each object in the image.

    All required parameters must be populated in order to send to Azure.

    :ivar limit_settings: Required. [Required] Limit settings for the AutoML job.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
    :ivar sweep_settings: Model sweeping and hyperparameter sweeping related settings.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    :ivar model_settings: Settings used for training the model.
    :vartype model_settings:
     ~azure.mgmt.machinelearningservices.models.ImageModelSettingsObjectDetection
    :ivar search_space: Search space for sampling different combinations of models and their
     hyperparameters.
    :vartype search_space:
     list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsObjectDetection]
    :ivar log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
     "Info", "Warning", "Error", "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar target_column_name: Target column name: This is prediction values column.
     Also known as label column name in context of classification tasks.
    :vartype target_column_name: str
    :ivar task_type: Required. [Required] Task type for AutoMLJob.Constant filled by server.
     Possible values include: "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    :ivar training_data: Required. [Required] Training data input.
    :vartype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar primary_metric: Primary metric to optimize for this task. Possible values include:
     "MeanAveragePrecision".
    :vartype primary_metric: str or
     ~azure.mgmt.machinelearningservices.models.InstanceSegmentationPrimaryMetrics
    """

    _validation = {
        'limit_settings': {'required': True},
        'task_type': {'required': True},
        'training_data': {'required': True},
    }

    _attribute_map = {
        'limit_settings': {'key': 'limitSettings', 'type': 'ImageLimitSettings'},
        'sweep_settings': {'key': 'sweepSettings', 'type': 'ImageSweepSettings'},
        'validation_data': {'key': 'validationData', 'type': 'MLTableJobInput'},
        'validation_data_size': {'key': 'validationDataSize', 'type': 'float'},
        'model_settings': {'key': 'modelSettings', 'type': 'ImageModelSettingsObjectDetection'},
        'search_space': {'key': 'searchSpace', 'type': '[ImageModelDistributionSettingsObjectDetection]'},
        'log_verbosity': {'key': 'logVerbosity', 'type': 'str'},
        'target_column_name': {'key': 'targetColumnName', 'type': 'str'},
        'task_type': {'key': 'taskType', 'type': 'str'},
        'training_data': {'key': 'trainingData', 'type': 'MLTableJobInput'},
        'primary_metric': {'key': 'primaryMetric', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        limit_settings: "ImageLimitSettings",
        training_data: "MLTableJobInput",
        sweep_settings: Optional["ImageSweepSettings"] = None,
        validation_data: Optional["MLTableJobInput"] = None,
        validation_data_size: Optional[float] = None,
        model_settings: Optional["ImageModelSettingsObjectDetection"] = None,
        search_space: Optional[List["ImageModelDistributionSettingsObjectDetection"]] = None,
        log_verbosity: Optional[Union[str, "LogVerbosity"]] = None,
        target_column_name: Optional[str] = None,
        primary_metric: Optional[Union[str, "InstanceSegmentationPrimaryMetrics"]] = None,
        **kwargs
    ):
        """
        :keyword limit_settings: Required. [Required] Limit settings for the AutoML job.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
        :keyword sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        :keyword model_settings: Settings used for training the model.
        :paramtype model_settings:
         ~azure.mgmt.machinelearningservices.models.ImageModelSettingsObjectDetection
        :keyword search_space: Search space for sampling different combinations of models and their
         hyperparameters.
        :paramtype search_space:
         list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsObjectDetection]
        :keyword log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
         "Info", "Warning", "Error", "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        :keyword target_column_name: Target column name: This is prediction values column.
         Also known as label column name in context of classification tasks.
        :paramtype target_column_name: str
        :keyword training_data: Required. [Required] Training data input.
        :paramtype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword primary_metric: Primary metric to optimize for this task. Possible values include:
         "MeanAveragePrecision".
        :paramtype primary_metric: str or
         ~azure.mgmt.machinelearningservices.models.InstanceSegmentationPrimaryMetrics
        """
        super(ImageInstanceSegmentation, self).__init__(log_verbosity=log_verbosity, target_column_name=target_column_name, training_data=training_data, limit_settings=limit_settings, sweep_settings=sweep_settings, validation_data=validation_data, validation_data_size=validation_data_size, model_settings=model_settings, search_space=search_space, **kwargs)
        self.limit_settings = limit_settings
        self.sweep_settings = sweep_settings
        self.validation_data = validation_data
        self.validation_data_size = validation_data_size
        self.model_settings = model_settings
        self.search_space = search_space
        self.task_type = 'ImageInstanceSegmentation'  # type: str
        self.primary_metric = primary_metric
        self.log_verbosity = log_verbosity
        self.target_column_name = target_column_name
        self.training_data = training_data


class ImageLimitSettings(msrest.serialization.Model):
    """Limit settings for the AutoML job.

    :ivar max_concurrent_trials: Maximum number of concurrent AutoML iterations.
    :vartype max_concurrent_trials: int
    :ivar max_trials: Maximum number of AutoML iterations.
    :vartype max_trials: int
    :ivar timeout: AutoML job timeout.
    :vartype timeout: ~datetime.timedelta
    """

    _attribute_map = {
        'max_concurrent_trials': {'key': 'maxConcurrentTrials', 'type': 'int'},
        'max_trials': {'key': 'maxTrials', 'type': 'int'},
        'timeout': {'key': 'timeout', 'type': 'duration'},
    }

    def __init__(
        self,
        *,
        max_concurrent_trials: Optional[int] = 1,
        max_trials: Optional[int] = 1,
        timeout: Optional[datetime.timedelta] = "P7D",
        **kwargs
    ):
        """
        :keyword max_concurrent_trials: Maximum number of concurrent AutoML iterations.
        :paramtype max_concurrent_trials: int
        :keyword max_trials: Maximum number of AutoML iterations.
        :paramtype max_trials: int
        :keyword timeout: AutoML job timeout.
        :paramtype timeout: ~datetime.timedelta
        """
        super(ImageLimitSettings, self).__init__(**kwargs)
        self.max_concurrent_trials = max_concurrent_trials
        self.max_trials = max_trials
        self.timeout = timeout


class ImageMetadata(msrest.serialization.Model):
    """Returns metadata about the operating system image for this compute instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar current_image_version: Specifies the current operating system image version this compute
     instance is running on.
    :vartype current_image_version: str
    :ivar latest_image_version: Specifies the latest available operating system image version.
    :vartype latest_image_version: str
    :ivar is_latest_os_image_version: Specifies whether this compute instance is running on the
     latest operating system image.
    :vartype is_latest_os_image_version: bool
    :ivar os_patching_status: Metadata about the os patching.
    :vartype os_patching_status: ~azure.mgmt.machinelearningservices.models.OsPatchingStatus
    """

    _validation = {
        'os_patching_status': {'readonly': True},
    }

    _attribute_map = {
        'current_image_version': {'key': 'currentImageVersion', 'type': 'str'},
        'latest_image_version': {'key': 'latestImageVersion', 'type': 'str'},
        'is_latest_os_image_version': {'key': 'isLatestOsImageVersion', 'type': 'bool'},
        'os_patching_status': {'key': 'osPatchingStatus', 'type': 'OsPatchingStatus'},
    }

    def __init__(
        self,
        *,
        current_image_version: Optional[str] = None,
        latest_image_version: Optional[str] = None,
        is_latest_os_image_version: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword current_image_version: Specifies the current operating system image version this
         compute instance is running on.
        :paramtype current_image_version: str
        :keyword latest_image_version: Specifies the latest available operating system image version.
        :paramtype latest_image_version: str
        :keyword is_latest_os_image_version: Specifies whether this compute instance is running on the
         latest operating system image.
        :paramtype is_latest_os_image_version: bool
        """
        super(ImageMetadata, self).__init__(**kwargs)
        self.current_image_version = current_image_version
        self.latest_image_version = latest_image_version
        self.is_latest_os_image_version = is_latest_os_image_version
        self.os_patching_status = None


class ImageModelDistributionSettings(msrest.serialization.Model):
    """Distribution expressions to sweep over values of model settings.

:code:`<example>
Some examples are:
```
ModelName = "choice('seresnext', 'resnest50')";
LearningRate = "uniform(0.001, 0.01)";
LayersToFreeze = "choice(0, 2)";
```</example>`
All distributions can be specified as distribution_name(min, max) or choice(val1, val2, ..., valn)
where distribution name can be: uniform, quniform, loguniform, etc
For more details on how to compose distribution expressions please check the documentation:
https://docs.microsoft.com/en-us/azure/machine-learning/how-to-tune-hyperparameters
For more information on the available settings please visit the official documentation:
https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.

    :ivar ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
    :vartype ams_gradient: str
    :ivar augmentations: Settings for using Augmentations.
    :vartype augmentations: str
    :ivar beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta1: str
    :ivar beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta2: str
    :ivar distributed: Whether to use distributer training.
    :vartype distributed: str
    :ivar early_stopping: Enable early stopping logic during training.
    :vartype early_stopping: str
    :ivar early_stopping_delay: Minimum number of epochs or validation evaluations to wait before
     primary metric improvement
     is tracked for early stopping. Must be a positive integer.
    :vartype early_stopping_delay: str
    :ivar early_stopping_patience: Minimum number of epochs or validation evaluations with no
     primary metric improvement before
     the run is stopped. Must be a positive integer.
    :vartype early_stopping_patience: str
    :ivar enable_onnx_normalization: Enable normalization when exporting ONNX model.
    :vartype enable_onnx_normalization: str
    :ivar evaluation_frequency: Frequency to evaluate validation dataset to get metric scores. Must
     be a positive integer.
    :vartype evaluation_frequency: str
    :ivar gradient_accumulation_step: Gradient accumulation means running a configured number of
     "GradAccumulationStep" steps without
     updating the model weights while accumulating the gradients of those steps, and then using
     the accumulated gradients to compute the weight updates. Must be a positive integer.
    :vartype gradient_accumulation_step: str
    :ivar layers_to_freeze: Number of layers to freeze for the model. Must be a positive integer.
     For instance, passing 2 as value for 'seresnext' means
     freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
     please
     see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype layers_to_freeze: str
    :ivar learning_rate: Initial learning rate. Must be a float in the range [0, 1].
    :vartype learning_rate: str
    :ivar learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
     'step'.
    :vartype learning_rate_scheduler: str
    :ivar model_name: Name of the model to use for training.
     For more information on the available models please visit the official documentation:
     https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype model_name: str
    :ivar momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
    :vartype momentum: str
    :ivar nesterov: Enable nesterov when optimizer is 'sgd'.
    :vartype nesterov: str
    :ivar number_of_epochs: Number of training epochs. Must be a positive integer.
    :vartype number_of_epochs: str
    :ivar number_of_workers: Number of data loader workers. Must be a non-negative integer.
    :vartype number_of_workers: str
    :ivar optimizer: Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
    :vartype optimizer: str
    :ivar random_seed: Random seed to be used when using deterministic training.
    :vartype random_seed: str
    :ivar step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float in
     the range [0, 1].
    :vartype step_lr_gamma: str
    :ivar step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be a
     positive integer.
    :vartype step_lr_step_size: str
    :ivar training_batch_size: Training batch size. Must be a positive integer.
    :vartype training_batch_size: str
    :ivar validation_batch_size: Validation batch size. Must be a positive integer.
    :vartype validation_batch_size: str
    :ivar warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
     'warmup_cosine'. Must be a float in the range [0, 1].
    :vartype warmup_cosine_lr_cycles: str
    :ivar warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
     'warmup_cosine'. Must be a positive integer.
    :vartype warmup_cosine_lr_warmup_epochs: str
    :ivar weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be
     a float in the range[0, 1].
    :vartype weight_decay: str
    """

    _attribute_map = {
        'ams_gradient': {'key': 'amsGradient', 'type': 'str'},
        'augmentations': {'key': 'augmentations', 'type': 'str'},
        'beta1': {'key': 'beta1', 'type': 'str'},
        'beta2': {'key': 'beta2', 'type': 'str'},
        'distributed': {'key': 'distributed', 'type': 'str'},
        'early_stopping': {'key': 'earlyStopping', 'type': 'str'},
        'early_stopping_delay': {'key': 'earlyStoppingDelay', 'type': 'str'},
        'early_stopping_patience': {'key': 'earlyStoppingPatience', 'type': 'str'},
        'enable_onnx_normalization': {'key': 'enableOnnxNormalization', 'type': 'str'},
        'evaluation_frequency': {'key': 'evaluationFrequency', 'type': 'str'},
        'gradient_accumulation_step': {'key': 'gradientAccumulationStep', 'type': 'str'},
        'layers_to_freeze': {'key': 'layersToFreeze', 'type': 'str'},
        'learning_rate': {'key': 'learningRate', 'type': 'str'},
        'learning_rate_scheduler': {'key': 'learningRateScheduler', 'type': 'str'},
        'model_name': {'key': 'modelName', 'type': 'str'},
        'momentum': {'key': 'momentum', 'type': 'str'},
        'nesterov': {'key': 'nesterov', 'type': 'str'},
        'number_of_epochs': {'key': 'numberOfEpochs', 'type': 'str'},
        'number_of_workers': {'key': 'numberOfWorkers', 'type': 'str'},
        'optimizer': {'key': 'optimizer', 'type': 'str'},
        'random_seed': {'key': 'randomSeed', 'type': 'str'},
        'step_lr_gamma': {'key': 'stepLRGamma', 'type': 'str'},
        'step_lr_step_size': {'key': 'stepLRStepSize', 'type': 'str'},
        'training_batch_size': {'key': 'trainingBatchSize', 'type': 'str'},
        'validation_batch_size': {'key': 'validationBatchSize', 'type': 'str'},
        'warmup_cosine_lr_cycles': {'key': 'warmupCosineLRCycles', 'type': 'str'},
        'warmup_cosine_lr_warmup_epochs': {'key': 'warmupCosineLRWarmupEpochs', 'type': 'str'},
        'weight_decay': {'key': 'weightDecay', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ams_gradient: Optional[str] = None,
        augmentations: Optional[str] = None,
        beta1: Optional[str] = None,
        beta2: Optional[str] = None,
        distributed: Optional[str] = None,
        early_stopping: Optional[str] = None,
        early_stopping_delay: Optional[str] = None,
        early_stopping_patience: Optional[str] = None,
        enable_onnx_normalization: Optional[str] = None,
        evaluation_frequency: Optional[str] = None,
        gradient_accumulation_step: Optional[str] = None,
        layers_to_freeze: Optional[str] = None,
        learning_rate: Optional[str] = None,
        learning_rate_scheduler: Optional[str] = None,
        model_name: Optional[str] = None,
        momentum: Optional[str] = None,
        nesterov: Optional[str] = None,
        number_of_epochs: Optional[str] = None,
        number_of_workers: Optional[str] = None,
        optimizer: Optional[str] = None,
        random_seed: Optional[str] = None,
        step_lr_gamma: Optional[str] = None,
        step_lr_step_size: Optional[str] = None,
        training_batch_size: Optional[str] = None,
        validation_batch_size: Optional[str] = None,
        warmup_cosine_lr_cycles: Optional[str] = None,
        warmup_cosine_lr_warmup_epochs: Optional[str] = None,
        weight_decay: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        :paramtype ams_gradient: str
        :keyword augmentations: Settings for using Augmentations.
        :paramtype augmentations: str
        :keyword beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta1: str
        :keyword beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta2: str
        :keyword distributed: Whether to use distributer training.
        :paramtype distributed: str
        :keyword early_stopping: Enable early stopping logic during training.
        :paramtype early_stopping: str
        :keyword early_stopping_delay: Minimum number of epochs or validation evaluations to wait
         before primary metric improvement
         is tracked for early stopping. Must be a positive integer.
        :paramtype early_stopping_delay: str
        :keyword early_stopping_patience: Minimum number of epochs or validation evaluations with no
         primary metric improvement before
         the run is stopped. Must be a positive integer.
        :paramtype early_stopping_patience: str
        :keyword enable_onnx_normalization: Enable normalization when exporting ONNX model.
        :paramtype enable_onnx_normalization: str
        :keyword evaluation_frequency: Frequency to evaluate validation dataset to get metric scores.
         Must be a positive integer.
        :paramtype evaluation_frequency: str
        :keyword gradient_accumulation_step: Gradient accumulation means running a configured number of
         "GradAccumulationStep" steps without
         updating the model weights while accumulating the gradients of those steps, and then using
         the accumulated gradients to compute the weight updates. Must be a positive integer.
        :paramtype gradient_accumulation_step: str
        :keyword layers_to_freeze: Number of layers to freeze for the model. Must be a positive
         integer.
         For instance, passing 2 as value for 'seresnext' means
         freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
         please
         see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype layers_to_freeze: str
        :keyword learning_rate: Initial learning rate. Must be a float in the range [0, 1].
        :paramtype learning_rate: str
        :keyword learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
         'step'.
        :paramtype learning_rate_scheduler: str
        :keyword model_name: Name of the model to use for training.
         For more information on the available models please visit the official documentation:
         https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype model_name: str
        :keyword momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0,
         1].
        :paramtype momentum: str
        :keyword nesterov: Enable nesterov when optimizer is 'sgd'.
        :paramtype nesterov: str
        :keyword number_of_epochs: Number of training epochs. Must be a positive integer.
        :paramtype number_of_epochs: str
        :keyword number_of_workers: Number of data loader workers. Must be a non-negative integer.
        :paramtype number_of_workers: str
        :keyword optimizer: Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
        :paramtype optimizer: str
        :keyword random_seed: Random seed to be used when using deterministic training.
        :paramtype random_seed: str
        :keyword step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float
         in the range [0, 1].
        :paramtype step_lr_gamma: str
        :keyword step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be
         a positive integer.
        :paramtype step_lr_step_size: str
        :keyword training_batch_size: Training batch size. Must be a positive integer.
        :paramtype training_batch_size: str
        :keyword validation_batch_size: Validation batch size. Must be a positive integer.
        :paramtype validation_batch_size: str
        :keyword warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
         'warmup_cosine'. Must be a float in the range [0, 1].
        :paramtype warmup_cosine_lr_cycles: str
        :keyword warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
         'warmup_cosine'. Must be a positive integer.
        :paramtype warmup_cosine_lr_warmup_epochs: str
        :keyword weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must
         be a float in the range[0, 1].
        :paramtype weight_decay: str
        """
        super(ImageModelDistributionSettings, self).__init__(**kwargs)
        self.ams_gradient = ams_gradient
        self.augmentations = augmentations
        self.beta1 = beta1
        self.beta2 = beta2
        self.distributed = distributed
        self.early_stopping = early_stopping
        self.early_stopping_delay = early_stopping_delay
        self.early_stopping_patience = early_stopping_patience
        self.enable_onnx_normalization = enable_onnx_normalization
        self.evaluation_frequency = evaluation_frequency
        self.gradient_accumulation_step = gradient_accumulation_step
        self.layers_to_freeze = layers_to_freeze
        self.learning_rate = learning_rate
        self.learning_rate_scheduler = learning_rate_scheduler
        self.model_name = model_name
        self.momentum = momentum
        self.nesterov = nesterov
        self.number_of_epochs = number_of_epochs
        self.number_of_workers = number_of_workers
        self.optimizer = optimizer
        self.random_seed = random_seed
        self.step_lr_gamma = step_lr_gamma
        self.step_lr_step_size = step_lr_step_size
        self.training_batch_size = training_batch_size
        self.validation_batch_size = validation_batch_size
        self.warmup_cosine_lr_cycles = warmup_cosine_lr_cycles
        self.warmup_cosine_lr_warmup_epochs = warmup_cosine_lr_warmup_epochs
        self.weight_decay = weight_decay


class ImageModelDistributionSettingsClassification(ImageModelDistributionSettings):
    """Distribution expressions to sweep over values of model settings.

:code:`<example>
Some examples are:
```
ModelName = "choice('seresnext', 'resnest50')";
LearningRate = "uniform(0.001, 0.01)";
LayersToFreeze = "choice(0, 2)";
```</example>`
For more details on how to compose distribution expressions please check the documentation:
https://docs.microsoft.com/en-us/azure/machine-learning/how-to-tune-hyperparameters
For more information on the available settings please visit the official documentation:
https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.

    :ivar ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
    :vartype ams_gradient: str
    :ivar augmentations: Settings for using Augmentations.
    :vartype augmentations: str
    :ivar beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta1: str
    :ivar beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta2: str
    :ivar distributed: Whether to use distributer training.
    :vartype distributed: str
    :ivar early_stopping: Enable early stopping logic during training.
    :vartype early_stopping: str
    :ivar early_stopping_delay: Minimum number of epochs or validation evaluations to wait before
     primary metric improvement
     is tracked for early stopping. Must be a positive integer.
    :vartype early_stopping_delay: str
    :ivar early_stopping_patience: Minimum number of epochs or validation evaluations with no
     primary metric improvement before
     the run is stopped. Must be a positive integer.
    :vartype early_stopping_patience: str
    :ivar enable_onnx_normalization: Enable normalization when exporting ONNX model.
    :vartype enable_onnx_normalization: str
    :ivar evaluation_frequency: Frequency to evaluate validation dataset to get metric scores. Must
     be a positive integer.
    :vartype evaluation_frequency: str
    :ivar gradient_accumulation_step: Gradient accumulation means running a configured number of
     "GradAccumulationStep" steps without
     updating the model weights while accumulating the gradients of those steps, and then using
     the accumulated gradients to compute the weight updates. Must be a positive integer.
    :vartype gradient_accumulation_step: str
    :ivar layers_to_freeze: Number of layers to freeze for the model. Must be a positive integer.
     For instance, passing 2 as value for 'seresnext' means
     freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
     please
     see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype layers_to_freeze: str
    :ivar learning_rate: Initial learning rate. Must be a float in the range [0, 1].
    :vartype learning_rate: str
    :ivar learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
     'step'.
    :vartype learning_rate_scheduler: str
    :ivar model_name: Name of the model to use for training.
     For more information on the available models please visit the official documentation:
     https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype model_name: str
    :ivar momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
    :vartype momentum: str
    :ivar nesterov: Enable nesterov when optimizer is 'sgd'.
    :vartype nesterov: str
    :ivar number_of_epochs: Number of training epochs. Must be a positive integer.
    :vartype number_of_epochs: str
    :ivar number_of_workers: Number of data loader workers. Must be a non-negative integer.
    :vartype number_of_workers: str
    :ivar optimizer: Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
    :vartype optimizer: str
    :ivar random_seed: Random seed to be used when using deterministic training.
    :vartype random_seed: str
    :ivar step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float in
     the range [0, 1].
    :vartype step_lr_gamma: str
    :ivar step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be a
     positive integer.
    :vartype step_lr_step_size: str
    :ivar training_batch_size: Training batch size. Must be a positive integer.
    :vartype training_batch_size: str
    :ivar validation_batch_size: Validation batch size. Must be a positive integer.
    :vartype validation_batch_size: str
    :ivar warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
     'warmup_cosine'. Must be a float in the range [0, 1].
    :vartype warmup_cosine_lr_cycles: str
    :ivar warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
     'warmup_cosine'. Must be a positive integer.
    :vartype warmup_cosine_lr_warmup_epochs: str
    :ivar weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be
     a float in the range[0, 1].
    :vartype weight_decay: str
    :ivar training_crop_size: Image crop size that is input to the neural network for the training
     dataset. Must be a positive integer.
    :vartype training_crop_size: str
    :ivar validation_crop_size: Image crop size that is input to the neural network for the
     validation dataset. Must be a positive integer.
    :vartype validation_crop_size: str
    :ivar validation_resize_size: Image size to which to resize before cropping for validation
     dataset. Must be a positive integer.
    :vartype validation_resize_size: str
    :ivar weighted_loss: Weighted loss. The accepted values are 0 for no weighted loss.
     1 for weighted loss with sqrt.(class_weights). 2 for weighted loss with class_weights. Must be
     0 or 1 or 2.
    :vartype weighted_loss: str
    """

    _attribute_map = {
        'ams_gradient': {'key': 'amsGradient', 'type': 'str'},
        'augmentations': {'key': 'augmentations', 'type': 'str'},
        'beta1': {'key': 'beta1', 'type': 'str'},
        'beta2': {'key': 'beta2', 'type': 'str'},
        'distributed': {'key': 'distributed', 'type': 'str'},
        'early_stopping': {'key': 'earlyStopping', 'type': 'str'},
        'early_stopping_delay': {'key': 'earlyStoppingDelay', 'type': 'str'},
        'early_stopping_patience': {'key': 'earlyStoppingPatience', 'type': 'str'},
        'enable_onnx_normalization': {'key': 'enableOnnxNormalization', 'type': 'str'},
        'evaluation_frequency': {'key': 'evaluationFrequency', 'type': 'str'},
        'gradient_accumulation_step': {'key': 'gradientAccumulationStep', 'type': 'str'},
        'layers_to_freeze': {'key': 'layersToFreeze', 'type': 'str'},
        'learning_rate': {'key': 'learningRate', 'type': 'str'},
        'learning_rate_scheduler': {'key': 'learningRateScheduler', 'type': 'str'},
        'model_name': {'key': 'modelName', 'type': 'str'},
        'momentum': {'key': 'momentum', 'type': 'str'},
        'nesterov': {'key': 'nesterov', 'type': 'str'},
        'number_of_epochs': {'key': 'numberOfEpochs', 'type': 'str'},
        'number_of_workers': {'key': 'numberOfWorkers', 'type': 'str'},
        'optimizer': {'key': 'optimizer', 'type': 'str'},
        'random_seed': {'key': 'randomSeed', 'type': 'str'},
        'step_lr_gamma': {'key': 'stepLRGamma', 'type': 'str'},
        'step_lr_step_size': {'key': 'stepLRStepSize', 'type': 'str'},
        'training_batch_size': {'key': 'trainingBatchSize', 'type': 'str'},
        'validation_batch_size': {'key': 'validationBatchSize', 'type': 'str'},
        'warmup_cosine_lr_cycles': {'key': 'warmupCosineLRCycles', 'type': 'str'},
        'warmup_cosine_lr_warmup_epochs': {'key': 'warmupCosineLRWarmupEpochs', 'type': 'str'},
        'weight_decay': {'key': 'weightDecay', 'type': 'str'},
        'training_crop_size': {'key': 'trainingCropSize', 'type': 'str'},
        'validation_crop_size': {'key': 'validationCropSize', 'type': 'str'},
        'validation_resize_size': {'key': 'validationResizeSize', 'type': 'str'},
        'weighted_loss': {'key': 'weightedLoss', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ams_gradient: Optional[str] = None,
        augmentations: Optional[str] = None,
        beta1: Optional[str] = None,
        beta2: Optional[str] = None,
        distributed: Optional[str] = None,
        early_stopping: Optional[str] = None,
        early_stopping_delay: Optional[str] = None,
        early_stopping_patience: Optional[str] = None,
        enable_onnx_normalization: Optional[str] = None,
        evaluation_frequency: Optional[str] = None,
        gradient_accumulation_step: Optional[str] = None,
        layers_to_freeze: Optional[str] = None,
        learning_rate: Optional[str] = None,
        learning_rate_scheduler: Optional[str] = None,
        model_name: Optional[str] = None,
        momentum: Optional[str] = None,
        nesterov: Optional[str] = None,
        number_of_epochs: Optional[str] = None,
        number_of_workers: Optional[str] = None,
        optimizer: Optional[str] = None,
        random_seed: Optional[str] = None,
        step_lr_gamma: Optional[str] = None,
        step_lr_step_size: Optional[str] = None,
        training_batch_size: Optional[str] = None,
        validation_batch_size: Optional[str] = None,
        warmup_cosine_lr_cycles: Optional[str] = None,
        warmup_cosine_lr_warmup_epochs: Optional[str] = None,
        weight_decay: Optional[str] = None,
        training_crop_size: Optional[str] = None,
        validation_crop_size: Optional[str] = None,
        validation_resize_size: Optional[str] = None,
        weighted_loss: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        :paramtype ams_gradient: str
        :keyword augmentations: Settings for using Augmentations.
        :paramtype augmentations: str
        :keyword beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta1: str
        :keyword beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta2: str
        :keyword distributed: Whether to use distributer training.
        :paramtype distributed: str
        :keyword early_stopping: Enable early stopping logic during training.
        :paramtype early_stopping: str
        :keyword early_stopping_delay: Minimum number of epochs or validation evaluations to wait
         before primary metric improvement
         is tracked for early stopping. Must be a positive integer.
        :paramtype early_stopping_delay: str
        :keyword early_stopping_patience: Minimum number of epochs or validation evaluations with no
         primary metric improvement before
         the run is stopped. Must be a positive integer.
        :paramtype early_stopping_patience: str
        :keyword enable_onnx_normalization: Enable normalization when exporting ONNX model.
        :paramtype enable_onnx_normalization: str
        :keyword evaluation_frequency: Frequency to evaluate validation dataset to get metric scores.
         Must be a positive integer.
        :paramtype evaluation_frequency: str
        :keyword gradient_accumulation_step: Gradient accumulation means running a configured number of
         "GradAccumulationStep" steps without
         updating the model weights while accumulating the gradients of those steps, and then using
         the accumulated gradients to compute the weight updates. Must be a positive integer.
        :paramtype gradient_accumulation_step: str
        :keyword layers_to_freeze: Number of layers to freeze for the model. Must be a positive
         integer.
         For instance, passing 2 as value for 'seresnext' means
         freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
         please
         see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype layers_to_freeze: str
        :keyword learning_rate: Initial learning rate. Must be a float in the range [0, 1].
        :paramtype learning_rate: str
        :keyword learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
         'step'.
        :paramtype learning_rate_scheduler: str
        :keyword model_name: Name of the model to use for training.
         For more information on the available models please visit the official documentation:
         https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype model_name: str
        :keyword momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0,
         1].
        :paramtype momentum: str
        :keyword nesterov: Enable nesterov when optimizer is 'sgd'.
        :paramtype nesterov: str
        :keyword number_of_epochs: Number of training epochs. Must be a positive integer.
        :paramtype number_of_epochs: str
        :keyword number_of_workers: Number of data loader workers. Must be a non-negative integer.
        :paramtype number_of_workers: str
        :keyword optimizer: Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
        :paramtype optimizer: str
        :keyword random_seed: Random seed to be used when using deterministic training.
        :paramtype random_seed: str
        :keyword step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float
         in the range [0, 1].
        :paramtype step_lr_gamma: str
        :keyword step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be
         a positive integer.
        :paramtype step_lr_step_size: str
        :keyword training_batch_size: Training batch size. Must be a positive integer.
        :paramtype training_batch_size: str
        :keyword validation_batch_size: Validation batch size. Must be a positive integer.
        :paramtype validation_batch_size: str
        :keyword warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
         'warmup_cosine'. Must be a float in the range [0, 1].
        :paramtype warmup_cosine_lr_cycles: str
        :keyword warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
         'warmup_cosine'. Must be a positive integer.
        :paramtype warmup_cosine_lr_warmup_epochs: str
        :keyword weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must
         be a float in the range[0, 1].
        :paramtype weight_decay: str
        :keyword training_crop_size: Image crop size that is input to the neural network for the
         training dataset. Must be a positive integer.
        :paramtype training_crop_size: str
        :keyword validation_crop_size: Image crop size that is input to the neural network for the
         validation dataset. Must be a positive integer.
        :paramtype validation_crop_size: str
        :keyword validation_resize_size: Image size to which to resize before cropping for validation
         dataset. Must be a positive integer.
        :paramtype validation_resize_size: str
        :keyword weighted_loss: Weighted loss. The accepted values are 0 for no weighted loss.
         1 for weighted loss with sqrt.(class_weights). 2 for weighted loss with class_weights. Must be
         0 or 1 or 2.
        :paramtype weighted_loss: str
        """
        super(ImageModelDistributionSettingsClassification, self).__init__(ams_gradient=ams_gradient, augmentations=augmentations, beta1=beta1, beta2=beta2, distributed=distributed, early_stopping=early_stopping, early_stopping_delay=early_stopping_delay, early_stopping_patience=early_stopping_patience, enable_onnx_normalization=enable_onnx_normalization, evaluation_frequency=evaluation_frequency, gradient_accumulation_step=gradient_accumulation_step, layers_to_freeze=layers_to_freeze, learning_rate=learning_rate, learning_rate_scheduler=learning_rate_scheduler, model_name=model_name, momentum=momentum, nesterov=nesterov, number_of_epochs=number_of_epochs, number_of_workers=number_of_workers, optimizer=optimizer, random_seed=random_seed, step_lr_gamma=step_lr_gamma, step_lr_step_size=step_lr_step_size, training_batch_size=training_batch_size, validation_batch_size=validation_batch_size, warmup_cosine_lr_cycles=warmup_cosine_lr_cycles, warmup_cosine_lr_warmup_epochs=warmup_cosine_lr_warmup_epochs, weight_decay=weight_decay, **kwargs)
        self.training_crop_size = training_crop_size
        self.validation_crop_size = validation_crop_size
        self.validation_resize_size = validation_resize_size
        self.weighted_loss = weighted_loss


class ImageModelDistributionSettingsObjectDetection(ImageModelDistributionSettings):
    """Distribution expressions to sweep over values of model settings.

:code:`<example>
Some examples are:
```
ModelName = "choice('seresnext', 'resnest50')";
LearningRate = "uniform(0.001, 0.01)";
LayersToFreeze = "choice(0, 2)";
```</example>`
For more details on how to compose distribution expressions please check the documentation:
https://docs.microsoft.com/en-us/azure/machine-learning/how-to-tune-hyperparameters
For more information on the available settings please visit the official documentation:
https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.

    :ivar ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
    :vartype ams_gradient: str
    :ivar augmentations: Settings for using Augmentations.
    :vartype augmentations: str
    :ivar beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta1: str
    :ivar beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta2: str
    :ivar distributed: Whether to use distributer training.
    :vartype distributed: str
    :ivar early_stopping: Enable early stopping logic during training.
    :vartype early_stopping: str
    :ivar early_stopping_delay: Minimum number of epochs or validation evaluations to wait before
     primary metric improvement
     is tracked for early stopping. Must be a positive integer.
    :vartype early_stopping_delay: str
    :ivar early_stopping_patience: Minimum number of epochs or validation evaluations with no
     primary metric improvement before
     the run is stopped. Must be a positive integer.
    :vartype early_stopping_patience: str
    :ivar enable_onnx_normalization: Enable normalization when exporting ONNX model.
    :vartype enable_onnx_normalization: str
    :ivar evaluation_frequency: Frequency to evaluate validation dataset to get metric scores. Must
     be a positive integer.
    :vartype evaluation_frequency: str
    :ivar gradient_accumulation_step: Gradient accumulation means running a configured number of
     "GradAccumulationStep" steps without
     updating the model weights while accumulating the gradients of those steps, and then using
     the accumulated gradients to compute the weight updates. Must be a positive integer.
    :vartype gradient_accumulation_step: str
    :ivar layers_to_freeze: Number of layers to freeze for the model. Must be a positive integer.
     For instance, passing 2 as value for 'seresnext' means
     freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
     please
     see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype layers_to_freeze: str
    :ivar learning_rate: Initial learning rate. Must be a float in the range [0, 1].
    :vartype learning_rate: str
    :ivar learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
     'step'.
    :vartype learning_rate_scheduler: str
    :ivar model_name: Name of the model to use for training.
     For more information on the available models please visit the official documentation:
     https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype model_name: str
    :ivar momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
    :vartype momentum: str
    :ivar nesterov: Enable nesterov when optimizer is 'sgd'.
    :vartype nesterov: str
    :ivar number_of_epochs: Number of training epochs. Must be a positive integer.
    :vartype number_of_epochs: str
    :ivar number_of_workers: Number of data loader workers. Must be a non-negative integer.
    :vartype number_of_workers: str
    :ivar optimizer: Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
    :vartype optimizer: str
    :ivar random_seed: Random seed to be used when using deterministic training.
    :vartype random_seed: str
    :ivar step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float in
     the range [0, 1].
    :vartype step_lr_gamma: str
    :ivar step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be a
     positive integer.
    :vartype step_lr_step_size: str
    :ivar training_batch_size: Training batch size. Must be a positive integer.
    :vartype training_batch_size: str
    :ivar validation_batch_size: Validation batch size. Must be a positive integer.
    :vartype validation_batch_size: str
    :ivar warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
     'warmup_cosine'. Must be a float in the range [0, 1].
    :vartype warmup_cosine_lr_cycles: str
    :ivar warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
     'warmup_cosine'. Must be a positive integer.
    :vartype warmup_cosine_lr_warmup_epochs: str
    :ivar weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be
     a float in the range[0, 1].
    :vartype weight_decay: str
    :ivar box_detections_per_image: Maximum number of detections per image, for all classes. Must
     be a positive integer.
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype box_detections_per_image: str
    :ivar box_score_threshold: During inference, only return proposals with a classification score
     greater than
     BoxScoreThreshold. Must be a float in the range[0, 1].
    :vartype box_score_threshold: str
    :ivar image_size: Image size for train and validation. Must be a positive integer.
     Note: The training run may get into CUDA OOM if the size is too big.
     Note: This settings is only supported for the 'yolov5' algorithm.
    :vartype image_size: str
    :ivar max_size: Maximum size of the image to be rescaled before feeding it to the backbone.
     Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype max_size: str
    :ivar min_size: Minimum size of the image to be rescaled before feeding it to the backbone.
     Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype min_size: str
    :ivar model_size: Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
     Note: training run may get into CUDA OOM if the model size is too big.
     Note: This settings is only supported for the 'yolov5' algorithm.
    :vartype model_size: str
    :ivar multi_scale: Enable multi-scale image by varying image size by +/- 50%.
     Note: training run may get into CUDA OOM if no sufficient GPU memory.
     Note: This settings is only supported for the 'yolov5' algorithm.
    :vartype multi_scale: str
    :ivar nms_iou_threshold: IOU threshold used during inference in NMS post processing. Must be
     float in the range [0, 1].
    :vartype nms_iou_threshold: str
    :ivar tile_grid_size: The grid size to use for tiling each image. Note: TileGridSize must not
     be
     None to enable small object detection logic. A string containing two integers in mxn format.
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype tile_grid_size: str
    :ivar tile_overlap_ratio: Overlap ratio between adjacent tiles in each dimension. Must be float
     in the range [0, 1).
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype tile_overlap_ratio: str
    :ivar tile_predictions_nms_threshold: The IOU threshold to use to perform NMS while merging
     predictions from tiles and image.
     Used in validation/ inference. Must be float in the range [0, 1].
     Note: This settings is not supported for the 'yolov5' algorithm.
     NMS: Non-maximum suppression.
    :vartype tile_predictions_nms_threshold: str
    :ivar validation_iou_threshold: IOU threshold to use when computing validation metric. Must be
     float in the range [0, 1].
    :vartype validation_iou_threshold: str
    :ivar validation_metric_type: Metric computation method to use for validation metrics. Must be
     'none', 'coco', 'voc', or 'coco_voc'.
    :vartype validation_metric_type: str
    """

    _attribute_map = {
        'ams_gradient': {'key': 'amsGradient', 'type': 'str'},
        'augmentations': {'key': 'augmentations', 'type': 'str'},
        'beta1': {'key': 'beta1', 'type': 'str'},
        'beta2': {'key': 'beta2', 'type': 'str'},
        'distributed': {'key': 'distributed', 'type': 'str'},
        'early_stopping': {'key': 'earlyStopping', 'type': 'str'},
        'early_stopping_delay': {'key': 'earlyStoppingDelay', 'type': 'str'},
        'early_stopping_patience': {'key': 'earlyStoppingPatience', 'type': 'str'},
        'enable_onnx_normalization': {'key': 'enableOnnxNormalization', 'type': 'str'},
        'evaluation_frequency': {'key': 'evaluationFrequency', 'type': 'str'},
        'gradient_accumulation_step': {'key': 'gradientAccumulationStep', 'type': 'str'},
        'layers_to_freeze': {'key': 'layersToFreeze', 'type': 'str'},
        'learning_rate': {'key': 'learningRate', 'type': 'str'},
        'learning_rate_scheduler': {'key': 'learningRateScheduler', 'type': 'str'},
        'model_name': {'key': 'modelName', 'type': 'str'},
        'momentum': {'key': 'momentum', 'type': 'str'},
        'nesterov': {'key': 'nesterov', 'type': 'str'},
        'number_of_epochs': {'key': 'numberOfEpochs', 'type': 'str'},
        'number_of_workers': {'key': 'numberOfWorkers', 'type': 'str'},
        'optimizer': {'key': 'optimizer', 'type': 'str'},
        'random_seed': {'key': 'randomSeed', 'type': 'str'},
        'step_lr_gamma': {'key': 'stepLRGamma', 'type': 'str'},
        'step_lr_step_size': {'key': 'stepLRStepSize', 'type': 'str'},
        'training_batch_size': {'key': 'trainingBatchSize', 'type': 'str'},
        'validation_batch_size': {'key': 'validationBatchSize', 'type': 'str'},
        'warmup_cosine_lr_cycles': {'key': 'warmupCosineLRCycles', 'type': 'str'},
        'warmup_cosine_lr_warmup_epochs': {'key': 'warmupCosineLRWarmupEpochs', 'type': 'str'},
        'weight_decay': {'key': 'weightDecay', 'type': 'str'},
        'box_detections_per_image': {'key': 'boxDetectionsPerImage', 'type': 'str'},
        'box_score_threshold': {'key': 'boxScoreThreshold', 'type': 'str'},
        'image_size': {'key': 'imageSize', 'type': 'str'},
        'max_size': {'key': 'maxSize', 'type': 'str'},
        'min_size': {'key': 'minSize', 'type': 'str'},
        'model_size': {'key': 'modelSize', 'type': 'str'},
        'multi_scale': {'key': 'multiScale', 'type': 'str'},
        'nms_iou_threshold': {'key': 'nmsIouThreshold', 'type': 'str'},
        'tile_grid_size': {'key': 'tileGridSize', 'type': 'str'},
        'tile_overlap_ratio': {'key': 'tileOverlapRatio', 'type': 'str'},
        'tile_predictions_nms_threshold': {'key': 'tilePredictionsNmsThreshold', 'type': 'str'},
        'validation_iou_threshold': {'key': 'validationIouThreshold', 'type': 'str'},
        'validation_metric_type': {'key': 'validationMetricType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ams_gradient: Optional[str] = None,
        augmentations: Optional[str] = None,
        beta1: Optional[str] = None,
        beta2: Optional[str] = None,
        distributed: Optional[str] = None,
        early_stopping: Optional[str] = None,
        early_stopping_delay: Optional[str] = None,
        early_stopping_patience: Optional[str] = None,
        enable_onnx_normalization: Optional[str] = None,
        evaluation_frequency: Optional[str] = None,
        gradient_accumulation_step: Optional[str] = None,
        layers_to_freeze: Optional[str] = None,
        learning_rate: Optional[str] = None,
        learning_rate_scheduler: Optional[str] = None,
        model_name: Optional[str] = None,
        momentum: Optional[str] = None,
        nesterov: Optional[str] = None,
        number_of_epochs: Optional[str] = None,
        number_of_workers: Optional[str] = None,
        optimizer: Optional[str] = None,
        random_seed: Optional[str] = None,
        step_lr_gamma: Optional[str] = None,
        step_lr_step_size: Optional[str] = None,
        training_batch_size: Optional[str] = None,
        validation_batch_size: Optional[str] = None,
        warmup_cosine_lr_cycles: Optional[str] = None,
        warmup_cosine_lr_warmup_epochs: Optional[str] = None,
        weight_decay: Optional[str] = None,
        box_detections_per_image: Optional[str] = None,
        box_score_threshold: Optional[str] = None,
        image_size: Optional[str] = None,
        max_size: Optional[str] = None,
        min_size: Optional[str] = None,
        model_size: Optional[str] = None,
        multi_scale: Optional[str] = None,
        nms_iou_threshold: Optional[str] = None,
        tile_grid_size: Optional[str] = None,
        tile_overlap_ratio: Optional[str] = None,
        tile_predictions_nms_threshold: Optional[str] = None,
        validation_iou_threshold: Optional[str] = None,
        validation_metric_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        :paramtype ams_gradient: str
        :keyword augmentations: Settings for using Augmentations.
        :paramtype augmentations: str
        :keyword beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta1: str
        :keyword beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta2: str
        :keyword distributed: Whether to use distributer training.
        :paramtype distributed: str
        :keyword early_stopping: Enable early stopping logic during training.
        :paramtype early_stopping: str
        :keyword early_stopping_delay: Minimum number of epochs or validation evaluations to wait
         before primary metric improvement
         is tracked for early stopping. Must be a positive integer.
        :paramtype early_stopping_delay: str
        :keyword early_stopping_patience: Minimum number of epochs or validation evaluations with no
         primary metric improvement before
         the run is stopped. Must be a positive integer.
        :paramtype early_stopping_patience: str
        :keyword enable_onnx_normalization: Enable normalization when exporting ONNX model.
        :paramtype enable_onnx_normalization: str
        :keyword evaluation_frequency: Frequency to evaluate validation dataset to get metric scores.
         Must be a positive integer.
        :paramtype evaluation_frequency: str
        :keyword gradient_accumulation_step: Gradient accumulation means running a configured number of
         "GradAccumulationStep" steps without
         updating the model weights while accumulating the gradients of those steps, and then using
         the accumulated gradients to compute the weight updates. Must be a positive integer.
        :paramtype gradient_accumulation_step: str
        :keyword layers_to_freeze: Number of layers to freeze for the model. Must be a positive
         integer.
         For instance, passing 2 as value for 'seresnext' means
         freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
         please
         see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype layers_to_freeze: str
        :keyword learning_rate: Initial learning rate. Must be a float in the range [0, 1].
        :paramtype learning_rate: str
        :keyword learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
         'step'.
        :paramtype learning_rate_scheduler: str
        :keyword model_name: Name of the model to use for training.
         For more information on the available models please visit the official documentation:
         https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype model_name: str
        :keyword momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0,
         1].
        :paramtype momentum: str
        :keyword nesterov: Enable nesterov when optimizer is 'sgd'.
        :paramtype nesterov: str
        :keyword number_of_epochs: Number of training epochs. Must be a positive integer.
        :paramtype number_of_epochs: str
        :keyword number_of_workers: Number of data loader workers. Must be a non-negative integer.
        :paramtype number_of_workers: str
        :keyword optimizer: Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
        :paramtype optimizer: str
        :keyword random_seed: Random seed to be used when using deterministic training.
        :paramtype random_seed: str
        :keyword step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float
         in the range [0, 1].
        :paramtype step_lr_gamma: str
        :keyword step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be
         a positive integer.
        :paramtype step_lr_step_size: str
        :keyword training_batch_size: Training batch size. Must be a positive integer.
        :paramtype training_batch_size: str
        :keyword validation_batch_size: Validation batch size. Must be a positive integer.
        :paramtype validation_batch_size: str
        :keyword warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
         'warmup_cosine'. Must be a float in the range [0, 1].
        :paramtype warmup_cosine_lr_cycles: str
        :keyword warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
         'warmup_cosine'. Must be a positive integer.
        :paramtype warmup_cosine_lr_warmup_epochs: str
        :keyword weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must
         be a float in the range[0, 1].
        :paramtype weight_decay: str
        :keyword box_detections_per_image: Maximum number of detections per image, for all classes.
         Must be a positive integer.
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype box_detections_per_image: str
        :keyword box_score_threshold: During inference, only return proposals with a classification
         score greater than
         BoxScoreThreshold. Must be a float in the range[0, 1].
        :paramtype box_score_threshold: str
        :keyword image_size: Image size for train and validation. Must be a positive integer.
         Note: The training run may get into CUDA OOM if the size is too big.
         Note: This settings is only supported for the 'yolov5' algorithm.
        :paramtype image_size: str
        :keyword max_size: Maximum size of the image to be rescaled before feeding it to the backbone.
         Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype max_size: str
        :keyword min_size: Minimum size of the image to be rescaled before feeding it to the backbone.
         Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype min_size: str
        :keyword model_size: Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
         Note: training run may get into CUDA OOM if the model size is too big.
         Note: This settings is only supported for the 'yolov5' algorithm.
        :paramtype model_size: str
        :keyword multi_scale: Enable multi-scale image by varying image size by +/- 50%.
         Note: training run may get into CUDA OOM if no sufficient GPU memory.
         Note: This settings is only supported for the 'yolov5' algorithm.
        :paramtype multi_scale: str
        :keyword nms_iou_threshold: IOU threshold used during inference in NMS post processing. Must be
         float in the range [0, 1].
        :paramtype nms_iou_threshold: str
        :keyword tile_grid_size: The grid size to use for tiling each image. Note: TileGridSize must
         not be
         None to enable small object detection logic. A string containing two integers in mxn format.
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype tile_grid_size: str
        :keyword tile_overlap_ratio: Overlap ratio between adjacent tiles in each dimension. Must be
         float in the range [0, 1).
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype tile_overlap_ratio: str
        :keyword tile_predictions_nms_threshold: The IOU threshold to use to perform NMS while merging
         predictions from tiles and image.
         Used in validation/ inference. Must be float in the range [0, 1].
         Note: This settings is not supported for the 'yolov5' algorithm.
         NMS: Non-maximum suppression.
        :paramtype tile_predictions_nms_threshold: str
        :keyword validation_iou_threshold: IOU threshold to use when computing validation metric. Must
         be float in the range [0, 1].
        :paramtype validation_iou_threshold: str
        :keyword validation_metric_type: Metric computation method to use for validation metrics. Must
         be 'none', 'coco', 'voc', or 'coco_voc'.
        :paramtype validation_metric_type: str
        """
        super(ImageModelDistributionSettingsObjectDetection, self).__init__(ams_gradient=ams_gradient, augmentations=augmentations, beta1=beta1, beta2=beta2, distributed=distributed, early_stopping=early_stopping, early_stopping_delay=early_stopping_delay, early_stopping_patience=early_stopping_patience, enable_onnx_normalization=enable_onnx_normalization, evaluation_frequency=evaluation_frequency, gradient_accumulation_step=gradient_accumulation_step, layers_to_freeze=layers_to_freeze, learning_rate=learning_rate, learning_rate_scheduler=learning_rate_scheduler, model_name=model_name, momentum=momentum, nesterov=nesterov, number_of_epochs=number_of_epochs, number_of_workers=number_of_workers, optimizer=optimizer, random_seed=random_seed, step_lr_gamma=step_lr_gamma, step_lr_step_size=step_lr_step_size, training_batch_size=training_batch_size, validation_batch_size=validation_batch_size, warmup_cosine_lr_cycles=warmup_cosine_lr_cycles, warmup_cosine_lr_warmup_epochs=warmup_cosine_lr_warmup_epochs, weight_decay=weight_decay, **kwargs)
        self.box_detections_per_image = box_detections_per_image
        self.box_score_threshold = box_score_threshold
        self.image_size = image_size
        self.max_size = max_size
        self.min_size = min_size
        self.model_size = model_size
        self.multi_scale = multi_scale
        self.nms_iou_threshold = nms_iou_threshold
        self.tile_grid_size = tile_grid_size
        self.tile_overlap_ratio = tile_overlap_ratio
        self.tile_predictions_nms_threshold = tile_predictions_nms_threshold
        self.validation_iou_threshold = validation_iou_threshold
        self.validation_metric_type = validation_metric_type


class ImageModelSettings(msrest.serialization.Model):
    """Settings used for training the model.
For more information on the available settings please visit the official documentation:
https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.

    :ivar advanced_settings: Settings for advanced scenarios.
    :vartype advanced_settings: str
    :ivar ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
    :vartype ams_gradient: bool
    :ivar augmentations: Settings for using Augmentations.
    :vartype augmentations: str
    :ivar beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta1: float
    :ivar beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta2: float
    :ivar checkpoint_frequency: Frequency to store model checkpoints. Must be a positive integer.
    :vartype checkpoint_frequency: int
    :ivar checkpoint_model: The pretrained checkpoint model for incremental training.
    :vartype checkpoint_model: ~azure.mgmt.machinelearningservices.models.MLFlowModelJobInput
    :ivar checkpoint_run_id: The id of a previous run that has a pretrained checkpoint for
     incremental training.
    :vartype checkpoint_run_id: str
    :ivar distributed: Whether to use distributed training.
    :vartype distributed: bool
    :ivar early_stopping: Enable early stopping logic during training.
    :vartype early_stopping: bool
    :ivar early_stopping_delay: Minimum number of epochs or validation evaluations to wait before
     primary metric improvement
     is tracked for early stopping. Must be a positive integer.
    :vartype early_stopping_delay: int
    :ivar early_stopping_patience: Minimum number of epochs or validation evaluations with no
     primary metric improvement before
     the run is stopped. Must be a positive integer.
    :vartype early_stopping_patience: int
    :ivar enable_onnx_normalization: Enable normalization when exporting ONNX model.
    :vartype enable_onnx_normalization: bool
    :ivar evaluation_frequency: Frequency to evaluate validation dataset to get metric scores. Must
     be a positive integer.
    :vartype evaluation_frequency: int
    :ivar gradient_accumulation_step: Gradient accumulation means running a configured number of
     "GradAccumulationStep" steps without
     updating the model weights while accumulating the gradients of those steps, and then using
     the accumulated gradients to compute the weight updates. Must be a positive integer.
    :vartype gradient_accumulation_step: int
    :ivar layers_to_freeze: Number of layers to freeze for the model. Must be a positive integer.
     For instance, passing 2 as value for 'seresnext' means
     freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
     please
     see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype layers_to_freeze: int
    :ivar learning_rate: Initial learning rate. Must be a float in the range [0, 1].
    :vartype learning_rate: float
    :ivar learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
     'step'. Possible values include: "None", "WarmupCosine", "Step".
    :vartype learning_rate_scheduler: str or
     ~azure.mgmt.machinelearningservices.models.LearningRateScheduler
    :ivar model_name: Name of the model to use for training.
     For more information on the available models please visit the official documentation:
     https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype model_name: str
    :ivar momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
    :vartype momentum: float
    :ivar nesterov: Enable nesterov when optimizer is 'sgd'.
    :vartype nesterov: bool
    :ivar number_of_epochs: Number of training epochs. Must be a positive integer.
    :vartype number_of_epochs: int
    :ivar number_of_workers: Number of data loader workers. Must be a non-negative integer.
    :vartype number_of_workers: int
    :ivar optimizer: Type of optimizer. Possible values include: "None", "Sgd", "Adam", "Adamw".
    :vartype optimizer: str or ~azure.mgmt.machinelearningservices.models.StochasticOptimizer
    :ivar random_seed: Random seed to be used when using deterministic training.
    :vartype random_seed: int
    :ivar step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float in
     the range [0, 1].
    :vartype step_lr_gamma: float
    :ivar step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be a
     positive integer.
    :vartype step_lr_step_size: int
    :ivar training_batch_size: Training batch size. Must be a positive integer.
    :vartype training_batch_size: int
    :ivar validation_batch_size: Validation batch size. Must be a positive integer.
    :vartype validation_batch_size: int
    :ivar warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
     'warmup_cosine'. Must be a float in the range [0, 1].
    :vartype warmup_cosine_lr_cycles: float
    :ivar warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
     'warmup_cosine'. Must be a positive integer.
    :vartype warmup_cosine_lr_warmup_epochs: int
    :ivar weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be
     a float in the range[0, 1].
    :vartype weight_decay: float
    """

    _attribute_map = {
        'advanced_settings': {'key': 'advancedSettings', 'type': 'str'},
        'ams_gradient': {'key': 'amsGradient', 'type': 'bool'},
        'augmentations': {'key': 'augmentations', 'type': 'str'},
        'beta1': {'key': 'beta1', 'type': 'float'},
        'beta2': {'key': 'beta2', 'type': 'float'},
        'checkpoint_frequency': {'key': 'checkpointFrequency', 'type': 'int'},
        'checkpoint_model': {'key': 'checkpointModel', 'type': 'MLFlowModelJobInput'},
        'checkpoint_run_id': {'key': 'checkpointRunId', 'type': 'str'},
        'distributed': {'key': 'distributed', 'type': 'bool'},
        'early_stopping': {'key': 'earlyStopping', 'type': 'bool'},
        'early_stopping_delay': {'key': 'earlyStoppingDelay', 'type': 'int'},
        'early_stopping_patience': {'key': 'earlyStoppingPatience', 'type': 'int'},
        'enable_onnx_normalization': {'key': 'enableOnnxNormalization', 'type': 'bool'},
        'evaluation_frequency': {'key': 'evaluationFrequency', 'type': 'int'},
        'gradient_accumulation_step': {'key': 'gradientAccumulationStep', 'type': 'int'},
        'layers_to_freeze': {'key': 'layersToFreeze', 'type': 'int'},
        'learning_rate': {'key': 'learningRate', 'type': 'float'},
        'learning_rate_scheduler': {'key': 'learningRateScheduler', 'type': 'str'},
        'model_name': {'key': 'modelName', 'type': 'str'},
        'momentum': {'key': 'momentum', 'type': 'float'},
        'nesterov': {'key': 'nesterov', 'type': 'bool'},
        'number_of_epochs': {'key': 'numberOfEpochs', 'type': 'int'},
        'number_of_workers': {'key': 'numberOfWorkers', 'type': 'int'},
        'optimizer': {'key': 'optimizer', 'type': 'str'},
        'random_seed': {'key': 'randomSeed', 'type': 'int'},
        'step_lr_gamma': {'key': 'stepLRGamma', 'type': 'float'},
        'step_lr_step_size': {'key': 'stepLRStepSize', 'type': 'int'},
        'training_batch_size': {'key': 'trainingBatchSize', 'type': 'int'},
        'validation_batch_size': {'key': 'validationBatchSize', 'type': 'int'},
        'warmup_cosine_lr_cycles': {'key': 'warmupCosineLRCycles', 'type': 'float'},
        'warmup_cosine_lr_warmup_epochs': {'key': 'warmupCosineLRWarmupEpochs', 'type': 'int'},
        'weight_decay': {'key': 'weightDecay', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        advanced_settings: Optional[str] = None,
        ams_gradient: Optional[bool] = None,
        augmentations: Optional[str] = None,
        beta1: Optional[float] = None,
        beta2: Optional[float] = None,
        checkpoint_frequency: Optional[int] = None,
        checkpoint_model: Optional["MLFlowModelJobInput"] = None,
        checkpoint_run_id: Optional[str] = None,
        distributed: Optional[bool] = None,
        early_stopping: Optional[bool] = None,
        early_stopping_delay: Optional[int] = None,
        early_stopping_patience: Optional[int] = None,
        enable_onnx_normalization: Optional[bool] = None,
        evaluation_frequency: Optional[int] = None,
        gradient_accumulation_step: Optional[int] = None,
        layers_to_freeze: Optional[int] = None,
        learning_rate: Optional[float] = None,
        learning_rate_scheduler: Optional[Union[str, "LearningRateScheduler"]] = None,
        model_name: Optional[str] = None,
        momentum: Optional[float] = None,
        nesterov: Optional[bool] = None,
        number_of_epochs: Optional[int] = None,
        number_of_workers: Optional[int] = None,
        optimizer: Optional[Union[str, "StochasticOptimizer"]] = None,
        random_seed: Optional[int] = None,
        step_lr_gamma: Optional[float] = None,
        step_lr_step_size: Optional[int] = None,
        training_batch_size: Optional[int] = None,
        validation_batch_size: Optional[int] = None,
        warmup_cosine_lr_cycles: Optional[float] = None,
        warmup_cosine_lr_warmup_epochs: Optional[int] = None,
        weight_decay: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword advanced_settings: Settings for advanced scenarios.
        :paramtype advanced_settings: str
        :keyword ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        :paramtype ams_gradient: bool
        :keyword augmentations: Settings for using Augmentations.
        :paramtype augmentations: str
        :keyword beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta1: float
        :keyword beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta2: float
        :keyword checkpoint_frequency: Frequency to store model checkpoints. Must be a positive
         integer.
        :paramtype checkpoint_frequency: int
        :keyword checkpoint_model: The pretrained checkpoint model for incremental training.
        :paramtype checkpoint_model: ~azure.mgmt.machinelearningservices.models.MLFlowModelJobInput
        :keyword checkpoint_run_id: The id of a previous run that has a pretrained checkpoint for
         incremental training.
        :paramtype checkpoint_run_id: str
        :keyword distributed: Whether to use distributed training.
        :paramtype distributed: bool
        :keyword early_stopping: Enable early stopping logic during training.
        :paramtype early_stopping: bool
        :keyword early_stopping_delay: Minimum number of epochs or validation evaluations to wait
         before primary metric improvement
         is tracked for early stopping. Must be a positive integer.
        :paramtype early_stopping_delay: int
        :keyword early_stopping_patience: Minimum number of epochs or validation evaluations with no
         primary metric improvement before
         the run is stopped. Must be a positive integer.
        :paramtype early_stopping_patience: int
        :keyword enable_onnx_normalization: Enable normalization when exporting ONNX model.
        :paramtype enable_onnx_normalization: bool
        :keyword evaluation_frequency: Frequency to evaluate validation dataset to get metric scores.
         Must be a positive integer.
        :paramtype evaluation_frequency: int
        :keyword gradient_accumulation_step: Gradient accumulation means running a configured number of
         "GradAccumulationStep" steps without
         updating the model weights while accumulating the gradients of those steps, and then using
         the accumulated gradients to compute the weight updates. Must be a positive integer.
        :paramtype gradient_accumulation_step: int
        :keyword layers_to_freeze: Number of layers to freeze for the model. Must be a positive
         integer.
         For instance, passing 2 as value for 'seresnext' means
         freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
         please
         see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype layers_to_freeze: int
        :keyword learning_rate: Initial learning rate. Must be a float in the range [0, 1].
        :paramtype learning_rate: float
        :keyword learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
         'step'. Possible values include: "None", "WarmupCosine", "Step".
        :paramtype learning_rate_scheduler: str or
         ~azure.mgmt.machinelearningservices.models.LearningRateScheduler
        :keyword model_name: Name of the model to use for training.
         For more information on the available models please visit the official documentation:
         https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype model_name: str
        :keyword momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0,
         1].
        :paramtype momentum: float
        :keyword nesterov: Enable nesterov when optimizer is 'sgd'.
        :paramtype nesterov: bool
        :keyword number_of_epochs: Number of training epochs. Must be a positive integer.
        :paramtype number_of_epochs: int
        :keyword number_of_workers: Number of data loader workers. Must be a non-negative integer.
        :paramtype number_of_workers: int
        :keyword optimizer: Type of optimizer. Possible values include: "None", "Sgd", "Adam", "Adamw".
        :paramtype optimizer: str or ~azure.mgmt.machinelearningservices.models.StochasticOptimizer
        :keyword random_seed: Random seed to be used when using deterministic training.
        :paramtype random_seed: int
        :keyword step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float
         in the range [0, 1].
        :paramtype step_lr_gamma: float
        :keyword step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be
         a positive integer.
        :paramtype step_lr_step_size: int
        :keyword training_batch_size: Training batch size. Must be a positive integer.
        :paramtype training_batch_size: int
        :keyword validation_batch_size: Validation batch size. Must be a positive integer.
        :paramtype validation_batch_size: int
        :keyword warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
         'warmup_cosine'. Must be a float in the range [0, 1].
        :paramtype warmup_cosine_lr_cycles: float
        :keyword warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
         'warmup_cosine'. Must be a positive integer.
        :paramtype warmup_cosine_lr_warmup_epochs: int
        :keyword weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must
         be a float in the range[0, 1].
        :paramtype weight_decay: float
        """
        super(ImageModelSettings, self).__init__(**kwargs)
        self.advanced_settings = advanced_settings
        self.ams_gradient = ams_gradient
        self.augmentations = augmentations
        self.beta1 = beta1
        self.beta2 = beta2
        self.checkpoint_frequency = checkpoint_frequency
        self.checkpoint_model = checkpoint_model
        self.checkpoint_run_id = checkpoint_run_id
        self.distributed = distributed
        self.early_stopping = early_stopping
        self.early_stopping_delay = early_stopping_delay
        self.early_stopping_patience = early_stopping_patience
        self.enable_onnx_normalization = enable_onnx_normalization
        self.evaluation_frequency = evaluation_frequency
        self.gradient_accumulation_step = gradient_accumulation_step
        self.layers_to_freeze = layers_to_freeze
        self.learning_rate = learning_rate
        self.learning_rate_scheduler = learning_rate_scheduler
        self.model_name = model_name
        self.momentum = momentum
        self.nesterov = nesterov
        self.number_of_epochs = number_of_epochs
        self.number_of_workers = number_of_workers
        self.optimizer = optimizer
        self.random_seed = random_seed
        self.step_lr_gamma = step_lr_gamma
        self.step_lr_step_size = step_lr_step_size
        self.training_batch_size = training_batch_size
        self.validation_batch_size = validation_batch_size
        self.warmup_cosine_lr_cycles = warmup_cosine_lr_cycles
        self.warmup_cosine_lr_warmup_epochs = warmup_cosine_lr_warmup_epochs
        self.weight_decay = weight_decay


class ImageModelSettingsClassification(ImageModelSettings):
    """Settings used for training the model.
For more information on the available settings please visit the official documentation:
https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.

    :ivar advanced_settings: Settings for advanced scenarios.
    :vartype advanced_settings: str
    :ivar ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
    :vartype ams_gradient: bool
    :ivar augmentations: Settings for using Augmentations.
    :vartype augmentations: str
    :ivar beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta1: float
    :ivar beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta2: float
    :ivar checkpoint_frequency: Frequency to store model checkpoints. Must be a positive integer.
    :vartype checkpoint_frequency: int
    :ivar checkpoint_model: The pretrained checkpoint model for incremental training.
    :vartype checkpoint_model: ~azure.mgmt.machinelearningservices.models.MLFlowModelJobInput
    :ivar checkpoint_run_id: The id of a previous run that has a pretrained checkpoint for
     incremental training.
    :vartype checkpoint_run_id: str
    :ivar distributed: Whether to use distributed training.
    :vartype distributed: bool
    :ivar early_stopping: Enable early stopping logic during training.
    :vartype early_stopping: bool
    :ivar early_stopping_delay: Minimum number of epochs or validation evaluations to wait before
     primary metric improvement
     is tracked for early stopping. Must be a positive integer.
    :vartype early_stopping_delay: int
    :ivar early_stopping_patience: Minimum number of epochs or validation evaluations with no
     primary metric improvement before
     the run is stopped. Must be a positive integer.
    :vartype early_stopping_patience: int
    :ivar enable_onnx_normalization: Enable normalization when exporting ONNX model.
    :vartype enable_onnx_normalization: bool
    :ivar evaluation_frequency: Frequency to evaluate validation dataset to get metric scores. Must
     be a positive integer.
    :vartype evaluation_frequency: int
    :ivar gradient_accumulation_step: Gradient accumulation means running a configured number of
     "GradAccumulationStep" steps without
     updating the model weights while accumulating the gradients of those steps, and then using
     the accumulated gradients to compute the weight updates. Must be a positive integer.
    :vartype gradient_accumulation_step: int
    :ivar layers_to_freeze: Number of layers to freeze for the model. Must be a positive integer.
     For instance, passing 2 as value for 'seresnext' means
     freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
     please
     see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype layers_to_freeze: int
    :ivar learning_rate: Initial learning rate. Must be a float in the range [0, 1].
    :vartype learning_rate: float
    :ivar learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
     'step'. Possible values include: "None", "WarmupCosine", "Step".
    :vartype learning_rate_scheduler: str or
     ~azure.mgmt.machinelearningservices.models.LearningRateScheduler
    :ivar model_name: Name of the model to use for training.
     For more information on the available models please visit the official documentation:
     https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype model_name: str
    :ivar momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
    :vartype momentum: float
    :ivar nesterov: Enable nesterov when optimizer is 'sgd'.
    :vartype nesterov: bool
    :ivar number_of_epochs: Number of training epochs. Must be a positive integer.
    :vartype number_of_epochs: int
    :ivar number_of_workers: Number of data loader workers. Must be a non-negative integer.
    :vartype number_of_workers: int
    :ivar optimizer: Type of optimizer. Possible values include: "None", "Sgd", "Adam", "Adamw".
    :vartype optimizer: str or ~azure.mgmt.machinelearningservices.models.StochasticOptimizer
    :ivar random_seed: Random seed to be used when using deterministic training.
    :vartype random_seed: int
    :ivar step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float in
     the range [0, 1].
    :vartype step_lr_gamma: float
    :ivar step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be a
     positive integer.
    :vartype step_lr_step_size: int
    :ivar training_batch_size: Training batch size. Must be a positive integer.
    :vartype training_batch_size: int
    :ivar validation_batch_size: Validation batch size. Must be a positive integer.
    :vartype validation_batch_size: int
    :ivar warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
     'warmup_cosine'. Must be a float in the range [0, 1].
    :vartype warmup_cosine_lr_cycles: float
    :ivar warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
     'warmup_cosine'. Must be a positive integer.
    :vartype warmup_cosine_lr_warmup_epochs: int
    :ivar weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be
     a float in the range[0, 1].
    :vartype weight_decay: float
    :ivar training_crop_size: Image crop size that is input to the neural network for the training
     dataset. Must be a positive integer.
    :vartype training_crop_size: int
    :ivar validation_crop_size: Image crop size that is input to the neural network for the
     validation dataset. Must be a positive integer.
    :vartype validation_crop_size: int
    :ivar validation_resize_size: Image size to which to resize before cropping for validation
     dataset. Must be a positive integer.
    :vartype validation_resize_size: int
    :ivar weighted_loss: Weighted loss. The accepted values are 0 for no weighted loss.
     1 for weighted loss with sqrt.(class_weights). 2 for weighted loss with class_weights. Must be
     0 or 1 or 2.
    :vartype weighted_loss: int
    """

    _attribute_map = {
        'advanced_settings': {'key': 'advancedSettings', 'type': 'str'},
        'ams_gradient': {'key': 'amsGradient', 'type': 'bool'},
        'augmentations': {'key': 'augmentations', 'type': 'str'},
        'beta1': {'key': 'beta1', 'type': 'float'},
        'beta2': {'key': 'beta2', 'type': 'float'},
        'checkpoint_frequency': {'key': 'checkpointFrequency', 'type': 'int'},
        'checkpoint_model': {'key': 'checkpointModel', 'type': 'MLFlowModelJobInput'},
        'checkpoint_run_id': {'key': 'checkpointRunId', 'type': 'str'},
        'distributed': {'key': 'distributed', 'type': 'bool'},
        'early_stopping': {'key': 'earlyStopping', 'type': 'bool'},
        'early_stopping_delay': {'key': 'earlyStoppingDelay', 'type': 'int'},
        'early_stopping_patience': {'key': 'earlyStoppingPatience', 'type': 'int'},
        'enable_onnx_normalization': {'key': 'enableOnnxNormalization', 'type': 'bool'},
        'evaluation_frequency': {'key': 'evaluationFrequency', 'type': 'int'},
        'gradient_accumulation_step': {'key': 'gradientAccumulationStep', 'type': 'int'},
        'layers_to_freeze': {'key': 'layersToFreeze', 'type': 'int'},
        'learning_rate': {'key': 'learningRate', 'type': 'float'},
        'learning_rate_scheduler': {'key': 'learningRateScheduler', 'type': 'str'},
        'model_name': {'key': 'modelName', 'type': 'str'},
        'momentum': {'key': 'momentum', 'type': 'float'},
        'nesterov': {'key': 'nesterov', 'type': 'bool'},
        'number_of_epochs': {'key': 'numberOfEpochs', 'type': 'int'},
        'number_of_workers': {'key': 'numberOfWorkers', 'type': 'int'},
        'optimizer': {'key': 'optimizer', 'type': 'str'},
        'random_seed': {'key': 'randomSeed', 'type': 'int'},
        'step_lr_gamma': {'key': 'stepLRGamma', 'type': 'float'},
        'step_lr_step_size': {'key': 'stepLRStepSize', 'type': 'int'},
        'training_batch_size': {'key': 'trainingBatchSize', 'type': 'int'},
        'validation_batch_size': {'key': 'validationBatchSize', 'type': 'int'},
        'warmup_cosine_lr_cycles': {'key': 'warmupCosineLRCycles', 'type': 'float'},
        'warmup_cosine_lr_warmup_epochs': {'key': 'warmupCosineLRWarmupEpochs', 'type': 'int'},
        'weight_decay': {'key': 'weightDecay', 'type': 'float'},
        'training_crop_size': {'key': 'trainingCropSize', 'type': 'int'},
        'validation_crop_size': {'key': 'validationCropSize', 'type': 'int'},
        'validation_resize_size': {'key': 'validationResizeSize', 'type': 'int'},
        'weighted_loss': {'key': 'weightedLoss', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        advanced_settings: Optional[str] = None,
        ams_gradient: Optional[bool] = None,
        augmentations: Optional[str] = None,
        beta1: Optional[float] = None,
        beta2: Optional[float] = None,
        checkpoint_frequency: Optional[int] = None,
        checkpoint_model: Optional["MLFlowModelJobInput"] = None,
        checkpoint_run_id: Optional[str] = None,
        distributed: Optional[bool] = None,
        early_stopping: Optional[bool] = None,
        early_stopping_delay: Optional[int] = None,
        early_stopping_patience: Optional[int] = None,
        enable_onnx_normalization: Optional[bool] = None,
        evaluation_frequency: Optional[int] = None,
        gradient_accumulation_step: Optional[int] = None,
        layers_to_freeze: Optional[int] = None,
        learning_rate: Optional[float] = None,
        learning_rate_scheduler: Optional[Union[str, "LearningRateScheduler"]] = None,
        model_name: Optional[str] = None,
        momentum: Optional[float] = None,
        nesterov: Optional[bool] = None,
        number_of_epochs: Optional[int] = None,
        number_of_workers: Optional[int] = None,
        optimizer: Optional[Union[str, "StochasticOptimizer"]] = None,
        random_seed: Optional[int] = None,
        step_lr_gamma: Optional[float] = None,
        step_lr_step_size: Optional[int] = None,
        training_batch_size: Optional[int] = None,
        validation_batch_size: Optional[int] = None,
        warmup_cosine_lr_cycles: Optional[float] = None,
        warmup_cosine_lr_warmup_epochs: Optional[int] = None,
        weight_decay: Optional[float] = None,
        training_crop_size: Optional[int] = None,
        validation_crop_size: Optional[int] = None,
        validation_resize_size: Optional[int] = None,
        weighted_loss: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword advanced_settings: Settings for advanced scenarios.
        :paramtype advanced_settings: str
        :keyword ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        :paramtype ams_gradient: bool
        :keyword augmentations: Settings for using Augmentations.
        :paramtype augmentations: str
        :keyword beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta1: float
        :keyword beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta2: float
        :keyword checkpoint_frequency: Frequency to store model checkpoints. Must be a positive
         integer.
        :paramtype checkpoint_frequency: int
        :keyword checkpoint_model: The pretrained checkpoint model for incremental training.
        :paramtype checkpoint_model: ~azure.mgmt.machinelearningservices.models.MLFlowModelJobInput
        :keyword checkpoint_run_id: The id of a previous run that has a pretrained checkpoint for
         incremental training.
        :paramtype checkpoint_run_id: str
        :keyword distributed: Whether to use distributed training.
        :paramtype distributed: bool
        :keyword early_stopping: Enable early stopping logic during training.
        :paramtype early_stopping: bool
        :keyword early_stopping_delay: Minimum number of epochs or validation evaluations to wait
         before primary metric improvement
         is tracked for early stopping. Must be a positive integer.
        :paramtype early_stopping_delay: int
        :keyword early_stopping_patience: Minimum number of epochs or validation evaluations with no
         primary metric improvement before
         the run is stopped. Must be a positive integer.
        :paramtype early_stopping_patience: int
        :keyword enable_onnx_normalization: Enable normalization when exporting ONNX model.
        :paramtype enable_onnx_normalization: bool
        :keyword evaluation_frequency: Frequency to evaluate validation dataset to get metric scores.
         Must be a positive integer.
        :paramtype evaluation_frequency: int
        :keyword gradient_accumulation_step: Gradient accumulation means running a configured number of
         "GradAccumulationStep" steps without
         updating the model weights while accumulating the gradients of those steps, and then using
         the accumulated gradients to compute the weight updates. Must be a positive integer.
        :paramtype gradient_accumulation_step: int
        :keyword layers_to_freeze: Number of layers to freeze for the model. Must be a positive
         integer.
         For instance, passing 2 as value for 'seresnext' means
         freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
         please
         see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype layers_to_freeze: int
        :keyword learning_rate: Initial learning rate. Must be a float in the range [0, 1].
        :paramtype learning_rate: float
        :keyword learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
         'step'. Possible values include: "None", "WarmupCosine", "Step".
        :paramtype learning_rate_scheduler: str or
         ~azure.mgmt.machinelearningservices.models.LearningRateScheduler
        :keyword model_name: Name of the model to use for training.
         For more information on the available models please visit the official documentation:
         https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype model_name: str
        :keyword momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0,
         1].
        :paramtype momentum: float
        :keyword nesterov: Enable nesterov when optimizer is 'sgd'.
        :paramtype nesterov: bool
        :keyword number_of_epochs: Number of training epochs. Must be a positive integer.
        :paramtype number_of_epochs: int
        :keyword number_of_workers: Number of data loader workers. Must be a non-negative integer.
        :paramtype number_of_workers: int
        :keyword optimizer: Type of optimizer. Possible values include: "None", "Sgd", "Adam", "Adamw".
        :paramtype optimizer: str or ~azure.mgmt.machinelearningservices.models.StochasticOptimizer
        :keyword random_seed: Random seed to be used when using deterministic training.
        :paramtype random_seed: int
        :keyword step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float
         in the range [0, 1].
        :paramtype step_lr_gamma: float
        :keyword step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be
         a positive integer.
        :paramtype step_lr_step_size: int
        :keyword training_batch_size: Training batch size. Must be a positive integer.
        :paramtype training_batch_size: int
        :keyword validation_batch_size: Validation batch size. Must be a positive integer.
        :paramtype validation_batch_size: int
        :keyword warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
         'warmup_cosine'. Must be a float in the range [0, 1].
        :paramtype warmup_cosine_lr_cycles: float
        :keyword warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
         'warmup_cosine'. Must be a positive integer.
        :paramtype warmup_cosine_lr_warmup_epochs: int
        :keyword weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must
         be a float in the range[0, 1].
        :paramtype weight_decay: float
        :keyword training_crop_size: Image crop size that is input to the neural network for the
         training dataset. Must be a positive integer.
        :paramtype training_crop_size: int
        :keyword validation_crop_size: Image crop size that is input to the neural network for the
         validation dataset. Must be a positive integer.
        :paramtype validation_crop_size: int
        :keyword validation_resize_size: Image size to which to resize before cropping for validation
         dataset. Must be a positive integer.
        :paramtype validation_resize_size: int
        :keyword weighted_loss: Weighted loss. The accepted values are 0 for no weighted loss.
         1 for weighted loss with sqrt.(class_weights). 2 for weighted loss with class_weights. Must be
         0 or 1 or 2.
        :paramtype weighted_loss: int
        """
        super(ImageModelSettingsClassification, self).__init__(advanced_settings=advanced_settings, ams_gradient=ams_gradient, augmentations=augmentations, beta1=beta1, beta2=beta2, checkpoint_frequency=checkpoint_frequency, checkpoint_model=checkpoint_model, checkpoint_run_id=checkpoint_run_id, distributed=distributed, early_stopping=early_stopping, early_stopping_delay=early_stopping_delay, early_stopping_patience=early_stopping_patience, enable_onnx_normalization=enable_onnx_normalization, evaluation_frequency=evaluation_frequency, gradient_accumulation_step=gradient_accumulation_step, layers_to_freeze=layers_to_freeze, learning_rate=learning_rate, learning_rate_scheduler=learning_rate_scheduler, model_name=model_name, momentum=momentum, nesterov=nesterov, number_of_epochs=number_of_epochs, number_of_workers=number_of_workers, optimizer=optimizer, random_seed=random_seed, step_lr_gamma=step_lr_gamma, step_lr_step_size=step_lr_step_size, training_batch_size=training_batch_size, validation_batch_size=validation_batch_size, warmup_cosine_lr_cycles=warmup_cosine_lr_cycles, warmup_cosine_lr_warmup_epochs=warmup_cosine_lr_warmup_epochs, weight_decay=weight_decay, **kwargs)
        self.training_crop_size = training_crop_size
        self.validation_crop_size = validation_crop_size
        self.validation_resize_size = validation_resize_size
        self.weighted_loss = weighted_loss


class ImageModelSettingsObjectDetection(ImageModelSettings):
    """Settings used for training the model.
For more information on the available settings please visit the official documentation:
https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.

    :ivar advanced_settings: Settings for advanced scenarios.
    :vartype advanced_settings: str
    :ivar ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
    :vartype ams_gradient: bool
    :ivar augmentations: Settings for using Augmentations.
    :vartype augmentations: str
    :ivar beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta1: float
    :ivar beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta2: float
    :ivar checkpoint_frequency: Frequency to store model checkpoints. Must be a positive integer.
    :vartype checkpoint_frequency: int
    :ivar checkpoint_model: The pretrained checkpoint model for incremental training.
    :vartype checkpoint_model: ~azure.mgmt.machinelearningservices.models.MLFlowModelJobInput
    :ivar checkpoint_run_id: The id of a previous run that has a pretrained checkpoint for
     incremental training.
    :vartype checkpoint_run_id: str
    :ivar distributed: Whether to use distributed training.
    :vartype distributed: bool
    :ivar early_stopping: Enable early stopping logic during training.
    :vartype early_stopping: bool
    :ivar early_stopping_delay: Minimum number of epochs or validation evaluations to wait before
     primary metric improvement
     is tracked for early stopping. Must be a positive integer.
    :vartype early_stopping_delay: int
    :ivar early_stopping_patience: Minimum number of epochs or validation evaluations with no
     primary metric improvement before
     the run is stopped. Must be a positive integer.
    :vartype early_stopping_patience: int
    :ivar enable_onnx_normalization: Enable normalization when exporting ONNX model.
    :vartype enable_onnx_normalization: bool
    :ivar evaluation_frequency: Frequency to evaluate validation dataset to get metric scores. Must
     be a positive integer.
    :vartype evaluation_frequency: int
    :ivar gradient_accumulation_step: Gradient accumulation means running a configured number of
     "GradAccumulationStep" steps without
     updating the model weights while accumulating the gradients of those steps, and then using
     the accumulated gradients to compute the weight updates. Must be a positive integer.
    :vartype gradient_accumulation_step: int
    :ivar layers_to_freeze: Number of layers to freeze for the model. Must be a positive integer.
     For instance, passing 2 as value for 'seresnext' means
     freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
     please
     see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype layers_to_freeze: int
    :ivar learning_rate: Initial learning rate. Must be a float in the range [0, 1].
    :vartype learning_rate: float
    :ivar learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
     'step'. Possible values include: "None", "WarmupCosine", "Step".
    :vartype learning_rate_scheduler: str or
     ~azure.mgmt.machinelearningservices.models.LearningRateScheduler
    :ivar model_name: Name of the model to use for training.
     For more information on the available models please visit the official documentation:
     https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype model_name: str
    :ivar momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
    :vartype momentum: float
    :ivar nesterov: Enable nesterov when optimizer is 'sgd'.
    :vartype nesterov: bool
    :ivar number_of_epochs: Number of training epochs. Must be a positive integer.
    :vartype number_of_epochs: int
    :ivar number_of_workers: Number of data loader workers. Must be a non-negative integer.
    :vartype number_of_workers: int
    :ivar optimizer: Type of optimizer. Possible values include: "None", "Sgd", "Adam", "Adamw".
    :vartype optimizer: str or ~azure.mgmt.machinelearningservices.models.StochasticOptimizer
    :ivar random_seed: Random seed to be used when using deterministic training.
    :vartype random_seed: int
    :ivar step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float in
     the range [0, 1].
    :vartype step_lr_gamma: float
    :ivar step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be a
     positive integer.
    :vartype step_lr_step_size: int
    :ivar training_batch_size: Training batch size. Must be a positive integer.
    :vartype training_batch_size: int
    :ivar validation_batch_size: Validation batch size. Must be a positive integer.
    :vartype validation_batch_size: int
    :ivar warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
     'warmup_cosine'. Must be a float in the range [0, 1].
    :vartype warmup_cosine_lr_cycles: float
    :ivar warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
     'warmup_cosine'. Must be a positive integer.
    :vartype warmup_cosine_lr_warmup_epochs: int
    :ivar weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be
     a float in the range[0, 1].
    :vartype weight_decay: float
    :ivar box_detections_per_image: Maximum number of detections per image, for all classes. Must
     be a positive integer.
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype box_detections_per_image: int
    :ivar box_score_threshold: During inference, only return proposals with a classification score
     greater than
     BoxScoreThreshold. Must be a float in the range[0, 1].
    :vartype box_score_threshold: float
    :ivar image_size: Image size for train and validation. Must be a positive integer.
     Note: The training run may get into CUDA OOM if the size is too big.
     Note: This settings is only supported for the 'yolov5' algorithm.
    :vartype image_size: int
    :ivar log_training_metrics: Enable computing and logging training metrics. Possible values
     include: "Enable", "Disable".
    :vartype log_training_metrics: str or
     ~azure.mgmt.machinelearningservices.models.LogTrainingMetrics
    :ivar log_validation_loss: Enable computing and logging validation loss. Possible values
     include: "Enable", "Disable".
    :vartype log_validation_loss: str or
     ~azure.mgmt.machinelearningservices.models.LogValidationLoss
    :ivar max_size: Maximum size of the image to be rescaled before feeding it to the backbone.
     Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype max_size: int
    :ivar min_size: Minimum size of the image to be rescaled before feeding it to the backbone.
     Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype min_size: int
    :ivar model_size: Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
     Note: training run may get into CUDA OOM if the model size is too big.
     Note: This settings is only supported for the 'yolov5' algorithm. Possible values include:
     "None", "Small", "Medium", "Large", "ExtraLarge".
    :vartype model_size: str or ~azure.mgmt.machinelearningservices.models.ModelSize
    :ivar multi_scale: Enable multi-scale image by varying image size by +/- 50%.
     Note: training run may get into CUDA OOM if no sufficient GPU memory.
     Note: This settings is only supported for the 'yolov5' algorithm.
    :vartype multi_scale: bool
    :ivar nms_iou_threshold: IOU threshold used during inference in NMS post processing. Must be a
     float in the range [0, 1].
    :vartype nms_iou_threshold: float
    :ivar tile_grid_size: The grid size to use for tiling each image. Note: TileGridSize must not
     be
     None to enable small object detection logic. A string containing two integers in mxn format.
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype tile_grid_size: str
    :ivar tile_overlap_ratio: Overlap ratio between adjacent tiles in each dimension. Must be float
     in the range [0, 1).
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype tile_overlap_ratio: float
    :ivar tile_predictions_nms_threshold: The IOU threshold to use to perform NMS while merging
     predictions from tiles and image.
     Used in validation/ inference. Must be float in the range [0, 1].
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype tile_predictions_nms_threshold: float
    :ivar validation_iou_threshold: IOU threshold to use when computing validation metric. Must be
     float in the range [0, 1].
    :vartype validation_iou_threshold: float
    :ivar validation_metric_type: Metric computation method to use for validation metrics. Possible
     values include: "None", "Coco", "Voc", "CocoVoc".
    :vartype validation_metric_type: str or
     ~azure.mgmt.machinelearningservices.models.ValidationMetricType
    """

    _attribute_map = {
        'advanced_settings': {'key': 'advancedSettings', 'type': 'str'},
        'ams_gradient': {'key': 'amsGradient', 'type': 'bool'},
        'augmentations': {'key': 'augmentations', 'type': 'str'},
        'beta1': {'key': 'beta1', 'type': 'float'},
        'beta2': {'key': 'beta2', 'type': 'float'},
        'checkpoint_frequency': {'key': 'checkpointFrequency', 'type': 'int'},
        'checkpoint_model': {'key': 'checkpointModel', 'type': 'MLFlowModelJobInput'},
        'checkpoint_run_id': {'key': 'checkpointRunId', 'type': 'str'},
        'distributed': {'key': 'distributed', 'type': 'bool'},
        'early_stopping': {'key': 'earlyStopping', 'type': 'bool'},
        'early_stopping_delay': {'key': 'earlyStoppingDelay', 'type': 'int'},
        'early_stopping_patience': {'key': 'earlyStoppingPatience', 'type': 'int'},
        'enable_onnx_normalization': {'key': 'enableOnnxNormalization', 'type': 'bool'},
        'evaluation_frequency': {'key': 'evaluationFrequency', 'type': 'int'},
        'gradient_accumulation_step': {'key': 'gradientAccumulationStep', 'type': 'int'},
        'layers_to_freeze': {'key': 'layersToFreeze', 'type': 'int'},
        'learning_rate': {'key': 'learningRate', 'type': 'float'},
        'learning_rate_scheduler': {'key': 'learningRateScheduler', 'type': 'str'},
        'model_name': {'key': 'modelName', 'type': 'str'},
        'momentum': {'key': 'momentum', 'type': 'float'},
        'nesterov': {'key': 'nesterov', 'type': 'bool'},
        'number_of_epochs': {'key': 'numberOfEpochs', 'type': 'int'},
        'number_of_workers': {'key': 'numberOfWorkers', 'type': 'int'},
        'optimizer': {'key': 'optimizer', 'type': 'str'},
        'random_seed': {'key': 'randomSeed', 'type': 'int'},
        'step_lr_gamma': {'key': 'stepLRGamma', 'type': 'float'},
        'step_lr_step_size': {'key': 'stepLRStepSize', 'type': 'int'},
        'training_batch_size': {'key': 'trainingBatchSize', 'type': 'int'},
        'validation_batch_size': {'key': 'validationBatchSize', 'type': 'int'},
        'warmup_cosine_lr_cycles': {'key': 'warmupCosineLRCycles', 'type': 'float'},
        'warmup_cosine_lr_warmup_epochs': {'key': 'warmupCosineLRWarmupEpochs', 'type': 'int'},
        'weight_decay': {'key': 'weightDecay', 'type': 'float'},
        'box_detections_per_image': {'key': 'boxDetectionsPerImage', 'type': 'int'},
        'box_score_threshold': {'key': 'boxScoreThreshold', 'type': 'float'},
        'image_size': {'key': 'imageSize', 'type': 'int'},
        'log_training_metrics': {'key': 'logTrainingMetrics', 'type': 'str'},
        'log_validation_loss': {'key': 'logValidationLoss', 'type': 'str'},
        'max_size': {'key': 'maxSize', 'type': 'int'},
        'min_size': {'key': 'minSize', 'type': 'int'},
        'model_size': {'key': 'modelSize', 'type': 'str'},
        'multi_scale': {'key': 'multiScale', 'type': 'bool'},
        'nms_iou_threshold': {'key': 'nmsIouThreshold', 'type': 'float'},
        'tile_grid_size': {'key': 'tileGridSize', 'type': 'str'},
        'tile_overlap_ratio': {'key': 'tileOverlapRatio', 'type': 'float'},
        'tile_predictions_nms_threshold': {'key': 'tilePredictionsNmsThreshold', 'type': 'float'},
        'validation_iou_threshold': {'key': 'validationIouThreshold', 'type': 'float'},
        'validation_metric_type': {'key': 'validationMetricType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        advanced_settings: Optional[str] = None,
        ams_gradient: Optional[bool] = None,
        augmentations: Optional[str] = None,
        beta1: Optional[float] = None,
        beta2: Optional[float] = None,
        checkpoint_frequency: Optional[int] = None,
        checkpoint_model: Optional["MLFlowModelJobInput"] = None,
        checkpoint_run_id: Optional[str] = None,
        distributed: Optional[bool] = None,
        early_stopping: Optional[bool] = None,
        early_stopping_delay: Optional[int] = None,
        early_stopping_patience: Optional[int] = None,
        enable_onnx_normalization: Optional[bool] = None,
        evaluation_frequency: Optional[int] = None,
        gradient_accumulation_step: Optional[int] = None,
        layers_to_freeze: Optional[int] = None,
        learning_rate: Optional[float] = None,
        learning_rate_scheduler: Optional[Union[str, "LearningRateScheduler"]] = None,
        model_name: Optional[str] = None,
        momentum: Optional[float] = None,
        nesterov: Optional[bool] = None,
        number_of_epochs: Optional[int] = None,
        number_of_workers: Optional[int] = None,
        optimizer: Optional[Union[str, "StochasticOptimizer"]] = None,
        random_seed: Optional[int] = None,
        step_lr_gamma: Optional[float] = None,
        step_lr_step_size: Optional[int] = None,
        training_batch_size: Optional[int] = None,
        validation_batch_size: Optional[int] = None,
        warmup_cosine_lr_cycles: Optional[float] = None,
        warmup_cosine_lr_warmup_epochs: Optional[int] = None,
        weight_decay: Optional[float] = None,
        box_detections_per_image: Optional[int] = None,
        box_score_threshold: Optional[float] = None,
        image_size: Optional[int] = None,
        log_training_metrics: Optional[Union[str, "LogTrainingMetrics"]] = None,
        log_validation_loss: Optional[Union[str, "LogValidationLoss"]] = None,
        max_size: Optional[int] = None,
        min_size: Optional[int] = None,
        model_size: Optional[Union[str, "ModelSize"]] = None,
        multi_scale: Optional[bool] = None,
        nms_iou_threshold: Optional[float] = None,
        tile_grid_size: Optional[str] = None,
        tile_overlap_ratio: Optional[float] = None,
        tile_predictions_nms_threshold: Optional[float] = None,
        validation_iou_threshold: Optional[float] = None,
        validation_metric_type: Optional[Union[str, "ValidationMetricType"]] = None,
        **kwargs
    ):
        """
        :keyword advanced_settings: Settings for advanced scenarios.
        :paramtype advanced_settings: str
        :keyword ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        :paramtype ams_gradient: bool
        :keyword augmentations: Settings for using Augmentations.
        :paramtype augmentations: str
        :keyword beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta1: float
        :keyword beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta2: float
        :keyword checkpoint_frequency: Frequency to store model checkpoints. Must be a positive
         integer.
        :paramtype checkpoint_frequency: int
        :keyword checkpoint_model: The pretrained checkpoint model for incremental training.
        :paramtype checkpoint_model: ~azure.mgmt.machinelearningservices.models.MLFlowModelJobInput
        :keyword checkpoint_run_id: The id of a previous run that has a pretrained checkpoint for
         incremental training.
        :paramtype checkpoint_run_id: str
        :keyword distributed: Whether to use distributed training.
        :paramtype distributed: bool
        :keyword early_stopping: Enable early stopping logic during training.
        :paramtype early_stopping: bool
        :keyword early_stopping_delay: Minimum number of epochs or validation evaluations to wait
         before primary metric improvement
         is tracked for early stopping. Must be a positive integer.
        :paramtype early_stopping_delay: int
        :keyword early_stopping_patience: Minimum number of epochs or validation evaluations with no
         primary metric improvement before
         the run is stopped. Must be a positive integer.
        :paramtype early_stopping_patience: int
        :keyword enable_onnx_normalization: Enable normalization when exporting ONNX model.
        :paramtype enable_onnx_normalization: bool
        :keyword evaluation_frequency: Frequency to evaluate validation dataset to get metric scores.
         Must be a positive integer.
        :paramtype evaluation_frequency: int
        :keyword gradient_accumulation_step: Gradient accumulation means running a configured number of
         "GradAccumulationStep" steps without
         updating the model weights while accumulating the gradients of those steps, and then using
         the accumulated gradients to compute the weight updates. Must be a positive integer.
        :paramtype gradient_accumulation_step: int
        :keyword layers_to_freeze: Number of layers to freeze for the model. Must be a positive
         integer.
         For instance, passing 2 as value for 'seresnext' means
         freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
         please
         see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype layers_to_freeze: int
        :keyword learning_rate: Initial learning rate. Must be a float in the range [0, 1].
        :paramtype learning_rate: float
        :keyword learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
         'step'. Possible values include: "None", "WarmupCosine", "Step".
        :paramtype learning_rate_scheduler: str or
         ~azure.mgmt.machinelearningservices.models.LearningRateScheduler
        :keyword model_name: Name of the model to use for training.
         For more information on the available models please visit the official documentation:
         https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype model_name: str
        :keyword momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0,
         1].
        :paramtype momentum: float
        :keyword nesterov: Enable nesterov when optimizer is 'sgd'.
        :paramtype nesterov: bool
        :keyword number_of_epochs: Number of training epochs. Must be a positive integer.
        :paramtype number_of_epochs: int
        :keyword number_of_workers: Number of data loader workers. Must be a non-negative integer.
        :paramtype number_of_workers: int
        :keyword optimizer: Type of optimizer. Possible values include: "None", "Sgd", "Adam", "Adamw".
        :paramtype optimizer: str or ~azure.mgmt.machinelearningservices.models.StochasticOptimizer
        :keyword random_seed: Random seed to be used when using deterministic training.
        :paramtype random_seed: int
        :keyword step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float
         in the range [0, 1].
        :paramtype step_lr_gamma: float
        :keyword step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be
         a positive integer.
        :paramtype step_lr_step_size: int
        :keyword training_batch_size: Training batch size. Must be a positive integer.
        :paramtype training_batch_size: int
        :keyword validation_batch_size: Validation batch size. Must be a positive integer.
        :paramtype validation_batch_size: int
        :keyword warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
         'warmup_cosine'. Must be a float in the range [0, 1].
        :paramtype warmup_cosine_lr_cycles: float
        :keyword warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
         'warmup_cosine'. Must be a positive integer.
        :paramtype warmup_cosine_lr_warmup_epochs: int
        :keyword weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must
         be a float in the range[0, 1].
        :paramtype weight_decay: float
        :keyword box_detections_per_image: Maximum number of detections per image, for all classes.
         Must be a positive integer.
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype box_detections_per_image: int
        :keyword box_score_threshold: During inference, only return proposals with a classification
         score greater than
         BoxScoreThreshold. Must be a float in the range[0, 1].
        :paramtype box_score_threshold: float
        :keyword image_size: Image size for train and validation. Must be a positive integer.
         Note: The training run may get into CUDA OOM if the size is too big.
         Note: This settings is only supported for the 'yolov5' algorithm.
        :paramtype image_size: int
        :keyword log_training_metrics: Enable computing and logging training metrics. Possible values
         include: "Enable", "Disable".
        :paramtype log_training_metrics: str or
         ~azure.mgmt.machinelearningservices.models.LogTrainingMetrics
        :keyword log_validation_loss: Enable computing and logging validation loss. Possible values
         include: "Enable", "Disable".
        :paramtype log_validation_loss: str or
         ~azure.mgmt.machinelearningservices.models.LogValidationLoss
        :keyword max_size: Maximum size of the image to be rescaled before feeding it to the backbone.
         Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype max_size: int
        :keyword min_size: Minimum size of the image to be rescaled before feeding it to the backbone.
         Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype min_size: int
        :keyword model_size: Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
         Note: training run may get into CUDA OOM if the model size is too big.
         Note: This settings is only supported for the 'yolov5' algorithm. Possible values include:
         "None", "Small", "Medium", "Large", "ExtraLarge".
        :paramtype model_size: str or ~azure.mgmt.machinelearningservices.models.ModelSize
        :keyword multi_scale: Enable multi-scale image by varying image size by +/- 50%.
         Note: training run may get into CUDA OOM if no sufficient GPU memory.
         Note: This settings is only supported for the 'yolov5' algorithm.
        :paramtype multi_scale: bool
        :keyword nms_iou_threshold: IOU threshold used during inference in NMS post processing. Must be
         a float in the range [0, 1].
        :paramtype nms_iou_threshold: float
        :keyword tile_grid_size: The grid size to use for tiling each image. Note: TileGridSize must
         not be
         None to enable small object detection logic. A string containing two integers in mxn format.
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype tile_grid_size: str
        :keyword tile_overlap_ratio: Overlap ratio between adjacent tiles in each dimension. Must be
         float in the range [0, 1).
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype tile_overlap_ratio: float
        :keyword tile_predictions_nms_threshold: The IOU threshold to use to perform NMS while merging
         predictions from tiles and image.
         Used in validation/ inference. Must be float in the range [0, 1].
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype tile_predictions_nms_threshold: float
        :keyword validation_iou_threshold: IOU threshold to use when computing validation metric. Must
         be float in the range [0, 1].
        :paramtype validation_iou_threshold: float
        :keyword validation_metric_type: Metric computation method to use for validation metrics.
         Possible values include: "None", "Coco", "Voc", "CocoVoc".
        :paramtype validation_metric_type: str or
         ~azure.mgmt.machinelearningservices.models.ValidationMetricType
        """
        super(ImageModelSettingsObjectDetection, self).__init__(advanced_settings=advanced_settings, ams_gradient=ams_gradient, augmentations=augmentations, beta1=beta1, beta2=beta2, checkpoint_frequency=checkpoint_frequency, checkpoint_model=checkpoint_model, checkpoint_run_id=checkpoint_run_id, distributed=distributed, early_stopping=early_stopping, early_stopping_delay=early_stopping_delay, early_stopping_patience=early_stopping_patience, enable_onnx_normalization=enable_onnx_normalization, evaluation_frequency=evaluation_frequency, gradient_accumulation_step=gradient_accumulation_step, layers_to_freeze=layers_to_freeze, learning_rate=learning_rate, learning_rate_scheduler=learning_rate_scheduler, model_name=model_name, momentum=momentum, nesterov=nesterov, number_of_epochs=number_of_epochs, number_of_workers=number_of_workers, optimizer=optimizer, random_seed=random_seed, step_lr_gamma=step_lr_gamma, step_lr_step_size=step_lr_step_size, training_batch_size=training_batch_size, validation_batch_size=validation_batch_size, warmup_cosine_lr_cycles=warmup_cosine_lr_cycles, warmup_cosine_lr_warmup_epochs=warmup_cosine_lr_warmup_epochs, weight_decay=weight_decay, **kwargs)
        self.box_detections_per_image = box_detections_per_image
        self.box_score_threshold = box_score_threshold
        self.image_size = image_size
        self.log_training_metrics = log_training_metrics
        self.log_validation_loss = log_validation_loss
        self.max_size = max_size
        self.min_size = min_size
        self.model_size = model_size
        self.multi_scale = multi_scale
        self.nms_iou_threshold = nms_iou_threshold
        self.tile_grid_size = tile_grid_size
        self.tile_overlap_ratio = tile_overlap_ratio
        self.tile_predictions_nms_threshold = tile_predictions_nms_threshold
        self.validation_iou_threshold = validation_iou_threshold
        self.validation_metric_type = validation_metric_type


class ImageObjectDetection(AutoMLVertical, ImageObjectDetectionBase):
    """Image Object Detection. Object detection is used to identify objects in an image and locate each object with a
bounding box e.g. locate all dogs and cats in an image and draw a bounding box around each.

    All required parameters must be populated in order to send to Azure.

    :ivar limit_settings: Required. [Required] Limit settings for the AutoML job.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
    :ivar sweep_settings: Model sweeping and hyperparameter sweeping related settings.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    :ivar model_settings: Settings used for training the model.
    :vartype model_settings:
     ~azure.mgmt.machinelearningservices.models.ImageModelSettingsObjectDetection
    :ivar search_space: Search space for sampling different combinations of models and their
     hyperparameters.
    :vartype search_space:
     list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsObjectDetection]
    :ivar log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
     "Info", "Warning", "Error", "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar target_column_name: Target column name: This is prediction values column.
     Also known as label column name in context of classification tasks.
    :vartype target_column_name: str
    :ivar task_type: Required. [Required] Task type for AutoMLJob.Constant filled by server.
     Possible values include: "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    :ivar training_data: Required. [Required] Training data input.
    :vartype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar primary_metric: Primary metric to optimize for this task. Possible values include:
     "MeanAveragePrecision".
    :vartype primary_metric: str or
     ~azure.mgmt.machinelearningservices.models.ObjectDetectionPrimaryMetrics
    """

    _validation = {
        'limit_settings': {'required': True},
        'task_type': {'required': True},
        'training_data': {'required': True},
    }

    _attribute_map = {
        'limit_settings': {'key': 'limitSettings', 'type': 'ImageLimitSettings'},
        'sweep_settings': {'key': 'sweepSettings', 'type': 'ImageSweepSettings'},
        'validation_data': {'key': 'validationData', 'type': 'MLTableJobInput'},
        'validation_data_size': {'key': 'validationDataSize', 'type': 'float'},
        'model_settings': {'key': 'modelSettings', 'type': 'ImageModelSettingsObjectDetection'},
        'search_space': {'key': 'searchSpace', 'type': '[ImageModelDistributionSettingsObjectDetection]'},
        'log_verbosity': {'key': 'logVerbosity', 'type': 'str'},
        'target_column_name': {'key': 'targetColumnName', 'type': 'str'},
        'task_type': {'key': 'taskType', 'type': 'str'},
        'training_data': {'key': 'trainingData', 'type': 'MLTableJobInput'},
        'primary_metric': {'key': 'primaryMetric', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        limit_settings: "ImageLimitSettings",
        training_data: "MLTableJobInput",
        sweep_settings: Optional["ImageSweepSettings"] = None,
        validation_data: Optional["MLTableJobInput"] = None,
        validation_data_size: Optional[float] = None,
        model_settings: Optional["ImageModelSettingsObjectDetection"] = None,
        search_space: Optional[List["ImageModelDistributionSettingsObjectDetection"]] = None,
        log_verbosity: Optional[Union[str, "LogVerbosity"]] = None,
        target_column_name: Optional[str] = None,
        primary_metric: Optional[Union[str, "ObjectDetectionPrimaryMetrics"]] = None,
        **kwargs
    ):
        """
        :keyword limit_settings: Required. [Required] Limit settings for the AutoML job.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
        :keyword sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        :keyword model_settings: Settings used for training the model.
        :paramtype model_settings:
         ~azure.mgmt.machinelearningservices.models.ImageModelSettingsObjectDetection
        :keyword search_space: Search space for sampling different combinations of models and their
         hyperparameters.
        :paramtype search_space:
         list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsObjectDetection]
        :keyword log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
         "Info", "Warning", "Error", "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        :keyword target_column_name: Target column name: This is prediction values column.
         Also known as label column name in context of classification tasks.
        :paramtype target_column_name: str
        :keyword training_data: Required. [Required] Training data input.
        :paramtype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword primary_metric: Primary metric to optimize for this task. Possible values include:
         "MeanAveragePrecision".
        :paramtype primary_metric: str or
         ~azure.mgmt.machinelearningservices.models.ObjectDetectionPrimaryMetrics
        """
        super(ImageObjectDetection, self).__init__(log_verbosity=log_verbosity, target_column_name=target_column_name, training_data=training_data, limit_settings=limit_settings, sweep_settings=sweep_settings, validation_data=validation_data, validation_data_size=validation_data_size, model_settings=model_settings, search_space=search_space, **kwargs)
        self.limit_settings = limit_settings
        self.sweep_settings = sweep_settings
        self.validation_data = validation_data
        self.validation_data_size = validation_data_size
        self.model_settings = model_settings
        self.search_space = search_space
        self.task_type = 'ImageObjectDetection'  # type: str
        self.primary_metric = primary_metric
        self.log_verbosity = log_verbosity
        self.target_column_name = target_column_name
        self.training_data = training_data


class ImageSweepSettings(msrest.serialization.Model):
    """Model sweeping and hyperparameter sweeping related settings.

    All required parameters must be populated in order to send to Azure.

    :ivar early_termination: Type of early termination policy.
    :vartype early_termination: ~azure.mgmt.machinelearningservices.models.EarlyTerminationPolicy
    :ivar sampling_algorithm: Required. [Required] Type of the hyperparameter sampling algorithms.
     Possible values include: "Grid", "Random", "Bayesian".
    :vartype sampling_algorithm: str or
     ~azure.mgmt.machinelearningservices.models.SamplingAlgorithmType
    """

    _validation = {
        'sampling_algorithm': {'required': True},
    }

    _attribute_map = {
        'early_termination': {'key': 'earlyTermination', 'type': 'EarlyTerminationPolicy'},
        'sampling_algorithm': {'key': 'samplingAlgorithm', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        sampling_algorithm: Union[str, "SamplingAlgorithmType"],
        early_termination: Optional["EarlyTerminationPolicy"] = None,
        **kwargs
    ):
        """
        :keyword early_termination: Type of early termination policy.
        :paramtype early_termination: ~azure.mgmt.machinelearningservices.models.EarlyTerminationPolicy
        :keyword sampling_algorithm: Required. [Required] Type of the hyperparameter sampling
         algorithms. Possible values include: "Grid", "Random", "Bayesian".
        :paramtype sampling_algorithm: str or
         ~azure.mgmt.machinelearningservices.models.SamplingAlgorithmType
        """
        super(ImageSweepSettings, self).__init__(**kwargs)
        self.early_termination = early_termination
        self.sampling_algorithm = sampling_algorithm


class ImportDataAction(ScheduleActionBase):
    """ImportDataAction.

    All required parameters must be populated in order to send to Azure.

    :ivar action_type: Required. [Required] Specifies the action type of the schedule.Constant
     filled by server. Possible values include: "CreateJob", "InvokeBatchEndpoint", "ImportData",
     "CreateMonitor".
    :vartype action_type: str or ~azure.mgmt.machinelearningservices.models.ScheduleActionType
    :ivar data_import_definition: Required. [Required] Defines Schedule action definition details.
    :vartype data_import_definition: ~azure.mgmt.machinelearningservices.models.DataImport
    """

    _validation = {
        'action_type': {'required': True},
        'data_import_definition': {'required': True},
    }

    _attribute_map = {
        'action_type': {'key': 'actionType', 'type': 'str'},
        'data_import_definition': {'key': 'dataImportDefinition', 'type': 'DataImport'},
    }

    def __init__(
        self,
        *,
        data_import_definition: "DataImport",
        **kwargs
    ):
        """
        :keyword data_import_definition: Required. [Required] Defines Schedule action definition
         details.
        :paramtype data_import_definition: ~azure.mgmt.machinelearningservices.models.DataImport
        """
        super(ImportDataAction, self).__init__(**kwargs)
        self.action_type = 'ImportData'  # type: str
        self.data_import_definition = data_import_definition


class IndexColumn(msrest.serialization.Model):
    """Dto object representing index column.

    :ivar column_name: Specifies the column name.
    :vartype column_name: str
    :ivar data_type: Specifies the data type. Possible values include: "String", "Integer", "Long",
     "Float", "Double", "Binary", "Datetime", "Boolean".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.FeatureDataType
    """

    _attribute_map = {
        'column_name': {'key': 'columnName', 'type': 'str'},
        'data_type': {'key': 'dataType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        column_name: Optional[str] = None,
        data_type: Optional[Union[str, "FeatureDataType"]] = None,
        **kwargs
    ):
        """
        :keyword column_name: Specifies the column name.
        :paramtype column_name: str
        :keyword data_type: Specifies the data type. Possible values include: "String", "Integer",
         "Long", "Float", "Double", "Binary", "Datetime", "Boolean".
        :paramtype data_type: str or ~azure.mgmt.machinelearningservices.models.FeatureDataType
        """
        super(IndexColumn, self).__init__(**kwargs)
        self.column_name = column_name
        self.data_type = data_type


class InferenceContainerProperties(msrest.serialization.Model):
    """InferenceContainerProperties.

    :ivar liveness_route: The route to check the liveness of the inference server container.
    :vartype liveness_route: ~azure.mgmt.machinelearningservices.models.Route
    :ivar readiness_route: The route to check the readiness of the inference server container.
    :vartype readiness_route: ~azure.mgmt.machinelearningservices.models.Route
    :ivar scoring_route: The port to send the scoring requests to, within the inference server
     container.
    :vartype scoring_route: ~azure.mgmt.machinelearningservices.models.Route
    """

    _attribute_map = {
        'liveness_route': {'key': 'livenessRoute', 'type': 'Route'},
        'readiness_route': {'key': 'readinessRoute', 'type': 'Route'},
        'scoring_route': {'key': 'scoringRoute', 'type': 'Route'},
    }

    def __init__(
        self,
        *,
        liveness_route: Optional["Route"] = None,
        readiness_route: Optional["Route"] = None,
        scoring_route: Optional["Route"] = None,
        **kwargs
    ):
        """
        :keyword liveness_route: The route to check the liveness of the inference server container.
        :paramtype liveness_route: ~azure.mgmt.machinelearningservices.models.Route
        :keyword readiness_route: The route to check the readiness of the inference server container.
        :paramtype readiness_route: ~azure.mgmt.machinelearningservices.models.Route
        :keyword scoring_route: The port to send the scoring requests to, within the inference server
         container.
        :paramtype scoring_route: ~azure.mgmt.machinelearningservices.models.Route
        """
        super(InferenceContainerProperties, self).__init__(**kwargs)
        self.liveness_route = liveness_route
        self.readiness_route = readiness_route
        self.scoring_route = scoring_route


class InferenceEndpoint(TrackedResource):
    """InferenceEndpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type.
    :vartype kind: str
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.InferenceEndpointProperties
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'InferenceEndpointProperties'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "InferenceEndpointProperties",
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["ManagedServiceIdentity"] = None,
        kind: Optional[str] = None,
        sku: Optional["Sku"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type.
        :paramtype kind: str
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.InferenceEndpointProperties
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        """
        super(InferenceEndpoint, self).__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.kind = kind
        self.properties = properties
        self.sku = sku


class PropertiesBase(msrest.serialization.Model):
    """Base definition for pool resources.

    :ivar description: Description of the resource.
    :vartype description: str
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword description: Description of the resource.
        :paramtype description: str
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        """
        super(PropertiesBase, self).__init__(**kwargs)
        self.description = description
        self.properties = properties


class InferenceEndpointProperties(PropertiesBase):
    """InferenceEndpoint configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: Description of the resource.
    :vartype description: str
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar auth_mode: Required. [Required] Authentication mode for the endpoint. Possible values
     include: "AAD".
    :vartype auth_mode: str or ~azure.mgmt.machinelearningservices.models.AuthMode
    :ivar endpoint_uri: Endpoint URI for the inference endpoint.
    :vartype endpoint_uri: str
    :ivar group_id: Required. [Required] Group within the same pool with which this endpoint needs
     to be associated with.
    :vartype group_id: str
    :ivar provisioning_state: Provisioning state for the endpoint. Possible values include:
     "Creating", "Deleting", "Succeeded", "Failed", "Updating", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.PoolProvisioningState
    """

    _validation = {
        'auth_mode': {'required': True},
        'endpoint_uri': {'readonly': True},
        'group_id': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'auth_mode': {'key': 'authMode', 'type': 'str'},
        'endpoint_uri': {'key': 'endpointUri', 'type': 'str'},
        'group_id': {'key': 'groupId', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        auth_mode: Union[str, "AuthMode"],
        group_id: str,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword description: Description of the resource.
        :paramtype description: str
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword auth_mode: Required. [Required] Authentication mode for the endpoint. Possible values
         include: "AAD".
        :paramtype auth_mode: str or ~azure.mgmt.machinelearningservices.models.AuthMode
        :keyword group_id: Required. [Required] Group within the same pool with which this endpoint
         needs to be associated with.
        :paramtype group_id: str
        """
        super(InferenceEndpointProperties, self).__init__(description=description, properties=properties, **kwargs)
        self.auth_mode = auth_mode
        self.endpoint_uri = None
        self.group_id = group_id
        self.provisioning_state = None


class InferenceEndpointTrackedResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of InferenceEndpoint entities.

    :ivar next_link: The link to the next page of InferenceEndpoint objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type InferenceEndpoint.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.InferenceEndpoint]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[InferenceEndpoint]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["InferenceEndpoint"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of InferenceEndpoint objects. If null, there are
         no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type InferenceEndpoint.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.InferenceEndpoint]
        """
        super(InferenceEndpointTrackedResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class InferenceGroup(TrackedResource):
    """InferenceGroup.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type.
    :vartype kind: str
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.InferenceGroupProperties
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'InferenceGroupProperties'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "InferenceGroupProperties",
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["ManagedServiceIdentity"] = None,
        kind: Optional[str] = None,
        sku: Optional["Sku"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type.
        :paramtype kind: str
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.InferenceGroupProperties
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        """
        super(InferenceGroup, self).__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.kind = kind
        self.properties = properties
        self.sku = sku


class InferenceGroupProperties(PropertiesBase):
    """Inference group configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: Description of the resource.
    :vartype description: str
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar bonus_extra_capacity: Capacity to be used from the pool's reserved capacity.
     optional.
    :vartype bonus_extra_capacity: int
    :ivar metadata: Metadata for the inference group.
    :vartype metadata: str
    :ivar priority: Priority of the group within the
     N:Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20240101Preview.Pools.InferencePools.
    :vartype priority: int
    :ivar provisioning_state: Provisioning state for the inference group. Possible values include:
     "Creating", "Deleting", "Succeeded", "Failed", "Updating", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.PoolProvisioningState
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'bonus_extra_capacity': {'key': 'bonusExtraCapacity', 'type': 'int'},
        'metadata': {'key': 'metadata', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        bonus_extra_capacity: Optional[int] = 0,
        metadata: Optional[str] = None,
        priority: Optional[int] = 0,
        **kwargs
    ):
        """
        :keyword description: Description of the resource.
        :paramtype description: str
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword bonus_extra_capacity: Capacity to be used from the pool's reserved capacity.
         optional.
        :paramtype bonus_extra_capacity: int
        :keyword metadata: Metadata for the inference group.
        :paramtype metadata: str
        :keyword priority: Priority of the group within the
         N:Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20240101Preview.Pools.InferencePools.
        :paramtype priority: int
        """
        super(InferenceGroupProperties, self).__init__(description=description, properties=properties, **kwargs)
        self.bonus_extra_capacity = bonus_extra_capacity
        self.metadata = metadata
        self.priority = priority
        self.provisioning_state = None


class InferenceGroupTrackedResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of InferenceGroup entities.

    :ivar next_link: The link to the next page of InferenceGroup objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type InferenceGroup.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.InferenceGroup]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[InferenceGroup]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["InferenceGroup"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of InferenceGroup objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type InferenceGroup.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.InferenceGroup]
        """
        super(InferenceGroupTrackedResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class InferencePool(TrackedResource):
    """InferencePool.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type.
    :vartype kind: str
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.InferencePoolProperties
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'InferencePoolProperties'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "InferencePoolProperties",
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["ManagedServiceIdentity"] = None,
        kind: Optional[str] = None,
        sku: Optional["Sku"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type.
        :paramtype kind: str
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.InferencePoolProperties
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        """
        super(InferencePool, self).__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.kind = kind
        self.properties = properties
        self.sku = sku


class InferencePoolProperties(PropertiesBase):
    """Inference pool configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: Description of the resource.
    :vartype description: str
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar code_configuration: Code configuration for the inference pool.
    :vartype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
    :ivar environment_configuration: EnvironmentConfiguration for the inference pool.
    :vartype environment_configuration:
     ~azure.mgmt.machinelearningservices.models.PoolEnvironmentConfiguration
    :ivar model_configuration: ModelConfiguration for the inference pool.
    :vartype model_configuration: ~azure.mgmt.machinelearningservices.models.PoolModelConfiguration
    :ivar node_sku_type: Required. [Required] Compute instance type.
    :vartype node_sku_type: str
    :ivar provisioning_state: Provisioning state for the pool. Possible values include: "Creating",
     "Deleting", "Succeeded", "Failed", "Updating", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.PoolProvisioningState
    :ivar request_configuration: Request configuration for the inference pool.
    :vartype request_configuration: ~azure.mgmt.machinelearningservices.models.RequestConfiguration
    """

    _validation = {
        'node_sku_type': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'code_configuration': {'key': 'codeConfiguration', 'type': 'CodeConfiguration'},
        'environment_configuration': {'key': 'environmentConfiguration', 'type': 'PoolEnvironmentConfiguration'},
        'model_configuration': {'key': 'modelConfiguration', 'type': 'PoolModelConfiguration'},
        'node_sku_type': {'key': 'nodeSkuType', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'request_configuration': {'key': 'requestConfiguration', 'type': 'RequestConfiguration'},
    }

    def __init__(
        self,
        *,
        node_sku_type: str,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        code_configuration: Optional["CodeConfiguration"] = None,
        environment_configuration: Optional["PoolEnvironmentConfiguration"] = None,
        model_configuration: Optional["PoolModelConfiguration"] = None,
        request_configuration: Optional["RequestConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword description: Description of the resource.
        :paramtype description: str
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword code_configuration: Code configuration for the inference pool.
        :paramtype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
        :keyword environment_configuration: EnvironmentConfiguration for the inference pool.
        :paramtype environment_configuration:
         ~azure.mgmt.machinelearningservices.models.PoolEnvironmentConfiguration
        :keyword model_configuration: ModelConfiguration for the inference pool.
        :paramtype model_configuration:
         ~azure.mgmt.machinelearningservices.models.PoolModelConfiguration
        :keyword node_sku_type: Required. [Required] Compute instance type.
        :paramtype node_sku_type: str
        :keyword request_configuration: Request configuration for the inference pool.
        :paramtype request_configuration:
         ~azure.mgmt.machinelearningservices.models.RequestConfiguration
        """
        super(InferencePoolProperties, self).__init__(description=description, properties=properties, **kwargs)
        self.code_configuration = code_configuration
        self.environment_configuration = environment_configuration
        self.model_configuration = model_configuration
        self.node_sku_type = node_sku_type
        self.provisioning_state = None
        self.request_configuration = request_configuration


class InferencePoolTrackedResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of InferencePool entities.

    :ivar next_link: The link to the next page of InferencePool objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type InferencePool.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.InferencePool]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[InferencePool]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["InferencePool"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of InferencePool objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type InferencePool.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.InferencePool]
        """
        super(InferencePoolTrackedResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class InstanceTypeSchema(msrest.serialization.Model):
    """Instance type schema.

    :ivar node_selector: Node Selector.
    :vartype node_selector: dict[str, str]
    :ivar resources: Resource requests/limits for this instance type.
    :vartype resources: ~azure.mgmt.machinelearningservices.models.InstanceTypeSchemaResources
    """

    _attribute_map = {
        'node_selector': {'key': 'nodeSelector', 'type': '{str}'},
        'resources': {'key': 'resources', 'type': 'InstanceTypeSchemaResources'},
    }

    def __init__(
        self,
        *,
        node_selector: Optional[Dict[str, str]] = None,
        resources: Optional["InstanceTypeSchemaResources"] = None,
        **kwargs
    ):
        """
        :keyword node_selector: Node Selector.
        :paramtype node_selector: dict[str, str]
        :keyword resources: Resource requests/limits for this instance type.
        :paramtype resources: ~azure.mgmt.machinelearningservices.models.InstanceTypeSchemaResources
        """
        super(InstanceTypeSchema, self).__init__(**kwargs)
        self.node_selector = node_selector
        self.resources = resources


class InstanceTypeSchemaResources(msrest.serialization.Model):
    """Resource requests/limits for this instance type.

    :ivar requests: Resource requests for this instance type.
    :vartype requests: dict[str, str]
    :ivar limits: Resource limits for this instance type.
    :vartype limits: dict[str, str]
    """

    _attribute_map = {
        'requests': {'key': 'requests', 'type': '{str}'},
        'limits': {'key': 'limits', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        requests: Optional[Dict[str, str]] = None,
        limits: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword requests: Resource requests for this instance type.
        :paramtype requests: dict[str, str]
        :keyword limits: Resource limits for this instance type.
        :paramtype limits: dict[str, str]
        """
        super(InstanceTypeSchemaResources, self).__init__(**kwargs)
        self.requests = requests
        self.limits = limits


class IntellectualProperty(msrest.serialization.Model):
    """Intellectual Property details for a resource.

    All required parameters must be populated in order to send to Azure.

    :ivar protection_level: Protection level of the Intellectual Property. Possible values include:
     "All", "None".
    :vartype protection_level: str or ~azure.mgmt.machinelearningservices.models.ProtectionLevel
    :ivar publisher: Required. [Required] Publisher of the Intellectual Property. Must be the same
     as Registry publisher name.
    :vartype publisher: str
    """

    _validation = {
        'publisher': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'protection_level': {'key': 'protectionLevel', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        publisher: str,
        protection_level: Optional[Union[str, "ProtectionLevel"]] = None,
        **kwargs
    ):
        """
        :keyword protection_level: Protection level of the Intellectual Property. Possible values
         include: "All", "None".
        :paramtype protection_level: str or ~azure.mgmt.machinelearningservices.models.ProtectionLevel
        :keyword publisher: Required. [Required] Publisher of the Intellectual Property. Must be the
         same as Registry publisher name.
        :paramtype publisher: str
        """
        super(IntellectualProperty, self).__init__(**kwargs)
        self.protection_level = protection_level
        self.publisher = publisher


class JobBase(ProxyResource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.JobBaseProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'JobBaseProperties'},
    }

    def __init__(
        self,
        *,
        properties: "JobBaseProperties",
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.JobBaseProperties
        """
        super(JobBase, self).__init__(**kwargs)
        self.properties = properties


class JobBaseResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of JobBase entities.

    :ivar next_link: The link to the next page of JobBase objects. If null, there are no additional
     pages.
    :vartype next_link: str
    :ivar value: An array of objects of type JobBase.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.JobBase]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[JobBase]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["JobBase"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of JobBase objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type JobBase.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.JobBase]
        """
        super(JobBaseResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class JobResourceConfiguration(ResourceConfiguration):
    """JobResourceConfiguration.

    :ivar instance_count: Optional number of instances or nodes used by the compute target.
    :vartype instance_count: int
    :ivar instance_type: Optional type of VM used as supported by the compute target.
    :vartype instance_type: str
    :ivar locations: Locations where the job can run.
    :vartype locations: list[str]
    :ivar max_instance_count: Optional max allowed number of instances or nodes to be used by the
     compute target.
     For use with elastic training, currently supported by PyTorch distribution type only.
    :vartype max_instance_count: int
    :ivar properties: Additional properties bag.
    :vartype properties: dict[str, any]
    :ivar docker_args: Extra arguments to pass to the Docker run command. This would override any
     parameters that have already been set by the system, or in this section. This parameter is only
     supported for Azure ML compute types.
    :vartype docker_args: str
    :ivar shm_size: Size of the docker container's shared memory block. This should be in the
     format of (number)(unit) where number as to be greater than 0 and the unit can be one of
     b(bytes), k(kilobytes), m(megabytes), or g(gigabytes).
    :vartype shm_size: str
    """

    _validation = {
        'shm_size': {'pattern': r'\d+[bBkKmMgG]'},
    }

    _attribute_map = {
        'instance_count': {'key': 'instanceCount', 'type': 'int'},
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'max_instance_count': {'key': 'maxInstanceCount', 'type': 'int'},
        'properties': {'key': 'properties', 'type': '{object}'},
        'docker_args': {'key': 'dockerArgs', 'type': 'str'},
        'shm_size': {'key': 'shmSize', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        instance_count: Optional[int] = 1,
        instance_type: Optional[str] = None,
        locations: Optional[List[str]] = None,
        max_instance_count: Optional[int] = None,
        properties: Optional[Dict[str, Any]] = None,
        docker_args: Optional[str] = None,
        shm_size: Optional[str] = "2g",
        **kwargs
    ):
        """
        :keyword instance_count: Optional number of instances or nodes used by the compute target.
        :paramtype instance_count: int
        :keyword instance_type: Optional type of VM used as supported by the compute target.
        :paramtype instance_type: str
        :keyword locations: Locations where the job can run.
        :paramtype locations: list[str]
        :keyword max_instance_count: Optional max allowed number of instances or nodes to be used by
         the compute target.
         For use with elastic training, currently supported by PyTorch distribution type only.
        :paramtype max_instance_count: int
        :keyword properties: Additional properties bag.
        :paramtype properties: dict[str, any]
        :keyword docker_args: Extra arguments to pass to the Docker run command. This would override
         any parameters that have already been set by the system, or in this section. This parameter is
         only supported for Azure ML compute types.
        :paramtype docker_args: str
        :keyword shm_size: Size of the docker container's shared memory block. This should be in the
         format of (number)(unit) where number as to be greater than 0 and the unit can be one of
         b(bytes), k(kilobytes), m(megabytes), or g(gigabytes).
        :paramtype shm_size: str
        """
        super(JobResourceConfiguration, self).__init__(instance_count=instance_count, instance_type=instance_type, locations=locations, max_instance_count=max_instance_count, properties=properties, **kwargs)
        self.docker_args = docker_args
        self.shm_size = shm_size


class JobScheduleAction(ScheduleActionBase):
    """JobScheduleAction.

    All required parameters must be populated in order to send to Azure.

    :ivar action_type: Required. [Required] Specifies the action type of the schedule.Constant
     filled by server. Possible values include: "CreateJob", "InvokeBatchEndpoint", "ImportData",
     "CreateMonitor".
    :vartype action_type: str or ~azure.mgmt.machinelearningservices.models.ScheduleActionType
    :ivar job_definition: Required. [Required] Defines Schedule action definition details.
    :v