# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.kusto import KustoManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-kusto
# USAGE
    python kusto_database_invite_follower.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = KustoManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="12345678-1234-1234-1234-123456789098",
    )

    response = client.database.invite_follower(
        resource_group_name="kustorptest",
        cluster_name="kustoCluster",
        database_name="database",
        parameters={
            "inviteeEmail": "invitee@contoso.com",
            "tableLevelSharingProperties": {
                "externalTablesToExclude": [],
                "externalTablesToInclude": ["ExternalTable*"],
                "functionsToExclude": ["functionsToExclude2"],
                "functionsToInclude": ["functionsToInclude1"],
                "materializedViewsToExclude": ["MaterializedViewTable2"],
                "materializedViewsToInclude": ["MaterializedViewTable1"],
                "tablesToExclude": ["Table2"],
                "tablesToInclude": ["Table1"],
            },
        },
    )
    print(response)


# x-ms-original-file: specification/azure-kusto/resource-manager/Microsoft.Kusto/stable/2023-08-15/examples/KustoDatabaseInviteFollower.json
if __name__ == "__main__":
    main()
