# coding=utf-8
# pylint: disable=too-many-lines, line-too-long, too-many-locals
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_discriminator, rest_field
from ._enums import RadiologyInsightsInferenceType

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class RadiologyInsightsInference(_model_base.Model):
    """An inference made by the Radiology Insights model regarding a patient.


    * AgeMismatch
    * SexMismatch
    * LateralityDiscrepancy
    * CompleteOrderDiscrepancy
    * LimitedOrderDiscrepancy
    * Finding
    * CriticalResult
    * FollowupRecommendation
    * RadiologyProcedure
    * FollowupCommunication.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AgeMismatchInference, CompleteOrderDiscrepancyInference, CriticalResultInference,
    FindingInference, FollowupCommunicationInference, FollowupRecommendationInference,
    LateralityDiscrepancyInference, LimitedOrderDiscrepancyInference, RadiologyProcedureInference,
    SexMismatchInference

    All required parameters must be populated in order to send to server.

    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar kind: Required. Known values are: "ageMismatch", "lateralityDiscrepancy", "sexMismatch",
     "completeOrderDiscrepancy", "limitedOrderDiscrepancy", "finding", "criticalResult",
     "followupRecommendation", "followupCommunication", and "radiologyProcedure".
    :vartype kind: str or
     ~azure.healthinsights.radiologyinsights.models.RadiologyInsightsInferenceType
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    extension: Optional[List["_models.Extension"]] = rest_field()
    """Additional Content defined by implementations."""
    kind: str = rest_discriminator(name="kind")
    """Required. Known values are: \"ageMismatch\", \"lateralityDiscrepancy\", \"sexMismatch\",
     \"completeOrderDiscrepancy\", \"limitedOrderDiscrepancy\", \"finding\", \"criticalResult\",
     \"followupRecommendation\", \"followupCommunication\", and \"radiologyProcedure\"."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
        extension: Optional[List["_models.Extension"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AgeMismatchInference(RadiologyInsightsInference, discriminator="ageMismatch"):
    """A notification for age mismatch is displayed when the age mentioned in a document for a
    specific patient does not match the age specified in the patient information.

    All required parameters must be populated in order to send to server.

    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar kind: Inference type. Required. Age mismatch inference type
    :vartype kind: str or ~azure.healthinsights.radiologyinsights.models.AGE_MISMATCH
    """

    kind: Literal[RadiologyInsightsInferenceType.AGE_MISMATCH] = rest_discriminator(name="kind")  # type: ignore
    """Inference type. Required. Age mismatch inference type"""

    @overload
    def __init__(
        self,
        *,
        extension: Optional[List["_models.Extension"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=RadiologyInsightsInferenceType.AGE_MISMATCH, **kwargs)


class Element(_model_base.Model):
    """The base definition for all elements contained inside a resource.
    Based on `FHIR Element <https://www.hl7.org/fhir/R4/element.html>`_.

    :ivar id: Unique id for inter-element referencing.
    :vartype id: str
    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    """

    id: Optional[str] = rest_field()
    """Unique id for inter-element referencing."""
    extension: Optional[List["_models.Extension"]] = rest_field()
    """Additional Content defined by implementations."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        extension: Optional[List["_models.Extension"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Annotation(Element):
    """A text note which also  contains information about who made the statement and when
    Based on `FHIR Annotation <https://www.hl7.org/fhir/R4/datatypes.html#Annotation>`_.

    All required parameters must be populated in order to send to server.

    :ivar id: Unique id for inter-element referencing.
    :vartype id: str
    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar author_string: Individual responsible for the annotation.
    :vartype author_string: str
    :ivar time: When the annotation was made.
    :vartype time: str
    :ivar text: The annotation - text content (as markdown). Required.
    :vartype text: str
    """

    author_string: Optional[str] = rest_field(name="authorString")
    """Individual responsible for the annotation."""
    time: Optional[str] = rest_field()
    """When the annotation was made."""
    text: str = rest_field()
    """The annotation - text content (as markdown). Required."""

    @overload
    def __init__(
        self,
        *,
        text: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        extension: Optional[List["_models.Extension"]] = None,
        author_string: Optional[str] = None,
        time: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class CodeableConcept(Element):
    """Concept - reference to a terminology or just text
    Based on `FHIR CodeableConcept <https://www.hl7.org/fhir/R4/datatypes.html#CodeableConcept>`_.

    :ivar coding: Code defined by a terminology system.
    :vartype coding: list[~azure.healthinsights.radiologyinsights.models.Coding]
    :ivar text: Plain text representation of the concept.
    :vartype text: str
    """

    coding: Optional[List["_models.Coding"]] = rest_field()
    """Code defined by a terminology system."""
    text: Optional[str] = rest_field()
    """Plain text representation of the concept."""

    @overload
    def __init__(
        self,
        *,
        coding: Optional[List["_models.Coding"]] = None,
        text: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Coding(Element):
    """A Coding is a representation of a defined concept using a symbol from a defined "code system".
    Based on `FHIR Coding <https://www.hl7.org/fhir/R4/datatypes.html#Coding>`_.

    :ivar id: Unique id for inter-element referencing.
    :vartype id: str
    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar system: Identity of the terminology system.
    :vartype system: str
    :ivar version: Version of the system - if relevant.
    :vartype version: str
    :ivar code: Symbol in syntax defined by the system.
    :vartype code: str
    :ivar display: Representation defined by the system.
    :vartype display: str
    """

    system: Optional[str] = rest_field()
    """Identity of the terminology system."""
    version: Optional[str] = rest_field()
    """Version of the system - if relevant."""
    code: Optional[str] = rest_field()
    """Symbol in syntax defined by the system."""
    display: Optional[str] = rest_field()
    """Representation defined by the system."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        extension: Optional[List["_models.Extension"]] = None,
        system: Optional[str] = None,
        version: Optional[str] = None,
        code: Optional[str] = None,
        display: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class CompleteOrderDiscrepancyInference(RadiologyInsightsInference, discriminator="completeOrderDiscrepancy"):
    """A complete order discrepancy is shown when one or more body parts and/or measurements that
    should be in the document (because there is a complete order) are not present.

    All required parameters must be populated in order to send to server.

    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar kind: Inference type. Required. Complete order discrepancy inference type
    :vartype kind: str or ~azure.healthinsights.radiologyinsights.models.COMPLETE_ORDER_DISCREPANCY
    :ivar order_type: Order type : CPT ultrasound complete code for abdomen, retroperitoneal,
     pelvis or breast. Required.
    :vartype order_type: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar missing_body_parts: List of missing body parts required by a complete order : SNOMED CT
     codes.
    :vartype missing_body_parts:
     list[~azure.healthinsights.radiologyinsights.models.CodeableConcept]
    :ivar missing_body_part_measurements: List of missing body parts that require measurement by a
     complete order : SNOMED CT codes.
    :vartype missing_body_part_measurements:
     list[~azure.healthinsights.radiologyinsights.models.CodeableConcept]
    """

    kind: Literal[RadiologyInsightsInferenceType.COMPLETE_ORDER_DISCREPANCY] = rest_discriminator(name="kind")  # type: ignore
    """Inference type. Required. Complete order discrepancy inference type"""
    order_type: "_models.CodeableConcept" = rest_field(name="orderType")
    """Order type : CPT ultrasound complete code for abdomen, retroperitoneal, pelvis or breast.
     Required."""
    missing_body_parts: Optional[List["_models.CodeableConcept"]] = rest_field(name="missingBodyParts")
    """List of missing body parts required by a complete order : SNOMED CT codes."""
    missing_body_part_measurements: Optional[List["_models.CodeableConcept"]] = rest_field(
        name="missingBodyPartMeasurements"
    )
    """List of missing body parts that require measurement by a complete order : SNOMED CT codes."""

    @overload
    def __init__(
        self,
        *,
        order_type: "_models.CodeableConcept",
        extension: Optional[List["_models.Extension"]] = None,
        missing_body_parts: Optional[List["_models.CodeableConcept"]] = None,
        missing_body_part_measurements: Optional[List["_models.CodeableConcept"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=RadiologyInsightsInferenceType.COMPLETE_ORDER_DISCREPANCY, **kwargs)


class Resource(_model_base.Model):
    """Resource is the ancestor of DomainResource from which most resources are derived. Bundle,
    Parameters, and Binary extend Resource directly.
    Based on [FHIR Resource](https://www.hl7.org/fhir/r4/resource.html.

    All required parameters must be populated in order to send to server.

    :ivar resource_type: The type of resource. Required.
    :vartype resource_type: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar meta: Metadata about the resource.
    :vartype meta: ~azure.healthinsights.radiologyinsights.models.Meta
    :ivar implicit_rules: A set of rules under which this content was created.
    :vartype implicit_rules: str
    :ivar language: Language of the resource content.
    :vartype language: str
    """

    resource_type: str = rest_field(name="resourceType")
    """The type of resource. Required."""
    id: Optional[str] = rest_field()
    """Resource Id."""
    meta: Optional["_models.Meta"] = rest_field()
    """Metadata about the resource."""
    implicit_rules: Optional[str] = rest_field(name="implicitRules")
    """A set of rules under which this content was created."""
    language: Optional[str] = rest_field()
    """Language of the resource content."""

    @overload
    def __init__(
        self,
        *,
        resource_type: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        meta: Optional["_models.Meta"] = None,
        implicit_rules: Optional[str] = None,
        language: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class DomainResource(Resource):
    """A resource with narrative, extensions, and contained resources
    Based on `FHIR DomainResource <https://www.hl7.org/fhir/domainresource.html>`_.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    Condition, ResearchStudy

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar meta: Metadata about the resource.
    :vartype meta: ~azure.healthinsights.radiologyinsights.models.Meta
    :ivar implicit_rules: A set of rules under which this content was created.
    :vartype implicit_rules: str
    :ivar language: Language of the resource content.
    :vartype language: str
    :ivar text: Text summary of the resource, for human interpretation.
    :vartype text: ~azure.healthinsights.radiologyinsights.models.Narrative
    :ivar contained: Contained, inline Resources.
    :vartype contained: list[~azure.healthinsights.radiologyinsights.models.Resource]
    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar modifier_extension: Extensions that cannot be ignored.
    :vartype modifier_extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar resource_type: Required. Default value is None.
    :vartype resource_type: str
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    text: Optional["_models.Narrative"] = rest_field()
    """Text summary of the resource, for human interpretation."""
    contained: Optional[List["_models.Resource"]] = rest_field()
    """Contained, inline Resources."""
    extension: Optional[List["_models.Extension"]] = rest_field()
    """Additional Content defined by implementations."""
    modifier_extension: Optional[List["_models.Extension"]] = rest_field(name="modifierExtension")
    """Extensions that cannot be ignored."""
    resource_type: str = rest_discriminator(name="resourceType")
    """Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        resource_type: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        meta: Optional["_models.Meta"] = None,
        implicit_rules: Optional[str] = None,
        language: Optional[str] = None,
        text: Optional["_models.Narrative"] = None,
        contained: Optional[List["_models.Resource"]] = None,
        extension: Optional[List["_models.Extension"]] = None,
        modifier_extension: Optional[List["_models.Extension"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Condition(DomainResource, discriminator="Condition"):  # pylint: disable=too-many-instance-attributes
    """Detailed information about conditions, problems or diagnoses
    Based on `FHIR Condition <https://www.hl7.org/fhir/R4/condition.html>`_.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar meta: Metadata about the resource.
    :vartype meta: ~azure.healthinsights.radiologyinsights.models.Meta
    :ivar implicit_rules: A set of rules under which this content was created.
    :vartype implicit_rules: str
    :ivar language: Language of the resource content.
    :vartype language: str
    :ivar text: Text summary of the resource, for human interpretation.
    :vartype text: ~azure.healthinsights.radiologyinsights.models.Narrative
    :ivar contained: Contained, inline Resources.
    :vartype contained: list[~azure.healthinsights.radiologyinsights.models.Resource]
    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar modifier_extension: Extensions that cannot be ignored.
    :vartype modifier_extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar resource_type: resourceType. Required. Default value is "Condition".
    :vartype resource_type: str
    :ivar identifier: External Ids for this condition.
    :vartype identifier: list[~azure.healthinsights.radiologyinsights.models.Identifier]
    :ivar clinical_status: active | recurrence | relapse | inactive | remission | resolved.
    :vartype clinical_status: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar verification_status: unconfirmed | provisional | differential | confirmed | refuted |
     entered-in-error.
    :vartype verification_status: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar category: problem-list-item | encounter-diagnosis.
    :vartype category: list[~azure.healthinsights.radiologyinsights.models.CodeableConcept]
    :ivar severity: Subjective severity of condition.
    :vartype severity: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar code: Identification of the condition, problem or diagnosis.
    :vartype code: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar body_site: Anatomical location, if relevant.
    :vartype body_site: list[~azure.healthinsights.radiologyinsights.models.CodeableConcept]
    :ivar encounter: Encounter created as part of.
    :vartype encounter: ~azure.healthinsights.radiologyinsights.models.Reference
    :ivar onset_date_time: Estimated or actual date,  date-time, or age.
    :vartype onset_date_time: str
    :ivar onset_age: Estimated or actual date,  date-time, or age.
    :vartype onset_age: ~azure.healthinsights.radiologyinsights.models.Quantity
    :ivar onset_period: Estimated or actual date,  date-time, or age.
    :vartype onset_period: ~azure.healthinsights.radiologyinsights.models.Period
    :ivar onset_range: Estimated or actual date,  date-time, or age.
    :vartype onset_range: ~azure.healthinsights.radiologyinsights.models.Range
    :ivar onset_string: Estimated or actual date,  date-time, or age.
    :vartype onset_string: str
    :ivar abatement_date_time: When in resolution/remission.
    :vartype abatement_date_time: str
    :ivar abatement_age: When in resolution/remission.
    :vartype abatement_age: ~azure.healthinsights.radiologyinsights.models.Quantity
    :ivar abatement_period: When in resolution/remission.
    :vartype abatement_period: ~azure.healthinsights.radiologyinsights.models.Period
    :ivar abatement_range: When in resolution/remission.
    :vartype abatement_range: ~azure.healthinsights.radiologyinsights.models.Range
    :ivar abatement_string: When in resolution/remission.
    :vartype abatement_string: str
    :ivar recorded_date: Date record was first recorded.
    :vartype recorded_date: str
    :ivar stage: stge/grade, usually assessed formally.
    :vartype stage: list[~azure.healthinsights.radiologyinsights.models.ConditionStage]
    :ivar note: Additional information about the Condition.
    :vartype note: list[~azure.healthinsights.radiologyinsights.models.Annotation]
    """

    resource_type: Literal["Condition"] = rest_discriminator(name="resourceType")  # type: ignore
    """resourceType. Required. Default value is \"Condition\"."""
    identifier: Optional[List["_models.Identifier"]] = rest_field()
    """External Ids for this condition."""
    clinical_status: Optional["_models.CodeableConcept"] = rest_field(name="clinicalStatus")
    """active | recurrence | relapse | inactive | remission | resolved."""
    verification_status: Optional["_models.CodeableConcept"] = rest_field(name="verificationStatus")
    """unconfirmed | provisional | differential | confirmed | refuted | entered-in-error."""
    category: Optional[List["_models.CodeableConcept"]] = rest_field()
    """problem-list-item | encounter-diagnosis."""
    severity: Optional["_models.CodeableConcept"] = rest_field()
    """Subjective severity of condition."""
    code: Optional["_models.CodeableConcept"] = rest_field()
    """Identification of the condition, problem or diagnosis."""
    body_site: Optional[List["_models.CodeableConcept"]] = rest_field(name="bodySite")
    """Anatomical location, if relevant."""
    encounter: Optional["_models.Reference"] = rest_field()
    """Encounter created as part of."""
    onset_date_time: Optional[str] = rest_field(name="onsetDateTime")
    """Estimated or actual date,  date-time, or age."""
    onset_age: Optional["_models.Quantity"] = rest_field(name="onsetAge")
    """Estimated or actual date,  date-time, or age."""
    onset_period: Optional["_models.Period"] = rest_field(name="onsetPeriod")
    """Estimated or actual date,  date-time, or age."""
    onset_range: Optional["_models.Range"] = rest_field(name="onsetRange")
    """Estimated or actual date,  date-time, or age."""
    onset_string: Optional[str] = rest_field(name="onsetString")
    """Estimated or actual date,  date-time, or age."""
    abatement_date_time: Optional[str] = rest_field(name="abatementDateTime")
    """When in resolution/remission."""
    abatement_age: Optional["_models.Quantity"] = rest_field(name="abatementAge")
    """When in resolution/remission."""
    abatement_period: Optional["_models.Period"] = rest_field(name="abatementPeriod")
    """When in resolution/remission."""
    abatement_range: Optional["_models.Range"] = rest_field(name="abatementRange")
    """When in resolution/remission."""
    abatement_string: Optional[str] = rest_field(name="abatementString")
    """When in resolution/remission."""
    recorded_date: Optional[str] = rest_field(name="recordedDate")
    """Date record was first recorded."""
    stage: Optional[List["_models.ConditionStage"]] = rest_field()
    """stge/grade, usually assessed formally."""
    note: Optional[List["_models.Annotation"]] = rest_field()
    """Additional information about the Condition."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        meta: Optional["_models.Meta"] = None,
        implicit_rules: Optional[str] = None,
        language: Optional[str] = None,
        text: Optional["_models.Narrative"] = None,
        contained: Optional[List["_models.Resource"]] = None,
        extension: Optional[List["_models.Extension"]] = None,
        modifier_extension: Optional[List["_models.Extension"]] = None,
        identifier: Optional[List["_models.Identifier"]] = None,
        clinical_status: Optional["_models.CodeableConcept"] = None,
        verification_status: Optional["_models.CodeableConcept"] = None,
        category: Optional[List["_models.CodeableConcept"]] = None,
        severity: Optional["_models.CodeableConcept"] = None,
        code: Optional["_models.CodeableConcept"] = None,
        body_site: Optional[List["_models.CodeableConcept"]] = None,
        encounter: Optional["_models.Reference"] = None,
        onset_date_time: Optional[str] = None,
        onset_age: Optional["_models.Quantity"] = None,
        onset_period: Optional["_models.Period"] = None,
        onset_range: Optional["_models.Range"] = None,
        onset_string: Optional[str] = None,
        abatement_date_time: Optional[str] = None,
        abatement_age: Optional["_models.Quantity"] = None,
        abatement_period: Optional["_models.Period"] = None,
        abatement_range: Optional["_models.Range"] = None,
        abatement_string: Optional[str] = None,
        recorded_date: Optional[str] = None,
        stage: Optional[List["_models.ConditionStage"]] = None,
        note: Optional[List["_models.Annotation"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, resource_type="Condition", **kwargs)


class ConditionStage(_model_base.Model):
    """Stage/grade, usually assessed formally
    Based on `FHIR Condition.Stage <https://www.hl7.org/fhir/R4/condition.html>`_.

    :ivar summary: Simple summary (disease specific).
    :vartype summary: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar type: Kind of staging.
    :vartype type: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    """

    summary: Optional["_models.CodeableConcept"] = rest_field()
    """Simple summary (disease specific)."""
    type: Optional["_models.CodeableConcept"] = rest_field()
    """Kind of staging."""

    @overload
    def __init__(
        self,
        *,
        summary: Optional["_models.CodeableConcept"] = None,
        type: Optional["_models.CodeableConcept"] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ContactDetail(Element):
    """Contact details (See: https://www.hl7.org/fhir/R4/metadatatypes.html#ContactDetail).

    :ivar id: Unique id for inter-element referencing.
    :vartype id: str
    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar name: Name of an individual to contact.
    :vartype name: str
    :ivar telecom: Contact details for individual or organization.
    :vartype telecom: list[~azure.healthinsights.radiologyinsights.models.ContactPoint]
    """

    name: Optional[str] = rest_field()
    """Name of an individual to contact."""
    telecom: Optional[List["_models.ContactPoint"]] = rest_field()
    """Contact details for individual or organization."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        extension: Optional[List["_models.Extension"]] = None,
        name: Optional[str] = None,
        telecom: Optional[List["_models.ContactPoint"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ContactPoint(_model_base.Model):
    """Details for all kinds of technology mediated contact points for a person or organization,
    including telephone, email, etc.
    See https://www.hl7.org/fhir/R4/datatypes.html#ContactPoint.

    :ivar system: phone | fax | email | pager | url | sms | other. Known values are: "phone",
     "fax", "email", "pager", "url", "sms", and "other".
    :vartype system: str or ~azure.healthinsights.radiologyinsights.models.ContactPointSystem
    :ivar value: The actual contact point details.
    :vartype value: str
    :ivar use: home | work | temp | old | mobile - purpose of this contact point. Known values are:
     "home", "work", "temp", "old", and "mobile".
    :vartype use: str or ~azure.healthinsights.radiologyinsights.models.ContactPointUse
    :ivar rank: Specify preferred order of use (1 = highest).
    :vartype rank: int
    :ivar period: Time period when the contact point was/is in use.
    :vartype period: ~azure.healthinsights.radiologyinsights.models.Period
    """

    system: Optional[Union[str, "_models.ContactPointSystem"]] = rest_field()
    """phone | fax | email | pager | url | sms | other. Known values are: \"phone\", \"fax\",
     \"email\", \"pager\", \"url\", \"sms\", and \"other\"."""
    value: Optional[str] = rest_field()
    """The actual contact point details."""
    use: Optional[Union[str, "_models.ContactPointUse"]] = rest_field()
    """home | work | temp | old | mobile - purpose of this contact point. Known values are: \"home\",
     \"work\", \"temp\", \"old\", and \"mobile\"."""
    rank: Optional[int] = rest_field()
    """Specify preferred order of use (1 = highest)."""
    period: Optional["_models.Period"] = rest_field()
    """Time period when the contact point was/is in use."""

    @overload
    def __init__(
        self,
        *,
        system: Optional[Union[str, "_models.ContactPointSystem"]] = None,
        value: Optional[str] = None,
        use: Optional[Union[str, "_models.ContactPointUse"]] = None,
        rank: Optional[int] = None,
        period: Optional["_models.Period"] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class CriticalResult(_model_base.Model):
    """Critical Result consists of two properties.

    All required parameters must be populated in order to send to server.

    :ivar description: Description : medical problem. Required.
    :vartype description: str
    :ivar finding: Finding linked to the critical result.
    :vartype finding: ~azure.healthinsights.radiologyinsights.models.Observation
    """

    description: str = rest_field()
    """Description : medical problem. Required."""
    finding: Optional["_models.Observation"] = rest_field()
    """Finding linked to the critical result."""

    @overload
    def __init__(
        self,
        *,
        description: str,
        finding: Optional["_models.Observation"] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class CriticalResultInference(RadiologyInsightsInference, discriminator="criticalResult"):
    """Critical results refer to findings of utmost importance that may require timely attention due
    to their potential impact on patient care.

    All required parameters must be populated in order to send to server.

    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar kind: Inference type. Required. Critical finding inference type
    :vartype kind: str or ~azure.healthinsights.radiologyinsights.models.CRITICAL_RESULT
    :ivar result: The complete Critical Result, as outlined below, will be reused for the
     recommendation. Required.
    :vartype result: ~azure.healthinsights.radiologyinsights.models.CriticalResult
    """

    kind: Literal[RadiologyInsightsInferenceType.CRITICAL_RESULT] = rest_discriminator(name="kind")  # type: ignore
    """Inference type. Required. Critical finding inference type"""
    result: "_models.CriticalResult" = rest_field()
    """The complete Critical Result, as outlined below, will be reused for the recommendation.
     Required."""

    @overload
    def __init__(
        self,
        *,
        result: "_models.CriticalResult",
        extension: Optional[List["_models.Extension"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=RadiologyInsightsInferenceType.CRITICAL_RESULT, **kwargs)


class DocumentAdministrativeMetadata(_model_base.Model):
    """Document administrative metadata.

    :ivar ordered_procedures: List of procedure information associated with the document.
    :vartype ordered_procedures:
     list[~azure.healthinsights.radiologyinsights.models.OrderedProcedure]
    :ivar encounter_id: Reference to the encounter associated with the document.
    :vartype encounter_id: str
    """

    ordered_procedures: Optional[List["_models.OrderedProcedure"]] = rest_field(name="orderedProcedures")
    """List of procedure information associated with the document."""
    encounter_id: Optional[str] = rest_field(name="encounterId")
    """Reference to the encounter associated with the document."""

    @overload
    def __init__(
        self,
        *,
        ordered_procedures: Optional[List["_models.OrderedProcedure"]] = None,
        encounter_id: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class DocumentAuthor(_model_base.Model):
    """Document author.

    :ivar id: author id.
    :vartype id: str
    :ivar full_name: Text representation of the full name.
    :vartype full_name: str
    """

    id: Optional[str] = rest_field()
    """author id."""
    full_name: Optional[str] = rest_field(name="fullName")
    """Text representation of the full name."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        full_name: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class DocumentContent(_model_base.Model):
    """The content of the patient document.

    All required parameters must be populated in order to send to server.

    :ivar source_type: The type of the content's source.
     In case the source type is 'inline', the content is given as a string (for instance, text).
     In case the source type is 'reference', the content is given as a URI. Required. Known values
     are: "inline" and "reference".
    :vartype source_type: str or
     ~azure.healthinsights.radiologyinsights.models.DocumentContentSourceType
    :ivar value: The content of the document, given either inline (as a string) or as a reference
     (URI). Required.
    :vartype value: str
    """

    source_type: Union[str, "_models.DocumentContentSourceType"] = rest_field(name="sourceType")
    """The type of the content's source.
     In case the source type is 'inline', the content is given as a string (for instance, text).
     In case the source type is 'reference', the content is given as a URI. Required. Known values
     are: \"inline\" and \"reference\"."""
    value: str = rest_field()
    """The content of the document, given either inline (as a string) or as a reference (URI).
     Required."""

    @overload
    def __init__(
        self,
        *,
        source_type: Union[str, "_models.DocumentContentSourceType"],
        value: str,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Encounter(_model_base.Model):
    """visit/encounter information.

    All required parameters must be populated in order to send to server.

    :ivar id: The id of the visit. Required.
    :vartype id: str
    :ivar period: Time period of the visit.
     In case of admission, use timePeriod.start to indicate the admission time and timePeriod.end
     to indicate the discharge time.
    :vartype period: ~azure.healthinsights.radiologyinsights.models.TimePeriod
    :ivar class_property: The class of the encounter. Known values are: "inpatient", "ambulatory",
     "observation", "emergency", "virtual", and "healthHome".
    :vartype class_property: str or ~azure.healthinsights.radiologyinsights.models.EncounterClass
    """

    id: str = rest_field()
    """The id of the visit. Required."""
    period: Optional["_models.TimePeriod"] = rest_field()
    """Time period of the visit.
     In case of admission, use timePeriod.start to indicate the admission time and timePeriod.end to
     indicate the discharge time."""
    class_property: Optional[Union[str, "_models.EncounterClass"]] = rest_field(name="class")
    """The class of the encounter. Known values are: \"inpatient\", \"ambulatory\", \"observation\",
     \"emergency\", \"virtual\", and \"healthHome\"."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        period: Optional["_models.TimePeriod"] = None,
        class_property: Optional[Union[str, "_models.EncounterClass"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Error(_model_base.Model):
    """The error object.

    All required parameters must be populated in order to send to server.

    :ivar code: One of a server-defined set of error codes. Required.
    :vartype code: str
    :ivar message: A human-readable representation of the error. Required.
    :vartype message: str
    :ivar target: The target of the error.
    :vartype target: str
    :ivar details: An array of details about specific errors that led to this reported error.
    :vartype details: list[~azure.healthinsights.radiologyinsights.models.Error]
    :ivar innererror: An object containing more specific information than the current object about
     the error.
    :vartype innererror: ~azure.healthinsights.radiologyinsights.models.InnerError
    """

    code: str = rest_field()
    """One of a server-defined set of error codes. Required."""
    message: str = rest_field()
    """A human-readable representation of the error. Required."""
    target: Optional[str] = rest_field()
    """The target of the error."""
    details: Optional[List["_models.Error"]] = rest_field()
    """An array of details about specific errors that led to this reported error."""
    innererror: Optional["_models.InnerError"] = rest_field()
    """An object containing more specific information than the current object about the error."""

    @overload
    def __init__(
        self,
        *,
        code: str,
        message: str,
        target: Optional[str] = None,
        details: Optional[List["_models.Error"]] = None,
        innererror: Optional["_models.InnerError"] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Extension(Element):  # pylint: disable=too-many-instance-attributes
    """Base for all elements
    Based on `FHIR Element <https://www.hl7.org/fhir/datatypes.html#Element>`_.

    All required parameters must be populated in order to send to server.

    :ivar url: Source of the definition for the extension code - a logical name or a URL. Required.
    :vartype url: str
    :ivar value_quantity: Value as Quantity.
    :vartype value_quantity: ~azure.healthinsights.radiologyinsights.models.Quantity
    :ivar value_codeable_concept: Value as CodeableConcept.
    :vartype value_codeable_concept: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar value_string: Value as string.
    :vartype value_string: str
    :ivar value_boolean: Value as boolean.
    :vartype value_boolean: bool
    :ivar value_integer: Value as integer.
    :vartype value_integer: int
    :ivar value_range: Value as Range.
    :vartype value_range: ~azure.healthinsights.radiologyinsights.models.Range
    :ivar value_ratio: Value as Ratio.
    :vartype value_ratio: ~azure.healthinsights.radiologyinsights.models.Ratio
    :ivar value_sampled_data: Value as SampledData.
    :vartype value_sampled_data: ~azure.healthinsights.radiologyinsights.models.SampledData
    :ivar value_time: Value as time (hh:mm:ss).
    :vartype value_time: ~datetime.time
    :ivar value_date_time: Value as dateTime.
    :vartype value_date_time: str
    :ivar value_period: Value as Period.
    :vartype value_period: ~azure.healthinsights.radiologyinsights.models.Period
    :ivar value_reference: Value as reference.
    :vartype value_reference: ~azure.healthinsights.radiologyinsights.models.Reference
    """

    url: str = rest_field()
    """Source of the definition for the extension code - a logical name or a URL. Required."""
    value_quantity: Optional["_models.Quantity"] = rest_field(name="valueQuantity")
    """Value as Quantity."""
    value_codeable_concept: Optional["_models.CodeableConcept"] = rest_field(name="valueCodeableConcept")
    """Value as CodeableConcept."""
    value_string: Optional[str] = rest_field(name="valueString")
    """Value as string."""
    value_boolean: Optional[bool] = rest_field(name="valueBoolean")
    """Value as boolean."""
    value_integer: Optional[int] = rest_field(name="valueInteger")
    """Value as integer."""
    value_range: Optional["_models.Range"] = rest_field(name="valueRange")
    """Value as Range."""
    value_ratio: Optional["_models.Ratio"] = rest_field(name="valueRatio")
    """Value as Ratio."""
    value_sampled_data: Optional["_models.SampledData"] = rest_field(name="valueSampledData")
    """Value as SampledData."""
    value_time: Optional[datetime.time] = rest_field(name="valueTime")
    """Value as time (hh:mm:ss)."""
    value_date_time: Optional[str] = rest_field(name="valueDateTime")
    """Value as dateTime."""
    value_period: Optional["_models.Period"] = rest_field(name="valuePeriod")
    """Value as Period."""
    value_reference: Optional["_models.Reference"] = rest_field(name="valueReference")
    """Value as reference."""

    @overload
    def __init__(
        self,
        *,
        url: str,
        value_quantity: Optional["_models.Quantity"] = None,
        value_codeable_concept: Optional["_models.CodeableConcept"] = None,
        value_string: Optional[str] = None,
        value_boolean: Optional[bool] = None,
        value_integer: Optional[int] = None,
        value_range: Optional["_models.Range"] = None,
        value_ratio: Optional["_models.Ratio"] = None,
        value_sampled_data: Optional["_models.SampledData"] = None,
        value_time: Optional[datetime.time] = None,
        value_date_time: Optional[str] = None,
        value_period: Optional["_models.Period"] = None,
        value_reference: Optional["_models.Reference"] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class FindingInference(RadiologyInsightsInference, discriminator="finding"):
    """Findings in a radiology report typically describe abnormalities, lesions, or other notable
    observations related to the anatomy or pathology of the imaged area.

    All required parameters must be populated in order to send to server.

    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar kind: Inference type. Required. Finding inference type
    :vartype kind: str or ~azure.healthinsights.radiologyinsights.models.FINDING
    :ivar finding: Finding data : contains extensions, fields and components linked with the
     finding. Required.
    :vartype finding: ~azure.healthinsights.radiologyinsights.models.Observation
    """

    kind: Literal[RadiologyInsightsInferenceType.FINDING] = rest_discriminator(name="kind")  # type: ignore
    """Inference type. Required. Finding inference type"""
    finding: "_models.Observation" = rest_field()
    """Finding data : contains extensions, fields and components linked with the finding. Required."""

    @overload
    def __init__(
        self,
        *,
        finding: "_models.Observation",
        extension: Optional[List["_models.Extension"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=RadiologyInsightsInferenceType.FINDING, **kwargs)


class FindingOptions(_model_base.Model):
    """Finding options.

    :ivar provide_focused_sentence_evidence: If this is true, provide the sentence that contains
     the first token of the finding's clinical indicator (i.e. the medical problem), if there is
     one. This sentence is provided as an extension with url 'ci_sentence', next to the token
     evidence. Default is false.
    :vartype provide_focused_sentence_evidence: bool
    """

    provide_focused_sentence_evidence: Optional[bool] = rest_field(name="provideFocusedSentenceEvidence")
    """If this is true, provide the sentence that contains the first token of the finding's clinical
     indicator (i.e. the medical problem), if there is one. This sentence is provided as an
     extension with url 'ci_sentence', next to the token evidence. Default is false."""

    @overload
    def __init__(
        self,
        *,
        provide_focused_sentence_evidence: Optional[bool] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class FollowupCommunicationInference(RadiologyInsightsInference, discriminator="followupCommunication"):
    """Follow-up communication involves the exchange of important information, recommendations, or
    updates between radiologists and other healthcare professionals involved in a patient's care.

    All required parameters must be populated in order to send to server.

    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar kind: Inference type. Required. Followup Communication inference type
    :vartype kind: str or ~azure.healthinsights.radiologyinsights.models.FOLLOWUP_COMMUNICATION
    :ivar date_time: Communication date and time.
    :vartype date_time: list[~datetime.datetime]
    :ivar recipient: Recipient of the communication.
    :vartype recipient: list[str or
     ~azure.healthinsights.radiologyinsights.models.MedicalProfessionalType]
    :ivar was_acknowledged: Communication was acknowledged. Required.
    :vartype was_acknowledged: bool
    """

    kind: Literal[RadiologyInsightsInferenceType.FOLLOWUP_COMMUNICATION] = rest_discriminator(name="kind")  # type: ignore
    """Inference type. Required. Followup Communication inference type"""
    date_time: Optional[List[datetime.datetime]] = rest_field(name="dateTime", format="rfc3339")
    """Communication date and time."""
    recipient: Optional[List[Union[str, "_models.MedicalProfessionalType"]]] = rest_field()
    """Recipient of the communication."""
    was_acknowledged: bool = rest_field(name="wasAcknowledged")
    """Communication was acknowledged. Required."""

    @overload
    def __init__(
        self,
        *,
        was_acknowledged: bool,
        extension: Optional[List["_models.Extension"]] = None,
        date_time: Optional[List[datetime.datetime]] = None,
        recipient: Optional[List[Union[str, "_models.MedicalProfessionalType"]]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=RadiologyInsightsInferenceType.FOLLOWUP_COMMUNICATION, **kwargs)


class FollowupRecommendationInference(RadiologyInsightsInference, discriminator="followupRecommendation"):
    """Follow-up recommendations offer guidance to healthcare providers on managing and monitoring
    patients based on the findings of imaging studies.

    All required parameters must be populated in order to send to server.

    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar kind: Inference type. Required. Recommendation inference type
    :vartype kind: str or ~azure.healthinsights.radiologyinsights.models.FOLLOWUP_RECOMMENDATION
    :ivar effective_date_time: Date and time are displayed when the procedure is recommended to be
     done at a specific point in time.
    :vartype effective_date_time: str
    :ivar effective_period: The period is shown if a specific period is mentioned, with a start and
     end date-time.
    :vartype effective_period: ~azure.healthinsights.radiologyinsights.models.Period
    :ivar findings: Findings related to the recommendation.
    :vartype findings: list[~azure.healthinsights.radiologyinsights.models.RecommendationFinding]
    :ivar is_conditional: The conditional value indicates whether or not the sentence containing
     the recommendation includes a conditional statement. Keywords for conditional statements
     include 'if', 'when', 'unless', and so on. Required.
    :vartype is_conditional: bool
    :ivar is_option: The option value indicates whether or not the sentence containing the
     recommendation includes an optional statement. Keywords for optional statements include
     'recommend', 'consider', and so on. Required.
    :vartype is_option: bool
    :ivar is_guideline: The guideline value indicates whether or not the recommendation is part of
     a guideline section that compiles all recommendations applicable to various findings. Required.
    :vartype is_guideline: bool
    :ivar is_hedging: Hedging refers to ambiguous, vague or imprecise language within the sentence
     of the recommendation. Keywords for hedging are 'can be','may be',and so on. Required.
    :vartype is_hedging: bool
    :ivar recommended_procedure: The procedure recommendation can be a generic procedure or an
     imaging procedure. Required.
    :vartype recommended_procedure:
     ~azure.healthinsights.radiologyinsights.models.ProcedureRecommendation
    """

    kind: Literal[RadiologyInsightsInferenceType.FOLLOWUP_RECOMMENDATION] = rest_discriminator(name="kind")  # type: ignore
    """Inference type. Required. Recommendation inference type"""
    effective_date_time: Optional[str] = rest_field(name="effectiveDateTime")
    """Date and time are displayed when the procedure is recommended to be done at a specific point in
     time."""
    effective_period: Optional["_models.Period"] = rest_field(name="effectivePeriod")
    """The period is shown if a specific period is mentioned, with a start and end date-time."""
    findings: Optional[List["_models.RecommendationFinding"]] = rest_field()
    """Findings related to the recommendation."""
    is_conditional: bool = rest_field(name="isConditional")
    """The conditional value indicates whether or not the sentence containing the recommendation
     includes a conditional statement. Keywords for conditional statements include 'if', 'when',
     'unless', and so on. Required."""
    is_option: bool = rest_field(name="isOption")
    """The option value indicates whether or not the sentence containing the recommendation includes
     an optional statement. Keywords for optional statements include 'recommend', 'consider', and so
     on. Required."""
    is_guideline: bool = rest_field(name="isGuideline")
    """The guideline value indicates whether or not the recommendation is part of a guideline section
     that compiles all recommendations applicable to various findings. Required."""
    is_hedging: bool = rest_field(name="isHedging")
    """Hedging refers to ambiguous, vague or imprecise language within the sentence of the
     recommendation. Keywords for hedging are 'can be','may be',and so on. Required."""
    recommended_procedure: "_models.ProcedureRecommendation" = rest_field(name="recommendedProcedure")
    """The procedure recommendation can be a generic procedure or an imaging procedure. Required."""

    @overload
    def __init__(
        self,
        *,
        is_conditional: bool,
        is_option: bool,
        is_guideline: bool,
        is_hedging: bool,
        recommended_procedure: "_models.ProcedureRecommendation",
        extension: Optional[List["_models.Extension"]] = None,
        effective_date_time: Optional[str] = None,
        effective_period: Optional["_models.Period"] = None,
        findings: Optional[List["_models.RecommendationFinding"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=RadiologyInsightsInferenceType.FOLLOWUP_RECOMMENDATION, **kwargs)


class FollowupRecommendationOptions(_model_base.Model):
    """Follow-up recommendation options.

    :ivar include_recommendations_with_no_specified_modality: Include/Exclude follow-up
     recommendations without a specific radiology procedure. Default is false.
    :vartype include_recommendations_with_no_specified_modality: bool
    :ivar include_recommendations_in_references: Include/Exclude follow-up recommendations in
     references to a guideline or article. Default is false.
    :vartype include_recommendations_in_references: bool
    :ivar provide_focused_sentence_evidence: If this is true, provide one or more sentences as
     evidence for the recommendation, next to the token evidence. The start and end positions of
     these sentences will be put in an extension with url 'modality_sentences'. Default is false.
    :vartype provide_focused_sentence_evidence: bool
    """

    include_recommendations_with_no_specified_modality: Optional[bool] = rest_field(
        name="includeRecommendationsWithNoSpecifiedModality"
    )
    """Include/Exclude follow-up recommendations without a specific radiology procedure. Default is
     false."""
    include_recommendations_in_references: Optional[bool] = rest_field(name="includeRecommendationsInReferences")
    """Include/Exclude follow-up recommendations in references to a guideline or article. Default is
     false."""
    provide_focused_sentence_evidence: Optional[bool] = rest_field(name="provideFocusedSentenceEvidence")
    """If this is true, provide one or more sentences as evidence for the recommendation, next to the
     token evidence. The start and end positions of these sentences will be put in an extension with
     url 'modality_sentences'. Default is false."""

    @overload
    def __init__(
        self,
        *,
        include_recommendations_with_no_specified_modality: Optional[bool] = None,
        include_recommendations_in_references: Optional[bool] = None,
        provide_focused_sentence_evidence: Optional[bool] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ProcedureRecommendation(_model_base.Model):
    """The procedure recommendation can be a generic procedure or an imaging procedure.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    GenericProcedureRecommendation, ImagingProcedureRecommendation

    All required parameters must be populated in order to send to server.

    :ivar kind: Required. Default value is None.
    :vartype kind: str
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    kind: str = rest_discriminator(name="kind")
    """Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class GenericProcedureRecommendation(ProcedureRecommendation, discriminator="genericProcedureRecommendation"):
    """Generic procedure information.

    All required parameters must be populated in order to send to server.

    :ivar kind: Procedure type : generic. Required. Default value is
     "genericProcedureRecommendation".
    :vartype kind: str
    :ivar code: Procedure modality : SNOMED CT code. Required.
    :vartype code: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar description: Procedure description : MANAGEMENT PROCEDURE (PROCEDURE) or CONSULTATION
     (PROCEDURE) based on SNOMED CT.
    :vartype description: str
    """

    kind: Literal["genericProcedureRecommendation"] = rest_discriminator(name="kind")  # type: ignore
    """Procedure type : generic. Required. Default value is \"genericProcedureRecommendation\"."""
    code: "_models.CodeableConcept" = rest_field()
    """Procedure modality : SNOMED CT code. Required."""
    description: Optional[str] = rest_field()
    """Procedure description : MANAGEMENT PROCEDURE (PROCEDURE) or CONSULTATION (PROCEDURE) based on
     SNOMED CT."""

    @overload
    def __init__(
        self,
        *,
        code: "_models.CodeableConcept",
        description: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind="genericProcedureRecommendation", **kwargs)


class HealthInsightsOperationStatus(_model_base.Model):
    """Provides status details for long running operations.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The unique ID of the operation. Required.
    :vartype id: str
    :ivar status: The status of the operation. Required. Known values are: "notStarted", "running",
     "succeeded", "failed", and "canceled".
    :vartype status: str or ~azure.healthinsights.radiologyinsights.models.JobStatus
    :ivar created_date_time: The date and time when the processing job was created.
    :vartype created_date_time: ~datetime.datetime
    :ivar expiration_date_time: The date and time when the processing job is set to expire.
    :vartype expiration_date_time: ~datetime.datetime
    :ivar last_update_date_time: The date and time when the processing job was last updated.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar error: Error object that describes the error when status is "Failed".
    :vartype error: ~azure.healthinsights.radiologyinsights.models.Error
    :ivar result: The result of the operation.
    :vartype result:
     ~azure.healthinsights.radiologyinsights.models.RadiologyInsightsInferenceResult
    """

    id: str = rest_field(visibility=["read"])
    """The unique ID of the operation. Required."""
    status: Union[str, "_models.JobStatus"] = rest_field(visibility=["read"])
    """The status of the operation. Required. Known values are: \"notStarted\", \"running\",
     \"succeeded\", \"failed\", and \"canceled\"."""
    created_date_time: Optional[datetime.datetime] = rest_field(
        name="createdDateTime", visibility=["read"], format="rfc3339"
    )
    """The date and time when the processing job was created."""
    expiration_date_time: Optional[datetime.datetime] = rest_field(
        name="expirationDateTime", visibility=["read"], format="rfc3339"
    )
    """The date and time when the processing job is set to expire."""
    last_update_date_time: Optional[datetime.datetime] = rest_field(
        name="lastUpdateDateTime", visibility=["read"], format="rfc3339"
    )
    """The date and time when the processing job was last updated."""
    error: Optional["_models.Error"] = rest_field()
    """Error object that describes the error when status is \"Failed\"."""
    result: Optional["_models.RadiologyInsightsInferenceResult"] = rest_field()
    """The result of the operation."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.Error"] = None,
        result: Optional["_models.RadiologyInsightsInferenceResult"] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Identifier(Element):
    """An identifier intended for computation
    Based on `FHIR Identifier <https://www.hl7.org/fhir/R4/identifier.html>`_.

    :ivar use: usual | official | temp | secondary | old (If known).
    :vartype use: str
    :ivar type: Description of identifier.
    :vartype type: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar system: The namespace for the identifier value.
    :vartype system: str
    :ivar value: The value that is unique.
    :vartype value: str
    :ivar period: Time period when id is/was valid for use.
    :vartype period: ~azure.healthinsights.radiologyinsights.models.Period
    :ivar assigner: Organization that issued id (may be just text).
    :vartype assigner: ~azure.healthinsights.radiologyinsights.models.Reference
    """

    use: Optional[str] = rest_field()
    """usual | official | temp | secondary | old (If known)."""
    type: Optional["_models.CodeableConcept"] = rest_field()
    """Description of identifier."""
    system: Optional[str] = rest_field()
    """The namespace for the identifier value."""
    value: Optional[str] = rest_field()
    """The value that is unique."""
    period: Optional["_models.Period"] = rest_field()
    """Time period when id is/was valid for use."""
    assigner: Optional["_models.Reference"] = rest_field()
    """Organization that issued id (may be just text)."""

    @overload
    def __init__(
        self,
        *,
        use: Optional[str] = None,
        type: Optional["_models.CodeableConcept"] = None,
        system: Optional[str] = None,
        value: Optional[str] = None,
        period: Optional["_models.Period"] = None,
        assigner: Optional["_models.Reference"] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ImagingProcedure(_model_base.Model):
    """Imaging procedure.

    All required parameters must be populated in order to send to server.

    :ivar modality: Modality : SNOMED CT code. Required.
    :vartype modality: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar anatomy: Anatomy : SNOMED CT code. Required.
    :vartype anatomy: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar laterality: Laterality : SNOMED CT code.
    :vartype laterality: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar contrast: Contrast : see RadiologyCodeWithTypes (below).
    :vartype contrast: ~azure.healthinsights.radiologyinsights.models.RadiologyCodeWithTypes
    :ivar view: View : see RadiologyCodeWithTypes (below).
    :vartype view: ~azure.healthinsights.radiologyinsights.models.RadiologyCodeWithTypes
    """

    modality: "_models.CodeableConcept" = rest_field()
    """Modality : SNOMED CT code. Required."""
    anatomy: "_models.CodeableConcept" = rest_field()
    """Anatomy : SNOMED CT code. Required."""
    laterality: Optional["_models.CodeableConcept"] = rest_field()
    """Laterality : SNOMED CT code."""
    contrast: Optional["_models.RadiologyCodeWithTypes"] = rest_field()
    """Contrast : see RadiologyCodeWithTypes (below)."""
    view: Optional["_models.RadiologyCodeWithTypes"] = rest_field()
    """View : see RadiologyCodeWithTypes (below)."""

    @overload
    def __init__(
        self,
        *,
        modality: "_models.CodeableConcept",
        anatomy: "_models.CodeableConcept",
        laterality: Optional["_models.CodeableConcept"] = None,
        contrast: Optional["_models.RadiologyCodeWithTypes"] = None,
        view: Optional["_models.RadiologyCodeWithTypes"] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ImagingProcedureRecommendation(ProcedureRecommendation, discriminator="imagingProcedureRecommendation"):
    """Imaging procedures.

    All required parameters must be populated in order to send to server.

    :ivar kind: Procedure type : imaging. Required. Default value is
     "imagingProcedureRecommendation".
    :vartype kind: str
    :ivar procedure_codes: LOINC codes for the procedure.
    :vartype procedure_codes: list[~azure.healthinsights.radiologyinsights.models.CodeableConcept]
    :ivar imaging_procedures: Imaging procedures. Required.
    :vartype imaging_procedures:
     list[~azure.healthinsights.radiologyinsights.models.ImagingProcedure]
    """

    kind: Literal["imagingProcedureRecommendation"] = rest_discriminator(name="kind")  # type: ignore
    """Procedure type : imaging. Required. Default value is \"imagingProcedureRecommendation\"."""
    procedure_codes: Optional[List["_models.CodeableConcept"]] = rest_field(name="procedureCodes")
    """LOINC codes for the procedure."""
    imaging_procedures: List["_models.ImagingProcedure"] = rest_field(name="imagingProcedures")
    """Imaging procedures. Required."""

    @overload
    def __init__(
        self,
        *,
        imaging_procedures: List["_models.ImagingProcedure"],
        procedure_codes: Optional[List["_models.CodeableConcept"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind="imagingProcedureRecommendation", **kwargs)


class InnerError(_model_base.Model):
    """An object containing more specific information about the error. As per Microsoft One API
    guidelines -
    https://github.com/Microsoft/api-guidelines/blob/vNext/Guidelines.md#7102-error-condition-responses.

    :ivar code: One of a server-defined set of error codes.
    :vartype code: str
    :ivar innererror: Inner error.
    :vartype innererror: ~azure.healthinsights.radiologyinsights.models.InnerError
    """

    code: Optional[str] = rest_field()
    """One of a server-defined set of error codes."""
    innererror: Optional["_models.InnerError"] = rest_field()
    """Inner error."""

    @overload
    def __init__(
        self,
        *,
        code: Optional[str] = None,
        innererror: Optional["_models.InnerError"] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class LateralityDiscrepancyInference(RadiologyInsightsInference, discriminator="lateralityDiscrepancy"):
    """A laterality mismatch occurs when there is a discrepancy between the clinical documentation and
    the ordered procedure (orderLateralityMismatch), a contradiction within the clinical document
    (textLateralityContradiction), or when no laterality is mentioned (textLateralityMissing).

    All required parameters must be populated in order to send to server.

    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar kind: Inference type. Required. Laterality discrepancy inference type
    :vartype kind: str or ~azure.healthinsights.radiologyinsights.models.LATERALITY_DISCREPANCY
    :ivar laterality_indication: Laterality indication : SNOMED CT code for laterality qualifier
     value.
    :vartype laterality_indication: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar discrepancy_type: Mismatch type : orderLateralityMismatch, textLateralityContradiction,
     textLateralityMissing. Required. Known values are: "orderLateralityMismatch",
     "textLateralityContradiction", and "textLateralityMissing".
    :vartype discrepancy_type: str or
     ~azure.healthinsights.radiologyinsights.models.LateralityDiscrepancyType
    """

    kind: Literal[RadiologyInsightsInferenceType.LATERALITY_DISCREPANCY] = rest_discriminator(name="kind")  # type: ignore
    """Inference type. Required. Laterality discrepancy inference type"""
    laterality_indication: Optional["_models.CodeableConcept"] = rest_field(name="lateralityIndication")
    """Laterality indication : SNOMED CT code for laterality qualifier value."""
    discrepancy_type: Union[str, "_models.LateralityDiscrepancyType"] = rest_field(name="discrepancyType")
    """Mismatch type : orderLateralityMismatch, textLateralityContradiction, textLateralityMissing.
     Required. Known values are: \"orderLateralityMismatch\", \"textLateralityContradiction\", and
     \"textLateralityMissing\"."""

    @overload
    def __init__(
        self,
        *,
        discrepancy_type: Union[str, "_models.LateralityDiscrepancyType"],
        extension: Optional[List["_models.Extension"]] = None,
        laterality_indication: Optional["_models.CodeableConcept"] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=RadiologyInsightsInferenceType.LATERALITY_DISCREPANCY, **kwargs)


class LimitedOrderDiscrepancyInference(RadiologyInsightsInference, discriminator="limitedOrderDiscrepancy"):
    """A limited order discrepancy occurs when there is a limited order, but all body parts and
    measurements that are needed for a complete order are present in the document.

    All required parameters must be populated in order to send to server.

    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar kind: Inference type. Required. Limited order discrepancy inference type
    :vartype kind: str or ~azure.healthinsights.radiologyinsights.models.LIMITED_ORDER_DISCREPANCY
    :ivar order_type: Order type : CPT ultrasound complete code for abdomen, retroperitoneal,
     pelvis or breast. Required.
    :vartype order_type: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar present_body_parts: List of body parts found in the document : SNOMED CT codes.
    :vartype present_body_parts:
     list[~azure.healthinsights.radiologyinsights.models.CodeableConcept]
    :ivar present_body_part_measurements: List of body parts that are measured according to the
     document : SNOMED CT codes.
    :vartype present_body_part_measurements:
     list[~azure.healthinsights.radiologyinsights.models.CodeableConcept]
    """

    kind: Literal[RadiologyInsightsInferenceType.LIMITED_ORDER_DISCREPANCY] = rest_discriminator(name="kind")  # type: ignore
    """Inference type. Required. Limited order discrepancy inference type"""
    order_type: "_models.CodeableConcept" = rest_field(name="orderType")
    """Order type : CPT ultrasound complete code for abdomen, retroperitoneal, pelvis or breast.
     Required."""
    present_body_parts: Optional[List["_models.CodeableConcept"]] = rest_field(name="presentBodyParts")
    """List of body parts found in the document : SNOMED CT codes."""
    present_body_part_measurements: Optional[List["_models.CodeableConcept"]] = rest_field(
        name="presentBodyPartMeasurements"
    )
    """List of body parts that are measured according to the document : SNOMED CT codes."""

    @overload
    def __init__(
        self,
        *,
        order_type: "_models.CodeableConcept",
        extension: Optional[List["_models.Extension"]] = None,
        present_body_parts: Optional[List["_models.CodeableConcept"]] = None,
        present_body_part_measurements: Optional[List["_models.CodeableConcept"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=RadiologyInsightsInferenceType.LIMITED_ORDER_DISCREPANCY, **kwargs)


class Meta(_model_base.Model):
    """Metadata about a resource
    Based on `FHIR Meta <https://www.hl7.org/fhir/R4/resource.html#Meta>`_.

    :ivar version_id: The version specific identifier, as it appears in the version portion of the
     URL. This value changes when the resource is created, updated, or deleted.
    :vartype version_id: str
    :ivar last_updated: When the resource last changed - e.g. when the version changed.
    :vartype last_updated: str
    :ivar source: A uri that identifies the source system of the resource. This provides a minimal
     amount of Provenance information that can be used to track or differentiate the source of
     information in the resource. The source may identify another FHIR server, document, message,
     database, etc.
    :vartype source: str
    :ivar profile: A list of profiles (references to `StructureDefinition
     <https://www.hl7.org/fhir/structuredefinition.html>`_ resources) that this resource claims to
     conform to. The URL is a reference to `StructureDefinition.url
     <https://www.hl7.org/fhir/structuredefinition-definitions.html#StructureDefinition.url>`_.
    :vartype profile: list[str]
    :ivar security: Security labels applied to this resource. These tags connect specific resources
     to the overall security policy and infrastructure.
    :vartype security: list[~azure.healthinsights.radiologyinsights.models.Coding]
    :ivar tag: Tags applied to this resource. Tags are intended to be used to identify and relate
     resources to process and workflow, and applications are not required to consider the tags when
     interpreting the meaning of a resource.
    :vartype tag: list[~azure.healthinsights.radiologyinsights.models.Coding]
    """

    version_id: Optional[str] = rest_field(name="versionId")
    """The version specific identifier, as it appears in the version portion of the URL. This value
     changes when the resource is created, updated, or deleted."""
    last_updated: Optional[str] = rest_field(name="lastUpdated")
    """When the resource last changed - e.g. when the version changed."""
    source: Optional[str] = rest_field()
    """A uri that identifies the source system of the resource. This provides a minimal amount of
     Provenance information that can be used to track or differentiate the source of information in
     the resource. The source may identify another FHIR server, document, message, database, etc."""
    profile: Optional[List[str]] = rest_field()
    """A list of profiles (references to `StructureDefinition
     <https://www.hl7.org/fhir/structuredefinition.html>`_ resources) that this resource claims to
     conform to. The URL is a reference to `StructureDefinition.url
     <https://www.hl7.org/fhir/structuredefinition-definitions.html#StructureDefinition.url>`_."""
    security: Optional[List["_models.Coding"]] = rest_field()
    """Security labels applied to this resource. These tags connect specific resources to the overall
     security policy and infrastructure."""
    tag: Optional[List["_models.Coding"]] = rest_field()
    """Tags applied to this resource. Tags are intended to be used to identify and relate resources to
     process and workflow, and applications are not required to consider the tags when interpreting
     the meaning of a resource."""

    @overload
    def __init__(
        self,
        *,
        version_id: Optional[str] = None,
        last_updated: Optional[str] = None,
        source: Optional[str] = None,
        profile: Optional[List[str]] = None,
        security: Optional[List["_models.Coding"]] = None,
        tag: Optional[List["_models.Coding"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Narrative(Element):
    """Any resource that is a `DomainResource <https://www.hl7.org/fhir/domainresource.html>`_ may
    include a human-readable narrative that contains a summary of the resource and may be used to
    represent the content of the resource to a human.
    Based on `FHIR Narrative <https://www.hl7.org/fhir/R4/narrative.html#Narrative>`_.

    All required parameters must be populated in order to send to server.

    :ivar id: Unique id for inter-element referencing.
    :vartype id: str
    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar status: generated, extensions, additional, empty. Required.
    :vartype status: str
    :ivar div: xhtml. Required.
    :vartype div: str
    """

    status: str = rest_field()
    """generated, extensions, additional, empty. Required."""
    div: str = rest_field()
    """xhtml. Required."""

    @overload
    def __init__(
        self,
        *,
        status: str,
        div: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        extension: Optional[List["_models.Extension"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Observation(DomainResource):  # pylint: disable=too-many-instance-attributes
    """Detailed information about observations
    Based on `FHIR Observation <https://www.hl7.org/fhir/R4/observation.html>`_.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar meta: Metadata about the resource.
    :vartype meta: ~azure.healthinsights.radiologyinsights.models.Meta
    :ivar implicit_rules: A set of rules under which this content was created.
    :vartype implicit_rules: str
    :ivar language: Language of the resource content.
    :vartype language: str
    :ivar text: Text summary of the resource, for human interpretation.
    :vartype text: ~azure.healthinsights.radiologyinsights.models.Narrative
    :ivar contained: Contained, inline Resources.
    :vartype contained: list[~azure.healthinsights.radiologyinsights.models.Resource]
    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar modifier_extension: Extensions that cannot be ignored.
    :vartype modifier_extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar resource_type: resourceType. Required. Default value is "Observation".
    :vartype resource_type: str
    :ivar identifier: Business Identifier for observation.
    :vartype identifier: list[~azure.healthinsights.radiologyinsights.models.Identifier]
    :ivar status: registered | preliminary | final | amended +. Required. Known values are:
     "registered", "preliminary", "final", "amended", "corrected", "cancelled", "entered-in-error",
     and "unknown".
    :vartype status: str or
     ~azure.healthinsights.radiologyinsights.models.ObservationStatusCodeType
    :ivar category: Classification of  type of observation.
    :vartype category: list[~azure.healthinsights.radiologyinsights.models.CodeableConcept]
    :ivar code: Type of observation (code / type). Required.
    :vartype code: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar subject: Who and/or what the observation is about.
    :vartype subject: ~azure.healthinsights.radiologyinsights.models.Reference
    :ivar encounter: Healthcare event during which this observation is made.
    :vartype encounter: ~azure.healthinsights.radiologyinsights.models.Reference
    :ivar effective_date_time: Clinically relevant time/time-period for observation.
    :vartype effective_date_time: str
    :ivar effective_period: Clinically relevant time/time-period for observation.
    :vartype effective_period: ~azure.healthinsights.radiologyinsights.models.Period
    :ivar effective_instant: Clinically relevant time/time-period for observation.
    :vartype effective_instant: str
    :ivar issued: Date/Time this version was made available.
    :vartype issued: str
    :ivar value_quantity: Actual result.
    :vartype value_quantity: ~azure.healthinsights.radiologyinsights.models.Quantity
    :ivar value_codeable_concept: Actual result.
    :vartype value_codeable_concept: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar value_string: Actual result.
    :vartype value_string: str
    :ivar value_boolean: Actual result.
    :vartype value_boolean: bool
    :ivar value_integer: Actual result.
    :vartype value_integer: int
    :ivar value_range: Actual result.
    :vartype value_range: ~azure.healthinsights.radiologyinsights.models.Range
    :ivar value_ratio: Actual result.
    :vartype value_ratio: ~azure.healthinsights.radiologyinsights.models.Ratio
    :ivar value_sampled_data: Actual result.
    :vartype value_sampled_data: ~azure.healthinsights.radiologyinsights.models.SampledData
    :ivar value_time: Actual result.
    :vartype value_time: ~datetime.time
    :ivar value_date_time: Actual result.
    :vartype value_date_time: str
    :ivar value_period: Actual result.
    :vartype value_period: ~azure.healthinsights.radiologyinsights.models.Period
    :ivar data_absent_reason: Why the result is missing.
    :vartype data_absent_reason: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar interpretation: High, low, normal, etc.
    :vartype interpretation: list[~azure.healthinsights.radiologyinsights.models.CodeableConcept]
    :ivar note: Comments about the observation.
    :vartype note: list[~azure.healthinsights.radiologyinsights.models.Annotation]
    :ivar body_site: Observed body part.
    :vartype body_site: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar method: How it was done.
    :vartype method: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar reference_range: Provides guide for interpretation.
    :vartype reference_range:
     list[~azure.healthinsights.radiologyinsights.models.ObservationReferenceRange]
    :ivar has_member: Related resource that belongs to the Observation group.
    :vartype has_member: list[~azure.healthinsights.radiologyinsights.models.Reference]
    :ivar derived_from: Related measurements the observation is made from.
    :vartype derived_from: list[~azure.healthinsights.radiologyinsights.models.Reference]
    :ivar component: Component results.
    :vartype component: list[~azure.healthinsights.radiologyinsights.models.ObservationComponent]
    """

    resource_type: Literal["Observation"] = rest_field(name="resourceType")
    """resourceType. Required. Default value is \"Observation\"."""
    identifier: Optional[List["_models.Identifier"]] = rest_field()
    """Business Identifier for observation."""
    status: Union[str, "_models.ObservationStatusCodeType"] = rest_field()
    """registered | preliminary | final | amended +. Required. Known values are: \"registered\",
     \"preliminary\", \"final\", \"amended\", \"corrected\", \"cancelled\", \"entered-in-error\",
     and \"unknown\"."""
    category: Optional[List["_models.CodeableConcept"]] = rest_field()
    """Classification of  type of observation."""
    code: "_models.CodeableConcept" = rest_field()
    """Type of observation (code / type). Required."""
    subject: Optional["_models.Reference"] = rest_field()
    """Who and/or what the observation is about."""
    encounter: Optional["_models.Reference"] = rest_field()
    """Healthcare event during which this observation is made."""
    effective_date_time: Optional[str] = rest_field(name="effectiveDateTime")
    """Clinically relevant time/time-period for observation."""
    effective_period: Optional["_models.Period"] = rest_field(name="effectivePeriod")
    """Clinically relevant time/time-period for observation."""
    effective_instant: Optional[str] = rest_field(name="effectiveInstant")
    """Clinically relevant time/time-period for observation."""
    issued: Optional[str] = rest_field()
    """Date/Time this version was made available."""
    value_quantity: Optional["_models.Quantity"] = rest_field(name="valueQuantity")
    """Actual result."""
    value_codeable_concept: Optional["_models.CodeableConcept"] = rest_field(name="valueCodeableConcept")
    """Actual result."""
    value_string: Optional[str] = rest_field(name="valueString")
    """Actual result."""
    value_boolean: Optional[bool] = rest_field(name="valueBoolean")
    """Actual result."""
    value_integer: Optional[int] = rest_field(name="valueInteger")
    """Actual result."""
    value_range: Optional["_models.Range"] = rest_field(name="valueRange")
    """Actual result."""
    value_ratio: Optional["_models.Ratio"] = rest_field(name="valueRatio")
    """Actual result."""
    value_sampled_data: Optional["_models.SampledData"] = rest_field(name="valueSampledData")
    """Actual result."""
    value_time: Optional[datetime.time] = rest_field(name="valueTime")
    """Actual result."""
    value_date_time: Optional[str] = rest_field(name="valueDateTime")
    """Actual result."""
    value_period: Optional["_models.Period"] = rest_field(name="valuePeriod")
    """Actual result."""
    data_absent_reason: Optional["_models.CodeableConcept"] = rest_field(name="dataAbsentReason")
    """Why the result is missing."""
    interpretation: Optional[List["_models.CodeableConcept"]] = rest_field()
    """High, low, normal, etc."""
    note: Optional[List["_models.Annotation"]] = rest_field()
    """Comments about the observation."""
    body_site: Optional["_models.CodeableConcept"] = rest_field(name="bodySite")
    """Observed body part."""
    method: Optional["_models.CodeableConcept"] = rest_field()
    """How it was done."""
    reference_range: Optional[List["_models.ObservationReferenceRange"]] = rest_field(name="referenceRange")
    """Provides guide for interpretation."""
    has_member: Optional[List["_models.Reference"]] = rest_field(name="hasMember")
    """Related resource that belongs to the Observation group."""
    derived_from: Optional[List["_models.Reference"]] = rest_field(name="derivedFrom")
    """Related measurements the observation is made from."""
    component: Optional[List["_models.ObservationComponent"]] = rest_field()
    """Component results."""

    @overload
    def __init__(
        self,
        *,
        status: Union[str, "_models.ObservationStatusCodeType"],
        code: "_models.CodeableConcept",
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        meta: Optional["_models.Meta"] = None,
        implicit_rules: Optional[str] = None,
        language: Optional[str] = None,
        text: Optional["_models.Narrative"] = None,
        contained: Optional[List["_models.Resource"]] = None,
        extension: Optional[List["_models.Extension"]] = None,
        modifier_extension: Optional[List["_models.Extension"]] = None,
        identifier: Optional[List["_models.Identifier"]] = None,
        category: Optional[List["_models.CodeableConcept"]] = None,
        subject: Optional["_models.Reference"] = None,
        encounter: Optional["_models.Reference"] = None,
        effective_date_time: Optional[str] = None,
        effective_period: Optional["_models.Period"] = None,
        effective_instant: Optional[str] = None,
        issued: Optional[str] = None,
        value_quantity: Optional["_models.Quantity"] = None,
        value_codeable_concept: Optional["_models.CodeableConcept"] = None,
        value_string: Optional[str] = None,
        value_boolean: Optional[bool] = None,
        value_integer: Optional[int] = None,
        value_range: Optional["_models.Range"] = None,
        value_ratio: Optional["_models.Ratio"] = None,
        value_sampled_data: Optional["_models.SampledData"] = None,
        value_time: Optional[datetime.time] = None,
        value_date_time: Optional[str] = None,
        value_period: Optional["_models.Period"] = None,
        data_absent_reason: Optional["_models.CodeableConcept"] = None,
        interpretation: Optional[List["_models.CodeableConcept"]] = None,
        note: Optional[List["_models.Annotation"]] = None,
        body_site: Optional["_models.CodeableConcept"] = None,
        method: Optional["_models.CodeableConcept"] = None,
        reference_range: Optional[List["_models.ObservationReferenceRange"]] = None,
        has_member: Optional[List["_models.Reference"]] = None,
        derived_from: Optional[List["_models.Reference"]] = None,
        component: Optional[List["_models.ObservationComponent"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.resource_type: Literal["Observation"] = "Observation"


class ObservationComponent(Element):  # pylint: disable=too-many-instance-attributes
    """Component results
    Based on `FHIR Observation.component <https://www.hl7.org/fhir/R4/observation.html>`_.

    All required parameters must be populated in order to send to server.

    :ivar id: Unique id for inter-element referencing.
    :vartype id: str
    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar code: Type of component observation (code / type). Required.
    :vartype code: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar value_quantity: Value as Quantity.
    :vartype value_quantity: ~azure.healthinsights.radiologyinsights.models.Quantity
    :ivar value_codeable_concept: Value as CodeableConcept.
    :vartype value_codeable_concept: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar value_string: Value as string.
    :vartype value_string: str
    :ivar value_boolean: Value as boolean.
    :vartype value_boolean: bool
    :ivar value_integer: Value as integer.
    :vartype value_integer: int
    :ivar value_range: Value as Range.
    :vartype value_range: ~azure.healthinsights.radiologyinsights.models.Range
    :ivar value_ratio: Value as Ratio.
    :vartype value_ratio: ~azure.healthinsights.radiologyinsights.models.Ratio
    :ivar value_sampled_data: Value as SampledData.
    :vartype value_sampled_data: ~azure.healthinsights.radiologyinsights.models.SampledData
    :ivar value_time: Value as time (hh:mm:ss).
    :vartype value_time: ~datetime.time
    :ivar value_date_time: Value as dateTime.
    :vartype value_date_time: str
    :ivar value_period: Value as Period.
    :vartype value_period: ~azure.healthinsights.radiologyinsights.models.Period
    :ivar value_reference: Value as reference.
    :vartype value_reference: ~azure.healthinsights.radiologyinsights.models.Reference
    :ivar data_absent_reason: Why the component result is missing.
    :vartype data_absent_reason: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar interpretation: High, low, normal, etc.
    :vartype interpretation: list[~azure.healthinsights.radiologyinsights.models.CodeableConcept]
    :ivar reference_range: Provides guide for interpretation of component result.
    :vartype reference_range:
     list[~azure.healthinsights.radiologyinsights.models.ObservationReferenceRange]
    """

    code: "_models.CodeableConcept" = rest_field()
    """Type of component observation (code / type). Required."""
    value_quantity: Optional["_models.Quantity"] = rest_field(name="valueQuantity")
    """Value as Quantity."""
    value_codeable_concept: Optional["_models.CodeableConcept"] = rest_field(name="valueCodeableConcept")
    """Value as CodeableConcept."""
    value_string: Optional[str] = rest_field(name="valueString")
    """Value as string."""
    value_boolean: Optional[bool] = rest_field(name="valueBoolean")
    """Value as boolean."""
    value_integer: Optional[int] = rest_field(name="valueInteger")
    """Value as integer."""
    value_range: Optional["_models.Range"] = rest_field(name="valueRange")
    """Value as Range."""
    value_ratio: Optional["_models.Ratio"] = rest_field(name="valueRatio")
    """Value as Ratio."""
    value_sampled_data: Optional["_models.SampledData"] = rest_field(name="valueSampledData")
    """Value as SampledData."""
    value_time: Optional[datetime.time] = rest_field(name="valueTime")
    """Value as time (hh:mm:ss)."""
    value_date_time: Optional[str] = rest_field(name="valueDateTime")
    """Value as dateTime."""
    value_period: Optional["_models.Period"] = rest_field(name="valuePeriod")
    """Value as Period."""
    value_reference: Optional["_models.Reference"] = rest_field(name="valueReference")
    """Value as reference."""
    data_absent_reason: Optional["_models.CodeableConcept"] = rest_field(name="dataAbsentReason")
    """Why the component result is missing."""
    interpretation: Optional[List["_models.CodeableConcept"]] = rest_field()
    """High, low, normal, etc."""
    reference_range: Optional[List["_models.ObservationReferenceRange"]] = rest_field(name="referenceRange")
    """Provides guide for interpretation of component result."""

    @overload
    def __init__(
        self,
        *,
        code: "_models.CodeableConcept",
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        extension: Optional[List["_models.Extension"]] = None,
        value_quantity: Optional["_models.Quantity"] = None,
        value_codeable_concept: Optional["_models.CodeableConcept"] = None,
        value_string: Optional[str] = None,
        value_boolean: Optional[bool] = None,
        value_integer: Optional[int] = None,
        value_range: Optional["_models.Range"] = None,
        value_ratio: Optional["_models.Ratio"] = None,
        value_sampled_data: Optional["_models.SampledData"] = None,
        value_time: Optional[datetime.time] = None,
        value_date_time: Optional[str] = None,
        value_period: Optional["_models.Period"] = None,
        value_reference: Optional["_models.Reference"] = None,
        data_absent_reason: Optional["_models.CodeableConcept"] = None,
        interpretation: Optional[List["_models.CodeableConcept"]] = None,
        reference_range: Optional[List["_models.ObservationReferenceRange"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ObservationReferenceRange(_model_base.Model):
    """Provides guide for interpretation of component result
    Based on `FHIR Observation.referenceRange <https://www.hl7.org/fhir/R4/observation.html>`_.

    :ivar low: Low Range, if relevant.
    :vartype low: ~azure.healthinsights.radiologyinsights.models.Quantity
    :ivar high: High Range, if relevant.
    :vartype high: ~azure.healthinsights.radiologyinsights.models.Quantity
    :ivar type: Reference range qualifier.
    :vartype type: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar applies_to: Reference range population.
    :vartype applies_to: list[~azure.healthinsights.radiologyinsights.models.CodeableConcept]
    :ivar age: Applicable age range, if relevant.
    :vartype age: ~azure.healthinsights.radiologyinsights.models.Range
    :ivar text: Text based reference range in an observation.
    :vartype text: str
    """

    low: Optional["_models.Quantity"] = rest_field()
    """Low Range, if relevant."""
    high: Optional["_models.Quantity"] = rest_field()
    """High Range, if relevant."""
    type: Optional["_models.CodeableConcept"] = rest_field()
    """Reference range qualifier."""
    applies_to: Optional[List["_models.CodeableConcept"]] = rest_field(name="appliesTo")
    """Reference range population."""
    age: Optional["_models.Range"] = rest_field()
    """Applicable age range, if relevant."""
    text: Optional[str] = rest_field()
    """Text based reference range in an observation."""

    @overload
    def __init__(
        self,
        *,
        low: Optional["_models.Quantity"] = None,
        high: Optional["_models.Quantity"] = None,
        type: Optional["_models.CodeableConcept"] = None,
        applies_to: Optional[List["_models.CodeableConcept"]] = None,
        age: Optional["_models.Range"] = None,
        text: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class OrderedProcedure(_model_base.Model):
    """Procedure information.

    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar code: Procedure code.
    :vartype code: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar description: Procedure description.
    :vartype description: str
    """

    extension: Optional[List["_models.Extension"]] = rest_field()
    """Additional Content defined by implementations."""
    code: Optional["_models.CodeableConcept"] = rest_field()
    """Procedure code."""
    description: Optional[str] = rest_field()
    """Procedure description."""

    @overload
    def __init__(
        self,
        *,
        extension: Optional[List["_models.Extension"]] = None,
        code: Optional["_models.CodeableConcept"] = None,
        description: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class PatientDetails(_model_base.Model):
    """Patient structured information, including demographics and known structured clinical
    information.

    :ivar sex: The patient's sex. Known values are: "female", "male", and "unspecified".
    :vartype sex: str or ~azure.healthinsights.radiologyinsights.models.PatientSex
    :ivar birth_date: The patient's date of birth.
    :vartype birth_date: ~datetime.date
    :ivar clinical_info: Known clinical information for the patient, structured.
    :vartype clinical_info: list[~azure.healthinsights.radiologyinsights.models.Resource]
    """

    sex: Optional[Union[str, "_models.PatientSex"]] = rest_field()
    """The patient's sex. Known values are: \"female\", \"male\", and \"unspecified\"."""
    birth_date: Optional[datetime.date] = rest_field(name="birthDate")
    """The patient's date of birth."""
    clinical_info: Optional[List["_models.Resource"]] = rest_field(name="clinicalInfo")
    """Known clinical information for the patient, structured."""

    @overload
    def __init__(
        self,
        *,
        sex: Optional[Union[str, "_models.PatientSex"]] = None,
        birth_date: Optional[datetime.date] = None,
        clinical_info: Optional[List["_models.Resource"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class PatientDocument(_model_base.Model):
    """A clinical document related to a patient. Document here is in the wide sense - not just a text
    document (note).

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the patient document, such as 'note' (text document) or 'fhirBundle'
     (FHIR JSON document). Required. Known values are: "note", "fhirBundle", "dicom", and
     "genomicSequencing".
    :vartype type: str or ~azure.healthinsights.radiologyinsights.models.DocumentType
    :ivar clinical_type: The type of the clinical document. Known values are: "consultation",
     "dischargeSummary", "historyAndPhysical", "radiologyReport", "procedure", "progress",
     "laboratory", and "pathologyReport".
    :vartype clinical_type: str or
     ~azure.healthinsights.radiologyinsights.models.ClinicalDocumentType
    :ivar id: A given identifier for the document. Has to be unique across all documents for a
     single patient. Required.
    :vartype id: str
    :ivar language: A 2 letter ISO 639-1 representation of the language of the document.
    :vartype language: str
    :ivar created_date_time: The date and time when the document was created.
    :vartype created_date_time: ~datetime.datetime
    :ivar authors: Document author(s).
    :vartype authors: list[~azure.healthinsights.radiologyinsights.models.DocumentAuthor]
    :ivar specialty_type: specialty type the document. Known values are: "pathology" and
     "radiology".
    :vartype specialty_type: str or ~azure.healthinsights.radiologyinsights.models.SpecialtyType
    :ivar administrative_metadata: Administrative metadata for the document.
    :vartype administrative_metadata:
     ~azure.healthinsights.radiologyinsights.models.DocumentAdministrativeMetadata
    :ivar content: The content of the patient document. Required.
    :vartype content: ~azure.healthinsights.radiologyinsights.models.DocumentContent
    """

    type: Union[str, "_models.DocumentType"] = rest_field()
    """The type of the patient document, such as 'note' (text document) or 'fhirBundle' (FHIR JSON
     document). Required. Known values are: \"note\", \"fhirBundle\", \"dicom\", and
     \"genomicSequencing\"."""
    clinical_type: Optional[Union[str, "_models.ClinicalDocumentType"]] = rest_field(name="clinicalType")
    """The type of the clinical document. Known values are: \"consultation\", \"dischargeSummary\",
     \"historyAndPhysical\", \"radiologyReport\", \"procedure\", \"progress\", \"laboratory\", and
     \"pathologyReport\"."""
    id: str = rest_field()
    """A given identifier for the document. Has to be unique across all documents for a single
     patient. Required."""
    language: Optional[str] = rest_field()
    """A 2 letter ISO 639-1 representation of the language of the document."""
    created_date_time: Optional[datetime.datetime] = rest_field(name="createdDateTime", format="rfc3339")
    """The date and time when the document was created."""
    authors: Optional[List["_models.DocumentAuthor"]] = rest_field()
    """Document author(s)."""
    specialty_type: Optional[Union[str, "_models.SpecialtyType"]] = rest_field(name="specialtyType")
    """specialty type the document. Known values are: \"pathology\" and \"radiology\"."""
    administrative_metadata: Optional["_models.DocumentAdministrativeMetadata"] = rest_field(
        name="administrativeMetadata"
    )
    """Administrative metadata for the document."""
    content: "_models.DocumentContent" = rest_field()
    """The content of the patient document. Required."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.DocumentType"],
        id: str,  # pylint: disable=redefined-builtin
        content: "_models.DocumentContent",
        clinical_type: Optional[Union[str, "_models.ClinicalDocumentType"]] = None,
        language: Optional[str] = None,
        created_date_time: Optional[datetime.datetime] = None,
        authors: Optional[List["_models.DocumentAuthor"]] = None,
        specialty_type: Optional[Union[str, "_models.SpecialtyType"]] = None,
        administrative_metadata: Optional["_models.DocumentAdministrativeMetadata"] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class PatientRecord(_model_base.Model):
    """A patient record, including their clinical information and data.

    All required parameters must be populated in order to send to server.

    :ivar id: A given identifier for the patient. Has to be unique across all patients in a single
     request. Required.
    :vartype id: str
    :ivar info: Patient structured information, including demographics and known structured
     clinical information.
    :vartype info: ~azure.healthinsights.radiologyinsights.models.PatientDetails
    :ivar encounters: Patient encounters/visits.
    :vartype encounters: list[~azure.healthinsights.radiologyinsights.models.Encounter]
    :ivar patient_documents: Patient unstructured clinical data, given as documents.
    :vartype patient_documents:
     list[~azure.healthinsights.radiologyinsights.models.PatientDocument]
    """

    id: str = rest_field()
    """A given identifier for the patient. Has to be unique across all patients in a single request.
     Required."""
    info: Optional["_models.PatientDetails"] = rest_field()
    """Patient structured information, including demographics and known structured clinical
     information."""
    encounters: Optional[List["_models.Encounter"]] = rest_field()
    """Patient encounters/visits."""
    patient_documents: Optional[List["_models.PatientDocument"]] = rest_field(name="patientDocuments")
    """Patient unstructured clinical data, given as documents."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        info: Optional["_models.PatientDetails"] = None,
        encounters: Optional[List["_models.Encounter"]] = None,
        patient_documents: Optional[List["_models.PatientDocument"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Period(Element):
    """A time period defined by a start and end date and optionally time
    Based on `FHIR Period <https://www.hl7.org/fhir/R4/datatypes.html#Period>`_.

    :ivar start: Starting time with inclusive boundary.
    :vartype start: str
    :ivar end: End time with inclusive boundary, if not ongoing.
    :vartype end: str
    """

    start: Optional[str] = rest_field()
    """Starting time with inclusive boundary."""
    end: Optional[str] = rest_field()
    """End time with inclusive boundary, if not ongoing."""

    @overload
    def __init__(
        self,
        *,
        start: Optional[str] = None,
        end: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Quantity(Element):
    """A measured or measurable amount
    Based on `FHIR Quantity <https://www.hl7.org/fhir/R4/datatypes.html#Quantity>`_.

    :ivar value: Numerical value (with implicit precision).
    :vartype value: float
    :ivar comparator: < | <= | >= | > - how to understand the value.
    :vartype comparator: str
    :ivar unit: Unit representation.
    :vartype unit: str
    :ivar system: System that defines coded unit form.
    :vartype system: str
    :ivar code: Coded form of the unit.
    :vartype code: str
    """

    value: Optional[float] = rest_field()
    """Numerical value (with implicit precision)."""
    comparator: Optional[str] = rest_field()
    """< | <= | >= | > - how to understand the value."""
    unit: Optional[str] = rest_field()
    """Unit representation."""
    system: Optional[str] = rest_field()
    """System that defines coded unit form."""
    code: Optional[str] = rest_field()
    """Coded form of the unit."""

    @overload
    def __init__(
        self,
        *,
        value: Optional[float] = None,
        comparator: Optional[str] = None,
        unit: Optional[str] = None,
        system: Optional[str] = None,
        code: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class RadiologyCodeWithTypes(_model_base.Model):
    """Radiology code with types : used in imaging procedure recommendation for contrast and view.

    All required parameters must be populated in order to send to server.

    :ivar code: The SNOMED CT code indicates whether imaging was conducted with or without contrast
     in the case of contrast, and in the case of views, it denotes the number of views. Required.
    :vartype code: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar types: The collection of types will indicate the contrast substance used in the case of
     contrast and, in the case of views, it will specify the types of views, such as lateral and
     frontal, etc. Required.
    :vartype types: list[~azure.healthinsights.radiologyinsights.models.CodeableConcept]
    """

    code: "_models.CodeableConcept" = rest_field()
    """The SNOMED CT code indicates whether imaging was conducted with or without contrast in the case
     of contrast, and in the case of views, it denotes the number of views. Required."""
    types: List["_models.CodeableConcept"] = rest_field()
    """The collection of types will indicate the contrast substance used in the case of contrast and,
     in the case of views, it will specify the types of views, such as lateral and frontal, etc.
     Required."""

    @overload
    def __init__(
        self,
        *,
        code: "_models.CodeableConcept",
        types: List["_models.CodeableConcept"],
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class RadiologyInsightsData(_model_base.Model):
    """Contains the list of patients, and configuration data.

    All required parameters must be populated in order to send to server.

    :ivar patients: The list of patients, including their clinical information and data. Required.
    :vartype patients: list[~azure.healthinsights.radiologyinsights.models.PatientRecord]
    :ivar configuration: Configuration affecting the Radiology Insights model's inference.
    :vartype configuration:
     ~azure.healthinsights.radiologyinsights.models.RadiologyInsightsModelConfiguration
    """

    patients: List["_models.PatientRecord"] = rest_field()
    """The list of patients, including their clinical information and data. Required."""
    configuration: Optional["_models.RadiologyInsightsModelConfiguration"] = rest_field()
    """Configuration affecting the Radiology Insights model's inference."""

    @overload
    def __init__(
        self,
        *,
        patients: List["_models.PatientRecord"],
        configuration: Optional["_models.RadiologyInsightsModelConfiguration"] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class RadiologyInsightsInferenceOptions(_model_base.Model):
    """Options regarding follow up recommendation inferences and finding inferences.

    :ivar followup_recommendation_options: Follow-up recommendation options.
    :vartype followup_recommendation_options:
     ~azure.healthinsights.radiologyinsights.models.FollowupRecommendationOptions
    :ivar finding_options: Finding options.
    :vartype finding_options: ~azure.healthinsights.radiologyinsights.models.FindingOptions
    """

    followup_recommendation_options: Optional["_models.FollowupRecommendationOptions"] = rest_field(
        name="followupRecommendationOptions"
    )
    """Follow-up recommendation options."""
    finding_options: Optional["_models.FindingOptions"] = rest_field(name="findingOptions")
    """Finding options."""

    @overload
    def __init__(
        self,
        *,
        followup_recommendation_options: Optional["_models.FollowupRecommendationOptions"] = None,
        finding_options: Optional["_models.FindingOptions"] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class RadiologyInsightsInferenceResult(_model_base.Model):
    """The inference results for the Radiology Insights request. If field 'status' has value
    'succeeded', then field 'result' will contain an instance of RadiologyInsightsInferenceResult.

    All required parameters must be populated in order to send to server.

    :ivar patient_results: Results for the patients given in the request. Required.
    :vartype patient_results:
     list[~azure.healthinsights.radiologyinsights.models.RadiologyInsightsPatientResult]
    :ivar model_version: The version of the model used for inference, expressed as the model date.
     Required.
    :vartype model_version: str
    """

    patient_results: List["_models.RadiologyInsightsPatientResult"] = rest_field(name="patientResults")
    """Results for the patients given in the request. Required."""
    model_version: str = rest_field(name="modelVersion")
    """The version of the model used for inference, expressed as the model date. Required."""

    @overload
    def __init__(
        self,
        *,
        patient_results: List["_models.RadiologyInsightsPatientResult"],
        model_version: str,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class RadiologyInsightsModelConfiguration(_model_base.Model):
    """Configuration affecting the Radiology Insights model's inference.

    :ivar verbose: An indication whether the model should produce verbose output.
    :vartype verbose: bool
    :ivar include_evidence: An indication whether the model's output should include evidence for
     the inferences.
    :vartype include_evidence: bool
    :ivar inference_types: This is a list of inference types to be inferred for the current
     request. It could be used if only part of the Radiology Insights inferences are required. If
     this list is omitted or empty, the model will return all the inference types.
    :vartype inference_types: list[str or
     ~azure.healthinsights.radiologyinsights.models.RadiologyInsightsInferenceType]
    :ivar inference_options: Options regarding follow up recommendation inferences and finding
     inferences.
    :vartype inference_options:
     ~azure.healthinsights.radiologyinsights.models.RadiologyInsightsInferenceOptions
    :ivar locale: Local for the model to use. If not specified, the model will use the default
     locale.
    :vartype locale: str
    """

    verbose: Optional[bool] = rest_field()
    """An indication whether the model should produce verbose output."""
    include_evidence: Optional[bool] = rest_field(name="includeEvidence")
    """An indication whether the model's output should include evidence for the inferences."""
    inference_types: Optional[List[Union[str, "_models.RadiologyInsightsInferenceType"]]] = rest_field(
        name="inferenceTypes"
    )
    """This is a list of inference types to be inferred for the current request. It could be used if
     only part of the Radiology Insights inferences are required. If this list is omitted or empty,
     the model will return all the inference types."""
    inference_options: Optional["_models.RadiologyInsightsInferenceOptions"] = rest_field(name="inferenceOptions")
    """Options regarding follow up recommendation inferences and finding inferences."""
    locale: Optional[str] = rest_field()
    """Local for the model to use. If not specified, the model will use the default locale."""

    @overload
    def __init__(
        self,
        *,
        verbose: Optional[bool] = None,
        include_evidence: Optional[bool] = None,
        inference_types: Optional[List[Union[str, "_models.RadiologyInsightsInferenceType"]]] = None,
        inference_options: Optional["_models.RadiologyInsightsInferenceOptions"] = None,
        locale: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class RadiologyInsightsPatientResult(_model_base.Model):
    """Results of the model's work for a single patient.

    All required parameters must be populated in order to send to server.

    :ivar patient_id: Identifier given for the patient in the request. Required.
    :vartype patient_id: str
    :ivar inferences: The model's inferences for the given patient. Required.
    :vartype inferences:
     list[~azure.healthinsights.radiologyinsights.models.RadiologyInsightsInference]
    """

    patient_id: str = rest_field(name="patientId")
    """Identifier given for the patient in the request. Required."""
    inferences: List["_models.RadiologyInsightsInference"] = rest_field()
    """The model's inferences for the given patient. Required."""

    @overload
    def __init__(
        self,
        *,
        patient_id: str,
        inferences: List["_models.RadiologyInsightsInference"],
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class RadiologyInsightsResult(_model_base.Model):
    """Response for the Radiology Insights request.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The unique ID of the operation. Required.
    :vartype id: str
    :ivar status: The status of the operation. Required. Known values are: "notStarted", "running",
     "succeeded", "failed", and "canceled".
    :vartype status: str or ~azure.healthinsights.radiologyinsights.models.JobStatus
    :ivar created_date_time: The date and time when the processing job was created.
    :vartype created_date_time: ~datetime.datetime
    :ivar expiration_date_time: The date and time when the processing job is set to expire.
    :vartype expiration_date_time: ~datetime.datetime
    :ivar last_update_date_time: The date and time when the processing job was last updated.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar error: Error object that describes the error when status is "Failed".
    :vartype error: ~azure.healthinsights.radiologyinsights.models.Error
    :ivar result: The result of the operation.
    :vartype result:
     ~azure.healthinsights.radiologyinsights.models.RadiologyInsightsInferenceResult
    """

    id: str = rest_field(visibility=["read"])
    """The unique ID of the operation. Required."""
    status: Union[str, "_models.JobStatus"] = rest_field(visibility=["read"])
    """The status of the operation. Required. Known values are: \"notStarted\", \"running\",
     \"succeeded\", \"failed\", and \"canceled\"."""
    created_date_time: Optional[datetime.datetime] = rest_field(
        name="createdDateTime", visibility=["read"], format="rfc3339"
    )
    """The date and time when the processing job was created."""
    expiration_date_time: Optional[datetime.datetime] = rest_field(
        name="expirationDateTime", visibility=["read"], format="rfc3339"
    )
    """The date and time when the processing job is set to expire."""
    last_update_date_time: Optional[datetime.datetime] = rest_field(
        name="lastUpdateDateTime", visibility=["read"], format="rfc3339"
    )
    """The date and time when the processing job was last updated."""
    error: Optional["_models.Error"] = rest_field()
    """Error object that describes the error when status is \"Failed\"."""
    result: Optional["_models.RadiologyInsightsInferenceResult"] = rest_field()
    """The result of the operation."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.Error"] = None,
        result: Optional["_models.RadiologyInsightsInferenceResult"] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class RadiologyProcedureInference(RadiologyInsightsInference, discriminator="radiologyProcedure"):
    """Radiology procedures are the specific imaging studies or examinations ordered for the patient,
    extracted from the document information and text.

    All required parameters must be populated in order to send to server.

    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar kind: Inference type. Required. Radiology Procedure inference type
    :vartype kind: str or ~azure.healthinsights.radiologyinsights.models.RADIOLOGY_PROCEDURE
    :ivar procedure_codes: LOINC codes for the procedure.
    :vartype procedure_codes: list[~azure.healthinsights.radiologyinsights.models.CodeableConcept]
    :ivar imaging_procedures: Imaging procedures. Required.
    :vartype imaging_procedures:
     list[~azure.healthinsights.radiologyinsights.models.ImagingProcedure]
    :ivar ordered_procedure: Ordered procedure information from the document information or text.
     Required.
    :vartype ordered_procedure: ~azure.healthinsights.radiologyinsights.models.OrderedProcedure
    """

    kind: Literal[RadiologyInsightsInferenceType.RADIOLOGY_PROCEDURE] = rest_discriminator(name="kind")  # type: ignore
    """Inference type. Required. Radiology Procedure inference type"""
    procedure_codes: Optional[List["_models.CodeableConcept"]] = rest_field(name="procedureCodes")
    """LOINC codes for the procedure."""
    imaging_procedures: List["_models.ImagingProcedure"] = rest_field(name="imagingProcedures")
    """Imaging procedures. Required."""
    ordered_procedure: "_models.OrderedProcedure" = rest_field(name="orderedProcedure")
    """Ordered procedure information from the document information or text. Required."""

    @overload
    def __init__(
        self,
        *,
        imaging_procedures: List["_models.ImagingProcedure"],
        ordered_procedure: "_models.OrderedProcedure",
        extension: Optional[List["_models.Extension"]] = None,
        procedure_codes: Optional[List["_models.CodeableConcept"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=RadiologyInsightsInferenceType.RADIOLOGY_PROCEDURE, **kwargs)


class Range(Element):
    """A set of ordered Quantities defined by a low and high limit
    Based on `FHIR Range <https://www.hl7.org/fhir/R4/datatypes.html#Range>`_.

    :ivar low: Low limit.
    :vartype low: ~azure.healthinsights.radiologyinsights.models.Quantity
    :ivar high: High limit.
    :vartype high: ~azure.healthinsights.radiologyinsights.models.Quantity
    """

    low: Optional["_models.Quantity"] = rest_field()
    """Low limit."""
    high: Optional["_models.Quantity"] = rest_field()
    """High limit."""

    @overload
    def __init__(
        self,
        *,
        low: Optional["_models.Quantity"] = None,
        high: Optional["_models.Quantity"] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Ratio(Element):
    """A ratio of two Quantity values - a numerator and a denominator
    Based on `FHIR Ratio <https://www.hl7.org/fhir/R4/datatypes.html#Ratio>`_.

    :ivar numerator: Numerator value.
    :vartype numerator: ~azure.healthinsights.radiologyinsights.models.Quantity
    :ivar denominator: Denominator value.
    :vartype denominator: ~azure.healthinsights.radiologyinsights.models.Quantity
    """

    numerator: Optional["_models.Quantity"] = rest_field()
    """Numerator value."""
    denominator: Optional["_models.Quantity"] = rest_field()
    """Denominator value."""

    @overload
    def __init__(
        self,
        *,
        numerator: Optional["_models.Quantity"] = None,
        denominator: Optional["_models.Quantity"] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class RecommendationFinding(_model_base.Model):
    """Finding reference for recommendation.

    All required parameters must be populated in order to send to server.

    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar finding: Finding linked to a recommendation.
    :vartype finding: ~azure.healthinsights.radiologyinsights.models.Observation
    :ivar critical_finding: Critical result linked to a recommendation.
    :vartype critical_finding: ~azure.healthinsights.radiologyinsights.models.CriticalResult
    :ivar recommendation_finding_status: Recommendation finding status. Required. Known values are:
     "present", "differential", "ruleOut", and "conditional".
    :vartype recommendation_finding_status: str or
     ~azure.healthinsights.radiologyinsights.models.RecommendationFindingStatusType
    """

    extension: Optional[List["_models.Extension"]] = rest_field()
    """Additional Content defined by implementations."""
    finding: Optional["_models.Observation"] = rest_field()
    """Finding linked to a recommendation."""
    critical_finding: Optional["_models.CriticalResult"] = rest_field(name="criticalFinding")
    """Critical result linked to a recommendation."""
    recommendation_finding_status: Union[str, "_models.RecommendationFindingStatusType"] = rest_field(
        name="recommendationFindingStatus"
    )
    """Recommendation finding status. Required. Known values are: \"present\", \"differential\",
     \"ruleOut\", and \"conditional\"."""

    @overload
    def __init__(
        self,
        *,
        recommendation_finding_status: Union[str, "_models.RecommendationFindingStatusType"],
        extension: Optional[List["_models.Extension"]] = None,
        finding: Optional["_models.Observation"] = None,
        critical_finding: Optional["_models.CriticalResult"] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Reference(Element):
    """A reference from one resource to another
    Based on `FHIR Reference <https://www.hl7.org/fhir/R4/references.html>`_.

    :ivar reference: Literal reference, Relative, internal or absolute URL.
    :vartype reference: str
    :ivar type: Type the reference refers to (e.g. "Patient").
    :vartype type: str
    :ivar identifier: Logical reference, when literal reference is not known.
    :vartype identifier: ~azure.healthinsights.radiologyinsights.models.Identifier
    :ivar display: Text alternative for the resource.
    :vartype display: str
    """

    reference: Optional[str] = rest_field()
    """Literal reference, Relative, internal or absolute URL."""
    type: Optional[str] = rest_field()
    """Type the reference refers to (e.g. \"Patient\")."""
    identifier: Optional["_models.Identifier"] = rest_field()
    """Logical reference, when literal reference is not known."""
    display: Optional[str] = rest_field()
    """Text alternative for the resource."""

    @overload
    def __init__(
        self,
        *,
        reference: Optional[str] = None,
        type: Optional[str] = None,
        identifier: Optional["_models.Identifier"] = None,
        display: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ResearchStudy(DomainResource, discriminator="ResearchStudy"):  # pylint: disable=too-many-instance-attributes
    """Detailed information about Research Study
    Based on `FHIR ResearchStudy <https://www.hl7.org/fhir/R4/researchstudy.html>`_.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar meta: Metadata about the resource.
    :vartype meta: ~azure.healthinsights.radiologyinsights.models.Meta
    :ivar implicit_rules: A set of rules under which this content was created.
    :vartype implicit_rules: str
    :ivar language: Language of the resource content.
    :vartype language: str
    :ivar text: Text summary of the resource, for human interpretation.
    :vartype text: ~azure.healthinsights.radiologyinsights.models.Narrative
    :ivar contained: Contained, inline Resources.
    :vartype contained: list[~azure.healthinsights.radiologyinsights.models.Resource]
    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar modifier_extension: Extensions that cannot be ignored.
    :vartype modifier_extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar resource_type: resourceType. Required. Default value is "ResearchStudy".
    :vartype resource_type: str
    :ivar identifier: Business Identifier for study.
    :vartype identifier: list[~azure.healthinsights.radiologyinsights.models.Identifier]
    :ivar title: Name for this study.
    :vartype title: str
    :ivar protocol: Steps followed in executing study.
    :vartype protocol: list[~azure.healthinsights.radiologyinsights.models.Reference]
    :ivar part_of: Part of larger study.
    :vartype part_of: list[~azure.healthinsights.radiologyinsights.models.Reference]
    :ivar status: active | administratively-completed | approved | closed-to-accrual |
     closed-to-accrual-and-intervention | completed | disapproved | in-review |
     temporarily-closed-to-accrual | temporarily-closed-to-accrual-and-intervention | withdrawn.
     Required. Known values are: "active", "administratively-completed", "approved",
     "closed-to-accrual", "closed-to-accrual-and-intervention", "completed", "disapproved",
     "in-review", "temporarily-closed-to-accrual", "temporarily-closed-to-accrual-and-intervention",
     and "withdrawn".
    :vartype status: str or
     ~azure.healthinsights.radiologyinsights.models.ResearchStudyStatusCodeType
    :ivar primary_purpose_type: treatment | prevention | diagnostic | supportive-care | screening |
     health-services-research | basic-science | device-feasibility.
    :vartype primary_purpose_type: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar phase: n-a | early-phase-1 | phase-1 | phase-1-phase-2 | phase-2 | phase-2-phase-3 |
     phase-3 | phase-4.
    :vartype phase: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar category: Classifications for the study.
    :vartype category: list[~azure.healthinsights.radiologyinsights.models.CodeableConcept]
    :ivar focus: Drugs, devices, etc. under study.
    :vartype focus: list[~azure.healthinsights.radiologyinsights.models.CodeableConcept]
    :ivar condition: Condition being studied.
    :vartype condition: list[~azure.healthinsights.radiologyinsights.models.CodeableConcept]
    :ivar contact: Contact details for the study.
    :vartype contact: list[~azure.healthinsights.radiologyinsights.models.ContactDetail]
    :ivar keyword: Used to search for the study.
    :vartype keyword: list[~azure.healthinsights.radiologyinsights.models.CodeableConcept]
    :ivar location: Geographic region(s) for study.
    :vartype location: list[~azure.healthinsights.radiologyinsights.models.CodeableConcept]
    :ivar description: What this is study doing.
    :vartype description: str
    :ivar enrollment: Inclusion & exclusion criteria.
    :vartype enrollment: list[~azure.healthinsights.radiologyinsights.models.Reference]
    :ivar period: When the study began and ended.
    :vartype period: ~azure.healthinsights.radiologyinsights.models.Period
    :ivar sponsor: Organization that initiates and is legally responsible for the study.
    :vartype sponsor: ~azure.healthinsights.radiologyinsights.models.Reference
    :ivar principal_investigator: Researcher who oversees multiple aspects of the study.
    :vartype principal_investigator: ~azure.healthinsights.radiologyinsights.models.Reference
    :ivar site: Facility where study activities are conducted.
    :vartype site: list[~azure.healthinsights.radiologyinsights.models.Reference]
    :ivar reason_stopped: accrual-goal-met | closed-due-to-toxicity |
     closed-due-to-lack-of-study-progress | temporarily-closed-per-study-design.
    :vartype reason_stopped: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar note: Comments made about the study.
    :vartype note: list[~azure.healthinsights.radiologyinsights.models.Annotation]
    :ivar arm: Defined path through the study for a subject.
    :vartype arm: list[~azure.healthinsights.radiologyinsights.models.ResearchStudyArm]
    :ivar objective: A goal for the study.
    :vartype objective: list[~azure.healthinsights.radiologyinsights.models.ResearchStudyObjective]
    """

    resource_type: Literal["ResearchStudy"] = rest_discriminator(name="resourceType")  # type: ignore
    """resourceType. Required. Default value is \"ResearchStudy\"."""
    identifier: Optional[List["_models.Identifier"]] = rest_field()
    """Business Identifier for study."""
    title: Optional[str] = rest_field()
    """Name for this study."""
    protocol: Optional[List["_models.Reference"]] = rest_field()
    """Steps followed in executing study."""
    part_of: Optional[List["_models.Reference"]] = rest_field(name="partOf")
    """Part of larger study."""
    status: Union[str, "_models.ResearchStudyStatusCodeType"] = rest_field()
    """active | administratively-completed | approved | closed-to-accrual |
     closed-to-accrual-and-intervention | completed | disapproved | in-review |
     temporarily-closed-to-accrual | temporarily-closed-to-accrual-and-intervention | withdrawn.
     Required. Known values are: \"active\", \"administratively-completed\", \"approved\",
     \"closed-to-accrual\", \"closed-to-accrual-and-intervention\", \"completed\", \"disapproved\",
     \"in-review\", \"temporarily-closed-to-accrual\",
     \"temporarily-closed-to-accrual-and-intervention\", and \"withdrawn\"."""
    primary_purpose_type: Optional["_models.CodeableConcept"] = rest_field(name="primaryPurposeType")
    """treatment | prevention | diagnostic | supportive-care | screening | health-services-research |
     basic-science | device-feasibility."""
    phase: Optional["_models.CodeableConcept"] = rest_field()
    """n-a | early-phase-1 | phase-1 | phase-1-phase-2 | phase-2 | phase-2-phase-3 | phase-3 |
     phase-4."""
    category: Optional[List["_models.CodeableConcept"]] = rest_field()
    """Classifications for the study."""
    focus: Optional[List["_models.CodeableConcept"]] = rest_field()
    """Drugs, devices, etc. under study."""
    condition: Optional[List["_models.CodeableConcept"]] = rest_field()
    """Condition being studied."""
    contact: Optional[List["_models.ContactDetail"]] = rest_field()
    """Contact details for the study."""
    keyword: Optional[List["_models.CodeableConcept"]] = rest_field()
    """Used to search for the study."""
    location: Optional[List["_models.CodeableConcept"]] = rest_field()
    """Geographic region(s) for study."""
    description: Optional[str] = rest_field()
    """What this is study doing."""
    enrollment: Optional[List["_models.Reference"]] = rest_field()
    """Inclusion & exclusion criteria."""
    period: Optional["_models.Period"] = rest_field()
    """When the study began and ended."""
    sponsor: Optional["_models.Reference"] = rest_field()
    """Organization that initiates and is legally responsible for the study."""
    principal_investigator: Optional["_models.Reference"] = rest_field(name="principalInvestigator")
    """Researcher who oversees multiple aspects of the study."""
    site: Optional[List["_models.Reference"]] = rest_field()
    """Facility where study activities are conducted."""
    reason_stopped: Optional["_models.CodeableConcept"] = rest_field(name="reasonStopped")
    """accrual-goal-met | closed-due-to-toxicity | closed-due-to-lack-of-study-progress |
     temporarily-closed-per-study-design."""
    note: Optional[List["_models.Annotation"]] = rest_field()
    """Comments made about the study."""
    arm: Optional[List["_models.ResearchStudyArm"]] = rest_field()
    """Defined path through the study for a subject."""
    objective: Optional[List["_models.ResearchStudyObjective"]] = rest_field()
    """A goal for the study."""

    @overload
    def __init__(
        self,
        *,
        status: Union[str, "_models.ResearchStudyStatusCodeType"],
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        meta: Optional["_models.Meta"] = None,
        implicit_rules: Optional[str] = None,
        language: Optional[str] = None,
        text: Optional["_models.Narrative"] = None,
        contained: Optional[List["_models.Resource"]] = None,
        extension: Optional[List["_models.Extension"]] = None,
        modifier_extension: Optional[List["_models.Extension"]] = None,
        identifier: Optional[List["_models.Identifier"]] = None,
        title: Optional[str] = None,
        protocol: Optional[List["_models.Reference"]] = None,
        part_of: Optional[List["_models.Reference"]] = None,
        primary_purpose_type: Optional["_models.CodeableConcept"] = None,
        phase: Optional["_models.CodeableConcept"] = None,
        category: Optional[List["_models.CodeableConcept"]] = None,
        focus: Optional[List["_models.CodeableConcept"]] = None,
        condition: Optional[List["_models.CodeableConcept"]] = None,
        contact: Optional[List["_models.ContactDetail"]] = None,
        keyword: Optional[List["_models.CodeableConcept"]] = None,
        location: Optional[List["_models.CodeableConcept"]] = None,
        description: Optional[str] = None,
        enrollment: Optional[List["_models.Reference"]] = None,
        period: Optional["_models.Period"] = None,
        sponsor: Optional["_models.Reference"] = None,
        principal_investigator: Optional["_models.Reference"] = None,
        site: Optional[List["_models.Reference"]] = None,
        reason_stopped: Optional["_models.CodeableConcept"] = None,
        note: Optional[List["_models.Annotation"]] = None,
        arm: Optional[List["_models.ResearchStudyArm"]] = None,
        objective: Optional[List["_models.ResearchStudyObjective"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, resource_type="ResearchStudy", **kwargs)


class ResearchStudyArm(_model_base.Model):
    """ResearchStudyArm.

    All required parameters must be populated in order to send to server.

    :ivar name: Label for study arm. Required.
    :vartype name: str
    :ivar type: Categorization of study arm.
    :vartype type: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar description: Short explanation of study path.
    :vartype description: str
    """

    name: str = rest_field()
    """Label for study arm. Required."""
    type: Optional["_models.CodeableConcept"] = rest_field()
    """Categorization of study arm."""
    description: Optional[str] = rest_field()
    """Short explanation of study path."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        type: Optional["_models.CodeableConcept"] = None,
        description: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ResearchStudyObjective(_model_base.Model):
    """ResearchStudyObjective.

    All required parameters must be populated in order to send to server.

    :ivar name: Label for the objective. Required.
    :vartype name: str
    :ivar type: primary | secondary | exploratory.
    :vartype type: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    """

    name: str = rest_field()
    """Label for the objective. Required."""
    type: Optional["_models.CodeableConcept"] = rest_field()
    """primary | secondary | exploratory."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        type: Optional["_models.CodeableConcept"] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SampledData(Element):
    """A series of measurements taken by a device
    Based on `FHIR SampledData <https://www.hl7.org/fhir/R4/datatypes.html#SampledData>`_.

    All required parameters must be populated in order to send to server.

    :ivar origin: Zero value and units. Required.
    :vartype origin: ~azure.healthinsights.radiologyinsights.models.Quantity
    :ivar period: Number of milliseconds between samples. Required.
    :vartype period: float
    :ivar factor: Multiply data by this before adding to origin.
    :vartype factor: float
    :ivar lower_limit: Lower limit of detection.
    :vartype lower_limit: float
    :ivar upper_limit: Upper limit of detection.
    :vartype upper_limit: float
    :ivar dimensions: Number of sample points at each time point. Required.
    :vartype dimensions: int
    :ivar data: Decimal values with spaces, or "E" | "U" | "L".
    :vartype data: str
    """

    origin: "_models.Quantity" = rest_field()
    """Zero value and units. Required."""
    period: float = rest_field()
    """Number of milliseconds between samples. Required."""
    factor: Optional[float] = rest_field()
    """Multiply data by this before adding to origin."""
    lower_limit: Optional[float] = rest_field(name="lowerLimit")
    """Lower limit of detection."""
    upper_limit: Optional[float] = rest_field(name="upperLimit")
    """Upper limit of detection."""
    dimensions: int = rest_field()
    """Number of sample points at each time point. Required."""
    data: Optional[str] = rest_field()
    """Decimal values with spaces, or \"E\" | \"U\" | \"L\"."""

    @overload
    def __init__(
        self,
        *,
        origin: "_models.Quantity",
        period: float,
        dimensions: int,
        factor: Optional[float] = None,
        lower_limit: Optional[float] = None,
        upper_limit: Optional[float] = None,
        data: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SexMismatchInference(RadiologyInsightsInference, discriminator="sexMismatch"):
    """A notification for a sex mismatch is displayed when the gender, personal pronouns,
    gender-related body parts, or gender-related procedures mentioned in a patient's clinical
    document are either inconsistent or do not match the gender specified in the patient
    information.

    All required parameters must be populated in order to send to server.

    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar kind: Inference type. Required. Sex mismatch inference type
    :vartype kind: str or ~azure.healthinsights.radiologyinsights.models.SEX_MISMATCH
    :ivar sex_indication: Sex indication : SNOMED CT code for gender finding. Required.
    :vartype sex_indication: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    """

    kind: Literal[RadiologyInsightsInferenceType.SEX_MISMATCH] = rest_discriminator(name="kind")  # type: ignore
    """Inference type. Required. Sex mismatch inference type"""
    sex_indication: "_models.CodeableConcept" = rest_field(name="sexIndication")
    """Sex indication : SNOMED CT code for gender finding. Required."""

    @overload
    def __init__(
        self,
        *,
        sex_indication: "_models.CodeableConcept",
        extension: Optional[List["_models.Extension"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=RadiologyInsightsInferenceType.SEX_MISMATCH, **kwargs)


class TimePeriod(_model_base.Model):
    """A duration of time during which an event is happening.

    :ivar start: Starting time with inclusive boundary.
    :vartype start: ~datetime.datetime
    :ivar end: End time with inclusive boundary, if not ongoing.
    :vartype end: ~datetime.datetime
    """

    start: Optional[datetime.datetime] = rest_field(format="rfc3339")
    """Starting time with inclusive boundary."""
    end: Optional[datetime.datetime] = rest_field(format="rfc3339")
    """End time with inclusive boundary, if not ongoing."""

    @overload
    def __init__(
        self,
        *,
        start: Optional[datetime.datetime] = None,
        end: Optional[datetime.datetime] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)
