# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import json
import sys
from typing import Any, Callable, Dict, IO, List, Optional, Type, TypeVar, Union, cast, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.polling.async_base_polling import AsyncLROBasePolling
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import _model_base, models as _models
from ..._model_base import SdkJSONEncoder, _deserialize
from ..._operations._operations import (
    build_face_administration_add_face_list_face_from_url_request,
    build_face_administration_add_face_list_face_request,
    build_face_administration_add_large_face_list_face_from_url_request,
    build_face_administration_add_large_face_list_face_request,
    build_face_administration_add_large_person_group_person_face_from_url_request,
    build_face_administration_add_large_person_group_person_face_request,
    build_face_administration_add_person_face_from_url_request,
    build_face_administration_add_person_face_request,
    build_face_administration_add_person_group_person_face_from_url_request,
    build_face_administration_add_person_group_person_face_request,
    build_face_administration_create_dynamic_person_group_request,
    build_face_administration_create_dynamic_person_group_with_person_request,
    build_face_administration_create_face_list_request,
    build_face_administration_create_large_face_list_request,
    build_face_administration_create_large_person_group_person_request,
    build_face_administration_create_large_person_group_request,
    build_face_administration_create_person_group_person_request,
    build_face_administration_create_person_group_request,
    build_face_administration_create_person_request,
    build_face_administration_delete_dynamic_person_group_request,
    build_face_administration_delete_face_list_face_request,
    build_face_administration_delete_face_list_request,
    build_face_administration_delete_large_face_list_face_request,
    build_face_administration_delete_large_face_list_request,
    build_face_administration_delete_large_person_group_person_face_request,
    build_face_administration_delete_large_person_group_person_request,
    build_face_administration_delete_large_person_group_request,
    build_face_administration_delete_person_face_request,
    build_face_administration_delete_person_group_person_face_request,
    build_face_administration_delete_person_group_person_request,
    build_face_administration_delete_person_group_request,
    build_face_administration_delete_person_request,
    build_face_administration_get_dynamic_person_group_persons_request,
    build_face_administration_get_dynamic_person_group_references_request,
    build_face_administration_get_dynamic_person_group_request,
    build_face_administration_get_dynamic_person_groups_request,
    build_face_administration_get_face_list_request,
    build_face_administration_get_face_lists_request,
    build_face_administration_get_large_face_list_face_request,
    build_face_administration_get_large_face_list_faces_request,
    build_face_administration_get_large_face_list_request,
    build_face_administration_get_large_face_list_training_status_request,
    build_face_administration_get_large_face_lists_request,
    build_face_administration_get_large_person_group_person_face_request,
    build_face_administration_get_large_person_group_person_request,
    build_face_administration_get_large_person_group_persons_request,
    build_face_administration_get_large_person_group_request,
    build_face_administration_get_large_person_group_training_status_request,
    build_face_administration_get_large_person_groups_request,
    build_face_administration_get_person_face_request,
    build_face_administration_get_person_faces_request,
    build_face_administration_get_person_group_person_face_request,
    build_face_administration_get_person_group_person_request,
    build_face_administration_get_person_group_persons_request,
    build_face_administration_get_person_group_request,
    build_face_administration_get_person_group_training_status_request,
    build_face_administration_get_person_groups_request,
    build_face_administration_get_person_request,
    build_face_administration_get_persons_request,
    build_face_administration_train_large_face_list_request,
    build_face_administration_train_large_person_group_request,
    build_face_administration_train_person_group_request,
    build_face_administration_update_dynamic_person_group_request,
    build_face_administration_update_dynamic_person_group_with_person_changes_request,
    build_face_administration_update_face_list_request,
    build_face_administration_update_large_face_list_face_request,
    build_face_administration_update_large_face_list_request,
    build_face_administration_update_large_person_group_person_face_request,
    build_face_administration_update_large_person_group_person_request,
    build_face_administration_update_large_person_group_request,
    build_face_administration_update_person_face_request,
    build_face_administration_update_person_group_person_face_request,
    build_face_administration_update_person_group_person_request,
    build_face_administration_update_person_group_request,
    build_face_administration_update_person_request,
    build_face_detect_from_url_request,
    build_face_detect_request,
    build_face_find_similar_from_face_list_request,
    build_face_find_similar_from_large_face_list_request,
    build_face_find_similar_request,
    build_face_group_request,
    build_face_identify_from_dynamic_person_group_request,
    build_face_identify_from_large_person_group_request,
    build_face_identify_from_person_directory_request,
    build_face_identify_from_person_group_request,
    build_face_session_create_liveness_session_request,
    build_face_session_create_liveness_with_verify_session_request,
    build_face_session_create_liveness_with_verify_session_with_verify_image_request,
    build_face_session_delete_liveness_session_request,
    build_face_session_delete_liveness_with_verify_session_request,
    build_face_session_get_liveness_session_audit_entries_request,
    build_face_session_get_liveness_session_result_request,
    build_face_session_get_liveness_sessions_request,
    build_face_session_get_liveness_with_verify_session_audit_entries_request,
    build_face_session_get_liveness_with_verify_session_result_request,
    build_face_session_get_liveness_with_verify_sessions_request,
    build_face_verify_face_to_face_request,
    build_face_verify_from_large_person_group_request,
    build_face_verify_from_person_directory_request,
    build_face_verify_from_person_group_request,
)
from ..._vendor import prepare_multipart_form_data
from .._vendor import FaceAdministrationClientMixinABC, FaceClientMixinABC, FaceSessionClientMixinABC

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
_Unset: Any = object()
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class FaceClientOperationsMixin(FaceClientMixinABC):

    @overload
    async def _detect_from_url(
        self,
        body: JSON,
        *,
        content_type: str = "application/json",
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        recognition_model: Optional[Union[str, _models.FaceRecognitionModel]] = None,
        return_face_id: Optional[bool] = None,
        return_face_attributes: Optional[List[Union[str, _models.FaceAttributeType]]] = None,
        return_face_landmarks: Optional[bool] = None,
        return_recognition_model: Optional[bool] = None,
        face_id_time_to_live: Optional[int] = None,
        **kwargs: Any
    ) -> List[_models.FaceDetectionResult]: ...
    @overload
    async def _detect_from_url(
        self,
        *,
        url: str,
        content_type: str = "application/json",
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        recognition_model: Optional[Union[str, _models.FaceRecognitionModel]] = None,
        return_face_id: Optional[bool] = None,
        return_face_attributes: Optional[List[Union[str, _models.FaceAttributeType]]] = None,
        return_face_landmarks: Optional[bool] = None,
        return_recognition_model: Optional[bool] = None,
        face_id_time_to_live: Optional[int] = None,
        **kwargs: Any
    ) -> List[_models.FaceDetectionResult]: ...
    @overload
    async def _detect_from_url(
        self,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        recognition_model: Optional[Union[str, _models.FaceRecognitionModel]] = None,
        return_face_id: Optional[bool] = None,
        return_face_attributes: Optional[List[Union[str, _models.FaceAttributeType]]] = None,
        return_face_landmarks: Optional[bool] = None,
        return_recognition_model: Optional[bool] = None,
        face_id_time_to_live: Optional[int] = None,
        **kwargs: Any
    ) -> List[_models.FaceDetectionResult]: ...

    @distributed_trace_async
    async def _detect_from_url(
        self,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        url: str = _Unset,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        recognition_model: Optional[Union[str, _models.FaceRecognitionModel]] = None,
        return_face_id: Optional[bool] = None,
        return_face_attributes: Optional[List[Union[str, _models.FaceAttributeType]]] = None,
        return_face_landmarks: Optional[bool] = None,
        return_recognition_model: Optional[bool] = None,
        face_id_time_to_live: Optional[int] = None,
        **kwargs: Any
    ) -> List[_models.FaceDetectionResult]:
        # pylint: disable=line-too-long
        """Detect human faces in an image, return face rectangles, and optionally with faceIds, landmarks,
        and attributes.

        ..

           [!IMPORTANT]
           To mitigate potential misuse that can subject people to stereotyping, discrimination, or
        unfair denial of services, we are retiring Face API attributes that predict emotion, gender,
        age, smile, facial hair, hair, and makeup. Read more about this decision
        https://azure.microsoft.com/blog/responsible-ai-investments-and-safeguards-for-facial-recognition/.


        *


        * No image will be stored. Only the extracted face feature(s) will be stored on server. The
        faceId is an identifier of the face feature and will be used in "Identify", "Verify", and "Find
        Similar". The stored face features will expire and be deleted at the time specified by
        faceIdTimeToLive after the original detection call.
        * Optional parameters include faceId, landmarks, and attributes. Attributes include headPose,
        glasses, occlusion, accessories, blur, exposure, noise, mask, and qualityForRecognition. Some
        of the results returned for specific attributes may not be highly accurate.
        * JPEG, PNG, GIF (the first frame), and BMP format are supported. The allowed image file size
        is from 1KB to 6MB.
        * The minimum detectable face size is 36x36 pixels in an image no larger than 1920x1080 pixels.
        Images with dimensions higher than 1920x1080 pixels will need a proportionally larger minimum
        face size.
        * Up to 100 faces can be returned for an image. Faces are ranked by face rectangle size from
        large to small.
        * For optimal results when querying "Identify", "Verify", and "Find Similar" ('returnFaceId' is
        true), please use faces that are: frontal, clear, and with a minimum size of 200x200 pixels
        (100 pixels between eyes).
        * Different 'detectionModel' values can be provided. To use and compare different detection
        models, please refer to
        https://learn.microsoft.com/azure/ai-services/computer-vision/how-to/specify-detection-model

          * 'detection_02': Face attributes and landmarks are disabled if you choose this detection
        model.
          * 'detection_03': Face attributes (mask and headPose only) and landmarks are supported if you
        choose this detection model.

        * Different 'recognitionModel' values are provided. If follow-up operations like "Verify",
        "Identify", "Find Similar" are needed, please specify the recognition model with
        'recognitionModel' parameter. The default value for 'recognitionModel' is 'recognition_01', if
        latest model needed, please explicitly specify the model you need in this parameter. Once
        specified, the detected faceIds will be associated with the specified recognition model. More
        details, please refer to
        https://learn.microsoft.com/azure/ai-services/computer-vision/how-to/specify-recognition-model.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword url: URL of input image. Required.
        :paramtype url: str
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword recognition_model: The 'recognitionModel' associated with the detected faceIds.
         Supported 'recognitionModel' values include 'recognition_01', 'recognition_02',
         'recognition_03' or 'recognition_04'. The default value is 'recognition_01'. 'recognition_04'
         is recommended since its accuracy is improved on faces wearing masks compared with
         'recognition_03', and its overall accuracy is improved compared with 'recognition_01' and
         'recognition_02'. Known values are: "recognition_01", "recognition_02", "recognition_03", and
         "recognition_04". Default value is None.
        :paramtype recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :keyword return_face_id: Return faceIds of the detected faces or not. The default value is
         true. Default value is None.
        :paramtype return_face_id: bool
        :keyword return_face_attributes: Analyze and return the one or more specified face attributes
         in the comma-separated string like 'returnFaceAttributes=headPose,glasses'. Face attribute
         analysis has additional computational and time cost. Default value is None.
        :paramtype return_face_attributes: list[str or ~azure.ai.vision.face.models.FaceAttributeType]
        :keyword return_face_landmarks: Return face landmarks of the detected faces or not. The default
         value is false. Default value is None.
        :paramtype return_face_landmarks: bool
        :keyword return_recognition_model: Return 'recognitionModel' or not. The default value is
         false. This is only applicable when returnFaceId = true. Default value is None.
        :paramtype return_recognition_model: bool
        :keyword face_id_time_to_live: The number of seconds for the face ID being cached. Supported
         range from 60 seconds up to 86400 seconds. The default value is 86400 (24 hours). Default value
         is None.
        :paramtype face_id_time_to_live: int
        :return: list of FaceDetectionResult
        :rtype: list[~azure.ai.vision.face.models.FaceDetectionResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "url": "str"  # URL of input image. Required.
                }

                # response body for status code(s): 200
                response == [
                    {
                        "faceRectangle": {
                            "height": 0,  # The height of the rectangle, in pixels.
                              Required.
                            "left": 0,  # The distance from the left edge if the image to
                              the left edge of the rectangle, in pixels. Required.
                            "top": 0,  # The distance from the top edge if the image to
                              the top edge of the rectangle, in pixels. Required.
                            "width": 0  # The width of the rectangle, in pixels.
                              Required.
                        },
                        "faceAttributes": {
                            "accessories": [
                                {
                                    "confidence": 0.0,  # Confidence level of the
                                      accessory type. Range between [0,1]. Required.
                                    "type": "str"  # Type of the accessory.
                                      Required. Known values are: "headwear", "glasses", and "mask".
                                }
                            ],
                            "age": 0.0,  # Optional. Age in years.
                            "blur": {
                                "blurLevel": "str",  # An enum value indicating level
                                  of blurriness. Required. Known values are: "low", "medium", and
                                  "high".
                                "value": 0.0  # A number indicating level of
                                  blurriness ranging from 0 to 1. Required.
                            },
                            "exposure": {
                                "exposureLevel": "str",  # An enum value indicating
                                  level of exposure. Required. Known values are: "underExposure",
                                  "goodExposure", and "overExposure".
                                "value": 0.0  # A number indicating level of exposure
                                  level ranging from 0 to 1. [0, 0.25) is under exposure. [0.25, 0.75)
                                  is good exposure. [0.75, 1] is over exposure. Required.
                            },
                            "facialHair": {
                                "beard": 0.0,  # A number ranging from 0 to 1
                                  indicating a level of confidence associated with a property.
                                  Required.
                                "moustache": 0.0,  # A number ranging from 0 to 1
                                  indicating a level of confidence associated with a property.
                                  Required.
                                "sideburns": 0.0  # A number ranging from 0 to 1
                                  indicating a level of confidence associated with a property.
                                  Required.
                            },
                            "glasses": "str",  # Optional. Glasses type if any of the
                              face. Known values are: "noGlasses", "readingGlasses", "sunglasses", and
                              "swimmingGoggles".
                            "hair": {
                                "bald": 0.0,  # A number describing confidence level
                                  of whether the person is bald. Required.
                                "hairColor": [
                                    {
                                        "color": "str",  # Name of the hair
                                          color. Required. Known values are: "unknown", "white",
                                          "gray", "blond", "brown", "red", "black", and "other".
                                        "confidence": 0.0  # Confidence level
                                          of the color. Range between [0,1]. Required.
                                    }
                                ],
                                "invisible": bool  # A boolean value describing
                                  whether the hair is visible in the image. Required.
                            },
                            "headPose": {
                                "pitch": 0.0,  # Value of angles. Required.
                                "roll": 0.0,  # Value of angles. Required.
                                "yaw": 0.0  # Value of angles. Required.
                            },
                            "mask": {
                                "noseAndMouthCovered": bool,  # A boolean value
                                  indicating whether nose and mouth are covered. Required.
                                "type": "str"  # Type of the mask. Required. Known
                                  values are: "faceMask", "noMask", "otherMaskOrOcclusion", and
                                  "uncertain".
                            },
                            "noise": {
                                "noiseLevel": "str",  # An enum value indicating
                                  level of noise. Required. Known values are: "low", "medium", and
                                  "high".
                                "value": 0.0  # A number indicating level of noise
                                  level ranging from 0 to 1. [0, 0.25) is under exposure. [0.25, 0.75)
                                  is good exposure. [0.75, 1] is over exposure. [0, 0.3) is low noise
                                  level. [0.3, 0.7) is medium noise level. [0.7, 1] is high noise
                                  level. Required.
                            },
                            "occlusion": {
                                "eyeOccluded": bool,  # A boolean value indicating
                                  whether eyes are occluded. Required.
                                "foreheadOccluded": bool,  # A boolean value
                                  indicating whether forehead is occluded. Required.
                                "mouthOccluded": bool  # A boolean value indicating
                                  whether the mouth is occluded. Required.
                            },
                            "qualityForRecognition": "str",  # Optional. Properties
                              describing the overall image quality regarding whether the image being
                              used in the detection is of sufficient quality to attempt face
                              recognition on. Known values are: "low", "medium", and "high".
                            "smile": 0.0  # Optional. Smile intensity, a number between
                              [0,1].
                        },
                        "faceId": "str",  # Optional. Unique faceId of the detected face,
                          created by detection API and it will expire 24 hours after the detection
                          call. To return this, it requires 'returnFaceId' parameter to be true.
                        "faceLandmarks": {
                            "eyeLeftBottom": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyeLeftInner": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyeLeftOuter": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyeLeftTop": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyeRightBottom": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyeRightInner": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyeRightOuter": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyeRightTop": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyebrowLeftInner": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyebrowLeftOuter": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyebrowRightInner": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyebrowRightOuter": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "mouthLeft": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "mouthRight": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "noseLeftAlarOutTip": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "noseLeftAlarTop": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "noseRightAlarOutTip": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "noseRightAlarTop": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "noseRootLeft": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "noseRootRight": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "noseTip": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "pupilLeft": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "pupilRight": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "underLipBottom": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "underLipTop": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "upperLipBottom": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "upperLipTop": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            }
                        },
                        "recognitionModel": "str"  # Optional. The 'recognitionModel'
                          associated with this faceId. This is only returned when
                          'returnRecognitionModel' is explicitly set as true. Known values are:
                          "recognition_01", "recognition_02", "recognition_03", and "recognition_04".
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("content-type", None))
        cls: ClsType[List[_models.FaceDetectionResult]] = kwargs.pop("cls", None)

        if body is _Unset:
            if url is _Unset:
                raise TypeError("missing required argument: url")
            body = {"url": url}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_detect_from_url_request(
            detection_model=detection_model,
            recognition_model=recognition_model,
            return_face_id=return_face_id,
            return_face_attributes=return_face_attributes,
            return_face_landmarks=return_face_landmarks,
            return_recognition_model=return_recognition_model,
            face_id_time_to_live=face_id_time_to_live,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.FaceDetectionResult], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def _detect(
        self,
        image_content: bytes,
        *,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        recognition_model: Optional[Union[str, _models.FaceRecognitionModel]] = None,
        return_face_id: Optional[bool] = None,
        return_face_attributes: Optional[List[Union[str, _models.FaceAttributeType]]] = None,
        return_face_landmarks: Optional[bool] = None,
        return_recognition_model: Optional[bool] = None,
        face_id_time_to_live: Optional[int] = None,
        **kwargs: Any
    ) -> List[_models.FaceDetectionResult]:
        # pylint: disable=line-too-long
        """Detect human faces in an image, return face rectangles, and optionally with faceIds, landmarks,
        and attributes.

        ..

           [!IMPORTANT]
           To mitigate potential misuse that can subject people to stereotyping, discrimination, or
        unfair denial of services, we are retiring Face API attributes that predict emotion, gender,
        age, smile, facial hair, hair, and makeup. Read more about this decision
        https://azure.microsoft.com/blog/responsible-ai-investments-and-safeguards-for-facial-recognition/.


        *


        * No image will be stored. Only the extracted face feature(s) will be stored on server. The
        faceId is an identifier of the face feature and will be used in "Identify", "Verify", and "Find
        Similar". The stored face features will expire and be deleted at the time specified by
        faceIdTimeToLive after the original detection call.
        * Optional parameters include faceId, landmarks, and attributes. Attributes include headPose,
        glasses, occlusion, accessories, blur, exposure, noise, mask, and qualityForRecognition. Some
        of the results returned for specific attributes may not be highly accurate.
        * JPEG, PNG, GIF (the first frame), and BMP format are supported. The allowed image file size
        is from 1KB to 6MB.
        * The minimum detectable face size is 36x36 pixels in an image no larger than 1920x1080 pixels.
        Images with dimensions higher than 1920x1080 pixels will need a proportionally larger minimum
        face size.
        * Up to 100 faces can be returned for an image. Faces are ranked by face rectangle size from
        large to small.
        * For optimal results when querying "Identify", "Verify", and "Find Similar" ('returnFaceId' is
        true), please use faces that are: frontal, clear, and with a minimum size of 200x200 pixels
        (100 pixels between eyes).
        * Different 'detectionModel' values can be provided. To use and compare different detection
        models, please refer to
        https://learn.microsoft.com/azure/ai-services/computer-vision/how-to/specify-detection-model

          * 'detection_02': Face attributes and landmarks are disabled if you choose this detection
        model.
          * 'detection_03': Face attributes (mask and headPose only) and landmarks are supported if you
        choose this detection model.

        * Different 'recognitionModel' values are provided. If follow-up operations like "Verify",
        "Identify", "Find Similar" are needed, please specify the recognition model with
        'recognitionModel' parameter. The default value for 'recognitionModel' is 'recognition_01', if
        latest model needed, please explicitly specify the model you need in this parameter. Once
        specified, the detected faceIds will be associated with the specified recognition model. More
        details, please refer to
        https://learn.microsoft.com/azure/ai-services/computer-vision/how-to/specify-recognition-model.

        :param image_content: The input image binary. Required.
        :type image_content: bytes
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword recognition_model: The 'recognitionModel' associated with the detected faceIds.
         Supported 'recognitionModel' values include 'recognition_01', 'recognition_02',
         'recognition_03' or 'recognition_04'. The default value is 'recognition_01'. 'recognition_04'
         is recommended since its accuracy is improved on faces wearing masks compared with
         'recognition_03', and its overall accuracy is improved compared with 'recognition_01' and
         'recognition_02'. Known values are: "recognition_01", "recognition_02", "recognition_03", and
         "recognition_04". Default value is None.
        :paramtype recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :keyword return_face_id: Return faceIds of the detected faces or not. The default value is
         true. Default value is None.
        :paramtype return_face_id: bool
        :keyword return_face_attributes: Analyze and return the one or more specified face attributes
         in the comma-separated string like 'returnFaceAttributes=headPose,glasses'. Face attribute
         analysis has additional computational and time cost. Default value is None.
        :paramtype return_face_attributes: list[str or ~azure.ai.vision.face.models.FaceAttributeType]
        :keyword return_face_landmarks: Return face landmarks of the detected faces or not. The default
         value is false. Default value is None.
        :paramtype return_face_landmarks: bool
        :keyword return_recognition_model: Return 'recognitionModel' or not. The default value is
         false. This is only applicable when returnFaceId = true. Default value is None.
        :paramtype return_recognition_model: bool
        :keyword face_id_time_to_live: The number of seconds for the face ID being cached. Supported
         range from 60 seconds up to 86400 seconds. The default value is 86400 (24 hours). Default value
         is None.
        :paramtype face_id_time_to_live: int
        :return: list of FaceDetectionResult
        :rtype: list[~azure.ai.vision.face.models.FaceDetectionResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "faceRectangle": {
                            "height": 0,  # The height of the rectangle, in pixels.
                              Required.
                            "left": 0,  # The distance from the left edge if the image to
                              the left edge of the rectangle, in pixels. Required.
                            "top": 0,  # The distance from the top edge if the image to
                              the top edge of the rectangle, in pixels. Required.
                            "width": 0  # The width of the rectangle, in pixels.
                              Required.
                        },
                        "faceAttributes": {
                            "accessories": [
                                {
                                    "confidence": 0.0,  # Confidence level of the
                                      accessory type. Range between [0,1]. Required.
                                    "type": "str"  # Type of the accessory.
                                      Required. Known values are: "headwear", "glasses", and "mask".
                                }
                            ],
                            "age": 0.0,  # Optional. Age in years.
                            "blur": {
                                "blurLevel": "str",  # An enum value indicating level
                                  of blurriness. Required. Known values are: "low", "medium", and
                                  "high".
                                "value": 0.0  # A number indicating level of
                                  blurriness ranging from 0 to 1. Required.
                            },
                            "exposure": {
                                "exposureLevel": "str",  # An enum value indicating
                                  level of exposure. Required. Known values are: "underExposure",
                                  "goodExposure", and "overExposure".
                                "value": 0.0  # A number indicating level of exposure
                                  level ranging from 0 to 1. [0, 0.25) is under exposure. [0.25, 0.75)
                                  is good exposure. [0.75, 1] is over exposure. Required.
                            },
                            "facialHair": {
                                "beard": 0.0,  # A number ranging from 0 to 1
                                  indicating a level of confidence associated with a property.
                                  Required.
                                "moustache": 0.0,  # A number ranging from 0 to 1
                                  indicating a level of confidence associated with a property.
                                  Required.
                                "sideburns": 0.0  # A number ranging from 0 to 1
                                  indicating a level of confidence associated with a property.
                                  Required.
                            },
                            "glasses": "str",  # Optional. Glasses type if any of the
                              face. Known values are: "noGlasses", "readingGlasses", "sunglasses", and
                              "swimmingGoggles".
                            "hair": {
                                "bald": 0.0,  # A number describing confidence level
                                  of whether the person is bald. Required.
                                "hairColor": [
                                    {
                                        "color": "str",  # Name of the hair
                                          color. Required. Known values are: "unknown", "white",
                                          "gray", "blond", "brown", "red", "black", and "other".
                                        "confidence": 0.0  # Confidence level
                                          of the color. Range between [0,1]. Required.
                                    }
                                ],
                                "invisible": bool  # A boolean value describing
                                  whether the hair is visible in the image. Required.
                            },
                            "headPose": {
                                "pitch": 0.0,  # Value of angles. Required.
                                "roll": 0.0,  # Value of angles. Required.
                                "yaw": 0.0  # Value of angles. Required.
                            },
                            "mask": {
                                "noseAndMouthCovered": bool,  # A boolean value
                                  indicating whether nose and mouth are covered. Required.
                                "type": "str"  # Type of the mask. Required. Known
                                  values are: "faceMask", "noMask", "otherMaskOrOcclusion", and
                                  "uncertain".
                            },
                            "noise": {
                                "noiseLevel": "str",  # An enum value indicating
                                  level of noise. Required. Known values are: "low", "medium", and
                                  "high".
                                "value": 0.0  # A number indicating level of noise
                                  level ranging from 0 to 1. [0, 0.25) is under exposure. [0.25, 0.75)
                                  is good exposure. [0.75, 1] is over exposure. [0, 0.3) is low noise
                                  level. [0.3, 0.7) is medium noise level. [0.7, 1] is high noise
                                  level. Required.
                            },
                            "occlusion": {
                                "eyeOccluded": bool,  # A boolean value indicating
                                  whether eyes are occluded. Required.
                                "foreheadOccluded": bool,  # A boolean value
                                  indicating whether forehead is occluded. Required.
                                "mouthOccluded": bool  # A boolean value indicating
                                  whether the mouth is occluded. Required.
                            },
                            "qualityForRecognition": "str",  # Optional. Properties
                              describing the overall image quality regarding whether the image being
                              used in the detection is of sufficient quality to attempt face
                              recognition on. Known values are: "low", "medium", and "high".
                            "smile": 0.0  # Optional. Smile intensity, a number between
                              [0,1].
                        },
                        "faceId": "str",  # Optional. Unique faceId of the detected face,
                          created by detection API and it will expire 24 hours after the detection
                          call. To return this, it requires 'returnFaceId' parameter to be true.
                        "faceLandmarks": {
                            "eyeLeftBottom": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyeLeftInner": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyeLeftOuter": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyeLeftTop": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyeRightBottom": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyeRightInner": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyeRightOuter": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyeRightTop": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyebrowLeftInner": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyebrowLeftOuter": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyebrowRightInner": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyebrowRightOuter": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "mouthLeft": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "mouthRight": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "noseLeftAlarOutTip": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "noseLeftAlarTop": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "noseRightAlarOutTip": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "noseRightAlarTop": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "noseRootLeft": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "noseRootRight": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "noseTip": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "pupilLeft": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "pupilRight": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "underLipBottom": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "underLipTop": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "upperLipBottom": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "upperLipTop": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            }
                        },
                        "recognitionModel": "str"  # Optional. The 'recognitionModel'
                          associated with this faceId. This is only returned when
                          'returnRecognitionModel' is explicitly set as true. Known values are:
                          "recognition_01", "recognition_02", "recognition_03", and "recognition_04".
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop("content_type", _headers.pop("content-type", "application/octet-stream"))
        cls: ClsType[List[_models.FaceDetectionResult]] = kwargs.pop("cls", None)

        _content = image_content

        _request = build_face_detect_request(
            detection_model=detection_model,
            recognition_model=recognition_model,
            return_face_id=return_face_id,
            return_face_attributes=return_face_attributes,
            return_face_landmarks=return_face_landmarks,
            return_recognition_model=return_recognition_model,
            face_id_time_to_live=face_id_time_to_live,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.FaceDetectionResult], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def find_similar(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.FaceFindSimilarResult]:
        # pylint: disable=line-too-long
        """Given query face's faceId, to search the similar-looking faces from a faceId array. A faceId
        array contains the faces created by Detect.

        Depending on the input the returned similar faces list contains faceIds or persistedFaceIds
        ranked by similarity.

        Find similar has two working modes, "matchPerson" and "matchFace". "matchPerson" is the default
        mode that it tries to find faces of the same person as possible by using internal same-person
        thresholds. It is useful to find a known person's other photos. Note that an empty list will be
        returned if no faces pass the internal thresholds. "matchFace" mode ignores same-person
        thresholds and returns ranked similar faces anyway, even the similarity is low. It can be used
        in the cases like searching celebrity-looking faces.

        The 'recognitionModel' associated with the query faceId should be the same as the
        'recognitionModel' used by the target faceId array.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of FaceFindSimilarResult
        :rtype: list[~azure.ai.vision.face.models.FaceFindSimilarResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "faceId": "str",  # faceId of the query face. User needs to call "Detect"
                      first to get a valid faceId. Note that this faceId is not persisted and will
                      expire 24 hours after the detection call. Required.
                    "faceIds": [
                        "str"  # An array of candidate faceIds. All of them are created by
                          "Detect" and the faceIds will expire 24 hours after the detection call. The
                          number of faceIds is limited to 1000. Required.
                    ],
                    "maxNumOfCandidatesReturned": 0,  # Optional. The number of top similar faces
                      returned. The valid range is [1, 1000]. Default value is 20.
                    "mode": "str"  # Optional. Similar face searching mode. It can be
                      'matchPerson' or 'matchFace'. Default value is 'matchPerson'. Known values are:
                      "matchPerson" and "matchFace".
                }

                # response body for status code(s): 200
                response == [
                    {
                        "confidence": 0.0,  # Confidence value of the candidate. The higher
                          confidence, the more similar. Range between [0,1]. Required.
                        "faceId": "str",  # Optional. faceId of candidate face when find by
                          faceIds. faceId is created by "Detect" and will expire 24 hours after the
                          detection call.
                        "persistedFaceId": "str"  # Optional. persistedFaceId of candidate
                          face when find by faceListId or largeFaceListId. persistedFaceId in face
                          list/large face list is persisted and will not expire.
                    }
                ]
        """

    @overload
    async def find_similar(
        self,
        *,
        face_id: str,
        face_ids: List[str],
        content_type: str = "application/json",
        max_num_of_candidates_returned: Optional[int] = None,
        mode: Optional[Union[str, _models.FindSimilarMatchMode]] = None,
        **kwargs: Any
    ) -> List[_models.FaceFindSimilarResult]:
        # pylint: disable=line-too-long
        """Given query face's faceId, to search the similar-looking faces from a faceId array. A faceId
        array contains the faces created by Detect.

        Depending on the input the returned similar faces list contains faceIds or persistedFaceIds
        ranked by similarity.

        Find similar has two working modes, "matchPerson" and "matchFace". "matchPerson" is the default
        mode that it tries to find faces of the same person as possible by using internal same-person
        thresholds. It is useful to find a known person's other photos. Note that an empty list will be
        returned if no faces pass the internal thresholds. "matchFace" mode ignores same-person
        thresholds and returns ranked similar faces anyway, even the similarity is low. It can be used
        in the cases like searching celebrity-looking faces.

        The 'recognitionModel' associated with the query faceId should be the same as the
        'recognitionModel' used by the target faceId array.

        :keyword face_id: faceId of the query face. User needs to call "Detect" first to get a valid
         faceId. Note that this faceId is not persisted and will expire 24 hours after the detection
         call. Required.
        :paramtype face_id: str
        :keyword face_ids: An array of candidate faceIds. All of them are created by "Detect" and the
         faceIds will expire 24 hours after the detection call. The number of faceIds is limited to
         1000. Required.
        :paramtype face_ids: list[str]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword max_num_of_candidates_returned: The number of top similar faces returned. The valid
         range is [1, 1000]. Default value is 20. Default value is None.
        :paramtype max_num_of_candidates_returned: int
        :keyword mode: Similar face searching mode. It can be 'matchPerson' or 'matchFace'. Default
         value is 'matchPerson'. Known values are: "matchPerson" and "matchFace". Default value is None.
        :paramtype mode: str or ~azure.ai.vision.face.models.FindSimilarMatchMode
        :return: list of FaceFindSimilarResult
        :rtype: list[~azure.ai.vision.face.models.FaceFindSimilarResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "confidence": 0.0,  # Confidence value of the candidate. The higher
                          confidence, the more similar. Range between [0,1]. Required.
                        "faceId": "str",  # Optional. faceId of candidate face when find by
                          faceIds. faceId is created by "Detect" and will expire 24 hours after the
                          detection call.
                        "persistedFaceId": "str"  # Optional. persistedFaceId of candidate
                          face when find by faceListId or largeFaceListId. persistedFaceId in face
                          list/large face list is persisted and will not expire.
                    }
                ]
        """

    @overload
    async def find_similar(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.FaceFindSimilarResult]:
        # pylint: disable=line-too-long
        """Given query face's faceId, to search the similar-looking faces from a faceId array. A faceId
        array contains the faces created by Detect.

        Depending on the input the returned similar faces list contains faceIds or persistedFaceIds
        ranked by similarity.

        Find similar has two working modes, "matchPerson" and "matchFace". "matchPerson" is the default
        mode that it tries to find faces of the same person as possible by using internal same-person
        thresholds. It is useful to find a known person's other photos. Note that an empty list will be
        returned if no faces pass the internal thresholds. "matchFace" mode ignores same-person
        thresholds and returns ranked similar faces anyway, even the similarity is low. It can be used
        in the cases like searching celebrity-looking faces.

        The 'recognitionModel' associated with the query faceId should be the same as the
        'recognitionModel' used by the target faceId array.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of FaceFindSimilarResult
        :rtype: list[~azure.ai.vision.face.models.FaceFindSimilarResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "confidence": 0.0,  # Confidence value of the candidate. The higher
                          confidence, the more similar. Range between [0,1]. Required.
                        "faceId": "str",  # Optional. faceId of candidate face when find by
                          faceIds. faceId is created by "Detect" and will expire 24 hours after the
                          detection call.
                        "persistedFaceId": "str"  # Optional. persistedFaceId of candidate
                          face when find by faceListId or largeFaceListId. persistedFaceId in face
                          list/large face list is persisted and will not expire.
                    }
                ]
        """

    @distributed_trace_async
    async def find_similar(
        self,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        face_id: str = _Unset,
        face_ids: List[str] = _Unset,
        max_num_of_candidates_returned: Optional[int] = None,
        mode: Optional[Union[str, _models.FindSimilarMatchMode]] = None,
        **kwargs: Any
    ) -> List[_models.FaceFindSimilarResult]:
        # pylint: disable=line-too-long
        """Given query face's faceId, to search the similar-looking faces from a faceId array. A faceId
        array contains the faces created by Detect.

        Depending on the input the returned similar faces list contains faceIds or persistedFaceIds
        ranked by similarity.

        Find similar has two working modes, "matchPerson" and "matchFace". "matchPerson" is the default
        mode that it tries to find faces of the same person as possible by using internal same-person
        thresholds. It is useful to find a known person's other photos. Note that an empty list will be
        returned if no faces pass the internal thresholds. "matchFace" mode ignores same-person
        thresholds and returns ranked similar faces anyway, even the similarity is low. It can be used
        in the cases like searching celebrity-looking faces.

        The 'recognitionModel' associated with the query faceId should be the same as the
        'recognitionModel' used by the target faceId array.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword face_id: faceId of the query face. User needs to call "Detect" first to get a valid
         faceId. Note that this faceId is not persisted and will expire 24 hours after the detection
         call. Required.
        :paramtype face_id: str
        :keyword face_ids: An array of candidate faceIds. All of them are created by "Detect" and the
         faceIds will expire 24 hours after the detection call. The number of faceIds is limited to
         1000. Required.
        :paramtype face_ids: list[str]
        :keyword max_num_of_candidates_returned: The number of top similar faces returned. The valid
         range is [1, 1000]. Default value is 20. Default value is None.
        :paramtype max_num_of_candidates_returned: int
        :keyword mode: Similar face searching mode. It can be 'matchPerson' or 'matchFace'. Default
         value is 'matchPerson'. Known values are: "matchPerson" and "matchFace". Default value is None.
        :paramtype mode: str or ~azure.ai.vision.face.models.FindSimilarMatchMode
        :return: list of FaceFindSimilarResult
        :rtype: list[~azure.ai.vision.face.models.FaceFindSimilarResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "faceId": "str",  # faceId of the query face. User needs to call "Detect"
                      first to get a valid faceId. Note that this faceId is not persisted and will
                      expire 24 hours after the detection call. Required.
                    "faceIds": [
                        "str"  # An array of candidate faceIds. All of them are created by
                          "Detect" and the faceIds will expire 24 hours after the detection call. The
                          number of faceIds is limited to 1000. Required.
                    ],
                    "maxNumOfCandidatesReturned": 0,  # Optional. The number of top similar faces
                      returned. The valid range is [1, 1000]. Default value is 20.
                    "mode": "str"  # Optional. Similar face searching mode. It can be
                      'matchPerson' or 'matchFace'. Default value is 'matchPerson'. Known values are:
                      "matchPerson" and "matchFace".
                }

                # response body for status code(s): 200
                response == [
                    {
                        "confidence": 0.0,  # Confidence value of the candidate. The higher
                          confidence, the more similar. Range between [0,1]. Required.
                        "faceId": "str",  # Optional. faceId of candidate face when find by
                          faceIds. faceId is created by "Detect" and will expire 24 hours after the
                          detection call.
                        "persistedFaceId": "str"  # Optional. persistedFaceId of candidate
                          face when find by faceListId or largeFaceListId. persistedFaceId in face
                          list/large face list is persisted and will not expire.
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[_models.FaceFindSimilarResult]] = kwargs.pop("cls", None)

        if body is _Unset:
            if face_id is _Unset:
                raise TypeError("missing required argument: face_id")
            if face_ids is _Unset:
                raise TypeError("missing required argument: face_ids")
            body = {
                "faceid": face_id,
                "faceids": face_ids,
                "maxnumofcandidatesreturned": max_num_of_candidates_returned,
                "mode": mode,
            }
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_find_similar_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.FaceFindSimilarResult], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def find_similar_from_face_list(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.FaceFindSimilarResult]:
        # pylint: disable=line-too-long
        """Given query face's faceId, to search the similar-looking faces from a Face List. A 'faceListId'
        is created by Create Face List.

        Depending on the input the returned similar faces list contains faceIds or persistedFaceIds
        ranked by similarity.

        Find similar has two working modes, "matchPerson" and "matchFace". "matchPerson" is the default
        mode that it tries to find faces of the same person as possible by using internal same-person
        thresholds. It is useful to find a known person's other photos. Note that an empty list will be
        returned if no faces pass the internal thresholds. "matchFace" mode ignores same-person
        thresholds and returns ranked similar faces anyway, even the similarity is low. It can be used
        in the cases like searching celebrity-looking faces.

        The 'recognitionModel' associated with the query faceId should be the same as the
        'recognitionModel' used by the target Face List.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of FaceFindSimilarResult
        :rtype: list[~azure.ai.vision.face.models.FaceFindSimilarResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "faceId": "str",  # faceId of the query face. User needs to call "Detect"
                      first to get a valid faceId. Note that this faceId is not persisted and will
                      expire 24 hours after the detection call. Required.
                    "faceListId": "str",  # An existing user-specified unique candidate Face
                      List, created in "Create Face List". Face List contains a set of persistedFaceIds
                      which are persisted and will never expire. Required.
                    "maxNumOfCandidatesReturned": 0,  # Optional. The number of top similar faces
                      returned. The valid range is [1, 1000]. Default value is 20.
                    "mode": "str"  # Optional. Similar face searching mode. It can be
                      'matchPerson' or 'matchFace'. Default value is 'matchPerson'. Known values are:
                      "matchPerson" and "matchFace".
                }

                # response body for status code(s): 200
                response == [
                    {
                        "confidence": 0.0,  # Confidence value of the candidate. The higher
                          confidence, the more similar. Range between [0,1]. Required.
                        "faceId": "str",  # Optional. faceId of candidate face when find by
                          faceIds. faceId is created by "Detect" and will expire 24 hours after the
                          detection call.
                        "persistedFaceId": "str"  # Optional. persistedFaceId of candidate
                          face when find by faceListId or largeFaceListId. persistedFaceId in face
                          list/large face list is persisted and will not expire.
                    }
                ]
        """

    @overload
    async def find_similar_from_face_list(
        self,
        *,
        face_id: str,
        face_list_id: str,
        content_type: str = "application/json",
        max_num_of_candidates_returned: Optional[int] = None,
        mode: Optional[Union[str, _models.FindSimilarMatchMode]] = None,
        **kwargs: Any
    ) -> List[_models.FaceFindSimilarResult]:
        # pylint: disable=line-too-long
        """Given query face's faceId, to search the similar-looking faces from a Face List. A 'faceListId'
        is created by Create Face List.

        Depending on the input the returned similar faces list contains faceIds or persistedFaceIds
        ranked by similarity.

        Find similar has two working modes, "matchPerson" and "matchFace". "matchPerson" is the default
        mode that it tries to find faces of the same person as possible by using internal same-person
        thresholds. It is useful to find a known person's other photos. Note that an empty list will be
        returned if no faces pass the internal thresholds. "matchFace" mode ignores same-person
        thresholds and returns ranked similar faces anyway, even the similarity is low. It can be used
        in the cases like searching celebrity-looking faces.

        The 'recognitionModel' associated with the query faceId should be the same as the
        'recognitionModel' used by the target Face List.

        :keyword face_id: faceId of the query face. User needs to call "Detect" first to get a valid
         faceId. Note that this faceId is not persisted and will expire 24 hours after the detection
         call. Required.
        :paramtype face_id: str
        :keyword face_list_id: An existing user-specified unique candidate Face List, created in
         "Create Face List". Face List contains a set of persistedFaceIds which are persisted and will
         never expire. Required.
        :paramtype face_list_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword max_num_of_candidates_returned: The number of top similar faces returned. The valid
         range is [1, 1000]. Default value is 20. Default value is None.
        :paramtype max_num_of_candidates_returned: int
        :keyword mode: Similar face searching mode. It can be 'matchPerson' or 'matchFace'. Default
         value is 'matchPerson'. Known values are: "matchPerson" and "matchFace". Default value is None.
        :paramtype mode: str or ~azure.ai.vision.face.models.FindSimilarMatchMode
        :return: list of FaceFindSimilarResult
        :rtype: list[~azure.ai.vision.face.models.FaceFindSimilarResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "confidence": 0.0,  # Confidence value of the candidate. The higher
                          confidence, the more similar. Range between [0,1]. Required.
                        "faceId": "str",  # Optional. faceId of candidate face when find by
                          faceIds. faceId is created by "Detect" and will expire 24 hours after the
                          detection call.
                        "persistedFaceId": "str"  # Optional. persistedFaceId of candidate
                          face when find by faceListId or largeFaceListId. persistedFaceId in face
                          list/large face list is persisted and will not expire.
                    }
                ]
        """

    @overload
    async def find_similar_from_face_list(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.FaceFindSimilarResult]:
        # pylint: disable=line-too-long
        """Given query face's faceId, to search the similar-looking faces from a Face List. A 'faceListId'
        is created by Create Face List.

        Depending on the input the returned similar faces list contains faceIds or persistedFaceIds
        ranked by similarity.

        Find similar has two working modes, "matchPerson" and "matchFace". "matchPerson" is the default
        mode that it tries to find faces of the same person as possible by using internal same-person
        thresholds. It is useful to find a known person's other photos. Note that an empty list will be
        returned if no faces pass the internal thresholds. "matchFace" mode ignores same-person
        thresholds and returns ranked similar faces anyway, even the similarity is low. It can be used
        in the cases like searching celebrity-looking faces.

        The 'recognitionModel' associated with the query faceId should be the same as the
        'recognitionModel' used by the target Face List.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of FaceFindSimilarResult
        :rtype: list[~azure.ai.vision.face.models.FaceFindSimilarResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "confidence": 0.0,  # Confidence value of the candidate. The higher
                          confidence, the more similar. Range between [0,1]. Required.
                        "faceId": "str",  # Optional. faceId of candidate face when find by
                          faceIds. faceId is created by "Detect" and will expire 24 hours after the
                          detection call.
                        "persistedFaceId": "str"  # Optional. persistedFaceId of candidate
                          face when find by faceListId or largeFaceListId. persistedFaceId in face
                          list/large face list is persisted and will not expire.
                    }
                ]
        """

    @distributed_trace_async
    async def find_similar_from_face_list(
        self,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        face_id: str = _Unset,
        face_list_id: str = _Unset,
        max_num_of_candidates_returned: Optional[int] = None,
        mode: Optional[Union[str, _models.FindSimilarMatchMode]] = None,
        **kwargs: Any
    ) -> List[_models.FaceFindSimilarResult]:
        # pylint: disable=line-too-long
        """Given query face's faceId, to search the similar-looking faces from a Face List. A 'faceListId'
        is created by Create Face List.

        Depending on the input the returned similar faces list contains faceIds or persistedFaceIds
        ranked by similarity.

        Find similar has two working modes, "matchPerson" and "matchFace". "matchPerson" is the default
        mode that it tries to find faces of the same person as possible by using internal same-person
        thresholds. It is useful to find a known person's other photos. Note that an empty list will be
        returned if no faces pass the internal thresholds. "matchFace" mode ignores same-person
        thresholds and returns ranked similar faces anyway, even the similarity is low. It can be used
        in the cases like searching celebrity-looking faces.

        The 'recognitionModel' associated with the query faceId should be the same as the
        'recognitionModel' used by the target Face List.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword face_id: faceId of the query face. User needs to call "Detect" first to get a valid
         faceId. Note that this faceId is not persisted and will expire 24 hours after the detection
         call. Required.
        :paramtype face_id: str
        :keyword face_list_id: An existing user-specified unique candidate Face List, created in
         "Create Face List". Face List contains a set of persistedFaceIds which are persisted and will
         never expire. Required.
        :paramtype face_list_id: str
        :keyword max_num_of_candidates_returned: The number of top similar faces returned. The valid
         range is [1, 1000]. Default value is 20. Default value is None.
        :paramtype max_num_of_candidates_returned: int
        :keyword mode: Similar face searching mode. It can be 'matchPerson' or 'matchFace'. Default
         value is 'matchPerson'. Known values are: "matchPerson" and "matchFace". Default value is None.
        :paramtype mode: str or ~azure.ai.vision.face.models.FindSimilarMatchMode
        :return: list of FaceFindSimilarResult
        :rtype: list[~azure.ai.vision.face.models.FaceFindSimilarResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "faceId": "str",  # faceId of the query face. User needs to call "Detect"
                      first to get a valid faceId. Note that this faceId is not persisted and will
                      expire 24 hours after the detection call. Required.
                    "faceListId": "str",  # An existing user-specified unique candidate Face
                      List, created in "Create Face List". Face List contains a set of persistedFaceIds
                      which are persisted and will never expire. Required.
                    "maxNumOfCandidatesReturned": 0,  # Optional. The number of top similar faces
                      returned. The valid range is [1, 1000]. Default value is 20.
                    "mode": "str"  # Optional. Similar face searching mode. It can be
                      'matchPerson' or 'matchFace'. Default value is 'matchPerson'. Known values are:
                      "matchPerson" and "matchFace".
                }

                # response body for status code(s): 200
                response == [
                    {
                        "confidence": 0.0,  # Confidence value of the candidate. The higher
                          confidence, the more similar. Range between [0,1]. Required.
                        "faceId": "str",  # Optional. faceId of candidate face when find by
                          faceIds. faceId is created by "Detect" and will expire 24 hours after the
                          detection call.
                        "persistedFaceId": "str"  # Optional. persistedFaceId of candidate
                          face when find by faceListId or largeFaceListId. persistedFaceId in face
                          list/large face list is persisted and will not expire.
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[_models.FaceFindSimilarResult]] = kwargs.pop("cls", None)

        if body is _Unset:
            if face_id is _Unset:
                raise TypeError("missing required argument: face_id")
            if face_list_id is _Unset:
                raise TypeError("missing required argument: face_list_id")
            body = {
                "faceid": face_id,
                "facelistid": face_list_id,
                "maxnumofcandidatesreturned": max_num_of_candidates_returned,
                "mode": mode,
            }
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_find_similar_from_face_list_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.FaceFindSimilarResult], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def find_similar_from_large_face_list(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.FaceFindSimilarResult]:
        # pylint: disable=line-too-long
        """Given query face's faceId, to search the similar-looking faces from a Large Face List. A
        'largeFaceListId' is created by Create Large Face List.

        Depending on the input the returned similar faces list contains faceIds or persistedFaceIds
        ranked by similarity.

        Find similar has two working modes, "matchPerson" and "matchFace". "matchPerson" is the default
        mode that it tries to find faces of the same person as possible by using internal same-person
        thresholds. It is useful to find a known person's other photos. Note that an empty list will be
        returned if no faces pass the internal thresholds. "matchFace" mode ignores same-person
        thresholds and returns ranked similar faces anyway, even the similarity is low. It can be used
        in the cases like searching celebrity-looking faces.

        The 'recognitionModel' associated with the query faceId should be the same as the
        'recognitionModel' used by the target Large Face List.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of FaceFindSimilarResult
        :rtype: list[~azure.ai.vision.face.models.FaceFindSimilarResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "faceId": "str",  # faceId of the query face. User needs to call "Detect"
                      first to get a valid faceId. Note that this faceId is not persisted and will
                      expire 24 hours after the detection call. Required.
                    "largeFaceListId": "str",  # An existing user-specified unique candidate
                      Large Face List, created in "Create Large Face List". Large Face List contains a
                      set of persistedFaceIds which are persisted and will never expire. Required.
                    "maxNumOfCandidatesReturned": 0,  # Optional. The number of top similar faces
                      returned. The valid range is [1, 1000]. Default value is 20.
                    "mode": "str"  # Optional. Similar face searching mode. It can be
                      'matchPerson' or 'matchFace'. Default value is 'matchPerson'. Known values are:
                      "matchPerson" and "matchFace".
                }

                # response body for status code(s): 200
                response == [
                    {
                        "confidence": 0.0,  # Confidence value of the candidate. The higher
                          confidence, the more similar. Range between [0,1]. Required.
                        "faceId": "str",  # Optional. faceId of candidate face when find by
                          faceIds. faceId is created by "Detect" and will expire 24 hours after the
                          detection call.
                        "persistedFaceId": "str"  # Optional. persistedFaceId of candidate
                          face when find by faceListId or largeFaceListId. persistedFaceId in face
                          list/large face list is persisted and will not expire.
                    }
                ]
        """

    @overload
    async def find_similar_from_large_face_list(
        self,
        *,
        face_id: str,
        large_face_list_id: str,
        content_type: str = "application/json",
        max_num_of_candidates_returned: Optional[int] = None,
        mode: Optional[Union[str, _models.FindSimilarMatchMode]] = None,
        **kwargs: Any
    ) -> List[_models.FaceFindSimilarResult]:
        # pylint: disable=line-too-long
        """Given query face's faceId, to search the similar-looking faces from a Large Face List. A
        'largeFaceListId' is created by Create Large Face List.

        Depending on the input the returned similar faces list contains faceIds or persistedFaceIds
        ranked by similarity.

        Find similar has two working modes, "matchPerson" and "matchFace". "matchPerson" is the default
        mode that it tries to find faces of the same person as possible by using internal same-person
        thresholds. It is useful to find a known person's other photos. Note that an empty list will be
        returned if no faces pass the internal thresholds. "matchFace" mode ignores same-person
        thresholds and returns ranked similar faces anyway, even the similarity is low. It can be used
        in the cases like searching celebrity-looking faces.

        The 'recognitionModel' associated with the query faceId should be the same as the
        'recognitionModel' used by the target Large Face List.

        :keyword face_id: faceId of the query face. User needs to call "Detect" first to get a valid
         faceId. Note that this faceId is not persisted and will expire 24 hours after the detection
         call. Required.
        :paramtype face_id: str
        :keyword large_face_list_id: An existing user-specified unique candidate Large Face List,
         created in "Create Large Face List". Large Face List contains a set of persistedFaceIds which
         are persisted and will never expire. Required.
        :paramtype large_face_list_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword max_num_of_candidates_returned: The number of top similar faces returned. The valid
         range is [1, 1000]. Default value is 20. Default value is None.
        :paramtype max_num_of_candidates_returned: int
        :keyword mode: Similar face searching mode. It can be 'matchPerson' or 'matchFace'. Default
         value is 'matchPerson'. Known values are: "matchPerson" and "matchFace". Default value is None.
        :paramtype mode: str or ~azure.ai.vision.face.models.FindSimilarMatchMode
        :return: list of FaceFindSimilarResult
        :rtype: list[~azure.ai.vision.face.models.FaceFindSimilarResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "confidence": 0.0,  # Confidence value of the candidate. The higher
                          confidence, the more similar. Range between [0,1]. Required.
                        "faceId": "str",  # Optional. faceId of candidate face when find by
                          faceIds. faceId is created by "Detect" and will expire 24 hours after the
                          detection call.
                        "persistedFaceId": "str"  # Optional. persistedFaceId of candidate
                          face when find by faceListId or largeFaceListId. persistedFaceId in face
                          list/large face list is persisted and will not expire.
                    }
                ]
        """

    @overload
    async def find_similar_from_large_face_list(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.FaceFindSimilarResult]:
        # pylint: disable=line-too-long
        """Given query face's faceId, to search the similar-looking faces from a Large Face List. A
        'largeFaceListId' is created by Create Large Face List.

        Depending on the input the returned similar faces list contains faceIds or persistedFaceIds
        ranked by similarity.

        Find similar has two working modes, "matchPerson" and "matchFace". "matchPerson" is the default
        mode that it tries to find faces of the same person as possible by using internal same-person
        thresholds. It is useful to find a known person's other photos. Note that an empty list will be
        returned if no faces pass the internal thresholds. "matchFace" mode ignores same-person
        thresholds and returns ranked similar faces anyway, even the similarity is low. It can be used
        in the cases like searching celebrity-looking faces.

        The 'recognitionModel' associated with the query faceId should be the same as the
        'recognitionModel' used by the target Large Face List.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of FaceFindSimilarResult
        :rtype: list[~azure.ai.vision.face.models.FaceFindSimilarResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "confidence": 0.0,  # Confidence value of the candidate. The higher
                          confidence, the more similar. Range between [0,1]. Required.
                        "faceId": "str",  # Optional. faceId of candidate face when find by
                          faceIds. faceId is created by "Detect" and will expire 24 hours after the
                          detection call.
                        "persistedFaceId": "str"  # Optional. persistedFaceId of candidate
                          face when find by faceListId or largeFaceListId. persistedFaceId in face
                          list/large face list is persisted and will not expire.
                    }
                ]
        """

    @distributed_trace_async
    async def find_similar_from_large_face_list(
        self,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        face_id: str = _Unset,
        large_face_list_id: str = _Unset,
        max_num_of_candidates_returned: Optional[int] = None,
        mode: Optional[Union[str, _models.FindSimilarMatchMode]] = None,
        **kwargs: Any
    ) -> List[_models.FaceFindSimilarResult]:
        # pylint: disable=line-too-long
        """Given query face's faceId, to search the similar-looking faces from a Large Face List. A
        'largeFaceListId' is created by Create Large Face List.

        Depending on the input the returned similar faces list contains faceIds or persistedFaceIds
        ranked by similarity.

        Find similar has two working modes, "matchPerson" and "matchFace". "matchPerson" is the default
        mode that it tries to find faces of the same person as possible by using internal same-person
        thresholds. It is useful to find a known person's other photos. Note that an empty list will be
        returned if no faces pass the internal thresholds. "matchFace" mode ignores same-person
        thresholds and returns ranked similar faces anyway, even the similarity is low. It can be used
        in the cases like searching celebrity-looking faces.

        The 'recognitionModel' associated with the query faceId should be the same as the
        'recognitionModel' used by the target Large Face List.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword face_id: faceId of the query face. User needs to call "Detect" first to get a valid
         faceId. Note that this faceId is not persisted and will expire 24 hours after the detection
         call. Required.
        :paramtype face_id: str
        :keyword large_face_list_id: An existing user-specified unique candidate Large Face List,
         created in "Create Large Face List". Large Face List contains a set of persistedFaceIds which
         are persisted and will never expire. Required.
        :paramtype large_face_list_id: str
        :keyword max_num_of_candidates_returned: The number of top similar faces returned. The valid
         range is [1, 1000]. Default value is 20. Default value is None.
        :paramtype max_num_of_candidates_returned: int
        :keyword mode: Similar face searching mode. It can be 'matchPerson' or 'matchFace'. Default
         value is 'matchPerson'. Known values are: "matchPerson" and "matchFace". Default value is None.
        :paramtype mode: str or ~azure.ai.vision.face.models.FindSimilarMatchMode
        :return: list of FaceFindSimilarResult
        :rtype: list[~azure.ai.vision.face.models.FaceFindSimilarResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "faceId": "str",  # faceId of the query face. User needs to call "Detect"
                      first to get a valid faceId. Note that this faceId is not persisted and will
                      expire 24 hours after the detection call. Required.
                    "largeFaceListId": "str",  # An existing user-specified unique candidate
                      Large Face List, created in "Create Large Face List". Large Face List contains a
                      set of persistedFaceIds which are persisted and will never expire. Required.
                    "maxNumOfCandidatesReturned": 0,  # Optional. The number of top similar faces
                      returned. The valid range is [1, 1000]. Default value is 20.
                    "mode": "str"  # Optional. Similar face searching mode. It can be
                      'matchPerson' or 'matchFace'. Default value is 'matchPerson'. Known values are:
                      "matchPerson" and "matchFace".
                }

                # response body for status code(s): 200
                response == [
                    {
                        "confidence": 0.0,  # Confidence value of the candidate. The higher
                          confidence, the more similar. Range between [0,1]. Required.
                        "faceId": "str",  # Optional. faceId of candidate face when find by
                          faceIds. faceId is created by "Detect" and will expire 24 hours after the
                          detection call.
                        "persistedFaceId": "str"  # Optional. persistedFaceId of candidate
                          face when find by faceListId or largeFaceListId. persistedFaceId in face
                          list/large face list is persisted and will not expire.
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[_models.FaceFindSimilarResult]] = kwargs.pop("cls", None)

        if body is _Unset:
            if face_id is _Unset:
                raise TypeError("missing required argument: face_id")
            if large_face_list_id is _Unset:
                raise TypeError("missing required argument: large_face_list_id")
            body = {
                "faceid": face_id,
                "largefacelistid": large_face_list_id,
                "maxnumofcandidatesreturned": max_num_of_candidates_returned,
                "mode": mode,
            }
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_find_similar_from_large_face_list_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.FaceFindSimilarResult], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def identify_from_person_group(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.FaceIdentificationResult]:
        # pylint: disable=line-too-long
        """1-to-many identification to find the closest matches of the specific query person face from a
        Person Group.

        For each face in the faceIds array, Face Identify will compute similarities between the query
        face and all the faces in the Person Group (given by personGroupId), and return candidate
        person(s) for that face ranked by similarity confidence. The Person Group should be trained to
        make it ready for identification. See more in "Train Person Group".

        ..

           [!NOTE]

           *


           * The algorithm allows more than one face to be identified independently at the same
        request, but no more than 10 faces.
           * Each person could have more than one face, but no more than 248 faces.
           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * Number of candidates returned is restricted by maxNumOfCandidatesReturned and
        confidenceThreshold. If no person is identified, the returned candidates will be an empty
        array.
           * Try "Find Similar" when you need to find similar faces from a Face List/Large Face List
        instead of a Person Group.
           * The 'recognitionModel' associated with the query faces' faceIds should be the same as the
        'recognitionModel' used by the target Person Group.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of FaceIdentificationResult
        :rtype: list[~azure.ai.vision.face.models.FaceIdentificationResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "faceIds": [
                        "str"  # Array of query faces faceIds, created by the "Detect". Each
                          of the faces are identified independently. The valid number of faceIds is
                          between [1, 10]. Required.
                    ],
                    "personGroupId": "str",  # personGroupId of the target Person Group, created
                      by "Create Person Group". Parameter personGroupId and largePersonGroupId should
                      not be provided at the same time. Required.
                    "confidenceThreshold": 0.0,  # Optional. Customized identification confidence
                      threshold, in the range of [0, 1]. Advanced user can tweak this value to override
                      default internal threshold for better precision on their scenario data. Note
                      there is no guarantee of this threshold value working on other data and after
                      algorithm updates.
                    "maxNumOfCandidatesReturned": 0  # Optional. The range of
                      maxNumOfCandidatesReturned is between 1 and 100. Default value is 10.
                }

                # response body for status code(s): 200
                response == [
                    {
                        "candidates": [
                            {
                                "confidence": 0.0,  # Confidence value of the
                                  candidate. The higher confidence, the more similar. Range between
                                  [0,1]. Required.
                                "personId": "str"  # personId of candidate person.
                                  Required.
                            }
                        ],
                        "faceId": "str"  # faceId of the query face. Required.
                    }
                ]
        """

    @overload
    async def identify_from_person_group(
        self,
        *,
        face_ids: List[str],
        person_group_id: str,
        content_type: str = "application/json",
        max_num_of_candidates_returned: Optional[int] = None,
        confidence_threshold: Optional[float] = None,
        **kwargs: Any
    ) -> List[_models.FaceIdentificationResult]:
        # pylint: disable=line-too-long
        """1-to-many identification to find the closest matches of the specific query person face from a
        Person Group.

        For each face in the faceIds array, Face Identify will compute similarities between the query
        face and all the faces in the Person Group (given by personGroupId), and return candidate
        person(s) for that face ranked by similarity confidence. The Person Group should be trained to
        make it ready for identification. See more in "Train Person Group".

        ..

           [!NOTE]

           *


           * The algorithm allows more than one face to be identified independently at the same
        request, but no more than 10 faces.
           * Each person could have more than one face, but no more than 248 faces.
           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * Number of candidates returned is restricted by maxNumOfCandidatesReturned and
        confidenceThreshold. If no person is identified, the returned candidates will be an empty
        array.
           * Try "Find Similar" when you need to find similar faces from a Face List/Large Face List
        instead of a Person Group.
           * The 'recognitionModel' associated with the query faces' faceIds should be the same as the
        'recognitionModel' used by the target Person Group.

        :keyword face_ids: Array of query faces faceIds, created by the "Detect". Each of the faces are
         identified independently. The valid number of faceIds is between [1, 10]. Required.
        :paramtype face_ids: list[str]
        :keyword person_group_id: personGroupId of the target Person Group, created by "Create Person
         Group". Parameter personGroupId and largePersonGroupId should not be provided at the same time.
         Required.
        :paramtype person_group_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword max_num_of_candidates_returned: The range of maxNumOfCandidatesReturned is between 1
         and 100. Default value is 10. Default value is None.
        :paramtype max_num_of_candidates_returned: int
        :keyword confidence_threshold: Customized identification confidence threshold, in the range of
         [0, 1]. Advanced user can tweak this value to override default internal threshold for better
         precision on their scenario data. Note there is no guarantee of this threshold value working on
         other data and after algorithm updates. Default value is None.
        :paramtype confidence_threshold: float
        :return: list of FaceIdentificationResult
        :rtype: list[~azure.ai.vision.face.models.FaceIdentificationResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "candidates": [
                            {
                                "confidence": 0.0,  # Confidence value of the
                                  candidate. The higher confidence, the more similar. Range between
                                  [0,1]. Required.
                                "personId": "str"  # personId of candidate person.
                                  Required.
                            }
                        ],
                        "faceId": "str"  # faceId of the query face. Required.
                    }
                ]
        """

    @overload
    async def identify_from_person_group(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.FaceIdentificationResult]:
        # pylint: disable=line-too-long
        """1-to-many identification to find the closest matches of the specific query person face from a
        Person Group.

        For each face in the faceIds array, Face Identify will compute similarities between the query
        face and all the faces in the Person Group (given by personGroupId), and return candidate
        person(s) for that face ranked by similarity confidence. The Person Group should be trained to
        make it ready for identification. See more in "Train Person Group".

        ..

           [!NOTE]

           *


           * The algorithm allows more than one face to be identified independently at the same
        request, but no more than 10 faces.
           * Each person could have more than one face, but no more than 248 faces.
           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * Number of candidates returned is restricted by maxNumOfCandidatesReturned and
        confidenceThreshold. If no person is identified, the returned candidates will be an empty
        array.
           * Try "Find Similar" when you need to find similar faces from a Face List/Large Face List
        instead of a Person Group.
           * The 'recognitionModel' associated with the query faces' faceIds should be the same as the
        'recognitionModel' used by the target Person Group.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of FaceIdentificationResult
        :rtype: list[~azure.ai.vision.face.models.FaceIdentificationResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "candidates": [
                            {
                                "confidence": 0.0,  # Confidence value of the
                                  candidate. The higher confidence, the more similar. Range between
                                  [0,1]. Required.
                                "personId": "str"  # personId of candidate person.
                                  Required.
                            }
                        ],
                        "faceId": "str"  # faceId of the query face. Required.
                    }
                ]
        """

    @distributed_trace_async
    async def identify_from_person_group(
        self,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        face_ids: List[str] = _Unset,
        person_group_id: str = _Unset,
        max_num_of_candidates_returned: Optional[int] = None,
        confidence_threshold: Optional[float] = None,
        **kwargs: Any
    ) -> List[_models.FaceIdentificationResult]:
        # pylint: disable=line-too-long
        """1-to-many identification to find the closest matches of the specific query person face from a
        Person Group.

        For each face in the faceIds array, Face Identify will compute similarities between the query
        face and all the faces in the Person Group (given by personGroupId), and return candidate
        person(s) for that face ranked by similarity confidence. The Person Group should be trained to
        make it ready for identification. See more in "Train Person Group".

        ..

           [!NOTE]

           *


           * The algorithm allows more than one face to be identified independently at the same
        request, but no more than 10 faces.
           * Each person could have more than one face, but no more than 248 faces.
           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * Number of candidates returned is restricted by maxNumOfCandidatesReturned and
        confidenceThreshold. If no person is identified, the returned candidates will be an empty
        array.
           * Try "Find Similar" when you need to find similar faces from a Face List/Large Face List
        instead of a Person Group.
           * The 'recognitionModel' associated with the query faces' faceIds should be the same as the
        'recognitionModel' used by the target Person Group.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword face_ids: Array of query faces faceIds, created by the "Detect". Each of the faces are
         identified independently. The valid number of faceIds is between [1, 10]. Required.
        :paramtype face_ids: list[str]
        :keyword person_group_id: personGroupId of the target Person Group, created by "Create Person
         Group". Parameter personGroupId and largePersonGroupId should not be provided at the same time.
         Required.
        :paramtype person_group_id: str
        :keyword max_num_of_candidates_returned: The range of maxNumOfCandidatesReturned is between 1
         and 100. Default value is 10. Default value is None.
        :paramtype max_num_of_candidates_returned: int
        :keyword confidence_threshold: Customized identification confidence threshold, in the range of
         [0, 1]. Advanced user can tweak this value to override default internal threshold for better
         precision on their scenario data. Note there is no guarantee of this threshold value working on
         other data and after algorithm updates. Default value is None.
        :paramtype confidence_threshold: float
        :return: list of FaceIdentificationResult
        :rtype: list[~azure.ai.vision.face.models.FaceIdentificationResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "faceIds": [
                        "str"  # Array of query faces faceIds, created by the "Detect". Each
                          of the faces are identified independently. The valid number of faceIds is
                          between [1, 10]. Required.
                    ],
                    "personGroupId": "str",  # personGroupId of the target Person Group, created
                      by "Create Person Group". Parameter personGroupId and largePersonGroupId should
                      not be provided at the same time. Required.
                    "confidenceThreshold": 0.0,  # Optional. Customized identification confidence
                      threshold, in the range of [0, 1]. Advanced user can tweak this value to override
                      default internal threshold for better precision on their scenario data. Note
                      there is no guarantee of this threshold value working on other data and after
                      algorithm updates.
                    "maxNumOfCandidatesReturned": 0  # Optional. The range of
                      maxNumOfCandidatesReturned is between 1 and 100. Default value is 10.
                }

                # response body for status code(s): 200
                response == [
                    {
                        "candidates": [
                            {
                                "confidence": 0.0,  # Confidence value of the
                                  candidate. The higher confidence, the more similar. Range between
                                  [0,1]. Required.
                                "personId": "str"  # personId of candidate person.
                                  Required.
                            }
                        ],
                        "faceId": "str"  # faceId of the query face. Required.
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[_models.FaceIdentificationResult]] = kwargs.pop("cls", None)

        if body is _Unset:
            if face_ids is _Unset:
                raise TypeError("missing required argument: face_ids")
            if person_group_id is _Unset:
                raise TypeError("missing required argument: person_group_id")
            body = {
                "confidencethreshold": confidence_threshold,
                "faceids": face_ids,
                "maxnumofcandidatesreturned": max_num_of_candidates_returned,
                "persongroupid": person_group_id,
            }
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_identify_from_person_group_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.FaceIdentificationResult], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def identify_from_large_person_group(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.FaceIdentificationResult]:
        # pylint: disable=line-too-long
        """1-to-many identification to find the closest matches of the specific query person face from a
        Large Person Group.

        For each face in the faceIds array, Face Identify will compute similarities between the query
        face and all the faces in the Large Person Group (given by largePersonGroupId), and return
        candidate person(s) for that face ranked by similarity confidence. The Large Person Group
        should be trained to make it ready for identification. See more in "Train Large Person Group".

        ..

           [!NOTE]

           *


           * The algorithm allows more than one face to be identified independently at the same
        request, but no more than 10 faces.
           * Each person could have more than one face, but no more than 248 faces.
           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * Number of candidates returned is restricted by maxNumOfCandidatesReturned and
        confidenceThreshold. If no person is identified, the returned candidates will be an empty
        array.
           * Try "Find Similar" when you need to find similar faces from a Face List/Large Face List
        instead of a Person Group/Large Person Group.
           * The 'recognitionModel' associated with the query faces' faceIds should be the same as the
        'recognitionModel' used by the target Person Group or Large Person Group.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of FaceIdentificationResult
        :rtype: list[~azure.ai.vision.face.models.FaceIdentificationResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "faceIds": [
                        "str"  # Array of query faces faceIds, created by the "Detect". Each
                          of the faces are identified independently. The valid number of faceIds is
                          between [1, 10]. Required.
                    ],
                    "largePersonGroupId": "str",  # largePersonGroupId of the target Large Person
                      Group, created by "Create Large Person Group". Parameter personGroupId and
                      largePersonGroupId should not be provided at the same time. Required.
                    "confidenceThreshold": 0.0,  # Optional. Customized identification confidence
                      threshold, in the range of [0, 1]. Advanced user can tweak this value to override
                      default internal threshold for better precision on their scenario data. Note
                      there is no guarantee of this threshold value working on other data and after
                      algorithm updates.
                    "maxNumOfCandidatesReturned": 0  # Optional. The range of
                      maxNumOfCandidatesReturned is between 1 and 100. Default value is 10.
                }

                # response body for status code(s): 200
                response == [
                    {
                        "candidates": [
                            {
                                "confidence": 0.0,  # Confidence value of the
                                  candidate. The higher confidence, the more similar. Range between
                                  [0,1]. Required.
                                "personId": "str"  # personId of candidate person.
                                  Required.
                            }
                        ],
                        "faceId": "str"  # faceId of the query face. Required.
                    }
                ]
        """

    @overload
    async def identify_from_large_person_group(
        self,
        *,
        face_ids: List[str],
        large_person_group_id: str,
        content_type: str = "application/json",
        max_num_of_candidates_returned: Optional[int] = None,
        confidence_threshold: Optional[float] = None,
        **kwargs: Any
    ) -> List[_models.FaceIdentificationResult]:
        # pylint: disable=line-too-long
        """1-to-many identification to find the closest matches of the specific query person face from a
        Large Person Group.

        For each face in the faceIds array, Face Identify will compute similarities between the query
        face and all the faces in the Large Person Group (given by largePersonGroupId), and return
        candidate person(s) for that face ranked by similarity confidence. The Large Person Group
        should be trained to make it ready for identification. See more in "Train Large Person Group".

        ..

           [!NOTE]

           *


           * The algorithm allows more than one face to be identified independently at the same
        request, but no more than 10 faces.
           * Each person could have more than one face, but no more than 248 faces.
           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * Number of candidates returned is restricted by maxNumOfCandidatesReturned and
        confidenceThreshold. If no person is identified, the returned candidates will be an empty
        array.
           * Try "Find Similar" when you need to find similar faces from a Face List/Large Face List
        instead of a Person Group/Large Person Group.
           * The 'recognitionModel' associated with the query faces' faceIds should be the same as the
        'recognitionModel' used by the target Person Group or Large Person Group.

        :keyword face_ids: Array of query faces faceIds, created by the "Detect". Each of the faces are
         identified independently. The valid number of faceIds is between [1, 10]. Required.
        :paramtype face_ids: list[str]
        :keyword large_person_group_id: largePersonGroupId of the target Large Person Group, created by
         "Create Large Person Group". Parameter personGroupId and largePersonGroupId should not be
         provided at the same time. Required.
        :paramtype large_person_group_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword max_num_of_candidates_returned: The range of maxNumOfCandidatesReturned is between 1
         and 100. Default value is 10. Default value is None.
        :paramtype max_num_of_candidates_returned: int
        :keyword confidence_threshold: Customized identification confidence threshold, in the range of
         [0, 1]. Advanced user can tweak this value to override default internal threshold for better
         precision on their scenario data. Note there is no guarantee of this threshold value working on
         other data and after algorithm updates. Default value is None.
        :paramtype confidence_threshold: float
        :return: list of FaceIdentificationResult
        :rtype: list[~azure.ai.vision.face.models.FaceIdentificationResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "candidates": [
                            {
                                "confidence": 0.0,  # Confidence value of the
                                  candidate. The higher confidence, the more similar. Range between
                                  [0,1]. Required.
                                "personId": "str"  # personId of candidate person.
                                  Required.
                            }
                        ],
                        "faceId": "str"  # faceId of the query face. Required.
                    }
                ]
        """

    @overload
    async def identify_from_large_person_group(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.FaceIdentificationResult]:
        # pylint: disable=line-too-long
        """1-to-many identification to find the closest matches of the specific query person face from a
        Large Person Group.

        For each face in the faceIds array, Face Identify will compute similarities between the query
        face and all the faces in the Large Person Group (given by largePersonGroupId), and return
        candidate person(s) for that face ranked by similarity confidence. The Large Person Group
        should be trained to make it ready for identification. See more in "Train Large Person Group".

        ..

           [!NOTE]

           *


           * The algorithm allows more than one face to be identified independently at the same
        request, but no more than 10 faces.
           * Each person could have more than one face, but no more than 248 faces.
           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * Number of candidates returned is restricted by maxNumOfCandidatesReturned and
        confidenceThreshold. If no person is identified, the returned candidates will be an empty
        array.
           * Try "Find Similar" when you need to find similar faces from a Face List/Large Face List
        instead of a Person Group/Large Person Group.
           * The 'recognitionModel' associated with the query faces' faceIds should be the same as the
        'recognitionModel' used by the target Person Group or Large Person Group.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of FaceIdentificationResult
        :rtype: list[~azure.ai.vision.face.models.FaceIdentificationResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "candidates": [
                            {
                                "confidence": 0.0,  # Confidence value of the
                                  candidate. The higher confidence, the more similar. Range between
                                  [0,1]. Required.
                                "personId": "str"  # personId of candidate person.
                                  Required.
                            }
                        ],
                        "faceId": "str"  # faceId of the query face. Required.
                    }
                ]
        """

    @distributed_trace_async
    async def identify_from_large_person_group(
        self,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        face_ids: List[str] = _Unset,
        large_person_group_id: str = _Unset,
        max_num_of_candidates_returned: Optional[int] = None,
        confidence_threshold: Optional[float] = None,
        **kwargs: Any
    ) -> List[_models.FaceIdentificationResult]:
        # pylint: disable=line-too-long
        """1-to-many identification to find the closest matches of the specific query person face from a
        Large Person Group.

        For each face in the faceIds array, Face Identify will compute similarities between the query
        face and all the faces in the Large Person Group (given by largePersonGroupId), and return
        candidate person(s) for that face ranked by similarity confidence. The Large Person Group
        should be trained to make it ready for identification. See more in "Train Large Person Group".

        ..

           [!NOTE]

           *


           * The algorithm allows more than one face to be identified independently at the same
        request, but no more than 10 faces.
           * Each person could have more than one face, but no more than 248 faces.
           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * Number of candidates returned is restricted by maxNumOfCandidatesReturned and
        confidenceThreshold. If no person is identified, the returned candidates will be an empty
        array.
           * Try "Find Similar" when you need to find similar faces from a Face List/Large Face List
        instead of a Person Group/Large Person Group.
           * The 'recognitionModel' associated with the query faces' faceIds should be the same as the
        'recognitionModel' used by the target Person Group or Large Person Group.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword face_ids: Array of query faces faceIds, created by the "Detect". Each of the faces are
         identified independently. The valid number of faceIds is between [1, 10]. Required.
        :paramtype face_ids: list[str]
        :keyword large_person_group_id: largePersonGroupId of the target Large Person Group, created by
         "Create Large Person Group". Parameter personGroupId and largePersonGroupId should not be
         provided at the same time. Required.
        :paramtype large_person_group_id: str
        :keyword max_num_of_candidates_returned: The range of maxNumOfCandidatesReturned is between 1
         and 100. Default value is 10. Default value is None.
        :paramtype max_num_of_candidates_returned: int
        :keyword confidence_threshold: Customized identification confidence threshold, in the range of
         [0, 1]. Advanced user can tweak this value to override default internal threshold for better
         precision on their scenario data. Note there is no guarantee of this threshold value working on
         other data and after algorithm updates. Default value is None.
        :paramtype confidence_threshold: float
        :return: list of FaceIdentificationResult
        :rtype: list[~azure.ai.vision.face.models.FaceIdentificationResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "faceIds": [
                        "str"  # Array of query faces faceIds, created by the "Detect". Each
                          of the faces are identified independently. The valid number of faceIds is
                          between [1, 10]. Required.
                    ],
                    "largePersonGroupId": "str",  # largePersonGroupId of the target Large Person
                      Group, created by "Create Large Person Group". Parameter personGroupId and
                      largePersonGroupId should not be provided at the same time. Required.
                    "confidenceThreshold": 0.0,  # Optional. Customized identification confidence
                      threshold, in the range of [0, 1]. Advanced user can tweak this value to override
                      default internal threshold for better precision on their scenario data. Note
                      there is no guarantee of this threshold value working on other data and after
                      algorithm updates.
                    "maxNumOfCandidatesReturned": 0  # Optional. The range of
                      maxNumOfCandidatesReturned is between 1 and 100. Default value is 10.
                }

                # response body for status code(s): 200
                response == [
                    {
                        "candidates": [
                            {
                                "confidence": 0.0,  # Confidence value of the
                                  candidate. The higher confidence, the more similar. Range between
                                  [0,1]. Required.
                                "personId": "str"  # personId of candidate person.
                                  Required.
                            }
                        ],
                        "faceId": "str"  # faceId of the query face. Required.
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[_models.FaceIdentificationResult]] = kwargs.pop("cls", None)

        if body is _Unset:
            if face_ids is _Unset:
                raise TypeError("missing required argument: face_ids")
            if large_person_group_id is _Unset:
                raise TypeError("missing required argument: large_person_group_id")
            body = {
                "confidencethreshold": confidence_threshold,
                "faceids": face_ids,
                "largepersongroupid": large_person_group_id,
                "maxnumofcandidatesreturned": max_num_of_candidates_returned,
            }
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_identify_from_large_person_group_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.FaceIdentificationResult], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def identify_from_person_directory(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.FaceIdentificationResult]:
        # pylint: disable=line-too-long
        """1-to-many identification to find the closest matches of the specific query person face from a
        person directory personIds array.

        For each face in the faceIds array, Face Identify will compute similarities between the query
        face and all the faces in the Person Directory Persons (given by personIds), and return
        candidate person(s) for that face ranked by similarity confidence.
        Passing personIds with an array with one element "*" can perform the operation over entire
        person directory.

        ..

           [!NOTE]

           *


           * The algorithm allows more than one face to be identified independently at the same
        request, but no more than 10 faces.
           * Each person could have more than one face, but no more than 248 faces.
           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * Number of candidates returned is restricted by maxNumOfCandidatesReturned and
        confidenceThreshold. If no person is identified, the returned candidates will be an empty
        array.
           * The Identify operation can only match faces obtained with the same recognition model, that
        is associated with the query faces.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of FaceIdentificationResult
        :rtype: list[~azure.ai.vision.face.models.FaceIdentificationResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "faceIds": [
                        "str"  # Array of query faces faceIds, created by the "Detect". Each
                          of the faces are identified independently. The valid number of faceIds is
                          between [1, 10]. Required.
                    ],
                    "personIds": [
                        "str"  # Array of personIds created in Person Directory "Create
                          Person". The valid number of personIds is between [1,30]. Required.
                    ],
                    "confidenceThreshold": 0.0,  # Optional. Customized identification confidence
                      threshold, in the range of [0, 1]. Advanced user can tweak this value to override
                      default internal threshold for better precision on their scenario data. Note
                      there is no guarantee of this threshold value working on other data and after
                      algorithm updates.
                    "maxNumOfCandidatesReturned": 0  # Optional. The range of
                      maxNumOfCandidatesReturned is between 1 and 100. Default value is 10.
                }

                # response body for status code(s): 200
                response == [
                    {
                        "candidates": [
                            {
                                "confidence": 0.0,  # Confidence value of the
                                  candidate. The higher confidence, the more similar. Range between
                                  [0,1]. Required.
                                "personId": "str"  # personId of candidate person.
                                  Required.
                            }
                        ],
                        "faceId": "str"  # faceId of the query face. Required.
                    }
                ]
        """

    @overload
    async def identify_from_person_directory(
        self,
        *,
        face_ids: List[str],
        person_ids: List[str],
        content_type: str = "application/json",
        max_num_of_candidates_returned: Optional[int] = None,
        confidence_threshold: Optional[float] = None,
        **kwargs: Any
    ) -> List[_models.FaceIdentificationResult]:
        # pylint: disable=line-too-long
        """1-to-many identification to find the closest matches of the specific query person face from a
        person directory personIds array.

        For each face in the faceIds array, Face Identify will compute similarities between the query
        face and all the faces in the Person Directory Persons (given by personIds), and return
        candidate person(s) for that face ranked by similarity confidence.
        Passing personIds with an array with one element "*" can perform the operation over entire
        person directory.

        ..

           [!NOTE]

           *


           * The algorithm allows more than one face to be identified independently at the same
        request, but no more than 10 faces.
           * Each person could have more than one face, but no more than 248 faces.
           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * Number of candidates returned is restricted by maxNumOfCandidatesReturned and
        confidenceThreshold. If no person is identified, the returned candidates will be an empty
        array.
           * The Identify operation can only match faces obtained with the same recognition model, that
        is associated with the query faces.

        :keyword face_ids: Array of query faces faceIds, created by the "Detect". Each of the faces are
         identified independently. The valid number of faceIds is between [1, 10]. Required.
        :paramtype face_ids: list[str]
        :keyword person_ids: Array of personIds created in Person Directory "Create Person". The valid
         number of personIds is between [1,30]. Required.
        :paramtype person_ids: list[str]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword max_num_of_candidates_returned: The range of maxNumOfCandidatesReturned is between 1
         and 100. Default value is 10. Default value is None.
        :paramtype max_num_of_candidates_returned: int
        :keyword confidence_threshold: Customized identification confidence threshold, in the range of
         [0, 1]. Advanced user can tweak this value to override default internal threshold for better
         precision on their scenario data. Note there is no guarantee of this threshold value working on
         other data and after algorithm updates. Default value is None.
        :paramtype confidence_threshold: float
        :return: list of FaceIdentificationResult
        :rtype: list[~azure.ai.vision.face.models.FaceIdentificationResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "candidates": [
                            {
                                "confidence": 0.0,  # Confidence value of the
                                  candidate. The higher confidence, the more similar. Range between
                                  [0,1]. Required.
                                "personId": "str"  # personId of candidate person.
                                  Required.
                            }
                        ],
                        "faceId": "str"  # faceId of the query face. Required.
                    }
                ]
        """

    @overload
    async def identify_from_person_directory(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.FaceIdentificationResult]:
        # pylint: disable=line-too-long
        """1-to-many identification to find the closest matches of the specific query person face from a
        person directory personIds array.

        For each face in the faceIds array, Face Identify will compute similarities between the query
        face and all the faces in the Person Directory Persons (given by personIds), and return
        candidate person(s) for that face ranked by similarity confidence.
        Passing personIds with an array with one element "*" can perform the operation over entire
        person directory.

        ..

           [!NOTE]

           *


           * The algorithm allows more than one face to be identified independently at the same
        request, but no more than 10 faces.
           * Each person could have more than one face, but no more than 248 faces.
           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * Number of candidates returned is restricted by maxNumOfCandidatesReturned and
        confidenceThreshold. If no person is identified, the returned candidates will be an empty
        array.
           * The Identify operation can only match faces obtained with the same recognition model, that
        is associated with the query faces.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of FaceIdentificationResult
        :rtype: list[~azure.ai.vision.face.models.FaceIdentificationResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "candidates": [
                            {
                                "confidence": 0.0,  # Confidence value of the
                                  candidate. The higher confidence, the more similar. Range between
                                  [0,1]. Required.
                                "personId": "str"  # personId of candidate person.
                                  Required.
                            }
                        ],
                        "faceId": "str"  # faceId of the query face. Required.
                    }
                ]
        """

    @distributed_trace_async
    async def identify_from_person_directory(
        self,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        face_ids: List[str] = _Unset,
        person_ids: List[str] = _Unset,
        max_num_of_candidates_returned: Optional[int] = None,
        confidence_threshold: Optional[float] = None,
        **kwargs: Any
    ) -> List[_models.FaceIdentificationResult]:
        # pylint: disable=line-too-long
        """1-to-many identification to find the closest matches of the specific query person face from a
        person directory personIds array.

        For each face in the faceIds array, Face Identify will compute similarities between the query
        face and all the faces in the Person Directory Persons (given by personIds), and return
        candidate person(s) for that face ranked by similarity confidence.
        Passing personIds with an array with one element "*" can perform the operation over entire
        person directory.

        ..

           [!NOTE]

           *


           * The algorithm allows more than one face to be identified independently at the same
        request, but no more than 10 faces.
           * Each person could have more than one face, but no more than 248 faces.
           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * Number of candidates returned is restricted by maxNumOfCandidatesReturned and
        confidenceThreshold. If no person is identified, the returned candidates will be an empty
        array.
           * The Identify operation can only match faces obtained with the same recognition model, that
        is associated with the query faces.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword face_ids: Array of query faces faceIds, created by the "Detect". Each of the faces are
         identified independently. The valid number of faceIds is between [1, 10]. Required.
        :paramtype face_ids: list[str]
        :keyword person_ids: Array of personIds created in Person Directory "Create Person". The valid
         number of personIds is between [1,30]. Required.
        :paramtype person_ids: list[str]
        :keyword max_num_of_candidates_returned: The range of maxNumOfCandidatesReturned is between 1
         and 100. Default value is 10. Default value is None.
        :paramtype max_num_of_candidates_returned: int
        :keyword confidence_threshold: Customized identification confidence threshold, in the range of
         [0, 1]. Advanced user can tweak this value to override default internal threshold for better
         precision on their scenario data. Note there is no guarantee of this threshold value working on
         other data and after algorithm updates. Default value is None.
        :paramtype confidence_threshold: float
        :return: list of FaceIdentificationResult
        :rtype: list[~azure.ai.vision.face.models.FaceIdentificationResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "faceIds": [
                        "str"  # Array of query faces faceIds, created by the "Detect". Each
                          of the faces are identified independently. The valid number of faceIds is
                          between [1, 10]. Required.
                    ],
                    "personIds": [
                        "str"  # Array of personIds created in Person Directory "Create
                          Person". The valid number of personIds is between [1,30]. Required.
                    ],
                    "confidenceThreshold": 0.0,  # Optional. Customized identification confidence
                      threshold, in the range of [0, 1]. Advanced user can tweak this value to override
                      default internal threshold for better precision on their scenario data. Note
                      there is no guarantee of this threshold value working on other data and after
                      algorithm updates.
                    "maxNumOfCandidatesReturned": 0  # Optional. The range of
                      maxNumOfCandidatesReturned is between 1 and 100. Default value is 10.
                }

                # response body for status code(s): 200
                response == [
                    {
                        "candidates": [
                            {
                                "confidence": 0.0,  # Confidence value of the
                                  candidate. The higher confidence, the more similar. Range between
                                  [0,1]. Required.
                                "personId": "str"  # personId of candidate person.
                                  Required.
                            }
                        ],
                        "faceId": "str"  # faceId of the query face. Required.
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[_models.FaceIdentificationResult]] = kwargs.pop("cls", None)

        if body is _Unset:
            if face_ids is _Unset:
                raise TypeError("missing required argument: face_ids")
            if person_ids is _Unset:
                raise TypeError("missing required argument: person_ids")
            body = {
                "confidencethreshold": confidence_threshold,
                "faceids": face_ids,
                "maxnumofcandidatesreturned": max_num_of_candidates_returned,
                "personids": person_ids,
            }
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_identify_from_person_directory_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.FaceIdentificationResult], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def identify_from_dynamic_person_group(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.FaceIdentificationResult]:
        # pylint: disable=line-too-long
        """1-to-many identification to find the closest matches of the specific query person face from a
        Dynamic Person Group.

        For each face in the faceIds array, Face Identify will compute similarities between the query
        face and all the faces in the Dynamic Person Group (given by dynamicPersonGroupId), and return
        candidate person(s) for that face ranked by similarity confidence.

        ..

           [!NOTE]

           *


           * The algorithm allows more than one face to be identified independently at the same
        request, but no more than 10 faces.
           * Each person could have more than one face, but no more than 248 faces.
           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * Number of candidates returned is restricted by maxNumOfCandidatesReturned and
        confidenceThreshold. If no person is identified, the returned candidates will be an empty
        array.
           * The Identify operation can only match faces obtained with the same recognition model, that
        is associated with the query faces.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of FaceIdentificationResult
        :rtype: list[~azure.ai.vision.face.models.FaceIdentificationResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "dynamicPersonGroupId": "str",  # DynamicPersonGroupId of the target
                      PersonDirectory DynamicPersonGroup to match against. Required.
                    "faceIds": [
                        "str"  # Array of query faces faceIds, created by the "Detect". Each
                          of the faces are identified independently. The valid number of faceIds is
                          between [1, 10]. Required.
                    ],
                    "confidenceThreshold": 0.0,  # Optional. Customized identification confidence
                      threshold, in the range of [0, 1]. Advanced user can tweak this value to override
                      default internal threshold for better precision on their scenario data. Note
                      there is no guarantee of this threshold value working on other data and after
                      algorithm updates.
                    "maxNumOfCandidatesReturned": 0  # Optional. The range of
                      maxNumOfCandidatesReturned is between 1 and 100. Default value is 10.
                }

                # response body for status code(s): 200
                response == [
                    {
                        "candidates": [
                            {
                                "confidence": 0.0,  # Confidence value of the
                                  candidate. The higher confidence, the more similar. Range between
                                  [0,1]. Required.
                                "personId": "str"  # personId of candidate person.
                                  Required.
                            }
                        ],
                        "faceId": "str"  # faceId of the query face. Required.
                    }
                ]
        """

    @overload
    async def identify_from_dynamic_person_group(
        self,
        *,
        face_ids: List[str],
        dynamic_person_group_id: str,
        content_type: str = "application/json",
        max_num_of_candidates_returned: Optional[int] = None,
        confidence_threshold: Optional[float] = None,
        **kwargs: Any
    ) -> List[_models.FaceIdentificationResult]:
        # pylint: disable=line-too-long
        """1-to-many identification to find the closest matches of the specific query person face from a
        Dynamic Person Group.

        For each face in the faceIds array, Face Identify will compute similarities between the query
        face and all the faces in the Dynamic Person Group (given by dynamicPersonGroupId), and return
        candidate person(s) for that face ranked by similarity confidence.

        ..

           [!NOTE]

           *


           * The algorithm allows more than one face to be identified independently at the same
        request, but no more than 10 faces.
           * Each person could have more than one face, but no more than 248 faces.
           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * Number of candidates returned is restricted by maxNumOfCandidatesReturned and
        confidenceThreshold. If no person is identified, the returned candidates will be an empty
        array.
           * The Identify operation can only match faces obtained with the same recognition model, that
        is associated with the query faces.

        :keyword face_ids: Array of query faces faceIds, created by the "Detect". Each of the faces are
         identified independently. The valid number of faceIds is between [1, 10]. Required.
        :paramtype face_ids: list[str]
        :keyword dynamic_person_group_id: DynamicPersonGroupId of the target PersonDirectory
         DynamicPersonGroup to match against. Required.
        :paramtype dynamic_person_group_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword max_num_of_candidates_returned: The range of maxNumOfCandidatesReturned is between 1
         and 100. Default value is 10. Default value is None.
        :paramtype max_num_of_candidates_returned: int
        :keyword confidence_threshold: Customized identification confidence threshold, in the range of
         [0, 1]. Advanced user can tweak this value to override default internal threshold for better
         precision on their scenario data. Note there is no guarantee of this threshold value working on
         other data and after algorithm updates. Default value is None.
        :paramtype confidence_threshold: float
        :return: list of FaceIdentificationResult
        :rtype: list[~azure.ai.vision.face.models.FaceIdentificationResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "candidates": [
                            {
                                "confidence": 0.0,  # Confidence value of the
                                  candidate. The higher confidence, the more similar. Range between
                                  [0,1]. Required.
                                "personId": "str"  # personId of candidate person.
                                  Required.
                            }
                        ],
                        "faceId": "str"  # faceId of the query face. Required.
                    }
                ]
        """

    @overload
    async def identify_from_dynamic_person_group(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.FaceIdentificationResult]:
        # pylint: disable=line-too-long
        """1-to-many identification to find the closest matches of the specific query person face from a
        Dynamic Person Group.

        For each face in the faceIds array, Face Identify will compute similarities between the query
        face and all the faces in the Dynamic Person Group (given by dynamicPersonGroupId), and return
        candidate person(s) for that face ranked by similarity confidence.

        ..

           [!NOTE]

           *


           * The algorithm allows more than one face to be identified independently at the same
        request, but no more than 10 faces.
           * Each person could have more than one face, but no more than 248 faces.
           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * Number of candidates returned is restricted by maxNumOfCandidatesReturned and
        confidenceThreshold. If no person is identified, the returned candidates will be an empty
        array.
           * The Identify operation can only match faces obtained with the same recognition model, that
        is associated with the query faces.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of FaceIdentificationResult
        :rtype: list[~azure.ai.vision.face.models.FaceIdentificationResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "candidates": [
                            {
                                "confidence": 0.0,  # Confidence value of the
                                  candidate. The higher confidence, the more similar. Range between
                                  [0,1]. Required.
                                "personId": "str"  # personId of candidate person.
                                  Required.
                            }
                        ],
                        "faceId": "str"  # faceId of the query face. Required.
                    }
                ]
        """

    @distributed_trace_async
    async def identify_from_dynamic_person_group(
        self,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        face_ids: List[str] = _Unset,
        dynamic_person_group_id: str = _Unset,
        max_num_of_candidates_returned: Optional[int] = None,
        confidence_threshold: Optional[float] = None,
        **kwargs: Any
    ) -> List[_models.FaceIdentificationResult]:
        # pylint: disable=line-too-long
        """1-to-many identification to find the closest matches of the specific query person face from a
        Dynamic Person Group.

        For each face in the faceIds array, Face Identify will compute similarities between the query
        face and all the faces in the Dynamic Person Group (given by dynamicPersonGroupId), and return
        candidate person(s) for that face ranked by similarity confidence.

        ..

           [!NOTE]

           *


           * The algorithm allows more than one face to be identified independently at the same
        request, but no more than 10 faces.
           * Each person could have more than one face, but no more than 248 faces.
           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * Number of candidates returned is restricted by maxNumOfCandidatesReturned and
        confidenceThreshold. If no person is identified, the returned candidates will be an empty
        array.
           * The Identify operation can only match faces obtained with the same recognition model, that
        is associated with the query faces.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword face_ids: Array of query faces faceIds, created by the "Detect". Each of the faces are
         identified independently. The valid number of faceIds is between [1, 10]. Required.
        :paramtype face_ids: list[str]
        :keyword dynamic_person_group_id: DynamicPersonGroupId of the target PersonDirectory
         DynamicPersonGroup to match against. Required.
        :paramtype dynamic_person_group_id: str
        :keyword max_num_of_candidates_returned: The range of maxNumOfCandidatesReturned is between 1
         and 100. Default value is 10. Default value is None.
        :paramtype max_num_of_candidates_returned: int
        :keyword confidence_threshold: Customized identification confidence threshold, in the range of
         [0, 1]. Advanced user can tweak this value to override default internal threshold for better
         precision on their scenario data. Note there is no guarantee of this threshold value working on
         other data and after algorithm updates. Default value is None.
        :paramtype confidence_threshold: float
        :return: list of FaceIdentificationResult
        :rtype: list[~azure.ai.vision.face.models.FaceIdentificationResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "dynamicPersonGroupId": "str",  # DynamicPersonGroupId of the target
                      PersonDirectory DynamicPersonGroup to match against. Required.
                    "faceIds": [
                        "str"  # Array of query faces faceIds, created by the "Detect". Each
                          of the faces are identified independently. The valid number of faceIds is
                          between [1, 10]. Required.
                    ],
                    "confidenceThreshold": 0.0,  # Optional. Customized identification confidence
                      threshold, in the range of [0, 1]. Advanced user can tweak this value to override
                      default internal threshold for better precision on their scenario data. Note
                      there is no guarantee of this threshold value working on other data and after
                      algorithm updates.
                    "maxNumOfCandidatesReturned": 0  # Optional. The range of
                      maxNumOfCandidatesReturned is between 1 and 100. Default value is 10.
                }

                # response body for status code(s): 200
                response == [
                    {
                        "candidates": [
                            {
                                "confidence": 0.0,  # Confidence value of the
                                  candidate. The higher confidence, the more similar. Range between
                                  [0,1]. Required.
                                "personId": "str"  # personId of candidate person.
                                  Required.
                            }
                        ],
                        "faceId": "str"  # faceId of the query face. Required.
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[_models.FaceIdentificationResult]] = kwargs.pop("cls", None)

        if body is _Unset:
            if face_ids is _Unset:
                raise TypeError("missing required argument: face_ids")
            if dynamic_person_group_id is _Unset:
                raise TypeError("missing required argument: dynamic_person_group_id")
            body = {
                "confidencethreshold": confidence_threshold,
                "dynamicpersongroupid": dynamic_person_group_id,
                "faceids": face_ids,
                "maxnumofcandidatesreturned": max_num_of_candidates_returned,
            }
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_identify_from_dynamic_person_group_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.FaceIdentificationResult], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def verify_face_to_face(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.FaceVerificationResult:
        # pylint: disable=line-too-long
        """Verify whether two faces belong to a same person.

        ..

           [!NOTE]

           *


           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * For the scenarios that are sensitive to accuracy please make your own judgment.
           * The 'recognitionModel' associated with the both faces should be the same.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: FaceVerificationResult. The FaceVerificationResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceVerificationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "faceId1": "str",  # The faceId of one face, come from "Detect". Required.
                    "faceId2": "str"  # The faceId of another face, come from "Detect". Required.
                }

                # response body for status code(s): 200
                response == {
                    "confidence": 0.0,  # A number indicates the similarity confidence of whether
                      two faces belong to the same person, or whether the face belongs to the person.
                      By default, isIdentical is set to True if similarity confidence is greater than
                      or equal to 0.5. This is useful for advanced users to override 'isIdentical' and
                      fine-tune the result on their own data. Required.
                    "isIdentical": bool  # True if the two faces belong to the same person or the
                      face belongs to the person, otherwise false. Required.
                }
        """

    @overload
    async def verify_face_to_face(
        self, *, face_id1: str, face_id2: str, content_type: str = "application/json", **kwargs: Any
    ) -> _models.FaceVerificationResult:
        # pylint: disable=line-too-long
        """Verify whether two faces belong to a same person.

        ..

           [!NOTE]

           *


           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * For the scenarios that are sensitive to accuracy please make your own judgment.
           * The 'recognitionModel' associated with the both faces should be the same.

        :keyword face_id1: The faceId of one face, come from "Detect". Required.
        :paramtype face_id1: str
        :keyword face_id2: The faceId of another face, come from "Detect". Required.
        :paramtype face_id2: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: FaceVerificationResult. The FaceVerificationResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceVerificationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "confidence": 0.0,  # A number indicates the similarity confidence of whether
                      two faces belong to the same person, or whether the face belongs to the person.
                      By default, isIdentical is set to True if similarity confidence is greater than
                      or equal to 0.5. This is useful for advanced users to override 'isIdentical' and
                      fine-tune the result on their own data. Required.
                    "isIdentical": bool  # True if the two faces belong to the same person or the
                      face belongs to the person, otherwise false. Required.
                }
        """

    @overload
    async def verify_face_to_face(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.FaceVerificationResult:
        # pylint: disable=line-too-long
        """Verify whether two faces belong to a same person.

        ..

           [!NOTE]

           *


           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * For the scenarios that are sensitive to accuracy please make your own judgment.
           * The 'recognitionModel' associated with the both faces should be the same.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: FaceVerificationResult. The FaceVerificationResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceVerificationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "confidence": 0.0,  # A number indicates the similarity confidence of whether
                      two faces belong to the same person, or whether the face belongs to the person.
                      By default, isIdentical is set to True if similarity confidence is greater than
                      or equal to 0.5. This is useful for advanced users to override 'isIdentical' and
                      fine-tune the result on their own data. Required.
                    "isIdentical": bool  # True if the two faces belong to the same person or the
                      face belongs to the person, otherwise false. Required.
                }
        """

    @distributed_trace_async
    async def verify_face_to_face(
        self, body: Union[JSON, IO[bytes]] = _Unset, *, face_id1: str = _Unset, face_id2: str = _Unset, **kwargs: Any
    ) -> _models.FaceVerificationResult:
        # pylint: disable=line-too-long
        """Verify whether two faces belong to a same person.

        ..

           [!NOTE]

           *


           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * For the scenarios that are sensitive to accuracy please make your own judgment.
           * The 'recognitionModel' associated with the both faces should be the same.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword face_id1: The faceId of one face, come from "Detect". Required.
        :paramtype face_id1: str
        :keyword face_id2: The faceId of another face, come from "Detect". Required.
        :paramtype face_id2: str
        :return: FaceVerificationResult. The FaceVerificationResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceVerificationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "faceId1": "str",  # The faceId of one face, come from "Detect". Required.
                    "faceId2": "str"  # The faceId of another face, come from "Detect". Required.
                }

                # response body for status code(s): 200
                response == {
                    "confidence": 0.0,  # A number indicates the similarity confidence of whether
                      two faces belong to the same person, or whether the face belongs to the person.
                      By default, isIdentical is set to True if similarity confidence is greater than
                      or equal to 0.5. This is useful for advanced users to override 'isIdentical' and
                      fine-tune the result on their own data. Required.
                    "isIdentical": bool  # True if the two faces belong to the same person or the
                      face belongs to the person, otherwise false. Required.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.FaceVerificationResult] = kwargs.pop("cls", None)

        if body is _Unset:
            if face_id1 is _Unset:
                raise TypeError("missing required argument: face_id1")
            if face_id2 is _Unset:
                raise TypeError("missing required argument: face_id2")
            body = {"faceid1": face_id1, "faceid2": face_id2}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_verify_face_to_face_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.FaceVerificationResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def verify_from_person_group(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.FaceVerificationResult:
        # pylint: disable=line-too-long
        """Verify whether a face belongs to a person in a Person Group.

        ..

           [!NOTE]

           *


           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * For the scenarios that are sensitive to accuracy please make your own judgment.
           * The 'recognitionModel' associated with the query face should be the same as the
        'recognitionModel' used by the Person Group.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: FaceVerificationResult. The FaceVerificationResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceVerificationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "faceId": "str",  # The faceId of the face, come from "Detect". Required.
                    "personGroupId": "str",  # Using existing personGroupId and personId for fast
                      loading a specified person. personGroupId is created in "Create Person Group".
                      Required.
                    "personId": "str"  # Specify a certain person in Person Group. Required.
                }

                # response body for status code(s): 200
                response == {
                    "confidence": 0.0,  # A number indicates the similarity confidence of whether
                      two faces belong to the same person, or whether the face belongs to the person.
                      By default, isIdentical is set to True if similarity confidence is greater than
                      or equal to 0.5. This is useful for advanced users to override 'isIdentical' and
                      fine-tune the result on their own data. Required.
                    "isIdentical": bool  # True if the two faces belong to the same person or the
                      face belongs to the person, otherwise false. Required.
                }
        """

    @overload
    async def verify_from_person_group(
        self,
        *,
        face_id: str,
        person_group_id: str,
        person_id: str,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.FaceVerificationResult:
        # pylint: disable=line-too-long
        """Verify whether a face belongs to a person in a Person Group.

        ..

           [!NOTE]

           *


           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * For the scenarios that are sensitive to accuracy please make your own judgment.
           * The 'recognitionModel' associated with the query face should be the same as the
        'recognitionModel' used by the Person Group.

        :keyword face_id: The faceId of the face, come from "Detect". Required.
        :paramtype face_id: str
        :keyword person_group_id: Using existing personGroupId and personId for fast loading a
         specified person. personGroupId is created in "Create Person Group". Required.
        :paramtype person_group_id: str
        :keyword person_id: Specify a certain person in Person Group. Required.
        :paramtype person_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: FaceVerificationResult. The FaceVerificationResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceVerificationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "confidence": 0.0,  # A number indicates the similarity confidence of whether
                      two faces belong to the same person, or whether the face belongs to the person.
                      By default, isIdentical is set to True if similarity confidence is greater than
                      or equal to 0.5. This is useful for advanced users to override 'isIdentical' and
                      fine-tune the result on their own data. Required.
                    "isIdentical": bool  # True if the two faces belong to the same person or the
                      face belongs to the person, otherwise false. Required.
                }
        """

    @overload
    async def verify_from_person_group(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.FaceVerificationResult:
        # pylint: disable=line-too-long
        """Verify whether a face belongs to a person in a Person Group.

        ..

           [!NOTE]

           *


           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * For the scenarios that are sensitive to accuracy please make your own judgment.
           * The 'recognitionModel' associated with the query face should be the same as the
        'recognitionModel' used by the Person Group.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: FaceVerificationResult. The FaceVerificationResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceVerificationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "confidence": 0.0,  # A number indicates the similarity confidence of whether
                      two faces belong to the same person, or whether the face belongs to the person.
                      By default, isIdentical is set to True if similarity confidence is greater than
                      or equal to 0.5. This is useful for advanced users to override 'isIdentical' and
                      fine-tune the result on their own data. Required.
                    "isIdentical": bool  # True if the two faces belong to the same person or the
                      face belongs to the person, otherwise false. Required.
                }
        """

    @distributed_trace_async
    async def verify_from_person_group(
        self,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        face_id: str = _Unset,
        person_group_id: str = _Unset,
        person_id: str = _Unset,
        **kwargs: Any
    ) -> _models.FaceVerificationResult:
        # pylint: disable=line-too-long
        """Verify whether a face belongs to a person in a Person Group.

        ..

           [!NOTE]

           *


           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * For the scenarios that are sensitive to accuracy please make your own judgment.
           * The 'recognitionModel' associated with the query face should be the same as the
        'recognitionModel' used by the Person Group.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword face_id: The faceId of the face, come from "Detect". Required.
        :paramtype face_id: str
        :keyword person_group_id: Using existing personGroupId and personId for fast loading a
         specified person. personGroupId is created in "Create Person Group". Required.
        :paramtype person_group_id: str
        :keyword person_id: Specify a certain person in Person Group. Required.
        :paramtype person_id: str
        :return: FaceVerificationResult. The FaceVerificationResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceVerificationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "faceId": "str",  # The faceId of the face, come from "Detect". Required.
                    "personGroupId": "str",  # Using existing personGroupId and personId for fast
                      loading a specified person. personGroupId is created in "Create Person Group".
                      Required.
                    "personId": "str"  # Specify a certain person in Person Group. Required.
                }

                # response body for status code(s): 200
                response == {
                    "confidence": 0.0,  # A number indicates the similarity confidence of whether
                      two faces belong to the same person, or whether the face belongs to the person.
                      By default, isIdentical is set to True if similarity confidence is greater than
                      or equal to 0.5. This is useful for advanced users to override 'isIdentical' and
                      fine-tune the result on their own data. Required.
                    "isIdentical": bool  # True if the two faces belong to the same person or the
                      face belongs to the person, otherwise false. Required.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.FaceVerificationResult] = kwargs.pop("cls", None)

        if body is _Unset:
            if face_id is _Unset:
                raise TypeError("missing required argument: face_id")
            if person_group_id is _Unset:
                raise TypeError("missing required argument: person_group_id")
            if person_id is _Unset:
                raise TypeError("missing required argument: person_id")
            body = {"faceid": face_id, "persongroupid": person_group_id, "personid": person_id}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_verify_from_person_group_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.FaceVerificationResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def verify_from_large_person_group(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.FaceVerificationResult:
        # pylint: disable=line-too-long
        """Verify whether a face belongs to a person in a Large Person Group.

        ..

           [!NOTE]

           *


           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * For the scenarios that are sensitive to accuracy please make your own judgment.
           * The 'recognitionModel' associated with the query face should be the same as the
        'recognitionModel' used by the Large Person Group.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: FaceVerificationResult. The FaceVerificationResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceVerificationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "faceId": "str",  # The faceId of the face, come from "Detect". Required.
                    "largePersonGroupId": "str",  # Using existing largePersonGroupId and
                      personId for fast loading a specified person. largePersonGroupId is created in
                      "Create Large Person Group". Required.
                    "personId": "str"  # Specify a certain person in Large Person Group.
                      Required.
                }

                # response body for status code(s): 200
                response == {
                    "confidence": 0.0,  # A number indicates the similarity confidence of whether
                      two faces belong to the same person, or whether the face belongs to the person.
                      By default, isIdentical is set to True if similarity confidence is greater than
                      or equal to 0.5. This is useful for advanced users to override 'isIdentical' and
                      fine-tune the result on their own data. Required.
                    "isIdentical": bool  # True if the two faces belong to the same person or the
                      face belongs to the person, otherwise false. Required.
                }
        """

    @overload
    async def verify_from_large_person_group(
        self,
        *,
        face_id: str,
        large_person_group_id: str,
        person_id: str,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.FaceVerificationResult:
        # pylint: disable=line-too-long
        """Verify whether a face belongs to a person in a Large Person Group.

        ..

           [!NOTE]

           *


           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * For the scenarios that are sensitive to accuracy please make your own judgment.
           * The 'recognitionModel' associated with the query face should be the same as the
        'recognitionModel' used by the Large Person Group.

        :keyword face_id: The faceId of the face, come from "Detect". Required.
        :paramtype face_id: str
        :keyword large_person_group_id: Using existing largePersonGroupId and personId for fast loading
         a specified person. largePersonGroupId is created in "Create Large Person Group". Required.
        :paramtype large_person_group_id: str
        :keyword person_id: Specify a certain person in Large Person Group. Required.
        :paramtype person_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: FaceVerificationResult. The FaceVerificationResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceVerificationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "confidence": 0.0,  # A number indicates the similarity confidence of whether
                      two faces belong to the same person, or whether the face belongs to the person.
                      By default, isIdentical is set to True if similarity confidence is greater than
                      or equal to 0.5. This is useful for advanced users to override 'isIdentical' and
                      fine-tune the result on their own data. Required.
                    "isIdentical": bool  # True if the two faces belong to the same person or the
                      face belongs to the person, otherwise false. Required.
                }
        """

    @overload
    async def verify_from_large_person_group(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.FaceVerificationResult:
        # pylint: disable=line-too-long
        """Verify whether a face belongs to a person in a Large Person Group.

        ..

           [!NOTE]

           *


           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * For the scenarios that are sensitive to accuracy please make your own judgment.
           * The 'recognitionModel' associated with the query face should be the same as the
        'recognitionModel' used by the Large Person Group.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: FaceVerificationResult. The FaceVerificationResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceVerificationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "confidence": 0.0,  # A number indicates the similarity confidence of whether
                      two faces belong to the same person, or whether the face belongs to the person.
                      By default, isIdentical is set to True if similarity confidence is greater than
                      or equal to 0.5. This is useful for advanced users to override 'isIdentical' and
                      fine-tune the result on their own data. Required.
                    "isIdentical": bool  # True if the two faces belong to the same person or the
                      face belongs to the person, otherwise false. Required.
                }
        """

    @distributed_trace_async
    async def verify_from_large_person_group(
        self,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        face_id: str = _Unset,
        large_person_group_id: str = _Unset,
        person_id: str = _Unset,
        **kwargs: Any
    ) -> _models.FaceVerificationResult:
        # pylint: disable=line-too-long
        """Verify whether a face belongs to a person in a Large Person Group.

        ..

           [!NOTE]

           *


           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * For the scenarios that are sensitive to accuracy please make your own judgment.
           * The 'recognitionModel' associated with the query face should be the same as the
        'recognitionModel' used by the Large Person Group.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword face_id: The faceId of the face, come from "Detect". Required.
        :paramtype face_id: str
        :keyword large_person_group_id: Using existing largePersonGroupId and personId for fast loading
         a specified person. largePersonGroupId is created in "Create Large Person Group". Required.
        :paramtype large_person_group_id: str
        :keyword person_id: Specify a certain person in Large Person Group. Required.
        :paramtype person_id: str
        :return: FaceVerificationResult. The FaceVerificationResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceVerificationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "faceId": "str",  # The faceId of the face, come from "Detect". Required.
                    "largePersonGroupId": "str",  # Using existing largePersonGroupId and
                      personId for fast loading a specified person. largePersonGroupId is created in
                      "Create Large Person Group". Required.
                    "personId": "str"  # Specify a certain person in Large Person Group.
                      Required.
                }

                # response body for status code(s): 200
                response == {
                    "confidence": 0.0,  # A number indicates the similarity confidence of whether
                      two faces belong to the same person, or whether the face belongs to the person.
                      By default, isIdentical is set to True if similarity confidence is greater than
                      or equal to 0.5. This is useful for advanced users to override 'isIdentical' and
                      fine-tune the result on their own data. Required.
                    "isIdentical": bool  # True if the two faces belong to the same person or the
                      face belongs to the person, otherwise false. Required.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.FaceVerificationResult] = kwargs.pop("cls", None)

        if body is _Unset:
            if face_id is _Unset:
                raise TypeError("missing required argument: face_id")
            if large_person_group_id is _Unset:
                raise TypeError("missing required argument: large_person_group_id")
            if person_id is _Unset:
                raise TypeError("missing required argument: person_id")
            body = {"faceid": face_id, "largepersongroupid": large_person_group_id, "personid": person_id}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_verify_from_large_person_group_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.FaceVerificationResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def verify_from_person_directory(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.FaceVerificationResult:
        # pylint: disable=line-too-long
        """Verify whether a face belongs to a person in Person Directory.

        ..

           [!NOTE]

           *


           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * For the scenarios that are sensitive to accuracy please make your own judgment.
           * The Verify operation can only match faces obtained with the same recognition model, that
        is associated with the query face.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: FaceVerificationResult. The FaceVerificationResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceVerificationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "faceId": "str",  # The faceId of the face, come from "Detect". Required.
                    "personId": "str"  # Specify a certain person in PersonDirectory Person.
                      Required.
                }

                # response body for status code(s): 200
                response == {
                    "confidence": 0.0,  # A number indicates the similarity confidence of whether
                      two faces belong to the same person, or whether the face belongs to the person.
                      By default, isIdentical is set to True if similarity confidence is greater than
                      or equal to 0.5. This is useful for advanced users to override 'isIdentical' and
                      fine-tune the result on their own data. Required.
                    "isIdentical": bool  # True if the two faces belong to the same person or the
                      face belongs to the person, otherwise false. Required.
                }
        """

    @overload
    async def verify_from_person_directory(
        self, *, face_id: str, person_id: str, content_type: str = "application/json", **kwargs: Any
    ) -> _models.FaceVerificationResult:
        # pylint: disable=line-too-long
        """Verify whether a face belongs to a person in Person Directory.

        ..

           [!NOTE]

           *


           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * For the scenarios that are sensitive to accuracy please make your own judgment.
           * The Verify operation can only match faces obtained with the same recognition model, that
        is associated with the query face.

        :keyword face_id: The faceId of the face, come from "Detect". Required.
        :paramtype face_id: str
        :keyword person_id: Specify a certain person in PersonDirectory Person. Required.
        :paramtype person_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: FaceVerificationResult. The FaceVerificationResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceVerificationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "confidence": 0.0,  # A number indicates the similarity confidence of whether
                      two faces belong to the same person, or whether the face belongs to the person.
                      By default, isIdentical is set to True if similarity confidence is greater than
                      or equal to 0.5. This is useful for advanced users to override 'isIdentical' and
                      fine-tune the result on their own data. Required.
                    "isIdentical": bool  # True if the two faces belong to the same person or the
                      face belongs to the person, otherwise false. Required.
                }
        """

    @overload
    async def verify_from_person_directory(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.FaceVerificationResult:
        # pylint: disable=line-too-long
        """Verify whether a face belongs to a person in Person Directory.

        ..

           [!NOTE]

           *


           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * For the scenarios that are sensitive to accuracy please make your own judgment.
           * The Verify operation can only match faces obtained with the same recognition model, that
        is associated with the query face.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: FaceVerificationResult. The FaceVerificationResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceVerificationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "confidence": 0.0,  # A number indicates the similarity confidence of whether
                      two faces belong to the same person, or whether the face belongs to the person.
                      By default, isIdentical is set to True if similarity confidence is greater than
                      or equal to 0.5. This is useful for advanced users to override 'isIdentical' and
                      fine-tune the result on their own data. Required.
                    "isIdentical": bool  # True if the two faces belong to the same person or the
                      face belongs to the person, otherwise false. Required.
                }
        """

    @distributed_trace_async
    async def verify_from_person_directory(
        self, body: Union[JSON, IO[bytes]] = _Unset, *, face_id: str = _Unset, person_id: str = _Unset, **kwargs: Any
    ) -> _models.FaceVerificationResult:
        # pylint: disable=line-too-long
        """Verify whether a face belongs to a person in Person Directory.

        ..

           [!NOTE]

           *


           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * For the scenarios that are sensitive to accuracy please make your own judgment.
           * The Verify operation can only match faces obtained with the same recognition model, that
        is associated with the query face.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword face_id: The faceId of the face, come from "Detect". Required.
        :paramtype face_id: str
        :keyword person_id: Specify a certain person in PersonDirectory Person. Required.
        :paramtype person_id: str
        :return: FaceVerificationResult. The FaceVerificationResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceVerificationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "faceId": "str",  # The faceId of the face, come from "Detect". Required.
                    "personId": "str"  # Specify a certain person in PersonDirectory Person.
                      Required.
                }

                # response body for status code(s): 200
                response == {
                    "confidence": 0.0,  # A number indicates the similarity confidence of whether
                      two faces belong to the same person, or whether the face belongs to the person.
                      By default, isIdentical is set to True if similarity confidence is greater than
                      or equal to 0.5. This is useful for advanced users to override 'isIdentical' and
                      fine-tune the result on their own data. Required.
                    "isIdentical": bool  # True if the two faces belong to the same person or the
                      face belongs to the person, otherwise false. Required.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.FaceVerificationResult] = kwargs.pop("cls", None)

        if body is _Unset:
            if face_id is _Unset:
                raise TypeError("missing required argument: face_id")
            if person_id is _Unset:
                raise TypeError("missing required argument: person_id")
            body = {"faceid": face_id, "personid": person_id}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_verify_from_person_directory_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.FaceVerificationResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def group(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.FaceGroupingResult:
        # pylint: disable=line-too-long
        """Divide candidate faces into groups based on face similarity.

        >
        *


        * The output is one or more disjointed face groups and a messyGroup. A face group contains
        faces that have similar looking, often of the same person. Face groups are ranked by group
        size, i.e. number of faces. Notice that faces belonging to a same person might be split into
        several groups in the result.
        * MessyGroup is a special face group containing faces that cannot find any similar counterpart
        face from original faces. The messyGroup will not appear in the result if all faces found their
        counterparts.
        * Group API needs at least 2 candidate faces and 1000 at most. We suggest to try "Verify Face
        To Face" when you only have 2 candidate faces.
        * The 'recognitionModel' associated with the query faces' faceIds should be the same.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: FaceGroupingResult. The FaceGroupingResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceGroupingResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "faceIds": [
                        "str"  # Array of candidate faceIds created by "Detect". The maximum
                          is 1000 faces. Required.
                    ]
                }

                # response body for status code(s): 200
                response == {
                    "groups": [
                        [
                            "str"  # A partition of the original faces based on face
                              similarity. Groups are ranked by number of faces. Required.
                        ]
                    ],
                    "messyGroup": [
                        "str"  # Face ids array of faces that cannot find any similar faces
                          from original faces. Required.
                    ]
                }
        """

    @overload
    async def group(
        self, *, face_ids: List[str], content_type: str = "application/json", **kwargs: Any
    ) -> _models.FaceGroupingResult:
        # pylint: disable=line-too-long
        """Divide candidate faces into groups based on face similarity.

        >
        *


        * The output is one or more disjointed face groups and a messyGroup. A face group contains
        faces that have similar looking, often of the same person. Face groups are ranked by group
        size, i.e. number of faces. Notice that faces belonging to a same person might be split into
        several groups in the result.
        * MessyGroup is a special face group containing faces that cannot find any similar counterpart
        face from original faces. The messyGroup will not appear in the result if all faces found their
        counterparts.
        * Group API needs at least 2 candidate faces and 1000 at most. We suggest to try "Verify Face
        To Face" when you only have 2 candidate faces.
        * The 'recognitionModel' associated with the query faces' faceIds should be the same.

        :keyword face_ids: Array of candidate faceIds created by "Detect". The maximum is 1000 faces.
         Required.
        :paramtype face_ids: list[str]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: FaceGroupingResult. The FaceGroupingResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceGroupingResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "groups": [
                        [
                            "str"  # A partition of the original faces based on face
                              similarity. Groups are ranked by number of faces. Required.
                        ]
                    ],
                    "messyGroup": [
                        "str"  # Face ids array of faces that cannot find any similar faces
                          from original faces. Required.
                    ]
                }
        """

    @overload
    async def group(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.FaceGroupingResult:
        # pylint: disable=line-too-long
        """Divide candidate faces into groups based on face similarity.

        >
        *


        * The output is one or more disjointed face groups and a messyGroup. A face group contains
        faces that have similar looking, often of the same person. Face groups are ranked by group
        size, i.e. number of faces. Notice that faces belonging to a same person might be split into
        several groups in the result.
        * MessyGroup is a special face group containing faces that cannot find any similar counterpart
        face from original faces. The messyGroup will not appear in the result if all faces found their
        counterparts.
        * Group API needs at least 2 candidate faces and 1000 at most. We suggest to try "Verify Face
        To Face" when you only have 2 candidate faces.
        * The 'recognitionModel' associated with the query faces' faceIds should be the same.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: FaceGroupingResult. The FaceGroupingResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceGroupingResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "groups": [
                        [
                            "str"  # A partition of the original faces based on face
                              similarity. Groups are ranked by number of faces. Required.
                        ]
                    ],
                    "messyGroup": [
                        "str"  # Face ids array of faces that cannot find any similar faces
                          from original faces. Required.
                    ]
                }
        """

    @distributed_trace_async
    async def group(
        self, body: Union[JSON, IO[bytes]] = _Unset, *, face_ids: List[str] = _Unset, **kwargs: Any
    ) -> _models.FaceGroupingResult:
        # pylint: disable=line-too-long
        """Divide candidate faces into groups based on face similarity.

        >
        *


        * The output is one or more disjointed face groups and a messyGroup. A face group contains
        faces that have similar looking, often of the same person. Face groups are ranked by group
        size, i.e. number of faces. Notice that faces belonging to a same person might be split into
        several groups in the result.
        * MessyGroup is a special face group containing faces that cannot find any similar counterpart
        face from original faces. The messyGroup will not appear in the result if all faces found their
        counterparts.
        * Group API needs at least 2 candidate faces and 1000 at most. We suggest to try "Verify Face
        To Face" when you only have 2 candidate faces.
        * The 'recognitionModel' associated with the query faces' faceIds should be the same.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword face_ids: Array of candidate faceIds created by "Detect". The maximum is 1000 faces.
         Required.
        :paramtype face_ids: list[str]
        :return: FaceGroupingResult. The FaceGroupingResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceGroupingResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "faceIds": [
                        "str"  # Array of candidate faceIds created by "Detect". The maximum
                          is 1000 faces. Required.
                    ]
                }

                # response body for status code(s): 200
                response == {
                    "groups": [
                        [
                            "str"  # A partition of the original faces based on face
                              similarity. Groups are ranked by number of faces. Required.
                        ]
                    ],
                    "messyGroup": [
                        "str"  # Face ids array of faces that cannot find any similar faces
                          from original faces. Required.
                    ]
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.FaceGroupingResult] = kwargs.pop("cls", None)

        if body is _Unset:
            if face_ids is _Unset:
                raise TypeError("missing required argument: face_ids")
            body = {"faceids": face_ids}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_group_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.FaceGroupingResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class FaceAdministrationClientOperationsMixin(  # pylint: disable=too-many-public-methods
    FaceAdministrationClientMixinABC
):

    @overload
    async def create_face_list(  # pylint: disable=inconsistent-return-statements
        self, face_list_id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Create an empty Face List with user-specified faceListId, name, an optional userData and
        recognitionModel.

        Up to 64 Face Lists are allowed in one subscription.

        Face List is a list of faces, up to 1,000 faces, and used by "Find Similar From Face List".

        After creation, user should use "Add Face List Face" to import the faces. No image will be
        stored. Only the extracted face feature(s) will be stored on server until "Delete Face List" is
        called.

        "Find Similar" is used for scenario like finding celebrity-like faces, similar face filtering,
        or as a light way face identification. But if the actual use is to identify person, please use
        Person Group / Large Person Group and "Identify".

        Please consider Large Face List when the face number is large. It can support up to 1,000,000
        faces.

        :param face_list_id: Valid character is letter in lower case or digit or '-' or '_', maximum
         length is 64. Required.
        :type face_list_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # User defined name, maximum length is 128. Required.
                    "recognitionModel": "str",  # Optional. The 'recognitionModel' associated
                      with this face list. Supported 'recognitionModel' values include
                      'recognition_01', 'recognition_02, 'recognition_03', and 'recognition_04'. The
                      default value is 'recognition_01'. 'recognition_04' is recommended since its
                      accuracy is improved on faces wearing masks compared with 'recognition_03', and
                      its overall accuracy is improved compared with 'recognition_01' and
                      'recognition_02'. Known values are: "recognition_01", "recognition_02",
                      "recognition_03", and "recognition_04".
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """

    @overload
    async def create_face_list(  # pylint: disable=inconsistent-return-statements
        self,
        face_list_id: str,
        *,
        name: str,
        content_type: str = "application/json",
        user_data: Optional[str] = None,
        recognition_model: Optional[Union[str, _models.FaceRecognitionModel]] = None,
        **kwargs: Any
    ) -> None:
        """Create an empty Face List with user-specified faceListId, name, an optional userData and
        recognitionModel.

        Up to 64 Face Lists are allowed in one subscription.

        Face List is a list of faces, up to 1,000 faces, and used by "Find Similar From Face List".

        After creation, user should use "Add Face List Face" to import the faces. No image will be
        stored. Only the extracted face feature(s) will be stored on server until "Delete Face List" is
        called.

        "Find Similar" is used for scenario like finding celebrity-like faces, similar face filtering,
        or as a light way face identification. But if the actual use is to identify person, please use
        Person Group / Large Person Group and "Identify".

        Please consider Large Face List when the face number is large. It can support up to 1,000,000
        faces.

        :param face_list_id: Valid character is letter in lower case or digit or '-' or '_', maximum
         length is 64. Required.
        :type face_list_id: str
        :keyword name: User defined name, maximum length is 128. Required.
        :paramtype name: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :keyword recognition_model: The 'recognitionModel' associated with this face list. Supported
         'recognitionModel' values include 'recognition_01', 'recognition_02, 'recognition_03', and
         'recognition_04'. The default value is 'recognition_01'. 'recognition_04' is recommended since
         its accuracy is improved on faces wearing masks compared with 'recognition_03', and its overall
         accuracy is improved compared with 'recognition_01' and 'recognition_02'. Known values are:
         "recognition_01", "recognition_02", "recognition_03", and "recognition_04". Default value is
         None.
        :paramtype recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_face_list(  # pylint: disable=inconsistent-return-statements
        self, face_list_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Create an empty Face List with user-specified faceListId, name, an optional userData and
        recognitionModel.

        Up to 64 Face Lists are allowed in one subscription.

        Face List is a list of faces, up to 1,000 faces, and used by "Find Similar From Face List".

        After creation, user should use "Add Face List Face" to import the faces. No image will be
        stored. Only the extracted face feature(s) will be stored on server until "Delete Face List" is
        called.

        "Find Similar" is used for scenario like finding celebrity-like faces, similar face filtering,
        or as a light way face identification. But if the actual use is to identify person, please use
        Person Group / Large Person Group and "Identify".

        Please consider Large Face List when the face number is large. It can support up to 1,000,000
        faces.

        :param face_list_id: Valid character is letter in lower case or digit or '-' or '_', maximum
         length is 64. Required.
        :type face_list_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_face_list(  # pylint: disable=inconsistent-return-statements
        self,
        face_list_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        name: str = _Unset,
        user_data: Optional[str] = None,
        recognition_model: Optional[Union[str, _models.FaceRecognitionModel]] = None,
        **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Create an empty Face List with user-specified faceListId, name, an optional userData and
        recognitionModel.

        Up to 64 Face Lists are allowed in one subscription.

        Face List is a list of faces, up to 1,000 faces, and used by "Find Similar From Face List".

        After creation, user should use "Add Face List Face" to import the faces. No image will be
        stored. Only the extracted face feature(s) will be stored on server until "Delete Face List" is
        called.

        "Find Similar" is used for scenario like finding celebrity-like faces, similar face filtering,
        or as a light way face identification. But if the actual use is to identify person, please use
        Person Group / Large Person Group and "Identify".

        Please consider Large Face List when the face number is large. It can support up to 1,000,000
        faces.

        :param face_list_id: Valid character is letter in lower case or digit or '-' or '_', maximum
         length is 64. Required.
        :type face_list_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword name: User defined name, maximum length is 128. Required.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :keyword recognition_model: The 'recognitionModel' associated with this face list. Supported
         'recognitionModel' values include 'recognition_01', 'recognition_02, 'recognition_03', and
         'recognition_04'. The default value is 'recognition_01'. 'recognition_04' is recommended since
         its accuracy is improved on faces wearing masks compared with 'recognition_03', and its overall
         accuracy is improved compared with 'recognition_01' and 'recognition_02'. Known values are:
         "recognition_01", "recognition_02", "recognition_03", and "recognition_04". Default value is
         None.
        :paramtype recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # User defined name, maximum length is 128. Required.
                    "recognitionModel": "str",  # Optional. The 'recognitionModel' associated
                      with this face list. Supported 'recognitionModel' values include
                      'recognition_01', 'recognition_02, 'recognition_03', and 'recognition_04'. The
                      default value is 'recognition_01'. 'recognition_04' is recommended since its
                      accuracy is improved on faces wearing masks compared with 'recognition_03', and
                      its overall accuracy is improved compared with 'recognition_01' and
                      'recognition_02'. Known values are: "recognition_01", "recognition_02",
                      "recognition_03", and "recognition_04".
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        if body is _Unset:
            if name is _Unset:
                raise TypeError("missing required argument: name")
            body = {"name": name, "recognitionmodel": recognition_model, "userdata": user_data}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_administration_create_face_list_request(
            face_list_id=face_list_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def delete_face_list(  # pylint: disable=inconsistent-return-statements
        self, face_list_id: str, **kwargs: Any
    ) -> None:
        """Delete a specified Face List.

        :param face_list_id: Valid character is letter in lower case or digit or '-' or '_', maximum
         length is 64. Required.
        :type face_list_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_face_administration_delete_face_list_request(
            face_list_id=face_list_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_face_list(
        self, face_list_id: str, *, return_recognition_model: Optional[bool] = None, **kwargs: Any
    ) -> _models.FaceList:
        # pylint: disable=line-too-long
        """Retrieve a Face List's faceListId, name, userData, recognitionModel and faces in the Face List.

        :param face_list_id: Valid character is letter in lower case or digit or '-' or '_', maximum
         length is 64. Required.
        :type face_list_id: str
        :keyword return_recognition_model: Return 'recognitionModel' or not. The default value is
         false. Default value is None.
        :paramtype return_recognition_model: bool
        :return: FaceList. The FaceList is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceList
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "faceListId": "str",  # Valid character is letter in lower case or digit or
                      '-' or '_', maximum length is 64. Required.
                    "name": "str",  # User defined name, maximum length is 128. Required.
                    "persistedFaces": [
                        {
                            "persistedFaceId": "str",  # Face ID of the face. Required.
                            "userData": "str"  # Optional. User-provided data attached to
                              the face. The length limit is 1K.
                        }
                    ],
                    "recognitionModel": "str",  # Optional. Name of recognition model.
                      Recognition model is used when the face features are extracted and associated
                      with detected faceIds. Known values are: "recognition_01", "recognition_02",
                      "recognition_03", and "recognition_04".
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.FaceList] = kwargs.pop("cls", None)

        _request = build_face_administration_get_face_list_request(
            face_list_id=face_list_id,
            return_recognition_model=return_recognition_model,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.FaceList, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_face_list(  # pylint: disable=inconsistent-return-statements
        self, face_list_id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Update information of a Face List, including name and userData.

        :param face_list_id: Valid character is letter in lower case or digit or '-' or '_', maximum
         length is 64. Required.
        :type face_list_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # Optional. User defined name, maximum length is 128.
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """

    @overload
    async def update_face_list(  # pylint: disable=inconsistent-return-statements
        self,
        face_list_id: str,
        *,
        content_type: str = "application/json",
        name: Optional[str] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Update information of a Face List, including name and userData.

        :param face_list_id: Valid character is letter in lower case or digit or '-' or '_', maximum
         length is 64. Required.
        :type face_list_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword name: User defined name, maximum length is 128. Default value is None.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_face_list(  # pylint: disable=inconsistent-return-statements
        self, face_list_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Update information of a Face List, including name and userData.

        :param face_list_id: Valid character is letter in lower case or digit or '-' or '_', maximum
         length is 64. Required.
        :type face_list_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_face_list(  # pylint: disable=inconsistent-return-statements
        self,
        face_list_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        name: Optional[str] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Update information of a Face List, including name and userData.

        :param face_list_id: Valid character is letter in lower case or digit or '-' or '_', maximum
         length is 64. Required.
        :type face_list_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword name: User defined name, maximum length is 128. Default value is None.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # Optional. User defined name, maximum length is 128.
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        if body is _Unset:
            body = {"name": name, "userdata": user_data}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_administration_update_face_list_request(
            face_list_id=face_list_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_face_lists(
        self, *, return_recognition_model: Optional[bool] = None, **kwargs: Any
    ) -> List[_models.FaceListItem]:
        # pylint: disable=line-too-long
        """List Face Lists' faceListId, name, userData and recognitionModel.

        To get face information inside Face List use "Get Face List".

        :keyword return_recognition_model: Return 'recognitionModel' or not. The default value is
         false. Default value is None.
        :paramtype return_recognition_model: bool
        :return: list of FaceListItem
        :rtype: list[~azure.ai.vision.face.models.FaceListItem]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "faceListId": "str",  # Valid character is letter in lower case or
                          digit or '-' or '_', maximum length is 64. Required.
                        "name": "str",  # User defined name, maximum length is 128. Required.
                        "recognitionModel": "str",  # Optional. Name of recognition model.
                          Recognition model is used when the face features are extracted and associated
                          with detected faceIds. Known values are: "recognition_01", "recognition_02",
                          "recognition_03", and "recognition_04".
                        "userData": "str"  # Optional. Optional user defined data. Length
                          should not exceed 16K.
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.FaceListItem]] = kwargs.pop("cls", None)

        _request = build_face_administration_get_face_lists_request(
            return_recognition_model=return_recognition_model,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.FaceListItem], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def add_face_list_face_from_url(
        self,
        face_list_id: str,
        body: JSON,
        *,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AddFaceResult:
        # pylint: disable=line-too-long
        """Add a face to a specified Face List, up to 1,000 faces.

        To deal with an image containing multiple faces, input face can be specified as an image with a
        targetFace rectangle. It returns a persistedFaceId representing the added face. No image will
        be stored. Only the extracted face feature(s) will be stored on server until "Delete Face List
        Face" or "Delete Face List" is called.

        Note that persistedFaceId is different from faceId generated by "Detect".
        >
        *


        * Higher face image quality means better recognition precision. Please consider high-quality
        faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes) or bigger.
        * Each person entry can hold up to 248 faces.
        * JPEG, PNG, GIF (the first frame), and BMP format are supported. The allowed image file size
        is from 1KB to 6MB.
        * "targetFace" rectangle should contain one face. Zero or multiple faces will be regarded as an
        error. If the provided "targetFace" rectangle is not returned from "Detect", there's no
        guarantee to detect and add the face successfully.
        * Out of detectable face size (36x36 - 4096x4096 pixels), large head-pose, or large occlusions
        will cause failures.
        * The minimum detectable face size is 36x36 pixels in an image no larger than 1920x1080 pixels.
        Images with dimensions higher than 1920x1080 pixels will need a proportionally larger minimum
        face size.
        * Different 'detectionModel' values can be provided. To use and compare different detection
        models, please refer to
        https://learn.microsoft.com/azure/ai-services/computer-vision/how-to/specify-detection-model.

        :param face_list_id: Valid character is letter in lower case or digit or '-' or '_', maximum
         length is 64. Required.
        :type face_list_id: str
        :param body: Required.
        :type body: JSON
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AddFaceResult. The AddFaceResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.AddFaceResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "url": "str"  # URL of input image. Required.
                }

                # response body for status code(s): 200
                response == {
                    "persistedFaceId": "str"  # Persisted Face ID of the added face, which is
                      persisted and will not expire. Different from faceId which is created in "Detect"
                      and will expire in 24 hours after the detection call. Required.
                }
        """

    @overload
    async def add_face_list_face_from_url(
        self,
        face_list_id: str,
        *,
        url: str,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AddFaceResult:
        # pylint: disable=line-too-long
        """Add a face to a specified Face List, up to 1,000 faces.

        To deal with an image containing multiple faces, input face can be specified as an image with a
        targetFace rectangle. It returns a persistedFaceId representing the added face. No image will
        be stored. Only the extracted face feature(s) will be stored on server until "Delete Face List
        Face" or "Delete Face List" is called.

        Note that persistedFaceId is different from faceId generated by "Detect".
        >
        *


        * Higher face image quality means better recognition precision. Please consider high-quality
        faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes) or bigger.
        * Each person entry can hold up to 248 faces.
        * JPEG, PNG, GIF (the first frame), and BMP format are supported. The allowed image file size
        is from 1KB to 6MB.
        * "targetFace" rectangle should contain one face. Zero or multiple faces will be regarded as an
        error. If the provided "targetFace" rectangle is not returned from "Detect", there's no
        guarantee to detect and add the face successfully.
        * Out of detectable face size (36x36 - 4096x4096 pixels), large head-pose, or large occlusions
        will cause failures.
        * The minimum detectable face size is 36x36 pixels in an image no larger than 1920x1080 pixels.
        Images with dimensions higher than 1920x1080 pixels will need a proportionally larger minimum
        face size.
        * Different 'detectionModel' values can be provided. To use and compare different detection
        models, please refer to
        https://learn.microsoft.com/azure/ai-services/computer-vision/how-to/specify-detection-model.

        :param face_list_id: Valid character is letter in lower case or digit or '-' or '_', maximum
         length is 64. Required.
        :type face_list_id: str
        :keyword url: URL of input image. Required.
        :paramtype url: str
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AddFaceResult. The AddFaceResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.AddFaceResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "persistedFaceId": "str"  # Persisted Face ID of the added face, which is
                      persisted and will not expire. Different from faceId which is created in "Detect"
                      and will expire in 24 hours after the detection call. Required.
                }
        """

    @overload
    async def add_face_list_face_from_url(
        self,
        face_list_id: str,
        body: IO[bytes],
        *,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AddFaceResult:
        # pylint: disable=line-too-long
        """Add a face to a specified Face List, up to 1,000 faces.

        To deal with an image containing multiple faces, input face can be specified as an image with a
        targetFace rectangle. It returns a persistedFaceId representing the added face. No image will
        be stored. Only the extracted face feature(s) will be stored on server until "Delete Face List
        Face" or "Delete Face List" is called.

        Note that persistedFaceId is different from faceId generated by "Detect".
        >
        *


        * Higher face image quality means better recognition precision. Please consider high-quality
        faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes) or bigger.
        * Each person entry can hold up to 248 faces.
        * JPEG, PNG, GIF (the first frame), and BMP format are supported. The allowed image file size
        is from 1KB to 6MB.
        * "targetFace" rectangle should contain one face. Zero or multiple faces will be regarded as an
        error. If the provided "targetFace" rectangle is not returned from "Detect", there's no
        guarantee to detect and add the face successfully.
        * Out of detectable face size (36x36 - 4096x4096 pixels), large head-pose, or large occlusions
        will cause failures.
        * The minimum detectable face size is 36x36 pixels in an image no larger than 1920x1080 pixels.
        Images with dimensions higher than 1920x1080 pixels will need a proportionally larger minimum
        face size.
        * Different 'detectionModel' values can be provided. To use and compare different detection
        models, please refer to
        https://learn.microsoft.com/azure/ai-services/computer-vision/how-to/specify-detection-model.

        :param face_list_id: Valid character is letter in lower case or digit or '-' or '_', maximum
         length is 64. Required.
        :type face_list_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AddFaceResult. The AddFaceResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.AddFaceResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "persistedFaceId": "str"  # Persisted Face ID of the added face, which is
                      persisted and will not expire. Different from faceId which is created in "Detect"
                      and will expire in 24 hours after the detection call. Required.
                }
        """

    @distributed_trace_async
    async def add_face_list_face_from_url(
        self,
        face_list_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        url: str = _Unset,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> _models.AddFaceResult:
        # pylint: disable=line-too-long
        """Add a face to a specified Face List, up to 1,000 faces.

        To deal with an image containing multiple faces, input face can be specified as an image with a
        targetFace rectangle. It returns a persistedFaceId representing the added face. No image will
        be stored. Only the extracted face feature(s) will be stored on server until "Delete Face List
        Face" or "Delete Face List" is called.

        Note that persistedFaceId is different from faceId generated by "Detect".
        >
        *


        * Higher face image quality means better recognition precision. Please consider high-quality
        faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes) or bigger.
        * Each person entry can hold up to 248 faces.
        * JPEG, PNG, GIF (the first frame), and BMP format are supported. The allowed image file size
        is from 1KB to 6MB.
        * "targetFace" rectangle should contain one face. Zero or multiple faces will be regarded as an
        error. If the provided "targetFace" rectangle is not returned from "Detect", there's no
        guarantee to detect and add the face successfully.
        * Out of detectable face size (36x36 - 4096x4096 pixels), large head-pose, or large occlusions
        will cause failures.
        * The minimum detectable face size is 36x36 pixels in an image no larger than 1920x1080 pixels.
        Images with dimensions higher than 1920x1080 pixels will need a proportionally larger minimum
        face size.
        * Different 'detectionModel' values can be provided. To use and compare different detection
        models, please refer to
        https://learn.microsoft.com/azure/ai-services/computer-vision/how-to/specify-detection-model.

        :param face_list_id: Valid character is letter in lower case or digit or '-' or '_', maximum
         length is 64. Required.
        :type face_list_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword url: URL of input image. Required.
        :paramtype url: str
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :return: AddFaceResult. The AddFaceResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.AddFaceResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "url": "str"  # URL of input image. Required.
                }

                # response body for status code(s): 200
                response == {
                    "persistedFaceId": "str"  # Persisted Face ID of the added face, which is
                      persisted and will not expire. Different from faceId which is created in "Detect"
                      and will expire in 24 hours after the detection call. Required.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AddFaceResult] = kwargs.pop("cls", None)

        if body is _Unset:
            if url is _Unset:
                raise TypeError("missing required argument: url")
            body = {"url": url}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_administration_add_face_list_face_from_url_request(
            face_list_id=face_list_id,
            target_face=target_face,
            detection_model=detection_model,
            user_data=user_data,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AddFaceResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def add_face_list_face(
        self,
        face_list_id: str,
        image_content: bytes,
        *,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> _models.AddFaceResult:
        # pylint: disable=line-too-long
        """Add a face to a specified Face List, up to 1,000 faces.

        To deal with an image containing multiple faces, input face can be specified as an image with a
        targetFace rectangle. It returns a persistedFaceId representing the added face. No image will
        be stored. Only the extracted face feature(s) will be stored on server until "Delete Face List
        Face" or "Delete Face List" is called.

        Note that persistedFaceId is different from faceId generated by "Detect".
        >
        *


        * Higher face image quality means better recognition precision. Please consider high-quality
        faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes) or bigger.
        * Each person entry can hold up to 248 faces.
        * JPEG, PNG, GIF (the first frame), and BMP format are supported. The allowed image file size
        is from 1KB to 6MB.
        * "targetFace" rectangle should contain one face. Zero or multiple faces will be regarded as an
        error. If the provided "targetFace" rectangle is not returned from "Detect", there's no
        guarantee to detect and add the face successfully.
        * Out of detectable face size (36x36 - 4096x4096 pixels), large head-pose, or large occlusions
        will cause failures.
        * The minimum detectable face size is 36x36 pixels in an image no larger than 1920x1080 pixels.
        Images with dimensions higher than 1920x1080 pixels will need a proportionally larger minimum
        face size.
        * Different 'detectionModel' values can be provided. To use and compare different detection
        models, please refer to
        https://learn.microsoft.com/azure/ai-services/computer-vision/how-to/specify-detection-model.

        :param face_list_id: Valid character is letter in lower case or digit or '-' or '_', maximum
         length is 64. Required.
        :type face_list_id: str
        :param image_content: The image to be analyzed. Required.
        :type image_content: bytes
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :return: AddFaceResult. The AddFaceResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.AddFaceResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "persistedFaceId": "str"  # Persisted Face ID of the added face, which is
                      persisted and will not expire. Different from faceId which is created in "Detect"
                      and will expire in 24 hours after the detection call. Required.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop("content_type", _headers.pop("content-type", "application/octet-stream"))
        cls: ClsType[_models.AddFaceResult] = kwargs.pop("cls", None)

        _content = image_content

        _request = build_face_administration_add_face_list_face_request(
            face_list_id=face_list_id,
            target_face=target_face,
            detection_model=detection_model,
            user_data=user_data,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AddFaceResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_face_list_face(  # pylint: disable=inconsistent-return-statements
        self, face_list_id: str, persisted_face_id: str, **kwargs: Any
    ) -> None:
        """Delete a face from a Face List by specified faceListId and persistedFaceId.

        Adding/deleting faces to/from a same Face List are processed sequentially and to/from different
        Face Lists are in parallel.

        :param face_list_id: Valid character is letter in lower case or digit or '-' or '_', maximum
         length is 64. Required.
        :type face_list_id: str
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_face_administration_delete_face_list_face_request(
            face_list_id=face_list_id,
            persisted_face_id=persisted_face_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def create_large_face_list(  # pylint: disable=inconsistent-return-statements
        self, large_face_list_id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Create an empty Large Face List with user-specified largeFaceListId, name, an optional userData
        and recognitionModel.

        Large Face List is a list of faces, up to 1,000,000 faces, and used by "Find Similar From Large
        Face List".

        After creation, user should use Add Large Face List Face to import the faces and Train Large
        Face List to make it ready for "Find Similar". No image will be stored. Only the extracted face
        feature(s) will be stored on server until Delete Large Face List is called.

        "Find Similar" is used for scenario like finding celebrity-like faces, similar face filtering,
        or as a light way face identification. But if the actual use is to identify person, please use
        Person Group / Large Person Group and "Identify".

        ..

           [!NOTE]

           *


           * Free-tier subscription quota: 64 Large Face Lists.
           * S0-tier subscription quota: 1,000,000 Large Face Lists.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # User defined name, maximum length is 128. Required.
                    "recognitionModel": "str",  # Optional. The 'recognitionModel' associated
                      with this face list. Supported 'recognitionModel' values include
                      'recognition_01', 'recognition_02, 'recognition_03', and 'recognition_04'. The
                      default value is 'recognition_01'. 'recognition_04' is recommended since its
                      accuracy is improved on faces wearing masks compared with 'recognition_03', and
                      its overall accuracy is improved compared with 'recognition_01' and
                      'recognition_02'. Known values are: "recognition_01", "recognition_02",
                      "recognition_03", and "recognition_04".
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """

    @overload
    async def create_large_face_list(  # pylint: disable=inconsistent-return-statements
        self,
        large_face_list_id: str,
        *,
        name: str,
        content_type: str = "application/json",
        user_data: Optional[str] = None,
        recognition_model: Optional[Union[str, _models.FaceRecognitionModel]] = None,
        **kwargs: Any
    ) -> None:
        """Create an empty Large Face List with user-specified largeFaceListId, name, an optional userData
        and recognitionModel.

        Large Face List is a list of faces, up to 1,000,000 faces, and used by "Find Similar From Large
        Face List".

        After creation, user should use Add Large Face List Face to import the faces and Train Large
        Face List to make it ready for "Find Similar". No image will be stored. Only the extracted face
        feature(s) will be stored on server until Delete Large Face List is called.

        "Find Similar" is used for scenario like finding celebrity-like faces, similar face filtering,
        or as a light way face identification. But if the actual use is to identify person, please use
        Person Group / Large Person Group and "Identify".

        ..

           [!NOTE]

           *


           * Free-tier subscription quota: 64 Large Face Lists.
           * S0-tier subscription quota: 1,000,000 Large Face Lists.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :keyword name: User defined name, maximum length is 128. Required.
        :paramtype name: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :keyword recognition_model: The 'recognitionModel' associated with this face list. Supported
         'recognitionModel' values include 'recognition_01', 'recognition_02, 'recognition_03', and
         'recognition_04'. The default value is 'recognition_01'. 'recognition_04' is recommended since
         its accuracy is improved on faces wearing masks compared with 'recognition_03', and its overall
         accuracy is improved compared with 'recognition_01' and 'recognition_02'. Known values are:
         "recognition_01", "recognition_02", "recognition_03", and "recognition_04". Default value is
         None.
        :paramtype recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_large_face_list(  # pylint: disable=inconsistent-return-statements
        self, large_face_list_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Create an empty Large Face List with user-specified largeFaceListId, name, an optional userData
        and recognitionModel.

        Large Face List is a list of faces, up to 1,000,000 faces, and used by "Find Similar From Large
        Face List".

        After creation, user should use Add Large Face List Face to import the faces and Train Large
        Face List to make it ready for "Find Similar". No image will be stored. Only the extracted face
        feature(s) will be stored on server until Delete Large Face List is called.

        "Find Similar" is used for scenario like finding celebrity-like faces, similar face filtering,
        or as a light way face identification. But if the actual use is to identify person, please use
        Person Group / Large Person Group and "Identify".

        ..

           [!NOTE]

           *


           * Free-tier subscription quota: 64 Large Face Lists.
           * S0-tier subscription quota: 1,000,000 Large Face Lists.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_large_face_list(  # pylint: disable=inconsistent-return-statements
        self,
        large_face_list_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        name: str = _Unset,
        user_data: Optional[str] = None,
        recognition_model: Optional[Union[str, _models.FaceRecognitionModel]] = None,
        **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Create an empty Large Face List with user-specified largeFaceListId, name, an optional userData
        and recognitionModel.

        Large Face List is a list of faces, up to 1,000,000 faces, and used by "Find Similar From Large
        Face List".

        After creation, user should use Add Large Face List Face to import the faces and Train Large
        Face List to make it ready for "Find Similar". No image will be stored. Only the extracted face
        feature(s) will be stored on server until Delete Large Face List is called.

        "Find Similar" is used for scenario like finding celebrity-like faces, similar face filtering,
        or as a light way face identification. But if the actual use is to identify person, please use
        Person Group / Large Person Group and "Identify".

        ..

           [!NOTE]

           *


           * Free-tier subscription quota: 64 Large Face Lists.
           * S0-tier subscription quota: 1,000,000 Large Face Lists.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword name: User defined name, maximum length is 128. Required.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :keyword recognition_model: The 'recognitionModel' associated with this face list. Supported
         'recognitionModel' values include 'recognition_01', 'recognition_02, 'recognition_03', and
         'recognition_04'. The default value is 'recognition_01'. 'recognition_04' is recommended since
         its accuracy is improved on faces wearing masks compared with 'recognition_03', and its overall
         accuracy is improved compared with 'recognition_01' and 'recognition_02'. Known values are:
         "recognition_01", "recognition_02", "recognition_03", and "recognition_04". Default value is
         None.
        :paramtype recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # User defined name, maximum length is 128. Required.
                    "recognitionModel": "str",  # Optional. The 'recognitionModel' associated
                      with this face list. Supported 'recognitionModel' values include
                      'recognition_01', 'recognition_02, 'recognition_03', and 'recognition_04'. The
                      default value is 'recognition_01'. 'recognition_04' is recommended since its
                      accuracy is improved on faces wearing masks compared with 'recognition_03', and
                      its overall accuracy is improved compared with 'recognition_01' and
                      'recognition_02'. Known values are: "recognition_01", "recognition_02",
                      "recognition_03", and "recognition_04".
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        if body is _Unset:
            if name is _Unset:
                raise TypeError("missing required argument: name")
            body = {"name": name, "recognitionmodel": recognition_model, "userdata": user_data}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_administration_create_large_face_list_request(
            large_face_list_id=large_face_list_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def delete_large_face_list(  # pylint: disable=inconsistent-return-statements
        self, large_face_list_id: str, **kwargs: Any
    ) -> None:
        """Delete a face from a Large Face List by specified largeFaceListId and persistedFaceId.

        Adding/deleting faces to/from a same Large Face List are processed sequentially and to/from
        different Large Face Lists are in parallel.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_face_administration_delete_large_face_list_request(
            large_face_list_id=large_face_list_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_large_face_list(
        self, large_face_list_id: str, *, return_recognition_model: Optional[bool] = None, **kwargs: Any
    ) -> _models.LargeFaceList:
        # pylint: disable=line-too-long
        """Retrieve a Large Face List's largeFaceListId, name, userData and recognitionModel.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :keyword return_recognition_model: Return 'recognitionModel' or not. The default value is
         false. Default value is None.
        :paramtype return_recognition_model: bool
        :return: LargeFaceList. The LargeFaceList is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.LargeFaceList
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "largeFaceListId": "str",  # Valid character is letter in lower case or digit
                      or '-' or '_', maximum length is 64. Required.
                    "name": "str",  # User defined name, maximum length is 128. Required.
                    "recognitionModel": "str",  # Optional. Name of recognition model.
                      Recognition model is used when the face features are extracted and associated
                      with detected faceIds. Known values are: "recognition_01", "recognition_02",
                      "recognition_03", and "recognition_04".
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.LargeFaceList] = kwargs.pop("cls", None)

        _request = build_face_administration_get_large_face_list_request(
            large_face_list_id=large_face_list_id,
            return_recognition_model=return_recognition_model,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.LargeFaceList, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_large_face_list(  # pylint: disable=inconsistent-return-statements
        self, large_face_list_id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Update information of a Large Face List, including name and userData.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # Optional. User defined name, maximum length is 128.
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """

    @overload
    async def update_large_face_list(  # pylint: disable=inconsistent-return-statements
        self,
        large_face_list_id: str,
        *,
        content_type: str = "application/json",
        name: Optional[str] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Update information of a Large Face List, including name and userData.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword name: User defined name, maximum length is 128. Default value is None.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_large_face_list(  # pylint: disable=inconsistent-return-statements
        self, large_face_list_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Update information of a Large Face List, including name and userData.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_large_face_list(  # pylint: disable=inconsistent-return-statements
        self,
        large_face_list_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        name: Optional[str] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Update information of a Large Face List, including name and userData.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword name: User defined name, maximum length is 128. Default value is None.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # Optional. User defined name, maximum length is 128.
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        if body is _Unset:
            body = {"name": name, "userdata": user_data}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_administration_update_large_face_list_request(
            large_face_list_id=large_face_list_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_large_face_lists(
        self,
        *,
        start: Optional[str] = None,
        top: Optional[int] = None,
        return_recognition_model: Optional[bool] = None,
        **kwargs: Any
    ) -> List[_models.LargeFaceList]:
        # pylint: disable=line-too-long
        """List Large Face Lists' information of largeFaceListId, name, userData and recognitionModel.

        To get face information inside largeFaceList use "Get Large Face List Face".

        Large Face Lists are stored in alphabetical order of largeFaceListId.
        >
        *


        * "start" parameter (string, optional) specifies an ID value from which returned entries will
        have larger IDs based on string comparison. Setting "start" to an empty value indicates that
        entries should be returned starting from the first item.
        * "top" parameter (int, optional) determines the maximum number of entries to be returned, with
        a limit of up to 1000 entries per call. To retrieve additional entries beyond this limit,
        specify "start" with the personId of the last entry returned in the current call.

        ..

           [!TIP]


           * For example, there are total 5 items with their IDs: "itemId1", ..., "itemId5".

             * "start=&top=" will return all 5 items.
             * "start=&top=2" will return "itemId1", "itemId2".
             * "start=itemId2&top=3" will return "itemId3", "itemId4", "itemId5".

        :keyword start: List resources greater than the "start". It contains no more than 64
         characters. Default is empty. Default value is None.
        :paramtype start: str
        :keyword top: The number of items to list, ranging in [1, 1000]. Default is 1000. Default value
         is None.
        :paramtype top: int
        :keyword return_recognition_model: Return 'recognitionModel' or not. The default value is
         false. Default value is None.
        :paramtype return_recognition_model: bool
        :return: list of LargeFaceList
        :rtype: list[~azure.ai.vision.face.models.LargeFaceList]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "largeFaceListId": "str",  # Valid character is letter in lower case
                          or digit or '-' or '_', maximum length is 64. Required.
                        "name": "str",  # User defined name, maximum length is 128. Required.
                        "recognitionModel": "str",  # Optional. Name of recognition model.
                          Recognition model is used when the face features are extracted and associated
                          with detected faceIds. Known values are: "recognition_01", "recognition_02",
                          "recognition_03", and "recognition_04".
                        "userData": "str"  # Optional. Optional user defined data. Length
                          should not exceed 16K.
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.LargeFaceList]] = kwargs.pop("cls", None)

        _request = build_face_administration_get_large_face_lists_request(
            start=start,
            top=top,
            return_recognition_model=return_recognition_model,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.LargeFaceList], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_large_face_list_training_status(
        self, large_face_list_id: str, **kwargs: Any
    ) -> _models.FaceCollectionTrainingResult:
        # pylint: disable=line-too-long
        """To check the Large Face List training status completed or still ongoing. Large Face List
        training is an asynchronous operation triggered by "Train Large Face List".

        Training time depends on the number of face entries in a Large Face List. It could be in
        seconds, or up to half an hour for 1,000,000 faces.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :return: FaceCollectionTrainingResult. The FaceCollectionTrainingResult is compatible with
         MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceCollectionTrainingResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # A combined UTC date and time
                      string that describes the created time of the person group, large person group or
                      large face list. Required.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # A combined UTC date and time
                      string that describes the last modify time of the person group, large person
                      group or large face list, could be null value when the group is not successfully
                      trained. Required.
                    "lastSuccessfulTrainingDateTime": "2020-02-20 00:00:00",  # A combined UTC
                      date and time string that describes the last successful training time of the
                      person group, large person group or large face list. Required.
                    "status": "str",  # Training status of the container. Required. Known values
                      are: "notStarted", "running", "succeeded", and "failed".
                    "message": "str"  # Optional. Show failure message when training failed
                      (omitted when training succeed).
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.FaceCollectionTrainingResult] = kwargs.pop("cls", None)

        _request = build_face_administration_get_large_face_list_training_status_request(
            large_face_list_id=large_face_list_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.FaceCollectionTrainingResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _train_large_face_list_initial(  # pylint: disable=inconsistent-return-statements
        self, large_face_list_id: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_face_administration_train_large_face_list_request(
            large_face_list_id=large_face_list_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["operation-Location"] = self._deserialize("str", response.headers.get("operation-Location"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace_async
    async def begin_train_large_face_list(self, large_face_list_id: str, **kwargs: Any) -> AsyncLROPoller[None]:
        """Submit a Large Face List training task.

        Training is a crucial step that only a trained Large Face List can be used by "Find Similar
        From Large Face List".

        The training task is an asynchronous task. Training time depends on the number of face entries
        in a Large Face List. It could be in seconds, or up to half an hour for 1,000,000 faces. To
        check training completion, please use "Get Large Face List Training Status".

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._train_large_face_list_initial(  # type: ignore
                large_face_list_id=large_face_list_id, cls=lambda x, y, z: x, headers=_headers, params=_params, **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @overload
    async def add_large_face_list_face_from_url(
        self,
        large_face_list_id: str,
        body: JSON,
        *,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AddFaceResult:
        # pylint: disable=line-too-long
        """Add a face to a specified Large Face List, up to 1,000,000 faces.

        To deal with an image containing multiple faces, input face can be specified as an image with a
        targetFace rectangle. It returns a persistedFaceId representing the added face. No image will
        be stored. Only the extracted face feature(s) will be stored on server until "Delete Large Face
        List Face" or "Delete Large Face List" is called.

        Note that persistedFaceId is different from faceId generated by "Detect".
        >
        *


        * Higher face image quality means better recognition precision. Please consider high-quality
        faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes) or bigger.
        * Each person entry can hold up to 248 faces.
        * JPEG, PNG, GIF (the first frame), and BMP format are supported. The allowed image file size
        is from 1KB to 6MB.
        * "targetFace" rectangle should contain one face. Zero or multiple faces will be regarded as an
        error. If the provided "targetFace" rectangle is not returned from "Detect", there's no
        guarantee to detect and add the face successfully.
        * Out of detectable face size (36x36 - 4096x4096 pixels), large head-pose, or large occlusions
        will cause failures.
        * The minimum detectable face size is 36x36 pixels in an image no larger than 1920x1080 pixels.
        Images with dimensions higher than 1920x1080 pixels will need a proportionally larger minimum
        face size.
        * Different 'detectionModel' values can be provided. To use and compare different detection
        models, please refer to
        https://learn.microsoft.com/azure/ai-services/computer-vision/how-to/specify-detection-model

        ..

           [!NOTE]

           *


           * Free-tier subscription quota: 1,000 faces per Large Face List.
           * S0-tier subscription quota: 1,000,000 faces per Large Face List.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :param body: Required.
        :type body: JSON
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AddFaceResult. The AddFaceResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.AddFaceResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "url": "str"  # URL of input image. Required.
                }

                # response body for status code(s): 200
                response == {
                    "persistedFaceId": "str"  # Persisted Face ID of the added face, which is
                      persisted and will not expire. Different from faceId which is created in "Detect"
                      and will expire in 24 hours after the detection call. Required.
                }
        """

    @overload
    async def add_large_face_list_face_from_url(
        self,
        large_face_list_id: str,
        *,
        url: str,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AddFaceResult:
        # pylint: disable=line-too-long
        """Add a face to a specified Large Face List, up to 1,000,000 faces.

        To deal with an image containing multiple faces, input face can be specified as an image with a
        targetFace rectangle. It returns a persistedFaceId representing the added face. No image will
        be stored. Only the extracted face feature(s) will be stored on server until "Delete Large Face
        List Face" or "Delete Large Face List" is called.

        Note that persistedFaceId is different from faceId generated by "Detect".
        >
        *


        * Higher face image quality means better recognition precision. Please consider high-quality
        faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes) or bigger.
        * Each person entry can hold up to 248 faces.
        * JPEG, PNG, GIF (the first frame), and BMP format are supported. The allowed image file size
        is from 1KB to 6MB.
        * "targetFace" rectangle should contain one face. Zero or multiple faces will be regarded as an
        error. If the provided "targetFace" rectangle is not returned from "Detect", there's no
        guarantee to detect and add the face successfully.
        * Out of detectable face size (36x36 - 4096x4096 pixels), large head-pose, or large occlusions
        will cause failures.
        * The minimum detectable face size is 36x36 pixels in an image no larger than 1920x1080 pixels.
        Images with dimensions higher than 1920x1080 pixels will need a proportionally larger minimum
        face size.
        * Different 'detectionModel' values can be provided. To use and compare different detection
        models, please refer to
        https://learn.microsoft.com/azure/ai-services/computer-vision/how-to/specify-detection-model

        ..

           [!NOTE]

           *


           * Free-tier subscription quota: 1,000 faces per Large Face List.
           * S0-tier subscription quota: 1,000,000 faces per Large Face List.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :keyword url: URL of input image. Required.
        :paramtype url: str
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AddFaceResult. The AddFaceResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.AddFaceResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "persistedFaceId": "str"  # Persisted Face ID of the added face, which is
                      persisted and will not expire. Different from faceId which is created in "Detect"
                      and will expire in 24 hours after the detection call. Required.
                }
        """

    @overload
    async def add_large_face_list_face_from_url(
        self,
        large_face_list_id: str,
        body: IO[bytes],
        *,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AddFaceResult:
        # pylint: disable=line-too-long
        """Add a face to a specified Large Face List, up to 1,000,000 faces.

        To deal with an image containing multiple faces, input face can be specified as an image with a
        targetFace rectangle. It returns a persistedFaceId representing the added face. No image will
        be stored. Only the extracted face feature(s) will be stored on server until "Delete Large Face
        List Face" or "Delete Large Face List" is called.

        Note that persistedFaceId is different from faceId generated by "Detect".
        >
        *


        * Higher face image quality means better recognition precision. Please consider high-quality
        faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes) or bigger.
        * Each person entry can hold up to 248 faces.
        * JPEG, PNG, GIF (the first frame), and BMP format are supported. The allowed image file size
        is from 1KB to 6MB.
        * "targetFace" rectangle should contain one face. Zero or multiple faces will be regarded as an
        error. If the provided "targetFace" rectangle is not returned from "Detect", there's no
        guarantee to detect and add the face successfully.
        * Out of detectable face size (36x36 - 4096x4096 pixels), large head-pose, or large occlusions
        will cause failures.
        * The minimum detectable face size is 36x36 pixels in an image no larger than 1920x1080 pixels.
        Images with dimensions higher than 1920x1080 pixels will need a proportionally larger minimum
        face size.
        * Different 'detectionModel' values can be provided. To use and compare different detection
        models, please refer to
        https://learn.microsoft.com/azure/ai-services/computer-vision/how-to/specify-detection-model

        ..

           [!NOTE]

           *


           * Free-tier subscription quota: 1,000 faces per Large Face List.
           * S0-tier subscription quota: 1,000,000 faces per Large Face List.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AddFaceResult. The AddFaceResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.AddFaceResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "persistedFaceId": "str"  # Persisted Face ID of the added face, which is
                      persisted and will not expire. Different from faceId which is created in "Detect"
                      and will expire in 24 hours after the detection call. Required.
                }
        """

    @distributed_trace_async
    async def add_large_face_list_face_from_url(
        self,
        large_face_list_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        url: str = _Unset,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> _models.AddFaceResult:
        # pylint: disable=line-too-long
        """Add a face to a specified Large Face List, up to 1,000,000 faces.

        To deal with an image containing multiple faces, input face can be specified as an image with a
        targetFace rectangle. It returns a persistedFaceId representing the added face. No image will
        be stored. Only the extracted face feature(s) will be stored on server until "Delete Large Face
        List Face" or "Delete Large Face List" is called.

        Note that persistedFaceId is different from faceId generated by "Detect".
        >
        *


        * Higher face image quality means better recognition precision. Please consider high-quality
        faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes) or bigger.
        * Each person entry can hold up to 248 faces.
        * JPEG, PNG, GIF (the first frame), and BMP format are supported. The allowed image file size
        is from 1KB to 6MB.
        * "targetFace" rectangle should contain one face. Zero or multiple faces will be regarded as an
        error. If the provided "targetFace" rectangle is not returned from "Detect", there's no
        guarantee to detect and add the face successfully.
        * Out of detectable face size (36x36 - 4096x4096 pixels), large head-pose, or large occlusions
        will cause failures.
        * The minimum detectable face size is 36x36 pixels in an image no larger than 1920x1080 pixels.
        Images with dimensions higher than 1920x1080 pixels will need a proportionally larger minimum
        face size.
        * Different 'detectionModel' values can be provided. To use and compare different detection
        models, please refer to
        https://learn.microsoft.com/azure/ai-services/computer-vision/how-to/specify-detection-model

        ..

           [!NOTE]

           *


           * Free-tier subscription quota: 1,000 faces per Large Face List.
           * S0-tier subscription quota: 1,000,000 faces per Large Face List.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword url: URL of input image. Required.
        :paramtype url: str
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :return: AddFaceResult. The AddFaceResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.AddFaceResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "url": "str"  # URL of input image. Required.
                }

                # response body for status code(s): 200
                response == {
                    "persistedFaceId": "str"  # Persisted Face ID of the added face, which is
                      persisted and will not expire. Different from faceId which is created in "Detect"
                      and will expire in 24 hours after the detection call. Required.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AddFaceResult] = kwargs.pop("cls", None)

        if body is _Unset:
            if url is _Unset:
                raise TypeError("missing required argument: url")
            body = {"url": url}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_administration_add_large_face_list_face_from_url_request(
            large_face_list_id=large_face_list_id,
            target_face=target_face,
            detection_model=detection_model,
            user_data=user_data,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AddFaceResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def add_large_face_list_face(
        self,
        large_face_list_id: str,
        image_content: bytes,
        *,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> _models.AddFaceResult:
        # pylint: disable=line-too-long
        """Add a face to a specified Large Face List, up to 1,000,000 faces.

        To deal with an image containing multiple faces, input face can be specified as an image with a
        targetFace rectangle. It returns a persistedFaceId representing the added face. No image will
        be stored. Only the extracted face feature(s) will be stored on server until "Delete Large Face
        List Face" or "Delete Large Face List" is called.

        Note that persistedFaceId is different from faceId generated by "Detect".
        >
        *


        * Higher face image quality means better recognition precision. Please consider high-quality
        faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes) or bigger.
        * Each person entry can hold up to 248 faces.
        * JPEG, PNG, GIF (the first frame), and BMP format are supported. The allowed image file size
        is from 1KB to 6MB.
        * "targetFace" rectangle should contain one face. Zero or multiple faces will be regarded as an
        error. If the provided "targetFace" rectangle is not returned from "Detect", there's no
        guarantee to detect and add the face successfully.
        * Out of detectable face size (36x36 - 4096x4096 pixels), large head-pose, or large occlusions
        will cause failures.
        * The minimum detectable face size is 36x36 pixels in an image no larger than 1920x1080 pixels.
        Images with dimensions higher than 1920x1080 pixels will need a proportionally larger minimum
        face size.
        * Different 'detectionModel' values can be provided. To use and compare different detection
        models, please refer to
        https://learn.microsoft.com/azure/ai-services/computer-vision/how-to/specify-detection-model

        ..

           [!NOTE]

           *


           * Free-tier subscription quota: 1,000 faces per Large Face List.
           * S0-tier subscription quota: 1,000,000 faces per Large Face List.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :param image_content: The image to be analyzed. Required.
        :type image_content: bytes
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :return: AddFaceResult. The AddFaceResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.AddFaceResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "persistedFaceId": "str"  # Persisted Face ID of the added face, which is
                      persisted and will not expire. Different from faceId which is created in "Detect"
                      and will expire in 24 hours after the detection call. Required.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop("content_type", _headers.pop("content-type", "application/octet-stream"))
        cls: ClsType[_models.AddFaceResult] = kwargs.pop("cls", None)

        _content = image_content

        _request = build_face_administration_add_large_face_list_face_request(
            large_face_list_id=large_face_list_id,
            target_face=target_face,
            detection_model=detection_model,
            user_data=user_data,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AddFaceResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_large_face_list_face(  # pylint: disable=inconsistent-return-statements
        self, large_face_list_id: str, persisted_face_id: str, **kwargs: Any
    ) -> None:
        """Delete a face from a Large Face List by specified largeFaceListId and persistedFaceId.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_face_administration_delete_large_face_list_face_request(
            large_face_list_id=large_face_list_id,
            persisted_face_id=persisted_face_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_large_face_list_face(
        self, large_face_list_id: str, persisted_face_id: str, **kwargs: Any
    ) -> _models.LargeFaceListFace:
        """Retrieve persisted face in Large Face List by largeFaceListId and persistedFaceId.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :return: LargeFaceListFace. The LargeFaceListFace is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.LargeFaceListFace
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "persistedFaceId": "str",  # Face ID of the face. Required.
                    "userData": "str"  # Optional. User-provided data attached to the face. The
                      length limit is 1K.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.LargeFaceListFace] = kwargs.pop("cls", None)

        _request = build_face_administration_get_large_face_list_face_request(
            large_face_list_id=large_face_list_id,
            persisted_face_id=persisted_face_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.LargeFaceListFace, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_large_face_list_face(  # pylint: disable=inconsistent-return-statements
        self,
        large_face_list_id: str,
        persisted_face_id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Update a specified face's userData field in a Large Face List by its persistedFaceId.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "userData": "str"  # Optional. User-provided data attached to the face. The
                      length limit is 1K.
                }
        """

    @overload
    async def update_large_face_list_face(  # pylint: disable=inconsistent-return-statements
        self,
        large_face_list_id: str,
        persisted_face_id: str,
        *,
        content_type: str = "application/json",
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Update a specified face's userData field in a Large Face List by its persistedFaceId.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword user_data: User-provided data attached to the face. The length limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_large_face_list_face(  # pylint: disable=inconsistent-return-statements
        self,
        large_face_list_id: str,
        persisted_face_id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Update a specified face's userData field in a Large Face List by its persistedFaceId.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_large_face_list_face(  # pylint: disable=inconsistent-return-statements
        self,
        large_face_list_id: str,
        persisted_face_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Update a specified face's userData field in a Large Face List by its persistedFaceId.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword user_data: User-provided data attached to the face. The length limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "userData": "str"  # Optional. User-provided data attached to the face. The
                      length limit is 1K.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        if body is _Unset:
            body = {"userdata": user_data}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_administration_update_large_face_list_face_request(
            large_face_list_id=large_face_list_id,
            persisted_face_id=persisted_face_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_large_face_list_faces(
        self, large_face_list_id: str, *, start: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
    ) -> List[_models.LargeFaceListFace]:
        """List faces' persistedFaceId and userData in a specified Large Face List.

        Faces are stored in alphabetical order of persistedFaceId created in "Add Large Face List
        Face".
        >
        *


        * "start" parameter (string, optional) specifies an ID value from which returned entries will
        have larger IDs based on string comparison. Setting "start" to an empty value indicates that
        entries should be returned starting from the first item.
        * "top" parameter (int, optional) determines the maximum number of entries to be returned, with
        a limit of up to 1000 entries per call. To retrieve additional entries beyond this limit,
        specify "start" with the personId of the last entry returned in the current call.

        ..

           [!TIP]


           * For example, there are total 5 items with their IDs: "itemId1", ..., "itemId5".

             * "start=&top=" will return all 5 items.
             * "start=&top=2" will return "itemId1", "itemId2".
             * "start=itemId2&top=3" will return "itemId3", "itemId4", "itemId5".

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :keyword start: List resources greater than the "start". It contains no more than 64
         characters. Default is empty. Default value is None.
        :paramtype start: str
        :keyword top: The number of items to list, ranging in [1, 1000]. Default is 1000. Default value
         is None.
        :paramtype top: int
        :return: list of LargeFaceListFace
        :rtype: list[~azure.ai.vision.face.models.LargeFaceListFace]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "persistedFaceId": "str",  # Face ID of the face. Required.
                        "userData": "str"  # Optional. User-provided data attached to the
                          face. The length limit is 1K.
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.LargeFaceListFace]] = kwargs.pop("cls", None)

        _request = build_face_administration_get_large_face_list_faces_request(
            large_face_list_id=large_face_list_id,
            start=start,
            top=top,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.LargeFaceListFace], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_person_group(  # pylint: disable=inconsistent-return-statements
        self, person_group_id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Create a new Person Group with specified personGroupId, name, user-provided userData and
        recognitionModel.

        A Person Group is a container holding the uploaded person data, including face recognition
        features.

        After creation, use "Create Person Group Person" to add persons into the group, and then call
        "Train Person Group" to get this group ready for "Identify From Person Group".

        No image will be stored. Only the person's extracted face feature(s) and userData will be
        stored on server until "Delete Person Group Person" or "Delete Person Group" is called.

        'recognitionModel' should be specified to associate with this Person Group. The default value
        for 'recognitionModel' is 'recognition_01', if the latest model needed, please explicitly
        specify the model you need in this parameter. New faces that are added to an existing Person
        Group will use the recognition model that's already associated with the collection. Existing
        face feature(s) in a Person Group can't be updated to features extracted by another version of
        recognition model.

        ..

           [!NOTE]

           *


           * Free-tier subscription quota: 1,000 Person Groups. Each holds up to 1,000 persons.
           * S0-tier subscription quota: 1,000,000 Person Groups. Each holds up to 10,000 persons.
           * to handle larger scale face identification problem, please consider using Large Person
        Group.

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # User defined name, maximum length is 128. Required.
                    "recognitionModel": "str",  # Optional. The 'recognitionModel' associated
                      with this face list. Supported 'recognitionModel' values include
                      'recognition_01', 'recognition_02, 'recognition_03', and 'recognition_04'. The
                      default value is 'recognition_01'. 'recognition_04' is recommended since its
                      accuracy is improved on faces wearing masks compared with 'recognition_03', and
                      its overall accuracy is improved compared with 'recognition_01' and
                      'recognition_02'. Known values are: "recognition_01", "recognition_02",
                      "recognition_03", and "recognition_04".
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """

    @overload
    async def create_person_group(  # pylint: disable=inconsistent-return-statements
        self,
        person_group_id: str,
        *,
        name: str,
        content_type: str = "application/json",
        user_data: Optional[str] = None,
        recognition_model: Optional[Union[str, _models.FaceRecognitionModel]] = None,
        **kwargs: Any
    ) -> None:
        """Create a new Person Group with specified personGroupId, name, user-provided userData and
        recognitionModel.

        A Person Group is a container holding the uploaded person data, including face recognition
        features.

        After creation, use "Create Person Group Person" to add persons into the group, and then call
        "Train Person Group" to get this group ready for "Identify From Person Group".

        No image will be stored. Only the person's extracted face feature(s) and userData will be
        stored on server until "Delete Person Group Person" or "Delete Person Group" is called.

        'recognitionModel' should be specified to associate with this Person Group. The default value
        for 'recognitionModel' is 'recognition_01', if the latest model needed, please explicitly
        specify the model you need in this parameter. New faces that are added to an existing Person
        Group will use the recognition model that's already associated with the collection. Existing
        face feature(s) in a Person Group can't be updated to features extracted by another version of
        recognition model.

        ..

           [!NOTE]

           *


           * Free-tier subscription quota: 1,000 Person Groups. Each holds up to 1,000 persons.
           * S0-tier subscription quota: 1,000,000 Person Groups. Each holds up to 10,000 persons.
           * to handle larger scale face identification problem, please consider using Large Person
        Group.

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :keyword name: User defined name, maximum length is 128. Required.
        :paramtype name: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :keyword recognition_model: The 'recognitionModel' associated with this face list. Supported
         'recognitionModel' values include 'recognition_01', 'recognition_02, 'recognition_03', and
         'recognition_04'. The default value is 'recognition_01'. 'recognition_04' is recommended since
         its accuracy is improved on faces wearing masks compared with 'recognition_03', and its overall
         accuracy is improved compared with 'recognition_01' and 'recognition_02'. Known values are:
         "recognition_01", "recognition_02", "recognition_03", and "recognition_04". Default value is
         None.
        :paramtype recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_person_group(  # pylint: disable=inconsistent-return-statements
        self, person_group_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Create a new Person Group with specified personGroupId, name, user-provided userData and
        recognitionModel.

        A Person Group is a container holding the uploaded person data, including face recognition
        features.

        After creation, use "Create Person Group Person" to add persons into the group, and then call
        "Train Person Group" to get this group ready for "Identify From Person Group".

        No image will be stored. Only the person's extracted face feature(s) and userData will be
        stored on server until "Delete Person Group Person" or "Delete Person Group" is called.

        'recognitionModel' should be specified to associate with this Person Group. The default value
        for 'recognitionModel' is 'recognition_01', if the latest model needed, please explicitly
        specify the model you need in this parameter. New faces that are added to an existing Person
        Group will use the recognition model that's already associated with the collection. Existing
        face feature(s) in a Person Group can't be updated to features extracted by another version of
        recognition model.

        ..

           [!NOTE]

           *


           * Free-tier subscription quota: 1,000 Person Groups. Each holds up to 1,000 persons.
           * S0-tier subscription quota: 1,000,000 Person Groups. Each holds up to 10,000 persons.
           * to handle larger scale face identification problem, please consider using Large Person
        Group.

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_person_group(  # pylint: disable=inconsistent-return-statements
        self,
        person_group_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        name: str = _Unset,
        user_data: Optional[str] = None,
        recognition_model: Optional[Union[str, _models.FaceRecognitionModel]] = None,
        **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Create a new Person Group with specified personGroupId, name, user-provided userData and
        recognitionModel.

        A Person Group is a container holding the uploaded person data, including face recognition
        features.

        After creation, use "Create Person Group Person" to add persons into the group, and then call
        "Train Person Group" to get this group ready for "Identify From Person Group".

        No image will be stored. Only the person's extracted face feature(s) and userData will be
        stored on server until "Delete Person Group Person" or "Delete Person Group" is called.

        'recognitionModel' should be specified to associate with this Person Group. The default value
        for 'recognitionModel' is 'recognition_01', if the latest model needed, please explicitly
        specify the model you need in this parameter. New faces that are added to an existing Person
        Group will use the recognition model that's already associated with the collection. Existing
        face feature(s) in a Person Group can't be updated to features extracted by another version of
        recognition model.

        ..

           [!NOTE]

           *


           * Free-tier subscription quota: 1,000 Person Groups. Each holds up to 1,000 persons.
           * S0-tier subscription quota: 1,000,000 Person Groups. Each holds up to 10,000 persons.
           * to handle larger scale face identification problem, please consider using Large Person
        Group.

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword name: User defined name, maximum length is 128. Required.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :keyword recognition_model: The 'recognitionModel' associated with this face list. Supported
         'recognitionModel' values include 'recognition_01', 'recognition_02, 'recognition_03', and
         'recognition_04'. The default value is 'recognition_01'. 'recognition_04' is recommended since
         its accuracy is improved on faces wearing masks compared with 'recognition_03', and its overall
         accuracy is improved compared with 'recognition_01' and 'recognition_02'. Known values are:
         "recognition_01", "recognition_02", "recognition_03", and "recognition_04". Default value is
         None.
        :paramtype recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # User defined name, maximum length is 128. Required.
                    "recognitionModel": "str",  # Optional. The 'recognitionModel' associated
                      with this face list. Supported 'recognitionModel' values include
                      'recognition_01', 'recognition_02, 'recognition_03', and 'recognition_04'. The
                      default value is 'recognition_01'. 'recognition_04' is recommended since its
                      accuracy is improved on faces wearing masks compared with 'recognition_03', and
                      its overall accuracy is improved compared with 'recognition_01' and
                      'recognition_02'. Known values are: "recognition_01", "recognition_02",
                      "recognition_03", and "recognition_04".
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        if body is _Unset:
            if name is _Unset:
                raise TypeError("missing required argument: name")
            body = {"name": name, "recognitionmodel": recognition_model, "userdata": user_data}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_administration_create_person_group_request(
            person_group_id=person_group_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def delete_person_group(  # pylint: disable=inconsistent-return-statements
        self, person_group_id: str, **kwargs: Any
    ) -> None:
        """Delete an existing Person Group with specified personGroupId. Persisted data in this Person
        Group will be deleted.

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_face_administration_delete_person_group_request(
            person_group_id=person_group_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_person_group(
        self, person_group_id: str, *, return_recognition_model: Optional[bool] = None, **kwargs: Any
    ) -> _models.PersonGroup:
        # pylint: disable=line-too-long
        """Retrieve Person Group name, userData and recognitionModel. To get person information under this
        personGroup, use "Get Person Group Persons".

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :keyword return_recognition_model: Return 'recognitionModel' or not. The default value is
         false. Default value is None.
        :paramtype return_recognition_model: bool
        :return: PersonGroup. The PersonGroup is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.PersonGroup
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "name": "str",  # User defined name, maximum length is 128. Required.
                    "personGroupId": "str",  # ID of the container. Required.
                    "recognitionModel": "str",  # Optional. Name of recognition model.
                      Recognition model is used when the face features are extracted and associated
                      with detected faceIds. Known values are: "recognition_01", "recognition_02",
                      "recognition_03", and "recognition_04".
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.PersonGroup] = kwargs.pop("cls", None)

        _request = build_face_administration_get_person_group_request(
            person_group_id=person_group_id,
            return_recognition_model=return_recognition_model,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.PersonGroup, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_person_group(  # pylint: disable=inconsistent-return-statements
        self, person_group_id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Update an existing Person Group's name and userData. The properties keep unchanged if they are
        not in request body.

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # Optional. User defined name, maximum length is 128.
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """

    @overload
    async def update_person_group(  # pylint: disable=inconsistent-return-statements
        self,
        person_group_id: str,
        *,
        content_type: str = "application/json",
        name: Optional[str] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Update an existing Person Group's name and userData. The properties keep unchanged if they are
        not in request body.

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword name: User defined name, maximum length is 128. Default value is None.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_person_group(  # pylint: disable=inconsistent-return-statements
        self, person_group_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Update an existing Person Group's name and userData. The properties keep unchanged if they are
        not in request body.

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_person_group(  # pylint: disable=inconsistent-return-statements
        self,
        person_group_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        name: Optional[str] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Update an existing Person Group's name and userData. The properties keep unchanged if they are
        not in request body.

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword name: User defined name, maximum length is 128. Default value is None.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # Optional. User defined name, maximum length is 128.
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        if body is _Unset:
            body = {"name": name, "userdata": user_data}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_administration_update_person_group_request(
            person_group_id=person_group_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_person_groups(
        self,
        *,
        start: Optional[str] = None,
        top: Optional[int] = None,
        return_recognition_model: Optional[bool] = None,
        **kwargs: Any
    ) -> List[_models.PersonGroup]:
        # pylint: disable=line-too-long
        """List Person Groups' personGroupId, name, userData and recognitionModel.

        Person Groups are stored in alphabetical order of personGroupId.
        >
        *


        * "start" parameter (string, optional) specifies an ID value from which returned entries will
        have larger IDs based on string comparison. Setting "start" to an empty value indicates that
        entries should be returned starting from the first item.
        * "top" parameter (int, optional) determines the maximum number of entries to be returned, with
        a limit of up to 1000 entries per call. To retrieve additional entries beyond this limit,
        specify "start" with the personId of the last entry returned in the current call.

        ..

           [!TIP]


           * For example, there are total 5 items with their IDs: "itemId1", ..., "itemId5".

             * "start=&top=" will return all 5 items.
             * "start=&top=2" will return "itemId1", "itemId2".
             * "start=itemId2&top=3" will return "itemId3", "itemId4", "itemId5".

        :keyword start: List resources greater than the "start". It contains no more than 64
         characters. Default is empty. Default value is None.
        :paramtype start: str
        :keyword top: The number of items to list, ranging in [1, 1000]. Default is 1000. Default value
         is None.
        :paramtype top: int
        :keyword return_recognition_model: Return 'recognitionModel' or not. The default value is
         false. Default value is None.
        :paramtype return_recognition_model: bool
        :return: list of PersonGroup
        :rtype: list[~azure.ai.vision.face.models.PersonGroup]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "name": "str",  # User defined name, maximum length is 128. Required.
                        "personGroupId": "str",  # ID of the container. Required.
                        "recognitionModel": "str",  # Optional. Name of recognition model.
                          Recognition model is used when the face features are extracted and associated
                          with detected faceIds. Known values are: "recognition_01", "recognition_02",
                          "recognition_03", and "recognition_04".
                        "userData": "str"  # Optional. Optional user defined data. Length
                          should not exceed 16K.
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.PersonGroup]] = kwargs.pop("cls", None)

        _request = build_face_administration_get_person_groups_request(
            start=start,
            top=top,
            return_recognition_model=return_recognition_model,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.PersonGroup], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_person_group_training_status(
        self, person_group_id: str, **kwargs: Any
    ) -> _models.FaceCollectionTrainingResult:
        # pylint: disable=line-too-long
        """To check Person Group training status completed or still ongoing. Person Group training is an
        asynchronous operation triggered by "Train Person Group" API.

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :return: FaceCollectionTrainingResult. The FaceCollectionTrainingResult is compatible with
         MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceCollectionTrainingResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # A combined UTC date and time
                      string that describes the created time of the person group, large person group or
                      large face list. Required.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # A combined UTC date and time
                      string that describes the last modify time of the person group, large person
                      group or large face list, could be null value when the group is not successfully
                      trained. Required.
                    "lastSuccessfulTrainingDateTime": "2020-02-20 00:00:00",  # A combined UTC
                      date and time string that describes the last successful training time of the
                      person group, large person group or large face list. Required.
                    "status": "str",  # Training status of the container. Required. Known values
                      are: "notStarted", "running", "succeeded", and "failed".
                    "message": "str"  # Optional. Show failure message when training failed
                      (omitted when training succeed).
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.FaceCollectionTrainingResult] = kwargs.pop("cls", None)

        _request = build_face_administration_get_person_group_training_status_request(
            person_group_id=person_group_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.FaceCollectionTrainingResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _train_person_group_initial(  # pylint: disable=inconsistent-return-statements
        self, person_group_id: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_face_administration_train_person_group_request(
            person_group_id=person_group_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["operation-Location"] = self._deserialize("str", response.headers.get("operation-Location"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace_async
    async def begin_train_person_group(self, person_group_id: str, **kwargs: Any) -> AsyncLROPoller[None]:
        """Submit a Person Group training task. Training is a crucial step that only a trained Person
        Group can be used by "Identify From Person Group".

        The training task is an asynchronous task. Training time depends on the number of person
        entries, and their faces in a Person Group. It could be several seconds to minutes. To check
        training status, please use "Get Person Group Training Status".

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._train_person_group_initial(  # type: ignore
                person_group_id=person_group_id, cls=lambda x, y, z: x, headers=_headers, params=_params, **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @overload
    async def create_person_group_person(
        self, person_group_id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CreatePersonResult:
        """Create a new person in a specified Person Group. To add face to this person, please call "Add
        Person Group Person Face".

        ..

           [!NOTE]

           *


           * Free-tier subscription quota:

             * 1,000 persons in all Person Groups.

           * S0-tier subscription quota:

             * 10,000 persons per Person Group.
             * 1,000,000 Person Groups.
             * 100,000,000 persons in all Person Groups.

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CreatePersonResult. The CreatePersonResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.CreatePersonResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # User defined name, maximum length is 128. Required.
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }

                # response body for status code(s): 200
                response == {
                    "personId": "str"  # Person ID of the person. Required.
                }
        """

    @overload
    async def create_person_group_person(
        self,
        person_group_id: str,
        *,
        name: str,
        content_type: str = "application/json",
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> _models.CreatePersonResult:
        """Create a new person in a specified Person Group. To add face to this person, please call "Add
        Person Group Person Face".

        ..

           [!NOTE]

           *


           * Free-tier subscription quota:

             * 1,000 persons in all Person Groups.

           * S0-tier subscription quota:

             * 10,000 persons per Person Group.
             * 1,000,000 Person Groups.
             * 100,000,000 persons in all Person Groups.

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :keyword name: User defined name, maximum length is 128. Required.
        :paramtype name: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: CreatePersonResult. The CreatePersonResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.CreatePersonResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "personId": "str"  # Person ID of the person. Required.
                }
        """

    @overload
    async def create_person_group_person(
        self, person_group_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CreatePersonResult:
        """Create a new person in a specified Person Group. To add face to this person, please call "Add
        Person Group Person Face".

        ..

           [!NOTE]

           *


           * Free-tier subscription quota:

             * 1,000 persons in all Person Groups.

           * S0-tier subscription quota:

             * 10,000 persons per Person Group.
             * 1,000,000 Person Groups.
             * 100,000,000 persons in all Person Groups.

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CreatePersonResult. The CreatePersonResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.CreatePersonResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "personId": "str"  # Person ID of the person. Required.
                }
        """

    @distributed_trace_async
    async def create_person_group_person(
        self,
        person_group_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        name: str = _Unset,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> _models.CreatePersonResult:
        """Create a new person in a specified Person Group. To add face to this person, please call "Add
        Person Group Person Face".

        ..

           [!NOTE]

           *


           * Free-tier subscription quota:

             * 1,000 persons in all Person Groups.

           * S0-tier subscription quota:

             * 10,000 persons per Person Group.
             * 1,000,000 Person Groups.
             * 100,000,000 persons in all Person Groups.

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword name: User defined name, maximum length is 128. Required.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: CreatePersonResult. The CreatePersonResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.CreatePersonResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # User defined name, maximum length is 128. Required.
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }

                # response body for status code(s): 200
                response == {
                    "personId": "str"  # Person ID of the person. Required.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CreatePersonResult] = kwargs.pop("cls", None)

        if body is _Unset:
            if name is _Unset:
                raise TypeError("missing required argument: name")
            body = {"name": name, "userdata": user_data}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_administration_create_person_group_person_request(
            person_group_id=person_group_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CreatePersonResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_person_group_person(  # pylint: disable=inconsistent-return-statements
        self, person_group_id: str, person_id: str, **kwargs: Any
    ) -> None:
        """Delete an existing person from a Person Group. The persistedFaceId, userData, person name and
        face feature(s) in the person entry will all be deleted.

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_face_administration_delete_person_group_person_request(
            person_group_id=person_group_id,
            person_id=person_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_person_group_person(
        self, person_group_id: str, person_id: str, **kwargs: Any
    ) -> _models.PersonGroupPerson:
        """Retrieve a person's name and userData, and the persisted faceIds representing the registered
        person face feature(s).

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :return: PersonGroupPerson. The PersonGroupPerson is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.PersonGroupPerson
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "name": "str",  # User defined name, maximum length is 128. Required.
                    "personId": "str",  # ID of the person. Required.
                    "persistedFaceIds": [
                        "str"  # Optional. Face ids of registered faces in the person.
                    ],
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.PersonGroupPerson] = kwargs.pop("cls", None)

        _request = build_face_administration_get_person_group_person_request(
            person_group_id=person_group_id,
            person_id=person_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.PersonGroupPerson, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_person_group_person(  # pylint: disable=inconsistent-return-statements
        self, person_group_id: str, person_id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Update name or userData of a person.

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # Optional. User defined name, maximum length is 128.
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """

    @overload
    async def update_person_group_person(  # pylint: disable=inconsistent-return-statements
        self,
        person_group_id: str,
        person_id: str,
        *,
        content_type: str = "application/json",
        name: Optional[str] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Update name or userData of a person.

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword name: User defined name, maximum length is 128. Default value is None.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_person_group_person(  # pylint: disable=inconsistent-return-statements
        self,
        person_group_id: str,
        person_id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Update name or userData of a person.

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_person_group_person(  # pylint: disable=inconsistent-return-statements
        self,
        person_group_id: str,
        person_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        name: Optional[str] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Update name or userData of a person.

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword name: User defined name, maximum length is 128. Default value is None.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # Optional. User defined name, maximum length is 128.
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        if body is _Unset:
            body = {"name": name, "userdata": user_data}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_administration_update_person_group_person_request(
            person_group_id=person_group_id,
            person_id=person_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_person_group_persons(
        self, person_group_id: str, *, start: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
    ) -> List[_models.PersonGroupPerson]:
        """List all persons' information in the specified Person Group, including personId, name, userData
        and persistedFaceIds of registered person faces.

        Persons are stored in alphabetical order of personId created in "Create Person Group Person".
        >
        *


        * "start" parameter (string, optional) specifies an ID value from which returned entries will
        have larger IDs based on string comparison. Setting "start" to an empty value indicates that
        entries should be returned starting from the first item.
        * "top" parameter (int, optional) determines the maximum number of entries to be returned, with
        a limit of up to 1000 entries per call. To retrieve additional entries beyond this limit,
        specify "start" with the personId of the last entry returned in the current call.

        ..

           [!TIP]


           * For example, there are total 5 items with their IDs: "itemId1", ..., "itemId5".

             * "start=&top=" will return all 5 items.
             * "start=&top=2" will return "itemId1", "itemId2".
             * "start=itemId2&top=3" will return "itemId3", "itemId4", "itemId5".

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :keyword start: List resources greater than the "start". It contains no more than 64
         characters. Default is empty. Default value is None.
        :paramtype start: str
        :keyword top: The number of items to list, ranging in [1, 1000]. Default is 1000. Default value
         is None.
        :paramtype top: int
        :return: list of PersonGroupPerson
        :rtype: list[~azure.ai.vision.face.models.PersonGroupPerson]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "name": "str",  # User defined name, maximum length is 128. Required.
                        "personId": "str",  # ID of the person. Required.
                        "persistedFaceIds": [
                            "str"  # Optional. Face ids of registered faces in the
                              person.
                        ],
                        "userData": "str"  # Optional. Optional user defined data. Length
                          should not exceed 16K.
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.PersonGroupPerson]] = kwargs.pop("cls", None)

        _request = build_face_administration_get_person_group_persons_request(
            person_group_id=person_group_id,
            start=start,
            top=top,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.PersonGroupPerson], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def add_person_group_person_face_from_url(
        self,
        person_group_id: str,
        person_id: str,
        body: JSON,
        *,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AddFaceResult:
        # pylint: disable=line-too-long
        """Add a face to a person into a Person Group for face identification or verification.

        To deal with an image containing multiple faces, input face can be specified as an image with a
        targetFace rectangle. It returns a persistedFaceId representing the added face. No image will
        be stored. Only the extracted face feature(s) will be stored on server until "Delete Person
        Group Person Face", "Delete Person Group Person" or "Delete Person Group" is called.

        Note that persistedFaceId is different from faceId generated by "Detect".
        >
        *


        * Higher face image quality means better recognition precision. Please consider high-quality
        faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes) or bigger.
        * Each person entry can hold up to 248 faces.
        * JPEG, PNG, GIF (the first frame), and BMP format are supported. The allowed image file size
        is from 1KB to 6MB.
        * "targetFace" rectangle should contain one face. Zero or multiple faces will be regarded as an
        error. If the provided "targetFace" rectangle is not returned from "Detect", there's no
        guarantee to detect and add the face successfully.
        * Out of detectable face size (36x36 - 4096x4096 pixels), large head-pose, or large occlusions
        will cause failures.
        * The minimum detectable face size is 36x36 pixels in an image no larger than 1920x1080 pixels.
        Images with dimensions higher than 1920x1080 pixels will need a proportionally larger minimum
        face size.
        * Different 'detectionModel' values can be provided. To use and compare different detection
        models, please refer to
        https://learn.microsoft.com/azure/ai-services/computer-vision/how-to/specify-detection-model.

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param body: Required.
        :type body: JSON
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AddFaceResult. The AddFaceResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.AddFaceResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "url": "str"  # URL of input image. Required.
                }

                # response body for status code(s): 200
                response == {
                    "persistedFaceId": "str"  # Persisted Face ID of the added face, which is
                      persisted and will not expire. Different from faceId which is created in "Detect"
                      and will expire in 24 hours after the detection call. Required.
                }
        """

    @overload
    async def add_person_group_person_face_from_url(
        self,
        person_group_id: str,
        person_id: str,
        *,
        url: str,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AddFaceResult:
        # pylint: disable=line-too-long
        """Add a face to a person into a Person Group for face identification or verification.

        To deal with an image containing multiple faces, input face can be specified as an image with a
        targetFace rectangle. It returns a persistedFaceId representing the added face. No image will
        be stored. Only the extracted face feature(s) will be stored on server until "Delete Person
        Group Person Face", "Delete Person Group Person" or "Delete Person Group" is called.

        Note that persistedFaceId is different from faceId generated by "Detect".
        >
        *


        * Higher face image quality means better recognition precision. Please consider high-quality
        faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes) or bigger.
        * Each person entry can hold up to 248 faces.
        * JPEG, PNG, GIF (the first frame), and BMP format are supported. The allowed image file size
        is from 1KB to 6MB.
        * "targetFace" rectangle should contain one face. Zero or multiple faces will be regarded as an
        error. If the provided "targetFace" rectangle is not returned from "Detect", there's no
        guarantee to detect and add the face successfully.
        * Out of detectable face size (36x36 - 4096x4096 pixels), large head-pose, or large occlusions
        will cause failures.
        * The minimum detectable face size is 36x36 pixels in an image no larger than 1920x1080 pixels.
        Images with dimensions higher than 1920x1080 pixels will need a proportionally larger minimum
        face size.
        * Different 'detectionModel' values can be provided. To use and compare different detection
        models, please refer to
        https://learn.microsoft.com/azure/ai-services/computer-vision/how-to/specify-detection-model.

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :keyword url: URL of input image. Required.
        :paramtype url: str
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AddFaceResult. The AddFaceResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.AddFaceResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "persistedFaceId": "str"  # Persisted Face ID of the added face, which is
                      persisted and will not expire. Different from faceId which is created in "Detect"
                      and will expire in 24 hours after the detection call. Required.
                }
        """

    @overload
    async def add_person_group_person_face_from_url(
        self,
        person_group_id: str,
        person_id: str,
        body: IO[bytes],
        *,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AddFaceResult:
        # pylint: disable=line-too-long
        """Add a face to a person into a Person Group for face identification or verification.

        To deal with an image containing multiple faces, input face can be specified as an image with a
        targetFace rectangle. It returns a persistedFaceId representing the added face. No image will
        be stored. Only the extracted face feature(s) will be stored on server until "Delete Person
        Group Person Face", "Delete Person Group Person" or "Delete Person Group" is called.

        Note that persistedFaceId is different from faceId generated by "Detect".
        >
        *


        * Higher face image quality means better recognition precision. Please consider high-quality
        faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes) or bigger.
        * Each person entry can hold up to 248 faces.
        * JPEG, PNG, GIF (the first frame), and BMP format are supported. The allowed image file size
        is from 1KB to 6MB.
        * "targetFace" rectangle should contain one face. Zero or multiple faces will be regarded as an
        error. If the provided "targetFace" rectangle is not returned from "Detect", there's no
        guarantee to detect and add the face successfully.
        * Out of detectable face size (36x36 - 4096x4096 pixels), large head-pose, or large occlusions
        will cause failures.
        * The minimum detectable face size is 36x36 pixels in an image no larger than 1920x1080 pixels.
        Images with dimensions higher than 1920x1080 pixels will need a proportionally larger minimum
        face size.
        * Different 'detectionModel' values can be provided. To use and compare different detection
        models, please refer to
        https://learn.microsoft.com/azure/ai-services/computer-vision/how-to/specify-detection-model.

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AddFaceResult. The AddFaceResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.AddFaceResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "persistedFaceId": "str"  # Persisted Face ID of the added face, which is
                      persisted and will not expire. Different from faceId which is created in "Detect"
                      and will expire in 24 hours after the detection call. Required.
                }
        """

    @distributed_trace_async
    async def add_person_group_person_face_from_url(
        self,
        person_group_id: str,
        person_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        url: str = _Unset,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> _models.AddFaceResult:
        # pylint: disable=line-too-long
        """Add a face to a person into a Person Group for face identification or verification.

        To deal with an image containing multiple faces, input face can be specified as an image with a
        targetFace rectangle. It returns a persistedFaceId representing the added face. No image will
        be stored. Only the extracted face feature(s) will be stored on server until "Delete Person
        Group Person Face", "Delete Person Group Person" or "Delete Person Group" is called.

        Note that persistedFaceId is different from faceId generated by "Detect".
        >
        *


        * Higher face image quality means better recognition precision. Please consider high-quality
        faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes) or bigger.
        * Each person entry can hold up to 248 faces.
        * JPEG, PNG, GIF (the first frame), and BMP format are supported. The allowed image file size
        is from 1KB to 6MB.
        * "targetFace" rectangle should contain one face. Zero or multiple faces will be regarded as an
        error. If the provided "targetFace" rectangle is not returned from "Detect", there's no
        guarantee to detect and add the face successfully.
        * Out of detectable face size (36x36 - 4096x4096 pixels), large head-pose, or large occlusions
        will cause failures.
        * The minimum detectable face size is 36x36 pixels in an image no larger than 1920x1080 pixels.
        Images with dimensions higher than 1920x1080 pixels will need a proportionally larger minimum
        face size.
        * Different 'detectionModel' values can be provided. To use and compare different detection
        models, please refer to
        https://learn.microsoft.com/azure/ai-services/computer-vision/how-to/specify-detection-model.

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword url: URL of input image. Required.
        :paramtype url: str
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :return: AddFaceResult. The AddFaceResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.AddFaceResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "url": "str"  # URL of input image. Required.
                }

                # response body for status code(s): 200
                response == {
                    "persistedFaceId": "str"  # Persisted Face ID of the added face, which is
                      persisted and will not expire. Different from faceId which is created in "Detect"
                      and will expire in 24 hours after the detection call. Required.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AddFaceResult] = kwargs.pop("cls", None)

        if body is _Unset:
            if url is _Unset:
                raise TypeError("missing required argument: url")
            body = {"url": url}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_administration_add_person_group_person_face_from_url_request(
            person_group_id=person_group_id,
            person_id=person_id,
            target_face=target_face,
            detection_model=detection_model,
            user_data=user_data,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AddFaceResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def add_person_group_person_face(
        self,
        person_group_id: str,
        person_id: str,
        image_content: bytes,
        *,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> _models.AddFaceResult:
        # pylint: disable=line-too-long
        """Add a face to a person into a Person Group for face identification or verification.

        To deal with an image containing multiple faces, input face can be specified as an image with a
        targetFace rectangle. It returns a persistedFaceId representing the added face. No image will
        be stored. Only the extracted face feature(s) will be stored on server until "Delete Person
        Group Person Face", "Delete Person Group Person" or "Delete Person Group" is called.

        Note that persistedFaceId is different from faceId generated by "Detect".
        >
        *


        * Higher face image quality means better recognition precision. Please consider high-quality
        faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes) or bigger.
        * Each person entry can hold up to 248 faces.
        * JPEG, PNG, GIF (the first frame), and BMP format are supported. The allowed image file size
        is from 1KB to 6MB.
        * "targetFace" rectangle should contain one face. Zero or multiple faces will be regarded as an
        error. If the provided "targetFace" rectangle is not returned from "Detect", there's no
        guarantee to detect and add the face successfully.
        * Out of detectable face size (36x36 - 4096x4096 pixels), large head-pose, or large occlusions
        will cause failures.
        * The minimum detectable face size is 36x36 pixels in an image no larger than 1920x1080 pixels.
        Images with dimensions higher than 1920x1080 pixels will need a proportionally larger minimum
        face size.
        * Different 'detectionModel' values can be provided. To use and compare different detection
        models, please refer to
        https://learn.microsoft.com/azure/ai-services/computer-vision/how-to/specify-detection-model.

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param image_content: The image to be analyzed. Required.
        :type image_content: bytes
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :return: AddFaceResult. The AddFaceResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.AddFaceResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "persistedFaceId": "str"  # Persisted Face ID of the added face, which is
                      persisted and will not expire. Different from faceId which is created in "Detect"
                      and will expire in 24 hours after the detection call. Required.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop("content_type", _headers.pop("content-type", "application/octet-stream"))
        cls: ClsType[_models.AddFaceResult] = kwargs.pop("cls", None)

        _content = image_content

        _request = build_face_administration_add_person_group_person_face_request(
            person_group_id=person_group_id,
            person_id=person_id,
            target_face=target_face,
            detection_model=detection_model,
            user_data=user_data,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AddFaceResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_person_group_person_face(  # pylint: disable=inconsistent-return-statements
        self, person_group_id: str, person_id: str, persisted_face_id: str, **kwargs: Any
    ) -> None:
        """Delete a face from a person in a Person Group by specified personGroupId, personId and
        persistedFaceId.

        Adding/deleting faces to/from a same person will be processed sequentially. Adding/deleting
        faces to/from different persons are processed in parallel.

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_face_administration_delete_person_group_person_face_request(
            person_group_id=person_group_id,
            person_id=person_id,
            persisted_face_id=persisted_face_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_person_group_person_face(
        self, person_group_id: str, person_id: str, persisted_face_id: str, **kwargs: Any
    ) -> _models.PersonGroupPersonFace:
        """Retrieve person face information. The persisted person face is specified by its personGroupId,
        personId and persistedFaceId.

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :return: PersonGroupPersonFace. The PersonGroupPersonFace is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.PersonGroupPersonFace
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "persistedFaceId": "str",  # Face ID of the face. Required.
                    "userData": "str"  # Optional. User-provided data attached to the face. The
                      length limit is 1K.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.PersonGroupPersonFace] = kwargs.pop("cls", None)

        _request = build_face_administration_get_person_group_person_face_request(
            person_group_id=person_group_id,
            person_id=person_id,
            persisted_face_id=persisted_face_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.PersonGroupPersonFace, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_person_group_person_face(  # pylint: disable=inconsistent-return-statements
        self,
        person_group_id: str,
        person_id: str,
        persisted_face_id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Update a person persisted face's userData field.

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "userData": "str"  # Optional. User-provided data attached to the face. The
                      length limit is 1K.
                }
        """

    @overload
    async def update_person_group_person_face(  # pylint: disable=inconsistent-return-statements
        self,
        person_group_id: str,
        person_id: str,
        persisted_face_id: str,
        *,
        content_type: str = "application/json",
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Update a person persisted face's userData field.

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword user_data: User-provided data attached to the face. The length limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_person_group_person_face(  # pylint: disable=inconsistent-return-statements
        self,
        person_group_id: str,
        person_id: str,
        persisted_face_id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Update a person persisted face's userData field.

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_person_group_person_face(  # pylint: disable=inconsistent-return-statements
        self,
        person_group_id: str,
        person_id: str,
        persisted_face_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Update a person persisted face's userData field.

        :param person_group_id: ID of the container. Required.
        :type person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword user_data: User-provided data attached to the face. The length limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "userData": "str"  # Optional. User-provided data attached to the face. The
                      length limit is 1K.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        if body is _Unset:
            body = {"userdata": user_data}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_administration_update_person_group_person_face_request(
            person_group_id=person_group_id,
            person_id=person_id,
            persisted_face_id=persisted_face_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def create_large_person_group(  # pylint: disable=inconsistent-return-statements
        self, large_person_group_id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Create a new Large Person Group with user-specified largePersonGroupId, name, an optional
        userData and recognitionModel.

        A Large Person Group is a container holding the uploaded person data, including the face
        recognition features. It can hold up to 1,000,000 entities.

        After creation, use "Create Large Person Group Person" to add person into the group, and call
        "Train Large Person Group" to get this group ready for "Identify From Large Person Group".

        No image will be stored. Only the person's extracted face feature(s) and userData will be
        stored on server until "Delete Large Person Group Person" or "Delete Large Person Group" is
        called.

        'recognitionModel' should be specified to associate with this Large Person Group. The default
        value for 'recognitionModel' is 'recognition_01', if the latest model needed, please explicitly
        specify the model you need in this parameter. New faces that are added to an existing Large
        Person Group will use the recognition model that's already associated with the collection.
        Existing face feature(s) in a Large Person Group can't be updated to features extracted by
        another version of recognition model.

        ..

           [!NOTE]

           *


           * Free-tier subscription quota: 1,000 Large Person Groups.
           * S0-tier subscription quota: 1,000,000 Large Person Groups.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # User defined name, maximum length is 128. Required.
                    "recognitionModel": "str",  # Optional. The 'recognitionModel' associated
                      with this face list. Supported 'recognitionModel' values include
                      'recognition_01', 'recognition_02, 'recognition_03', and 'recognition_04'. The
                      default value is 'recognition_01'. 'recognition_04' is recommended since its
                      accuracy is improved on faces wearing masks compared with 'recognition_03', and
                      its overall accuracy is improved compared with 'recognition_01' and
                      'recognition_02'. Known values are: "recognition_01", "recognition_02",
                      "recognition_03", and "recognition_04".
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """

    @overload
    async def create_large_person_group(  # pylint: disable=inconsistent-return-statements
        self,
        large_person_group_id: str,
        *,
        name: str,
        content_type: str = "application/json",
        user_data: Optional[str] = None,
        recognition_model: Optional[Union[str, _models.FaceRecognitionModel]] = None,
        **kwargs: Any
    ) -> None:
        """Create a new Large Person Group with user-specified largePersonGroupId, name, an optional
        userData and recognitionModel.

        A Large Person Group is a container holding the uploaded person data, including the face
        recognition features. It can hold up to 1,000,000 entities.

        After creation, use "Create Large Person Group Person" to add person into the group, and call
        "Train Large Person Group" to get this group ready for "Identify From Large Person Group".

        No image will be stored. Only the person's extracted face feature(s) and userData will be
        stored on server until "Delete Large Person Group Person" or "Delete Large Person Group" is
        called.

        'recognitionModel' should be specified to associate with this Large Person Group. The default
        value for 'recognitionModel' is 'recognition_01', if the latest model needed, please explicitly
        specify the model you need in this parameter. New faces that are added to an existing Large
        Person Group will use the recognition model that's already associated with the collection.
        Existing face feature(s) in a Large Person Group can't be updated to features extracted by
        another version of recognition model.

        ..

           [!NOTE]

           *


           * Free-tier subscription quota: 1,000 Large Person Groups.
           * S0-tier subscription quota: 1,000,000 Large Person Groups.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :keyword name: User defined name, maximum length is 128. Required.
        :paramtype name: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :keyword recognition_model: The 'recognitionModel' associated with this face list. Supported
         'recognitionModel' values include 'recognition_01', 'recognition_02, 'recognition_03', and
         'recognition_04'. The default value is 'recognition_01'. 'recognition_04' is recommended since
         its accuracy is improved on faces wearing masks compared with 'recognition_03', and its overall
         accuracy is improved compared with 'recognition_01' and 'recognition_02'. Known values are:
         "recognition_01", "recognition_02", "recognition_03", and "recognition_04". Default value is
         None.
        :paramtype recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_large_person_group(  # pylint: disable=inconsistent-return-statements
        self, large_person_group_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Create a new Large Person Group with user-specified largePersonGroupId, name, an optional
        userData and recognitionModel.

        A Large Person Group is a container holding the uploaded person data, including the face
        recognition features. It can hold up to 1,000,000 entities.

        After creation, use "Create Large Person Group Person" to add person into the group, and call
        "Train Large Person Group" to get this group ready for "Identify From Large Person Group".

        No image will be stored. Only the person's extracted face feature(s) and userData will be
        stored on server until "Delete Large Person Group Person" or "Delete Large Person Group" is
        called.

        'recognitionModel' should be specified to associate with this Large Person Group. The default
        value for 'recognitionModel' is 'recognition_01', if the latest model needed, please explicitly
        specify the model you need in this parameter. New faces that are added to an existing Large
        Person Group will use the recognition model that's already associated with the collection.
        Existing face feature(s) in a Large Person Group can't be updated to features extracted by
        another version of recognition model.

        ..

           [!NOTE]

           *


           * Free-tier subscription quota: 1,000 Large Person Groups.
           * S0-tier subscription quota: 1,000,000 Large Person Groups.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_large_person_group(  # pylint: disable=inconsistent-return-statements
        self,
        large_person_group_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        name: str = _Unset,
        user_data: Optional[str] = None,
        recognition_model: Optional[Union[str, _models.FaceRecognitionModel]] = None,
        **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Create a new Large Person Group with user-specified largePersonGroupId, name, an optional
        userData and recognitionModel.

        A Large Person Group is a container holding the uploaded person data, including the face
        recognition features. It can hold up to 1,000,000 entities.

        After creation, use "Create Large Person Group Person" to add person into the group, and call
        "Train Large Person Group" to get this group ready for "Identify From Large Person Group".

        No image will be stored. Only the person's extracted face feature(s) and userData will be
        stored on server until "Delete Large Person Group Person" or "Delete Large Person Group" is
        called.

        'recognitionModel' should be specified to associate with this Large Person Group. The default
        value for 'recognitionModel' is 'recognition_01', if the latest model needed, please explicitly
        specify the model you need in this parameter. New faces that are added to an existing Large
        Person Group will use the recognition model that's already associated with the collection.
        Existing face feature(s) in a Large Person Group can't be updated to features extracted by
        another version of recognition model.

        ..

           [!NOTE]

           *


           * Free-tier subscription quota: 1,000 Large Person Groups.
           * S0-tier subscription quota: 1,000,000 Large Person Groups.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword name: User defined name, maximum length is 128. Required.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :keyword recognition_model: The 'recognitionModel' associated with this face list. Supported
         'recognitionModel' values include 'recognition_01', 'recognition_02, 'recognition_03', and
         'recognition_04'. The default value is 'recognition_01'. 'recognition_04' is recommended since
         its accuracy is improved on faces wearing masks compared with 'recognition_03', and its overall
         accuracy is improved compared with 'recognition_01' and 'recognition_02'. Known values are:
         "recognition_01", "recognition_02", "recognition_03", and "recognition_04". Default value is
         None.
        :paramtype recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # User defined name, maximum length is 128. Required.
                    "recognitionModel": "str",  # Optional. The 'recognitionModel' associated
                      with this face list. Supported 'recognitionModel' values include
                      'recognition_01', 'recognition_02, 'recognition_03', and 'recognition_04'. The
                      default value is 'recognition_01'. 'recognition_04' is recommended since its
                      accuracy is improved on faces wearing masks compared with 'recognition_03', and
                      its overall accuracy is improved compared with 'recognition_01' and
                      'recognition_02'. Known values are: "recognition_01", "recognition_02",
                      "recognition_03", and "recognition_04".
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        if body is _Unset:
            if name is _Unset:
                raise TypeError("missing required argument: name")
            body = {"name": name, "recognitionmodel": recognition_model, "userdata": user_data}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_administration_create_large_person_group_request(
            large_person_group_id=large_person_group_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def delete_large_person_group(  # pylint: disable=inconsistent-return-statements
        self, large_person_group_id: str, **kwargs: Any
    ) -> None:
        """Delete an existing Large Person Group with specified personGroupId. Persisted data in this
        Large Person Group will be deleted.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_face_administration_delete_large_person_group_request(
            large_person_group_id=large_person_group_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_large_person_group(
        self, large_person_group_id: str, *, return_recognition_model: Optional[bool] = None, **kwargs: Any
    ) -> _models.LargePersonGroup:
        # pylint: disable=line-too-long
        """Retrieve the information of a Large Person Group, including its name, userData and
        recognitionModel. This API returns Large Person Group information only, use "Get Large Person
        Group Persons" instead to retrieve person information under the Large Person Group.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :keyword return_recognition_model: Return 'recognitionModel' or not. The default value is
         false. Default value is None.
        :paramtype return_recognition_model: bool
        :return: LargePersonGroup. The LargePersonGroup is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.LargePersonGroup
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "largePersonGroupId": "str",  # ID of the container. Required.
                    "name": "str",  # User defined name, maximum length is 128. Required.
                    "recognitionModel": "str",  # Optional. Name of recognition model.
                      Recognition model is used when the face features are extracted and associated
                      with detected faceIds. Known values are: "recognition_01", "recognition_02",
                      "recognition_03", and "recognition_04".
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.LargePersonGroup] = kwargs.pop("cls", None)

        _request = build_face_administration_get_large_person_group_request(
            large_person_group_id=large_person_group_id,
            return_recognition_model=return_recognition_model,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.LargePersonGroup, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_large_person_group(  # pylint: disable=inconsistent-return-statements
        self, large_person_group_id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Update an existing Large Person Group's name and userData. The properties keep unchanged if
        they are not in request body.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # Optional. User defined name, maximum length is 128.
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """

    @overload
    async def update_large_person_group(  # pylint: disable=inconsistent-return-statements
        self,
        large_person_group_id: str,
        *,
        content_type: str = "application/json",
        name: Optional[str] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Update an existing Large Person Group's name and userData. The properties keep unchanged if
        they are not in request body.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword name: User defined name, maximum length is 128. Default value is None.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_large_person_group(  # pylint: disable=inconsistent-return-statements
        self, large_person_group_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Update an existing Large Person Group's name and userData. The properties keep unchanged if
        they are not in request body.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_large_person_group(  # pylint: disable=inconsistent-return-statements
        self,
        large_person_group_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        name: Optional[str] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Update an existing Large Person Group's name and userData. The properties keep unchanged if
        they are not in request body.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword name: User defined name, maximum length is 128. Default value is None.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # Optional. User defined name, maximum length is 128.
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        if body is _Unset:
            body = {"name": name, "userdata": user_data}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_administration_update_large_person_group_request(
            large_person_group_id=large_person_group_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_large_person_groups(
        self,
        *,
        start: Optional[str] = None,
        top: Optional[int] = None,
        return_recognition_model: Optional[bool] = None,
        **kwargs: Any
    ) -> List[_models.LargePersonGroup]:
        # pylint: disable=line-too-long
        """List all existing Large Person Groups' largePersonGroupId, name, userData and recognitionModel.

        Large Person Groups are stored in alphabetical order of largePersonGroupId.
        >
        *


        * "start" parameter (string, optional) specifies an ID value from which returned entries will
        have larger IDs based on string comparison. Setting "start" to an empty value indicates that
        entries should be returned starting from the first item.
        * "top" parameter (int, optional) determines the maximum number of entries to be returned, with
        a limit of up to 1000 entries per call. To retrieve additional entries beyond this limit,
        specify "start" with the personId of the last entry returned in the current call.

        ..

           [!TIP]


           * For example, there are total 5 items with their IDs: "itemId1", ..., "itemId5".

             * "start=&top=" will return all 5 items.
             * "start=&top=2" will return "itemId1", "itemId2".
             * "start=itemId2&top=3" will return "itemId3", "itemId4", "itemId5".

        :keyword start: List resources greater than the "start". It contains no more than 64
         characters. Default is empty. Default value is None.
        :paramtype start: str
        :keyword top: The number of items to list, ranging in [1, 1000]. Default is 1000. Default value
         is None.
        :paramtype top: int
        :keyword return_recognition_model: Return 'recognitionModel' or not. The default value is
         false. Default value is None.
        :paramtype return_recognition_model: bool
        :return: list of LargePersonGroup
        :rtype: list[~azure.ai.vision.face.models.LargePersonGroup]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "largePersonGroupId": "str",  # ID of the container. Required.
                        "name": "str",  # User defined name, maximum length is 128. Required.
                        "recognitionModel": "str",  # Optional. Name of recognition model.
                          Recognition model is used when the face features are extracted and associated
                          with detected faceIds. Known values are: "recognition_01", "recognition_02",
                          "recognition_03", and "recognition_04".
                        "userData": "str"  # Optional. Optional user defined data. Length
                          should not exceed 16K.
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.LargePersonGroup]] = kwargs.pop("cls", None)

        _request = build_face_administration_get_large_person_groups_request(
            start=start,
            top=top,
            return_recognition_model=return_recognition_model,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.LargePersonGroup], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_large_person_group_training_status(
        self, large_person_group_id: str, **kwargs: Any
    ) -> _models.FaceCollectionTrainingResult:
        # pylint: disable=line-too-long
        """To check Large Person Group training status completed or still ongoing. Large Person Group
        training is an asynchronous operation triggered by "Train Large Person Group" API.

        Training time depends on the number of person entries, and their faces in a Large Person Group.
        It could be in seconds, or up to half an hour for 1,000,000 persons.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :return: FaceCollectionTrainingResult. The FaceCollectionTrainingResult is compatible with
         MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceCollectionTrainingResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # A combined UTC date and time
                      string that describes the created time of the person group, large person group or
                      large face list. Required.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # A combined UTC date and time
                      string that describes the last modify time of the person group, large person
                      group or large face list, could be null value when the group is not successfully
                      trained. Required.
                    "lastSuccessfulTrainingDateTime": "2020-02-20 00:00:00",  # A combined UTC
                      date and time string that describes the last successful training time of the
                      person group, large person group or large face list. Required.
                    "status": "str",  # Training status of the container. Required. Known values
                      are: "notStarted", "running", "succeeded", and "failed".
                    "message": "str"  # Optional. Show failure message when training failed
                      (omitted when training succeed).
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.FaceCollectionTrainingResult] = kwargs.pop("cls", None)

        _request = build_face_administration_get_large_person_group_training_status_request(
            large_person_group_id=large_person_group_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.FaceCollectionTrainingResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _train_large_person_group_initial(  # pylint: disable=inconsistent-return-statements
        self, large_person_group_id: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_face_administration_train_large_person_group_request(
            large_person_group_id=large_person_group_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["operation-Location"] = self._deserialize("str", response.headers.get("operation-Location"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace_async
    async def begin_train_large_person_group(self, large_person_group_id: str, **kwargs: Any) -> AsyncLROPoller[None]:
        """Submit a Large Person Group training task. Training is a crucial step that only a trained Large
        Person Group can be used by "Identify From Large Person Group".

        The training task is an asynchronous task. Training time depends on the number of person
        entries, and their faces in a Large Person Group. It could be in several seconds, or up to half
        a hour for 1,000,000 persons. To check training status, please use "Get Large Person Group
        Training Status".

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._train_large_person_group_initial(  # type: ignore
                large_person_group_id=large_person_group_id,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @overload
    async def create_large_person_group_person(
        self, large_person_group_id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CreatePersonResult:
        """Create a new person in a specified Large Person Group. To add face to this person, please call
        "Add Large Person Group Person Face".

        ..

           [!NOTE]

           *


           * Free-tier subscription quota:

             * 1,000 persons in all Large Person Groups.

           * S0-tier subscription quota:

             * 1,000,000 persons per Large Person Group.
             * 1,000,000 Large Person Groups.
             * 1,000,000,000 persons in all Large Person Groups.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CreatePersonResult. The CreatePersonResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.CreatePersonResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # User defined name, maximum length is 128. Required.
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }

                # response body for status code(s): 200
                response == {
                    "personId": "str"  # Person ID of the person. Required.
                }
        """

    @overload
    async def create_large_person_group_person(
        self,
        large_person_group_id: str,
        *,
        name: str,
        content_type: str = "application/json",
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> _models.CreatePersonResult:
        """Create a new person in a specified Large Person Group. To add face to this person, please call
        "Add Large Person Group Person Face".

        ..

           [!NOTE]

           *


           * Free-tier subscription quota:

             * 1,000 persons in all Large Person Groups.

           * S0-tier subscription quota:

             * 1,000,000 persons per Large Person Group.
             * 1,000,000 Large Person Groups.
             * 1,000,000,000 persons in all Large Person Groups.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :keyword name: User defined name, maximum length is 128. Required.
        :paramtype name: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: CreatePersonResult. The CreatePersonResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.CreatePersonResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "personId": "str"  # Person ID of the person. Required.
                }
        """

    @overload
    async def create_large_person_group_person(
        self, large_person_group_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CreatePersonResult:
        """Create a new person in a specified Large Person Group. To add face to this person, please call
        "Add Large Person Group Person Face".

        ..

           [!NOTE]

           *


           * Free-tier subscription quota:

             * 1,000 persons in all Large Person Groups.

           * S0-tier subscription quota:

             * 1,000,000 persons per Large Person Group.
             * 1,000,000 Large Person Groups.
             * 1,000,000,000 persons in all Large Person Groups.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CreatePersonResult. The CreatePersonResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.CreatePersonResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "personId": "str"  # Person ID of the person. Required.
                }
        """

    @distributed_trace_async
    async def create_large_person_group_person(
        self,
        large_person_group_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        name: str = _Unset,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> _models.CreatePersonResult:
        """Create a new person in a specified Large Person Group. To add face to this person, please call
        "Add Large Person Group Person Face".

        ..

           [!NOTE]

           *


           * Free-tier subscription quota:

             * 1,000 persons in all Large Person Groups.

           * S0-tier subscription quota:

             * 1,000,000 persons per Large Person Group.
             * 1,000,000 Large Person Groups.
             * 1,000,000,000 persons in all Large Person Groups.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword name: User defined name, maximum length is 128. Required.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: CreatePersonResult. The CreatePersonResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.CreatePersonResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # User defined name, maximum length is 128. Required.
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }

                # response body for status code(s): 200
                response == {
                    "personId": "str"  # Person ID of the person. Required.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CreatePersonResult] = kwargs.pop("cls", None)

        if body is _Unset:
            if name is _Unset:
                raise TypeError("missing required argument: name")
            body = {"name": name, "userdata": user_data}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_administration_create_large_person_group_person_request(
            large_person_group_id=large_person_group_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CreatePersonResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_large_person_group_person(  # pylint: disable=inconsistent-return-statements
        self, large_person_group_id: str, person_id: str, **kwargs: Any
    ) -> None:
        """Delete an existing person from a Large Person Group. The persistedFaceId, userData, person name
        and face feature(s) in the person entry will all be deleted.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_face_administration_delete_large_person_group_person_request(
            large_person_group_id=large_person_group_id,
            person_id=person_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_large_person_group_person(
        self, large_person_group_id: str, person_id: str, **kwargs: Any
    ) -> _models.LargePersonGroupPerson:
        """Retrieve a person's name and userData, and the persisted faceIds representing the registered
        person face feature(s).

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :return: LargePersonGroupPerson. The LargePersonGroupPerson is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.LargePersonGroupPerson
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "name": "str",  # User defined name, maximum length is 128. Required.
                    "personId": "str",  # ID of the person. Required.
                    "persistedFaceIds": [
                        "str"  # Optional. Face ids of registered faces in the person.
                    ],
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.LargePersonGroupPerson] = kwargs.pop("cls", None)

        _request = build_face_administration_get_large_person_group_person_request(
            large_person_group_id=large_person_group_id,
            person_id=person_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.LargePersonGroupPerson, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_large_person_group_person(  # pylint: disable=inconsistent-return-statements
        self,
        large_person_group_id: str,
        person_id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Update name or userData of a person.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # Optional. User defined name, maximum length is 128.
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """

    @overload
    async def update_large_person_group_person(  # pylint: disable=inconsistent-return-statements
        self,
        large_person_group_id: str,
        person_id: str,
        *,
        content_type: str = "application/json",
        name: Optional[str] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Update name or userData of a person.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword name: User defined name, maximum length is 128. Default value is None.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_large_person_group_person(  # pylint: disable=inconsistent-return-statements
        self,
        large_person_group_id: str,
        person_id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Update name or userData of a person.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_large_person_group_person(  # pylint: disable=inconsistent-return-statements
        self,
        large_person_group_id: str,
        person_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        name: Optional[str] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Update name or userData of a person.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword name: User defined name, maximum length is 128. Default value is None.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # Optional. User defined name, maximum length is 128.
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        if body is _Unset:
            body = {"name": name, "userdata": user_data}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_administration_update_large_person_group_person_request(
            large_person_group_id=large_person_group_id,
            person_id=person_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_large_person_group_persons(
        self, large_person_group_id: str, *, start: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
    ) -> List[_models.LargePersonGroupPerson]:
        """List all persons' information in the specified Large Person Group, including personId, name,
        userData and persistedFaceIds of registered person faces.

        Persons are stored in alphabetical order of personId created in "Create Large Person Group
        Person".
        >
        *


        * "start" parameter (string, optional) specifies an ID value from which returned entries will
        have larger IDs based on string comparison. Setting "start" to an empty value indicates that
        entries should be returned starting from the first item.
        * "top" parameter (int, optional) determines the maximum number of entries to be returned, with
        a limit of up to 1000 entries per call. To retrieve additional entries beyond this limit,
        specify "start" with the personId of the last entry returned in the current call.

        ..

           [!TIP]


           * For example, there are total 5 items with their IDs: "itemId1", ..., "itemId5".

             * "start=&top=" will return all 5 items.
             * "start=&top=2" will return "itemId1", "itemId2".
             * "start=itemId2&top=3" will return "itemId3", "itemId4", "itemId5".

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :keyword start: List resources greater than the "start". It contains no more than 64
         characters. Default is empty. Default value is None.
        :paramtype start: str
        :keyword top: The number of items to list, ranging in [1, 1000]. Default is 1000. Default value
         is None.
        :paramtype top: int
        :return: list of LargePersonGroupPerson
        :rtype: list[~azure.ai.vision.face.models.LargePersonGroupPerson]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "name": "str",  # User defined name, maximum length is 128. Required.
                        "personId": "str",  # ID of the person. Required.
                        "persistedFaceIds": [
                            "str"  # Optional. Face ids of registered faces in the
                              person.
                        ],
                        "userData": "str"  # Optional. Optional user defined data. Length
                          should not exceed 16K.
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.LargePersonGroupPerson]] = kwargs.pop("cls", None)

        _request = build_face_administration_get_large_person_group_persons_request(
            large_person_group_id=large_person_group_id,
            start=start,
            top=top,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.LargePersonGroupPerson], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def add_large_person_group_person_face_from_url(  # pylint: disable=name-too-long
        self,
        large_person_group_id: str,
        person_id: str,
        body: JSON,
        *,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AddFaceResult:
        # pylint: disable=line-too-long
        """Add a face to a person into a Large Person Group for face identification or verification.

        To deal with an image containing multiple faces, input face can be specified as an image with a
        targetFace rectangle. It returns a persistedFaceId representing the added face. No image will
        be stored. Only the extracted face feature(s) will be stored on server until "Delete Large
        Person Group Person Face", "Delete Large Person Group Person" or "Delete Large Person Group" is
        called.

        Note that persistedFaceId is different from faceId generated by "Detect".
        >
        *


        * Higher face image quality means better recognition precision. Please consider high-quality
        faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes) or bigger.
        * Each person entry can hold up to 248 faces.
        * JPEG, PNG, GIF (the first frame), and BMP format are supported. The allowed image file size
        is from 1KB to 6MB.
        * "targetFace" rectangle should contain one face. Zero or multiple faces will be regarded as an
        error. If the provided "targetFace" rectangle is not returned from "Detect", there's no
        guarantee to detect and add the face successfully.
        * Out of detectable face size (36x36 - 4096x4096 pixels), large head-pose, or large occlusions
        will cause failures.
        * The minimum detectable face size is 36x36 pixels in an image no larger than 1920x1080 pixels.
        Images with dimensions higher than 1920x1080 pixels will need a proportionally larger minimum
        face size.
        * Different 'detectionModel' values can be provided. To use and compare different detection
        models, please refer to
        https://learn.microsoft.com/azure/ai-services/computer-vision/how-to/specify-detection-model.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param body: Required.
        :type body: JSON
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AddFaceResult. The AddFaceResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.AddFaceResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "url": "str"  # URL of input image. Required.
                }

                # response body for status code(s): 200
                response == {
                    "persistedFaceId": "str"  # Persisted Face ID of the added face, which is
                      persisted and will not expire. Different from faceId which is created in "Detect"
                      and will expire in 24 hours after the detection call. Required.
                }
        """

    @overload
    async def add_large_person_group_person_face_from_url(  # pylint: disable=name-too-long
        self,
        large_person_group_id: str,
        person_id: str,
        *,
        url: str,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AddFaceResult:
        # pylint: disable=line-too-long
        """Add a face to a person into a Large Person Group for face identification or verification.

        To deal with an image containing multiple faces, input face can be specified as an image with a
        targetFace rectangle. It returns a persistedFaceId representing the added face. No image will
        be stored. Only the extracted face feature(s) will be stored on server until "Delete Large
        Person Group Person Face", "Delete Large Person Group Person" or "Delete Large Person Group" is
        called.

        Note that persistedFaceId is different from faceId generated by "Detect".
        >
        *


        * Higher face image quality means better recognition precision. Please consider high-quality
        faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes) or bigger.
        * Each person entry can hold up to 248 faces.
        * JPEG, PNG, GIF (the first frame), and BMP format are supported. The allowed image file size
        is from 1KB to 6MB.
        * "targetFace" rectangle should contain one face. Zero or multiple faces will be regarded as an
        error. If the provided "targetFace" rectangle is not returned from "Detect", there's no
        guarantee to detect and add the face successfully.
        * Out of detectable face size (36x36 - 4096x4096 pixels), large head-pose, or large occlusions
        will cause failures.
        * The minimum detectable face size is 36x36 pixels in an image no larger than 1920x1080 pixels.
        Images with dimensions higher than 1920x1080 pixels will need a proportionally larger minimum
        face size.
        * Different 'detectionModel' values can be provided. To use and compare different detection
        models, please refer to
        https://learn.microsoft.com/azure/ai-services/computer-vision/how-to/specify-detection-model.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :keyword url: URL of input image. Required.
        :paramtype url: str
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AddFaceResult. The AddFaceResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.AddFaceResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "persistedFaceId": "str"  # Persisted Face ID of the added face, which is
                      persisted and will not expire. Different from faceId which is created in "Detect"
                      and will expire in 24 hours after the detection call. Required.
                }
        """

    @overload
    async def add_large_person_group_person_face_from_url(  # pylint: disable=name-too-long
        self,
        large_person_group_id: str,
        person_id: str,
        body: IO[bytes],
        *,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AddFaceResult:
        # pylint: disable=line-too-long
        """Add a face to a person into a Large Person Group for face identification or verification.

        To deal with an image containing multiple faces, input face can be specified as an image with a
        targetFace rectangle. It returns a persistedFaceId representing the added face. No image will
        be stored. Only the extracted face feature(s) will be stored on server until "Delete Large
        Person Group Person Face", "Delete Large Person Group Person" or "Delete Large Person Group" is
        called.

        Note that persistedFaceId is different from faceId generated by "Detect".
        >
        *


        * Higher face image quality means better recognition precision. Please consider high-quality
        faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes) or bigger.
        * Each person entry can hold up to 248 faces.
        * JPEG, PNG, GIF (the first frame), and BMP format are supported. The allowed image file size
        is from 1KB to 6MB.
        * "targetFace" rectangle should contain one face. Zero or multiple faces will be regarded as an
        error. If the provided "targetFace" rectangle is not returned from "Detect", there's no
        guarantee to detect and add the face successfully.
        * Out of detectable face size (36x36 - 4096x4096 pixels), large head-pose, or large occlusions
        will cause failures.
        * The minimum detectable face size is 36x36 pixels in an image no larger than 1920x1080 pixels.
        Images with dimensions higher than 1920x1080 pixels will need a proportionally larger minimum
        face size.
        * Different 'detectionModel' values can be provided. To use and compare different detection
        models, please refer to
        https://learn.microsoft.com/azure/ai-services/computer-vision/how-to/specify-detection-model.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AddFaceResult. The AddFaceResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.AddFaceResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "persistedFaceId": "str"  # Persisted Face ID of the added face, which is
                      persisted and will not expire. Different from faceId which is created in "Detect"
                      and will expire in 24 hours after the detection call. Required.
                }
        """

    @distributed_trace_async
    async def add_large_person_group_person_face_from_url(  # pylint: disable=name-too-long
        self,
        large_person_group_id: str,
        person_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        url: str = _Unset,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> _models.AddFaceResult:
        # pylint: disable=line-too-long
        """Add a face to a person into a Large Person Group for face identification or verification.

        To deal with an image containing multiple faces, input face can be specified as an image with a
        targetFace rectangle. It returns a persistedFaceId representing the added face. No image will
        be stored. Only the extracted face feature(s) will be stored on server until "Delete Large
        Person Group Person Face", "Delete Large Person Group Person" or "Delete Large Person Group" is
        called.

        Note that persistedFaceId is different from faceId generated by "Detect".
        >
        *


        * Higher face image quality means better recognition precision. Please consider high-quality
        faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes) or bigger.
        * Each person entry can hold up to 248 faces.
        * JPEG, PNG, GIF (the first frame), and BMP format are supported. The allowed image file size
        is from 1KB to 6MB.
        * "targetFace" rectangle should contain one face. Zero or multiple faces will be regarded as an
        error. If the provided "targetFace" rectangle is not returned from "Detect", there's no
        guarantee to detect and add the face successfully.
        * Out of detectable face size (36x36 - 4096x4096 pixels), large head-pose, or large occlusions
        will cause failures.
        * The minimum detectable face size is 36x36 pixels in an image no larger than 1920x1080 pixels.
        Images with dimensions higher than 1920x1080 pixels will need a proportionally larger minimum
        face size.
        * Different 'detectionModel' values can be provided. To use and compare different detection
        models, please refer to
        https://learn.microsoft.com/azure/ai-services/computer-vision/how-to/specify-detection-model.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword url: URL of input image. Required.
        :paramtype url: str
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :return: AddFaceResult. The AddFaceResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.AddFaceResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "url": "str"  # URL of input image. Required.
                }

                # response body for status code(s): 200
                response == {
                    "persistedFaceId": "str"  # Persisted Face ID of the added face, which is
                      persisted and will not expire. Different from faceId which is created in "Detect"
                      and will expire in 24 hours after the detection call. Required.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AddFaceResult] = kwargs.pop("cls", None)

        if body is _Unset:
            if url is _Unset:
                raise TypeError("missing required argument: url")
            body = {"url": url}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_administration_add_large_person_group_person_face_from_url_request(
            large_person_group_id=large_person_group_id,
            person_id=person_id,
            target_face=target_face,
            detection_model=detection_model,
            user_data=user_data,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AddFaceResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def add_large_person_group_person_face(
        self,
        large_person_group_id: str,
        person_id: str,
        image_content: bytes,
        *,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> _models.AddFaceResult:
        # pylint: disable=line-too-long
        """Add a face to a person into a Large Person Group for face identification or verification.

        To deal with an image containing multiple faces, input face can be specified as an image with a
        targetFace rectangle. It returns a persistedFaceId representing the added face. No image will
        be stored. Only the extracted face feature(s) will be stored on server until "Delete Large
        Person Group Person Face", "Delete Large Person Group Person" or "Delete Large Person Group" is
        called.

        Note that persistedFaceId is different from faceId generated by "Detect".
        >
        *


        * Higher face image quality means better recognition precision. Please consider high-quality
        faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes) or bigger.
        * Each person entry can hold up to 248 faces.
        * JPEG, PNG, GIF (the first frame), and BMP format are supported. The allowed image file size
        is from 1KB to 6MB.
        * "targetFace" rectangle should contain one face. Zero or multiple faces will be regarded as an
        error. If the provided "targetFace" rectangle is not returned from "Detect", there's no
        guarantee to detect and add the face successfully.
        * Out of detectable face size (36x36 - 4096x4096 pixels), large head-pose, or large occlusions
        will cause failures.
        * The minimum detectable face size is 36x36 pixels in an image no larger than 1920x1080 pixels.
        Images with dimensions higher than 1920x1080 pixels will need a proportionally larger minimum
        face size.
        * Different 'detectionModel' values can be provided. To use and compare different detection
        models, please refer to
        https://learn.microsoft.com/azure/ai-services/computer-vision/how-to/specify-detection-model.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param image_content: The image to be analyzed. Required.
        :type image_content: bytes
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :return: AddFaceResult. The AddFaceResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.AddFaceResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "persistedFaceId": "str"  # Persisted Face ID of the added face, which is
                      persisted and will not expire. Different from faceId which is created in "Detect"
                      and will expire in 24 hours after the detection call. Required.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop("content_type", _headers.pop("content-type", "application/octet-stream"))
        cls: ClsType[_models.AddFaceResult] = kwargs.pop("cls", None)

        _content = image_content

        _request = build_face_administration_add_large_person_group_person_face_request(
            large_person_group_id=large_person_group_id,
            person_id=person_id,
            target_face=target_face,
            detection_model=detection_model,
            user_data=user_data,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AddFaceResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_large_person_group_person_face(  # pylint: disable=inconsistent-return-statements
        self, large_person_group_id: str, person_id: str, persisted_face_id: str, **kwargs: Any
    ) -> None:
        """Delete a face from a person in a Large Person Group by specified largePersonGroupId, personId
        and persistedFaceId.

        Adding/deleting faces to/from a same person will be processed sequentially. Adding/deleting
        faces to/from different persons are processed in parallel.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_face_administration_delete_large_person_group_person_face_request(
            large_person_group_id=large_person_group_id,
            person_id=person_id,
            persisted_face_id=persisted_face_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_large_person_group_person_face(
        self, large_person_group_id: str, person_id: str, persisted_face_id: str, **kwargs: Any
    ) -> _models.LargePersonGroupPersonFace:
        """Retrieve person face information. The persisted person face is specified by its
        largePersonGroupId, personId and persistedFaceId.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :return: LargePersonGroupPersonFace. The LargePersonGroupPersonFace is compatible with
         MutableMapping
        :rtype: ~azure.ai.vision.face.models.LargePersonGroupPersonFace
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "persistedFaceId": "str",  # Face ID of the face. Required.
                    "userData": "str"  # Optional. User-provided data attached to the face. The
                      length limit is 1K.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.LargePersonGroupPersonFace] = kwargs.pop("cls", None)

        _request = build_face_administration_get_large_person_group_person_face_request(
            large_person_group_id=large_person_group_id,
            person_id=person_id,
            persisted_face_id=persisted_face_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.LargePersonGroupPersonFace, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_large_person_group_person_face(  # pylint: disable=inconsistent-return-statements
        self,
        large_person_group_id: str,
        person_id: str,
        persisted_face_id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Update a person persisted face's userData field.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "userData": "str"  # Optional. User-provided data attached to the face. The
                      length limit is 1K.
                }
        """

    @overload
    async def update_large_person_group_person_face(  # pylint: disable=inconsistent-return-statements
        self,
        large_person_group_id: str,
        person_id: str,
        persisted_face_id: str,
        *,
        content_type: str = "application/json",
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Update a person persisted face's userData field.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword user_data: User-provided data attached to the face. The length limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_large_person_group_person_face(  # pylint: disable=inconsistent-return-statements
        self,
        large_person_group_id: str,
        person_id: str,
        persisted_face_id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Update a person persisted face's userData field.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_large_person_group_person_face(  # pylint: disable=inconsistent-return-statements
        self,
        large_person_group_id: str,
        person_id: str,
        persisted_face_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Update a person persisted face's userData field.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword user_data: User-provided data attached to the face. The length limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "userData": "str"  # Optional. User-provided data attached to the face. The
                      length limit is 1K.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        if body is _Unset:
            body = {"userdata": user_data}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_administration_update_large_person_group_person_face_request(
            large_person_group_id=large_person_group_id,
            person_id=person_id,
            persisted_face_id=persisted_face_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    async def _create_person_initial(
        self,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        name: str = _Unset,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> JSON:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        if body is _Unset:
            if name is _Unset:
                raise TypeError("missing required argument: name")
            body = {"name": name, "userdata": user_data}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_administration_create_person_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["operation-Location"] = self._deserialize("str", response.headers.get("operation-Location"))
        response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))

        deserialized = _deserialize(JSON, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_person(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[_models.CreatePersonResult]:
        """Creates a new person in a Person Directory. To add face to this person, please call Person
        Directory "Add Person Face".

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns CreatePersonResult. The CreatePersonResult
         is compatible with MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.ai.vision.face.models.CreatePersonResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # User defined name, maximum length is 128. Required.
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }

                # response body for status code(s): 202
                response == {
                    "personId": "str"  # Person ID of the person. Required.
                }
        """

    @overload
    async def begin_create_person(
        self, *, name: str, content_type: str = "application/json", user_data: Optional[str] = None, **kwargs: Any
    ) -> AsyncLROPoller[_models.CreatePersonResult]:
        """Creates a new person in a Person Directory. To add face to this person, please call Person
        Directory "Add Person Face".

        :keyword name: User defined name, maximum length is 128. Required.
        :paramtype name: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: An instance of AsyncLROPoller that returns CreatePersonResult. The CreatePersonResult
         is compatible with MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.ai.vision.face.models.CreatePersonResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "personId": "str"  # Person ID of the person. Required.
                }
        """

    @overload
    async def begin_create_person(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[_models.CreatePersonResult]:
        """Creates a new person in a Person Directory. To add face to this person, please call Person
        Directory "Add Person Face".

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns CreatePersonResult. The CreatePersonResult
         is compatible with MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.ai.vision.face.models.CreatePersonResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "personId": "str"  # Person ID of the person. Required.
                }
        """

    @distributed_trace_async
    async def begin_create_person(
        self,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        name: str = _Unset,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[_models.CreatePersonResult]:
        """Creates a new person in a Person Directory. To add face to this person, please call Person
        Directory "Add Person Face".

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword name: User defined name, maximum length is 128. Required.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: An instance of AsyncLROPoller that returns CreatePersonResult. The CreatePersonResult
         is compatible with MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.ai.vision.face.models.CreatePersonResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # User defined name, maximum length is 128. Required.
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }

                # response body for status code(s): 202
                response == {
                    "personId": "str"  # Person ID of the person. Required.
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CreatePersonResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_person_initial(
                body=body,
                name=name,
                user_data=user_data,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["operation-Location"] = self._deserialize(
                "str", response.headers.get("operation-Location")
            )
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))

            deserialized = _deserialize(_models.CreatePersonResult, response.json())
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.CreatePersonResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.CreatePersonResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _delete_person_initial(  # pylint: disable=inconsistent-return-statements
        self, person_id: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_face_administration_delete_person_request(
            person_id=person_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["operation-Location"] = self._deserialize("str", response.headers.get("operation-Location"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace_async
    async def begin_delete_person(self, person_id: str, **kwargs: Any) -> AsyncLROPoller[None]:
        """Delete an existing person from Person Directory. The persistedFaceId(s), userData, person name
        and face feature(s) in the person entry will all be deleted.

        :param person_id: Person ID of the person. Required.
        :type person_id: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_person_initial(  # type: ignore
                person_id=person_id, cls=lambda x, y, z: x, headers=_headers, params=_params, **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def get_person(self, person_id: str, **kwargs: Any) -> _models.PersonDirectoryPerson:
        """Retrieve a person's name and userData from Person Directory.

        :param person_id: Person ID of the person. Required.
        :type person_id: str
        :return: PersonDirectoryPerson. The PersonDirectoryPerson is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.PersonDirectoryPerson
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "name": "str",  # User defined name, maximum length is 128. Required.
                    "personId": "str",  # Person ID of the person. Required.
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.PersonDirectoryPerson] = kwargs.pop("cls", None)

        _request = build_face_administration_get_person_request(
            person_id=person_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.PersonDirectoryPerson, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_person(  # pylint: disable=inconsistent-return-statements
        self, person_id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Update name or userData of a person.

        :param person_id: Person ID of the person. Required.
        :type person_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # Optional. User defined name, maximum length is 128.
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """

    @overload
    async def update_person(  # pylint: disable=inconsistent-return-statements
        self,
        person_id: str,
        *,
        content_type: str = "application/json",
        name: Optional[str] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Update name or userData of a person.

        :param person_id: Person ID of the person. Required.
        :type person_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword name: User defined name, maximum length is 128. Default value is None.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_person(  # pylint: disable=inconsistent-return-statements
        self, person_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Update name or userData of a person.

        :param person_id: Person ID of the person. Required.
        :type person_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_person(  # pylint: disable=inconsistent-return-statements
        self,
        person_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        name: Optional[str] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Update name or userData of a person.

        :param person_id: Person ID of the person. Required.
        :type person_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword name: User defined name, maximum length is 128. Default value is None.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # Optional. User defined name, maximum length is 128.
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        if body is _Unset:
            body = {"name": name, "userdata": user_data}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_administration_update_person_request(
            person_id=person_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_persons(
        self, *, start: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
    ) -> List[_models.PersonDirectoryPerson]:
        """List all persons' information in Person Directory, including personId, name, and userData.

        Persons are stored in alphabetical order of personId created in Person Directory "Create
        Person".
        >
        *


        * "start" parameter (string, optional) specifies an ID value from which returned entries will
        have larger IDs based on string comparison. Setting "start" to an empty value indicates that
        entries should be returned starting from the first item.
        * "top" parameter (int, optional) determines the maximum number of entries to be returned, with
        a limit of up to 1000 entries per call. To retrieve additional entries beyond this limit,
        specify "start" with the personId of the last entry returned in the current call.

        ..

           [!TIP]


           * For example, there are total 5 items with their IDs: "itemId1", ..., "itemId5".

             * "start=&top=" will return all 5 items.
             * "start=&top=2" will return "itemId1", "itemId2".
             * "start=itemId2&top=3" will return "itemId3", "itemId4", "itemId5".

        :keyword start: List resources greater than the "start". It contains no more than 64
         characters. Default is empty. Default value is None.
        :paramtype start: str
        :keyword top: The number of items to list, ranging in [1, 1000]. Default is 1000. Default value
         is None.
        :paramtype top: int
        :return: list of PersonDirectoryPerson
        :rtype: list[~azure.ai.vision.face.models.PersonDirectoryPerson]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "name": "str",  # User defined name, maximum length is 128. Required.
                        "personId": "str",  # Person ID of the person. Required.
                        "userData": "str"  # Optional. Optional user defined data. Length
                          should not exceed 16K.
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.PersonDirectoryPerson]] = kwargs.pop("cls", None)

        _request = build_face_administration_get_persons_request(
            start=start,
            top=top,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.PersonDirectoryPerson], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_dynamic_person_group_references(
        self, person_id: str, *, start: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
    ) -> _models.ListGroupReferenceResult:
        """List all Dynamic Person Groups a person has been referenced by in Person Directory.

        Dynamic Person Groups are stored in alphabetical order of Dynamic Person Group ID created in
        Person Directory "Create Dynamic Person Group".
        >
        *


        * "start" parameter (string, optional) specifies an ID value from which returned entries will
        have larger IDs based on string comparison. Setting "start" to an empty value indicates that
        entries should be returned starting from the first item.
        * "top" parameter (int, optional) determines the maximum number of entries to be returned, with
        a limit of up to 1000 entries per call. To retrieve additional entries beyond this limit,
        specify "start" with the personId of the last entry returned in the current call.

        ..

           [!TIP]


           * For example, there are total 5 items with their IDs: "itemId1", ..., "itemId5".

             * "start=&top=" will return all 5 items.
             * "start=&top=2" will return "itemId1", "itemId2".
             * "start=itemId2&top=3" will return "itemId3", "itemId4", "itemId5".

        :param person_id: Person ID of the person. Required.
        :type person_id: str
        :keyword start: List resources greater than the "start". It contains no more than 64
         characters. Default is empty. Default value is None.
        :paramtype start: str
        :keyword top: The number of items to list, ranging in [1, 1000]. Default is 1000. Default value
         is None.
        :paramtype top: int
        :return: ListGroupReferenceResult. The ListGroupReferenceResult is compatible with
         MutableMapping
        :rtype: ~azure.ai.vision.face.models.ListGroupReferenceResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "dynamicPersonGroupIds": [
                        "str"  # Array of PersonDirectory DynamicPersonGroup ids. Required.
                    ]
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.ListGroupReferenceResult] = kwargs.pop("cls", None)

        _request = build_face_administration_get_dynamic_person_group_references_request(
            person_id=person_id,
            start=start,
            top=top,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.ListGroupReferenceResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _add_person_face_from_url_initial(
        self,
        person_id: str,
        recognition_model: Union[str, _models.FaceRecognitionModel],
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        url: str = _Unset,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> JSON:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        if body is _Unset:
            if url is _Unset:
                raise TypeError("missing required argument: url")
            body = {"url": url}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_administration_add_person_face_from_url_request(
            person_id=person_id,
            recognition_model=recognition_model,
            target_face=target_face,
            detection_model=detection_model,
            user_data=user_data,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["operation-Location"] = self._deserialize("str", response.headers.get("operation-Location"))
        response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))

        deserialized = _deserialize(JSON, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_add_person_face_from_url(
        self,
        person_id: str,
        recognition_model: Union[str, _models.FaceRecognitionModel],
        body: JSON,
        *,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.AddFaceResult]:
        # pylint: disable=line-too-long
        """Add a face to a person (see Person Directory "Create Person") for face identification or
        verification.

        To deal with an image containing multiple faces, input face can be specified as an image with a
        targetFace rectangle. It returns a persistedFaceId representing the added face. No image will
        be stored. Only the extracted face feature(s) will be stored on server until Person Directory
        "Delete Person Face" or "Delete Person" is called.

        Note that persistedFaceId is different from faceId generated by "Detect".
        >
        *


        * Higher face image quality means better recognition precision. Please consider high-quality
        faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes) or bigger.
        * Each person entry can hold up to 248 faces.
        * JPEG, PNG, GIF (the first frame), and BMP format are supported. The allowed image file size
        is from 1KB to 6MB.
        * "targetFace" rectangle should contain one face. Zero or multiple faces will be regarded as an
        error. If the provided "targetFace" rectangle is not returned from "Detect", there's no
        guarantee to detect and add the face successfully.
        * Out of detectable face size (36x36 - 4096x4096 pixels), large head-pose, or large occlusions
        will cause failures.
        * The minimum detectable face size is 36x36 pixels in an image no larger than 1920x1080 pixels.
        Images with dimensions higher than 1920x1080 pixels will need a proportionally larger minimum
        face size.
        * Different 'detectionModel' values can be provided. To use and compare different detection
        models, please refer to
        https://learn.microsoft.com/azure/ai-services/computer-vision/how-to/specify-detection-model
          *
        * Adding/deleting faces to/from a same person will be processed sequentially. Adding/deleting
        faces to/from different persons are processed in parallel.
        * This is a long running operation. Use Response Header "Operation-Location" to determine when
        the AddFace operation has successfully propagated for future requests to "Identify". For
        further information about Operation-Locations see "Get Face Operation Status".

        :param person_id: Person ID of the person. Required.
        :type person_id: str
        :param recognition_model: The 'recognitionModel' associated with faces. Known values are:
         "recognition_01", "recognition_02", "recognition_03", and "recognition_04". Required.
        :type recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :param body: Required.
        :type body: JSON
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns AddFaceResult. The AddFaceResult is
         compatible with MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.ai.vision.face.models.AddFaceResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "url": "str"  # URL of input image. Required.
                }

                # response body for status code(s): 202
                response == {
                    "persistedFaceId": "str"  # Persisted Face ID of the added face, which is
                      persisted and will not expire. Different from faceId which is created in "Detect"
                      and will expire in 24 hours after the detection call. Required.
                }
        """

    @overload
    async def begin_add_person_face_from_url(
        self,
        person_id: str,
        recognition_model: Union[str, _models.FaceRecognitionModel],
        *,
        url: str,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.AddFaceResult]:
        # pylint: disable=line-too-long
        """Add a face to a person (see Person Directory "Create Person") for face identification or
        verification.

        To deal with an image containing multiple faces, input face can be specified as an image with a
        targetFace rectangle. It returns a persistedFaceId representing the added face. No image will
        be stored. Only the extracted face feature(s) will be stored on server until Person Directory
        "Delete Person Face" or "Delete Person" is called.

        Note that persistedFaceId is different from faceId generated by "Detect".
        >
        *


        * Higher face image quality means better recognition precision. Please consider high-quality
        faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes) or bigger.
        * Each person entry can hold up to 248 faces.
        * JPEG, PNG, GIF (the first frame), and BMP format are supported. The allowed image file size
        is from 1KB to 6MB.
        * "targetFace" rectangle should contain one face. Zero or multiple faces will be regarded as an
        error. If the provided "targetFace" rectangle is not returned from "Detect", there's no
        guarantee to detect and add the face successfully.
        * Out of detectable face size (36x36 - 4096x4096 pixels), large head-pose, or large occlusions
        will cause failures.
        * The minimum detectable face size is 36x36 pixels in an image no larger than 1920x1080 pixels.
        Images with dimensions higher than 1920x1080 pixels will need a proportionally larger minimum
        face size.
        * Different 'detectionModel' values can be provided. To use and compare different detection
        models, please refer to
        https://learn.microsoft.com/azure/ai-services/computer-vision/how-to/specify-detection-model
          *
        * Adding/deleting faces to/from a same person will be processed sequentially. Adding/deleting
        faces to/from different persons are processed in parallel.
        * This is a long running operation. Use Response Header "Operation-Location" to determine when
        the AddFace operation has successfully propagated for future requests to "Identify". For
        further information about Operation-Locations see "Get Face Operation Status".

        :param person_id: Person ID of the person. Required.
        :type person_id: str
        :param recognition_model: The 'recognitionModel' associated with faces. Known values are:
         "recognition_01", "recognition_02", "recognition_03", and "recognition_04". Required.
        :type recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :keyword url: URL of input image. Required.
        :paramtype url: str
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns AddFaceResult. The AddFaceResult is
         compatible with MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.ai.vision.face.models.AddFaceResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "persistedFaceId": "str"  # Persisted Face ID of the added face, which is
                      persisted and will not expire. Different from faceId which is created in "Detect"
                      and will expire in 24 hours after the detection call. Required.
                }
        """

    @overload
    async def begin_add_person_face_from_url(
        self,
        person_id: str,
        recognition_model: Union[str, _models.FaceRecognitionModel],
        body: IO[bytes],
        *,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.AddFaceResult]:
        # pylint: disable=line-too-long
        """Add a face to a person (see Person Directory "Create Person") for face identification or
        verification.

        To deal with an image containing multiple faces, input face can be specified as an image with a
        targetFace rectangle. It returns a persistedFaceId representing the added face. No image will
        be stored. Only the extracted face feature(s) will be stored on server until Person Directory
        "Delete Person Face" or "Delete Person" is called.

        Note that persistedFaceId is different from faceId generated by "Detect".
        >
        *


        * Higher face image quality means better recognition precision. Please consider high-quality
        faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes) or bigger.
        * Each person entry can hold up to 248 faces.
        * JPEG, PNG, GIF (the first frame), and BMP format are supported. The allowed image file size
        is from 1KB to 6MB.
        * "targetFace" rectangle should contain one face. Zero or multiple faces will be regarded as an
        error. If the provided "targetFace" rectangle is not returned from "Detect", there's no
        guarantee to detect and add the face successfully.
        * Out of detectable face size (36x36 - 4096x4096 pixels), large head-pose, or large occlusions
        will cause failures.
        * The minimum detectable face size is 36x36 pixels in an image no larger than 1920x1080 pixels.
        Images with dimensions higher than 1920x1080 pixels will need a proportionally larger minimum
        face size.
        * Different 'detectionModel' values can be provided. To use and compare different detection
        models, please refer to
        https://learn.microsoft.com/azure/ai-services/computer-vision/how-to/specify-detection-model
          *
        * Adding/deleting faces to/from a same person will be processed sequentially. Adding/deleting
        faces to/from different persons are processed in parallel.
        * This is a long running operation. Use Response Header "Operation-Location" to determine when
        the AddFace operation has successfully propagated for future requests to "Identify". For
        further information about Operation-Locations see "Get Face Operation Status".

        :param person_id: Person ID of the person. Required.
        :type person_id: str
        :param recognition_model: The 'recognitionModel' associated with faces. Known values are:
         "recognition_01", "recognition_02", "recognition_03", and "recognition_04". Required.
        :type recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :param body: Required.
        :type body: IO[bytes]
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns AddFaceResult. The AddFaceResult is
         compatible with MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.ai.vision.face.models.AddFaceResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "persistedFaceId": "str"  # Persisted Face ID of the added face, which is
                      persisted and will not expire. Different from faceId which is created in "Detect"
                      and will expire in 24 hours after the detection call. Required.
                }
        """

    @distributed_trace_async
    async def begin_add_person_face_from_url(
        self,
        person_id: str,
        recognition_model: Union[str, _models.FaceRecognitionModel],
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        url: str = _Unset,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[_models.AddFaceResult]:
        # pylint: disable=line-too-long
        """Add a face to a person (see Person Directory "Create Person") for face identification or
        verification.

        To deal with an image containing multiple faces, input face can be specified as an image with a
        targetFace rectangle. It returns a persistedFaceId representing the added face. No image will
        be stored. Only the extracted face feature(s) will be stored on server until Person Directory
        "Delete Person Face" or "Delete Person" is called.

        Note that persistedFaceId is different from faceId generated by "Detect".
        >
        *


        * Higher face image quality means better recognition precision. Please consider high-quality
        faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes) or bigger.
        * Each person entry can hold up to 248 faces.
        * JPEG, PNG, GIF (the first frame), and BMP format are supported. The allowed image file size
        is from 1KB to 6MB.
        * "targetFace" rectangle should contain one face. Zero or multiple faces will be regarded as an
        error. If the provided "targetFace" rectangle is not returned from "Detect", there's no
        guarantee to detect and add the face successfully.
        * Out of detectable face size (36x36 - 4096x4096 pixels), large head-pose, or large occlusions
        will cause failures.
        * The minimum detectable face size is 36x36 pixels in an image no larger than 1920x1080 pixels.
        Images with dimensions higher than 1920x1080 pixels will need a proportionally larger minimum
        face size.
        * Different 'detectionModel' values can be provided. To use and compare different detection
        models, please refer to
        https://learn.microsoft.com/azure/ai-services/computer-vision/how-to/specify-detection-model
          *
        * Adding/deleting faces to/from a same person will be processed sequentially. Adding/deleting
        faces to/from different persons are processed in parallel.
        * This is a long running operation. Use Response Header "Operation-Location" to determine when
        the AddFace operation has successfully propagated for future requests to "Identify". For
        further information about Operation-Locations see "Get Face Operation Status".

        :param person_id: Person ID of the person. Required.
        :type person_id: str
        :param recognition_model: The 'recognitionModel' associated with faces. Known values are:
         "recognition_01", "recognition_02", "recognition_03", and "recognition_04". Required.
        :type recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword url: URL of input image. Required.
        :paramtype url: str
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :return: An instance of AsyncLROPoller that returns AddFaceResult. The AddFaceResult is
         compatible with MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.ai.vision.face.models.AddFaceResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "url": "str"  # URL of input image. Required.
                }

                # response body for status code(s): 202
                response == {
                    "persistedFaceId": "str"  # Persisted Face ID of the added face, which is
                      persisted and will not expire. Different from faceId which is created in "Detect"
                      and will expire in 24 hours after the detection call. Required.
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AddFaceResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._add_person_face_from_url_initial(
                person_id=person_id,
                recognition_model=recognition_model,
                body=body,
                url=url,
                target_face=target_face,
                detection_model=detection_model,
                user_data=user_data,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["operation-Location"] = self._deserialize(
                "str", response.headers.get("operation-Location")
            )
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))

            deserialized = _deserialize(_models.AddFaceResult, response.json())
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.AddFaceResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.AddFaceResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _add_person_face_initial(
        self,
        person_id: str,
        recognition_model: Union[str, _models.FaceRecognitionModel],
        image_content: bytes,
        *,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> JSON:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop("content_type", _headers.pop("content-type", "application/octet-stream"))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _content = image_content

        _request = build_face_administration_add_person_face_request(
            person_id=person_id,
            recognition_model=recognition_model,
            target_face=target_face,
            detection_model=detection_model,
            user_data=user_data,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["operation-Location"] = self._deserialize("str", response.headers.get("operation-Location"))
        response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))

        deserialized = _deserialize(JSON, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_add_person_face(
        self,
        person_id: str,
        recognition_model: Union[str, _models.FaceRecognitionModel],
        image_content: bytes,
        *,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[_models.AddFaceResult]:
        # pylint: disable=line-too-long
        """Add a face to a person (see Person Directory "Create Person") for face identification or
        verification.

        To deal with an image containing multiple faces, input face can be specified as an image with a
        targetFace rectangle. It returns a persistedFaceId representing the added face. No image will
        be stored. Only the extracted face feature(s) will be stored on server until Person Directory
        "Delete Person Face" or "Delete Person" is called.

        Note that persistedFaceId is different from faceId generated by "Detect".
        >
        *


        * Higher face image quality means better recognition precision. Please consider high-quality
        faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes) or bigger.
        * Each person entry can hold up to 248 faces.
        * JPEG, PNG, GIF (the first frame), and BMP format are supported. The allowed image file size
        is from 1KB to 6MB.
        * "targetFace" rectangle should contain one face. Zero or multiple faces will be regarded as an
        error. If the provided "targetFace" rectangle is not returned from "Detect", there's no
        guarantee to detect and add the face successfully.
        * Out of detectable face size (36x36 - 4096x4096 pixels), large head-pose, or large occlusions
        will cause failures.
        * The minimum detectable face size is 36x36 pixels in an image no larger than 1920x1080 pixels.
        Images with dimensions higher than 1920x1080 pixels will need a proportionally larger minimum
        face size.
        * Different 'detectionModel' values can be provided. To use and compare different detection
        models, please refer to
        https://learn.microsoft.com/azure/ai-services/computer-vision/how-to/specify-detection-model
          *
        * Adding/deleting faces to/from a same person will be processed sequentially. Adding/deleting
        faces to/from different persons are processed in parallel.
        * This is a long running operation. Use Response Header "Operation-Location" to determine when
        the AddFace operation has successfully propagated for future requests to "Identify". For
        further information about Operation-Locations see "Get Face Operation Status".

        :param person_id: Person ID of the person. Required.
        :type person_id: str
        :param recognition_model: The 'recognitionModel' associated with faces. Known values are:
         "recognition_01", "recognition_02", "recognition_03", and "recognition_04". Required.
        :type recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :param image_content: The image to be analyzed. Required.
        :type image_content: bytes
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :return: An instance of AsyncLROPoller that returns AddFaceResult. The AddFaceResult is
         compatible with MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.ai.vision.face.models.AddFaceResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "persistedFaceId": "str"  # Persisted Face ID of the added face, which is
                      persisted and will not expire. Different from faceId which is created in "Detect"
                      and will expire in 24 hours after the detection call. Required.
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop("content_type", _headers.pop("content-type", "application/octet-stream"))
        cls: ClsType[_models.AddFaceResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._add_person_face_initial(
                person_id=person_id,
                recognition_model=recognition_model,
                image_content=image_content,
                target_face=target_face,
                detection_model=detection_model,
                user_data=user_data,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["operation-Location"] = self._deserialize(
                "str", response.headers.get("operation-Location")
            )
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))

            deserialized = _deserialize(_models.AddFaceResult, response.json())
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.AddFaceResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.AddFaceResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _delete_person_face_initial(  # pylint: disable=inconsistent-return-statements
        self,
        person_id: str,
        recognition_model: Union[str, _models.FaceRecognitionModel],
        persisted_face_id: str,
        **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_face_administration_delete_person_face_request(
            person_id=person_id,
            recognition_model=recognition_model,
            persisted_face_id=persisted_face_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["operation-Location"] = self._deserialize("str", response.headers.get("operation-Location"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace_async
    async def begin_delete_person_face(
        self,
        person_id: str,
        recognition_model: Union[str, _models.FaceRecognitionModel],
        persisted_face_id: str,
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Delete a face from a person in Person Directory by specified personId and persistedFaceId.

        Adding/deleting faces to/from a same person will be processed sequentially. Adding/deleting
        faces to/from different persons are processed in parallel.

        :param person_id: Person ID of the person. Required.
        :type person_id: str
        :param recognition_model: The 'recognitionModel' associated with faces. Known values are:
         "recognition_01", "recognition_02", "recognition_03", and "recognition_04". Required.
        :type recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_person_face_initial(  # type: ignore
                person_id=person_id,
                recognition_model=recognition_model,
                persisted_face_id=persisted_face_id,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def get_person_face(
        self,
        person_id: str,
        recognition_model: Union[str, _models.FaceRecognitionModel],
        persisted_face_id: str,
        **kwargs: Any
    ) -> _models.PersonDirectoryFace:
        """Retrieve person face information. The persisted person face is specified by its personId.
        recognitionModel, and persistedFaceId.

        :param person_id: Person ID of the person. Required.
        :type person_id: str
        :param recognition_model: The 'recognitionModel' associated with faces. Known values are:
         "recognition_01", "recognition_02", "recognition_03", and "recognition_04". Required.
        :type recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :return: PersonDirectoryFace. The PersonDirectoryFace is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.PersonDirectoryFace
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "persistedFaceId": "str",  # Face ID of the face. Required.
                    "userData": "str"  # Optional. User-provided data attached to the face. The
                      length limit is 1K.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.PersonDirectoryFace] = kwargs.pop("cls", None)

        _request = build_face_administration_get_person_face_request(
            person_id=person_id,
            recognition_model=recognition_model,
            persisted_face_id=persisted_face_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.PersonDirectoryFace, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_person_face(  # pylint: disable=inconsistent-return-statements
        self,
        person_id: str,
        recognition_model: Union[str, _models.FaceRecognitionModel],
        persisted_face_id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Update a persisted face's userData field of a person.

        :param person_id: Person ID of the person. Required.
        :type person_id: str
        :param recognition_model: The 'recognitionModel' associated with faces. Known values are:
         "recognition_01", "recognition_02", "recognition_03", and "recognition_04". Required.
        :type recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "userData": "str"  # Optional. User-provided data attached to the face. The
                      length limit is 1K.
                }
        """

    @overload
    async def update_person_face(  # pylint: disable=inconsistent-return-statements
        self,
        person_id: str,
        recognition_model: Union[str, _models.FaceRecognitionModel],
        persisted_face_id: str,
        *,
        content_type: str = "application/json",
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Update a persisted face's userData field of a person.

        :param person_id: Person ID of the person. Required.
        :type person_id: str
        :param recognition_model: The 'recognitionModel' associated with faces. Known values are:
         "recognition_01", "recognition_02", "recognition_03", and "recognition_04". Required.
        :type recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword user_data: User-provided data attached to the face. The length limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_person_face(  # pylint: disable=inconsistent-return-statements
        self,
        person_id: str,
        recognition_model: Union[str, _models.FaceRecognitionModel],
        persisted_face_id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Update a persisted face's userData field of a person.

        :param person_id: Person ID of the person. Required.
        :type person_id: str
        :param recognition_model: The 'recognitionModel' associated with faces. Known values are:
         "recognition_01", "recognition_02", "recognition_03", and "recognition_04". Required.
        :type recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_person_face(  # pylint: disable=inconsistent-return-statements
        self,
        person_id: str,
        recognition_model: Union[str, _models.FaceRecognitionModel],
        persisted_face_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Update a persisted face's userData field of a person.

        :param person_id: Person ID of the person. Required.
        :type person_id: str
        :param recognition_model: The 'recognitionModel' associated with faces. Known values are:
         "recognition_01", "recognition_02", "recognition_03", and "recognition_04". Required.
        :type recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword user_data: User-provided data attached to the face. The length limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "userData": "str"  # Optional. User-provided data attached to the face. The
                      length limit is 1K.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        if body is _Unset:
            body = {"userdata": user_data}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_administration_update_person_face_request(
            person_id=person_id,
            recognition_model=recognition_model,
            persisted_face_id=persisted_face_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_person_faces(
        self, person_id: str, recognition_model: Union[str, _models.FaceRecognitionModel], **kwargs: Any
    ) -> _models.ListFaceResult:
        """Retrieve a person's persistedFaceIds representing the registered person face feature(s).

        :param person_id: Person ID of the person. Required.
        :type person_id: str
        :param recognition_model: The 'recognitionModel' associated with faces. Known values are:
         "recognition_01", "recognition_02", "recognition_03", and "recognition_04". Required.
        :type recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :return: ListFaceResult. The ListFaceResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.ListFaceResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "persistedFaceIds": [
                        "str"  # Array of persisted face ids. Required.
                    ],
                    "personId": "str"  # Id of person. Required.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.ListFaceResult] = kwargs.pop("cls", None)

        _request = build_face_administration_get_person_faces_request(
            person_id=person_id,
            recognition_model=recognition_model,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.ListFaceResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_dynamic_person_group_with_person_initial(  # pylint: disable=inconsistent-return-statements,name-too-long
        self,
        dynamic_person_group_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        name: str = _Unset,
        add_person_ids: List[str] = _Unset,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        if body is _Unset:
            if name is _Unset:
                raise TypeError("missing required argument: name")
            if add_person_ids is _Unset:
                raise TypeError("missing required argument: add_person_ids")
            body = {"addpersonids": add_person_ids, "name": name, "userdata": user_data}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_administration_create_dynamic_person_group_with_person_request(
            dynamic_person_group_id=dynamic_person_group_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["operation-Location"] = self._deserialize("str", response.headers.get("operation-Location"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @overload
    async def begin_create_dynamic_person_group_with_person(  # pylint: disable=name-too-long
        self, dynamic_person_group_id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[_models.DynamicPersonGroup]:
        """Creates a new Dynamic Person Group with specified dynamicPersonGroupId, name, and user-provided
        userData.

        A Dynamic Person Group is a container that references Person Directory "Create Person". After
        creation, use Person Directory "Update Dynamic Person Group" to add/remove persons to/from the
        Dynamic Person Group.

        Dynamic Person Group and user data will be stored on server until Person Directory "Delete
        Dynamic Person Group" is called. Use "Identify From Dynamic Person Group" with the
        dynamicPersonGroupId parameter to identify against persons.

        No image will be stored. Only the person's extracted face feature(s) and userData will be
        stored on server until Person Directory "Delete Person" or "Delete Person Face" is called.

        'recognitionModel' does not need to be specified with Dynamic Person Groups. Dynamic Person
        Groups are references to Person Directory "Create Person" and therefore work with most all
        'recognitionModels'. The faceId's provided during "Identify" determine the 'recognitionModel'
        used.

        :param dynamic_person_group_id: ID of the dynamic person group. Required.
        :type dynamic_person_group_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns DynamicPersonGroup. The DynamicPersonGroup
         is compatible with MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.ai.vision.face.models.DynamicPersonGroup]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "addPersonIds": [
                        "str"  # Array of personIds created by Person Directory "Create
                          Person" to be added. Required.
                    ],
                    "name": "str",  # User defined name, maximum length is 128. Required.
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }

                # response body for status code(s): 202
                response == {
                    "dynamicPersonGroupId": "str",  # ID of the dynamic person group. Required.
                    "name": "str",  # User defined name, maximum length is 128. Required.
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """

    @overload
    async def begin_create_dynamic_person_group_with_person(  # pylint: disable=name-too-long
        self,
        dynamic_person_group_id: str,
        *,
        name: str,
        add_person_ids: List[str],
        content_type: str = "application/json",
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[_models.DynamicPersonGroup]:
        """Creates a new Dynamic Person Group with specified dynamicPersonGroupId, name, and user-provided
        userData.

        A Dynamic Person Group is a container that references Person Directory "Create Person". After
        creation, use Person Directory "Update Dynamic Person Group" to add/remove persons to/from the
        Dynamic Person Group.

        Dynamic Person Group and user data will be stored on server until Person Directory "Delete
        Dynamic Person Group" is called. Use "Identify From Dynamic Person Group" with the
        dynamicPersonGroupId parameter to identify against persons.

        No image will be stored. Only the person's extracted face feature(s) and userData will be
        stored on server until Person Directory "Delete Person" or "Delete Person Face" is called.

        'recognitionModel' does not need to be specified with Dynamic Person Groups. Dynamic Person
        Groups are references to Person Directory "Create Person" and therefore work with most all
        'recognitionModels'. The faceId's provided during "Identify" determine the 'recognitionModel'
        used.

        :param dynamic_person_group_id: ID of the dynamic person group. Required.
        :type dynamic_person_group_id: str
        :keyword name: User defined name, maximum length is 128. Required.
        :paramtype name: str
        :keyword add_person_ids: Array of personIds created by Person Directory "Create Person" to be
         added. Required.
        :paramtype add_person_ids: list[str]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: An instance of AsyncLROPoller that returns DynamicPersonGroup. The DynamicPersonGroup
         is compatible with MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.ai.vision.face.models.DynamicPersonGroup]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "dynamicPersonGroupId": "str",  # ID of the dynamic person group. Required.
                    "name": "str",  # User defined name, maximum length is 128. Required.
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """

    @overload
    async def begin_create_dynamic_person_group_with_person(  # pylint: disable=name-too-long
        self, dynamic_person_group_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[_models.DynamicPersonGroup]:
        """Creates a new Dynamic Person Group with specified dynamicPersonGroupId, name, and user-provided
        userData.

        A Dynamic Person Group is a container that references Person Directory "Create Person". After
        creation, use Person Directory "Update Dynamic Person Group" to add/remove persons to/from the
        Dynamic Person Group.

        Dynamic Person Group and user data will be stored on server until Person Directory "Delete
        Dynamic Person Group" is called. Use "Identify From Dynamic Person Group" with the
        dynamicPersonGroupId parameter to identify against persons.

        No image will be stored. Only the person's extracted face feature(s) and userData will be
        stored on server until Person Directory "Delete Person" or "Delete Person Face" is called.

        'recognitionModel' does not need to be specified with Dynamic Person Groups. Dynamic Person
        Groups are references to Person Directory "Create Person" and therefore work with most all
        'recognitionModels'. The faceId's provided during "Identify" determine the 'recognitionModel'
        used.

        :param dynamic_person_group_id: ID of the dynamic person group. Required.
        :type dynamic_person_group_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns DynamicPersonGroup. The DynamicPersonGroup
         is compatible with MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.ai.vision.face.models.DynamicPersonGroup]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "dynamicPersonGroupId": "str",  # ID of the dynamic person group. Required.
                    "name": "str",  # User defined name, maximum length is 128. Required.
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """

    @distributed_trace_async
    async def begin_create_dynamic_person_group_with_person(  # pylint: disable=name-too-long
        self,
        dynamic_person_group_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        name: str = _Unset,
        add_person_ids: List[str] = _Unset,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[_models.DynamicPersonGroup]:
        """Creates a new Dynamic Person Group with specified dynamicPersonGroupId, name, and user-provided
        userData.

        A Dynamic Person Group is a container that references Person Directory "Create Person". After
        creation, use Person Directory "Update Dynamic Person Group" to add/remove persons to/from the
        Dynamic Person Group.

        Dynamic Person Group and user data will be stored on server until Person Directory "Delete
        Dynamic Person Group" is called. Use "Identify From Dynamic Person Group" with the
        dynamicPersonGroupId parameter to identify against persons.

        No image will be stored. Only the person's extracted face feature(s) and userData will be
        stored on server until Person Directory "Delete Person" or "Delete Person Face" is called.

        'recognitionModel' does not need to be specified with Dynamic Person Groups. Dynamic Person
        Groups are references to Person Directory "Create Person" and therefore work with most all
        'recognitionModels'. The faceId's provided during "Identify" determine the 'recognitionModel'
        used.

        :param dynamic_person_group_id: ID of the dynamic person group. Required.
        :type dynamic_person_group_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword name: User defined name, maximum length is 128. Required.
        :paramtype name: str
        :keyword add_person_ids: Array of personIds created by Person Directory "Create Person" to be
         added. Required.
        :paramtype add_person_ids: list[str]
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: An instance of AsyncLROPoller that returns DynamicPersonGroup. The DynamicPersonGroup
         is compatible with MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.ai.vision.face.models.DynamicPersonGroup]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "addPersonIds": [
                        "str"  # Array of personIds created by Person Directory "Create
                          Person" to be added. Required.
                    ],
                    "name": "str",  # User defined name, maximum length is 128. Required.
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }

                # response body for status code(s): 202
                response == {
                    "dynamicPersonGroupId": "str",  # ID of the dynamic person group. Required.
                    "name": "str",  # User defined name, maximum length is 128. Required.
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DynamicPersonGroup] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_dynamic_person_group_with_person_initial(  # type: ignore
                dynamic_person_group_id=dynamic_person_group_id,
                body=body,
                name=name,
                add_person_ids=add_person_ids,
                user_data=user_data,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["operation-Location"] = self._deserialize(
                "str", response.headers.get("operation-Location")
            )

            deserialized = _deserialize(_models.DynamicPersonGroup, response.json())
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.DynamicPersonGroup].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.DynamicPersonGroup](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @overload
    async def create_dynamic_person_group(  # pylint: disable=inconsistent-return-statements
        self, dynamic_person_group_id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Creates a new Dynamic Person Group with specified dynamicPersonGroupId, name, and user-provided
        userData.

        A Dynamic Person Group is a container that references Person Directory "Create Person". After
        creation, use Person Directory "Update Dynamic Person Group" to add/remove persons to/from the
        Dynamic Person Group.

        Dynamic Person Group and user data will be stored on server until Person Directory "Delete
        Dynamic Person Group" is called. Use "Identify From Dynamic Person Group" with the
        dynamicPersonGroupId parameter to identify against persons.

        No image will be stored. Only the person's extracted face feature(s) and userData will be
        stored on server until Person Directory "Delete Person" or "Delete Person Face" is called.

        'recognitionModel' does not need to be specified with Dynamic Person Groups. Dynamic Person
        Groups are references to Person Directory "Create Person" and therefore work with most all
        'recognitionModels'. The faceId's provided during "Identify" determine the 'recognitionModel'
        used.

        :param dynamic_person_group_id: ID of the dynamic person group. Required.
        :type dynamic_person_group_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # User defined name, maximum length is 128. Required.
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """

    @overload
    async def create_dynamic_person_group(  # pylint: disable=inconsistent-return-statements
        self,
        dynamic_person_group_id: str,
        *,
        name: str,
        content_type: str = "application/json",
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Creates a new Dynamic Person Group with specified dynamicPersonGroupId, name, and user-provided
        userData.

        A Dynamic Person Group is a container that references Person Directory "Create Person". After
        creation, use Person Directory "Update Dynamic Person Group" to add/remove persons to/from the
        Dynamic Person Group.

        Dynamic Person Group and user data will be stored on server until Person Directory "Delete
        Dynamic Person Group" is called. Use "Identify From Dynamic Person Group" with the
        dynamicPersonGroupId parameter to identify against persons.

        No image will be stored. Only the person's extracted face feature(s) and userData will be
        stored on server until Person Directory "Delete Person" or "Delete Person Face" is called.

        'recognitionModel' does not need to be specified with Dynamic Person Groups. Dynamic Person
        Groups are references to Person Directory "Create Person" and therefore work with most all
        'recognitionModels'. The faceId's provided during "Identify" determine the 'recognitionModel'
        used.

        :param dynamic_person_group_id: ID of the dynamic person group. Required.
        :type dynamic_person_group_id: str
        :keyword name: User defined name, maximum length is 128. Required.
        :paramtype name: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_dynamic_person_group(  # pylint: disable=inconsistent-return-statements
        self, dynamic_person_group_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Creates a new Dynamic Person Group with specified dynamicPersonGroupId, name, and user-provided
        userData.

        A Dynamic Person Group is a container that references Person Directory "Create Person". After
        creation, use Person Directory "Update Dynamic Person Group" to add/remove persons to/from the
        Dynamic Person Group.

        Dynamic Person Group and user data will be stored on server until Person Directory "Delete
        Dynamic Person Group" is called. Use "Identify From Dynamic Person Group" with the
        dynamicPersonGroupId parameter to identify against persons.

        No image will be stored. Only the person's extracted face feature(s) and userData will be
        stored on server until Person Directory "Delete Person" or "Delete Person Face" is called.

        'recognitionModel' does not need to be specified with Dynamic Person Groups. Dynamic Person
        Groups are references to Person Directory "Create Person" and therefore work with most all
        'recognitionModels'. The faceId's provided during "Identify" determine the 'recognitionModel'
        used.

        :param dynamic_person_group_id: ID of the dynamic person group. Required.
        :type dynamic_person_group_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_dynamic_person_group(  # pylint: disable=inconsistent-return-statements
        self,
        dynamic_person_group_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        name: str = _Unset,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Creates a new Dynamic Person Group with specified dynamicPersonGroupId, name, and user-provided
        userData.

        A Dynamic Person Group is a container that references Person Directory "Create Person". After
        creation, use Person Directory "Update Dynamic Person Group" to add/remove persons to/from the
        Dynamic Person Group.

        Dynamic Person Group and user data will be stored on server until Person Directory "Delete
        Dynamic Person Group" is called. Use "Identify From Dynamic Person Group" with the
        dynamicPersonGroupId parameter to identify against persons.

        No image will be stored. Only the person's extracted face feature(s) and userData will be
        stored on server until Person Directory "Delete Person" or "Delete Person Face" is called.

        'recognitionModel' does not need to be specified with Dynamic Person Groups. Dynamic Person
        Groups are references to Person Directory "Create Person" and therefore work with most all
        'recognitionModels'. The faceId's provided during "Identify" determine the 'recognitionModel'
        used.

        :param dynamic_person_group_id: ID of the dynamic person group. Required.
        :type dynamic_person_group_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword name: User defined name, maximum length is 128. Required.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # User defined name, maximum length is 128. Required.
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        if body is _Unset:
            if name is _Unset:
                raise TypeError("missing required argument: name")
            body = {"name": name, "userdata": user_data}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_administration_create_dynamic_person_group_request(
            dynamic_person_group_id=dynamic_person_group_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    async def _delete_dynamic_person_group_initial(  # pylint: disable=inconsistent-return-statements
        self, dynamic_person_group_id: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_face_administration_delete_dynamic_person_group_request(
            dynamic_person_group_id=dynamic_person_group_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["operation-Location"] = self._deserialize("str", response.headers.get("operation-Location"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace_async
    async def begin_delete_dynamic_person_group(
        self, dynamic_person_group_id: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes an existing Dynamic Person Group with specified dynamicPersonGroupId.

        Deleting this Dynamic Person Group only delete the references to persons data. To delete actual
        person see Person Directory "Delete Person".

        :param dynamic_person_group_id: ID of the dynamic person group. Required.
        :type dynamic_person_group_id: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_dynamic_person_group_initial(  # type: ignore
                dynamic_person_group_id=dynamic_person_group_id,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def get_dynamic_person_group(self, dynamic_person_group_id: str, **kwargs: Any) -> _models.DynamicPersonGroup:
        """Retrieve the information of a Dynamic Person Group, including its name and userData.

        This API returns Dynamic Person Group information only, use Person Directory "Get Dynamic
        Person Group Persons" instead to retrieve person information under the Dynamic Person Group.

        :param dynamic_person_group_id: ID of the dynamic person group. Required.
        :type dynamic_person_group_id: str
        :return: DynamicPersonGroup. The DynamicPersonGroup is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.DynamicPersonGroup
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "dynamicPersonGroupId": "str",  # ID of the dynamic person group. Required.
                    "name": "str",  # User defined name, maximum length is 128. Required.
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.DynamicPersonGroup] = kwargs.pop("cls", None)

        _request = build_face_administration_get_dynamic_person_group_request(
            dynamic_person_group_id=dynamic_person_group_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.DynamicPersonGroup, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _update_dynamic_person_group_with_person_changes_initial(  # pylint: disable=inconsistent-return-statements,name-too-long
        self,
        dynamic_person_group_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        name: Optional[str] = None,
        user_data: Optional[str] = None,
        add_person_ids: Optional[List[str]] = None,
        remove_person_ids: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        if body is _Unset:
            body = {
                "addpersonids": add_person_ids,
                "name": name,
                "removepersonids": remove_person_ids,
                "userdata": user_data,
            }
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_administration_update_dynamic_person_group_with_person_changes_request(
            dynamic_person_group_id=dynamic_person_group_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["operation-Location"] = self._deserialize("str", response.headers.get("operation-Location"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @overload
    async def begin_update_dynamic_person_group_with_person_changes(  # pylint: disable=name-too-long
        self, dynamic_person_group_id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Update the name or userData of an existing Dynamic Person Group, and manage its members by
        adding or removing persons.

        The properties keep unchanged if they are not in request body.

        :param dynamic_person_group_id: ID of the dynamic person group. Required.
        :type dynamic_person_group_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "addPersonIds": [
                        "str"  # Optional. Array of personIds created by Person Directory
                          "Create Person" to be added.
                    ],
                    "name": "str",  # Optional. User defined name, maximum length is 128.
                    "removePersonIds": [
                        "str"  # Optional. Array of personIds created by Person Directory
                          "Create Person" to be removed.
                    ],
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """

    @overload
    async def begin_update_dynamic_person_group_with_person_changes(  # pylint: disable=name-too-long
        self,
        dynamic_person_group_id: str,
        *,
        content_type: str = "application/json",
        name: Optional[str] = None,
        user_data: Optional[str] = None,
        add_person_ids: Optional[List[str]] = None,
        remove_person_ids: Optional[List[str]] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Update the name or userData of an existing Dynamic Person Group, and manage its members by
        adding or removing persons.

        The properties keep unchanged if they are not in request body.

        :param dynamic_person_group_id: ID of the dynamic person group. Required.
        :type dynamic_person_group_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword name: User defined name, maximum length is 128. Default value is None.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :keyword add_person_ids: Array of personIds created by Person Directory "Create Person" to be
         added. Default value is None.
        :paramtype add_person_ids: list[str]
        :keyword remove_person_ids: Array of personIds created by Person Directory "Create Person" to
         be removed. Default value is None.
        :paramtype remove_person_ids: list[str]
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_update_dynamic_person_group_with_person_changes(  # pylint: disable=name-too-long
        self, dynamic_person_group_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Update the name or userData of an existing Dynamic Person Group, and manage its members by
        adding or removing persons.

        The properties keep unchanged if they are not in request body.

        :param dynamic_person_group_id: ID of the dynamic person group. Required.
        :type dynamic_person_group_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_update_dynamic_person_group_with_person_changes(  # pylint: disable=name-too-long
        self,
        dynamic_person_group_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        name: Optional[str] = None,
        user_data: Optional[str] = None,
        add_person_ids: Optional[List[str]] = None,
        remove_person_ids: Optional[List[str]] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Update the name or userData of an existing Dynamic Person Group, and manage its members by
        adding or removing persons.

        The properties keep unchanged if they are not in request body.

        :param dynamic_person_group_id: ID of the dynamic person group. Required.
        :type dynamic_person_group_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword name: User defined name, maximum length is 128. Default value is None.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :keyword add_person_ids: Array of personIds created by Person Directory "Create Person" to be
         added. Default value is None.
        :paramtype add_person_ids: list[str]
        :keyword remove_person_ids: Array of personIds created by Person Directory "Create Person" to
         be removed. Default value is None.
        :paramtype remove_person_ids: list[str]
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "addPersonIds": [
                        "str"  # Optional. Array of personIds created by Person Directory
                          "Create Person" to be added.
                    ],
                    "name": "str",  # Optional. User defined name, maximum length is 128.
                    "removePersonIds": [
                        "str"  # Optional. Array of personIds created by Person Directory
                          "Create Person" to be removed.
                    ],
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._update_dynamic_person_group_with_person_changes_initial(  # type: ignore
                dynamic_person_group_id=dynamic_person_group_id,
                body=body,
                name=name,
                user_data=user_data,
                add_person_ids=add_person_ids,
                remove_person_ids=remove_person_ids,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @overload
    async def update_dynamic_person_group(  # pylint: disable=inconsistent-return-statements
        self, dynamic_person_group_id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Update the name or userData of an existing Dynamic Person Group, and manage its members by
        adding or removing persons.

        The properties keep unchanged if they are not in request body.

        :param dynamic_person_group_id: ID of the dynamic person group. Required.
        :type dynamic_person_group_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # Optional. User defined name, maximum length is 128.
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """

    @overload
    async def update_dynamic_person_group(  # pylint: disable=inconsistent-return-statements
        self,
        dynamic_person_group_id: str,
        *,
        content_type: str = "application/json",
        name: Optional[str] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Update the name or userData of an existing Dynamic Person Group, and manage its members by
        adding or removing persons.

        The properties keep unchanged if they are not in request body.

        :param dynamic_person_group_id: ID of the dynamic person group. Required.
        :type dynamic_person_group_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword name: User defined name, maximum length is 128. Default value is None.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_dynamic_person_group(  # pylint: disable=inconsistent-return-statements
        self, dynamic_person_group_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Update the name or userData of an existing Dynamic Person Group, and manage its members by
        adding or removing persons.

        The properties keep unchanged if they are not in request body.

        :param dynamic_person_group_id: ID of the dynamic person group. Required.
        :type dynamic_person_group_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_dynamic_person_group(  # pylint: disable=inconsistent-return-statements
        self,
        dynamic_person_group_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        name: Optional[str] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Update the name or userData of an existing Dynamic Person Group, and manage its members by
        adding or removing persons.

        The properties keep unchanged if they are not in request body.

        :param dynamic_person_group_id: ID of the dynamic person group. Required.
        :type dynamic_person_group_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword name: User defined name, maximum length is 128. Default value is None.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # Optional. User defined name, maximum length is 128.
                    "userData": "str"  # Optional. Optional user defined data. Length should not
                      exceed 16K.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        if body is _Unset:
            body = {"name": name, "userdata": user_data}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_administration_update_dynamic_person_group_request(
            dynamic_person_group_id=dynamic_person_group_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_dynamic_person_groups(
        self, *, start: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
    ) -> List[_models.DynamicPersonGroup]:
        """List all existing Dynamic Person Groups by dynamicPersonGroupId along with name and userData.

        Dynamic Person Groups are stored in alphabetical order of dynamicPersonGroupId.
        >
        *


        * "start" parameter (string, optional) specifies an ID value from which returned entries will
        have larger IDs based on string comparison. Setting "start" to an empty value indicates that
        entries should be returned starting from the first item.
        * "top" parameter (int, optional) determines the maximum number of entries to be returned, with
        a limit of up to 1000 entries per call. To retrieve additional entries beyond this limit,
        specify "start" with the personId of the last entry returned in the current call.

        ..

           [!TIP]


           * For example, there are total 5 items with their IDs: "itemId1", ..., "itemId5".

             * "start=&top=" will return all 5 items.
             * "start=&top=2" will return "itemId1", "itemId2".
             * "start=itemId2&top=3" will return "itemId3", "itemId4", "itemId5".

        :keyword start: List resources greater than the "start". It contains no more than 64
         characters. Default is empty. Default value is None.
        :paramtype start: str
        :keyword top: The number of items to list, ranging in [1, 1000]. Default is 1000. Default value
         is None.
        :paramtype top: int
        :return: list of DynamicPersonGroup
        :rtype: list[~azure.ai.vision.face.models.DynamicPersonGroup]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "dynamicPersonGroupId": "str",  # ID of the dynamic person group.
                          Required.
                        "name": "str",  # User defined name, maximum length is 128. Required.
                        "userData": "str"  # Optional. Optional user defined data. Length
                          should not exceed 16K.
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.DynamicPersonGroup]] = kwargs.pop("cls", None)

        _request = build_face_administration_get_dynamic_person_groups_request(
            start=start,
            top=top,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.DynamicPersonGroup], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_dynamic_person_group_persons(
        self, dynamic_person_group_id: str, *, start: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
    ) -> _models.ListPersonResult:
        """List all persons in the specified Dynamic Person Group.

        Persons are stored in alphabetical order of personId created in Person Directory "Create
        Person".
        >
        *


        * "start" parameter (string, optional) specifies an ID value from which returned entries will
        have larger IDs based on string comparison. Setting "start" to an empty value indicates that
        entries should be returned starting from the first item.
        * "top" parameter (int, optional) determines the maximum number of entries to be returned, with
        a limit of up to 1000 entries per call. To retrieve additional entries beyond this limit,
        specify "start" with the personId of the last entry returned in the current call.

        ..

           [!TIP]


           * For example, there are total 5 items with their IDs: "itemId1", ..., "itemId5".

             * "start=&top=" will return all 5 items.
             * "start=&top=2" will return "itemId1", "itemId2".
             * "start=itemId2&top=3" will return "itemId3", "itemId4", "itemId5".

        :param dynamic_person_group_id: ID of the dynamic person group. Required.
        :type dynamic_person_group_id: str
        :keyword start: List resources greater than the "start". It contains no more than 64
         characters. Default is empty. Default value is None.
        :paramtype start: str
        :keyword top: The number of items to list, ranging in [1, 1000]. Default is 1000. Default value
         is None.
        :paramtype top: int
        :return: ListPersonResult. The ListPersonResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.ListPersonResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "personIds": [
                        "str"  # Array of PersonDirectory Person ids. Required.
                    ]
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.ListPersonResult] = kwargs.pop("cls", None)

        _request = build_face_administration_get_dynamic_person_group_persons_request(
            dynamic_person_group_id=dynamic_person_group_id,
            start=start,
            top=top,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.ListPersonResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class FaceSessionClientOperationsMixin(FaceSessionClientMixinABC):

    @overload
    async def create_liveness_session(
        self, body: _models.CreateLivenessSessionContent, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CreateLivenessSessionResult:
        # pylint: disable=line-too-long
        """Create a new detect liveness session.

        A session is best for client device scenarios where developers want to authorize a client
        device to perform only a liveness detection without granting full access to their resource.
        Created sessions have a limited life span and only authorize clients to perform the desired
        action before access is expired.

        Permissions includes...
        >
        *


        * Ability to call /detectLiveness/singleModal for up to 3 retries.
        * A token lifetime of 10 minutes.

        ..

           [!NOTE]
           Client access can be revoked by deleting the session using the Delete Liveness Session
        operation. To retrieve a result, use the Get Liveness Session. To audit the individual requests
        that a client has made to your resource, use the List Liveness Session Audit Entries.

        :param body: Required.
        :type body: ~azure.ai.vision.face.models.CreateLivenessSessionContent
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CreateLivenessSessionResult. The CreateLivenessSessionResult is compatible with
         MutableMapping
        :rtype: ~azure.ai.vision.face.models.CreateLivenessSessionResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "livenessOperationMode": "str",  # Type of liveness mode the client should
                      follow. Required. Known values are: "Passive" and "PassiveActive".
                    "authTokenTimeToLiveInSeconds": 0,  # Optional. Seconds the session should
                      last for. Range is 60 to 86400 seconds. Default value is 600.
                    "deviceCorrelationId": "str",  # Optional. Unique Guid per each end-user
                      device. This is to provide rate limiting and anti-hammering. If
                      'deviceCorrelationIdSetInClient' is true in this request, this
                      'deviceCorrelationId' must be null.
                    "deviceCorrelationIdSetInClient": bool,  # Optional. Whether or not to allow
                      client to set their own 'deviceCorrelationId' via the Vision SDK. Default is
                      false, and 'deviceCorrelationId' must be set in this request body.
                    "sendResultsToClient": bool  # Optional. Whether or not to allow a '200 -
                      Success' response body to be sent to the client, which may be undesirable for
                      security reasons. Default is false, clients will receive a '204 - NoContent'
                      empty body response. Regardless of selection, calling Session GetResult will
                      always contain a response body enabling business logic to be implemented.
                }

                # response body for status code(s): 200
                response == {
                    "authToken": "str",  # Bearer token to provide authentication for the Vision
                      SDK running on a client application. This Bearer token has limited permissions to
                      perform only the required action and expires after the TTL time. It is also
                      auditable. Required.
                    "sessionId": "str"  # The unique session ID of the created session. It will
                      expire 48 hours after it was created or may be deleted sooner using the
                      corresponding Session DELETE operation. Required.
                }
        """

    @overload
    async def create_liveness_session(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CreateLivenessSessionResult:
        # pylint: disable=line-too-long
        """Create a new detect liveness session.

        A session is best for client device scenarios where developers want to authorize a client
        device to perform only a liveness detection without granting full access to their resource.
        Created sessions have a limited life span and only authorize clients to perform the desired
        action before access is expired.

        Permissions includes...
        >
        *


        * Ability to call /detectLiveness/singleModal for up to 3 retries.
        * A token lifetime of 10 minutes.

        ..

           [!NOTE]
           Client access can be revoked by deleting the session using the Delete Liveness Session
        operation. To retrieve a result, use the Get Liveness Session. To audit the individual requests
        that a client has made to your resource, use the List Liveness Session Audit Entries.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CreateLivenessSessionResult. The CreateLivenessSessionResult is compatible with
         MutableMapping
        :rtype: ~azure.ai.vision.face.models.CreateLivenessSessionResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "authToken": "str",  # Bearer token to provide authentication for the Vision
                      SDK running on a client application. This Bearer token has limited permissions to
                      perform only the required action and expires after the TTL time. It is also
                      auditable. Required.
                    "sessionId": "str"  # The unique session ID of the created session. It will
                      expire 48 hours after it was created or may be deleted sooner using the
                      corresponding Session DELETE operation. Required.
                }
        """

    @overload
    async def create_liveness_session(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CreateLivenessSessionResult:
        # pylint: disable=line-too-long
        """Create a new detect liveness session.

        A session is best for client device scenarios where developers want to authorize a client
        device to perform only a liveness detection without granting full access to their resource.
        Created sessions have a limited life span and only authorize clients to perform the desired
        action before access is expired.

        Permissions includes...
        >
        *


        * Ability to call /detectLiveness/singleModal for up to 3 retries.
        * A token lifetime of 10 minutes.

        ..

           [!NOTE]
           Client access can be revoked by deleting the session using the Delete Liveness Session
        operation. To retrieve a result, use the Get Liveness Session. To audit the individual requests
        that a client has made to your resource, use the List Liveness Session Audit Entries.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CreateLivenessSessionResult. The CreateLivenessSessionResult is compatible with
         MutableMapping
        :rtype: ~azure.ai.vision.face.models.CreateLivenessSessionResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "authToken": "str",  # Bearer token to provide authentication for the Vision
                      SDK running on a client application. This Bearer token has limited permissions to
                      perform only the required action and expires after the TTL time. It is also
                      auditable. Required.
                    "sessionId": "str"  # The unique session ID of the created session. It will
                      expire 48 hours after it was created or may be deleted sooner using the
                      corresponding Session DELETE operation. Required.
                }
        """

    @distributed_trace_async
    async def create_liveness_session(
        self, body: Union[_models.CreateLivenessSessionContent, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.CreateLivenessSessionResult:
        # pylint: disable=line-too-long
        """Create a new detect liveness session.

        A session is best for client device scenarios where developers want to authorize a client
        device to perform only a liveness detection without granting full access to their resource.
        Created sessions have a limited life span and only authorize clients to perform the desired
        action before access is expired.

        Permissions includes...
        >
        *


        * Ability to call /detectLiveness/singleModal for up to 3 retries.
        * A token lifetime of 10 minutes.

        ..

           [!NOTE]
           Client access can be revoked by deleting the session using the Delete Liveness Session
        operation. To retrieve a result, use the Get Liveness Session. To audit the individual requests
        that a client has made to your resource, use the List Liveness Session Audit Entries.

        :param body: Is one of the following types: CreateLivenessSessionContent, JSON, IO[bytes]
         Required.
        :type body: ~azure.ai.vision.face.models.CreateLivenessSessionContent or JSON or IO[bytes]
        :return: CreateLivenessSessionResult. The CreateLivenessSessionResult is compatible with
         MutableMapping
        :rtype: ~azure.ai.vision.face.models.CreateLivenessSessionResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "livenessOperationMode": "str",  # Type of liveness mode the client should
                      follow. Required. Known values are: "Passive" and "PassiveActive".
                    "authTokenTimeToLiveInSeconds": 0,  # Optional. Seconds the session should
                      last for. Range is 60 to 86400 seconds. Default value is 600.
                    "deviceCorrelationId": "str",  # Optional. Unique Guid per each end-user
                      device. This is to provide rate limiting and anti-hammering. If
                      'deviceCorrelationIdSetInClient' is true in this request, this
                      'deviceCorrelationId' must be null.
                    "deviceCorrelationIdSetInClient": bool,  # Optional. Whether or not to allow
                      client to set their own 'deviceCorrelationId' via the Vision SDK. Default is
                      false, and 'deviceCorrelationId' must be set in this request body.
                    "sendResultsToClient": bool  # Optional. Whether or not to allow a '200 -
                      Success' response body to be sent to the client, which may be undesirable for
                      security reasons. Default is false, clients will receive a '204 - NoContent'
                      empty body response. Regardless of selection, calling Session GetResult will
                      always contain a response body enabling business logic to be implemented.
                }

                # response body for status code(s): 200
                response == {
                    "authToken": "str",  # Bearer token to provide authentication for the Vision
                      SDK running on a client application. This Bearer token has limited permissions to
                      perform only the required action and expires after the TTL time. It is also
                      auditable. Required.
                    "sessionId": "str"  # The unique session ID of the created session. It will
                      expire 48 hours after it was created or may be deleted sooner using the
                      corresponding Session DELETE operation. Required.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CreateLivenessSessionResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_session_create_liveness_session_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CreateLivenessSessionResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_liveness_session(  # pylint: disable=inconsistent-return-statements
        self, session_id: str, **kwargs: Any
    ) -> None:
        """Delete all session related information for matching the specified session id.

        ..

           [!NOTE]
           Deleting a session deactivates the Session Auth Token by blocking future API calls made with
        that Auth Token. While this can be used to remove any access for that token, those requests
        will still count towards overall resource rate limits. It's best to leverage TokenTTL to limit
        length of tokens in the case that it is misused.

        :param session_id: The unique ID to reference this session. Required.
        :type session_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_face_session_delete_liveness_session_request(
            session_id=session_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_liveness_session_result(self, session_id: str, **kwargs: Any) -> _models.LivenessSession:
        # pylint: disable=line-too-long
        """Get session result of detectLiveness/singleModal call.

        :param session_id: The unique ID to reference this session. Required.
        :type session_id: str
        :return: LivenessSession. The LivenessSession is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.LivenessSession
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # DateTime when this session was
                      created. Required.
                    "id": "str",  # The unique ID to reference this session. Required.
                    "sessionExpired": bool,  # Whether or not the session is expired. Required.
                    "status": "str",  # The current status of the session. Required. Known values
                      are: "NotStarted", "Started", and "ResultAvailable".
                    "authTokenTimeToLiveInSeconds": 0,  # Optional. Seconds the session should
                      last for. Range is 60 to 86400 seconds. Default value is 600.
                    "deviceCorrelationId": "str",  # Optional. Unique Guid per each end-user
                      device. This is to provide rate limiting and anti-hammering. If
                      'deviceCorrelationIdSetInClient' is true in this request, this
                      'deviceCorrelationId' must be null.
                    "result": {
                        "clientRequestId": "str",  # The unique clientRequestId that is sent
                          by the client in the 'client-request-id' header. Required.
                        "digest": "str",  # The server calculated digest for this request. If
                          the client reported digest differs from the server calculated digest, then
                          the message integrity between the client and service has been compromised and
                          the result should not be trusted. For more information, see how to guides on
                          how to leverage this value to secure your end-to-end solution. Required.
                        "id": 0,  # The unique id to refer to this audit request. Use this id
                          with the 'start' query parameter to continue on to the next page of audit
                          results. Required.
                        "receivedDateTime": "2020-02-20 00:00:00",  # The UTC DateTime that
                          the request was received. Required.
                        "request": {
                            "contentType": "str",  # The content type of the request.
                              Required.
                            "method": "str",  # The HTTP method of the request (i.e.,
                              GET, POST, DELETE). Required.
                            "url": "str",  # The relative URL and query of the liveness
                              request. Required.
                            "contentLength": 0,  # Optional. The length of the request
                              body in bytes.
                            "userAgent": "str"  # Optional. The user agent used to submit
                              the request.
                        },
                        "requestId": "str",  # The unique requestId that is returned by the
                          service to the client in the 'apim-request-id' header. Required.
                        "response": {
                            "body": {
                                "livenessDecision": "str",  # Optional. The liveness
                                  classification for the target face. Known values are: "uncertain",
                                  "realface", and "spoofface".
                                "modelVersionUsed": "str",  # Optional. The model
                                  version used for liveness classification. Known values are:
                                  "2020-02-15-preview.01", "2021-11-12-preview.03",
                                  "2022-10-15-preview.04", and "2023-03-02-preview.05".
                                "target": {
                                    "faceRectangle": {
                                        "height": 0,  # The height of the
                                          rectangle, in pixels. Required.
                                        "left": 0,  # The distance from the
                                          left edge if the image to the left edge of the rectangle, in
                                          pixels. Required.
                                        "top": 0,  # The distance from the
                                          top edge if the image to the top edge of the rectangle, in
                                          pixels. Required.
                                        "width": 0  # The width of the
                                          rectangle, in pixels. Required.
                                    },
                                    "fileName": "str",  # The file name which
                                      contains the face rectangle where the liveness classification was
                                      made on. Required.
                                    "imageType": "str",  # The image type which
                                      contains the face rectangle where the liveness classification was
                                      made on. Required. Known values are: "Color", "Infrared", and
                                      "Depth".
                                    "timeOffsetWithinFile": 0  # The time offset
                                      within the file of the frame which contains the face rectangle
                                      where the liveness classification was made on. Required.
                                },
                                "verifyResult": {
                                    "isIdentical": bool,  # Whether the target
                                      liveness face and comparison image face match. Required.
                                    "matchConfidence": 0.0,  # The target face
                                      liveness face and comparison image face verification confidence.
                                      Required.
                                    "verifyImage": {
                                        "faceRectangle": {
                                            "height": 0,  # The height of
                                              the rectangle, in pixels. Required.
                                            "left": 0,  # The distance
                                              from the left edge if the image to the left edge of the
                                              rectangle, in pixels. Required.
                                            "top": 0,  # The distance
                                              from the top edge if the image to the top edge of the
                                              rectangle, in pixels. Required.
                                            "width": 0  # The width of
                                              the rectangle, in pixels. Required.
                                        },
                                        "qualityForRecognition": "str"  #
                                          Quality of face image for recognition. Required. Known values
                                          are: "low", "medium", and "high".
                                    }
                                }
                            },
                            "latencyInMilliseconds": 0,  # The server measured latency
                              for this request in milliseconds. Required.
                            "statusCode": 0  # The HTTP status code returned to the
                              client. Required.
                        },
                        "sessionId": "str"  # The unique sessionId of the created session. It
                          will expire 48 hours after it was created or may be deleted sooner using the
                          corresponding session DELETE operation. Required.
                    },
                    "sessionStartDateTime": "2020-02-20 00:00:00"  # Optional. DateTime when this
                      session was started by the client.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.LivenessSession] = kwargs.pop("cls", None)

        _request = build_face_session_get_liveness_session_result_request(
            session_id=session_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.LivenessSession, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_liveness_sessions(
        self, *, start: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
    ) -> List[_models.LivenessSessionItem]:
        # pylint: disable=line-too-long
        """Lists sessions for /detectLiveness/SingleModal.

        List sessions from the last sessionId greater than the 'start'.

        The result should be ordered by sessionId in ascending order.

        :keyword start: List resources greater than the "start". It contains no more than 64
         characters. Default is empty. Default value is None.
        :paramtype start: str
        :keyword top: The number of items to list, ranging in [1, 1000]. Default is 1000. Default value
         is None.
        :paramtype top: int
        :return: list of LivenessSessionItem
        :rtype: list[~azure.ai.vision.face.models.LivenessSessionItem]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "createdDateTime": "2020-02-20 00:00:00",  # DateTime when this
                          session was created. Required.
                        "id": "str",  # The unique ID to reference this session. Required.
                        "sessionExpired": bool,  # Whether or not the session is expired.
                          Required.
                        "authTokenTimeToLiveInSeconds": 0,  # Optional. Seconds the session
                          should last for. Range is 60 to 86400 seconds. Default value is 600.
                        "deviceCorrelationId": "str",  # Optional. Unique Guid per each
                          end-user device. This is to provide rate limiting and anti-hammering. If
                          'deviceCorrelationIdSetInClient' is true in this request, this
                          'deviceCorrelationId' must be null.
                        "sessionStartDateTime": "2020-02-20 00:00:00"  # Optional. DateTime
                          when this session was started by the client.
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.LivenessSessionItem]] = kwargs.pop("cls", None)

        _request = build_face_session_get_liveness_sessions_request(
            start=start,
            top=top,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.LivenessSessionItem], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_liveness_session_audit_entries(
        self, session_id: str, *, start: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
    ) -> List[_models.LivenessSessionAuditEntry]:
        # pylint: disable=line-too-long
        """Gets session requests and response body for the session.

        :param session_id: The unique ID to reference this session. Required.
        :type session_id: str
        :keyword start: List resources greater than the "start". It contains no more than 64
         characters. Default is empty. Default value is None.
        :paramtype start: str
        :keyword top: The number of items to list, ranging in [1, 1000]. Default is 1000. Default value
         is None.
        :paramtype top: int
        :return: list of LivenessSessionAuditEntry
        :rtype: list[~azure.ai.vision.face.models.LivenessSessionAuditEntry]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "clientRequestId": "str",  # The unique clientRequestId that is sent
                          by the client in the 'client-request-id' header. Required.
                        "digest": "str",  # The server calculated digest for this request. If
                          the client reported digest differs from the server calculated digest, then
                          the message integrity between the client and service has been compromised and
                          the result should not be trusted. For more information, see how to guides on
                          how to leverage this value to secure your end-to-end solution. Required.
                        "id": 0,  # The unique id to refer to this audit request. Use this id
                          with the 'start' query parameter to continue on to the next page of audit
                          results. Required.
                        "receivedDateTime": "2020-02-20 00:00:00",  # The UTC DateTime that
                          the request was received. Required.
                        "request": {
                            "contentType": "str",  # The content type of the request.
                              Required.
                            "method": "str",  # The HTTP method of the request (i.e.,
                              GET, POST, DELETE). Required.
                            "url": "str",  # The relative URL and query of the liveness
                              request. Required.
                            "contentLength": 0,  # Optional. The length of the request
                              body in bytes.
                            "userAgent": "str"  # Optional. The user agent used to submit
                              the request.
                        },
                        "requestId": "str",  # The unique requestId that is returned by the
                          service to the client in the 'apim-request-id' header. Required.
                        "response": {
                            "body": {
                                "livenessDecision": "str",  # Optional. The liveness
                                  classification for the target face. Known values are: "uncertain",
                                  "realface", and "spoofface".
                                "modelVersionUsed": "str",  # Optional. The model
                                  version used for liveness classification. Known values are:
                                  "2020-02-15-preview.01", "2021-11-12-preview.03",
                                  "2022-10-15-preview.04", and "2023-03-02-preview.05".
                                "target": {
                                    "faceRectangle": {
                                        "height": 0,  # The height of the
                                          rectangle, in pixels. Required.
                                        "left": 0,  # The distance from the
                                          left edge if the image to the left edge of the rectangle, in
                                          pixels. Required.
                                        "top": 0,  # The distance from the
                                          top edge if the image to the top edge of the rectangle, in
                                          pixels. Required.
                                        "width": 0  # The width of the
                                          rectangle, in pixels. Required.
                                    },
                                    "fileName": "str",  # The file name which
                                      contains the face rectangle where the liveness classification was
                                      made on. Required.
                                    "imageType": "str",  # The image type which
                                      contains the face rectangle where the liveness classification was
                                      made on. Required. Known values are: "Color", "Infrared", and
                                      "Depth".
                                    "timeOffsetWithinFile": 0  # The time offset
                                      within the file of the frame which contains the face rectangle
                                      where the liveness classification was made on. Required.
                                },
                                "verifyResult": {
                                    "isIdentical": bool,  # Whether the target
                                      liveness face and comparison image face match. Required.
                                    "matchConfidence": 0.0,  # The target face
                                      liveness face and comparison image face verification confidence.
                                      Required.
                                    "verifyImage": {
                                        "faceRectangle": {
                                            "height": 0,  # The height of
                                              the rectangle, in pixels. Required.
                                            "left": 0,  # The distance
                                              from the left edge if the image to the left edge of the
                                              rectangle, in pixels. Required.
                                            "top": 0,  # The distance
                                              from the top edge if the image to the top edge of the
                                              rectangle, in pixels. Required.
                                            "width": 0  # The width of
                                              the rectangle, in pixels. Required.
                                        },
                                        "qualityForRecognition": "str"  #
                                          Quality of face image for recognition. Required. Known values
                                          are: "low", "medium", and "high".
                                    }
                                }
                            },
                            "latencyInMilliseconds": 0,  # The server measured latency
                              for this request in milliseconds. Required.
                            "statusCode": 0  # The HTTP status code returned to the
                              client. Required.
                        },
                        "sessionId": "str"  # The unique sessionId of the created session. It
                          will expire 48 hours after it was created or may be deleted sooner using the
                          corresponding session DELETE operation. Required.
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.LivenessSessionAuditEntry]] = kwargs.pop("cls", None)

        _request = build_face_session_get_liveness_session_audit_entries_request(
            session_id=session_id,
            start=start,
            top=top,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.LivenessSessionAuditEntry], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def _create_liveness_with_verify_session(
        self, body: _models.CreateLivenessSessionContent, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CreateLivenessWithVerifySessionResult: ...
    @overload
    async def _create_liveness_with_verify_session(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CreateLivenessWithVerifySessionResult: ...
    @overload
    async def _create_liveness_with_verify_session(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CreateLivenessWithVerifySessionResult: ...

    @distributed_trace_async
    async def _create_liveness_with_verify_session(
        self, body: Union[_models.CreateLivenessSessionContent, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.CreateLivenessWithVerifySessionResult:
        # pylint: disable=line-too-long
        """Create a new liveness session with verify. Client device submits VerifyImage during the
        /detectLivenessWithVerify/singleModal call.

        A session is best for client device scenarios where developers want to authorize a client
        device to perform only a liveness detection without granting full access to their resource.
        Created sessions have a limited life span and only authorize clients to perform the desired
        action before access is expired.

        Permissions includes...
        >
        *


        * Ability to call /detectLivenessWithVerify/singleModal for up to 3 retries.
        * A token lifetime of 10 minutes.

        ..

           [!NOTE]

           *


           * Client access can be revoked by deleting the session using the Delete Liveness With Verify
        Session operation.
           * To retrieve a result, use the Get Liveness With Verify Session.
           * To audit the individual requests that a client has made to your resource, use the List
        Liveness With Verify Session Audit Entries.


        Alternative Option: Client device submits VerifyImage during the
        /detectLivenessWithVerify/singleModal call.

        ..

           [!NOTE]
           Extra measures should be taken to validate that the client is sending the expected
        VerifyImage.

        :param body: Is one of the following types: CreateLivenessSessionContent, JSON, IO[bytes]
         Required.
        :type body: ~azure.ai.vision.face.models.CreateLivenessSessionContent or JSON or IO[bytes]
        :return: CreateLivenessWithVerifySessionResult. The CreateLivenessWithVerifySessionResult is
         compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.CreateLivenessWithVerifySessionResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "livenessOperationMode": "str",  # Type of liveness mode the client should
                      follow. Required. Known values are: "Passive" and "PassiveActive".
                    "authTokenTimeToLiveInSeconds": 0,  # Optional. Seconds the session should
                      last for. Range is 60 to 86400 seconds. Default value is 600.
                    "deviceCorrelationId": "str",  # Optional. Unique Guid per each end-user
                      device. This is to provide rate limiting and anti-hammering. If
                      'deviceCorrelationIdSetInClient' is true in this request, this
                      'deviceCorrelationId' must be null.
                    "deviceCorrelationIdSetInClient": bool,  # Optional. Whether or not to allow
                      client to set their own 'deviceCorrelationId' via the Vision SDK. Default is
                      false, and 'deviceCorrelationId' must be set in this request body.
                    "sendResultsToClient": bool  # Optional. Whether or not to allow a '200 -
                      Success' response body to be sent to the client, which may be undesirable for
                      security reasons. Default is false, clients will receive a '204 - NoContent'
                      empty body response. Regardless of selection, calling Session GetResult will
                      always contain a response body enabling business logic to be implemented.
                }

                # response body for status code(s): 200
                response == {
                    "authToken": "str",  # Bearer token to provide authentication for the Vision
                      SDK running on a client application. This Bearer token has limited permissions to
                      perform only the required action and expires after the TTL time. It is also
                      auditable. Required.
                    "sessionId": "str",  # The unique session ID of the created session. It will
                      expire 48 hours after it was created or may be deleted sooner using the
                      corresponding Session DELETE operation. Required.
                    "verifyImage": {
                        "faceRectangle": {
                            "height": 0,  # The height of the rectangle, in pixels.
                              Required.
                            "left": 0,  # The distance from the left edge if the image to
                              the left edge of the rectangle, in pixels. Required.
                            "top": 0,  # The distance from the top edge if the image to
                              the top edge of the rectangle, in pixels. Required.
                            "width": 0  # The width of the rectangle, in pixels.
                              Required.
                        },
                        "qualityForRecognition": "str"  # Quality of face image for
                          recognition. Required. Known values are: "low", "medium", and "high".
                    }
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CreateLivenessWithVerifySessionResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_session_create_liveness_with_verify_session_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CreateLivenessWithVerifySessionResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def _create_liveness_with_verify_session_with_verify_image(  # pylint: disable=protected-access,name-too-long
        self, body: _models._models.CreateLivenessWithVerifySessionContent, **kwargs: Any
    ) -> _models.CreateLivenessWithVerifySessionResult: ...
    @overload
    async def _create_liveness_with_verify_session_with_verify_image(  # pylint: disable=name-too-long
        self, body: JSON, **kwargs: Any
    ) -> _models.CreateLivenessWithVerifySessionResult: ...

    @distributed_trace_async
    async def _create_liveness_with_verify_session_with_verify_image(  # pylint: disable=name-too-long
        self, body: Union[_models._models.CreateLivenessWithVerifySessionContent, JSON], **kwargs: Any
    ) -> _models.CreateLivenessWithVerifySessionResult:
        # pylint: disable=line-too-long
        """Create a new liveness session with verify. Provide the verify image during session creation.

        A session is best for client device scenarios where developers want to authorize a client
        device to perform only a liveness detection without granting full access to their resource.
        Created sessions have a limited life span and only authorize clients to perform the desired
        action before access is expired.

        Permissions includes...
        >
        *


        * Ability to call /detectLivenessWithVerify/singleModal for up to 3 retries.
        * A token lifetime of 10 minutes.

        ..

           [!NOTE]

           *


           * Client access can be revoked by deleting the session using the Delete Liveness With Verify
        Session operation.
           * To retrieve a result, use the Get Liveness With Verify Session.
           * To audit the individual requests that a client has made to your resource, use the List
        Liveness With Verify Session Audit Entries.


        Recommended Option: VerifyImage is provided during session creation.

        :param body: Is either a CreateLivenessWithVerifySessionContent type or a JSON type. Required.
        :type body: ~azure.ai.vision.face.models._models.CreateLivenessWithVerifySessionContent or JSON
        :return: CreateLivenessWithVerifySessionResult. The CreateLivenessWithVerifySessionResult is
         compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.CreateLivenessWithVerifySessionResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "Parameters": {
                        "livenessOperationMode": "str",  # Type of liveness mode the client
                          should follow. Required. Known values are: "Passive" and "PassiveActive".
                        "authTokenTimeToLiveInSeconds": 0,  # Optional. Seconds the session
                          should last for. Range is 60 to 86400 seconds. Default value is 600.
                        "deviceCorrelationId": "str",  # Optional. Unique Guid per each
                          end-user device. This is to provide rate limiting and anti-hammering. If
                          'deviceCorrelationIdSetInClient' is true in this request, this
                          'deviceCorrelationId' must be null.
                        "deviceCorrelationIdSetInClient": bool,  # Optional. Whether or not
                          to allow client to set their own 'deviceCorrelationId' via the Vision SDK.
                          Default is false, and 'deviceCorrelationId' must be set in this request body.
                        "sendResultsToClient": bool  # Optional. Whether or not to allow a
                          '200 - Success' response body to be sent to the client, which may be
                          undesirable for security reasons. Default is false, clients will receive a
                          '204 - NoContent' empty body response. Regardless of selection, calling
                          Session GetResult will always contain a response body enabling business logic
                          to be implemented.
                    },
                    "VerifyImage": filetype
                }

                # response body for status code(s): 200
                response == {
                    "authToken": "str",  # Bearer token to provide authentication for the Vision
                      SDK running on a client application. This Bearer token has limited permissions to
                      perform only the required action and expires after the TTL time. It is also
                      auditable. Required.
                    "sessionId": "str",  # The unique session ID of the created session. It will
                      expire 48 hours after it was created or may be deleted sooner using the
                      corresponding Session DELETE operation. Required.
                    "verifyImage": {
                        "faceRectangle": {
                            "height": 0,  # The height of the rectangle, in pixels.
                              Required.
                            "left": 0,  # The distance from the left edge if the image to
                              the left edge of the rectangle, in pixels. Required.
                            "top": 0,  # The distance from the top edge if the image to
                              the top edge of the rectangle, in pixels. Required.
                            "width": 0  # The width of the rectangle, in pixels.
                              Required.
                        },
                        "qualityForRecognition": "str"  # Quality of face image for
                          recognition. Required. Known values are: "low", "medium", and "high".
                    }
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.CreateLivenessWithVerifySessionResult] = kwargs.pop("cls", None)

        _body = body.as_dict() if isinstance(body, _model_base.Model) else body
        _file_fields: List[str] = ["VerifyImage"]
        _data_fields: List[str] = ["Parameters"]
        _files, _data = prepare_multipart_form_data(_body, _file_fields, _data_fields)

        _request = build_face_session_create_liveness_with_verify_session_with_verify_image_request(
            files=_files,
            data=_data,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CreateLivenessWithVerifySessionResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_liveness_with_verify_session(  # pylint: disable=inconsistent-return-statements
        self, session_id: str, **kwargs: Any
    ) -> None:
        """Delete all session related information for matching the specified session id.

        ..

           [!NOTE]
           Deleting a session deactivates the Session Auth Token by blocking future API calls made with
        that Auth Token. While this can be used to remove any access for that token, those requests
        will still count towards overall resource rate limits. It's best to leverage TokenTTL to limit
        length of tokens in the case that it is misused.

        :param session_id: The unique ID to reference this session. Required.
        :type session_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_face_session_delete_liveness_with_verify_session_request(
            session_id=session_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_liveness_with_verify_session_result(
        self, session_id: str, **kwargs: Any
    ) -> _models.LivenessWithVerifySession:
        # pylint: disable=line-too-long
        """Get session result of detectLivenessWithVerify/singleModal call.

        :param session_id: The unique ID to reference this session. Required.
        :type session_id: str
        :return: LivenessWithVerifySession. The LivenessWithVerifySession is compatible with
         MutableMapping
        :rtype: ~azure.ai.vision.face.models.LivenessWithVerifySession
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # DateTime when this session was
                      created. Required.
                    "id": "str",  # The unique ID to reference this session. Required.
                    "sessionExpired": bool,  # Whether or not the session is expired. Required.
                    "status": "str",  # The current status of the session. Required. Known values
                      are: "NotStarted", "Started", and "ResultAvailable".
                    "authTokenTimeToLiveInSeconds": 0,  # Optional. Seconds the session should
                      last for. Range is 60 to 86400 seconds. Default value is 600.
                    "deviceCorrelationId": "str",  # Optional. Unique Guid per each end-user
                      device. This is to provide rate limiting and anti-hammering. If
                      'deviceCorrelationIdSetInClient' is true in this request, this
                      'deviceCorrelationId' must be null.
                    "result": {
                        "clientRequestId": "str",  # The unique clientRequestId that is sent
                          by the client in the 'client-request-id' header. Required.
                        "digest": "str",  # The server calculated digest for this request. If
                          the client reported digest differs from the server calculated digest, then
                          the message integrity between the client and service has been compromised and
                          the result should not be trusted. For more information, see how to guides on
                          how to leverage this value to secure your end-to-end solution. Required.
                        "id": 0,  # The unique id to refer to this audit request. Use this id
                          with the 'start' query parameter to continue on to the next page of audit
                          results. Required.
                        "receivedDateTime": "2020-02-20 00:00:00",  # The UTC DateTime that
                          the request was received. Required.
                        "request": {
                            "contentType": "str",  # The content type of the request.
                              Required.
                            "method": "str",  # The HTTP method of the request (i.e.,
                              GET, POST, DELETE). Required.
                            "url": "str",  # The relative URL and query of the liveness
                              request. Required.
                            "contentLength": 0,  # Optional. The length of the request
                              body in bytes.
                            "userAgent": "str"  # Optional. The user agent used to submit
                              the request.
                        },
                        "requestId": "str",  # The unique requestId that is returned by the
                          service to the client in the 'apim-request-id' header. Required.
                        "response": {
                            "body": {
                                "livenessDecision": "str",  # Optional. The liveness
                                  classification for the target face. Known values are: "uncertain",
                                  "realface", and "spoofface".
                                "modelVersionUsed": "str",  # Optional. The model
                                  version used for liveness classification. Known values are:
                                  "2020-02-15-preview.01", "2021-11-12-preview.03",
                                  "2022-10-15-preview.04", and "2023-03-02-preview.05".
                                "target": {
                                    "faceRectangle": {
                                        "height": 0,  # The height of the
                                          rectangle, in pixels. Required.
                                        "left": 0,  # The distance from the
                                          left edge if the image to the left edge of the rectangle, in
                                          pixels. Required.
                                        "top": 0,  # The distance from the
                                          top edge if the image to the top edge of the rectangle, in
                                          pixels. Required.
                                        "width": 0  # The width of the
                                          rectangle, in pixels. Required.
                                    },
                                    "fileName": "str",  # The file name which
                                      contains the face rectangle where the liveness classification was
                                      made on. Required.
                                    "imageType": "str",  # The image type which
                                      contains the face rectangle where the liveness classification was
                                      made on. Required. Known values are: "Color", "Infrared", and
                                      "Depth".
                                    "timeOffsetWithinFile": 0  # The time offset
                                      within the file of the frame which contains the face rectangle
                                      where the liveness classification was made on. Required.
                                },
                                "verifyResult": {
                                    "isIdentical": bool,  # Whether the target
                                      liveness face and comparison image face match. Required.
                                    "matchConfidence": 0.0,  # The target face
                                      liveness face and comparison image face verification confidence.
                                      Required.
                                    "verifyImage": {
                                        "faceRectangle": {
                                            "height": 0,  # The height of
                                              the rectangle, in pixels. Required.
                                            "left": 0,  # The distance
                                              from the left edge if the image to the left edge of the
                                              rectangle, in pixels. Required.
                                            "top": 0,  # The distance
                                              from the top edge if the image to the top edge of the
                                              rectangle, in pixels. Required.
                                            "width": 0  # The width of
                                              the rectangle, in pixels. Required.
                                        },
                                        "qualityForRecognition": "str"  #
                                          Quality of face image for recognition. Required. Known values
                                          are: "low", "medium", and "high".
                                    }
                                }
                            },
                            "latencyInMilliseconds": 0,  # The server measured latency
                              for this request in milliseconds. Required.
                            "statusCode": 0  # The HTTP status code returned to the
                              client. Required.
                        },
                        "sessionId": "str"  # The unique sessionId of the created session. It
                          will expire 48 hours after it was created or may be deleted sooner using the
                          corresponding session DELETE operation. Required.
                    },
                    "sessionStartDateTime": "2020-02-20 00:00:00"  # Optional. DateTime when this
                      session was started by the client.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.LivenessWithVerifySession] = kwargs.pop("cls", None)

        _request = build_face_session_get_liveness_with_verify_session_result_request(
            session_id=session_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.LivenessWithVerifySession, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_liveness_with_verify_sessions(
        self, *, start: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
    ) -> List[_models.LivenessSessionItem]:
        # pylint: disable=line-too-long
        """Lists sessions for /detectLivenessWithVerify/SingleModal.

        List sessions from the last sessionId greater than the "start".

        The result should be ordered by sessionId in ascending order.

        :keyword start: List resources greater than the "start". It contains no more than 64
         characters. Default is empty. Default value is None.
        :paramtype start: str
        :keyword top: The number of items to list, ranging in [1, 1000]. Default is 1000. Default value
         is None.
        :paramtype top: int
        :return: list of LivenessSessionItem
        :rtype: list[~azure.ai.vision.face.models.LivenessSessionItem]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "createdDateTime": "2020-02-20 00:00:00",  # DateTime when this
                          session was created. Required.
                        "id": "str",  # The unique ID to reference this session. Required.
                        "sessionExpired": bool,  # Whether or not the session is expired.
                          Required.
                        "authTokenTimeToLiveInSeconds": 0,  # Optional. Seconds the session
                          should last for. Range is 60 to 86400 seconds. Default value is 600.
                        "deviceCorrelationId": "str",  # Optional. Unique Guid per each
                          end-user device. This is to provide rate limiting and anti-hammering. If
                          'deviceCorrelationIdSetInClient' is true in this request, this
                          'deviceCorrelationId' must be null.
                        "sessionStartDateTime": "2020-02-20 00:00:00"  # Optional. DateTime
                          when this session was started by the client.
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.LivenessSessionItem]] = kwargs.pop("cls", None)

        _request = build_face_session_get_liveness_with_verify_sessions_request(
            start=start,
            top=top,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.LivenessSessionItem], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_liveness_with_verify_session_audit_entries(  # pylint: disable=name-too-long
        self, session_id: str, *, start: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
    ) -> List[_models.LivenessSessionAuditEntry]:
        # pylint: disable=line-too-long
        """Gets session requests and response body for the session.

        :param session_id: The unique ID to reference this session. Required.
        :type session_id: str
        :keyword start: List resources greater than the "start". It contains no more than 64
         characters. Default is empty. Default value is None.
        :paramtype start: str
        :keyword top: The number of items to list, ranging in [1, 1000]. Default is 1000. Default value
         is None.
        :paramtype top: int
        :return: list of LivenessSessionAuditEntry
        :rtype: list[~azure.ai.vision.face.models.LivenessSessionAuditEntry]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "clientRequestId": "str",  # The unique clientRequestId that is sent
                          by the client in the 'client-request-id' header. Required.
                        "digest": "str",  # The server calculated digest for this request. If
                          the client reported digest differs from the server calculated digest, then
                          the message integrity between the client and service has been compromised and
                          the result should not be trusted. For more information, see how to guides on
                          how to leverage this value to secure your end-to-end solution. Required.
                        "id": 0,  # The unique id to refer to this audit request. Use this id
                          with the 'start' query parameter to continue on to the next page of audit
                          results. Required.
                        "receivedDateTime": "2020-02-20 00:00:00",  # The UTC DateTime that
                          the request was received. Required.
                        "request": {
                            "contentType": "str",  # The content type of the request.
                              Required.
                            "method": "str",  # The HTTP method of the request (i.e.,
                              GET, POST, DELETE). Required.
                            "url": "str",  # The relative URL and query of the liveness
                              request. Required.
                            "contentLength": 0,  # Optional. The length of the request
                              body in bytes.
                            "userAgent": "str"  # Optional. The user agent used to submit
                              the request.
                        },
                        "requestId": "str",  # The unique requestId that is returned by the
                          service to the client in the 'apim-request-id' header. Required.
                        "response": {
                            "body": {
                                "livenessDecision": "str",  # Optional. The liveness
                                  classification for the target face. Known values are: "uncertain",
                                  "realface", and "spoofface".
                                "modelVersionUsed": "str",  # Optional. The model
                                  version used for liveness classification. Known values are:
                                  "2020-02-15-preview.01", "2021-11-12-preview.03",
                                  "2022-10-15-preview.04", and "2023-03-02-preview.05".
                                "target": {
                                    "faceRectangle": {
                                        "height": 0,  # The height of the
                                          rectangle, in pixels. Required.
                                        "left": 0,  # The distance from the
                                          left edge if the image to the left edge of the rectangle, in
                                          pixels. Required.
                                        "top": 0,  # The distance from the
                                          top edge if the image to the top edge of the rectangle, in
                                          pixels. Required.
                                        "width": 0  # The width of the
                                          rectangle, in pixels. Required.
                                    },
                                    "fileName": "str",  # The file name which
                                      contains the face rectangle where the liveness classification was
                                      made on. Required.
                                    "imageType": "str",  # The image type which
                                      contains the face rectangle where the liveness classification was
                                      made on. Required. Known values are: "Color", "Infrared", and
                                      "Depth".
                                    "timeOffsetWithinFile": 0  # The time offset
                                      within the file of the frame which contains the face rectangle
                                      where the liveness classification was made on. Required.
                                },
                                "verifyResult": {
                                    "isIdentical": bool,  # Whether the target
                                      liveness face and comparison image face match. Required.
                                    "matchConfidence": 0.0,  # The target face
                                      liveness face and comparison image face verification confidence.
                                      Required.
                                    "verifyImage": {
                                        "faceRectangle": {
                                            "height": 0,  # The height of
                                              the rectangle, in pixels. Required.
                                            "left": 0,  # The distance
                                              from the left edge if the image to the left edge of the
                                              rectangle, in pixels. Required.
                                            "top": 0,  # The distance
                                              from the top edge if the image to the top edge of the
                                              rectangle, in pixels. Required.
                                            "width": 0  # The width of
                                              the rectangle, in pixels. Required.
                                        },
                                        "qualityForRecognition": "str"  #
                                          Quality of face image for recognition. Required. Known values
                                          are: "low", "medium", and "high".
                                    }
                                }
                            },
                            "latencyInMilliseconds": 0,  # The server measured latency
                              for this request in milliseconds. Required.
                            "statusCode": 0  # The HTTP status code returned to the
                              client. Required.
                        },
                        "sessionId": "str"  # The unique sessionId of the created session. It
                          will expire 48 hours after it was created or may be deleted sooner using the
                          corresponding session DELETE operation. Required.
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.LivenessSessionAuditEntry]] = kwargs.pop("cls", None)

        _request = build_face_session_get_liveness_with_verify_session_audit_entries_request(
            session_id=session_id,
            start=start,
            top=top,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.LivenessSessionAuditEntry], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
