# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import json
import sys
from typing import Any, AsyncIterable, Callable, Dict, IO, List, Optional, Type, TypeVar, Union, cast, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.polling.async_base_polling import AsyncLROBasePolling
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ..._model_base import SdkJSONEncoder, _deserialize
from ..._operations._operations import (
    build_document_intelligence_administration_authorize_model_copy_request,
    build_document_intelligence_administration_build_classifier_request,
    build_document_intelligence_administration_build_document_model_request,
    build_document_intelligence_administration_compose_model_request,
    build_document_intelligence_administration_copy_model_to_request,
    build_document_intelligence_administration_delete_classifier_request,
    build_document_intelligence_administration_delete_model_request,
    build_document_intelligence_administration_get_classifier_request,
    build_document_intelligence_administration_get_model_request,
    build_document_intelligence_administration_get_operation_request,
    build_document_intelligence_administration_get_resource_info_request,
    build_document_intelligence_administration_list_classifiers_request,
    build_document_intelligence_administration_list_models_request,
    build_document_intelligence_administration_list_operations_request,
    build_document_intelligence_analyze_document_request,
    build_document_intelligence_classify_document_request,
)
from .._vendor import DocumentIntelligenceAdministrationClientMixinABC, DocumentIntelligenceClientMixinABC

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class DocumentIntelligenceClientOperationsMixin(DocumentIntelligenceClientMixinABC):  # pylint: disable=name-too-long
    async def _analyze_document_initial(  # pylint: disable=inconsistent-return-statements
        self,
        model_id: str,
        analyze_request: Optional[Union[_models.AnalyzeDocumentRequest, JSON, IO[bytes]]] = None,
        *,
        pages: Optional[str] = None,
        locale: Optional[str] = None,
        string_index_type: Optional[Union[str, _models.StringIndexType]] = None,
        features: Optional[List[Union[str, _models.DocumentAnalysisFeature]]] = None,
        query_fields: Optional[List[str]] = None,
        output_content_format: Optional[Union[str, _models.ContentFormat]] = None,
        **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("content-type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(analyze_request, (IOBase, bytes)):
            _content = analyze_request
        else:
            if analyze_request is not None:
                _content = json.dumps(analyze_request, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        _request = build_document_intelligence_analyze_document_request(
            model_id=model_id,
            pages=pages,
            locale=locale,
            string_index_type=string_index_type,
            features=features,
            query_fields=query_fields,
            output_content_format=output_content_format,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))
        response_headers["Operation-Location"] = self._deserialize("str", response.headers.get("Operation-Location"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @overload
    async def begin_analyze_document(
        self,
        model_id: str,
        analyze_request: Optional[_models.AnalyzeDocumentRequest] = None,
        *,
        pages: Optional[str] = None,
        locale: Optional[str] = None,
        string_index_type: Optional[Union[str, _models.StringIndexType]] = None,
        features: Optional[List[Union[str, _models.DocumentAnalysisFeature]]] = None,
        query_fields: Optional[List[str]] = None,
        output_content_format: Optional[Union[str, _models.ContentFormat]] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.AnalyzeResult]:
        # pylint: disable=line-too-long
        """Analyzes document with document model.

        :param model_id: Unique document model name. Required.
        :type model_id: str
        :param analyze_request: Analyze request parameters. Default value is None.
        :type analyze_request: ~azure.ai.documentintelligence.models.AnalyzeDocumentRequest
        :keyword pages: List of 1-based page numbers to analyze.  Ex. "1-3,5,7-9". Default value is
         None.
        :paramtype pages: str
        :keyword locale: Locale hint for text recognition and document analysis.  Value may contain
         only
         the language code (ex. "en", "fr") or BCP 47 language tag (ex. "en-US"). Default value is
         None.
        :paramtype locale: str
        :keyword string_index_type: Method used to compute string offset and length. Known values are:
         "textElements", "unicodeCodePoint", and "utf16CodeUnit". Default value is None.
        :paramtype string_index_type: str or ~azure.ai.documentintelligence.models.StringIndexType
        :keyword features: List of optional analysis features. Default value is None.
        :paramtype features: list[str or ~azure.ai.documentintelligence.models.DocumentAnalysisFeature]
        :keyword query_fields: List of additional fields to extract.  Ex. "NumberOfGuests,StoreNumber".
         Default value is None.
        :paramtype query_fields: list[str]
        :keyword output_content_format: Format of the analyze result top-level content. Known values
         are: "text" and "markdown". Default value is None.
        :paramtype output_content_format: str or ~azure.ai.documentintelligence.models.ContentFormat
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns AnalyzeResult. The AnalyzeResult is
         compatible with MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.ai.documentintelligence.models.AnalyzeResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                analyze_request = {
                    "base64Source": bytes("bytes", encoding="utf-8"),  # Optional. Base64
                      encoding of the document to analyze.  Either urlSource or base64Source must be
                      specified.
                    "urlSource": "str"  # Optional. Document URL to analyze.  Either urlSource or
                      base64Source must be specified.
                }

                # response body for status code(s): 202
                response == {
                    "apiVersion": "str",  # API version used to produce this result. Required.
                    "content": "str",  # Concatenate string representation of all textual and
                      visual elements in reading order. Required.
                    "modelId": "str",  # Document model ID used to produce this result. Required.
                    "pages": [
                        {
                            "pageNumber": 0,  # 1-based page number in the input
                              document. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "angle": 0.0,  # Optional. The general orientation of the
                              content in clockwise direction, measured in degrees between (-180, 180].
                            "barcodes": [
                                {
                                    "confidence": 0.0,  # Confidence of correctly
                                      extracting the barcode. Required.
                                    "kind": "str",  # Barcode kind. Required.
                                      Known values are: "QRCode", "PDF417", "UPCA", "UPCE", "Code39",
                                      "Code128", "EAN8", "EAN13", "DataBar", "Code93", "Codabar",
                                      "DataBarExpanded", "ITF", "MicroQRCode", "Aztec", "DataMatrix",
                                      and "MaxiCode".
                                    "span": {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    },
                                    "value": "str",  # Barcode value. Required.
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the barcode, with coordinates specified relative to the
                                          top-left of the page. The numbers represent the x, y values
                                          of the polygon vertices, clockwise from the left (-180
                                          degrees inclusive) relative to the element orientation.
                                    ]
                                }
                            ],
                            "formulas": [
                                {
                                    "confidence": 0.0,  # Confidence of correctly
                                      extracting the formula. Required.
                                    "kind": "str",  # Formula kind. Required.
                                      Known values are: "inline" and "display".
                                    "span": {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    },
                                    "value": "str",  # LaTex expression
                                      describing the formula. Required.
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the formula, with coordinates specified relative to the
                                          top-left of the page. The numbers represent the x, y values
                                          of the polygon vertices, clockwise from the left (-180
                                          degrees inclusive) relative to the element orientation.
                                    ]
                                }
                            ],
                            "height": 0.0,  # Optional. The height of the image/PDF in
                              pixels/inches, respectively.
                            "lines": [
                                {
                                    "content": "str",  # Concatenated content of
                                      the contained elements in reading order. Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the line, with coordinates specified relative to the top-left
                                          of the page. The numbers represent the x, y values of the
                                          polygon vertices, clockwise from the left (-180 degrees
                                          inclusive) relative to the element orientation.
                                    ]
                                }
                            ],
                            "selectionMarks": [
                                {
                                    "confidence": 0.0,  # Confidence of correctly
                                      extracting the selection mark. Required.
                                    "span": {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    },
                                    "state": "str",  # State of the selection
                                      mark. Required. Known values are: "selected" and "unselected".
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the selection mark, with coordinates specified relative to
                                          the top-left of the page. The numbers represent the x, y
                                          values of the polygon vertices, clockwise from the left (-180
                                          degrees inclusive) relative to the element orientation.
                                    ]
                                }
                            ],
                            "unit": "str",  # Optional. The unit used by the width,
                              height, and polygon properties. For images, the unit is "pixel". For PDF,
                              the unit is "inch". Known values are: "pixel" and "inch".
                            "width": 0.0,  # Optional. The width of the image/PDF in
                              pixels/inches, respectively.
                            "words": [
                                {
                                    "confidence": 0.0,  # Confidence of correctly
                                      extracting the word. Required.
                                    "content": "str",  # Text content of the
                                      word. Required.
                                    "span": {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    },
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the word, with coordinates specified relative to the top-left
                                          of the page. The numbers represent the x, y values of the
                                          polygon vertices, clockwise from the left (-180 degrees
                                          inclusive) relative to the element orientation.
                                    ]
                                }
                            ]
                        }
                    ],
                    "stringIndexType": "str",  # Method used to compute string offset and length.
                      Required. Known values are: "textElements", "unicodeCodePoint", and
                      "utf16CodeUnit".
                    "contentFormat": "str",  # Optional. Format of the analyze result top-level
                      content. Known values are: "text" and "markdown".
                    "documents": [
                        {
                            "confidence": 0.0,  # Confidence of correctly extracting the
                              document. Required.
                            "docType": "str",  # Document type. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "boundingRegions": [
                                {
                                    "pageNumber": 0,  # 1-based page number of
                                      page containing the bounding region. Required.
                                    "polygon": [
                                        0.0  # Bounding polygon on the page,
                                          or the entire page if not specified. Coordinates specified
                                          relative to the top-left of the page. The numbers represent
                                          the x, y values of the polygon vertices, clockwise from the
                                          left (-180 degrees inclusive) relative to the element
                                          orientation. Required.
                                    ]
                                }
                            ],
                            "fields": {
                                "str": {
                                    "type": "str",  # Data type of the field
                                      value. Required. Known values are: "string", "date", "time",
                                      "phoneNumber", "number", "integer", "selectionMark",
                                      "countryRegion", "signature", "array", "object", "currency",
                                      "address", "boolean", and "selectionGroup".
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "confidence": 0.0,  # Optional. Confidence of
                                      correctly extracting the field.
                                    "content": "str",  # Optional. Field content.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "valueAddress": {
                                        "city": "str",  # Optional. Name of
                                          city, town, village, etc.
                                        "cityDistrict": "str",  # Optional.
                                          Districts or boroughs within a city, such as Brooklyn in New
                                          York City or City of Westminster in London.
                                        "countryRegion": "str",  # Optional.
                                          Country/region.
                                        "house": "str",  # Optional. Build
                                          name, such as World Trade Center.
                                        "houseNumber": "str",  # Optional.
                                          House or building number.
                                        "level": "str",  # Optional. Floor
                                          number, such as 3F.
                                        "poBox": "str",  # Optional. Post
                                          office box number.
                                        "postalCode": "str",  # Optional.
                                          Postal code used for mail sorting.
                                        "road": "str",  # Optional. Street
                                          name.
                                        "state": "str",  # Optional.
                                          First-level administrative division.
                                        "stateDistrict": "str",  # Optional.
                                          Second-level administrative division used in certain locales.
                                        "streetAddress": "str",  # Optional.
                                          Street-level address, excluding city, state, countryRegion,
                                          and postalCode.
                                        "suburb": "str",  # Optional.
                                          Unofficial neighborhood name, like Chinatown.
                                        "unit": "str"  # Optional. Apartment
                                          or office number.
                                    },
                                    "valueArray": [
                                        ...
                                    ],
                                    "valueBoolean": bool,  # Optional. Boolean
                                      value.
                                    "valueCountryRegion": "str",  # Optional.
                                      3-letter country code value (ISO 3166-1 alpha-3).
                                    "valueCurrency": {
                                        "amount": 0.0,  # Currency amount.
                                          Required.
                                        "currencyCode": "str",  # Optional.
                                          Resolved currency code (ISO 4217), if any.
                                        "currencySymbol": "str"  # Optional.
                                          Currency symbol label, if any.
                                    },
                                    "valueDate": "2020-02-20",  # Optional. Date
                                      value in YYYY-MM-DD format (ISO 8601).
                                    "valueInteger": 0,  # Optional. Integer
                                      value.
                                    "valueNumber": 0.0,  # Optional. Floating
                                      point value.
                                    "valueObject": {
                                        "str": ...
                                    },
                                    "valuePhoneNumber": "str",  # Optional. Phone
                                      number value in E.164 format (ex. +19876543210).
                                    "valueSelectionGroup": [
                                        "str"  # Optional. Selection group
                                          value.
                                    ],
                                    "valueSelectionMark": "str",  # Optional.
                                      Selection mark value. Known values are: "selected" and
                                      "unselected".
                                    "valueSignature": "str",  # Optional.
                                      Presence of signature. Known values are: "signed" and "unsigned".
                                    "valueString": "str",  # Optional. String
                                      value.
                                    "valueTime": "12:30:00"  # Optional. Time
                                      value in hh:mm:ss format (ISO 8601).
                                }
                            }
                        }
                    ],
                    "figures": [
                        {
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "boundingRegions": [
                                {
                                    "pageNumber": 0,  # 1-based page number of
                                      page containing the bounding region. Required.
                                    "polygon": [
                                        0.0  # Bounding polygon on the page,
                                          or the entire page if not specified. Coordinates specified
                                          relative to the top-left of the page. The numbers represent
                                          the x, y values of the polygon vertices, clockwise from the
                                          left (-180 degrees inclusive) relative to the element
                                          orientation. Required.
                                    ]
                                }
                            ],
                            "caption": {
                                "content": "str",  # Content of the caption.
                                  Required.
                                "spans": [
                                    {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    }
                                ],
                                "boundingRegions": [
                                    {
                                        "pageNumber": 0,  # 1-based page
                                          number of page containing the bounding region. Required.
                                        "polygon": [
                                            0.0  # Bounding polygon on
                                              the page, or the entire page if not specified.
                                              Coordinates specified relative to the top-left of the
                                              page. The numbers represent the x, y values of the
                                              polygon vertices, clockwise from the left (-180 degrees
                                              inclusive) relative to the element orientation. Required.
                                        ]
                                    }
                                ],
                                "elements": [
                                    "str"  # Optional. Child elements of the
                                      caption.
                                ]
                            },
                            "elements": [
                                "str"  # Optional. Child elements of the figure,
                                  excluding any caption or footnotes.
                            ],
                            "footnotes": [
                                {
                                    "content": "str",  # Content of the footnote.
                                      Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "elements": [
                                        "str"  # Optional. Child elements of
                                          the footnote.
                                    ]
                                }
                            ]
                        }
                    ],
                    "keyValuePairs": [
                        {
                            "confidence": 0.0,  # Confidence of correctly extracting the
                              key-value pair. Required.
                            "key": {
                                "content": "str",  # Concatenated content of the
                                  key-value element in reading order. Required.
                                "spans": [
                                    {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    }
                                ],
                                "boundingRegions": [
                                    {
                                        "pageNumber": 0,  # 1-based page
                                          number of page containing the bounding region. Required.
                                        "polygon": [
                                            0.0  # Bounding polygon on
                                              the page, or the entire page if not specified.
                                              Coordinates specified relative to the top-left of the
                                              page. The numbers represent the x, y values of the
                                              polygon vertices, clockwise from the left (-180 degrees
                                              inclusive) relative to the element orientation. Required.
                                        ]
                                    }
                                ]
                            },
                            "value": {
                                "content": "str",  # Concatenated content of the
                                  key-value element in reading order. Required.
                                "spans": [
                                    {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    }
                                ],
                                "boundingRegions": [
                                    {
                                        "pageNumber": 0,  # 1-based page
                                          number of page containing the bounding region. Required.
                                        "polygon": [
                                            0.0  # Bounding polygon on
                                              the page, or the entire page if not specified.
                                              Coordinates specified relative to the top-left of the
                                              page. The numbers represent the x, y values of the
                                              polygon vertices, clockwise from the left (-180 degrees
                                              inclusive) relative to the element orientation. Required.
                                        ]
                                    }
                                ]
                            }
                        }
                    ],
                    "languages": [
                        {
                            "confidence": 0.0,  # Confidence of correctly identifying the
                              language. Required.
                            "locale": "str",  # Detected language.  Value may an ISO
                              639-1 language code (ex. "en", "fr") or BCP 47 language tag (ex.
                              "zh-Hans"). Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ]
                        }
                    ],
                    "lists": [
                        {
                            "items": [
                                {
                                    "content": "str",  # Content of the list
                                      item. Required.
                                    "level": 0,  # Level of the list item
                                      (1-indexed). Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "elements": [
                                        "str"  # Optional. Child elements of
                                          the list item.
                                    ]
                                }
                            ],
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ]
                        }
                    ],
                    "paragraphs": [
                        {
                            "content": "str",  # Concatenated content of the paragraph in
                              reading order. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "boundingRegions": [
                                {
                                    "pageNumber": 0,  # 1-based page number of
                                      page containing the bounding region. Required.
                                    "polygon": [
                                        0.0  # Bounding polygon on the page,
                                          or the entire page if not specified. Coordinates specified
                                          relative to the top-left of the page. The numbers represent
                                          the x, y values of the polygon vertices, clockwise from the
                                          left (-180 degrees inclusive) relative to the element
                                          orientation. Required.
                                    ]
                                }
                            ],
                            "role": "str"  # Optional. Semantic role of the paragraph.
                              Known values are: "pageHeader", "pageFooter", "pageNumber", "title",
                              "sectionHeading", "footnote", and "formulaBlock".
                        }
                    ],
                    "sections": [
                        {
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "elements": [
                                "str"  # Optional. Child elements of the section.
                            ]
                        }
                    ],
                    "styles": [
                        {
                            "confidence": 0.0,  # Confidence of correctly identifying the
                              style. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "backgroundColor": "str",  # Optional. Background color in
                              #rrggbb hexadecimal format..
                            "color": "str",  # Optional. Foreground color in #rrggbb
                              hexadecimal format.
                            "fontStyle": "str",  # Optional. Font style. Known values
                              are: "normal" and "italic".
                            "fontWeight": "str",  # Optional. Font weight. Known values
                              are: "normal" and "bold".
                            "isHandwritten": bool,  # Optional. Is content handwritten?.
                            "similarFontFamily": "str"  # Optional. Visually most similar
                              font from among the set of supported font families, with fallback fonts
                              following CSS convention (ex. 'Arial, sans-serif').
                        }
                    ],
                    "tables": [
                        {
                            "cells": [
                                {
                                    "columnIndex": 0,  # Column index of the
                                      cell. Required.
                                    "content": "str",  # Concatenated content of
                                      the table cell in reading order. Required.
                                    "rowIndex": 0,  # Row index of the cell.
                                      Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "columnSpan": 0,  # Optional. Number of
                                      columns spanned by this cell.
                                    "elements": [
                                        "str"  # Optional. Child elements of
                                          the table cell.
                                    ],
                                    "kind": "str",  # Optional. Table cell kind.
                                      Known values are: "content", "rowHeader", "columnHeader",
                                      "stubHead", and "description".
                                    "rowSpan": 0  # Optional. Number of rows
                                      spanned by this cell.
                                }
                            ],
                            "columnCount": 0,  # Number of columns in the table.
                              Required.
                            "rowCount": 0,  # Number of rows in the table. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "boundingRegions": [
                                {
                                    "pageNumber": 0,  # 1-based page number of
                                      page containing the bounding region. Required.
                                    "polygon": [
                                        0.0  # Bounding polygon on the page,
                                          or the entire page if not specified. Coordinates specified
                                          relative to the top-left of the page. The numbers represent
                                          the x, y values of the polygon vertices, clockwise from the
                                          left (-180 degrees inclusive) relative to the element
                                          orientation. Required.
                                    ]
                                }
                            ],
                            "caption": {
                                "content": "str",  # Content of the caption.
                                  Required.
                                "spans": [
                                    {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    }
                                ],
                                "boundingRegions": [
                                    {
                                        "pageNumber": 0,  # 1-based page
                                          number of page containing the bounding region. Required.
                                        "polygon": [
                                            0.0  # Bounding polygon on
                                              the page, or the entire page if not specified.
                                              Coordinates specified relative to the top-left of the
                                              page. The numbers represent the x, y values of the
                                              polygon vertices, clockwise from the left (-180 degrees
                                              inclusive) relative to the element orientation. Required.
                                        ]
                                    }
                                ],
                                "elements": [
                                    "str"  # Optional. Child elements of the
                                      caption.
                                ]
                            },
                            "footnotes": [
                                {
                                    "content": "str",  # Content of the footnote.
                                      Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "elements": [
                                        "str"  # Optional. Child elements of
                                          the footnote.
                                    ]
                                }
                            ]
                        }
                    ]
                }
        """

    @overload
    async def begin_analyze_document(
        self,
        model_id: str,
        analyze_request: Optional[JSON] = None,
        *,
        pages: Optional[str] = None,
        locale: Optional[str] = None,
        string_index_type: Optional[Union[str, _models.StringIndexType]] = None,
        features: Optional[List[Union[str, _models.DocumentAnalysisFeature]]] = None,
        query_fields: Optional[List[str]] = None,
        output_content_format: Optional[Union[str, _models.ContentFormat]] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.AnalyzeResult]:
        # pylint: disable=line-too-long
        """Analyzes document with document model.

        :param model_id: Unique document model name. Required.
        :type model_id: str
        :param analyze_request: Analyze request parameters. Default value is None.
        :type analyze_request: JSON
        :keyword pages: List of 1-based page numbers to analyze.  Ex. "1-3,5,7-9". Default value is
         None.
        :paramtype pages: str
        :keyword locale: Locale hint for text recognition and document analysis.  Value may contain
         only
         the language code (ex. "en", "fr") or BCP 47 language tag (ex. "en-US"). Default value is
         None.
        :paramtype locale: str
        :keyword string_index_type: Method used to compute string offset and length. Known values are:
         "textElements", "unicodeCodePoint", and "utf16CodeUnit". Default value is None.
        :paramtype string_index_type: str or ~azure.ai.documentintelligence.models.StringIndexType
        :keyword features: List of optional analysis features. Default value is None.
        :paramtype features: list[str or ~azure.ai.documentintelligence.models.DocumentAnalysisFeature]
        :keyword query_fields: List of additional fields to extract.  Ex. "NumberOfGuests,StoreNumber".
         Default value is None.
        :paramtype query_fields: list[str]
        :keyword output_content_format: Format of the analyze result top-level content. Known values
         are: "text" and "markdown". Default value is None.
        :paramtype output_content_format: str or ~azure.ai.documentintelligence.models.ContentFormat
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns AnalyzeResult. The AnalyzeResult is
         compatible with MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.ai.documentintelligence.models.AnalyzeResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "apiVersion": "str",  # API version used to produce this result. Required.
                    "content": "str",  # Concatenate string representation of all textual and
                      visual elements in reading order. Required.
                    "modelId": "str",  # Document model ID used to produce this result. Required.
                    "pages": [
                        {
                            "pageNumber": 0,  # 1-based page number in the input
                              document. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "angle": 0.0,  # Optional. The general orientation of the
                              content in clockwise direction, measured in degrees between (-180, 180].
                            "barcodes": [
                                {
                                    "confidence": 0.0,  # Confidence of correctly
                                      extracting the barcode. Required.
                                    "kind": "str",  # Barcode kind. Required.
                                      Known values are: "QRCode", "PDF417", "UPCA", "UPCE", "Code39",
                                      "Code128", "EAN8", "EAN13", "DataBar", "Code93", "Codabar",
                                      "DataBarExpanded", "ITF", "MicroQRCode", "Aztec", "DataMatrix",
                                      and "MaxiCode".
                                    "span": {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    },
                                    "value": "str",  # Barcode value. Required.
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the barcode, with coordinates specified relative to the
                                          top-left of the page. The numbers represent the x, y values
                                          of the polygon vertices, clockwise from the left (-180
                                          degrees inclusive) relative to the element orientation.
                                    ]
                                }
                            ],
                            "formulas": [
                                {
                                    "confidence": 0.0,  # Confidence of correctly
                                      extracting the formula. Required.
                                    "kind": "str",  # Formula kind. Required.
                                      Known values are: "inline" and "display".
                                    "span": {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    },
                                    "value": "str",  # LaTex expression
                                      describing the formula. Required.
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the formula, with coordinates specified relative to the
                                          top-left of the page. The numbers represent the x, y values
                                          of the polygon vertices, clockwise from the left (-180
                                          degrees inclusive) relative to the element orientation.
                                    ]
                                }
                            ],
                            "height": 0.0,  # Optional. The height of the image/PDF in
                              pixels/inches, respectively.
                            "lines": [
                                {
                                    "content": "str",  # Concatenated content of
                                      the contained elements in reading order. Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the line, with coordinates specified relative to the top-left
                                          of the page. The numbers represent the x, y values of the
                                          polygon vertices, clockwise from the left (-180 degrees
                                          inclusive) relative to the element orientation.
                                    ]
                                }
                            ],
                            "selectionMarks": [
                                {
                                    "confidence": 0.0,  # Confidence of correctly
                                      extracting the selection mark. Required.
                                    "span": {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    },
                                    "state": "str",  # State of the selection
                                      mark. Required. Known values are: "selected" and "unselected".
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the selection mark, with coordinates specified relative to
                                          the top-left of the page. The numbers represent the x, y
                                          values of the polygon vertices, clockwise from the left (-180
                                          degrees inclusive) relative to the element orientation.
                                    ]
                                }
                            ],
                            "unit": "str",  # Optional. The unit used by the width,
                              height, and polygon properties. For images, the unit is "pixel". For PDF,
                              the unit is "inch". Known values are: "pixel" and "inch".
                            "width": 0.0,  # Optional. The width of the image/PDF in
                              pixels/inches, respectively.
                            "words": [
                                {
                                    "confidence": 0.0,  # Confidence of correctly
                                      extracting the word. Required.
                                    "content": "str",  # Text content of the
                                      word. Required.
                                    "span": {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    },
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the word, with coordinates specified relative to the top-left
                                          of the page. The numbers represent the x, y values of the
                                          polygon vertices, clockwise from the left (-180 degrees
                                          inclusive) relative to the element orientation.
                                    ]
                                }
                            ]
                        }
                    ],
                    "stringIndexType": "str",  # Method used to compute string offset and length.
                      Required. Known values are: "textElements", "unicodeCodePoint", and
                      "utf16CodeUnit".
                    "contentFormat": "str",  # Optional. Format of the analyze result top-level
                      content. Known values are: "text" and "markdown".
                    "documents": [
                        {
                            "confidence": 0.0,  # Confidence of correctly extracting the
                              document. Required.
                            "docType": "str",  # Document type. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "boundingRegions": [
                                {
                                    "pageNumber": 0,  # 1-based page number of
                                      page containing the bounding region. Required.
                                    "polygon": [
                                        0.0  # Bounding polygon on the page,
                                          or the entire page if not specified. Coordinates specified
                                          relative to the top-left of the page. The numbers represent
                                          the x, y values of the polygon vertices, clockwise from the
                                          left (-180 degrees inclusive) relative to the element
                                          orientation. Required.
                                    ]
                                }
                            ],
                            "fields": {
                                "str": {
                                    "type": "str",  # Data type of the field
                                      value. Required. Known values are: "string", "date", "time",
                                      "phoneNumber", "number", "integer", "selectionMark",
                                      "countryRegion", "signature", "array", "object", "currency",
                                      "address", "boolean", and "selectionGroup".
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "confidence": 0.0,  # Optional. Confidence of
                                      correctly extracting the field.
                                    "content": "str",  # Optional. Field content.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "valueAddress": {
                                        "city": "str",  # Optional. Name of
                                          city, town, village, etc.
                                        "cityDistrict": "str",  # Optional.
                                          Districts or boroughs within a city, such as Brooklyn in New
                                          York City or City of Westminster in London.
                                        "countryRegion": "str",  # Optional.
                                          Country/region.
                                        "house": "str",  # Optional. Build
                                          name, such as World Trade Center.
                                        "houseNumber": "str",  # Optional.
                                          House or building number.
                                        "level": "str",  # Optional. Floor
                                          number, such as 3F.
                                        "poBox": "str",  # Optional. Post
                                          office box number.
                                        "postalCode": "str",  # Optional.
                                          Postal code used for mail sorting.
                                        "road": "str",  # Optional. Street
                                          name.
                                        "state": "str",  # Optional.
                                          First-level administrative division.
                                        "stateDistrict": "str",  # Optional.
                                          Second-level administrative division used in certain locales.
                                        "streetAddress": "str",  # Optional.
                                          Street-level address, excluding city, state, countryRegion,
                                          and postalCode.
                                        "suburb": "str",  # Optional.
                                          Unofficial neighborhood name, like Chinatown.
                                        "unit": "str"  # Optional. Apartment
                                          or office number.
                                    },
                                    "valueArray": [
                                        ...
                                    ],
                                    "valueBoolean": bool,  # Optional. Boolean
                                      value.
                                    "valueCountryRegion": "str",  # Optional.
                                      3-letter country code value (ISO 3166-1 alpha-3).
                                    "valueCurrency": {
                                        "amount": 0.0,  # Currency amount.
                                          Required.
                                        "currencyCode": "str",  # Optional.
                                          Resolved currency code (ISO 4217), if any.
                                        "currencySymbol": "str"  # Optional.
                                          Currency symbol label, if any.
                                    },
                                    "valueDate": "2020-02-20",  # Optional. Date
                                      value in YYYY-MM-DD format (ISO 8601).
                                    "valueInteger": 0,  # Optional. Integer
                                      value.
                                    "valueNumber": 0.0,  # Optional. Floating
                                      point value.
                                    "valueObject": {
                                        "str": ...
                                    },
                                    "valuePhoneNumber": "str",  # Optional. Phone
                                      number value in E.164 format (ex. +19876543210).
                                    "valueSelectionGroup": [
                                        "str"  # Optional. Selection group
                                          value.
                                    ],
                                    "valueSelectionMark": "str",  # Optional.
                                      Selection mark value. Known values are: "selected" and
                                      "unselected".
                                    "valueSignature": "str",  # Optional.
                                      Presence of signature. Known values are: "signed" and "unsigned".
                                    "valueString": "str",  # Optional. String
                                      value.
                                    "valueTime": "12:30:00"  # Optional. Time
                                      value in hh:mm:ss format (ISO 8601).
                                }
                            }
                        }
                    ],
                    "figures": [
                        {
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "boundingRegions": [
                                {
                                    "pageNumber": 0,  # 1-based page number of
                                      page containing the bounding region. Required.
                                    "polygon": [
                                        0.0  # Bounding polygon on the page,
                                          or the entire page if not specified. Coordinates specified
                                          relative to the top-left of the page. The numbers represent
                                          the x, y values of the polygon vertices, clockwise from the
                                          left (-180 degrees inclusive) relative to the element
                                          orientation. Required.
                                    ]
                                }
                            ],
                            "caption": {
                                "content": "str",  # Content of the caption.
                                  Required.
                                "spans": [
                                    {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    }
                                ],
                                "boundingRegions": [
                                    {
                                        "pageNumber": 0,  # 1-based page
                                          number of page containing the bounding region. Required.
                                        "polygon": [
                                            0.0  # Bounding polygon on
                                              the page, or the entire page if not specified.
                                              Coordinates specified relative to the top-left of the
                                              page. The numbers represent the x, y values of the
                                              polygon vertices, clockwise from the left (-180 degrees
                                              inclusive) relative to the element orientation. Required.
                                        ]
                                    }
                                ],
                                "elements": [
                                    "str"  # Optional. Child elements of the
                                      caption.
                                ]
                            },
                            "elements": [
                                "str"  # Optional. Child elements of the figure,
                                  excluding any caption or footnotes.
                            ],
                            "footnotes": [
                                {
                                    "content": "str",  # Content of the footnote.
                                      Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "elements": [
                                        "str"  # Optional. Child elements of
                                          the footnote.
                                    ]
                                }
                            ]
                        }
                    ],
                    "keyValuePairs": [
                        {
                            "confidence": 0.0,  # Confidence of correctly extracting the
                              key-value pair. Required.
                            "key": {
                                "content": "str",  # Concatenated content of the
                                  key-value element in reading order. Required.
                                "spans": [
                                    {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    }
                                ],
                                "boundingRegions": [
                                    {
                                        "pageNumber": 0,  # 1-based page
                                          number of page containing the bounding region. Required.
                                        "polygon": [
                                            0.0  # Bounding polygon on
                                              the page, or the entire page if not specified.
                                              Coordinates specified relative to the top-left of the
                                              page. The numbers represent the x, y values of the
                                              polygon vertices, clockwise from the left (-180 degrees
                                              inclusive) relative to the element orientation. Required.
                                        ]
                                    }
                                ]
                            },
                            "value": {
                                "content": "str",  # Concatenated content of the
                                  key-value element in reading order. Required.
                                "spans": [
                                    {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    }
                                ],
                                "boundingRegions": [
                                    {
                                        "pageNumber": 0,  # 1-based page
                                          number of page containing the bounding region. Required.
                                        "polygon": [
                                            0.0  # Bounding polygon on
                                              the page, or the entire page if not specified.
                                              Coordinates specified relative to the top-left of the
                                              page. The numbers represent the x, y values of the
                                              polygon vertices, clockwise from the left (-180 degrees
                                              inclusive) relative to the element orientation. Required.
                                        ]
                                    }
                                ]
                            }
                        }
                    ],
                    "languages": [
                        {
                            "confidence": 0.0,  # Confidence of correctly identifying the
                              language. Required.
                            "locale": "str",  # Detected language.  Value may an ISO
                              639-1 language code (ex. "en", "fr") or BCP 47 language tag (ex.
                              "zh-Hans"). Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ]
                        }
                    ],
                    "lists": [
                        {
                            "items": [
                                {
                                    "content": "str",  # Content of the list
                                      item. Required.
                                    "level": 0,  # Level of the list item
                                      (1-indexed). Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "elements": [
                                        "str"  # Optional. Child elements of
                                          the list item.
                                    ]
                                }
                            ],
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ]
                        }
                    ],
                    "paragraphs": [
                        {
                            "content": "str",  # Concatenated content of the paragraph in
                              reading order. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "boundingRegions": [
                                {
                                    "pageNumber": 0,  # 1-based page number of
                                      page containing the bounding region. Required.
                                    "polygon": [
                                        0.0  # Bounding polygon on the page,
                                          or the entire page if not specified. Coordinates specified
                                          relative to the top-left of the page. The numbers represent
                                          the x, y values of the polygon vertices, clockwise from the
                                          left (-180 degrees inclusive) relative to the element
                                          orientation. Required.
                                    ]
                                }
                            ],
                            "role": "str"  # Optional. Semantic role of the paragraph.
                              Known values are: "pageHeader", "pageFooter", "pageNumber", "title",
                              "sectionHeading", "footnote", and "formulaBlock".
                        }
                    ],
                    "sections": [
                        {
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "elements": [
                                "str"  # Optional. Child elements of the section.
                            ]
                        }
                    ],
                    "styles": [
                        {
                            "confidence": 0.0,  # Confidence of correctly identifying the
                              style. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "backgroundColor": "str",  # Optional. Background color in
                              #rrggbb hexadecimal format..
                            "color": "str",  # Optional. Foreground color in #rrggbb
                              hexadecimal format.
                            "fontStyle": "str",  # Optional. Font style. Known values
                              are: "normal" and "italic".
                            "fontWeight": "str",  # Optional. Font weight. Known values
                              are: "normal" and "bold".
                            "isHandwritten": bool,  # Optional. Is content handwritten?.
                            "similarFontFamily": "str"  # Optional. Visually most similar
                              font from among the set of supported font families, with fallback fonts
                              following CSS convention (ex. 'Arial, sans-serif').
                        }
                    ],
                    "tables": [
                        {
                            "cells": [
                                {
                                    "columnIndex": 0,  # Column index of the
                                      cell. Required.
                                    "content": "str",  # Concatenated content of
                                      the table cell in reading order. Required.
                                    "rowIndex": 0,  # Row index of the cell.
                                      Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "columnSpan": 0,  # Optional. Number of
                                      columns spanned by this cell.
                                    "elements": [
                                        "str"  # Optional. Child elements of
                                          the table cell.
                                    ],
                                    "kind": "str",  # Optional. Table cell kind.
                                      Known values are: "content", "rowHeader", "columnHeader",
                                      "stubHead", and "description".
                                    "rowSpan": 0  # Optional. Number of rows
                                      spanned by this cell.
                                }
                            ],
                            "columnCount": 0,  # Number of columns in the table.
                              Required.
                            "rowCount": 0,  # Number of rows in the table. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "boundingRegions": [
                                {
                                    "pageNumber": 0,  # 1-based page number of
                                      page containing the bounding region. Required.
                                    "polygon": [
                                        0.0  # Bounding polygon on the page,
                                          or the entire page if not specified. Coordinates specified
                                          relative to the top-left of the page. The numbers represent
                                          the x, y values of the polygon vertices, clockwise from the
                                          left (-180 degrees inclusive) relative to the element
                                          orientation. Required.
                                    ]
                                }
                            ],
                            "caption": {
                                "content": "str",  # Content of the caption.
                                  Required.
                                "spans": [
                                    {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    }
                                ],
                                "boundingRegions": [
                                    {
                                        "pageNumber": 0,  # 1-based page
                                          number of page containing the bounding region. Required.
                                        "polygon": [
                                            0.0  # Bounding polygon on
                                              the page, or the entire page if not specified.
                                              Coordinates specified relative to the top-left of the
                                              page. The numbers represent the x, y values of the
                                              polygon vertices, clockwise from the left (-180 degrees
                                              inclusive) relative to the element orientation. Required.
                                        ]
                                    }
                                ],
                                "elements": [
                                    "str"  # Optional. Child elements of the
                                      caption.
                                ]
                            },
                            "footnotes": [
                                {
                                    "content": "str",  # Content of the footnote.
                                      Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "elements": [
                                        "str"  # Optional. Child elements of
                                          the footnote.
                                    ]
                                }
                            ]
                        }
                    ]
                }
        """

    @overload
    async def begin_analyze_document(
        self,
        model_id: str,
        analyze_request: Optional[IO[bytes]] = None,
        *,
        pages: Optional[str] = None,
        locale: Optional[str] = None,
        string_index_type: Optional[Union[str, _models.StringIndexType]] = None,
        features: Optional[List[Union[str, _models.DocumentAnalysisFeature]]] = None,
        query_fields: Optional[List[str]] = None,
        output_content_format: Optional[Union[str, _models.ContentFormat]] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.AnalyzeResult]:
        # pylint: disable=line-too-long
        """Analyzes document with document model.

        :param model_id: Unique document model name. Required.
        :type model_id: str
        :param analyze_request: Analyze request parameters. Default value is None.
        :type analyze_request: IO[bytes]
        :keyword pages: List of 1-based page numbers to analyze.  Ex. "1-3,5,7-9". Default value is
         None.
        :paramtype pages: str
        :keyword locale: Locale hint for text recognition and document analysis.  Value may contain
         only
         the language code (ex. "en", "fr") or BCP 47 language tag (ex. "en-US"). Default value is
         None.
        :paramtype locale: str
        :keyword string_index_type: Method used to compute string offset and length. Known values are:
         "textElements", "unicodeCodePoint", and "utf16CodeUnit". Default value is None.
        :paramtype string_index_type: str or ~azure.ai.documentintelligence.models.StringIndexType
        :keyword features: List of optional analysis features. Default value is None.
        :paramtype features: list[str or ~azure.ai.documentintelligence.models.DocumentAnalysisFeature]
        :keyword query_fields: List of additional fields to extract.  Ex. "NumberOfGuests,StoreNumber".
         Default value is None.
        :paramtype query_fields: list[str]
        :keyword output_content_format: Format of the analyze result top-level content. Known values
         are: "text" and "markdown". Default value is None.
        :paramtype output_content_format: str or ~azure.ai.documentintelligence.models.ContentFormat
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns AnalyzeResult. The AnalyzeResult is
         compatible with MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.ai.documentintelligence.models.AnalyzeResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "apiVersion": "str",  # API version used to produce this result. Required.
                    "content": "str",  # Concatenate string representation of all textual and
                      visual elements in reading order. Required.
                    "modelId": "str",  # Document model ID used to produce this result. Required.
                    "pages": [
                        {
                            "pageNumber": 0,  # 1-based page number in the input
                              document. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "angle": 0.0,  # Optional. The general orientation of the
                              content in clockwise direction, measured in degrees between (-180, 180].
                            "barcodes": [
                                {
                                    "confidence": 0.0,  # Confidence of correctly
                                      extracting the barcode. Required.
                                    "kind": "str",  # Barcode kind. Required.
                                      Known values are: "QRCode", "PDF417", "UPCA", "UPCE", "Code39",
                                      "Code128", "EAN8", "EAN13", "DataBar", "Code93", "Codabar",
                                      "DataBarExpanded", "ITF", "MicroQRCode", "Aztec", "DataMatrix",
                                      and "MaxiCode".
                                    "span": {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    },
                                    "value": "str",  # Barcode value. Required.
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the barcode, with coordinates specified relative to the
                                          top-left of the page. The numbers represent the x, y values
                                          of the polygon vertices, clockwise from the left (-180
                                          degrees inclusive) relative to the element orientation.
                                    ]
                                }
                            ],
                            "formulas": [
                                {
                                    "confidence": 0.0,  # Confidence of correctly
                                      extracting the formula. Required.
                                    "kind": "str",  # Formula kind. Required.
                                      Known values are: "inline" and "display".
                                    "span": {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    },
                                    "value": "str",  # LaTex expression
                                      describing the formula. Required.
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the formula, with coordinates specified relative to the
                                          top-left of the page. The numbers represent the x, y values
                                          of the polygon vertices, clockwise from the left (-180
                                          degrees inclusive) relative to the element orientation.
                                    ]
                                }
                            ],
                            "height": 0.0,  # Optional. The height of the image/PDF in
                              pixels/inches, respectively.
                            "lines": [
                                {
                                    "content": "str",  # Concatenated content of
                                      the contained elements in reading order. Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the line, with coordinates specified relative to the top-left
                                          of the page. The numbers represent the x, y values of the
                                          polygon vertices, clockwise from the left (-180 degrees
                                          inclusive) relative to the element orientation.
                                    ]
                                }
                            ],
                            "selectionMarks": [
                                {
                                    "confidence": 0.0,  # Confidence of correctly
                                      extracting the selection mark. Required.
                                    "span": {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    },
                                    "state": "str",  # State of the selection
                                      mark. Required. Known values are: "selected" and "unselected".
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the selection mark, with coordinates specified relative to
                                          the top-left of the page. The numbers represent the x, y
                                          values of the polygon vertices, clockwise from the left (-180
                                          degrees inclusive) relative to the element orientation.
                                    ]
                                }
                            ],
                            "unit": "str",  # Optional. The unit used by the width,
                              height, and polygon properties. For images, the unit is "pixel". For PDF,
                              the unit is "inch". Known values are: "pixel" and "inch".
                            "width": 0.0,  # Optional. The width of the image/PDF in
                              pixels/inches, respectively.
                            "words": [
                                {
                                    "confidence": 0.0,  # Confidence of correctly
                                      extracting the word. Required.
                                    "content": "str",  # Text content of the
                                      word. Required.
                                    "span": {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    },
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the word, with coordinates specified relative to the top-left
                                          of the page. The numbers represent the x, y values of the
                                          polygon vertices, clockwise from the left (-180 degrees
                                          inclusive) relative to the element orientation.
                                    ]
                                }
                            ]
                        }
                    ],
                    "stringIndexType": "str",  # Method used to compute string offset and length.
                      Required. Known values are: "textElements", "unicodeCodePoint", and
                      "utf16CodeUnit".
                    "contentFormat": "str",  # Optional. Format of the analyze result top-level
                      content. Known values are: "text" and "markdown".
                    "documents": [
                        {
                            "confidence": 0.0,  # Confidence of correctly extracting the
                              document. Required.
                            "docType": "str",  # Document type. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "boundingRegions": [
                                {
                                    "pageNumber": 0,  # 1-based page number of
                                      page containing the bounding region. Required.
                                    "polygon": [
                                        0.0  # Bounding polygon on the page,
                                          or the entire page if not specified. Coordinates specified
                                          relative to the top-left of the page. The numbers represent
                                          the x, y values of the polygon vertices, clockwise from the
                                          left (-180 degrees inclusive) relative to the element
                                          orientation. Required.
                                    ]
                                }
                            ],
                            "fields": {
                                "str": {
                                    "type": "str",  # Data type of the field
                                      value. Required. Known values are: "string", "date", "time",
                                      "phoneNumber", "number", "integer", "selectionMark",
                                      "countryRegion", "signature", "array", "object", "currency",
                                      "address", "boolean", and "selectionGroup".
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "confidence": 0.0,  # Optional. Confidence of
                                      correctly extracting the field.
                                    "content": "str",  # Optional. Field content.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "valueAddress": {
                                        "city": "str",  # Optional. Name of
                                          city, town, village, etc.
                                        "cityDistrict": "str",  # Optional.
                                          Districts or boroughs within a city, such as Brooklyn in New
                                          York City or City of Westminster in London.
                                        "countryRegion": "str",  # Optional.
                                          Country/region.
                                        "house": "str",  # Optional. Build
                                          name, such as World Trade Center.
                                        "houseNumber": "str",  # Optional.
                                          House or building number.
                                        "level": "str",  # Optional. Floor
                                          number, such as 3F.
                                        "poBox": "str",  # Optional. Post
                                          office box number.
                                        "postalCode": "str",  # Optional.
                                          Postal code used for mail sorting.
                                        "road": "str",  # Optional. Street
                                          name.
                                        "state": "str",  # Optional.
                                          First-level administrative division.
                                        "stateDistrict": "str",  # Optional.
                                          Second-level administrative division used in certain locales.
                                        "streetAddress": "str",  # Optional.
                                          Street-level address, excluding city, state, countryRegion,
                                          and postalCode.
                                        "suburb": "str",  # Optional.
                                          Unofficial neighborhood name, like Chinatown.
                                        "unit": "str"  # Optional. Apartment
                                          or office number.
                                    },
                                    "valueArray": [
                                        ...
                                    ],
                                    "valueBoolean": bool,  # Optional. Boolean
                                      value.
                                    "valueCountryRegion": "str",  # Optional.
                                      3-letter country code value (ISO 3166-1 alpha-3).
                                    "valueCurrency": {
                                        "amount": 0.0,  # Currency amount.
                                          Required.
                                        "currencyCode": "str",  # Optional.
                                          Resolved currency code (ISO 4217), if any.
                                        "currencySymbol": "str"  # Optional.
                                          Currency symbol label, if any.
                                    },
                                    "valueDate": "2020-02-20",  # Optional. Date
                                      value in YYYY-MM-DD format (ISO 8601).
                                    "valueInteger": 0,  # Optional. Integer
                                      value.
                                    "valueNumber": 0.0,  # Optional. Floating
                                      point value.
                                    "valueObject": {
                                        "str": ...
                                    },
                                    "valuePhoneNumber": "str",  # Optional. Phone
                                      number value in E.164 format (ex. +19876543210).
                                    "valueSelectionGroup": [
                                        "str"  # Optional. Selection group
                                          value.
                                    ],
                                    "valueSelectionMark": "str",  # Optional.
                                      Selection mark value. Known values are: "selected" and
                                      "unselected".
                                    "valueSignature": "str",  # Optional.
                                      Presence of signature. Known values are: "signed" and "unsigned".
                                    "valueString": "str",  # Optional. String
                                      value.
                                    "valueTime": "12:30:00"  # Optional. Time
                                      value in hh:mm:ss format (ISO 8601).
                                }
                            }
                        }
                    ],
                    "figures": [
                        {
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "boundingRegions": [
                                {
                                    "pageNumber": 0,  # 1-based page number of
                                      page containing the bounding region. Required.
                                    "polygon": [
                                        0.0  # Bounding polygon on the page,
                                          or the entire page if not specified. Coordinates specified
                                          relative to the top-left of the page. The numbers represent
                                          the x, y values of the polygon vertices, clockwise from the
                                          left (-180 degrees inclusive) relative to the element
                                          orientation. Required.
                                    ]
                                }
                            ],
                            "caption": {
                                "content": "str",  # Content of the caption.
                                  Required.
                                "spans": [
                                    {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    }
                                ],
                                "boundingRegions": [
                                    {
                                        "pageNumber": 0,  # 1-based page
                                          number of page containing the bounding region. Required.
                                        "polygon": [
                                            0.0  # Bounding polygon on
                                              the page, or the entire page if not specified.
                                              Coordinates specified relative to the top-left of the
                                              page. The numbers represent the x, y values of the
                                              polygon vertices, clockwise from the left (-180 degrees
                                              inclusive) relative to the element orientation. Required.
                                        ]
                                    }
                                ],
                                "elements": [
                                    "str"  # Optional. Child elements of the
                                      caption.
                                ]
                            },
                            "elements": [
                                "str"  # Optional. Child elements of the figure,
                                  excluding any caption or footnotes.
                            ],
                            "footnotes": [
                                {
                                    "content": "str",  # Content of the footnote.
                                      Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "elements": [
                                        "str"  # Optional. Child elements of
                                          the footnote.
                                    ]
                                }
                            ]
                        }
                    ],
                    "keyValuePairs": [
                        {
                            "confidence": 0.0,  # Confidence of correctly extracting the
                              key-value pair. Required.
                            "key": {
                                "content": "str",  # Concatenated content of the
                                  key-value element in reading order. Required.
                                "spans": [
                                    {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    }
                                ],
                                "boundingRegions": [
                                    {
                                        "pageNumber": 0,  # 1-based page
                                          number of page containing the bounding region. Required.
                                        "polygon": [
                                            0.0  # Bounding polygon on
                                              the page, or the entire page if not specified.
                                              Coordinates specified relative to the top-left of the
                                              page. The numbers represent the x, y values of the
                                              polygon vertices, clockwise from the left (-180 degrees
                                              inclusive) relative to the element orientation. Required.
                                        ]
                                    }
                                ]
                            },
                            "value": {
                                "content": "str",  # Concatenated content of the
                                  key-value element in reading order. Required.
                                "spans": [
                                    {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    }
                                ],
                                "boundingRegions": [
                                    {
                                        "pageNumber": 0,  # 1-based page
                                          number of page containing the bounding region. Required.
                                        "polygon": [
                                            0.0  # Bounding polygon on
                                              the page, or the entire page if not specified.
                                              Coordinates specified relative to the top-left of the
                                              page. The numbers represent the x, y values of the
                                              polygon vertices, clockwise from the left (-180 degrees
                                              inclusive) relative to the element orientation. Required.
                                        ]
                                    }
                                ]
                            }
                        }
                    ],
                    "languages": [
                        {
                            "confidence": 0.0,  # Confidence of correctly identifying the
                              language. Required.
                            "locale": "str",  # Detected language.  Value may an ISO
                              639-1 language code (ex. "en", "fr") or BCP 47 language tag (ex.
                              "zh-Hans"). Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ]
                        }
                    ],
                    "lists": [
                        {
                            "items": [
                                {
                                    "content": "str",  # Content of the list
                                      item. Required.
                                    "level": 0,  # Level of the list item
                                      (1-indexed). Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "elements": [
                                        "str"  # Optional. Child elements of
                                          the list item.
                                    ]
                                }
                            ],
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ]
                        }
                    ],
                    "paragraphs": [
                        {
                            "content": "str",  # Concatenated content of the paragraph in
                              reading order. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "boundingRegions": [
                                {
                                    "pageNumber": 0,  # 1-based page number of
                                      page containing the bounding region. Required.
                                    "polygon": [
                                        0.0  # Bounding polygon on the page,
                                          or the entire page if not specified. Coordinates specified
                                          relative to the top-left of the page. The numbers represent
                                          the x, y values of the polygon vertices, clockwise from the
                                          left (-180 degrees inclusive) relative to the element
                                          orientation. Required.
                                    ]
                                }
                            ],
                            "role": "str"  # Optional. Semantic role of the paragraph.
                              Known values are: "pageHeader", "pageFooter", "pageNumber", "title",
                              "sectionHeading", "footnote", and "formulaBlock".
                        }
                    ],
                    "sections": [
                        {
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "elements": [
                                "str"  # Optional. Child elements of the section.
                            ]
                        }
                    ],
                    "styles": [
                        {
                            "confidence": 0.0,  # Confidence of correctly identifying the
                              style. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "backgroundColor": "str",  # Optional. Background color in
                              #rrggbb hexadecimal format..
                            "color": "str",  # Optional. Foreground color in #rrggbb
                              hexadecimal format.
                            "fontStyle": "str",  # Optional. Font style. Known values
                              are: "normal" and "italic".
                            "fontWeight": "str",  # Optional. Font weight. Known values
                              are: "normal" and "bold".
                            "isHandwritten": bool,  # Optional. Is content handwritten?.
                            "similarFontFamily": "str"  # Optional. Visually most similar
                              font from among the set of supported font families, with fallback fonts
                              following CSS convention (ex. 'Arial, sans-serif').
                        }
                    ],
                    "tables": [
                        {
                            "cells": [
                                {
                                    "columnIndex": 0,  # Column index of the
                                      cell. Required.
                                    "content": "str",  # Concatenated content of
                                      the table cell in reading order. Required.
                                    "rowIndex": 0,  # Row index of the cell.
                                      Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "columnSpan": 0,  # Optional. Number of
                                      columns spanned by this cell.
                                    "elements": [
                                        "str"  # Optional. Child elements of
                                          the table cell.
                                    ],
                                    "kind": "str",  # Optional. Table cell kind.
                                      Known values are: "content", "rowHeader", "columnHeader",
                                      "stubHead", and "description".
                                    "rowSpan": 0  # Optional. Number of rows
                                      spanned by this cell.
                                }
                            ],
                            "columnCount": 0,  # Number of columns in the table.
                              Required.
                            "rowCount": 0,  # Number of rows in the table. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "boundingRegions": [
                                {
                                    "pageNumber": 0,  # 1-based page number of
                                      page containing the bounding region. Required.
                                    "polygon": [
                                        0.0  # Bounding polygon on the page,
                                          or the entire page if not specified. Coordinates specified
                                          relative to the top-left of the page. The numbers represent
                                          the x, y values of the polygon vertices, clockwise from the
                                          left (-180 degrees inclusive) relative to the element
                                          orientation. Required.
                                    ]
                                }
                            ],
                            "caption": {
                                "content": "str",  # Content of the caption.
                                  Required.
                                "spans": [
                                    {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    }
                                ],
                                "boundingRegions": [
                                    {
                                        "pageNumber": 0,  # 1-based page
                                          number of page containing the bounding region. Required.
                                        "polygon": [
                                            0.0  # Bounding polygon on
                                              the page, or the entire page if not specified.
                                              Coordinates specified relative to the top-left of the
                                              page. The numbers represent the x, y values of the
                                              polygon vertices, clockwise from the left (-180 degrees
                                              inclusive) relative to the element orientation. Required.
                                        ]
                                    }
                                ],
                                "elements": [
                                    "str"  # Optional. Child elements of the
                                      caption.
                                ]
                            },
                            "footnotes": [
                                {
                                    "content": "str",  # Content of the footnote.
                                      Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "elements": [
                                        "str"  # Optional. Child elements of
                                          the footnote.
                                    ]
                                }
                            ]
                        }
                    ]
                }
        """

    @distributed_trace_async
    async def begin_analyze_document(
        self,
        model_id: str,
        analyze_request: Optional[Union[_models.AnalyzeDocumentRequest, JSON, IO[bytes]]] = None,
        *,
        pages: Optional[str] = None,
        locale: Optional[str] = None,
        string_index_type: Optional[Union[str, _models.StringIndexType]] = None,
        features: Optional[List[Union[str, _models.DocumentAnalysisFeature]]] = None,
        query_fields: Optional[List[str]] = None,
        output_content_format: Optional[Union[str, _models.ContentFormat]] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[_models.AnalyzeResult]:
        # pylint: disable=line-too-long
        """Analyzes document with document model.

        :param model_id: Unique document model name. Required.
        :type model_id: str
        :param analyze_request: Analyze request parameters. Is one of the following types:
         AnalyzeDocumentRequest, JSON, IO[bytes] Default value is None.
        :type analyze_request: ~azure.ai.documentintelligence.models.AnalyzeDocumentRequest or JSON or
         IO[bytes]
        :keyword pages: List of 1-based page numbers to analyze.  Ex. "1-3,5,7-9". Default value is
         None.
        :paramtype pages: str
        :keyword locale: Locale hint for text recognition and document analysis.  Value may contain
         only
         the language code (ex. "en", "fr") or BCP 47 language tag (ex. "en-US"). Default value is
         None.
        :paramtype locale: str
        :keyword string_index_type: Method used to compute string offset and length. Known values are:
         "textElements", "unicodeCodePoint", and "utf16CodeUnit". Default value is None.
        :paramtype string_index_type: str or ~azure.ai.documentintelligence.models.StringIndexType
        :keyword features: List of optional analysis features. Default value is None.
        :paramtype features: list[str or ~azure.ai.documentintelligence.models.DocumentAnalysisFeature]
        :keyword query_fields: List of additional fields to extract.  Ex. "NumberOfGuests,StoreNumber".
         Default value is None.
        :paramtype query_fields: list[str]
        :keyword output_content_format: Format of the analyze result top-level content. Known values
         are: "text" and "markdown". Default value is None.
        :paramtype output_content_format: str or ~azure.ai.documentintelligence.models.ContentFormat
        :return: An instance of AsyncLROPoller that returns AnalyzeResult. The AnalyzeResult is
         compatible with MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.ai.documentintelligence.models.AnalyzeResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                analyze_request = {
                    "base64Source": bytes("bytes", encoding="utf-8"),  # Optional. Base64
                      encoding of the document to analyze.  Either urlSource or base64Source must be
                      specified.
                    "urlSource": "str"  # Optional. Document URL to analyze.  Either urlSource or
                      base64Source must be specified.
                }

                # response body for status code(s): 202
                response == {
                    "apiVersion": "str",  # API version used to produce this result. Required.
                    "content": "str",  # Concatenate string representation of all textual and
                      visual elements in reading order. Required.
                    "modelId": "str",  # Document model ID used to produce this result. Required.
                    "pages": [
                        {
                            "pageNumber": 0,  # 1-based page number in the input
                              document. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "angle": 0.0,  # Optional. The general orientation of the
                              content in clockwise direction, measured in degrees between (-180, 180].
                            "barcodes": [
                                {
                                    "confidence": 0.0,  # Confidence of correctly
                                      extracting the barcode. Required.
                                    "kind": "str",  # Barcode kind. Required.
                                      Known values are: "QRCode", "PDF417", "UPCA", "UPCE", "Code39",
                                      "Code128", "EAN8", "EAN13", "DataBar", "Code93", "Codabar",
                                      "DataBarExpanded", "ITF", "MicroQRCode", "Aztec", "DataMatrix",
                                      and "MaxiCode".
                                    "span": {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    },
                                    "value": "str",  # Barcode value. Required.
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the barcode, with coordinates specified relative to the
                                          top-left of the page. The numbers represent the x, y values
                                          of the polygon vertices, clockwise from the left (-180
                                          degrees inclusive) relative to the element orientation.
                                    ]
                                }
                            ],
                            "formulas": [
                                {
                                    "confidence": 0.0,  # Confidence of correctly
                                      extracting the formula. Required.
                                    "kind": "str",  # Formula kind. Required.
                                      Known values are: "inline" and "display".
                                    "span": {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    },
                                    "value": "str",  # LaTex expression
                                      describing the formula. Required.
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the formula, with coordinates specified relative to the
                                          top-left of the page. The numbers represent the x, y values
                                          of the polygon vertices, clockwise from the left (-180
                                          degrees inclusive) relative to the element orientation.
                                    ]
                                }
                            ],
                            "height": 0.0,  # Optional. The height of the image/PDF in
                              pixels/inches, respectively.
                            "lines": [
                                {
                                    "content": "str",  # Concatenated content of
                                      the contained elements in reading order. Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the line, with coordinates specified relative to the top-left
                                          of the page. The numbers represent the x, y values of the
                                          polygon vertices, clockwise from the left (-180 degrees
                                          inclusive) relative to the element orientation.
                                    ]
                                }
                            ],
                            "selectionMarks": [
                                {
                                    "confidence": 0.0,  # Confidence of correctly
                                      extracting the selection mark. Required.
                                    "span": {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    },
                                    "state": "str",  # State of the selection
                                      mark. Required. Known values are: "selected" and "unselected".
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the selection mark, with coordinates specified relative to
                                          the top-left of the page. The numbers represent the x, y
                                          values of the polygon vertices, clockwise from the left (-180
                                          degrees inclusive) relative to the element orientation.
                                    ]
                                }
                            ],
                            "unit": "str",  # Optional. The unit used by the width,
                              height, and polygon properties. For images, the unit is "pixel". For PDF,
                              the unit is "inch". Known values are: "pixel" and "inch".
                            "width": 0.0,  # Optional. The width of the image/PDF in
                              pixels/inches, respectively.
                            "words": [
                                {
                                    "confidence": 0.0,  # Confidence of correctly
                                      extracting the word. Required.
                                    "content": "str",  # Text content of the
                                      word. Required.
                                    "span": {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    },
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the word, with coordinates specified relative to the top-left
                                          of the page. The numbers represent the x, y values of the
                                          polygon vertices, clockwise from the left (-180 degrees
                                          inclusive) relative to the element orientation.
                                    ]
                                }
                            ]
                        }
                    ],
                    "stringIndexType": "str",  # Method used to compute string offset and length.
                      Required. Known values are: "textElements", "unicodeCodePoint", and
                      "utf16CodeUnit".
                    "contentFormat": "str",  # Optional. Format of the analyze result top-level
                      content. Known values are: "text" and "markdown".
                    "documents": [
                        {
                            "confidence": 0.0,  # Confidence of correctly extracting the
                              document. Required.
                            "docType": "str",  # Document type. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "boundingRegions": [
                                {
                                    "pageNumber": 0,  # 1-based page number of
                                      page containing the bounding region. Required.
                                    "polygon": [
                                        0.0  # Bounding polygon on the page,
                                          or the entire page if not specified. Coordinates specified
                                          relative to the top-left of the page. The numbers represent
                                          the x, y values of the polygon vertices, clockwise from the
                                          left (-180 degrees inclusive) relative to the element
                                          orientation. Required.
                                    ]
                                }
                            ],
                            "fields": {
                                "str": {
                                    "type": "str",  # Data type of the field
                                      value. Required. Known values are: "string", "date", "time",
                                      "phoneNumber", "number", "integer", "selectionMark",
                                      "countryRegion", "signature", "array", "object", "currency",
                                      "address", "boolean", and "selectionGroup".
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "confidence": 0.0,  # Optional. Confidence of
                                      correctly extracting the field.
                                    "content": "str",  # Optional. Field content.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "valueAddress": {
                                        "city": "str",  # Optional. Name of
                                          city, town, village, etc.
                                        "cityDistrict": "str",  # Optional.
                                          Districts or boroughs within a city, such as Brooklyn in New
                                          York City or City of Westminster in London.
                                        "countryRegion": "str",  # Optional.
                                          Country/region.
                                        "house": "str",  # Optional. Build
                                          name, such as World Trade Center.
                                        "houseNumber": "str",  # Optional.
                                          House or building number.
                                        "level": "str",  # Optional. Floor
                                          number, such as 3F.
                                        "poBox": "str",  # Optional. Post
                                          office box number.
                                        "postalCode": "str",  # Optional.
                                          Postal code used for mail sorting.
                                        "road": "str",  # Optional. Street
                                          name.
                                        "state": "str",  # Optional.
                                          First-level administrative division.
                                        "stateDistrict": "str",  # Optional.
                                          Second-level administrative division used in certain locales.
                                        "streetAddress": "str",  # Optional.
                                          Street-level address, excluding city, state, countryRegion,
                                          and postalCode.
                                        "suburb": "str",  # Optional.
                                          Unofficial neighborhood name, like Chinatown.
                                        "unit": "str"  # Optional. Apartment
                                          or office number.
                                    },
                                    "valueArray": [
                                        ...
                                    ],
                                    "valueBoolean": bool,  # Optional. Boolean
                                      value.
                                    "valueCountryRegion": "str",  # Optional.
                                      3-letter country code value (ISO 3166-1 alpha-3).
                                    "valueCurrency": {
                                        "amount": 0.0,  # Currency amount.
                                          Required.
                                        "currencyCode": "str",  # Optional.
                                          Resolved currency code (ISO 4217), if any.
                                        "currencySymbol": "str"  # Optional.
                                          Currency symbol label, if any.
                                    },
                                    "valueDate": "2020-02-20",  # Optional. Date
                                      value in YYYY-MM-DD format (ISO 8601).
                                    "valueInteger": 0,  # Optional. Integer
                                      value.
                                    "valueNumber": 0.0,  # Optional. Floating
                                      point value.
                                    "valueObject": {
                                        "str": ...
                                    },
                                    "valuePhoneNumber": "str",  # Optional. Phone
                                      number value in E.164 format (ex. +19876543210).
                                    "valueSelectionGroup": [
                                        "str"  # Optional. Selection group
                                          value.
                                    ],
                                    "valueSelectionMark": "str",  # Optional.
                                      Selection mark value. Known values are: "selected" and
                                      "unselected".
                                    "valueSignature": "str",  # Optional.
                                      Presence of signature. Known values are: "signed" and "unsigned".
                                    "valueString": "str",  # Optional. String
                                      value.
                                    "valueTime": "12:30:00"  # Optional. Time
                                      value in hh:mm:ss format (ISO 8601).
                                }
                            }
                        }
                    ],
                    "figures": [
                        {
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "boundingRegions": [
                                {
                                    "pageNumber": 0,  # 1-based page number of
                                      page containing the bounding region. Required.
                                    "polygon": [
                                        0.0  # Bounding polygon on the page,
                                          or the entire page if not specified. Coordinates specified
                                          relative to the top-left of the page. The numbers represent
                                          the x, y values of the polygon vertices, clockwise from the
                                          left (-180 degrees inclusive) relative to the element
                                          orientation. Required.
                                    ]
                                }
                            ],
                            "caption": {
                                "content": "str",  # Content of the caption.
                                  Required.
                                "spans": [
                                    {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    }
                                ],
                                "boundingRegions": [
                                    {
                                        "pageNumber": 0,  # 1-based page
                                          number of page containing the bounding region. Required.
                                        "polygon": [
                                            0.0  # Bounding polygon on
                                              the page, or the entire page if not specified.
                                              Coordinates specified relative to the top-left of the
                                              page. The numbers represent the x, y values of the
                                              polygon vertices, clockwise from the left (-180 degrees
                                              inclusive) relative to the element orientation. Required.
                                        ]
                                    }
                                ],
                                "elements": [
                                    "str"  # Optional. Child elements of the
                                      caption.
                                ]
                            },
                            "elements": [
                                "str"  # Optional. Child elements of the figure,
                                  excluding any caption or footnotes.
                            ],
                            "footnotes": [
                                {
                                    "content": "str",  # Content of the footnote.
                                      Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "elements": [
                                        "str"  # Optional. Child elements of
                                          the footnote.
                                    ]
                                }
                            ]
                        }
                    ],
                    "keyValuePairs": [
                        {
                            "confidence": 0.0,  # Confidence of correctly extracting the
                              key-value pair. Required.
                            "key": {
                                "content": "str",  # Concatenated content of the
                                  key-value element in reading order. Required.
                                "spans": [
                                    {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    }
                                ],
                                "boundingRegions": [
                                    {
                                        "pageNumber": 0,  # 1-based page
                                          number of page containing the bounding region. Required.
                                        "polygon": [
                                            0.0  # Bounding polygon on
                                              the page, or the entire page if not specified.
                                              Coordinates specified relative to the top-left of the
                                              page. The numbers represent the x, y values of the
                                              polygon vertices, clockwise from the left (-180 degrees
                                              inclusive) relative to the element orientation. Required.
                                        ]
                                    }
                                ]
                            },
                            "value": {
                                "content": "str",  # Concatenated content of the
                                  key-value element in reading order. Required.
                                "spans": [
                                    {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    }
                                ],
                                "boundingRegions": [
                                    {
                                        "pageNumber": 0,  # 1-based page
                                          number of page containing the bounding region. Required.
                                        "polygon": [
                                            0.0  # Bounding polygon on
                                              the page, or the entire page if not specified.
                                              Coordinates specified relative to the top-left of the
                                              page. The numbers represent the x, y values of the
                                              polygon vertices, clockwise from the left (-180 degrees
                                              inclusive) relative to the element orientation. Required.
                                        ]
                                    }
                                ]
                            }
                        }
                    ],
                    "languages": [
                        {
                            "confidence": 0.0,  # Confidence of correctly identifying the
                              language. Required.
                            "locale": "str",  # Detected language.  Value may an ISO
                              639-1 language code (ex. "en", "fr") or BCP 47 language tag (ex.
                              "zh-Hans"). Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ]
                        }
                    ],
                    "lists": [
                        {
                            "items": [
                                {
                                    "content": "str",  # Content of the list
                                      item. Required.
                                    "level": 0,  # Level of the list item
                                      (1-indexed). Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "elements": [
                                        "str"  # Optional. Child elements of
                                          the list item.
                                    ]
                                }
                            ],
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ]
                        }
                    ],
                    "paragraphs": [
                        {
                            "content": "str",  # Concatenated content of the paragraph in
                              reading order. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "boundingRegions": [
                                {
                                    "pageNumber": 0,  # 1-based page number of
                                      page containing the bounding region. Required.
                                    "polygon": [
                                        0.0  # Bounding polygon on the page,
                                          or the entire page if not specified. Coordinates specified
                                          relative to the top-left of the page. The numbers represent
                                          the x, y values of the polygon vertices, clockwise from the
                                          left (-180 degrees inclusive) relative to the element
                                          orientation. Required.
                                    ]
                                }
                            ],
                            "role": "str"  # Optional. Semantic role of the paragraph.
                              Known values are: "pageHeader", "pageFooter", "pageNumber", "title",
                              "sectionHeading", "footnote", and "formulaBlock".
                        }
                    ],
                    "sections": [
                        {
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "elements": [
                                "str"  # Optional. Child elements of the section.
                            ]
                        }
                    ],
                    "styles": [
                        {
                            "confidence": 0.0,  # Confidence of correctly identifying the
                              style. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "backgroundColor": "str",  # Optional. Background color in
                              #rrggbb hexadecimal format..
                            "color": "str",  # Optional. Foreground color in #rrggbb
                              hexadecimal format.
                            "fontStyle": "str",  # Optional. Font style. Known values
                              are: "normal" and "italic".
                            "fontWeight": "str",  # Optional. Font weight. Known values
                              are: "normal" and "bold".
                            "isHandwritten": bool,  # Optional. Is content handwritten?.
                            "similarFontFamily": "str"  # Optional. Visually most similar
                              font from among the set of supported font families, with fallback fonts
                              following CSS convention (ex. 'Arial, sans-serif').
                        }
                    ],
                    "tables": [
                        {
                            "cells": [
                                {
                                    "columnIndex": 0,  # Column index of the
                                      cell. Required.
                                    "content": "str",  # Concatenated content of
                                      the table cell in reading order. Required.
                                    "rowIndex": 0,  # Row index of the cell.
                                      Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "columnSpan": 0,  # Optional. Number of
                                      columns spanned by this cell.
                                    "elements": [
                                        "str"  # Optional. Child elements of
                                          the table cell.
                                    ],
                                    "kind": "str",  # Optional. Table cell kind.
                                      Known values are: "content", "rowHeader", "columnHeader",
                                      "stubHead", and "description".
                                    "rowSpan": 0  # Optional. Number of rows
                                      spanned by this cell.
                                }
                            ],
                            "columnCount": 0,  # Number of columns in the table.
                              Required.
                            "rowCount": 0,  # Number of rows in the table. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "boundingRegions": [
                                {
                                    "pageNumber": 0,  # 1-based page number of
                                      page containing the bounding region. Required.
                                    "polygon": [
                                        0.0  # Bounding polygon on the page,
                                          or the entire page if not specified. Coordinates specified
                                          relative to the top-left of the page. The numbers represent
                                          the x, y values of the polygon vertices, clockwise from the
                                          left (-180 degrees inclusive) relative to the element
                                          orientation. Required.
                                    ]
                                }
                            ],
                            "caption": {
                                "content": "str",  # Content of the caption.
                                  Required.
                                "spans": [
                                    {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    }
                                ],
                                "boundingRegions": [
                                    {
                                        "pageNumber": 0,  # 1-based page
                                          number of page containing the bounding region. Required.
                                        "polygon": [
                                            0.0  # Bounding polygon on
                                              the page, or the entire page if not specified.
                                              Coordinates specified relative to the top-left of the
                                              page. The numbers represent the x, y values of the
                                              polygon vertices, clockwise from the left (-180 degrees
                                              inclusive) relative to the element orientation. Required.
                                        ]
                                    }
                                ],
                                "elements": [
                                    "str"  # Optional. Child elements of the
                                      caption.
                                ]
                            },
                            "footnotes": [
                                {
                                    "content": "str",  # Content of the footnote.
                                      Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "elements": [
                                        "str"  # Optional. Child elements of
                                          the footnote.
                                    ]
                                }
                            ]
                        }
                    ]
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("content-type", None))
        cls: ClsType[_models.AnalyzeResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._analyze_document_initial(  # type: ignore
                model_id=model_id,
                analyze_request=analyze_request,
                pages=pages,
                locale=locale,
                string_index_type=string_index_type,
                features=features,
                query_fields=query_fields,
                output_content_format=output_content_format,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

            deserialized = _deserialize(_models.AnalyzeResult, response.json().get("analyzeResult"))
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.AnalyzeResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.AnalyzeResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _classify_document_initial(  # pylint: disable=inconsistent-return-statements
        self,
        classifier_id: str,
        classify_request: Union[_models.ClassifyDocumentRequest, JSON, IO[bytes]],
        *,
        string_index_type: Optional[Union[str, _models.StringIndexType]] = None,
        split: Optional[Union[str, _models.SplitMode]] = None,
        **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("content-type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(classify_request, (IOBase, bytes)):
            _content = classify_request
        else:
            _content = json.dumps(classify_request, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_document_intelligence_classify_document_request(
            classifier_id=classifier_id,
            string_index_type=string_index_type,
            split=split,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))
        response_headers["Operation-Location"] = self._deserialize("str", response.headers.get("Operation-Location"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @overload
    async def begin_classify_document(
        self,
        classifier_id: str,
        classify_request: _models.ClassifyDocumentRequest,
        *,
        string_index_type: Optional[Union[str, _models.StringIndexType]] = None,
        split: Optional[Union[str, _models.SplitMode]] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.AnalyzeResult]:
        # pylint: disable=line-too-long
        """Classifies document with document classifier.

        :param classifier_id: Unique document classifier name. Required.
        :type classifier_id: str
        :param classify_request: Classify request parameters. Required.
        :type classify_request: ~azure.ai.documentintelligence.models.ClassifyDocumentRequest
        :keyword string_index_type: Method used to compute string offset and length. Known values are:
         "textElements", "unicodeCodePoint", and "utf16CodeUnit". Default value is None.
        :paramtype string_index_type: str or ~azure.ai.documentintelligence.models.StringIndexType
        :keyword split: Document splitting mode. Known values are: "auto", "none", and "perPage".
         Default value is None.
        :paramtype split: str or ~azure.ai.documentintelligence.models.SplitMode
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns AnalyzeResult. The AnalyzeResult is
         compatible with MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.ai.documentintelligence.models.AnalyzeResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                classify_request = {
                    "base64Source": bytes("bytes", encoding="utf-8"),  # Optional. Base64
                      encoding of the document to classify.  Either urlSource or base64Source must be
                      specified.
                    "urlSource": "str"  # Optional. Document URL to classify.  Either urlSource
                      or base64Source must be specified.
                }

                # response body for status code(s): 202
                response == {
                    "apiVersion": "str",  # API version used to produce this result. Required.
                    "content": "str",  # Concatenate string representation of all textual and
                      visual elements in reading order. Required.
                    "modelId": "str",  # Document model ID used to produce this result. Required.
                    "pages": [
                        {
                            "pageNumber": 0,  # 1-based page number in the input
                              document. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "angle": 0.0,  # Optional. The general orientation of the
                              content in clockwise direction, measured in degrees between (-180, 180].
                            "barcodes": [
                                {
                                    "confidence": 0.0,  # Confidence of correctly
                                      extracting the barcode. Required.
                                    "kind": "str",  # Barcode kind. Required.
                                      Known values are: "QRCode", "PDF417", "UPCA", "UPCE", "Code39",
                                      "Code128", "EAN8", "EAN13", "DataBar", "Code93", "Codabar",
                                      "DataBarExpanded", "ITF", "MicroQRCode", "Aztec", "DataMatrix",
                                      and "MaxiCode".
                                    "span": {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    },
                                    "value": "str",  # Barcode value. Required.
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the barcode, with coordinates specified relative to the
                                          top-left of the page. The numbers represent the x, y values
                                          of the polygon vertices, clockwise from the left (-180
                                          degrees inclusive) relative to the element orientation.
                                    ]
                                }
                            ],
                            "formulas": [
                                {
                                    "confidence": 0.0,  # Confidence of correctly
                                      extracting the formula. Required.
                                    "kind": "str",  # Formula kind. Required.
                                      Known values are: "inline" and "display".
                                    "span": {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    },
                                    "value": "str",  # LaTex expression
                                      describing the formula. Required.
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the formula, with coordinates specified relative to the
                                          top-left of the page. The numbers represent the x, y values
                                          of the polygon vertices, clockwise from the left (-180
                                          degrees inclusive) relative to the element orientation.
                                    ]
                                }
                            ],
                            "height": 0.0,  # Optional. The height of the image/PDF in
                              pixels/inches, respectively.
                            "lines": [
                                {
                                    "content": "str",  # Concatenated content of
                                      the contained elements in reading order. Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the line, with coordinates specified relative to the top-left
                                          of the page. The numbers represent the x, y values of the
                                          polygon vertices, clockwise from the left (-180 degrees
                                          inclusive) relative to the element orientation.
                                    ]
                                }
                            ],
                            "selectionMarks": [
                                {
                                    "confidence": 0.0,  # Confidence of correctly
                                      extracting the selection mark. Required.
                                    "span": {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    },
                                    "state": "str",  # State of the selection
                                      mark. Required. Known values are: "selected" and "unselected".
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the selection mark, with coordinates specified relative to
                                          the top-left of the page. The numbers represent the x, y
                                          values of the polygon vertices, clockwise from the left (-180
                                          degrees inclusive) relative to the element orientation.
                                    ]
                                }
                            ],
                            "unit": "str",  # Optional. The unit used by the width,
                              height, and polygon properties. For images, the unit is "pixel". For PDF,
                              the unit is "inch". Known values are: "pixel" and "inch".
                            "width": 0.0,  # Optional. The width of the image/PDF in
                              pixels/inches, respectively.
                            "words": [
                                {
                                    "confidence": 0.0,  # Confidence of correctly
                                      extracting the word. Required.
                                    "content": "str",  # Text content of the
                                      word. Required.
                                    "span": {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    },
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the word, with coordinates specified relative to the top-left
                                          of the page. The numbers represent the x, y values of the
                                          polygon vertices, clockwise from the left (-180 degrees
                                          inclusive) relative to the element orientation.
                                    ]
                                }
                            ]
                        }
                    ],
                    "stringIndexType": "str",  # Method used to compute string offset and length.
                      Required. Known values are: "textElements", "unicodeCodePoint", and
                      "utf16CodeUnit".
                    "contentFormat": "str",  # Optional. Format of the analyze result top-level
                      content. Known values are: "text" and "markdown".
                    "documents": [
                        {
                            "confidence": 0.0,  # Confidence of correctly extracting the
                              document. Required.
                            "docType": "str",  # Document type. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "boundingRegions": [
                                {
                                    "pageNumber": 0,  # 1-based page number of
                                      page containing the bounding region. Required.
                                    "polygon": [
                                        0.0  # Bounding polygon on the page,
                                          or the entire page if not specified. Coordinates specified
                                          relative to the top-left of the page. The numbers represent
                                          the x, y values of the polygon vertices, clockwise from the
                                          left (-180 degrees inclusive) relative to the element
                                          orientation. Required.
                                    ]
                                }
                            ],
                            "fields": {
                                "str": {
                                    "type": "str",  # Data type of the field
                                      value. Required. Known values are: "string", "date", "time",
                                      "phoneNumber", "number", "integer", "selectionMark",
                                      "countryRegion", "signature", "array", "object", "currency",
                                      "address", "boolean", and "selectionGroup".
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "confidence": 0.0,  # Optional. Confidence of
                                      correctly extracting the field.
                                    "content": "str",  # Optional. Field content.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "valueAddress": {
                                        "city": "str",  # Optional. Name of
                                          city, town, village, etc.
                                        "cityDistrict": "str",  # Optional.
                                          Districts or boroughs within a city, such as Brooklyn in New
                                          York City or City of Westminster in London.
                                        "countryRegion": "str",  # Optional.
                                          Country/region.
                                        "house": "str",  # Optional. Build
                                          name, such as World Trade Center.
                                        "houseNumber": "str",  # Optional.
                                          House or building number.
                                        "level": "str",  # Optional. Floor
                                          number, such as 3F.
                                        "poBox": "str",  # Optional. Post
                                          office box number.
                                        "postalCode": "str",  # Optional.
                                          Postal code used for mail sorting.
                                        "road": "str",  # Optional. Street
                                          name.
                                        "state": "str",  # Optional.
                                          First-level administrative division.
                                        "stateDistrict": "str",  # Optional.
                                          Second-level administrative division used in certain locales.
                                        "streetAddress": "str",  # Optional.
                                          Street-level address, excluding city, state, countryRegion,
                                          and postalCode.
                                        "suburb": "str",  # Optional.
                                          Unofficial neighborhood name, like Chinatown.
                                        "unit": "str"  # Optional. Apartment
                                          or office number.
                                    },
                                    "valueArray": [
                                        ...
                                    ],
                                    "valueBoolean": bool,  # Optional. Boolean
                                      value.
                                    "valueCountryRegion": "str",  # Optional.
                                      3-letter country code value (ISO 3166-1 alpha-3).
                                    "valueCurrency": {
                                        "amount": 0.0,  # Currency amount.
                                          Required.
                                        "currencyCode": "str",  # Optional.
                                          Resolved currency code (ISO 4217), if any.
                                        "currencySymbol": "str"  # Optional.
                                          Currency symbol label, if any.
                                    },
                                    "valueDate": "2020-02-20",  # Optional. Date
                                      value in YYYY-MM-DD format (ISO 8601).
                                    "valueInteger": 0,  # Optional. Integer
                                      value.
                                    "valueNumber": 0.0,  # Optional. Floating
                                      point value.
                                    "valueObject": {
                                        "str": ...
                                    },
                                    "valuePhoneNumber": "str",  # Optional. Phone
                                      number value in E.164 format (ex. +19876543210).
                                    "valueSelectionGroup": [
                                        "str"  # Optional. Selection group
                                          value.
                                    ],
                                    "valueSelectionMark": "str",  # Optional.
                                      Selection mark value. Known values are: "selected" and
                                      "unselected".
                                    "valueSignature": "str",  # Optional.
                                      Presence of signature. Known values are: "signed" and "unsigned".
                                    "valueString": "str",  # Optional. String
                                      value.
                                    "valueTime": "12:30:00"  # Optional. Time
                                      value in hh:mm:ss format (ISO 8601).
                                }
                            }
                        }
                    ],
                    "figures": [
                        {
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "boundingRegions": [
                                {
                                    "pageNumber": 0,  # 1-based page number of
                                      page containing the bounding region. Required.
                                    "polygon": [
                                        0.0  # Bounding polygon on the page,
                                          or the entire page if not specified. Coordinates specified
                                          relative to the top-left of the page. The numbers represent
                                          the x, y values of the polygon vertices, clockwise from the
                                          left (-180 degrees inclusive) relative to the element
                                          orientation. Required.
                                    ]
                                }
                            ],
                            "caption": {
                                "content": "str",  # Content of the caption.
                                  Required.
                                "spans": [
                                    {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    }
                                ],
                                "boundingRegions": [
                                    {
                                        "pageNumber": 0,  # 1-based page
                                          number of page containing the bounding region. Required.
                                        "polygon": [
                                            0.0  # Bounding polygon on
                                              the page, or the entire page if not specified.
                                              Coordinates specified relative to the top-left of the
                                              page. The numbers represent the x, y values of the
                                              polygon vertices, clockwise from the left (-180 degrees
                                              inclusive) relative to the element orientation. Required.
                                        ]
                                    }
                                ],
                                "elements": [
                                    "str"  # Optional. Child elements of the
                                      caption.
                                ]
                            },
                            "elements": [
                                "str"  # Optional. Child elements of the figure,
                                  excluding any caption or footnotes.
                            ],
                            "footnotes": [
                                {
                                    "content": "str",  # Content of the footnote.
                                      Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "elements": [
                                        "str"  # Optional. Child elements of
                                          the footnote.
                                    ]
                                }
                            ]
                        }
                    ],
                    "keyValuePairs": [
                        {
                            "confidence": 0.0,  # Confidence of correctly extracting the
                              key-value pair. Required.
                            "key": {
                                "content": "str",  # Concatenated content of the
                                  key-value element in reading order. Required.
                                "spans": [
                                    {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    }
                                ],
                                "boundingRegions": [
                                    {
                                        "pageNumber": 0,  # 1-based page
                                          number of page containing the bounding region. Required.
                                        "polygon": [
                                            0.0  # Bounding polygon on
                                              the page, or the entire page if not specified.
                                              Coordinates specified relative to the top-left of the
                                              page. The numbers represent the x, y values of the
                                              polygon vertices, clockwise from the left (-180 degrees
                                              inclusive) relative to the element orientation. Required.
                                        ]
                                    }
                                ]
                            },
                            "value": {
                                "content": "str",  # Concatenated content of the
                                  key-value element in reading order. Required.
                                "spans": [
                                    {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    }
                                ],
                                "boundingRegions": [
                                    {
                                        "pageNumber": 0,  # 1-based page
                                          number of page containing the bounding region. Required.
                                        "polygon": [
                                            0.0  # Bounding polygon on
                                              the page, or the entire page if not specified.
                                              Coordinates specified relative to the top-left of the
                                              page. The numbers represent the x, y values of the
                                              polygon vertices, clockwise from the left (-180 degrees
                                              inclusive) relative to the element orientation. Required.
                                        ]
                                    }
                                ]
                            }
                        }
                    ],
                    "languages": [
                        {
                            "confidence": 0.0,  # Confidence of correctly identifying the
                              language. Required.
                            "locale": "str",  # Detected language.  Value may an ISO
                              639-1 language code (ex. "en", "fr") or BCP 47 language tag (ex.
                              "zh-Hans"). Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ]
                        }
                    ],
                    "lists": [
                        {
                            "items": [
                                {
                                    "content": "str",  # Content of the list
                                      item. Required.
                                    "level": 0,  # Level of the list item
                                      (1-indexed). Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "elements": [
                                        "str"  # Optional. Child elements of
                                          the list item.
                                    ]
                                }
                            ],
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ]
                        }
                    ],
                    "paragraphs": [
                        {
                            "content": "str",  # Concatenated content of the paragraph in
                              reading order. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "boundingRegions": [
                                {
                                    "pageNumber": 0,  # 1-based page number of
                                      page containing the bounding region. Required.
                                    "polygon": [
                                        0.0  # Bounding polygon on the page,
                                          or the entire page if not specified. Coordinates specified
                                          relative to the top-left of the page. The numbers represent
                                          the x, y values of the polygon vertices, clockwise from the
                                          left (-180 degrees inclusive) relative to the element
                                          orientation. Required.
                                    ]
                                }
                            ],
                            "role": "str"  # Optional. Semantic role of the paragraph.
                              Known values are: "pageHeader", "pageFooter", "pageNumber", "title",
                              "sectionHeading", "footnote", and "formulaBlock".
                        }
                    ],
                    "sections": [
                        {
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "elements": [
                                "str"  # Optional. Child elements of the section.
                            ]
                        }
                    ],
                    "styles": [
                        {
                            "confidence": 0.0,  # Confidence of correctly identifying the
                              style. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "backgroundColor": "str",  # Optional. Background color in
                              #rrggbb hexadecimal format..
                            "color": "str",  # Optional. Foreground color in #rrggbb
                              hexadecimal format.
                            "fontStyle": "str",  # Optional. Font style. Known values
                              are: "normal" and "italic".
                            "fontWeight": "str",  # Optional. Font weight. Known values
                              are: "normal" and "bold".
                            "isHandwritten": bool,  # Optional. Is content handwritten?.
                            "similarFontFamily": "str"  # Optional. Visually most similar
                              font from among the set of supported font families, with fallback fonts
                              following CSS convention (ex. 'Arial, sans-serif').
                        }
                    ],
                    "tables": [
                        {
                            "cells": [
                                {
                                    "columnIndex": 0,  # Column index of the
                                      cell. Required.
                                    "content": "str",  # Concatenated content of
                                      the table cell in reading order. Required.
                                    "rowIndex": 0,  # Row index of the cell.
                                      Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "columnSpan": 0,  # Optional. Number of
                                      columns spanned by this cell.
                                    "elements": [
                                        "str"  # Optional. Child elements of
                                          the table cell.
                                    ],
                                    "kind": "str",  # Optional. Table cell kind.
                                      Known values are: "content", "rowHeader", "columnHeader",
                                      "stubHead", and "description".
                                    "rowSpan": 0  # Optional. Number of rows
                                      spanned by this cell.
                                }
                            ],
                            "columnCount": 0,  # Number of columns in the table.
                              Required.
                            "rowCount": 0,  # Number of rows in the table. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "boundingRegions": [
                                {
                                    "pageNumber": 0,  # 1-based page number of
                                      page containing the bounding region. Required.
                                    "polygon": [
                                        0.0  # Bounding polygon on the page,
                                          or the entire page if not specified. Coordinates specified
                                          relative to the top-left of the page. The numbers represent
                                          the x, y values of the polygon vertices, clockwise from the
                                          left (-180 degrees inclusive) relative to the element
                                          orientation. Required.
                                    ]
                                }
                            ],
                            "caption": {
                                "content": "str",  # Content of the caption.
                                  Required.
                                "spans": [
                                    {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    }
                                ],
                                "boundingRegions": [
                                    {
                                        "pageNumber": 0,  # 1-based page
                                          number of page containing the bounding region. Required.
                                        "polygon": [
                                            0.0  # Bounding polygon on
                                              the page, or the entire page if not specified.
                                              Coordinates specified relative to the top-left of the
                                              page. The numbers represent the x, y values of the
                                              polygon vertices, clockwise from the left (-180 degrees
                                              inclusive) relative to the element orientation. Required.
                                        ]
                                    }
                                ],
                                "elements": [
                                    "str"  # Optional. Child elements of the
                                      caption.
                                ]
                            },
                            "footnotes": [
                                {
                                    "content": "str",  # Content of the footnote.
                                      Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "elements": [
                                        "str"  # Optional. Child elements of
                                          the footnote.
                                    ]
                                }
                            ]
                        }
                    ]
                }
        """

    @overload
    async def begin_classify_document(
        self,
        classifier_id: str,
        classify_request: JSON,
        *,
        string_index_type: Optional[Union[str, _models.StringIndexType]] = None,
        split: Optional[Union[str, _models.SplitMode]] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.AnalyzeResult]:
        # pylint: disable=line-too-long
        """Classifies document with document classifier.

        :param classifier_id: Unique document classifier name. Required.
        :type classifier_id: str
        :param classify_request: Classify request parameters. Required.
        :type classify_request: JSON
        :keyword string_index_type: Method used to compute string offset and length. Known values are:
         "textElements", "unicodeCodePoint", and "utf16CodeUnit". Default value is None.
        :paramtype string_index_type: str or ~azure.ai.documentintelligence.models.StringIndexType
        :keyword split: Document splitting mode. Known values are: "auto", "none", and "perPage".
         Default value is None.
        :paramtype split: str or ~azure.ai.documentintelligence.models.SplitMode
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns AnalyzeResult. The AnalyzeResult is
         compatible with MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.ai.documentintelligence.models.AnalyzeResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "apiVersion": "str",  # API version used to produce this result. Required.
                    "content": "str",  # Concatenate string representation of all textual and
                      visual elements in reading order. Required.
                    "modelId": "str",  # Document model ID used to produce this result. Required.
                    "pages": [
                        {
                            "pageNumber": 0,  # 1-based page number in the input
                              document. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "angle": 0.0,  # Optional. The general orientation of the
                              content in clockwise direction, measured in degrees between (-180, 180].
                            "barcodes": [
                                {
                                    "confidence": 0.0,  # Confidence of correctly
                                      extracting the barcode. Required.
                                    "kind": "str",  # Barcode kind. Required.
                                      Known values are: "QRCode", "PDF417", "UPCA", "UPCE", "Code39",
                                      "Code128", "EAN8", "EAN13", "DataBar", "Code93", "Codabar",
                                      "DataBarExpanded", "ITF", "MicroQRCode", "Aztec", "DataMatrix",
                                      and "MaxiCode".
                                    "span": {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    },
                                    "value": "str",  # Barcode value. Required.
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the barcode, with coordinates specified relative to the
                                          top-left of the page. The numbers represent the x, y values
                                          of the polygon vertices, clockwise from the left (-180
                                          degrees inclusive) relative to the element orientation.
                                    ]
                                }
                            ],
                            "formulas": [
                                {
                                    "confidence": 0.0,  # Confidence of correctly
                                      extracting the formula. Required.
                                    "kind": "str",  # Formula kind. Required.
                                      Known values are: "inline" and "display".
                                    "span": {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    },
                                    "value": "str",  # LaTex expression
                                      describing the formula. Required.
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the formula, with coordinates specified relative to the
                                          top-left of the page. The numbers represent the x, y values
                                          of the polygon vertices, clockwise from the left (-180
                                          degrees inclusive) relative to the element orientation.
                                    ]
                                }
                            ],
                            "height": 0.0,  # Optional. The height of the image/PDF in
                              pixels/inches, respectively.
                            "lines": [
                                {
                                    "content": "str",  # Concatenated content of
                                      the contained elements in reading order. Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the line, with coordinates specified relative to the top-left
                                          of the page. The numbers represent the x, y values of the
                                          polygon vertices, clockwise from the left (-180 degrees
                                          inclusive) relative to the element orientation.
                                    ]
                                }
                            ],
                            "selectionMarks": [
                                {
                                    "confidence": 0.0,  # Confidence of correctly
                                      extracting the selection mark. Required.
                                    "span": {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    },
                                    "state": "str",  # State of the selection
                                      mark. Required. Known values are: "selected" and "unselected".
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the selection mark, with coordinates specified relative to
                                          the top-left of the page. The numbers represent the x, y
                                          values of the polygon vertices, clockwise from the left (-180
                                          degrees inclusive) relative to the element orientation.
                                    ]
                                }
                            ],
                            "unit": "str",  # Optional. The unit used by the width,
                              height, and polygon properties. For images, the unit is "pixel". For PDF,
                              the unit is "inch". Known values are: "pixel" and "inch".
                            "width": 0.0,  # Optional. The width of the image/PDF in
                              pixels/inches, respectively.
                            "words": [
                                {
                                    "confidence": 0.0,  # Confidence of correctly
                                      extracting the word. Required.
                                    "content": "str",  # Text content of the
                                      word. Required.
                                    "span": {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    },
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the word, with coordinates specified relative to the top-left
                                          of the page. The numbers represent the x, y values of the
                                          polygon vertices, clockwise from the left (-180 degrees
                                          inclusive) relative to the element orientation.
                                    ]
                                }
                            ]
                        }
                    ],
                    "stringIndexType": "str",  # Method used to compute string offset and length.
                      Required. Known values are: "textElements", "unicodeCodePoint", and
                      "utf16CodeUnit".
                    "contentFormat": "str",  # Optional. Format of the analyze result top-level
                      content. Known values are: "text" and "markdown".
                    "documents": [
                        {
                            "confidence": 0.0,  # Confidence of correctly extracting the
                              document. Required.
                            "docType": "str",  # Document type. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "boundingRegions": [
                                {
                                    "pageNumber": 0,  # 1-based page number of
                                      page containing the bounding region. Required.
                                    "polygon": [
                                        0.0  # Bounding polygon on the page,
                                          or the entire page if not specified. Coordinates specified
                                          relative to the top-left of the page. The numbers represent
                                          the x, y values of the polygon vertices, clockwise from the
                                          left (-180 degrees inclusive) relative to the element
                                          orientation. Required.
                                    ]
                                }
                            ],
                            "fields": {
                                "str": {
                                    "type": "str",  # Data type of the field
                                      value. Required. Known values are: "string", "date", "time",
                                      "phoneNumber", "number", "integer", "selectionMark",
                                      "countryRegion", "signature", "array", "object", "currency",
                                      "address", "boolean", and "selectionGroup".
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "confidence": 0.0,  # Optional. Confidence of
                                      correctly extracting the field.
                                    "content": "str",  # Optional. Field content.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "valueAddress": {
                                        "city": "str",  # Optional. Name of
                                          city, town, village, etc.
                                        "cityDistrict": "str",  # Optional.
                                          Districts or boroughs within a city, such as Brooklyn in New
                                          York City or City of Westminster in London.
                                        "countryRegion": "str",  # Optional.
                                          Country/region.
                                        "house": "str",  # Optional. Build
                                          name, such as World Trade Center.
                                        "houseNumber": "str",  # Optional.
                                          House or building number.
                                        "level": "str",  # Optional. Floor
                                          number, such as 3F.
                                        "poBox": "str",  # Optional. Post
                                          office box number.
                                        "postalCode": "str",  # Optional.
                                          Postal code used for mail sorting.
                                        "road": "str",  # Optional. Street
                                          name.
                                        "state": "str",  # Optional.
                                          First-level administrative division.
                                        "stateDistrict": "str",  # Optional.
                                          Second-level administrative division used in certain locales.
                                        "streetAddress": "str",  # Optional.
                                          Street-level address, excluding city, state, countryRegion,
                                          and postalCode.
                                        "suburb": "str",  # Optional.
                                          Unofficial neighborhood name, like Chinatown.
                                        "unit": "str"  # Optional. Apartment
                                          or office number.
                                    },
                                    "valueArray": [
                                        ...
                                    ],
                                    "valueBoolean": bool,  # Optional. Boolean
                                      value.
                                    "valueCountryRegion": "str",  # Optional.
                                      3-letter country code value (ISO 3166-1 alpha-3).
                                    "valueCurrency": {
                                        "amount": 0.0,  # Currency amount.
                                          Required.
                                        "currencyCode": "str",  # Optional.
                                          Resolved currency code (ISO 4217), if any.
                                        "currencySymbol": "str"  # Optional.
                                          Currency symbol label, if any.
                                    },
                                    "valueDate": "2020-02-20",  # Optional. Date
                                      value in YYYY-MM-DD format (ISO 8601).
                                    "valueInteger": 0,  # Optional. Integer
                                      value.
                                    "valueNumber": 0.0,  # Optional. Floating
                                      point value.
                                    "valueObject": {
                                        "str": ...
                                    },
                                    "valuePhoneNumber": "str",  # Optional. Phone
                                      number value in E.164 format (ex. +19876543210).
                                    "valueSelectionGroup": [
                                        "str"  # Optional. Selection group
                                          value.
                                    ],
                                    "valueSelectionMark": "str",  # Optional.
                                      Selection mark value. Known values are: "selected" and
                                      "unselected".
                                    "valueSignature": "str",  # Optional.
                                      Presence of signature. Known values are: "signed" and "unsigned".
                                    "valueString": "str",  # Optional. String
                                      value.
                                    "valueTime": "12:30:00"  # Optional. Time
                                      value in hh:mm:ss format (ISO 8601).
                                }
                            }
                        }
                    ],
                    "figures": [
                        {
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "boundingRegions": [
                                {
                                    "pageNumber": 0,  # 1-based page number of
                                      page containing the bounding region. Required.
                                    "polygon": [
                                        0.0  # Bounding polygon on the page,
                                          or the entire page if not specified. Coordinates specified
                                          relative to the top-left of the page. The numbers represent
                                          the x, y values of the polygon vertices, clockwise from the
                                          left (-180 degrees inclusive) relative to the element
                                          orientation. Required.
                                    ]
                                }
                            ],
                            "caption": {
                                "content": "str",  # Content of the caption.
                                  Required.
                                "spans": [
                                    {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    }
                                ],
                                "boundingRegions": [
                                    {
                                        "pageNumber": 0,  # 1-based page
                                          number of page containing the bounding region. Required.
                                        "polygon": [
                                            0.0  # Bounding polygon on
                                              the page, or the entire page if not specified.
                                              Coordinates specified relative to the top-left of the
                                              page. The numbers represent the x, y values of the
                                              polygon vertices, clockwise from the left (-180 degrees
                                              inclusive) relative to the element orientation. Required.
                                        ]
                                    }
                                ],
                                "elements": [
                                    "str"  # Optional. Child elements of the
                                      caption.
                                ]
                            },
                            "elements": [
                                "str"  # Optional. Child elements of the figure,
                                  excluding any caption or footnotes.
                            ],
                            "footnotes": [
                                {
                                    "content": "str",  # Content of the footnote.
                                      Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "elements": [
                                        "str"  # Optional. Child elements of
                                          the footnote.
                                    ]
                                }
                            ]
                        }
                    ],
                    "keyValuePairs": [
                        {
                            "confidence": 0.0,  # Confidence of correctly extracting the
                              key-value pair. Required.
                            "key": {
                                "content": "str",  # Concatenated content of the
                                  key-value element in reading order. Required.
                                "spans": [
                                    {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    }
                                ],
                                "boundingRegions": [
                                    {
                                        "pageNumber": 0,  # 1-based page
                                          number of page containing the bounding region. Required.
                                        "polygon": [
                                            0.0  # Bounding polygon on
                                              the page, or the entire page if not specified.
                                              Coordinates specified relative to the top-left of the
                                              page. The numbers represent the x, y values of the
                                              polygon vertices, clockwise from the left (-180 degrees
                                              inclusive) relative to the element orientation. Required.
                                        ]
                                    }
                                ]
                            },
                            "value": {
                                "content": "str",  # Concatenated content of the
                                  key-value element in reading order. Required.
                                "spans": [
                                    {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    }
                                ],
                                "boundingRegions": [
                                    {
                                        "pageNumber": 0,  # 1-based page
                                          number of page containing the bounding region. Required.
                                        "polygon": [
                                            0.0  # Bounding polygon on
                                              the page, or the entire page if not specified.
                                              Coordinates specified relative to the top-left of the
                                              page. The numbers represent the x, y values of the
                                              polygon vertices, clockwise from the left (-180 degrees
                                              inclusive) relative to the element orientation. Required.
                                        ]
                                    }
                                ]
                            }
                        }
                    ],
                    "languages": [
                        {
                            "confidence": 0.0,  # Confidence of correctly identifying the
                              language. Required.
                            "locale": "str",  # Detected language.  Value may an ISO
                              639-1 language code (ex. "en", "fr") or BCP 47 language tag (ex.
                              "zh-Hans"). Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ]
                        }
                    ],
                    "lists": [
                        {
                            "items": [
                                {
                                    "content": "str",  # Content of the list
                                      item. Required.
                                    "level": 0,  # Level of the list item
                                      (1-indexed). Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "elements": [
                                        "str"  # Optional. Child elements of
                                          the list item.
                                    ]
                                }
                            ],
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ]
                        }
                    ],
                    "paragraphs": [
                        {
                            "content": "str",  # Concatenated content of the paragraph in
                              reading order. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "boundingRegions": [
                                {
                                    "pageNumber": 0,  # 1-based page number of
                                      page containing the bounding region. Required.
                                    "polygon": [
                                        0.0  # Bounding polygon on the page,
                                          or the entire page if not specified. Coordinates specified
                                          relative to the top-left of the page. The numbers represent
                                          the x, y values of the polygon vertices, clockwise from the
                                          left (-180 degrees inclusive) relative to the element
                                          orientation. Required.
                                    ]
                                }
                            ],
                            "role": "str"  # Optional. Semantic role of the paragraph.
                              Known values are: "pageHeader", "pageFooter", "pageNumber", "title",
                              "sectionHeading", "footnote", and "formulaBlock".
                        }
                    ],
                    "sections": [
                        {
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "elements": [
                                "str"  # Optional. Child elements of the section.
                            ]
                        }
                    ],
                    "styles": [
                        {
                            "confidence": 0.0,  # Confidence of correctly identifying the
                              style. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "backgroundColor": "str",  # Optional. Background color in
                              #rrggbb hexadecimal format..
                            "color": "str",  # Optional. Foreground color in #rrggbb
                              hexadecimal format.
                            "fontStyle": "str",  # Optional. Font style. Known values
                              are: "normal" and "italic".
                            "fontWeight": "str",  # Optional. Font weight. Known values
                              are: "normal" and "bold".
                            "isHandwritten": bool,  # Optional. Is content handwritten?.
                            "similarFontFamily": "str"  # Optional. Visually most similar
                              font from among the set of supported font families, with fallback fonts
                              following CSS convention (ex. 'Arial, sans-serif').
                        }
                    ],
                    "tables": [
                        {
                            "cells": [
                                {
                                    "columnIndex": 0,  # Column index of the
                                      cell. Required.
                                    "content": "str",  # Concatenated content of
                                      the table cell in reading order. Required.
                                    "rowIndex": 0,  # Row index of the cell.
                                      Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "columnSpan": 0,  # Optional. Number of
                                      columns spanned by this cell.
                                    "elements": [
                                        "str"  # Optional. Child elements of
                                          the table cell.
                                    ],
                                    "kind": "str",  # Optional. Table cell kind.
                                      Known values are: "content", "rowHeader", "columnHeader",
                                      "stubHead", and "description".
                                    "rowSpan": 0  # Optional. Number of rows
                                      spanned by this cell.
                                }
                            ],
                            "columnCount": 0,  # Number of columns in the table.
                              Required.
                            "rowCount": 0,  # Number of rows in the table. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "boundingRegions": [
                                {
                                    "pageNumber": 0,  # 1-based page number of
                                      page containing the bounding region. Required.
                                    "polygon": [
                                        0.0  # Bounding polygon on the page,
                                          or the entire page if not specified. Coordinates specified
                                          relative to the top-left of the page. The numbers represent
                                          the x, y values of the polygon vertices, clockwise from the
                                          left (-180 degrees inclusive) relative to the element
                                          orientation. Required.
                                    ]
                                }
                            ],
                            "caption": {
                                "content": "str",  # Content of the caption.
                                  Required.
                                "spans": [
                                    {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    }
                                ],
                                "boundingRegions": [
                                    {
                                        "pageNumber": 0,  # 1-based page
                                          number of page containing the bounding region. Required.
                                        "polygon": [
                                            0.0  # Bounding polygon on
                                              the page, or the entire page if not specified.
                                              Coordinates specified relative to the top-left of the
                                              page. The numbers represent the x, y values of the
                                              polygon vertices, clockwise from the left (-180 degrees
                                              inclusive) relative to the element orientation. Required.
                                        ]
                                    }
                                ],
                                "elements": [
                                    "str"  # Optional. Child elements of the
                                      caption.
                                ]
                            },
                            "footnotes": [
                                {
                                    "content": "str",  # Content of the footnote.
                                      Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "elements": [
                                        "str"  # Optional. Child elements of
                                          the footnote.
                                    ]
                                }
                            ]
                        }
                    ]
                }
        """

    @overload
    async def begin_classify_document(
        self,
        classifier_id: str,
        classify_request: IO[bytes],
        *,
        string_index_type: Optional[Union[str, _models.StringIndexType]] = None,
        split: Optional[Union[str, _models.SplitMode]] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.AnalyzeResult]:
        # pylint: disable=line-too-long
        """Classifies document with document classifier.

        :param classifier_id: Unique document classifier name. Required.
        :type classifier_id: str
        :param classify_request: Classify request parameters. Required.
        :type classify_request: IO[bytes]
        :keyword string_index_type: Method used to compute string offset and length. Known values are:
         "textElements", "unicodeCodePoint", and "utf16CodeUnit". Default value is None.
        :paramtype string_index_type: str or ~azure.ai.documentintelligence.models.StringIndexType
        :keyword split: Document splitting mode. Known values are: "auto", "none", and "perPage".
         Default value is None.
        :paramtype split: str or ~azure.ai.documentintelligence.models.SplitMode
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns AnalyzeResult. The AnalyzeResult is
         compatible with MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.ai.documentintelligence.models.AnalyzeResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "apiVersion": "str",  # API version used to produce this result. Required.
                    "content": "str",  # Concatenate string representation of all textual and
                      visual elements in reading order. Required.
                    "modelId": "str",  # Document model ID used to produce this result. Required.
                    "pages": [
                        {
                            "pageNumber": 0,  # 1-based page number in the input
                              document. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "angle": 0.0,  # Optional. The general orientation of the
                              content in clockwise direction, measured in degrees between (-180, 180].
                            "barcodes": [
                                {
                                    "confidence": 0.0,  # Confidence of correctly
                                      extracting the barcode. Required.
                                    "kind": "str",  # Barcode kind. Required.
                                      Known values are: "QRCode", "PDF417", "UPCA", "UPCE", "Code39",
                                      "Code128", "EAN8", "EAN13", "DataBar", "Code93", "Codabar",
                                      "DataBarExpanded", "ITF", "MicroQRCode", "Aztec", "DataMatrix",
                                      and "MaxiCode".
                                    "span": {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    },
                                    "value": "str",  # Barcode value. Required.
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the barcode, with coordinates specified relative to the
                                          top-left of the page. The numbers represent the x, y values
                                          of the polygon vertices, clockwise from the left (-180
                                          degrees inclusive) relative to the element orientation.
                                    ]
                                }
                            ],
                            "formulas": [
                                {
                                    "confidence": 0.0,  # Confidence of correctly
                                      extracting the formula. Required.
                                    "kind": "str",  # Formula kind. Required.
                                      Known values are: "inline" and "display".
                                    "span": {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    },
                                    "value": "str",  # LaTex expression
                                      describing the formula. Required.
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the formula, with coordinates specified relative to the
                                          top-left of the page. The numbers represent the x, y values
                                          of the polygon vertices, clockwise from the left (-180
                                          degrees inclusive) relative to the element orientation.
                                    ]
                                }
                            ],
                            "height": 0.0,  # Optional. The height of the image/PDF in
                              pixels/inches, respectively.
                            "lines": [
                                {
                                    "content": "str",  # Concatenated content of
                                      the contained elements in reading order. Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the line, with coordinates specified relative to the top-left
                                          of the page. The numbers represent the x, y values of the
                                          polygon vertices, clockwise from the left (-180 degrees
                                          inclusive) relative to the element orientation.
                                    ]
                                }
                            ],
                            "selectionMarks": [
                                {
                                    "confidence": 0.0,  # Confidence of correctly
                                      extracting the selection mark. Required.
                                    "span": {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    },
                                    "state": "str",  # State of the selection
                                      mark. Required. Known values are: "selected" and "unselected".
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the selection mark, with coordinates specified relative to
                                          the top-left of the page. The numbers represent the x, y
                                          values of the polygon vertices, clockwise from the left (-180
                                          degrees inclusive) relative to the element orientation.
                                    ]
                                }
                            ],
                            "unit": "str",  # Optional. The unit used by the width,
                              height, and polygon properties. For images, the unit is "pixel". For PDF,
                              the unit is "inch". Known values are: "pixel" and "inch".
                            "width": 0.0,  # Optional. The width of the image/PDF in
                              pixels/inches, respectively.
                            "words": [
                                {
                                    "confidence": 0.0,  # Confidence of correctly
                                      extracting the word. Required.
                                    "content": "str",  # Text content of the
                                      word. Required.
                                    "span": {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    },
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the word, with coordinates specified relative to the top-left
                                          of the page. The numbers represent the x, y values of the
                                          polygon vertices, clockwise from the left (-180 degrees
                                          inclusive) relative to the element orientation.
                                    ]
                                }
                            ]
                        }
                    ],
                    "stringIndexType": "str",  # Method used to compute string offset and length.
                      Required. Known values are: "textElements", "unicodeCodePoint", and
                      "utf16CodeUnit".
                    "contentFormat": "str",  # Optional. Format of the analyze result top-level
                      content. Known values are: "text" and "markdown".
                    "documents": [
                        {
                            "confidence": 0.0,  # Confidence of correctly extracting the
                              document. Required.
                            "docType": "str",  # Document type. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "boundingRegions": [
                                {
                                    "pageNumber": 0,  # 1-based page number of
                                      page containing the bounding region. Required.
                                    "polygon": [
                                        0.0  # Bounding polygon on the page,
                                          or the entire page if not specified. Coordinates specified
                                          relative to the top-left of the page. The numbers represent
                                          the x, y values of the polygon vertices, clockwise from the
                                          left (-180 degrees inclusive) relative to the element
                                          orientation. Required.
                                    ]
                                }
                            ],
                            "fields": {
                                "str": {
                                    "type": "str",  # Data type of the field
                                      value. Required. Known values are: "string", "date", "time",
                                      "phoneNumber", "number", "integer", "selectionMark",
                                      "countryRegion", "signature", "array", "object", "currency",
                                      "address", "boolean", and "selectionGroup".
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "confidence": 0.0,  # Optional. Confidence of
                                      correctly extracting the field.
                                    "content": "str",  # Optional. Field content.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "valueAddress": {
                                        "city": "str",  # Optional. Name of
                                          city, town, village, etc.
                                        "cityDistrict": "str",  # Optional.
                                          Districts or boroughs within a city, such as Brooklyn in New
                                          York City or City of Westminster in London.
                                        "countryRegion": "str",  # Optional.
                                          Country/region.
                                        "house": "str",  # Optional. Build
                                          name, such as World Trade Center.
                                        "houseNumber": "str",  # Optional.
                                          House or building number.
                                        "level": "str",  # Optional. Floor
                                          number, such as 3F.
                                        "poBox": "str",  # Optional. Post
                                          office box number.
                                        "postalCode": "str",  # Optional.
                                          Postal code used for mail sorting.
                                        "road": "str",  # Optional. Street
                                          name.
                                        "state": "str",  # Optional.
                                          First-level administrative division.
                                        "stateDistrict": "str",  # Optional.
                                          Second-level administrative division used in certain locales.
                                        "streetAddress": "str",  # Optional.
                                          Street-level address, excluding city, state, countryRegion,
                                          and postalCode.
                                        "suburb": "str",  # Optional.
                                          Unofficial neighborhood name, like Chinatown.
                                        "unit": "str"  # Optional. Apartment
                                          or office number.
                                    },
                                    "valueArray": [
                                        ...
                                    ],
                                    "valueBoolean": bool,  # Optional. Boolean
                                      value.
                                    "valueCountryRegion": "str",  # Optional.
                                      3-letter country code value (ISO 3166-1 alpha-3).
                                    "valueCurrency": {
                                        "amount": 0.0,  # Currency amount.
                                          Required.
                                        "currencyCode": "str",  # Optional.
                                          Resolved currency code (ISO 4217), if any.
                                        "currencySymbol": "str"  # Optional.
                                          Currency symbol label, if any.
                                    },
                                    "valueDate": "2020-02-20",  # Optional. Date
                                      value in YYYY-MM-DD format (ISO 8601).
                                    "valueInteger": 0,  # Optional. Integer
                                      value.
                                    "valueNumber": 0.0,  # Optional. Floating
                                      point value.
                                    "valueObject": {
                                        "str": ...
                                    },
                                    "valuePhoneNumber": "str",  # Optional. Phone
                                      number value in E.164 format (ex. +19876543210).
                                    "valueSelectionGroup": [
                                        "str"  # Optional. Selection group
                                          value.
                                    ],
                                    "valueSelectionMark": "str",  # Optional.
                                      Selection mark value. Known values are: "selected" and
                                      "unselected".
                                    "valueSignature": "str",  # Optional.
                                      Presence of signature. Known values are: "signed" and "unsigned".
                                    "valueString": "str",  # Optional. String
                                      value.
                                    "valueTime": "12:30:00"  # Optional. Time
                                      value in hh:mm:ss format (ISO 8601).
                                }
                            }
                        }
                    ],
                    "figures": [
                        {
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "boundingRegions": [
                                {
                                    "pageNumber": 0,  # 1-based page number of
                                      page containing the bounding region. Required.
                                    "polygon": [
                                        0.0  # Bounding polygon on the page,
                                          or the entire page if not specified. Coordinates specified
                                          relative to the top-left of the page. The numbers represent
                                          the x, y values of the polygon vertices, clockwise from the
                                          left (-180 degrees inclusive) relative to the element
                                          orientation. Required.
                                    ]
                                }
                            ],
                            "caption": {
                                "content": "str",  # Content of the caption.
                                  Required.
                                "spans": [
                                    {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    }
                                ],
                                "boundingRegions": [
                                    {
                                        "pageNumber": 0,  # 1-based page
                                          number of page containing the bounding region. Required.
                                        "polygon": [
                                            0.0  # Bounding polygon on
                                              the page, or the entire page if not specified.
                                              Coordinates specified relative to the top-left of the
                                              page. The numbers represent the x, y values of the
                                              polygon vertices, clockwise from the left (-180 degrees
                                              inclusive) relative to the element orientation. Required.
                                        ]
                                    }
                                ],
                                "elements": [
                                    "str"  # Optional. Child elements of the
                                      caption.
                                ]
                            },
                            "elements": [
                                "str"  # Optional. Child elements of the figure,
                                  excluding any caption or footnotes.
                            ],
                            "footnotes": [
                                {
                                    "content": "str",  # Content of the footnote.
                                      Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "elements": [
                                        "str"  # Optional. Child elements of
                                          the footnote.
                                    ]
                                }
                            ]
                        }
                    ],
                    "keyValuePairs": [
                        {
                            "confidence": 0.0,  # Confidence of correctly extracting the
                              key-value pair. Required.
                            "key": {
                                "content": "str",  # Concatenated content of the
                                  key-value element in reading order. Required.
                                "spans": [
                                    {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    }
                                ],
                                "boundingRegions": [
                                    {
                                        "pageNumber": 0,  # 1-based page
                                          number of page containing the bounding region. Required.
                                        "polygon": [
                                            0.0  # Bounding polygon on
                                              the page, or the entire page if not specified.
                                              Coordinates specified relative to the top-left of the
                                              page. The numbers represent the x, y values of the
                                              polygon vertices, clockwise from the left (-180 degrees
                                              inclusive) relative to the element orientation. Required.
                                        ]
                                    }
                                ]
                            },
                            "value": {
                                "content": "str",  # Concatenated content of the
                                  key-value element in reading order. Required.
                                "spans": [
                                    {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    }
                                ],
                                "boundingRegions": [
                                    {
                                        "pageNumber": 0,  # 1-based page
                                          number of page containing the bounding region. Required.
                                        "polygon": [
                                            0.0  # Bounding polygon on
                                              the page, or the entire page if not specified.
                                              Coordinates specified relative to the top-left of the
                                              page. The numbers represent the x, y values of the
                                              polygon vertices, clockwise from the left (-180 degrees
                                              inclusive) relative to the element orientation. Required.
                                        ]
                                    }
                                ]
                            }
                        }
                    ],
                    "languages": [
                        {
                            "confidence": 0.0,  # Confidence of correctly identifying the
                              language. Required.
                            "locale": "str",  # Detected language.  Value may an ISO
                              639-1 language code (ex. "en", "fr") or BCP 47 language tag (ex.
                              "zh-Hans"). Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ]
                        }
                    ],
                    "lists": [
                        {
                            "items": [
                                {
                                    "content": "str",  # Content of the list
                                      item. Required.
                                    "level": 0,  # Level of the list item
                                      (1-indexed). Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "elements": [
                                        "str"  # Optional. Child elements of
                                          the list item.
                                    ]
                                }
                            ],
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ]
                        }
                    ],
                    "paragraphs": [
                        {
                            "content": "str",  # Concatenated content of the paragraph in
                              reading order. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "boundingRegions": [
                                {
                                    "pageNumber": 0,  # 1-based page number of
                                      page containing the bounding region. Required.
                                    "polygon": [
                                        0.0  # Bounding polygon on the page,
                                          or the entire page if not specified. Coordinates specified
                                          relative to the top-left of the page. The numbers represent
                                          the x, y values of the polygon vertices, clockwise from the
                                          left (-180 degrees inclusive) relative to the element
                                          orientation. Required.
                                    ]
                                }
                            ],
                            "role": "str"  # Optional. Semantic role of the paragraph.
                              Known values are: "pageHeader", "pageFooter", "pageNumber", "title",
                              "sectionHeading", "footnote", and "formulaBlock".
                        }
                    ],
                    "sections": [
                        {
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "elements": [
                                "str"  # Optional. Child elements of the section.
                            ]
                        }
                    ],
                    "styles": [
                        {
                            "confidence": 0.0,  # Confidence of correctly identifying the
                              style. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "backgroundColor": "str",  # Optional. Background color in
                              #rrggbb hexadecimal format..
                            "color": "str",  # Optional. Foreground color in #rrggbb
                              hexadecimal format.
                            "fontStyle": "str",  # Optional. Font style. Known values
                              are: "normal" and "italic".
                            "fontWeight": "str",  # Optional. Font weight. Known values
                              are: "normal" and "bold".
                            "isHandwritten": bool,  # Optional. Is content handwritten?.
                            "similarFontFamily": "str"  # Optional. Visually most similar
                              font from among the set of supported font families, with fallback fonts
                              following CSS convention (ex. 'Arial, sans-serif').
                        }
                    ],
                    "tables": [
                        {
                            "cells": [
                                {
                                    "columnIndex": 0,  # Column index of the
                                      cell. Required.
                                    "content": "str",  # Concatenated content of
                                      the table cell in reading order. Required.
                                    "rowIndex": 0,  # Row index of the cell.
                                      Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "columnSpan": 0,  # Optional. Number of
                                      columns spanned by this cell.
                                    "elements": [
                                        "str"  # Optional. Child elements of
                                          the table cell.
                                    ],
                                    "kind": "str",  # Optional. Table cell kind.
                                      Known values are: "content", "rowHeader", "columnHeader",
                                      "stubHead", and "description".
                                    "rowSpan": 0  # Optional. Number of rows
                                      spanned by this cell.
                                }
                            ],
                            "columnCount": 0,  # Number of columns in the table.
                              Required.
                            "rowCount": 0,  # Number of rows in the table. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "boundingRegions": [
                                {
                                    "pageNumber": 0,  # 1-based page number of
                                      page containing the bounding region. Required.
                                    "polygon": [
                                        0.0  # Bounding polygon on the page,
                                          or the entire page if not specified. Coordinates specified
                                          relative to the top-left of the page. The numbers represent
                                          the x, y values of the polygon vertices, clockwise from the
                                          left (-180 degrees inclusive) relative to the element
                                          orientation. Required.
                                    ]
                                }
                            ],
                            "caption": {
                                "content": "str",  # Content of the caption.
                                  Required.
                                "spans": [
                                    {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    }
                                ],
                                "boundingRegions": [
                                    {
                                        "pageNumber": 0,  # 1-based page
                                          number of page containing the bounding region. Required.
                                        "polygon": [
                                            0.0  # Bounding polygon on
                                              the page, or the entire page if not specified.
                                              Coordinates specified relative to the top-left of the
                                              page. The numbers represent the x, y values of the
                                              polygon vertices, clockwise from the left (-180 degrees
                                              inclusive) relative to the element orientation. Required.
                                        ]
                                    }
                                ],
                                "elements": [
                                    "str"  # Optional. Child elements of the
                                      caption.
                                ]
                            },
                            "footnotes": [
                                {
                                    "content": "str",  # Content of the footnote.
                                      Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "elements": [
                                        "str"  # Optional. Child elements of
                                          the footnote.
                                    ]
                                }
                            ]
                        }
                    ]
                }
        """

    @distributed_trace_async
    async def begin_classify_document(
        self,
        classifier_id: str,
        classify_request: Union[_models.ClassifyDocumentRequest, JSON, IO[bytes]],
        *,
        string_index_type: Optional[Union[str, _models.StringIndexType]] = None,
        split: Optional[Union[str, _models.SplitMode]] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[_models.AnalyzeResult]:
        # pylint: disable=line-too-long
        """Classifies document with document classifier.

        :param classifier_id: Unique document classifier name. Required.
        :type classifier_id: str
        :param classify_request: Classify request parameters. Is one of the following types:
         ClassifyDocumentRequest, JSON, IO[bytes] Required.
        :type classify_request: ~azure.ai.documentintelligence.models.ClassifyDocumentRequest or JSON
         or IO[bytes]
        :keyword string_index_type: Method used to compute string offset and length. Known values are:
         "textElements", "unicodeCodePoint", and "utf16CodeUnit". Default value is None.
        :paramtype string_index_type: str or ~azure.ai.documentintelligence.models.StringIndexType
        :keyword split: Document splitting mode. Known values are: "auto", "none", and "perPage".
         Default value is None.
        :paramtype split: str or ~azure.ai.documentintelligence.models.SplitMode
        :return: An instance of AsyncLROPoller that returns AnalyzeResult. The AnalyzeResult is
         compatible with MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.ai.documentintelligence.models.AnalyzeResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                classify_request = {
                    "base64Source": bytes("bytes", encoding="utf-8"),  # Optional. Base64
                      encoding of the document to classify.  Either urlSource or base64Source must be
                      specified.
                    "urlSource": "str"  # Optional. Document URL to classify.  Either urlSource
                      or base64Source must be specified.
                }

                # response body for status code(s): 202
                response == {
                    "apiVersion": "str",  # API version used to produce this result. Required.
                    "content": "str",  # Concatenate string representation of all textual and
                      visual elements in reading order. Required.
                    "modelId": "str",  # Document model ID used to produce this result. Required.
                    "pages": [
                        {
                            "pageNumber": 0,  # 1-based page number in the input
                              document. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "angle": 0.0,  # Optional. The general orientation of the
                              content in clockwise direction, measured in degrees between (-180, 180].
                            "barcodes": [
                                {
                                    "confidence": 0.0,  # Confidence of correctly
                                      extracting the barcode. Required.
                                    "kind": "str",  # Barcode kind. Required.
                                      Known values are: "QRCode", "PDF417", "UPCA", "UPCE", "Code39",
                                      "Code128", "EAN8", "EAN13", "DataBar", "Code93", "Codabar",
                                      "DataBarExpanded", "ITF", "MicroQRCode", "Aztec", "DataMatrix",
                                      and "MaxiCode".
                                    "span": {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    },
                                    "value": "str",  # Barcode value. Required.
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the barcode, with coordinates specified relative to the
                                          top-left of the page. The numbers represent the x, y values
                                          of the polygon vertices, clockwise from the left (-180
                                          degrees inclusive) relative to the element orientation.
                                    ]
                                }
                            ],
                            "formulas": [
                                {
                                    "confidence": 0.0,  # Confidence of correctly
                                      extracting the formula. Required.
                                    "kind": "str",  # Formula kind. Required.
                                      Known values are: "inline" and "display".
                                    "span": {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    },
                                    "value": "str",  # LaTex expression
                                      describing the formula. Required.
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the formula, with coordinates specified relative to the
                                          top-left of the page. The numbers represent the x, y values
                                          of the polygon vertices, clockwise from the left (-180
                                          degrees inclusive) relative to the element orientation.
                                    ]
                                }
                            ],
                            "height": 0.0,  # Optional. The height of the image/PDF in
                              pixels/inches, respectively.
                            "lines": [
                                {
                                    "content": "str",  # Concatenated content of
                                      the contained elements in reading order. Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the line, with coordinates specified relative to the top-left
                                          of the page. The numbers represent the x, y values of the
                                          polygon vertices, clockwise from the left (-180 degrees
                                          inclusive) relative to the element orientation.
                                    ]
                                }
                            ],
                            "selectionMarks": [
                                {
                                    "confidence": 0.0,  # Confidence of correctly
                                      extracting the selection mark. Required.
                                    "span": {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    },
                                    "state": "str",  # State of the selection
                                      mark. Required. Known values are: "selected" and "unselected".
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the selection mark, with coordinates specified relative to
                                          the top-left of the page. The numbers represent the x, y
                                          values of the polygon vertices, clockwise from the left (-180
                                          degrees inclusive) relative to the element orientation.
                                    ]
                                }
                            ],
                            "unit": "str",  # Optional. The unit used by the width,
                              height, and polygon properties. For images, the unit is "pixel". For PDF,
                              the unit is "inch". Known values are: "pixel" and "inch".
                            "width": 0.0,  # Optional. The width of the image/PDF in
                              pixels/inches, respectively.
                            "words": [
                                {
                                    "confidence": 0.0,  # Confidence of correctly
                                      extracting the word. Required.
                                    "content": "str",  # Text content of the
                                      word. Required.
                                    "span": {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    },
                                    "polygon": [
                                        0.0  # Optional. Bounding polygon of
                                          the word, with coordinates specified relative to the top-left
                                          of the page. The numbers represent the x, y values of the
                                          polygon vertices, clockwise from the left (-180 degrees
                                          inclusive) relative to the element orientation.
                                    ]
                                }
                            ]
                        }
                    ],
                    "stringIndexType": "str",  # Method used to compute string offset and length.
                      Required. Known values are: "textElements", "unicodeCodePoint", and
                      "utf16CodeUnit".
                    "contentFormat": "str",  # Optional. Format of the analyze result top-level
                      content. Known values are: "text" and "markdown".
                    "documents": [
                        {
                            "confidence": 0.0,  # Confidence of correctly extracting the
                              document. Required.
                            "docType": "str",  # Document type. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "boundingRegions": [
                                {
                                    "pageNumber": 0,  # 1-based page number of
                                      page containing the bounding region. Required.
                                    "polygon": [
                                        0.0  # Bounding polygon on the page,
                                          or the entire page if not specified. Coordinates specified
                                          relative to the top-left of the page. The numbers represent
                                          the x, y values of the polygon vertices, clockwise from the
                                          left (-180 degrees inclusive) relative to the element
                                          orientation. Required.
                                    ]
                                }
                            ],
                            "fields": {
                                "str": {
                                    "type": "str",  # Data type of the field
                                      value. Required. Known values are: "string", "date", "time",
                                      "phoneNumber", "number", "integer", "selectionMark",
                                      "countryRegion", "signature", "array", "object", "currency",
                                      "address", "boolean", and "selectionGroup".
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "confidence": 0.0,  # Optional. Confidence of
                                      correctly extracting the field.
                                    "content": "str",  # Optional. Field content.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "valueAddress": {
                                        "city": "str",  # Optional. Name of
                                          city, town, village, etc.
                                        "cityDistrict": "str",  # Optional.
                                          Districts or boroughs within a city, such as Brooklyn in New
                                          York City or City of Westminster in London.
                                        "countryRegion": "str",  # Optional.
                                          Country/region.
                                        "house": "str",  # Optional. Build
                                          name, such as World Trade Center.
                                        "houseNumber": "str",  # Optional.
                                          House or building number.
                                        "level": "str",  # Optional. Floor
                                          number, such as 3F.
                                        "poBox": "str",  # Optional. Post
                                          office box number.
                                        "postalCode": "str",  # Optional.
                                          Postal code used for mail sorting.
                                        "road": "str",  # Optional. Street
                                          name.
                                        "state": "str",  # Optional.
                                          First-level administrative division.
                                        "stateDistrict": "str",  # Optional.
                                          Second-level administrative division used in certain locales.
                                        "streetAddress": "str",  # Optional.
                                          Street-level address, excluding city, state, countryRegion,
                                          and postalCode.
                                        "suburb": "str",  # Optional.
                                          Unofficial neighborhood name, like Chinatown.
                                        "unit": "str"  # Optional. Apartment
                                          or office number.
                                    },
                                    "valueArray": [
                                        ...
                                    ],
                                    "valueBoolean": bool,  # Optional. Boolean
                                      value.
                                    "valueCountryRegion": "str",  # Optional.
                                      3-letter country code value (ISO 3166-1 alpha-3).
                                    "valueCurrency": {
                                        "amount": 0.0,  # Currency amount.
                                          Required.
                                        "currencyCode": "str",  # Optional.
                                          Resolved currency code (ISO 4217), if any.
                                        "currencySymbol": "str"  # Optional.
                                          Currency symbol label, if any.
                                    },
                                    "valueDate": "2020-02-20",  # Optional. Date
                                      value in YYYY-MM-DD format (ISO 8601).
                                    "valueInteger": 0,  # Optional. Integer
                                      value.
                                    "valueNumber": 0.0,  # Optional. Floating
                                      point value.
                                    "valueObject": {
                                        "str": ...
                                    },
                                    "valuePhoneNumber": "str",  # Optional. Phone
                                      number value in E.164 format (ex. +19876543210).
                                    "valueSelectionGroup": [
                                        "str"  # Optional. Selection group
                                          value.
                                    ],
                                    "valueSelectionMark": "str",  # Optional.
                                      Selection mark value. Known values are: "selected" and
                                      "unselected".
                                    "valueSignature": "str",  # Optional.
                                      Presence of signature. Known values are: "signed" and "unsigned".
                                    "valueString": "str",  # Optional. String
                                      value.
                                    "valueTime": "12:30:00"  # Optional. Time
                                      value in hh:mm:ss format (ISO 8601).
                                }
                            }
                        }
                    ],
                    "figures": [
                        {
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "boundingRegions": [
                                {
                                    "pageNumber": 0,  # 1-based page number of
                                      page containing the bounding region. Required.
                                    "polygon": [
                                        0.0  # Bounding polygon on the page,
                                          or the entire page if not specified. Coordinates specified
                                          relative to the top-left of the page. The numbers represent
                                          the x, y values of the polygon vertices, clockwise from the
                                          left (-180 degrees inclusive) relative to the element
                                          orientation. Required.
                                    ]
                                }
                            ],
                            "caption": {
                                "content": "str",  # Content of the caption.
                                  Required.
                                "spans": [
                                    {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    }
                                ],
                                "boundingRegions": [
                                    {
                                        "pageNumber": 0,  # 1-based page
                                          number of page containing the bounding region. Required.
                                        "polygon": [
                                            0.0  # Bounding polygon on
                                              the page, or the entire page if not specified.
                                              Coordinates specified relative to the top-left of the
                                              page. The numbers represent the x, y values of the
                                              polygon vertices, clockwise from the left (-180 degrees
                                              inclusive) relative to the element orientation. Required.
                                        ]
                                    }
                                ],
                                "elements": [
                                    "str"  # Optional. Child elements of the
                                      caption.
                                ]
                            },
                            "elements": [
                                "str"  # Optional. Child elements of the figure,
                                  excluding any caption or footnotes.
                            ],
                            "footnotes": [
                                {
                                    "content": "str",  # Content of the footnote.
                                      Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "elements": [
                                        "str"  # Optional. Child elements of
                                          the footnote.
                                    ]
                                }
                            ]
                        }
                    ],
                    "keyValuePairs": [
                        {
                            "confidence": 0.0,  # Confidence of correctly extracting the
                              key-value pair. Required.
                            "key": {
                                "content": "str",  # Concatenated content of the
                                  key-value element in reading order. Required.
                                "spans": [
                                    {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    }
                                ],
                                "boundingRegions": [
                                    {
                                        "pageNumber": 0,  # 1-based page
                                          number of page containing the bounding region. Required.
                                        "polygon": [
                                            0.0  # Bounding polygon on
                                              the page, or the entire page if not specified.
                                              Coordinates specified relative to the top-left of the
                                              page. The numbers represent the x, y values of the
                                              polygon vertices, clockwise from the left (-180 degrees
                                              inclusive) relative to the element orientation. Required.
                                        ]
                                    }
                                ]
                            },
                            "value": {
                                "content": "str",  # Concatenated content of the
                                  key-value element in reading order. Required.
                                "spans": [
                                    {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    }
                                ],
                                "boundingRegions": [
                                    {
                                        "pageNumber": 0,  # 1-based page
                                          number of page containing the bounding region. Required.
                                        "polygon": [
                                            0.0  # Bounding polygon on
                                              the page, or the entire page if not specified.
                                              Coordinates specified relative to the top-left of the
                                              page. The numbers represent the x, y values of the
                                              polygon vertices, clockwise from the left (-180 degrees
                                              inclusive) relative to the element orientation. Required.
                                        ]
                                    }
                                ]
                            }
                        }
                    ],
                    "languages": [
                        {
                            "confidence": 0.0,  # Confidence of correctly identifying the
                              language. Required.
                            "locale": "str",  # Detected language.  Value may an ISO
                              639-1 language code (ex. "en", "fr") or BCP 47 language tag (ex.
                              "zh-Hans"). Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ]
                        }
                    ],
                    "lists": [
                        {
                            "items": [
                                {
                                    "content": "str",  # Content of the list
                                      item. Required.
                                    "level": 0,  # Level of the list item
                                      (1-indexed). Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "elements": [
                                        "str"  # Optional. Child elements of
                                          the list item.
                                    ]
                                }
                            ],
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ]
                        }
                    ],
                    "paragraphs": [
                        {
                            "content": "str",  # Concatenated content of the paragraph in
                              reading order. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "boundingRegions": [
                                {
                                    "pageNumber": 0,  # 1-based page number of
                                      page containing the bounding region. Required.
                                    "polygon": [
                                        0.0  # Bounding polygon on the page,
                                          or the entire page if not specified. Coordinates specified
                                          relative to the top-left of the page. The numbers represent
                                          the x, y values of the polygon vertices, clockwise from the
                                          left (-180 degrees inclusive) relative to the element
                                          orientation. Required.
                                    ]
                                }
                            ],
                            "role": "str"  # Optional. Semantic role of the paragraph.
                              Known values are: "pageHeader", "pageFooter", "pageNumber", "title",
                              "sectionHeading", "footnote", and "formulaBlock".
                        }
                    ],
                    "sections": [
                        {
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "elements": [
                                "str"  # Optional. Child elements of the section.
                            ]
                        }
                    ],
                    "styles": [
                        {
                            "confidence": 0.0,  # Confidence of correctly identifying the
                              style. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "backgroundColor": "str",  # Optional. Background color in
                              #rrggbb hexadecimal format..
                            "color": "str",  # Optional. Foreground color in #rrggbb
                              hexadecimal format.
                            "fontStyle": "str",  # Optional. Font style. Known values
                              are: "normal" and "italic".
                            "fontWeight": "str",  # Optional. Font weight. Known values
                              are: "normal" and "bold".
                            "isHandwritten": bool,  # Optional. Is content handwritten?.
                            "similarFontFamily": "str"  # Optional. Visually most similar
                              font from among the set of supported font families, with fallback fonts
                              following CSS convention (ex. 'Arial, sans-serif').
                        }
                    ],
                    "tables": [
                        {
                            "cells": [
                                {
                                    "columnIndex": 0,  # Column index of the
                                      cell. Required.
                                    "content": "str",  # Concatenated content of
                                      the table cell in reading order. Required.
                                    "rowIndex": 0,  # Row index of the cell.
                                      Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "columnSpan": 0,  # Optional. Number of
                                      columns spanned by this cell.
                                    "elements": [
                                        "str"  # Optional. Child elements of
                                          the table cell.
                                    ],
                                    "kind": "str",  # Optional. Table cell kind.
                                      Known values are: "content", "rowHeader", "columnHeader",
                                      "stubHead", and "description".
                                    "rowSpan": 0  # Optional. Number of rows
                                      spanned by this cell.
                                }
                            ],
                            "columnCount": 0,  # Number of columns in the table.
                              Required.
                            "rowCount": 0,  # Number of rows in the table. Required.
                            "spans": [
                                {
                                    "length": 0,  # Number of characters in the
                                      content represented by the span. Required.
                                    "offset": 0  # Zero-based index of the
                                      content represented by the span. Required.
                                }
                            ],
                            "boundingRegions": [
                                {
                                    "pageNumber": 0,  # 1-based page number of
                                      page containing the bounding region. Required.
                                    "polygon": [
                                        0.0  # Bounding polygon on the page,
                                          or the entire page if not specified. Coordinates specified
                                          relative to the top-left of the page. The numbers represent
                                          the x, y values of the polygon vertices, clockwise from the
                                          left (-180 degrees inclusive) relative to the element
                                          orientation. Required.
                                    ]
                                }
                            ],
                            "caption": {
                                "content": "str",  # Content of the caption.
                                  Required.
                                "spans": [
                                    {
                                        "length": 0,  # Number of characters
                                          in the content represented by the span. Required.
                                        "offset": 0  # Zero-based index of
                                          the content represented by the span. Required.
                                    }
                                ],
                                "boundingRegions": [
                                    {
                                        "pageNumber": 0,  # 1-based page
                                          number of page containing the bounding region. Required.
                                        "polygon": [
                                            0.0  # Bounding polygon on
                                              the page, or the entire page if not specified.
                                              Coordinates specified relative to the top-left of the
                                              page. The numbers represent the x, y values of the
                                              polygon vertices, clockwise from the left (-180 degrees
                                              inclusive) relative to the element orientation. Required.
                                        ]
                                    }
                                ],
                                "elements": [
                                    "str"  # Optional. Child elements of the
                                      caption.
                                ]
                            },
                            "footnotes": [
                                {
                                    "content": "str",  # Content of the footnote.
                                      Required.
                                    "spans": [
                                        {
                                            "length": 0,  # Number of
                                              characters in the content represented by the span.
                                              Required.
                                            "offset": 0  # Zero-based
                                              index of the content represented by the span. Required.
                                        }
                                    ],
                                    "boundingRegions": [
                                        {
                                            "pageNumber": 0,  # 1-based
                                              page number of page containing the bounding region.
                                              Required.
                                            "polygon": [
                                                0.0  # Bounding
                                                  polygon on the page, or the entire page if not
                                                  specified. Coordinates specified relative to the
                                                  top-left of the page. The numbers represent the x, y
                                                  values of the polygon vertices, clockwise from the
                                                  left (-180 degrees inclusive) relative to the element
                                                  orientation. Required.
                                            ]
                                        }
                                    ],
                                    "elements": [
                                        "str"  # Optional. Child elements of
                                          the footnote.
                                    ]
                                }
                            ]
                        }
                    ]
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("content-type", None))
        cls: ClsType[_models.AnalyzeResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._classify_document_initial(  # type: ignore
                classifier_id=classifier_id,
                classify_request=classify_request,
                string_index_type=string_index_type,
                split=split,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

            deserialized = _deserialize(_models.AnalyzeResult, response.json().get("analyzeResult"))
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.AnalyzeResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.AnalyzeResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )


class DocumentIntelligenceAdministrationClientOperationsMixin(  # pylint: disable=name-too-long
    DocumentIntelligenceAdministrationClientMixinABC
):
    async def _build_document_model_initial(  # pylint: disable=inconsistent-return-statements
        self, build_request: Union[_models.BuildDocumentModelRequest, JSON, IO[bytes]], **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(build_request, (IOBase, bytes)):
            _content = build_request
        else:
            _content = json.dumps(build_request, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_document_intelligence_administration_build_document_model_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))
        response_headers["Operation-Location"] = self._deserialize("str", response.headers.get("Operation-Location"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @overload
    async def begin_build_document_model(
        self, build_request: _models.BuildDocumentModelRequest, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[_models.DocumentModelDetails]:
        # pylint: disable=line-too-long
        """Builds a custom document analysis model.

        :param build_request: Build request parameters. Required.
        :type build_request: ~azure.ai.documentintelligence.models.BuildDocumentModelRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns DocumentModelDetails. The
         DocumentModelDetails is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.ai.documentintelligence.models.DocumentModelDetails]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                build_request = {
                    "buildMode": "str",  # Custom document model build mode. Required. Known
                      values are: "template" and "neural".
                    "modelId": "str",  # Unique document model name. Required.
                    "azureBlobFileListSource": {
                        "containerUrl": "str",  # Azure Blob Storage container URL. Required.
                        "fileList": "str"  # Path to a JSONL file within the container
                          specifying a subset of documents. Required.
                    },
                    "azureBlobSource": {
                        "containerUrl": "str",  # Azure Blob Storage container URL. Required.
                        "prefix": "str"  # Optional. Blob name prefix.
                    },
                    "description": "str",  # Optional. Document model description.
                    "tags": {
                        "str": "str"  # Optional. List of key-value tag attributes associated
                          with the document model.
                    }
                }

                # response body for status code(s): 202
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when the
                      document model was created. Required.
                    "modelId": "str",  # Unique document model name. Required.
                    "apiVersion": "str",  # Optional. API version used to create this document
                      model.
                    "azureBlobFileListSource": {
                        "containerUrl": "str",  # Azure Blob Storage container URL. Required.
                        "fileList": "str"  # Path to a JSONL file within the container
                          specifying a subset of documents. Required.
                    },
                    "azureBlobSource": {
                        "containerUrl": "str",  # Azure Blob Storage container URL. Required.
                        "prefix": "str"  # Optional. Blob name prefix.
                    },
                    "buildMode": "str",  # Optional. Custom document model build mode. Known
                      values are: "template" and "neural".
                    "description": "str",  # Optional. Document model description.
                    "docTypes": {
                        "str": {
                            "fieldSchema": {
                                "str": {
                                    "type": "str",  # Semantic data type of the
                                      field value. Required. Known values are: "string", "date",
                                      "time", "phoneNumber", "number", "integer", "selectionMark",
                                      "countryRegion", "signature", "array", "object", "currency",
                                      "address", "boolean", and "selectionGroup".
                                    "description": "str",  # Optional. Field
                                      description.
                                    "example": "str",  # Optional. Example field
                                      content.
                                    "items": ...,
                                    "properties": {
                                        "str": ...
                                    }
                                }
                            },
                            "buildMode": "str",  # Optional. Custom document model build
                              mode. Known values are: "template" and "neural".
                            "description": "str",  # Optional. Document model
                              description.
                            "fieldConfidence": {
                                "str": 0.0  # Optional. Estimated confidence for each
                                  field.
                            }
                        }
                    },
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. Date and time (UTC)
                      when the document model will expire.
                    "tags": {
                        "str": "str"  # Optional. List of key-value tag attributes associated
                          with the document model.
                    },
                    "warnings": [
                        {
                            "code": "str",  # One of a server-defined set of warning
                              codes. Required.
                            "message": "str",  # A human-readable representation of the
                              warning. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ]
                }
        """

    @overload
    async def begin_build_document_model(
        self, build_request: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[_models.DocumentModelDetails]:
        # pylint: disable=line-too-long
        """Builds a custom document analysis model.

        :param build_request: Build request parameters. Required.
        :type build_request: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns DocumentModelDetails. The
         DocumentModelDetails is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.ai.documentintelligence.models.DocumentModelDetails]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when the
                      document model was created. Required.
                    "modelId": "str",  # Unique document model name. Required.
                    "apiVersion": "str",  # Optional. API version used to create this document
                      model.
                    "azureBlobFileListSource": {
                        "containerUrl": "str",  # Azure Blob Storage container URL. Required.
                        "fileList": "str"  # Path to a JSONL file within the container
                          specifying a subset of documents. Required.
                    },
                    "azureBlobSource": {
                        "containerUrl": "str",  # Azure Blob Storage container URL. Required.
                        "prefix": "str"  # Optional. Blob name prefix.
                    },
                    "buildMode": "str",  # Optional. Custom document model build mode. Known
                      values are: "template" and "neural".
                    "description": "str",  # Optional. Document model description.
                    "docTypes": {
                        "str": {
                            "fieldSchema": {
                                "str": {
                                    "type": "str",  # Semantic data type of the
                                      field value. Required. Known values are: "string", "date",
                                      "time", "phoneNumber", "number", "integer", "selectionMark",
                                      "countryRegion", "signature", "array", "object", "currency",
                                      "address", "boolean", and "selectionGroup".
                                    "description": "str",  # Optional. Field
                                      description.
                                    "example": "str",  # Optional. Example field
                                      content.
                                    "items": ...,
                                    "properties": {
                                        "str": ...
                                    }
                                }
                            },
                            "buildMode": "str",  # Optional. Custom document model build
                              mode. Known values are: "template" and "neural".
                            "description": "str",  # Optional. Document model
                              description.
                            "fieldConfidence": {
                                "str": 0.0  # Optional. Estimated confidence for each
                                  field.
                            }
                        }
                    },
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. Date and time (UTC)
                      when the document model will expire.
                    "tags": {
                        "str": "str"  # Optional. List of key-value tag attributes associated
                          with the document model.
                    },
                    "warnings": [
                        {
                            "code": "str",  # One of a server-defined set of warning
                              codes. Required.
                            "message": "str",  # A human-readable representation of the
                              warning. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ]
                }
        """

    @overload
    async def begin_build_document_model(
        self, build_request: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[_models.DocumentModelDetails]:
        # pylint: disable=line-too-long
        """Builds a custom document analysis model.

        :param build_request: Build request parameters. Required.
        :type build_request: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns DocumentModelDetails. The
         DocumentModelDetails is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.ai.documentintelligence.models.DocumentModelDetails]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when the
                      document model was created. Required.
                    "modelId": "str",  # Unique document model name. Required.
                    "apiVersion": "str",  # Optional. API version used to create this document
                      model.
                    "azureBlobFileListSource": {
                        "containerUrl": "str",  # Azure Blob Storage container URL. Required.
                        "fileList": "str"  # Path to a JSONL file within the container
                          specifying a subset of documents. Required.
                    },
                    "azureBlobSource": {
                        "containerUrl": "str",  # Azure Blob Storage container URL. Required.
                        "prefix": "str"  # Optional. Blob name prefix.
                    },
                    "buildMode": "str",  # Optional. Custom document model build mode. Known
                      values are: "template" and "neural".
                    "description": "str",  # Optional. Document model description.
                    "docTypes": {
                        "str": {
                            "fieldSchema": {
                                "str": {
                                    "type": "str",  # Semantic data type of the
                                      field value. Required. Known values are: "string", "date",
                                      "time", "phoneNumber", "number", "integer", "selectionMark",
                                      "countryRegion", "signature", "array", "object", "currency",
                                      "address", "boolean", and "selectionGroup".
                                    "description": "str",  # Optional. Field
                                      description.
                                    "example": "str",  # Optional. Example field
                                      content.
                                    "items": ...,
                                    "properties": {
                                        "str": ...
                                    }
                                }
                            },
                            "buildMode": "str",  # Optional. Custom document model build
                              mode. Known values are: "template" and "neural".
                            "description": "str",  # Optional. Document model
                              description.
                            "fieldConfidence": {
                                "str": 0.0  # Optional. Estimated confidence for each
                                  field.
                            }
                        }
                    },
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. Date and time (UTC)
                      when the document model will expire.
                    "tags": {
                        "str": "str"  # Optional. List of key-value tag attributes associated
                          with the document model.
                    },
                    "warnings": [
                        {
                            "code": "str",  # One of a server-defined set of warning
                              codes. Required.
                            "message": "str",  # A human-readable representation of the
                              warning. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ]
                }
        """

    @distributed_trace_async
    async def begin_build_document_model(
        self, build_request: Union[_models.BuildDocumentModelRequest, JSON, IO[bytes]], **kwargs: Any
    ) -> AsyncLROPoller[_models.DocumentModelDetails]:
        # pylint: disable=line-too-long
        """Builds a custom document analysis model.

        :param build_request: Build request parameters. Is one of the following types:
         BuildDocumentModelRequest, JSON, IO[bytes] Required.
        :type build_request: ~azure.ai.documentintelligence.models.BuildDocumentModelRequest or JSON or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns DocumentModelDetails. The
         DocumentModelDetails is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.ai.documentintelligence.models.DocumentModelDetails]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                build_request = {
                    "buildMode": "str",  # Custom document model build mode. Required. Known
                      values are: "template" and "neural".
                    "modelId": "str",  # Unique document model name. Required.
                    "azureBlobFileListSource": {
                        "containerUrl": "str",  # Azure Blob Storage container URL. Required.
                        "fileList": "str"  # Path to a JSONL file within the container
                          specifying a subset of documents. Required.
                    },
                    "azureBlobSource": {
                        "containerUrl": "str",  # Azure Blob Storage container URL. Required.
                        "prefix": "str"  # Optional. Blob name prefix.
                    },
                    "description": "str",  # Optional. Document model description.
                    "tags": {
                        "str": "str"  # Optional. List of key-value tag attributes associated
                          with the document model.
                    }
                }

                # response body for status code(s): 202
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when the
                      document model was created. Required.
                    "modelId": "str",  # Unique document model name. Required.
                    "apiVersion": "str",  # Optional. API version used to create this document
                      model.
                    "azureBlobFileListSource": {
                        "containerUrl": "str",  # Azure Blob Storage container URL. Required.
                        "fileList": "str"  # Path to a JSONL file within the container
                          specifying a subset of documents. Required.
                    },
                    "azureBlobSource": {
                        "containerUrl": "str",  # Azure Blob Storage container URL. Required.
                        "prefix": "str"  # Optional. Blob name prefix.
                    },
                    "buildMode": "str",  # Optional. Custom document model build mode. Known
                      values are: "template" and "neural".
                    "description": "str",  # Optional. Document model description.
                    "docTypes": {
                        "str": {
                            "fieldSchema": {
                                "str": {
                                    "type": "str",  # Semantic data type of the
                                      field value. Required. Known values are: "string", "date",
                                      "time", "phoneNumber", "number", "integer", "selectionMark",
                                      "countryRegion", "signature", "array", "object", "currency",
                                      "address", "boolean", and "selectionGroup".
                                    "description": "str",  # Optional. Field
                                      description.
                                    "example": "str",  # Optional. Example field
                                      content.
                                    "items": ...,
                                    "properties": {
                                        "str": ...
                                    }
                                }
                            },
                            "buildMode": "str",  # Optional. Custom document model build
                              mode. Known values are: "template" and "neural".
                            "description": "str",  # Optional. Document model
                              description.
                            "fieldConfidence": {
                                "str": 0.0  # Optional. Estimated confidence for each
                                  field.
                            }
                        }
                    },
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. Date and time (UTC)
                      when the document model will expire.
                    "tags": {
                        "str": "str"  # Optional. List of key-value tag attributes associated
                          with the document model.
                    },
                    "warnings": [
                        {
                            "code": "str",  # One of a server-defined set of warning
                              codes. Required.
                            "message": "str",  # A human-readable representation of the
                              warning. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ]
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DocumentModelDetails] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._build_document_model_initial(  # type: ignore
                build_request=build_request,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

            deserialized = _deserialize(_models.DocumentModelDetails, response.json().get("result"))
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.DocumentModelDetails].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.DocumentModelDetails](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _compose_model_initial(  # pylint: disable=inconsistent-return-statements
        self, compose_request: Union[_models.ComposeDocumentModelRequest, JSON, IO[bytes]], **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(compose_request, (IOBase, bytes)):
            _content = compose_request
        else:
            _content = json.dumps(compose_request, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_document_intelligence_administration_compose_model_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))
        response_headers["Operation-Location"] = self._deserialize("str", response.headers.get("Operation-Location"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @overload
    async def begin_compose_model(
        self,
        compose_request: _models.ComposeDocumentModelRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.DocumentModelDetails]:
        # pylint: disable=line-too-long
        """Creates a new document model from document types of existing document models.

        :param compose_request: Compose request parameters. Required.
        :type compose_request: ~azure.ai.documentintelligence.models.ComposeDocumentModelRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns DocumentModelDetails. The
         DocumentModelDetails is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.ai.documentintelligence.models.DocumentModelDetails]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                compose_request = {
                    "componentModels": [
                        {
                            "modelId": "str"  # Unique document model name. Required.
                        }
                    ],
                    "modelId": "str",  # Unique document model name. Required.
                    "description": "str",  # Optional. Document model description.
                    "tags": {
                        "str": "str"  # Optional. List of key-value tag attributes associated
                          with the document model.
                    }
                }

                # response body for status code(s): 202
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when the
                      document model was created. Required.
                    "modelId": "str",  # Unique document model name. Required.
                    "apiVersion": "str",  # Optional. API version used to create this document
                      model.
                    "azureBlobFileListSource": {
                        "containerUrl": "str",  # Azure Blob Storage container URL. Required.
                        "fileList": "str"  # Path to a JSONL file within the container
                          specifying a subset of documents. Required.
                    },
                    "azureBlobSource": {
                        "containerUrl": "str",  # Azure Blob Storage container URL. Required.
                        "prefix": "str"  # Optional. Blob name prefix.
                    },
                    "buildMode": "str",  # Optional. Custom document model build mode. Known
                      values are: "template" and "neural".
                    "description": "str",  # Optional. Document model description.
                    "docTypes": {
                        "str": {
                            "fieldSchema": {
                                "str": {
                                    "type": "str",  # Semantic data type of the
                                      field value. Required. Known values are: "string", "date",
                                      "time", "phoneNumber", "number", "integer", "selectionMark",
                                      "countryRegion", "signature", "array", "object", "currency",
                                      "address", "boolean", and "selectionGroup".
                                    "description": "str",  # Optional. Field
                                      description.
                                    "example": "str",  # Optional. Example field
                                      content.
                                    "items": ...,
                                    "properties": {
                                        "str": ...
                                    }
                                }
                            },
                            "buildMode": "str",  # Optional. Custom document model build
                              mode. Known values are: "template" and "neural".
                            "description": "str",  # Optional. Document model
                              description.
                            "fieldConfidence": {
                                "str": 0.0  # Optional. Estimated confidence for each
                                  field.
                            }
                        }
                    },
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. Date and time (UTC)
                      when the document model will expire.
                    "tags": {
                        "str": "str"  # Optional. List of key-value tag attributes associated
                          with the document model.
                    },
                    "warnings": [
                        {
                            "code": "str",  # One of a server-defined set of warning
                              codes. Required.
                            "message": "str",  # A human-readable representation of the
                              warning. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ]
                }
        """

    @overload
    async def begin_compose_model(
        self, compose_request: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[_models.DocumentModelDetails]:
        # pylint: disable=line-too-long
        """Creates a new document model from document types of existing document models.

        :param compose_request: Compose request parameters. Required.
        :type compose_request: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns DocumentModelDetails. The
         DocumentModelDetails is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.ai.documentintelligence.models.DocumentModelDetails]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when the
                      document model was created. Required.
                    "modelId": "str",  # Unique document model name. Required.
                    "apiVersion": "str",  # Optional. API version used to create this document
                      model.
                    "azureBlobFileListSource": {
                        "containerUrl": "str",  # Azure Blob Storage container URL. Required.
                        "fileList": "str"  # Path to a JSONL file within the container
                          specifying a subset of documents. Required.
                    },
                    "azureBlobSource": {
                        "containerUrl": "str",  # Azure Blob Storage container URL. Required.
                        "prefix": "str"  # Optional. Blob name prefix.
                    },
                    "buildMode": "str",  # Optional. Custom document model build mode. Known
                      values are: "template" and "neural".
                    "description": "str",  # Optional. Document model description.
                    "docTypes": {
                        "str": {
                            "fieldSchema": {
                                "str": {
                                    "type": "str",  # Semantic data type of the
                                      field value. Required. Known values are: "string", "date",
                                      "time", "phoneNumber", "number", "integer", "selectionMark",
                                      "countryRegion", "signature", "array", "object", "currency",
                                      "address", "boolean", and "selectionGroup".
                                    "description": "str",  # Optional. Field
                                      description.
                                    "example": "str",  # Optional. Example field
                                      content.
                                    "items": ...,
                                    "properties": {
                                        "str": ...
                                    }
                                }
                            },
                            "buildMode": "str",  # Optional. Custom document model build
                              mode. Known values are: "template" and "neural".
                            "description": "str",  # Optional. Document model
                              description.
                            "fieldConfidence": {
                                "str": 0.0  # Optional. Estimated confidence for each
                                  field.
                            }
                        }
                    },
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. Date and time (UTC)
                      when the document model will expire.
                    "tags": {
                        "str": "str"  # Optional. List of key-value tag attributes associated
                          with the document model.
                    },
                    "warnings": [
                        {
                            "code": "str",  # One of a server-defined set of warning
                              codes. Required.
                            "message": "str",  # A human-readable representation of the
                              warning. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ]
                }
        """

    @overload
    async def begin_compose_model(
        self, compose_request: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[_models.DocumentModelDetails]:
        # pylint: disable=line-too-long
        """Creates a new document model from document types of existing document models.

        :param compose_request: Compose request parameters. Required.
        :type compose_request: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns DocumentModelDetails. The
         DocumentModelDetails is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.ai.documentintelligence.models.DocumentModelDetails]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when the
                      document model was created. Required.
                    "modelId": "str",  # Unique document model name. Required.
                    "apiVersion": "str",  # Optional. API version used to create this document
                      model.
                    "azureBlobFileListSource": {
                        "containerUrl": "str",  # Azure Blob Storage container URL. Required.
                        "fileList": "str"  # Path to a JSONL file within the container
                          specifying a subset of documents. Required.
                    },
                    "azureBlobSource": {
                        "containerUrl": "str",  # Azure Blob Storage container URL. Required.
                        "prefix": "str"  # Optional. Blob name prefix.
                    },
                    "buildMode": "str",  # Optional. Custom document model build mode. Known
                      values are: "template" and "neural".
                    "description": "str",  # Optional. Document model description.
                    "docTypes": {
                        "str": {
                            "fieldSchema": {
                                "str": {
                                    "type": "str",  # Semantic data type of the
                                      field value. Required. Known values are: "string", "date",
                                      "time", "phoneNumber", "number", "integer", "selectionMark",
                                      "countryRegion", "signature", "array", "object", "currency",
                                      "address", "boolean", and "selectionGroup".
                                    "description": "str",  # Optional. Field
                                      description.
                                    "example": "str",  # Optional. Example field
                                      content.
                                    "items": ...,
                                    "properties": {
                                        "str": ...
                                    }
                                }
                            },
                            "buildMode": "str",  # Optional. Custom document model build
                              mode. Known values are: "template" and "neural".
                            "description": "str",  # Optional. Document model
                              description.
                            "fieldConfidence": {
                                "str": 0.0  # Optional. Estimated confidence for each
                                  field.
                            }
                        }
                    },
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. Date and time (UTC)
                      when the document model will expire.
                    "tags": {
                        "str": "str"  # Optional. List of key-value tag attributes associated
                          with the document model.
                    },
                    "warnings": [
                        {
                            "code": "str",  # One of a server-defined set of warning
                              codes. Required.
                            "message": "str",  # A human-readable representation of the
                              warning. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ]
                }
        """

    @distributed_trace_async
    async def begin_compose_model(
        self, compose_request: Union[_models.ComposeDocumentModelRequest, JSON, IO[bytes]], **kwargs: Any
    ) -> AsyncLROPoller[_models.DocumentModelDetails]:
        # pylint: disable=line-too-long
        """Creates a new document model from document types of existing document models.

        :param compose_request: Compose request parameters. Is one of the following types:
         ComposeDocumentModelRequest, JSON, IO[bytes] Required.
        :type compose_request: ~azure.ai.documentintelligence.models.ComposeDocumentModelRequest or
         JSON or IO[bytes]
        :return: An instance of AsyncLROPoller that returns DocumentModelDetails. The
         DocumentModelDetails is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.ai.documentintelligence.models.DocumentModelDetails]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                compose_request = {
                    "componentModels": [
                        {
                            "modelId": "str"  # Unique document model name. Required.
                        }
                    ],
                    "modelId": "str",  # Unique document model name. Required.
                    "description": "str",  # Optional. Document model description.
                    "tags": {
                        "str": "str"  # Optional. List of key-value tag attributes associated
                          with the document model.
                    }
                }

                # response body for status code(s): 202
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when the
                      document model was created. Required.
                    "modelId": "str",  # Unique document model name. Required.
                    "apiVersion": "str",  # Optional. API version used to create this document
                      model.
                    "azureBlobFileListSource": {
                        "containerUrl": "str",  # Azure Blob Storage container URL. Required.
                        "fileList": "str"  # Path to a JSONL file within the container
                          specifying a subset of documents. Required.
                    },
                    "azureBlobSource": {
                        "containerUrl": "str",  # Azure Blob Storage container URL. Required.
                        "prefix": "str"  # Optional. Blob name prefix.
                    },
                    "buildMode": "str",  # Optional. Custom document model build mode. Known
                      values are: "template" and "neural".
                    "description": "str",  # Optional. Document model description.
                    "docTypes": {
                        "str": {
                            "fieldSchema": {
                                "str": {
                                    "type": "str",  # Semantic data type of the
                                      field value. Required. Known values are: "string", "date",
                                      "time", "phoneNumber", "number", "integer", "selectionMark",
                                      "countryRegion", "signature", "array", "object", "currency",
                                      "address", "boolean", and "selectionGroup".
                                    "description": "str",  # Optional. Field
                                      description.
                                    "example": "str",  # Optional. Example field
                                      content.
                                    "items": ...,
                                    "properties": {
                                        "str": ...
                                    }
                                }
                            },
                            "buildMode": "str",  # Optional. Custom document model build
                              mode. Known values are: "template" and "neural".
                            "description": "str",  # Optional. Document model
                              description.
                            "fieldConfidence": {
                                "str": 0.0  # Optional. Estimated confidence for each
                                  field.
                            }
                        }
                    },
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. Date and time (UTC)
                      when the document model will expire.
                    "tags": {
                        "str": "str"  # Optional. List of key-value tag attributes associated
                          with the document model.
                    },
                    "warnings": [
                        {
                            "code": "str",  # One of a server-defined set of warning
                              codes. Required.
                            "message": "str",  # A human-readable representation of the
                              warning. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ]
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DocumentModelDetails] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._compose_model_initial(  # type: ignore
                compose_request=compose_request,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

            deserialized = _deserialize(_models.DocumentModelDetails, response.json().get("result"))
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.DocumentModelDetails].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.DocumentModelDetails](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @overload
    async def authorize_model_copy(
        self,
        authorize_copy_request: _models.AuthorizeCopyRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CopyAuthorization:
        # pylint: disable=line-too-long
        """Generates authorization to copy a document model to this location with
        specified modelId and optional description.

        :param authorize_copy_request: Authorize copy request parameters. Required.
        :type authorize_copy_request: ~azure.ai.documentintelligence.models.AuthorizeCopyRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CopyAuthorization. The CopyAuthorization is compatible with MutableMapping
        :rtype: ~azure.ai.documentintelligence.models.CopyAuthorization
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                authorize_copy_request = {
                    "modelId": "str",  # Unique document model name. Required.
                    "description": "str",  # Optional. Document model description.
                    "tags": {
                        "str": "str"  # Optional. List of key-value tag attributes associated
                          with the document model.
                    }
                }

                # response body for status code(s): 200
                response == {
                    "accessToken": "str",  # Token used to authorize the request. Required.
                    "expirationDateTime": "2020-02-20 00:00:00",  # Date/time when the access
                      token expires. Required.
                    "targetModelId": "str",  # Identifier of the target document model. Required.
                    "targetModelLocation": "str",  # URL of the copied document model in the
                      target account. Required.
                    "targetResourceId": "str",  # ID of the target Azure resource where the
                      document model should be copied to. Required.
                    "targetResourceRegion": "str"  # Location of the target Azure resource where
                      the document model should be copied to. Required.
                }
        """

    @overload
    async def authorize_model_copy(
        self, authorize_copy_request: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CopyAuthorization:
        # pylint: disable=line-too-long
        """Generates authorization to copy a document model to this location with
        specified modelId and optional description.

        :param authorize_copy_request: Authorize copy request parameters. Required.
        :type authorize_copy_request: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CopyAuthorization. The CopyAuthorization is compatible with MutableMapping
        :rtype: ~azure.ai.documentintelligence.models.CopyAuthorization
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "accessToken": "str",  # Token used to authorize the request. Required.
                    "expirationDateTime": "2020-02-20 00:00:00",  # Date/time when the access
                      token expires. Required.
                    "targetModelId": "str",  # Identifier of the target document model. Required.
                    "targetModelLocation": "str",  # URL of the copied document model in the
                      target account. Required.
                    "targetResourceId": "str",  # ID of the target Azure resource where the
                      document model should be copied to. Required.
                    "targetResourceRegion": "str"  # Location of the target Azure resource where
                      the document model should be copied to. Required.
                }
        """

    @overload
    async def authorize_model_copy(
        self, authorize_copy_request: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CopyAuthorization:
        # pylint: disable=line-too-long
        """Generates authorization to copy a document model to this location with
        specified modelId and optional description.

        :param authorize_copy_request: Authorize copy request parameters. Required.
        :type authorize_copy_request: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CopyAuthorization. The CopyAuthorization is compatible with MutableMapping
        :rtype: ~azure.ai.documentintelligence.models.CopyAuthorization
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "accessToken": "str",  # Token used to authorize the request. Required.
                    "expirationDateTime": "2020-02-20 00:00:00",  # Date/time when the access
                      token expires. Required.
                    "targetModelId": "str",  # Identifier of the target document model. Required.
                    "targetModelLocation": "str",  # URL of the copied document model in the
                      target account. Required.
                    "targetResourceId": "str",  # ID of the target Azure resource where the
                      document model should be copied to. Required.
                    "targetResourceRegion": "str"  # Location of the target Azure resource where
                      the document model should be copied to. Required.
                }
        """

    @distributed_trace_async
    async def authorize_model_copy(
        self, authorize_copy_request: Union[_models.AuthorizeCopyRequest, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.CopyAuthorization:
        # pylint: disable=line-too-long
        """Generates authorization to copy a document model to this location with
        specified modelId and optional description.

        :param authorize_copy_request: Authorize copy request parameters. Is one of the following
         types: AuthorizeCopyRequest, JSON, IO[bytes] Required.
        :type authorize_copy_request: ~azure.ai.documentintelligence.models.AuthorizeCopyRequest or
         JSON or IO[bytes]
        :return: CopyAuthorization. The CopyAuthorization is compatible with MutableMapping
        :rtype: ~azure.ai.documentintelligence.models.CopyAuthorization
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                authorize_copy_request = {
                    "modelId": "str",  # Unique document model name. Required.
                    "description": "str",  # Optional. Document model description.
                    "tags": {
                        "str": "str"  # Optional. List of key-value tag attributes associated
                          with the document model.
                    }
                }

                # response body for status code(s): 200
                response == {
                    "accessToken": "str",  # Token used to authorize the request. Required.
                    "expirationDateTime": "2020-02-20 00:00:00",  # Date/time when the access
                      token expires. Required.
                    "targetModelId": "str",  # Identifier of the target document model. Required.
                    "targetModelLocation": "str",  # URL of the copied document model in the
                      target account. Required.
                    "targetResourceId": "str",  # ID of the target Azure resource where the
                      document model should be copied to. Required.
                    "targetResourceRegion": "str"  # Location of the target Azure resource where
                      the document model should be copied to. Required.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CopyAuthorization] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(authorize_copy_request, (IOBase, bytes)):
            _content = authorize_copy_request
        else:
            _content = json.dumps(authorize_copy_request, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_document_intelligence_administration_authorize_model_copy_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CopyAuthorization, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _copy_model_to_initial(  # pylint: disable=inconsistent-return-statements
        self, model_id: str, copy_to_request: Union[_models.CopyAuthorization, JSON, IO[bytes]], **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(copy_to_request, (IOBase, bytes)):
            _content = copy_to_request
        else:
            _content = json.dumps(copy_to_request, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_document_intelligence_administration_copy_model_to_request(
            model_id=model_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))
        response_headers["Operation-Location"] = self._deserialize("str", response.headers.get("Operation-Location"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @overload
    async def begin_copy_model_to(
        self,
        model_id: str,
        copy_to_request: _models.CopyAuthorization,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.DocumentModelDetails]:
        # pylint: disable=line-too-long
        """Copies document model to the target resource, region, and modelId.

        :param model_id: Unique document model name. Required.
        :type model_id: str
        :param copy_to_request: Copy to request parameters. Required.
        :type copy_to_request: ~azure.ai.documentintelligence.models.CopyAuthorization
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns DocumentModelDetails. The
         DocumentModelDetails is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.ai.documentintelligence.models.DocumentModelDetails]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                copy_to_request = {
                    "accessToken": "str",  # Token used to authorize the request. Required.
                    "expirationDateTime": "2020-02-20 00:00:00",  # Date/time when the access
                      token expires. Required.
                    "targetModelId": "str",  # Identifier of the target document model. Required.
                    "targetModelLocation": "str",  # URL of the copied document model in the
                      target account. Required.
                    "targetResourceId": "str",  # ID of the target Azure resource where the
                      document model should be copied to. Required.
                    "targetResourceRegion": "str"  # Location of the target Azure resource where
                      the document model should be copied to. Required.
                }

                # response body for status code(s): 202
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when the
                      document model was created. Required.
                    "modelId": "str",  # Unique document model name. Required.
                    "apiVersion": "str",  # Optional. API version used to create this document
                      model.
                    "azureBlobFileListSource": {
                        "containerUrl": "str",  # Azure Blob Storage container URL. Required.
                        "fileList": "str"  # Path to a JSONL file within the container
                          specifying a subset of documents. Required.
                    },
                    "azureBlobSource": {
                        "containerUrl": "str",  # Azure Blob Storage container URL. Required.
                        "prefix": "str"  # Optional. Blob name prefix.
                    },
                    "buildMode": "str",  # Optional. Custom document model build mode. Known
                      values are: "template" and "neural".
                    "description": "str",  # Optional. Document model description.
                    "docTypes": {
                        "str": {
                            "fieldSchema": {
                                "str": {
                                    "type": "str",  # Semantic data type of the
                                      field value. Required. Known values are: "string", "date",
                                      "time", "phoneNumber", "number", "integer", "selectionMark",
                                      "countryRegion", "signature", "array", "object", "currency",
                                      "address", "boolean", and "selectionGroup".
                                    "description": "str",  # Optional. Field
                                      description.
                                    "example": "str",  # Optional. Example field
                                      content.
                                    "items": ...,
                                    "properties": {
                                        "str": ...
                                    }
                                }
                            },
                            "buildMode": "str",  # Optional. Custom document model build
                              mode. Known values are: "template" and "neural".
                            "description": "str",  # Optional. Document model
                              description.
                            "fieldConfidence": {
                                "str": 0.0  # Optional. Estimated confidence for each
                                  field.
                            }
                        }
                    },
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. Date and time (UTC)
                      when the document model will expire.
                    "tags": {
                        "str": "str"  # Optional. List of key-value tag attributes associated
                          with the document model.
                    },
                    "warnings": [
                        {
                            "code": "str",  # One of a server-defined set of warning
                              codes. Required.
                            "message": "str",  # A human-readable representation of the
                              warning. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ]
                }
        """

    @overload
    async def begin_copy_model_to(
        self, model_id: str, copy_to_request: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[_models.DocumentModelDetails]:
        # pylint: disable=line-too-long
        """Copies document model to the target resource, region, and modelId.

        :param model_id: Unique document model name. Required.
        :type model_id: str
        :param copy_to_request: Copy to request parameters. Required.
        :type copy_to_request: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns DocumentModelDetails. The
         DocumentModelDetails is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.ai.documentintelligence.models.DocumentModelDetails]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when the
                      document model was created. Required.
                    "modelId": "str",  # Unique document model name. Required.
                    "apiVersion": "str",  # Optional. API version used to create this document
                      model.
                    "azureBlobFileListSource": {
                        "containerUrl": "str",  # Azure Blob Storage container URL. Required.
                        "fileList": "str"  # Path to a JSONL file within the container
                          specifying a subset of documents. Required.
                    },
                    "azureBlobSource": {
                        "containerUrl": "str",  # Azure Blob Storage container URL. Required.
                        "prefix": "str"  # Optional. Blob name prefix.
                    },
                    "buildMode": "str",  # Optional. Custom document model build mode. Known
                      values are: "template" and "neural".
                    "description": "str",  # Optional. Document model description.
                    "docTypes": {
                        "str": {
                            "fieldSchema": {
                                "str": {
                                    "type": "str",  # Semantic data type of the
                                      field value. Required. Known values are: "string", "date",
                                      "time", "phoneNumber", "number", "integer", "selectionMark",
                                      "countryRegion", "signature", "array", "object", "currency",
                                      "address", "boolean", and "selectionGroup".
                                    "description": "str",  # Optional. Field
                                      description.
                                    "example": "str",  # Optional. Example field
                                      content.
                                    "items": ...,
                                    "properties": {
                                        "str": ...
                                    }
                                }
                            },
                            "buildMode": "str",  # Optional. Custom document model build
                              mode. Known values are: "template" and "neural".
                            "description": "str",  # Optional. Document model
                              description.
                            "fieldConfidence": {
                                "str": 0.0  # Optional. Estimated confidence for each
                                  field.
                            }
                        }
                    },
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. Date and time (UTC)
                      when the document model will expire.
                    "tags": {
                        "str": "str"  # Optional. List of key-value tag attributes associated
                          with the document model.
                    },
                    "warnings": [
                        {
                            "code": "str",  # One of a server-defined set of warning
                              codes. Required.
                            "message": "str",  # A human-readable representation of the
                              warning. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ]
                }
        """

    @overload
    async def begin_copy_model_to(
        self, model_id: str, copy_to_request: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[_models.DocumentModelDetails]:
        # pylint: disable=line-too-long
        """Copies document model to the target resource, region, and modelId.

        :param model_id: Unique document model name. Required.
        :type model_id: str
        :param copy_to_request: Copy to request parameters. Required.
        :type copy_to_request: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns DocumentModelDetails. The
         DocumentModelDetails is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.ai.documentintelligence.models.DocumentModelDetails]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when the
                      document model was created. Required.
                    "modelId": "str",  # Unique document model name. Required.
                    "apiVersion": "str",  # Optional. API version used to create this document
                      model.
                    "azureBlobFileListSource": {
                        "containerUrl": "str",  # Azure Blob Storage container URL. Required.
                        "fileList": "str"  # Path to a JSONL file within the container
                          specifying a subset of documents. Required.
                    },
                    "azureBlobSource": {
                        "containerUrl": "str",  # Azure Blob Storage container URL. Required.
                        "prefix": "str"  # Optional. Blob name prefix.
                    },
                    "buildMode": "str",  # Optional. Custom document model build mode. Known
                      values are: "template" and "neural".
                    "description": "str",  # Optional. Document model description.
                    "docTypes": {
                        "str": {
                            "fieldSchema": {
                                "str": {
                                    "type": "str",  # Semantic data type of the
                                      field value. Required. Known values are: "string", "date",
                                      "time", "phoneNumber", "number", "integer", "selectionMark",
                                      "countryRegion", "signature", "array", "object", "currency",
                                      "address", "boolean", and "selectionGroup".
                                    "description": "str",  # Optional. Field
                                      description.
                                    "example": "str",  # Optional. Example field
                                      content.
                                    "items": ...,
                                    "properties": {
                                        "str": ...
                                    }
                                }
                            },
                            "buildMode": "str",  # Optional. Custom document model build
                              mode. Known values are: "template" and "neural".
                            "description": "str",  # Optional. Document model
                              description.
                            "fieldConfidence": {
                                "str": 0.0  # Optional. Estimated confidence for each
                                  field.
                            }
                        }
                    },
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. Date and time (UTC)
                      when the document model will expire.
                    "tags": {
                        "str": "str"  # Optional. List of key-value tag attributes associated
                          with the document model.
                    },
                    "warnings": [
                        {
                            "code": "str",  # One of a server-defined set of warning
                              codes. Required.
                            "message": "str",  # A human-readable representation of the
                              warning. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ]
                }
        """

    @distributed_trace_async
    async def begin_copy_model_to(
        self, model_id: str, copy_to_request: Union[_models.CopyAuthorization, JSON, IO[bytes]], **kwargs: Any
    ) -> AsyncLROPoller[_models.DocumentModelDetails]:
        # pylint: disable=line-too-long
        """Copies document model to the target resource, region, and modelId.

        :param model_id: Unique document model name. Required.
        :type model_id: str
        :param copy_to_request: Copy to request parameters. Is one of the following types:
         CopyAuthorization, JSON, IO[bytes] Required.
        :type copy_to_request: ~azure.ai.documentintelligence.models.CopyAuthorization or JSON or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns DocumentModelDetails. The
         DocumentModelDetails is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.ai.documentintelligence.models.DocumentModelDetails]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                copy_to_request = {
                    "accessToken": "str",  # Token used to authorize the request. Required.
                    "expirationDateTime": "2020-02-20 00:00:00",  # Date/time when the access
                      token expires. Required.
                    "targetModelId": "str",  # Identifier of the target document model. Required.
                    "targetModelLocation": "str",  # URL of the copied document model in the
                      target account. Required.
                    "targetResourceId": "str",  # ID of the target Azure resource where the
                      document model should be copied to. Required.
                    "targetResourceRegion": "str"  # Location of the target Azure resource where
                      the document model should be copied to. Required.
                }

                # response body for status code(s): 202
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when the
                      document model was created. Required.
                    "modelId": "str",  # Unique document model name. Required.
                    "apiVersion": "str",  # Optional. API version used to create this document
                      model.
                    "azureBlobFileListSource": {
                        "containerUrl": "str",  # Azure Blob Storage container URL. Required.
                        "fileList": "str"  # Path to a JSONL file within the container
                          specifying a subset of documents. Required.
                    },
                    "azureBlobSource": {
                        "containerUrl": "str",  # Azure Blob Storage container URL. Required.
                        "prefix": "str"  # Optional. Blob name prefix.
                    },
                    "buildMode": "str",  # Optional. Custom document model build mode. Known
                      values are: "template" and "neural".
                    "description": "str",  # Optional. Document model description.
                    "docTypes": {
                        "str": {
                            "fieldSchema": {
                                "str": {
                                    "type": "str",  # Semantic data type of the
                                      field value. Required. Known values are: "string", "date",
                                      "time", "phoneNumber", "number", "integer", "selectionMark",
                                      "countryRegion", "signature", "array", "object", "currency",
                                      "address", "boolean", and "selectionGroup".
                                    "description": "str",  # Optional. Field
                                      description.
                                    "example": "str",  # Optional. Example field
                                      content.
                                    "items": ...,
                                    "properties": {
                                        "str": ...
                                    }
                                }
                            },
                            "buildMode": "str",  # Optional. Custom document model build
                              mode. Known values are: "template" and "neural".
                            "description": "str",  # Optional. Document model
                              description.
                            "fieldConfidence": {
                                "str": 0.0  # Optional. Estimated confidence for each
                                  field.
                            }
                        }
                    },
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. Date and time (UTC)
                      when the document model will expire.
                    "tags": {
                        "str": "str"  # Optional. List of key-value tag attributes associated
                          with the document model.
                    },
                    "warnings": [
                        {
                            "code": "str",  # One of a server-defined set of warning
                              codes. Required.
                            "message": "str",  # A human-readable representation of the
                              warning. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ]
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DocumentModelDetails] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._copy_model_to_initial(  # type: ignore
                model_id=model_id,
                copy_to_request=copy_to_request,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

            deserialized = _deserialize(_models.DocumentModelDetails, response.json().get("result"))
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.DocumentModelDetails].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.DocumentModelDetails](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace_async
    async def get_model(self, model_id: str, **kwargs: Any) -> _models.DocumentModelDetails:
        # pylint: disable=line-too-long
        """Gets detailed document model information.

        :param model_id: Unique document model name. Required.
        :type model_id: str
        :return: DocumentModelDetails. The DocumentModelDetails is compatible with MutableMapping
        :rtype: ~azure.ai.documentintelligence.models.DocumentModelDetails
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when the
                      document model was created. Required.
                    "modelId": "str",  # Unique document model name. Required.
                    "apiVersion": "str",  # Optional. API version used to create this document
                      model.
                    "azureBlobFileListSource": {
                        "containerUrl": "str",  # Azure Blob Storage container URL. Required.
                        "fileList": "str"  # Path to a JSONL file within the container
                          specifying a subset of documents. Required.
                    },
                    "azureBlobSource": {
                        "containerUrl": "str",  # Azure Blob Storage container URL. Required.
                        "prefix": "str"  # Optional. Blob name prefix.
                    },
                    "buildMode": "str",  # Optional. Custom document model build mode. Known
                      values are: "template" and "neural".
                    "description": "str",  # Optional. Document model description.
                    "docTypes": {
                        "str": {
                            "fieldSchema": {
                                "str": {
                                    "type": "str",  # Semantic data type of the
                                      field value. Required. Known values are: "string", "date",
                                      "time", "phoneNumber", "number", "integer", "selectionMark",
                                      "countryRegion", "signature", "array", "object", "currency",
                                      "address", "boolean", and "selectionGroup".
                                    "description": "str",  # Optional. Field
                                      description.
                                    "example": "str",  # Optional. Example field
                                      content.
                                    "items": ...,
                                    "properties": {
                                        "str": ...
                                    }
                                }
                            },
                            "buildMode": "str",  # Optional. Custom document model build
                              mode. Known values are: "template" and "neural".
                            "description": "str",  # Optional. Document model
                              description.
                            "fieldConfidence": {
                                "str": 0.0  # Optional. Estimated confidence for each
                                  field.
                            }
                        }
                    },
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. Date and time (UTC)
                      when the document model will expire.
                    "tags": {
                        "str": "str"  # Optional. List of key-value tag attributes associated
                          with the document model.
                    },
                    "warnings": [
                        {
                            "code": "str",  # One of a server-defined set of warning
                              codes. Required.
                            "message": "str",  # A human-readable representation of the
                              warning. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ]
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.DocumentModelDetails] = kwargs.pop("cls", None)

        _request = build_document_intelligence_administration_get_model_request(
            model_id=model_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.DocumentModelDetails, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_models(self, **kwargs: Any) -> AsyncIterable["_models.DocumentModelDetails"]:
        # pylint: disable=line-too-long
        """List all document models.

        :return: An iterator like instance of DocumentModelDetails
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.ai.documentintelligence.models.DocumentModelDetails]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when the
                      document model was created. Required.
                    "modelId": "str",  # Unique document model name. Required.
                    "apiVersion": "str",  # Optional. API version used to create this document
                      model.
                    "azureBlobFileListSource": {
                        "containerUrl": "str",  # Azure Blob Storage container URL. Required.
                        "fileList": "str"  # Path to a JSONL file within the container
                          specifying a subset of documents. Required.
                    },
                    "azureBlobSource": {
                        "containerUrl": "str",  # Azure Blob Storage container URL. Required.
                        "prefix": "str"  # Optional. Blob name prefix.
                    },
                    "buildMode": "str",  # Optional. Custom document model build mode. Known
                      values are: "template" and "neural".
                    "description": "str",  # Optional. Document model description.
                    "docTypes": {
                        "str": {
                            "fieldSchema": {
                                "str": {
                                    "type": "str",  # Semantic data type of the
                                      field value. Required. Known values are: "string", "date",
                                      "time", "phoneNumber", "number", "integer", "selectionMark",
                                      "countryRegion", "signature", "array", "object", "currency",
                                      "address", "boolean", and "selectionGroup".
                                    "description": "str",  # Optional. Field
                                      description.
                                    "example": "str",  # Optional. Example field
                                      content.
                                    "items": ...,
                                    "properties": {
                                        "str": ...
                                    }
                                }
                            },
                            "buildMode": "str",  # Optional. Custom document model build
                              mode. Known values are: "template" and "neural".
                            "description": "str",  # Optional. Document model
                              description.
                            "fieldConfidence": {
                                "str": 0.0  # Optional. Estimated confidence for each
                                  field.
                            }
                        }
                    },
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. Date and time (UTC)
                      when the document model will expire.
                    "tags": {
                        "str": "str"  # Optional. List of key-value tag attributes associated
                          with the document model.
                    },
                    "warnings": [
                        {
                            "code": "str",  # One of a server-defined set of warning
                              codes. Required.
                            "message": "str",  # A human-readable representation of the
                              warning. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ]
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.DocumentModelDetails]] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_document_intelligence_administration_list_models_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.DocumentModelDetails], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _deserialize(_models.ErrorResponse, response.json())
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def delete_model(  # pylint: disable=inconsistent-return-statements
        self, model_id: str, **kwargs: Any
    ) -> None:
        """Deletes document model.

        :param model_id: Unique document model name. Required.
        :type model_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_document_intelligence_administration_delete_model_request(
            model_id=model_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace_async
    async def get_resource_info(self, **kwargs: Any) -> _models.ResourceDetails:
        # pylint: disable=line-too-long
        """Return information about the current resource.

        :return: ResourceDetails. The ResourceDetails is compatible with MutableMapping
        :rtype: ~azure.ai.documentintelligence.models.ResourceDetails
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "customDocumentModels": {
                        "count": 0,  # Number of custom document models in the current
                          resource. Required.
                        "limit": 0  # Maximum number of custom document models supported in
                          the current resource. Required.
                    },
                    "customNeuralDocumentModelBuilds": {
                        "quota": 0,  # Resource quota limit. Required.
                        "quotaResetDateTime": "2020-02-20 00:00:00",  # Date/time when the
                          resource quota usage will be reset. Required.
                        "used": 0  # Amount of the resource quota used. Required.
                    }
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.ResourceDetails] = kwargs.pop("cls", None)

        _request = build_document_intelligence_administration_get_resource_info_request(
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.ResourceDetails, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_operation(self, operation_id: str, **kwargs: Any) -> _models.OperationDetails:
        # pylint: disable=line-too-long
        """Gets operation info.

        :param operation_id: Operation ID. Required.
        :type operation_id: str
        :return: OperationDetails. The OperationDetails is compatible with MutableMapping
        :rtype: ~azure.ai.documentintelligence.models.OperationDetails
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "documentClassifierBuild":
                operation_details = {
                    "createdDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when the
                      operation was created. Required.
                    "kind": "documentClassifierBuild",
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when the
                      status was last updated. Required.
                    "operationId": "str",  # Operation ID. Required.
                    "resourceLocation": "str",  # URL of the resource targeted by this operation.
                      Required.
                    "status": "str",  # Operation status.  notStarted, running, completed, or
                      failed. Required. Known values are: "notStarted", "running", "failed",
                      "succeeded", "completed", and "canceled".
                    "apiVersion": "str",  # Optional. API version used to create this operation.
                    "error": {
                        "code": "str",  # One of a server-defined set of error codes.
                          Required.
                        "message": "str",  # A human-readable representation of the error.
                          Required.
                        "details": [
                            ...
                        ],
                        "innererror": {
                            "code": "str",  # Optional. One of a server-defined set of
                              error codes.
                            "innererror": ...,
                            "message": "str"  # Optional. A human-readable representation
                              of the error.
                        },
                        "target": "str"  # Optional. The target of the error.
                    },
                    "percentCompleted": 0,  # Optional. Operation progress (0-100).
                    "result": {
                        "apiVersion": "str",  # API version used to create this document
                          classifier. Required.
                        "classifierId": "str",  # Unique document classifier name. Required.
                        "createdDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when
                          the document classifier was created. Required.
                        "docTypes": {
                            "str": {
                                "azureBlobFileListSource": {
                                    "containerUrl": "str",  # Azure Blob Storage
                                      container URL. Required.
                                    "fileList": "str"  # Path to a JSONL file
                                      within the container specifying a subset of documents. Required.
                                },
                                "azureBlobSource": {
                                    "containerUrl": "str",  # Azure Blob Storage
                                      container URL. Required.
                                    "prefix": "str"  # Optional. Blob name
                                      prefix.
                                },
                                "sourceKind": "str"  # Optional. Type of training
                                  data source. Known values are: "url", "base64", "azureBlob", and
                                  "azureBlobFileList".
                            }
                        },
                        "baseClassifierId": "str",  # Optional. Base classifierId on top of
                          which the classifier was trained.
                        "description": "str",  # Optional. Document classifier description.
                        "expirationDateTime": "2020-02-20 00:00:00",  # Optional. Date and
                          time (UTC) when the document classifier will expire.
                        "warnings": [
                            {
                                "code": "str",  # One of a server-defined set of
                                  warning codes. Required.
                                "message": "str",  # A human-readable representation
                                  of the warning. Required.
                                "target": "str"  # Optional. The target of the error.
                            }
                        ]
                    },
                    "tags": {
                        "str": "str"  # Optional. List of key-value tag attributes associated
                          with the document model.
                    }
                }

                # JSON input template for discriminator value "documentModelCompose":
                operation_details = {
                    "createdDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when the
                      operation was created. Required.
                    "kind": "documentModelCompose",
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when the
                      status was last updated. Required.
                    "operationId": "str",  # Operation ID. Required.
                    "resourceLocation": "str",  # URL of the resource targeted by this operation.
                      Required.
                    "status": "str",  # Operation status.  notStarted, running, completed, or
                      failed. Required. Known values are: "notStarted", "running", "failed",
                      "succeeded", "completed", and "canceled".
                    "apiVersion": "str",  # Optional. API version used to create this operation.
                    "error": {
                        "code": "str",  # One of a server-defined set of error codes.
                          Required.
                        "message": "str",  # A human-readable representation of the error.
                          Required.
                        "details": [
                            ...
                        ],
                        "innererror": {
                            "code": "str",  # Optional. One of a server-defined set of
                              error codes.
                            "innererror": ...,
                            "message": "str"  # Optional. A human-readable representation
                              of the error.
                        },
                        "target": "str"  # Optional. The target of the error.
                    },
                    "percentCompleted": 0,  # Optional. Operation progress (0-100).
                    "result": {
                        "createdDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when
                          the document model was created. Required.
                        "modelId": "str",  # Unique document model name. Required.
                        "apiVersion": "str",  # Optional. API version used to create this
                          document model.
                        "azureBlobFileListSource": {
                            "containerUrl": "str",  # Azure Blob Storage container URL.
                              Required.
                            "fileList": "str"  # Path to a JSONL file within the
                              container specifying a subset of documents. Required.
                        },
                        "azureBlobSource": {
                            "containerUrl": "str",  # Azure Blob Storage container URL.
                              Required.
                            "prefix": "str"  # Optional. Blob name prefix.
                        },
                        "buildMode": "str",  # Optional. Custom document model build mode.
                          Known values are: "template" and "neural".
                        "description": "str",  # Optional. Document model description.
                        "docTypes": {
                            "str": {
                                "fieldSchema": {
                                    "str": {
                                        "type": "str",  # Semantic data type
                                          of the field value. Required. Known values are: "string",
                                          "date", "time", "phoneNumber", "number", "integer",
                                          "selectionMark", "countryRegion", "signature", "array",
                                          "object", "currency", "address", "boolean", and
                                          "selectionGroup".
                                        "description": "str",  # Optional.
                                          Field description.
                                        "example": "str",  # Optional.
                                          Example field content.
                                        "items": ...,
                                        "properties": {
                                            "str": ...
                                        }
                                    }
                                },
                                "buildMode": "str",  # Optional. Custom document
                                  model build mode. Known values are: "template" and "neural".
                                "description": "str",  # Optional. Document model
                                  description.
                                "fieldConfidence": {
                                    "str": 0.0  # Optional. Estimated confidence
                                      for each field.
                                }
                            }
                        },
                        "expirationDateTime": "2020-02-20 00:00:00",  # Optional. Date and
                          time (UTC) when the document model will expire.
                        "tags": {
                            "str": "str"  # Optional. List of key-value tag attributes
                              associated with the document model.
                        },
                        "warnings": [
                            {
                                "code": "str",  # One of a server-defined set of
                                  warning codes. Required.
                                "message": "str",  # A human-readable representation
                                  of the warning. Required.
                                "target": "str"  # Optional. The target of the error.
                            }
                        ]
                    },
                    "tags": {
                        "str": "str"  # Optional. List of key-value tag attributes associated
                          with the document model.
                    }
                }

                # JSON input template for discriminator value "documentModelCopyTo":
                operation_details = {
                    "createdDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when the
                      operation was created. Required.
                    "kind": "documentModelCopyTo",
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when the
                      status was last updated. Required.
                    "operationId": "str",  # Operation ID. Required.
                    "resourceLocation": "str",  # URL of the resource targeted by this operation.
                      Required.
                    "status": "str",  # Operation status.  notStarted, running, completed, or
                      failed. Required. Known values are: "notStarted", "running", "failed",
                      "succeeded", "completed", and "canceled".
                    "apiVersion": "str",  # Optional. API version used to create this operation.
                    "error": {
                        "code": "str",  # One of a server-defined set of error codes.
                          Required.
                        "message": "str",  # A human-readable representation of the error.
                          Required.
                        "details": [
                            ...
                        ],
                        "innererror": {
                            "code": "str",  # Optional. One of a server-defined set of
                              error codes.
                            "innererror": ...,
                            "message": "str"  # Optional. A human-readable representation
                              of the error.
                        },
                        "target": "str"  # Optional. The target of the error.
                    },
                    "percentCompleted": 0,  # Optional. Operation progress (0-100).
                    "result": {
                        "createdDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when
                          the document model was created. Required.
                        "modelId": "str",  # Unique document model name. Required.
                        "apiVersion": "str",  # Optional. API version used to create this
                          document model.
                        "azureBlobFileListSource": {
                            "containerUrl": "str",  # Azure Blob Storage container URL.
                              Required.
                            "fileList": "str"  # Path to a JSONL file within the
                              container specifying a subset of documents. Required.
                        },
                        "azureBlobSource": {
                            "containerUrl": "str",  # Azure Blob Storage container URL.
                              Required.
                            "prefix": "str"  # Optional. Blob name prefix.
                        },
                        "buildMode": "str",  # Optional. Custom document model build mode.
                          Known values are: "template" and "neural".
                        "description": "str",  # Optional. Document model description.
                        "docTypes": {
                            "str": {
                                "fieldSchema": {
                                    "str": {
                                        "type": "str",  # Semantic data type
                                          of the field value. Required. Known values are: "string",
                                          "date", "time", "phoneNumber", "number", "integer",
                                          "selectionMark", "countryRegion", "signature", "array",
                                          "object", "currency", "address", "boolean", and
                                          "selectionGroup".
                                        "description": "str",  # Optional.
                                          Field description.
                                        "example": "str",  # Optional.
                                          Example field content.
                                        "items": ...,
                                        "properties": {
                                            "str": ...
                                        }
                                    }
                                },
                                "buildMode": "str",  # Optional. Custom document
                                  model build mode. Known values are: "template" and "neural".
                                "description": "str",  # Optional. Document model
                                  description.
                                "fieldConfidence": {
                                    "str": 0.0  # Optional. Estimated confidence
                                      for each field.
                                }
                            }
                        },
                        "expirationDateTime": "2020-02-20 00:00:00",  # Optional. Date and
                          time (UTC) when the document model will expire.
                        "tags": {
                            "str": "str"  # Optional. List of key-value tag attributes
                              associated with the document model.
                        },
                        "warnings": [
                            {
                                "code": "str",  # One of a server-defined set of
                                  warning codes. Required.
                                "message": "str",  # A human-readable representation
                                  of the warning. Required.
                                "target": "str"  # Optional. The target of the error.
                            }
                        ]
                    },
                    "tags": {
                        "str": "str"  # Optional. List of key-value tag attributes associated
                          with the document model.
                    }
                }

                # response body for status code(s): 200
                response == operation_details
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.OperationDetails] = kwargs.pop("cls", None)

        _request = build_document_intelligence_administration_get_operation_request(
            operation_id=operation_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.OperationDetails, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_operations(self, **kwargs: Any) -> AsyncIterable["_models.OperationDetails"]:
        # pylint: disable=line-too-long
        """Lists all operations.

        :return: An iterator like instance of OperationDetails
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.ai.documentintelligence.models.OperationDetails]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "documentClassifierBuild":
                operation_details = {
                    "createdDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when the
                      operation was created. Required.
                    "kind": "documentClassifierBuild",
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when the
                      status was last updated. Required.
                    "operationId": "str",  # Operation ID. Required.
                    "resourceLocation": "str",  # URL of the resource targeted by this operation.
                      Required.
                    "status": "str",  # Operation status.  notStarted, running, completed, or
                      failed. Required. Known values are: "notStarted", "running", "failed",
                      "succeeded", "completed", and "canceled".
                    "apiVersion": "str",  # Optional. API version used to create this operation.
                    "error": {
                        "code": "str",  # One of a server-defined set of error codes.
                          Required.
                        "message": "str",  # A human-readable representation of the error.
                          Required.
                        "details": [
                            ...
                        ],
                        "innererror": {
                            "code": "str",  # Optional. One of a server-defined set of
                              error codes.
                            "innererror": ...,
                            "message": "str"  # Optional. A human-readable representation
                              of the error.
                        },
                        "target": "str"  # Optional. The target of the error.
                    },
                    "percentCompleted": 0,  # Optional. Operation progress (0-100).
                    "result": {
                        "apiVersion": "str",  # API version used to create this document
                          classifier. Required.
                        "classifierId": "str",  # Unique document classifier name. Required.
                        "createdDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when
                          the document classifier was created. Required.
                        "docTypes": {
                            "str": {
                                "azureBlobFileListSource": {
                                    "containerUrl": "str",  # Azure Blob Storage
                                      container URL. Required.
                                    "fileList": "str"  # Path to a JSONL file
                                      within the container specifying a subset of documents. Required.
                                },
                                "azureBlobSource": {
                                    "containerUrl": "str",  # Azure Blob Storage
                                      container URL. Required.
                                    "prefix": "str"  # Optional. Blob name
                                      prefix.
                                },
                                "sourceKind": "str"  # Optional. Type of training
                                  data source. Known values are: "url", "base64", "azureBlob", and
                                  "azureBlobFileList".
                            }
                        },
                        "baseClassifierId": "str",  # Optional. Base classifierId on top of
                          which the classifier was trained.
                        "description": "str",  # Optional. Document classifier description.
                        "expirationDateTime": "2020-02-20 00:00:00",  # Optional. Date and
                          time (UTC) when the document classifier will expire.
                        "warnings": [
                            {
                                "code": "str",  # One of a server-defined set of
                                  warning codes. Required.
                                "message": "str",  # A human-readable representation
                                  of the warning. Required.
                                "target": "str"  # Optional. The target of the error.
                            }
                        ]
                    },
                    "tags": {
                        "str": "str"  # Optional. List of key-value tag attributes associated
                          with the document model.
                    }
                }

                # JSON input template for discriminator value "documentModelCompose":
                operation_details = {
                    "createdDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when the
                      operation was created. Required.
                    "kind": "documentModelCompose",
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when the
                      status was last updated. Required.
                    "operationId": "str",  # Operation ID. Required.
                    "resourceLocation": "str",  # URL of the resource targeted by this operation.
                      Required.
                    "status": "str",  # Operation status.  notStarted, running, completed, or
                      failed. Required. Known values are: "notStarted", "running", "failed",
                      "succeeded", "completed", and "canceled".
                    "apiVersion": "str",  # Optional. API version used to create this operation.
                    "error": {
                        "code": "str",  # One of a server-defined set of error codes.
                          Required.
                        "message": "str",  # A human-readable representation of the error.
                          Required.
                        "details": [
                            ...
                        ],
                        "innererror": {
                            "code": "str",  # Optional. One of a server-defined set of
                              error codes.
                            "innererror": ...,
                            "message": "str"  # Optional. A human-readable representation
                              of the error.
                        },
                        "target": "str"  # Optional. The target of the error.
                    },
                    "percentCompleted": 0,  # Optional. Operation progress (0-100).
                    "result": {
                        "createdDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when
                          the document model was created. Required.
                        "modelId": "str",  # Unique document model name. Required.
                        "apiVersion": "str",  # Optional. API version used to create this
                          document model.
                        "azureBlobFileListSource": {
                            "containerUrl": "str",  # Azure Blob Storage container URL.
                              Required.
                            "fileList": "str"  # Path to a JSONL file within the
                              container specifying a subset of documents. Required.
                        },
                        "azureBlobSource": {
                            "containerUrl": "str",  # Azure Blob Storage container URL.
                              Required.
                            "prefix": "str"  # Optional. Blob name prefix.
                        },
                        "buildMode": "str",  # Optional. Custom document model build mode.
                          Known values are: "template" and "neural".
                        "description": "str",  # Optional. Document model description.
                        "docTypes": {
                            "str": {
                                "fieldSchema": {
                                    "str": {
                                        "type": "str",  # Semantic data type
                                          of the field value. Required. Known values are: "string",
                                          "date", "time", "phoneNumber", "number", "integer",
                                          "selectionMark", "countryRegion", "signature", "array",
                                          "object", "currency", "address", "boolean", and
                                          "selectionGroup".
                                        "description": "str",  # Optional.
                                          Field description.
                                        "example": "str",  # Optional.
                                          Example field content.
                                        "items": ...,
                                        "properties": {
                                            "str": ...
                                        }
                                    }
                                },
                                "buildMode": "str",  # Optional. Custom document
                                  model build mode. Known values are: "template" and "neural".
                                "description": "str",  # Optional. Document model
                                  description.
                                "fieldConfidence": {
                                    "str": 0.0  # Optional. Estimated confidence
                                      for each field.
                                }
                            }
                        },
                        "expirationDateTime": "2020-02-20 00:00:00",  # Optional. Date and
                          time (UTC) when the document model will expire.
                        "tags": {
                            "str": "str"  # Optional. List of key-value tag attributes
                              associated with the document model.
                        },
                        "warnings": [
                            {
                                "code": "str",  # One of a server-defined set of
                                  warning codes. Required.
                                "message": "str",  # A human-readable representation
                                  of the warning. Required.
                                "target": "str"  # Optional. The target of the error.
                            }
                        ]
                    },
                    "tags": {
                        "str": "str"  # Optional. List of key-value tag attributes associated
                          with the document model.
                    }
                }

                # JSON input template for discriminator value "documentModelCopyTo":
                operation_details = {
                    "createdDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when the
                      operation was created. Required.
                    "kind": "documentModelCopyTo",
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when the
                      status was last updated. Required.
                    "operationId": "str",  # Operation ID. Required.
                    "resourceLocation": "str",  # URL of the resource targeted by this operation.
                      Required.
                    "status": "str",  # Operation status.  notStarted, running, completed, or
                      failed. Required. Known values are: "notStarted", "running", "failed",
                      "succeeded", "completed", and "canceled".
                    "apiVersion": "str",  # Optional. API version used to create this operation.
                    "error": {
                        "code": "str",  # One of a server-defined set of error codes.
                          Required.
                        "message": "str",  # A human-readable representation of the error.
                          Required.
                        "details": [
                            ...
                        ],
                        "innererror": {
                            "code": "str",  # Optional. One of a server-defined set of
                              error codes.
                            "innererror": ...,
                            "message": "str"  # Optional. A human-readable representation
                              of the error.
                        },
                        "target": "str"  # Optional. The target of the error.
                    },
                    "percentCompleted": 0,  # Optional. Operation progress (0-100).
                    "result": {
                        "createdDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when
                          the document model was created. Required.
                        "modelId": "str",  # Unique document model name. Required.
                        "apiVersion": "str",  # Optional. API version used to create this
                          document model.
                        "azureBlobFileListSource": {
                            "containerUrl": "str",  # Azure Blob Storage container URL.
                              Required.
                            "fileList": "str"  # Path to a JSONL file within the
                              container specifying a subset of documents. Required.
                        },
                        "azureBlobSource": {
                            "containerUrl": "str",  # Azure Blob Storage container URL.
                              Required.
                            "prefix": "str"  # Optional. Blob name prefix.
                        },
                        "buildMode": "str",  # Optional. Custom document model build mode.
                          Known values are: "template" and "neural".
                        "description": "str",  # Optional. Document model description.
                        "docTypes": {
                            "str": {
                                "fieldSchema": {
                                    "str": {
                                        "type": "str",  # Semantic data type
                                          of the field value. Required. Known values are: "string",
                                          "date", "time", "phoneNumber", "number", "integer",
                                          "selectionMark", "countryRegion", "signature", "array",
                                          "object", "currency", "address", "boolean", and
                                          "selectionGroup".
                                        "description": "str",  # Optional.
                                          Field description.
                                        "example": "str",  # Optional.
                                          Example field content.
                                        "items": ...,
                                        "properties": {
                                            "str": ...
                                        }
                                    }
                                },
                                "buildMode": "str",  # Optional. Custom document
                                  model build mode. Known values are: "template" and "neural".
                                "description": "str",  # Optional. Document model
                                  description.
                                "fieldConfidence": {
                                    "str": 0.0  # Optional. Estimated confidence
                                      for each field.
                                }
                            }
                        },
                        "expirationDateTime": "2020-02-20 00:00:00",  # Optional. Date and
                          time (UTC) when the document model will expire.
                        "tags": {
                            "str": "str"  # Optional. List of key-value tag attributes
                              associated with the document model.
                        },
                        "warnings": [
                            {
                                "code": "str",  # One of a server-defined set of
                                  warning codes. Required.
                                "message": "str",  # A human-readable representation
                                  of the warning. Required.
                                "target": "str"  # Optional. The target of the error.
                            }
                        ]
                    },
                    "tags": {
                        "str": "str"  # Optional. List of key-value tag attributes associated
                          with the document model.
                    }
                }

                # response body for status code(s): 200
                response == operation_details
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.OperationDetails]] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_document_intelligence_administration_list_operations_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.OperationDetails], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _deserialize(_models.ErrorResponse, response.json())
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    async def _build_classifier_initial(  # pylint: disable=inconsistent-return-statements
        self, build_request: Union[_models.BuildDocumentClassifierRequest, JSON, IO[bytes]], **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(build_request, (IOBase, bytes)):
            _content = build_request
        else:
            _content = json.dumps(build_request, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_document_intelligence_administration_build_classifier_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))
        response_headers["Operation-Location"] = self._deserialize("str", response.headers.get("Operation-Location"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @overload
    async def begin_build_classifier(
        self,
        build_request: _models.BuildDocumentClassifierRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.DocumentClassifierDetails]:
        # pylint: disable=line-too-long
        """Builds a custom document classifier.

        :param build_request: Build request parameters. Required.
        :type build_request: ~azure.ai.documentintelligence.models.BuildDocumentClassifierRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns DocumentClassifierDetails. The
         DocumentClassifierDetails is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.ai.documentintelligence.models.DocumentClassifierDetails]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                build_request = {
                    "classifierId": "str",  # Unique document classifier name. Required.
                    "docTypes": {
                        "str": {
                            "azureBlobFileListSource": {
                                "containerUrl": "str",  # Azure Blob Storage
                                  container URL. Required.
                                "fileList": "str"  # Path to a JSONL file within the
                                  container specifying a subset of documents. Required.
                            },
                            "azureBlobSource": {
                                "containerUrl": "str",  # Azure Blob Storage
                                  container URL. Required.
                                "prefix": "str"  # Optional. Blob name prefix.
                            },
                            "sourceKind": "str"  # Optional. Type of training data
                              source. Known values are: "url", "base64", "azureBlob", and
                              "azureBlobFileList".
                        }
                    },
                    "baseClassifierId": "str",  # Optional. Base classifierId on top of which to
                      train the classifier.
                    "description": "str"  # Optional. Document classifier description.
                }

                # response body for status code(s): 202
                response == {
                    "apiVersion": "str",  # API version used to create this document classifier.
                      Required.
                    "classifierId": "str",  # Unique document classifier name. Required.
                    "createdDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when the
                      document classifier was created. Required.
                    "docTypes": {
                        "str": {
                            "azureBlobFileListSource": {
                                "containerUrl": "str",  # Azure Blob Storage
                                  container URL. Required.
                                "fileList": "str"  # Path to a JSONL file within the
                                  container specifying a subset of documents. Required.
                            },
                            "azureBlobSource": {
                                "containerUrl": "str",  # Azure Blob Storage
                                  container URL. Required.
                                "prefix": "str"  # Optional. Blob name prefix.
                            },
                            "sourceKind": "str"  # Optional. Type of training data
                              source. Known values are: "url", "base64", "azureBlob", and
                              "azureBlobFileList".
                        }
                    },
                    "baseClassifierId": "str",  # Optional. Base classifierId on top of which the
                      classifier was trained.
                    "description": "str",  # Optional. Document classifier description.
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. Date and time (UTC)
                      when the document classifier will expire.
                    "warnings": [
                        {
                            "code": "str",  # One of a server-defined set of warning
                              codes. Required.
                            "message": "str",  # A human-readable representation of the
                              warning. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ]
                }
        """

    @overload
    async def begin_build_classifier(
        self, build_request: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[_models.DocumentClassifierDetails]:
        # pylint: disable=line-too-long
        """Builds a custom document classifier.

        :param build_request: Build request parameters. Required.
        :type build_request: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns DocumentClassifierDetails. The
         DocumentClassifierDetails is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.ai.documentintelligence.models.DocumentClassifierDetails]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "apiVersion": "str",  # API version used to create this document classifier.
                      Required.
                    "classifierId": "str",  # Unique document classifier name. Required.
                    "createdDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when the
                      document classifier was created. Required.
                    "docTypes": {
                        "str": {
                            "azureBlobFileListSource": {
                                "containerUrl": "str",  # Azure Blob Storage
                                  container URL. Required.
                                "fileList": "str"  # Path to a JSONL file within the
                                  container specifying a subset of documents. Required.
                            },
                            "azureBlobSource": {
                                "containerUrl": "str",  # Azure Blob Storage
                                  container URL. Required.
                                "prefix": "str"  # Optional. Blob name prefix.
                            },
                            "sourceKind": "str"  # Optional. Type of training data
                              source. Known values are: "url", "base64", "azureBlob", and
                              "azureBlobFileList".
                        }
                    },
                    "baseClassifierId": "str",  # Optional. Base classifierId on top of which the
                      classifier was trained.
                    "description": "str",  # Optional. Document classifier description.
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. Date and time (UTC)
                      when the document classifier will expire.
                    "warnings": [
                        {
                            "code": "str",  # One of a server-defined set of warning
                              codes. Required.
                            "message": "str",  # A human-readable representation of the
                              warning. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ]
                }
        """

    @overload
    async def begin_build_classifier(
        self, build_request: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[_models.DocumentClassifierDetails]:
        # pylint: disable=line-too-long
        """Builds a custom document classifier.

        :param build_request: Build request parameters. Required.
        :type build_request: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns DocumentClassifierDetails. The
         DocumentClassifierDetails is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.ai.documentintelligence.models.DocumentClassifierDetails]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "apiVersion": "str",  # API version used to create this document classifier.
                      Required.
                    "classifierId": "str",  # Unique document classifier name. Required.
                    "createdDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when the
                      document classifier was created. Required.
                    "docTypes": {
                        "str": {
                            "azureBlobFileListSource": {
                                "containerUrl": "str",  # Azure Blob Storage
                                  container URL. Required.
                                "fileList": "str"  # Path to a JSONL file within the
                                  container specifying a subset of documents. Required.
                            },
                            "azureBlobSource": {
                                "containerUrl": "str",  # Azure Blob Storage
                                  container URL. Required.
                                "prefix": "str"  # Optional. Blob name prefix.
                            },
                            "sourceKind": "str"  # Optional. Type of training data
                              source. Known values are: "url", "base64", "azureBlob", and
                              "azureBlobFileList".
                        }
                    },
                    "baseClassifierId": "str",  # Optional. Base classifierId on top of which the
                      classifier was trained.
                    "description": "str",  # Optional. Document classifier description.
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. Date and time (UTC)
                      when the document classifier will expire.
                    "warnings": [
                        {
                            "code": "str",  # One of a server-defined set of warning
                              codes. Required.
                            "message": "str",  # A human-readable representation of the
                              warning. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ]
                }
        """

    @distributed_trace_async
    async def begin_build_classifier(
        self, build_request: Union[_models.BuildDocumentClassifierRequest, JSON, IO[bytes]], **kwargs: Any
    ) -> AsyncLROPoller[_models.DocumentClassifierDetails]:
        # pylint: disable=line-too-long
        """Builds a custom document classifier.

        :param build_request: Build request parameters. Is one of the following types:
         BuildDocumentClassifierRequest, JSON, IO[bytes] Required.
        :type build_request: ~azure.ai.documentintelligence.models.BuildDocumentClassifierRequest or
         JSON or IO[bytes]
        :return: An instance of AsyncLROPoller that returns DocumentClassifierDetails. The
         DocumentClassifierDetails is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.ai.documentintelligence.models.DocumentClassifierDetails]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                build_request = {
                    "classifierId": "str",  # Unique document classifier name. Required.
                    "docTypes": {
                        "str": {
                            "azureBlobFileListSource": {
                                "containerUrl": "str",  # Azure Blob Storage
                                  container URL. Required.
                                "fileList": "str"  # Path to a JSONL file within the
                                  container specifying a subset of documents. Required.
                            },
                            "azureBlobSource": {
                                "containerUrl": "str",  # Azure Blob Storage
                                  container URL. Required.
                                "prefix": "str"  # Optional. Blob name prefix.
                            },
                            "sourceKind": "str"  # Optional. Type of training data
                              source. Known values are: "url", "base64", "azureBlob", and
                              "azureBlobFileList".
                        }
                    },
                    "baseClassifierId": "str",  # Optional. Base classifierId on top of which to
                      train the classifier.
                    "description": "str"  # Optional. Document classifier description.
                }

                # response body for status code(s): 202
                response == {
                    "apiVersion": "str",  # API version used to create this document classifier.
                      Required.
                    "classifierId": "str",  # Unique document classifier name. Required.
                    "createdDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when the
                      document classifier was created. Required.
                    "docTypes": {
                        "str": {
                            "azureBlobFileListSource": {
                                "containerUrl": "str",  # Azure Blob Storage
                                  container URL. Required.
                                "fileList": "str"  # Path to a JSONL file within the
                                  container specifying a subset of documents. Required.
                            },
                            "azureBlobSource": {
                                "containerUrl": "str",  # Azure Blob Storage
                                  container URL. Required.
                                "prefix": "str"  # Optional. Blob name prefix.
                            },
                            "sourceKind": "str"  # Optional. Type of training data
                              source. Known values are: "url", "base64", "azureBlob", and
                              "azureBlobFileList".
                        }
                    },
                    "baseClassifierId": "str",  # Optional. Base classifierId on top of which the
                      classifier was trained.
                    "description": "str",  # Optional. Document classifier description.
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. Date and time (UTC)
                      when the document classifier will expire.
                    "warnings": [
                        {
                            "code": "str",  # One of a server-defined set of warning
                              codes. Required.
                            "message": "str",  # A human-readable representation of the
                              warning. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ]
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DocumentClassifierDetails] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._build_classifier_initial(  # type: ignore
                build_request=build_request,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

            deserialized = _deserialize(_models.DocumentClassifierDetails, response.json().get("result"))
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.DocumentClassifierDetails].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.DocumentClassifierDetails](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace_async
    async def get_classifier(self, classifier_id: str, **kwargs: Any) -> _models.DocumentClassifierDetails:
        # pylint: disable=line-too-long
        """Gets detailed document classifier information.

        :param classifier_id: Unique document classifier name. Required.
        :type classifier_id: str
        :return: DocumentClassifierDetails. The DocumentClassifierDetails is compatible with
         MutableMapping
        :rtype: ~azure.ai.documentintelligence.models.DocumentClassifierDetails
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "apiVersion": "str",  # API version used to create this document classifier.
                      Required.
                    "classifierId": "str",  # Unique document classifier name. Required.
                    "createdDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when the
                      document classifier was created. Required.
                    "docTypes": {
                        "str": {
                            "azureBlobFileListSource": {
                                "containerUrl": "str",  # Azure Blob Storage
                                  container URL. Required.
                                "fileList": "str"  # Path to a JSONL file within the
                                  container specifying a subset of documents. Required.
                            },
                            "azureBlobSource": {
                                "containerUrl": "str",  # Azure Blob Storage
                                  container URL. Required.
                                "prefix": "str"  # Optional. Blob name prefix.
                            },
                            "sourceKind": "str"  # Optional. Type of training data
                              source. Known values are: "url", "base64", "azureBlob", and
                              "azureBlobFileList".
                        }
                    },
                    "baseClassifierId": "str",  # Optional. Base classifierId on top of which the
                      classifier was trained.
                    "description": "str",  # Optional. Document classifier description.
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. Date and time (UTC)
                      when the document classifier will expire.
                    "warnings": [
                        {
                            "code": "str",  # One of a server-defined set of warning
                              codes. Required.
                            "message": "str",  # A human-readable representation of the
                              warning. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ]
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.DocumentClassifierDetails] = kwargs.pop("cls", None)

        _request = build_document_intelligence_administration_get_classifier_request(
            classifier_id=classifier_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.DocumentClassifierDetails, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_classifiers(self, **kwargs: Any) -> AsyncIterable["_models.DocumentClassifierDetails"]:
        # pylint: disable=line-too-long
        """List all document classifiers.

        :return: An iterator like instance of DocumentClassifierDetails
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.ai.documentintelligence.models.DocumentClassifierDetails]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "apiVersion": "str",  # API version used to create this document classifier.
                      Required.
                    "classifierId": "str",  # Unique document classifier name. Required.
                    "createdDateTime": "2020-02-20 00:00:00",  # Date and time (UTC) when the
                      document classifier was created. Required.
                    "docTypes": {
                        "str": {
                            "azureBlobFileListSource": {
                                "containerUrl": "str",  # Azure Blob Storage
                                  container URL. Required.
                                "fileList": "str"  # Path to a JSONL file within the
                                  container specifying a subset of documents. Required.
                            },
                            "azureBlobSource": {
                                "containerUrl": "str",  # Azure Blob Storage
                                  container URL. Required.
                                "prefix": "str"  # Optional. Blob name prefix.
                            },
                            "sourceKind": "str"  # Optional. Type of training data
                              source. Known values are: "url", "base64", "azureBlob", and
                              "azureBlobFileList".
                        }
                    },
                    "baseClassifierId": "str",  # Optional. Base classifierId on top of which the
                      classifier was trained.
                    "description": "str",  # Optional. Document classifier description.
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. Date and time (UTC)
                      when the document classifier will expire.
                    "warnings": [
                        {
                            "code": "str",  # One of a server-defined set of warning
                              codes. Required.
                            "message": "str",  # A human-readable representation of the
                              warning. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ]
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.DocumentClassifierDetails]] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_document_intelligence_administration_list_classifiers_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.DocumentClassifierDetails], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _deserialize(_models.ErrorResponse, response.json())
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def delete_classifier(  # pylint: disable=inconsistent-return-statements
        self, classifier_id: str, **kwargs: Any
    ) -> None:
        """Deletes document classifier.

        :param classifier_id: Unique document classifier name. Required.
        :type classifier_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_document_intelligence_administration_delete_classifier_request(
            classifier_id=classifier_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore
