# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._web_site_management_client_enums import *


class AbnormalTimePeriod(msrest.serialization.Model):
    """Class representing Abnormal Time Period identified in diagnosis.

    :param start_time: Start time of the downtime.
    :type start_time: ~datetime.datetime
    :param end_time: End time of the downtime.
    :type end_time: ~datetime.datetime
    :param events: List of Possible Cause of downtime.
    :type events: list[~azure.mgmt.web.v2019_08_01.models.DetectorAbnormalTimePeriod]
    :param solutions: List of proposed solutions.
    :type solutions: list[~azure.mgmt.web.v2019_08_01.models.Solution]
    """

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'events': {'key': 'events', 'type': '[DetectorAbnormalTimePeriod]'},
        'solutions': {'key': 'solutions', 'type': '[Solution]'},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        events: Optional[List["DetectorAbnormalTimePeriod"]] = None,
        solutions: Optional[List["Solution"]] = None,
        **kwargs
    ):
        super(AbnormalTimePeriod, self).__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.events = events
        self.solutions = solutions


class Address(msrest.serialization.Model):
    """Address information for domain registration.

    All required parameters must be populated in order to send to Azure.

    :param address1: Required. First line of an Address.
    :type address1: str
    :param address2: The second line of the Address. Optional.
    :type address2: str
    :param city: Required. The city for the address.
    :type city: str
    :param country: Required. The country for the address.
    :type country: str
    :param postal_code: Required. The postal code for the address.
    :type postal_code: str
    :param state: Required. The state or province for the address.
    :type state: str
    """

    _validation = {
        'address1': {'required': True},
        'city': {'required': True},
        'country': {'required': True},
        'postal_code': {'required': True},
        'state': {'required': True},
    }

    _attribute_map = {
        'address1': {'key': 'address1', 'type': 'str'},
        'address2': {'key': 'address2', 'type': 'str'},
        'city': {'key': 'city', 'type': 'str'},
        'country': {'key': 'country', 'type': 'str'},
        'postal_code': {'key': 'postalCode', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        address1: str,
        city: str,
        country: str,
        postal_code: str,
        state: str,
        address2: Optional[str] = None,
        **kwargs
    ):
        super(Address, self).__init__(**kwargs)
        self.address1 = address1
        self.address2 = address2
        self.city = city
        self.country = country
        self.postal_code = postal_code
        self.state = state


class ProxyOnlyResource(msrest.serialization.Model):
    """Azure proxy only resource. This resource is not tracked by Azure Resource Manager.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        super(ProxyOnlyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.kind = kind
        self.type = None


class AddressResponse(ProxyOnlyResource):
    """Describes main public IP address and any extra virtual IPs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param service_ip_address: Main public virtual IP.
    :type service_ip_address: str
    :param internal_ip_address: Virtual Network internal IP address of the App Service Environment
     if it is in internal load-balancing mode.
    :type internal_ip_address: str
    :param outbound_ip_addresses: IP addresses appearing on outbound connections.
    :type outbound_ip_addresses: list[str]
    :param vip_mappings: Additional virtual IPs.
    :type vip_mappings: list[~azure.mgmt.web.v2019_08_01.models.VirtualIPMapping]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'service_ip_address': {'key': 'properties.serviceIpAddress', 'type': 'str'},
        'internal_ip_address': {'key': 'properties.internalIpAddress', 'type': 'str'},
        'outbound_ip_addresses': {'key': 'properties.outboundIpAddresses', 'type': '[str]'},
        'vip_mappings': {'key': 'properties.vipMappings', 'type': '[VirtualIPMapping]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        service_ip_address: Optional[str] = None,
        internal_ip_address: Optional[str] = None,
        outbound_ip_addresses: Optional[List[str]] = None,
        vip_mappings: Optional[List["VirtualIPMapping"]] = None,
        **kwargs
    ):
        super(AddressResponse, self).__init__(kind=kind, **kwargs)
        self.service_ip_address = service_ip_address
        self.internal_ip_address = internal_ip_address
        self.outbound_ip_addresses = outbound_ip_addresses
        self.vip_mappings = vip_mappings


class AnalysisData(msrest.serialization.Model):
    """Class Representing Detector Evidence used for analysis.

    :param source: Name of the Detector.
    :type source: str
    :param detector_definition: Detector Definition.
    :type detector_definition: ~azure.mgmt.web.v2019_08_01.models.DetectorDefinition
    :param metrics: Source Metrics.
    :type metrics: list[~azure.mgmt.web.v2019_08_01.models.DiagnosticMetricSet]
    :param data: Additional Source Data.
    :type data: list[list[~azure.mgmt.web.v2019_08_01.models.NameValuePair]]
    :param detector_meta_data: Detector Meta Data.
    :type detector_meta_data: ~azure.mgmt.web.v2019_08_01.models.ResponseMetaData
    """

    _attribute_map = {
        'source': {'key': 'source', 'type': 'str'},
        'detector_definition': {'key': 'detectorDefinition', 'type': 'DetectorDefinition'},
        'metrics': {'key': 'metrics', 'type': '[DiagnosticMetricSet]'},
        'data': {'key': 'data', 'type': '[[NameValuePair]]'},
        'detector_meta_data': {'key': 'detectorMetaData', 'type': 'ResponseMetaData'},
    }

    def __init__(
        self,
        *,
        source: Optional[str] = None,
        detector_definition: Optional["DetectorDefinition"] = None,
        metrics: Optional[List["DiagnosticMetricSet"]] = None,
        data: Optional[List[List["NameValuePair"]]] = None,
        detector_meta_data: Optional["ResponseMetaData"] = None,
        **kwargs
    ):
        super(AnalysisData, self).__init__(**kwargs)
        self.source = source
        self.detector_definition = detector_definition
        self.metrics = metrics
        self.data = data
        self.detector_meta_data = detector_meta_data


class AnalysisDefinition(ProxyOnlyResource):
    """Definition of Analysis.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar description: Description of the Analysis.
    :vartype description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        super(AnalysisDefinition, self).__init__(kind=kind, **kwargs)
        self.description = None


class ApiDefinitionInfo(msrest.serialization.Model):
    """Information about the formal API definition for the app.

    :param url: The URL of the API definition.
    :type url: str
    """

    _attribute_map = {
        'url': {'key': 'url', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        url: Optional[str] = None,
        **kwargs
    ):
        super(ApiDefinitionInfo, self).__init__(**kwargs)
        self.url = url


class ApiKVReference(msrest.serialization.Model):
    """Description of site key vault references.

    :param reference:
    :type reference: str
    :param status:  Possible values include: "Initialized", "Resolved", "InvalidSyntax",
     "MSINotEnabled", "VaultNotFound", "SecretNotFound", "SecretVersionNotFound",
     "AccessToKeyVaultDenied", "OtherReasons".
    :type status: str or ~azure.mgmt.web.v2019_08_01.models.ResolveStatus
    :param vault_name:
    :type vault_name: str
    :param secret_name:
    :type secret_name: str
    :param secret_version:
    :type secret_version: str
    :param identity_type: Type of managed service identity. Possible values include:
     "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned", "None".
    :type identity_type: str or ~azure.mgmt.web.v2019_08_01.models.ManagedServiceIdentityType
    :param details:
    :type details: str
    :param source:  The only acceptable values to pass in are None and "KeyVault". The default
     value is None.
    :type source: str
    :param location:  The only acceptable values to pass in are None and "ApplicationSetting". The
     default value is None.
    :type location: str
    """

    _attribute_map = {
        'reference': {'key': 'reference', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'vault_name': {'key': 'vaultName', 'type': 'str'},
        'secret_name': {'key': 'secretName', 'type': 'str'},
        'secret_version': {'key': 'secretVersion', 'type': 'str'},
        'identity_type': {'key': 'identityType', 'type': 'str'},
        'details': {'key': 'details', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        reference: Optional[str] = None,
        status: Optional[Union[str, "ResolveStatus"]] = None,
        vault_name: Optional[str] = None,
        secret_name: Optional[str] = None,
        secret_version: Optional[str] = None,
        identity_type: Optional[Union[str, "ManagedServiceIdentityType"]] = None,
        details: Optional[str] = None,
        source: Optional[str] = None,
        location: Optional[str] = None,
        **kwargs
    ):
        super(ApiKVReference, self).__init__(**kwargs)
        self.reference = reference
        self.status = status
        self.vault_name = vault_name
        self.secret_name = secret_name
        self.secret_version = secret_version
        self.identity_type = identity_type
        self.details = details
        self.source = source
        self.location = location


class ApiManagementConfig(msrest.serialization.Model):
    """Azure API management (APIM) configuration linked to the app.

    :param id: APIM-Api Identifier.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(ApiManagementConfig, self).__init__(**kwargs)
        self.id = id


class ApplicationLogsConfig(msrest.serialization.Model):
    """Application logs configuration.

    :param file_system: Application logs to file system configuration.
    :type file_system: ~azure.mgmt.web.v2019_08_01.models.FileSystemApplicationLogsConfig
    :param azure_table_storage: Application logs to azure table storage configuration.
    :type azure_table_storage:
     ~azure.mgmt.web.v2019_08_01.models.AzureTableStorageApplicationLogsConfig
    :param azure_blob_storage: Application logs to blob storage configuration.
    :type azure_blob_storage:
     ~azure.mgmt.web.v2019_08_01.models.AzureBlobStorageApplicationLogsConfig
    """

    _attribute_map = {
        'file_system': {'key': 'fileSystem', 'type': 'FileSystemApplicationLogsConfig'},
        'azure_table_storage': {'key': 'azureTableStorage', 'type': 'AzureTableStorageApplicationLogsConfig'},
        'azure_blob_storage': {'key': 'azureBlobStorage', 'type': 'AzureBlobStorageApplicationLogsConfig'},
    }

    def __init__(
        self,
        *,
        file_system: Optional["FileSystemApplicationLogsConfig"] = None,
        azure_table_storage: Optional["AzureTableStorageApplicationLogsConfig"] = None,
        azure_blob_storage: Optional["AzureBlobStorageApplicationLogsConfig"] = None,
        **kwargs
    ):
        super(ApplicationLogsConfig, self).__init__(**kwargs)
        self.file_system = file_system
        self.azure_table_storage = azure_table_storage
        self.azure_blob_storage = azure_blob_storage


class ApplicationStack(msrest.serialization.Model):
    """Application stack.

    :param name: Application stack name.
    :type name: str
    :param display: Application stack display name.
    :type display: str
    :param dependency: Application stack dependency.
    :type dependency: str
    :param major_versions: List of major versions available.
    :type major_versions: list[~azure.mgmt.web.v2019_08_01.models.StackMajorVersion]
    :param frameworks: List of frameworks associated with application stack.
    :type frameworks: list[~azure.mgmt.web.v2019_08_01.models.ApplicationStack]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'str'},
        'dependency': {'key': 'dependency', 'type': 'str'},
        'major_versions': {'key': 'majorVersions', 'type': '[StackMajorVersion]'},
        'frameworks': {'key': 'frameworks', 'type': '[ApplicationStack]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional[str] = None,
        dependency: Optional[str] = None,
        major_versions: Optional[List["StackMajorVersion"]] = None,
        frameworks: Optional[List["ApplicationStack"]] = None,
        **kwargs
    ):
        super(ApplicationStack, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.dependency = dependency
        self.major_versions = major_versions
        self.frameworks = frameworks


class ApplicationStackCollection(msrest.serialization.Model):
    """Collection of Application Stacks.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.ApplicationStackResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationStackResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["ApplicationStackResource"],
        **kwargs
    ):
        super(ApplicationStackCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ApplicationStackResource(ProxyOnlyResource):
    """ARM resource for a ApplicationStack.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param name_properties_name: Application stack name.
    :type name_properties_name: str
    :param display: Application stack display name.
    :type display: str
    :param dependency: Application stack dependency.
    :type dependency: str
    :param major_versions: List of major versions available.
    :type major_versions: list[~azure.mgmt.web.v2019_08_01.models.StackMajorVersion]
    :param frameworks: List of frameworks associated with application stack.
    :type frameworks: list[~azure.mgmt.web.v2019_08_01.models.ApplicationStack]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'display': {'key': 'properties.display', 'type': 'str'},
        'dependency': {'key': 'properties.dependency', 'type': 'str'},
        'major_versions': {'key': 'properties.majorVersions', 'type': '[StackMajorVersion]'},
        'frameworks': {'key': 'properties.frameworks', 'type': '[ApplicationStack]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        name_properties_name: Optional[str] = None,
        display: Optional[str] = None,
        dependency: Optional[str] = None,
        major_versions: Optional[List["StackMajorVersion"]] = None,
        frameworks: Optional[List["ApplicationStack"]] = None,
        **kwargs
    ):
        super(ApplicationStackResource, self).__init__(kind=kind, **kwargs)
        self.name_properties_name = name_properties_name
        self.display = display
        self.dependency = dependency
        self.major_versions = major_versions
        self.frameworks = frameworks


class AppServiceCertificate(msrest.serialization.Model):
    """Key Vault container for a certificate that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param key_vault_id: Key Vault resource Id.
    :type key_vault_id: str
    :param key_vault_secret_name: Key Vault secret name.
    :type key_vault_secret_name: str
    :ivar provisioning_state: Status of the Key Vault secret. Possible values include:
     "Initialized", "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey",
     "Unknown".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2019_08_01.models.KeyVaultSecretStatus
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'key_vault_id': {'key': 'keyVaultId', 'type': 'str'},
        'key_vault_secret_name': {'key': 'keyVaultSecretName', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_vault_id: Optional[str] = None,
        key_vault_secret_name: Optional[str] = None,
        **kwargs
    ):
        super(AppServiceCertificate, self).__init__(**kwargs)
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.provisioning_state = None


class AppServiceCertificateCollection(msrest.serialization.Model):
    """Collection of certificate order certificates.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.AppServiceCertificateResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AppServiceCertificateResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["AppServiceCertificateResource"],
        **kwargs
    ):
        super(AppServiceCertificateCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class Resource(msrest.serialization.Model):
    """Azure resource. This resource is tracked in Azure Resource Manager.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.kind = kind
        self.location = location
        self.type = None
        self.tags = tags


class AppServiceCertificateOrder(Resource):
    """SSL certificate purchase order.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param certificates: State of the Key Vault secret.
    :type certificates: dict[str, ~azure.mgmt.web.v2019_08_01.models.AppServiceCertificate]
    :param distinguished_name: Certificate distinguished name.
    :type distinguished_name: str
    :ivar domain_verification_token: Domain verification token.
    :vartype domain_verification_token: str
    :param validity_in_years: Duration in years (must be between 1 and 3).
    :type validity_in_years: int
    :param key_size: Certificate key size.
    :type key_size: int
    :param product_type: Certificate product type. Possible values include:
     "StandardDomainValidatedSsl", "StandardDomainValidatedWildCardSsl".
    :type product_type: str or ~azure.mgmt.web.v2019_08_01.models.CertificateProductType
    :param auto_renew: :code:`<code>true</code>` if the certificate should be automatically renewed
     when it expires; otherwise, :code:`<code>false</code>`.
    :type auto_renew: bool
    :ivar provisioning_state: Status of certificate order. Possible values include: "Succeeded",
     "Failed", "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2019_08_01.models.ProvisioningState
    :ivar status: Current order status. Possible values include: "Pendingissuance", "Issued",
     "Revoked", "Canceled", "Denied", "Pendingrevocation", "PendingRekey", "Unused", "Expired",
     "NotSubmitted".
    :vartype status: str or ~azure.mgmt.web.v2019_08_01.models.CertificateOrderStatus
    :ivar signed_certificate: Signed certificate.
    :vartype signed_certificate: ~azure.mgmt.web.v2019_08_01.models.CertificateDetails
    :param csr: Last CSR that was created for this order.
    :type csr: str
    :ivar intermediate: Intermediate certificate.
    :vartype intermediate: ~azure.mgmt.web.v2019_08_01.models.CertificateDetails
    :ivar root: Root certificate.
    :vartype root: ~azure.mgmt.web.v2019_08_01.models.CertificateDetails
    :ivar serial_number: Current serial number of the certificate.
    :vartype serial_number: str
    :ivar last_certificate_issuance_time: Certificate last issuance time.
    :vartype last_certificate_issuance_time: ~datetime.datetime
    :ivar expiration_time: Certificate expiration time.
    :vartype expiration_time: ~datetime.datetime
    :ivar is_private_key_external: :code:`<code>true</code>` if private key is external; otherwise,
     :code:`<code>false</code>`.
    :vartype is_private_key_external: bool
    :ivar app_service_certificate_not_renewable_reasons: Reasons why App Service Certificate is not
     renewable at the current moment.
    :vartype app_service_certificate_not_renewable_reasons: list[str or
     ~azure.mgmt.web.v2019_08_01.models.AppServiceCertificateOrderPropertiesAppServiceCertificateNotRenewableReasonsItem]
    :ivar next_auto_renewal_time_stamp: Time stamp when the certificate would be auto renewed next.
    :vartype next_auto_renewal_time_stamp: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'domain_verification_token': {'readonly': True},
        'validity_in_years': {'maximum': 3, 'minimum': 1},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
        'signed_certificate': {'readonly': True},
        'intermediate': {'readonly': True},
        'root': {'readonly': True},
        'serial_number': {'readonly': True},
        'last_certificate_issuance_time': {'readonly': True},
        'expiration_time': {'readonly': True},
        'is_private_key_external': {'readonly': True},
        'app_service_certificate_not_renewable_reasons': {'readonly': True},
        'next_auto_renewal_time_stamp': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'certificates': {'key': 'properties.certificates', 'type': '{AppServiceCertificate}'},
        'distinguished_name': {'key': 'properties.distinguishedName', 'type': 'str'},
        'domain_verification_token': {'key': 'properties.domainVerificationToken', 'type': 'str'},
        'validity_in_years': {'key': 'properties.validityInYears', 'type': 'int'},
        'key_size': {'key': 'properties.keySize', 'type': 'int'},
        'product_type': {'key': 'properties.productType', 'type': 'str'},
        'auto_renew': {'key': 'properties.autoRenew', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'signed_certificate': {'key': 'properties.signedCertificate', 'type': 'CertificateDetails'},
        'csr': {'key': 'properties.csr', 'type': 'str'},
        'intermediate': {'key': 'properties.intermediate', 'type': 'CertificateDetails'},
        'root': {'key': 'properties.root', 'type': 'CertificateDetails'},
        'serial_number': {'key': 'properties.serialNumber', 'type': 'str'},
        'last_certificate_issuance_time': {'key': 'properties.lastCertificateIssuanceTime', 'type': 'iso-8601'},
        'expiration_time': {'key': 'properties.expirationTime', 'type': 'iso-8601'},
        'is_private_key_external': {'key': 'properties.isPrivateKeyExternal', 'type': 'bool'},
        'app_service_certificate_not_renewable_reasons': {'key': 'properties.appServiceCertificateNotRenewableReasons', 'type': '[str]'},
        'next_auto_renewal_time_stamp': {'key': 'properties.nextAutoRenewalTimeStamp', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        certificates: Optional[Dict[str, "AppServiceCertificate"]] = None,
        distinguished_name: Optional[str] = None,
        validity_in_years: Optional[int] = 1,
        key_size: Optional[int] = 2048,
        product_type: Optional[Union[str, "CertificateProductType"]] = None,
        auto_renew: Optional[bool] = True,
        csr: Optional[str] = None,
        **kwargs
    ):
        super(AppServiceCertificateOrder, self).__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.certificates = certificates
        self.distinguished_name = distinguished_name
        self.domain_verification_token = None
        self.validity_in_years = validity_in_years
        self.key_size = key_size
        self.product_type = product_type
        self.auto_renew = auto_renew
        self.provisioning_state = None
        self.status = None
        self.signed_certificate = None
        self.csr = csr
        self.intermediate = None
        self.root = None
        self.serial_number = None
        self.last_certificate_issuance_time = None
        self.expiration_time = None
        self.is_private_key_external = None
        self.app_service_certificate_not_renewable_reasons = None
        self.next_auto_renewal_time_stamp = None


class AppServiceCertificateOrderCollection(msrest.serialization.Model):
    """Collection of certificate orders.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.AppServiceCertificateOrder]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AppServiceCertificateOrder]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["AppServiceCertificateOrder"],
        **kwargs
    ):
        super(AppServiceCertificateOrderCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class AppServiceCertificateOrderPatchResource(ProxyOnlyResource):
    """ARM resource for a certificate order that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param certificates: State of the Key Vault secret.
    :type certificates: dict[str, ~azure.mgmt.web.v2019_08_01.models.AppServiceCertificate]
    :param distinguished_name: Certificate distinguished name.
    :type distinguished_name: str
    :ivar domain_verification_token: Domain verification token.
    :vartype domain_verification_token: str
    :param validity_in_years: Duration in years (must be between 1 and 3).
    :type validity_in_years: int
    :param key_size: Certificate key size.
    :type key_size: int
    :param product_type: Certificate product type. Possible values include:
     "StandardDomainValidatedSsl", "StandardDomainValidatedWildCardSsl".
    :type product_type: str or ~azure.mgmt.web.v2019_08_01.models.CertificateProductType
    :param auto_renew: :code:`<code>true</code>` if the certificate should be automatically renewed
     when it expires; otherwise, :code:`<code>false</code>`.
    :type auto_renew: bool
    :ivar provisioning_state: Status of certificate order. Possible values include: "Succeeded",
     "Failed", "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2019_08_01.models.ProvisioningState
    :ivar status: Current order status. Possible values include: "Pendingissuance", "Issued",
     "Revoked", "Canceled", "Denied", "Pendingrevocation", "PendingRekey", "Unused", "Expired",
     "NotSubmitted".
    :vartype status: str or ~azure.mgmt.web.v2019_08_01.models.CertificateOrderStatus
    :ivar signed_certificate: Signed certificate.
    :vartype signed_certificate: ~azure.mgmt.web.v2019_08_01.models.CertificateDetails
    :param csr: Last CSR that was created for this order.
    :type csr: str
    :ivar intermediate: Intermediate certificate.
    :vartype intermediate: ~azure.mgmt.web.v2019_08_01.models.CertificateDetails
    :ivar root: Root certificate.
    :vartype root: ~azure.mgmt.web.v2019_08_01.models.CertificateDetails
    :ivar serial_number: Current serial number of the certificate.
    :vartype serial_number: str
    :ivar last_certificate_issuance_time: Certificate last issuance time.
    :vartype last_certificate_issuance_time: ~datetime.datetime
    :ivar expiration_time: Certificate expiration time.
    :vartype expiration_time: ~datetime.datetime
    :ivar is_private_key_external: :code:`<code>true</code>` if private key is external; otherwise,
     :code:`<code>false</code>`.
    :vartype is_private_key_external: bool
    :ivar app_service_certificate_not_renewable_reasons: Reasons why App Service Certificate is not
     renewable at the current moment.
    :vartype app_service_certificate_not_renewable_reasons: list[str or
     ~azure.mgmt.web.v2019_08_01.models.AppServiceCertificateOrderPatchResourcePropertiesAppServiceCertificateNotRenewableReasonsItem]
    :ivar next_auto_renewal_time_stamp: Time stamp when the certificate would be auto renewed next.
    :vartype next_auto_renewal_time_stamp: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'domain_verification_token': {'readonly': True},
        'validity_in_years': {'maximum': 3, 'minimum': 1},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
        'signed_certificate': {'readonly': True},
        'intermediate': {'readonly': True},
        'root': {'readonly': True},
        'serial_number': {'readonly': True},
        'last_certificate_issuance_time': {'readonly': True},
        'expiration_time': {'readonly': True},
        'is_private_key_external': {'readonly': True},
        'app_service_certificate_not_renewable_reasons': {'readonly': True},
        'next_auto_renewal_time_stamp': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'certificates': {'key': 'properties.certificates', 'type': '{AppServiceCertificate}'},
        'distinguished_name': {'key': 'properties.distinguishedName', 'type': 'str'},
        'domain_verification_token': {'key': 'properties.domainVerificationToken', 'type': 'str'},
        'validity_in_years': {'key': 'properties.validityInYears', 'type': 'int'},
        'key_size': {'key': 'properties.keySize', 'type': 'int'},
        'product_type': {'key': 'properties.productType', 'type': 'str'},
        'auto_renew': {'key': 'properties.autoRenew', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'signed_certificate': {'key': 'properties.signedCertificate', 'type': 'CertificateDetails'},
        'csr': {'key': 'properties.csr', 'type': 'str'},
        'intermediate': {'key': 'properties.intermediate', 'type': 'CertificateDetails'},
        'root': {'key': 'properties.root', 'type': 'CertificateDetails'},
        'serial_number': {'key': 'properties.serialNumber', 'type': 'str'},
        'last_certificate_issuance_time': {'key': 'properties.lastCertificateIssuanceTime', 'type': 'iso-8601'},
        'expiration_time': {'key': 'properties.expirationTime', 'type': 'iso-8601'},
        'is_private_key_external': {'key': 'properties.isPrivateKeyExternal', 'type': 'bool'},
        'app_service_certificate_not_renewable_reasons': {'key': 'properties.appServiceCertificateNotRenewableReasons', 'type': '[str]'},
        'next_auto_renewal_time_stamp': {'key': 'properties.nextAutoRenewalTimeStamp', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        certificates: Optional[Dict[str, "AppServiceCertificate"]] = None,
        distinguished_name: Optional[str] = None,
        validity_in_years: Optional[int] = 1,
        key_size: Optional[int] = 2048,
        product_type: Optional[Union[str, "CertificateProductType"]] = None,
        auto_renew: Optional[bool] = True,
        csr: Optional[str] = None,
        **kwargs
    ):
        super(AppServiceCertificateOrderPatchResource, self).__init__(kind=kind, **kwargs)
        self.certificates = certificates
        self.distinguished_name = distinguished_name
        self.domain_verification_token = None
        self.validity_in_years = validity_in_years
        self.key_size = key_size
        self.product_type = product_type
        self.auto_renew = auto_renew
        self.provisioning_state = None
        self.status = None
        self.signed_certificate = None
        self.csr = csr
        self.intermediate = None
        self.root = None
        self.serial_number = None
        self.last_certificate_issuance_time = None
        self.expiration_time = None
        self.is_private_key_external = None
        self.app_service_certificate_not_renewable_reasons = None
        self.next_auto_renewal_time_stamp = None


class AppServiceCertificatePatchResource(ProxyOnlyResource):
    """Key Vault container ARM resource for a certificate that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param key_vault_id: Key Vault resource Id.
    :type key_vault_id: str
    :param key_vault_secret_name: Key Vault secret name.
    :type key_vault_secret_name: str
    :ivar provisioning_state: Status of the Key Vault secret. Possible values include:
     "Initialized", "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey",
     "Unknown".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2019_08_01.models.KeyVaultSecretStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'key_vault_id': {'key': 'properties.keyVaultId', 'type': 'str'},
        'key_vault_secret_name': {'key': 'properties.keyVaultSecretName', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        key_vault_id: Optional[str] = None,
        key_vault_secret_name: Optional[str] = None,
        **kwargs
    ):
        super(AppServiceCertificatePatchResource, self).__init__(kind=kind, **kwargs)
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.provisioning_state = None


class AppServiceCertificateResource(Resource):
    """Key Vault container ARM resource for a certificate that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param key_vault_id: Key Vault resource Id.
    :type key_vault_id: str
    :param key_vault_secret_name: Key Vault secret name.
    :type key_vault_secret_name: str
    :ivar provisioning_state: Status of the Key Vault secret. Possible values include:
     "Initialized", "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey",
     "Unknown".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2019_08_01.models.KeyVaultSecretStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'key_vault_id': {'key': 'properties.keyVaultId', 'type': 'str'},
        'key_vault_secret_name': {'key': 'properties.keyVaultSecretName', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        key_vault_id: Optional[str] = None,
        key_vault_secret_name: Optional[str] = None,
        **kwargs
    ):
        super(AppServiceCertificateResource, self).__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.provisioning_state = None


class AppServiceEnvironment(msrest.serialization.Model):
    """Description of an App Service Environment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of the App Service Environment.
    :type name: str
    :param location: Required. Location of the App Service Environment, e.g. "West US".
    :type location: str
    :ivar provisioning_state: Provisioning state of the App Service Environment. Possible values
     include: "Succeeded", "Failed", "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2019_08_01.models.ProvisioningState
    :ivar status: Current status of the App Service Environment. Possible values include:
     "Preparing", "Ready", "Scaling", "Deleting".
    :vartype status: str or ~azure.mgmt.web.v2019_08_01.models.HostingEnvironmentStatus
    :param vnet_name: Name of the Virtual Network for the App Service Environment.
    :type vnet_name: str
    :param vnet_resource_group_name: Resource group of the Virtual Network.
    :type vnet_resource_group_name: str
    :param vnet_subnet_name: Subnet of the Virtual Network.
    :type vnet_subnet_name: str
    :param virtual_network: Required. Description of the Virtual Network.
    :type virtual_network: ~azure.mgmt.web.v2019_08_01.models.VirtualNetworkProfile
    :param internal_load_balancing_mode: Specifies which endpoints to serve internally in the
     Virtual Network for the App Service Environment. Possible values include: "None", "Web",
     "Publishing".
    :type internal_load_balancing_mode: str or
     ~azure.mgmt.web.v2019_08_01.models.InternalLoadBalancingMode
    :param multi_size: Front-end VM size, e.g. "Medium", "Large".
    :type multi_size: str
    :param multi_role_count: Number of front-end instances.
    :type multi_role_count: int
    :param worker_pools: Required. Description of worker pools with worker size IDs, VM sizes, and
     number of workers in each pool.
    :type worker_pools: list[~azure.mgmt.web.v2019_08_01.models.WorkerPool]
    :param ipssl_address_count: Number of IP SSL addresses reserved for the App Service
     Environment.
    :type ipssl_address_count: int
    :ivar database_edition: Edition of the metadata database for the App Service Environment, e.g.
     "Standard".
    :vartype database_edition: str
    :ivar database_service_objective: Service objective of the metadata database for the App
     Service Environment, e.g. "S0".
    :vartype database_service_objective: str
    :ivar upgrade_domains: Number of upgrade domains of the App Service Environment.
    :vartype upgrade_domains: int
    :ivar subscription_id: Subscription of the App Service Environment.
    :vartype subscription_id: str
    :param dns_suffix: DNS suffix of the App Service Environment.
    :type dns_suffix: str
    :ivar last_action: Last deployment action on the App Service Environment.
    :vartype last_action: str
    :ivar last_action_result: Result of the last deployment action on the App Service Environment.
    :vartype last_action_result: str
    :ivar allowed_multi_sizes: List of comma separated strings describing which VM sizes are
     allowed for front-ends.
    :vartype allowed_multi_sizes: str
    :ivar allowed_worker_sizes: List of comma separated strings describing which VM sizes are
     allowed for workers.
    :vartype allowed_worker_sizes: str
    :ivar maximum_number_of_machines: Maximum number of VMs in the App Service Environment.
    :vartype maximum_number_of_machines: int
    :ivar vip_mappings: Description of IP SSL mapping for the App Service Environment.
    :vartype vip_mappings: list[~azure.mgmt.web.v2019_08_01.models.VirtualIPMapping]
    :ivar environment_capacities: Current total, used, and available worker capacities.
    :vartype environment_capacities: list[~azure.mgmt.web.v2019_08_01.models.StampCapacity]
    :param network_access_control_list: Access control list for controlling traffic to the App
     Service Environment.
    :type network_access_control_list:
     list[~azure.mgmt.web.v2019_08_01.models.NetworkAccessControlEntry]
    :ivar environment_is_healthy: True/false indicating whether the App Service Environment is
     healthy.
    :vartype environment_is_healthy: bool
    :ivar environment_status: Detailed message about with results of the last check of the App
     Service Environment.
    :vartype environment_status: str
    :ivar resource_group: Resource group of the App Service Environment.
    :vartype resource_group: str
    :param front_end_scale_factor: Scale factor for front-ends.
    :type front_end_scale_factor: int
    :ivar default_front_end_scale_factor: Default Scale Factor for FrontEnds.
    :vartype default_front_end_scale_factor: int
    :param api_management_account_id: API Management Account associated with the App Service
     Environment.
    :type api_management_account_id: str
    :param suspended: :code:`<code>true</code>` if the App Service Environment is suspended;
     otherwise, :code:`<code>false</code>`. The environment can be suspended, e.g. when the
     management endpoint is no longer available
      (most likely because NSG blocked the incoming traffic).
    :type suspended: bool
    :param dynamic_cache_enabled: True/false indicating whether the App Service Environment is
     suspended. The environment can be suspended e.g. when the management endpoint is no longer
     available
     (most likely because NSG blocked the incoming traffic).
    :type dynamic_cache_enabled: bool
    :param cluster_settings: Custom settings for changing the behavior of the App Service
     Environment.
    :type cluster_settings: list[~azure.mgmt.web.v2019_08_01.models.NameValuePair]
    :param user_whitelisted_ip_ranges: User added ip ranges to whitelist on ASE db.
    :type user_whitelisted_ip_ranges: list[str]
    :param has_linux_workers: Flag that displays whether an ASE has linux workers or not.
    :type has_linux_workers: bool
    :param ssl_cert_key_vault_id: Key Vault ID for ILB App Service Environment default SSL
     certificate.
    :type ssl_cert_key_vault_id: str
    :param ssl_cert_key_vault_secret_name: Key Vault Secret Name for ILB App Service Environment
     default SSL certificate.
    :type ssl_cert_key_vault_secret_name: str
    """

    _validation = {
        'name': {'required': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
        'virtual_network': {'required': True},
        'worker_pools': {'required': True},
        'database_edition': {'readonly': True},
        'database_service_objective': {'readonly': True},
        'upgrade_domains': {'readonly': True},
        'subscription_id': {'readonly': True},
        'last_action': {'readonly': True},
        'last_action_result': {'readonly': True},
        'allowed_multi_sizes': {'readonly': True},
        'allowed_worker_sizes': {'readonly': True},
        'maximum_number_of_machines': {'readonly': True},
        'vip_mappings': {'readonly': True},
        'environment_capacities': {'readonly': True},
        'environment_is_healthy': {'readonly': True},
        'environment_status': {'readonly': True},
        'resource_group': {'readonly': True},
        'default_front_end_scale_factor': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'vnet_name': {'key': 'vnetName', 'type': 'str'},
        'vnet_resource_group_name': {'key': 'vnetResourceGroupName', 'type': 'str'},
        'vnet_subnet_name': {'key': 'vnetSubnetName', 'type': 'str'},
        'virtual_network': {'key': 'virtualNetwork', 'type': 'VirtualNetworkProfile'},
        'internal_load_balancing_mode': {'key': 'internalLoadBalancingMode', 'type': 'str'},
        'multi_size': {'key': 'multiSize', 'type': 'str'},
        'multi_role_count': {'key': 'multiRoleCount', 'type': 'int'},
        'worker_pools': {'key': 'workerPools', 'type': '[WorkerPool]'},
        'ipssl_address_count': {'key': 'ipsslAddressCount', 'type': 'int'},
        'database_edition': {'key': 'databaseEdition', 'type': 'str'},
        'database_service_objective': {'key': 'databaseServiceObjective', 'type': 'str'},
        'upgrade_domains': {'key': 'upgradeDomains', 'type': 'int'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'dns_suffix': {'key': 'dnsSuffix', 'type': 'str'},
        'last_action': {'key': 'lastAction', 'type': 'str'},
        'last_action_result': {'key': 'lastActionResult', 'type': 'str'},
        'allowed_multi_sizes': {'key': 'allowedMultiSizes', 'type': 'str'},
        'allowed_worker_sizes': {'key': 'allowedWorkerSizes', 'type': 'str'},
        'maximum_number_of_machines': {'key': 'maximumNumberOfMachines', 'type': 'int'},
        'vip_mappings': {'key': 'vipMappings', 'type': '[VirtualIPMapping]'},
        'environment_capacities': {'key': 'environmentCapacities', 'type': '[StampCapacity]'},
        'network_access_control_list': {'key': 'networkAccessControlList', 'type': '[NetworkAccessControlEntry]'},
        'environment_is_healthy': {'key': 'environmentIsHealthy', 'type': 'bool'},
        'environment_status': {'key': 'environmentStatus', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'front_end_scale_factor': {'key': 'frontEndScaleFactor', 'type': 'int'},
        'default_front_end_scale_factor': {'key': 'defaultFrontEndScaleFactor', 'type': 'int'},
        'api_management_account_id': {'key': 'apiManagementAccountId', 'type': 'str'},
        'suspended': {'key': 'suspended', 'type': 'bool'},
        'dynamic_cache_enabled': {'key': 'dynamicCacheEnabled', 'type': 'bool'},
        'cluster_settings': {'key': 'clusterSettings', 'type': '[NameValuePair]'},
        'user_whitelisted_ip_ranges': {'key': 'userWhitelistedIpRanges', 'type': '[str]'},
        'has_linux_workers': {'key': 'hasLinuxWorkers', 'type': 'bool'},
        'ssl_cert_key_vault_id': {'key': 'sslCertKeyVaultId', 'type': 'str'},
        'ssl_cert_key_vault_secret_name': {'key': 'sslCertKeyVaultSecretName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        location: str,
        virtual_network: "VirtualNetworkProfile",
        worker_pools: List["WorkerPool"],
        vnet_name: Optional[str] = None,
        vnet_resource_group_name: Optional[str] = None,
        vnet_subnet_name: Optional[str] = None,
        internal_load_balancing_mode: Optional[Union[str, "InternalLoadBalancingMode"]] = None,
        multi_size: Optional[str] = None,
        multi_role_count: Optional[int] = None,
        ipssl_address_count: Optional[int] = None,
        dns_suffix: Optional[str] = None,
        network_access_control_list: Optional[List["NetworkAccessControlEntry"]] = None,
        front_end_scale_factor: Optional[int] = None,
        api_management_account_id: Optional[str] = None,
        suspended: Optional[bool] = None,
        dynamic_cache_enabled: Optional[bool] = None,
        cluster_settings: Optional[List["NameValuePair"]] = None,
        user_whitelisted_ip_ranges: Optional[List[str]] = None,
        has_linux_workers: Optional[bool] = None,
        ssl_cert_key_vault_id: Optional[str] = None,
        ssl_cert_key_vault_secret_name: Optional[str] = None,
        **kwargs
    ):
        super(AppServiceEnvironment, self).__init__(**kwargs)
        self.name = name
        self.location = location
        self.provisioning_state = None
        self.status = None
        self.vnet_name = vnet_name
        self.vnet_resource_group_name = vnet_resource_group_name
        self.vnet_subnet_name = vnet_subnet_name
        self.virtual_network = virtual_network
        self.internal_load_balancing_mode = internal_load_balancing_mode
        self.multi_size = multi_size
        self.multi_role_count = multi_role_count
        self.worker_pools = worker_pools
        self.ipssl_address_count = ipssl_address_count
        self.database_edition = None
        self.database_service_objective = None
        self.upgrade_domains = None
        self.subscription_id = None
        self.dns_suffix = dns_suffix
        self.last_action = None
        self.last_action_result = None
        self.allowed_multi_sizes = None
        self.allowed_worker_sizes = None
        self.maximum_number_of_machines = None
        self.vip_mappings = None
        self.environment_capacities = None
        self.network_access_control_list = network_access_control_list
        self.environment_is_healthy = None
        self.environment_status = None
        self.resource_group = None
        self.front_end_scale_factor = front_end_scale_factor
        self.default_front_end_scale_factor = None
        self.api_management_account_id = api_management_account_id
        self.suspended = suspended
        self.dynamic_cache_enabled = dynamic_cache_enabled
        self.cluster_settings = cluster_settings
        self.user_whitelisted_ip_ranges = user_whitelisted_ip_ranges
        self.has_linux_workers = has_linux_workers
        self.ssl_cert_key_vault_id = ssl_cert_key_vault_id
        self.ssl_cert_key_vault_secret_name = ssl_cert_key_vault_secret_name


class AppServiceEnvironmentCollection(msrest.serialization.Model):
    """Collection of App Service Environments.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.AppServiceEnvironmentResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AppServiceEnvironmentResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["AppServiceEnvironmentResource"],
        **kwargs
    ):
        super(AppServiceEnvironmentCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class AppServiceEnvironmentPatchResource(ProxyOnlyResource):
    """ARM resource for a app service environment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param name_properties_name: Name of the App Service Environment.
    :type name_properties_name: str
    :param location: Location of the App Service Environment, e.g. "West US".
    :type location: str
    :ivar provisioning_state: Provisioning state of the App Service Environment. Possible values
     include: "Succeeded", "Failed", "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2019_08_01.models.ProvisioningState
    :ivar status: Current status of the App Service Environment. Possible values include:
     "Preparing", "Ready", "Scaling", "Deleting".
    :vartype status: str or ~azure.mgmt.web.v2019_08_01.models.HostingEnvironmentStatus
    :param vnet_name: Name of the Virtual Network for the App Service Environment.
    :type vnet_name: str
    :param vnet_resource_group_name: Resource group of the Virtual Network.
    :type vnet_resource_group_name: str
    :param vnet_subnet_name: Subnet of the Virtual Network.
    :type vnet_subnet_name: str
    :param virtual_network: Description of the Virtual Network.
    :type virtual_network: ~azure.mgmt.web.v2019_08_01.models.VirtualNetworkProfile
    :param internal_load_balancing_mode: Specifies which endpoints to serve internally in the
     Virtual Network for the App Service Environment. Possible values include: "None", "Web",
     "Publishing".
    :type internal_load_balancing_mode: str or
     ~azure.mgmt.web.v2019_08_01.models.InternalLoadBalancingMode
    :param multi_size: Front-end VM size, e.g. "Medium", "Large".
    :type multi_size: str
    :param multi_role_count: Number of front-end instances.
    :type multi_role_count: int
    :param worker_pools: Description of worker pools with worker size IDs, VM sizes, and number of
     workers in each pool.
    :type worker_pools: list[~azure.mgmt.web.v2019_08_01.models.WorkerPool]
    :param ipssl_address_count: Number of IP SSL addresses reserved for the App Service
     Environment.
    :type ipssl_address_count: int
    :ivar database_edition: Edition of the metadata database for the App Service Environment, e.g.
     "Standard".
    :vartype database_edition: str
    :ivar database_service_objective: Service objective of the metadata database for the App
     Service Environment, e.g. "S0".
    :vartype database_service_objective: str
    :ivar upgrade_domains: Number of upgrade domains of the App Service Environment.
    :vartype upgrade_domains: int
    :ivar subscription_id: Subscription of the App Service Environment.
    :vartype subscription_id: str
    :param dns_suffix: DNS suffix of the App Service Environment.
    :type dns_suffix: str
    :ivar last_action: Last deployment action on the App Service Environment.
    :vartype last_action: str
    :ivar last_action_result: Result of the last deployment action on the App Service Environment.
    :vartype last_action_result: str
    :ivar allowed_multi_sizes: List of comma separated strings describing which VM sizes are
     allowed for front-ends.
    :vartype allowed_multi_sizes: str
    :ivar allowed_worker_sizes: List of comma separated strings describing which VM sizes are
     allowed for workers.
    :vartype allowed_worker_sizes: str
    :ivar maximum_number_of_machines: Maximum number of VMs in the App Service Environment.
    :vartype maximum_number_of_machines: int
    :ivar vip_mappings: Description of IP SSL mapping for the App Service Environment.
    :vartype vip_mappings: list[~azure.mgmt.web.v2019_08_01.models.VirtualIPMapping]
    :ivar environment_capacities: Current total, used, and available worker capacities.
    :vartype environment_capacities: list[~azure.mgmt.web.v2019_08_01.models.StampCapacity]
    :param network_access_control_list: Access control list for controlling traffic to the App
     Service Environment.
    :type network_access_control_list:
     list[~azure.mgmt.web.v2019_08_01.models.NetworkAccessControlEntry]
    :ivar environment_is_healthy: True/false indicating whether the App Service Environment is
     healthy.
    :vartype environment_is_healthy: bool
    :ivar environment_status: Detailed message about with results of the last check of the App
     Service Environment.
    :vartype environment_status: str
    :ivar resource_group: Resource group of the App Service Environment.
    :vartype resource_group: str
    :param front_end_scale_factor: Scale factor for front-ends.
    :type front_end_scale_factor: int
    :ivar default_front_end_scale_factor: Default Scale Factor for FrontEnds.
    :vartype default_front_end_scale_factor: int
    :param api_management_account_id: API Management Account associated with the App Service
     Environment.
    :type api_management_account_id: str
    :param suspended: :code:`<code>true</code>` if the App Service Environment is suspended;
     otherwise, :code:`<code>false</code>`. The environment can be suspended, e.g. when the
     management endpoint is no longer available
      (most likely because NSG blocked the incoming traffic).
    :type suspended: bool
    :param dynamic_cache_enabled: True/false indicating whether the App Service Environment is
     suspended. The environment can be suspended e.g. when the management endpoint is no longer
     available
     (most likely because NSG blocked the incoming traffic).
    :type dynamic_cache_enabled: bool
    :param cluster_settings: Custom settings for changing the behavior of the App Service
     Environment.
    :type cluster_settings: list[~azure.mgmt.web.v2019_08_01.models.NameValuePair]
    :param user_whitelisted_ip_ranges: User added ip ranges to whitelist on ASE db.
    :type user_whitelisted_ip_ranges: list[str]
    :param has_linux_workers: Flag that displays whether an ASE has linux workers or not.
    :type has_linux_workers: bool
    :param ssl_cert_key_vault_id: Key Vault ID for ILB App Service Environment default SSL
     certificate.
    :type ssl_cert_key_vault_id: str
    :param ssl_cert_key_vault_secret_name: Key Vault Secret Name for ILB App Service Environment
     default SSL certificate.
    :type ssl_cert_key_vault_secret_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
        'database_edition': {'readonly': True},
        'database_service_objective': {'readonly': True},
        'upgrade_domains': {'readonly': True},
        'subscription_id': {'readonly': True},
        'last_action': {'readonly': True},
        'last_action_result': {'readonly': True},
        'allowed_multi_sizes': {'readonly': True},
        'allowed_worker_sizes': {'readonly': True},
        'maximum_number_of_machines': {'readonly': True},
        'vip_mappings': {'readonly': True},
        'environment_capacities': {'readonly': True},
        'environment_is_healthy': {'readonly': True},
        'environment_status': {'readonly': True},
        'resource_group': {'readonly': True},
        'default_front_end_scale_factor': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'location': {'key': 'properties.location', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'vnet_name': {'key': 'properties.vnetName', 'type': 'str'},
        'vnet_resource_group_name': {'key': 'properties.vnetResourceGroupName', 'type': 'str'},
        'vnet_subnet_name': {'key': 'properties.vnetSubnetName', 'type': 'str'},
        'virtual_network': {'key': 'properties.virtualNetwork', 'type': 'VirtualNetworkProfile'},
        'internal_load_balancing_mode': {'key': 'properties.internalLoadBalancingMode', 'type': 'str'},
        'multi_size': {'key': 'properties.multiSize', 'type': 'str'},
        'multi_role_count': {'key': 'properties.multiRoleCount', 'type': 'int'},
        'worker_pools': {'key': 'properties.workerPools', 'type': '[WorkerPool]'},
        'ipssl_address_count': {'key': 'properties.ipsslAddressCount', 'type': 'int'},
        'database_edition': {'key': 'properties.databaseEdition', 'type': 'str'},
        'database_service_objective': {'key': 'properties.databaseServiceObjective', 'type': 'str'},
        'upgrade_domains': {'key': 'properties.upgradeDomains', 'type': 'int'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
        'dns_suffix': {'key': 'properties.dnsSuffix', 'type': 'str'},
        'last_action': {'key': 'properties.lastAction', 'type': 'str'},
        'last_action_result': {'key': 'properties.lastActionResult', 'type': 'str'},
        'allowed_multi_sizes': {'key': 'properties.allowedMultiSizes', 'type': 'str'},
        'allowed_worker_sizes': {'key': 'properties.allowedWorkerSizes', 'type': 'str'},
        'maximum_number_of_machines': {'key': 'properties.maximumNumberOfMachines', 'type': 'int'},
        'vip_mappings': {'key': 'properties.vipMappings', 'type': '[VirtualIPMapping]'},
        'environment_capacities': {'key': 'properties.environmentCapacities', 'type': '[StampCapacity]'},
        'network_access_control_list': {'key': 'properties.networkAccessControlList', 'type': '[NetworkAccessControlEntry]'},
        'environment_is_healthy': {'key': 'properties.environmentIsHealthy', 'type': 'bool'},
        'environment_status': {'key': 'properties.environmentStatus', 'type': 'str'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'front_end_scale_factor': {'key': 'properties.frontEndScaleFactor', 'type': 'int'},
        'default_front_end_scale_factor': {'key': 'properties.defaultFrontEndScaleFactor', 'type': 'int'},
        'api_management_account_id': {'key': 'properties.apiManagementAccountId', 'type': 'str'},
        'suspended': {'key': 'properties.suspended', 'type': 'bool'},
        'dynamic_cache_enabled': {'key': 'properties.dynamicCacheEnabled', 'type': 'bool'},
        'cluster_settings': {'key': 'properties.clusterSettings', 'type': '[NameValuePair]'},
        'user_whitelisted_ip_ranges': {'key': 'properties.userWhitelistedIpRanges', 'type': '[str]'},
        'has_linux_workers': {'key': 'properties.hasLinuxWorkers', 'type': 'bool'},
        'ssl_cert_key_vault_id': {'key': 'properties.sslCertKeyVaultId', 'type': 'str'},
        'ssl_cert_key_vault_secret_name': {'key': 'properties.sslCertKeyVaultSecretName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        name_properties_name: Optional[str] = None,
        location: Optional[str] = None,
        vnet_name: Optional[str] = None,
        vnet_resource_group_name: Optional[str] = None,
        vnet_subnet_name: Optional[str] = None,
        virtual_network: Optional["VirtualNetworkProfile"] = None,
        internal_load_balancing_mode: Optional[Union[str, "InternalLoadBalancingMode"]] = None,
        multi_size: Optional[str] = None,
        multi_role_count: Optional[int] = None,
        worker_pools: Optional[List["WorkerPool"]] = None,
        ipssl_address_count: Optional[int] = None,
        dns_suffix: Optional[str] = None,
        network_access_control_list: Optional[List["NetworkAccessControlEntry"]] = None,
        front_end_scale_factor: Optional[int] = None,
        api_management_account_id: Optional[str] = None,
        suspended: Optional[bool] = None,
        dynamic_cache_enabled: Optional[bool] = None,
        cluster_settings: Optional[List["NameValuePair"]] = None,
        user_whitelisted_ip_ranges: Optional[List[str]] = None,
        has_linux_workers: Optional[bool] = None,
        ssl_cert_key_vault_id: Optional[str] = None,
        ssl_cert_key_vault_secret_name: Optional[str] = None,
        **kwargs
    ):
        super(AppServiceEnvironmentPatchResource, self).__init__(kind=kind, **kwargs)
        self.name_properties_name = name_properties_name
        self.location = location
        self.provisioning_state = None
        self.status = None
        self.vnet_name = vnet_name
        self.vnet_resource_group_name = vnet_resource_group_name
        self.vnet_subnet_name = vnet_subnet_name
        self.virtual_network = virtual_network
        self.internal_load_balancing_mode = internal_load_balancing_mode
        self.multi_size = multi_size
        self.multi_role_count = multi_role_count
        self.worker_pools = worker_pools
        self.ipssl_address_count = ipssl_address_count
        self.database_edition = None
        self.database_service_objective = None
        self.upgrade_domains = None
        self.subscription_id = None
        self.dns_suffix = dns_suffix
        self.last_action = None
        self.last_action_result = None
        self.allowed_multi_sizes = None
        self.allowed_worker_sizes = None
        self.maximum_number_of_machines = None
        self.vip_mappings = None
        self.environment_capacities = None
        self.network_access_control_list = network_access_control_list
        self.environment_is_healthy = None
        self.environment_status = None
        self.resource_group = None
        self.front_end_scale_factor = front_end_scale_factor
        self.default_front_end_scale_factor = None
        self.api_management_account_id = api_management_account_id
        self.suspended = suspended
        self.dynamic_cache_enabled = dynamic_cache_enabled
        self.cluster_settings = cluster_settings
        self.user_whitelisted_ip_ranges = user_whitelisted_ip_ranges
        self.has_linux_workers = has_linux_workers
        self.ssl_cert_key_vault_id = ssl_cert_key_vault_id
        self.ssl_cert_key_vault_secret_name = ssl_cert_key_vault_secret_name


class AppServiceEnvironmentResource(Resource):
    """App Service Environment ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param name_properties_name: Name of the App Service Environment.
    :type name_properties_name: str
    :param location_properties_location: Location of the App Service Environment, e.g. "West US".
    :type location_properties_location: str
    :ivar provisioning_state: Provisioning state of the App Service Environment. Possible values
     include: "Succeeded", "Failed", "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2019_08_01.models.ProvisioningState
    :ivar status: Current status of the App Service Environment. Possible values include:
     "Preparing", "Ready", "Scaling", "Deleting".
    :vartype status: str or ~azure.mgmt.web.v2019_08_01.models.HostingEnvironmentStatus
    :param vnet_name: Name of the Virtual Network for the App Service Environment.
    :type vnet_name: str
    :param vnet_resource_group_name: Resource group of the Virtual Network.
    :type vnet_resource_group_name: str
    :param vnet_subnet_name: Subnet of the Virtual Network.
    :type vnet_subnet_name: str
    :param virtual_network: Description of the Virtual Network.
    :type virtual_network: ~azure.mgmt.web.v2019_08_01.models.VirtualNetworkProfile
    :param internal_load_balancing_mode: Specifies which endpoints to serve internally in the
     Virtual Network for the App Service Environment. Possible values include: "None", "Web",
     "Publishing".
    :type internal_load_balancing_mode: str or
     ~azure.mgmt.web.v2019_08_01.models.InternalLoadBalancingMode
    :param multi_size: Front-end VM size, e.g. "Medium", "Large".
    :type multi_size: str
    :param multi_role_count: Number of front-end instances.
    :type multi_role_count: int
    :param worker_pools: Description of worker pools with worker size IDs, VM sizes, and number of
     workers in each pool.
    :type worker_pools: list[~azure.mgmt.web.v2019_08_01.models.WorkerPool]
    :param ipssl_address_count: Number of IP SSL addresses reserved for the App Service
     Environment.
    :type ipssl_address_count: int
    :ivar database_edition: Edition of the metadata database for the App Service Environment, e.g.
     "Standard".
    :vartype database_edition: str
    :ivar database_service_objective: Service objective of the metadata database for the App
     Service Environment, e.g. "S0".
    :vartype database_service_objective: str
    :ivar upgrade_domains: Number of upgrade domains of the App Service Environment.
    :vartype upgrade_domains: int
    :ivar subscription_id: Subscription of the App Service Environment.
    :vartype subscription_id: str
    :param dns_suffix: DNS suffix of the App Service Environment.
    :type dns_suffix: str
    :ivar last_action: Last deployment action on the App Service Environment.
    :vartype last_action: str
    :ivar last_action_result: Result of the last deployment action on the App Service Environment.
    :vartype last_action_result: str
    :ivar allowed_multi_sizes: List of comma separated strings describing which VM sizes are
     allowed for front-ends.
    :vartype allowed_multi_sizes: str
    :ivar allowed_worker_sizes: List of comma separated strings describing which VM sizes are
     allowed for workers.
    :vartype allowed_worker_sizes: str
    :ivar maximum_number_of_machines: Maximum number of VMs in the App Service Environment.
    :vartype maximum_number_of_machines: int
    :ivar vip_mappings: Description of IP SSL mapping for the App Service Environment.
    :vartype vip_mappings: list[~azure.mgmt.web.v2019_08_01.models.VirtualIPMapping]
    :ivar environment_capacities: Current total, used, and available worker capacities.
    :vartype environment_capacities: list[~azure.mgmt.web.v2019_08_01.models.StampCapacity]
    :param network_access_control_list: Access control list for controlling traffic to the App
     Service Environment.
    :type network_access_control_list:
     list[~azure.mgmt.web.v2019_08_01.models.NetworkAccessControlEntry]
    :ivar environment_is_healthy: True/false indicating whether the App Service Environment is
     healthy.
    :vartype environment_is_healthy: bool
    :ivar environment_status: Detailed message about with results of the last check of the App
     Service Environment.
    :vartype environment_status: str
    :ivar resource_group: Resource group of the App Service Environment.
    :vartype resource_group: str
    :param front_end_scale_factor: Scale factor for front-ends.
    :type front_end_scale_factor: int
    :ivar default_front_end_scale_factor: Default Scale Factor for FrontEnds.
    :vartype default_front_end_scale_factor: int
    :param api_management_account_id: API Management Account associated with the App Service
     Environment.
    :type api_management_account_id: str
    :param suspended: :code:`<code>true</code>` if the App Service Environment is suspended;
     otherwise, :code:`<code>false</code>`. The environment can be suspended, e.g. when the
     management endpoint is no longer available
      (most likely because NSG blocked the incoming traffic).
    :type suspended: bool
    :param dynamic_cache_enabled: True/false indicating whether the App Service Environment is
     suspended. The environment can be suspended e.g. when the management endpoint is no longer
     available
     (most likely because NSG blocked the incoming traffic).
    :type dynamic_cache_enabled: bool
    :param cluster_settings: Custom settings for changing the behavior of the App Service
     Environment.
    :type cluster_settings: list[~azure.mgmt.web.v2019_08_01.models.NameValuePair]
    :param user_whitelisted_ip_ranges: User added ip ranges to whitelist on ASE db.
    :type user_whitelisted_ip_ranges: list[str]
    :param has_linux_workers: Flag that displays whether an ASE has linux workers or not.
    :type has_linux_workers: bool
    :param ssl_cert_key_vault_id: Key Vault ID for ILB App Service Environment default SSL
     certificate.
    :type ssl_cert_key_vault_id: str
    :param ssl_cert_key_vault_secret_name: Key Vault Secret Name for ILB App Service Environment
     default SSL certificate.
    :type ssl_cert_key_vault_secret_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
        'database_edition': {'readonly': True},
        'database_service_objective': {'readonly': True},
        'upgrade_domains': {'readonly': True},
        'subscription_id': {'readonly': True},
        'last_action': {'readonly': True},
        'last_action_result': {'readonly': True},
        'allowed_multi_sizes': {'readonly': True},
        'allowed_worker_sizes': {'readonly': True},
        'maximum_number_of_machines': {'readonly': True},
        'vip_mappings': {'readonly': True},
        'environment_capacities': {'readonly': True},
        'environment_is_healthy': {'readonly': True},
        'environment_status': {'readonly': True},
        'resource_group': {'readonly': True},
        'default_front_end_scale_factor': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'location_properties_location': {'key': 'properties.location', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'vnet_name': {'key': 'properties.vnetName', 'type': 'str'},
        'vnet_resource_group_name': {'key': 'properties.vnetResourceGroupName', 'type': 'str'},
        'vnet_subnet_name': {'key': 'properties.vnetSubnetName', 'type': 'str'},
        'virtual_network': {'key': 'properties.virtualNetwork', 'type': 'VirtualNetworkProfile'},
        'internal_load_balancing_mode': {'key': 'properties.internalLoadBalancingMode', 'type': 'str'},
        'multi_size': {'key': 'properties.multiSize', 'type': 'str'},
        'multi_role_count': {'key': 'properties.multiRoleCount', 'type': 'int'},
        'worker_pools': {'key': 'properties.workerPools', 'type': '[WorkerPool]'},
        'ipssl_address_count': {'key': 'properties.ipsslAddressCount', 'type': 'int'},
        'database_edition': {'key': 'properties.databaseEdition', 'type': 'str'},
        'database_service_objective': {'key': 'properties.databaseServiceObjective', 'type': 'str'},
        'upgrade_domains': {'key': 'properties.upgradeDomains', 'type': 'int'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
        'dns_suffix': {'key': 'properties.dnsSuffix', 'type': 'str'},
        'last_action': {'key': 'properties.lastAction', 'type': 'str'},
        'last_action_result': {'key': 'properties.lastActionResult', 'type': 'str'},
        'allowed_multi_sizes': {'key': 'properties.allowedMultiSizes', 'type': 'str'},
        'allowed_worker_sizes': {'key': 'properties.allowedWorkerSizes', 'type': 'str'},
        'maximum_number_of_machines': {'key': 'properties.maximumNumberOfMachines', 'type': 'int'},
        'vip_mappings': {'key': 'properties.vipMappings', 'type': '[VirtualIPMapping]'},
        'environment_capacities': {'key': 'properties.environmentCapacities', 'type': '[StampCapacity]'},
        'network_access_control_list': {'key': 'properties.networkAccessControlList', 'type': '[NetworkAccessControlEntry]'},
        'environment_is_healthy': {'key': 'properties.environmentIsHealthy', 'type': 'bool'},
        'environment_status': {'key': 'properties.environmentStatus', 'type': 'str'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'front_end_scale_factor': {'key': 'properties.frontEndScaleFactor', 'type': 'int'},
        'default_front_end_scale_factor': {'key': 'properties.defaultFrontEndScaleFactor', 'type': 'int'},
        'api_management_account_id': {'key': 'properties.apiManagementAccountId', 'type': 'str'},
        'suspended': {'key': 'properties.suspended', 'type': 'bool'},
        'dynamic_cache_enabled': {'key': 'properties.dynamicCacheEnabled', 'type': 'bool'},
        'cluster_settings': {'key': 'properties.clusterSettings', 'type': '[NameValuePair]'},
        'user_whitelisted_ip_ranges': {'key': 'properties.userWhitelistedIpRanges', 'type': '[str]'},
        'has_linux_workers': {'key': 'properties.hasLinuxWorkers', 'type': 'bool'},
        'ssl_cert_key_vault_id': {'key': 'properties.sslCertKeyVaultId', 'type': 'str'},
        'ssl_cert_key_vault_secret_name': {'key': 'properties.sslCertKeyVaultSecretName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        name_properties_name: Optional[str] = None,
        location_properties_location: Optional[str] = None,
        vnet_name: Optional[str] = None,
        vnet_resource_group_name: Optional[str] = None,
        vnet_subnet_name: Optional[str] = None,
        virtual_network: Optional["VirtualNetworkProfile"] = None,
        internal_load_balancing_mode: Optional[Union[str, "InternalLoadBalancingMode"]] = None,
        multi_size: Optional[str] = None,
        multi_role_count: Optional[int] = None,
        worker_pools: Optional[List["WorkerPool"]] = None,
        ipssl_address_count: Optional[int] = None,
        dns_suffix: Optional[str] = None,
        network_access_control_list: Optional[List["NetworkAccessControlEntry"]] = None,
        front_end_scale_factor: Optional[int] = None,
        api_management_account_id: Optional[str] = None,
        suspended: Optional[bool] = None,
        dynamic_cache_enabled: Optional[bool] = None,
        cluster_settings: Optional[List["NameValuePair"]] = None,
        user_whitelisted_ip_ranges: Optional[List[str]] = None,
        has_linux_workers: Optional[bool] = None,
        ssl_cert_key_vault_id: Optional[str] = None,
        ssl_cert_key_vault_secret_name: Optional[str] = None,
        **kwargs
    ):
        super(AppServiceEnvironmentResource, self).__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.name_properties_name = name_properties_name
        self.location_properties_location = location_properties_location
        self.provisioning_state = None
        self.status = None
        self.vnet_name = vnet_name
        self.vnet_resource_group_name = vnet_resource_group_name
        self.vnet_subnet_name = vnet_subnet_name
        self.virtual_network = virtual_network
        self.internal_load_balancing_mode = internal_load_balancing_mode
        self.multi_size = multi_size
        self.multi_role_count = multi_role_count
        self.worker_pools = worker_pools
        self.ipssl_address_count = ipssl_address_count
        self.database_edition = None
        self.database_service_objective = None
        self.upgrade_domains = None
        self.subscription_id = None
        self.dns_suffix = dns_suffix
        self.last_action = None
        self.last_action_result = None
        self.allowed_multi_sizes = None
        self.allowed_worker_sizes = None
        self.maximum_number_of_machines = None
        self.vip_mappings = None
        self.environment_capacities = None
        self.network_access_control_list = network_access_control_list
        self.environment_is_healthy = None
        self.environment_status = None
        self.resource_group = None
        self.front_end_scale_factor = front_end_scale_factor
        self.default_front_end_scale_factor = None
        self.api_management_account_id = api_management_account_id
        self.suspended = suspended
        self.dynamic_cache_enabled = dynamic_cache_enabled
        self.cluster_settings = cluster_settings
        self.user_whitelisted_ip_ranges = user_whitelisted_ip_ranges
        self.has_linux_workers = has_linux_workers
        self.ssl_cert_key_vault_id = ssl_cert_key_vault_id
        self.ssl_cert_key_vault_secret_name = ssl_cert_key_vault_secret_name


class AppServicePlan(Resource):
    """App Service plan.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: Description of a SKU for a scalable resource.
    :type sku: ~azure.mgmt.web.v2019_08_01.models.SkuDescription
    :param worker_tier_name: Target worker tier assigned to the App Service plan.
    :type worker_tier_name: str
    :ivar status: App Service plan status. Possible values include: "Ready", "Pending", "Creating".
    :vartype status: str or ~azure.mgmt.web.v2019_08_01.models.StatusOptions
    :ivar subscription: App Service plan subscription.
    :vartype subscription: str
    :param hosting_environment_profile: Specification for the App Service Environment to use for
     the App Service plan.
    :type hosting_environment_profile: ~azure.mgmt.web.v2019_08_01.models.HostingEnvironmentProfile
    :ivar maximum_number_of_workers: Maximum number of instances that can be assigned to this App
     Service plan.
    :vartype maximum_number_of_workers: int
    :ivar geo_region: Geographical location for the App Service plan.
    :vartype geo_region: str
    :param per_site_scaling: If :code:`<code>true</code>`, apps assigned to this App Service plan
     can be scaled independently.
     If :code:`<code>false</code>`, apps assigned to this App Service plan will scale to all
     instances of the plan.
    :type per_site_scaling: bool
    :param maximum_elastic_worker_count: Maximum number of total workers allowed for this
     ElasticScaleEnabled App Service Plan.
    :type maximum_elastic_worker_count: int
    :ivar number_of_sites: Number of apps assigned to this App Service plan.
    :vartype number_of_sites: int
    :param is_spot: If :code:`<code>true</code>`, this App Service Plan owns spot instances.
    :type is_spot: bool
    :param spot_expiration_time: The time when the server farm expires. Valid only if it is a spot
     server farm.
    :type spot_expiration_time: ~datetime.datetime
    :param free_offer_expiration_time: The time when the server farm free offer expires.
    :type free_offer_expiration_time: ~datetime.datetime
    :ivar resource_group: Resource group of the App Service plan.
    :vartype resource_group: str
    :param reserved: If Linux app service plan :code:`<code>true</code>`,
     :code:`<code>false</code>` otherwise.
    :type reserved: bool
    :param is_xenon: Obsolete: If Hyper-V container app service plan :code:`<code>true</code>`,
     :code:`<code>false</code>` otherwise.
    :type is_xenon: bool
    :param hyper_v: If Hyper-V container app service plan :code:`<code>true</code>`,
     :code:`<code>false</code>` otherwise.
    :type hyper_v: bool
    :param target_worker_count: Scaling worker count.
    :type target_worker_count: int
    :param target_worker_size_id: Scaling worker size ID.
    :type target_worker_size_id: int
    :ivar provisioning_state: Provisioning state of the App Service Environment. Possible values
     include: "Succeeded", "Failed", "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
        'subscription': {'readonly': True},
        'maximum_number_of_workers': {'readonly': True},
        'geo_region': {'readonly': True},
        'number_of_sites': {'readonly': True},
        'resource_group': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'SkuDescription'},
        'worker_tier_name': {'key': 'properties.workerTierName', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'subscription': {'key': 'properties.subscription', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'maximum_number_of_workers': {'key': 'properties.maximumNumberOfWorkers', 'type': 'int'},
        'geo_region': {'key': 'properties.geoRegion', 'type': 'str'},
        'per_site_scaling': {'key': 'properties.perSiteScaling', 'type': 'bool'},
        'maximum_elastic_worker_count': {'key': 'properties.maximumElasticWorkerCount', 'type': 'int'},
        'number_of_sites': {'key': 'properties.numberOfSites', 'type': 'int'},
        'is_spot': {'key': 'properties.isSpot', 'type': 'bool'},
        'spot_expiration_time': {'key': 'properties.spotExpirationTime', 'type': 'iso-8601'},
        'free_offer_expiration_time': {'key': 'properties.freeOfferExpirationTime', 'type': 'iso-8601'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'reserved': {'key': 'properties.reserved', 'type': 'bool'},
        'is_xenon': {'key': 'properties.isXenon', 'type': 'bool'},
        'hyper_v': {'key': 'properties.hyperV', 'type': 'bool'},
        'target_worker_count': {'key': 'properties.targetWorkerCount', 'type': 'int'},
        'target_worker_size_id': {'key': 'properties.targetWorkerSizeId', 'type': 'int'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["SkuDescription"] = None,
        worker_tier_name: Optional[str] = None,
        hosting_environment_profile: Optional["HostingEnvironmentProfile"] = None,
        per_site_scaling: Optional[bool] = False,
        maximum_elastic_worker_count: Optional[int] = None,
        is_spot: Optional[bool] = None,
        spot_expiration_time: Optional[datetime.datetime] = None,
        free_offer_expiration_time: Optional[datetime.datetime] = None,
        reserved: Optional[bool] = False,
        is_xenon: Optional[bool] = False,
        hyper_v: Optional[bool] = False,
        target_worker_count: Optional[int] = None,
        target_worker_size_id: Optional[int] = None,
        **kwargs
    ):
        super(AppServicePlan, self).__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.worker_tier_name = worker_tier_name
        self.status = None
        self.subscription = None
        self.hosting_environment_profile = hosting_environment_profile
        self.maximum_number_of_workers = None
        self.geo_region = None
        self.per_site_scaling = per_site_scaling
        self.maximum_elastic_worker_count = maximum_elastic_worker_count
        self.number_of_sites = None
        self.is_spot = is_spot
        self.spot_expiration_time = spot_expiration_time
        self.free_offer_expiration_time = free_offer_expiration_time
        self.resource_group = None
        self.reserved = reserved
        self.is_xenon = is_xenon
        self.hyper_v = hyper_v
        self.target_worker_count = target_worker_count
        self.target_worker_size_id = target_worker_size_id
        self.provisioning_state = None


class AppServicePlanCollection(msrest.serialization.Model):
    """Collection of App Service plans.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.AppServicePlan]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AppServicePlan]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["AppServicePlan"],
        **kwargs
    ):
        super(AppServicePlanCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class AppServicePlanPatchResource(ProxyOnlyResource):
    """ARM resource for a app service plan.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param worker_tier_name: Target worker tier assigned to the App Service plan.
    :type worker_tier_name: str
    :ivar status: App Service plan status. Possible values include: "Ready", "Pending", "Creating".
    :vartype status: str or ~azure.mgmt.web.v2019_08_01.models.StatusOptions
    :ivar subscription: App Service plan subscription.
    :vartype subscription: str
    :param hosting_environment_profile: Specification for the App Service Environment to use for
     the App Service plan.
    :type hosting_environment_profile: ~azure.mgmt.web.v2019_08_01.models.HostingEnvironmentProfile
    :ivar maximum_number_of_workers: Maximum number of instances that can be assigned to this App
     Service plan.
    :vartype maximum_number_of_workers: int
    :ivar geo_region: Geographical location for the App Service plan.
    :vartype geo_region: str
    :param per_site_scaling: If :code:`<code>true</code>`, apps assigned to this App Service plan
     can be scaled independently.
     If :code:`<code>false</code>`, apps assigned to this App Service plan will scale to all
     instances of the plan.
    :type per_site_scaling: bool
    :param maximum_elastic_worker_count: Maximum number of total workers allowed for this
     ElasticScaleEnabled App Service Plan.
    :type maximum_elastic_worker_count: int
    :ivar number_of_sites: Number of apps assigned to this App Service plan.
    :vartype number_of_sites: int
    :param is_spot: If :code:`<code>true</code>`, this App Service Plan owns spot instances.
    :type is_spot: bool
    :param spot_expiration_time: The time when the server farm expires. Valid only if it is a spot
     server farm.
    :type spot_expiration_time: ~datetime.datetime
    :param free_offer_expiration_time: The time when the server farm free offer expires.
    :type free_offer_expiration_time: ~datetime.datetime
    :ivar resource_group: Resource group of the App Service plan.
    :vartype resource_group: str
    :param reserved: This needs to set to :code:`<code>true</code>` when creating a Linux App
     Service Plan, along with :code:`<code>kind</code>` set to :code:`<code>Linux</code>`. It should
     be :code:`<code>false</code>` otherwise.
    :type reserved: bool
    :param is_xenon: Obsolete: If Hyper-V container app service plan :code:`<code>true</code>`,
     :code:`<code>false</code>` otherwise.
    :type is_xenon: bool
    :param hyper_v: If Hyper-V container app service plan :code:`<code>true</code>`,
     :code:`<code>false</code>` otherwise.
    :type hyper_v: bool
    :param target_worker_count: Scaling worker count.
    :type target_worker_count: int
    :param target_worker_size_id: Scaling worker size ID.
    :type target_worker_size_id: int
    :ivar provisioning_state: Provisioning state of the App Service Environment. Possible values
     include: "Succeeded", "Failed", "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
        'subscription': {'readonly': True},
        'maximum_number_of_workers': {'readonly': True},
        'geo_region': {'readonly': True},
        'number_of_sites': {'readonly': True},
        'resource_group': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'worker_tier_name': {'key': 'properties.workerTierName', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'subscription': {'key': 'properties.subscription', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'maximum_number_of_workers': {'key': 'properties.maximumNumberOfWorkers', 'type': 'int'},
        'geo_region': {'key': 'properties.geoRegion', 'type': 'str'},
        'per_site_scaling': {'key': 'properties.perSiteScaling', 'type': 'bool'},
        'maximum_elastic_worker_count': {'key': 'properties.maximumElasticWorkerCount', 'type': 'int'},
        'number_of_sites': {'key': 'properties.numberOfSites', 'type': 'int'},
        'is_spot': {'key': 'properties.isSpot', 'type': 'bool'},
        'spot_expiration_time': {'key': 'properties.spotExpirationTime', 'type': 'iso-8601'},
        'free_offer_expiration_time': {'key': 'properties.freeOfferExpirationTime', 'type': 'iso-8601'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'reserved': {'key': 'properties.reserved', 'type': 'bool'},
        'is_xenon': {'key': 'properties.isXenon', 'type': 'bool'},
        'hyper_v': {'key': 'properties.hyperV', 'type': 'bool'},
        'target_worker_count': {'key': 'properties.targetWorkerCount', 'type': 'int'},
        'target_worker_size_id': {'key': 'properties.targetWorkerSizeId', 'type': 'int'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        worker_tier_name: Optional[str] = None,
        hosting_environment_profile: Optional["HostingEnvironmentProfile"] = None,
        per_site_scaling: Optional[bool] = False,
        maximum_elastic_worker_count: Optional[int] = None,
        is_spot: Optional[bool] = None,
        spot_expiration_time: Optional[datetime.datetime] = None,
        free_offer_expiration_time: Optional[datetime.datetime] = None,
        reserved: Optional[bool] = False,
        is_xenon: Optional[bool] = False,
        hyper_v: Optional[bool] = False,
        target_worker_count: Optional[int] = None,
        target_worker_size_id: Optional[int] = None,
        **kwargs
    ):
        super(AppServicePlanPatchResource, self).__init__(kind=kind, **kwargs)
        self.worker_tier_name = worker_tier_name
        self.status = None
        self.subscription = None
        self.hosting_environment_profile = hosting_environment_profile
        self.maximum_number_of_workers = None
        self.geo_region = None
        self.per_site_scaling = per_site_scaling
        self.maximum_elastic_worker_count = maximum_elastic_worker_count
        self.number_of_sites = None
        self.is_spot = is_spot
        self.spot_expiration_time = spot_expiration_time
        self.free_offer_expiration_time = free_offer_expiration_time
        self.resource_group = None
        self.reserved = reserved
        self.is_xenon = is_xenon
        self.hyper_v = hyper_v
        self.target_worker_count = target_worker_count
        self.target_worker_size_id = target_worker_size_id
        self.provisioning_state = None


class ArmIdWrapper(msrest.serialization.Model):
    """A wrapper for an ARM resource id.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id:
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ArmIdWrapper, self).__init__(**kwargs)
        self.id = None


class AutoHealActions(msrest.serialization.Model):
    """Actions which to take by the auto-heal module when a rule is triggered.

    :param action_type: Predefined action to be taken. Possible values include: "Recycle",
     "LogEvent", "CustomAction".
    :type action_type: str or ~azure.mgmt.web.v2019_08_01.models.AutoHealActionType
    :param custom_action: Custom action to be taken.
    :type custom_action: ~azure.mgmt.web.v2019_08_01.models.AutoHealCustomAction
    :param min_process_execution_time: Minimum time the process must execute
     before taking the action.
    :type min_process_execution_time: str
    """

    _attribute_map = {
        'action_type': {'key': 'actionType', 'type': 'str'},
        'custom_action': {'key': 'customAction', 'type': 'AutoHealCustomAction'},
        'min_process_execution_time': {'key': 'minProcessExecutionTime', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        action_type: Optional[Union[str, "AutoHealActionType"]] = None,
        custom_action: Optional["AutoHealCustomAction"] = None,
        min_process_execution_time: Optional[str] = None,
        **kwargs
    ):
        super(AutoHealActions, self).__init__(**kwargs)
        self.action_type = action_type
        self.custom_action = custom_action
        self.min_process_execution_time = min_process_execution_time


class AutoHealCustomAction(msrest.serialization.Model):
    """Custom action to be executed
when an auto heal rule is triggered.

    :param exe: Executable to be run.
    :type exe: str
    :param parameters: Parameters for the executable.
    :type parameters: str
    """

    _attribute_map = {
        'exe': {'key': 'exe', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        exe: Optional[str] = None,
        parameters: Optional[str] = None,
        **kwargs
    ):
        super(AutoHealCustomAction, self).__init__(**kwargs)
        self.exe = exe
        self.parameters = parameters


class AutoHealRules(msrest.serialization.Model):
    """Rules that can be defined for auto-heal.

    :param triggers: Conditions that describe when to execute the auto-heal actions.
    :type triggers: ~azure.mgmt.web.v2019_08_01.models.AutoHealTriggers
    :param actions: Actions to be executed when a rule is triggered.
    :type actions: ~azure.mgmt.web.v2019_08_01.models.AutoHealActions
    """

    _attribute_map = {
        'triggers': {'key': 'triggers', 'type': 'AutoHealTriggers'},
        'actions': {'key': 'actions', 'type': 'AutoHealActions'},
    }

    def __init__(
        self,
        *,
        triggers: Optional["AutoHealTriggers"] = None,
        actions: Optional["AutoHealActions"] = None,
        **kwargs
    ):
        super(AutoHealRules, self).__init__(**kwargs)
        self.triggers = triggers
        self.actions = actions


class AutoHealTriggers(msrest.serialization.Model):
    """Triggers for auto-heal.

    :param requests: A rule based on total requests.
    :type requests: ~azure.mgmt.web.v2019_08_01.models.RequestsBasedTrigger
    :param private_bytes_in_kb: A rule based on private bytes.
    :type private_bytes_in_kb: int
    :param status_codes: A rule based on status codes.
    :type status_codes: list[~azure.mgmt.web.v2019_08_01.models.StatusCodesBasedTrigger]
    :param slow_requests: A rule based on request execution time.
    :type slow_requests: ~azure.mgmt.web.v2019_08_01.models.SlowRequestsBasedTrigger
    """

    _attribute_map = {
        'requests': {'key': 'requests', 'type': 'RequestsBasedTrigger'},
        'private_bytes_in_kb': {'key': 'privateBytesInKB', 'type': 'int'},
        'status_codes': {'key': 'statusCodes', 'type': '[StatusCodesBasedTrigger]'},
        'slow_requests': {'key': 'slowRequests', 'type': 'SlowRequestsBasedTrigger'},
    }

    def __init__(
        self,
        *,
        requests: Optional["RequestsBasedTrigger"] = None,
        private_bytes_in_kb: Optional[int] = None,
        status_codes: Optional[List["StatusCodesBasedTrigger"]] = None,
        slow_requests: Optional["SlowRequestsBasedTrigger"] = None,
        **kwargs
    ):
        super(AutoHealTriggers, self).__init__(**kwargs)
        self.requests = requests
        self.private_bytes_in_kb = private_bytes_in_kb
        self.status_codes = status_codes
        self.slow_requests = slow_requests


class AzureBlobStorageApplicationLogsConfig(msrest.serialization.Model):
    """Application logs azure blob storage configuration.

    :param level: Log level. Possible values include: "Off", "Verbose", "Information", "Warning",
     "Error".
    :type level: str or ~azure.mgmt.web.v2019_08_01.models.LogLevel
    :param sas_url: SAS url to a azure blob container with read/write/list/delete permissions.
    :type sas_url: str
    :param retention_in_days: Retention in days.
     Remove blobs older than X days.
     0 or lower means no retention.
    :type retention_in_days: int
    """

    _attribute_map = {
        'level': {'key': 'level', 'type': 'str'},
        'sas_url': {'key': 'sasUrl', 'type': 'str'},
        'retention_in_days': {'key': 'retentionInDays', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        level: Optional[Union[str, "LogLevel"]] = None,
        sas_url: Optional[str] = None,
        retention_in_days: Optional[int] = None,
        **kwargs
    ):
        super(AzureBlobStorageApplicationLogsConfig, self).__init__(**kwargs)
        self.level = level
        self.sas_url = sas_url
        self.retention_in_days = retention_in_days


class AzureBlobStorageHttpLogsConfig(msrest.serialization.Model):
    """Http logs to azure blob storage configuration.

    :param sas_url: SAS url to a azure blob container with read/write/list/delete permissions.
    :type sas_url: str
    :param retention_in_days: Retention in days.
     Remove blobs older than X days.
     0 or lower means no retention.
    :type retention_in_days: int
    :param enabled: True if configuration is enabled, false if it is disabled and null if
     configuration is not set.
    :type enabled: bool
    """

    _attribute_map = {
        'sas_url': {'key': 'sasUrl', 'type': 'str'},
        'retention_in_days': {'key': 'retentionInDays', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        sas_url: Optional[str] = None,
        retention_in_days: Optional[int] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        super(AzureBlobStorageHttpLogsConfig, self).__init__(**kwargs)
        self.sas_url = sas_url
        self.retention_in_days = retention_in_days
        self.enabled = enabled


class AzureStorageInfoValue(msrest.serialization.Model):
    """Azure Files or Blob Storage access information value for dictionary storage.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type: Type of storage. Possible values include: "AzureFiles", "AzureBlob".
    :type type: str or ~azure.mgmt.web.v2019_08_01.models.AzureStorageType
    :param account_name: Name of the storage account.
    :type account_name: str
    :param share_name: Name of the file share (container name, for Blob storage).
    :type share_name: str
    :param access_key: Access key for the storage account.
    :type access_key: str
    :param mount_path: Path to mount the storage within the site's runtime environment.
    :type mount_path: str
    :ivar state: State of the storage account. Possible values include: "Ok", "InvalidCredentials",
     "InvalidShare".
    :vartype state: str or ~azure.mgmt.web.v2019_08_01.models.AzureStorageState
    """

    _validation = {
        'state': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'account_name': {'key': 'accountName', 'type': 'str'},
        'share_name': {'key': 'shareName', 'type': 'str'},
        'access_key': {'key': 'accessKey', 'type': 'str'},
        'mount_path': {'key': 'mountPath', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "AzureStorageType"]] = None,
        account_name: Optional[str] = None,
        share_name: Optional[str] = None,
        access_key: Optional[str] = None,
        mount_path: Optional[str] = None,
        **kwargs
    ):
        super(AzureStorageInfoValue, self).__init__(**kwargs)
        self.type = type
        self.account_name = account_name
        self.share_name = share_name
        self.access_key = access_key
        self.mount_path = mount_path
        self.state = None


class AzureStoragePropertyDictionaryResource(ProxyOnlyResource):
    """AzureStorageInfo dictionary resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param properties: Azure storage accounts.
    :type properties: dict[str, ~azure.mgmt.web.v2019_08_01.models.AzureStorageInfoValue]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{AzureStorageInfoValue}'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        properties: Optional[Dict[str, "AzureStorageInfoValue"]] = None,
        **kwargs
    ):
        super(AzureStoragePropertyDictionaryResource, self).__init__(kind=kind, **kwargs)
        self.properties = properties


class AzureTableStorageApplicationLogsConfig(msrest.serialization.Model):
    """Application logs to Azure table storage configuration.

    All required parameters must be populated in order to send to Azure.

    :param level: Log level. Possible values include: "Off", "Verbose", "Information", "Warning",
     "Error".
    :type level: str or ~azure.mgmt.web.v2019_08_01.models.LogLevel
    :param sas_url: Required. SAS URL to an Azure table with add/query/delete permissions.
    :type sas_url: str
    """

    _validation = {
        'sas_url': {'required': True},
    }

    _attribute_map = {
        'level': {'key': 'level', 'type': 'str'},
        'sas_url': {'key': 'sasUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        sas_url: str,
        level: Optional[Union[str, "LogLevel"]] = None,
        **kwargs
    ):
        super(AzureTableStorageApplicationLogsConfig, self).__init__(**kwargs)
        self.level = level
        self.sas_url = sas_url


class BackupItem(ProxyOnlyResource):
    """Backup description.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar backup_id: Id of the backup.
    :vartype backup_id: int
    :ivar storage_account_url: SAS URL for the storage account container which contains this
     backup.
    :vartype storage_account_url: str
    :ivar blob_name: Name of the blob which contains data for this backup.
    :vartype blob_name: str
    :ivar name_properties_name: Name of this backup.
    :vartype name_properties_name: str
    :ivar status: Backup status. Possible values include: "InProgress", "Failed", "Succeeded",
     "TimedOut", "Created", "Skipped", "PartiallySucceeded", "DeleteInProgress", "DeleteFailed",
     "Deleted".
    :vartype status: str or ~azure.mgmt.web.v2019_08_01.models.BackupItemStatus
    :ivar size_in_bytes: Size of the backup in bytes.
    :vartype size_in_bytes: long
    :ivar created: Timestamp of the backup creation.
    :vartype created: ~datetime.datetime
    :ivar log: Details regarding this backup. Might contain an error message.
    :vartype log: str
    :ivar databases: List of databases included in the backup.
    :vartype databases: list[~azure.mgmt.web.v2019_08_01.models.DatabaseBackupSetting]
    :ivar scheduled: True if this backup has been created due to a schedule being triggered.
    :vartype scheduled: bool
    :ivar last_restore_time_stamp: Timestamp of a last restore operation which used this backup.
    :vartype last_restore_time_stamp: ~datetime.datetime
    :ivar finished_time_stamp: Timestamp when this backup finished.
    :vartype finished_time_stamp: ~datetime.datetime
    :ivar correlation_id: Unique correlation identifier. Please use this along with the timestamp
     while communicating with Azure support.
    :vartype correlation_id: str
    :ivar website_size_in_bytes: Size of the original web app which has been backed up.
    :vartype website_size_in_bytes: long
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'backup_id': {'readonly': True},
        'storage_account_url': {'readonly': True},
        'blob_name': {'readonly': True},
        'name_properties_name': {'readonly': True},
        'status': {'readonly': True},
        'size_in_bytes': {'readonly': True},
        'created': {'readonly': True},
        'log': {'readonly': True},
        'databases': {'readonly': True},
        'scheduled': {'readonly': True},
        'last_restore_time_stamp': {'readonly': True},
        'finished_time_stamp': {'readonly': True},
        'correlation_id': {'readonly': True},
        'website_size_in_bytes': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'backup_id': {'key': 'properties.id', 'type': 'int'},
        'storage_account_url': {'key': 'properties.storageAccountUrl', 'type': 'str'},
        'blob_name': {'key': 'properties.blobName', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'size_in_bytes': {'key': 'properties.sizeInBytes', 'type': 'long'},
        'created': {'key': 'properties.created', 'type': 'iso-8601'},
        'log': {'key': 'properties.log', 'type': 'str'},
        'databases': {'key': 'properties.databases', 'type': '[DatabaseBackupSetting]'},
        'scheduled': {'key': 'properties.scheduled', 'type': 'bool'},
        'last_restore_time_stamp': {'key': 'properties.lastRestoreTimeStamp', 'type': 'iso-8601'},
        'finished_time_stamp': {'key': 'properties.finishedTimeStamp', 'type': 'iso-8601'},
        'correlation_id': {'key': 'properties.correlationId', 'type': 'str'},
        'website_size_in_bytes': {'key': 'properties.websiteSizeInBytes', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        super(BackupItem, self).__init__(kind=kind, **kwargs)
        self.backup_id = None
        self.storage_account_url = None
        self.blob_name = None
        self.name_properties_name = None
        self.status = None
        self.size_in_bytes = None
        self.created = None
        self.log = None
        self.databases = None
        self.scheduled = None
        self.last_restore_time_stamp = None
        self.finished_time_stamp = None
        self.correlation_id = None
        self.website_size_in_bytes = None


class BackupItemCollection(msrest.serialization.Model):
    """Collection of backup items.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.BackupItem]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BackupItem]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["BackupItem"],
        **kwargs
    ):
        super(BackupItemCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class BackupRequest(ProxyOnlyResource):
    """Description of a backup which will be performed.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param backup_name: Name of the backup.
    :type backup_name: str
    :param enabled: True if the backup schedule is enabled (must be included in that case), false
     if the backup schedule should be disabled.
    :type enabled: bool
    :param storage_account_url: SAS URL to the container.
    :type storage_account_url: str
    :param backup_schedule: Schedule for the backup if it is executed periodically.
    :type backup_schedule: ~azure.mgmt.web.v2019_08_01.models.BackupSchedule
    :param databases: Databases included in the backup.
    :type databases: list[~azure.mgmt.web.v2019_08_01.models.DatabaseBackupSetting]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'backup_name': {'key': 'properties.backupName', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'storage_account_url': {'key': 'properties.storageAccountUrl', 'type': 'str'},
        'backup_schedule': {'key': 'properties.backupSchedule', 'type': 'BackupSchedule'},
        'databases': {'key': 'properties.databases', 'type': '[DatabaseBackupSetting]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        backup_name: Optional[str] = None,
        enabled: Optional[bool] = None,
        storage_account_url: Optional[str] = None,
        backup_schedule: Optional["BackupSchedule"] = None,
        databases: Optional[List["DatabaseBackupSetting"]] = None,
        **kwargs
    ):
        super(BackupRequest, self).__init__(kind=kind, **kwargs)
        self.backup_name = backup_name
        self.enabled = enabled
        self.storage_account_url = storage_account_url
        self.backup_schedule = backup_schedule
        self.databases = databases


class BackupSchedule(msrest.serialization.Model):
    """Description of a backup schedule. Describes how often should be the backup performed and what should be the retention policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param frequency_interval: Required. How often the backup should be executed (e.g. for weekly
     backup, this should be set to 7 and FrequencyUnit should be set to Day).
    :type frequency_interval: int
    :param frequency_unit: Required. The unit of time for how often the backup should be executed
     (e.g. for weekly backup, this should be set to Day and FrequencyInterval should be set to 7).
     Possible values include: "Day", "Hour". Default value: "Day".
    :type frequency_unit: str or ~azure.mgmt.web.v2019_08_01.models.FrequencyUnit
    :param keep_at_least_one_backup: Required. True if the retention policy should always keep at
     least one backup in the storage account, regardless how old it is; false otherwise.
    :type keep_at_least_one_backup: bool
    :param retention_period_in_days: Required. After how many days backups should be deleted.
    :type retention_period_in_days: int
    :param start_time: When the schedule should start working.
    :type start_time: ~datetime.datetime
    :ivar last_execution_time: Last time when this schedule was triggered.
    :vartype last_execution_time: ~datetime.datetime
    """

    _validation = {
        'frequency_interval': {'required': True},
        'frequency_unit': {'required': True},
        'keep_at_least_one_backup': {'required': True},
        'retention_period_in_days': {'required': True},
        'last_execution_time': {'readonly': True},
    }

    _attribute_map = {
        'frequency_interval': {'key': 'frequencyInterval', 'type': 'int'},
        'frequency_unit': {'key': 'frequencyUnit', 'type': 'str'},
        'keep_at_least_one_backup': {'key': 'keepAtLeastOneBackup', 'type': 'bool'},
        'retention_period_in_days': {'key': 'retentionPeriodInDays', 'type': 'int'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'last_execution_time': {'key': 'lastExecutionTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        frequency_interval: int = 7,
        frequency_unit: Union[str, "FrequencyUnit"] = "Day",
        keep_at_least_one_backup: bool = True,
        retention_period_in_days: int = 30,
        start_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(BackupSchedule, self).__init__(**kwargs)
        self.frequency_interval = frequency_interval
        self.frequency_unit = frequency_unit
        self.keep_at_least_one_backup = keep_at_least_one_backup
        self.retention_period_in_days = retention_period_in_days
        self.start_time = start_time
        self.last_execution_time = None


class BillingMeter(ProxyOnlyResource):
    """App Service billing entity that contains information about meter which the Azure billing system utilizes to charge users for services.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param meter_id: Meter GUID onboarded in Commerce.
    :type meter_id: str
    :param billing_location: Azure Location of billable resource.
    :type billing_location: str
    :param short_name: Short Name from App Service Azure pricing Page.
    :type short_name: str
    :param friendly_name: Friendly name of the meter.
    :type friendly_name: str
    :param resource_type: App Service ResourceType meter used for.
    :type resource_type: str
    :param os_type: App Service OS type meter used for.
    :type os_type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'meter_id': {'key': 'properties.meterId', 'type': 'str'},
        'billing_location': {'key': 'properties.billingLocation', 'type': 'str'},
        'short_name': {'key': 'properties.shortName', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'resource_type': {'key': 'properties.resourceType', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        meter_id: Optional[str] = None,
        billing_location: Optional[str] = None,
        short_name: Optional[str] = None,
        friendly_name: Optional[str] = None,
        resource_type: Optional[str] = None,
        os_type: Optional[str] = None,
        **kwargs
    ):
        super(BillingMeter, self).__init__(kind=kind, **kwargs)
        self.meter_id = meter_id
        self.billing_location = billing_location
        self.short_name = short_name
        self.friendly_name = friendly_name
        self.resource_type = resource_type
        self.os_type = os_type


class BillingMeterCollection(msrest.serialization.Model):
    """Collection of Billing Meters.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.BillingMeter]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BillingMeter]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["BillingMeter"],
        **kwargs
    ):
        super(BillingMeterCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class Capability(msrest.serialization.Model):
    """Describes the capabilities/features allowed for a specific SKU.

    :param name: Name of the SKU capability.
    :type name: str
    :param value: Value of the SKU capability.
    :type value: str
    :param reason: Reason of the SKU capability.
    :type reason: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        reason: Optional[str] = None,
        **kwargs
    ):
        super(Capability, self).__init__(**kwargs)
        self.name = name
        self.value = value
        self.reason = reason


class Certificate(Resource):
    """SSL certificate for an app.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar friendly_name: Friendly name of the certificate.
    :vartype friendly_name: str
    :ivar subject_name: Subject name of the certificate.
    :vartype subject_name: str
    :param host_names: Host names the certificate applies to.
    :type host_names: list[str]
    :param pfx_blob: Pfx blob.
    :type pfx_blob: bytearray
    :ivar site_name: App name.
    :vartype site_name: str
    :ivar self_link: Self link.
    :vartype self_link: str
    :ivar issuer: Certificate issuer.
    :vartype issuer: str
    :ivar issue_date: Certificate issue Date.
    :vartype issue_date: ~datetime.datetime
    :ivar expiration_date: Certificate expiration date.
    :vartype expiration_date: ~datetime.datetime
    :param password: Certificate password.
    :type password: str
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    :ivar valid: Is the certificate valid?.
    :vartype valid: bool
    :ivar cer_blob: Raw bytes of .cer file.
    :vartype cer_blob: bytearray
    :ivar public_key_hash: Public key hash.
    :vartype public_key_hash: str
    :ivar hosting_environment_profile: Specification for the App Service Environment to use for the
     certificate.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.v2019_08_01.models.HostingEnvironmentProfile
    :param key_vault_id: Key Vault Csm resource Id.
    :type key_vault_id: str
    :param key_vault_secret_name: Key Vault secret name.
    :type key_vault_secret_name: str
    :ivar key_vault_secret_status: Status of the Key Vault secret. Possible values include:
     "Initialized", "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey",
     "Unknown".
    :vartype key_vault_secret_status: str or
     ~azure.mgmt.web.v2019_08_01.models.KeyVaultSecretStatus
    :param server_farm_id: Resource ID of the associated App Service plan, formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
    :type server_farm_id: str
    :param canonical_name: CNAME of the certificate to be issued via free certificate.
    :type canonical_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'friendly_name': {'readonly': True},
        'subject_name': {'readonly': True},
        'site_name': {'readonly': True},
        'self_link': {'readonly': True},
        'issuer': {'readonly': True},
        'issue_date': {'readonly': True},
        'expiration_date': {'readonly': True},
        'thumbprint': {'readonly': True},
        'valid': {'readonly': True},
        'cer_blob': {'readonly': True},
        'public_key_hash': {'readonly': True},
        'hosting_environment_profile': {'readonly': True},
        'key_vault_secret_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'subject_name': {'key': 'properties.subjectName', 'type': 'str'},
        'host_names': {'key': 'properties.hostNames', 'type': '[str]'},
        'pfx_blob': {'key': 'properties.pfxBlob', 'type': 'bytearray'},
        'site_name': {'key': 'properties.siteName', 'type': 'str'},
        'self_link': {'key': 'properties.selfLink', 'type': 'str'},
        'issuer': {'key': 'properties.issuer', 'type': 'str'},
        'issue_date': {'key': 'properties.issueDate', 'type': 'iso-8601'},
        'expiration_date': {'key': 'properties.expirationDate', 'type': 'iso-8601'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'valid': {'key': 'properties.valid', 'type': 'bool'},
        'cer_blob': {'key': 'properties.cerBlob', 'type': 'bytearray'},
        'public_key_hash': {'key': 'properties.publicKeyHash', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'key_vault_id': {'key': 'properties.keyVaultId', 'type': 'str'},
        'key_vault_secret_name': {'key': 'properties.keyVaultSecretName', 'type': 'str'},
        'key_vault_secret_status': {'key': 'properties.keyVaultSecretStatus', 'type': 'str'},
        'server_farm_id': {'key': 'properties.serverFarmId', 'type': 'str'},
        'canonical_name': {'key': 'properties.canonicalName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        host_names: Optional[List[str]] = None,
        pfx_blob: Optional[bytearray] = None,
        password: Optional[str] = None,
        key_vault_id: Optional[str] = None,
        key_vault_secret_name: Optional[str] = None,
        server_farm_id: Optional[str] = None,
        canonical_name: Optional[str] = None,
        **kwargs
    ):
        super(Certificate, self).__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.friendly_name = None
        self.subject_name = None
        self.host_names = host_names
        self.pfx_blob = pfx_blob
        self.site_name = None
        self.self_link = None
        self.issuer = None
        self.issue_date = None
        self.expiration_date = None
        self.password = password
        self.thumbprint = None
        self.valid = None
        self.cer_blob = None
        self.public_key_hash = None
        self.hosting_environment_profile = None
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.key_vault_secret_status = None
        self.server_farm_id = server_farm_id
        self.canonical_name = canonical_name


class CertificateCollection(msrest.serialization.Model):
    """Collection of certificates.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.Certificate]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Certificate]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["Certificate"],
        **kwargs
    ):
        super(CertificateCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class CertificateDetails(msrest.serialization.Model):
    """SSL certificate details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar version: Certificate Version.
    :vartype version: int
    :ivar serial_number: Certificate Serial Number.
    :vartype serial_number: str
    :ivar thumbprint: Certificate Thumbprint.
    :vartype thumbprint: str
    :ivar subject: Certificate Subject.
    :vartype subject: str
    :ivar not_before: Date Certificate is valid from.
    :vartype not_before: ~datetime.datetime
    :ivar not_after: Date Certificate is valid to.
    :vartype not_after: ~datetime.datetime
    :ivar signature_algorithm: Certificate Signature algorithm.
    :vartype signature_algorithm: str
    :ivar issuer: Certificate Issuer.
    :vartype issuer: str
    :ivar raw_data: Raw certificate data.
    :vartype raw_data: str
    """

    _validation = {
        'version': {'readonly': True},
        'serial_number': {'readonly': True},
        'thumbprint': {'readonly': True},
        'subject': {'readonly': True},
        'not_before': {'readonly': True},
        'not_after': {'readonly': True},
        'signature_algorithm': {'readonly': True},
        'issuer': {'readonly': True},
        'raw_data': {'readonly': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'int'},
        'serial_number': {'key': 'serialNumber', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'subject': {'key': 'subject', 'type': 'str'},
        'not_before': {'key': 'notBefore', 'type': 'iso-8601'},
        'not_after': {'key': 'notAfter', 'type': 'iso-8601'},
        'signature_algorithm': {'key': 'signatureAlgorithm', 'type': 'str'},
        'issuer': {'key': 'issuer', 'type': 'str'},
        'raw_data': {'key': 'rawData', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificateDetails, self).__init__(**kwargs)
        self.version = None
        self.serial_number = None
        self.thumbprint = None
        self.subject = None
        self.not_before = None
        self.not_after = None
        self.signature_algorithm = None
        self.issuer = None
        self.raw_data = None


class CertificateEmail(ProxyOnlyResource):
    """SSL certificate email.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param email_id: Email id.
    :type email_id: str
    :param time_stamp: Time stamp.
    :type time_stamp: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'email_id': {'key': 'properties.emailId', 'type': 'str'},
        'time_stamp': {'key': 'properties.timeStamp', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        email_id: Optional[str] = None,
        time_stamp: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(CertificateEmail, self).__init__(kind=kind, **kwargs)
        self.email_id = email_id
        self.time_stamp = time_stamp


class CertificateOrderAction(ProxyOnlyResource):
    """Certificate order action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar action_type: Action type. Possible values include: "CertificateIssued",
     "CertificateOrderCanceled", "CertificateOrderCreated", "CertificateRevoked",
     "DomainValidationComplete", "FraudDetected", "OrgNameChange", "OrgValidationComplete",
     "SanDrop", "FraudCleared", "CertificateExpired", "CertificateExpirationWarning",
     "FraudDocumentationRequired", "Unknown".
    :vartype action_type: str or ~azure.mgmt.web.v2019_08_01.models.CertificateOrderActionType
    :ivar created_at: Time at which the certificate action was performed.
    :vartype created_at: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'action_type': {'readonly': True},
        'created_at': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'action_type': {'key': 'properties.actionType', 'type': 'str'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        super(CertificateOrderAction, self).__init__(kind=kind, **kwargs)
        self.action_type = None
        self.created_at = None


class CertificatePatchResource(ProxyOnlyResource):
    """ARM resource for a certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar friendly_name: Friendly name of the certificate.
    :vartype friendly_name: str
    :ivar subject_name: Subject name of the certificate.
    :vartype subject_name: str
    :param host_names: Host names the certificate applies to.
    :type host_names: list[str]
    :param pfx_blob: Pfx blob.
    :type pfx_blob: bytearray
    :ivar site_name: App name.
    :vartype site_name: str
    :ivar self_link: Self link.
    :vartype self_link: str
    :ivar issuer: Certificate issuer.
    :vartype issuer: str
    :ivar issue_date: Certificate issue Date.
    :vartype issue_date: ~datetime.datetime
    :ivar expiration_date: Certificate expiration date.
    :vartype expiration_date: ~datetime.datetime
    :param password: Certificate password.
    :type password: str
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    :ivar valid: Is the certificate valid?.
    :vartype valid: bool
    :ivar cer_blob: Raw bytes of .cer file.
    :vartype cer_blob: bytearray
    :ivar public_key_hash: Public key hash.
    :vartype public_key_hash: str
    :ivar hosting_environment_profile: Specification for the App Service Environment to use for the
     certificate.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.v2019_08_01.models.HostingEnvironmentProfile
    :param key_vault_id: Key Vault Csm resource Id.
    :type key_vault_id: str
    :param key_vault_secret_name: Key Vault secret name.
    :type key_vault_secret_name: str
    :ivar key_vault_secret_status: Status of the Key Vault secret. Possible values include:
     "Initialized", "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey",
     "Unknown".
    :vartype key_vault_secret_status: str or
     ~azure.mgmt.web.v2019_08_01.models.KeyVaultSecretStatus
    :param server_farm_id: Resource ID of the associated App Service plan, formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
    :type server_farm_id: str
    :param canonical_name: CNAME of the certificate to be issued via free certificate.
    :type canonical_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'friendly_name': {'readonly': True},
        'subject_name': {'readonly': True},
        'site_name': {'readonly': True},
        'self_link': {'readonly': True},
        'issuer': {'readonly': True},
        'issue_date': {'readonly': True},
        'expiration_date': {'readonly': True},
        'thumbprint': {'readonly': True},
        'valid': {'readonly': True},
        'cer_blob': {'readonly': True},
        'public_key_hash': {'readonly': True},
        'hosting_environment_profile': {'readonly': True},
        'key_vault_secret_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'subject_name': {'key': 'properties.subjectName', 'type': 'str'},
        'host_names': {'key': 'properties.hostNames', 'type': '[str]'},
        'pfx_blob': {'key': 'properties.pfxBlob', 'type': 'bytearray'},
        'site_name': {'key': 'properties.siteName', 'type': 'str'},
        'self_link': {'key': 'properties.selfLink', 'type': 'str'},
        'issuer': {'key': 'properties.issuer', 'type': 'str'},
        'issue_date': {'key': 'properties.issueDate', 'type': 'iso-8601'},
        'expiration_date': {'key': 'properties.expirationDate', 'type': 'iso-8601'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'valid': {'key': 'properties.valid', 'type': 'bool'},
        'cer_blob': {'key': 'properties.cerBlob', 'type': 'bytearray'},
        'public_key_hash': {'key': 'properties.publicKeyHash', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'key_vault_id': {'key': 'properties.keyVaultId', 'type': 'str'},
        'key_vault_secret_name': {'key': 'properties.keyVaultSecretName', 'type': 'str'},
        'key_vault_secret_status': {'key': 'properties.keyVaultSecretStatus', 'type': 'str'},
        'server_farm_id': {'key': 'properties.serverFarmId', 'type': 'str'},
        'canonical_name': {'key': 'properties.canonicalName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        host_names: Optional[List[str]] = None,
        pfx_blob: Optional[bytearray] = None,
        password: Optional[str] = None,
        key_vault_id: Optional[str] = None,
        key_vault_secret_name: Optional[str] = None,
        server_farm_id: Optional[str] = None,
        canonical_name: Optional[str] = None,
        **kwargs
    ):
        super(CertificatePatchResource, self).__init__(kind=kind, **kwargs)
        self.friendly_name = None
        self.subject_name = None
        self.host_names = host_names
        self.pfx_blob = pfx_blob
        self.site_name = None
        self.self_link = None
        self.issuer = None
        self.issue_date = None
        self.expiration_date = None
        self.password = password
        self.thumbprint = None
        self.valid = None
        self.cer_blob = None
        self.public_key_hash = None
        self.hosting_environment_profile = None
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.key_vault_secret_status = None
        self.server_farm_id = server_farm_id
        self.canonical_name = canonical_name


class CloningInfo(msrest.serialization.Model):
    """Information needed for cloning operation.

    All required parameters must be populated in order to send to Azure.

    :param correlation_id: Correlation ID of cloning operation. This ID ties multiple cloning
     operations
     together to use the same snapshot.
    :type correlation_id: str
    :param overwrite: :code:`<code>true</code>` to overwrite destination app; otherwise,
     :code:`<code>false</code>`.
    :type overwrite: bool
    :param clone_custom_host_names: :code:`<code>true</code>` to clone custom hostnames from source
     app; otherwise, :code:`<code>false</code>`.
    :type clone_custom_host_names: bool
    :param clone_source_control: :code:`<code>true</code>` to clone source control from source app;
     otherwise, :code:`<code>false</code>`.
    :type clone_source_control: bool
    :param source_web_app_id: Required. ARM resource ID of the source app. App resource ID is of
     the form
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
     for production slots and
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
     for other slots.
    :type source_web_app_id: str
    :param source_web_app_location: Location of source app ex: West US or North Europe.
    :type source_web_app_location: str
    :param hosting_environment: App Service Environment.
    :type hosting_environment: str
    :param app_settings_overrides: Application setting overrides for cloned app. If specified,
     these settings override the settings cloned
     from source app. Otherwise, application settings from source app are retained.
    :type app_settings_overrides: dict[str, str]
    :param configure_load_balancing: :code:`<code>true</code>` to configure load balancing for
     source and destination app.
    :type configure_load_balancing: bool
    :param traffic_manager_profile_id: ARM resource ID of the Traffic Manager profile to use, if it
     exists. Traffic Manager resource ID is of the form
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}.
    :type traffic_manager_profile_id: str
    :param traffic_manager_profile_name: Name of Traffic Manager profile to create. This is only
     needed if Traffic Manager profile does not already exist.
    :type traffic_manager_profile_name: str
    """

    _validation = {
        'source_web_app_id': {'required': True},
    }

    _attribute_map = {
        'correlation_id': {'key': 'correlationId', 'type': 'str'},
        'overwrite': {'key': 'overwrite', 'type': 'bool'},
        'clone_custom_host_names': {'key': 'cloneCustomHostNames', 'type': 'bool'},
        'clone_source_control': {'key': 'cloneSourceControl', 'type': 'bool'},
        'source_web_app_id': {'key': 'sourceWebAppId', 'type': 'str'},
        'source_web_app_location': {'key': 'sourceWebAppLocation', 'type': 'str'},
        'hosting_environment': {'key': 'hostingEnvironment', 'type': 'str'},
        'app_settings_overrides': {'key': 'appSettingsOverrides', 'type': '{str}'},
        'configure_load_balancing': {'key': 'configureLoadBalancing', 'type': 'bool'},
        'traffic_manager_profile_id': {'key': 'trafficManagerProfileId', 'type': 'str'},
        'traffic_manager_profile_name': {'key': 'trafficManagerProfileName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_web_app_id: str,
        correlation_id: Optional[str] = None,
        overwrite: Optional[bool] = None,
        clone_custom_host_names: Optional[bool] = None,
        clone_source_control: Optional[bool] = None,
        source_web_app_location: Optional[str] = None,
        hosting_environment: Optional[str] = None,
        app_settings_overrides: Optional[Dict[str, str]] = None,
        configure_load_balancing: Optional[bool] = None,
        traffic_manager_profile_id: Optional[str] = None,
        traffic_manager_profile_name: Optional[str] = None,
        **kwargs
    ):
        super(CloningInfo, self).__init__(**kwargs)
        self.correlation_id = correlation_id
        self.overwrite = overwrite
        self.clone_custom_host_names = clone_custom_host_names
        self.clone_source_control = clone_source_control
        self.source_web_app_id = source_web_app_id
        self.source_web_app_location = source_web_app_location
        self.hosting_environment = hosting_environment
        self.app_settings_overrides = app_settings_overrides
        self.configure_load_balancing = configure_load_balancing
        self.traffic_manager_profile_id = traffic_manager_profile_id
        self.traffic_manager_profile_name = traffic_manager_profile_name


class Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties(msrest.serialization.Model):
    """Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: Principal Id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: Client Id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class ConnectionStringDictionary(ProxyOnlyResource):
    """String dictionary resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param properties: Connection strings.
    :type properties: dict[str, ~azure.mgmt.web.v2019_08_01.models.ConnStringValueTypePair]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{ConnStringValueTypePair}'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        properties: Optional[Dict[str, "ConnStringValueTypePair"]] = None,
        **kwargs
    ):
        super(ConnectionStringDictionary, self).__init__(kind=kind, **kwargs)
        self.properties = properties


class ConnStringInfo(msrest.serialization.Model):
    """Database connection string information.

    :param name: Name of connection string.
    :type name: str
    :param connection_string: Connection string value.
    :type connection_string: str
    :param type: Type of database. Possible values include: "MySql", "SQLServer", "SQLAzure",
     "Custom", "NotificationHub", "ServiceBus", "EventHub", "ApiHub", "DocDb", "RedisCache",
     "PostgreSQL".
    :type type: str or ~azure.mgmt.web.v2019_08_01.models.ConnectionStringType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        connection_string: Optional[str] = None,
        type: Optional[Union[str, "ConnectionStringType"]] = None,
        **kwargs
    ):
        super(ConnStringInfo, self).__init__(**kwargs)
        self.name = name
        self.connection_string = connection_string
        self.type = type


class ConnStringValueTypePair(msrest.serialization.Model):
    """Database connection string value to type pair.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Value of pair.
    :type value: str
    :param type: Required. Type of database. Possible values include: "MySql", "SQLServer",
     "SQLAzure", "Custom", "NotificationHub", "ServiceBus", "EventHub", "ApiHub", "DocDb",
     "RedisCache", "PostgreSQL".
    :type type: str or ~azure.mgmt.web.v2019_08_01.models.ConnectionStringType
    """

    _validation = {
        'value': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: str,
        type: Union[str, "ConnectionStringType"],
        **kwargs
    ):
        super(ConnStringValueTypePair, self).__init__(**kwargs)
        self.value = value
        self.type = type


class Contact(msrest.serialization.Model):
    """Contact information for domain registration. If 'Domain Privacy' option is not selected then the contact information is made publicly available through the Whois 
directories as per ICANN requirements.

    All required parameters must be populated in order to send to Azure.

    :param address_mailing: Mailing address.
    :type address_mailing: ~azure.mgmt.web.v2019_08_01.models.Address
    :param email: Required. Email address.
    :type email: str
    :param fax: Fax number.
    :type fax: str
    :param job_title: Job title.
    :type job_title: str
    :param name_first: Required. First name.
    :type name_first: str
    :param name_last: Required. Last name.
    :type name_last: str
    :param name_middle: Middle name.
    :type name_middle: str
    :param organization: Organization contact belongs to.
    :type organization: str
    :param phone: Required. Phone number.
    :type phone: str
    """

    _validation = {
        'email': {'required': True},
        'name_first': {'required': True},
        'name_last': {'required': True},
        'phone': {'required': True},
    }

    _attribute_map = {
        'address_mailing': {'key': 'addressMailing', 'type': 'Address'},
        'email': {'key': 'email', 'type': 'str'},
        'fax': {'key': 'fax', 'type': 'str'},
        'job_title': {'key': 'jobTitle', 'type': 'str'},
        'name_first': {'key': 'nameFirst', 'type': 'str'},
        'name_last': {'key': 'nameLast', 'type': 'str'},
        'name_middle': {'key': 'nameMiddle', 'type': 'str'},
        'organization': {'key': 'organization', 'type': 'str'},
        'phone': {'key': 'phone', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        email: str,
        name_first: str,
        name_last: str,
        phone: str,
        address_mailing: Optional["Address"] = None,
        fax: Optional[str] = None,
        job_title: Optional[str] = None,
        name_middle: Optional[str] = None,
        organization: Optional[str] = None,
        **kwargs
    ):
        super(Contact, self).__init__(**kwargs)
        self.address_mailing = address_mailing
        self.email = email
        self.fax = fax
        self.job_title = job_title
        self.name_first = name_first
        self.name_last = name_last
        self.name_middle = name_middle
        self.organization = organization
        self.phone = phone


class ContainerCpuStatistics(msrest.serialization.Model):
    """ContainerCpuStatistics.

    :param cpu_usage:
    :type cpu_usage: ~azure.mgmt.web.v2019_08_01.models.ContainerCpuUsage
    :param system_cpu_usage:
    :type system_cpu_usage: long
    :param online_cpu_count:
    :type online_cpu_count: int
    :param throttling_data:
    :type throttling_data: ~azure.mgmt.web.v2019_08_01.models.ContainerThrottlingData
    """

    _attribute_map = {
        'cpu_usage': {'key': 'cpuUsage', 'type': 'ContainerCpuUsage'},
        'system_cpu_usage': {'key': 'systemCpuUsage', 'type': 'long'},
        'online_cpu_count': {'key': 'onlineCpuCount', 'type': 'int'},
        'throttling_data': {'key': 'throttlingData', 'type': 'ContainerThrottlingData'},
    }

    def __init__(
        self,
        *,
        cpu_usage: Optional["ContainerCpuUsage"] = None,
        system_cpu_usage: Optional[int] = None,
        online_cpu_count: Optional[int] = None,
        throttling_data: Optional["ContainerThrottlingData"] = None,
        **kwargs
    ):
        super(ContainerCpuStatistics, self).__init__(**kwargs)
        self.cpu_usage = cpu_usage
        self.system_cpu_usage = system_cpu_usage
        self.online_cpu_count = online_cpu_count
        self.throttling_data = throttling_data


class ContainerCpuUsage(msrest.serialization.Model):
    """ContainerCpuUsage.

    :param total_usage:
    :type total_usage: long
    :param per_cpu_usage:
    :type per_cpu_usage: list[long]
    :param kernel_mode_usage:
    :type kernel_mode_usage: long
    :param user_mode_usage:
    :type user_mode_usage: long
    """

    _attribute_map = {
        'total_usage': {'key': 'totalUsage', 'type': 'long'},
        'per_cpu_usage': {'key': 'perCpuUsage', 'type': '[long]'},
        'kernel_mode_usage': {'key': 'kernelModeUsage', 'type': 'long'},
        'user_mode_usage': {'key': 'userModeUsage', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        total_usage: Optional[int] = None,
        per_cpu_usage: Optional[List[int]] = None,
        kernel_mode_usage: Optional[int] = None,
        user_mode_usage: Optional[int] = None,
        **kwargs
    ):
        super(ContainerCpuUsage, self).__init__(**kwargs)
        self.total_usage = total_usage
        self.per_cpu_usage = per_cpu_usage
        self.kernel_mode_usage = kernel_mode_usage
        self.user_mode_usage = user_mode_usage


class ContainerInfo(msrest.serialization.Model):
    """ContainerInfo.

    :param current_time_stamp:
    :type current_time_stamp: ~datetime.datetime
    :param previous_time_stamp:
    :type previous_time_stamp: ~datetime.datetime
    :param current_cpu_stats:
    :type current_cpu_stats: ~azure.mgmt.web.v2019_08_01.models.ContainerCpuStatistics
    :param previous_cpu_stats:
    :type previous_cpu_stats: ~azure.mgmt.web.v2019_08_01.models.ContainerCpuStatistics
    :param memory_stats:
    :type memory_stats: ~azure.mgmt.web.v2019_08_01.models.ContainerMemoryStatistics
    :param name:
    :type name: str
    :param id:
    :type id: str
    :param eth0:
    :type eth0: ~azure.mgmt.web.v2019_08_01.models.ContainerNetworkInterfaceStatistics
    """

    _attribute_map = {
        'current_time_stamp': {'key': 'currentTimeStamp', 'type': 'iso-8601'},
        'previous_time_stamp': {'key': 'previousTimeStamp', 'type': 'iso-8601'},
        'current_cpu_stats': {'key': 'currentCpuStats', 'type': 'ContainerCpuStatistics'},
        'previous_cpu_stats': {'key': 'previousCpuStats', 'type': 'ContainerCpuStatistics'},
        'memory_stats': {'key': 'memoryStats', 'type': 'ContainerMemoryStatistics'},
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'eth0': {'key': 'eth0', 'type': 'ContainerNetworkInterfaceStatistics'},
    }

    def __init__(
        self,
        *,
        current_time_stamp: Optional[datetime.datetime] = None,
        previous_time_stamp: Optional[datetime.datetime] = None,
        current_cpu_stats: Optional["ContainerCpuStatistics"] = None,
        previous_cpu_stats: Optional["ContainerCpuStatistics"] = None,
        memory_stats: Optional["ContainerMemoryStatistics"] = None,
        name: Optional[str] = None,
        id: Optional[str] = None,
        eth0: Optional["ContainerNetworkInterfaceStatistics"] = None,
        **kwargs
    ):
        super(ContainerInfo, self).__init__(**kwargs)
        self.current_time_stamp = current_time_stamp
        self.previous_time_stamp = previous_time_stamp
        self.current_cpu_stats = current_cpu_stats
        self.previous_cpu_stats = previous_cpu_stats
        self.memory_stats = memory_stats
        self.name = name
        self.id = id
        self.eth0 = eth0


class ContainerMemoryStatistics(msrest.serialization.Model):
    """ContainerMemoryStatistics.

    :param usage:
    :type usage: long
    :param max_usage:
    :type max_usage: long
    :param limit:
    :type limit: long
    """

    _attribute_map = {
        'usage': {'key': 'usage', 'type': 'long'},
        'max_usage': {'key': 'maxUsage', 'type': 'long'},
        'limit': {'key': 'limit', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        usage: Optional[int] = None,
        max_usage: Optional[int] = None,
        limit: Optional[int] = None,
        **kwargs
    ):
        super(ContainerMemoryStatistics, self).__init__(**kwargs)
        self.usage = usage
        self.max_usage = max_usage
        self.limit = limit


class ContainerNetworkInterfaceStatistics(msrest.serialization.Model):
    """ContainerNetworkInterfaceStatistics.

    :param rx_bytes:
    :type rx_bytes: long
    :param rx_packets:
    :type rx_packets: long
    :param rx_errors:
    :type rx_errors: long
    :param rx_dropped:
    :type rx_dropped: long
    :param tx_bytes:
    :type tx_bytes: long
    :param tx_packets:
    :type tx_packets: long
    :param tx_errors:
    :type tx_errors: long
    :param tx_dropped:
    :type tx_dropped: long
    """

    _attribute_map = {
        'rx_bytes': {'key': 'rxBytes', 'type': 'long'},
        'rx_packets': {'key': 'rxPackets', 'type': 'long'},
        'rx_errors': {'key': 'rxErrors', 'type': 'long'},
        'rx_dropped': {'key': 'rxDropped', 'type': 'long'},
        'tx_bytes': {'key': 'txBytes', 'type': 'long'},
        'tx_packets': {'key': 'txPackets', 'type': 'long'},
        'tx_errors': {'key': 'txErrors', 'type': 'long'},
        'tx_dropped': {'key': 'txDropped', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        rx_bytes: Optional[int] = None,
        rx_packets: Optional[int] = None,
        rx_errors: Optional[int] = None,
        rx_dropped: Optional[int] = None,
        tx_bytes: Optional[int] = None,
        tx_packets: Optional[int] = None,
        tx_errors: Optional[int] = None,
        tx_dropped: Optional[int] = None,
        **kwargs
    ):
        super(ContainerNetworkInterfaceStatistics, self).__init__(**kwargs)
        self.rx_bytes = rx_bytes
        self.rx_packets = rx_packets
        self.rx_errors = rx_errors
        self.rx_dropped = rx_dropped
        self.tx_bytes = tx_bytes
        self.tx_packets = tx_packets
        self.tx_errors = tx_errors
        self.tx_dropped = tx_dropped


class ContainerThrottlingData(msrest.serialization.Model):
    """ContainerThrottlingData.

    :param periods:
    :type periods: int
    :param throttled_periods:
    :type throttled_periods: int
    :param throttled_time:
    :type throttled_time: int
    """

    _attribute_map = {
        'periods': {'key': 'periods', 'type': 'int'},
        'throttled_periods': {'key': 'throttledPeriods', 'type': 'int'},
        'throttled_time': {'key': 'throttledTime', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        periods: Optional[int] = None,
        throttled_periods: Optional[int] = None,
        throttled_time: Optional[int] = None,
        **kwargs
    ):
        super(ContainerThrottlingData, self).__init__(**kwargs)
        self.periods = periods
        self.throttled_periods = throttled_periods
        self.throttled_time = throttled_time


class ContinuousWebJob(ProxyOnlyResource):
    """Continuous Web Job Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param status: Job status. Possible values include: "Initializing", "Starting", "Running",
     "PendingRestart", "Stopped".
    :type status: str or ~azure.mgmt.web.v2019_08_01.models.ContinuousWebJobStatus
    :param detailed_status: Detailed status.
    :type detailed_status: str
    :param log_url: Log URL.
    :type log_url: str
    :param run_command: Run command.
    :type run_command: str
    :param url: Job URL.
    :type url: str
    :param extra_info_url: Extra Info URL.
    :type extra_info_url: str
    :param web_job_type: Job type. Possible values include: "Continuous", "Triggered".
    :type web_job_type: str or ~azure.mgmt.web.v2019_08_01.models.WebJobType
    :param error: Error information.
    :type error: str
    :param using_sdk: Using SDK?.
    :type using_sdk: bool
    :param settings: Job settings.
    :type settings: dict[str, any]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'detailed_status': {'key': 'properties.detailed_status', 'type': 'str'},
        'log_url': {'key': 'properties.log_url', 'type': 'str'},
        'run_command': {'key': 'properties.run_command', 'type': 'str'},
        'url': {'key': 'properties.url', 'type': 'str'},
        'extra_info_url': {'key': 'properties.extra_info_url', 'type': 'str'},
        'web_job_type': {'key': 'properties.web_job_type', 'type': 'str'},
        'error': {'key': 'properties.error', 'type': 'str'},
        'using_sdk': {'key': 'properties.using_sdk', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        status: Optional[Union[str, "ContinuousWebJobStatus"]] = None,
        detailed_status: Optional[str] = None,
        log_url: Optional[str] = None,
        run_command: Optional[str] = None,
        url: Optional[str] = None,
        extra_info_url: Optional[str] = None,
        web_job_type: Optional[Union[str, "WebJobType"]] = None,
        error: Optional[str] = None,
        using_sdk: Optional[bool] = None,
        settings: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        super(ContinuousWebJob, self).__init__(kind=kind, **kwargs)
        self.status = status
        self.detailed_status = detailed_status
        self.log_url = log_url
        self.run_command = run_command
        self.url = url
        self.extra_info_url = extra_info_url
        self.web_job_type = web_job_type
        self.error = error
        self.using_sdk = using_sdk
        self.settings = settings


class ContinuousWebJobCollection(msrest.serialization.Model):
    """Collection of Kudu continuous web job information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.ContinuousWebJob]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ContinuousWebJob]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["ContinuousWebJob"],
        **kwargs
    ):
        super(ContinuousWebJobCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class CorsSettings(msrest.serialization.Model):
    """Cross-Origin Resource Sharing (CORS) settings for the app.

    :param allowed_origins: Gets or sets the list of origins that should be allowed to make
     cross-origin
     calls (for example: http://example.com:12345). Use "*" to allow all.
    :type allowed_origins: list[str]
    :param support_credentials: Gets or sets whether CORS requests with credentials are allowed.
     See
     https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Requests_with_credentials
     for more details.
    :type support_credentials: bool
    """

    _attribute_map = {
        'allowed_origins': {'key': 'allowedOrigins', 'type': '[str]'},
        'support_credentials': {'key': 'supportCredentials', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        allowed_origins: Optional[List[str]] = None,
        support_credentials: Optional[bool] = None,
        **kwargs
    ):
        super(CorsSettings, self).__init__(**kwargs)
        self.allowed_origins = allowed_origins
        self.support_credentials = support_credentials


class CsmCopySlotEntity(msrest.serialization.Model):
    """Copy deployment slot parameters.

    All required parameters must be populated in order to send to Azure.

    :param target_slot: Required. Destination deployment slot during copy operation.
    :type target_slot: str
    :param site_config: Required. The site object which will be merged with the source slot site
     to produce new destination slot site object.
     :code:`<code>null</code>` to just copy source slot content. Otherwise a
     :code:`<code>Site</code>`
     object with properties to override source slot site.
    :type site_config: ~azure.mgmt.web.v2019_08_01.models.SiteConfig
    """

    _validation = {
        'target_slot': {'required': True},
        'site_config': {'required': True},
    }

    _attribute_map = {
        'target_slot': {'key': 'targetSlot', 'type': 'str'},
        'site_config': {'key': 'siteConfig', 'type': 'SiteConfig'},
    }

    def __init__(
        self,
        *,
        target_slot: str,
        site_config: "SiteConfig",
        **kwargs
    ):
        super(CsmCopySlotEntity, self).__init__(**kwargs)
        self.target_slot = target_slot
        self.site_config = site_config


class CsmMoveResourceEnvelope(msrest.serialization.Model):
    """Object with a list of the resources that need to be moved and the resource group they should be moved to.

    :param target_resource_group:
    :type target_resource_group: str
    :param resources:
    :type resources: list[str]
    """

    _validation = {
        'target_resource_group': {'max_length': 90, 'min_length': 1, 'pattern': r' ^[-\w\._\(\)]+[^\.]$'},
    }

    _attribute_map = {
        'target_resource_group': {'key': 'targetResourceGroup', 'type': 'str'},
        'resources': {'key': 'resources', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        target_resource_group: Optional[str] = None,
        resources: Optional[List[str]] = None,
        **kwargs
    ):
        super(CsmMoveResourceEnvelope, self).__init__(**kwargs)
        self.target_resource_group = target_resource_group
        self.resources = resources


class CsmOperationCollection(msrest.serialization.Model):
    """Collection of Azure resource manager operation metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.CsmOperationDescription]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CsmOperationDescription]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["CsmOperationDescription"],
        **kwargs
    ):
        super(CsmOperationCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class CsmOperationDescription(msrest.serialization.Model):
    """Description of an operation available for Microsoft.Web resource provider.

    :param name:
    :type name: str
    :param display: Meta data about operation used for display in portal.
    :type display: ~azure.mgmt.web.v2019_08_01.models.CsmOperationDisplay
    :param origin:
    :type origin: str
    :param properties: Properties available for a Microsoft.Web resource provider operation.
    :type properties: ~azure.mgmt.web.v2019_08_01.models.CsmOperationDescriptionProperties
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'CsmOperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'CsmOperationDescriptionProperties'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["CsmOperationDisplay"] = None,
        origin: Optional[str] = None,
        properties: Optional["CsmOperationDescriptionProperties"] = None,
        **kwargs
    ):
        super(CsmOperationDescription, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.properties = properties


class CsmOperationDescriptionProperties(msrest.serialization.Model):
    """Properties available for a Microsoft.Web resource provider operation.

    :param service_specification: Resource metrics service provided by Microsoft.Insights resource
     provider.
    :type service_specification: ~azure.mgmt.web.v2019_08_01.models.ServiceSpecification
    """

    _attribute_map = {
        'service_specification': {'key': 'serviceSpecification', 'type': 'ServiceSpecification'},
    }

    def __init__(
        self,
        *,
        service_specification: Optional["ServiceSpecification"] = None,
        **kwargs
    ):
        super(CsmOperationDescriptionProperties, self).__init__(**kwargs)
        self.service_specification = service_specification


class CsmOperationDisplay(msrest.serialization.Model):
    """Meta data about operation used for display in portal.

    :param provider:
    :type provider: str
    :param resource:
    :type resource: str
    :param operation:
    :type operation: str
    :param description:
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(CsmOperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class CsmPublishingCredentialsPoliciesCollection(ProxyOnlyResource):
    """Publishing Credentials Policies collection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param ftp: Whether FTP is allowed.
    :type ftp: ~azure.mgmt.web.v2019_08_01.models.CsmPublishingCredentialsPoliciesEntity
    :param scm: Whether Scm Basic Auth is allowed.
    :type scm: ~azure.mgmt.web.v2019_08_01.models.CsmPublishingCredentialsPoliciesEntity
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'ftp': {'key': 'properties.ftp', 'type': 'CsmPublishingCredentialsPoliciesEntity'},
        'scm': {'key': 'properties.scm', 'type': 'CsmPublishingCredentialsPoliciesEntity'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        ftp: Optional["CsmPublishingCredentialsPoliciesEntity"] = None,
        scm: Optional["CsmPublishingCredentialsPoliciesEntity"] = None,
        **kwargs
    ):
        super(CsmPublishingCredentialsPoliciesCollection, self).__init__(kind=kind, **kwargs)
        self.ftp = ftp
        self.scm = scm


class CsmPublishingCredentialsPoliciesEntity(ProxyOnlyResource):
    """Publishing Credentials Policies parameters.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param allow: :code:`<code>true</code>` to allow access to a publishing method; otherwise,
     :code:`<code>false</code>`.
    :type allow: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'allow': {'key': 'properties.allow', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        allow: Optional[bool] = None,
        **kwargs
    ):
        super(CsmPublishingCredentialsPoliciesEntity, self).__init__(kind=kind, **kwargs)
        self.allow = allow


class CsmPublishingProfileOptions(msrest.serialization.Model):
    """Publishing options for requested profile.

    :param format: Name of the format. Valid values are:
     FileZilla3
     WebDeploy -- default
     Ftp. Possible values include: "FileZilla3", "WebDeploy", "Ftp".
    :type format: str or ~azure.mgmt.web.v2019_08_01.models.PublishingProfileFormat
    :param include_disaster_recovery_endpoints: Include the DisasterRecover endpoint if true.
    :type include_disaster_recovery_endpoints: bool
    """

    _attribute_map = {
        'format': {'key': 'format', 'type': 'str'},
        'include_disaster_recovery_endpoints': {'key': 'includeDisasterRecoveryEndpoints', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        format: Optional[Union[str, "PublishingProfileFormat"]] = None,
        include_disaster_recovery_endpoints: Optional[bool] = None,
        **kwargs
    ):
        super(CsmPublishingProfileOptions, self).__init__(**kwargs)
        self.format = format
        self.include_disaster_recovery_endpoints = include_disaster_recovery_endpoints


class CsmSlotEntity(msrest.serialization.Model):
    """Deployment slot parameters.

    All required parameters must be populated in order to send to Azure.

    :param target_slot: Required. Destination deployment slot during swap operation.
    :type target_slot: str
    :param preserve_vnet: Required. :code:`<code>true</code>` to preserve Virtual Network to the
     slot during swap; otherwise, :code:`<code>false</code>`.
    :type preserve_vnet: bool
    """

    _validation = {
        'target_slot': {'required': True},
        'preserve_vnet': {'required': True},
    }

    _attribute_map = {
        'target_slot': {'key': 'targetSlot', 'type': 'str'},
        'preserve_vnet': {'key': 'preserveVnet', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        target_slot: str,
        preserve_vnet: bool,
        **kwargs
    ):
        super(CsmSlotEntity, self).__init__(**kwargs)
        self.target_slot = target_slot
        self.preserve_vnet = preserve_vnet


class CsmUsageQuota(msrest.serialization.Model):
    """Usage of the quota resource.

    :param unit: Units of measurement for the quota resource.
    :type unit: str
    :param next_reset_time: Next reset time for the resource counter.
    :type next_reset_time: ~datetime.datetime
    :param current_value: The current value of the resource counter.
    :type current_value: long
    :param limit: The resource limit.
    :type limit: long
    :param name: Quota name.
    :type name: ~azure.mgmt.web.v2019_08_01.models.LocalizableString
    """

    _attribute_map = {
        'unit': {'key': 'unit', 'type': 'str'},
        'next_reset_time': {'key': 'nextResetTime', 'type': 'iso-8601'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'limit': {'key': 'limit', 'type': 'long'},
        'name': {'key': 'name', 'type': 'LocalizableString'},
    }

    def __init__(
        self,
        *,
        unit: Optional[str] = None,
        next_reset_time: Optional[datetime.datetime] = None,
        current_value: Optional[int] = None,
        limit: Optional[int] = None,
        name: Optional["LocalizableString"] = None,
        **kwargs
    ):
        super(CsmUsageQuota, self).__init__(**kwargs)
        self.unit = unit
        self.next_reset_time = next_reset_time
        self.current_value = current_value
        self.limit = limit
        self.name = name


class CsmUsageQuotaCollection(msrest.serialization.Model):
    """Collection of CSM usage quotas.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.CsmUsageQuota]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CsmUsageQuota]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["CsmUsageQuota"],
        **kwargs
    ):
        super(CsmUsageQuotaCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class CustomHostnameAnalysisResult(ProxyOnlyResource):
    """Custom domain analysis.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar is_hostname_already_verified: :code:`<code>true</code>` if hostname is already verified;
     otherwise, :code:`<code>false</code>`.
    :vartype is_hostname_already_verified: bool
    :ivar custom_domain_verification_test: DNS verification test result. Possible values include:
     "Passed", "Failed", "Skipped".
    :vartype custom_domain_verification_test: str or
     ~azure.mgmt.web.v2019_08_01.models.DnsVerificationTestResult
    :ivar custom_domain_verification_failure_info: Raw failure information if DNS verification
     fails.
    :vartype custom_domain_verification_failure_info:
     ~azure.mgmt.web.v2019_08_01.models.ErrorEntity
    :ivar has_conflict_on_scale_unit: :code:`<code>true</code>` if there is a conflict on a scale
     unit; otherwise, :code:`<code>false</code>`.
    :vartype has_conflict_on_scale_unit: bool
    :ivar has_conflict_across_subscription: :code:`<code>true</code>` if there is a conflict across
     subscriptions; otherwise, :code:`<code>false</code>`.
    :vartype has_conflict_across_subscription: bool
    :ivar conflicting_app_resource_id: Name of the conflicting app on scale unit if it's within the
     same subscription.
    :vartype conflicting_app_resource_id: str
    :param c_name_records: CName records controller can see for this hostname.
    :type c_name_records: list[str]
    :param txt_records: TXT records controller can see for this hostname.
    :type txt_records: list[str]
    :param a_records: A records controller can see for this hostname.
    :type a_records: list[str]
    :param alternate_c_name_records: Alternate CName records controller can see for this hostname.
    :type alternate_c_name_records: list[str]
    :param alternate_txt_records: Alternate TXT records controller can see for this hostname.
    :type alternate_txt_records: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'is_hostname_already_verified': {'readonly': True},
        'custom_domain_verification_test': {'readonly': True},
        'custom_domain_verification_failure_info': {'readonly': True},
        'has_conflict_on_scale_unit': {'readonly': True},
        'has_conflict_across_subscription': {'readonly': True},
        'conflicting_app_resource_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_hostname_already_verified': {'key': 'properties.isHostnameAlreadyVerified', 'type': 'bool'},
        'custom_domain_verification_test': {'key': 'properties.customDomainVerificationTest', 'type': 'str'},
        'custom_domain_verification_failure_info': {'key': 'properties.customDomainVerificationFailureInfo', 'type': 'ErrorEntity'},
        'has_conflict_on_scale_unit': {'key': 'properties.hasConflictOnScaleUnit', 'type': 'bool'},
        'has_conflict_across_subscription': {'key': 'properties.hasConflictAcrossSubscription', 'type': 'bool'},
        'conflicting_app_resource_id': {'key': 'properties.conflictingAppResourceId', 'type': 'str'},
        'c_name_records': {'key': 'properties.cNameRecords', 'type': '[str]'},
        'txt_records': {'key': 'properties.txtRecords', 'type': '[str]'},
        'a_records': {'key': 'properties.aRecords', 'type': '[str]'},
        'alternate_c_name_records': {'key': 'properties.alternateCNameRecords', 'type': '[str]'},
        'alternate_txt_records': {'key': 'properties.alternateTxtRecords', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        c_name_records: Optional[List[str]] = None,
        txt_records: Optional[List[str]] = None,
        a_records: Optional[List[str]] = None,
        alternate_c_name_records: Optional[List[str]] = None,
        alternate_txt_records: Optional[List[str]] = None,
        **kwargs
    ):
        super(CustomHostnameAnalysisResult, self).__init__(kind=kind, **kwargs)
        self.is_hostname_already_verified = None
        self.custom_domain_verification_test = None
        self.custom_domain_verification_failure_info = None
        self.has_conflict_on_scale_unit = None
        self.has_conflict_across_subscription = None
        self.conflicting_app_resource_id = None
        self.c_name_records = c_name_records
        self.txt_records = txt_records
        self.a_records = a_records
        self.alternate_c_name_records = alternate_c_name_records
        self.alternate_txt_records = alternate_txt_records


class DatabaseBackupSetting(msrest.serialization.Model):
    """Database backup settings.

    All required parameters must be populated in order to send to Azure.

    :param database_type: Required. Database type (e.g. SqlAzure / MySql). Possible values include:
     "SqlAzure", "MySql", "LocalMySql", "PostgreSql".
    :type database_type: str or ~azure.mgmt.web.v2019_08_01.models.DatabaseType
    :param name:
    :type name: str
    :param connection_string_name: Contains a connection string name that is linked to the
     SiteConfig.ConnectionStrings.
     This is used during restore with overwrite connection strings options.
    :type connection_string_name: str
    :param connection_string: Contains a connection string to a database which is being backed up
     or restored. If the restore should happen to a new database, the database name inside is the
     new one.
    :type connection_string: str
    """

    _validation = {
        'database_type': {'required': True},
    }

    _attribute_map = {
        'database_type': {'key': 'databaseType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'connection_string_name': {'key': 'connectionStringName', 'type': 'str'},
        'connection_string': {'key': 'connectionString', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        database_type: Union[str, "DatabaseType"],
        name: Optional[str] = None,
        connection_string_name: Optional[str] = None,
        connection_string: Optional[str] = None,
        **kwargs
    ):
        super(DatabaseBackupSetting, self).__init__(**kwargs)
        self.database_type = database_type
        self.name = name
        self.connection_string_name = connection_string_name
        self.connection_string = connection_string


class DataSource(msrest.serialization.Model):
    """Class representing data source used by the detectors.

    :param instructions: Instructions if any for the data source.
    :type instructions: list[str]
    :param data_source_uri: Datasource Uri Links.
    :type data_source_uri: list[~azure.mgmt.web.v2019_08_01.models.NameValuePair]
    """

    _attribute_map = {
        'instructions': {'key': 'instructions', 'type': '[str]'},
        'data_source_uri': {'key': 'dataSourceUri', 'type': '[NameValuePair]'},
    }

    def __init__(
        self,
        *,
        instructions: Optional[List[str]] = None,
        data_source_uri: Optional[List["NameValuePair"]] = None,
        **kwargs
    ):
        super(DataSource, self).__init__(**kwargs)
        self.instructions = instructions
        self.data_source_uri = data_source_uri


class DataTableResponseColumn(msrest.serialization.Model):
    """Column definition.

    :param column_name: Name of the column.
    :type column_name: str
    :param data_type: Data type which looks like 'String' or 'Int32'.
    :type data_type: str
    :param column_type: Column Type.
    :type column_type: str
    """

    _attribute_map = {
        'column_name': {'key': 'columnName', 'type': 'str'},
        'data_type': {'key': 'dataType', 'type': 'str'},
        'column_type': {'key': 'columnType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        column_name: Optional[str] = None,
        data_type: Optional[str] = None,
        column_type: Optional[str] = None,
        **kwargs
    ):
        super(DataTableResponseColumn, self).__init__(**kwargs)
        self.column_name = column_name
        self.data_type = data_type
        self.column_type = column_type


class DataTableResponseObject(msrest.serialization.Model):
    """Data Table which defines columns and raw row values.

    :param table_name: Name of the table.
    :type table_name: str
    :param columns: List of columns with data types.
    :type columns: list[~azure.mgmt.web.v2019_08_01.models.DataTableResponseColumn]
    :param rows: Raw row values.
    :type rows: list[list[str]]
    """

    _attribute_map = {
        'table_name': {'key': 'tableName', 'type': 'str'},
        'columns': {'key': 'columns', 'type': '[DataTableResponseColumn]'},
        'rows': {'key': 'rows', 'type': '[[str]]'},
    }

    def __init__(
        self,
        *,
        table_name: Optional[str] = None,
        columns: Optional[List["DataTableResponseColumn"]] = None,
        rows: Optional[List[List[str]]] = None,
        **kwargs
    ):
        super(DataTableResponseObject, self).__init__(**kwargs)
        self.table_name = table_name
        self.columns = columns
        self.rows = rows


class DefaultErrorResponse(msrest.serialization.Model):
    """App Service error response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: Error model.
    :vartype error: ~azure.mgmt.web.v2019_08_01.models.DefaultErrorResponseError
    """

    _validation = {
        'error': {'readonly': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'DefaultErrorResponseError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DefaultErrorResponse, self).__init__(**kwargs)
        self.error = None


class DefaultErrorResponseError(msrest.serialization.Model):
    """Error model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Standardized string to programmatically identify the error.
    :vartype code: str
    :ivar message: Detailed error description and debugging information.
    :vartype message: str
    :ivar target: Detailed error description and debugging information.
    :vartype target: str
    :param details:
    :type details: list[~azure.mgmt.web.v2019_08_01.models.DefaultErrorResponseErrorDetailsItem]
    :ivar innererror: More information to debug error.
    :vartype innererror: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'innererror': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[DefaultErrorResponseErrorDetailsItem]'},
        'innererror': {'key': 'innererror', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        details: Optional[List["DefaultErrorResponseErrorDetailsItem"]] = None,
        **kwargs
    ):
        super(DefaultErrorResponseError, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = details
        self.innererror = None


class DefaultErrorResponseErrorDetailsItem(msrest.serialization.Model):
    """Detailed errors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Standardized string to programmatically identify the error.
    :vartype code: str
    :ivar message: Detailed error description and debugging information.
    :vartype message: str
    :ivar target: Detailed error description and debugging information.
    :vartype target: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DefaultErrorResponseErrorDetailsItem, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None


class DeletedAppRestoreRequest(ProxyOnlyResource):
    """Details about restoring a deleted app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param deleted_site_id: ARM resource ID of the deleted app. Example:
     /subscriptions/{subId}/providers/Microsoft.Web/deletedSites/{deletedSiteId}.
    :type deleted_site_id: str
    :param recover_configuration: If true, deleted site configuration, in addition to content, will
     be restored.
    :type recover_configuration: bool
    :param snapshot_time: Point in time to restore the deleted app from, formatted as a DateTime
     string.
     If unspecified, default value is the time that the app was deleted.
    :type snapshot_time: str
    :param use_dr_secondary: If true, the snapshot is retrieved from DRSecondary endpoint.
    :type use_dr_secondary: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'deleted_site_id': {'key': 'properties.deletedSiteId', 'type': 'str'},
        'recover_configuration': {'key': 'properties.recoverConfiguration', 'type': 'bool'},
        'snapshot_time': {'key': 'properties.snapshotTime', 'type': 'str'},
        'use_dr_secondary': {'key': 'properties.useDRSecondary', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        deleted_site_id: Optional[str] = None,
        recover_configuration: Optional[bool] = None,
        snapshot_time: Optional[str] = None,
        use_dr_secondary: Optional[bool] = None,
        **kwargs
    ):
        super(DeletedAppRestoreRequest, self).__init__(kind=kind, **kwargs)
        self.deleted_site_id = deleted_site_id
        self.recover_configuration = recover_configuration
        self.snapshot_time = snapshot_time
        self.use_dr_secondary = use_dr_secondary


class DeletedSite(ProxyOnlyResource):
    """A deleted app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar deleted_site_id: Numeric id for the deleted site.
    :vartype deleted_site_id: int
    :ivar deleted_timestamp: Time in UTC when the app was deleted.
    :vartype deleted_timestamp: str
    :ivar subscription: Subscription containing the deleted site.
    :vartype subscription: str
    :ivar resource_group: ResourceGroup that contained the deleted site.
    :vartype resource_group: str
    :ivar deleted_site_name: Name of the deleted site.
    :vartype deleted_site_name: str
    :ivar slot: Slot of the deleted site.
    :vartype slot: str
    :ivar kind_properties_kind: Kind of site that was deleted.
    :vartype kind_properties_kind: str
    :ivar geo_region_name: Geo Region of the deleted site.
    :vartype geo_region_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'deleted_site_id': {'readonly': True},
        'deleted_timestamp': {'readonly': True},
        'subscription': {'readonly': True},
        'resource_group': {'readonly': True},
        'deleted_site_name': {'readonly': True},
        'slot': {'readonly': True},
        'kind_properties_kind': {'readonly': True},
        'geo_region_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'deleted_site_id': {'key': 'properties.deletedSiteId', 'type': 'int'},
        'deleted_timestamp': {'key': 'properties.deletedTimestamp', 'type': 'str'},
        'subscription': {'key': 'properties.subscription', 'type': 'str'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'deleted_site_name': {'key': 'properties.deletedSiteName', 'type': 'str'},
        'slot': {'key': 'properties.slot', 'type': 'str'},
        'kind_properties_kind': {'key': 'properties.kind', 'type': 'str'},
        'geo_region_name': {'key': 'properties.geoRegionName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        super(DeletedSite, self).__init__(kind=kind, **kwargs)
        self.deleted_site_id = None
        self.deleted_timestamp = None
        self.subscription = None
        self.resource_group = None
        self.deleted_site_name = None
        self.slot = None
        self.kind_properties_kind = None
        self.geo_region_name = None


class DeletedWebAppCollection(msrest.serialization.Model):
    """Collection of deleted apps.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.DeletedSite]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DeletedSite]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["DeletedSite"],
        **kwargs
    ):
        super(DeletedWebAppCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class Deployment(ProxyOnlyResource):
    """User credentials used for publishing activity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param status: Deployment status.
    :type status: int
    :param message: Details about deployment status.
    :type message: str
    :param author: Who authored the deployment.
    :type author: str
    :param deployer: Who performed the deployment.
    :type deployer: str
    :param author_email: Author email.
    :type author_email: str
    :param start_time: Start time.
    :type start_time: ~datetime.datetime
    :param end_time: End time.
    :type end_time: ~datetime.datetime
    :param active: True if deployment is currently active, false if completed and null if not
     started.
    :type active: bool
    :param details: Details on deployment.
    :type details: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'int'},
        'message': {'key': 'properties.message', 'type': 'str'},
        'author': {'key': 'properties.author', 'type': 'str'},
        'deployer': {'key': 'properties.deployer', 'type': 'str'},
        'author_email': {'key': 'properties.author_email', 'type': 'str'},
        'start_time': {'key': 'properties.start_time', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.end_time', 'type': 'iso-8601'},
        'active': {'key': 'properties.active', 'type': 'bool'},
        'details': {'key': 'properties.details', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        status: Optional[int] = None,
        message: Optional[str] = None,
        author: Optional[str] = None,
        deployer: Optional[str] = None,
        author_email: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        active: Optional[bool] = None,
        details: Optional[str] = None,
        **kwargs
    ):
        super(Deployment, self).__init__(kind=kind, **kwargs)
        self.status = status
        self.message = message
        self.author = author
        self.deployer = deployer
        self.author_email = author_email
        self.start_time = start_time
        self.end_time = end_time
        self.active = active
        self.details = details


class DeploymentCollection(msrest.serialization.Model):
    """Collection of app deployments.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.Deployment]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Deployment]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["Deployment"],
        **kwargs
    ):
        super(DeploymentCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class DeploymentLocations(msrest.serialization.Model):
    """List of available locations (regions or App Service Environments) for
deployment of App Service resources.

    :param locations: Available regions.
    :type locations: list[~azure.mgmt.web.v2019_08_01.models.GeoRegion]
    :param hosting_environments: Available App Service Environments with full descriptions of the
     environments.
    :type hosting_environments: list[~azure.mgmt.web.v2019_08_01.models.AppServiceEnvironment]
    :param hosting_environment_deployment_infos: Available App Service Environments with basic
     information.
    :type hosting_environment_deployment_infos:
     list[~azure.mgmt.web.v2019_08_01.models.HostingEnvironmentDeploymentInfo]
    """

    _attribute_map = {
        'locations': {'key': 'locations', 'type': '[GeoRegion]'},
        'hosting_environments': {'key': 'hostingEnvironments', 'type': '[AppServiceEnvironment]'},
        'hosting_environment_deployment_infos': {'key': 'hostingEnvironmentDeploymentInfos', 'type': '[HostingEnvironmentDeploymentInfo]'},
    }

    def __init__(
        self,
        *,
        locations: Optional[List["GeoRegion"]] = None,
        hosting_environments: Optional[List["AppServiceEnvironment"]] = None,
        hosting_environment_deployment_infos: Optional[List["HostingEnvironmentDeploymentInfo"]] = None,
        **kwargs
    ):
        super(DeploymentLocations, self).__init__(**kwargs)
        self.locations = locations
        self.hosting_environments = hosting_environments
        self.hosting_environment_deployment_infos = hosting_environment_deployment_infos


class DetectorAbnormalTimePeriod(msrest.serialization.Model):
    """Class representing Abnormal Time Period detected.

    :param start_time: Start time of the correlated event.
    :type start_time: ~datetime.datetime
    :param end_time: End time of the correlated event.
    :type end_time: ~datetime.datetime
    :param message: Message describing the event.
    :type message: str
    :param source: Represents the name of the Detector.
    :type source: str
    :param priority: Represents the rank of the Detector.
    :type priority: float
    :param meta_data: Downtime metadata.
    :type meta_data: list[list[~azure.mgmt.web.v2019_08_01.models.NameValuePair]]
    :param type: Represents the type of the Detector. Possible values include: "ServiceIncident",
     "AppDeployment", "AppCrash", "RuntimeIssueDetected", "AseDeployment", "UserIssue",
     "PlatformIssue", "Other".
    :type type: str or ~azure.mgmt.web.v2019_08_01.models.IssueType
    :param solutions: List of proposed solutions.
    :type solutions: list[~azure.mgmt.web.v2019_08_01.models.Solution]
    """

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'message': {'key': 'message', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'float'},
        'meta_data': {'key': 'metaData', 'type': '[[NameValuePair]]'},
        'type': {'key': 'type', 'type': 'str'},
        'solutions': {'key': 'solutions', 'type': '[Solution]'},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        message: Optional[str] = None,
        source: Optional[str] = None,
        priority: Optional[float] = None,
        meta_data: Optional[List[List["NameValuePair"]]] = None,
        type: Optional[Union[str, "IssueType"]] = None,
        solutions: Optional[List["Solution"]] = None,
        **kwargs
    ):
        super(DetectorAbnormalTimePeriod, self).__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.message = message
        self.source = source
        self.priority = priority
        self.meta_data = meta_data
        self.type = type
        self.solutions = solutions


class DetectorDefinition(ProxyOnlyResource):
    """Class representing detector definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: Display name of the detector.
    :vartype display_name: str
    :ivar description: Description of the detector.
    :vartype description: str
    :ivar rank: Detector Rank.
    :vartype rank: float
    :ivar is_enabled: Flag representing whether detector is enabled or not.
    :vartype is_enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'rank': {'readonly': True},
        'is_enabled': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'rank': {'key': 'properties.rank', 'type': 'float'},
        'is_enabled': {'key': 'properties.isEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        super(DetectorDefinition, self).__init__(kind=kind, **kwargs)
        self.display_name = None
        self.description = None
        self.rank = None
        self.is_enabled = None


class DetectorInfo(msrest.serialization.Model):
    """Definition of Detector.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: Short description of the detector and its purpose.
    :vartype description: str
    :ivar category: Support Category.
    :vartype category: str
    :ivar sub_category: Support Sub Category.
    :vartype sub_category: str
    :ivar support_topic_id: Support Topic Id.
    :vartype support_topic_id: str
    """

    _validation = {
        'description': {'readonly': True},
        'category': {'readonly': True},
        'sub_category': {'readonly': True},
        'support_topic_id': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'sub_category': {'key': 'subCategory', 'type': 'str'},
        'support_topic_id': {'key': 'supportTopicId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DetectorInfo, self).__init__(**kwargs)
        self.description = None
        self.category = None
        self.sub_category = None
        self.support_topic_id = None


class DetectorResponse(ProxyOnlyResource):
    """Class representing Response from Detector.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param metadata: metadata for the detector.
    :type metadata: ~azure.mgmt.web.v2019_08_01.models.DetectorInfo
    :param dataset: Data Set.
    :type dataset: list[~azure.mgmt.web.v2019_08_01.models.DiagnosticData]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'metadata': {'key': 'properties.metadata', 'type': 'DetectorInfo'},
        'dataset': {'key': 'properties.dataset', 'type': '[DiagnosticData]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        metadata: Optional["DetectorInfo"] = None,
        dataset: Optional[List["DiagnosticData"]] = None,
        **kwargs
    ):
        super(DetectorResponse, self).__init__(kind=kind, **kwargs)
        self.metadata = metadata
        self.dataset = dataset


class DetectorResponseCollection(msrest.serialization.Model):
    """Collection of detector responses.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.DetectorResponse]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DetectorResponse]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["DetectorResponse"],
        **kwargs
    ):
        super(DetectorResponseCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class DiagnosticAnalysis(ProxyOnlyResource):
    """Class representing a diagnostic analysis done on an application.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param start_time: Start time of the period.
    :type start_time: ~datetime.datetime
    :param end_time: End time of the period.
    :type end_time: ~datetime.datetime
    :param abnormal_time_periods: List of time periods.
    :type abnormal_time_periods: list[~azure.mgmt.web.v2019_08_01.models.AbnormalTimePeriod]
    :param payload: Data by each detector.
    :type payload: list[~azure.mgmt.web.v2019_08_01.models.AnalysisData]
    :param non_correlated_detectors: Data by each detector for detectors that did not corelate.
    :type non_correlated_detectors: list[~azure.mgmt.web.v2019_08_01.models.DetectorDefinition]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'abnormal_time_periods': {'key': 'properties.abnormalTimePeriods', 'type': '[AbnormalTimePeriod]'},
        'payload': {'key': 'properties.payload', 'type': '[AnalysisData]'},
        'non_correlated_detectors': {'key': 'properties.nonCorrelatedDetectors', 'type': '[DetectorDefinition]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        abnormal_time_periods: Optional[List["AbnormalTimePeriod"]] = None,
        payload: Optional[List["AnalysisData"]] = None,
        non_correlated_detectors: Optional[List["DetectorDefinition"]] = None,
        **kwargs
    ):
        super(DiagnosticAnalysis, self).__init__(kind=kind, **kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.abnormal_time_periods = abnormal_time_periods
        self.payload = payload
        self.non_correlated_detectors = non_correlated_detectors


class DiagnosticAnalysisCollection(msrest.serialization.Model):
    """Collection of Diagnostic Analyses.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.AnalysisDefinition]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AnalysisDefinition]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["AnalysisDefinition"],
        **kwargs
    ):
        super(DiagnosticAnalysisCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class DiagnosticCategory(ProxyOnlyResource):
    """Class representing detector definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar description: Description of the diagnostic category.
    :vartype description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        super(DiagnosticCategory, self).__init__(kind=kind, **kwargs)
        self.description = None


class DiagnosticCategoryCollection(msrest.serialization.Model):
    """Collection of Diagnostic Categories.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.DiagnosticCategory]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DiagnosticCategory]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["DiagnosticCategory"],
        **kwargs
    ):
        super(DiagnosticCategoryCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class DiagnosticData(msrest.serialization.Model):
    """Set of data with rendering instructions.

    :param table: Data in table form.
    :type table: ~azure.mgmt.web.v2019_08_01.models.DataTableResponseObject
    :param rendering_properties: Properties that describe how the table should be rendered.
    :type rendering_properties: ~azure.mgmt.web.v2019_08_01.models.Rendering
    """

    _attribute_map = {
        'table': {'key': 'table', 'type': 'DataTableResponseObject'},
        'rendering_properties': {'key': 'renderingProperties', 'type': 'Rendering'},
    }

    def __init__(
        self,
        *,
        table: Optional["DataTableResponseObject"] = None,
        rendering_properties: Optional["Rendering"] = None,
        **kwargs
    ):
        super(DiagnosticData, self).__init__(**kwargs)
        self.table = table
        self.rendering_properties = rendering_properties


class DiagnosticDetectorCollection(msrest.serialization.Model):
    """Collection of Diagnostic Detectors.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.DetectorDefinition]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DetectorDefinition]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["DetectorDefinition"],
        **kwargs
    ):
        super(DiagnosticDetectorCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class DiagnosticDetectorResponse(ProxyOnlyResource):
    """Class representing Response from Diagnostic Detectors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param start_time: Start time of the period.
    :type start_time: ~datetime.datetime
    :param end_time: End time of the period.
    :type end_time: ~datetime.datetime
    :param issue_detected: Flag representing Issue was detected.
    :type issue_detected: bool
    :param detector_definition: Detector's definition.
    :type detector_definition: ~azure.mgmt.web.v2019_08_01.models.DetectorDefinition
    :param metrics: Metrics provided by the detector.
    :type metrics: list[~azure.mgmt.web.v2019_08_01.models.DiagnosticMetricSet]
    :param abnormal_time_periods: List of Correlated events found by the detector.
    :type abnormal_time_periods:
     list[~azure.mgmt.web.v2019_08_01.models.DetectorAbnormalTimePeriod]
    :param data: Additional Data that detector wants to send.
    :type data: list[list[~azure.mgmt.web.v2019_08_01.models.NameValuePair]]
    :param response_meta_data: Meta Data.
    :type response_meta_data: ~azure.mgmt.web.v2019_08_01.models.ResponseMetaData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'issue_detected': {'key': 'properties.issueDetected', 'type': 'bool'},
        'detector_definition': {'key': 'properties.detectorDefinition', 'type': 'DetectorDefinition'},
        'metrics': {'key': 'properties.metrics', 'type': '[DiagnosticMetricSet]'},
        'abnormal_time_periods': {'key': 'properties.abnormalTimePeriods', 'type': '[DetectorAbnormalTimePeriod]'},
        'data': {'key': 'properties.data', 'type': '[[NameValuePair]]'},
        'response_meta_data': {'key': 'properties.responseMetaData', 'type': 'ResponseMetaData'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        issue_detected: Optional[bool] = None,
        detector_definition: Optional["DetectorDefinition"] = None,
        metrics: Optional[List["DiagnosticMetricSet"]] = None,
        abnormal_time_periods: Optional[List["DetectorAbnormalTimePeriod"]] = None,
        data: Optional[List[List["NameValuePair"]]] = None,
        response_meta_data: Optional["ResponseMetaData"] = None,
        **kwargs
    ):
        super(DiagnosticDetectorResponse, self).__init__(kind=kind, **kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.issue_detected = issue_detected
        self.detector_definition = detector_definition
        self.metrics = metrics
        self.abnormal_time_periods = abnormal_time_periods
        self.data = data
        self.response_meta_data = response_meta_data


class DiagnosticMetricSample(msrest.serialization.Model):
    """Class representing Diagnostic Metric.

    :param timestamp: Time at which metric is measured.
    :type timestamp: ~datetime.datetime
    :param role_instance: Role Instance. Null if this counter is not per instance
     This is returned and should be whichever instance name we desire to be returned
     i.e. CPU and Memory return RDWORKERNAME (LargeDed..._IN_0)
     where RDWORKERNAME is Machine name below and RoleInstance name in parenthesis.
    :type role_instance: str
    :param total: Total value of the metric. If multiple measurements are made this will have sum
     of all.
    :type total: float
    :param maximum: Maximum of the metric sampled during the time period.
    :type maximum: float
    :param minimum: Minimum of the metric sampled during the time period.
    :type minimum: float
    :param is_aggregated: Whether the values are aggregates across all workers or not.
    :type is_aggregated: bool
    """

    _attribute_map = {
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'role_instance': {'key': 'roleInstance', 'type': 'str'},
        'total': {'key': 'total', 'type': 'float'},
        'maximum': {'key': 'maximum', 'type': 'float'},
        'minimum': {'key': 'minimum', 'type': 'float'},
        'is_aggregated': {'key': 'isAggregated', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        timestamp: Optional[datetime.datetime] = None,
        role_instance: Optional[str] = None,
        total: Optional[float] = None,
        maximum: Optional[float] = None,
        minimum: Optional[float] = None,
        is_aggregated: Optional[bool] = None,
        **kwargs
    ):
        super(DiagnosticMetricSample, self).__init__(**kwargs)
        self.timestamp = timestamp
        self.role_instance = role_instance
        self.total = total
        self.maximum = maximum
        self.minimum = minimum
        self.is_aggregated = is_aggregated


class DiagnosticMetricSet(msrest.serialization.Model):
    """Class representing Diagnostic Metric information.

    :param name: Name of the metric.
    :type name: str
    :param unit: Metric's unit.
    :type unit: str
    :param start_time: Start time of the period.
    :type start_time: ~datetime.datetime
    :param end_time: End time of the period.
    :type end_time: ~datetime.datetime
    :param time_grain: Presented time grain. Supported grains at the moment are PT1M, PT1H, P1D.
    :type time_grain: str
    :param values: Collection of metric values for the selected period based on the
     {Microsoft.Web.Hosting.Administration.DiagnosticMetricSet.TimeGrain}.
    :type values: list[~azure.mgmt.web.v2019_08_01.models.DiagnosticMetricSample]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'values': {'key': 'values', 'type': '[DiagnosticMetricSample]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        unit: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        time_grain: Optional[str] = None,
        values: Optional[List["DiagnosticMetricSample"]] = None,
        **kwargs
    ):
        super(DiagnosticMetricSet, self).__init__(**kwargs)
        self.name = name
        self.unit = unit
        self.start_time = start_time
        self.end_time = end_time
        self.time_grain = time_grain
        self.values = values


class Dimension(msrest.serialization.Model):
    """Dimension of a resource metric. For e.g. instance specific HTTP requests for a web app, 
where instance name is dimension of the metric HTTP request.

    :param name:
    :type name: str
    :param display_name:
    :type display_name: str
    :param internal_name:
    :type internal_name: str
    :param to_be_exported_for_shoebox:
    :type to_be_exported_for_shoebox: bool
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'internal_name': {'key': 'internalName', 'type': 'str'},
        'to_be_exported_for_shoebox': {'key': 'toBeExportedForShoebox', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        internal_name: Optional[str] = None,
        to_be_exported_for_shoebox: Optional[bool] = None,
        **kwargs
    ):
        super(Dimension, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.internal_name = internal_name
        self.to_be_exported_for_shoebox = to_be_exported_for_shoebox


class Domain(Resource):
    """Information about a domain.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param contact_admin: Administrative contact.
    :type contact_admin: ~azure.mgmt.web.v2019_08_01.models.Contact
    :param contact_billing: Billing contact.
    :type contact_billing: ~azure.mgmt.web.v2019_08_01.models.Contact
    :param contact_registrant: Registrant contact.
    :type contact_registrant: ~azure.mgmt.web.v2019_08_01.models.Contact
    :param contact_tech: Technical contact.
    :type contact_tech: ~azure.mgmt.web.v2019_08_01.models.Contact
    :ivar registration_status: Domain registration status. Possible values include: "Active",
     "Awaiting", "Cancelled", "Confiscated", "Disabled", "Excluded", "Expired", "Failed", "Held",
     "Locked", "Parked", "Pending", "Reserved", "Reverted", "Suspended", "Transferred", "Unknown",
     "Unlocked", "Unparked", "Updated", "JsonConverterFailed".
    :vartype registration_status: str or ~azure.mgmt.web.v2019_08_01.models.DomainStatus
    :ivar provisioning_state: Domain provisioning state. Possible values include: "Succeeded",
     "Failed", "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2019_08_01.models.ProvisioningState
    :ivar name_servers: Name servers.
    :vartype name_servers: list[str]
    :param privacy: :code:`<code>true</code>` if domain privacy is enabled for this domain;
     otherwise, :code:`<code>false</code>`.
    :type privacy: bool
    :ivar created_time: Domain creation timestamp.
    :vartype created_time: ~datetime.datetime
    :ivar expiration_time: Domain expiration timestamp.
    :vartype expiration_time: ~datetime.datetime
    :ivar last_renewed_time: Timestamp when the domain was renewed last time.
    :vartype last_renewed_time: ~datetime.datetime
    :param auto_renew: :code:`<code>true</code>` if the domain should be automatically renewed;
     otherwise, :code:`<code>false</code>`.
    :type auto_renew: bool
    :ivar ready_for_dns_record_management: :code:`<code>true</code>` if Azure can assign this
     domain to App Service apps; otherwise, :code:`<code>false</code>`. This value will be
     :code:`<code>true</code>` if domain registration status is active and
      it is hosted on name servers Azure has programmatic access to.
    :vartype ready_for_dns_record_management: bool
    :ivar managed_host_names: All hostnames derived from the domain and assigned to Azure
     resources.
    :vartype managed_host_names: list[~azure.mgmt.web.v2019_08_01.models.HostName]
    :param consent: Legal agreement consent.
    :type consent: ~azure.mgmt.web.v2019_08_01.models.DomainPurchaseConsent
    :ivar domain_not_renewable_reasons: Reasons why domain is not renewable.
    :vartype domain_not_renewable_reasons: list[str or
     ~azure.mgmt.web.v2019_08_01.models.DomainPropertiesDomainNotRenewableReasonsItem]
    :param dns_type: Current DNS type. Possible values include: "AzureDns",
     "DefaultDomainRegistrarDns".
    :type dns_type: str or ~azure.mgmt.web.v2019_08_01.models.DnsType
    :param dns_zone_id: Azure DNS Zone to use.
    :type dns_zone_id: str
    :param target_dns_type: Target DNS type (would be used for migration). Possible values include:
     "AzureDns", "DefaultDomainRegistrarDns".
    :type target_dns_type: str or ~azure.mgmt.web.v2019_08_01.models.DnsType
    :param auth_code:
    :type auth_code: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'registration_status': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'name_servers': {'readonly': True},
        'created_time': {'readonly': True},
        'expiration_time': {'readonly': True},
        'last_renewed_time': {'readonly': True},
        'ready_for_dns_record_management': {'readonly': True},
        'managed_host_names': {'readonly': True},
        'domain_not_renewable_reasons': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'contact_admin': {'key': 'properties.contactAdmin', 'type': 'Contact'},
        'contact_billing': {'key': 'properties.contactBilling', 'type': 'Contact'},
        'contact_registrant': {'key': 'properties.contactRegistrant', 'type': 'Contact'},
        'contact_tech': {'key': 'properties.contactTech', 'type': 'Contact'},
        'registration_status': {'key': 'properties.registrationStatus', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name_servers': {'key': 'properties.nameServers', 'type': '[str]'},
        'privacy': {'key': 'properties.privacy', 'type': 'bool'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'expiration_time': {'key': 'properties.expirationTime', 'type': 'iso-8601'},
        'last_renewed_time': {'key': 'properties.lastRenewedTime', 'type': 'iso-8601'},
        'auto_renew': {'key': 'properties.autoRenew', 'type': 'bool'},
        'ready_for_dns_record_management': {'key': 'properties.readyForDnsRecordManagement', 'type': 'bool'},
        'managed_host_names': {'key': 'properties.managedHostNames', 'type': '[HostName]'},
        'consent': {'key': 'properties.consent', 'type': 'DomainPurchaseConsent'},
        'domain_not_renewable_reasons': {'key': 'properties.domainNotRenewableReasons', 'type': '[str]'},
        'dns_type': {'key': 'properties.dnsType', 'type': 'str'},
        'dns_zone_id': {'key': 'properties.dnsZoneId', 'type': 'str'},
        'target_dns_type': {'key': 'properties.targetDnsType', 'type': 'str'},
        'auth_code': {'key': 'properties.authCode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        contact_admin: Optional["Contact"] = None,
        contact_billing: Optional["Contact"] = None,
        contact_registrant: Optional["Contact"] = None,
        contact_tech: Optional["Contact"] = None,
        privacy: Optional[bool] = None,
        auto_renew: Optional[bool] = True,
        consent: Optional["DomainPurchaseConsent"] = None,
        dns_type: Optional[Union[str, "DnsType"]] = None,
        dns_zone_id: Optional[str] = None,
        target_dns_type: Optional[Union[str, "DnsType"]] = None,
        auth_code: Optional[str] = None,
        **kwargs
    ):
        super(Domain, self).__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.contact_admin = contact_admin
        self.contact_billing = contact_billing
        self.contact_registrant = contact_registrant
        self.contact_tech = contact_tech
        self.registration_status = None
        self.provisioning_state = None
        self.name_servers = None
        self.privacy = privacy
        self.created_time = None
        self.expiration_time = None
        self.last_renewed_time = None
        self.auto_renew = auto_renew
        self.ready_for_dns_record_management = None
        self.managed_host_names = None
        self.consent = consent
        self.domain_not_renewable_reasons = None
        self.dns_type = dns_type
        self.dns_zone_id = dns_zone_id
        self.target_dns_type = target_dns_type
        self.auth_code = auth_code


class DomainAvailabilityCheckResult(msrest.serialization.Model):
    """Domain availability check result.

    :param name: Name of the domain.
    :type name: str
    :param available: :code:`<code>true</code>` if domain can be purchased using CreateDomain API;
     otherwise, :code:`<code>false</code>`.
    :type available: bool
    :param domain_type: Valid values are Regular domain: Azure will charge the full price of domain
     registration, SoftDeleted: Purchasing this domain will simply restore it and this operation
     will not cost anything. Possible values include: "Regular", "SoftDeleted".
    :type domain_type: str or ~azure.mgmt.web.v2019_08_01.models.DomainType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'available': {'key': 'available', 'type': 'bool'},
        'domain_type': {'key': 'domainType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        available: Optional[bool] = None,
        domain_type: Optional[Union[str, "DomainType"]] = None,
        **kwargs
    ):
        super(DomainAvailabilityCheckResult, self).__init__(**kwargs)
        self.name = name
        self.available = available
        self.domain_type = domain_type


class DomainCollection(msrest.serialization.Model):
    """Collection of domains.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.Domain]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Domain]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["Domain"],
        **kwargs
    ):
        super(DomainCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class DomainControlCenterSsoRequest(msrest.serialization.Model):
    """Single sign-on request information for domain management.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar url: URL where the single sign-on request is to be made.
    :vartype url: str
    :ivar post_parameter_key: Post parameter key.
    :vartype post_parameter_key: str
    :ivar post_parameter_value: Post parameter value. Client should use
     'application/x-www-form-urlencoded' encoding for this value.
    :vartype post_parameter_value: str
    """

    _validation = {
        'url': {'readonly': True},
        'post_parameter_key': {'readonly': True},
        'post_parameter_value': {'readonly': True},
    }

    _attribute_map = {
        'url': {'key': 'url', 'type': 'str'},
        'post_parameter_key': {'key': 'postParameterKey', 'type': 'str'},
        'post_parameter_value': {'key': 'postParameterValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DomainControlCenterSsoRequest, self).__init__(**kwargs)
        self.url = None
        self.post_parameter_key = None
        self.post_parameter_value = None


class DomainOwnershipIdentifier(ProxyOnlyResource):
    """Domain ownership Identifier.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param ownership_id: Ownership Id.
    :type ownership_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'ownership_id': {'key': 'properties.ownershipId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        ownership_id: Optional[str] = None,
        **kwargs
    ):
        super(DomainOwnershipIdentifier, self).__init__(kind=kind, **kwargs)
        self.ownership_id = ownership_id


class DomainOwnershipIdentifierCollection(msrest.serialization.Model):
    """Collection of domain ownership identifiers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.DomainOwnershipIdentifier]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DomainOwnershipIdentifier]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["DomainOwnershipIdentifier"],
        **kwargs
    ):
        super(DomainOwnershipIdentifierCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class DomainPatchResource(ProxyOnlyResource):
    """ARM resource for a domain.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param contact_admin: Administrative contact.
    :type contact_admin: ~azure.mgmt.web.v2019_08_01.models.Contact
    :param contact_billing: Billing contact.
    :type contact_billing: ~azure.mgmt.web.v2019_08_01.models.Contact
    :param contact_registrant: Registrant contact.
    :type contact_registrant: ~azure.mgmt.web.v2019_08_01.models.Contact
    :param contact_tech: Technical contact.
    :type contact_tech: ~azure.mgmt.web.v2019_08_01.models.Contact
    :ivar registration_status: Domain registration status. Possible values include: "Active",
     "Awaiting", "Cancelled", "Confiscated", "Disabled", "Excluded", "Expired", "Failed", "Held",
     "Locked", "Parked", "Pending", "Reserved", "Reverted", "Suspended", "Transferred", "Unknown",
     "Unlocked", "Unparked", "Updated", "JsonConverterFailed".
    :vartype registration_status: str or ~azure.mgmt.web.v2019_08_01.models.DomainStatus
    :ivar provisioning_state: Domain provisioning state. Possible values include: "Succeeded",
     "Failed", "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2019_08_01.models.ProvisioningState
    :ivar name_servers: Name servers.
    :vartype name_servers: list[str]
    :param privacy: :code:`<code>true</code>` if domain privacy is enabled for this domain;
     otherwise, :code:`<code>false</code>`.
    :type privacy: bool
    :ivar created_time: Domain creation timestamp.
    :vartype created_time: ~datetime.datetime
    :ivar expiration_time: Domain expiration timestamp.
    :vartype expiration_time: ~datetime.datetime
    :ivar last_renewed_time: Timestamp when the domain was renewed last time.
    :vartype last_renewed_time: ~datetime.datetime
    :param auto_renew: :code:`<code>true</code>` if the domain should be automatically renewed;
     otherwise, :code:`<code>false</code>`.
    :type auto_renew: bool
    :ivar ready_for_dns_record_management: :code:`<code>true</code>` if Azure can assign this
     domain to App Service apps; otherwise, :code:`<code>false</code>`. This value will be
     :code:`<code>true</code>` if domain registration status is active and
      it is hosted on name servers Azure has programmatic access to.
    :vartype ready_for_dns_record_management: bool
    :ivar managed_host_names: All hostnames derived from the domain and assigned to Azure
     resources.
    :vartype managed_host_names: list[~azure.mgmt.web.v2019_08_01.models.HostName]
    :param consent: Legal agreement consent.
    :type consent: ~azure.mgmt.web.v2019_08_01.models.DomainPurchaseConsent
    :ivar domain_not_renewable_reasons: Reasons why domain is not renewable.
    :vartype domain_not_renewable_reasons: list[str or
     ~azure.mgmt.web.v2019_08_01.models.DomainPatchResourcePropertiesDomainNotRenewableReasonsItem]
    :param dns_type: Current DNS type. Possible values include: "AzureDns",
     "DefaultDomainRegistrarDns".
    :type dns_type: str or ~azure.mgmt.web.v2019_08_01.models.DnsType
    :param dns_zone_id: Azure DNS Zone to use.
    :type dns_zone_id: str
    :param target_dns_type: Target DNS type (would be used for migration). Possible values include:
     "AzureDns", "DefaultDomainRegistrarDns".
    :type target_dns_type: str or ~azure.mgmt.web.v2019_08_01.models.DnsType
    :param auth_code:
    :type auth_code: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'registration_status': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'name_servers': {'readonly': True},
        'created_time': {'readonly': True},
        'expiration_time': {'readonly': True},
        'last_renewed_time': {'readonly': True},
        'ready_for_dns_record_management': {'readonly': True},
        'managed_host_names': {'readonly': True},
        'domain_not_renewable_reasons': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'contact_admin': {'key': 'properties.contactAdmin', 'type': 'Contact'},
        'contact_billing': {'key': 'properties.contactBilling', 'type': 'Contact'},
        'contact_registrant': {'key': 'properties.contactRegistrant', 'type': 'Contact'},
        'contact_tech': {'key': 'properties.contactTech', 'type': 'Contact'},
        'registration_status': {'key': 'properties.registrationStatus', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name_servers': {'key': 'properties.nameServers', 'type': '[str]'},
        'privacy': {'key': 'properties.privacy', 'type': 'bool'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'expiration_time': {'key': 'properties.expirationTime', 'type': 'iso-8601'},
        'last_renewed_time': {'key': 'properties.lastRenewedTime', 'type': 'iso-8601'},
        'auto_renew': {'key': 'properties.autoRenew', 'type': 'bool'},
        'ready_for_dns_record_management': {'key': 'properties.readyForDnsRecordManagement', 'type': 'bool'},
        'managed_host_names': {'key': 'properties.managedHostNames', 'type': '[HostName]'},
        'consent': {'key': 'properties.consent', 'type': 'DomainPurchaseConsent'},
        'domain_not_renewable_reasons': {'key': 'properties.domainNotRenewableReasons', 'type': '[str]'},
        'dns_type': {'key': 'properties.dnsType', 'type': 'str'},
        'dns_zone_id': {'key': 'properties.dnsZoneId', 'type': 'str'},
        'target_dns_type': {'key': 'properties.targetDnsType', 'type': 'str'},
        'auth_code': {'key': 'properties.authCode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        contact_admin: Optional["Contact"] = None,
        contact_billing: Optional["Contact"] = None,
        contact_registrant: Optional["Contact"] = None,
        contact_tech: Optional["Contact"] = None,
        privacy: Optional[bool] = None,
        auto_renew: Optional[bool] = True,
        consent: Optional["DomainPurchaseConsent"] = None,
        dns_type: Optional[Union[str, "DnsType"]] = None,
        dns_zone_id: Optional[str] = None,
        target_dns_type: Optional[Union[str, "DnsType"]] = None,
        auth_code: Optional[str] = None,
        **kwargs
    ):
        super(DomainPatchResource, self).__init__(kind=kind, **kwargs)
        self.contact_admin = contact_admin
        self.contact_billing = contact_billing
        self.contact_registrant = contact_registrant
        self.contact_tech = contact_tech
        self.registration_status = None
        self.provisioning_state = None
        self.name_servers = None
        self.privacy = privacy
        self.created_time = None
        self.expiration_time = None
        self.last_renewed_time = None
        self.auto_renew = auto_renew
        self.ready_for_dns_record_management = None
        self.managed_host_names = None
        self.consent = consent
        self.domain_not_renewable_reasons = None
        self.dns_type = dns_type
        self.dns_zone_id = dns_zone_id
        self.target_dns_type = target_dns_type
        self.auth_code = auth_code


class DomainPurchaseConsent(msrest.serialization.Model):
    """Domain purchase consent object, representing acceptance of applicable legal agreements.

    :param agreement_keys: List of applicable legal agreement keys. This list can be retrieved
     using ListLegalAgreements API under :code:`<code>TopLevelDomain</code>` resource.
    :type agreement_keys: list[str]
    :param agreed_by: Client IP address.
    :type agreed_by: str
    :param agreed_at: Timestamp when the agreements were accepted.
    :type agreed_at: ~datetime.datetime
    """

    _attribute_map = {
        'agreement_keys': {'key': 'agreementKeys', 'type': '[str]'},
        'agreed_by': {'key': 'agreedBy', 'type': 'str'},
        'agreed_at': {'key': 'agreedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        agreement_keys: Optional[List[str]] = None,
        agreed_by: Optional[str] = None,
        agreed_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(DomainPurchaseConsent, self).__init__(**kwargs)
        self.agreement_keys = agreement_keys
        self.agreed_by = agreed_by
        self.agreed_at = agreed_at


class DomainRecommendationSearchParameters(msrest.serialization.Model):
    """Domain recommendation search parameters.

    :param keywords: Keywords to be used for generating domain recommendations.
    :type keywords: str
    :param max_domain_recommendations: Maximum number of recommendations.
    :type max_domain_recommendations: int
    """

    _attribute_map = {
        'keywords': {'key': 'keywords', 'type': 'str'},
        'max_domain_recommendations': {'key': 'maxDomainRecommendations', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        keywords: Optional[str] = None,
        max_domain_recommendations: Optional[int] = None,
        **kwargs
    ):
        super(DomainRecommendationSearchParameters, self).__init__(**kwargs)
        self.keywords = keywords
        self.max_domain_recommendations = max_domain_recommendations


class EnabledConfig(msrest.serialization.Model):
    """Enabled configuration.

    :param enabled: True if configuration is enabled, false if it is disabled and null if
     configuration is not set.
    :type enabled: bool
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        super(EnabledConfig, self).__init__(**kwargs)
        self.enabled = enabled


class EndpointDependency(msrest.serialization.Model):
    """A domain name that a service is reached at, including details of the current connection status.

    :param domain_name: The domain name of the dependency.
    :type domain_name: str
    :param endpoint_details: The IP Addresses and Ports used when connecting to DomainName.
    :type endpoint_details: list[~azure.mgmt.web.v2019_08_01.models.EndpointDetail]
    """

    _attribute_map = {
        'domain_name': {'key': 'domainName', 'type': 'str'},
        'endpoint_details': {'key': 'endpointDetails', 'type': '[EndpointDetail]'},
    }

    def __init__(
        self,
        *,
        domain_name: Optional[str] = None,
        endpoint_details: Optional[List["EndpointDetail"]] = None,
        **kwargs
    ):
        super(EndpointDependency, self).__init__(**kwargs)
        self.domain_name = domain_name
        self.endpoint_details = endpoint_details


class EndpointDetail(msrest.serialization.Model):
    """Current TCP connectivity information from the App Service Environment to a single endpoint.

    :param ip_address: An IP Address that Domain Name currently resolves to.
    :type ip_address: str
    :param port: The port an endpoint is connected to.
    :type port: int
    :param latency: The time in milliseconds it takes for a TCP connection to be created from the
     App Service Environment to this IpAddress at this Port.
    :type latency: float
    :param is_accessible: Whether it is possible to create a TCP connection from the App Service
     Environment to this IpAddress at this Port.
    :type is_accessible: bool
    """

    _attribute_map = {
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
        'latency': {'key': 'latency', 'type': 'float'},
        'is_accessible': {'key': 'isAccessible', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        ip_address: Optional[str] = None,
        port: Optional[int] = None,
        latency: Optional[float] = None,
        is_accessible: Optional[bool] = None,
        **kwargs
    ):
        super(EndpointDetail, self).__init__(**kwargs)
        self.ip_address = ip_address
        self.port = port
        self.latency = latency
        self.is_accessible = is_accessible


class ErrorEntity(msrest.serialization.Model):
    """Body of the error response returned from the API.

    :param extended_code: Type of error.
    :type extended_code: str
    :param message_template: Message template.
    :type message_template: str
    :param parameters: Parameters for the template.
    :type parameters: list[str]
    :param inner_errors: Inner errors.
    :type inner_errors: list[~azure.mgmt.web.v2019_08_01.models.ErrorEntity]
    :param code: Basic error code.
    :type code: str
    :param message: Any details of the error.
    :type message: str
    """

    _attribute_map = {
        'extended_code': {'key': 'extendedCode', 'type': 'str'},
        'message_template': {'key': 'messageTemplate', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '[str]'},
        'inner_errors': {'key': 'innerErrors', 'type': '[ErrorEntity]'},
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        extended_code: Optional[str] = None,
        message_template: Optional[str] = None,
        parameters: Optional[List[str]] = None,
        inner_errors: Optional[List["ErrorEntity"]] = None,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ErrorEntity, self).__init__(**kwargs)
        self.extended_code = extended_code
        self.message_template = message_template
        self.parameters = parameters
        self.inner_errors = inner_errors
        self.code = code
        self.message = message


class Experiments(msrest.serialization.Model):
    """Routing rules in production experiments.

    :param ramp_up_rules: List of ramp-up rules.
    :type ramp_up_rules: list[~azure.mgmt.web.v2019_08_01.models.RampUpRule]
    """

    _attribute_map = {
        'ramp_up_rules': {'key': 'rampUpRules', 'type': '[RampUpRule]'},
    }

    def __init__(
        self,
        *,
        ramp_up_rules: Optional[List["RampUpRule"]] = None,
        **kwargs
    ):
        super(Experiments, self).__init__(**kwargs)
        self.ramp_up_rules = ramp_up_rules


class FileSystemApplicationLogsConfig(msrest.serialization.Model):
    """Application logs to file system configuration.

    :param level: Log level. Possible values include: "Off", "Verbose", "Information", "Warning",
     "Error".
    :type level: str or ~azure.mgmt.web.v2019_08_01.models.LogLevel
    """

    _attribute_map = {
        'level': {'key': 'level', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        level: Optional[Union[str, "LogLevel"]] = None,
        **kwargs
    ):
        super(FileSystemApplicationLogsConfig, self).__init__(**kwargs)
        self.level = level


class FileSystemHttpLogsConfig(msrest.serialization.Model):
    """Http logs to file system configuration.

    :param retention_in_mb: Maximum size in megabytes that http log files can use.
     When reached old log files will be removed to make space for new ones.
     Value can range between 25 and 100.
    :type retention_in_mb: int
    :param retention_in_days: Retention in days.
     Remove files older than X days.
     0 or lower means no retention.
    :type retention_in_days: int
    :param enabled: True if configuration is enabled, false if it is disabled and null if
     configuration is not set.
    :type enabled: bool
    """

    _validation = {
        'retention_in_mb': {'maximum': 100, 'minimum': 25},
    }

    _attribute_map = {
        'retention_in_mb': {'key': 'retentionInMb', 'type': 'int'},
        'retention_in_days': {'key': 'retentionInDays', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        retention_in_mb: Optional[int] = None,
        retention_in_days: Optional[int] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        super(FileSystemHttpLogsConfig, self).__init__(**kwargs)
        self.retention_in_mb = retention_in_mb
        self.retention_in_days = retention_in_days
        self.enabled = enabled


class FunctionEnvelope(ProxyOnlyResource):
    """Function information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param function_app_id: Function App ID.
    :type function_app_id: str
    :param script_root_path_href: Script root path URI.
    :type script_root_path_href: str
    :param script_href: Script URI.
    :type script_href: str
    :param config_href: Config URI.
    :type config_href: str
    :param test_data_href: Test data URI.
    :type test_data_href: str
    :param secrets_file_href: Secrets file URI.
    :type secrets_file_href: str
    :param href: Function URI.
    :type href: str
    :param config: Config information.
    :type config: any
    :param files: File list.
    :type files: dict[str, str]
    :param test_data: Test data used when testing via the Azure Portal.
    :type test_data: str
    :param invoke_url_template: The invocation URL.
    :type invoke_url_template: str
    :param language: The function language.
    :type language: str
    :param is_disabled: Gets or sets a value indicating whether the function is disabled.
    :type is_disabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'function_app_id': {'key': 'properties.function_app_id', 'type': 'str'},
        'script_root_path_href': {'key': 'properties.script_root_path_href', 'type': 'str'},
        'script_href': {'key': 'properties.script_href', 'type': 'str'},
        'config_href': {'key': 'properties.config_href', 'type': 'str'},
        'test_data_href': {'key': 'properties.test_data_href', 'type': 'str'},
        'secrets_file_href': {'key': 'properties.secrets_file_href', 'type': 'str'},
        'href': {'key': 'properties.href', 'type': 'str'},
        'config': {'key': 'properties.config', 'type': 'object'},
        'files': {'key': 'properties.files', 'type': '{str}'},
        'test_data': {'key': 'properties.test_data', 'type': 'str'},
        'invoke_url_template': {'key': 'properties.invoke_url_template', 'type': 'str'},
        'language': {'key': 'properties.language', 'type': 'str'},
        'is_disabled': {'key': 'properties.isDisabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        function_app_id: Optional[str] = None,
        script_root_path_href: Optional[str] = None,
        script_href: Optional[str] = None,
        config_href: Optional[str] = None,
        test_data_href: Optional[str] = None,
        secrets_file_href: Optional[str] = None,
        href: Optional[str] = None,
        config: Optional[Any] = None,
        files: Optional[Dict[str, str]] = None,
        test_data: Optional[str] = None,
        invoke_url_template: Optional[str] = None,
        language: Optional[str] = None,
        is_disabled: Optional[bool] = None,
        **kwargs
    ):
        super(FunctionEnvelope, self).__init__(kind=kind, **kwargs)
        self.function_app_id = function_app_id
        self.script_root_path_href = script_root_path_href
        self.script_href = script_href
        self.config_href = config_href
        self.test_data_href = test_data_href
        self.secrets_file_href = secrets_file_href
        self.href = href
        self.config = config
        self.files = files
        self.test_data = test_data
        self.invoke_url_template = invoke_url_template
        self.language = language
        self.is_disabled = is_disabled


class FunctionEnvelopeCollection(msrest.serialization.Model):
    """Collection of Kudu function information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.FunctionEnvelope]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FunctionEnvelope]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["FunctionEnvelope"],
        **kwargs
    ):
        super(FunctionEnvelopeCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class FunctionSecrets(ProxyOnlyResource):
    """Function secrets.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param key: Secret key.
    :type key: str
    :param trigger_url: Trigger URL.
    :type trigger_url: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'key': {'key': 'properties.key', 'type': 'str'},
        'trigger_url': {'key': 'properties.trigger_url', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        key: Optional[str] = None,
        trigger_url: Optional[str] = None,
        **kwargs
    ):
        super(FunctionSecrets, self).__init__(kind=kind, **kwargs)
        self.key = key
        self.trigger_url = trigger_url


class GeoRegion(ProxyOnlyResource):
    """Geographical region.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar description: Region description.
    :vartype description: str
    :ivar display_name: Display name for region.
    :vartype display_name: str
    :ivar org_domain: Display name for region.
    :vartype org_domain: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'readonly': True},
        'display_name': {'readonly': True},
        'org_domain': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'org_domain': {'key': 'properties.orgDomain', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        super(GeoRegion, self).__init__(kind=kind, **kwargs)
        self.description = None
        self.display_name = None
        self.org_domain = None


class GeoRegionCollection(msrest.serialization.Model):
    """Collection of geographical regions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.GeoRegion]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GeoRegion]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["GeoRegion"],
        **kwargs
    ):
        super(GeoRegionCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class GlobalCsmSkuDescription(msrest.serialization.Model):
    """A Global SKU Description.

    :param name: Name of the resource SKU.
    :type name: str
    :param tier: Service Tier of the resource SKU.
    :type tier: str
    :param size: Size specifier of the resource SKU.
    :type size: str
    :param family: Family code of the resource SKU.
    :type family: str
    :param capacity: Min, max, and default scale values of the SKU.
    :type capacity: ~azure.mgmt.web.v2019_08_01.models.SkuCapacity
    :param locations: Locations of the SKU.
    :type locations: list[str]
    :param capabilities: Capabilities of the SKU, e.g., is traffic manager enabled?.
    :type capabilities: list[~azure.mgmt.web.v2019_08_01.models.Capability]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'SkuCapacity'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'capabilities': {'key': 'capabilities', 'type': '[Capability]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tier: Optional[str] = None,
        size: Optional[str] = None,
        family: Optional[str] = None,
        capacity: Optional["SkuCapacity"] = None,
        locations: Optional[List[str]] = None,
        capabilities: Optional[List["Capability"]] = None,
        **kwargs
    ):
        super(GlobalCsmSkuDescription, self).__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.size = size
        self.family = family
        self.capacity = capacity
        self.locations = locations
        self.capabilities = capabilities


class HandlerMapping(msrest.serialization.Model):
    """The IIS handler mappings used to define which handler processes HTTP requests with certain extension. 
For example, it is used to configure php-cgi.exe process to handle all HTTP requests with *.php extension.

    :param extension: Requests with this extension will be handled using the specified FastCGI
     application.
    :type extension: str
    :param script_processor: The absolute path to the FastCGI application.
    :type script_processor: str
    :param arguments: Command-line arguments to be passed to the script processor.
    :type arguments: str
    """

    _attribute_map = {
        'extension': {'key': 'extension', 'type': 'str'},
        'script_processor': {'key': 'scriptProcessor', 'type': 'str'},
        'arguments': {'key': 'arguments', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        extension: Optional[str] = None,
        script_processor: Optional[str] = None,
        arguments: Optional[str] = None,
        **kwargs
    ):
        super(HandlerMapping, self).__init__(**kwargs)
        self.extension = extension
        self.script_processor = script_processor
        self.arguments = arguments


class HostingEnvironmentDeploymentInfo(msrest.serialization.Model):
    """Information needed to create resources on an App Service Environment.

    :param name: Name of the App Service Environment.
    :type name: str
    :param location: Location of the App Service Environment.
    :type location: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        location: Optional[str] = None,
        **kwargs
    ):
        super(HostingEnvironmentDeploymentInfo, self).__init__(**kwargs)
        self.name = name
        self.location = location


class HostingEnvironmentDiagnostics(msrest.serialization.Model):
    """Diagnostics for an App Service Environment.

    :param name: Name/identifier of the diagnostics.
    :type name: str
    :param diagnostics_output: Diagnostics output.
    :type diagnostics_output: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'diagnostics_output': {'key': 'diagnosticsOutput', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        diagnostics_output: Optional[str] = None,
        **kwargs
    ):
        super(HostingEnvironmentDiagnostics, self).__init__(**kwargs)
        self.name = name
        self.diagnostics_output = diagnostics_output


class HostingEnvironmentProfile(msrest.serialization.Model):
    """Specification for an App Service Environment to use for this resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID of the App Service Environment.
    :type id: str
    :ivar name: Name of the App Service Environment.
    :vartype name: str
    :ivar type: Resource type of the App Service Environment.
    :vartype type: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(HostingEnvironmentProfile, self).__init__(**kwargs)
        self.id = id
        self.name = None
        self.type = None


class HostKeys(msrest.serialization.Model):
    """Functions host level keys.

    :param master_key: Secret key.
    :type master_key: str
    :param function_keys: Host level function keys.
    :type function_keys: dict[str, str]
    :param system_keys: System keys.
    :type system_keys: dict[str, str]
    """

    _attribute_map = {
        'master_key': {'key': 'masterKey', 'type': 'str'},
        'function_keys': {'key': 'functionKeys', 'type': '{str}'},
        'system_keys': {'key': 'systemKeys', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        master_key: Optional[str] = None,
        function_keys: Optional[Dict[str, str]] = None,
        system_keys: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(HostKeys, self).__init__(**kwargs)
        self.master_key = master_key
        self.function_keys = function_keys
        self.system_keys = system_keys


class HostName(msrest.serialization.Model):
    """Details of a hostname derived from a domain.

    :param name: Name of the hostname.
    :type name: str
    :param site_names: List of apps the hostname is assigned to. This list will have more than one
     app only if the hostname is pointing to a Traffic Manager.
    :type site_names: list[str]
    :param azure_resource_name: Name of the Azure resource the hostname is assigned to. If it is
     assigned to a Traffic Manager then it will be the Traffic Manager name otherwise it will be the
     app name.
    :type azure_resource_name: str
    :param azure_resource_type: Type of the Azure resource the hostname is assigned to. Possible
     values include: "Website", "TrafficManager".
    :type azure_resource_type: str or ~azure.mgmt.web.v2019_08_01.models.AzureResourceType
    :param custom_host_name_dns_record_type: Type of the DNS record. Possible values include:
     "CName", "A".
    :type custom_host_name_dns_record_type: str or
     ~azure.mgmt.web.v2019_08_01.models.CustomHostNameDnsRecordType
    :param host_name_type: Type of the hostname. Possible values include: "Verified", "Managed".
    :type host_name_type: str or ~azure.mgmt.web.v2019_08_01.models.HostNameType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'site_names': {'key': 'siteNames', 'type': '[str]'},
        'azure_resource_name': {'key': 'azureResourceName', 'type': 'str'},
        'azure_resource_type': {'key': 'azureResourceType', 'type': 'str'},
        'custom_host_name_dns_record_type': {'key': 'customHostNameDnsRecordType', 'type': 'str'},
        'host_name_type': {'key': 'hostNameType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        site_names: Optional[List[str]] = None,
        azure_resource_name: Optional[str] = None,
        azure_resource_type: Optional[Union[str, "AzureResourceType"]] = None,
        custom_host_name_dns_record_type: Optional[Union[str, "CustomHostNameDnsRecordType"]] = None,
        host_name_type: Optional[Union[str, "HostNameType"]] = None,
        **kwargs
    ):
        super(HostName, self).__init__(**kwargs)
        self.name = name
        self.site_names = site_names
        self.azure_resource_name = azure_resource_name
        self.azure_resource_type = azure_resource_type
        self.custom_host_name_dns_record_type = custom_host_name_dns_record_type
        self.host_name_type = host_name_type


class HostNameBinding(ProxyOnlyResource):
    """A hostname binding object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param site_name: App Service app name.
    :type site_name: str
    :param domain_id: Fully qualified ARM domain resource URI.
    :type domain_id: str
    :param azure_resource_name: Azure resource name.
    :type azure_resource_name: str
    :param azure_resource_type: Azure resource type. Possible values include: "Website",
     "TrafficManager".
    :type azure_resource_type: str or ~azure.mgmt.web.v2019_08_01.models.AzureResourceType
    :param custom_host_name_dns_record_type: Custom DNS record type. Possible values include:
     "CName", "A".
    :type custom_host_name_dns_record_type: str or
     ~azure.mgmt.web.v2019_08_01.models.CustomHostNameDnsRecordType
    :param host_name_type: Hostname type. Possible values include: "Verified", "Managed".
    :type host_name_type: str or ~azure.mgmt.web.v2019_08_01.models.HostNameType
    :param ssl_state: SSL type. Possible values include: "Disabled", "SniEnabled",
     "IpBasedEnabled".
    :type ssl_state: str or ~azure.mgmt.web.v2019_08_01.models.SslState
    :param thumbprint: SSL certificate thumbprint.
    :type thumbprint: str
    :ivar virtual_ip: Virtual IP address assigned to the hostname if IP based SSL is enabled.
    :vartype virtual_ip: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'virtual_ip': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'site_name': {'key': 'properties.siteName', 'type': 'str'},
        'domain_id': {'key': 'properties.domainId', 'type': 'str'},
        'azure_resource_name': {'key': 'properties.azureResourceName', 'type': 'str'},
        'azure_resource_type': {'key': 'properties.azureResourceType', 'type': 'str'},
        'custom_host_name_dns_record_type': {'key': 'properties.customHostNameDnsRecordType', 'type': 'str'},
        'host_name_type': {'key': 'properties.hostNameType', 'type': 'str'},
        'ssl_state': {'key': 'properties.sslState', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'virtual_ip': {'key': 'properties.virtualIP', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        site_name: Optional[str] = None,
        domain_id: Optional[str] = None,
        azure_resource_name: Optional[str] = None,
        azure_resource_type: Optional[Union[str, "AzureResourceType"]] = None,
        custom_host_name_dns_record_type: Optional[Union[str, "CustomHostNameDnsRecordType"]] = None,
        host_name_type: Optional[Union[str, "HostNameType"]] = None,
        ssl_state: Optional[Union[str, "SslState"]] = None,
        thumbprint: Optional[str] = None,
        **kwargs
    ):
        super(HostNameBinding, self).__init__(kind=kind, **kwargs)
        self.site_name = site_name
        self.domain_id = domain_id
        self.azure_resource_name = azure_resource_name
        self.azure_resource_type = azure_resource_type
        self.custom_host_name_dns_record_type = custom_host_name_dns_record_type
        self.host_name_type = host_name_type
        self.ssl_state = ssl_state
        self.thumbprint = thumbprint
        self.virtual_ip = None


class HostNameBindingCollection(msrest.serialization.Model):
    """Collection of hostname bindings.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.HostNameBinding]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[HostNameBinding]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["HostNameBinding"],
        **kwargs
    ):
        super(HostNameBindingCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class HostNameSslState(msrest.serialization.Model):
    """SSL-enabled hostname.

    :param name: Hostname.
    :type name: str
    :param ssl_state: SSL type. Possible values include: "Disabled", "SniEnabled",
     "IpBasedEnabled".
    :type ssl_state: str or ~azure.mgmt.web.v2019_08_01.models.SslState
    :param virtual_ip: Virtual IP address assigned to the hostname if IP based SSL is enabled.
    :type virtual_ip: str
    :param thumbprint: SSL certificate thumbprint.
    :type thumbprint: str
    :param to_update: Set to :code:`<code>true</code>` to update existing hostname.
    :type to_update: bool
    :param host_type: Indicates whether the hostname is a standard or repository hostname. Possible
     values include: "Standard", "Repository".
    :type host_type: str or ~azure.mgmt.web.v2019_08_01.models.HostType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'ssl_state': {'key': 'sslState', 'type': 'str'},
        'virtual_ip': {'key': 'virtualIP', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'to_update': {'key': 'toUpdate', 'type': 'bool'},
        'host_type': {'key': 'hostType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        ssl_state: Optional[Union[str, "SslState"]] = None,
        virtual_ip: Optional[str] = None,
        thumbprint: Optional[str] = None,
        to_update: Optional[bool] = None,
        host_type: Optional[Union[str, "HostType"]] = None,
        **kwargs
    ):
        super(HostNameSslState, self).__init__(**kwargs)
        self.name = name
        self.ssl_state = ssl_state
        self.virtual_ip = virtual_ip
        self.thumbprint = thumbprint
        self.to_update = to_update
        self.host_type = host_type


class HttpLogsConfig(msrest.serialization.Model):
    """Http logs configuration.

    :param file_system: Http logs to file system configuration.
    :type file_system: ~azure.mgmt.web.v2019_08_01.models.FileSystemHttpLogsConfig
    :param azure_blob_storage: Http logs to azure blob storage configuration.
    :type azure_blob_storage: ~azure.mgmt.web.v2019_08_01.models.AzureBlobStorageHttpLogsConfig
    """

    _attribute_map = {
        'file_system': {'key': 'fileSystem', 'type': 'FileSystemHttpLogsConfig'},
        'azure_blob_storage': {'key': 'azureBlobStorage', 'type': 'AzureBlobStorageHttpLogsConfig'},
    }

    def __init__(
        self,
        *,
        file_system: Optional["FileSystemHttpLogsConfig"] = None,
        azure_blob_storage: Optional["AzureBlobStorageHttpLogsConfig"] = None,
        **kwargs
    ):
        super(HttpLogsConfig, self).__init__(**kwargs)
        self.file_system = file_system
        self.azure_blob_storage = azure_blob_storage


class HybridConnection(ProxyOnlyResource):
    """Hybrid Connection contract. This is used to configure a Hybrid Connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param service_bus_namespace: The name of the Service Bus namespace.
    :type service_bus_namespace: str
    :param relay_name: The name of the Service Bus relay.
    :type relay_name: str
    :param relay_arm_uri: The ARM URI to the Service Bus relay.
    :type relay_arm_uri: str
    :param hostname: The hostname of the endpoint.
    :type hostname: str
    :param port: The port of the endpoint.
    :type port: int
    :param send_key_name: The name of the Service Bus key which has Send permissions. This is used
     to authenticate to Service Bus.
    :type send_key_name: str
    :param send_key_value: The value of the Service Bus key. This is used to authenticate to
     Service Bus. In ARM this key will not be returned
     normally, use the POST /listKeys API instead.
    :type send_key_value: str
    :param service_bus_suffix: The suffix for the service bus endpoint. By default this is
     .servicebus.windows.net.
    :type service_bus_suffix: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'service_bus_namespace': {'key': 'properties.serviceBusNamespace', 'type': 'str'},
        'relay_name': {'key': 'properties.relayName', 'type': 'str'},
        'relay_arm_uri': {'key': 'properties.relayArmUri', 'type': 'str'},
        'hostname': {'key': 'properties.hostname', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'send_key_name': {'key': 'properties.sendKeyName', 'type': 'str'},
        'send_key_value': {'key': 'properties.sendKeyValue', 'type': 'str'},
        'service_bus_suffix': {'key': 'properties.serviceBusSuffix', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        service_bus_namespace: Optional[str] = None,
        relay_name: Optional[str] = None,
        relay_arm_uri: Optional[str] = None,
        hostname: Optional[str] = None,
        port: Optional[int] = None,
        send_key_name: Optional[str] = None,
        send_key_value: Optional[str] = None,
        service_bus_suffix: Optional[str] = None,
        **kwargs
    ):
        super(HybridConnection, self).__init__(kind=kind, **kwargs)
        self.service_bus_namespace = service_bus_namespace
        self.relay_name = relay_name
        self.relay_arm_uri = relay_arm_uri
        self.hostname = hostname
        self.port = port
        self.send_key_name = send_key_name
        self.send_key_value = send_key_value
        self.service_bus_suffix = service_bus_suffix


class HybridConnectionCollection(msrest.serialization.Model):
    """Collection of hostname bindings.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.HybridConnection]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[HybridConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["HybridConnection"],
        **kwargs
    ):
        super(HybridConnectionCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class HybridConnectionKey(ProxyOnlyResource):
    """Hybrid Connection key contract. This has the send key name and value for a Hybrid Connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar send_key_name: The name of the send key.
    :vartype send_key_name: str
    :ivar send_key_value: The value of the send key.
    :vartype send_key_value: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'send_key_name': {'readonly': True},
        'send_key_value': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'send_key_name': {'key': 'properties.sendKeyName', 'type': 'str'},
        'send_key_value': {'key': 'properties.sendKeyValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        super(HybridConnectionKey, self).__init__(kind=kind, **kwargs)
        self.send_key_name = None
        self.send_key_value = None


class HybridConnectionLimits(ProxyOnlyResource):
    """Hybrid Connection limits contract. This is used to return the plan limits of Hybrid Connections.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar current: The current number of Hybrid Connections.
    :vartype current: int
    :ivar maximum: The maximum number of Hybrid Connections allowed.
    :vartype maximum: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'current': {'readonly': True},
        'maximum': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'current': {'key': 'properties.current', 'type': 'int'},
        'maximum': {'key': 'properties.maximum', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        super(HybridConnectionLimits, self).__init__(kind=kind, **kwargs)
        self.current = None
        self.maximum = None


class Identifier(ProxyOnlyResource):
    """A domain specific resource identifier.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param value: String representation of the identity.
    :type value: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'properties.id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        super(Identifier, self).__init__(kind=kind, **kwargs)
        self.value = value


class IdentifierCollection(msrest.serialization.Model):
    """Collection of identifiers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.Identifier]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Identifier]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["Identifier"],
        **kwargs
    ):
        super(IdentifierCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class InboundEnvironmentEndpoint(msrest.serialization.Model):
    """The IP Addresses and Ports that require inbound network access to and within the subnet of the App Service Environment.

    :param description: Short text describing the purpose of the network traffic.
    :type description: str
    :param endpoints: The IP addresses that network traffic will originate from in cidr notation.
    :type endpoints: list[str]
    :param ports: The ports that network traffic will arrive to the App Service Environment at.
    :type ports: list[str]
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'endpoints': {'key': 'endpoints', 'type': '[str]'},
        'ports': {'key': 'ports', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        endpoints: Optional[List[str]] = None,
        ports: Optional[List[str]] = None,
        **kwargs
    ):
        super(InboundEnvironmentEndpoint, self).__init__(**kwargs)
        self.description = description
        self.endpoints = endpoints
        self.ports = ports


class InboundEnvironmentEndpointCollection(msrest.serialization.Model):
    """Collection of Inbound Environment Endpoints.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.InboundEnvironmentEndpoint]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[InboundEnvironmentEndpoint]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["InboundEnvironmentEndpoint"],
        **kwargs
    ):
        super(InboundEnvironmentEndpointCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class IpSecurityRestriction(msrest.serialization.Model):
    """IP security restriction on an app.

    :param ip_address: IP address the security restriction is valid for.
     It can be in form of pure ipv4 address (required SubnetMask property) or
     CIDR notation such as ipv4/mask (leading bit match). For CIDR,
     SubnetMask property must not be specified.
    :type ip_address: str
    :param subnet_mask: Subnet mask for the range of IP addresses the restriction is valid for.
    :type subnet_mask: str
    :param vnet_subnet_resource_id: Virtual network resource id.
    :type vnet_subnet_resource_id: str
    :param vnet_traffic_tag: (internal) Vnet traffic tag.
    :type vnet_traffic_tag: int
    :param subnet_traffic_tag: (internal) Subnet traffic tag.
    :type subnet_traffic_tag: int
    :param action: Allow or Deny access for this IP range.
    :type action: str
    :param tag: Defines what this IP filter will be used for. This is to support IP filtering on
     proxies. Possible values include: "Default", "XffProxy".
    :type tag: str or ~azure.mgmt.web.v2019_08_01.models.IpFilterTag
    :param priority: Priority of IP restriction rule.
    :type priority: int
    :param name: IP restriction rule name.
    :type name: str
    :param description: IP restriction rule description.
    :type description: str
    """

    _attribute_map = {
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'subnet_mask': {'key': 'subnetMask', 'type': 'str'},
        'vnet_subnet_resource_id': {'key': 'vnetSubnetResourceId', 'type': 'str'},
        'vnet_traffic_tag': {'key': 'vnetTrafficTag', 'type': 'int'},
        'subnet_traffic_tag': {'key': 'subnetTrafficTag', 'type': 'int'},
        'action': {'key': 'action', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ip_address: Optional[str] = None,
        subnet_mask: Optional[str] = None,
        vnet_subnet_resource_id: Optional[str] = None,
        vnet_traffic_tag: Optional[int] = None,
        subnet_traffic_tag: Optional[int] = None,
        action: Optional[str] = None,
        tag: Optional[Union[str, "IpFilterTag"]] = None,
        priority: Optional[int] = None,
        name: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(IpSecurityRestriction, self).__init__(**kwargs)
        self.ip_address = ip_address
        self.subnet_mask = subnet_mask
        self.vnet_subnet_resource_id = vnet_subnet_resource_id
        self.vnet_traffic_tag = vnet_traffic_tag
        self.subnet_traffic_tag = subnet_traffic_tag
        self.action = action
        self.tag = tag
        self.priority = priority
        self.name = name
        self.description = description


class KeyInfo(msrest.serialization.Model):
    """Function key info.

    :param name: Key name.
    :type name: str
    :param value: Key value.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        super(KeyInfo, self).__init__(**kwargs)
        self.name = name
        self.value = value


class KeyVaultReferenceCollection(ProxyOnlyResource):
    """Web app key vault reference and status ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param key_to_reference_statuses: Dictionary of :code:`<ApiKVReference>`.
    :type key_to_reference_statuses: dict[str, ~azure.mgmt.web.v2019_08_01.models.ApiKVReference]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'key_to_reference_statuses': {'key': 'properties.keyToReferenceStatuses', 'type': '{ApiKVReference}'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        key_to_reference_statuses: Optional[Dict[str, "ApiKVReference"]] = None,
        **kwargs
    ):
        super(KeyVaultReferenceCollection, self).__init__(kind=kind, **kwargs)
        self.key_to_reference_statuses = key_to_reference_statuses


class KeyVaultReferenceResource(ProxyOnlyResource):
    """Web app key vault reference and status ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param reference:
    :type reference: str
    :param status:  Possible values include: "Initialized", "Resolved", "InvalidSyntax",
     "MSINotEnabled", "VaultNotFound", "SecretNotFound", "SecretVersionNotFound",
     "AccessToKeyVaultDenied", "OtherReasons".
    :type status: str or ~azure.mgmt.web.v2019_08_01.models.ResolveStatus
    :param vault_name:
    :type vault_name: str
    :param secret_name:
    :type secret_name: str
    :param secret_version:
    :type secret_version: str
    :param identity_type: Type of managed service identity. Possible values include:
     "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned", "None".
    :type identity_type: str or ~azure.mgmt.web.v2019_08_01.models.ManagedServiceIdentityType
    :param details:
    :type details: str
    :param source:  The only acceptable values to pass in are None and "KeyVault". The default
     value is None.
    :type source: str
    :param location:  The only acceptable values to pass in are None and "ApplicationSetting". The
     default value is None.
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'reference': {'key': 'properties.reference', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'vault_name': {'key': 'properties.vaultName', 'type': 'str'},
        'secret_name': {'key': 'properties.secretName', 'type': 'str'},
        'secret_version': {'key': 'properties.secretVersion', 'type': 'str'},
        'identity_type': {'key': 'properties.identityType', 'type': 'str'},
        'details': {'key': 'properties.details', 'type': 'str'},
        'source': {'key': 'properties.source', 'type': 'str'},
        'location': {'key': 'properties.location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        reference: Optional[str] = None,
        status: Optional[Union[str, "ResolveStatus"]] = None,
        vault_name: Optional[str] = None,
        secret_name: Optional[str] = None,
        secret_version: Optional[str] = None,
        identity_type: Optional[Union[str, "ManagedServiceIdentityType"]] = None,
        details: Optional[str] = None,
        source: Optional[str] = None,
        location: Optional[str] = None,
        **kwargs
    ):
        super(KeyVaultReferenceResource, self).__init__(kind=kind, **kwargs)
        self.reference = reference
        self.status = status
        self.vault_name = vault_name
        self.secret_name = secret_name
        self.secret_version = secret_version
        self.identity_type = identity_type
        self.details = details
        self.source = source
        self.location = location


class LocalizableString(msrest.serialization.Model):
    """Localizable string object containing the name and a localized value.

    :param value: Non-localized name.
    :type value: str
    :param localized_value: Localized name.
    :type localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        localized_value: Optional[str] = None,
        **kwargs
    ):
        super(LocalizableString, self).__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class LogSpecification(msrest.serialization.Model):
    """Log Definition of a single resource metric.

    :param name:
    :type name: str
    :param display_name:
    :type display_name: str
    :param blob_duration:
    :type blob_duration: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        blob_duration: Optional[str] = None,
        **kwargs
    ):
        super(LogSpecification, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.blob_duration = blob_duration


class ManagedServiceIdentity(msrest.serialization.Model):
    """Managed service identity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type: Type of managed service identity. Possible values include: "SystemAssigned",
     "UserAssigned", "SystemAssigned, UserAssigned", "None".
    :type type: str or ~azure.mgmt.web.v2019_08_01.models.ManagedServiceIdentityType
    :ivar tenant_id: Tenant of managed service identity.
    :vartype tenant_id: str
    :ivar principal_id: Principal Id of managed service identity.
    :vartype principal_id: str
    :param user_assigned_identities: The list of user assigned identities associated with the
     resource. The user identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
    :type user_assigned_identities: dict[str,
     ~azure.mgmt.web.v2019_08_01.models.Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties]
    """

    _validation = {
        'tenant_id': {'readonly': True},
        'principal_id': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties}'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "ManagedServiceIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties"]] = None,
        **kwargs
    ):
        super(ManagedServiceIdentity, self).__init__(**kwargs)
        self.type = type
        self.tenant_id = None
        self.principal_id = None
        self.user_assigned_identities = user_assigned_identities


class MetricAvailability(msrest.serialization.Model):
    """Retention policy of a resource metric.

    :param time_grain:
    :type time_grain: str
    :param blob_duration:
    :type blob_duration: str
    """

    _attribute_map = {
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        time_grain: Optional[str] = None,
        blob_duration: Optional[str] = None,
        **kwargs
    ):
        super(MetricAvailability, self).__init__(**kwargs)
        self.time_grain = time_grain
        self.blob_duration = blob_duration


class MetricSpecification(msrest.serialization.Model):
    """Definition of a single resource metric.

    :param name:
    :type name: str
    :param display_name:
    :type display_name: str
    :param display_description:
    :type display_description: str
    :param unit:
    :type unit: str
    :param aggregation_type:
    :type aggregation_type: str
    :param supports_instance_level_aggregation:
    :type supports_instance_level_aggregation: bool
    :param enable_regional_mdm_account:
    :type enable_regional_mdm_account: bool
    :param source_mdm_account:
    :type source_mdm_account: str
    :param source_mdm_namespace:
    :type source_mdm_namespace: str
    :param metric_filter_pattern:
    :type metric_filter_pattern: str
    :param fill_gap_with_zero:
    :type fill_gap_with_zero: bool
    :param is_internal:
    :type is_internal: bool
    :param dimensions:
    :type dimensions: list[~azure.mgmt.web.v2019_08_01.models.Dimension]
    :param category:
    :type category: str
    :param availabilities:
    :type availabilities: list[~azure.mgmt.web.v2019_08_01.models.MetricAvailability]
    :param supported_time_grain_types:
    :type supported_time_grain_types: list[str]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'supports_instance_level_aggregation': {'key': 'supportsInstanceLevelAggregation', 'type': 'bool'},
        'enable_regional_mdm_account': {'key': 'enableRegionalMdmAccount', 'type': 'bool'},
        'source_mdm_account': {'key': 'sourceMdmAccount', 'type': 'str'},
        'source_mdm_namespace': {'key': 'sourceMdmNamespace', 'type': 'str'},
        'metric_filter_pattern': {'key': 'metricFilterPattern', 'type': 'str'},
        'fill_gap_with_zero': {'key': 'fillGapWithZero', 'type': 'bool'},
        'is_internal': {'key': 'isInternal', 'type': 'bool'},
        'dimensions': {'key': 'dimensions', 'type': '[Dimension]'},
        'category': {'key': 'category', 'type': 'str'},
        'availabilities': {'key': 'availabilities', 'type': '[MetricAvailability]'},
        'supported_time_grain_types': {'key': 'supportedTimeGrainTypes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        aggregation_type: Optional[str] = None,
        supports_instance_level_aggregation: Optional[bool] = None,
        enable_regional_mdm_account: Optional[bool] = None,
        source_mdm_account: Optional[str] = None,
        source_mdm_namespace: Optional[str] = None,
        metric_filter_pattern: Optional[str] = None,
        fill_gap_with_zero: Optional[bool] = None,
        is_internal: Optional[bool] = None,
        dimensions: Optional[List["Dimension"]] = None,
        category: Optional[str] = None,
        availabilities: Optional[List["MetricAvailability"]] = None,
        supported_time_grain_types: Optional[List[str]] = None,
        **kwargs
    ):
        super(MetricSpecification, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.aggregation_type = aggregation_type
        self.supports_instance_level_aggregation = supports_instance_level_aggregation
        self.enable_regional_mdm_account = enable_regional_mdm_account
        self.source_mdm_account = source_mdm_account
        self.source_mdm_namespace = source_mdm_namespace
        self.metric_filter_pattern = metric_filter_pattern
        self.fill_gap_with_zero = fill_gap_with_zero
        self.is_internal = is_internal
        self.dimensions = dimensions
        self.category = category
        self.availabilities = availabilities
        self.supported_time_grain_types = supported_time_grain_types


class MigrateMySqlRequest(ProxyOnlyResource):
    """MySQL migration request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param connection_string: Connection string to the remote MySQL database.
    :type connection_string: str
    :param migration_type: The type of migration operation to be done. Possible values include:
     "LocalToRemote", "RemoteToLocal".
    :type migration_type: str or ~azure.mgmt.web.v2019_08_01.models.MySqlMigrationType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'connection_string': {'key': 'properties.connectionString', 'type': 'str'},
        'migration_type': {'key': 'properties.migrationType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        connection_string: Optional[str] = None,
        migration_type: Optional[Union[str, "MySqlMigrationType"]] = None,
        **kwargs
    ):
        super(MigrateMySqlRequest, self).__init__(kind=kind, **kwargs)
        self.connection_string = connection_string
        self.migration_type = migration_type


class MigrateMySqlStatus(ProxyOnlyResource):
    """MySQL migration status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar migration_operation_status: Status of the migration task. Possible values include:
     "InProgress", "Failed", "Succeeded", "TimedOut", "Created".
    :vartype migration_operation_status: str or ~azure.mgmt.web.v2019_08_01.models.OperationStatus
    :ivar operation_id: Operation ID for the migration task.
    :vartype operation_id: str
    :ivar local_my_sql_enabled: True if the web app has in app MySql enabled.
    :vartype local_my_sql_enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'migration_operation_status': {'readonly': True},
        'operation_id': {'readonly': True},
        'local_my_sql_enabled': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'migration_operation_status': {'key': 'properties.migrationOperationStatus', 'type': 'str'},
        'operation_id': {'key': 'properties.operationId', 'type': 'str'},
        'local_my_sql_enabled': {'key': 'properties.localMySqlEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        super(MigrateMySqlStatus, self).__init__(kind=kind, **kwargs)
        self.migration_operation_status = None
        self.operation_id = None
        self.local_my_sql_enabled = None


class MSDeploy(ProxyOnlyResource):
    """MSDeploy ARM PUT information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param package_uri: Package URI.
    :type package_uri: str
    :param connection_string: SQL Connection String.
    :type connection_string: str
    :param db_type: Database Type.
    :type db_type: str
    :param set_parameters_xml_file_uri: URI of MSDeploy Parameters file. Must not be set if
     SetParameters is used.
    :type set_parameters_xml_file_uri: str
    :param set_parameters: MSDeploy Parameters. Must not be set if SetParametersXmlFileUri is used.
    :type set_parameters: dict[str, str]
    :param skip_app_data: Controls whether the MSDeploy operation skips the App_Data directory.
     If set to :code:`<code>true</code>`, the existing App_Data directory on the destination
     will not be deleted, and any App_Data directory in the source will be ignored.
     Setting is :code:`<code>false</code>` by default.
    :type skip_app_data: bool
    :param app_offline: Sets the AppOffline rule while the MSDeploy operation executes.
     Setting is :code:`<code>false</code>` by default.
    :type app_offline: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'package_uri': {'key': 'properties.packageUri', 'type': 'str'},
        'connection_string': {'key': 'properties.connectionString', 'type': 'str'},
        'db_type': {'key': 'properties.dbType', 'type': 'str'},
        'set_parameters_xml_file_uri': {'key': 'properties.setParametersXmlFileUri', 'type': 'str'},
        'set_parameters': {'key': 'properties.setParameters', 'type': '{str}'},
        'skip_app_data': {'key': 'properties.skipAppData', 'type': 'bool'},
        'app_offline': {'key': 'properties.appOffline', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        package_uri: Optional[str] = None,
        connection_string: Optional[str] = None,
        db_type: Optional[str] = None,
        set_parameters_xml_file_uri: Optional[str] = None,
        set_parameters: Optional[Dict[str, str]] = None,
        skip_app_data: Optional[bool] = None,
        app_offline: Optional[bool] = None,
        **kwargs
    ):
        super(MSDeploy, self).__init__(kind=kind, **kwargs)
        self.package_uri = package_uri
        self.connection_string = connection_string
        self.db_type = db_type
        self.set_parameters_xml_file_uri = set_parameters_xml_file_uri
        self.set_parameters = set_parameters
        self.skip_app_data = skip_app_data
        self.app_offline = app_offline


class MSDeployLog(ProxyOnlyResource):
    """MSDeploy log.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar entries: List of log entry messages.
    :vartype entries: list[~azure.mgmt.web.v2019_08_01.models.MSDeployLogEntry]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'entries': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'entries': {'key': 'properties.entries', 'type': '[MSDeployLogEntry]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        super(MSDeployLog, self).__init__(kind=kind, **kwargs)
        self.entries = None


class MSDeployLogEntry(msrest.serialization.Model):
    """MSDeploy log entry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar time: Timestamp of log entry.
    :vartype time: ~datetime.datetime
    :ivar type: Log entry type. Possible values include: "Message", "Warning", "Error".
    :vartype type: str or ~azure.mgmt.web.v2019_08_01.models.MSDeployLogEntryType
    :ivar message: Log entry message.
    :vartype message: str
    """

    _validation = {
        'time': {'readonly': True},
        'type': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'time': {'key': 'time', 'type': 'iso-8601'},
        'type': {'key': 'type', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MSDeployLogEntry, self).__init__(**kwargs)
        self.time = None
        self.type = None
        self.message = None


class MSDeployStatus(ProxyOnlyResource):
    """MSDeploy ARM response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar deployer: Username of deployer.
    :vartype deployer: str
    :ivar provisioning_state: Provisioning state. Possible values include: "accepted", "running",
     "succeeded", "failed", "canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.web.v2019_08_01.models.MSDeployProvisioningState
    :ivar start_time: Start time of deploy operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of deploy operation.
    :vartype end_time: ~datetime.datetime
    :ivar complete: Whether the deployment operation has completed.
    :vartype complete: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'deployer': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'complete': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'deployer': {'key': 'properties.deployer', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'complete': {'key': 'properties.complete', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        super(MSDeployStatus, self).__init__(kind=kind, **kwargs)
        self.deployer = None
        self.provisioning_state = None
        self.start_time = None
        self.end_time = None
        self.complete = None


class NameIdentifier(msrest.serialization.Model):
    """Identifies an object.

    :param name: Name of the object.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        super(NameIdentifier, self).__init__(**kwargs)
        self.name = name


class NameIdentifierCollection(msrest.serialization.Model):
    """Collection of domain name identifiers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.NameIdentifier]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NameIdentifier]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["NameIdentifier"],
        **kwargs
    ):
        super(NameIdentifierCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class NameValuePair(msrest.serialization.Model):
    """Name value pair.

    :param name: Pair name.
    :type name: str
    :param value: Pair value.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        super(NameValuePair, self).__init__(**kwargs)
        self.name = name
        self.value = value


class NetworkAccessControlEntry(msrest.serialization.Model):
    """Network access control entry.

    :param action: Action object. Possible values include: "Permit", "Deny".
    :type action: str or ~azure.mgmt.web.v2019_08_01.models.AccessControlEntryAction
    :param description: Description of network access control entry.
    :type description: str
    :param order: Order of precedence.
    :type order: int
    :param remote_subnet: Remote subnet.
    :type remote_subnet: str
    """

    _attribute_map = {
        'action': {'key': 'action', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'order': {'key': 'order', 'type': 'int'},
        'remote_subnet': {'key': 'remoteSubnet', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        action: Optional[Union[str, "AccessControlEntryAction"]] = None,
        description: Optional[str] = None,
        order: Optional[int] = None,
        remote_subnet: Optional[str] = None,
        **kwargs
    ):
        super(NetworkAccessControlEntry, self).__init__(**kwargs)
        self.action = action
        self.description = description
        self.order = order
        self.remote_subnet = remote_subnet


class NetworkFeatures(ProxyOnlyResource):
    """Full view of network features for an app (presently VNET integration and Hybrid Connections).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar virtual_network_name: The Virtual Network name.
    :vartype virtual_network_name: str
    :ivar virtual_network_connection: The Virtual Network summary view.
    :vartype virtual_network_connection: ~azure.mgmt.web.v2019_08_01.models.VnetInfo
    :ivar hybrid_connections: The Hybrid Connections summary view.
    :vartype hybrid_connections:
     list[~azure.mgmt.web.v2019_08_01.models.RelayServiceConnectionEntity]
    :ivar hybrid_connections_v2: The Hybrid Connection V2 (Service Bus) view.
    :vartype hybrid_connections_v2: list[~azure.mgmt.web.v2019_08_01.models.HybridConnection]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'virtual_network_name': {'readonly': True},
        'virtual_network_connection': {'readonly': True},
        'hybrid_connections': {'readonly': True},
        'hybrid_connections_v2': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'virtual_network_name': {'key': 'properties.virtualNetworkName', 'type': 'str'},
        'virtual_network_connection': {'key': 'properties.virtualNetworkConnection', 'type': 'VnetInfo'},
        'hybrid_connections': {'key': 'properties.hybridConnections', 'type': '[RelayServiceConnectionEntity]'},
        'hybrid_connections_v2': {'key': 'properties.hybridConnectionsV2', 'type': '[HybridConnection]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        super(NetworkFeatures, self).__init__(kind=kind, **kwargs)
        self.virtual_network_name = None
        self.virtual_network_connection = None
        self.hybrid_connections = None
        self.hybrid_connections_v2 = None


class NetworkTrace(msrest.serialization.Model):
    """Network trace.

    :param path: Local file path for the captured network trace file.
    :type path: str
    :param status: Current status of the network trace operation, same as Operation.Status
     (InProgress/Succeeded/Failed).
    :type status: str
    :param message: Detailed message of a network trace operation, e.g. error message in case of
     failure.
    :type message: str
    """

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        path: Optional[str] = None,
        status: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(NetworkTrace, self).__init__(**kwargs)
        self.path = path
        self.status = status
        self.message = message


class Operation(msrest.serialization.Model):
    """An operation on a resource.

    :param id: Operation ID.
    :type id: str
    :param name: Operation name.
    :type name: str
    :param status: The current status of the operation. Possible values include: "InProgress",
     "Failed", "Succeeded", "TimedOut", "Created".
    :type status: str or ~azure.mgmt.web.v2019_08_01.models.OperationStatus
    :param errors: Any errors associate with the operation.
    :type errors: list[~azure.mgmt.web.v2019_08_01.models.ErrorEntity]
    :param created_time: Time when operation has started.
    :type created_time: ~datetime.datetime
    :param modified_time: Time when operation has been updated.
    :type modified_time: ~datetime.datetime
    :param expiration_time: Time when operation will expire.
    :type expiration_time: ~datetime.datetime
    :param geo_master_operation_id: Applicable only for stamp operation ids.
    :type geo_master_operation_id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ErrorEntity]'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'modified_time': {'key': 'modifiedTime', 'type': 'iso-8601'},
        'expiration_time': {'key': 'expirationTime', 'type': 'iso-8601'},
        'geo_master_operation_id': {'key': 'geoMasterOperationId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        status: Optional[Union[str, "OperationStatus"]] = None,
        errors: Optional[List["ErrorEntity"]] = None,
        created_time: Optional[datetime.datetime] = None,
        modified_time: Optional[datetime.datetime] = None,
        expiration_time: Optional[datetime.datetime] = None,
        geo_master_operation_id: Optional[str] = None,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.status = status
        self.errors = errors
        self.created_time = created_time
        self.modified_time = modified_time
        self.expiration_time = expiration_time
        self.geo_master_operation_id = geo_master_operation_id


class OutboundEnvironmentEndpoint(msrest.serialization.Model):
    """Endpoints accessed for a common purpose that the App Service Environment requires outbound network access to.

    :param category: The type of service accessed by the App Service Environment, e.g., Azure
     Storage, Azure SQL Database, and Azure Active Directory.
    :type category: str
    :param endpoints: The endpoints that the App Service Environment reaches the service at.
    :type endpoints: list[~azure.mgmt.web.v2019_08_01.models.EndpointDependency]
    """

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'endpoints': {'key': 'endpoints', 'type': '[EndpointDependency]'},
    }

    def __init__(
        self,
        *,
        category: Optional[str] = None,
        endpoints: Optional[List["EndpointDependency"]] = None,
        **kwargs
    ):
        super(OutboundEnvironmentEndpoint, self).__init__(**kwargs)
        self.category = category
        self.endpoints = endpoints


class OutboundEnvironmentEndpointCollection(msrest.serialization.Model):
    """Collection of Outbound Environment Endpoints.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.OutboundEnvironmentEndpoint]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OutboundEnvironmentEndpoint]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["OutboundEnvironmentEndpoint"],
        **kwargs
    ):
        super(OutboundEnvironmentEndpointCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class PerfMonCounterCollection(msrest.serialization.Model):
    """Collection of performance monitor counters.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.PerfMonResponse]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PerfMonResponse]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["PerfMonResponse"],
        **kwargs
    ):
        super(PerfMonCounterCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class PerfMonResponse(msrest.serialization.Model):
    """Performance monitor API response.

    :param code: The response code.
    :type code: str
    :param message: The message.
    :type message: str
    :param data: The performance monitor counters.
    :type data: ~azure.mgmt.web.v2019_08_01.models.PerfMonSet
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'data': {'key': 'data', 'type': 'PerfMonSet'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        data: Optional["PerfMonSet"] = None,
        **kwargs
    ):
        super(PerfMonResponse, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.data = data


class PerfMonSample(msrest.serialization.Model):
    """Performance monitor sample in a set.

    :param time: Point in time for which counter was measured.
    :type time: ~datetime.datetime
    :param instance_name: Name of the server on which the measurement is made.
    :type instance_name: str
    :param value: Value of counter at a certain time.
    :type value: float
    """

    _attribute_map = {
        'time': {'key': 'time', 'type': 'iso-8601'},
        'instance_name': {'key': 'instanceName', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        time: Optional[datetime.datetime] = None,
        instance_name: Optional[str] = None,
        value: Optional[float] = None,
        **kwargs
    ):
        super(PerfMonSample, self).__init__(**kwargs)
        self.time = time
        self.instance_name = instance_name
        self.value = value


class PerfMonSet(msrest.serialization.Model):
    """Metric information.

    :param name: Unique key name of the counter.
    :type name: str
    :param start_time: Start time of the period.
    :type start_time: ~datetime.datetime
    :param end_time: End time of the period.
    :type end_time: ~datetime.datetime
    :param time_grain: Presented time grain.
    :type time_grain: str
    :param values: Collection of workers that are active during this time.
    :type values: list[~azure.mgmt.web.v2019_08_01.models.PerfMonSample]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'values': {'key': 'values', 'type': '[PerfMonSample]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        time_grain: Optional[str] = None,
        values: Optional[List["PerfMonSample"]] = None,
        **kwargs
    ):
        super(PerfMonSet, self).__init__(**kwargs)
        self.name = name
        self.start_time = start_time
        self.end_time = end_time
        self.time_grain = time_grain
        self.values = values


class PremierAddOn(Resource):
    """Premier add-on.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: Premier add on SKU.
    :type sku: str
    :param product: Premier add on Product.
    :type product: str
    :param vendor: Premier add on Vendor.
    :type vendor: str
    :param marketplace_publisher: Premier add on Marketplace publisher.
    :type marketplace_publisher: str
    :param marketplace_offer: Premier add on Marketplace offer.
    :type marketplace_offer: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'properties.sku', 'type': 'str'},
        'product': {'key': 'properties.product', 'type': 'str'},
        'vendor': {'key': 'properties.vendor', 'type': 'str'},
        'marketplace_publisher': {'key': 'properties.marketplacePublisher', 'type': 'str'},
        'marketplace_offer': {'key': 'properties.marketplaceOffer', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional[str] = None,
        product: Optional[str] = None,
        vendor: Optional[str] = None,
        marketplace_publisher: Optional[str] = None,
        marketplace_offer: Optional[str] = None,
        **kwargs
    ):
        super(PremierAddOn, self).__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.product = product
        self.vendor = vendor
        self.marketplace_publisher = marketplace_publisher
        self.marketplace_offer = marketplace_offer


class PremierAddOnOffer(ProxyOnlyResource):
    """Premier add-on offer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param sku: Premier add on SKU.
    :type sku: str
    :param product: Premier add on offer Product.
    :type product: str
    :param vendor: Premier add on offer Vendor.
    :type vendor: str
    :param promo_code_required: :code:`<code>true</code>` if promotion code is required; otherwise,
     :code:`<code>false</code>`.
    :type promo_code_required: bool
    :param quota: Premier add on offer Quota.
    :type quota: int
    :param web_hosting_plan_restrictions: App Service plans this offer is restricted to. Possible
     values include: "None", "Free", "Shared", "Basic", "Standard", "Premium".
    :type web_hosting_plan_restrictions: str or
     ~azure.mgmt.web.v2019_08_01.models.AppServicePlanRestrictions
    :param privacy_policy_url: Privacy policy URL.
    :type privacy_policy_url: str
    :param legal_terms_url: Legal terms URL.
    :type legal_terms_url: str
    :param marketplace_publisher: Marketplace publisher.
    :type marketplace_publisher: str
    :param marketplace_offer: Marketplace offer.
    :type marketplace_offer: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'sku': {'key': 'properties.sku', 'type': 'str'},
        'product': {'key': 'properties.product', 'type': 'str'},
        'vendor': {'key': 'properties.vendor', 'type': 'str'},
        'promo_code_required': {'key': 'properties.promoCodeRequired', 'type': 'bool'},
        'quota': {'key': 'properties.quota', 'type': 'int'},
        'web_hosting_plan_restrictions': {'key': 'properties.webHostingPlanRestrictions', 'type': 'str'},
        'privacy_policy_url': {'key': 'properties.privacyPolicyUrl', 'type': 'str'},
        'legal_terms_url': {'key': 'properties.legalTermsUrl', 'type': 'str'},
        'marketplace_publisher': {'key': 'properties.marketplacePublisher', 'type': 'str'},
        'marketplace_offer': {'key': 'properties.marketplaceOffer', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        sku: Optional[str] = None,
        product: Optional[str] = None,
        vendor: Optional[str] = None,
        promo_code_required: Optional[bool] = None,
        quota: Optional[int] = None,
        web_hosting_plan_restrictions: Optional[Union[str, "AppServicePlanRestrictions"]] = None,
        privacy_policy_url: Optional[str] = None,
        legal_terms_url: Optional[str] = None,
        marketplace_publisher: Optional[str] = None,
        marketplace_offer: Optional[str] = None,
        **kwargs
    ):
        super(PremierAddOnOffer, self).__init__(kind=kind, **kwargs)
        self.sku = sku
        self.product = product
        self.vendor = vendor
        self.promo_code_required = promo_code_required
        self.quota = quota
        self.web_hosting_plan_restrictions = web_hosting_plan_restrictions
        self.privacy_policy_url = privacy_policy_url
        self.legal_terms_url = legal_terms_url
        self.marketplace_publisher = marketplace_publisher
        self.marketplace_offer = marketplace_offer


class PremierAddOnOfferCollection(msrest.serialization.Model):
    """Collection of premier add-on offers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.PremierAddOnOffer]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PremierAddOnOffer]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["PremierAddOnOffer"],
        **kwargs
    ):
        super(PremierAddOnOfferCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class PremierAddOnPatchResource(ProxyOnlyResource):
    """ARM resource for a PremierAddOn.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param sku: Premier add on SKU.
    :type sku: str
    :param product: Premier add on Product.
    :type product: str
    :param vendor: Premier add on Vendor.
    :type vendor: str
    :param marketplace_publisher: Premier add on Marketplace publisher.
    :type marketplace_publisher: str
    :param marketplace_offer: Premier add on Marketplace offer.
    :type marketplace_offer: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'sku': {'key': 'properties.sku', 'type': 'str'},
        'product': {'key': 'properties.product', 'type': 'str'},
        'vendor': {'key': 'properties.vendor', 'type': 'str'},
        'marketplace_publisher': {'key': 'properties.marketplacePublisher', 'type': 'str'},
        'marketplace_offer': {'key': 'properties.marketplaceOffer', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        sku: Optional[str] = None,
        product: Optional[str] = None,
        vendor: Optional[str] = None,
        marketplace_publisher: Optional[str] = None,
        marketplace_offer: Optional[str] = None,
        **kwargs
    ):
        super(PremierAddOnPatchResource, self).__init__(kind=kind, **kwargs)
        self.sku = sku
        self.product = product
        self.vendor = vendor
        self.marketplace_publisher = marketplace_publisher
        self.marketplace_offer = marketplace_offer


class PrivateAccess(ProxyOnlyResource):
    """Description of the parameters of Private Access for a Web Site.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param enabled: Whether private access is enabled or not.
    :type enabled: bool
    :param virtual_networks: The Virtual Networks (and subnets) allowed to access the site
     privately.
    :type virtual_networks: list[~azure.mgmt.web.v2019_08_01.models.PrivateAccessVirtualNetwork]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'virtual_networks': {'key': 'properties.virtualNetworks', 'type': '[PrivateAccessVirtualNetwork]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        enabled: Optional[bool] = None,
        virtual_networks: Optional[List["PrivateAccessVirtualNetwork"]] = None,
        **kwargs
    ):
        super(PrivateAccess, self).__init__(kind=kind, **kwargs)
        self.enabled = enabled
        self.virtual_networks = virtual_networks


class PrivateAccessSubnet(msrest.serialization.Model):
    """Description of a Virtual Network subnet that is useable for private site access.

    :param name: The name of the subnet.
    :type name: str
    :param key: The key (ID) of the subnet.
    :type key: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'key': {'key': 'key', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        key: Optional[int] = None,
        **kwargs
    ):
        super(PrivateAccessSubnet, self).__init__(**kwargs)
        self.name = name
        self.key = key


class PrivateAccessVirtualNetwork(msrest.serialization.Model):
    """Description of a Virtual Network that is useable for private site access.

    :param name: The name of the Virtual Network.
    :type name: str
    :param key: The key (ID) of the Virtual Network.
    :type key: int
    :param resource_id: The ARM uri of the Virtual Network.
    :type resource_id: str
    :param subnets: A List of subnets that access is allowed to on this Virtual Network. An empty
     array (but not null) is interpreted to mean that all subnets are allowed within this Virtual
     Network.
    :type subnets: list[~azure.mgmt.web.v2019_08_01.models.PrivateAccessSubnet]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'key': {'key': 'key', 'type': 'int'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'subnets': {'key': 'subnets', 'type': '[PrivateAccessSubnet]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        key: Optional[int] = None,
        resource_id: Optional[str] = None,
        subnets: Optional[List["PrivateAccessSubnet"]] = None,
        **kwargs
    ):
        super(PrivateAccessVirtualNetwork, self).__init__(**kwargs)
        self.name = name
        self.key = key
        self.resource_id = resource_id
        self.subnets = subnets


class PrivateEndpointConnectionResource(ProxyOnlyResource):
    """Private Endpoint Connection ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state:
    :vartype provisioning_state: str
    :param private_endpoint: PrivateEndpoint of a remote private endpoint connection.
    :type private_endpoint: ~azure.mgmt.web.v2019_08_01.models.ArmIdWrapper
    :param private_link_service_connection_state: The state of a private link connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.web.v2019_08_01.models.PrivateLinkConnectionState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'ArmIdWrapper'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkConnectionState'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        private_endpoint: Optional["ArmIdWrapper"] = None,
        private_link_service_connection_state: Optional["PrivateLinkConnectionState"] = None,
        **kwargs
    ):
        super(PrivateEndpointConnectionResource, self).__init__(kind=kind, **kwargs)
        self.provisioning_state = None
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state


class PrivateLinkConnectionApprovalRequestResource(ProxyOnlyResource):
    """Private Endpoint Connection Approval ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param private_link_service_connection_state: The state of a private link connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.web.v2019_08_01.models.PrivateLinkConnectionState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkConnectionState'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        private_link_service_connection_state: Optional["PrivateLinkConnectionState"] = None,
        **kwargs
    ):
        super(PrivateLinkConnectionApprovalRequestResource, self).__init__(kind=kind, **kwargs)
        self.private_link_service_connection_state = private_link_service_connection_state


class PrivateLinkConnectionState(msrest.serialization.Model):
    """The state of a private link connection.

    :param status: Status of a private link connection.
    :type status: str
    :param description: Description of a private link connection.
    :type description: str
    :param actions_required: ActionsRequired for a private link connection.
    :type actions_required: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[str] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs
    ):
        super(PrivateLinkConnectionState, self).__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class PrivateLinkResource(msrest.serialization.Model):
    """A private link resource.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: str
    :param name: Required. Name of a private link resource.
    :type name: str
    :param type: Required.
    :type type: str
    :param properties: Required. Properties of a private link resource.
    :type properties: ~azure.mgmt.web.v2019_08_01.models.PrivateLinkResourceProperties
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
        'type': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PrivateLinkResourceProperties'},
    }

    def __init__(
        self,
        *,
        id: str,
        name: str,
        type: str,
        properties: "PrivateLinkResourceProperties",
        **kwargs
    ):
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.type = type
        self.properties = properties


class PrivateLinkResourceProperties(msrest.serialization.Model):
    """Properties of a private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar group_id: GroupId of a private link resource.
    :vartype group_id: str
    :ivar required_members: RequiredMembers of a private link resource.
    :vartype required_members: list[str]
    :ivar required_zone_names: RequiredZoneNames of a private link resource.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
        'required_zone_names': {'readonly': True},
    }

    _attribute_map = {
        'group_id': {'key': 'groupId', 'type': 'str'},
        'required_members': {'key': 'requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResourceProperties, self).__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = None


class PrivateLinkResourcesWrapper(msrest.serialization.Model):
    """Wrapper for a collection of private link resources.

    All required parameters must be populated in order to send to Azure.

    :param value: Required.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.PrivateLinkResource]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
    }

    def __init__(
        self,
        *,
        value: List["PrivateLinkResource"],
        **kwargs
    ):
        super(PrivateLinkResourcesWrapper, self).__init__(**kwargs)
        self.value = value


class ProcessInfo(ProxyOnlyResource):
    """Process Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar identifier: ARM Identifier for deployment.
    :vartype identifier: int
    :param deployment_name: Deployment name.
    :type deployment_name: str
    :param href: HRef URI.
    :type href: str
    :param minidump: Minidump URI.
    :type minidump: str
    :param is_profile_running: Is profile running?.
    :type is_profile_running: bool
    :param is_iis_profile_running: Is the IIS Profile running?.
    :type is_iis_profile_running: bool
    :param iis_profile_timeout_in_seconds: IIS Profile timeout (seconds).
    :type iis_profile_timeout_in_seconds: float
    :param parent: Parent process.
    :type parent: str
    :param children: Child process list.
    :type children: list[str]
    :param threads: Thread list.
    :type threads: list[~azure.mgmt.web.v2019_08_01.models.ProcessThreadInfo]
    :param open_file_handles: List of open files.
    :type open_file_handles: list[str]
    :param modules: List of modules.
    :type modules: list[~azure.mgmt.web.v2019_08_01.models.ProcessModuleInfo]
    :param file_name: File name of this process.
    :type file_name: str
    :param command_line: Command line.
    :type command_line: str
    :param user_name: User name.
    :type user_name: str
    :param handle_count: Handle count.
    :type handle_count: int
    :param module_count: Module count.
    :type module_count: int
    :param thread_count: Thread count.
    :type thread_count: int
    :param start_time: Start time.
    :type start_time: ~datetime.datetime
    :param total_cpu_time: Total CPU time.
    :type total_cpu_time: str
    :param user_cpu_time: User CPU time.
    :type user_cpu_time: str
    :param privileged_cpu_time: Privileged CPU time.
    :type privileged_cpu_time: str
    :param working_set: Working set.
    :type working_set: long
    :param peak_working_set: Peak working set.
    :type peak_working_set: long
    :param private_memory: Private memory size.
    :type private_memory: long
    :param virtual_memory: Virtual memory size.
    :type virtual_memory: long
    :param peak_virtual_memory: Peak virtual memory usage.
    :type peak_virtual_memory: long
    :param paged_system_memory: Paged system memory.
    :type paged_system_memory: long
    :param non_paged_system_memory: Non-paged system memory.
    :type non_paged_system_memory: long
    :param paged_memory: Paged memory.
    :type paged_memory: long
    :param peak_paged_memory: Peak paged memory.
    :type peak_paged_memory: long
    :param time_stamp: Time stamp.
    :type time_stamp: ~datetime.datetime
    :param environment_variables: List of environment variables.
    :type environment_variables: dict[str, str]
    :param is_scm_site: Is this the SCM site?.
    :type is_scm_site: bool
    :param is_webjob: Is this a Web Job?.
    :type is_webjob: bool
    :param description: Description of process.
    :type description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'identifier': {'key': 'properties.identifier', 'type': 'int'},
        'deployment_name': {'key': 'properties.deployment_name', 'type': 'str'},
        'href': {'key': 'properties.href', 'type': 'str'},
        'minidump': {'key': 'properties.minidump', 'type': 'str'},
        'is_profile_running': {'key': 'properties.is_profile_running', 'type': 'bool'},
        'is_iis_profile_running': {'key': 'properties.is_iis_profile_running', 'type': 'bool'},
        'iis_profile_timeout_in_seconds': {'key': 'properties.iis_profile_timeout_in_seconds', 'type': 'float'},
        'parent': {'key': 'properties.parent', 'type': 'str'},
        'children': {'key': 'properties.children', 'type': '[str]'},
        'threads': {'key': 'properties.threads', 'type': '[ProcessThreadInfo]'},
        'open_file_handles': {'key': 'properties.open_file_handles', 'type': '[str]'},
        'modules': {'key': 'properties.modules', 'type': '[ProcessModuleInfo]'},
        'file_name': {'key': 'properties.file_name', 'type': 'str'},
        'command_line': {'key': 'properties.command_line', 'type': 'str'},
        'user_name': {'key': 'properties.user_name', 'type': 'str'},
        'handle_count': {'key': 'properties.handle_count', 'type': 'int'},
        'module_count': {'key': 'properties.module_count', 'type': 'int'},
        'thread_count': {'key': 'properties.thread_count', 'type': 'int'},
        'start_time': {'key': 'properties.start_time', 'type': 'iso-8601'},
        'total_cpu_time': {'key': 'properties.total_cpu_time', 'type': 'str'},
        'user_cpu_time': {'key': 'properties.user_cpu_time', 'type': 'str'},
        'privileged_cpu_time': {'key': 'properties.privileged_cpu_time', 'type': 'str'},
        'working_set': {'key': 'properties.working_set', 'type': 'long'},
        'peak_working_set': {'key': 'properties.peak_working_set', 'type': 'long'},
        'private_memory': {'key': 'properties.private_memory', 'type': 'long'},
        'virtual_memory': {'key': 'properties.virtual_memory', 'type': 'long'},
        'peak_virtual_memory': {'key': 'properties.peak_virtual_memory', 'type': 'long'},
        'paged_system_memory': {'key': 'properties.paged_system_memory', 'type': 'long'},
        'non_paged_system_memory': {'key': 'properties.non_paged_system_memory', 'type': 'long'},
        'paged_memory': {'key': 'properties.paged_memory', 'type': 'long'},
        'peak_paged_memory': {'key': 'properties.peak_paged_memory', 'type': 'long'},
        'time_stamp': {'key': 'properties.time_stamp', 'type': 'iso-8601'},
        'environment_variables': {'key': 'properties.environment_variables', 'type': '{str}'},
        'is_scm_site': {'key': 'properties.is_scm_site', 'type': 'bool'},
        'is_webjob': {'key': 'properties.is_webjob', 'type': 'bool'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        deployment_name: Optional[str] = None,
        href: Optional[str] = None,
        minidump: Optional[str] = None,
        is_profile_running: Optional[bool] = None,
        is_iis_profile_running: Optional[bool] = None,
        iis_profile_timeout_in_seconds: Optional[float] = None,
        parent: Optional[str] = None,
        children: Optional[List[str]] = None,
        threads: Optional[List["ProcessThreadInfo"]] = None,
        open_file_handles: Optional[List[str]] = None,
        modules: Optional[List["ProcessModuleInfo"]] = None,
        file_name: Optional[str] = None,
        command_line: Optional[str] = None,
        user_name: Optional[str] = None,
        handle_count: Optional[int] = None,
        module_count: Optional[int] = None,
        thread_count: Optional[int] = None,
        start_time: Optional[datetime.datetime] = None,
        total_cpu_time: Optional[str] = None,
        user_cpu_time: Optional[str] = None,
        privileged_cpu_time: Optional[str] = None,
        working_set: Optional[int] = None,
        peak_working_set: Optional[int] = None,
        private_memory: Optional[int] = None,
        virtual_memory: Optional[int] = None,
        peak_virtual_memory: Optional[int] = None,
        paged_system_memory: Optional[int] = None,
        non_paged_system_memory: Optional[int] = None,
        paged_memory: Optional[int] = None,
        peak_paged_memory: Optional[int] = None,
        time_stamp: Optional[datetime.datetime] = None,
        environment_variables: Optional[Dict[str, str]] = None,
        is_scm_site: Optional[bool] = None,
        is_webjob: Optional[bool] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(ProcessInfo, self).__init__(kind=kind, **kwargs)
        self.identifier = None
        self.deployment_name = deployment_name
        self.href = href
        self.minidump = minidump
        self.is_profile_running = is_profile_running
        self.is_iis_profile_running = is_iis_profile_running
        self.iis_profile_timeout_in_seconds = iis_profile_timeout_in_seconds
        self.parent = parent
        self.children = children
        self.threads = threads
        self.open_file_handles = open_file_handles
        self.modules = modules
        self.file_name = file_name
        self.command_line = command_line
        self.user_name = user_name
        self.handle_count = handle_count
        self.module_count = module_count
        self.thread_count = thread_count
        self.start_time = start_time
        self.total_cpu_time = total_cpu_time
        self.user_cpu_time = user_cpu_time
        self.privileged_cpu_time = privileged_cpu_time
        self.working_set = working_set
        self.peak_working_set = peak_working_set
        self.private_memory = private_memory
        self.virtual_memory = virtual_memory
        self.peak_virtual_memory = peak_virtual_memory
        self.paged_system_memory = paged_system_memory
        self.non_paged_system_memory = non_paged_system_memory
        self.paged_memory = paged_memory
        self.peak_paged_memory = peak_paged_memory
        self.time_stamp = time_stamp
        self.environment_variables = environment_variables
        self.is_scm_site = is_scm_site
        self.is_webjob = is_webjob
        self.description = description


class ProcessInfoCollection(msrest.serialization.Model):
    """Collection of Kudu process information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.ProcessInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ProcessInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["ProcessInfo"],
        **kwargs
    ):
        super(ProcessInfoCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ProcessModuleInfo(ProxyOnlyResource):
    """Process Module Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param base_address: Base address. Used as module identifier in ARM resource URI.
    :type base_address: str
    :param file_name: File name.
    :type file_name: str
    :param href: HRef URI.
    :type href: str
    :param file_path: File path.
    :type file_path: str
    :param module_memory_size: Module memory size.
    :type module_memory_size: int
    :param file_version: File version.
    :type file_version: str
    :param file_description: File description.
    :type file_description: str
    :param product: Product name.
    :type product: str
    :param product_version: Product version.
    :type product_version: str
    :param is_debug: Is debug?.
    :type is_debug: bool
    :param language: Module language (locale).
    :type language: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'base_address': {'key': 'properties.base_address', 'type': 'str'},
        'file_name': {'key': 'properties.file_name', 'type': 'str'},
        'href': {'key': 'properties.href', 'type': 'str'},
        'file_path': {'key': 'properties.file_path', 'type': 'str'},
        'module_memory_size': {'key': 'properties.module_memory_size', 'type': 'int'},
        'file_version': {'key': 'properties.file_version', 'type': 'str'},
        'file_description': {'key': 'properties.file_description', 'type': 'str'},
        'product': {'key': 'properties.product', 'type': 'str'},
        'product_version': {'key': 'properties.product_version', 'type': 'str'},
        'is_debug': {'key': 'properties.is_debug', 'type': 'bool'},
        'language': {'key': 'properties.language', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        base_address: Optional[str] = None,
        file_name: Optional[str] = None,
        href: Optional[str] = None,
        file_path: Optional[str] = None,
        module_memory_size: Optional[int] = None,
        file_version: Optional[str] = None,
        file_description: Optional[str] = None,
        product: Optional[str] = None,
        product_version: Optional[str] = None,
        is_debug: Optional[bool] = None,
        language: Optional[str] = None,
        **kwargs
    ):
        super(ProcessModuleInfo, self).__init__(kind=kind, **kwargs)
        self.base_address = base_address
        self.file_name = file_name
        self.href = href
        self.file_path = file_path
        self.module_memory_size = module_memory_size
        self.file_version = file_version
        self.file_description = file_description
        self.product = product
        self.product_version = product_version
        self.is_debug = is_debug
        self.language = language


class ProcessModuleInfoCollection(msrest.serialization.Model):
    """Collection of Kudu thread information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.ProcessModuleInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ProcessModuleInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["ProcessModuleInfo"],
        **kwargs
    ):
        super(ProcessModuleInfoCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ProcessThreadInfo(ProxyOnlyResource):
    """Process Thread Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar identifier: Site extension ID.
    :vartype identifier: int
    :param href: HRef URI.
    :type href: str
    :param process: Process URI.
    :type process: str
    :param start_address: Start address.
    :type start_address: str
    :param current_priority: Current thread priority.
    :type current_priority: int
    :param priority_level: Thread priority level.
    :type priority_level: str
    :param base_priority: Base priority.
    :type base_priority: int
    :param start_time: Start time.
    :type start_time: ~datetime.datetime
    :param total_processor_time: Total processor time.
    :type total_processor_time: str
    :param user_processor_time: User processor time.
    :type user_processor_time: str
    :param state: Thread state.
    :type state: str
    :param wait_reason: Wait reason.
    :type wait_reason: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'identifier': {'key': 'properties.identifier', 'type': 'int'},
        'href': {'key': 'properties.href', 'type': 'str'},
        'process': {'key': 'properties.process', 'type': 'str'},
        'start_address': {'key': 'properties.start_address', 'type': 'str'},
        'current_priority': {'key': 'properties.current_priority', 'type': 'int'},
        'priority_level': {'key': 'properties.priority_level', 'type': 'str'},
        'base_priority': {'key': 'properties.base_priority', 'type': 'int'},
        'start_time': {'key': 'properties.start_time', 'type': 'iso-8601'},
        'total_processor_time': {'key': 'properties.total_processor_time', 'type': 'str'},
        'user_processor_time': {'key': 'properties.user_processor_time', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'wait_reason': {'key': 'properties.wait_reason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        href: Optional[str] = None,
        process: Optional[str] = None,
        start_address: Optional[str] = None,
        current_priority: Optional[int] = None,
        priority_level: Optional[str] = None,
        base_priority: Optional[int] = None,
        start_time: Optional[datetime.datetime] = None,
        total_processor_time: Optional[str] = None,
        user_processor_time: Optional[str] = None,
        state: Optional[str] = None,
        wait_reason: Optional[str] = None,
        **kwargs
    ):
        super(ProcessThreadInfo, self).__init__(kind=kind, **kwargs)
        self.identifier = None
        self.href = href
        self.process = process
        self.start_address = start_address
        self.current_priority = current_priority
        self.priority_level = priority_level
        self.base_priority = base_priority
        self.start_time = start_time
        self.total_processor_time = total_processor_time
        self.user_processor_time = user_processor_time
        self.state = state
        self.wait_reason = wait_reason


class ProcessThreadInfoCollection(msrest.serialization.Model):
    """Collection of Kudu thread information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.ProcessThreadInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ProcessThreadInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["ProcessThreadInfo"],
        **kwargs
    ):
        super(ProcessThreadInfoCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class PublicCertificate(ProxyOnlyResource):
    """Public certificate object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param blob: Public Certificate byte array.
    :type blob: bytearray
    :param public_certificate_location: Public Certificate Location. Possible values include:
     "CurrentUserMy", "LocalMachineMy", "Unknown".
    :type public_certificate_location: str or
     ~azure.mgmt.web.v2019_08_01.models.PublicCertificateLocation
    :ivar thumbprint: Certificate Thumbprint.
    :vartype thumbprint: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'thumbprint': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'blob': {'key': 'properties.blob', 'type': 'bytearray'},
        'public_certificate_location': {'key': 'properties.publicCertificateLocation', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        blob: Optional[bytearray] = None,
        public_certificate_location: Optional[Union[str, "PublicCertificateLocation"]] = None,
        **kwargs
    ):
        super(PublicCertificate, self).__init__(kind=kind, **kwargs)
        self.blob = blob
        self.public_certificate_location = public_certificate_location
        self.thumbprint = None


class PublicCertificateCollection(msrest.serialization.Model):
    """Collection of public certificates.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.PublicCertificate]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PublicCertificate]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["PublicCertificate"],
        **kwargs
    ):
        super(PublicCertificateCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class PushSettings(ProxyOnlyResource):
    """Push settings for the App.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param is_push_enabled: Gets or sets a flag indicating whether the Push endpoint is enabled.
    :type is_push_enabled: bool
    :param tag_whitelist_json: Gets or sets a JSON string containing a list of tags that are
     whitelisted for use by the push registration endpoint.
    :type tag_whitelist_json: str
    :param tags_requiring_auth: Gets or sets a JSON string containing a list of tags that require
     user authentication to be used in the push registration endpoint.
     Tags can consist of alphanumeric characters and the following:
     '_', '@', '#', '.', ':', '-'.
     Validation should be performed at the PushRequestHandler.
    :type tags_requiring_auth: str
    :param dynamic_tags_json: Gets or sets a JSON string containing a list of dynamic tags that
     will be evaluated from user claims in the push registration endpoint.
    :type dynamic_tags_json: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_push_enabled': {'key': 'properties.isPushEnabled', 'type': 'bool'},
        'tag_whitelist_json': {'key': 'properties.tagWhitelistJson', 'type': 'str'},
        'tags_requiring_auth': {'key': 'properties.tagsRequiringAuth', 'type': 'str'},
        'dynamic_tags_json': {'key': 'properties.dynamicTagsJson', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        is_push_enabled: Optional[bool] = None,
        tag_whitelist_json: Optional[str] = None,
        tags_requiring_auth: Optional[str] = None,
        dynamic_tags_json: Optional[str] = None,
        **kwargs
    ):
        super(PushSettings, self).__init__(kind=kind, **kwargs)
        self.is_push_enabled = is_push_enabled
        self.tag_whitelist_json = tag_whitelist_json
        self.tags_requiring_auth = tags_requiring_auth
        self.dynamic_tags_json = dynamic_tags_json


class RampUpRule(msrest.serialization.Model):
    """Routing rules for ramp up testing. This rule allows to redirect static traffic % to a slot or to gradually change routing % based on performance.

    :param action_host_name: Hostname of a slot to which the traffic will be redirected if decided
     to. E.g. myapp-stage.azurewebsites.net.
    :type action_host_name: str
    :param reroute_percentage: Percentage of the traffic which will be redirected to
     :code:`<code>ActionHostName</code>`.
    :type reroute_percentage: float
    :param change_step: In auto ramp up scenario this is the step to add/remove from
     :code:`<code>ReroutePercentage</code>` until it reaches
     \n:code:`<code>MinReroutePercentage</code>` or
     :code:`<code>MaxReroutePercentage</code>`. Site metrics are checked every N minutes specified
     in :code:`<code>ChangeIntervalInMinutes</code>`.\nCustom decision algorithm
     can be provided in TiPCallback site extension which URL can be specified in
     :code:`<code>ChangeDecisionCallbackUrl</code>`.
    :type change_step: float
    :param change_interval_in_minutes: Specifies interval in minutes to reevaluate
     ReroutePercentage.
    :type change_interval_in_minutes: int
    :param min_reroute_percentage: Specifies lower boundary above which ReroutePercentage will
     stay.
    :type min_reroute_percentage: float
    :param max_reroute_percentage: Specifies upper boundary below which ReroutePercentage will
     stay.
    :type max_reroute_percentage: float
    :param change_decision_callback_url: Custom decision algorithm can be provided in TiPCallback
     site extension which URL can be specified. See TiPCallback site extension for the scaffold and
     contracts.
     https://www.siteextensions.net/packages/TiPCallback/.
    :type change_decision_callback_url: str
    :param name: Name of the routing rule. The recommended name would be to point to the slot which
     will receive the traffic in the experiment.
    :type name: str
    """

    _attribute_map = {
        'action_host_name': {'key': 'actionHostName', 'type': 'str'},
        'reroute_percentage': {'key': 'reroutePercentage', 'type': 'float'},
        'change_step': {'key': 'changeStep', 'type': 'float'},
        'change_interval_in_minutes': {'key': 'changeIntervalInMinutes', 'type': 'int'},
        'min_reroute_percentage': {'key': 'minReroutePercentage', 'type': 'float'},
        'max_reroute_percentage': {'key': 'maxReroutePercentage', 'type': 'float'},
        'change_decision_callback_url': {'key': 'changeDecisionCallbackUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        action_host_name: Optional[str] = None,
        reroute_percentage: Optional[float] = None,
        change_step: Optional[float] = None,
        change_interval_in_minutes: Optional[int] = None,
        min_reroute_percentage: Optional[float] = None,
        max_reroute_percentage: Optional[float] = None,
        change_decision_callback_url: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs
    ):
        super(RampUpRule, self).__init__(**kwargs)
        self.action_host_name = action_host_name
        self.reroute_percentage = reroute_percentage
        self.change_step = change_step
        self.change_interval_in_minutes = change_interval_in_minutes
        self.min_reroute_percentage = min_reroute_percentage
        self.max_reroute_percentage = max_reroute_percentage
        self.change_decision_callback_url = change_decision_callback_url
        self.name = name


class Recommendation(ProxyOnlyResource):
    """Represents a recommendation result generated by the recommendation engine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param creation_time: Timestamp when this instance was created.
    :type creation_time: ~datetime.datetime
    :param recommendation_id: A GUID value that each recommendation object is associated with.
    :type recommendation_id: str
    :param resource_id: Full ARM resource ID string that this recommendation object is associated
     with.
    :type resource_id: str
    :param resource_scope: Name of a resource type this recommendation applies, e.g. Subscription,
     ServerFarm, Site. Possible values include: "ServerFarm", "Subscription", "WebSite".
    :type resource_scope: str or ~azure.mgmt.web.v2019_08_01.models.ResourceScopeType
    :param rule_name: Unique name of the rule.
    :type rule_name: str
    :param display_name: UI friendly name of the rule (may not be unique).
    :type display_name: str
    :param message: Recommendation text.
    :type message: str
    :param level: Level indicating how critical this recommendation can impact. Possible values
     include: "Critical", "Warning", "Information", "NonUrgentSuggestion".
    :type level: str or ~azure.mgmt.web.v2019_08_01.models.NotificationLevel
    :param channels: List of channels that this recommendation can apply. Possible values include:
     "Notification", "Api", "Email", "Webhook", "All".
    :type channels: str or ~azure.mgmt.web.v2019_08_01.models.Channels
    :ivar category_tags: The list of category tags that this recommendation belongs to.
    :vartype category_tags: list[str]
    :param action_name: Name of action recommended by this object.
    :type action_name: str
    :param enabled: True if this recommendation is still valid (i.e. "actionable"). False if it is
     invalid.
    :type enabled: int
    :param states: The list of states of this recommendation. If it's null then it should be
     considered "Active".
    :type states: list[str]
    :param start_time: The beginning time in UTC of a range that the recommendation refers to.
    :type start_time: ~datetime.datetime
    :param end_time: The end time in UTC of a range that the recommendation refers to.
    :type end_time: ~datetime.datetime
    :param next_notification_time: When to notify this recommendation next in UTC. Null means that
     this will never be notified anymore.
    :type next_notification_time: ~datetime.datetime
    :param notification_expiration_time: Date and time in UTC when this notification expires.
    :type notification_expiration_time: ~datetime.datetime
    :param notified_time: Last timestamp in UTC this instance was actually notified. Null means
     that this recommendation hasn't been notified yet.
    :type notified_time: ~datetime.datetime
    :param score: A metric value measured by the rule.
    :type score: float
    :param is_dynamic: True if this is associated with a dynamically added rule.
    :type is_dynamic: bool
    :param extension_name: Extension name of the portal if exists.
    :type extension_name: str
    :param blade_name: Deep link to a blade on the portal.
    :type blade_name: str
    :param forward_link: Forward link to an external document associated with the rule.
    :type forward_link: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'category_tags': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'recommendation_id': {'key': 'properties.recommendationId', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'resource_scope': {'key': 'properties.resourceScope', 'type': 'str'},
        'rule_name': {'key': 'properties.ruleName', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'message': {'key': 'properties.message', 'type': 'str'},
        'level': {'key': 'properties.level', 'type': 'str'},
        'channels': {'key': 'properties.channels', 'type': 'str'},
        'category_tags': {'key': 'properties.categoryTags', 'type': '[str]'},
        'action_name': {'key': 'properties.actionName', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'int'},
        'states': {'key': 'properties.states', 'type': '[str]'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'next_notification_time': {'key': 'properties.nextNotificationTime', 'type': 'iso-8601'},
        'notification_expiration_time': {'key': 'properties.notificationExpirationTime', 'type': 'iso-8601'},
        'notified_time': {'key': 'properties.notifiedTime', 'type': 'iso-8601'},
        'score': {'key': 'properties.score', 'type': 'float'},
        'is_dynamic': {'key': 'properties.isDynamic', 'type': 'bool'},
        'extension_name': {'key': 'properties.extensionName', 'type': 'str'},
        'blade_name': {'key': 'properties.bladeName', 'type': 'str'},
        'forward_link': {'key': 'properties.forwardLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        creation_time: Optional[datetime.datetime] = None,
        recommendation_id: Optional[str] = None,
        resource_id: Optional[str] = None,
        resource_scope: Optional[Union[str, "ResourceScopeType"]] = None,
        rule_name: Optional[str] = None,
        display_name: Optional[str] = None,
        message: Optional[str] = None,
        level: Optional[Union[str, "NotificationLevel"]] = None,
        channels: Optional[Union[str, "Channels"]] = None,
        action_name: Optional[str] = None,
        enabled: Optional[int] = None,
        states: Optional[List[str]] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        next_notification_time: Optional[datetime.datetime] = None,
        notification_expiration_time: Optional[datetime.datetime] = None,
        notified_time: Optional[datetime.datetime] = None,
        score: Optional[float] = None,
        is_dynamic: Optional[bool] = None,
        extension_name: Optional[str] = None,
        blade_name: Optional[str] = None,
        forward_link: Optional[str] = None,
        **kwargs
    ):
        super(Recommendation, self).__init__(kind=kind, **kwargs)
        self.creation_time = creation_time
        self.recommendation_id = recommendation_id
        self.resource_id = resource_id
        self.resource_scope = resource_scope
        self.rule_name = rule_name
        self.display_name = display_name
        self.message = message
        self.level = level
        self.channels = channels
        self.category_tags = None
        self.action_name = action_name
        self.enabled = enabled
        self.states = states
        self.start_time = start_time
        self.end_time = end_time
        self.next_notification_time = next_notification_time
        self.notification_expiration_time = notification_expiration_time
        self.notified_time = notified_time
        self.score = score
        self.is_dynamic = is_dynamic
        self.extension_name = extension_name
        self.blade_name = blade_name
        self.forward_link = forward_link


class RecommendationCollection(msrest.serialization.Model):
    """Collection of recommendations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.Recommendation]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Recommendation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["Recommendation"],
        **kwargs
    ):
        super(RecommendationCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class RecommendationRule(ProxyOnlyResource):
    """Represents a recommendation rule that the recommendation engine can perform.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param recommendation_name: Unique name of the rule.
    :type recommendation_name: str
    :param display_name: UI friendly name of the rule.
    :type display_name: str
    :param message: Localized name of the rule (Good for UI).
    :type message: str
    :param recommendation_id: Recommendation ID of an associated recommendation object tied to the
     rule, if exists.
     If such an object doesn't exist, it is set to null.
    :type recommendation_id: str
    :param description: Localized detailed description of the rule.
    :type description: str
    :param action_name: Name of action that is recommended by this rule in string.
    :type action_name: str
    :param level: Level of impact indicating how critical this rule is. Possible values include:
     "Critical", "Warning", "Information", "NonUrgentSuggestion".
    :type level: str or ~azure.mgmt.web.v2019_08_01.models.NotificationLevel
    :param channels: List of available channels that this rule applies. Possible values include:
     "Notification", "Api", "Email", "Webhook", "All".
    :type channels: str or ~azure.mgmt.web.v2019_08_01.models.Channels
    :ivar category_tags: The list of category tags that this recommendation rule belongs to.
    :vartype category_tags: list[str]
    :param is_dynamic: True if this is associated with a dynamically added rule.
    :type is_dynamic: bool
    :param extension_name: Extension name of the portal if exists. Applicable to dynamic rule only.
    :type extension_name: str
    :param blade_name: Deep link to a blade on the portal. Applicable to dynamic rule only.
    :type blade_name: str
    :param forward_link: Forward link to an external document associated with the rule. Applicable
     to dynamic rule only.
    :type forward_link: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'category_tags': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'recommendation_name': {'key': 'properties.recommendationName', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'message': {'key': 'properties.message', 'type': 'str'},
        'recommendation_id': {'key': 'properties.recommendationId', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'action_name': {'key': 'properties.actionName', 'type': 'str'},
        'level': {'key': 'properties.level', 'type': 'str'},
        'channels': {'key': 'properties.channels', 'type': 'str'},
        'category_tags': {'key': 'properties.categoryTags', 'type': '[str]'},
        'is_dynamic': {'key': 'properties.isDynamic', 'type': 'bool'},
        'extension_name': {'key': 'properties.extensionName', 'type': 'str'},
        'blade_name': {'key': 'properties.bladeName', 'type': 'str'},
        'forward_link': {'key': 'properties.forwardLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        recommendation_name: Optional[str] = None,
        display_name: Optional[str] = None,
        message: Optional[str] = None,
        recommendation_id: Optional[str] = None,
        description: Optional[str] = None,
        action_name: Optional[str] = None,
        level: Optional[Union[str, "NotificationLevel"]] = None,
        channels: Optional[Union[str, "Channels"]] = None,
        is_dynamic: Optional[bool] = None,
        extension_name: Optional[str] = None,
        blade_name: Optional[str] = None,
        forward_link: Optional[str] = None,
        **kwargs
    ):
        super(RecommendationRule, self).__init__(kind=kind, **kwargs)
        self.recommendation_name = recommendation_name
        self.display_name = display_name
        self.message = message
        self.recommendation_id = recommendation_id
        self.description = description
        self.action_name = action_name
        self.level = level
        self.channels = channels
        self.category_tags = None
        self.is_dynamic = is_dynamic
        self.extension_name = extension_name
        self.blade_name = blade_name
        self.forward_link = forward_link


class ReissueCertificateOrderRequest(ProxyOnlyResource):
    """Class representing certificate reissue request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param key_size: Certificate Key Size.
    :type key_size: int
    :param delay_existing_revoke_in_hours: Delay in hours to revoke existing certificate after the
     new certificate is issued.
    :type delay_existing_revoke_in_hours: int
    :param csr: Csr to be used for re-key operation.
    :type csr: str
    :param is_private_key_external: Should we change the ASC type (from managed private key to
     external private key and vice versa).
    :type is_private_key_external: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'key_size': {'key': 'properties.keySize', 'type': 'int'},
        'delay_existing_revoke_in_hours': {'key': 'properties.delayExistingRevokeInHours', 'type': 'int'},
        'csr': {'key': 'properties.csr', 'type': 'str'},
        'is_private_key_external': {'key': 'properties.isPrivateKeyExternal', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        key_size: Optional[int] = None,
        delay_existing_revoke_in_hours: Optional[int] = None,
        csr: Optional[str] = None,
        is_private_key_external: Optional[bool] = None,
        **kwargs
    ):
        super(ReissueCertificateOrderRequest, self).__init__(kind=kind, **kwargs)
        self.key_size = key_size
        self.delay_existing_revoke_in_hours = delay_existing_revoke_in_hours
        self.csr = csr
        self.is_private_key_external = is_private_key_external


class RelayServiceConnectionEntity(ProxyOnlyResource):
    """Hybrid Connection for an App Service app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param entity_name:
    :type entity_name: str
    :param entity_connection_string:
    :type entity_connection_string: str
    :param resource_type:
    :type resource_type: str
    :param resource_connection_string:
    :type resource_connection_string: str
    :param hostname:
    :type hostname: str
    :param port:
    :type port: int
    :param biztalk_uri:
    :type biztalk_uri: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'entity_name': {'key': 'properties.entityName', 'type': 'str'},
        'entity_connection_string': {'key': 'properties.entityConnectionString', 'type': 'str'},
        'resource_type': {'key': 'properties.resourceType', 'type': 'str'},
        'resource_connection_string': {'key': 'properties.resourceConnectionString', 'type': 'str'},
        'hostname': {'key': 'properties.hostname', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'biztalk_uri': {'key': 'properties.biztalkUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        entity_name: Optional[str] = None,
        entity_connection_string: Optional[str] = None,
        resource_type: Optional[str] = None,
        resource_connection_string: Optional[str] = None,
        hostname: Optional[str] = None,
        port: Optional[int] = None,
        biztalk_uri: Optional[str] = None,
        **kwargs
    ):
        super(RelayServiceConnectionEntity, self).__init__(kind=kind, **kwargs)
        self.entity_name = entity_name
        self.entity_connection_string = entity_connection_string
        self.resource_type = resource_type
        self.resource_connection_string = resource_connection_string
        self.hostname = hostname
        self.port = port
        self.biztalk_uri = biztalk_uri


class Rendering(msrest.serialization.Model):
    """Instructions for rendering the data.

    :param type: Rendering Type. Possible values include: "NoGraph", "Table", "TimeSeries",
     "TimeSeriesPerInstance".
    :type type: str or ~azure.mgmt.web.v2019_08_01.models.RenderingType
    :param title: Title of data.
    :type title: str
    :param description: Description of the data that will help it be interpreted.
    :type description: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'title': {'key': 'title', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "RenderingType"]] = None,
        title: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(Rendering, self).__init__(**kwargs)
        self.type = type
        self.title = title
        self.description = description


class RenewCertificateOrderRequest(ProxyOnlyResource):
    """Class representing certificate renew request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param key_size: Certificate Key Size.
    :type key_size: int
    :param csr: Csr to be used for re-key operation.
    :type csr: str
    :param is_private_key_external: Should we change the ASC type (from managed private key to
     external private key and vice versa).
    :type is_private_key_external: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'key_size': {'key': 'properties.keySize', 'type': 'int'},
        'csr': {'key': 'properties.csr', 'type': 'str'},
        'is_private_key_external': {'key': 'properties.isPrivateKeyExternal', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        key_size: Optional[int] = None,
        csr: Optional[str] = None,
        is_private_key_external: Optional[bool] = None,
        **kwargs
    ):
        super(RenewCertificateOrderRequest, self).__init__(kind=kind, **kwargs)
        self.key_size = key_size
        self.csr = csr
        self.is_private_key_external = is_private_key_external


class RequestsBasedTrigger(msrest.serialization.Model):
    """Trigger based on total requests.

    :param count: Request Count.
    :type count: int
    :param time_interval: Time interval.
    :type time_interval: str
    """

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'time_interval': {'key': 'timeInterval', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        time_interval: Optional[str] = None,
        **kwargs
    ):
        super(RequestsBasedTrigger, self).__init__(**kwargs)
        self.count = count
        self.time_interval = time_interval


class ResourceCollection(msrest.serialization.Model):
    """Collection of resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[str]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[str]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List[str],
        **kwargs
    ):
        super(ResourceCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ResourceHealthMetadata(ProxyOnlyResource):
    """Used for getting ResourceHealthCheck settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param category: The category that the resource matches in the RHC Policy File.
    :type category: str
    :param signal_availability: Is there a health signal for the resource.
    :type signal_availability: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'category': {'key': 'properties.category', 'type': 'str'},
        'signal_availability': {'key': 'properties.signalAvailability', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        category: Optional[str] = None,
        signal_availability: Optional[bool] = None,
        **kwargs
    ):
        super(ResourceHealthMetadata, self).__init__(kind=kind, **kwargs)
        self.category = category
        self.signal_availability = signal_availability


class ResourceHealthMetadataCollection(msrest.serialization.Model):
    """Collection of resource health metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.ResourceHealthMetadata]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceHealthMetadata]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["ResourceHealthMetadata"],
        **kwargs
    ):
        super(ResourceHealthMetadataCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ResourceMetricAvailability(msrest.serialization.Model):
    """Metrics availability and retention.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar time_grain: Time grain .
    :vartype time_grain: str
    :ivar retention: Retention period for the current time grain.
    :vartype retention: str
    """

    _validation = {
        'time_grain': {'readonly': True},
        'retention': {'readonly': True},
    }

    _attribute_map = {
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'retention': {'key': 'retention', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceMetricAvailability, self).__init__(**kwargs)
        self.time_grain = None
        self.retention = None


class ResourceMetricDefinition(ProxyOnlyResource):
    """Metadata for the metrics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar unit: Unit of the metric.
    :vartype unit: str
    :ivar primary_aggregation_type: Primary aggregation type.
    :vartype primary_aggregation_type: str
    :ivar metric_availabilities: List of time grains supported for the metric together with
     retention period.
    :vartype metric_availabilities:
     list[~azure.mgmt.web.v2019_08_01.models.ResourceMetricAvailability]
    :ivar resource_uri: Resource URI.
    :vartype resource_uri: str
    :ivar properties: Resource metric definition properties.
    :vartype properties: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'unit': {'readonly': True},
        'primary_aggregation_type': {'readonly': True},
        'metric_availabilities': {'readonly': True},
        'resource_uri': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'unit': {'key': 'properties.unit', 'type': 'str'},
        'primary_aggregation_type': {'key': 'properties.primaryAggregationType', 'type': 'str'},
        'metric_availabilities': {'key': 'properties.metricAvailabilities', 'type': '[ResourceMetricAvailability]'},
        'resource_uri': {'key': 'properties.resourceUri', 'type': 'str'},
        'properties': {'key': 'properties.properties', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        super(ResourceMetricDefinition, self).__init__(kind=kind, **kwargs)
        self.unit = None
        self.primary_aggregation_type = None
        self.metric_availabilities = None
        self.resource_uri = None
        self.properties = None


class ResourceMetricDefinitionCollection(msrest.serialization.Model):
    """Collection of metric definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.ResourceMetricDefinition]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceMetricDefinition]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["ResourceMetricDefinition"],
        **kwargs
    ):
        super(ResourceMetricDefinitionCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ResourceNameAvailability(msrest.serialization.Model):
    """Information regarding availability of a resource name.

    :param name_available: :code:`<code>true</code>` indicates name is valid and available.
     :code:`<code>false</code>` indicates the name is invalid, unavailable, or both.
    :type name_available: bool
    :param reason: :code:`<code>Invalid</code>` indicates the name provided does not match Azure
     App Service naming requirements. :code:`<code>AlreadyExists</code>` indicates that the name is
     already in use and is therefore unavailable. Possible values include: "Invalid",
     "AlreadyExists".
    :type reason: str or ~azure.mgmt.web.v2019_08_01.models.InAvailabilityReasonType
    :param message: If reason == invalid, provide the user with the reason why the given name is
     invalid, and provide the resource naming requirements so that the user can select a valid name.
     If reason == AlreadyExists, explain that resource name is already in use, and direct them to
     select a different name.
    :type message: str
    """

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[Union[str, "InAvailabilityReasonType"]] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ResourceNameAvailability, self).__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = message


class ResourceNameAvailabilityRequest(msrest.serialization.Model):
    """Resource name availability request content.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Resource name to verify.
    :type name: str
    :param type: Required. Resource type used for verification. Possible values include: "Site",
     "Slot", "HostingEnvironment", "PublishingUser", "Microsoft.Web/sites",
     "Microsoft.Web/sites/slots", "Microsoft.Web/hostingEnvironments",
     "Microsoft.Web/publishingUsers".
    :type type: str or ~azure.mgmt.web.v2019_08_01.models.CheckNameResourceTypes
    :param is_fqdn: Is fully qualified domain name.
    :type is_fqdn: bool
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_fqdn': {'key': 'isFqdn', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        type: Union[str, "CheckNameResourceTypes"],
        is_fqdn: Optional[bool] = None,
        **kwargs
    ):
        super(ResourceNameAvailabilityRequest, self).__init__(**kwargs)
        self.name = name
        self.type = type
        self.is_fqdn = is_fqdn


class ResponseMetaData(msrest.serialization.Model):
    """ResponseMetaData.

    :param data_source: Source of the Data.
    :type data_source: ~azure.mgmt.web.v2019_08_01.models.DataSource
    """

    _attribute_map = {
        'data_source': {'key': 'dataSource', 'type': 'DataSource'},
    }

    def __init__(
        self,
        *,
        data_source: Optional["DataSource"] = None,
        **kwargs
    ):
        super(ResponseMetaData, self).__init__(**kwargs)
        self.data_source = data_source


class RestoreRequest(ProxyOnlyResource):
    """Description of a restore request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param storage_account_url: SAS URL to the container.
    :type storage_account_url: str
    :param blob_name: Name of a blob which contains the backup.
    :type blob_name: str
    :param overwrite: :code:`<code>true</code>` if the restore operation can overwrite target app;
     otherwise, :code:`<code>false</code>`. :code:`<code>true</code>` is needed if trying to restore
     over an existing app.
    :type overwrite: bool
    :param site_name: Name of an app.
    :type site_name: str
    :param databases: Collection of databases which should be restored. This list has to match the
     list of databases included in the backup.
    :type databases: list[~azure.mgmt.web.v2019_08_01.models.DatabaseBackupSetting]
    :param ignore_conflicting_host_names: Changes a logic when restoring an app with custom
     domains. :code:`<code>true</code>` to remove custom domains automatically. If
     :code:`<code>false</code>`, custom domains are added to
     the app's object when it is being restored, but that might fail due to conflicts during the
     operation.
    :type ignore_conflicting_host_names: bool
    :param ignore_databases: Ignore the databases and only restore the site content.
    :type ignore_databases: bool
    :param app_service_plan: Specify app service plan that will own restored site.
    :type app_service_plan: str
    :param operation_type: Operation type. Possible values include: "Default", "Clone",
     "Relocation", "Snapshot", "CloudFS". Default value: "Default".
    :type operation_type: str or ~azure.mgmt.web.v2019_08_01.models.BackupRestoreOperationType
    :param adjust_connection_strings: :code:`<code>true</code>` if SiteConfig.ConnectionStrings
     should be set in new app; otherwise, :code:`<code>false</code>`.
    :type adjust_connection_strings: bool
    :param hosting_environment: App Service Environment name, if needed (only when restoring an app
     to an App Service Environment).
    :type hosting_environment: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'storage_account_url': {'key': 'properties.storageAccountUrl', 'type': 'str'},
        'blob_name': {'key': 'properties.blobName', 'type': 'str'},
        'overwrite': {'key': 'properties.overwrite', 'type': 'bool'},
        'site_name': {'key': 'properties.siteName', 'type': 'str'},
        'databases': {'key': 'properties.databases', 'type': '[DatabaseBackupSetting]'},
        'ignore_conflicting_host_names': {'key': 'properties.ignoreConflictingHostNames', 'type': 'bool'},
        'ignore_databases': {'key': 'properties.ignoreDatabases', 'type': 'bool'},
        'app_service_plan': {'key': 'properties.appServicePlan', 'type': 'str'},
        'operation_type': {'key': 'properties.operationType', 'type': 'str'},
        'adjust_connection_strings': {'key': 'properties.adjustConnectionStrings', 'type': 'bool'},
        'hosting_environment': {'key': 'properties.hostingEnvironment', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        storage_account_url: Optional[str] = None,
        blob_name: Optional[str] = None,
        overwrite: Optional[bool] = None,
        site_name: Optional[str] = None,
        databases: Optional[List["DatabaseBackupSetting"]] = None,
        ignore_conflicting_host_names: Optional[bool] = False,
        ignore_databases: Optional[bool] = False,
        app_service_plan: Optional[str] = None,
        operation_type: Optional[Union[str, "BackupRestoreOperationType"]] = "Default",
        adjust_connection_strings: Optional[bool] = None,
        hosting_environment: Optional[str] = None,
        **kwargs
    ):
        super(RestoreRequest, self).__init__(kind=kind, **kwargs)
        self.storage_account_url = storage_account_url
        self.blob_name = blob_name
        self.overwrite = overwrite
        self.site_name = site_name
        self.databases = databases
        self.ignore_conflicting_host_names = ignore_conflicting_host_names
        self.ignore_databases = ignore_databases
        self.app_service_plan = app_service_plan
        self.operation_type = operation_type
        self.adjust_connection_strings = adjust_connection_strings
        self.hosting_environment = hosting_environment


class ServiceSpecification(msrest.serialization.Model):
    """Resource metrics service provided by Microsoft.Insights resource provider.

    :param metric_specifications:
    :type metric_specifications: list[~azure.mgmt.web.v2019_08_01.models.MetricSpecification]
    :param log_specifications:
    :type log_specifications: list[~azure.mgmt.web.v2019_08_01.models.LogSpecification]
    """

    _attribute_map = {
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[MetricSpecification]'},
        'log_specifications': {'key': 'logSpecifications', 'type': '[LogSpecification]'},
    }

    def __init__(
        self,
        *,
        metric_specifications: Optional[List["MetricSpecification"]] = None,
        log_specifications: Optional[List["LogSpecification"]] = None,
        **kwargs
    ):
        super(ServiceSpecification, self).__init__(**kwargs)
        self.metric_specifications = metric_specifications
        self.log_specifications = log_specifications


class Site(Resource):
    """A web app, a mobile app backend, or an API app.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param identity: Managed service identity.
    :type identity: ~azure.mgmt.web.v2019_08_01.models.ManagedServiceIdentity
    :ivar state: Current state of the app.
    :vartype state: str
    :ivar host_names: Hostnames associated with the app.
    :vartype host_names: list[str]
    :ivar repository_site_name: Name of the repository site.
    :vartype repository_site_name: str
    :ivar usage_state: State indicating whether the app has exceeded its quota usage. Read-only.
     Possible values include: "Normal", "Exceeded".
    :vartype usage_state: str or ~azure.mgmt.web.v2019_08_01.models.UsageState
    :param enabled: :code:`<code>true</code>` if the app is enabled; otherwise,
     :code:`<code>false</code>`. Setting this value to false disables the app (takes the app
     offline).
    :type enabled: bool
    :ivar enabled_host_names: Enabled hostnames for the app.Hostnames need to be assigned (see
     HostNames) AND enabled. Otherwise,
     the app is not served on those hostnames.
    :vartype enabled_host_names: list[str]
    :ivar availability_state: Management information availability state for the app. Possible
     values include: "Normal", "Limited", "DisasterRecoveryMode".
    :vartype availability_state: str or ~azure.mgmt.web.v2019_08_01.models.SiteAvailabilityState
    :param host_name_ssl_states: Hostname SSL states are used to manage the SSL bindings for app's
     hostnames.
    :type host_name_ssl_states: list[~azure.mgmt.web.v2019_08_01.models.HostNameSslState]
    :param server_farm_id: Resource ID of the associated App Service plan, formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
    :type server_farm_id: str
    :param reserved: :code:`<code>true</code>` if reserved; otherwise, :code:`<code>false</code>`.
    :type reserved: bool
    :param is_xenon: Obsolete: Hyper-V sandbox.
    :type is_xenon: bool
    :param hyper_v: Hyper-V sandbox.
    :type hyper_v: bool
    :ivar last_modified_time_utc: Last time the app was modified, in UTC. Read-only.
    :vartype last_modified_time_utc: ~datetime.datetime
    :param site_config: Configuration of the app.
    :type site_config: ~azure.mgmt.web.v2019_08_01.models.SiteConfig
    :ivar traffic_manager_host_names: Azure Traffic Manager hostnames associated with the app.
     Read-only.
    :vartype traffic_manager_host_names: list[str]
    :param scm_site_also_stopped: :code:`<code>true</code>` to stop SCM (KUDU) site when the app is
     stopped; otherwise, :code:`<code>false</code>`. The default is :code:`<code>false</code>`.
    :type scm_site_also_stopped: bool
    :ivar target_swap_slot: Specifies which deployment slot this app will swap into. Read-only.
    :vartype target_swap_slot: str
    :param hosting_environment_profile: App Service Environment to use for the app.
    :type hosting_environment_profile: ~azure.mgmt.web.v2019_08_01.models.HostingEnvironmentProfile
    :param client_affinity_enabled: :code:`<code>true</code>` to enable client affinity;
     :code:`<code>false</code>` to stop sending session affinity cookies, which route client
     requests in the same session to the same instance. Default is :code:`<code>true</code>`.
    :type client_affinity_enabled: bool
    :param client_cert_enabled: :code:`<code>true</code>` to enable client certificate
     authentication (TLS mutual authentication); otherwise, :code:`<code>false</code>`. Default is
     :code:`<code>false</code>`.
    :type client_cert_enabled: bool
    :param client_cert_exclusion_paths: client certificate authentication comma-separated exclusion
     paths.
    :type client_cert_exclusion_paths: str
    :param host_names_disabled: :code:`<code>true</code>` to disable the public hostnames of the
     app; otherwise, :code:`<code>false</code>`.
      If :code:`<code>true</code>`, the app is only accessible via API management process.
    :type host_names_disabled: bool
    :ivar outbound_ip_addresses: List of IP addresses that the app uses for outbound connections
     (e.g. database access). Includes VIPs from tenants that site can be hosted with current
     settings. Read-only.
    :vartype outbound_ip_addresses: str
    :ivar possible_outbound_ip_addresses: List of IP addresses that the app uses for outbound
     connections (e.g. database access). Includes VIPs from all tenants except dataComponent.
     Read-only.
    :vartype possible_outbound_ip_addresses: str
    :param container_size: Size of the function container.
    :type container_size: int
    :param daily_memory_time_quota: Maximum allowed daily memory-time quota (applicable on dynamic
     apps only).
    :type daily_memory_time_quota: int
    :ivar suspended_till: App suspended till in case memory-time quota is exceeded.
    :vartype suspended_till: ~datetime.datetime
    :ivar max_number_of_workers: Maximum number of workers.
     This only applies to Functions container.
    :vartype max_number_of_workers: int
    :param cloning_info: If specified during app creation, the app is cloned from a source app.
    :type cloning_info: ~azure.mgmt.web.v2019_08_01.models.CloningInfo
    :ivar resource_group: Name of the resource group the app belongs to. Read-only.
    :vartype resource_group: str
    :ivar is_default_container: :code:`<code>true</code>` if the app is a default container;
     otherwise, :code:`<code>false</code>`.
    :vartype is_default_container: bool
    :ivar default_host_name: Default hostname of the app. Read-only.
    :vartype default_host_name: str
    :ivar slot_swap_status: Status of the last deployment slot swap operation.
    :vartype slot_swap_status: ~azure.mgmt.web.v2019_08_01.models.SlotSwapStatus
    :param https_only: HttpsOnly: configures a web site to accept only https requests. Issues
     redirect for
     http requests.
    :type https_only: bool
    :param redundancy_mode: Site redundancy mode. Possible values include: "None", "Manual",
     "Failover", "ActiveActive", "GeoRedundant".
    :type redundancy_mode: str or ~azure.mgmt.web.v2019_08_01.models.RedundancyMode
    :ivar in_progress_operation_id: Specifies an operation id if this site has a pending operation.
    :vartype in_progress_operation_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'state': {'readonly': True},
        'host_names': {'readonly': True},
        'repository_site_name': {'readonly': True},
        'usage_state': {'readonly': True},
        'enabled_host_names': {'readonly': True},
        'availability_state': {'readonly': True},
        'last_modified_time_utc': {'readonly': True},
        'traffic_manager_host_names': {'readonly': True},
        'target_swap_slot': {'readonly': True},
        'outbound_ip_addresses': {'readonly': True},
        'possible_outbound_ip_addresses': {'readonly': True},
        'suspended_till': {'readonly': True},
        'max_number_of_workers': {'readonly': True},
        'resource_group': {'readonly': True},
        'is_default_container': {'readonly': True},
        'default_host_name': {'readonly': True},
        'slot_swap_status': {'readonly': True},
        'in_progress_operation_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'host_names': {'key': 'properties.hostNames', 'type': '[str]'},
        'repository_site_name': {'key': 'properties.repositorySiteName', 'type': 'str'},
        'usage_state': {'key': 'properties.usageState', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'enabled_host_names': {'key': 'properties.enabledHostNames', 'type': '[str]'},
        'availability_state': {'key': 'properties.availabilityState', 'type': 'str'},
        'host_name_ssl_states': {'key': 'properties.hostNameSslStates', 'type': '[HostNameSslState]'},
        'server_farm_id': {'key': 'properties.serverFarmId', 'type': 'str'},
        'reserved': {'key': 'properties.reserved', 'type': 'bool'},
        'is_xenon': {'key': 'properties.isXenon', 'type': 'bool'},
        'hyper_v': {'key': 'properties.hyperV', 'type': 'bool'},
        'last_modified_time_utc': {'key': 'properties.lastModifiedTimeUtc', 'type': 'iso-8601'},
        'site_config': {'key': 'properties.siteConfig', 'type': 'SiteConfig'},
        'traffic_manager_host_names': {'key': 'properties.trafficManagerHostNames', 'type': '[str]'},
        'scm_site_also_stopped': {'key': 'properties.scmSiteAlsoStopped', 'type': 'bool'},
        'target_swap_slot': {'key': 'properties.targetSwapSlot', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'client_affinity_enabled': {'key': 'properties.clientAffinityEnabled', 'type': 'bool'},
        'client_cert_enabled': {'key': 'properties.clientCertEnabled', 'type': 'bool'},
        'client_cert_exclusion_paths': {'key': 'properties.clientCertExclusionPaths', 'type': 'str'},
        'host_names_disabled': {'key': 'properties.hostNamesDisabled', 'type': 'bool'},
        'outbound_ip_addresses': {'key': 'properties.outboundIpAddresses', 'type': 'str'},
        'possible_outbound_ip_addresses': {'key': 'properties.possibleOutboundIpAddresses', 'type': 'str'},
        'container_size': {'key': 'properties.containerSize', 'type': 'int'},
        'daily_memory_time_quota': {'key': 'properties.dailyMemoryTimeQuota', 'type': 'int'},
        'suspended_till': {'key': 'properties.suspendedTill', 'type': 'iso-8601'},
        'max_number_of_workers': {'key': 'properties.maxNumberOfWorkers', 'type': 'int'},
        'cloning_info': {'key': 'properties.cloningInfo', 'type': 'CloningInfo'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'is_default_container': {'key': 'properties.isDefaultContainer', 'type': 'bool'},
        'default_host_name': {'key': 'properties.defaultHostName', 'type': 'str'},
        'slot_swap_status': {'key': 'properties.slotSwapStatus', 'type': 'SlotSwapStatus'},
        'https_only': {'key': 'properties.httpsOnly', 'type': 'bool'},
        'redundancy_mode': {'key': 'properties.redundancyMode', 'type': 'str'},
        'in_progress_operation_id': {'key': 'properties.inProgressOperationId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["ManagedServiceIdentity"] = None,
        enabled: Optional[bool] = None,
        host_name_ssl_states: Optional[List["HostNameSslState"]] = None,
        server_farm_id: Optional[str] = None,
        reserved: Optional[bool] = False,
        is_xenon: Optional[bool] = False,
        hyper_v: Optional[bool] = False,
        site_config: Optional["SiteConfig"] = None,
        scm_site_also_stopped: Optional[bool] = False,
        hosting_environment_profile: Optional["HostingEnvironmentProfile"] = None,
        client_affinity_enabled: Optional[bool] = None,
        client_cert_enabled: Optional[bool] = None,
        client_cert_exclusion_paths: Optional[str] = None,
        host_names_disabled: Optional[bool] = None,
        container_size: Optional[int] = None,
        daily_memory_time_quota: Optional[int] = None,
        cloning_info: Optional["CloningInfo"] = None,
        https_only: Optional[bool] = None,
        redundancy_mode: Optional[Union[str, "RedundancyMode"]] = None,
        **kwargs
    ):
        super(Site, self).__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.identity = identity
        self.state = None
        self.host_names = None
        self.repository_site_name = None
        self.usage_state = None
        self.enabled = enabled
        self.enabled_host_names = None
        self.availability_state = None
        self.host_name_ssl_states = host_name_ssl_states
        self.server_farm_id = server_farm_id
        self.reserved = reserved
        self.is_xenon = is_xenon
        self.hyper_v = hyper_v
        self.last_modified_time_utc = None
        self.site_config = site_config
        self.traffic_manager_host_names = None
        self.scm_site_also_stopped = scm_site_also_stopped
        self.target_swap_slot = None
        self.hosting_environment_profile = hosting_environment_profile
        self.client_affinity_enabled = client_affinity_enabled
        self.client_cert_enabled = client_cert_enabled
        self.client_cert_exclusion_paths = client_cert_exclusion_paths
        self.host_names_disabled = host_names_disabled
        self.outbound_ip_addresses = None
        self.possible_outbound_ip_addresses = None
        self.container_size = container_size
        self.daily_memory_time_quota = daily_memory_time_quota
        self.suspended_till = None
        self.max_number_of_workers = None
        self.cloning_info = cloning_info
        self.resource_group = None
        self.is_default_container = None
        self.default_host_name = None
        self.slot_swap_status = None
        self.https_only = https_only
        self.redundancy_mode = redundancy_mode
        self.in_progress_operation_id = None


class SiteAuthSettings(ProxyOnlyResource):
    """Configuration settings for the Azure App Service Authentication / Authorization feature.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param enabled: :code:`<code>true</code>` if the Authentication / Authorization feature is
     enabled for the current app; otherwise, :code:`<code>false</code>`.
    :type enabled: bool
    :param runtime_version: The RuntimeVersion of the Authentication / Authorization feature in use
     for the current app.
     The setting in this value can control the behavior of certain features in the Authentication /
     Authorization module.
    :type runtime_version: str
    :param unauthenticated_client_action: The action to take when an unauthenticated client
     attempts to access the app. Possible values include: "RedirectToLoginPage", "AllowAnonymous".
    :type unauthenticated_client_action: str or
     ~azure.mgmt.web.v2019_08_01.models.UnauthenticatedClientAction
    :param token_store_enabled: :code:`<code>true</code>` to durably store platform-specific
     security tokens that are obtained during login flows; otherwise, :code:`<code>false</code>`.
      The default is :code:`<code>false</code>`.
    :type token_store_enabled: bool
    :param allowed_external_redirect_urls: External URLs that can be redirected to as part of
     logging in or logging out of the app. Note that the query string part of the URL is ignored.
     This is an advanced setting typically only needed by Windows Store application backends.
     Note that URLs within the current domain are always implicitly allowed.
    :type allowed_external_redirect_urls: list[str]
    :param default_provider: The default authentication provider to use when multiple providers are
     configured.
     This setting is only needed if multiple providers are configured and the unauthenticated
     client
     action is set to "RedirectToLoginPage". Possible values include: "AzureActiveDirectory",
     "Facebook", "Google", "MicrosoftAccount", "Twitter".
    :type default_provider: str or ~azure.mgmt.web.v2019_08_01.models.BuiltInAuthenticationProvider
    :param token_refresh_extension_hours: The number of hours after session token expiration that a
     session token can be used to
     call the token refresh API. The default is 72 hours.
    :type token_refresh_extension_hours: float
    :param client_id: The Client ID of this relying party application, known as the client_id.
     This setting is required for enabling OpenID Connection authentication with Azure Active
     Directory or
     other 3rd party OpenID Connect providers.
     More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html.
    :type client_id: str
    :param client_secret: The Client Secret of this relying party application (in Azure Active
     Directory, this is also referred to as the Key).
     This setting is optional. If no client secret is configured, the OpenID Connect implicit auth
     flow is used to authenticate end users.
     Otherwise, the OpenID Connect Authorization Code Flow is used to authenticate end users.
     More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html.
    :type client_secret: str
    :param client_secret_certificate_thumbprint: An alternative to the client secret, that is the
     thumbprint of a certificate used for signing purposes. This property acts as
     a replacement for the Client Secret. It is also optional.
    :type client_secret_certificate_thumbprint: str
    :param issuer: The OpenID Connect Issuer URI that represents the entity which issues access
     tokens for this application.
     When using Azure Active Directory, this value is the URI of the directory tenant, e.g.
     https://sts.windows.net/{tenant-guid}/.
     This URI is a case-sensitive identifier for the token issuer.
     More information on OpenID Connect Discovery:
     http://openid.net/specs/openid-connect-discovery-1_0.html.
    :type issuer: str
    :param validate_issuer: Gets a value indicating whether the issuer should be a valid HTTPS url
     and be validated as such.
    :type validate_issuer: bool
    :param allowed_audiences: Allowed audience values to consider when validating JWTs issued by
     Azure Active Directory. Note that the :code:`<code>ClientID</code>` value is always considered
     an
     allowed audience, regardless of this setting.
    :type allowed_audiences: list[str]
    :param additional_login_params: Login parameters to send to the OpenID Connect authorization
     endpoint when
     a user logs in. Each parameter must be in the form "key=value".
    :type additional_login_params: list[str]
    :param google_client_id: The OpenID Connect Client ID for the Google web application.
     This setting is required for enabling Google Sign-In.
     Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/.
    :type google_client_id: str
    :param google_client_secret: The client secret associated with the Google web application.
     This setting is required for enabling Google Sign-In.
     Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/.
    :type google_client_secret: str
    :param google_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of Google
     Sign-In authentication.
     This setting is optional. If not specified, "openid", "profile", and "email" are used as
     default scopes.
     Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/.
    :type google_o_auth_scopes: list[str]
    :param facebook_app_id: The App ID of the Facebook app used for login.
     This setting is required for enabling Facebook Login.
     Facebook Login documentation: https://developers.facebook.com/docs/facebook-login.
    :type facebook_app_id: str
    :param facebook_app_secret: The App Secret of the Facebook app used for Facebook Login.
     This setting is required for enabling Facebook Login.
     Facebook Login documentation: https://developers.facebook.com/docs/facebook-login.
    :type facebook_app_secret: str
    :param facebook_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of Facebook
     Login authentication.
     This setting is optional.
     Facebook Login documentation: https://developers.facebook.com/docs/facebook-login.
    :type facebook_o_auth_scopes: list[str]
    :param twitter_consumer_key: The OAuth 1.0a consumer key of the Twitter application used for
     sign-in.
     This setting is required for enabling Twitter Sign-In.
     Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in.
    :type twitter_consumer_key: str
    :param twitter_consumer_secret: The OAuth 1.0a consumer secret of the Twitter application used
     for sign-in.
     This setting is required for enabling Twitter Sign-In.
     Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in.
    :type twitter_consumer_secret: str
    :param microsoft_account_client_id: The OAuth 2.0 client ID that was created for the app used
     for authentication.
     This setting is required for enabling Microsoft Account authentication.
     Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm.
    :type microsoft_account_client_id: str
    :param microsoft_account_client_secret: The OAuth 2.0 client secret that was created for the
     app used for authentication.
     This setting is required for enabling Microsoft Account authentication.
     Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm.
    :type microsoft_account_client_secret: str
    :param microsoft_account_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of
     Microsoft Account authentication.
     This setting is optional. If not specified, "wl.basic" is used as the default scope.
     Microsoft Account Scopes and permissions documentation:
     https://msdn.microsoft.com/en-us/library/dn631845.aspx.
    :type microsoft_account_o_auth_scopes: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'runtime_version': {'key': 'properties.runtimeVersion', 'type': 'str'},
        'unauthenticated_client_action': {'key': 'properties.unauthenticatedClientAction', 'type': 'str'},
        'token_store_enabled': {'key': 'properties.tokenStoreEnabled', 'type': 'bool'},
        'allowed_external_redirect_urls': {'key': 'properties.allowedExternalRedirectUrls', 'type': '[str]'},
        'default_provider': {'key': 'properties.defaultProvider', 'type': 'str'},
        'token_refresh_extension_hours': {'key': 'properties.tokenRefreshExtensionHours', 'type': 'float'},
        'client_id': {'key': 'properties.clientId', 'type': 'str'},
        'client_secret': {'key': 'properties.clientSecret', 'type': 'str'},
        'client_secret_certificate_thumbprint': {'key': 'properties.clientSecretCertificateThumbprint', 'type': 'str'},
        'issuer': {'key': 'properties.issuer', 'type': 'str'},
        'validate_issuer': {'key': 'properties.validateIssuer', 'type': 'bool'},
        'allowed_audiences': {'key': 'properties.allowedAudiences', 'type': '[str]'},
        'additional_login_params': {'key': 'properties.additionalLoginParams', 'type': '[str]'},
        'google_client_id': {'key': 'properties.googleClientId', 'type': 'str'},
        'google_client_secret': {'key': 'properties.googleClientSecret', 'type': 'str'},
        'google_o_auth_scopes': {'key': 'properties.googleOAuthScopes', 'type': '[str]'},
        'facebook_app_id': {'key': 'properties.facebookAppId', 'type': 'str'},
        'facebook_app_secret': {'key': 'properties.facebookAppSecret', 'type': 'str'},
        'facebook_o_auth_scopes': {'key': 'properties.facebookOAuthScopes', 'type': '[str]'},
        'twitter_consumer_key': {'key': 'properties.twitterConsumerKey', 'type': 'str'},
        'twitter_consumer_secret': {'key': 'properties.twitterConsumerSecret', 'type': 'str'},
        'microsoft_account_client_id': {'key': 'properties.microsoftAccountClientId', 'type': 'str'},
        'microsoft_account_client_secret': {'key': 'properties.microsoftAccountClientSecret', 'type': 'str'},
        'microsoft_account_o_auth_scopes': {'key': 'properties.microsoftAccountOAuthScopes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        enabled: Optional[bool] = None,
        runtime_version: Optional[str] = None,
        unauthenticated_client_action: Optional[Union[str, "UnauthenticatedClientAction"]] = None,
        token_store_enabled: Optional[bool] = None,
        allowed_external_redirect_urls: Optional[List[str]] = None,
        default_provider: Optional[Union[str, "BuiltInAuthenticationProvider"]] = None,
        token_refresh_extension_hours: Optional[float] = None,
        client_id: Optional[str] = None,
        client_secret: Optional[str] = None,
        client_secret_certificate_thumbprint: Optional[str] = None,
        issuer: Optional[str] = None,
        validate_issuer: Optional[bool] = None,
        allowed_audiences: Optional[List[str]] = None,
        additional_login_params: Optional[List[str]] = None,
        google_client_id: Optional[str] = None,
        google_client_secret: Optional[str] = None,
        google_o_auth_scopes: Optional[List[str]] = None,
        facebook_app_id: Optional[str] = None,
        facebook_app_secret: Optional[str] = None,
        facebook_o_auth_scopes: Optional[List[str]] = None,
        twitter_consumer_key: Optional[str] = None,
        twitter_consumer_secret: Optional[str] = None,
        microsoft_account_client_id: Optional[str] = None,
        microsoft_account_client_secret: Optional[str] = None,
        microsoft_account_o_auth_scopes: Optional[List[str]] = None,
        **kwargs
    ):
        super(SiteAuthSettings, self).__init__(kind=kind, **kwargs)
        self.enabled = enabled
        self.runtime_version = runtime_version
        self.unauthenticated_client_action = unauthenticated_client_action
        self.token_store_enabled = token_store_enabled
        self.allowed_external_redirect_urls = allowed_external_redirect_urls
        self.default_provider = default_provider
        self.token_refresh_extension_hours = token_refresh_extension_hours
        self.client_id = client_id
        self.client_secret = client_secret
        self.client_secret_certificate_thumbprint = client_secret_certificate_thumbprint
        self.issuer = issuer
        self.validate_issuer = validate_issuer
        self.allowed_audiences = allowed_audiences
        self.additional_login_params = additional_login_params
        self.google_client_id = google_client_id
        self.google_client_secret = google_client_secret
        self.google_o_auth_scopes = google_o_auth_scopes
        self.facebook_app_id = facebook_app_id
        self.facebook_app_secret = facebook_app_secret
        self.facebook_o_auth_scopes = facebook_o_auth_scopes
        self.twitter_consumer_key = twitter_consumer_key
        self.twitter_consumer_secret = twitter_consumer_secret
        self.microsoft_account_client_id = microsoft_account_client_id
        self.microsoft_account_client_secret = microsoft_account_client_secret
        self.microsoft_account_o_auth_scopes = microsoft_account_o_auth_scopes


class SiteCloneability(msrest.serialization.Model):
    """Represents whether or not an app is cloneable.

    :param result: Name of app. Possible values include: "Cloneable", "PartiallyCloneable",
     "NotCloneable".
    :type result: str or ~azure.mgmt.web.v2019_08_01.models.CloneAbilityResult
    :param blocking_features: List of features enabled on app that prevent cloning.
    :type blocking_features: list[~azure.mgmt.web.v2019_08_01.models.SiteCloneabilityCriterion]
    :param unsupported_features: List of features enabled on app that are non-blocking but cannot
     be cloned. The app can still be cloned
     but the features in this list will not be set up on cloned app.
    :type unsupported_features: list[~azure.mgmt.web.v2019_08_01.models.SiteCloneabilityCriterion]
    :param blocking_characteristics: List of blocking application characteristics.
    :type blocking_characteristics:
     list[~azure.mgmt.web.v2019_08_01.models.SiteCloneabilityCriterion]
    """

    _attribute_map = {
        'result': {'key': 'result', 'type': 'str'},
        'blocking_features': {'key': 'blockingFeatures', 'type': '[SiteCloneabilityCriterion]'},
        'unsupported_features': {'key': 'unsupportedFeatures', 'type': '[SiteCloneabilityCriterion]'},
        'blocking_characteristics': {'key': 'blockingCharacteristics', 'type': '[SiteCloneabilityCriterion]'},
    }

    def __init__(
        self,
        *,
        result: Optional[Union[str, "CloneAbilityResult"]] = None,
        blocking_features: Optional[List["SiteCloneabilityCriterion"]] = None,
        unsupported_features: Optional[List["SiteCloneabilityCriterion"]] = None,
        blocking_characteristics: Optional[List["SiteCloneabilityCriterion"]] = None,
        **kwargs
    ):
        super(SiteCloneability, self).__init__(**kwargs)
        self.result = result
        self.blocking_features = blocking_features
        self.unsupported_features = unsupported_features
        self.blocking_characteristics = blocking_characteristics


class SiteCloneabilityCriterion(msrest.serialization.Model):
    """An app cloneability criterion.

    :param name: Name of criterion.
    :type name: str
    :param description: Description of criterion.
    :type description: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(SiteCloneabilityCriterion, self).__init__(**kwargs)
        self.name = name
        self.description = description


class SiteConfig(msrest.serialization.Model):
    """Configuration of an App Service app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param number_of_workers: Number of workers.
    :type number_of_workers: int
    :param default_documents: Default documents.
    :type default_documents: list[str]
    :param net_framework_version: .NET Framework version.
    :type net_framework_version: str
    :param php_version: Version of PHP.
    :type php_version: str
    :param python_version: Version of Python.
    :type python_version: str
    :param node_version: Version of Node.js.
    :type node_version: str
    :param power_shell_version: Version of PowerShell.
    :type power_shell_version: str
    :param linux_fx_version: Linux App Framework and version.
    :type linux_fx_version: str
    :param windows_fx_version: Xenon App Framework and version.
    :type windows_fx_version: str
    :param request_tracing_enabled: :code:`<code>true</code>` if request tracing is enabled;
     otherwise, :code:`<code>false</code>`.
    :type request_tracing_enabled: bool
    :param request_tracing_expiration_time: Request tracing expiration time.
    :type request_tracing_expiration_time: ~datetime.datetime
    :param remote_debugging_enabled: :code:`<code>true</code>` if remote debugging is enabled;
     otherwise, :code:`<code>false</code>`.
    :type remote_debugging_enabled: bool
    :param remote_debugging_version: Remote debugging version.
    :type remote_debugging_version: str
    :param http_logging_enabled: :code:`<code>true</code>` if HTTP logging is enabled; otherwise,
     :code:`<code>false</code>`.
    :type http_logging_enabled: bool
    :param acr_use_managed_identity_creds: Flag to use Managed Identity Creds for ACR pull.
    :type acr_use_managed_identity_creds: bool
    :param acr_user_managed_identity_id: If using user managed identity, the user managed identity
     ClientId.
    :type acr_user_managed_identity_id: str
    :param logs_directory_size_limit: HTTP logs directory size limit.
    :type logs_directory_size_limit: int
    :param detailed_error_logging_enabled: :code:`<code>true</code>` if detailed error logging is
     enabled; otherwise, :code:`<code>false</code>`.
    :type detailed_error_logging_enabled: bool
    :param publishing_username: Publishing user name.
    :type publishing_username: str
    :param app_settings: Application settings.
    :type app_settings: list[~azure.mgmt.web.v2019_08_01.models.NameValuePair]
    :param connection_strings: Connection strings.
    :type connection_strings: list[~azure.mgmt.web.v2019_08_01.models.ConnStringInfo]
    :ivar machine_key: Site MachineKey.
    :vartype machine_key: ~azure.mgmt.web.v2019_08_01.models.SiteMachineKey
    :param handler_mappings: Handler mappings.
    :type handler_mappings: list[~azure.mgmt.web.v2019_08_01.models.HandlerMapping]
    :param document_root: Document root.
    :type document_root: str
    :param scm_type: SCM type. Possible values include: "None", "Dropbox", "Tfs", "LocalGit",
     "GitHub", "CodePlexGit", "CodePlexHg", "BitbucketGit", "BitbucketHg", "ExternalGit",
     "ExternalHg", "OneDrive", "VSO", "VSTSRM".
    :type scm_type: str or ~azure.mgmt.web.v2019_08_01.models.ScmType
    :param use32_bit_worker_process: :code:`<code>true</code>` to use 32-bit worker process;
     otherwise, :code:`<code>false</code>`.
    :type use32_bit_worker_process: bool
    :param web_sockets_enabled: :code:`<code>true</code>` if WebSocket is enabled; otherwise,
     :code:`<code>false</code>`.
    :type web_sockets_enabled: bool
    :param always_on: :code:`<code>true</code>` if Always On is enabled; otherwise,
     :code:`<code>false</code>`.
    :type always_on: bool
    :param java_version: Java version.
    :type java_version: str
    :param java_container: Java container.
    :type java_container: str
    :param java_container_version: Java container version.
    :type java_container_version: str
    :param app_command_line: App command line to launch.
    :type app_command_line: str
    :param managed_pipeline_mode: Managed pipeline mode. Possible values include: "Integrated",
     "Classic".
    :type managed_pipeline_mode: str or ~azure.mgmt.web.v2019_08_01.models.ManagedPipelineMode
    :param virtual_applications: Virtual applications.
    :type virtual_applications: list[~azure.mgmt.web.v2019_08_01.models.VirtualApplication]
    :param load_balancing: Site load balancing. Possible values include: "WeightedRoundRobin",
     "LeastRequests", "LeastResponseTime", "WeightedTotalTraffic", "RequestHash".
    :type load_balancing: str or ~azure.mgmt.web.v2019_08_01.models.SiteLoadBalancing
    :param experiments: This is work around for polymorphic types.
    :type experiments: ~azure.mgmt.web.v2019_08_01.models.Experiments
    :param limits: Site limits.
    :type limits: ~azure.mgmt.web.v2019_08_01.models.SiteLimits
    :param auto_heal_enabled: :code:`<code>true</code>` if Auto Heal is enabled; otherwise,
     :code:`<code>false</code>`.
    :type auto_heal_enabled: bool
    :param auto_heal_rules: Auto Heal rules.
    :type auto_heal_rules: ~azure.mgmt.web.v2019_08_01.models.AutoHealRules
    :param tracing_options: Tracing options.
    :type tracing_options: str
    :param vnet_name: Virtual Network name.
    :type vnet_name: str
    :param cors: Cross-Origin Resource Sharing (CORS) settings.
    :type cors: ~azure.mgmt.web.v2019_08_01.models.CorsSettings
    :param push: Push endpoint settings.
    :type push: ~azure.mgmt.web.v2019_08_01.models.PushSettings
    :param api_definition: Information about the formal API definition for the app.
    :type api_definition: ~azure.mgmt.web.v2019_08_01.models.ApiDefinitionInfo
    :param api_management_config: Azure API management settings linked to the app.
    :type api_management_config: ~azure.mgmt.web.v2019_08_01.models.ApiManagementConfig
    :param auto_swap_slot_name: Auto-swap slot name.
    :type auto_swap_slot_name: str
    :param local_my_sql_enabled: :code:`<code>true</code>` to enable local MySQL; otherwise,
     :code:`<code>false</code>`.
    :type local_my_sql_enabled: bool
    :param managed_service_identity_id: Managed Service Identity Id.
    :type managed_service_identity_id: int
    :param x_managed_service_identity_id: Explicit Managed Service Identity Id.
    :type x_managed_service_identity_id: int
    :param ip_security_restrictions: IP security restrictions for main.
    :type ip_security_restrictions: list[~azure.mgmt.web.v2019_08_01.models.IpSecurityRestriction]
    :param scm_ip_security_restrictions: IP security restrictions for scm.
    :type scm_ip_security_restrictions:
     list[~azure.mgmt.web.v2019_08_01.models.IpSecurityRestriction]
    :param scm_ip_security_restrictions_use_main: IP security restrictions for scm to use main.
    :type scm_ip_security_restrictions_use_main: bool
    :param http20_enabled: Http20Enabled: configures a web site to allow clients to connect over
     http2.0.
    :type http20_enabled: bool
    :param min_tls_version: MinTlsVersion: configures the minimum version of TLS required for SSL
     requests. Possible values include: "1.0", "1.1", "1.2".
    :type min_tls_version: str or ~azure.mgmt.web.v2019_08_01.models.SupportedTlsVersions
    :param ftps_state: State of FTP / FTPS service. Possible values include: "AllAllowed",
     "FtpsOnly", "Disabled".
    :type ftps_state: str or ~azure.mgmt.web.v2019_08_01.models.FtpsState
    :param pre_warmed_instance_count: Number of preWarmed instances.
     This setting only applies to the Consumption and Elastic Plans.
    :type pre_warmed_instance_count: int
    :param health_check_path: Health check path.
    :type health_check_path: str
    """

    _validation = {
        'machine_key': {'readonly': True},
        'pre_warmed_instance_count': {'maximum': 10, 'minimum': 0},
    }

    _attribute_map = {
        'number_of_workers': {'key': 'numberOfWorkers', 'type': 'int'},
        'default_documents': {'key': 'defaultDocuments', 'type': '[str]'},
        'net_framework_version': {'key': 'netFrameworkVersion', 'type': 'str'},
        'php_version': {'key': 'phpVersion', 'type': 'str'},
        'python_version': {'key': 'pythonVersion', 'type': 'str'},
        'node_version': {'key': 'nodeVersion', 'type': 'str'},
        'power_shell_version': {'key': 'powerShellVersion', 'type': 'str'},
        'linux_fx_version': {'key': 'linuxFxVersion', 'type': 'str'},
        'windows_fx_version': {'key': 'windowsFxVersion', 'type': 'str'},
        'request_tracing_enabled': {'key': 'requestTracingEnabled', 'type': 'bool'},
        'request_tracing_expiration_time': {'key': 'requestTracingExpirationTime', 'type': 'iso-8601'},
        'remote_debugging_enabled': {'key': 'remoteDebuggingEnabled', 'type': 'bool'},
        'remote_debugging_version': {'key': 'remoteDebuggingVersion', 'type': 'str'},
        'http_logging_enabled': {'key': 'httpLoggingEnabled', 'type': 'bool'},
        'acr_use_managed_identity_creds': {'key': 'acrUseManagedIdentityCreds', 'type': 'bool'},
        'acr_user_managed_identity_id': {'key': 'acrUserManagedIdentityID', 'type': 'str'},
        'logs_directory_size_limit': {'key': 'logsDirectorySizeLimit', 'type': 'int'},
        'detailed_error_logging_enabled': {'key': 'detailedErrorLoggingEnabled', 'type': 'bool'},
        'publishing_username': {'key': 'publishingUsername', 'type': 'str'},
        'app_settings': {'key': 'appSettings', 'type': '[NameValuePair]'},
        'connection_strings': {'key': 'connectionStrings', 'type': '[ConnStringInfo]'},
        'machine_key': {'key': 'machineKey', 'type': 'SiteMachineKey'},
        'handler_mappings': {'key': 'handlerMappings', 'type': '[HandlerMapping]'},
        'document_root': {'key': 'documentRoot', 'type': 'str'},
        'scm_type': {'key': 'scmType', 'type': 'str'},
        'use32_bit_worker_process': {'key': 'use32BitWorkerProcess', 'type': 'bool'},
        'web_sockets_enabled': {'key': 'webSocketsEnabled', 'type': 'bool'},
        'always_on': {'key': 'alwaysOn', 'type': 'bool'},
        'java_version': {'key': 'javaVersion', 'type': 'str'},
        'java_container': {'key': 'javaContainer', 'type': 'str'},
        'java_container_version': {'key': 'javaContainerVersion', 'type': 'str'},
        'app_command_line': {'key': 'appCommandLine', 'type': 'str'},
        'managed_pipeline_mode': {'key': 'managedPipelineMode', 'type': 'str'},
        'virtual_applications': {'key': 'virtualApplications', 'type': '[VirtualApplication]'},
        'load_balancing': {'key': 'loadBalancing', 'type': 'str'},
        'experiments': {'key': 'experiments', 'type': 'Experiments'},
        'limits': {'key': 'limits', 'type': 'SiteLimits'},
        'auto_heal_enabled': {'key': 'autoHealEnabled', 'type': 'bool'},
        'auto_heal_rules': {'key': 'autoHealRules', 'type': 'AutoHealRules'},
        'tracing_options': {'key': 'tracingOptions', 'type': 'str'},
        'vnet_name': {'key': 'vnetName', 'type': 'str'},
        'cors': {'key': 'cors', 'type': 'CorsSettings'},
        'push': {'key': 'push', 'type': 'PushSettings'},
        'api_definition': {'key': 'apiDefinition', 'type': 'ApiDefinitionInfo'},
        'api_management_config': {'key': 'apiManagementConfig', 'type': 'ApiManagementConfig'},
        'auto_swap_slot_name': {'key': 'autoSwapSlotName', 'type': 'str'},
        'local_my_sql_enabled': {'key': 'localMySqlEnabled', 'type': 'bool'},
        'managed_service_identity_id': {'key': 'managedServiceIdentityId', 'type': 'int'},
        'x_managed_service_identity_id': {'key': 'xManagedServiceIdentityId', 'type': 'int'},
        'ip_security_restrictions': {'key': 'ipSecurityRestrictions', 'type': '[IpSecurityRestriction]'},
        'scm_ip_security_restrictions': {'key': 'scmIpSecurityRestrictions', 'type': '[IpSecurityRestriction]'},
        'scm_ip_security_restrictions_use_main': {'key': 'scmIpSecurityRestrictionsUseMain', 'type': 'bool'},
        'http20_enabled': {'key': 'http20Enabled', 'type': 'bool'},
        'min_tls_version': {'key': 'minTlsVersion', 'type': 'str'},
        'ftps_state': {'key': 'ftpsState', 'type': 'str'},
        'pre_warmed_instance_count': {'key': 'preWarmedInstanceCount', 'type': 'int'},
        'health_check_path': {'key': 'healthCheckPath', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        number_of_workers: Optional[int] = None,
        default_documents: Optional[List[str]] = None,
        net_framework_version: Optional[str] = "v4.6",
        php_version: Optional[str] = None,
        python_version: Optional[str] = None,
        node_version: Optional[str] = None,
        power_shell_version: Optional[str] = None,
        linux_fx_version: Optional[str] = None,
        windows_fx_version: Optional[str] = None,
        request_tracing_enabled: Optional[bool] = None,
        request_tracing_expiration_time: Optional[datetime.datetime] = None,
        remote_debugging_enabled: Optional[bool] = None,
        remote_debugging_version: Optional[str] = None,
        http_logging_enabled: Optional[bool] = None,
        acr_use_managed_identity_creds: Optional[bool] = None,
        acr_user_managed_identity_id: Optional[str] = None,
        logs_directory_size_limit: Optional[int] = None,
        detailed_error_logging_enabled: Optional[bool] = None,
        publishing_username: Optional[str] = None,
        app_settings: Optional[List["NameValuePair"]] = None,
        connection_strings: Optional[List["ConnStringInfo"]] = None,
        handler_mappings: Optional[List["HandlerMapping"]] = None,
        document_root: Optional[str] = None,
        scm_type: Optional[Union[str, "ScmType"]] = None,
        use32_bit_worker_process: Optional[bool] = None,
        web_sockets_enabled: Optional[bool] = None,
        always_on: Optional[bool] = None,
        java_version: Optional[str] = None,
        java_container: Optional[str] = None,
        java_container_version: Optional[str] = None,
        app_command_line: Optional[str] = None,
        managed_pipeline_mode: Optional[Union[str, "ManagedPipelineMode"]] = None,
        virtual_applications: Optional[List["VirtualApplication"]] = None,
        load_balancing: Optional[Union[str, "SiteLoadBalancing"]] = None,
        experiments: Optional["Experiments"] = None,
        limits: Optional["SiteLimits"] = None,
        auto_heal_enabled: Optional[bool] = None,
        auto_heal_rules: Optional["AutoHealRules"] = None,
        tracing_options: Optional[str] = None,
        vnet_name: Optional[str] = None,
        cors: Optional["CorsSettings"] = None,
        push: Optional["PushSettings"] = None,
        api_definition: Optional["ApiDefinitionInfo"] = None,
        api_management_config: Optional["ApiManagementConfig"] = None,
        auto_swap_slot_name: Optional[str] = None,
        local_my_sql_enabled: Optional[bool] = False,
        managed_service_identity_id: Optional[int] = None,
        x_managed_service_identity_id: Optional[int] = None,
        ip_security_restrictions: Optional[List["IpSecurityRestriction"]] = None,
        scm_ip_security_restrictions: Optional[List["IpSecurityRestriction"]] = None,
        scm_ip_security_restrictions_use_main: Optional[bool] = None,
        http20_enabled: Optional[bool] = True,
        min_tls_version: Optional[Union[str, "SupportedTlsVersions"]] = None,
        ftps_state: Optional[Union[str, "FtpsState"]] = None,
        pre_warmed_instance_count: Optional[int] = None,
        health_check_path: Optional[str] = None,
        **kwargs
    ):
        super(SiteConfig, self).__init__(**kwargs)
        self.number_of_workers = number_of_workers
        self.default_documents = default_documents
        self.net_framework_version = net_framework_version
        self.php_version = php_version
        self.python_version = python_version
        self.node_version = node_version
        self.power_shell_version = power_shell_version
        self.linux_fx_version = linux_fx_version
        self.windows_fx_version = windows_fx_version
        self.request_tracing_enabled = request_tracing_enabled
        self.request_tracing_expiration_time = request_tracing_expiration_time
        self.remote_debugging_enabled = remote_debugging_enabled
        self.remote_debugging_version = remote_debugging_version
        self.http_logging_enabled = http_logging_enabled
        self.acr_use_managed_identity_creds = acr_use_managed_identity_creds
        self.acr_user_managed_identity_id = acr_user_managed_identity_id
        self.logs_directory_size_limit = logs_directory_size_limit
        self.detailed_error_logging_enabled = detailed_error_logging_enabled
        self.publishing_username = publishing_username
        self.app_settings = app_settings
        self.connection_strings = connection_strings
        self.machine_key = None
        self.handler_mappings = handler_mappings
        self.document_root = document_root
        self.scm_type = scm_type
        self.use32_bit_worker_process = use32_bit_worker_process
        self.web_sockets_enabled = web_sockets_enabled
        self.always_on = always_on
        self.java_version = java_version
        self.java_container = java_container
        self.java_container_version = java_container_version
        self.app_command_line = app_command_line
        self.managed_pipeline_mode = managed_pipeline_mode
        self.virtual_applications = virtual_applications
        self.load_balancing = load_balancing
        self.experiments = experiments
        self.limits = limits
        self.auto_heal_enabled = auto_heal_enabled
        self.auto_heal_rules = auto_heal_rules
        self.tracing_options = tracing_options
        self.vnet_name = vnet_name
        self.cors = cors
        self.push = push
        self.api_definition = api_definition
        self.api_management_config = api_management_config
        self.auto_swap_slot_name = auto_swap_slot_name
        self.local_my_sql_enabled = local_my_sql_enabled
        self.managed_service_identity_id = managed_service_identity_id
        self.x_managed_service_identity_id = x_managed_service_identity_id
        self.ip_security_restrictions = ip_security_restrictions
        self.scm_ip_security_restrictions = scm_ip_security_restrictions
        self.scm_ip_security_restrictions_use_main = scm_ip_security_restrictions_use_main
        self.http20_enabled = http20_enabled
        self.min_tls_version = min_tls_version
        self.ftps_state = ftps_state
        self.pre_warmed_instance_count = pre_warmed_instance_count
        self.health_check_path = health_check_path


class SiteConfigResource(ProxyOnlyResource):
    """Web app configuration ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param number_of_workers: Number of workers.
    :type number_of_workers: int
    :param default_documents: Default documents.
    :type default_documents: list[str]
    :param net_framework_version: .NET Framework version.
    :type net_framework_version: str
    :param php_version: Version of PHP.
    :type php_version: str
    :param python_version: Version of Python.
    :type python_version: str
    :param node_version: Version of Node.js.
    :type node_version: str
    :param power_shell_version: Version of PowerShell.
    :type power_shell_version: str
    :param linux_fx_version: Linux App Framework and version.
    :type linux_fx_version: str
    :param windows_fx_version: Xenon App Framework and version.
    :type windows_fx_version: str
    :param request_tracing_enabled: :code:`<code>true</code>` if request tracing is enabled;
     otherwise, :code:`<code>false</code>`.
    :type request_tracing_enabled: bool
    :param request_tracing_expiration_time: Request tracing expiration time.
    :type request_tracing_expiration_time: ~datetime.datetime
    :param remote_debugging_enabled: :code:`<code>true</code>` if remote debugging is enabled;
     otherwise, :code:`<code>false</code>`.
    :type remote_debugging_enabled: bool
    :param remote_debugging_version: Remote debugging version.
    :type remote_debugging_version: str
    :param http_logging_enabled: :code:`<code>true</code>` if HTTP logging is enabled; otherwise,
     :code:`<code>false</code>`.
    :type http_logging_enabled: bool
    :param acr_use_managed_identity_creds: Flag to use Managed Identity Creds for ACR pull.
    :type acr_use_managed_identity_creds: bool
    :param acr_user_managed_identity_id: If using user managed identity, the user managed identity
     ClientId.
    :type acr_user_managed_identity_id: str
    :param logs_directory_size_limit: HTTP logs directory size limit.
    :type logs_directory_size_limit: int
    :param detailed_error_logging_enabled: :code:`<code>true</code>` if detailed error logging is
     enabled; otherwise, :code:`<code>false</code>`.
    :type detailed_error_logging_enabled: bool
    :param publishing_username: Publishing user name.
    :type publishing_username: str
    :param app_settings: Application settings.
    :type app_settings: list[~azure.mgmt.web.v2019_08_01.models.NameValuePair]
    :param connection_strings: Connection strings.
    :type connection_strings: list[~azure.mgmt.web.v2019_08_01.models.ConnStringInfo]
    :ivar machine_key: Site MachineKey.
    :vartype machine_key: ~azure.mgmt.web.v2019_08_01.models.SiteMachineKey
    :param handler_mappings: Handler mappings.
    :type handler_mappings: list[~azure.mgmt.web.v2019_08_01.models.HandlerMapping]
    :param document_root: Document root.
    :type document_root: str
    :param scm_type: SCM type. Possible values include: "None", "Dropbox", "Tfs", "LocalGit",
     "GitHub", "CodePlexGit", "CodePlexHg", "BitbucketGit", "BitbucketHg", "ExternalGit",
     "ExternalHg", "OneDrive", "VSO", "VSTSRM".
    :type scm_type: str or ~azure.mgmt.web.v2019_08_01.models.ScmType
    :param use32_bit_worker_process: :code:`<code>true</code>` to use 32-bit worker process;
     otherwise, :code:`<code>false</code>`.
    :type use32_bit_worker_process: bool
    :param web_sockets_enabled: :code:`<code>true</code>` if WebSocket is enabled; otherwise,
     :code:`<code>false</code>`.
    :type web_sockets_enabled: bool
    :param always_on: :code:`<code>true</code>` if Always On is enabled; otherwise,
     :code:`<code>false</code>`.
    :type always_on: bool
    :param java_version: Java version.
    :type java_version: str
    :param java_container: Java container.
    :type java_container: str
    :param java_container_version: Java container version.
    :type java_container_version: str
    :param app_command_line: App command line to launch.
    :type app_command_line: str
    :param managed_pipeline_mode: Managed pipeline mode. Possible values include: "Integrated",
     "Classic".
    :type managed_pipeline_mode: str or ~azure.mgmt.web.v2019_08_01.models.ManagedPipelineMode
    :param virtual_applications: Virtual applications.
    :type virtual_applications: list[~azure.mgmt.web.v2019_08_01.models.VirtualApplication]
    :param load_balancing: Site load balancing. Possible values include: "WeightedRoundRobin",
     "LeastRequests", "LeastResponseTime", "WeightedTotalTraffic", "RequestHash".
    :type load_balancing: str or ~azure.mgmt.web.v2019_08_01.models.SiteLoadBalancing
    :param experiments: This is work around for polymorphic types.
    :type experiments: ~azure.mgmt.web.v2019_08_01.models.Experiments
    :param limits: Site limits.
    :type limits: ~azure.mgmt.web.v2019_08_01.models.SiteLimits
    :param auto_heal_enabled: :code:`<code>true</code>` if Auto Heal is enabled; otherwise,
     :code:`<code>false</code>`.
    :type auto_heal_enabled: bool
    :param auto_heal_rules: Auto Heal rules.
    :type auto_heal_rules: ~azure.mgmt.web.v2019_08_01.models.AutoHealRules
    :param tracing_options: Tracing options.
    :type tracing_options: str
    :param vnet_name: Virtual Network name.
    :type vnet_name: str
    :param cors: Cross-Origin Resource Sharing (CORS) settings.
    :type cors: ~azure.mgmt.web.v2019_08_01.models.CorsSettings
    :param push: Push endpoint settings.
    :type push: ~azure.mgmt.web.v2019_08_01.models.PushSettings
    :param api_definition: Information about the formal API definition for the app.
    :type api_definition: ~azure.mgmt.web.v2019_08_01.models.ApiDefinitionInfo
    :param api_management_config: Azure API management settings linked to the app.
    :type api_management_config: ~azure.mgmt.web.v2019_08_01.models.ApiManagementConfig
    :param auto_swap_slot_name: Auto-swap slot name.
    :type auto_swap_slot_name: str
    :param local_my_sql_enabled: :code:`<code>true</code>` to enable local MySQL; otherwise,
     :code:`<code>false</code>`.
    :type local_my_sql_enabled: bool
    :param managed_service_identity_id: Managed Service Identity Id.
    :type managed_service_identity_id: int
    :param x_managed_service_identity_id: Explicit Managed Service Identity Id.
    :type x_managed_service_identity_id: int
    :param ip_security_restrictions: IP security restrictions for main.
    :type ip_security_restrictions: list[~azure.mgmt.web.v2019_08_01.models.IpSecurityRestriction]
    :param scm_ip_security_restrictions: IP security restrictions for scm.
    :type scm_ip_security_restrictions:
     list[~azure.mgmt.web.v2019_08_01.models.IpSecurityRestriction]
    :param scm_ip_security_restrictions_use_main: IP security restrictions for scm to use main.
    :type scm_ip_security_restrictions_use_main: bool
    :param http20_enabled: Http20Enabled: configures a web site to allow clients to connect over
     http2.0.
    :type http20_enabled: bool
    :param min_tls_version: MinTlsVersion: configures the minimum version of TLS required for SSL
     requests. Possible values include: "1.0", "1.1", "1.2".
    :type min_tls_version: str or ~azure.mgmt.web.v2019_08_01.models.SupportedTlsVersions
    :param ftps_state: State of FTP / FTPS service. Possible values include: "AllAllowed",
     "FtpsOnly", "Disabled".
    :type ftps_state: str or ~azure.mgmt.web.v2019_08_01.models.FtpsState
    :param pre_warmed_instance_count: Number of preWarmed instances.
     This setting only applies to the Consumption and Elastic Plans.
    :type pre_warmed_instance_count: int
    :param health_check_path: Health check path.
    :type health_check_path: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'machine_key': {'readonly': True},
        'pre_warmed_instance_count': {'maximum': 10, 'minimum': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'number_of_workers': {'key': 'properties.numberOfWorkers', 'type': 'int'},
        'default_documents': {'key': 'properties.defaultDocuments', 'type': '[str]'},
        'net_framework_version': {'key': 'properties.netFrameworkVersion', 'type': 'str'},
        'php_version': {'key': 'properties.phpVersion', 'type': 'str'},
        'python_version': {'key': 'properties.pythonVersion', 'type': 'str'},
        'node_version': {'key': 'properties.nodeVersion', 'type': 'str'},
        'power_shell_version': {'key': 'properties.powerShellVersion', 'type': 'str'},
        'linux_fx_version': {'key': 'properties.linuxFxVersion', 'type': 'str'},
        'windows_fx_version': {'key': 'properties.windowsFxVersion', 'type': 'str'},
        'request_tracing_enabled': {'key': 'properties.requestTracingEnabled', 'type': 'bool'},
        'request_tracing_expiration_time': {'key': 'properties.requestTracingExpirationTime', 'type': 'iso-8601'},
        'remote_debugging_enabled': {'key': 'properties.remoteDebuggingEnabled', 'type': 'bool'},
        'remote_debugging_version': {'key': 'properties.remoteDebuggingVersion', 'type': 'str'},
        'http_logging_enabled': {'key': 'properties.httpLoggingEnabled', 'type': 'bool'},
        'acr_use_managed_identity_creds': {'key': 'properties.acrUseManagedIdentityCreds', 'type': 'bool'},
        'acr_user_managed_identity_id': {'key': 'properties.acrUserManagedIdentityID', 'type': 'str'},
        'logs_directory_size_limit': {'key': 'properties.logsDirectorySizeLimit', 'type': 'int'},
        'detailed_error_logging_enabled': {'key': 'properties.detailedErrorLoggingEnabled', 'type': 'bool'},
        'publishing_username': {'key': 'properties.publishingUsername', 'type': 'str'},
        'app_settings': {'key': 'properties.appSettings', 'type': '[NameValuePair]'},
        'connection_strings': {'key': 'properties.connectionStrings', 'type': '[ConnStringInfo]'},
        'machine_key': {'key': 'properties.machineKey', 'type': 'SiteMachineKey'},
        'handler_mappings': {'key': 'properties.handlerMappings', 'type': '[HandlerMapping]'},
        'document_root': {'key': 'properties.documentRoot', 'type': 'str'},
        'scm_type': {'key': 'properties.scmType', 'type': 'str'},
        'use32_bit_worker_process': {'key': 'properties.use32BitWorkerProcess', 'type': 'bool'},
        'web_sockets_enabled': {'key': 'properties.webSocketsEnabled', 'type': 'bool'},
        'always_on': {'key': 'properties.alwaysOn', 'type': 'bool'},
        'java_version': {'key': 'properties.javaVersion', 'type': 'str'},
        'java_container': {'key': 'properties.javaContainer', 'type': 'str'},
        'java_container_version': {'key': 'properties.javaContainerVersion', 'type': 'str'},
        'app_command_line': {'key': 'properties.appCommandLine', 'type': 'str'},
        'managed_pipeline_mode': {'key': 'properties.managedPipelineMode', 'type': 'str'},
        'virtual_applications': {'key': 'properties.virtualApplications', 'type': '[VirtualApplication]'},
        'load_balancing': {'key': 'properties.loadBalancing', 'type': 'str'},
        'experiments': {'key': 'properties.experiments', 'type': 'Experiments'},
        'limits': {'key': 'properties.limits', 'type': 'SiteLimits'},
        'auto_heal_enabled': {'key': 'properties.autoHealEnabled', 'type': 'bool'},
        'auto_heal_rules': {'key': 'properties.autoHealRules', 'type': 'AutoHealRules'},
        'tracing_options': {'key': 'properties.tracingOptions', 'type': 'str'},
        'vnet_name': {'key': 'properties.vnetName', 'type': 'str'},
        'cors': {'key': 'properties.cors', 'type': 'CorsSettings'},
        'push': {'key': 'properties.push', 'type': 'PushSettings'},
        'api_definition': {'key': 'properties.apiDefinition', 'type': 'ApiDefinitionInfo'},
        'api_management_config': {'key': 'properties.apiManagementConfig', 'type': 'ApiManagementConfig'},
        'auto_swap_slot_name': {'key': 'properties.autoSwapSlotName', 'type': 'str'},
        'local_my_sql_enabled': {'key': 'properties.localMySqlEnabled', 'type': 'bool'},
        'managed_service_identity_id': {'key': 'properties.managedServiceIdentityId', 'type': 'int'},
        'x_managed_service_identity_id': {'key': 'properties.xManagedServiceIdentityId', 'type': 'int'},
        'ip_security_restrictions': {'key': 'properties.ipSecurityRestrictions', 'type': '[IpSecurityRestriction]'},
        'scm_ip_security_restrictions': {'key': 'properties.scmIpSecurityRestrictions', 'type': '[IpSecurityRestriction]'},
        'scm_ip_security_restrictions_use_main': {'key': 'properties.scmIpSecurityRestrictionsUseMain', 'type': 'bool'},
        'http20_enabled': {'key': 'properties.http20Enabled', 'type': 'bool'},
        'min_tls_version': {'key': 'properties.minTlsVersion', 'type': 'str'},
        'ftps_state': {'key': 'properties.ftpsState', 'type': 'str'},
        'pre_warmed_instance_count': {'key': 'properties.preWarmedInstanceCount', 'type': 'int'},
        'health_check_path': {'key': 'properties.healthCheckPath', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        number_of_workers: Optional[int] = None,
        default_documents: Optional[List[str]] = None,
        net_framework_version: Optional[str] = "v4.6",
        php_version: Optional[str] = None,
        python_version: Optional[str] = None,
        node_version: Optional[str] = None,
        power_shell_version: Optional[str] = None,
        linux_fx_version: Optional[str] = None,
        windows_fx_version: Optional[str] = None,
        request_tracing_enabled: Optional[bool] = None,
        request_tracing_expiration_time: Optional[datetime.datetime] = None,
        remote_debugging_enabled: Optional[bool] = None,
        remote_debugging_version: Optional[str] = None,
        http_logging_enabled: Optional[bool] = None,
        acr_use_managed_identity_creds: Optional[bool] = None,
        acr_user_managed_identity_id: Optional[str] = None,
        logs_directory_size_limit: Optional[int] = None,
        detailed_error_logging_enabled: Optional[bool] = None,
        publishing_username: Optional[str] = None,
        app_settings: Optional[List["NameValuePair"]] = None,
        connection_strings: Optional[List["ConnStringInfo"]] = None,
        handler_mappings: Optional[List["HandlerMapping"]] = None,
        document_root: Optional[str] = None,
        scm_type: Optional[Union[str, "ScmType"]] = None,
        use32_bit_worker_process: Optional[bool] = None,
        web_sockets_enabled: Optional[bool] = None,
        always_on: Optional[bool] = None,
        java_version: Optional[str] = None,
        java_container: Optional[str] = None,
        java_container_version: Optional[str] = None,
        app_command_line: Optional[str] = None,
        managed_pipeline_mode: Optional[Union[str, "ManagedPipelineMode"]] = None,
        virtual_applications: Optional[List["VirtualApplication"]] = None,
        load_balancing: Optional[Union[str, "SiteLoadBalancing"]] = None,
        experiments: Optional["Experiments"] = None,
        limits: Optional["SiteLimits"] = None,
        auto_heal_enabled: Optional[bool] = None,
        auto_heal_rules: Optional["AutoHealRules"] = None,
        tracing_options: Optional[str] = None,
        vnet_name: Optional[str] = None,
        cors: Optional["CorsSettings"] = None,
        push: Optional["PushSettings"] = None,
        api_definition: Optional["ApiDefinitionInfo"] = None,
        api_management_config: Optional["ApiManagementConfig"] = None,
        auto_swap_slot_name: Optional[str] = None,
        local_my_sql_enabled: Optional[bool] = False,
        managed_service_identity_id: Optional[int] = None,
        x_managed_service_identity_id: Optional[int] = None,
        ip_security_restrictions: Optional[List["IpSecurityRestriction"]] = None,
        scm_ip_security_restrictions: Optional[List["IpSecurityRestriction"]] = None,
        scm_ip_security_restrictions_use_main: Optional[bool] = None,
        http20_enabled: Optional[bool] = True,
        min_tls_version: Optional[Union[str, "SupportedTlsVersions"]] = None,
        ftps_state: Optional[Union[str, "FtpsState"]] = None,
        pre_warmed_instance_count: Optional[int] = None,
        health_check_path: Optional[str] = None,
        **kwargs
    ):
        super(SiteConfigResource, self).__init__(kind=kind, **kwargs)
        self.number_of_workers = number_of_workers
        self.default_documents = default_documents
        self.net_framework_version = net_framework_version
        self.php_version = php_version
        self.python_version = python_version
        self.node_version = node_version
        self.power_shell_version = power_shell_version
        self.linux_fx_version = linux_fx_version
        self.windows_fx_version = windows_fx_version
        self.request_tracing_enabled = request_tracing_enabled
        self.request_tracing_expiration_time = request_tracing_expiration_time
        self.remote_debugging_enabled = remote_debugging_enabled
        self.remote_debugging_version = remote_debugging_version
        self.http_logging_enabled = http_logging_enabled
        self.acr_use_managed_identity_creds = acr_use_managed_identity_creds
        self.acr_user_managed_identity_id = acr_user_managed_identity_id
        self.logs_directory_size_limit = logs_directory_size_limit
        self.detailed_error_logging_enabled = detailed_error_logging_enabled
        self.publishing_username = publishing_username
        self.app_settings = app_settings
        self.connection_strings = connection_strings
        self.machine_key = None
        self.handler_mappings = handler_mappings
        self.document_root = document_root
        self.scm_type = scm_type
        self.use32_bit_worker_process = use32_bit_worker_process
        self.web_sockets_enabled = web_sockets_enabled
        self.always_on = always_on
        self.java_version = java_version
        self.java_container = java_container
        self.java_container_version = java_container_version
        self.app_command_line = app_command_line
        self.managed_pipeline_mode = managed_pipeline_mode
        self.virtual_applications = virtual_applications
        self.load_balancing = load_balancing
        self.experiments = experiments
        self.limits = limits
        self.auto_heal_enabled = auto_heal_enabled
        self.auto_heal_rules = auto_heal_rules
        self.tracing_options = tracing_options
        self.vnet_name = vnet_name
        self.cors = cors
        self.push = push
        self.api_definition = api_definition
        self.api_management_config = api_management_config
        self.auto_swap_slot_name = auto_swap_slot_name
        self.local_my_sql_enabled = local_my_sql_enabled
        self.managed_service_identity_id = managed_service_identity_id
        self.x_managed_service_identity_id = x_managed_service_identity_id
        self.ip_security_restrictions = ip_security_restrictions
        self.scm_ip_security_restrictions = scm_ip_security_restrictions
        self.scm_ip_security_restrictions_use_main = scm_ip_security_restrictions_use_main
        self.http20_enabled = http20_enabled
        self.min_tls_version = min_tls_version
        self.ftps_state = ftps_state
        self.pre_warmed_instance_count = pre_warmed_instance_count
        self.health_check_path = health_check_path


class SiteConfigResourceCollection(msrest.serialization.Model):
    """Collection of site configurations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.SiteConfigResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SiteConfigResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["SiteConfigResource"],
        **kwargs
    ):
        super(SiteConfigResourceCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class SiteConfigurationSnapshotInfo(ProxyOnlyResource):
    """A snapshot of a web app configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar time: The time the snapshot was taken.
    :vartype time: ~datetime.datetime
    :ivar snapshot_id: The id of the snapshot.
    :vartype snapshot_id: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'time': {'readonly': True},
        'snapshot_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'time': {'key': 'properties.time', 'type': 'iso-8601'},
        'snapshot_id': {'key': 'properties.snapshotId', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        super(SiteConfigurationSnapshotInfo, self).__init__(kind=kind, **kwargs)
        self.time = None
        self.snapshot_id = None


class SiteConfigurationSnapshotInfoCollection(msrest.serialization.Model):
    """Collection of metadata for the app configuration snapshots that can be restored.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.SiteConfigurationSnapshotInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SiteConfigurationSnapshotInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["SiteConfigurationSnapshotInfo"],
        **kwargs
    ):
        super(SiteConfigurationSnapshotInfoCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class SiteExtensionInfo(ProxyOnlyResource):
    """Site Extension Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param extension_id: Site extension ID.
    :type extension_id: str
    :param title:
    :type title: str
    :param extension_type: Site extension type. Possible values include: "Gallery", "WebRoot".
    :type extension_type: str or ~azure.mgmt.web.v2019_08_01.models.SiteExtensionType
    :param summary: Summary description.
    :type summary: str
    :param description: Detailed description.
    :type description: str
    :param version: Version information.
    :type version: str
    :param extension_url: Extension URL.
    :type extension_url: str
    :param project_url: Project URL.
    :type project_url: str
    :param icon_url: Icon URL.
    :type icon_url: str
    :param license_url: License URL.
    :type license_url: str
    :param feed_url: Feed URL.
    :type feed_url: str
    :param authors: List of authors.
    :type authors: list[str]
    :param installer_command_line_params: Installer command line parameters.
    :type installer_command_line_params: str
    :param published_date_time: Published timestamp.
    :type published_date_time: ~datetime.datetime
    :param download_count: Count of downloads.
    :type download_count: int
    :param local_is_latest_version: :code:`<code>true</code>` if the local version is the latest
     version; :code:`<code>false</code>` otherwise.
    :type local_is_latest_version: bool
    :param local_path: Local path.
    :type local_path: str
    :param installed_date_time: Installed timestamp.
    :type installed_date_time: ~datetime.datetime
    :param provisioning_state: Provisioning state.
    :type provisioning_state: str
    :param comment: Site Extension comment.
    :type comment: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'extension_id': {'key': 'properties.extension_id', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'extension_type': {'key': 'properties.extension_type', 'type': 'str'},
        'summary': {'key': 'properties.summary', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'extension_url': {'key': 'properties.extension_url', 'type': 'str'},
        'project_url': {'key': 'properties.project_url', 'type': 'str'},
        'icon_url': {'key': 'properties.icon_url', 'type': 'str'},
        'license_url': {'key': 'properties.license_url', 'type': 'str'},
        'feed_url': {'key': 'properties.feed_url', 'type': 'str'},
        'authors': {'key': 'properties.authors', 'type': '[str]'},
        'installer_command_line_params': {'key': 'properties.installer_command_line_params', 'type': 'str'},
        'published_date_time': {'key': 'properties.published_date_time', 'type': 'iso-8601'},
        'download_count': {'key': 'properties.download_count', 'type': 'int'},
        'local_is_latest_version': {'key': 'properties.local_is_latest_version', 'type': 'bool'},
        'local_path': {'key': 'properties.local_path', 'type': 'str'},
        'installed_date_time': {'key': 'properties.installed_date_time', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'comment': {'key': 'properties.comment', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        extension_id: Optional[str] = None,
        title: Optional[str] = None,
        extension_type: Optional[Union[str, "SiteExtensionType"]] = None,
        summary: Optional[str] = None,
        description: Optional[str] = None,
        version: Optional[str] = None,
        extension_url: Optional[str] = None,
        project_url: Optional[str] = None,
        icon_url: Optional[str] = None,
        license_url: Optional[str] = None,
        feed_url: Optional[str] = None,
        authors: Optional[List[str]] = None,
        installer_command_line_params: Optional[str] = None,
        published_date_time: Optional[datetime.datetime] = None,
        download_count: Optional[int] = None,
        local_is_latest_version: Optional[bool] = None,
        local_path: Optional[str] = None,
        installed_date_time: Optional[datetime.datetime] = None,
        provisioning_state: Optional[str] = None,
        comment: Optional[str] = None,
        **kwargs
    ):
        super(SiteExtensionInfo, self).__init__(kind=kind, **kwargs)
        self.extension_id = extension_id
        self.title = title
        self.extension_type = extension_type
        self.summary = summary
        self.description = description
        self.version = version
        self.extension_url = extension_url
        self.project_url = project_url
        self.icon_url = icon_url
        self.license_url = license_url
        self.feed_url = feed_url
        self.authors = authors
        self.installer_command_line_params = installer_command_line_params
        self.published_date_time = published_date_time
        self.download_count = download_count
        self.local_is_latest_version = local_is_latest_version
        self.local_path = local_path
        self.installed_date_time = installed_date_time
        self.provisioning_state = provisioning_state
        self.comment = comment


class SiteExtensionInfoCollection(msrest.serialization.Model):
    """Collection of Kudu site extension information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.SiteExtensionInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SiteExtensionInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["SiteExtensionInfo"],
        **kwargs
    ):
        super(SiteExtensionInfoCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class SiteInstance(ProxyOnlyResource):
    """Instance of an app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar site_instance_name: Name of instance.
    :vartype site_instance_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'site_instance_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'site_instance_name': {'key': 'properties.siteInstanceName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        super(SiteInstance, self).__init__(kind=kind, **kwargs)
        self.site_instance_name = None


class SiteLimits(msrest.serialization.Model):
    """Metric limits set on an app.

    :param max_percentage_cpu: Maximum allowed CPU usage percentage.
    :type max_percentage_cpu: float
    :param max_memory_in_mb: Maximum allowed memory usage in MB.
    :type max_memory_in_mb: long
    :param max_disk_size_in_mb: Maximum allowed disk size usage in MB.
    :type max_disk_size_in_mb: long
    """

    _attribute_map = {
        'max_percentage_cpu': {'key': 'maxPercentageCpu', 'type': 'float'},
        'max_memory_in_mb': {'key': 'maxMemoryInMb', 'type': 'long'},
        'max_disk_size_in_mb': {'key': 'maxDiskSizeInMb', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        max_percentage_cpu: Optional[float] = None,
        max_memory_in_mb: Optional[int] = None,
        max_disk_size_in_mb: Optional[int] = None,
        **kwargs
    ):
        super(SiteLimits, self).__init__(**kwargs)
        self.max_percentage_cpu = max_percentage_cpu
        self.max_memory_in_mb = max_memory_in_mb
        self.max_disk_size_in_mb = max_disk_size_in_mb


class SiteLogsConfig(ProxyOnlyResource):
    """Configuration of App Service site logs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param application_logs: Application logs configuration.
    :type application_logs: ~azure.mgmt.web.v2019_08_01.models.ApplicationLogsConfig
    :param http_logs: HTTP logs configuration.
    :type http_logs: ~azure.mgmt.web.v2019_08_01.models.HttpLogsConfig
    :param failed_requests_tracing: Failed requests tracing configuration.
    :type failed_requests_tracing: ~azure.mgmt.web.v2019_08_01.models.EnabledConfig
    :param detailed_error_messages: Detailed error messages configuration.
    :type detailed_error_messages: ~azure.mgmt.web.v2019_08_01.models.EnabledConfig
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'application_logs': {'key': 'properties.applicationLogs', 'type': 'ApplicationLogsConfig'},
        'http_logs': {'key': 'properties.httpLogs', 'type': 'HttpLogsConfig'},
        'failed_requests_tracing': {'key': 'properties.failedRequestsTracing', 'type': 'EnabledConfig'},
        'detailed_error_messages': {'key': 'properties.detailedErrorMessages', 'type': 'EnabledConfig'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        application_logs: Optional["ApplicationLogsConfig"] = None,
        http_logs: Optional["HttpLogsConfig"] = None,
        failed_requests_tracing: Optional["EnabledConfig"] = None,
        detailed_error_messages: Optional["EnabledConfig"] = None,
        **kwargs
    ):
        super(SiteLogsConfig, self).__init__(kind=kind, **kwargs)
        self.application_logs = application_logs
        self.http_logs = http_logs
        self.failed_requests_tracing = failed_requests_tracing
        self.detailed_error_messages = detailed_error_messages


class SiteMachineKey(msrest.serialization.Model):
    """MachineKey of an app.

    :param validation: MachineKey validation.
    :type validation: str
    :param validation_key: Validation key.
    :type validation_key: str
    :param decryption: Algorithm used for decryption.
    :type decryption: str
    :param decryption_key: Decryption key.
    :type decryption_key: str
    """

    _attribute_map = {
        'validation': {'key': 'validation', 'type': 'str'},
        'validation_key': {'key': 'validationKey', 'type': 'str'},
        'decryption': {'key': 'decryption', 'type': 'str'},
        'decryption_key': {'key': 'decryptionKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        validation: Optional[str] = None,
        validation_key: Optional[str] = None,
        decryption: Optional[str] = None,
        decryption_key: Optional[str] = None,
        **kwargs
    ):
        super(SiteMachineKey, self).__init__(**kwargs)
        self.validation = validation
        self.validation_key = validation_key
        self.decryption = decryption
        self.decryption_key = decryption_key


class SitePatchResource(ProxyOnlyResource):
    """ARM resource for a site.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param identity: Managed service identity.
    :type identity: ~azure.mgmt.web.v2019_08_01.models.ManagedServiceIdentity
    :ivar state: Current state of the app.
    :vartype state: str
    :ivar host_names: Hostnames associated with the app.
    :vartype host_names: list[str]
    :ivar repository_site_name: Name of the repository site.
    :vartype repository_site_name: str
    :ivar usage_state: State indicating whether the app has exceeded its quota usage. Read-only.
     Possible values include: "Normal", "Exceeded".
    :vartype usage_state: str or ~azure.mgmt.web.v2019_08_01.models.UsageState
    :param enabled: :code:`<code>true</code>` if the app is enabled; otherwise,
     :code:`<code>false</code>`. Setting this value to false disables the app (takes the app
     offline).
    :type enabled: bool
    :ivar enabled_host_names: Enabled hostnames for the app.Hostnames need to be assigned (see
     HostNames) AND enabled. Otherwise,
     the app is not served on those hostnames.
    :vartype enabled_host_names: list[str]
    :ivar availability_state: Management information availability state for the app. Possible
     values include: "Normal", "Limited", "DisasterRecoveryMode".
    :vartype availability_state: str or ~azure.mgmt.web.v2019_08_01.models.SiteAvailabilityState
    :param host_name_ssl_states: Hostname SSL states are used to manage the SSL bindings for app's
     hostnames.
    :type host_name_ssl_states: list[~azure.mgmt.web.v2019_08_01.models.HostNameSslState]
    :param server_farm_id: Resource ID of the associated App Service plan, formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
    :type server_farm_id: str
    :param reserved: :code:`<code>true</code>` if reserved; otherwise, :code:`<code>false</code>`.
    :type reserved: bool
    :param is_xenon: Obsolete: Hyper-V sandbox.
    :type is_xenon: bool
    :param hyper_v: Hyper-V sandbox.
    :type hyper_v: bool
    :ivar last_modified_time_utc: Last time the app was modified, in UTC. Read-only.
    :vartype last_modified_time_utc: ~datetime.datetime
    :param site_config: Configuration of the app.
    :type site_config: ~azure.mgmt.web.v2019_08_01.models.SiteConfig
    :ivar traffic_manager_host_names: Azure Traffic Manager hostnames associated with the app.
     Read-only.
    :vartype traffic_manager_host_names: list[str]
    :param scm_site_also_stopped: :code:`<code>true</code>` to stop SCM (KUDU) site when the app is
     stopped; otherwise, :code:`<code>false</code>`. The default is :code:`<code>false</code>`.
    :type scm_site_also_stopped: bool
    :ivar target_swap_slot: Specifies which deployment slot this app will swap into. Read-only.
    :vartype target_swap_slot: str
    :param hosting_environment_profile: App Service Environment to use for the app.
    :type hosting_environment_profile: ~azure.mgmt.web.v2019_08_01.models.HostingEnvironmentProfile
    :param client_affinity_enabled: :code:`<code>true</code>` to enable client affinity;
     :code:`<code>false</code>` to stop sending session affinity cookies, which route client
     requests in the same session to the same instance. Default is :code:`<code>true</code>`.
    :type client_affinity_enabled: bool
    :param client_cert_enabled: :code:`<code>true</code>` to enable client certificate
     authentication (TLS mutual authentication); otherwise, :code:`<code>false</code>`. Default is
     :code:`<code>false</code>`.
    :type client_cert_enabled: bool
    :param client_cert_exclusion_paths: client certificate authentication comma-separated exclusion
     paths.
    :type client_cert_exclusion_paths: str
    :param host_names_disabled: :code:`<code>true</code>` to disable the public hostnames of the
     app; otherwise, :code:`<code>false</code>`.
      If :code:`<code>true</code>`, the app is only accessible via API management process.
    :type host_names_disabled: bool
    :ivar outbound_ip_addresses: List of IP addresses that the app uses for outbound connections
     (e.g. database access). Includes VIPs from tenants that site can be hosted with current
     settings. Read-only.
    :vartype outbound_ip_addresses: str
    :ivar possible_outbound_ip_addresses: List of IP addresses that the app uses for outbound
     connections (e.g. database access). Includes VIPs from all tenants except dataComponent.
     Read-only.
    :vartype possible_outbound_ip_addresses: str
    :param container_size: Size of the function container.
    :type container_size: int
    :param daily_memory_time_quota: Maximum allowed daily memory-time quota (applicable on dynamic
     apps only).
    :type daily_memory_time_quota: int
    :ivar suspended_till: App suspended till in case memory-time quota is exceeded.
    :vartype suspended_till: ~datetime.datetime
    :ivar max_number_of_workers: Maximum number of workers.
     This only applies to Functions container.
    :vartype max_number_of_workers: int
    :param cloning_info: If specified during app creation, the app is cloned from a source app.
    :type cloning_info: ~azure.mgmt.web.v2019_08_01.models.CloningInfo
    :ivar resource_group: Name of the resource group the app belongs to. Read-only.
    :vartype resource_group: str
    :ivar is_default_container: :code:`<code>true</code>` if the app is a default container;
     otherwise, :code:`<code>false</code>`.
    :vartype is_default_container: bool
    :ivar default_host_name: Default hostname of the app. Read-only.
    :vartype default_host_name: str
    :ivar slot_swap_status: Status of the last deployment slot swap operation.
    :vartype slot_swap_status: ~azure.mgmt.web.v2019_08_01.models.SlotSwapStatus
    :param https_only: HttpsOnly: configures a web site to accept only https requests. Issues
     redirect for
     http requests.
    :type https_only: bool
    :param redundancy_mode: Site redundancy mode. Possible values include: "None", "Manual",
     "Failover", "ActiveActive", "GeoRedundant".
    :type redundancy_mode: str or ~azure.mgmt.web.v2019_08_01.models.RedundancyMode
    :ivar in_progress_operation_id: Specifies an operation id if this site has a pending operation.
    :vartype in_progress_operation_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'state': {'readonly': True},
        'host_names': {'readonly': True},
        'repository_site_name': {'readonly': True},
        'usage_state': {'readonly': True},
        'enabled_host_names': {'readonly': True},
        'availability_state': {'readonly': True},
        'last_modified_time_utc': {'readonly': True},
        'traffic_manager_host_names': {'readonly': True},
        'target_swap_slot': {'readonly': True},
        'outbound_ip_addresses': {'readonly': True},
        'possible_outbound_ip_addresses': {'readonly': True},
        'suspended_till': {'readonly': True},
        'max_number_of_workers': {'readonly': True},
        'resource_group': {'readonly': True},
        'is_default_container': {'readonly': True},
        'default_host_name': {'readonly': True},
        'slot_swap_status': {'readonly': True},
        'in_progress_operation_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'host_names': {'key': 'properties.hostNames', 'type': '[str]'},
        'repository_site_name': {'key': 'properties.repositorySiteName', 'type': 'str'},
        'usage_state': {'key': 'properties.usageState', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'enabled_host_names': {'key': 'properties.enabledHostNames', 'type': '[str]'},
        'availability_state': {'key': 'properties.availabilityState', 'type': 'str'},
        'host_name_ssl_states': {'key': 'properties.hostNameSslStates', 'type': '[HostNameSslState]'},
        'server_farm_id': {'key': 'properties.serverFarmId', 'type': 'str'},
        'reserved': {'key': 'properties.reserved', 'type': 'bool'},
        'is_xenon': {'key': 'properties.isXenon', 'type': 'bool'},
        'hyper_v': {'key': 'properties.hyperV', 'type': 'bool'},
        'last_modified_time_utc': {'key': 'properties.lastModifiedTimeUtc', 'type': 'iso-8601'},
        'site_config': {'key': 'properties.siteConfig', 'type': 'SiteConfig'},
        'traffic_manager_host_names': {'key': 'properties.trafficManagerHostNames', 'type': '[str]'},
        'scm_site_also_stopped': {'key': 'properties.scmSiteAlsoStopped', 'type': 'bool'},
        'target_swap_slot': {'key': 'properties.targetSwapSlot', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'client_affinity_enabled': {'key': 'properties.clientAffinityEnabled', 'type': 'bool'},
        'client_cert_enabled': {'key': 'properties.clientCertEnabled', 'type': 'bool'},
        'client_cert_exclusion_paths': {'key': 'properties.clientCertExclusionPaths', 'type': 'str'},
        'host_names_disabled': {'key': 'properties.hostNamesDisabled', 'type': 'bool'},
        'outbound_ip_addresses': {'key': 'properties.outboundIpAddresses', 'type': 'str'},
        'possible_outbound_ip_addresses': {'key': 'properties.possibleOutboundIpAddresses', 'type': 'str'},
        'container_size': {'key': 'properties.containerSize', 'type': 'int'},
        'daily_memory_time_quota': {'key': 'properties.dailyMemoryTimeQuota', 'type': 'int'},
        'suspended_till': {'key': 'properties.suspendedTill', 'type': 'iso-8601'},
        'max_number_of_workers': {'key': 'properties.maxNumberOfWorkers', 'type': 'int'},
        'cloning_info': {'key': 'properties.cloningInfo', 'type': 'CloningInfo'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'is_default_container': {'key': 'properties.isDefaultContainer', 'type': 'bool'},
        'default_host_name': {'key': 'properties.defaultHostName', 'type': 'str'},
        'slot_swap_status': {'key': 'properties.slotSwapStatus', 'type': 'SlotSwapStatus'},
        'https_only': {'key': 'properties.httpsOnly', 'type': 'bool'},
        'redundancy_mode': {'key': 'properties.redundancyMode', 'type': 'str'},
        'in_progress_operation_id': {'key': 'properties.inProgressOperationId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        identity: Optional["ManagedServiceIdentity"] = None,
        enabled: Optional[bool] = None,
        host_name_ssl_states: Optional[List["HostNameSslState"]] = None,
        server_farm_id: Optional[str] = None,
        reserved: Optional[bool] = False,
        is_xenon: Optional[bool] = False,
        hyper_v: Optional[bool] = False,
        site_config: Optional["SiteConfig"] = None,
        scm_site_also_stopped: Optional[bool] = False,
        hosting_environment_profile: Optional["HostingEnvironmentProfile"] = None,
        client_affinity_enabled: Optional[bool] = None,
        client_cert_enabled: Optional[bool] = None,
        client_cert_exclusion_paths: Optional[str] = None,
        host_names_disabled: Optional[bool] = None,
        container_size: Optional[int] = None,
        daily_memory_time_quota: Optional[int] = None,
        cloning_info: Optional["CloningInfo"] = None,
        https_only: Optional[bool] = None,
        redundancy_mode: Optional[Union[str, "RedundancyMode"]] = None,
        **kwargs
    ):
        super(SitePatchResource, self).__init__(kind=kind, **kwargs)
        self.identity = identity
        self.state = None
        self.host_names = None
        self.repository_site_name = None
        self.usage_state = None
        self.enabled = enabled
        self.enabled_host_names = None
        self.availability_state = None
        self.host_name_ssl_states = host_name_ssl_states
        self.server_farm_id = server_farm_id
        self.reserved = reserved
        self.is_xenon = is_xenon
        self.hyper_v = hyper_v
        self.last_modified_time_utc = None
        self.site_config = site_config
        self.traffic_manager_host_names = None
        self.scm_site_also_stopped = scm_site_also_stopped
        self.target_swap_slot = None
        self.hosting_environment_profile = hosting_environment_profile
        self.client_affinity_enabled = client_affinity_enabled
        self.client_cert_enabled = client_cert_enabled
        self.client_cert_exclusion_paths = client_cert_exclusion_paths
        self.host_names_disabled = host_names_disabled
        self.outbound_ip_addresses = None
        self.possible_outbound_ip_addresses = None
        self.container_size = container_size
        self.daily_memory_time_quota = daily_memory_time_quota
        self.suspended_till = None
        self.max_number_of_workers = None
        self.cloning_info = cloning_info
        self.resource_group = None
        self.is_default_container = None
        self.default_host_name = None
        self.slot_swap_status = None
        self.https_only = https_only
        self.redundancy_mode = redundancy_mode
        self.in_progress_operation_id = None


class SitePhpErrorLogFlag(ProxyOnlyResource):
    """Used for getting PHP error logging flag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param local_log_errors: Local log_errors setting.
    :type local_log_errors: str
    :param master_log_errors: Master log_errors setting.
    :type master_log_errors: str
    :param local_log_errors_max_length: Local log_errors_max_len setting.
    :type local_log_errors_max_length: str
    :param master_log_errors_max_length: Master log_errors_max_len setting.
    :type master_log_errors_max_length: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'local_log_errors': {'key': 'properties.localLogErrors', 'type': 'str'},
        'master_log_errors': {'key': 'properties.masterLogErrors', 'type': 'str'},
        'local_log_errors_max_length': {'key': 'properties.localLogErrorsMaxLength', 'type': 'str'},
        'master_log_errors_max_length': {'key': 'properties.masterLogErrorsMaxLength', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        local_log_errors: Optional[str] = None,
        master_log_errors: Optional[str] = None,
        local_log_errors_max_length: Optional[str] = None,
        master_log_errors_max_length: Optional[str] = None,
        **kwargs
    ):
        super(SitePhpErrorLogFlag, self).__init__(kind=kind, **kwargs)
        self.local_log_errors = local_log_errors
        self.master_log_errors = master_log_errors
        self.local_log_errors_max_length = local_log_errors_max_length
        self.master_log_errors_max_length = master_log_errors_max_length


class SiteSeal(msrest.serialization.Model):
    """Site seal.

    All required parameters must be populated in order to send to Azure.

    :param html: Required. HTML snippet.
    :type html: str
    """

    _validation = {
        'html': {'required': True},
    }

    _attribute_map = {
        'html': {'key': 'html', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        html: str,
        **kwargs
    ):
        super(SiteSeal, self).__init__(**kwargs)
        self.html = html


class SiteSealRequest(msrest.serialization.Model):
    """Site seal request.

    :param light_theme: If :code:`<code>true</code>` use the light color theme for site seal;
     otherwise, use the default color theme.
    :type light_theme: bool
    :param locale: Locale of site seal.
    :type locale: str
    """

    _attribute_map = {
        'light_theme': {'key': 'lightTheme', 'type': 'bool'},
        'locale': {'key': 'locale', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        light_theme: Optional[bool] = None,
        locale: Optional[str] = None,
        **kwargs
    ):
        super(SiteSealRequest, self).__init__(**kwargs)
        self.light_theme = light_theme
        self.locale = locale


class SiteSourceControl(ProxyOnlyResource):
    """Source control configuration for an app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param repo_url: Repository or source control URL.
    :type repo_url: str
    :param branch: Name of branch to use for deployment.
    :type branch: str
    :param is_manual_integration: :code:`<code>true</code>` to limit to manual integration;
     :code:`<code>false</code>` to enable continuous integration (which configures webhooks into
     online repos like GitHub).
    :type is_manual_integration: bool
    :param deployment_rollback_enabled: :code:`<code>true</code>` to enable deployment rollback;
     otherwise, :code:`<code>false</code>`.
    :type deployment_rollback_enabled: bool
    :param is_mercurial: :code:`<code>true</code>` for a Mercurial repository;
     :code:`<code>false</code>` for a Git repository.
    :type is_mercurial: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'repo_url': {'key': 'properties.repoUrl', 'type': 'str'},
        'branch': {'key': 'properties.branch', 'type': 'str'},
        'is_manual_integration': {'key': 'properties.isManualIntegration', 'type': 'bool'},
        'deployment_rollback_enabled': {'key': 'properties.deploymentRollbackEnabled', 'type': 'bool'},
        'is_mercurial': {'key': 'properties.isMercurial', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        repo_url: Optional[str] = None,
        branch: Optional[str] = None,
        is_manual_integration: Optional[bool] = None,
        deployment_rollback_enabled: Optional[bool] = None,
        is_mercurial: Optional[bool] = None,
        **kwargs
    ):
        super(SiteSourceControl, self).__init__(kind=kind, **kwargs)
        self.repo_url = repo_url
        self.branch = branch
        self.is_manual_integration = is_manual_integration
        self.deployment_rollback_enabled = deployment_rollback_enabled
        self.is_mercurial = is_mercurial


class SkuCapacity(msrest.serialization.Model):
    """Description of the App Service plan scale options.

    :param minimum: Minimum number of workers for this App Service plan SKU.
    :type minimum: int
    :param maximum: Maximum number of workers for this App Service plan SKU.
    :type maximum: int
    :param default: Default number of workers for this App Service plan SKU.
    :type default: int
    :param scale_type: Available scale configurations for an App Service plan.
    :type scale_type: str
    """

    _attribute_map = {
        'minimum': {'key': 'minimum', 'type': 'int'},
        'maximum': {'key': 'maximum', 'type': 'int'},
        'default': {'key': 'default', 'type': 'int'},
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        minimum: Optional[int] = None,
        maximum: Optional[int] = None,
        default: Optional[int] = None,
        scale_type: Optional[str] = None,
        **kwargs
    ):
        super(SkuCapacity, self).__init__(**kwargs)
        self.minimum = minimum
        self.maximum = maximum
        self.default = default
        self.scale_type = scale_type


class SkuDescription(msrest.serialization.Model):
    """Description of a SKU for a scalable resource.

    :param name: Name of the resource SKU.
    :type name: str
    :param tier: Service tier of the resource SKU.
    :type tier: str
    :param size: Size specifier of the resource SKU.
    :type size: str
    :param family: Family code of the resource SKU.
    :type family: str
    :param capacity: Current number of instances assigned to the resource.
    :type capacity: int
    :param sku_capacity: Min, max, and default scale values of the SKU.
    :type sku_capacity: ~azure.mgmt.web.v2019_08_01.models.SkuCapacity
    :param locations: Locations of the SKU.
    :type locations: list[str]
    :param capabilities: Capabilities of the SKU, e.g., is traffic manager enabled?.
    :type capabilities: list[~azure.mgmt.web.v2019_08_01.models.Capability]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
        'sku_capacity': {'key': 'skuCapacity', 'type': 'SkuCapacity'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'capabilities': {'key': 'capabilities', 'type': '[Capability]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tier: Optional[str] = None,
        size: Optional[str] = None,
        family: Optional[str] = None,
        capacity: Optional[int] = None,
        sku_capacity: Optional["SkuCapacity"] = None,
        locations: Optional[List[str]] = None,
        capabilities: Optional[List["Capability"]] = None,
        **kwargs
    ):
        super(SkuDescription, self).__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.size = size
        self.family = family
        self.capacity = capacity
        self.sku_capacity = sku_capacity
        self.locations = locations
        self.capabilities = capabilities


class SkuInfo(msrest.serialization.Model):
    """SKU discovery information.

    :param resource_type: Resource type that this SKU applies to.
    :type resource_type: str
    :param sku: Name and tier of the SKU.
    :type sku: ~azure.mgmt.web.v2019_08_01.models.SkuDescription
    :param capacity: Min, max, and default scale values of the SKU.
    :type capacity: ~azure.mgmt.web.v2019_08_01.models.SkuCapacity
    """

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'SkuDescription'},
        'capacity': {'key': 'capacity', 'type': 'SkuCapacity'},
    }

    def __init__(
        self,
        *,
        resource_type: Optional[str] = None,
        sku: Optional["SkuDescription"] = None,
        capacity: Optional["SkuCapacity"] = None,
        **kwargs
    ):
        super(SkuInfo, self).__init__(**kwargs)
        self.resource_type = resource_type
        self.sku = sku
        self.capacity = capacity


class SkuInfoCollection(msrest.serialization.Model):
    """Collection of SKU information.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.SkuInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SkuInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["SkuInfo"],
        **kwargs
    ):
        super(SkuInfoCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class SkuInfos(msrest.serialization.Model):
    """Collection of SKU information.

    :param resource_type: Resource type that this SKU applies to.
    :type resource_type: str
    :param skus: List of SKUs the subscription is able to use.
    :type skus: list[~azure.mgmt.web.v2019_08_01.models.GlobalCsmSkuDescription]
    """

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'skus': {'key': 'skus', 'type': '[GlobalCsmSkuDescription]'},
    }

    def __init__(
        self,
        *,
        resource_type: Optional[str] = None,
        skus: Optional[List["GlobalCsmSkuDescription"]] = None,
        **kwargs
    ):
        super(SkuInfos, self).__init__(**kwargs)
        self.resource_type = resource_type
        self.skus = skus


class SlotConfigNamesResource(ProxyOnlyResource):
    """Slot Config names azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param connection_string_names: List of connection string names.
    :type connection_string_names: list[str]
    :param app_setting_names: List of application settings names.
    :type app_setting_names: list[str]
    :param azure_storage_config_names: List of external Azure storage account identifiers.
    :type azure_storage_config_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'connection_string_names': {'key': 'properties.connectionStringNames', 'type': '[str]'},
        'app_setting_names': {'key': 'properties.appSettingNames', 'type': '[str]'},
        'azure_storage_config_names': {'key': 'properties.azureStorageConfigNames', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        connection_string_names: Optional[List[str]] = None,
        app_setting_names: Optional[List[str]] = None,
        azure_storage_config_names: Optional[List[str]] = None,
        **kwargs
    ):
        super(SlotConfigNamesResource, self).__init__(kind=kind, **kwargs)
        self.connection_string_names = connection_string_names
        self.app_setting_names = app_setting_names
        self.azure_storage_config_names = azure_storage_config_names


class SlotDifference(ProxyOnlyResource):
    """A setting difference between two deployment slots of an app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar level: Level of the difference: Information, Warning or Error.
    :vartype level: str
    :ivar setting_type: The type of the setting: General, AppSetting or ConnectionString.
    :vartype setting_type: str
    :ivar diff_rule: Rule that describes how to process the setting difference during a slot swap.
    :vartype diff_rule: str
    :ivar setting_name: Name of the setting.
    :vartype setting_name: str
    :ivar value_in_current_slot: Value of the setting in the current slot.
    :vartype value_in_current_slot: str
    :ivar value_in_target_slot: Value of the setting in the target slot.
    :vartype value_in_target_slot: str
    :ivar description: Description of the setting difference.
    :vartype description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'level': {'readonly': True},
        'setting_type': {'readonly': True},
        'diff_rule': {'readonly': True},
        'setting_name': {'readonly': True},
        'value_in_current_slot': {'readonly': True},
        'value_in_target_slot': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'level': {'key': 'properties.level', 'type': 'str'},
        'setting_type': {'key': 'properties.settingType', 'type': 'str'},
        'diff_rule': {'key': 'properties.diffRule', 'type': 'str'},
        'setting_name': {'key': 'properties.settingName', 'type': 'str'},
        'value_in_current_slot': {'key': 'properties.valueInCurrentSlot', 'type': 'str'},
        'value_in_target_slot': {'key': 'properties.valueInTargetSlot', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        super(SlotDifference, self).__init__(kind=kind, **kwargs)
        self.level = None
        self.setting_type = None
        self.diff_rule = None
        self.setting_name = None
        self.value_in_current_slot = None
        self.value_in_target_slot = None
        self.description = None


class SlotDifferenceCollection(msrest.serialization.Model):
    """Collection of slot differences.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.SlotDifference]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SlotDifference]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["SlotDifference"],
        **kwargs
    ):
        super(SlotDifferenceCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class SlotSwapStatus(msrest.serialization.Model):
    """The status of the last successful slot swap operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar timestamp_utc: The time the last successful slot swap completed.
    :vartype timestamp_utc: ~datetime.datetime
    :ivar source_slot_name: The source slot of the last swap operation.
    :vartype source_slot_name: str
    :ivar destination_slot_name: The destination slot of the last swap operation.
    :vartype destination_slot_name: str
    """

    _validation = {
        'timestamp_utc': {'readonly': True},
        'source_slot_name': {'readonly': True},
        'destination_slot_name': {'readonly': True},
    }

    _attribute_map = {
        'timestamp_utc': {'key': 'timestampUtc', 'type': 'iso-8601'},
        'source_slot_name': {'key': 'sourceSlotName', 'type': 'str'},
        'destination_slot_name': {'key': 'destinationSlotName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SlotSwapStatus, self).__init__(**kwargs)
        self.timestamp_utc = None
        self.source_slot_name = None
        self.destination_slot_name = None


class SlowRequestsBasedTrigger(msrest.serialization.Model):
    """Trigger based on request execution time.

    :param time_taken: Time taken.
    :type time_taken: str
    :param count: Request Count.
    :type count: int
    :param time_interval: Time interval.
    :type time_interval: str
    """

    _attribute_map = {
        'time_taken': {'key': 'timeTaken', 'type': 'str'},
        'count': {'key': 'count', 'type': 'int'},
        'time_interval': {'key': 'timeInterval', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        time_taken: Optional[str] = None,
        count: Optional[int] = None,
        time_interval: Optional[str] = None,
        **kwargs
    ):
        super(SlowRequestsBasedTrigger, self).__init__(**kwargs)
        self.time_taken = time_taken
        self.count = count
        self.time_interval = time_interval


class Snapshot(ProxyOnlyResource):
    """A snapshot of an app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar time: The time the snapshot was taken.
    :vartype time: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'time': {'key': 'properties.time', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        super(Snapshot, self).__init__(kind=kind, **kwargs)
        self.time = None


class SnapshotCollection(msrest.serialization.Model):
    """Collection of snapshots which can be used to revert an app to a previous time.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.Snapshot]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Snapshot]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["Snapshot"],
        **kwargs
    ):
        super(SnapshotCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class SnapshotRecoverySource(msrest.serialization.Model):
    """Specifies the web app that snapshot contents will be retrieved from.

    :param location: Geographical location of the source web app, e.g. SouthEastAsia,
     SouthCentralUS.
    :type location: str
    :param id: ARM resource ID of the source app.
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
     for production slots and
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
     for other slots.
    :type id: str
    """

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        id: Optional[str] = None,
        **kwargs
    ):
        super(SnapshotRecoverySource, self).__init__(**kwargs)
        self.location = location
        self.id = id


class SnapshotRestoreRequest(ProxyOnlyResource):
    """Details about app recovery operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param snapshot_time: Point in time in which the app restore should be done, formatted as a
     DateTime string.
    :type snapshot_time: str
    :param recovery_source: Optional. Specifies the web app that snapshot contents will be
     retrieved from.
     If empty, the targeted web app will be used as the source.
    :type recovery_source: ~azure.mgmt.web.v2019_08_01.models.SnapshotRecoverySource
    :param overwrite: If :code:`<code>true</code>` the restore operation can overwrite source app;
     otherwise, :code:`<code>false</code>`.
    :type overwrite: bool
    :param recover_configuration: If true, site configuration, in addition to content, will be
     reverted.
    :type recover_configuration: bool
    :param ignore_conflicting_host_names: If true, custom hostname conflicts will be ignored when
     recovering to a target web app.
     This setting is only necessary when RecoverConfiguration is enabled.
    :type ignore_conflicting_host_names: bool
    :param use_dr_secondary: If true, the snapshot is retrieved from DRSecondary endpoint.
    :type use_dr_secondary: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'snapshot_time': {'key': 'properties.snapshotTime', 'type': 'str'},
        'recovery_source': {'key': 'properties.recoverySource', 'type': 'SnapshotRecoverySource'},
        'overwrite': {'key': 'properties.overwrite', 'type': 'bool'},
        'recover_configuration': {'key': 'properties.recoverConfiguration', 'type': 'bool'},
        'ignore_conflicting_host_names': {'key': 'properties.ignoreConflictingHostNames', 'type': 'bool'},
        'use_dr_secondary': {'key': 'properties.useDRSecondary', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        snapshot_time: Optional[str] = None,
        recovery_source: Optional["SnapshotRecoverySource"] = None,
        overwrite: Optional[bool] = None,
        recover_configuration: Optional[bool] = None,
        ignore_conflicting_host_names: Optional[bool] = None,
        use_dr_secondary: Optional[bool] = None,
        **kwargs
    ):
        super(SnapshotRestoreRequest, self).__init__(kind=kind, **kwargs)
        self.snapshot_time = snapshot_time
        self.recovery_source = recovery_source
        self.overwrite = overwrite
        self.recover_configuration = recover_configuration
        self.ignore_conflicting_host_names = ignore_conflicting_host_names
        self.use_dr_secondary = use_dr_secondary


class Solution(msrest.serialization.Model):
    """Class Representing Solution for problems detected.

    :param id: Solution Id.
    :type id: float
    :param display_name: Display Name of the solution.
    :type display_name: str
    :param order: Order of the solution.
    :type order: float
    :param description: Description of the solution.
    :type description: str
    :param type: Type of Solution. Possible values include: "QuickSolution", "DeepInvestigation",
     "BestPractices".
    :type type: str or ~azure.mgmt.web.v2019_08_01.models.SolutionType
    :param data: Solution Data.
    :type data: list[list[~azure.mgmt.web.v2019_08_01.models.NameValuePair]]
    :param metadata: Solution Metadata.
    :type metadata: list[list[~azure.mgmt.web.v2019_08_01.models.NameValuePair]]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'float'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'order': {'key': 'order', 'type': 'float'},
        'description': {'key': 'description', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'data': {'key': 'data', 'type': '[[NameValuePair]]'},
        'metadata': {'key': 'metadata', 'type': '[[NameValuePair]]'},
    }

    def __init__(
        self,
        *,
        id: Optional[float] = None,
        display_name: Optional[str] = None,
        order: Optional[float] = None,
        description: Optional[str] = None,
        type: Optional[Union[str, "SolutionType"]] = None,
        data: Optional[List[List["NameValuePair"]]] = None,
        metadata: Optional[List[List["NameValuePair"]]] = None,
        **kwargs
    ):
        super(Solution, self).__init__(**kwargs)
        self.id = id
        self.display_name = display_name
        self.order = order
        self.description = description
        self.type = type
        self.data = data
        self.metadata = metadata


class SourceControl(ProxyOnlyResource):
    """The source control OAuth token.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param token: OAuth access token.
    :type token: str
    :param token_secret: OAuth access token secret.
    :type token_secret: str
    :param refresh_token: OAuth refresh token.
    :type refresh_token: str
    :param expiration_time: OAuth token expiration.
    :type expiration_time: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'token': {'key': 'properties.token', 'type': 'str'},
        'token_secret': {'key': 'properties.tokenSecret', 'type': 'str'},
        'refresh_token': {'key': 'properties.refreshToken', 'type': 'str'},
        'expiration_time': {'key': 'properties.expirationTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        token: Optional[str] = None,
        token_secret: Optional[str] = None,
        refresh_token: Optional[str] = None,
        expiration_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(SourceControl, self).__init__(kind=kind, **kwargs)
        self.token = token
        self.token_secret = token_secret
        self.refresh_token = refresh_token
        self.expiration_time = expiration_time


class SourceControlCollection(msrest.serialization.Model):
    """Collection of source controls.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.SourceControl]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SourceControl]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["SourceControl"],
        **kwargs
    ):
        super(SourceControlCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class StackMajorVersion(msrest.serialization.Model):
    """Application stack major version.

    :param display_version: Application stack major version (display only).
    :type display_version: str
    :param runtime_version: Application stack major version (runtime only).
    :type runtime_version: str
    :param is_default: :code:`<code>true</code>` if this is the default major version; otherwise,
     :code:`<code>false</code>`.
    :type is_default: bool
    :param minor_versions: Minor versions associated with the major version.
    :type minor_versions: list[~azure.mgmt.web.v2019_08_01.models.StackMinorVersion]
    :param application_insights: :code:`<code>true</code>` if this supports Application Insights;
     otherwise, :code:`<code>false</code>`.
    :type application_insights: bool
    :param is_preview: :code:`<code>true</code>` if this stack is in Preview, otherwise
     :code:`<code>false</code>`.
    :type is_preview: bool
    :param is_deprecated: :code:`<code>true</code>` if this stack has been deprecated, otherwise
     :code:`<code>false</code>`.
    :type is_deprecated: bool
    :param is_hidden: :code:`<code>true</code>` if this stack should be hidden for new customers on
     portal, otherwise :code:`<code>false</code>`.
    :type is_hidden: bool
    """

    _attribute_map = {
        'display_version': {'key': 'displayVersion', 'type': 'str'},
        'runtime_version': {'key': 'runtimeVersion', 'type': 'str'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
        'minor_versions': {'key': 'minorVersions', 'type': '[StackMinorVersion]'},
        'application_insights': {'key': 'applicationInsights', 'type': 'bool'},
        'is_preview': {'key': 'isPreview', 'type': 'bool'},
        'is_deprecated': {'key': 'isDeprecated', 'type': 'bool'},
        'is_hidden': {'key': 'isHidden', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        display_version: Optional[str] = None,
        runtime_version: Optional[str] = None,
        is_default: Optional[bool] = None,
        minor_versions: Optional[List["StackMinorVersion"]] = None,
        application_insights: Optional[bool] = None,
        is_preview: Optional[bool] = None,
        is_deprecated: Optional[bool] = None,
        is_hidden: Optional[bool] = None,
        **kwargs
    ):
        super(StackMajorVersion, self).__init__(**kwargs)
        self.display_version = display_version
        self.runtime_version = runtime_version
        self.is_default = is_default
        self.minor_versions = minor_versions
        self.application_insights = application_insights
        self.is_preview = is_preview
        self.is_deprecated = is_deprecated
        self.is_hidden = is_hidden


class StackMinorVersion(msrest.serialization.Model):
    """Application stack minor version.

    :param display_version: Application stack minor version (display only).
    :type display_version: str
    :param runtime_version: Application stack minor version (runtime only).
    :type runtime_version: str
    :param is_default: :code:`<code>true</code>` if this is the default minor version; otherwise,
     :code:`<code>false</code>`.
    :type is_default: bool
    :param is_remote_debugging_enabled: :code:`<code>true</code>` if this supports Remote
     Debugging, otherwise :code:`<code>false</code>`.
    :type is_remote_debugging_enabled: bool
    """

    _attribute_map = {
        'display_version': {'key': 'displayVersion', 'type': 'str'},
        'runtime_version': {'key': 'runtimeVersion', 'type': 'str'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
        'is_remote_debugging_enabled': {'key': 'isRemoteDebuggingEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        display_version: Optional[str] = None,
        runtime_version: Optional[str] = None,
        is_default: Optional[bool] = None,
        is_remote_debugging_enabled: Optional[bool] = None,
        **kwargs
    ):
        super(StackMinorVersion, self).__init__(**kwargs)
        self.display_version = display_version
        self.runtime_version = runtime_version
        self.is_default = is_default
        self.is_remote_debugging_enabled = is_remote_debugging_enabled


class StampCapacity(msrest.serialization.Model):
    """Stamp capacity information.

    :param name: Name of the stamp.
    :type name: str
    :param available_capacity: Available capacity (# of machines, bytes of storage etc...).
    :type available_capacity: long
    :param total_capacity: Total capacity (# of machines, bytes of storage etc...).
    :type total_capacity: long
    :param unit: Name of the unit.
    :type unit: str
    :param compute_mode: Shared/dedicated workers. Possible values include: "Shared", "Dedicated",
     "Dynamic".
    :type compute_mode: str or ~azure.mgmt.web.v2019_08_01.models.ComputeModeOptions
    :param worker_size: Size of the machines. Possible values include: "Small", "Medium", "Large",
     "D1", "D2", "D3", "NestedSmall", "Default".
    :type worker_size: str or ~azure.mgmt.web.v2019_08_01.models.WorkerSizeOptions
    :param worker_size_id: Size ID of machines:
     0 - Small
     1 - Medium
     2 - Large.
    :type worker_size_id: int
    :param exclude_from_capacity_allocation: If :code:`<code>true</code>`, it includes basic apps.
     Basic apps are not used for capacity allocation.
    :type exclude_from_capacity_allocation: bool
    :param is_applicable_for_all_compute_modes: :code:`<code>true</code>` if capacity is applicable
     for all apps; otherwise, :code:`<code>false</code>`.
    :type is_applicable_for_all_compute_modes: bool
    :param site_mode: Shared or Dedicated.
    :type site_mode: str
    :param is_linux: Is this a linux stamp capacity.
    :type is_linux: bool
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'available_capacity': {'key': 'availableCapacity', 'type': 'long'},
        'total_capacity': {'key': 'totalCapacity', 'type': 'long'},
        'unit': {'key': 'unit', 'type': 'str'},
        'compute_mode': {'key': 'computeMode', 'type': 'str'},
        'worker_size': {'key': 'workerSize', 'type': 'str'},
        'worker_size_id': {'key': 'workerSizeId', 'type': 'int'},
        'exclude_from_capacity_allocation': {'key': 'excludeFromCapacityAllocation', 'type': 'bool'},
        'is_applicable_for_all_compute_modes': {'key': 'isApplicableForAllComputeModes', 'type': 'bool'},
        'site_mode': {'key': 'siteMode', 'type': 'str'},
        'is_linux': {'key': 'isLinux', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        available_capacity: Optional[int] = None,
        total_capacity: Optional[int] = None,
        unit: Optional[str] = None,
        compute_mode: Optional[Union[str, "ComputeModeOptions"]] = None,
        worker_size: Optional[Union[str, "WorkerSizeOptions"]] = None,
        worker_size_id: Optional[int] = None,
        exclude_from_capacity_allocation: Optional[bool] = None,
        is_applicable_for_all_compute_modes: Optional[bool] = None,
        site_mode: Optional[str] = None,
        is_linux: Optional[bool] = None,
        **kwargs
    ):
        super(StampCapacity, self).__init__(**kwargs)
        self.name = name
        self.available_capacity = available_capacity
        self.total_capacity = total_capacity
        self.unit = unit
        self.compute_mode = compute_mode
        self.worker_size = worker_size
        self.worker_size_id = worker_size_id
        self.exclude_from_capacity_allocation = exclude_from_capacity_allocation
        self.is_applicable_for_all_compute_modes = is_applicable_for_all_compute_modes
        self.site_mode = site_mode
        self.is_linux = is_linux


class StampCapacityCollection(msrest.serialization.Model):
    """Collection of stamp capacities.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.StampCapacity]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StampCapacity]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["StampCapacity"],
        **kwargs
    ):
        super(StampCapacityCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class StaticSiteARMResource(Resource):
    """Static Site ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: Description of a SKU for a scalable resource.
    :type sku: ~azure.mgmt.web.v2019_08_01.models.SkuDescription
    :ivar default_hostname: The default autogenerated hostname for the static site.
    :vartype default_hostname: str
    :param repository_url: URL for the repository of the static site.
    :type repository_url: str
    :param branch: The target branch in the repository.
    :type branch: str
    :ivar custom_domains: The custom domains associated with this static site.
    :vartype custom_domains: list[str]
    :param repository_token: A user's github repository token. This is used to setup the Github
     Actions workflow file and API secrets.
    :type repository_token: str
    :param build_properties: Build properties to configure on the repository.
    :type build_properties: ~azure.mgmt.web.v2019_08_01.models.StaticSiteBuildProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'default_hostname': {'readonly': True},
        'custom_domains': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'SkuDescription'},
        'default_hostname': {'key': 'properties.defaultHostname', 'type': 'str'},
        'repository_url': {'key': 'properties.repositoryUrl', 'type': 'str'},
        'branch': {'key': 'properties.branch', 'type': 'str'},
        'custom_domains': {'key': 'properties.customDomains', 'type': '[str]'},
        'repository_token': {'key': 'properties.repositoryToken', 'type': 'str'},
        'build_properties': {'key': 'properties.buildProperties', 'type': 'StaticSiteBuildProperties'},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["SkuDescription"] = None,
        repository_url: Optional[str] = None,
        branch: Optional[str] = None,
        repository_token: Optional[str] = None,
        build_properties: Optional["StaticSiteBuildProperties"] = None,
        **kwargs
    ):
        super(StaticSiteARMResource, self).__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.default_hostname = None
        self.repository_url = repository_url
        self.branch = branch
        self.custom_domains = None
        self.repository_token = repository_token
        self.build_properties = build_properties


class StaticSiteBuildARMResource(ProxyOnlyResource):
    """Static Site Build ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar build_id: An identifier for the static site build.
    :vartype build_id: str
    :ivar source_branch: The source branch.
    :vartype source_branch: str
    :ivar pull_request_title: The title of a pull request that a static site build is related to.
    :vartype pull_request_title: str
    :ivar hostname: The hostname for a static site build.
    :vartype hostname: str
    :ivar created_time_utc: When this build was created.
    :vartype created_time_utc: ~datetime.datetime
    :ivar last_updated_on: When this build was updated.
    :vartype last_updated_on: ~datetime.datetime
    :ivar status: The status of the static site build. Possible values include:
     "WaitingForDeployment", "Uploading", "Deploying", "Ready", "Failed", "Deleting", "Detached".
    :vartype status: str or ~azure.mgmt.web.v2019_08_01.models.BuildStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'build_id': {'readonly': True},
        'source_branch': {'readonly': True},
        'pull_request_title': {'readonly': True},
        'hostname': {'readonly': True},
        'created_time_utc': {'readonly': True},
        'last_updated_on': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'build_id': {'key': 'properties.buildId', 'type': 'str'},
        'source_branch': {'key': 'properties.sourceBranch', 'type': 'str'},
        'pull_request_title': {'key': 'properties.pullRequestTitle', 'type': 'str'},
        'hostname': {'key': 'properties.hostname', 'type': 'str'},
        'created_time_utc': {'key': 'properties.createdTimeUtc', 'type': 'iso-8601'},
        'last_updated_on': {'key': 'properties.lastUpdatedOn', 'type': 'iso-8601'},
        'status': {'key': 'properties.status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        super(StaticSiteBuildARMResource, self).__init__(kind=kind, **kwargs)
        self.build_id = None
        self.source_branch = None
        self.pull_request_title = None
        self.hostname = None
        self.created_time_utc = None
        self.last_updated_on = None
        self.status = None


class StaticSiteBuildCollection(msrest.serialization.Model):
    """Collection of static site builds.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.StaticSiteBuildARMResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StaticSiteBuildARMResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["StaticSiteBuildARMResource"],
        **kwargs
    ):
        super(StaticSiteBuildCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class StaticSiteBuildProperties(msrest.serialization.Model):
    """Build properties for the static site.

    :param app_location: The path to the app code within the repository.
    :type app_location: str
    :param api_location: The path to the api code within the repository.
    :type api_location: str
    :param app_artifact_location: The path of the app artifacts after building.
    :type app_artifact_location: str
    """

    _attribute_map = {
        'app_location': {'key': 'appLocation', 'type': 'str'},
        'api_location': {'key': 'apiLocation', 'type': 'str'},
        'app_artifact_location': {'key': 'appArtifactLocation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        app_location: Optional[str] = None,
        api_location: Optional[str] = None,
        app_artifact_location: Optional[str] = None,
        **kwargs
    ):
        super(StaticSiteBuildProperties, self).__init__(**kwargs)
        self.app_location = app_location
        self.api_location = api_location
        self.app_artifact_location = app_artifact_location


class StaticSiteCollection(msrest.serialization.Model):
    """Collection of static sites.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.StaticSiteARMResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StaticSiteARMResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["StaticSiteARMResource"],
        **kwargs
    ):
        super(StaticSiteCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class StaticSiteCustomDomainOverviewARMResource(ProxyOnlyResource):
    """Static Site Custom Domain Overview ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar domain_name: The domain name for the static site custom domain.
    :vartype domain_name: str
    :ivar created_on: The date and time on which the custom domain was created for the static site.
    :vartype created_on: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'domain_name': {'readonly': True},
        'created_on': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'domain_name': {'key': 'properties.domainName', 'type': 'str'},
        'created_on': {'key': 'properties.createdOn', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        super(StaticSiteCustomDomainOverviewARMResource, self).__init__(kind=kind, **kwargs)
        self.domain_name = None
        self.created_on = None


class StaticSiteCustomDomainOverviewCollection(msrest.serialization.Model):
    """Collection of static site custom domains.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.StaticSiteCustomDomainOverviewARMResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StaticSiteCustomDomainOverviewARMResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["StaticSiteCustomDomainOverviewARMResource"],
        **kwargs
    ):
        super(StaticSiteCustomDomainOverviewCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class StaticSiteFunctionOverviewARMResource(ProxyOnlyResource):
    """Static Site Function Overview ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar function_name: The name for the function.
    :vartype function_name: str
    :ivar trigger_type: The trigger type of the function. Possible values include: "HttpTrigger",
     "Unknown".
    :vartype trigger_type: str or ~azure.mgmt.web.v2019_08_01.models.TriggerTypes
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'function_name': {'readonly': True},
        'trigger_type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'function_name': {'key': 'properties.functionName', 'type': 'str'},
        'trigger_type': {'key': 'properties.triggerType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        super(StaticSiteFunctionOverviewARMResource, self).__init__(kind=kind, **kwargs)
        self.function_name = None
        self.trigger_type = None


class StaticSiteFunctionOverviewCollection(msrest.serialization.Model):
    """Collection of static site functions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.StaticSiteFunctionOverviewARMResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StaticSiteFunctionOverviewARMResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["StaticSiteFunctionOverviewARMResource"],
        **kwargs
    ):
        super(StaticSiteFunctionOverviewCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class StaticSitePatchResource(ProxyOnlyResource):
    """ARM resource for a static site when patching.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar default_hostname: The default autogenerated hostname for the static site.
    :vartype default_hostname: str
    :param repository_url: URL for the repository of the static site.
    :type repository_url: str
    :param branch: The target branch in the repository.
    :type branch: str
    :ivar custom_domains: The custom domains associated with this static site.
    :vartype custom_domains: list[str]
    :param repository_token: A user's github repository token. This is used to setup the Github
     Actions workflow file and API secrets.
    :type repository_token: str
    :param build_properties: Build properties to configure on the repository.
    :type build_properties: ~azure.mgmt.web.v2019_08_01.models.StaticSiteBuildProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'default_hostname': {'readonly': True},
        'custom_domains': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'default_hostname': {'key': 'properties.defaultHostname', 'type': 'str'},
        'repository_url': {'key': 'properties.repositoryUrl', 'type': 'str'},
        'branch': {'key': 'properties.branch', 'type': 'str'},
        'custom_domains': {'key': 'properties.customDomains', 'type': '[str]'},
        'repository_token': {'key': 'properties.repositoryToken', 'type': 'str'},
        'build_properties': {'key': 'properties.buildProperties', 'type': 'StaticSiteBuildProperties'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        repository_url: Optional[str] = None,
        branch: Optional[str] = None,
        repository_token: Optional[str] = None,
        build_properties: Optional["StaticSiteBuildProperties"] = None,
        **kwargs
    ):
        super(StaticSitePatchResource, self).__init__(kind=kind, **kwargs)
        self.default_hostname = None
        self.repository_url = repository_url
        self.branch = branch
        self.custom_domains = None
        self.repository_token = repository_token
        self.build_properties = build_properties


class StaticSiteResetPropertiesARMResource(ProxyOnlyResource):
    """Static Site Reset Properties ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param repository_token: The token which proves admin privileges to the repository.
    :type repository_token: str
    :param should_update_repository: Determines whether the repository should be updated with the
     new properties.
    :type should_update_repository: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'repository_token': {'key': 'properties.repositoryToken', 'type': 'str'},
        'should_update_repository': {'key': 'properties.shouldUpdateRepository', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        repository_token: Optional[str] = None,
        should_update_repository: Optional[bool] = None,
        **kwargs
    ):
        super(StaticSiteResetPropertiesARMResource, self).__init__(kind=kind, **kwargs)
        self.repository_token = repository_token
        self.should_update_repository = should_update_repository


class StaticSiteUserARMResource(ProxyOnlyResource):
    """Static Site User ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provider: The identity provider for the static site user.
    :vartype provider: str
    :ivar user_id: The user id for the static site user.
    :vartype user_id: str
    :ivar display_name: The display name for the static site user.
    :vartype display_name: str
    :param roles: The roles for the static site user, in free-form string format.
    :type roles: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provider': {'readonly': True},
        'user_id': {'readonly': True},
        'display_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provider': {'key': 'properties.provider', 'type': 'str'},
        'user_id': {'key': 'properties.userId', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'roles': {'key': 'properties.roles', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        roles: Optional[str] = None,
        **kwargs
    ):
        super(StaticSiteUserARMResource, self).__init__(kind=kind, **kwargs)
        self.provider = None
        self.user_id = None
        self.display_name = None
        self.roles = roles


class StaticSiteUserCollection(msrest.serialization.Model):
    """Collection of static site custom users.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.StaticSiteUserARMResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StaticSiteUserARMResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["StaticSiteUserARMResource"],
        **kwargs
    ):
        super(StaticSiteUserCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class StaticSiteUserInvitationRequestResource(ProxyOnlyResource):
    """Static sites user roles invitation resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param domain: The domain name for the static site custom domain.
    :type domain: str
    :param provider: The identity provider for the static site user.
    :type provider: str
    :param user_details: The user id for the static site user.
    :type user_details: str
    :param roles: The roles for the static site user, in free-form string format.
    :type roles: str
    :param num_hours_to_expiration: The number of hours the sas token stays valid.
    :type num_hours_to_expiration: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'domain': {'key': 'properties.domain', 'type': 'str'},
        'provider': {'key': 'properties.provider', 'type': 'str'},
        'user_details': {'key': 'properties.userDetails', 'type': 'str'},
        'roles': {'key': 'properties.roles', 'type': 'str'},
        'num_hours_to_expiration': {'key': 'properties.numHoursToExpiration', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        domain: Optional[str] = None,
        provider: Optional[str] = None,
        user_details: Optional[str] = None,
        roles: Optional[str] = None,
        num_hours_to_expiration: Optional[int] = None,
        **kwargs
    ):
        super(StaticSiteUserInvitationRequestResource, self).__init__(kind=kind, **kwargs)
        self.domain = domain
        self.provider = provider
        self.user_details = user_details
        self.roles = roles
        self.num_hours_to_expiration = num_hours_to_expiration


class StaticSiteUserInvitationResponseResource(ProxyOnlyResource):
    """Static sites user roles invitation link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar expires_on: The expiration time of the invitation.
    :vartype expires_on: ~datetime.datetime
    :ivar invitation_url: The url for the invitation link.
    :vartype invitation_url: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'expires_on': {'readonly': True},
        'invitation_url': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'expires_on': {'key': 'properties.expiresOn', 'type': 'iso-8601'},
        'invitation_url': {'key': 'properties.invitationUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        super(StaticSiteUserInvitationResponseResource, self).__init__(kind=kind, **kwargs)
        self.expires_on = None
        self.invitation_url = None


class StatusCodesBasedTrigger(msrest.serialization.Model):
    """Trigger based on status code.

    :param status: HTTP status code.
    :type status: int
    :param sub_status: Request Sub Status.
    :type sub_status: int
    :param win32_status: Win32 error code.
    :type win32_status: int
    :param count: Request Count.
    :type count: int
    :param time_interval: Time interval.
    :type time_interval: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'int'},
        'sub_status': {'key': 'subStatus', 'type': 'int'},
        'win32_status': {'key': 'win32Status', 'type': 'int'},
        'count': {'key': 'count', 'type': 'int'},
        'time_interval': {'key': 'timeInterval', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[int] = None,
        sub_status: Optional[int] = None,
        win32_status: Optional[int] = None,
        count: Optional[int] = None,
        time_interval: Optional[str] = None,
        **kwargs
    ):
        super(StatusCodesBasedTrigger, self).__init__(**kwargs)
        self.status = status
        self.sub_status = sub_status
        self.win32_status = win32_status
        self.count = count
        self.time_interval = time_interval


class StorageMigrationOptions(ProxyOnlyResource):
    """Options for app content migration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param azurefiles_connection_string: AzureFiles connection string.
    :type azurefiles_connection_string: str
    :param azurefiles_share: AzureFiles share.
    :type azurefiles_share: str
    :param switch_site_after_migration: :code:`<code>true</code>`if the app should be switched
     over; otherwise, :code:`<code>false</code>`.
    :type switch_site_after_migration: bool
    :param block_write_access_to_site: :code:`<code>true</code>` if the app should be read only
     during copy operation; otherwise, :code:`<code>false</code>`.
    :type block_write_access_to_site: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'azurefiles_connection_string': {'key': 'properties.azurefilesConnectionString', 'type': 'str'},
        'azurefiles_share': {'key': 'properties.azurefilesShare', 'type': 'str'},
        'switch_site_after_migration': {'key': 'properties.switchSiteAfterMigration', 'type': 'bool'},
        'block_write_access_to_site': {'key': 'properties.blockWriteAccessToSite', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        azurefiles_connection_string: Optional[str] = None,
        azurefiles_share: Optional[str] = None,
        switch_site_after_migration: Optional[bool] = False,
        block_write_access_to_site: Optional[bool] = False,
        **kwargs
    ):
        super(StorageMigrationOptions, self).__init__(kind=kind, **kwargs)
        self.azurefiles_connection_string = azurefiles_connection_string
        self.azurefiles_share = azurefiles_share
        self.switch_site_after_migration = switch_site_after_migration
        self.block_write_access_to_site = block_write_access_to_site


class StorageMigrationResponse(ProxyOnlyResource):
    """Response for a migration of app content request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar operation_id: When server starts the migration process, it will return an operation ID
     identifying that particular migration operation.
    :vartype operation_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'operation_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'operation_id': {'key': 'properties.operationId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        super(StorageMigrationResponse, self).__init__(kind=kind, **kwargs)
        self.operation_id = None


class StringDictionary(ProxyOnlyResource):
    """String dictionary resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param properties: Settings.
    :type properties: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(StringDictionary, self).__init__(kind=kind, **kwargs)
        self.properties = properties


class SwiftVirtualNetwork(ProxyOnlyResource):
    """Swift Virtual Network Contract. This is used to enable the new Swift way of doing virtual network integration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param subnet_resource_id: The Virtual Network subnet's resource ID. This is the subnet that
     this Web App will join. This subnet must have a delegation to Microsoft.Web/serverFarms defined
     first.
    :type subnet_resource_id: str
    :param swift_supported: A flag that specifies if the scale unit this Web App is on supports
     Swift integration.
    :type swift_supported: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'subnet_resource_id': {'key': 'properties.subnetResourceId', 'type': 'str'},
        'swift_supported': {'key': 'properties.swiftSupported', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        subnet_resource_id: Optional[str] = None,
        swift_supported: Optional[bool] = None,
        **kwargs
    ):
        super(SwiftVirtualNetwork, self).__init__(kind=kind, **kwargs)
        self.subnet_resource_id = subnet_resource_id
        self.swift_supported = swift_supported


class TldLegalAgreement(msrest.serialization.Model):
    """Legal agreement for a top level domain.

    All required parameters must be populated in order to send to Azure.

    :param agreement_key: Required. Unique identifier for the agreement.
    :type agreement_key: str
    :param title: Required. Agreement title.
    :type title: str
    :param content: Required. Agreement details.
    :type content: str
    :param url: URL where a copy of the agreement details is hosted.
    :type url: str
    """

    _validation = {
        'agreement_key': {'required': True},
        'title': {'required': True},
        'content': {'required': True},
    }

    _attribute_map = {
        'agreement_key': {'key': 'agreementKey', 'type': 'str'},
        'title': {'key': 'title', 'type': 'str'},
        'content': {'key': 'content', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        agreement_key: str,
        title: str,
        content: str,
        url: Optional[str] = None,
        **kwargs
    ):
        super(TldLegalAgreement, self).__init__(**kwargs)
        self.agreement_key = agreement_key
        self.title = title
        self.content = content
        self.url = url


class TldLegalAgreementCollection(msrest.serialization.Model):
    """Collection of top-level domain legal agreements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.TldLegalAgreement]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TldLegalAgreement]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["TldLegalAgreement"],
        **kwargs
    ):
        super(TldLegalAgreementCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class TopLevelDomain(ProxyOnlyResource):
    """A top level domain object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param privacy: If :code:`<code>true</code>`, then the top level domain supports domain
     privacy; otherwise, :code:`<code>false</code>`.
    :type privacy: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'privacy': {'key': 'properties.privacy', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        privacy: Optional[bool] = None,
        **kwargs
    ):
        super(TopLevelDomain, self).__init__(kind=kind, **kwargs)
        self.privacy = privacy


class TopLevelDomainAgreementOption(msrest.serialization.Model):
    """Options for retrieving the list of top level domain legal agreements.

    :param include_privacy: If :code:`<code>true</code>`, then the list of agreements will include
     agreements for domain privacy as well; otherwise, :code:`<code>false</code>`.
    :type include_privacy: bool
    :param for_transfer: If :code:`<code>true</code>`, then the list of agreements will include
     agreements for domain transfer as well; otherwise, :code:`<code>false</code>`.
    :type for_transfer: bool
    """

    _attribute_map = {
        'include_privacy': {'key': 'includePrivacy', 'type': 'bool'},
        'for_transfer': {'key': 'forTransfer', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        include_privacy: Optional[bool] = None,
        for_transfer: Optional[bool] = None,
        **kwargs
    ):
        super(TopLevelDomainAgreementOption, self).__init__(**kwargs)
        self.include_privacy = include_privacy
        self.for_transfer = for_transfer


class TopLevelDomainCollection(msrest.serialization.Model):
    """Collection of Top-level domains.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.TopLevelDomain]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TopLevelDomain]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["TopLevelDomain"],
        **kwargs
    ):
        super(TopLevelDomainCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class TriggeredJobHistory(ProxyOnlyResource):
    """Triggered Web Job History. List of Triggered Web Job Run Information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param runs: List of triggered web job runs.
    :type runs: list[~azure.mgmt.web.v2019_08_01.models.TriggeredJobRun]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'runs': {'key': 'properties.runs', 'type': '[TriggeredJobRun]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        runs: Optional[List["TriggeredJobRun"]] = None,
        **kwargs
    ):
        super(TriggeredJobHistory, self).__init__(kind=kind, **kwargs)
        self.runs = runs


class TriggeredJobHistoryCollection(msrest.serialization.Model):
    """Collection of Kudu continuous web job information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.TriggeredJobHistory]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TriggeredJobHistory]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["TriggeredJobHistory"],
        **kwargs
    ):
        super(TriggeredJobHistoryCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class TriggeredJobRun(ProxyOnlyResource):
    """Triggered Web Job Run Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param web_job_id: Job ID.
    :type web_job_id: str
    :param web_job_name: Job name.
    :type web_job_name: str
    :param status: Job status. Possible values include: "Success", "Failed", "Error".
    :type status: str or ~azure.mgmt.web.v2019_08_01.models.TriggeredWebJobStatus
    :param start_time: Start time.
    :type start_time: ~datetime.datetime
    :param end_time: End time.
    :type end_time: ~datetime.datetime
    :param duration: Job duration.
    :type duration: str
    :param output_url: Output URL.
    :type output_url: str
    :param error_url: Error URL.
    :type error_url: str
    :param url: Job URL.
    :type url: str
    :param job_name: Job name.
    :type job_name: str
    :param trigger: Job trigger.
    :type trigger: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'web_job_id': {'key': 'properties.web_job_id', 'type': 'str'},
        'web_job_name': {'key': 'properties.web_job_name', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'start_time': {'key': 'properties.start_time', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.end_time', 'type': 'iso-8601'},
        'duration': {'key': 'properties.duration', 'type': 'str'},
        'output_url': {'key': 'properties.output_url', 'type': 'str'},
        'error_url': {'key': 'properties.error_url', 'type': 'str'},
        'url': {'key': 'properties.url', 'type': 'str'},
        'job_name': {'key': 'properties.job_name', 'type': 'str'},
        'trigger': {'key': 'properties.trigger', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        web_job_id: Optional[str] = None,
        web_job_name: Optional[str] = None,
        status: Optional[Union[str, "TriggeredWebJobStatus"]] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        duration: Optional[str] = None,
        output_url: Optional[str] = None,
        error_url: Optional[str] = None,
        url: Optional[str] = None,
        job_name: Optional[str] = None,
        trigger: Optional[str] = None,
        **kwargs
    ):
        super(TriggeredJobRun, self).__init__(kind=kind, **kwargs)
        self.web_job_id = web_job_id
        self.web_job_name = web_job_name
        self.status = status
        self.start_time = start_time
        self.end_time = end_time
        self.duration = duration
        self.output_url = output_url
        self.error_url = error_url
        self.url = url
        self.job_name = job_name
        self.trigger = trigger


class TriggeredWebJob(ProxyOnlyResource):
    """Triggered Web Job Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param latest_run: Latest job run information.
    :type latest_run: ~azure.mgmt.web.v2019_08_01.models.TriggeredJobRun
    :param history_url: History URL.
    :type history_url: str
    :param scheduler_logs_url: Scheduler Logs URL.
    :type scheduler_logs_url: str
    :param run_command: Run command.
    :type run_command: str
    :param url: Job URL.
    :type url: str
    :param extra_info_url: Extra Info URL.
    :type extra_info_url: str
    :param web_job_type: Job type. Possible values include: "Continuous", "Triggered".
    :type web_job_type: str or ~azure.mgmt.web.v2019_08_01.models.WebJobType
    :param error: Error information.
    :type error: str
    :param using_sdk: Using SDK?.
    :type using_sdk: bool
    :param settings: Job settings.
    :type settings: dict[str, any]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'latest_run': {'key': 'properties.latest_run', 'type': 'TriggeredJobRun'},
        'history_url': {'key': 'properties.history_url', 'type': 'str'},
        'scheduler_logs_url': {'key': 'properties.scheduler_logs_url', 'type': 'str'},
        'run_command': {'key': 'properties.run_command', 'type': 'str'},
        'url': {'key': 'properties.url', 'type': 'str'},
        'extra_info_url': {'key': 'properties.extra_info_url', 'type': 'str'},
        'web_job_type': {'key': 'properties.web_job_type', 'type': 'str'},
        'error': {'key': 'properties.error', 'type': 'str'},
        'using_sdk': {'key': 'properties.using_sdk', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        latest_run: Optional["TriggeredJobRun"] = None,
        history_url: Optional[str] = None,
        scheduler_logs_url: Optional[str] = None,
        run_command: Optional[str] = None,
        url: Optional[str] = None,
        extra_info_url: Optional[str] = None,
        web_job_type: Optional[Union[str, "WebJobType"]] = None,
        error: Optional[str] = None,
        using_sdk: Optional[bool] = None,
        settings: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        super(TriggeredWebJob, self).__init__(kind=kind, **kwargs)
        self.latest_run = latest_run
        self.history_url = history_url
        self.scheduler_logs_url = scheduler_logs_url
        self.run_command = run_command
        self.url = url
        self.extra_info_url = extra_info_url
        self.web_job_type = web_job_type
        self.error = error
        self.using_sdk = using_sdk
        self.settings = settings


class TriggeredWebJobCollection(msrest.serialization.Model):
    """Collection of Kudu continuous web job information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.TriggeredWebJob]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TriggeredWebJob]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["TriggeredWebJob"],
        **kwargs
    ):
        super(TriggeredWebJobCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class Usage(ProxyOnlyResource):
    """Usage of the quota resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: Friendly name shown in the UI.
    :vartype display_name: str
    :ivar resource_name: Name of the quota resource.
    :vartype resource_name: str
    :ivar unit: Units of measurement for the quota resource.
    :vartype unit: str
    :ivar current_value: The current value of the resource counter.
    :vartype current_value: long
    :ivar limit: The resource limit.
    :vartype limit: long
    :ivar next_reset_time: Next reset time for the resource counter.
    :vartype next_reset_time: ~datetime.datetime
    :ivar compute_mode: Compute mode used for this usage. Possible values include: "Shared",
     "Dedicated", "Dynamic".
    :vartype compute_mode: str or ~azure.mgmt.web.v2019_08_01.models.ComputeModeOptions
    :ivar site_mode: Site mode used for this usage.
    :vartype site_mode: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'readonly': True},
        'resource_name': {'readonly': True},
        'unit': {'readonly': True},
        'current_value': {'readonly': True},
        'limit': {'readonly': True},
        'next_reset_time': {'readonly': True},
        'compute_mode': {'readonly': True},
        'site_mode': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'resource_name': {'key': 'properties.resourceName', 'type': 'str'},
        'unit': {'key': 'properties.unit', 'type': 'str'},
        'current_value': {'key': 'properties.currentValue', 'type': 'long'},
        'limit': {'key': 'properties.limit', 'type': 'long'},
        'next_reset_time': {'key': 'properties.nextResetTime', 'type': 'iso-8601'},
        'compute_mode': {'key': 'properties.computeMode', 'type': 'str'},
        'site_mode': {'key': 'properties.siteMode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        super(Usage, self).__init__(kind=kind, **kwargs)
        self.display_name = None
        self.resource_name = None
        self.unit = None
        self.current_value = None
        self.limit = None
        self.next_reset_time = None
        self.compute_mode = None
        self.site_mode = None


class UsageCollection(msrest.serialization.Model):
    """Collection of usages.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.Usage]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Usage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["Usage"],
        **kwargs
    ):
        super(UsageCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class User(ProxyOnlyResource):
    """User credentials used for publishing activity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param publishing_user_name: Username used for publishing.
    :type publishing_user_name: str
    :param publishing_password: Password used for publishing.
    :type publishing_password: str
    :param publishing_password_hash: Password hash used for publishing.
    :type publishing_password_hash: str
    :param publishing_password_hash_salt: Password hash salt used for publishing.
    :type publishing_password_hash_salt: str
    :param scm_uri: Url of SCM site.
    :type scm_uri: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'publishing_user_name': {'key': 'properties.publishingUserName', 'type': 'str'},
        'publishing_password': {'key': 'properties.publishingPassword', 'type': 'str'},
        'publishing_password_hash': {'key': 'properties.publishingPasswordHash', 'type': 'str'},
        'publishing_password_hash_salt': {'key': 'properties.publishingPasswordHashSalt', 'type': 'str'},
        'scm_uri': {'key': 'properties.scmUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        publishing_user_name: Optional[str] = None,
        publishing_password: Optional[str] = None,
        publishing_password_hash: Optional[str] = None,
        publishing_password_hash_salt: Optional[str] = None,
        scm_uri: Optional[str] = None,
        **kwargs
    ):
        super(User, self).__init__(kind=kind, **kwargs)
        self.publishing_user_name = publishing_user_name
        self.publishing_password = publishing_password
        self.publishing_password_hash = publishing_password_hash
        self.publishing_password_hash_salt = publishing_password_hash_salt
        self.scm_uri = scm_uri


class ValidateRequest(msrest.serialization.Model):
    """Resource validation request content.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Resource name to verify.
    :type name: str
    :param type: Required. Resource type used for verification. Possible values include:
     "ServerFarm", "Site".
    :type type: str or ~azure.mgmt.web.v2019_08_01.models.ValidateResourceTypes
    :param location: Required. Expected location of the resource.
    :type location: str
    :param server_farm_id: ARM resource ID of an App Service plan that would host the app.
    :type server_farm_id: str
    :param sku_name: Name of the target SKU for the App Service plan.
    :type sku_name: str
    :param need_linux_workers: :code:`<code>true</code>` if App Service plan is for Linux workers;
     otherwise, :code:`<code>false</code>`.
    :type need_linux_workers: bool
    :param is_spot: :code:`<code>true</code>` if App Service plan is for Spot instances; otherwise,
     :code:`<code>false</code>`.
    :type is_spot: bool
    :param capacity: Target capacity of the App Service plan (number of VMs).
    :type capacity: int
    :param hosting_environment: Name of App Service Environment where app or App Service plan
     should be created.
    :type hosting_environment: str
    :param is_xenon: :code:`<code>true</code>` if App Service plan is running as a windows
     container.
    :type is_xenon: bool
    :param container_registry_base_url: Base URL of the container registry.
    :type container_registry_base_url: str
    :param container_registry_username: Username for to access the container registry.
    :type container_registry_username: str
    :param container_registry_password: Password for to access the container registry.
    :type container_registry_password: str
    :param container_image_repository: Repository name (image name).
    :type container_image_repository: str
    :param container_image_tag: Image tag.
    :type container_image_tag: str
    :param container_image_platform: Platform (windows or linux).
    :type container_image_platform: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'location': {'required': True},
        'capacity': {'minimum': 1},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'server_farm_id': {'key': 'properties.serverFarmId', 'type': 'str'},
        'sku_name': {'key': 'properties.skuName', 'type': 'str'},
        'need_linux_workers': {'key': 'properties.needLinuxWorkers', 'type': 'bool'},
        'is_spot': {'key': 'properties.isSpot', 'type': 'bool'},
        'capacity': {'key': 'properties.capacity', 'type': 'int'},
        'hosting_environment': {'key': 'properties.hostingEnvironment', 'type': 'str'},
        'is_xenon': {'key': 'properties.isXenon', 'type': 'bool'},
        'container_registry_base_url': {'key': 'properties.containerRegistryBaseUrl', 'type': 'str'},
        'container_registry_username': {'key': 'properties.containerRegistryUsername', 'type': 'str'},
        'container_registry_password': {'key': 'properties.containerRegistryPassword', 'type': 'str'},
        'container_image_repository': {'key': 'properties.containerImageRepository', 'type': 'str'},
        'container_image_tag': {'key': 'properties.containerImageTag', 'type': 'str'},
        'container_image_platform': {'key': 'properties.containerImagePlatform', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        type: Union[str, "ValidateResourceTypes"],
        location: str,
        server_farm_id: Optional[str] = None,
        sku_name: Optional[str] = None,
        need_linux_workers: Optional[bool] = None,
        is_spot: Optional[bool] = None,
        capacity: Optional[int] = None,
        hosting_environment: Optional[str] = None,
        is_xenon: Optional[bool] = None,
        container_registry_base_url: Optional[str] = None,
        container_registry_username: Optional[str] = None,
        container_registry_password: Optional[str] = None,
        container_image_repository: Optional[str] = None,
        container_image_tag: Optional[str] = None,
        container_image_platform: Optional[str] = None,
        **kwargs
    ):
        super(ValidateRequest, self).__init__(**kwargs)
        self.name = name
        self.type = type
        self.location = location
        self.server_farm_id = server_farm_id
        self.sku_name = sku_name
        self.need_linux_workers = need_linux_workers
        self.is_spot = is_spot
        self.capacity = capacity
        self.hosting_environment = hosting_environment
        self.is_xenon = is_xenon
        self.container_registry_base_url = container_registry_base_url
        self.container_registry_username = container_registry_username
        self.container_registry_password = container_registry_password
        self.container_image_repository = container_image_repository
        self.container_image_tag = container_image_tag
        self.container_image_platform = container_image_platform


class ValidateResponse(msrest.serialization.Model):
    """Describes the result of resource validation.

    :param status: Result of validation.
    :type status: str
    :param error: Error details for the case when validation fails.
    :type error: ~azure.mgmt.web.v2019_08_01.models.ValidateResponseError
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'ValidateResponseError'},
    }

    def __init__(
        self,
        *,
        status: Optional[str] = None,
        error: Optional["ValidateResponseError"] = None,
        **kwargs
    ):
        super(ValidateResponse, self).__init__(**kwargs)
        self.status = status
        self.error = error


class ValidateResponseError(msrest.serialization.Model):
    """Error details for when validation fails.

    :param code: Validation error code.
    :type code: str
    :param message: Validation error message.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ValidateResponseError, self).__init__(**kwargs)
        self.code = code
        self.message = message


class VirtualApplication(msrest.serialization.Model):
    """Virtual application in an app.

    :param virtual_path: Virtual path.
    :type virtual_path: str
    :param physical_path: Physical path.
    :type physical_path: str
    :param preload_enabled: :code:`<code>true</code>` if preloading is enabled; otherwise,
     :code:`<code>false</code>`.
    :type preload_enabled: bool
    :param virtual_directories: Virtual directories for virtual application.
    :type virtual_directories: list[~azure.mgmt.web.v2019_08_01.models.VirtualDirectory]
    """

    _attribute_map = {
        'virtual_path': {'key': 'virtualPath', 'type': 'str'},
        'physical_path': {'key': 'physicalPath', 'type': 'str'},
        'preload_enabled': {'key': 'preloadEnabled', 'type': 'bool'},
        'virtual_directories': {'key': 'virtualDirectories', 'type': '[VirtualDirectory]'},
    }

    def __init__(
        self,
        *,
        virtual_path: Optional[str] = None,
        physical_path: Optional[str] = None,
        preload_enabled: Optional[bool] = None,
        virtual_directories: Optional[List["VirtualDirectory"]] = None,
        **kwargs
    ):
        super(VirtualApplication, self).__init__(**kwargs)
        self.virtual_path = virtual_path
        self.physical_path = physical_path
        self.preload_enabled = preload_enabled
        self.virtual_directories = virtual_directories


class VirtualDirectory(msrest.serialization.Model):
    """Directory for virtual application.

    :param virtual_path: Path to virtual application.
    :type virtual_path: str
    :param physical_path: Physical path.
    :type physical_path: str
    """

    _attribute_map = {
        'virtual_path': {'key': 'virtualPath', 'type': 'str'},
        'physical_path': {'key': 'physicalPath', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        virtual_path: Optional[str] = None,
        physical_path: Optional[str] = None,
        **kwargs
    ):
        super(VirtualDirectory, self).__init__(**kwargs)
        self.virtual_path = virtual_path
        self.physical_path = physical_path


class VirtualIPMapping(msrest.serialization.Model):
    """Virtual IP mapping.

    :param virtual_ip: Virtual IP address.
    :type virtual_ip: str
    :param internal_http_port: Internal HTTP port.
    :type internal_http_port: int
    :param internal_https_port: Internal HTTPS port.
    :type internal_https_port: int
    :param in_use: Is virtual IP mapping in use.
    :type in_use: bool
    :param service_name: name of the service that virtual IP is assigned to.
    :type service_name: str
    """

    _attribute_map = {
        'virtual_ip': {'key': 'virtualIP', 'type': 'str'},
        'internal_http_port': {'key': 'internalHttpPort', 'type': 'int'},
        'internal_https_port': {'key': 'internalHttpsPort', 'type': 'int'},
        'in_use': {'key': 'inUse', 'type': 'bool'},
        'service_name': {'key': 'serviceName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        virtual_ip: Optional[str] = None,
        internal_http_port: Optional[int] = None,
        internal_https_port: Optional[int] = None,
        in_use: Optional[bool] = None,
        service_name: Optional[str] = None,
        **kwargs
    ):
        super(VirtualIPMapping, self).__init__(**kwargs)
        self.virtual_ip = virtual_ip
        self.internal_http_port = internal_http_port
        self.internal_https_port = internal_https_port
        self.in_use = in_use
        self.service_name = service_name


class VirtualNetworkProfile(msrest.serialization.Model):
    """Specification for using a Virtual Network.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource id of the Virtual Network.
    :type id: str
    :ivar name: Name of the Virtual Network (read-only).
    :vartype name: str
    :ivar type: Resource type of the Virtual Network (read-only).
    :vartype type: str
    :param subnet: Subnet within the Virtual Network.
    :type subnet: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'subnet': {'key': 'subnet', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        subnet: Optional[str] = None,
        **kwargs
    ):
        super(VirtualNetworkProfile, self).__init__(**kwargs)
        self.id = id
        self.name = None
        self.type = None
        self.subnet = subnet


class VnetGateway(ProxyOnlyResource):
    """The Virtual Network gateway contract. This is used to give the Virtual Network gateway access to the VPN package.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param vnet_name: The Virtual Network name.
    :type vnet_name: str
    :param vpn_package_uri: The URI where the VPN package can be downloaded.
    :type vpn_package_uri: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'vnet_name': {'key': 'properties.vnetName', 'type': 'str'},
        'vpn_package_uri': {'key': 'properties.vpnPackageUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        vnet_name: Optional[str] = None,
        vpn_package_uri: Optional[str] = None,
        **kwargs
    ):
        super(VnetGateway, self).__init__(kind=kind, **kwargs)
        self.vnet_name = vnet_name
        self.vpn_package_uri = vpn_package_uri


class VnetInfo(ProxyOnlyResource):
    """Virtual Network information contract.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param vnet_resource_id: The Virtual Network's resource ID.
    :type vnet_resource_id: str
    :ivar cert_thumbprint: The client certificate thumbprint.
    :vartype cert_thumbprint: str
    :param cert_blob: A certificate file (.cer) blob containing the public key of the private key
     used to authenticate a
     Point-To-Site VPN connection.
    :type cert_blob: str
    :ivar routes: The routes that this Virtual Network connection uses.
    :vartype routes: list[~azure.mgmt.web.v2019_08_01.models.VnetRoute]
    :ivar resync_required: :code:`<code>true</code>` if a resync is required; otherwise,
     :code:`<code>false</code>`.
    :vartype resync_required: bool
    :param dns_servers: DNS servers to be used by this Virtual Network. This should be a
     comma-separated list of IP addresses.
    :type dns_servers: str
    :param is_swift: Flag that is used to denote if this is VNET injection.
    :type is_swift: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'cert_thumbprint': {'readonly': True},
        'routes': {'readonly': True},
        'resync_required': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'vnet_resource_id': {'key': 'properties.vnetResourceId', 'type': 'str'},
        'cert_thumbprint': {'key': 'properties.certThumbprint', 'type': 'str'},
        'cert_blob': {'key': 'properties.certBlob', 'type': 'str'},
        'routes': {'key': 'properties.routes', 'type': '[VnetRoute]'},
        'resync_required': {'key': 'properties.resyncRequired', 'type': 'bool'},
        'dns_servers': {'key': 'properties.dnsServers', 'type': 'str'},
        'is_swift': {'key': 'properties.isSwift', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        vnet_resource_id: Optional[str] = None,
        cert_blob: Optional[str] = None,
        dns_servers: Optional[str] = None,
        is_swift: Optional[bool] = None,
        **kwargs
    ):
        super(VnetInfo, self).__init__(kind=kind, **kwargs)
        self.vnet_resource_id = vnet_resource_id
        self.cert_thumbprint = None
        self.cert_blob = cert_blob
        self.routes = None
        self.resync_required = None
        self.dns_servers = dns_servers
        self.is_swift = is_swift


class VnetParameters(ProxyOnlyResource):
    """The required set of inputs to validate a VNET.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param vnet_resource_group: The Resource Group of the VNET to be validated.
    :type vnet_resource_group: str
    :param vnet_name: The name of the VNET to be validated.
    :type vnet_name: str
    :param vnet_subnet_name: The subnet name to be validated.
    :type vnet_subnet_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'vnet_resource_group': {'key': 'properties.vnetResourceGroup', 'type': 'str'},
        'vnet_name': {'key': 'properties.vnetName', 'type': 'str'},
        'vnet_subnet_name': {'key': 'properties.vnetSubnetName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        vnet_resource_group: Optional[str] = None,
        vnet_name: Optional[str] = None,
        vnet_subnet_name: Optional[str] = None,
        **kwargs
    ):
        super(VnetParameters, self).__init__(kind=kind, **kwargs)
        self.vnet_resource_group = vnet_resource_group
        self.vnet_name = vnet_name
        self.vnet_subnet_name = vnet_subnet_name


class VnetRoute(ProxyOnlyResource):
    """Virtual Network route contract used to pass routing information for a Virtual Network.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param start_address: The starting address for this route. This may also include a CIDR
     notation, in which case the end address must not be specified.
    :type start_address: str
    :param end_address: The ending address for this route. If the start address is specified in
     CIDR notation, this must be omitted.
    :type end_address: str
    :param route_type: The type of route this is:
     DEFAULT - By default, every app has routes to the local address ranges specified by RFC1918
     INHERITED - Routes inherited from the real Virtual Network routes
     STATIC - Static route set on the app only
    
     These values will be used for syncing an app's routes with those from a Virtual Network.
     Possible values include: "DEFAULT", "INHERITED", "STATIC".
    :type route_type: str or ~azure.mgmt.web.v2019_08_01.models.RouteType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'start_address': {'key': 'properties.startAddress', 'type': 'str'},
        'end_address': {'key': 'properties.endAddress', 'type': 'str'},
        'route_type': {'key': 'properties.routeType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        start_address: Optional[str] = None,
        end_address: Optional[str] = None,
        route_type: Optional[Union[str, "RouteType"]] = None,
        **kwargs
    ):
        super(VnetRoute, self).__init__(kind=kind, **kwargs)
        self.start_address = start_address
        self.end_address = end_address
        self.route_type = route_type


class VnetValidationFailureDetails(ProxyOnlyResource):
    """A class that describes the reason for a validation failure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param failed: A flag describing whether or not validation failed.
    :type failed: bool
    :param failed_tests: A list of tests that failed in the validation.
    :type failed_tests: list[~azure.mgmt.web.v2019_08_01.models.VnetValidationTestFailure]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'failed': {'key': 'properties.failed', 'type': 'bool'},
        'failed_tests': {'key': 'properties.failedTests', 'type': '[VnetValidationTestFailure]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        failed: Optional[bool] = None,
        failed_tests: Optional[List["VnetValidationTestFailure"]] = None,
        **kwargs
    ):
        super(VnetValidationFailureDetails, self).__init__(kind=kind, **kwargs)
        self.failed = failed
        self.failed_tests = failed_tests


class VnetValidationTestFailure(ProxyOnlyResource):
    """A class that describes a test that failed during NSG and UDR validation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param test_name: The name of the test that failed.
    :type test_name: str
    :param details: The details of what caused the failure, e.g. the blocking rule name, etc.
    :type details: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'test_name': {'key': 'properties.testName', 'type': 'str'},
        'details': {'key': 'properties.details', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        test_name: Optional[str] = None,
        details: Optional[str] = None,
        **kwargs
    ):
        super(VnetValidationTestFailure, self).__init__(kind=kind, **kwargs)
        self.test_name = test_name
        self.details = details


class WebAppCollection(msrest.serialization.Model):
    """Collection of App Service apps.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.Site]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Site]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["Site"],
        **kwargs
    ):
        super(WebAppCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class WebAppInstanceCollection(msrest.serialization.Model):
    """Collection of app instances.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.SiteInstance]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SiteInstance]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["SiteInstance"],
        **kwargs
    ):
        super(WebAppInstanceCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class WebJob(ProxyOnlyResource):
    """Web Job Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param run_command: Run command.
    :type run_command: str
    :param url: Job URL.
    :type url: str
    :param extra_info_url: Extra Info URL.
    :type extra_info_url: str
    :param web_job_type: Job type. Possible values include: "Continuous", "Triggered".
    :type web_job_type: str or ~azure.mgmt.web.v2019_08_01.models.WebJobType
    :param error: Error information.
    :type error: str
    :param using_sdk: Using SDK?.
    :type using_sdk: bool
    :param settings: Job settings.
    :type settings: dict[str, any]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'run_command': {'key': 'properties.run_command', 'type': 'str'},
        'url': {'key': 'properties.url', 'type': 'str'},
        'extra_info_url': {'key': 'properties.extra_info_url', 'type': 'str'},
        'web_job_type': {'key': 'properties.web_job_type', 'type': 'str'},
        'error': {'key': 'properties.error', 'type': 'str'},
        'using_sdk': {'key': 'properties.using_sdk', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        run_command: Optional[str] = None,
        url: Optional[str] = None,
        extra_info_url: Optional[str] = None,
        web_job_type: Optional[Union[str, "WebJobType"]] = None,
        error: Optional[str] = None,
        using_sdk: Optional[bool] = None,
        settings: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        super(WebJob, self).__init__(kind=kind, **kwargs)
        self.run_command = run_command
        self.url = url
        self.extra_info_url = extra_info_url
        self.web_job_type = web_job_type
        self.error = error
        self.using_sdk = using_sdk
        self.settings = settings


class WebJobCollection(msrest.serialization.Model):
    """Collection of Kudu web job information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.WebJob]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WebJob]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["WebJob"],
        **kwargs
    ):
        super(WebJobCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class WebSiteInstanceStatus(ProxyOnlyResource):
    """WebSiteInstanceStatus.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param state:  Possible values include: "READY", "STOPPED", "UNKNOWN".
    :type state: str or ~azure.mgmt.web.v2019_08_01.models.SiteRuntimeState
    :param status_url: Link to the GetStatusApi in Kudu.
    :type status_url: str
    :param detector_url: Link to the Diagnose and Solve Portal.
    :type detector_url: str
    :param console_url: Link to the Diagnose and Solve Portal.
    :type console_url: str
    :param containers: Dictionary of :code:`<ContainerInfo>`.
    :type containers: dict[str, ~azure.mgmt.web.v2019_08_01.models.ContainerInfo]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'status_url': {'key': 'properties.statusUrl', 'type': 'str'},
        'detector_url': {'key': 'properties.detectorUrl', 'type': 'str'},
        'console_url': {'key': 'properties.consoleUrl', 'type': 'str'},
        'containers': {'key': 'properties.containers', 'type': '{ContainerInfo}'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        state: Optional[Union[str, "SiteRuntimeState"]] = None,
        status_url: Optional[str] = None,
        detector_url: Optional[str] = None,
        console_url: Optional[str] = None,
        containers: Optional[Dict[str, "ContainerInfo"]] = None,
        **kwargs
    ):
        super(WebSiteInstanceStatus, self).__init__(kind=kind, **kwargs)
        self.state = state
        self.status_url = status_url
        self.detector_url = detector_url
        self.console_url = console_url
        self.containers = containers


class WorkerPool(msrest.serialization.Model):
    """Worker pool of an App Service Environment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param worker_size_id: Worker size ID for referencing this worker pool.
    :type worker_size_id: int
    :param compute_mode: Shared or dedicated app hosting. Possible values include: "Shared",
     "Dedicated", "Dynamic".
    :type compute_mode: str or ~azure.mgmt.web.v2019_08_01.models.ComputeModeOptions
    :param worker_size: VM size of the worker pool instances.
    :type worker_size: str
    :param worker_count: Number of instances in the worker pool.
    :type worker_count: int
    :ivar instance_names: Names of all instances in the worker pool (read only).
    :vartype instance_names: list[str]
    """

    _validation = {
        'instance_names': {'readonly': True},
    }

    _attribute_map = {
        'worker_size_id': {'key': 'workerSizeId', 'type': 'int'},
        'compute_mode': {'key': 'computeMode', 'type': 'str'},
        'worker_size': {'key': 'workerSize', 'type': 'str'},
        'worker_count': {'key': 'workerCount', 'type': 'int'},
        'instance_names': {'key': 'instanceNames', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        worker_size_id: Optional[int] = None,
        compute_mode: Optional[Union[str, "ComputeModeOptions"]] = None,
        worker_size: Optional[str] = None,
        worker_count: Optional[int] = None,
        **kwargs
    ):
        super(WorkerPool, self).__init__(**kwargs)
        self.worker_size_id = worker_size_id
        self.compute_mode = compute_mode
        self.worker_size = worker_size
        self.worker_count = worker_count
        self.instance_names = None


class WorkerPoolCollection(msrest.serialization.Model):
    """Collection of worker pools.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2019_08_01.models.WorkerPoolResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WorkerPoolResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["WorkerPoolResource"],
        **kwargs
    ):
        super(WorkerPoolCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class WorkerPoolResource(ProxyOnlyResource):
    """Worker pool of an App Service Environment ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param sku: Description of a SKU for a scalable resource.
    :type sku: ~azure.mgmt.web.v2019_08_01.models.SkuDescription
    :param worker_size_id: Worker size ID for referencing this worker pool.
    :type worker_size_id: int
    :param compute_mode: Shared or dedicated app hosting. Possible values include: "Shared",
     "Dedicated", "Dynamic".
    :type compute_mode: str or ~azure.mgmt.web.v2019_08_01.models.ComputeModeOptions
    :param worker_size: VM size of the worker pool instances.
    :type worker_size: str
    :param worker_count: Number of instances in the worker pool.
    :type worker_count: int
    :ivar instance_names: Names of all instances in the worker pool (read only).
    :vartype instance_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'instance_names': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'SkuDescription'},
        'worker_size_id': {'key': 'properties.workerSizeId', 'type': 'int'},
        'compute_mode': {'key': 'properties.computeMode', 'type': 'str'},
        'worker_size': {'key': 'properties.workerSize', 'type': 'str'},
        'worker_count': {'key': 'properties.workerCount', 'type': 'int'},
        'instance_names': {'key': 'properties.instanceNames', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        sku: Optional["SkuDescription"] = None,
        worker_size_id: Optional[int] = None,
        compute_mode: Optional[Union[str, "ComputeModeOptions"]] = None,
        worker_size: Optional[str] = None,
        worker_count: Optional[int] = None,
        **kwargs
    ):
        super(WorkerPoolResource, self).__init__(kind=kind, **kwargs)
        self.sku = sku
        self.worker_size_id = worker_size_id
        self.compute_mode = compute_mode
        self.worker_size = worker_size
        self.worker_count = worker_count
        self.instance_names = None
