#!/usr/bin/env python

# -*- coding: utf8 -*- 

#***********************************************************************
# pysycache : a program for learn to use the mouse
# Copyright (C) 2005-2007 Vincent DEROO (vincent.pysycache@free.fr) 
# 
# This program is free software; you can redistribute it and/or 
# modify it under the terms of the GNU General Public License 
# as published by the Free Software Foundation; either version 2 
# of the License, or (at your option) any later version. 
# 
# This program is distributed in the hope that it will be useful, 
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License 
# along with this program; if not, write to the Free Software 
# Foundation, Inc. : 
# 51 Franklin Street, Fifth Floor, Boston, MA02110-1301, USA
#***********************************************************************



#*******************************************************************************
# Importation des modules
#*******************************************************************************
import sys
import getopt, string
import random
import time
import locale

import random
import os.path
import pygame
from pygame.locals import *

import datas
from pysyclasses import BtnOfMenu
from pysyclasses import MouseOfActivity
import const
import pysyihm




#*******************************************************************************
# 
#*******************************************************************************
def ShowButtonsOfAdmin():
	for btn in TabBtnAdminPysy:
		btn.visible = 1
		if btn.id == 31:
			if const.GPysyUserModeTmp == 0:
				#le rep perso de l'utilisateur
				btn.LoadNormalPicture(Background_Restore)
			else:
				if const.GPysyUserModeTmp == 1:
					#repertoire gere par pysycache
					btn.LoadNormalPicture(Background_Restore)
					btn.LoadSecondPicture(Background_Restore)
				else:
					#repertoire gere par ???
					btn.LoadNormalPicture(Background_Restore)
					btn.LoadSecondPicture(Background_Restore)
		elif btn.id == 32 :
			if const.GPysyUserModeTmp == 0:
				btn.LoadNormalPicture(Background_Restore)
			else:
				if const.GPysyUserModeTmp == 1:
					btn.LoadNormalPicture(Background_Restore)
					btn.LoadSecondPicture(Background_Restore)
				else:
					#repertoire gere par ???
					btn.LoadNormalPicture(Background_Restore)
					btn.LoadSecondPicture(Background_Restore)
					btn.LoadNormalPicture(Background_Restore)
		else:
			btn.LoadNormalPicture(Background_Restore)



#*******************************************************************************
# Event detection
#*******************************************************************************
def DetectEvent():
	""" Traitement des evenements """
	for event in pygame.event.get():
		if event.type == QUIT:
			return 0
		elif event.type == KEYUP:
			if event.key == K_ESCAPE:
				return 0
		elif event.type == pygame.MOUSEMOTION:
			#*************** evenement deplacement de la souris ***************
			event0 = event.pos[0] 
			event1 = event.pos[1] 

			screen = pygame.display.get_surface()

			#redessin de la souris a sa position actuelle
			const.GMaSourisCurrentPositionX = event0 
			const.GMaSourisCurrentPositionY = event1 
			for o in const.GLstSouris.sprites():
				o.move(const.Gbackground_image)

			const.GLstSouris.draw(screen)

			pygame.display.update()

			return 1
		elif event.type == MOUSEBUTTONUP:
			#---------------------- on relache la souris -----------------------
			ok = 0
			event0 = event.pos[0] 
			event1 = event.pos[1] 

			screen = pygame.display.get_surface()  

			#recherche du bouton (de menu) concerne
			for btn in TabBtnAdminPysy :
				if ( event0 >= btn.left ) & ( event0 <= btn.left + btn.largeur ) & ( event1 >= btn.top  ) & ( event1 <= btn.top + btn.hauteur ) :
					if ( btn.id == 14) :
						#Quitter
						return 0
					elif ( btn.id == 20) :
						#save the pysycache configuration
						filename = os.path.join("/", "etc", "pysycache", 'pysycache.dfg')
						if os.path.isfile(filename):
							pass
						else:
							filename = os.path.join(const.GRepPysycache , "etc", "pysycache", 'pysycache.dfg')
							dirname =  os.path.join(const.GRepPysycache , "etc", "pysycache")
							#si le repertoire n'existe pas... on le cree !
							if os.path.exists(dirname):
								pass
							else:
								os.makedirs(dirname)

						file = open(filename,'w')
						file.write("USER=" + str(const.GPysyUserModeTmp) + "\n")
						file.write("SCORE=" + const.GRepScoresTmp + "\n")
						file.write("REPUSER=" + const.GRepUsersPysycacheTmp + "\n")

						const.GPysyUserMode = const.GPysyUserModeTmp
						const.GRepScores = const.GRepScoresTmp
						const.GRepUsersPysycache = const.GRepUsersPysycacheTmp

						file.close()
					elif ( btn.id == 11) :
						#modif le rep des utilisateurs
						if os.path.exists(const.GRepUsersPysycacheTmp):
							returnvalue = pysyihm.ShowFileBox(const.GRepUsersPysycacheTmp)
						else:
							returnvalue = pysyihm.ShowFileBox(const.GRepPysycache)

						if returnvalue == 1 :
							const.GRepUsersPysycacheTmp = const.GCurrentDirectory
						const.Gbackground_image.blit(Background_Restore, (0, 0))
						#redessin
						ShowNameOfUserDir()
						ShowNameOfScore()
						ShowButtonsOfAdmin()

						const.GLstSouris.draw(screen)
						screen.blit(const.Gbackground_image, (0, 0))
						pygame.display.update()
					elif ( btn.id == 12) :
						#modif le rep des scores
						if os.path.exists(const.GRepScoresTmp):
							returnvalue = pysyihm.ShowFileBox(const.GRepScoresTmp)
						else:
							returnvalue = pysyihm.ShowFileBox(const.GRepPysycache)

						if returnvalue == 1 :
							const.GRepScoresTmp = const.GCurrentDirectory
						const.Gbackground_image.blit(Background_Restore, (0, 0))
						ShowNameOfUserDir()
						ShowNameOfScore()
						ShowButtonsOfAdmin()
						
						const.GLstSouris.draw(screen)
						screen.blit(const.Gbackground_image, (0, 0))
						pygame.display.update()
					elif ( btn.id == 31) :
						#gestion par le rep perso de l'utilisateurs
						ok = 1
						if const.GPysyUserModeTmp == 0:
							const.GPysyUserModeTmp  = 1
							btn.LoadSecondPicture(Background_Restore)
							for btn2 in TabBtnAdminPysy:
								if ( btn2.id == 32) :
									btn2.LoadSecondPicture(Background_Restore, 'btncoche.ogg')
									break
						else:
							const.GPysyUserModeTmp  = 0
							btn.LoadNormalPicture(Background_Restore)
							datas.Load_sound("sounds", "btncoche.ogg")
							for btn2 in TabBtnAdminPysy:
								if ( btn2.id == 32) :
									btn2.LoadNormalPicture(Background_Restore)
									break
					elif ( btn.id == 32) :
						#gestion par pysycache
						ok = 1
						if const.GPysyUserModeTmp == 0:
							const.GPysyUserModeTmp  = 1
							btn.LoadSecondPicture(Background_Restore)
							for btn2 in TabBtnAdminPysy:
								if ( btn2.id == 31) :
									btn2.LoadSecondPicture(Background_Restore, 'btncoche.ogg')
									break
						else:
							const.GPysyUserModeTmp  = 0
							btn.LoadNormalPicture(Background_Restore)
							datas.Load_sound("sounds", "btncoche.ogg")
							for btn2 in TabBtnAdminPysy:
								if ( btn2.id == 31) :
									btn2.LoadNormalPicture(Background_Restore)
									break

					break

			const.GLstSouris.draw(screen)
			pygame.display.update()


	return 1



#*******************************************************************************
#  
#*******************************************************************************
def ShowNameOfUserDir():
	imgtmp, rectmp = datas.Load_image("images", "btn-admin-users.png")
	const.Gbackground_image.blit(imgtmp, (50, 270))
	datas.WriteTextInLang("MOD03", "Public directory of users", const.Gbackground_image, 130, 270, 20)
	imgtmp, rectmp = datas.Load_image("images", "input-directory.png")
	const.Gbackground_image.blit(imgtmp, (130, 310))
	datas.WriteTextInLang("00000", const.GRepUsersPysycacheTmp, const.Gbackground_image, 140, 315, 20, 490)


#*******************************************************************************
# 
#*******************************************************************************
def ShowNameOfScore():
	imgtmp, rectmp = datas.Load_image("images", "btn-admin-scores.png")
	const.Gbackground_image.blit(imgtmp, (50, 390))
	datas.WriteTextInLang("SCO00", "Scores directory", const.Gbackground_image, 130, 390, 20)
	imgtmp, rectmp = datas.Load_image("images", "input-directory.png")
	const.Gbackground_image.blit(imgtmp, (130, 430))
	datas.WriteTextInLang("00000", const.GRepScoresTmp, const.Gbackground_image, 140, 435, 20, 490)




#*******************************************************************************
# Main of the program                                                          #
# parameters    typfull = 0 : in window                                        #
#                       = 1 : fullscreen                                       #
#*******************************************************************************
def ShowWindow(typfull):
	global TabBtnAdminPysy 			#tableau des boutons de l'application
	TabBtnAdminPysy = []
	TabBtnAdminPysy[:]= []
	global Background_Restore

	const.GPysyUserModeTmp = const.GPysyUserMode
	const.GRepScoresTmp = const.GRepScores
	const.GRepUsersPysycacheTmp = const.GRepUsersPysycache

	screen = pygame.display.get_surface()

	datas.ShowTransitionOfTheme(const.GDureeTransition, "fond-admin-pysy.png", 0)

	#----------------------- transition vers le menu ---------------------------
	const.Gbackground_image, background_rect = datas.Load_image("images", "fond-admin-pysy.png")
	Background_Restore, background_rect = datas.Load_image("images", "fond-admin-pysy.png")

	#------------------ ecriture des titre differentes sections -----------------
	#titre
	datas.WriteTextInLang("PRF01", "Default", const.Gbackground_image, -1, 31, 40)

	#gestion des utilisateurs
	imgtmp, rectmp = datas.Load_image("images", "btn-admin-mode.png")
	const.Gbackground_image.blit(imgtmp, (50, 130))
	datas.WriteTextInLang("MOD00", "Default", const.Gbackground_image, 130, 130, 20)

	#repertoire perso
	datas.WriteTextInLang("MOD01", "Default", const.Gbackground_image, 200, 170, 20)
	#gere par pysycache
	datas.WriteTextInLang("MOD02", "Default", const.Gbackground_image, 200, 210, 20)

	Background_Restore.blit(const.Gbackground_image, (0,0))

	#repertoire des utilisateurs
	ShowNameOfUserDir()

	#repertoire des scores
	ShowNameOfScore()


	#----------------------------- liste des boutons ---------------------------
	const.GBtnMenu = 999
	TabBtnAdminPysy.append(BtnOfMenu("fond-admin-pysy.png", 14, 'btn-quitter-gd.png', 'btn-quitter.png', 690, 545) )	#quitter
	TabBtnAdminPysy.append(BtnOfMenu("fond-admin-pysy.png", 20, 'btn-admin-save.png', 'btn-admin-save.png', 735, 10) )			#enregistrer
	TabBtnAdminPysy.append(BtnOfMenu("fond-admin-pysy.png", 11, 'open.png', 'open.png', 601, 316) )								#ouvrir rep utilisateurs pysycache
	TabBtnAdminPysy.append(BtnOfMenu("fond-admin-pysy.png", 12, 'open.png', 'open.png', 601, 436) )								#ouvrir scores

	TabBtnAdminPysy.append(BtnOfMenu("fond-admin-pysy.png", 31, 'cancel.png', 'apply.png', 160, 171)) 
	TabBtnAdminPysy.append(BtnOfMenu("fond-admin-pysy.png", 32, 'apply.png', 'cancel.png', 160, 211) )

	ShowButtonsOfAdmin()

	screen.blit(const.Gbackground_image, (0, 0))


	#------------------- changer la souris en main -------------------------
#	pygame.event.clear()
	const.GLstSouris.empty()
	const.GLstSouris.add(MouseOfActivity(400, 300, "souris.png") )
	for o in const.GLstSouris.sprites():
		o.move(const.Gbackground_image)
	const.GLstSouris.draw(screen)
	pygame.display.update()
	pygame.event.clear()

	const.GTypeSouris = const.EVENT_JEU0

	#---------------------- entree dans la boucle principale -------------------
	running = 1
	while running:
		datas.Temporisation()

		#----------------- recherche des evt -----------------------------------
		running = DetectEvent()

		datas.ShowFPS()
