#include "pilercr.h"

void Info()
	{
	Out
(
"Help on reading this report\n"
"===========================\n"
"\n"
"This report has three sections: Detailed, Summary by Similarity\n"
"and Summary by Position.\n"
"\n"
"The detailed section shows each repeat in each putative\n"
"CRISPR array.\n"
"\n"
"The summary sections give one line for each array.\n"
"\n"
"An 'array' is a contiguous sequence of CRISPR repeats\n"
"looking like this:\n"
"\n"
"    REPEAT Spacer REPEAT Spacer REPEAT ... Spacer REPEAT\n"
"\n"
"Within one array, repeats have high similarity and spacers\n"
"are, roughly speaking, unique within a window around the array.\n"
"In a given array, each repeat has a similar length, and each\n"
"spacer has a similar length. With default parameters, the\n"
"algorithm allows a fair amount of variability in order to\n"
"maximize sensitivity. This may allow identification of\n"
"inactive (\"fossil\") arrays, and may in rare cases also\n"
"induce false positives due to other classes of repeats\n"
"such as microsatellites, LTRs and arrays of RNA genes.\n"
"\n"
"\n"
"Columns in the detailed section are:\n"
"\n"
"  Pos               Sequence position, starting at 1 for the first base.\n"
"  Repeat            Length of the repeat.\n"
"  %%id               Identity with the consensus sequence.\n"
"  Spacer            Length of spacer to the right of this repeat.\n"
"  Left flank        10 bases to the left of this repeat.\n"
"  Repeat            Sequence of this repeat.\n"
"                      Dots indicate positions where this repeat\n"
"                      agrees with the consensus sequence below.\n"
"  Spacer            Sequence of spacer to the right of this repeat,\n"
"                      or 10 bases if this is the last repeat.\n"
"\n"
"The left flank sequence duplicates the end of the spacer for the preceding\n"
"repeat; it is provided to facilitate visual identification of cases\n"
"where the algorithm does not correctly identify repeat endpoints.\n"
"\n"
"At the end of each array there is a sub-heading that gives the average\n"
"repeat length, average spacer length and consensus sequence.\n"
"\n"
"Columns in the summary sections are:\n"
"\n"
"  Array             Number 1, 2 ... referring back to the detailed report.\n"
"  Sequence          FASTA label of the sequence. May be truncated.\n"
"  From              Start position of array.\n"
"  To                End position of array.\n"
"  # copies          Number of repeats in the array.\n"
"  Repeat            Average repeat length.\n"
"  Spacer            Average spacer length.\n"
"  +                 +/-, indicating orientation relative to first array in group.\n"
"  Distance          Distance from previous array.\n"
"  Consensus         Consensus sequence.\n"
"\n"
"In the Summary by Similarity section, arrays are grouped by similarity of their\n"
"consensus sequences. If consensus sequences are sufficiently similar, they are\n"
"aligned to each other to indicate probable relationships between arrays.\n"
"\n"
"In the Summary by Position section, arrays are sorted by position within the\n"
"input sequence file.\n"
"\n"
"The Distance column facilitates identification of cases where a single\n"
"array has been reported as two adjacent arrays. In such a case, (a) the\n"
"consensus sequences will be similar or identical, and (b) the distance\n"
"will be approximately a small multiple of the repeat length + spacer length.\n"
"\n"
"Use the -noinfo option to turn off this help.\n"
"Use the -help option to get a list of command line options.\n"
"\n"
);
	}
