# -*- mode: python; coding: utf-8 -*-
#
# Pigment Python binding unit tests
#
# Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

from test_drawable import _TestDrawable
import pgm

class TestText(_TestDrawable):

    def setUp(self):
        self.drawable = pgm.Text()
        _TestDrawable.setUp(self)

##     def test_contructor(self):

##         t = pgm.Text("foo")
##         self.assertEqual(t.get_label(), "foo")

##         t = pgm.Text("foo", font_path="/bar", font_height=2.)
##         self.assertEqual(t.get_label(), "foo")
##         self.assertEqual(t.get_font(), ("/bar", 2.))

    def test_label(self):

        # get
        label = self.drawable.get_label()
        self.assertEqual(label, "")

        # set
        self.drawable.set_label("bar")
        self.assertEqual(self.drawable.get_label(), "bar")

        # set markup
        markup = "<bold>Foo</bold>"
        self.drawable.set_markup(markup)
        self.assertEqual(self.drawable.get_label(), markup)

    def test_font_family(self):

        # get
        font_family = self.drawable.get_font_family()
        self.assertEqual(font_family, 'Sans')


        # set
        self.drawable.set_font_family("foo")
        font_family = self.drawable.get_font_family()
        self.assertEqual(font_family, "foo")

    def test_height(self):

        # get
        height = self.drawable.height

        self.failUnless(isinstance(height, float))
        self.assertEqual(height, 1.0)

        # set
        self.drawable.height = 1.5
        self.assertEqual(self.drawable.height, 1.5)

    def test_ellipsize(self):

        # get
        ellipsize = self.drawable.get_ellipsize()
        self.assertEqual(ellipsize, pgm.TextEllipsize(pgm.TEXT_ELLIPSIZE_NONE))
        # set
        new_ellipse = pgm.TextEllipsize(pgm.TEXT_ELLIPSIZE_MIDDLE)
        self.drawable.set_ellipsize(new_ellipse)
        self.assertEqual(self.drawable.get_ellipsize(), new_ellipse)

    def test_justify(self):

        # get
        justify = self.drawable.get_justify()
        self.assertEqual(justify, False)

        # set
        self.drawable.set_justify(True)
        self.assertEqual(self.drawable.get_justify(), True)

    def test_alignment(self):

        # get
        align = self.drawable.get_alignment()
        self.assertEqual(align, pgm.TextAlignment(pgm.TEXT_ALIGN_LEFT))

        # set
        new_align = pgm.TextAlignment(pgm.TEXT_ALIGN_LEFT)
        self.drawable.set_alignment(new_align)
        self.assertEqual(self.drawable.get_alignment(), new_align)

    def test_wrap(self):

        # get
        wrap = self.drawable.get_wrap()
        self.assertEqual(wrap, pgm.TextWrap(pgm.TEXT_WRAP_WORD))

        # set
        new_wrap = pgm.TextWrap(pgm.TEXT_WRAP_CHAR)
        self.drawable.set_wrap(new_wrap)
        self.assertEqual(self.drawable.get_wrap(), new_wrap)

    def test_gravity(self):

        # get
        gravity = self.drawable.get_gravity()
        self.assertEqual(gravity, pgm.TextGravity(pgm.TEXT_GRAVITY_AUTO))

        # set
        new_gravity = pgm.TextGravity(pgm.TEXT_GRAVITY_NORTH)
        self.drawable.set_gravity(new_gravity)
        self.assertEqual(self.drawable.get_gravity(), new_gravity)

    def test_stretch(self):

        # get
        stretch = self.drawable.get_stretch()
        self.assertEqual(stretch, pgm.TextStretch(pgm.TEXT_STRETCH_NORMAL))

        # set
        new_stretch = pgm.TextStretch(pgm.TEXT_STRETCH_CONDENSED)
        self.drawable.set_stretch(new_stretch)
        self.assertEqual(self.drawable.get_stretch(), new_stretch)

    def test_style(self):

        # get
        style = self.drawable.get_style()
        self.assertEqual(style, pgm.TextStyle(pgm.TEXT_STYLE_NORMAL))

        # set
        new_style = pgm.TextStyle(pgm.TEXT_STYLE_OBLIQUE)
        self.drawable.set_style(new_style)
        self.assertEqual(self.drawable.get_style(), new_style)

    def test_variant(self):

        # get
        variant = self.drawable.get_variant()
        self.assertEqual(variant, pgm.TextVariant(pgm.TEXT_VARIANT_NORMAL))

        # set
        new_variant = pgm.TextVariant(pgm.TEXT_VARIANT_SMALL_CAPS)
        self.drawable.set_variant(new_variant)
        self.assertEqual(self.drawable.get_variant(), new_variant)

    def test_weight(self):

        # get
        weight = self.drawable.get_weight()
        self.assertEqual(weight, pgm.TextWeight(pgm.TEXT_WEIGHT_NORMAL))

        # set
        new_weight = pgm.TextWeight(pgm.TEXT_WEIGHT_BOLD)
        self.drawable.set_weight(new_weight)
        self.assertEqual(self.drawable.get_weight(), new_weight)

    def test_line_spacing(self):

        # get
        line_spacing = self.drawable.get_line_spacing()
        self.assertEqual(line_spacing, 0.0)

        # set
        new_line_spacing = 1.5
        self.drawable.set_line_spacing(new_line_spacing)
        self.assertEqual(self.drawable.get_line_spacing(), new_line_spacing)


    def test_outline_color(self):

        outline_color = self.drawable.get_outline_color()
        self.assertEqual(outline_color, (0, 0, 0, 0))

        new_outline_color = (50, 60, 70, 80)
        self.drawable.set_outline_color(*new_outline_color)
        self.assertEqual(self.drawable.get_outline_color(),
                         new_outline_color)

    def test_outline_width(self):

        # get
        outline_width = self.drawable.get_outline_width()
        self.assertEqual(outline_width, 0.0)

        # set
        new_outline_width = 1.5
        self.drawable.set_outline_width(new_outline_width)
        self.assertEqual(self.drawable.get_outline_width(),
                         new_outline_width)

