/***********************************************************************************************************************************
Exit Routines
***********************************************************************************************************************************/
#ifndef COMMAND_EXIT_H
#define COMMAND_EXIT_H

#include <stdbool.h>
#include <signal.h>

/***********************************************************************************************************************************
Signal type
***********************************************************************************************************************************/
typedef enum
{
    signalTypeNone = 0,
    signalTypeHup = SIGHUP,
    signalTypeInt = SIGINT,
    signalTypeTerm = SIGTERM,
} SignalType;

/***********************************************************************************************************************************
Functions
***********************************************************************************************************************************/
// Setup signal handlers
FN_EXTERN void exitInit(void);

// Do cleanup and return result code
FN_EXTERN int exitSafe(int result, bool error, SignalType signalType);

#endif
