#include "Platform.h"
#include <string.h>
#include <stdio.h>
#include <time.h>
#include "KHUReader.h"
#include "BaseCommunication.h"

#include "memory_placements.h"


#define base CSHUReader

CKHUReader::CKHUReader(CReader *Owner,CBaseCommunication *Communicator)
			  :base(Owner,Communicator)
{}

CKHUReader::~CKHUReader(void)
{
}

void CKHUReader::SetNFCSpeedLimit()
{
	uint32_t l = 1;
	uint8_t s = (uint8_t)GetEnviroment("NFCSpeedLimit", 0xff);
	Escape(MODULE_ID_KERNEL, CCID_ESCAPE_NFC_SPEED_LIMIT, &s, 1, NULL, &s, &l);// Fire and forgot
}


void CKHUReader::SetHWString(char *String)
{
	SetNFCSpeedLimit();
    strcpy(String,"KHU_");
}

void CKHUReader::GetProductString(uint8_t *Product)
{
	memcpy(Product,"CJKHU",5);
}

CJ_RESULT CKHUReader::CtSetBacklight(EBacklight eBacklight,uint32_t *Result)
{
	CJ_RESULT Res;
	switch(eBacklight)
	{
	case BacklightOff:
		Res=_CtSetBacklight(0,Result);
		break;
	case BacklightVeryLow:
		Res=_CtSetBacklight(70,Result);
		break;
	case BacklightLow:
		Res=_CtSetBacklight(100,Result);
		break;
	case BacklightMedium:
		Res=_CtSetBacklight(120,Result);
		break;
	case BacklightHigh:
		Res=_CtSetBacklight(160,Result);
		break;
	case BacklightVeryHigh:
		Res=_CtSetBacklight(255,Result);
		break;
	default:
		Res=CJ_ERR_WRONG_PARAMETER;
	}
	return Res;
}

