##############################################################################
#
#  xine-lib Multiple Vulnerabilities
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/18
#
#  Revision: 1.2
#
#  Log: ssharath
#  Issue #0125
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900111);
 script_cve_id("CVE-2008-5235");
 script_bugtraq_id(30698);
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("Revision: 1.2 ");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");
 script_category(ACT_GATHER_INFO);
 script_family("General");
 script_name("xine-lib Multiple Vulnerabilities");
 script_summary("Check for vulnerable version of xine-lib");
 desc = "
 Overview : The host is installed with xine-lib, which prone to multiple
 vulnerabilities.

 Vulnerability Insight :
	
        The flaws are due to,
        - errors when processing malformed Ogg files in demux_ogg_send_chunk()
          and send_header() functions in src/demuxers/demux_ogg.c
        - error when processing malformed V4L video in open_video_capture_device()
          function in src/input/input_v4l.c file.
        - error when processing malformed ID3 data in id3v22_interp_frame(),
          id3v23_interp_frame(), and id3v24_interp_frame() functions in
          src/demuxers/id3.c file.
        - error when processing malformed Real file in demux_real_send_chunk()
          function in src/demuxers/demux_real.c file.
        
        Impact : Remote exploitation could allow execution of arbitrary code to
        cause the server to crash or denying the access to legitimate users.

 Impact Level : Application

 Affected Software/OS :
        xine-lib versions prior to 1.1.15 on Linux (All).

 Fix : Upgrade to xine-lib version 1.1.15
 http://xinehq.de/index.php/releases

 References :
 http://www.frsirt.com/english/advisories/2008/2382
 http://sourceforge.net/project/shownotes.php?release_id=619869&group_id=9655

 CVSS Score :
        CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
        CVSS Temporal Score : 5.3
 Risk factor : High";
 script_description(desc);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/uname");
 exit(0);
}


 include("ssh_func.inc");

 if("Linux" >!< get_kb_item("ssh/login/uname")){
        exit(0);
 }
 
 foreach item (get_kb_list("ssh/*/rpms"))
 {
        if("xine" >< item)
        {
                if(egrep(pattern:"(libxine(1)?|xine-lib)~(0\..*|1\.(0\..*|" +
				 "1(\.0?[0-9]|\.1[0-4])?))[^.0-9]", string:item))
		{
                        security_hole(0);
			exit(0);
		}
	}
 }

 sock = ssh_login_or_reuse_connection();
 if(!sock){
 	exit(0);
 }

 xineVer = ssh_cmd(socket:sock, cmd:"xine-config --version", timeout:timeout);
 ssh_close_connection();

 if(!xineVer){
 	exit(0);
 }

 if(egrep(pattern:"^(0\..*|1\.(0\..*|1(\.0?[0-9]|\.1[0-4])?))([^.0-9]|$)",
	  string:xineVer)){
 	security_hole(0);
 } 
