###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_sun_java_app_serv_info_disc_vuln.nasl 901 2009-01-29 14:50:29Z jan $
#
# Sun Java System Application Server Information Disclosure vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900301);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-0278");
  script_bugtraq_id(33397);
  script_name("Sun Java System Application Server Information Disclosure vulnerability");
  desc = "

  Overview: The host is running Java Application Server and is prone to
  information disclosure vulnerability.

  Vulnerability Insight:
  A security vulnerability in Java Application server may expose sensitive
  directory contents i.e. 'WEB-INF' and 'META-INF' via malformed requests.

  Impact:
  Successful exploitation could allow remote unprivileged user to read Web
  Application configuration files in 'WEB-INF' and 'META-INF' directories.

  Impact Level: Application

  Affected Software/OS:
  Java System Application Server version 8.1 and 8.2 on Linux and Windows.

  Fix: Apply the security updates.
  http://sunsolve.sun.com/search/document.do?assetkey=1-66-245446-1

  *****
  NOTE: Please ignore this warning, if above mentioned patch is applied.
  *****

  References:
  http://osvdb.org/51604
  http://secunia.com/advisories/33725
  http://xforce.iss.net/xforce/xfdb/48161
  http://sunsolve.sun.com/search/document.do?assetkey=1-21-119166-35-1

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Java Application Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_sun_java_app_serv_detect.nasl");
  script_require_keys("Sun/Java/AppServer/Ver");
  script_require_ports("Services/www", 8080);
  exit(0);
}


include("http_func.inc");

port = get_http_port(default:8080);
if(!port){
  exit(0);
}

appservVer = get_kb_item("Sun/Java/AppServer/Ver");
if(appservVer)
{
  # Check for Java Application Server version 8.1 and 8.2
  if(appservVer =~ "(8\.1|8\.2)"){
    security_warning(port);
  }
}
