###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_evolution_info_disc_vuln.nasl 2319 2009-05-18 13:50:29Z may $
#
# Evolution Mail Client Information Disclosure Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900709);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"2.1");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-1631");
  script_bugtraq_id(34921);
  script_name("Evolution Mail Client Information Disclosure Vulnerability");
  desc = "

  Overview: This host is installed with Evolution for Linux and is prone to
  Information Disclosure Vulnerability.

  Vulnerability Insight:
  The flaw is caused due to Mailer component in Evolution, uses world readable
  permissions for the .evolution directory and some other certain directories
  under .evolution which causes disclosure of sensitive information of the
  user's mail directories and their contents.

  Impact:
  Successful exploitation will let the local attacker gain sensitive information
  about the victim's mail folders and can view their contents.

  Impact level: Application

  Affected Software/OS:
  Evolution Mail Client version 2.26.1 and prior.

  Fix: Upgrade to Evolution Mail Client version 2.30.1 or later
  For further updates refer, http://projects.gnome.org/evolution

  References:
  http://bugzilla.gnome.org/show_bug.cgi?id=581604
  https://bugzilla.redhat.com/show_bug.cgi?id=498648
  http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=526409

  CVSS Score:
    CVSS Base Score     : 2.1 (AV:L/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 1.8
  Risk factor: Low";

  script_description(desc);
  script_summary("Check for the version of Evolution");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("gb_evolution_data_server_detect.nasl");
  script_require_keys("Evolution/Ver");
  exit(0);
}


include("version_func.inc");

evolutionVer = get_kb_item("Evolution/Ver");
if(evolutionVer == NULL){
  exit(0);
}

# Grep for Evolution Mail Client version 2.26.1 and prior
if(version_is_less_equal(version:evolutionVer, test_version:"2.26.1")){
  security_warning(0);
}
