###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for mesa MDVA-2008:052 (mesa)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830669);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "MDVA", value: "2008:052");
  script_name( "Mandriva Update for mesa MDVA-2008:052 (mesa)");
  desc = "

  Vulnerability Insight:

  Updated Mesa packages are available that correct a problem of reversed
  logic in Mesa 7.0.3rc2 on Intel i965 cards.

  Affected Software/OS:
  mesa on Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-04/msg00025.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of mesa");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"libmesagl1", rpm:"libmesagl1~7.0.2~6.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmesagl1-devel", rpm:"libmesagl1-devel~7.0.2~6.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmesaglu1", rpm:"libmesaglu1~7.0.2~6.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmesaglu1-devel", rpm:"libmesaglu1-devel~7.0.2~6.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmesaglut3", rpm:"libmesaglut3~7.0.2~6.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmesaglut3-devel", rpm:"libmesaglut3-devel~7.0.2~6.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmesaglw1", rpm:"libmesaglw1~7.0.2~6.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmesaglw1-devel", rpm:"libmesaglw1-devel~7.0.2~6.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mesa", rpm:"mesa~7.0.2~6.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mesa-common-devel", rpm:"mesa-common-devel~7.0.2~6.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mesa-demos", rpm:"mesa-demos~7.0.2~6.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mesa-source", rpm:"mesa-source~7.0.2~6.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mesagl1", rpm:"lib64mesagl1~7.0.2~6.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mesagl1-devel", rpm:"lib64mesagl1-devel~7.0.2~6.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mesaglu1", rpm:"lib64mesaglu1~7.0.2~6.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mesaglu1-devel", rpm:"lib64mesaglu1-devel~7.0.2~6.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mesaglut3", rpm:"lib64mesaglut3~7.0.2~6.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mesaglut3-devel", rpm:"lib64mesaglut3-devel~7.0.2~6.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mesaglw1", rpm:"lib64mesaglw1~7.0.2~6.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mesaglw1-devel", rpm:"lib64mesaglw1-devel~7.0.2~6.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}