# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 173-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53428);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 173-1 (bugzilla)";
 script_name(name);

 desc = "The remote host is missing an update to bugzilla
announced via advisory DSA 173-1.

The developers of Bugzilla, a web-based bug tracking system,
discovered a problem in the handling of more than 47 groups.  When a
new product is added to an installation with 47 groups or more and
usebuggroups is enabled, the new group will be assigned a groupset
bit using Perl math that is not exact beyond 2^48.  This results in
the new group being defined with a bit that has several bits set.
As users are given access to the new group, those users will also gain
access to spurious lower group privileges.  Also, group bits were not
always reused when groups were deleted.

This problem has been fixed in version 2.14.2-0woody2 for the current
stable distribution (woody) and will soon be fixed in the unstable
distribution (sid).  The old stable distribution (potato) doesn't
contain a bugzilla package.

We recommend that you upgrade your bugzilla package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20173-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 173-1 (bugzilla)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"bugzilla-doc", ver:"2.14.2-0woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bugzilla", ver:"2.14.2-0woody2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
