## 2015.03-3

**OS X only: Auto-update vulnerability fix**

## 2015.03-2

**Bugfixes**
* \#1483 - Fix Z-fighting in Ortho view
* \#1479 - No check for infinite $fn
* \#1472 - "nan" in list comprehension causes crash
* \#452 - rands() fails when the seed is a floating point number
* \#1407 - Recursive module crash
* \#1425 - Animate Filename Generation - Duplicate/Missing Filenames
* \#1420 - expression-evaluation-tests fails on arm64
* \#1410 - Crash when a polygon contains NaN
* \#1378 - Linear extrude plus infinite twist causes crash instead of just an error
* \#1358 - Add more detailed installer information including version number
* \#1356 - Crash when multiplying matrices with undefined elements
* \#1350 - Saving file when HD is full ends up in data loss
* \#1342 - Syntax Highlighting Does Not Work on Linux Mint 17.1
* \#1337 - Simple detection of script and direction based on given text
* \#1325 - Crash when polygons with > 3 indices turn out to be degenerate
* \#1329 - version() returned ```[0,0,0]```

## 2015.03-1

**Bugfixes**
* \#1203 - Linux: Missing icons on Xfce
* \#1258 - Occasional crash when exporting STL
* \#1260 - Minimal window width too large
* \#1264 - Replace All sometimes caused a hang
* \#1274 - Fixed some preview bugs on Intel GPUs (OpenCSG 1.4.0)
* \#1276 - Module recursion sometimes caused a crash
* \#1277 - Automatic reload sometimes messed up camera position
* \#1284 - Animation flicker eliminated
* \#1294 - Support reproducible builds
* \#1317 - Normals vectors in STL were sometimes 0 0 0

## 2015.03

**Language Features:**
* Added text() module for 2D text
* Added offset() module for 2D offsets
* Added list comprehensions and let()
* Added concat() function
* Added chr() function
* surface() can now take PNG images as input
* min() and max() can now take a vector argument
* 2D minkowski can now handle polygons with holes
* Variables can now be assigned in local blocks without using assign()

**Program Features:**
* Added Toolbar icons
* New code editor based on QScintilla
* Added Splash screen
* Added SVG export
* Added AMF export
* Added --viewall and --autocenter cmd-line parameters
* GUI is now translated into German, Czech, Spanish, French and Russian
* MDI (Multiple Document Interface) is now available on all platforms
* Color schemes for viewer and editor can be user-edited using JSON files
* GUI components are now dockable
* Added Tickmarks on axes

**Bugfixes/improvements:**
* Performance improvement: 2D (clipper), preview, hull, minkowski, surface
* Performance improvement: Reduce duplicate evaluation of identical expressions
* Better recursion behavior
* STL export and import is now more robust
* Internal cavities are better supported
* New examples
* Windows cmd-line behaves better
* Better mirror() and scale() behavior when using negative factors

**Deprecations:**
* polyhedron() now takes a faces= argument rather than triangles=
* assign() is no longer needed. Local variables can be created in any scope
