// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BRepBuilderAPI_Copy_HeaderFile
#define _BRepBuilderAPI_Copy_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <BRepBuilderAPI_ModifyShape.hxx>
#include <Standard_Boolean.hxx>
class TopoDS_Shape;


//! Duplication of a shape.
//! A Copy object provides a framework for:
//! -   defining the construction of a duplicate shape,
//! -   implementing the construction algorithm, and
//! -   consulting the result.
class BRepBuilderAPI_Copy  : public BRepBuilderAPI_ModifyShape
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Constructs an empty copy framework. Use the function
  //! Perform to copy shapes.
  Standard_EXPORT BRepBuilderAPI_Copy();
  
  //! Constructs a copy framework and copies the shape S.
  //! Use the function Shape to access the result.
  //! If copyGeom is False, only topological objects will be copied, while
  //! geometry will be shared with original shape.
  //! Note: the constructed framework can be reused to copy
  //! other shapes: just specify them with the function Perform.
  Standard_EXPORT BRepBuilderAPI_Copy(const TopoDS_Shape& S, const Standard_Boolean copyGeom = Standard_True);
  
  //! Copies the shape S.
  //! Use the function Shape to access the result.
  //! If copyGeom is False, only topological objects will be copied, while
  //! geometry will be shared with original shape.
  Standard_EXPORT   void Perform (const TopoDS_Shape& S, const Standard_Boolean copyGeom = Standard_True) ;




protected:





private:





};







#endif // _BRepBuilderAPI_Copy_HeaderFile
