
      SUBROUTINE SCO_getdimimp(id_port_id,sco_jf, kinfo)

C*****
C               *****************************
C               * OASIS ROUTINE  -  LEVEL 3 *
C               * -------------     ------- *
C               *****************************
C
C**** *SCO_getdimimp*  
C
C     Purpose:
C     -------
C     The routine defines the dimension of the imported 'sco_jf' field. 
C     The dimension is expressed in byte
C
C     Interface:
C     ---------
C       *CALL*  *SCO_getdimimp(id_port_id,sco_jf, kinfo)
C
C     Called from:
C     -----------
C     getfld
C
C     Input:
C     -----
C             id_port_id : port number of the field
C             sco_jf  :  field identificator
C     Output:
C     ------
C             kinfo : output status
C
C     History:
C     -------
C       Version   Programmer         Date        Description
C       -------   ----------         ----        -----------  
C       3.3       I. Epicoco(CMCC)   09/11/16    created
C
C %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C* ---------------------------- Modules used ----------------------------
C
#if defined use_oasis_cmcc_para && (use_comm_MPI1 || defined use_comm_MPI2 || (!defined use_comm_MPI1 && !defined use_comm_MPI2 && !defined use_comm_SIPC && !defined use_comm_GMEM && !defined use_comm_PIPE && !defined use_comm_NONE))
      USE mod_comclim
C* ---------------------------- Include files ---------------------------
C
#include <mpif.h>
C* ---------------------------- Argument declarations -------------------------------
C
      INTEGER (kind=ip_intwp_p)     id_port_id, sco_jf, kinfo
C* ---------------------------- Local declarations ----------------------
C
      INTEGER (kind=ip_intwp_p)	    ilk, iseg, is, ilgb, ilen
C %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C
c
c*    0. Entering
c     -----------
c
      IF (coupler_rank .EQ. 0) THEN
      kinfo = 0
c
c*    1. check for this port in my list
c     ---------------------------------
c
      iport = -1
c
      IF (myport(1,id_port_id).eq.CLIM_In) iport=id_port_id
      IF (iport.lt.0) THEN
         kinfo = -1
         WRITE(nulprt,FMT='(A,A)')
     *         'getdimimp - WARNING - Invalid port out: ', 
     $        cports(id_port_id)
         GO TO 1010
      ENDIF
c
c*    2. check for connected ports (in)
c     ---------------------------------
c
c
      ityp = myport(2,iport)
c
      DO 290 ip=1,myport(5,iport)
c
         ilk  = myport(5+ip,iport)
         iseg = mylink(4,ilk)
c
               ilgb = 0
               DO 260 is=1,iseg
                  ilen = mylink(4+2*is,ilk)
c
                 ilgb = ilgb + ilen
 260           CONTINUE
c
 290  CONTINUE
      sco_ig_nbrecv(sco_jf)=ilgb*8
      ENDIF
      call MPI_BCAST( sco_ig_nbrecv(sco_jf), 1, MPI_INTEGER,
     $       0, coupler_comm, error )
         IF (error .NE. MPI_SUCCESS) THEN
             CALL prtout('Error MPIBCAST',1,2)
             CALL HALTE ('STOP in sco_getdimimp')
         ENDIF
c
c
c     ----------------------------------------------------------------
c
 1010 CONTINUE
#endif
      RETURN
      END

      SUBROUTINE SCO_getdimexp(id_port_id,sco_jf, kinfo)
C*****
C               *****************************
C               * OASIS ROUTINE  -  LEVEL 3 *
C               * -------------     ------- *
C               *****************************
C
C**** *SCO_getdimexp*  
C
C     Purpose:
C     -------
C     The routine defines the dimension of the exported 'sco_jf' field. 
C     the dimension is expressed in byte
C
C     Interface:
C     ---------
C       *CALL*  *SCO_getdimexp(id_port_id,sco_jf, kinfo)
C
C     Called from:
C     -----------
C     givfld
C
C     Input:
C     -----
C             id_port_id : port number of the field
C             sco_jf  :  field identificator
C     Output:
C     ------
C             kinfo : output status
C
C     History:
C     -------
C       Version   Programmer         Date        Description
C       -------   ----------         ----        -----------  
C       3.3       I. Epicoco(CMCC)   09/11/16    created
C
C %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C* ---------------------------- Modules used ----------------------------
C
#if defined use_oasis_cmcc_para && (use_comm_MPI1 || defined use_comm_MPI2 || (!defined use_comm_MPI1 && !defined use_comm_MPI2 && !defined use_comm_SIPC && !defined use_comm_GMEM && !defined use_comm_PIPE && !defined use_comm_NONE))
      USE mod_comclim
C* ---------------------------- Include files ---------------------------
C
#include <mpif.h>
C* ---------------------------- Argument declarations -------------------------------
C
      INTEGER (kind=ip_intwp_p)     id_port_id, sco_jf, kinfo
C* ---------------------------- Local declarations ----------------------
C
      INTEGER (kind=ip_intwp_p)     ilk, iseg, is, ilgb, ilen
C %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C
c
c*    0. Entering
c     -----------
c
      IF (coupler_rank .EQ. 0) THEN
      kinfo = 0
c
c*    1. check for this port in my list
c     ---------------------------------
c
      iport = -1
c
      IF (myport(1,id_port_id).eq.CLIM_Out) iport=id_port_id
      IF (iport.lt.0) THEN
         kinfo = -1
         WRITE(nulprt,FMT='(A,A)')
     *         'getdimimp - WARNING - Invalid port out: ', 
     $        cports(id_port_id)
         GO TO 1020
      ENDIF
c
c*    2. check for connected ports (in)
c     ---------------------------------
c
c
      ityp = myport(2,iport)
c
      DO 290 ip=1,myport(5,iport)
c
         ilk  = myport(5+ip,iport)
         iseg = mylink(4,ilk)
c
               ilgb = 0
               DO 260 is=1,iseg
                  ilen = mylink(4+2*is,ilk)
c
                 ilgb = ilgb + ilen
 260           CONTINUE
c
 290  CONTINUE
      sco_ig_nbsend(sco_jf)=ilgb*8
      ENDIF
      call MPI_BCAST( sco_ig_nbsend(sco_jf), 1, MPI_INTEGER,
     $       0, coupler_comm, error )
         IF (error .NE. MPI_SUCCESS) THEN
             CALL prtout('Error MPIBCAST',1,2)
             CALL HALTE ('STOP in co_getdimexp')
         ENDIF
c
c
c     ----------------------------------------------------------------
c
 1020 CONTINUE
#endif
      RETURN
      END
