/* $Id: ID2_Reply_Data.cpp 534721 2017-05-01 18:13:51Z grichenk $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'id2.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <objects/id2/ID2_Reply_Data.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CID2_Reply_Data::~CID2_Reply_Data(void)
{
}


COctetStringSequenceWriter::COctetStringSequenceWriter(TOctetStringSequence& out)
    : m_Output(out)
{
}
    
ERW_Result COctetStringSequenceWriter::Write(const void* buffer,
                                             size_t      count,
                                             size_t*     written)
{
    const char* data = static_cast<const char*>(buffer);
    m_Output.push_back(new TOctetString(data, data+count));
    if ( written ) {
        *written = count;
    }
    return eRW_Success;
}


ERW_Result COctetStringSequenceWriter::Flush(void)
{
    return eRW_Success;
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 57, chars: 1731, CRC32: 5659d7c6 */
