/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.tr;

import com.jclark.xsl.expr.BooleanExpr;
import com.jclark.xsl.expr.CloneableNodeIterator;
import com.jclark.xsl.expr.CloneableNodeIteratorImpl;
import com.jclark.xsl.expr.EmptyVariableSet;
import com.jclark.xsl.expr.ExprParser;
import com.jclark.xsl.expr.ExtensionContext;
import com.jclark.xsl.expr.NodeSetExpr;
import com.jclark.xsl.expr.NumberVariant;
import com.jclark.xsl.expr.StringExpr;
import com.jclark.xsl.expr.StringVariant;
import com.jclark.xsl.expr.TopLevelPattern;
import com.jclark.xsl.expr.VariableSet;
import com.jclark.xsl.expr.Variant;
import com.jclark.xsl.expr.VariantExpr;
import com.jclark.xsl.om.LoadContext;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.NameTable;
import com.jclark.xsl.om.NamespacePrefixMap;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.NodeIterator;
import com.jclark.xsl.om.SafeNodeIterator;
import com.jclark.xsl.om.XMLProcessor;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.tr.Action;
import com.jclark.xsl.tr.AddVariableSet;
import com.jclark.xsl.tr.AnyLevelNumberAction;
import com.jclark.xsl.tr.AppendAction;
import com.jclark.xsl.tr.ApplyImportsAction;
import com.jclark.xsl.tr.AttributeAction;
import com.jclark.xsl.tr.BilevelComparatorTemplate;
import com.jclark.xsl.tr.BindLocalParamAction;
import com.jclark.xsl.tr.BindLocalVariableAction;
import com.jclark.xsl.tr.BuiltinAction;
import com.jclark.xsl.tr.CharsAction;
import com.jclark.xsl.tr.CommentAction;
import com.jclark.xsl.tr.ComparatorTemplate;
import com.jclark.xsl.tr.CopyAction;
import com.jclark.xsl.tr.CopyOfAction;
import com.jclark.xsl.tr.ElementAction;
import com.jclark.xsl.tr.EmptyAction;
import com.jclark.xsl.tr.ExprNumberAction;
import com.jclark.xsl.tr.ExtensionHandler;
import com.jclark.xsl.tr.ForEachAction;
import com.jclark.xsl.tr.IfAction;
import com.jclark.xsl.tr.Importance;
import com.jclark.xsl.tr.InvokeAction;
import com.jclark.xsl.tr.Lang;
import com.jclark.xsl.tr.LiteralAttributeAction;
import com.jclark.xsl.tr.LiteralElementAction;
import com.jclark.xsl.tr.MultiLevelNumberAction;
import com.jclark.xsl.tr.NodeComparatorTemplate;
import com.jclark.xsl.tr.NumberListFormatTemplate;
import com.jclark.xsl.tr.ParamAction;
import com.jclark.xsl.tr.Priority;
import com.jclark.xsl.tr.ProcessAction;
import com.jclark.xsl.tr.ProcessContext;
import com.jclark.xsl.tr.ProcessingInstructionAction;
import com.jclark.xsl.tr.Result;
import com.jclark.xsl.tr.ResultFragmentExpr;
import com.jclark.xsl.tr.Sheet;
import com.jclark.xsl.tr.SingleLevelNumberAction;
import com.jclark.xsl.tr.SortNodeSetExpr;
import com.jclark.xsl.tr.TemplateAttributeAction;
import com.jclark.xsl.tr.TemplateRuleSet;
import com.jclark.xsl.tr.UnbindLocalVariablesAction;
import com.jclark.xsl.tr.ValueOfAction;
import com.jclark.xsl.util.Comparator;
import com.jclark.xsl.util.NumberComparator;
import com.jclark.xsl.util.ReverseComparator;
import com.jclark.xsl.util.TextComparator;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

class SheetImpl
implements Sheet,
LoadContext {
    static final int OPEN_ACTION_INIT_SIZE = 2;
    static StringVariant emptyStringVariant = new StringVariant("");
    private boolean stripSource = false;
    Hashtable stripSourceTable = null;
    private boolean indentResult = false;
    private String resultNamespace = null;
    TemplateRuleSet templateRules = new TemplateRuleSet(new BuiltinAction());
    private Hashtable modeTable = new Hashtable();
    Hashtable namedTemplateTable = new Hashtable();
    Hashtable variableExprTable = new Hashtable();
    private Vector idAttributes = new Vector();
    static final Action emptyAction = new EmptyAction();
    private Hashtable topLevelTable = new Hashtable();
    private Hashtable actionTable = new Hashtable();
    Importance currentImportance = Importance.create();
    Importance firstImportImportance = Importance.create();
    static NodeSetExpr childrenExpr = ExprParser.getChildrenExpr();
    VariableSet currentLocalVariables = new EmptyVariableSet();
    int nCurrentLocalVariables = 0;
    XMLProcessor parser;
    Name XSL_WHEN;
    Name XSL_OTHERWISE;
    Name XSL_STYLESHEET;
    Name XSL_TRANSFORM;
    Name XSL_WITH_PARAM;
    Name XSL_SORT;
    Name XSL_FOR_EACH;
    Name XSL_VERSION;
    Name XSL_VENDOR;
    Name XSL_VENDOR_URL;
    Name HREF;
    Name MATCH;
    Name PRIORITY;
    Name SELECT;
    Name TEST;
    Name DEFAULT_SPACE;
    Name INDENT_RESULT;
    Name RESULT_NS;
    Name NAME;
    Name NAMESPACE;
    Name DEFAULT;
    Name VALUE;
    Name ELEMENTS;
    Name ATTRIBUTE;
    Name FROM;
    Name COUNT;
    Name LEVEL;
    Name FORMAT;
    Name LETTER_VALUE;
    Name GROUPING_SIZE;
    Name GROUPING_SEPARATOR;
    Name MODE;
    Name ORDER;
    Name LANG;
    Name CASE_ORDER;
    Name DATA_TYPE;
    LoadContext sheetLoadContext;
    NameTable nameTable;
    ExtensionHandler extensionHandler;
    static final String XSL_NAMESPACE = "http://www.w3.org/XSL/Transform/1.0";

    static Name expandSourceElementTypeName(String string, Node node) throws XSLException {
        return node.getNamespacePrefixMap().expandAttributeName(string, node);
    }

    public Result process(Node node, Result result) throws XSLException {
        result.start();
        new ProcessContextImpl(node).processSafe(node, null, result);
        result.end();
        return result;
    }

    public boolean getIncludeProcessingInstructions() {
        return true;
    }

    public boolean getStripSource(Name name) {
        Boolean bl;
        if (this.stripSourceTable != null && (bl = (Boolean)this.stripSourceTable.get(name)) != null) {
            return bl;
        }
        return this.stripSource;
    }

    private static String unquoteNamespace(String string) {
        if (string != null && string.startsWith("quote:")) {
            return string.substring(6);
        }
        return null;
    }

    private void parseSheet(Node node) throws XSLException, IOException {
        Object object;
        Node node2 = node.getChildren().next();
        if (XSL_NAMESPACE.equals(node2.getName().getNamespace())) {
            if (!this.XSL_STYLESHEET.equals(node2.getName()) && !this.XSL_TRANSFORM.equals(node2.getName())) {
                throw new XSLException("bad document element for stylesheet", node2);
            }
            if ("strip".equals(node2.getAttributeValue(this.DEFAULT_SPACE))) {
                this.stripSource = true;
            }
            if ("yes".equals(node2.getAttributeValue(this.INDENT_RESULT))) {
                this.indentResult = true;
            }
            this.resultNamespace = node2.getAttributeValue(this.RESULT_NS);
            if (this.resultNamespace != null) {
                object = node2.getNamespacePrefixMap();
                this.resultNamespace = this.resultNamespace.equals("") ? object.getDefaultNamespace() : object.getNamespace(this.resultNamespace);
            }
            this.parseTopLevel(node2);
        } else {
            this.parseRootTemplate(node2);
        }
        this.templateRules.compile();
        object = this.modeTable.elements();
        while (object.hasMoreElements()) {
            ((TemplateRuleSet)object.nextElement()).compile();
        }
    }

    NumberListFormatTemplate getNumberListFormatTemplate(Node node) throws XSLException {
        NumberListFormatTemplate numberListFormatTemplate = new NumberListFormatTemplate();
        String string = node.getAttributeValue(this.FORMAT);
        if (string != null) {
            StringExpr stringExpr = ExprParser.parseAttributeValueTemplate(node, string, this.currentLocalVariables);
            String string2 = stringExpr.constantValue();
            if (string2 != null) {
                numberListFormatTemplate.setFormat(string2);
            } else {
                numberListFormatTemplate.setFormat(stringExpr);
            }
        }
        if ((string = node.getAttributeValue(this.LANG)) != null) {
            numberListFormatTemplate.setLang(string);
        }
        if ((string = node.getAttributeValue(this.LETTER_VALUE)) != null) {
            numberListFormatTemplate.setLetterValue(string);
        }
        if ((string = node.getAttributeValue(this.GROUPING_SIZE)) != null) {
            try {
                numberListFormatTemplate.setGroupingSize(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((string = node.getAttributeValue(this.GROUPING_SEPARATOR)) != null) {
            numberListFormatTemplate.setGroupingSeparator(string);
        }
        return numberListFormatTemplate;
    }

    private Name xsl(String string) {
        return this.nameTable.createName("xsl:" + string, XSL_NAMESPACE);
    }

    SheetImpl(Node node, XMLProcessor xMLProcessor, ExtensionHandler extensionHandler, LoadContext loadContext, NameTable nameTable) throws IOException, XSLException {
        this.sheetLoadContext = loadContext;
        this.nameTable = nameTable;
        this.parser = xMLProcessor;
        this.extensionHandler = extensionHandler;
        this.XSL_WHEN = this.xsl("when");
        this.XSL_OTHERWISE = this.xsl("otherwise");
        this.XSL_STYLESHEET = this.xsl("stylesheet");
        this.XSL_TRANSFORM = this.xsl("transform");
        this.XSL_WITH_PARAM = this.xsl("with-param");
        this.XSL_SORT = this.xsl("sort");
        this.XSL_FOR_EACH = this.xsl("for-each");
        this.XSL_VERSION = this.xsl("version");
        this.XSL_VENDOR = this.xsl("vendor");
        this.XSL_VENDOR_URL = this.xsl("vendor-url");
        this.HREF = nameTable.createName("href");
        this.SELECT = nameTable.createName("select");
        this.TEST = nameTable.createName("test");
        this.MATCH = nameTable.createName("match");
        this.PRIORITY = nameTable.createName("priority");
        this.DEFAULT_SPACE = nameTable.createName("default-space");
        this.INDENT_RESULT = nameTable.createName("indent-result");
        this.RESULT_NS = nameTable.createName("result-ns");
        this.NAME = nameTable.createName("name");
        this.NAMESPACE = nameTable.createName("namespace");
        this.DEFAULT = nameTable.createName("default");
        this.VALUE = nameTable.createName("value");
        this.ELEMENTS = nameTable.createName("elements");
        this.ATTRIBUTE = nameTable.createName("attribute");
        this.COUNT = nameTable.createName("count");
        this.LEVEL = nameTable.createName("level");
        this.FROM = nameTable.createName("from");
        this.FORMAT = nameTable.createName("format");
        this.LETTER_VALUE = nameTable.createName("letter-value");
        this.GROUPING_SIZE = nameTable.createName("grouping-size");
        this.GROUPING_SEPARATOR = nameTable.createName("grouping-separator");
        this.MODE = nameTable.createName("mode");
        this.ORDER = nameTable.createName("order");
        this.LANG = nameTable.createName("lang");
        this.DATA_TYPE = nameTable.createName("data-type");
        this.CASE_ORDER = nameTable.createName("case-order");
        this.topLevelTable.put(this.xsl("include"), new IncludeParser());
        this.topLevelTable.put(this.xsl("import"), new ImportParser());
        this.topLevelTable.put(this.xsl("template"), new TemplateParser());
        this.topLevelTable.put(this.xsl("attribute-set"), new AttributeSetParser());
        this.topLevelTable.put(this.xsl("locale"), new LocaleParser());
        this.topLevelTable.put(this.xsl("key"), new KeyParser());
        this.topLevelTable.put(this.xsl("variable"), new VariableTopLevelParser());
        this.topLevelTable.put(this.xsl("param"), new VariableTopLevelParser());
        this.topLevelTable.put(this.xsl("strip-space"), new StripSpaceParser());
        this.topLevelTable.put(this.xsl("preserve-space"), new PreserveSpaceParser());
        this.actionTable.put(this.xsl("text"), new TextParser());
        this.actionTable.put(this.xsl("apply-templates"), new ApplyTemplatesParser());
        this.actionTable.put(this.xsl("call-template"), new CallTemplateParser());
        this.actionTable.put(this.xsl("for-each"), new ForEachParser());
        this.actionTable.put(this.xsl("value-of"), new ValueOfParser());
        this.actionTable.put(this.xsl("number"), new NumberParser());
        this.actionTable.put(this.xsl("if"), new IfParser());
        this.actionTable.put(this.xsl("choose"), new ChooseParser());
        this.actionTable.put(this.xsl("copy"), new CopyParser());
        this.actionTable.put(this.xsl("copy-of"), new CopyOfParser());
        this.actionTable.put(this.xsl("comment"), new CommentParser());
        this.actionTable.put(this.xsl("processing-instruction"), new ProcessingInstructionParser());
        this.actionTable.put(this.xsl("element"), new ElementParser());
        this.actionTable.put(this.xsl("attribute"), new AttributeParser());
        this.actionTable.put(this.xsl("apply-imports"), new ApplyImportsParser());
        this.actionTable.put(this.xsl("variable"), new VariableActionParser());
        this.actionTable.put(this.xsl("param"), new ParamActionParser());
        this.actionTable.put(this.xsl("message"), new MessageParser());
        this.parseSheet(node);
    }

    TemplateRuleSet getModeTemplateRuleSet(Name name) {
        if (name == null) {
            return this.templateRules;
        }
        TemplateRuleSet templateRuleSet = (TemplateRuleSet)this.modeTable.get(name);
        if (templateRuleSet == null) {
            templateRuleSet = new TemplateRuleSet(new BuiltinAction(name));
            this.modeTable.put(name, templateRuleSet);
        }
        return templateRuleSet;
    }

    VariantExpr getVariantExpr(Node node) throws XSLException {
        String string = node.getAttributeValue(this.SELECT);
        if (string != null) {
            return ExprParser.parseVariantExpr(node, string, this.currentLocalVariables);
        }
        return new ResultFragmentExpr(this.parseActions(node, emptyAction), this.extensionHandler);
    }

    public boolean getIndentResult() {
        return this.indentResult;
    }

    Name unquoteName(Name name, Node node) {
        String string = SheetImpl.unquoteNamespace(name.getNamespace());
        if (string == null) {
            return name;
        }
        return this.nameTable.createName(name.toString(), string);
    }

    public boolean getIncludeComments() {
        return true;
    }

    String getData(Node node) throws XSLException {
        if ((node = node.getChildren().next()) == null) {
            return "";
        }
        String string = node.getData();
        if (string == null) {
            throw new XSLException("only character data allowed", node);
        }
        return string;
    }

    void parseRootTemplate(Node node) throws XSLException {
        this.templateRules.add(ExprParser.parsePattern(node, "/"), this.currentImportance, this.firstImportImportance, null, this.parseActions(node, emptyAction));
    }

    String getRequiredAttribute(Node node, Name name) throws XSLException {
        String string = node.getAttributeValue(name);
        if (string == null) {
            throw new XSLException("missing attribute \"" + name + "\"", node);
        }
        return string;
    }

    private static NamespacePrefixMap unquoteNamespacePrefixMap(NamespacePrefixMap namespacePrefixMap) {
        String string = namespacePrefixMap.getDefaultNamespace();
        if (XSL_NAMESPACE.equals(string)) {
            namespacePrefixMap = namespacePrefixMap.unbindDefault();
        } else if ((string = SheetImpl.unquoteNamespace(string)) != null) {
            namespacePrefixMap = namespacePrefixMap.bindDefault(string);
        }
        NamespacePrefixMap namespacePrefixMap2 = namespacePrefixMap;
        int n = namespacePrefixMap.getSize();
        int n2 = 0;
        while (n2 < n) {
            string = namespacePrefixMap.getNamespace(n2);
            if (XSL_NAMESPACE.equals(string)) {
                namespacePrefixMap2 = namespacePrefixMap2.unbind(namespacePrefixMap.getPrefix(n2));
            } else if ((string = SheetImpl.unquoteNamespace(string)) != null) {
                namespacePrefixMap2 = namespacePrefixMap2.bind(namespacePrefixMap.getPrefix(n2), string);
            }
            ++n2;
        }
        return namespacePrefixMap2;
    }

    Action addParams(ParamAction paramAction, Node node) throws XSLException {
        SafeNodeIterator safeNodeIterator = node.getChildren();
        while ((node = safeNodeIterator.next()) != null) {
            if (!this.XSL_WITH_PARAM.equals(node.getName())) continue;
            paramAction.addParam(SheetImpl.expandSourceElementTypeName(this.getRequiredAttribute(node, this.NAME), node), this.getVariantExpr(node));
        }
        return paramAction;
    }

    Action parseActions(Node node, Action action) throws XSLException {
        return this.parseActions(node, action, null);
    }

    public String getResultNamespace() {
        return this.resultNamespace;
    }

    Action parseActions(Node node, Action action, AppendAction appendAction) throws XSLException {
        VariableSet variableSet = this.currentLocalVariables;
        int n = this.nCurrentLocalVariables;
        SafeNodeIterator safeNodeIterator = node.getChildren();
        if ((node = safeNodeIterator.next()) == null) {
            if (appendAction == null) {
                return action;
            }
            return appendAction;
        }
        if (appendAction == null) {
            appendAction = new AppendAction();
        }
        block6: do {
            switch (node.getType()) {
                case 1: {
                    appendAction.add(new CharsAction(node.getData()));
                    break;
                }
                case 0: {
                    Name name = node.getName();
                    if (!XSL_NAMESPACE.equals(name.getNamespace())) {
                        appendAction.add(new LiteralElementAction(this.unquoteName(node.getName(), node), SheetImpl.unquoteNamespacePrefixMap(node.getNamespacePrefixMap()), this.parseAttributesAndActions(node)));
                        break;
                    }
                    ActionParser actionParser = null;
                    try {
                        actionParser = (ActionParser)this.actionTable.get(name);
                    }
                    catch (ClassCastException classCastException) {}
                    if (actionParser == null) {
                        if (name.equals(this.XSL_SORT) && this.XSL_FOR_EACH.equals(node.getParent().getName())) continue block6;
                        throw new XSLException("expected action not " + name, node);
                    }
                    appendAction.add(actionParser.parse(node));
                }
            }
        } while ((node = safeNodeIterator.next()) != null);
        if (n != this.nCurrentLocalVariables) {
            appendAction.add(new UnbindLocalVariablesAction(this.nCurrentLocalVariables - n));
            this.nCurrentLocalVariables = n;
            this.currentLocalVariables = variableSet;
        }
        return appendAction;
    }

    Action parseAttributesAndActions(Node node) throws XSLException {
        Node node2;
        AppendAction appendAction = null;
        SafeNodeIterator safeNodeIterator = node.getAttributes();
        while ((node2 = safeNodeIterator.next()) != null) {
            if (appendAction == null) {
                appendAction = new AppendAction();
            }
            String string = node2.getData();
            Name name = this.unquoteName(node2.getName(), node);
            if (string.indexOf(123) >= 0 || string.indexOf(125) >= 0) {
                appendAction.add(new TemplateAttributeAction(name, ExprParser.parseAttributeValueTemplate(node, string, this.currentLocalVariables)));
                continue;
            }
            appendAction.add(new LiteralAttributeAction(name, string));
        }
        return this.parseActions(node, null, appendAction);
    }

    String getOptionalAttribute(Node node, Name name, String string) {
        String string2 = node.getAttributeValue(name);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    NodeSetExpr getSortNodeSetExpr(Node node, NodeSetExpr nodeSetExpr) throws XSLException {
        ComparatorTemplate comparatorTemplate = null;
        SafeNodeIterator safeNodeIterator = node.getChildren();
        while ((node = safeNodeIterator.next()) != null) {
            Comparator comparator;
            if (!this.XSL_SORT.equals(node.getName())) continue;
            Locale locale = Lang.getLocale(node.getAttributeValue(this.LANG));
            String string = node.getAttributeValue(this.DATA_TYPE);
            if ("number".equals(string)) {
                comparator = new NumberComparator(locale);
            } else {
                int n = 0;
                String string2 = node.getAttributeValue(this.CASE_ORDER);
                if ("upper-first".equals(string2)) {
                    n = 1;
                } else if ("lower-first".equals(string2)) {
                    n = 2;
                }
                comparator = TextComparator.create(locale, n);
            }
            if ("descending".equals(node.getAttributeValue(this.ORDER))) {
                comparator = new ReverseComparator(comparator);
            }
            NodeComparatorTemplate nodeComparatorTemplate = new NodeComparatorTemplate(comparator, ExprParser.parseStringExpr(node, this.getOptionalAttribute(node, this.SELECT, "."), this.currentLocalVariables));
            if (comparatorTemplate == null) {
                comparatorTemplate = nodeComparatorTemplate;
                continue;
            }
            comparatorTemplate = new BilevelComparatorTemplate(comparatorTemplate, nodeComparatorTemplate);
        }
        if (comparatorTemplate == null) {
            return nodeSetExpr;
        }
        return new SortNodeSetExpr(nodeSetExpr, comparatorTemplate);
    }

    void parseTopLevel(Node node) throws XSLException, IOException {
        Node node2;
        SafeNodeIterator safeNodeIterator = node.getChildren();
        while ((node2 = safeNodeIterator.next()) != null) {
            TopLevelParser topLevelParser = null;
            try {
                Name name = node2.getName();
                if (name == null) {
                    throw new XSLException("illegal data characters inside xsl:stylesheet", node2);
                }
                topLevelParser = (TopLevelParser)this.topLevelTable.get(name);
                if (topLevelParser == null && name.getNamespace() == null) {
                    throw new XSLException("illegal top-level element", node2);
                }
            }
            catch (ClassCastException classCastException) {}
            topLevelParser.parse(node2);
        }
    }

    public LoadContext getSourceLoadContext() {
        return this;
    }

    class ProcessContextImpl
    implements ProcessContext {
        Node root;
        Hashtable variableValueTable;
        Name evalGlobalVariableName;
        Name[] actionNames;
        Node[] actionNodes;
        int[] actionImportLevels;
        int[] actionForEachLevels;
        int nOpenActions;
        VariableBindings localVariables;
        Name[] currentParamNames;
        Variant[] currentParamValues;
        int position;
        int lastPosition;
        NodeIterator currentIter;
        Hashtable extensionTable;

        public ExtensionContext getExtensionContext(String string) throws XSLException {
            ExtensionContext extensionContext = (ExtensionContext)this.extensionTable.get(string);
            if (extensionContext == null) {
                extensionContext = SheetImpl.this.extensionHandler.createContext(string);
                if (extensionContext == null) {
                    extensionContext = new ExtensionContext(){
                        {
                            ProcessContextImpl.this.getClass();
                        }

                        public boolean available(String string) {
                            return false;
                        }

                        public Object call(String string, Node node, Object[] objectArray) throws XSLException {
                            throw new XSLException("implementation of extension namespace not available");
                        }
                    };
                }
                this.extensionTable.put(string, extensionContext);
            }
            return extensionContext;
        }

        private void processUnsafe(Node node, Name name, Result result) throws XSLException {
            this.getAction(name, node).invoke(this, node, result);
        }

        public void process(NodeIterator nodeIterator, Name name, Name[] nameArray, Variant[] variantArray, Result result) throws XSLException {
            int n = this.position;
            int n2 = this.lastPosition;
            NodeIterator nodeIterator2 = this.currentIter;
            this.currentIter = nodeIterator;
            this.position = 0;
            this.lastPosition = 0;
            Name[] nameArray2 = this.currentParamNames;
            this.currentParamNames = nameArray;
            Variant[] variantArray2 = this.currentParamValues;
            this.currentParamValues = variantArray;
            boolean bl = variantArray == null;
            try {
                Node node;
                while ((node = this.currentIter.next()) != null) {
                    ++this.position;
                    if (bl) {
                        this.processSafe(node, name, result);
                        continue;
                    }
                    this.processUnsafe(node, name, result);
                }
                Object var14_13 = null;
                this.position = n;
                this.lastPosition = n2;
                this.currentIter = nodeIterator2;
                this.currentParamNames = nameArray2;
                this.currentParamValues = variantArray2;
                return;
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                this.position = n;
                this.lastPosition = n2;
                this.currentIter = nodeIterator2;
                this.currentParamNames = nameArray2;
                this.currentParamValues = variantArray2;
                throw throwable;
            }
        }

        public void applyImports(Node node, Result result) throws XSLException {
            if (this.actionForEachLevels != null && this.actionForEachLevels[this.nOpenActions - 1] > 0) {
                return;
            }
            if (this.actionImportLevels == null) {
                this.actionImportLevels = new int[this.nOpenActions];
            } else if (this.nOpenActions > this.actionImportLevels.length) {
                int[] nArray = this.actionImportLevels;
                this.actionImportLevels = new int[this.nOpenActions];
                System.arraycopy(nArray, 0, this.actionImportLevels, 0, nArray.length);
            }
            int n = this.nOpenActions - 1;
            int n2 = this.actionImportLevels[n];
            this.actionImportLevels[n] = n2 + 1;
            SheetImpl.this.getModeTemplateRuleSet(this.actionNames[this.nOpenActions - 1]).getImportAction(node, this, n2).invoke(this, node, result);
            int n3 = this.nOpenActions - 1;
            this.actionImportLevels[n3] = this.actionImportLevels[n3] + -1;
        }

        public void invoke(NodeIterator nodeIterator, Action action, Result result) throws XSLException {
            int n;
            Object object;
            int n2 = this.position;
            int n3 = this.lastPosition;
            NodeIterator nodeIterator2 = this.currentIter;
            this.currentIter = nodeIterator;
            this.position = 0;
            this.lastPosition = 0;
            if (this.actionForEachLevels == null) {
                this.actionForEachLevels = new int[this.nOpenActions];
            } else if (this.nOpenActions > this.actionForEachLevels.length) {
                object = this.actionForEachLevels;
                this.actionForEachLevels = new int[this.nOpenActions];
                System.arraycopy(object, 0, this.actionForEachLevels, 0, ((int[])object).length);
            }
            int n4 = this.nOpenActions - 1;
            this.actionForEachLevels[n4] = this.actionForEachLevels[n4] + 1;
            try {
                while ((object = (Object)this.currentIter.next()) != null) {
                    ++this.position;
                    action.invoke(this, (Node)object, result);
                }
                Object var9_8 = null;
                n = this.nOpenActions - 1;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                int n5 = this.nOpenActions - 1;
                this.actionForEachLevels[n5] = this.actionForEachLevels[n5] + -1;
                this.position = n2;
                this.lastPosition = n3;
                this.currentIter = nodeIterator2;
                throw throwable;
            }
            this.actionForEachLevels[n] = this.actionForEachLevels[n] + -1;
            this.position = n2;
            this.lastPosition = n3;
            this.currentIter = nodeIterator2;
        }

        public Variant getSystemProperty(Name name) {
            if (name.equals(SheetImpl.this.XSL_VERSION)) {
                return new NumberVariant(1.0);
            }
            if (name.equals(SheetImpl.this.XSL_VENDOR)) {
                return new StringVariant("James Clark");
            }
            if (name.equals(SheetImpl.this.XSL_VENDOR_URL)) {
                return new StringVariant("http://www.jclark.com/");
            }
            return emptyStringVariant;
        }

        void processSafe(Node node, Name name, Result result) throws XSLException {
            int n;
            if (name == null) {
                n = 0;
                while (n < this.nOpenActions) {
                    if (this.actionNames[n] == null && this.actionNodes[n].equals(node)) {
                        return;
                    }
                    ++n;
                }
            } else {
                n = 0;
                while (n < this.nOpenActions) {
                    if (name.equals(this.actionNames[n]) && this.actionNodes[n].equals(node)) {
                        return;
                    }
                    ++n;
                }
            }
            if (this.nOpenActions == this.actionNames.length) {
                Name[] nameArray = this.actionNames;
                this.actionNames = new Name[this.nOpenActions * 2];
                System.arraycopy(nameArray, 0, this.actionNames, 0, this.nOpenActions);
                Node[] nodeArray = this.actionNodes;
                this.actionNodes = new Node[this.nOpenActions * 2];
                System.arraycopy(nodeArray, 0, this.actionNodes, 0, this.nOpenActions);
            }
            this.actionNames[this.nOpenActions] = name;
            this.actionNodes[this.nOpenActions] = node;
            ++this.nOpenActions;
            this.getAction(name, node).invoke(this, node, result);
            this.nOpenActions += -1;
        }

        public ProcessContext.Memento createMemento() {
            VariableBindings variableBindings = this.localVariables;
            final int n = this.position;
            int n2 = this.lastPosition;
            NodeIterator nodeIterator = this.lastPosition == 0 ? this.cloneCurrentIter() : null;
            Name name = this.evalGlobalVariableName;
            return new ProcessContext.Memento(this, name, variableBindings, nodeIterator, n2){
                private final /* synthetic */ int val$rememberLastPosition;
                private final /* synthetic */ NodeIterator val$rememberCurrentIter;
                private final /* synthetic */ VariableBindings val$rememberLocalVariables;
                private final /* synthetic */ Name val$rememberEvalGlobalVariableName;
                final /* synthetic */ ProcessContextImpl this$0;

                public void invoke(Action action, Node node, Result result) throws XSLException {
                    Name[] nameArray = this.this$0.currentParamNames;
                    this.this$0.currentParamNames = null;
                    Variant[] variantArray = this.this$0.currentParamValues;
                    this.this$0.currentParamValues = null;
                    int n3 = this.this$0.position;
                    this.this$0.position = n;
                    int n2 = this.this$0.lastPosition;
                    this.this$0.lastPosition = this.val$rememberLastPosition;
                    NodeIterator nodeIterator = this.this$0.currentIter;
                    this.this$0.currentIter = this.val$rememberCurrentIter;
                    VariableBindings variableBindings = this.this$0.localVariables;
                    this.this$0.localVariables = this.val$rememberLocalVariables;
                    Object v = null;
                    if (this.val$rememberEvalGlobalVariableName != null) {
                        v = this.this$0.variableValueTable.get(this.val$rememberEvalGlobalVariableName);
                        this.this$0.variableValueTable.put(this.val$rememberEvalGlobalVariableName, emptyStringVariant);
                    }
                    try {
                        action.invoke(this.this$0, node, result);
                    }
                    catch (Throwable throwable) {
                        block4: {
                            Object var12_12 = null;
                            this.this$0.currentParamNames = nameArray;
                            this.this$0.currentParamValues = variantArray;
                            this.this$0.localVariables = variableBindings;
                            this.this$0.position = n3;
                            this.this$0.lastPosition = n2;
                            this.this$0.currentIter = nodeIterator;
                            if (this.val$rememberEvalGlobalVariableName == null) break block4;
                            this.this$0.variableValueTable.put(this.val$rememberEvalGlobalVariableName, v);
                        }
                        throw throwable;
                    }
                    Object var12_11 = null;
                    this.this$0.currentParamNames = nameArray;
                    this.this$0.currentParamValues = variantArray;
                    this.this$0.localVariables = variableBindings;
                    this.this$0.position = n3;
                    this.this$0.lastPosition = n2;
                    this.this$0.currentIter = nodeIterator;
                    if (this.val$rememberEvalGlobalVariableName != null) {
                        this.this$0.variableValueTable.put(this.val$rememberEvalGlobalVariableName, v);
                    }
                }
                {
                    this.val$rememberLastPosition = n3;
                    this.val$rememberCurrentIter = nodeIterator;
                    this.val$rememberLocalVariables = variableBindings;
                    this.val$rememberEvalGlobalVariableName = name;
                    this.this$0 = processContextImpl;
                    this.this$0.getClass();
                }
            };
        }

        private final Action getAction(Name name, Node node) throws XSLException {
            return SheetImpl.this.getModeTemplateRuleSet(name).getAction(node, this);
        }

        public Variant getLocalVariableValue(Name name) {
            VariableBindings variableBindings = this.localVariables;
            while (variableBindings != null) {
                if (variableBindings.name.equals(name)) {
                    return variableBindings.value;
                }
                variableBindings = variableBindings.next;
            }
            throw new Error("no such local variable");
        }

        private NodeIterator cloneCurrentIter() {
            if (!(this.currentIter instanceof CloneableNodeIterator)) {
                this.currentIter = new CloneableNodeIteratorImpl(this.currentIter);
            }
            return (NodeIterator)((CloneableNodeIterator)this.currentIter).clone();
        }

        ProcessContextImpl(Node node) {
            SheetImpl.this.getClass();
            this.variableValueTable = new Hashtable();
            this.evalGlobalVariableName = null;
            this.actionNames = new Name[2];
            this.actionNodes = new Node[2];
            this.actionImportLevels = null;
            this.actionForEachLevels = null;
            this.nOpenActions = 0;
            this.currentParamNames = null;
            this.currentParamValues = null;
            this.position = 1;
            this.lastPosition = 1;
            this.currentIter = null;
            this.extensionTable = new Hashtable();
            this.root = node;
        }

        public final boolean hasAttribute(Vector vector, Node node, String string) {
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                if (string.equals(node.getAttributeValue((Name)vector.elementAt(n2)))) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public Variant getGlobalVariableValue(Name name) throws XSLException {
            Variant variant = (Variant)this.variableValueTable.get(name);
            if (variant != null) {
                return variant;
            }
            VariantExpr variantExpr = (VariantExpr)SheetImpl.this.variableExprTable.get(name);
            if (variantExpr == null) {
                return null;
            }
            this.variableValueTable.put(name, emptyStringVariant);
            Name name2 = this.evalGlobalVariableName;
            this.evalGlobalVariableName = name;
            try {
                variant = variantExpr.eval(this.root, this).makePermanent();
            }
            finally {
                Object var6_5 = null;
                this.evalGlobalVariableName = name2;
            }
            this.variableValueTable.put(name, variant);
            return variant;
        }

        public Variant getParam(Name name) {
            if (this.currentParamNames != null) {
                int n = 0;
                while (n < this.currentParamNames.length) {
                    if (name.equals(this.currentParamNames[n])) {
                        return this.currentParamValues[n];
                    }
                    ++n;
                }
            }
            return null;
        }

        public void invokeWithParams(Action action, Name[] nameArray, Variant[] variantArray, Node node, Result result) throws XSLException {
            Name[] nameArray2 = this.currentParamNames;
            this.currentParamNames = nameArray;
            Variant[] variantArray2 = this.currentParamValues;
            this.currentParamValues = variantArray;
            try {
                action.invoke(this, node, result);
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this.currentParamNames = nameArray2;
                this.currentParamValues = variantArray2;
                throw throwable;
            }
            Object var9_8 = null;
            this.currentParamNames = nameArray2;
            this.currentParamValues = variantArray2;
        }

        public void unbindLocalVariables(int n) {
            while (n > 0) {
                this.localVariables = this.localVariables.next;
                --n;
            }
        }

        public int getPosition() {
            return this.position;
        }

        public int getLastPosition() throws XSLException {
            if (this.lastPosition == 0) {
                this.lastPosition = this.position;
                NodeIterator nodeIterator = this.cloneCurrentIter();
                while (nodeIterator.next() != null) {
                    ++this.lastPosition;
                }
            }
            return this.lastPosition;
        }

        public void bindLocalVariable(Name name, Variant variant) {
            this.localVariables = new VariableBindings(name, variant.makePermanent(), this.localVariables);
        }
    }

    private class IncludeParser
    implements TopLevelParser {
        public void parse(Node node) throws XSLException, IOException {
            Node node2 = SheetImpl.this.parser.load(new URL(node.getURL(), SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.HREF)), SheetImpl.this.sheetLoadContext, SheetImpl.this.nameTable).getChildren().next();
            if (SheetImpl.XSL_NAMESPACE.equals(node2.getName().getNamespace())) {
                if (!SheetImpl.this.XSL_STYLESHEET.equals(node2.getName()) && !SheetImpl.this.XSL_TRANSFORM.equals(node2.getName())) {
                    throw new XSLException("bad document element for stylesheet", node2);
                }
                SheetImpl.this.parseTopLevel(node2);
                return;
            }
            SheetImpl.this.parseRootTemplate(node2);
        }

        IncludeParser() {
            SheetImpl.this.getClass();
        }
    }

    private class ImportParser
    extends IncludeParser {
        public void parse(Node node) throws XSLException, IOException {
            Importance importance = SheetImpl.this.firstImportImportance;
            SheetImpl.this.firstImportImportance = SheetImpl.this.currentImportance;
            super.parse(node);
            SheetImpl.this.currentImportance = SheetImpl.this.currentImportance.createHigher();
            SheetImpl.this.firstImportImportance = importance;
        }

        ImportParser() {
            SheetImpl.this.getClass();
        }
    }

    private class TemplateParser
    implements TopLevelParser {
        public void parse(Node node) throws XSLException {
            String string;
            String string2 = node.getAttributeValue(SheetImpl.this.NAME);
            Action action = SheetImpl.this.parseActions(node, emptyAction);
            if (string2 != null) {
                SheetImpl.this.namedTemplateTable.put(SheetImpl.expandSourceElementTypeName(string2, node), action);
            }
            if ((string = node.getAttributeValue(SheetImpl.this.MATCH)) == null) {
                return;
            }
            String string3 = node.getAttributeValue(SheetImpl.this.MODE);
            TemplateRuleSet templateRuleSet = string3 != null ? SheetImpl.this.getModeTemplateRuleSet(SheetImpl.expandSourceElementTypeName(string3, node)) : SheetImpl.this.templateRules;
            try {
                templateRuleSet.add(ExprParser.parsePattern(node, string), SheetImpl.this.currentImportance, SheetImpl.this.firstImportImportance, Priority.create(node.getAttributeValue(SheetImpl.this.PRIORITY)), action);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                throw new XSLException("invalid priority", node);
            }
        }

        TemplateParser() {
            SheetImpl.this.getClass();
        }
    }

    private class AttributeSetParser
    implements TopLevelParser {
        public void parse(Node node) throws XSLException {
        }

        AttributeSetParser() {
            SheetImpl.this.getClass();
        }
    }

    private class LocaleParser
    implements TopLevelParser {
        public void parse(Node node) throws XSLException {
        }

        LocaleParser() {
            SheetImpl.this.getClass();
        }
    }

    private class KeyParser
    implements TopLevelParser {
        public void parse(Node node) throws XSLException {
        }

        KeyParser() {
            SheetImpl.this.getClass();
        }
    }

    private class VariableTopLevelParser
    implements TopLevelParser {
        public void parse(Node node) throws XSLException {
            SheetImpl.this.variableExprTable.put(SheetImpl.expandSourceElementTypeName(SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.NAME), node), SheetImpl.this.getVariantExpr(node));
        }

        VariableTopLevelParser() {
            SheetImpl.this.getClass();
        }
    }

    private class StripSpaceParser
    implements TopLevelParser {
        public void parse(Node node) throws XSLException {
            this.parse(node, Boolean.TRUE);
        }

        void parse(Node node, Boolean bl) throws XSLException {
            if (SheetImpl.this.stripSourceTable == null) {
                SheetImpl.this.stripSourceTable = new Hashtable();
            }
            StringTokenizer stringTokenizer = new StringTokenizer(SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.ELEMENTS));
            while (stringTokenizer.hasMoreElements()) {
                SheetImpl.this.stripSourceTable.put(SheetImpl.expandSourceElementTypeName((String)stringTokenizer.nextElement(), node), bl);
            }
        }

        StripSpaceParser() {
            SheetImpl.this.getClass();
        }
    }

    private class PreserveSpaceParser
    extends StripSpaceParser {
        public void parse(Node node) throws XSLException {
            this.parse(node, Boolean.FALSE);
        }

        PreserveSpaceParser() {
            SheetImpl.this.getClass();
        }
    }

    private class TextParser
    implements ActionParser {
        public Action parse(Node node) throws XSLException {
            Node node2 = node.getChildren().next();
            if (node2 != null) {
                String string = node2.getData();
                if (string == null || node2.getFollowingSiblings().next() != null) {
                    throw new XSLException("xsl:text must not contain elements", node);
                }
                return new CharsAction(string);
            }
            return emptyAction;
        }

        TextParser() {
            SheetImpl.this.getClass();
        }
    }

    private class ApplyTemplatesParser
    implements ActionParser {
        public Action parse(Node node) throws XSLException {
            NodeSetExpr nodeSetExpr = SheetImpl.this.getSortNodeSetExpr(node, this.getNodeSetExpr(node));
            String string = node.getAttributeValue(SheetImpl.this.MODE);
            Name name = null;
            if (string != null) {
                name = SheetImpl.expandSourceElementTypeName(string, node);
            }
            return SheetImpl.this.addParams(new ProcessAction(nodeSetExpr, name), node);
        }

        ApplyTemplatesParser() {
            SheetImpl.this.getClass();
        }

        NodeSetExpr getNodeSetExpr(Node node) throws XSLException {
            String string = node.getAttributeValue(SheetImpl.this.SELECT);
            if (string == null) {
                return childrenExpr;
            }
            return ExprParser.parseNodeSetExpr(node, string, SheetImpl.this.currentLocalVariables);
        }
    }

    private class CallTemplateParser
    implements ActionParser {
        public Action parse(Node node) throws XSLException {
            return SheetImpl.this.addParams(new InvokeAction(SheetImpl.expandSourceElementTypeName(SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.NAME), node), SheetImpl.this.namedTemplateTable), node);
        }

        CallTemplateParser() {
            SheetImpl.this.getClass();
        }
    }

    private class ForEachParser
    implements ActionParser {
        public Action parse(Node node) throws XSLException {
            return new ForEachAction(SheetImpl.this.getSortNodeSetExpr(node, ExprParser.parseNodeSetExpr(node, SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.SELECT), SheetImpl.this.currentLocalVariables)), SheetImpl.this.parseActions(node, emptyAction));
        }

        ForEachParser() {
            SheetImpl.this.getClass();
        }
    }

    private class ValueOfParser
    implements ActionParser {
        public Action parse(Node node) throws XSLException {
            return new ValueOfAction(ExprParser.parseStringExpr(node, SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.SELECT), SheetImpl.this.currentLocalVariables));
        }

        ValueOfParser() {
            SheetImpl.this.getClass();
        }
    }

    private class NumberParser
    implements ActionParser {
        public Action parse(Node node) throws XSLException {
            NumberListFormatTemplate numberListFormatTemplate = SheetImpl.this.getNumberListFormatTemplate(node);
            String string = node.getAttributeValue(SheetImpl.this.VALUE);
            if (string != null) {
                return new ExprNumberAction(ExprParser.parseNumberExpr(node, string, SheetImpl.this.currentLocalVariables), numberListFormatTemplate);
            }
            String string2 = SheetImpl.this.getOptionalAttribute(node, SheetImpl.this.LEVEL, "single");
            String string3 = node.getAttributeValue(SheetImpl.this.COUNT);
            TopLevelPattern topLevelPattern = string3 == null ? null : ExprParser.parsePattern(node, string3);
            String string4 = node.getAttributeValue(SheetImpl.this.FROM);
            TopLevelPattern topLevelPattern2 = string4 == null ? null : ExprParser.parsePattern(node, string4);
            if (string2.equals("any")) {
                return new AnyLevelNumberAction(topLevelPattern, topLevelPattern2, numberListFormatTemplate);
            }
            if (string2.equals("multiple")) {
                return new MultiLevelNumberAction(topLevelPattern, topLevelPattern2, numberListFormatTemplate);
            }
            if (string2.equals("single")) {
                return new SingleLevelNumberAction(topLevelPattern, topLevelPattern2, numberListFormatTemplate);
            }
            throw new XSLException("bad level", node);
        }

        NumberParser() {
            SheetImpl.this.getClass();
        }
    }

    private class IfParser
    implements ActionParser {
        public Action parse(Node node) throws XSLException {
            return new IfAction(this.makeCondition(node), SheetImpl.this.parseActions(node, emptyAction), emptyAction);
        }

        IfParser() {
            SheetImpl.this.getClass();
        }

        BooleanExpr makeCondition(Node node) throws XSLException {
            return ExprParser.parseBooleanExpr(node, SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.TEST), SheetImpl.this.currentLocalVariables);
        }
    }

    private class ChooseParser
    extends IfParser {
        public Action parseChoices(NodeIterator nodeIterator) throws XSLException {
            Node node = nodeIterator.next();
            if (node == null) {
                return emptyAction;
            }
            Name name = node.getName();
            if (SheetImpl.this.XSL_WHEN.equals(name)) {
                return new IfAction(this.makeCondition(node), SheetImpl.this.parseActions(node, emptyAction), this.parseChoices(nodeIterator));
            }
            if (SheetImpl.this.XSL_OTHERWISE.equals(name)) {
                Node node2 = nodeIterator.next();
                if (node2 != null) {
                    throw new XSLException("unexpected element after otherwise", node2);
                }
                return SheetImpl.this.parseActions(node, emptyAction);
            }
            throw new XSLException("expected when or otherwise", node);
        }

        public Action parse(Node node) throws XSLException {
            return this.parseChoices(node.getChildren());
        }

        ChooseParser() {
            SheetImpl.this.getClass();
        }
    }

    private class CopyParser
    implements ActionParser {
        public Action parse(Node node) throws XSLException {
            return new CopyAction(SheetImpl.this.parseActions(node, emptyAction));
        }

        CopyParser() {
            SheetImpl.this.getClass();
        }
    }

    private class CopyOfParser
    implements ActionParser {
        public Action parse(Node node) throws XSLException {
            return new CopyOfAction(ExprParser.parseVariantExpr(node, SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.SELECT), SheetImpl.this.currentLocalVariables));
        }

        CopyOfParser() {
            SheetImpl.this.getClass();
        }
    }

    private class CommentParser
    implements ActionParser {
        public Action parse(Node node) throws XSLException {
            return new CommentAction(SheetImpl.this.parseActions(node, emptyAction));
        }

        CommentParser() {
            SheetImpl.this.getClass();
        }
    }

    private class ProcessingInstructionParser
    implements ActionParser {
        public Action parse(Node node) throws XSLException {
            return new ProcessingInstructionAction(ExprParser.parseAttributeValueTemplate(node, SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.NAME), SheetImpl.this.currentLocalVariables), SheetImpl.this.parseActions(node, emptyAction));
        }

        ProcessingInstructionParser() {
            SheetImpl.this.getClass();
        }
    }

    private class ElementParser
    implements ActionParser {
        public Action parse(Node node) throws XSLException {
            return new ElementAction(ExprParser.parseAttributeValueTemplate(node, SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.NAME), SheetImpl.this.currentLocalVariables), this.getNamespaceExpr(node), node.getNamespacePrefixMap(), SheetImpl.this.parseActions(node, emptyAction));
        }

        ElementParser() {
            SheetImpl.this.getClass();
        }

        StringExpr getNamespaceExpr(Node node) throws XSLException {
            String string = node.getAttributeValue(SheetImpl.this.NAMESPACE);
            if (string == null) {
                return null;
            }
            return ExprParser.parseAttributeValueTemplate(node, string, SheetImpl.this.currentLocalVariables);
        }
    }

    private class AttributeParser
    extends ElementParser {
        public Action parse(Node node) throws XSLException {
            return new AttributeAction(ExprParser.parseAttributeValueTemplate(node, SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.NAME), SheetImpl.this.currentLocalVariables), this.getNamespaceExpr(node), node.getNamespacePrefixMap(), SheetImpl.this.parseActions(node, emptyAction));
        }

        AttributeParser() {
            SheetImpl.this.getClass();
        }
    }

    private class ApplyImportsParser
    implements ActionParser {
        public Action parse(Node node) throws XSLException {
            return new ApplyImportsAction();
        }

        ApplyImportsParser() {
            SheetImpl.this.getClass();
        }
    }

    private class VariableActionParser
    implements ActionParser {
        public Action parse(Node node) throws XSLException {
            Name name = SheetImpl.expandSourceElementTypeName(SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.NAME), node);
            VariantExpr variantExpr = SheetImpl.this.getVariantExpr(node);
            SheetImpl.this.currentLocalVariables = new AddVariableSet(name, SheetImpl.this.currentLocalVariables);
            ++SheetImpl.this.nCurrentLocalVariables;
            return this.makeAction(name, variantExpr);
        }

        Action makeAction(Name name, VariantExpr variantExpr) {
            return new BindLocalVariableAction(name, variantExpr);
        }

        VariableActionParser() {
            SheetImpl.this.getClass();
        }
    }

    private class ParamActionParser
    extends VariableActionParser {
        Action makeAction(Name name, VariantExpr variantExpr) {
            return new BindLocalParamAction(name, variantExpr);
        }

        ParamActionParser() {
            SheetImpl.this.getClass();
        }
    }

    private class MessageParser
    implements ActionParser {
        public Action parse(Node node) throws XSLException {
            return new AppendAction();
        }

        MessageParser() {
            SheetImpl.this.getClass();
        }
    }

    private static interface ActionParser {
        public Action parse(Node var1) throws XSLException;
    }

    private static interface TopLevelParser {
        public void parse(Node var1) throws XSLException, IOException;
    }

    static final class VariableBindings {
        final VariableBindings next;
        final Variant value;
        final Name name;

        VariableBindings(Name name, Variant variant, VariableBindings variableBindings) {
            this.name = name;
            this.value = variant;
            this.next = variableBindings;
        }
    }
}

