/* BEGIN software license
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright (C) 2009--2020 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the msXpertSuite project.
 *
 * The msXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once

/////////////////////// StdLib includes
#include <vector>


/////////////////////// Qt includes


/////////////////////// pappsomspp includes
#include <pappsomspp/massspectrum/qualifiedmassspectrum.h>
#include <pappsomspp/processing/combiners/massspectrumpluscombiner.h>


/////////////////////// Local includes
#include "globals.hpp"
#include "../MsRunProber.hpp"

namespace msxps
{
namespace minexpert
{

class BrukerTimsTofMsRunProber;

typedef std::shared_ptr<BrukerTimsTofMsRunProber> BrukerTimsTofMsRunProberSPtr;

typedef std::vector<pappso::QualifiedMassSpectrumCstSPtr>
  QualifiedMassSpectraVector;

typedef std::shared_ptr<QualifiedMassSpectraVector>
  QualifiedMassSpectraVectorSPtr;

typedef std::shared_ptr<const QualifiedMassSpectraVector>
  QualifiedMassSpectraVectorCstSPtr;


class BrukerTimsTofMsRunProber : public MsRunProber
{
  Q_OBJECT

  public:
  BrukerTimsTofMsRunProber(pappso::MsFileAccessorSPtr ms_file_accessor_sp);

  virtual ~BrukerTimsTofMsRunProber();

  virtual MsRunProbeInfo probe() override;

  public slots:

  signals:

  protected:
  private:
};


} // namespace minexpert

} // namespace msxps


Q_DECLARE_METATYPE(msxps::minexpert::BrukerTimsTofMsRunProber)
extern int BrukerTimsTofMsRunProberMetaTypeId;

Q_DECLARE_METATYPE(msxps::minexpert::BrukerTimsTofMsRunProberSPtr)
extern int BrukerTimsTofMsRunProberSPtrMetaTypeId;
