# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class Selector(Object):
    r"""
    Selector - Computes the portion of a dataset which is inside a
    selection
    
    Superclass: Object
    
    This is an abstract superclass for types of selection operations.
    Subclasses generally only need to override `compute_selected_elements`.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkSelector, obj, update, **traits)
    
    insidedness_array_name = traits.String('', enter_set=True, auto_set=False, desc=\
        r"""
        Get/Set the name of the array to use for the insidedness array to
        add to the output in `Execute` call.
        """
    )

    def _insidedness_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInsidednessArrayName,
                        self.insidedness_array_name)

    def execute(self, *args):
        """
        execute(self, input:DataObject, output:DataObject) -> None
        C++: virtual void execute(DataObject *input,
            DataObject *output)
        Given an input and the SelectionNode passed into the
        Initialize() method, add to the output a SignedChar attribute
        array indicating whether each element is inside (1) or outside
        (0) the selection. The attribute (point data or cell data) is
        determined by the Selection that owns the SelectionNode set
        in Initialize(). The insidedness array is named with the value of
        insidedness_array_name. If input is a CompositeDataSet, the
        insidedness array is added to each block.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Execute, *my_args)
        return ret

    def finalize(self):
        """
        finalize(self) -> None
        C++: virtual void finalize()
        Does any cleanup of objects created in Initialize
        """
        ret = self._vtk_obj.Finalize()
        return ret
        

    def initialize(self, *args):
        """
        initialize(self, node:SelectionNode) -> None
        C++: virtual void initialize(SelectionNode *node)
        Sets the SelectionNode used by this selection operator and
        initializes the data structures in the selection operator based
        on the selection.
        
        (for example in the FrustumSelector this creates the Planes
        implicit function to represent the frustum).
        
        @param node The selection node that determines the behavior of
            this operator.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Initialize, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('insidedness_array_name',
    'GetInsidednessArrayName'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'insidedness_array_name',
    'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Selector, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Selector properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['insidedness_array_name', 'object_name']),
            title='Edit Selector properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Selector properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

