/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.ExplainVerbosity;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncConnectionSource;
import com.mongodb.binding.AsyncReadBinding;
import com.mongodb.binding.ConnectionSource;
import com.mongodb.binding.ReadBinding;
import com.mongodb.client.model.Collation;
import com.mongodb.connection.AsyncConnection;
import com.mongodb.connection.Connection;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.QueryResult;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.operation.AggregateExplainOperation;
import com.mongodb.operation.AsyncQueryBatchCursor;
import com.mongodb.operation.AsyncReadOperation;
import com.mongodb.operation.BatchCursor;
import com.mongodb.operation.BsonDocumentWrapperHelper;
import com.mongodb.operation.CommandOperationHelper;
import com.mongodb.operation.CommandResultDocumentCodec;
import com.mongodb.operation.OperationHelper;
import com.mongodb.operation.QueryBatchCursor;
import com.mongodb.operation.ReadOperation;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.codecs.Decoder;

public class AggregateOperation<T>
implements AsyncReadOperation<AsyncBatchCursor<T>>,
ReadOperation<BatchCursor<T>> {
    private static final String RESULT = "result";
    private static final String FIRST_BATCH = "firstBatch";
    private final MongoNamespace namespace;
    private final List<BsonDocument> pipeline;
    private final Decoder<T> decoder;
    private Boolean allowDiskUse;
    private Integer batchSize;
    private long maxTimeMS;
    private Boolean useCursor;
    private ReadConcern readConcern = ReadConcern.DEFAULT;
    private Collation collation;

    public AggregateOperation(MongoNamespace namespace, List<BsonDocument> pipeline, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.pipeline = Assertions.notNull("pipeline", pipeline);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public List<BsonDocument> getPipeline() {
        return this.pipeline;
    }

    public Boolean getAllowDiskUse() {
        return this.allowDiskUse;
    }

    public AggregateOperation<T> allowDiskUse(Boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public AggregateOperation<T> batchSize(Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public AggregateOperation<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public Boolean getUseCursor() {
        return this.useCursor;
    }

    public AggregateOperation<T> useCursor(Boolean useCursor) {
        this.useCursor = useCursor;
        return this;
    }

    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    public AggregateOperation<T> readConcern(ReadConcern readConcern) {
        this.readConcern = Assertions.notNull("readConcern", readConcern);
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public AggregateOperation<T> collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public BatchCursor<T> execute(final ReadBinding binding) {
        return (BatchCursor)OperationHelper.withConnection(binding, new OperationHelper.CallableWithConnectionAndSource<BatchCursor<T>>(){

            @Override
            public BatchCursor<T> call(ConnectionSource source, Connection connection) {
                OperationHelper.validateReadConcernAndCollation(connection, AggregateOperation.this.readConcern, AggregateOperation.this.collation);
                return (BatchCursor)CommandOperationHelper.executeWrappedCommandProtocol(binding, AggregateOperation.this.namespace.getDatabaseName(), AggregateOperation.this.getCommand(connection.getDescription()), CommandResultDocumentCodec.create(AggregateOperation.this.decoder, AggregateOperation.this.getFieldNameWithResults(connection.getDescription())), connection, AggregateOperation.this.transformer(source, connection));
            }
        });
    }

    @Override
    public void executeAsync(final AsyncReadBinding binding, final SingleResultCallback<AsyncBatchCursor<T>> callback) {
        OperationHelper.withConnection(binding, new OperationHelper.AsyncCallableWithConnectionAndSource(){

            @Override
            public void call(AsyncConnectionSource source, AsyncConnection connection, Throwable t) {
                SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else {
                    final SingleResultCallback wrappedCallback = OperationHelper.releasingCallback(errHandlingCallback, source, connection);
                    OperationHelper.validateReadConcernAndCollation(source, connection, AggregateOperation.this.readConcern, AggregateOperation.this.collation, new OperationHelper.AsyncCallableWithConnectionAndSource(){

                        @Override
                        public void call(AsyncConnectionSource source, AsyncConnection connection, Throwable t) {
                            if (t != null) {
                                wrappedCallback.onResult(null, t);
                            } else {
                                CommandOperationHelper.executeWrappedCommandProtocolAsync(binding, AggregateOperation.this.namespace.getDatabaseName(), AggregateOperation.this.getCommand(connection.getDescription()), CommandResultDocumentCodec.create(AggregateOperation.this.decoder, AggregateOperation.this.getFieldNameWithResults(connection.getDescription())), connection, AggregateOperation.this.asyncTransformer(source, connection), wrappedCallback);
                            }
                        }
                    });
                }
            }
        });
    }

    public ReadOperation<BsonDocument> asExplainableOperation(ExplainVerbosity explainVerbosity) {
        return new AggregateExplainOperation(this.namespace, this.pipeline).allowDiskUse(this.allowDiskUse).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public AsyncReadOperation<BsonDocument> asExplainableOperationAsync(ExplainVerbosity explainVerbosity) {
        return new AggregateExplainOperation(this.namespace, this.pipeline).allowDiskUse(this.allowDiskUse).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    private boolean isInline(ConnectionDescription description) {
        return this.useCursor != null && this.useCursor == false || !OperationHelper.serverIsAtLeastVersionTwoDotSix(description);
    }

    private BsonDocument getCommand(ConnectionDescription description) {
        BsonDocument commandDocument = new BsonDocument("aggregate", new BsonString(this.namespace.getCollectionName()));
        commandDocument.put("pipeline", new BsonArray(this.pipeline));
        if (this.maxTimeMS > 0L) {
            commandDocument.put("maxTimeMS", new BsonInt64(this.maxTimeMS));
        }
        if ((this.useCursor == null || this.useCursor.booleanValue()) && OperationHelper.serverIsAtLeastVersionTwoDotSix(description)) {
            BsonDocument cursor = new BsonDocument();
            if (this.batchSize != null) {
                cursor.put("batchSize", new BsonInt32(this.batchSize));
            }
            commandDocument.put("cursor", cursor);
        }
        if (this.allowDiskUse != null) {
            commandDocument.put("allowDiskUse", BsonBoolean.valueOf(this.allowDiskUse));
        }
        if (!this.readConcern.isServerDefault()) {
            commandDocument.put("readConcern", this.readConcern.asDocument());
        }
        if (this.collation != null) {
            commandDocument.put("collation", this.collation.asDocument());
        }
        return commandDocument;
    }

    String getFieldNameWithResults(ConnectionDescription description) {
        return (this.useCursor == null || this.useCursor != false) && OperationHelper.serverIsAtLeastVersionTwoDotSix(description) ? FIRST_BATCH : RESULT;
    }

    private QueryResult<T> createQueryResult(BsonDocument result, ConnectionDescription description) {
        if (this.isInline(description)) {
            return new QueryResult(this.namespace, BsonDocumentWrapperHelper.toList(result, RESULT), 0L, description.getServerAddress());
        }
        return OperationHelper.cursorDocumentToQueryResult(result.getDocument("cursor"), description.getServerAddress());
    }

    private CommandOperationHelper.CommandTransformer<BsonDocument, BatchCursor<T>> transformer(final ConnectionSource source, final Connection connection) {
        return new CommandOperationHelper.CommandTransformer<BsonDocument, BatchCursor<T>>(){

            @Override
            public BatchCursor<T> apply(BsonDocument result, ServerAddress serverAddress) {
                QueryResult queryResult = AggregateOperation.this.createQueryResult(result, connection.getDescription());
                return new QueryBatchCursor(queryResult, 0, AggregateOperation.this.batchSize != null ? AggregateOperation.this.batchSize : 0, AggregateOperation.this.decoder, source);
            }
        };
    }

    private CommandOperationHelper.CommandTransformer<BsonDocument, AsyncBatchCursor<T>> asyncTransformer(final AsyncConnectionSource source, final AsyncConnection connection) {
        return new CommandOperationHelper.CommandTransformer<BsonDocument, AsyncBatchCursor<T>>(){

            @Override
            public AsyncBatchCursor<T> apply(BsonDocument result, ServerAddress serverAddress) {
                QueryResult queryResult = AggregateOperation.this.createQueryResult(result, connection.getDescription());
                return new AsyncQueryBatchCursor(queryResult, 0, AggregateOperation.this.batchSize != null ? AggregateOperation.this.batchSize : 0, 0L, AggregateOperation.this.decoder, source, connection);
            }
        };
    }
}

