#line 2 "lex.c"
#line 2 "lex.l"
/* This file is part of Mailfromd.
   Copyright (C) 2005-2023 Sergey Poznyakoff

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>. */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif



#line 26 "lex.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

/* %not-for-header */

/* %if-c-only */
/* %if-not-reentrant */

/* %endif */
/* %endif */
/* %ok-for-header */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 0
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* %if-c++-only */
/* %endif */

/* %if-c-only */
    
/* %endif */

/* %if-c-only */

/* %endif */

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
/* %if-c-only */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
/* %endif */

/* %if-tables-serialization */
/* %endif */
/* end standard C headers. */

/* %if-c-or-c++ */
/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* %endif */

/* %if-c++-only */
/* %endif */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* %not-for-header */

/* Returned upon end-of-file. */
#define YY_NULL 0
/* %ok-for-header */

/* %not-for-header */

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)
/* %ok-for-header */

/* %if-reentrant */
/* %endif */

/* %if-not-reentrant */

/* %endif */

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart(yyin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

/* %if-not-reentrant */
extern yy_size_t yyleng;
/* %endif */

/* %if-c-only */
/* %if-not-reentrant */
extern FILE *yyin, *yyout;
/* %endif */
/* %endif */

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
/* %if-c-only */
	FILE *yy_input_file;
/* %endif */

/* %if-c++-only */
/* %endif */

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	yy_size_t yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* %if-c-only Standard (non-C++) definition */
/* %not-for-header */

/* %if-not-reentrant */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */
/* %endif */
/* %ok-for-header */

/* %endif */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* %if-c-only Standard (non-C++) definition */

/* %if-not-reentrant */
/* %not-for-header */

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static yy_size_t yy_n_chars;		/* number of characters read into yy_ch_buf */
yy_size_t yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;
/* %ok-for-header */

/* %endif */

void yyrestart (FILE *input_file  );
void yy_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer (FILE *file,int size  );
void yy_delete_buffer (YY_BUFFER_STATE b  );
void yy_flush_buffer (YY_BUFFER_STATE b  );
void yypush_buffer_state (YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state (void );

static void yyensure_buffer_stack (void );
static void yy_load_buffer_state (void );
static void yy_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER yy_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE yy_scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes (yyconst char *bytes,yy_size_t len  );

/* %endif */

void *yyalloc (yy_size_t  );
void *yyrealloc (void *,yy_size_t  );
void yyfree (void *  );

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* %% [1.0] yytext/yyin/yyout/yy_state_type/yylineno etc. def's & init go here */
/* Begin user sect3 */

#define FLEX_DEBUG

typedef unsigned char YY_CHAR;

FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;

typedef int yy_state_type;

extern int yylineno;

int yylineno = 1;

extern char *yytext;
#ifdef yytext_ptr
#undef yytext_ptr
#endif
#define yytext_ptr yytext

/* %% [1.5] DFA */

/* %if-c-only Standard (non-C++) definition */

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
#if defined(__GNUC__) && __GNUC__ >= 3
__attribute__((__noreturn__))
#endif
static void yy_fatal_error (yyconst char msg[]  );

/* %endif */

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
/* %% [2.0] code to fiddle yytext and yyleng for yymore() goes here \ */\
	yyleng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
/* %% [3.0] code to copy yytext_ptr to yytext[] goes here, if %array \ */\
	(yy_c_buf_p) = yy_cp;

/* %% [4.0] data tables for the DFA and the user's section 1 definitions go here */
#define YY_NUM_RULES 152
#define YY_END_OF_BUFFER 153
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[984] =
    {   0,
        0,    0,    2,    2,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  153,  151,
      135,  136,  151,  151,   16,  151,  151,  143,  151,  151,
      151,  103,  103,  139,  137,  141,  105,  151,  145,  105,
      105,  105,  105,  105,  105,  105,  105,  105,  105,  105,
      105,  105,  105,  105,  105,  105,  105,  144,  146,  135,
       16,    2,    4,    3,    2,    2,  152,  152,  117,  131,
      131,  152,  150,  133,  131,  131,  150,  152,  134,  152,
      150,  127,   20,   18,   19,   20,   17,  152,    8,  152,
      105,  105,  105,  135,   16,  135,  138,    0,  107,  109,

      109,   16,   15,   89,   91,   90,   92,   95,    0,    0,
        0,    0,  106,    0,    1,  102,    0,  103,  147,  140,
      137,  142,  148,  105,   99,  105,  105,  105,  105,  105,
      105,  105,  105,  105,  105,  105,  105,   34,  105,  105,
       30,  105,  105,  105,  105,   29,  105,  105,  105,  105,
      105,  105,  105,  105,   33,   41,  105,  105,  105,  105,
      105,  105,  105,  105,  105,  105,  105,  105,  105,  135,
        0,   16,   16,   16,   16,   16,   16,   16,    2,    3,
        3,    5,    2,    2,    2,    2,    0,  117,  118,  118,
       93,  130,   94,   97,    0,   87,   87,    0,  124,  116,

      124,  100,  124,    0,  133,  128,  132,    0,  134,  129,
        0,  127,   18,   17,    0,    8,    0,   82,  105,  105,
      135,    0,   16,  109,  115,  108,  115,  115,   90,   95,
        0,    0,    0,  149,  102,  101,    0,    0,    0,    0,
       99,  105,  105,  105,  105,  105,  105,  105,  105,  105,
       26,  105,   42,  105,   77,  105,  105,  105,  105,  105,
      105,  105,  105,  105,  105,  105,  105,   65,  105,  105,
      105,  105,  105,  105,    0,  105,   43,  105,  105,  105,
      105,  105,  105,  105,  105,  105,  104,   46,  105,  105,
      105,  105,  105,   48,  105,  105,  105,  105,    0,    0,

        0,    0,    0,    0,   16,   16,   16,   16,   16,   16,
       16,   16,    2,  116,   94,   97,    0,   87,   87,    0,
        0,  123,  122,  100,    0,    0,    7,  105,  105,    0,
      108,  114,  113,    0,    0,   96,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  101,    0,    0,    0,    0,
      125,    0,  105,  105,  105,  105,  105,  105,  105,  105,
      105,  105,  105,  105,  105,  105,  105,   54,  105,  105,
      105,  105,  105,  105,  105,   35,   49,   32,   31,  105,
       73,   52,  105,   63,  105,  105,    0,    0,    0,   44,
      105,   67,  105,   45,  105,  105,  105,  105,  105,  105,

      105,  105,  105,  105,  105,   58,   40,  105,    0,    0,
        0,    0,    0,    0,   16,    6,   16,   16,   16,   16,
       16,    2,    0,   98,   87,   87,   87,   87,   87,   87,
       87,   87,    0,   88,    0,  121,  122,  120,   81,   80,
      112,  113,  111,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  105,  105,  105,  105,  105,
      105,  105,  105,  105,  105,  105,  105,  105,  105,   68,
       66,   47,   61,  105,   78,  105,  105,  105,  105,  105,
      105,  105,    0,    0,  105,  105,  105,  105,  105,  105,

      105,  105,  105,  105,  105,   62,   69,   64,    0,    0,
        0,    0,    0,   16,   16,   16,   16,   16,   16,    2,
       87,   87,   87,   87,   87,   87,   87,   87,   87,   87,
       87,   87,    0,    0,    0,    0,    0,    0,    0,    0,
      122,  119,  113,  110,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  126,  105,  105,  105,  105,  105,  105,  105,  105,
      105,  105,  105,  105,  105,   21,  105,  105,   28,  105,
      105,   72,  105,   76,    0,    0,   60,  105,   75,   22,

      105,  105,   50,   74,   59,   53,  105,    0,    0,    0,
        0,    0,    0,   16,    9,   16,   16,   16,   16,   16,
        2,   87,   87,   87,   87,   87,   87,   87,   87,   87,
       87,   87,   87,   87,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  105,  105,   79,  105,  105,  105,  105,  105,
      105,  105,  105,  105,  105,   55,   25,  105,   36,    0,
        0,    0,   57,  105,   27,   71,   51,    0,   56,  105,

        0,    9,    0,    0,    0,    0,    0,   16,   16,   16,
       10,   16,    2,   10,    0,   87,   87,   87,   87,   87,
       87,   87,   87,   87,   87,   87,   87,   87,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,   83,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,   79,  105,  105,  105,
      105,  105,  105,  105,  105,  105,   24,  105,    0,    0,
       70,   23,    0,    0,    0,   16,   12,   16,   16,   87,
       87,   85,   87,   87,   87,   87,   87,   87,   87,   87,

       87,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,   83,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  105,  105,  105,  105,
      105,  105,   37,    0,    0,    0,   12,    0,    0,   16,
       16,   16,   11,   85,   87,   87,   87,   87,   87,   87,
       87,   87,   87,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,   84,    0,    0,    0,    0,    0,    0,
        0,    0,  105,  105,  105,  105,  105,    0,   38,    0,

        0,    0,   11,   16,   14,   16,   87,   87,   87,   87,
       87,   87,    0,    0,   86,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  105,  105,    0,    0,   14,    0,
       16,   87,   87,   87,   87,   87,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,   39,
        0,   16,   87,   87,    0,    0,    0,    0,    0,    0,
        0,    0,   16,    0,    0,    0,   16,    0,   16,   13,
        0,   13,    0
    } ;

static yyconst YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    4,    5,    6,    7,    8,    9,   10,   11,   12,
        1,   13,    1,    1,   14,   15,   16,   17,   18,   18,
       18,   18,   18,   18,   18,   19,   19,    1,    1,   20,
       21,   22,    1,   23,   24,   24,   24,   24,   24,   24,
       25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
       25,   25,   25,   25,   25,   25,   25,   26,   25,   25,
        1,   27,    1,   28,   29,    1,   30,   31,   32,   33,

       34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
       44,   45,   46,   47,   48,   49,   50,   51,   52,   53,
       54,   25,   55,   56,   57,   58,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst YY_CHAR yy_meta[59] =
    {   0,
        1,    1,    2,    1,    1,    1,    3,    4,    5,    1,
        6,    7,    8,    9,    1,    1,   10,   11,   11,    1,
        1,    1,    7,   12,   13,   13,   14,    1,   13,   12,
       12,   12,   12,   12,   12,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   15,    1,   16,    1
    } ;

static yyconst flex_uint16_t yy_base[1043] =
    {   0,
        0,   57,   57,   64,   66,   70,   77,   79,   81,   91,
     2204, 2203,  118,    0, 2202,   60,   65,  175, 2204, 2208,
       94, 2208, 2182,  172, 2199,  177,   54, 2208, 2190, 2185,
     2186,  168,   94,   71, 2177,   93,    0,   98, 2208, 2168,
      160,  136,  158,  172,  166,  175,  173, 2152,  184,  183,
       58,  179, 2161,  189,  197,  167, 2157, 2208, 2208,  238,
      244,    0, 2208,  223,  248,  249,  248, 2208, 2208,  251,
      252,  269,  257, 2184,  284,  264,  277,  271, 2208,  282,
     2189, 2208, 2208,  306, 2208, 2178,    0, 2187, 2208,  100,
      272, 2145,  267,  314,  338,  321, 2208,  318, 2208, 2208,

      329, 2185, 2208, 2208, 2208,  319, 2208,    0,    0, 2158,
     2157, 2174, 2208, 2169, 2208,  250,    0,  330,  317, 2208,
     2208, 2208, 2208,    0,  333,  326, 2151, 2149, 2143, 2147,
     2145, 2144,  228, 2134, 2135,  189, 2127, 2131, 2136,  315,
        0, 2130, 2124, 2126, 2126,    0, 2123, 2123, 2117, 2132,
      356, 2111, 2114, 2120,    0,    0, 2113,  320, 2129,  339,
      332,  282, 2121, 2116, 2110, 2102, 2110, 2116,  332,  385,
      389,  433,  393,  396,  370,  240,  331,  372,    0,  388,
      389, 2208,  414,  408,  418, 2115,  420, 2208, 2208, 2149,
     2208, 2208,  414,    0,    0,    0, 2122, 2121,  416,  430,

      436,  423,  452,  461, 2140, 2208, 2208,  472, 2208, 2208,
     2145, 2208,  444,    0, 2144, 2208,  480,    0, 2098, 2104,
      483,  487,  490, 2141,  468,  488,  493,  495,  495,    0,
     2086,  498, 2113, 2208,  362,    0,    0,  515,  549,  597,
      499, 2107,  356, 2102, 2101,  428,  356, 2089, 2103, 2102,
        0, 2105,    0, 2104,    0, 2099, 2100,  407, 2097, 2100,
     2095, 2096, 2093, 2082, 2090, 2090, 2093,    0, 2080, 2089,
     2076, 2074, 2086, 2067,  608, 2067,    0, 2084, 2066, 2081,
     2076, 2070, 2076, 2068, 2058, 2057,    0,    0, 2057, 2067,
     2055, 2058, 2058,    0, 2052, 2067, 2056, 2057,  611,  614,

     2050, 2053, 2057, 2047,  470, 2090,  617,  623,  497,  232,
      352,  606, 2049, 2208,  519,    0, 2034,    0,  618, 2033,
      605, 2208,  630,  653,    0,  671, 2208, 2040, 2047,  663,
     2208, 2208,  668,    0, 2030, 2208, 2052,  412, 2047, 2046,
      584,  500, 2034, 2048,  658,    0, 2070,  669, 2077,  685,
     2208,    0, 2044, 2037, 2034, 2027, 2032, 2035, 2030, 2039,
      612, 2037, 2040, 2022, 2023, 2019, 2026,    0, 2028, 2015,
     2025, 2009, 2011, 2011, 2029,    0,    0,    0,    0, 2009,
        0,    0, 2010,    0, 2019, 2014,  688, 2011, 2023,    0,
     2018,    0, 2013,    0, 2012, 2017, 2018, 2009, 1999, 2007,

     2001, 2011, 2007, 1989, 1993,    0,    0, 2005,  708,  700,
     1991, 2005, 1993, 2005, 2031, 2208,  462,  504,  268,  634,
      643, 1999, 1975, 2208, 1997,  675, 1992, 1991,  677,  675,
     1979, 1993, 1969, 2208,  698, 2208,  718,  720,    0,    0,
     2208,  733,  729, 1990, 1983, 1980, 1973, 1978, 1981, 1976,
     1985,  712, 1983, 1986, 1968, 1980,  682, 1975, 1974,  724,
      718, 1962, 1976,  755, 1998,  610, 1974, 1975, 1977, 1971,
     1960, 1959, 1952, 1961, 1968, 1954, 1949, 1949, 1947,    0,
        0,    0,    0, 1952,    0, 1953, 1959, 1945, 1959, 1941,
     1955, 1954, 1945, 1937, 1938, 1940, 1951, 1933, 1949, 1933,

     1936, 1946, 1941, 1939, 1945,    0,    0,    0, 1968, 1929,
     1931, 1937, 1934,  760,  761,  749,  495,  767,  750,  770,
     1934, 1927, 1924, 1917, 1922, 1925, 1920, 1929,  741, 1927,
     1930, 1912,  741,  738,  740,  742,  747,  753,  667,  745,
      778, 2208,  785, 2208,  736, 1924, 1925, 1927, 1921, 1910,
     1909, 1902, 1911, 1918, 1904, 1899, 1899, 1911, 1904, 1901,
     1894, 1899, 1902, 1897, 1906,  757, 1904, 1907, 1889, 1932,
      805, 2208, 1887, 1904, 1883, 1902, 1901, 1882, 1881, 1886,
     1896, 1888, 1877, 1889, 1884,    0, 1871, 1871,    0, 1886,
     1881,    0, 1869,    0, 1886, 1883,  799, 1864,    0,    0,

     1879, 1878, 1863,    0,  811,    0, 1872, 1903,  811, 1861,
     1857,  814, 1864,  816, 2208,  818,  823,  817, 1902,  681,
      825,  784, 1870, 1871, 1873, 1867, 1856, 1855, 1848, 1857,
     1864, 1850, 1845, 1845,  795,  790,  484,  784,  621,  578,
      791,  802,  804,  803,  809,  797, 1845, 1862, 1841, 1860,
     1859, 1840, 1839, 1844, 1854, 1846, 1835, 1847, 1842,  795,
     1845, 1846, 1848, 1842, 1831, 1830, 1823, 1832, 1839, 1825,
     1820, 1820, 1838, 1828,    0, 1836, 1835, 1834, 1828, 1825,
     1831, 1815, 1825, 1813, 1822,    0,    0, 1821,    0, 1805,
     1816,  853, 2208, 1804,    0,    0,    0,  860, 2208, 1810,

      839, 2208,  843,  854, 1817, 1846, 1818, 1844,  848, 1843,
     2208,  865,  860, 2208, 1842, 1797, 1814, 1793, 1812, 1811,
     1792, 1791, 1796, 1806, 1798, 1787, 1799, 1794,  826,  836,
      843,  847,  844,  833,  835,  830,  841,  852,  840,  837,
      848, 1802, 1792, 2208, 1800, 1799, 1798, 1792, 1789, 1795,
     1779, 1789, 1777, 1773, 1790, 1769, 1788, 1787, 1768, 1767,
     1772, 1782, 1774, 1763, 1775, 1770,    0, 1763, 1777, 1776,
     1775, 1769, 1773, 1769, 1762, 1756,    0, 1750, 1765, 1762,
        0,    0, 1792, 1760,  887, 1790, 2208,  904, 1789, 1762,
     1752,    0, 1760, 1759, 1758, 1752, 1749, 1755, 1739, 1749,

     1737,  855,  859,  846,  870,  881,  864,  866,  873,  885,
      880,  871,  886,  884, 2208, 1736, 1750, 1749, 1748, 1742,
     1746, 1742, 1735, 1729, 1742, 1732, 1712, 1739, 1738, 1515,
     1456, 1453, 1459, 1435, 1445, 1428, 1428, 1417, 1416, 1410,
     1388, 1405,    0, 1396, 1384, 1425, 2208,  922, 1421, 1420,
      916, 1419, 2208,    0, 1377, 1378, 1377, 1375, 1369, 1360,
     1261, 1252, 1246,  896,  891, 1231,  902,  905,  906,  898,
      354,  907,  895,  911,  901, 1244, 1257, 1256, 1253, 1231,
     1248, 1219, 1231, 2208, 1245, 1244, 1227, 1206, 1201, 1192,
     1166, 1158, 1168, 1167, 1166, 1164, 1163, 1157, 2208, 1156,

     1016, 1056, 2208, 1055, 2208,  937, 1014, 1027, 1019,   33,
      140,  304,  466,  910, 2208,  917,  918,  920,  916,  927,
      925,  928,  922,  669,  753,  932,  940,  941,  928,  943,
      947,  949,  934,  954,  957,  958,  940,  986, 2208,  947,
      988,  963,  964,  965,  966,  967,  954,  969,  970,  971,
      955,  972,  974,  975,  976,  977,  978,  979,  980, 2208,
      978, 1010,  985,  986,  988,  989,  990,  992,  993,  987,
      994,  990, 1028,  996, 1004, 1032, 1032, 1034, 1035, 2208,
     1036, 2208, 2208, 1061, 1077, 1093, 1109, 1125, 1141, 1157,
     1173, 1187, 1202, 1209, 1222, 1238, 1254, 1268, 1279, 1294,

     1310, 1326, 1342, 1349, 1362, 1378, 1385, 1028, 1389, 1396,
     1401, 1030, 1405, 1039, 1415, 1426, 1431, 1438, 1042, 1450,
     1457, 1464, 1471, 1474, 1481, 1494, 1510, 1526, 1542, 1558,
     1574, 1590, 1606, 1622, 1638, 1654, 1670, 1686, 1702, 1718,
     1734, 1750
    } ;

static yyconst flex_int16_t yy_def[1043] =
    {   0,
      983,    1,  984,  984,  985,  985,  986,  986,  987,  987,
      988,  988,  983,   13,  989,  989,    1,    1,  983,  983,
      983,  983,  983,  990,  991,  992,  983,  983,  993,  983,
      983,  983,  983,  983,  983,  983,  994,  983,  983,  994,
      994,  994,  994,  994,  994,  994,  994,  994,  994,  994,
      994,  994,  994,  994,  994,  994,  994,  983,  983,  983,
      991,  995,  983,  996,  995,  995,  997,  983,  983,  998,
      999, 1000, 1001,  983,  998,  999, 1000, 1002,  983, 1000,
     1003,  983,  983,  983,  983,  983, 1004, 1005,  983, 1005,
      994,  994,  994,  983,  991,  983,  983,  990,  983,  983,

     1006,  991,  983,  983,  983,  983,  983, 1007, 1008,  983,
      983,  993,  983,  983,  983,  983, 1009,  983, 1010,  983,
      983,  983,  983,  994,  983,  994,  994,  994,  994,  994,
      994,  994,  994,  994,  994,  994,  994,  994,  994,  994,
      994,  994,  994,  994,  994,  994,  994,  994,  994,  994,
      994,  994,  994,  994,  994,  994,  994,  994,  994,  994,
      994,  994,  994,  994,  994,  994,  994,  994,  994,  983,
      983,  991,  991,  991,  991,  991,  991,  991,  995,  996,
      996,  983,  995,  995,  995,  995,  997,  983,  983,  983,
      983,  983,  983, 1011, 1012, 1013, 1013, 1014,  983,  983,

      983,  983, 1015, 1001,  983,  983,  983, 1002,  983,  983,
     1003,  983,  983, 1004, 1005,  983, 1005,  994,  994,  994,
      983,  983,  991,  983,  983,  983,  983, 1016,  983, 1007,
     1017,  983,  983,  983,  983, 1018, 1019, 1010,  983, 1010,
      983,  994,  994,  994,  994,  994,  994,  994,  994,  994,
      994,  994,  994,  994,  994,  994,  994,  994,  994,  994,
      994,  994,  994,  994,  994,  994,  994,  994,  994,  994,
      994,  994,  994,  994,  983,  994,  994,  994,  994,  994,
      994,  994,  994,  994,  994,  994,  994,  994,  994,  994,
      994,  994,  994,  994,  994,  994,  994,  994,  983,  983,

      983,  983,  983,  983,  991, 1020,  991,  991,  991,  991,
      991,  991,  995,  983,  983, 1011, 1021, 1013, 1013, 1022,
     1022,  983,  983,  983, 1023, 1005,  983,  994,  994,  983,
      983,  983,  983, 1024, 1017,  983,  983,  983,  983,  983,
      983,  983,  983,  983,  983, 1018, 1025, 1010, 1026, 1026,
      983,  239,  994,  994,  994,  994,  994,  994,  994,  994,
      994,  994,  994,  994,  994,  994,  994,  994,  994,  994,
      994,  994,  994,  994,  994,  994,  994,  994,  994,  994,
      994,  994,  994,  994,  994,  994,  983,  983,  983,  994,
      994,  994,  994,  994,  994,  994,  994,  994,  994,  994,

      994,  994,  994,  994,  994,  994,  994,  994,  983,  983,
      983,  983,  983,  983, 1020,  983, 1027,  991,  991,  991,
      991,  995, 1021,  983, 1013, 1013, 1013, 1013, 1013, 1013,
     1013, 1013, 1022,  983, 1022,  983,  983,  983,  994,  994,
      983,  983,  983,  983,  983,  983,  983,  983,  983,  983,
      983,  983,  983,  983,  983,  983,  983,  983,  983,  983,
      983,  983,  983, 1028, 1025,  994,  994,  994,  994,  994,
      994,  994,  994,  994,  994,  994,  994,  994,  994,  994,
      994,  994,  994,  994,  994,  994,  994,  994,  994,  994,
      994,  994,  983,  983,  994,  994,  994,  994,  994,  994,

      994,  994,  994,  994,  994,  994,  994,  994, 1029,  983,
      983,  983,  983, 1027, 1030,  991,  991,  991,  991,  995,
     1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013,
     1013, 1013, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
      983,  983,  983,  983,  983,  983,  983,  983,  983,  983,
      983,  983,  983,  983,  983,  983,  983,  983,  983,  983,
      983,  983,  983,  983,  983,  983,  983,  983,  983, 1028,
     1028,  983,  994,  994,  994,  994,  994,  994,  994,  994,
      994,  994,  994,  994,  994,  994,  994,  994,  994,  994,
      994,  994,  994,  994,  983,  983,  994,  994,  994,  994,

      994,  994,  994,  994,  994,  994,  994, 1029, 1031,  983,
      983,  983,  983, 1030,  983, 1030,  991,  991, 1032,  991,
     1033, 1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013,
     1013, 1013, 1013, 1013, 1022, 1022, 1022, 1022, 1022, 1022,
     1022, 1022, 1022, 1022, 1022, 1022,  983,  983,  983,  983,
      983,  983,  983,  983,  983,  983,  983,  983,  983,  983,
      983,  983,  983,  983,  983,  983,  983,  983,  983,  983,
      983,  983,  994,  994,  994,  994,  994,  994,  994,  994,
      994,  994,  994,  994,  994,  994,  994,  994,  994,  983,
      983,  983,  983,  994,  994,  994,  994,  983,  983,  994,

     1031,  983, 1031,  983,  983, 1034,  983, 1035,  991, 1032,
      983,  991, 1033,  983, 1034, 1013, 1013, 1013, 1013, 1013,
     1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013, 1022, 1022,
     1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
     1022,  983,  983,  983,  983,  983,  983,  983,  983,  983,
      983,  983,  983,  983,  983,  983,  983,  983,  983,  983,
      983,  983,  983,  983,  983,  983,  994,  994,  994,  994,
      994,  994,  994,  994,  994,  994,  994,  994,  983,  983,
      994,  994, 1036,  983,  983, 1035,  983,  991, 1037, 1013,
     1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013,

     1013, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
     1022, 1022, 1022, 1022,  983,  983,  983,  983,  983,  983,
      983,  983,  983,  983,  983,  983,  983,  983,  983,  983,
      983,  983,  983,  983,  983,  983,  994,  994,  994,  994,
      994,  994,  994,  983,  983, 1036,  983,  983, 1038, 1039,
      991, 1037,  983, 1013, 1013, 1013, 1013, 1013, 1013, 1013,
     1013, 1013, 1013, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
     1022, 1022, 1022, 1022, 1022,  983,  983,  983,  983,  983,
      983,  983,  983,  983,  983,  983,  983,  983,  983,  983,
      983,  983,  994,  994,  994,  994,  994,  983,  983, 1040,

      983, 1038,  983, 1039,  983,  991, 1013, 1013, 1013, 1013,
     1013, 1013, 1022, 1022,  983, 1022, 1022, 1022, 1022, 1022,
     1022, 1022, 1022,  983,  983,  983,  983,  983,  983,  983,
      983,  983,  983,  983,  994,  994,  983, 1040,  983,  983,
      991, 1013, 1013, 1013, 1013, 1013, 1022, 1022, 1022, 1022,
     1022, 1022,  983,  983,  983,  983,  983,  983,  983,  983,
      983,  991, 1013, 1013, 1022, 1022, 1022, 1022, 1022,  983,
      983,  983,  991, 1022, 1022,  983, 1041, 1042, 1041,  983,
     1042,  983,    0,  983,  983,  983,  983,  983,  983,  983,
      983,  983,  983,  983,  983,  983,  983,  983,  983,  983,

      983,  983,  983,  983,  983,  983,  983,  983,  983,  983,
      983,  983,  983,  983,  983,  983,  983,  983,  983,  983,
      983,  983,  983,  983,  983,  983,  983,  983,  983,  983,
      983,  983,  983,  983,  983,  983,  983,  983,  983,  983,
      983,  983
    } ;

static yyconst flex_uint16_t yy_nxt[2267] =
    {   0,
       20,   21,   22,   21,   23,   24,   25,   26,   27,   28,
       29,   20,   20,   20,   30,   31,   32,   33,   33,   34,
       35,   36,   20,   37,   37,   37,   38,   39,   40,   41,
       42,   43,   44,   45,   46,   37,   37,   47,   37,   37,
       48,   49,   50,   51,   52,   37,   53,   54,   55,   37,
       56,   57,   37,   37,   20,   58,   20,   59,   60,   63,
       60,  944,   89,   61,   90,   65,   63,   65,   68,   64,
       66,   69,   68,   70,   71,   69,   64,   70,   71,   74,
       20,   74,  110,   79,   75,   76,   75,   76,   70,   71,
      119,  120,   72,   79,   91,   96,   72,   96,   70,   71,

      155,   92,  216,   77,  156,   77,  217,   80,  111,   93,
      118,  118,  118,  122,  123,  125,  125,   80,   83,   84,
       85,   84,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   86,   83,   83,   83,   83,   83,   83,
       83,   87,   87,   87,   83,   83,   87,   87,   87,   87,
       87,   87,   87,   87,   87,   87,   87,   87,   87,   87,
       87,   87,   87,   87,   87,   87,   87,   87,   87,   87,
       87,   87,   83,   83,   83,   83,   94,   99,   94,  100,
      100,   95,  131,  104,  116,  116,  945,  133,  105,  132,
       20,  127,  128,  117,  106,  106,  167,  139,  101,  107,

      129,  134,  130,  135,   91,  136,  140,  146,  157,  137,
      168,   92,  141,  149,  147,  138,  152,  142,  143,   93,
      117,  144,  161,  260,  145,  158,  153,  150,  159,  261,
      164,  109,  154,  165,  103,  181,  151,  162,  182,  170,
      163,  170,  103,  166,  171,  172,  103,  172,  173,  183,
      185,  183,  185,  188,  184,  189,  189,  191,  192,  205,
      192,  174,  174,  419,  206,  206,  235,  235,  193,  193,
      103,  200,  983,  209,  190,  256,  257,  175,  210,  210,
      197,  176,  310,  206,  177,  201,  202,  202,  178,  186,
      191,  983,  197,  201,  202,  202,  157,  210,  201,  202,

      202,  193,  193,  127,  128,  195,  198,  213,  517,  213,
      220,  289,  129,  158,  130,  221,  159,  221,  198,  218,
      222,  203,   96,   99,   96,  100,  100,  237,  290,  203,
      238,  226,  946,  103,  203,  229,  229,  229,  195,  223,
      103,  223,  173,  240,  224,  227,  118,  118,  118,  241,
      241,  241,  265,  280,  103,  174,  174,  275,  242,  275,
      243,  244,  266,  281,  287,  297,  245,  246,  311,  298,
      247,  175,  103,  248,  103,  176,  249,  283,  235,  235,
      288,  228,  178,  284,  285,  361,  170,  286,  170,  919,
      299,  171,  299,  354,  420,  103,  305,  307,  103,  307,

      983,  181,  362,  983,  182,  355,  300,  300,  306,  185,
      434,  185,  308,  308,  308,  183,  309,  183,  312,  185,
      184,  185,  301,  322,  322,  188,  302,  189,  189,  303,
      315,  315,  315,  304,  172,  103,  172,  322,  322,  324,
      324,  324,  322,  322,  322,  213,  190,  213,  186,  445,
      174,  174,  323,  323,  370,  371,  322,  358,  186,  322,
      322,  446,  322,  205,  103,  359,  175,  515,  206,  206,
      176,  360,  103,  177,  209,  332,  332,  178,  322,  210,
      210,  326,  327,  326,  221,  306,  221,  206,  330,  222,
      330,  223,  103,  223,  332,  332,  332,  103,  210,  103,

      332,  332,  332,  332,  300,  300,  103,  174,  174,  333,
      333,  229,  229,  229,  332,  241,  241,  241,  348,  332,
      301,  332,  915,  175,  302,  237,  731,  176,  983,  452,
      337,  304,  338,  339,  178,  315,  315,  315,  340,  341,
      434,  240,  342,  418,  618,  343,  453,  516,  344,  349,
      350,  351,  350,  349,  349,  349,  349,  349,  349,  349,
      349,  349,  349,  349,  349,  352,  352,  352,  349,  349,
      349,  349,  352,  352,  352,  349,  349,  352,  352,  352,
      352,  352,  352,  352,  352,  352,  352,  352,  352,  352,
      352,  352,  352,  352,  352,  352,  352,  352,  352,  352,

      352,  352,  352,  349,  349,  349,  349,  983,  103,  387,
      983,  387,  299,  449,  299,  409,  734,  409,  307,  103,
      307,  450,  417,  983,  307,  103,  307,  451,  300,  300,
      410,  410,  410,  435,  434,  421,  103,  436,  436,  308,
      308,  308,  388,  474,  301,  103,  437,  437,  302,  389,
      425,  303,  426,  427,  573,  304,  436,  248,  428,  429,
      475,  434,  430,  733,  330,  431,  330,  518,  432,  324,
      324,  324,  326,  327,  326,  441,  441,  434,  519,  237,
      300,  300,  983,  103,  442,  442,  350,  351,  350,  387,
      456,  387,  457,  458,  441,  240,  301,  953,  459,  460,

      302,  409,  461,  409,  529,  462,  526,  304,  463,  409,
      712,  409,  522,  509,  527,  645,  410,  410,  410,  559,
      528,  530,  388,  434,  523,  436,  436,  542,  542,  389,
      533,  560,  534,  535,  541,  541,  544,  544,  536,  537,
      441,  441,  538,  553,  436,  539,  542,  566,  540,  543,
      543,  103,  103,  563,  434,  544,  571,  572,  571,  441,
      554,  564,  103,  615,  567,  515,  616,  565,  619,  103,
      619,  621,  630,  621,  635,  636,  640,  638,  646,  639,
      647,  744,  643,  343,  641,  436,  436,  637,  668,  631,
      642,  620,  441,  441,  434,  617,  434,  434,  434,  644,

      692,  434,  692,  434,  436,  669,  571,  572,  571,  434,
      693,  441,  698,  702,  698,  706,  703,  706,  615,  103,
      615,  616,  699,  616,  708,  103,  708,  714,  716,  729,
      730,  431,  732,  735,  736,  737,  739,  715,  740,  754,
      434,  702,  462,  741,  703,  702,  434,  434,  703,  709,
      103,  434,  738,  434,  692,  783,  692,  783,  434,  434,
      434,  698,  714,  698,  693,  434,  789,  103,  789,  803,
      802,  699,  715,  539,  804,  805,  807,  806,  808,  809,
      810,  788,  434,  811,  812,  813,  434,  864,  849,  434,
      849,  434,  434,  434,  865,  814,  434,  434,  866,  434,

      434,  644,  434,  434,  434,  850,  103,  850,  434,  867,
      868,  434,  869,  870,  871,  434,  872,  873,  103,  874,
      434,  875,  434,  900,  913,  900,  434,  434,  914,  434,
      913,  918,  851,  916,  917,  920,  434,  434,  921,  103,
      434,  434,  434,  922,  923,  866,  866,  434,  948,  949,
      901,  434,  434,  947,  434,  866,  950,  434,  434,  906,
      815,  434,  434,  434,  952,  951,  434,  434,  954,  744,
      955,  882,  434,  434,  434,  956,  434,  957,  434,  941,
      958,  434,  959,  434,  434,  767,  767,  960,  939,  961,
      103,  963,  792,  854,  964,  792,  965,  913,  966,  967,

      969,  968,  815,  815,  970,  827,  882,  971,  827,  972,
      434,  434,  103,  854,  854,  882,  974,  866,  913,  962,
      975,  866,  882,  976,  913,  434,  434,  434,  434,  977,
      103,  977,  913,  978,  980,  978,  982,  980,  982,  231,
      231,  317,  317,  973,  434,  434,  434,  943,  434,  434,
      320,  320,  434,  347,  347,  854,  942,  905,  903,  940,
      434,   62,   62,   62,   62,   62,   62,   62,   62,   62,
       62,   62,   62,   62,   62,   62,   62,   67,   67,   67,
       67,   67,   67,   67,   67,   67,   67,   67,   67,   67,
       67,   67,   67,   73,   73,   73,   73,   73,   73,   73,

       73,   73,   73,   73,   73,   73,   73,   73,   73,   78,
       78,   78,   78,   78,   78,   78,   78,   78,   78,   78,
       78,   78,   78,   78,   78,   81,   81,   81,   81,   81,
       81,   81,   81,   81,   81,   81,   81,   81,   81,   81,
       81,   88,   88,   88,   88,   88,   88,   88,   88,   88,
       88,   88,   88,   88,   88,   88,   88,   98,  939,   98,
       98,   98,   98,   98,   98,   98,   98,   98,   98,   98,
       98,   98,   98,  102,  102,  102,  102,  102,  102,  102,
      102,  102,  102,  102,  102,  102,  102,  102,  102,  108,
      937,  675,  936,  108,  767,  675,  935,  108,  108,  108,

      934,  108,  112,  933,  112,  112,  112,  112,  112,  112,
      112,  112,  112,  112,  112,  112,  112,  112,  124,  124,
      124,  124,  179,  932,  179,  179,  179,  179,  179,  827,
      179,  179,  179,  179,  179,  179,  179,  179,  180,  931,
      180,  180,  180,  180,  180,  180,  180,  180,  180,  180,
      180,  180,  180,  180,  187,  930,  187,  187,  187,  187,
      187,  187,  187,  187,  187,  187,  187,  187,  187,  187,
      194,  194,  827,  827,  929,  884,  928,  927,  194,  194,
      194,  926,  194,  196,  925,  815,  924,  915,  912,  911,
      196,  196,  910,  196,  199,  199,  199,  199,  199,  199,

      199,  199,  199,  199,  199,  199,  199,  199,  199,  199,
      204,  204,  204,  204,  204,  204,  204,  204,  204,  204,
      204,  204,  204,  204,  204,  204,  208,  208,  208,  208,
      208,  208,  208,  208,  208,  208,  208,  208,  208,  208,
      208,  208,  211,  211,  211,  211,  211,  211,  211,  211,
      211,  211,  211,  211,  211,  211,  211,  211,  214,  214,
      214,  214,  215,  215,  215,  215,  215,  215,  215,  215,
      215,  215,  215,  215,  215,  215,  215,  215,  225,  225,
      225,  225,  225,  225,  225,  225,  225,  225,  792,  225,
      225,  225,  225,  225,  230,  230,  230,  230,  236,  236,

      236,  239,  909,  908,  239,  792,  792,  239,  239,  239,
      316,  316,  316,  316,  318,  318,  318,  318,  325,  325,
      907,  853,  905,  903,  325,  325,  325,  847,  325,  334,
      334,  899,  898,  897,  896,  334,  334,  334,  895,  334,
      335,  335,  335,  335,  894,  767,  335,  346,  346,  346,
      415,  415,  415,  415,  415,  415,  415,  415,  415,  415,
      415,  415,  415,  415,  415,  415,  423,  423,  423,  423,
      893,  892,  423,  433,  433,  433,  433,  891,  890,  433,
      438,  438,  438,  443,  443,  443,  465,  889,  888,  887,
      465,  465,  465,  465,  349,  349,  349,  349,  349,  349,

      349,  349,  349,  349,  349,  349,  349,  349,  349,  349,
      514,  514,  514,  514,  514,  514,  514,  514,  514,  514,
      514,  514,  514,  514,  514,  514,  570,  570,  570,  570,
      570,  570,  570,  570,  570,  570,  570,  570,  570,  570,
      570,  570,  608,  886,  608,  608,  608,  608,  608,  608,
      608,  608,  608,  608,  608,  608,  608,  608,  614,  614,
      614,  614,  614,  614,  614,  614,  614,  614,  614,  614,
      614,  614,  614,  614,  701,  701,  701,  701,  701,  701,
      701,  701,  701,  701,  701,  701,  701,  701,  701,  701,
      710,  710,  710,  710,  710,  710,  710,  710,  710,  710,

      710,  710,  710,  710,  710,  710,  713,  713,  713,  713,
      713,  713,  713,  713,  713,  713,  713,  713,  713,  713,
      713,  713,  715,  715,  715,  715,  715,  715,  715,  715,
      715,  715,  715,  715,  715,  715,  715,  715,  786,  786,
      786,  786,  786,  786,  786,  786,  786,  786,  786,  786,
      786,  786,  786,  786,  846,  846,  846,  846,  846,  846,
      846,  846,  846,  846,  846,  846,  846,  846,  846,  846,
      852,  852,  852,  852,  852,  852,  852,  852,  852,  852,
      852,  852,  852,  852,  852,  852,  902,  902,  902,  902,
      902,  902,  902,  902,  902,  902,  902,  902,  902,  902,

      902,  902,  904,  904,  904,  904,  904,  904,  904,  904,
      904,  904,  904,  904,  904,  904,  904,  904,  938,  938,
      938,  938,  938,  938,  938,  938,  938,  938,  938,  938,
      938,  938,  938,  938,  979,  979,  979,  979,  979,  979,
      979,  979,  979,  979,  979,  979,  979,  979,  979,  979,
      981,  981,  981,  981,  981,  981,  981,  981,  981,  981,
      981,  981,  981,  981,  981,  981,  885,  882,  884,  883,
      882,  881,  880,  879,  744,  878,  877,  744,  744,  876,
      863,  862,  861,  860,  859,  858,  857,  856,  854,  855,
      854,  853,  787,  848,  847,  845,  844,  843,  842,  841,

      840,  675,  839,  838,  675,  675,  837,  836,  835,  834,
      833,  832,  831,  830,  829,  828,  827,  826,  825,  567,
      824,  823,  822,  821,  820,  819,  818,  817,  815,  816,
      815,  801,  800,  799,  798,  797,  796,  795,  794,  793,
      792,  791,  790,  530,  714,  711,  787,  785,  714,  784,
      782,  781,  780,  779,  778,  777,  776,  775,  774,  773,
      772,  771,  770,  769,  767,  768,  767,  766,  765,  764,
      763,  762,  761,  760,  759,  758,  757,  756,  755,  753,
      752,  751,  750,  749,  748,  747,  746,  745,  744,  743,
      742,  453,  728,  727,  726,  725,  724,  723,  722,  721,

      720,  719,  718,  717,  711,  707,  705,  704,  609,  700,
      697,  696,  695,  694,  691,  690,  689,  688,  687,  686,
      685,  684,  683,  682,  681,  680,  679,  678,  677,  676,
      675,  674,  673,  362,  572,  672,  671,  670,  667,  666,
      665,  664,  663,  662,  661,  660,  659,  658,  657,  656,
      655,  654,  653,  652,  651,  650,  649,  648,  634,  633,
      632,  629,  628,  627,  626,  625,  624,  623,  622,  613,
      612,  611,  610,  609,  607,  606,  605,  604,  603,  602,
      601,  600,  599,  598,  597,  596,  595,  594,  593,  592,
      591,  590,  589,  588,  587,  586,  585,  584,  583,  582,

      581,  580,  579,  578,  577,  576,  575,  574,  464,  569,
      568,  562,  561,  558,  557,  556,  555,  552,  551,  550,
      549,  548,  547,  546,  545,  434,  532,  531,  525,  524,
      521,  424,  520,  416,  513,  512,  511,  510,  508,  507,
      506,  505,  504,  503,  502,  501,  500,  499,  498,  497,
      496,  495,  494,  493,  492,  491,  490,  489,  488,  487,
      486,  485,  484,  483,  482,  481,  480,  479,  478,  477,
      476,  473,  472,  471,  470,  469,  468,  467,  466,  351,
      464,  455,  454,  448,  447,  444,  336,  440,  439,  434,
      424,  422,  416,  414,  413,  412,  411,  408,  407,  406,

      405,  404,  403,  402,  401,  400,  399,  398,  397,  396,
      395,  394,  393,  392,  391,  390,  386,  385,  384,  383,
      382,  381,  380,  379,  378,  377,  376,  375,  374,  373,
      372,  369,  368,  367,  366,  365,  364,  363,  357,  356,
      353,  345,  336,  331,  329,  328,  216,  212,  207,  321,
      319,  314,  313,  296,  295,  294,  293,  292,  291,  282,
      279,  278,  277,  276,  274,  273,  272,  271,  270,  269,
      268,  267,  264,  263,  262,  259,  258,  255,  254,  253,
      252,  251,  250,  234,  113,  233,  232,  103,  219,  216,
      115,  212,  207,  169,  160,  148,  126,  121,  115,  114,

      113,  103,   97,  983,   89,   82,   82,   19,  983,  983,
      983,  983,  983,  983,  983,  983,  983,  983,  983,  983,
      983,  983,  983,  983,  983,  983,  983,  983,  983,  983,
      983,  983,  983,  983,  983,  983,  983,  983,  983,  983,
      983,  983,  983,  983,  983,  983,  983,  983,  983,  983,
      983,  983,  983,  983,  983,  983,  983,  983,  983,  983,
      983,  983,  983,  983,  983,  983
    } ;

static yyconst flex_int16_t yy_chk[2267] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        2,  910,   16,    2,   16,    4,    4,    4,    5,    3,
        4,    5,    6,    5,    5,    6,    4,    6,    6,    7,
       17,    8,   27,    9,    7,    7,    8,    8,    9,    9,
       34,   34,    5,   10,   17,   21,    6,   21,   10,   10,

       51,   17,   90,    7,   51,    8,   90,    9,   27,   17,
       33,   33,   33,   36,   36,   38,   38,   10,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   18,   24,   18,   24,
       24,   18,   42,   26,   32,   32,  911,   43,   26,   42,
       18,   41,   41,   32,   26,   26,   56,   45,   24,   26,

       41,   43,   41,   44,   18,   44,   45,   47,   52,   44,
       56,   18,   46,   49,   47,   44,   50,   46,   46,   18,
       32,   46,   54,  136,   46,   52,   50,   49,   52,  136,
       55,   26,   50,   55,  310,   64,   49,   54,   64,   60,
       54,   60,  176,   55,   60,   61,   61,   61,   61,   65,
       66,   65,   66,   67,   65,   67,   67,   70,   70,   73,
       71,   61,   61,  310,   73,   73,  116,  116,   70,   70,
      419,   72,   76,   78,   67,  133,  133,   61,   78,   78,
       71,   61,  176,   73,   61,   72,   72,   72,   61,   66,
       75,   75,   76,   77,   77,   77,   93,   78,   80,   80,

       80,   75,   75,   91,   91,   70,   71,   84,  419,   84,
       93,  162,   91,   93,   91,   94,   93,   94,   76,   91,
       94,   72,   96,   98,   96,   98,   98,  119,  162,   77,
      119,  101,  912,  177,   80,  106,  106,  106,   75,   95,
       95,   95,   95,  119,   98,  101,  118,  118,  118,  125,
      125,  125,  140,  158,  311,   95,   95,  151,  126,  151,
      126,  126,  140,  158,  161,  169,  126,  126,  177,  169,
      126,   95,  175,  126,  178,   95,  126,  160,  235,  235,
      161,  101,   95,  160,  160,  247,  170,  160,  170,  871,
      171,  170,  171,  243,  311,  173,  173,  174,  174,  174,

      180,  181,  247,  180,  181,  243,  171,  171,  173,  184,
      871,  184,  174,  174,  174,  183,  175,  183,  178,  185,
      183,  185,  171,  199,  199,  187,  171,  187,  187,  171,
      193,  193,  193,  171,  172,  172,  172,  200,  200,  202,
      202,  202,  199,  201,  201,  213,  187,  213,  184,  338,
      172,  172,  201,  201,  258,  258,  200,  246,  185,  203,
      203,  338,  201,  204,  417,  246,  172,  417,  204,  204,
      172,  246,  305,  172,  208,  225,  225,  172,  203,  208,
      208,  217,  217,  217,  221,  305,  221,  204,  222,  221,
      222,  223,  223,  223,  225,  226,  226,  517,  208,  309,

      227,  227,  228,  228,  222,  222,  418,  223,  223,  227,
      227,  229,  229,  229,  226,  241,  241,  241,  238,  227,
      222,  228,  913,  223,  222,  238,  637,  223,  238,  342,
      232,  222,  232,  232,  223,  315,  315,  315,  232,  232,
      637,  238,  232,  309,  517,  232,  342,  418,  232,  239,
      239,  239,  239,  239,  239,  239,  239,  239,  239,  239,
      239,  239,  239,  239,  239,  239,  239,  239,  239,  239,
      239,  239,  239,  239,  239,  239,  239,  239,  239,  239,
      239,  239,  239,  239,  239,  239,  239,  239,  239,  239,
      239,  239,  239,  239,  239,  239,  239,  239,  239,  239,

      239,  239,  239,  239,  239,  239,  239,  240,  312,  275,
      240,  275,  299,  341,  299,  300,  640,  300,  307,  307,
      307,  341,  307,  240,  308,  308,  308,  341,  299,  299,
      300,  300,  300,  321,  640,  312,  420,  323,  323,  308,
      308,  308,  275,  361,  299,  421,  323,  323,  299,  275,
      319,  299,  319,  319,  466,  299,  323,  466,  319,  319,
      361,  321,  319,  639,  330,  319,  330,  420,  319,  324,
      324,  324,  326,  326,  326,  333,  333,  639,  421,  348,
      330,  330,  348,  620,  333,  333,  350,  350,  350,  387,
      345,  387,  345,  345,  333,  348,  330,  924,  345,  345,

      330,  410,  345,  410,  430,  345,  429,  330,  345,  409,
      620,  409,  426,  409,  429,  539,  410,  410,  410,  457,
      429,  430,  387,  539,  426,  437,  437,  438,  438,  387,
      435,  457,  435,  435,  437,  437,  443,  443,  435,  435,
      442,  442,  435,  452,  437,  435,  438,  461,  435,  442,
      442,  516,  519,  460,  435,  443,  464,  464,  464,  442,
      452,  460,  514,  515,  461,  514,  515,  460,  518,  518,
      518,  520,  529,  520,  533,  534,  537,  535,  540,  536,
      545,  925,  538,  545,  537,  541,  541,  534,  566,  529,
      537,  519,  543,  543,  534,  516,  535,  533,  536,  538,

      597,  540,  597,  537,  541,  566,  571,  571,  571,  538,
      597,  543,  605,  609,  605,  612,  609,  612,  614,  618,
      616,  614,  605,  616,  617,  617,  617,  621,  622,  635,
      636,  622,  638,  641,  642,  643,  644,  621,  645,  660,
      638,  701,  660,  646,  701,  703,  636,  641,  703,  618,
      709,  635,  643,  646,  692,  704,  692,  704,  642,  644,
      643,  698,  713,  698,  692,  645,  712,  712,  712,  730,
      729,  698,  713,  729,  731,  732,  734,  733,  735,  736,
      737,  709,  729,  738,  739,  740,  736,  803,  785,  734,
      785,  735,  730,  740,  804,  741,  739,  737,  805,  731,

      733,  802,  804,  732,  741,  788,  788,  788,  738,  806,
      807,  802,  808,  809,  810,  803,  811,  812,  851,  813,
      807,  814,  808,  848,  864,  848,  805,  812,  865,  809,
      867,  870,  788,  868,  869,  872,  811,  806,  873,  906,
      814,  810,  813,  874,  875,  916,  917,  865,  918,  919,
      848,  873,  864,  914,  870,  920,  921,  875,  867,  851,
      926,  868,  869,  872,  923,  922,  914,  874,  927,  928,
      929,  930,  919,  916,  917,  931,  918,  932,  923,  906,
      933,  921,  934,  920,  922,  935,  936,  937,  938,  940,
      941,  942,  943,  944,  945,  946,  947,  948,  949,  950,

      952,  951,  953,  954,  955,  956,  957,  958,  959,  961,
      947,  951,  962,  963,  964,  970,  965,  966,  967,  941,
      968,  969,  971,  972,  974,  948,  949,  950,  952,  973,
      973,  973,  975,  976,  977,  976,  978,  979,  981, 1008,
     1008, 1012, 1012,  962,  965,  966,  967,  909,  968,  969,
     1014, 1014,  974, 1019, 1019,  908,  907,  904,  902,  901,
      975,  984,  984,  984,  984,  984,  984,  984,  984,  984,
      984,  984,  984,  984,  984,  984,  984,  985,  985,  985,
      985,  985,  985,  985,  985,  985,  985,  985,  985,  985,
      985,  985,  985,  986,  986,  986,  986,  986,  986,  986,

      986,  986,  986,  986,  986,  986,  986,  986,  986,  987,
      987,  987,  987,  987,  987,  987,  987,  987,  987,  987,
      987,  987,  987,  987,  987,  988,  988,  988,  988,  988,
      988,  988,  988,  988,  988,  988,  988,  988,  988,  988,
      988,  989,  989,  989,  989,  989,  989,  989,  989,  989,
      989,  989,  989,  989,  989,  989,  989,  990,  900,  990,
      990,  990,  990,  990,  990,  990,  990,  990,  990,  990,
      990,  990,  990,  991,  991,  991,  991,  991,  991,  991,
      991,  991,  991,  991,  991,  991,  991,  991,  991,  992,
      898,  897,  896,  992,  895,  894,  893,  992,  992,  992,

      892,  992,  993,  891,  993,  993,  993,  993,  993,  993,
      993,  993,  993,  993,  993,  993,  993,  993,  994,  994,
      994,  994,  995,  890,  995,  995,  995,  995,  995,  889,
      995,  995,  995,  995,  995,  995,  995,  995,  996,  888,
      996,  996,  996,  996,  996,  996,  996,  996,  996,  996,
      996,  996,  996,  996,  997,  887,  997,  997,  997,  997,
      997,  997,  997,  997,  997,  997,  997,  997,  997,  997,
      998,  998,  886,  885,  883,  882,  881,  880,  998,  998,
      998,  879,  998,  999,  878,  877,  876,  866,  863,  862,
      999,  999,  861,  999, 1000, 1000, 1000, 1000, 1000, 1000,

     1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000,
     1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001,
     1001, 1001, 1001, 1001, 1001, 1001, 1002, 1002, 1002, 1002,
     1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002,
     1002, 1002, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
     1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1004, 1004,
     1004, 1004, 1005, 1005, 1005, 1005, 1005, 1005, 1005, 1005,
     1005, 1005, 1005, 1005, 1005, 1005, 1005, 1005, 1006, 1006,
     1006, 1006, 1006, 1006, 1006, 1006, 1006, 1006,  860, 1006,
     1006, 1006, 1006, 1006, 1007, 1007, 1007, 1007, 1009, 1009,

     1009, 1010,  859,  858, 1010,  857,  856, 1010, 1010, 1010,
     1011, 1011, 1011, 1011, 1013, 1013, 1013, 1013, 1015, 1015,
      855,  852,  850,  849, 1015, 1015, 1015,  846, 1015, 1016,
     1016,  845,  844,  842,  841, 1016, 1016, 1016,  840, 1016,
     1017, 1017, 1017, 1017,  839,  838, 1017, 1018, 1018, 1018,
     1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
     1020, 1020, 1020, 1020, 1020, 1020, 1021, 1021, 1021, 1021,
      837,  836, 1021, 1022, 1022, 1022, 1022,  835,  834, 1022,
     1023, 1023, 1023, 1024, 1024, 1024, 1025,  833,  832,  831,
     1025, 1025, 1025, 1025, 1026, 1026, 1026, 1026, 1026, 1026,

     1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026,
     1027, 1027, 1027, 1027, 1027, 1027, 1027, 1027, 1027, 1027,
     1027, 1027, 1027, 1027, 1027, 1027, 1028, 1028, 1028, 1028,
     1028, 1028, 1028, 1028, 1028, 1028, 1028, 1028, 1028, 1028,
     1028, 1028, 1029,  830, 1029, 1029, 1029, 1029, 1029, 1029,
     1029, 1029, 1029, 1029, 1029, 1029, 1029, 1029, 1030, 1030,
     1030, 1030, 1030, 1030, 1030, 1030, 1030, 1030, 1030, 1030,
     1030, 1030, 1030, 1030, 1031, 1031, 1031, 1031, 1031, 1031,
     1031, 1031, 1031, 1031, 1031, 1031, 1031, 1031, 1031, 1031,
     1032, 1032, 1032, 1032, 1032, 1032, 1032, 1032, 1032, 1032,

     1032, 1032, 1032, 1032, 1032, 1032, 1033, 1033, 1033, 1033,
     1033, 1033, 1033, 1033, 1033, 1033, 1033, 1033, 1033, 1033,
     1033, 1033, 1034, 1034, 1034, 1034, 1034, 1034, 1034, 1034,
     1034, 1034, 1034, 1034, 1034, 1034, 1034, 1034, 1035, 1035,
     1035, 1035, 1035, 1035, 1035, 1035, 1035, 1035, 1035, 1035,
     1035, 1035, 1035, 1035, 1036, 1036, 1036, 1036, 1036, 1036,
     1036, 1036, 1036, 1036, 1036, 1036, 1036, 1036, 1036, 1036,
     1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037,
     1037, 1037, 1037, 1037, 1037, 1037, 1038, 1038, 1038, 1038,
     1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038,

     1038, 1038, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039,
     1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 1040, 1040,
     1040, 1040, 1040, 1040, 1040, 1040, 1040, 1040, 1040, 1040,
     1040, 1040, 1040, 1040, 1041, 1041, 1041, 1041, 1041, 1041,
     1041, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 1041,
     1042, 1042, 1042, 1042, 1042, 1042, 1042, 1042, 1042, 1042,
     1042, 1042, 1042, 1042, 1042, 1042,  829,  828,  827,  826,
      825,  824,  823,  822,  821,  820,  819,  818,  817,  816,
      801,  800,  799,  798,  797,  796,  795,  794,  793,  791,
      790,  789,  786,  784,  783,  780,  779,  778,  776,  775,

      774,  773,  772,  771,  770,  769,  768,  766,  765,  764,
      763,  762,  761,  760,  759,  758,  757,  756,  755,  754,
      753,  752,  751,  750,  749,  748,  747,  746,  745,  743,
      742,  728,  727,  726,  725,  724,  723,  722,  721,  720,
      719,  718,  717,  716,  715,  710,  708,  707,  706,  705,
      700,  694,  691,  690,  688,  685,  684,  683,  682,  681,
      680,  679,  678,  677,  676,  674,  673,  672,  671,  670,
      669,  668,  667,  666,  665,  664,  663,  662,  661,  659,
      658,  657,  656,  655,  654,  653,  652,  651,  650,  649,
      648,  647,  634,  633,  632,  631,  630,  629,  628,  627,

      626,  625,  624,  623,  619,  613,  611,  610,  608,  607,
      603,  602,  601,  598,  596,  595,  593,  591,  590,  588,
      587,  585,  584,  583,  582,  581,  580,  579,  578,  577,
      576,  575,  574,  573,  570,  569,  568,  567,  565,  564,
      563,  562,  561,  560,  559,  558,  557,  556,  555,  554,
      553,  552,  551,  550,  549,  548,  547,  546,  532,  531,
      530,  528,  527,  526,  525,  524,  523,  522,  521,  513,
      512,  511,  510,  509,  505,  504,  503,  502,  501,  500,
      499,  498,  497,  496,  495,  494,  493,  492,  491,  490,
      489,  488,  487,  486,  484,  479,  478,  477,  476,  475,

      474,  473,  472,  471,  470,  469,  468,  467,  465,  463,
      462,  459,  458,  456,  455,  454,  453,  451,  450,  449,
      448,  447,  446,  445,  444,  433,  432,  431,  428,  427,
      425,  423,  422,  415,  414,  413,  412,  411,  408,  405,
      404,  403,  402,  401,  400,  399,  398,  397,  396,  395,
      393,  391,  389,  388,  386,  385,  383,  380,  375,  374,
      373,  372,  371,  370,  369,  367,  366,  365,  364,  363,
      362,  360,  359,  358,  357,  356,  355,  354,  353,  349,
      347,  344,  343,  340,  339,  337,  335,  329,  328,  320,
      317,  313,  306,  304,  303,  302,  301,  298,  297,  296,

      295,  293,  292,  291,  290,  289,  286,  285,  284,  283,
      282,  281,  280,  279,  278,  276,  274,  273,  272,  271,
      270,  269,  267,  266,  265,  264,  263,  262,  261,  260,
      259,  257,  256,  254,  252,  250,  249,  248,  245,  244,
      242,  233,  231,  224,  220,  219,  215,  211,  205,  198,
      197,  190,  186,  168,  167,  166,  165,  164,  163,  159,
      157,  154,  153,  152,  150,  149,  148,  147,  145,  144,
      143,  142,  139,  138,  137,  135,  134,  132,  131,  130,
      129,  128,  127,  114,  112,  111,  110,  102,   92,   88,
       86,   81,   74,   57,   53,   48,   40,   35,   31,   30,

       29,   25,   23,   19,   15,   12,   11,  983,  983,  983,
      983,  983,  983,  983,  983,  983,  983,  983,  983,  983,
      983,  983,  983,  983,  983,  983,  983,  983,  983,  983,
      983,  983,  983,  983,  983,  983,  983,  983,  983,  983,
      983,  983,  983,  983,  983,  983,  983,  983,  983,  983,
      983,  983,  983,  983,  983,  983,  983,  983,  983,  983,
      983,  983,  983,  983,  983,  983
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 1;

static yyconst flex_int16_t yy_rule_linenum[152] =
    {   0,
      502,  504,  505,  506,  507,  511,  517,  518,  521,  538,
      543,  548,  552,  555,  559,  560,  563,  568,  569,  570,
      578,  579,  580,  581,  582,  583,  584,  585,  586,  587,
      588,  589,  590,  591,  592,  593,  594,  595,  596,  597,
      598,  599,  600,  601,  602,  603,  604,  605,  606,  607,
      608,  609,  610,  611,  612,  613,  614,  615,  616,  617,
      618,  619,  620,  621,  622,  623,  624,  625,  626,  627,
      628,  629,  630,  635,  636,  637,  679,  680,  682,  685,
      686,  687,  692,  695,  701,  704,  707,  711,  719,  720,
      721,  722,  726,  729,  737,  749,  755,  767,  773,  774,

      778,  779,  780,  782,  783,  820,  824,  828,  832,  836,
      841,  846,  851,  856,  861,  867,  868,  875,  883,  888,
      891,  896,  899,  904,  910,  911,  951,  973,  982,  987,
      992,  996, 1017, 1039, 1055, 1056, 1057, 1058, 1059, 1060,
     1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070,
     1072
    } ;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "lex.l"

#line 26 "lex.l"
#include <sys/types.h>
#include <sys/stat.h>
#include "mailfromd.h"
#include <mailutils/yyloc.h>
#include "gram.h"
#include "prog.h"
#include "srvcfg.h"

static mu_linetrack_t trk;

static struct mu_locus_point start_locus; /* Location when the last state switch
					    occurred */
static mu_opool_t string_pool;   /* Opool for constructing string values */
static char *multiline_delimiter; /* End of here-document delimiter */
static size_t multiline_delimiter_len; /* Length of multiline_delimiter_len */
static int multiline_unescape;         /* Unescape here-document contents */
static int (*char_to_strip)(char);     /* Strip matching characters of each
					  here-document line */
struct mu_locus_range const *
get_locus(void)
{
	return &yylloc;
}

static int
is_tab(char c)
{
	return c == '\t';
}

static int
is_space(char c)
{
	return c == '\t' || c == ' ';
}

static unsigned char
c_unescape(unsigned char inc)
{
	int outc = mu_wordsplit_c_unquote_char(inc);
	return outc ? outc : inc;
}

static void
switch_origin(struct mu_locus_point *pt)
{
	mu_linetrack_origin(trk, pt);
	mu_locus_point_deinit(pt);
}

#define line_begin string_begin
#define line_add string_add
#define line_add_char string_add_char
static void line_finish(void);
static void string(const char *str, size_t len);
static int isemptystr(char *text);
static int builtin_const(const char *s, size_t len);


/* Input context flags */
#define INCTX_MODULE     0x1  /* current input is a MFL module */
#define INCTX_HADINPUT   0x2  /* some statements has already been processed */
#define INCTX_IGNORE_BYE 0x4  /* ignore eventual `bye' statement, because
				 this is an #included module */

/* Input context stack */
struct inctx {                     /* input context structure */
	struct inctx *parent;      /* parent context */
	struct mu_locus_range locus;/* locus where the context was pushed */
	mu_linetrack_t trk;
	struct input_file_ident id;/* file id structure to prevent recursion */
	FILE *file;                /* saved yyin */
	pid_t pp_pid;              /* preprocessor pid, if used */
	int inctx_flags;           /* input context flags */
	YY_BUFFER_STATE buf;       /* lex buffer state */
};

struct inctx *inctx_tos;           /* stack of input contexts */

/* Current input context: */
static pid_t pp_pid;               /* preprocessor pid */
static struct input_file_ident input_file_id;
static int inctx_flags;            /* input context flags */

/* If not 0, emit_token keeps a token that yylex must return on the
   next call. See YY_USER_ACTION below. */
static int emit_token;

/* Find on stack an input context that matches the given file id.
   Return pointer to the context. */
struct inctx *
inctx_locate(struct input_file_ident *id)
{
	struct inctx *ctx;

	for (ctx = inctx_tos; ctx; ctx = ctx->parent)
		if (ctx->id.device == id->device
		    && ctx->id.i_node == id->i_node)
			break;
	return ctx;
}

/* Push input context */
static void
inctx_push()
{
	struct inctx *ctx = mu_alloc(sizeof(*ctx));

	mu_locus_range_init(&ctx->locus);
	mu_locus_range_copy(&ctx->locus, &yylloc);
	ctx->trk = trk;
	ctx->id = input_file_id;
	ctx->file = yyin;
	ctx->pp_pid = pp_pid;
	ctx->inctx_flags = inctx_flags;
	ctx->buf = YY_CURRENT_BUFFER;
	ctx->parent = inctx_tos;
	inctx_tos = ctx;
}

/* Pop input context from the top of the stack into the current
   input context. Return 1 if there are no more contexts left. */
int
inctx_pop()
{
	struct inctx *ctx = inctx_tos;

	if (!ctx)
		return 1;

	inctx_tos = ctx->parent;

	mu_locus_range_deinit(&ctx->locus);
	trk = ctx->trk;
	yyin = ctx->file;
	input_file_id = ctx->id;
	inctx_flags = ctx->inctx_flags;
	yy_delete_buffer(YY_CURRENT_BUFFER);
	yy_switch_to_buffer(ctx->buf);
	pp_pid = ctx->pp_pid;
	free(ctx);
	return 0;
}

/* Setup the scanner for input from the file NAME. Return 0 on success,
   and an appropriate EX_ code on error. See lex_new_source below. */
static int
lex_new_source_0(const char *name)
{
	if (!yyin)
		mu_locus_range_init (&yylloc);
	if (preprocessor.enabled) {
		yyin = pp_extrn_start(name, &pp_pid);
		if (!yyin) {
			parse_error(_("unable to start external "
				      "preprocessor `%s': %s"),
				    string_preprocessor(),
				    mu_strerror(errno));
			return EX_OSFILE;
		}
	} else {
		yyin = fopen(name, "r");
		if (!yyin) {
			parse_error(_("cannot open %s: %s"), name,
				    mu_strerror(errno));
			return EX_NOINPUT;
		}
	}
	yy_switch_to_buffer(yy_create_buffer(yyin,YY_BUF_SIZE));
	MU_ASSERT(mu_linetrack_create(&trk, name, 2));
	mu_locus_point_set_file(&yylloc.beg, name);
	yylloc.beg.mu_line = 1;
	yylloc.beg.mu_col = 1;
	mu_locus_point_copy(&yylloc.end, &yylloc.beg);
	mu_stream_ioctl(mu_strerr, MU_IOCTL_LOGSTREAM,
			MU_IOCTL_LOGSTREAM_SET_LOCUS_RANGE, &yylloc);
	return EX_OK;
}

/* Save the current input context on stack and set up the scanner for
   input from the file NAME. Return 0 on success,
   and an appropriate EX_ code on error. */
int
lex_new_source(const char *name, int flag)
{
	int rc;
	struct stat st;
	struct input_file_ident id;
	struct inctx *pctx;

	if (stat(name, &st)) {
		parse_error(_("cannot open `%s': %s"),
			    name, mu_strerror(errno));
		return EX_NOINPUT;
	} else if (!S_ISREG(st.st_mode)) {
		parse_error(_("`%s' is not a regular file"), name);
		return EX_NOINPUT;
	}

	id.device = st.st_dev;
	id.i_node = st.st_ino;

	pctx = inctx_locate(&id);
	if (pctx) {
		parse_error(_("recursive inclusion"));
		if (pctx->parent)
			parse_error_locus(&pctx->parent->locus,
					  _("`%s' already included here"),
					  name);
		else
			parse_error(_("`%s' already included at top level"),
				    name);
		return 1;
	}

	if (flag == LEX_ONCE && source_lookup(&id))
		return 0;

	if (yyin)
		inctx_push();
	rc = lex_new_source_0(name);
	if (rc)
		inctx_pop();
	else {
		input_file_id = id;
		if (flag == LEX_MODULE) {
			inctx_flags = INCTX_MODULE;
			emit_token = T_MODBEG;
		} else
			inctx_flags = 0;
	}
	return rc;
}


/* Return constant or variable token corresponding to the current
   value of yylval.literal->text. */
static int
variable_or_const(void)
{
	struct variable *vptr;
	const struct constant *cptr;

	cptr = constant_lookup(yylval.literal->text);
	if (cptr) {
		const struct value *value_ptr = &cptr->value;
		switch (value_ptr->type) {
		case dtype_number:
			yylval.number = value_ptr->v.number;
			return T_NUMBER;

		case dtype_string:
			yylval.literal = value_ptr->v.literal;
			return T_STRING;

		default:
			abort();
		}
	}

	vptr = variable_lookup(yylval.literal->text);
	if (!vptr) {
		parse_error(_("variable %s is not defined"),
			    yylval.literal->text);
		return T_BOGUS;
	}
	variable_check_initialized(vptr, &yylloc);
	add_xref(vptr, &yylloc);
	yylval.var = vptr;
	return T_VARIABLE;
}

/* Saved lexer state before entering COMMENT */
static int save_state;
/* Same as BEGIN, but also saves the current locus. It is then used
   to report unclosed constructs at the end of file. */
#define BEGIN_X(s)							\
	do {								\
		BEGIN(s);						\
		mu_locus_point_copy (&start_locus, &yylloc.beg);	\
	} while(0)

/* If emit_token is not 0, push back current input and return the value
   of emit_token. Clear emit_token before returning. */
#define YY_USER_ACTION							\
	if (emit_token) {						\
		int tok = emit_token;					\
		emit_token = 0;						\
		if (yy_flex_debug)					\
			fprintf(stderr, "--emitting %d (module %s)\n",	\
				tok,top_module->name);			\
		mu_linetrack_retreat(trk, yyleng);			\
		yyless(0);						\
		return tok;						\
	} else {							\
		mu_linetrack_advance(trk, &yylloc, yytext, yyleng);	\
		mu_stream_ioctl(mu_strerr, MU_IOCTL_LOGSTREAM,		\
				MU_IOCTL_LOGSTREAM_SET_LOCUS_RANGE, &yylloc);\
	}

/* Read next input chunk. */
#define YY_INPUT(buf,result,max_size)					\
	if (yyin == NULL)						\
		result = YY_NULL;					\
	else if (((result = fread(buf, 1, max_size, yyin)) == 0)	\
		 && ferror(yyin))					\
		YY_FATAL_ERROR("input in flex scanner failed");

/* Redeclare main entry point. Actual yylex is defined in the code section
   below. */
#define YY_DECL static int lexscan(void)


/* String composer */
static struct mu_locus_point string_beg;
static NODE *string_head, *string_tail;

static void
compose_add_node(NODE *node)
{
	if (string_tail)
		string_tail->next = node;
	else
		string_head = node;
	string_tail = node;
}

static void
compose_start(int state)
{
	if (string_head) {
		parse_error("INTERNAL ERROR: previous composition has not "
			    "finished when a new one started");
		abort();
	}
	mu_locus_point_copy(&string_beg, &yylloc.beg);
	BEGIN_X(state);
}

static int
compose_finish()
{
	if (string_tail != string_head) {
		while (string_head->next) {
			NODE *cat = alloc_node(node_type_concat,
					       &string_head->locus);
			NODE *next = string_head->next;
			cat->next = next->next;
			cat->v.concat.arg[0] = cast_to(dtype_string,
						       string_head);
			cat->v.concat.arg[1] = cast_to(dtype_string, next);
			string_head->next = next->next = NULL;
			string_head = cat;
		}
	}
	yylval.node = string_head;
	mu_locus_point_copy(&yylloc.beg, &string_beg);
	mu_locus_point_deinit(&string_beg);
	string_head = string_tail = NULL;
	return T_COMPOSE;
}

static void
compose_add_literal(struct literal *lit)
{
	NODE *node = alloc_node(node_type_string, &yylloc);
	node->v.literal = lit;
	compose_add_node(node);
	if (yy_flex_debug)
		fprintf(stderr, "--add literal: '%s'\n", lit->text);
}

static void
compose_add_string(const char *text, size_t length)
{
	compose_add_literal(string_alloc(text, length));
}

static void
compose_add_number(long num)
{
	NODE *node = alloc_node(node_type_number, &yylloc);
	node->v.number = num;
	compose_add_node(node);
}

void
compose_add_builtin_const(const char *s, size_t len)
{
	const char *sval;
	long nval;

	switch (builtin_const_value(s, len, &sval, &nval)) {
	case dtype_number:
		compose_add_number(nval);
		break;

	case dtype_string:
		compose_add_string(sval, strlen(sval));
		break;

	default:
		abort();
	}
}

void
compose_add_variable_or_const(int what)
{
	switch (what) {
	case T_NUMBER:
		compose_add_number(yylval.number);
		break;

	case T_STRING:
		compose_add_literal(yylval.literal);
		break;

	case T_VARIABLE:
		compose_add_node(create_node_variable(yylval.var, &yylloc));
	}
}

static int
getnum(int type, int off, int base)
{
	errno = 0;
	yylval.number = strtol(yytext + off, NULL, base);
	if (errno) {
		struct mu_locus_range loc = yylloc;
		loc.beg.mu_col += off;
		parse_error_locus(&loc, "%s", _("numeric value out of range"));
		return T_BOGUS;
	}
	return type;
}

/* Exclusive states:

   SHELLMAGIC     Initial shell-magic boilerplate (#!... !#)
   COMMENT        Within a C-style comment;
   XIDENT         Expected identifier;
   STR            Processing a complex string;
   ML             Within a multi-line aggregator.  The line being built
		  requires stripping leading whitespace (if requested).
   CML            Continuation within a multi-line aggregator.  The line
		  being built does not require stripping leading whitespace.
   QML            Quoted multi-line aggregator.  No variable substitution and
		  unquoting is needed.

   Inclusive states:

   ONBLOCK	  Lexical tie-in after an `on' keyword.  In ONBLOCK state
		  the strigns `as', `host', `from', and `poll' are
		  recognized as keywords.  The string `for' also acquires
		  special meaning.
*/


#line 1891 "lex.c"

#define INITIAL 0
#define COMMENT 1
#define STR 2
#define ML 3
#define CML 4
#define QML 5
#define XIDENT 6
#define SHELLMAGIC 7
#define ONBLOCK 8

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
/* %if-c-only */
#include <unistd.h>
/* %endif */
/* %if-c++-only */
/* %endif */
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

/* %if-c-only Reentrant structure and macros (non-C++). */
/* %if-reentrant */
/* %if-c-only */

static int yy_init_globals (void );

/* %endif */
/* %if-reentrant */
/* %endif */
/* %endif End reentrant structures and macros. */

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy (void );

int yyget_debug (void );

void yyset_debug (int debug_flag  );

YY_EXTRA_TYPE yyget_extra (void );

void yyset_extra (YY_EXTRA_TYPE user_defined  );

FILE *yyget_in (void );

void yyset_in  (FILE * _in_str  );

FILE *yyget_out (void );

void yyset_out  (FILE * _out_str  );

yy_size_t yyget_leng (void );

char *yyget_text (void );

int yyget_lineno (void );

void yyset_lineno (int _line_number  );

/* %if-bison-bridge */
/* %endif */

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap (void );
#else
extern int yywrap (void );
#endif
#endif

/* %not-for-header */

#ifndef YY_NO_UNPUT
    
#endif
/* %ok-for-header */

/* %endif */

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT
/* %if-c-only Standard (non-C++) definition */
/* %not-for-header */

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif
/* %ok-for-header */

/* %endif */
#endif

/* %if-c-only */

/* %endif */

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* %if-c-only Standard (non-C++) definition */
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, yyleng, 1, yyout )) {} } while (0)
/* %endif */
/* %if-c++-only C++ definition */
/* %endif */
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
/* %% [5.0] fread()/read() definition of YY_INPUT goes here unless we're doing C++ \ */\
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\
/* %if-c++-only C++ definition \ */\
/* %endif */

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
/* %if-c-only */
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
/* %endif */
/* %if-c++-only */
/* %endif */
#endif

/* %if-tables-serialization structures and prototypes */
/* %not-for-header */

/* %ok-for-header */

/* %not-for-header */

/* %tables-yydmap generated elements */
/* %endif */
/* end tables serialization structures and prototypes */

/* %ok-for-header */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1
/* %if-c-only Standard (non-C++) definition */

extern int yylex (void);

#define YY_DECL int yylex (void)
/* %endif */
/* %if-c++-only C++ definition */
/* %endif */
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

/* %% [6.0] YY_RULE_SETUP definition goes here */
#define YY_RULE_SETUP \
	if ( yyleng > 0 ) \
		YY_CURRENT_BUFFER_LVALUE->yy_at_bol = \
				(yytext[yyleng - 1] == '\n'); \
	YY_USER_ACTION

/* %not-for-header */

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
/* %if-c-only */
			yyin = stdin;
/* %endif */
/* %if-c++-only */
/* %endif */

		if ( ! yyout )
/* %if-c-only */
			yyout = stdout;
/* %endif */
/* %if-c++-only */
/* %endif */

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer(yyin,YY_BUF_SIZE );
		}

		yy_load_buffer_state( );
		}

	{
/* %% [7.0] user's declarations go here */
#line 500 "lex.l"

	 /* C-style comments */
#line 2188 "lex.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
/* %% [8.0] yymore()-related code goes here */
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

/* %% [9.0] code to set up and find next match goes here */
		yy_current_state = (yy_start);
		yy_current_state += YY_AT_BOL();
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 984 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 2208 );

yy_find_action:
/* %% [10.0] code to find the action number goes here */
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

/* %% [11.0] code for yylineno update goes here */

do_action:	/* This label is used only to access EOF actions. */

/* %% [12.0] debug code goes here */
		if ( yy_flex_debug )
			{
			if ( yy_act == 0 )
				fprintf( stderr, "--scanner backing up\n" );
			else if ( yy_act < 152 )
				fprintf( stderr, "--accepting rule at line %ld (\"%s\")\n",
				         (long)yy_rule_linenum[yy_act], yytext );
			else if ( yy_act == 152 )
				fprintf( stderr, "--accepting default rule (\"%s\")\n",
				         yytext );
			else if ( yy_act == 153 )
				fprintf( stderr, "--(end of buffer or a NUL)\n" );
			else
				fprintf( stderr, "--EOF (start condition %d)\n", YY_START );
			}

		switch ( yy_act )
	{ /* beginning of action switch */
/* %% [13.0] actions go here */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 502 "lex.l"
{ save_state = YYSTATE;  BEGIN_X(COMMENT); }
	YY_BREAK

case 2:
YY_RULE_SETUP
#line 504 "lex.l"
/* eat anything that's not a '*' */
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 505 "lex.l"
/* eat up '*'s not followed by '/'s */
	YY_BREAK
case 4:
/* rule 4 can match eol */
YY_RULE_SETUP
#line 506 "lex.l"
;
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 507 "lex.l"
BEGIN(save_state);
	YY_BREAK

/* Shell magic sequence */
case 6:
/* rule 6 can match eol */
YY_RULE_SETUP
#line 511 "lex.l"
{
	if (yylloc.beg.mu_line == 1) {
		BEGIN_X(SHELLMAGIC);
	}
 }
	YY_BREAK

case 7:
/* rule 7 can match eol */
YY_RULE_SETUP
#line 517 "lex.l"
{ BEGIN(INITIAL); }
	YY_BREAK
case 8:
/* rule 8 can match eol */
YY_RULE_SETUP
#line 518 "lex.l"
;
	YY_BREAK

/* Configuration directives */
case 9:
/* rule 9 can match eol */
YY_RULE_SETUP
#line 521 "lex.l"
{
	struct mu_locus_point pt;
	if (parse_line_cpp(yytext, &pt) == 0)
		switch_origin(&pt);
}
	YY_BREAK
/* Normally, everything within a comment should be ignored, so
	   the exclusive condition for the rule below is an error.
	   Unfortunately, GNU m4 in versions up to 1.4.9 outputs line
	   synchronisation directives in comments, which makes any decent
	   compiler lose trace of which input line it is on.  To avoid
	   this, mfd handles #line directives even within a C-comment
	   block.

	   This bug was fixed in m4 version 1.4.10.  I prefer to keep
	   this kludge until I am pretty sure there are no 1.4.9 around.
	*/
case 10:
/* rule 10 can match eol */
YY_RULE_SETUP
#line 538 "lex.l"
{
	struct mu_locus_point pt;
	if (parse_line(yytext, &pt) == 0)
		switch_origin(&pt);
}
	YY_BREAK
case 11:
/* rule 11 can match eol */
YY_RULE_SETUP
#line 543 "lex.l"
{
	mu_linetrack_retreat(trk, 1);
	yyless(yyleng-1);
	parse_pragma(yytext);
}
	YY_BREAK
case 12:
/* rule 12 can match eol */
YY_RULE_SETUP
#line 548 "lex.l"
{
	yytext[yyleng-1] = 0; /* Kill trailing newline */
	parse_error("%s", yytext);
}
	YY_BREAK
case 13:
/* rule 13 can match eol */
YY_RULE_SETUP
#line 552 "lex.l"
{
	parse_include(yytext, 1);
}
	YY_BREAK
case 14:
/* rule 14 can match eol */
YY_RULE_SETUP
#line 555 "lex.l"
{
	parse_include(yytext, 0);
}
	YY_BREAK
/* End-of-line comments */
case 15:
/* rule 15 can match eol */
YY_RULE_SETUP
#line 559 "lex.l"
;
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 560 "lex.l"
/* end-of-file comment */;
	YY_BREAK
/* expected identifier (after 'require', 'prog' and initial 'from') */

case 17:
YY_RULE_SETUP
#line 563 "lex.l"
{
		BEGIN(INITIAL);
		string(yytext, yyleng);
		return T_IDENTIFIER;
	}
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 568 "lex.l"
;
	YY_BREAK
case 19:
/* rule 19 can match eol */
YY_RULE_SETUP
#line 569 "lex.l"
;
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 570 "lex.l"
{
		BEGIN(INITIAL);
		mu_linetrack_retreat(trk, yyleng);
		yyless(0);
	}
	YY_BREAK

/* Reserved words */
case 21:
YY_RULE_SETUP
#line 578 "lex.l"
return T_ACCEPT;
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 579 "lex.l"
return T_REJECT;
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 580 "lex.l"
return T_TEMPFAIL;
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 581 "lex.l"
return T_CONTINUE;
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 582 "lex.l"
return T_DISCARD;
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 583 "lex.l"
return T_ADD;
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 584 "lex.l"
return T_REPLACE;
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 585 "lex.l"
return T_DELETE;
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 586 "lex.l"
return T_IF;
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 587 "lex.l"
return T_FI;
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 588 "lex.l"
return T_ELSE;
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 589 "lex.l"
return T_ELIF;
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 590 "lex.l"
return T_ON;
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 591 "lex.l"
return T_DO;
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 592 "lex.l"
return T_DONE;
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 593 "lex.l"
return T_MATCHES;
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 594 "lex.l"
return T_FNMATCHES;
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 595 "lex.l"
return T_MXMATCHES;
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 596 "lex.l"
return T_MXFNMATCHES;
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 597 "lex.l"
return T_WHEN;
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 598 "lex.l"
return T_OR;
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 599 "lex.l"
return T_AND;
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 600 "lex.l"
return T_NOT;
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 601 "lex.l"
return T_NEXT;
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 602 "lex.l"
{ BEGIN(XIDENT); return T_PROG; }
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 603 "lex.l"
return T_SET;
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 604 "lex.l"
return T_CATCH;
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 605 "lex.l"
return T_TRY;
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 606 "lex.l"
return T_ECHO;
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 607 "lex.l"
return T_RETURN;
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 608 "lex.l"
return T_RETURNS;
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 609 "lex.l"
return T_FUNC;
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 610 "lex.l"
return T_SWITCH;
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 611 "lex.l"
return T_CASE;
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 612 "lex.l"
return T_DEFAULT;
	YY_BREAK
case 56:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp = yy_bp + 6;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 613 "lex.l"
{ yylval.type = dtype_string; return T_TYPECAST; }
	YY_BREAK
case 57:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp = yy_bp + 6;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 614 "lex.l"
{ yylval.type = dtype_number; return T_TYPECAST; }
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 615 "lex.l"
return T_VOID;
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 616 "lex.l"
{ yylval.type = dtype_string; return T_TYPE; }
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 617 "lex.l"
{ yylval.type = dtype_number; return T_TYPE; }
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 618 "lex.l"
return T_CONST;
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 619 "lex.l"
return T_THROW;
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 620 "lex.l"
return T_LOOP;
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 621 "lex.l"
return T_WHILE;
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 622 "lex.l"
return T_FOR;
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 623 "lex.l"
return T_BREAK;
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 624 "lex.l"
return T_PASS;
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 625 "lex.l"
return T_ALIAS;
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 626 "lex.l"
return T_VAPTR;
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 627 "lex.l"
return T_PRECIOUS;
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 628 "lex.l"
{ BEGIN(XIDENT); return T_REQUIRE; }
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 629 "lex.l"
return T_IMPORT;
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 630 "lex.l"
{
	if (YYSTATE != ONBLOCK)
		BEGIN(XIDENT);
	return T_FROM;
 }
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 635 "lex.l"
return T_STATIC;
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 636 "lex.l"
return T_PUBLIC;
	YY_BREAK
case 76:
YY_RULE_SETUP
#line 637 "lex.l"
{
	if (inctx_tos && inctx_flags == 0) {
		int c;
		int flen;
		const char *fname = strrchr(yylloc.beg.mu_file, '/');

		if (fname)
			fname++;
		else
			fname = yylloc.beg.mu_file;
		flen = strlen(fname);

		if (flen > 3 && strcmp(fname + flen - 3, ".mf") == 0)
			flen -= 3;
		parse_warning_locus(&inctx_tos->locus,
				    _("including a module file is unreliable and may cause subtle errors"));
		/* TRANSLATORS: Do not translate `require %*.*s' */
		parse_warning_locus(&inctx_tos->locus,
				    _("use `require %*.*s' instead"),
				    flen, flen, fname);
		inctx_flags |= INCTX_IGNORE_BYE;
		mu_locus_point_copy(&start_locus, &yylloc.beg);
		while ((c = input()) != '.') {
		    /*
		     * On end of file, input() returns EOF in flex versions
		     * before 2.6.1, and 0 in flex 2.6.1 and later.
		     * See https://github.com/westes/flex/issues/448
		     */
		    if (c == EOF || c == 0) {
			mu_diag_at_locus_point(MU_DIAG_ERROR, &start_locus,
					       "%s",
					       _("unexpected end of file"));
			return 0;
		    } else {
			char ch = c;
			mu_linetrack_advance(trk, &yylloc, &ch, 1);
		    }
		}
	     } else if (inctx_flags & INCTX_HADINPUT)
		     parse_error(_("misplaced `module'"));
	    return T_MODULE;
 }
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 679 "lex.l"
return T_BYE;
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 680 "lex.l"
return T_DCLEX;
	YY_BREAK
case 79:
YY_RULE_SETUP
#line 682 "lex.l"
{ return builtin_const(yytext, yyleng); }
	YY_BREAK

case 80:
YY_RULE_SETUP
#line 685 "lex.l"
return T_POLL;
	YY_BREAK
case 81:
YY_RULE_SETUP
#line 686 "lex.l"
return T_HOST;
	YY_BREAK
case 82:
YY_RULE_SETUP
#line 687 "lex.l"
return T_AS;
	YY_BREAK

/* Variables */

case 83:
YY_RULE_SETUP
#line 692 "lex.l"
{
		return builtin_const(yytext + 1, yyleng - 1);
	}
	YY_BREAK
case 84:
YY_RULE_SETUP
#line 695 "lex.l"
{
		return builtin_const(yytext + 2, yyleng - 3);
	}
	YY_BREAK


case 85:
YY_RULE_SETUP
#line 701 "lex.l"
{
		compose_add_builtin_const(yytext + 1, yyleng - 1);
	}
	YY_BREAK
case 86:
YY_RULE_SETUP
#line 704 "lex.l"
{
		compose_add_builtin_const(yytext + 2, yyleng - 3);
	}
	YY_BREAK
case 87:
YY_RULE_SETUP
#line 707 "lex.l"
{
		string(yytext + 1, yyleng - 1);
		compose_add_variable_or_const(variable_or_const());
	}
	YY_BREAK
case 88:
YY_RULE_SETUP
#line 711 "lex.l"
{
		string(yytext + 2, yyleng - 3);
		compose_add_variable_or_const(variable_or_const());
	}
	YY_BREAK

/* Positional arguments */

case 89:
YY_RULE_SETUP
#line 719 "lex.l"
return T_ARGCOUNT;
	YY_BREAK
case 90:
YY_RULE_SETUP
#line 720 "lex.l"
return getnum(T_ARG, 1, 0);
	YY_BREAK
case 91:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp = yy_bp + 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 721 "lex.l"
return T_ARGX;
	YY_BREAK
case 92:
YY_RULE_SETUP
#line 722 "lex.l"
return T_ARGV;
	YY_BREAK


case 93:
YY_RULE_SETUP
#line 726 "lex.l"
{
		compose_add_node(create_node_argcount(&yylloc));
	}
	YY_BREAK
case 94:
YY_RULE_SETUP
#line 729 "lex.l"
{
		compose_add_node(create_node_arg(strtol(yytext + 1, NULL, 0),
						 &yylloc));
	}
	YY_BREAK

/* Sendmail variables */

case 95:
YY_RULE_SETUP
#line 737 "lex.l"
{
		if (yyleng == 2)
			string(yytext + 1, 1);
		else {
			line_begin();
			line_add("{", 1);
			line_add(yytext + 1, yyleng - 1);
			line_add("}", 1);
			line_finish();
		}
		return T_SYMBOL;
	}
	YY_BREAK
case 96:
YY_RULE_SETUP
#line 749 "lex.l"
{
		string(yytext+1, yyleng - 1); return T_SYMBOL;
	}
	YY_BREAK


case 97:
YY_RULE_SETUP
#line 755 "lex.l"
{
		if (yyleng == 2)
			string(yytext + 1, 1);
		else {
			line_begin();
			line_add("{", 1);
			line_add(yytext + 1, yyleng - 1);
			line_add("}", 1);
			line_finish();
		}
		compose_add_node(create_node_symbol(yylval.literal, &yylloc));
	}
	YY_BREAK
case 98:
YY_RULE_SETUP
#line 767 "lex.l"
{
		string(yytext+1, yyleng - 1);
		compose_add_node(create_node_symbol(yylval.literal, &yylloc));
	}
	YY_BREAK

/* Back-references */
case 99:
YY_RULE_SETUP
#line 773 "lex.l"
{ return getnum(T_BACKREF, 1, 0); }
	YY_BREAK
case 100:
YY_RULE_SETUP
#line 774 "lex.l"
{
	compose_add_node(create_node_backref(strtoul(yytext+1, NULL, 10),
					     &yylloc)); }
	YY_BREAK
/* Numeric strings */
case 101:
YY_RULE_SETUP
#line 778 "lex.l"
{ return getnum(T_NUMBER, 0, 16); }
	YY_BREAK
case 102:
YY_RULE_SETUP
#line 779 "lex.l"
{ return getnum(T_NUMBER, 0, 8); }
	YY_BREAK
case 103:
YY_RULE_SETUP
#line 780 "lex.l"
{ return getnum(T_NUMBER, 0, 10); }
	YY_BREAK
/* Identifiers */
case 104:
YY_RULE_SETUP
#line 782 "lex.l"
return T_SED;
	YY_BREAK
case 105:
YY_RULE_SETUP
#line 783 "lex.l"
{
	const struct constant *cptr;

	cptr = constant_lookup(yytext);
	if (cptr) {
		const struct value *value_ptr = &cptr->value;
		switch (value_ptr->type) {
		case dtype_number:
			yylval.number = value_ptr->v.number;
			return T_NUMBER;

		case dtype_string:
			yylval.literal = value_ptr->v.literal;
			return T_STRING;

		default:
			abort();
		}
	}

	if (yylval.builtin = builtin_lookup(yytext))
		return T_BUILTIN;
	else if (yylval.function = function_lookup(yytext))
		return T_FUNCTION;
	else {
		struct variable *vptr;
		string(yytext, yyleng);
		vptr = variable_lookup(yylval.literal->text);
		if (!vptr) {
			return T_IDENTIFIER;
		}
		add_xref(vptr, &yylloc);
		yylval.var = vptr;
		return T_VARIABLE;
	}
}
	YY_BREAK
/* Strings */
case 106:
YY_RULE_SETUP
#line 820 "lex.l"
{
	string(yytext+1, yyleng-2);
	return T_STRING;
 }
	YY_BREAK
case 107:
YY_RULE_SETUP
#line 824 "lex.l"
{
	string(yytext+1, yyleng-2);
	return T_STRING;
 }
	YY_BREAK
case 108:
/* rule 108 can match eol */
YY_RULE_SETUP
#line 828 "lex.l"
{
	compose_start(STR);
	compose_add_string(yytext + 1, yyleng - 3);
 }
	YY_BREAK
case 109:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 832 "lex.l"
{
	compose_start(STR);
	compose_add_string(yytext+1, yyleng-1);
 }
	YY_BREAK
case 110:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp = yy_bp + 5;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 836 "lex.l"
{
	compose_start(STR);
	line_add_char(strtoul(yytext + 3, NULL, 16));
	compose_add_literal(string_finish());
 }
	YY_BREAK
case 111:
YY_RULE_SETUP
#line 841 "lex.l"
{
	compose_start(STR);
	line_add_char(strtoul(yytext + 3, NULL, 16));
 }
	YY_BREAK
case 112:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 846 "lex.l"
{
	compose_start(STR);
	line_add_char(strtoul(yytext + 3, NULL, 8));
	compose_add_literal(string_finish());
 }
	YY_BREAK
case 113:
YY_RULE_SETUP
#line 851 "lex.l"
{
	compose_start(STR);
	line_add_char(strtoul(yytext + 3, NULL, 8));
 }
	YY_BREAK
case 114:
/* rule 114 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
YY_LINENO_REWIND_TO(yy_bp + 3);
(yy_c_buf_p) = yy_cp = yy_bp + 3;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 856 "lex.l"
{
	compose_start(STR);
	line_add_char(c_unescape(yytext[2]));
	compose_add_literal(string_finish());
 }
	YY_BREAK
case 115:
/* rule 115 can match eol */
YY_RULE_SETUP
#line 861 "lex.l"
{
	compose_start(STR);
	line_add_char(c_unescape(yytext[2]));
 }
	YY_BREAK

case 116:
/* rule 116 can match eol */
YY_RULE_SETUP
#line 867 "lex.l"
{ line_add(yytext, yyleng - 2); }
	YY_BREAK
case 117:
YY_RULE_SETUP
#line 868 "lex.l"
{
		BEGIN(INITIAL);
		if (yyleng > 1)
			line_add(yytext, yyleng - 1);
		compose_add_literal(string_finish());
		return compose_finish();
	}
	YY_BREAK
case 118:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 875 "lex.l"
{
		line_add(yytext, yyleng);
		compose_add_literal(string_finish());
		line_begin();
	}
	YY_BREAK


case 119:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp = yy_bp + 4;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 883 "lex.l"
{
		line_add_char(strtoul(yytext + 2, NULL, 16));
		compose_add_literal(string_finish());
		line_begin();
	}
	YY_BREAK
case 120:
YY_RULE_SETUP
#line 888 "lex.l"
{
		line_add_char(strtoul(yytext + 2, NULL, 16));
	}
	YY_BREAK
case 121:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 891 "lex.l"
{
		line_add_char(strtoul(yytext + 2, NULL, 8));
		compose_add_literal(string_finish());
		line_begin();
	}
	YY_BREAK
case 122:
YY_RULE_SETUP
#line 896 "lex.l"
{
		line_add_char(strtoul(yytext + 2, NULL, 8));
	}
	YY_BREAK
case 123:
/* rule 123 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
YY_LINENO_REWIND_TO(yy_bp + 2);
(yy_c_buf_p) = yy_cp = yy_bp + 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 899 "lex.l"
{
		line_add_char(c_unescape(yytext[1]));
		compose_add_literal(string_finish());
		line_begin();
	}
	YY_BREAK
case 124:
/* rule 124 can match eol */
YY_RULE_SETUP
#line 904 "lex.l"
{
		line_add_char(c_unescape(yytext[1]));
	}
	YY_BREAK

/* Multi-line strings */
case 125:
/* rule 125 can match eol */
#line 911 "lex.l"
case 126:
/* rule 126 can match eol */
YY_RULE_SETUP
#line 911 "lex.l"
{
	char *p;

	char_to_strip = NULL;
	multiline_unescape = 1;

	line_begin();
	p = yytext + 2;
	if (*p == '-') {
		++p;
		if (*p == ' ') {
			++p;
			char_to_strip = is_space;
		} else
			char_to_strip = is_tab;
	}

	if (*p == '\\') {
		p++;
		multiline_unescape = 0;
	}
	if (*p == '\'') {
		char *q;

		p++;
		multiline_unescape = 0;
		q = strchr(p, '\'');
		multiline_delimiter_len = q - p;
	} else
		multiline_delimiter_len = strcspn(p, " \t");

	multiline_delimiter = mu_alloc(multiline_delimiter_len + 1);
	memcpy(multiline_delimiter, p, multiline_delimiter_len);
	multiline_delimiter[multiline_delimiter_len] = 0;
	if (multiline_unescape)
		compose_start(ML);
	else
		compose_start(QML);
}
	YY_BREAK
/* Quoted multilines */
case 127:
/* rule 127 can match eol */
YY_RULE_SETUP
#line 951 "lex.l"
{
	char *p;

	p = yytext;
	if (char_to_strip)
	       for (; char_to_strip (*p); p++)
		      ;

	if (strlen(p) >= multiline_delimiter_len
	    && memcmp(p, multiline_delimiter, multiline_delimiter_len) == 0
	    && isemptystr(p + multiline_delimiter_len)) {
		free (multiline_delimiter);
		multiline_delimiter = NULL;
		multiline_delimiter_len = 0;
		BEGIN(INITIAL);
		compose_add_literal(string_finish());
		return compose_finish();
	}
	line_add(p, strlen(p));
}
	YY_BREAK
/* Unquoted multilines */
case 128:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 973 "lex.l"
{
	char *p = yytext;
	if (char_to_strip)
	       for (; char_to_strip (*p); p++)
		      ;
	line_add(p, strlen(p));
	compose_add_literal(string_finish());
	BEGIN_X(CML);
}
	YY_BREAK
case 129:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 982 "lex.l"
{
	line_add(yytext, yyleng);
	compose_add_literal(string_finish());
	line_begin();
}
	YY_BREAK
case 130:
YY_RULE_SETUP
#line 987 "lex.l"
{
	line_add(yytext, 1);
	compose_add_literal(string_finish());
	line_begin();
}
	YY_BREAK
case 131:
YY_RULE_SETUP
#line 992 "lex.l"
{
	line_add(yytext, yyleng);
}
	YY_BREAK

case 132:
/* rule 132 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
YY_LINENO_REWIND_TO(yy_cp - 1);
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 996 "lex.l"
{
		char *p;

		p = yytext;
		if (char_to_strip)
			for (; char_to_strip (*p); p++)
				;

		if (strlen(p) >= multiline_delimiter_len
		    && memcmp(p, multiline_delimiter, multiline_delimiter_len) == 0
		    && isemptystr(p + multiline_delimiter_len)) {
			free(multiline_delimiter);
			multiline_delimiter = NULL;
			multiline_delimiter_len = 0;
			BEGIN(INITIAL);
			compose_add_literal(string_finish());
			return compose_finish();
		}
		line_add(p, strlen(p));
		compose_add_literal(string_finish());
	}
	YY_BREAK
case 133:
/* rule 133 can match eol */
YY_RULE_SETUP
#line 1017 "lex.l"
{
		char *p;

		p = yytext;
		if (char_to_strip)
			for (; char_to_strip (*p); p++)
				;

		if (strlen(p) >= multiline_delimiter_len
		    && memcmp(p, multiline_delimiter, multiline_delimiter_len) == 0
		    && isemptystr(p + multiline_delimiter_len)) {
			free(multiline_delimiter);
			multiline_delimiter = NULL;
			multiline_delimiter_len = 0;
			BEGIN(INITIAL);
			compose_add_literal(string_finish());
			return compose_finish();
		}
		line_add(p, strlen(p));
	}
	YY_BREAK

case 134:
/* rule 134 can match eol */
YY_RULE_SETUP
#line 1039 "lex.l"
{
	if (yyleng >= multiline_delimiter_len
	    && memcmp(yytext, multiline_delimiter,
		      multiline_delimiter_len) == 0
	    && isemptystr(yytext + multiline_delimiter_len)) {
	       free (multiline_delimiter);
	       multiline_delimiter = NULL;
	       multiline_delimiter_len = 0;
	       BEGIN(INITIAL);
	       compose_add_literal(string_finish());
	       return compose_finish();
	}
	line_add(yytext, yyleng);
	BEGIN_X(ML);
}
	YY_BREAK
/* Other tokens */
case 135:
YY_RULE_SETUP
#line 1055 "lex.l"
;
	YY_BREAK
case 136:
/* rule 136 can match eol */
YY_RULE_SETUP
#line 1056 "lex.l"
;
	YY_BREAK
case 137:
YY_RULE_SETUP
#line 1057 "lex.l"
return T_EQ;
	YY_BREAK
case 138:
YY_RULE_SETUP
#line 1058 "lex.l"
return T_NE;
	YY_BREAK
case 139:
YY_RULE_SETUP
#line 1059 "lex.l"
return T_LT;
	YY_BREAK
case 140:
YY_RULE_SETUP
#line 1060 "lex.l"
return T_LE;
	YY_BREAK
case 141:
YY_RULE_SETUP
#line 1061 "lex.l"
return T_GT;
	YY_BREAK
case 142:
YY_RULE_SETUP
#line 1062 "lex.l"
return T_GE;
	YY_BREAK
case 143:
YY_RULE_SETUP
#line 1063 "lex.l"
return T_LOGAND;
	YY_BREAK
case 144:
YY_RULE_SETUP
#line 1064 "lex.l"
return T_LOGOR;
	YY_BREAK
case 145:
YY_RULE_SETUP
#line 1065 "lex.l"
return T_LOGXOR;
	YY_BREAK
case 146:
YY_RULE_SETUP
#line 1066 "lex.l"
return T_LOGNOT;
	YY_BREAK
case 147:
YY_RULE_SETUP
#line 1067 "lex.l"
return T_SHL;
	YY_BREAK
case 148:
YY_RULE_SETUP
#line 1068 "lex.l"
return T_SHR;
	YY_BREAK
case 149:
YY_RULE_SETUP
#line 1069 "lex.l"
return T_DOTS;
	YY_BREAK
case 150:
YY_RULE_SETUP
#line 1070 "lex.l"
/* If a here-document is not closed and its next line does not
	       end with a \n, prevent it from being displayed by ECHO */;
	YY_BREAK
case 151:
YY_RULE_SETUP
#line 1072 "lex.l"
return yytext[0];
	YY_BREAK
case 152:
YY_RULE_SETUP
#line 1073 "lex.l"
ECHO;
	YY_BREAK
#line 3498 "lex.c"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(COMMENT):
case YY_STATE_EOF(STR):
case YY_STATE_EOF(ML):
case YY_STATE_EOF(CML):
case YY_STATE_EOF(QML):
case YY_STATE_EOF(XIDENT):
case YY_STATE_EOF(SHELLMAGIC):
case YY_STATE_EOF(ONBLOCK):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
/* %if-c-only */
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
/* %endif */
/* %if-c++-only */
/* %endif */
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
/* %% [14.0] code to do back-up for compressed tables and set up yy_cp goes here */
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */
/* %ok-for-header */

/* %if-c++-only */
/* %not-for-header */

/* %ok-for-header */

/* %endif */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
/* %if-c-only */
static int yy_get_next_buffer (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = (yytext_ptr);
	yy_size_t number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (yy_size_t) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			yy_size_t num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				yy_size_t new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart(yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yy_size_t) ((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

/* %if-c-only */
/* %not-for-header */

    static yy_state_type yy_get_previous_state (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
	yy_state_type yy_current_state;
	char *yy_cp;
    
/* %% [15.0] code to get the start state into yy_current_state goes here */
	yy_current_state = (yy_start);
	yy_current_state += YY_AT_BOL();

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
/* %% [16.0] code to find the next state goes here */
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 984 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
/* %if-c-only */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
/* %endif */
/* %if-c++-only */
/* %endif */
{
	int yy_is_jam;
    /* %% [17.0] code to find the next state, and perhaps do backing up, goes here */
	char *yy_cp = (yy_c_buf_p);

	YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 984 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 983);

		return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT
/* %if-c-only */

/* %endif */
#endif

/* %if-c-only */
#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

/* %endif */
/* %if-c++-only */
/* %endif */
{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			yy_size_t offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart(yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

/* %% [19.0] update BOL and yylineno */
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = (c == '\n');

	return c;
}
/* %if-c-only */
#endif	/* ifndef YY_NO_INPUT */
/* %endif */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
/* %if-c-only */
    void yyrestart  (FILE * input_file )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer(yyin,YY_BUF_SIZE );
	}

	yy_init_buffer(YY_CURRENT_BUFFER,input_file );
	yy_load_buffer_state( );
}

/* %if-c++-only */
/* %endif */

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
/* %if-c-only */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

/* %if-c-only */
static void yy_load_buffer_state  (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
/* %if-c-only */
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
/* %endif */
/* %if-c++-only */
/* %endif */
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
/* %if-c-only */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
/* %endif */
/* %if-c++-only */
/* %endif */
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = (yy_size_t)size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer(b,file );

	return b;
}

/* %if-c++-only */
/* %endif */

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
/* %if-c-only */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree((void *) b->yy_ch_buf  );

	yyfree((void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
/* %if-c-only */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )
/* %endif */
/* %if-c++-only */
/* %endif */

{
	int oerrno = errno;
    
	yy_flush_buffer(b );

/* %if-c-only */
	b->yy_input_file = file;
/* %endif */
/* %if-c++-only */
/* %endif */
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

/* %if-c-only */

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
/* %endif */
/* %if-c++-only */
/* %endif */
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
/* %if-c-only */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( );
}

/* %if-c-or-c++ */
/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
/* %if-c-only */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}
/* %endif */

/* %if-c-or-c++ */
/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
/* %if-c-only */
void yypop_buffer_state (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}
/* %endif */

/* %if-c-or-c++ */
/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
/* %if-c-only */
static void yyensure_buffer_stack (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1; // After all that talk, this was set to 1 anyways...
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );
								  
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}
/* %endif */

/* %if-c-only */
/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer(b  );

	return b;
}
/* %endif */

/* %if-c-only */
/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (yyconst char * yystr )
{
    
	return yy_scan_bytes(yystr,strlen(yystr) );
}
/* %endif */

/* %if-c-only */
/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (yyconst char * yybytes, yy_size_t  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	yy_size_t i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) yyalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}
/* %endif */

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

/* %if-c-only */
static void yy_fatal_error (yyconst char* msg )
{
			(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}
/* %endif */
/* %if-c++-only */
/* %endif */

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/* %if-c-only */
/* %if-reentrant */
/* %endif */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
        
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
yy_size_t yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/* %if-reentrant */
/* %endif */

/** Set the current line number.
 * @param _line_number line number
 * 
 */
void yyset_lineno (int  _line_number )
{
    
    yylineno = _line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str )
{
        yyin = _in_str ;
}

void yyset_out (FILE *  _out_str )
{
        yyout = _out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  _bdebug )
{
        yy_flex_debug = _bdebug ;
}

/* %endif */

/* %if-reentrant */
/* %if-bison-bridge */
/* %endif */
/* %endif if-c-only */

/* %if-c-only */
static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    (yy_buffer_stack) = 0;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = (char *) 0;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = (FILE *) 0;
    yyout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}
/* %endif */

/* %if-c-only SNIP! this currently causes conflicts with the c++ scanner */
/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

/* %if-reentrant */
/* %endif */
    return 0;
}
/* %endif */

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
			return (void *) malloc( size );
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void yyfree (void * ptr )
{
			free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

/* %if-tables-serialization definitions */
/* %define-yytables   The name for this specific scanner's tables. */
#define YYTABLES_NAME "yytables"
/* %endif */

/* %ok-for-header */

#line 1073 "lex.l"



int
yylex()
{
	int rc = lexscan();
	if (rc != T_MODBEG && rc != T_MODEND)
		inctx_flags |= INCTX_HADINPUT;
	return rc;
}

void
init_string_space()
{
	mu_opool_create(&string_pool, MU_OPOOL_ENOMEMABRT);
}

void
free_string_space()
{
	mu_opool_destroy(&string_pool);
}

char *
mf_strdup(const char *str)
{
	string_add(str, strlen(str) + 1);
	return mu_opool_finish(string_pool, NULL);
}

struct literal *
string_alloc(const char *str, size_t len)
{
	string_begin();
	string_add(str, len);
	return string_finish();
}

static void
string(const char *str, size_t len)
{
	yylval.literal = string_alloc(str, len);
}

void
string_begin()
{
	/* nothing */
}

struct literal *
string_finish()
{
	char *ptr;
	struct literal *lit;
	mu_opool_append_char(string_pool, 0);
	ptr = mu_opool_finish(string_pool, NULL);
	lit = literal_lookup(ptr);
	if (lit->text != ptr)
		mu_opool_free(string_pool, ptr);
	return lit;
}

static void
line_finish()
{
	yylval.literal = string_finish();
	if (yy_flex_debug)
		fprintf(stderr, "constructed line: %s\n",
			yylval.literal->text);
}

void
string_add(const char *str, size_t len)
{
	mu_opool_append(string_pool, str, len);
}

void
string_add_char(unsigned char c)
{
	mu_opool_append_char(string_pool, c);
}

void
parse_warning(const char *fmt, ...)
{
	va_list ap;
	va_start(ap, fmt);
	mu_diag_voutput (MU_DIAG_WARNING, fmt, ap);
	va_end(ap);
}

void
parse_warning_locus(struct mu_locus_range const *loc, const char *fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	mu_vdiag_at_locus_range(MU_DIAG_WARNING, loc, fmt, ap);
	va_end(ap);
}

void
parse_error(const char *fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	mu_diag_voutput(MU_DIAG_ERROR, fmt, ap);
	va_end(ap);
	error_count++;
}

void
parse_error_locus(struct mu_locus_range const *loc, const char *fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	mu_vdiag_at_locus_range(MU_DIAG_ERROR, loc, fmt, ap);
	va_end(ap);
	error_count++;
}



static int
lex_close_source()
{
	if (!yyin)
		return 1;
	if (preprocessor.enabled)
		pp_extrn_shutdown(yyin, pp_pid);
	else
		fclose(yyin);
	yyin = NULL;
	mu_linetrack_destroy(&trk);

	switch (YYSTATE) {
	case INITIAL:
		/* ok */
		break;

	case COMMENT:
		mu_diag_at_locus_point (MU_DIAG_ERROR, &start_locus,
					"%s", _("end of file in comment"));
		break;

	case STR:
	case ML:
	case CML:
	case QML:
		mu_diag_at_locus_point (MU_DIAG_ERROR, &start_locus,
					"%s", _("end of file in string"));
		break;

	case SHELLMAGIC:
		mu_diag_at_locus_point (MU_DIAG_ERROR, &start_locus,
					"%s", _("end of file in shell block"));
		break;
	}
	return inctx_pop();
}

void
lex_drain_input()
{
	int c;
	while ((c = input()) != 0 && c != EOF)
		;
}

void
lex_bye()
{
	lex_drain_input();
	lex_close_source();
}

int
yywrap()
{
	if (yy_flex_debug && top_module)
		fprintf(stderr, "--eof in module %s\n", top_module->name);
	if (inctx_flags & INCTX_MODULE)
		emit_token = T_MODEND;
	return lex_close_source();
}

static int
isemptystr(char *text)
{
	for (; *text && mu_isspace (*text); text++)
		;
	return *text == 0;
}

void
tie_in_onblock(int enable)
{
	if (enable)
		BEGIN(ONBLOCK);
	else
		BEGIN(INITIAL);
}

data_type_t
builtin_const_value(const char *s, size_t len, const char **sval, long *nval)
{
	if (strncmp(s, "__file__", len) == 0) {
		struct literal *lit = literal_lookup(yylloc.beg.mu_file);
		*sval = lit->text;
		return dtype_string;
	} else if (strncmp(s, "__line__", len) == 0) {
		*nval = yylloc.beg.mu_line;
		return dtype_number;
	} else if (strncmp(s, "__function__", len) == 0) {
		*sval = function_name();
		return dtype_string;
	} else if (strncmp(s, "__package__", len) == 0) {
		*sval = PACKAGE_TARNAME;
		return dtype_string;
	} else if (strncmp(s, "__version__", len) == 0) {
		*sval = PACKAGE_VERSION;
		return dtype_string;
	} else if (strncmp(s, "__major__", len) == 0) {
		*nval = MAILFROMD_VERSION_MAJOR;
		return dtype_number;
	} else if (strncmp(s, "__minor__", len) == 0) {
		*nval = MAILFROMD_VERSION_MINOR;
		return dtype_number;
	} else if (strncmp(s, "__patch__", len) == 0) {
		*nval = MAILFROMD_VERSION_PATCH;
		return dtype_number;
	} else if (strncmp(s, "__git__", len) == 0) {
#ifdef GIT_DESCRIBE
		*sval = GIT_DESCRIBE;
#else
		*sval = "";
#endif
		return dtype_string;
	} else if (strncmp(s, "__statedir__", len) == 0) {
		*sval = mailfromd_state_dir;
		return dtype_string;
	} else if (strncmp(s, "__defstatedir__", len) == 0) {
		*sval = DEFAULT_STATE_DIR;
		return dtype_string;
	} else if (strncmp(s, "__preproc__", len) == 0) {
		*sval = (preprocessor.enabled && preprocessor.command)
			   ? preprocessor.command : "";
		return dtype_string;
	} else if (strncmp(s, "__defpreproc__", len) == 0) {
		*sval = DEF_EXT_PP ? DEF_EXT_PP : "";
		return dtype_string;
	} else if (strncmp(s, "__module__", len) == 0) {
		*sval = top_module->dclname ? top_module->dclname : top_module->name;
		return dtype_string;
	}
	return dtype_unspecified;
}

int
builtin_const(const char *s, size_t len)
{
	const char *sval;
	long nval;

	switch (builtin_const_value(s, len, &sval, &nval)) {
	case dtype_number:
		yylval.number = nval;
		return T_NUMBER;

	case dtype_string:
		string(sval, strlen(sval));
		return T_STRING;

	default:
		abort();
	}
	return T_BOGUS;
}

const char *
symbit_to_qualifier(unsigned f)
{
	switch (f) {
	case SYM_PRECIOUS:
		return "precious";
	case SYM_STATIC:
		return "static";
	case SYM_PUBLIC:
		return "public";
	}
	return NULL;
}

/* End of lex.l */

