
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileGribDecoderAttributes.h
    \brief Definition of GribDecoder Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef GribDecoderAttributes_H
#define GribDecoderAttributes_H

#include "magics.h"
#include "GribAddressMode.h"
#include "WindMode.h"
namespace magics {

class XmlNode;
class GribDecoderAttributes 
{
public:
//  --  constructor
    GribDecoderAttributes();
    
//  --  destructor
    virtual ~GribDecoderAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const GribDecoderAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	string file_name_;
	string first_file_name_;
	string colour_file_name_;
	string second_file_name_;
	string id_;
	bool loop_;
	bool scaling_;
	bool derived_scaling_;
	double scaling_factor_;
	double scaling_offset_;
	double regular_resolution_;
	string interpolation_method_;
	int missing_fill_count_;
	bool expver_;
	bool units_;
	int field_position_;
	unsigned long long large_field_position_;
	int position_1_;
	int position_2_;
	int colour_position_;
	unsigned long long large_position_1_;
	unsigned long long large_position_2_;
	unsigned long long large_colour_position_;
	double missing_value_;
	bool wind_style_;
	unique_ptr<GribAddressMode> address_mode_;
	unique_ptr<WindMode> wind_mode_;
	 

private:
	friend ostream& operator<<(ostream& s,const GribDecoderAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

