/*
 * $Id: ActionFormBean.java 54929 2004-10-16 16:38:42Z germuska $ 
 *
 * Copyright 2000-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.apache.struts.action;


import org.apache.struts.config.FormBeanConfig;


/**
 * <p>An <strong>ActionFormBean</strong> is the definition of a form bean that
 * is loaded from a <code>&lt;form-bean&gt;</code> element in the Struts
 * configuration file. It can be subclassed as necessary to add additional
 * properties.</p>
 *
 * <p>Since Struts 1.1 <code>ActionFormBean</code> extends <code>FormBeanConfig</code>.</p>
 *
 * <p><strong>NOTE</strong> - This class would have been deprecated and
 * replaced by <code>org.apache.struts.config.FormBeanConfig</code> except
 * for the fact that it is part of the public API that existing applications
 * are using.</p>
 *
 * @version $Rev: 54929 $ $Date: 2004-10-16 17:38:42 +0100 (Sat, 16 Oct 2004) $
 */
public class ActionFormBean extends FormBeanConfig {


    /**
     * <p>Construct an instance with default vaslues.</p>
     */
    public ActionFormBean() {

        super();

    }


    /**
     * <p>Construct an instance with the specified values.</p>
     *
     * @param name Form bean name
     * @param type Fully qualified class name
     */
    public ActionFormBean(String name, String type) {

        super();
        setName(name);
        setType(type);

    }


}
