//
// File: test_c13n15.cpp
// Created by: Olivier Langella
// Created on: 12/7/2023
//
/*******************************************************************************
 * Copyright (c) 2023 Olivier Langella
 *<Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/


// ./tests/dia/catch2-only-dia [soleil] -s


#include <catch2/catch_test_macros.hpp>
#include <catch2/matchers/catch_matchers_vector.hpp>
#include <pappsomspp/vendors/tims/timsframe.h>
#include <pappsomspp/msrun/private/timsmsrunreaderms2.h>

#include <QDebug>
#include "../common.h"
#include "tests/config.h"
#include "dia_lib.h"


TEST_CASE("soleil test suite.", "[soleil]")
{
  // Set the debugging message formatting pattern.
  qSetMessagePattern(QString("%{file}@%{line}, %{function}(): %{message}"));


  SECTION("Test TIMS TDF parsing")
  {
    INFO("Test case mobility trace extractor");

    pappso::MsFileAccessor accessor(
      "/gorgone/pappso/versions_logiciels_pappso/bruker/"
      "200ngHeLaPASEF_2min_compressed.d/analysis.tdf",
      "a1");


    accessor.setPreferredFileReaderType(pappso::MsDataFormat::brukerTims,
                                        pappso::FileReaderType::tims_ms2);


    pappso::MsRunReaderSPtr p_ms_data_file =
      accessor.msRunReaderSPtr(accessor.getMsRunIds().front());
    pappso::TimsMsRunReaderMs2 *p_msreader_tims_ms2 =
      dynamic_cast<pappso::TimsMsRunReaderMs2 *>(p_ms_data_file.get());
    /*
     * 36	1101.0713085818	1101.2352981594	1100.56987430806	2	206.34670754313
27481.0	7

37	1032.50460066644	1032.61931820008	1032.00354342756	2
255.636031950547	7776.0	7

38	849.889511073675	850.36577904552
849.889511073675	2	301.081436858545	10674.0	7

39	732.368888386124
732.7994188422	732.368888386124	2	366.846506680738	171577.0	7


40 613.834985672256	614.145093980785	613.834985672256	2	408.353586866372
100182.0	7

41	590.663111414989	590.993423163968	590.663111414989	3
480.650093737275	11285.0	7

42	1186.54230445333	1186.72886658555
1186.04087739917	2	209.745072692947	3388.0	7

43	675.889879111058
676.29815138184	675.889879111058	2	357.036750108284	78563.0	7

44
625.325372791376	625.579928168419	625.325372791376	1	408.432368202426
103456.0	7

45	1007.51213556948	1007.6267841152	1007.01070658348	2
247.074788254945	7187.0	7

46	913.959890656205	913.979678622373
913.458905261467	2	294.654254399024	8314.0	7 47	755.38529656205
755.841674769364	755.38529656205	2	353.86257989541	12945.0	7

48
591.302490003786	591.590497194694	591.302490003786	2	403.254182106694
29830.0	7

49	595.771231095101	596.059238283215	595.771231095101	2
446.612758885196	9435.0	7

50	413.752273442763	413.939477660886
413.752273442763	1	509.25342989311	6639.0	7 51	762.399893323618
762.856367409854	762.399893323618	2	322.644976866487	8675.0	7 52
735.843048722056	736.273579192029	735.843048722056	2	373.54662077597 18891.0
7 53	568.32624886187	568.614256051375	568.32624886187	2	429.363085740713
10674.0	7 54	643.816041172731	644.126137985901	643.816041172731	2
399.427994121969	15462.0	7 55	687.390246797748	687.798519066724
687.390246797748	2	363.680236411293	11928.0	7 56	562.806530794766
563.094537974134	562.806530794766	2	405.175837742504	13135.0	7 57
546.269682718966	546.539497651969	546.269682718966	2	450.784556792487 7570.0
7 58	509.960123743293	510.26725044115	509.960123743293	3	496.035031847134
6328.0	7 59	883.463248838573	883.962935681494	883.463248838573	2
225.932830827769	5538.0	7 60	938.950034464637	938.969822427669
938.4490490699	2	300.353033535402	7770.0	7 61	729.330713601629
729.761244061435	729.330713601629	2	378.503772398617	10847.0	7 62
578.827527999194	579.115535190246	578.827527999194	2	418.782881695176 8674.0
7 63	497.283111759912	497.529947222637	497.283111759912	2	467.090705461384
7569.0	7 64	417.732442590361	417.732442590361			514.431244560487	3550.0
7 65	874.942898591935	875.442503475723	874.942898591935	2	305.569882347679
6660.0	7 66	751.906613734472	752.363087819094	751.906613734472	2
352.740672716387	9542.0	7 67	791.370289287521	791.490672694711
791.036000584609	3	396.117318241086	8795.0	7 68	455.606517405094
455.889596549243	455.606517405094	3	497.462564102564	5917.0	7
     * */
    pappso::TimsFrameCstSPtr timsframe_sptr;
    timsframe_sptr =
      p_msreader_tims_ms2->getTimsDataSPtr().get()->getTimsFrameCstSPtr(13);
    // LVSNHSLHETSSVFVDSLTK 71
    // prec 36	1101.0713085818	1101.2352981594	1100.56987430806	2
    // 206.34670754313	27481.0	7
    // frameprec 13	194	219 1101.2352981594	3.0	68.0 36

    /*
     *
      <peptide id="pd3148" seq="LVSNHSLHETSSVFVDSLTK"/>
              <peptide_evidence id="peb34" peptide_id="pd3148" idx="71"
     rt="2402.244825" eng="1" evalue="2.25835e-09" exp_mass="2199.125195"
     charge="2" checked="true"> <param key="0" value="44.2"/> <param key="1"
     value="2.25835e-09"/>
              </peptide_evidence>*/

    // AWGPGLEGGVVGK 79
    // prec 40	613.834985672256	614.145093980785	613.834985672256	2
    // 408.353586866372	100182.0	7
    // frameprec 13	396	421 614.145093980785	2.0	42.0	40
    /*
     *
        <peptide id="pd1376" seq="AWGPGLEGGVVGK"/>
                <peptide_evidence id="peb38" peptide_id="pd1376" idx="79"
     rt="2402.244825" eng="1" evalue="3.55081e-06" exp_mass="1225.655418"
     charge="2" checked="true"> <param key="0" value="42"/> <param key="1"
     value="3.55081e-06"/>
                </peptide_evidence>*/

    // AVEGC[MOD:00397]VSASQAATEDGQLLR 73
    // prec 37	1032.50460066644	1032.61931820008	1032.00354342756	2
    // 255.636031950547	7776.0	7
    // frameprec 13	243	268  1032.61931820008	3.0	58.0	37
    // 14	243	268	1032.61931820008	3.0	58.0	37
    // 16	243	268	1032.61931820008	3.0	58.0	37
    /*
     *
        <peptide id="pd1946" seq="AVEGCVSASQAATEDGQLLR">
            <mod ref="moda6" position="4" aa="C"/>
        </peptide>
                <peptide_evidence id="peb35" peptide_id="pd1946" idx="73"
     rt="2402.244825" eng="1" evalue="1.25003e-08" exp_mass="2061.992533"
     charge="2" checked="true"> <param key="0" value="38.8"/> <param key="1"
     value="1.25003e-08"/>
                </peptide_evidence>*/

    /*

                <peptide_evidence id="peb34" peptide_id="pd3148" idx="71"
       rt="2402.244825" eng="1" evalue="2.25835e-09" exp_mass="2199.125195"
       charge="2" checked="true"> <param key="0" value="44.2"/> <param key="1"
       value="2.25835e-09"/>
                </peptide_evidence>
                <peptide_evidence id="peb35" peptide_id="pd1946" idx="73"
       rt="2402.244825" eng="1" evalue="1.25003e-08" exp_mass="2061.992533"
       charge="2" checked="true"> <param key="0" value="38.8"/> <param key="1"
       value="1.25003e-08"/>
                </peptide_evidence>
                <peptide_evidence id="peb36" peptide_id="pd1997" idx="75"
       rt="2402.244825" eng="1" evalue="3.33021" exp_mass="1697.764469"
       charge="2" checked="true"> <param key="0" value="18.8"/> <param key="1"
       value="3.33021"/>
                </peptide_evidence>
                <peptide_evidence id="peb37" peptide_id="pd1357" idx="77"
       rt="2402.244825" eng="1" evalue="6.40312e-06" exp_mass="1462.723223"
       charge="2" checked="true"> <param key="0" value="32.3"/> <param key="1"
       value="6.40312e-06"/>
                </peptide_evidence>
                <peptide_evidence id="peb38" peptide_id="pd1376" idx="79"
       rt="2402.244825" eng="1" evalue="3.55081e-06" exp_mass="1225.655418"
       charge="2" checked="true"> <param key="0" value="42"/> <param key="1"
       value="3.55081e-06"/>
                </peptide_evidence>
                <peptide_evidence id="peb39" peptide_id="pd1748" idx="81"
       rt="2402.244825" eng="1" evalue="7.82161e-12" exp_mass="1768.967504"
       charge="3" checked="true"> <param key="0" value="48"/> <param key="1"
       value="7.82161e-12"/>

                    */

    pappso::TimsDataFastMap raw_spectrum;
    timsframe_sptr.get()->cumulateScansInRawMap(
      raw_spectrum, 0, timsframe_sptr.get()->getTotalNumberOfScans() - 1);

    pappso::Trace total_spectrum;

    for(auto index : raw_spectrum.tofIndexList)
      {

        total_spectrum.push_back(
          {(double)index, (double)raw_spectrum.readIntensity(index)});
      }
    total_spectrum.sortX();


    std::vector<pappso::TraceCstSPtr> traces;


    total_spectrum.sortY(pappso::SortOrder::descending);

    std::vector<double> mz_index;

    for(auto &datapoint : total_spectrum)
      {
        pappso::Trace trace(
          timsframe_sptr.get()->getIonMobilityTraceByMzIndexRange(
            datapoint.x - 1, datapoint.x + 1, pappso::XicExtractMethod::sum));

        traces.push_back(trace.makeTraceSPtr());
        mz_index.push_back(datapoint.x);
        if(traces.size() >= 1000)
          break;
      }

    writeMobilityTraces("mobility_71_73_79.ods", mz_index, traces);
  }
}
