#include "dia_lib.h"

void
writeMobilityTraces(const QString &filename,
                    const std::vector<double> &mz_index,
                    const std::vector<pappso::TraceCstSPtr> &traces)
{

  QFile file(filename);
  // file.open(QIODevice::WriteOnly);
  OdsDocWriter writer(&file);

  writer.writeSheet("mobility");

  std::size_t i = 0;

  writer.writeLine();
  writer.writeEmptyCell();
  if(traces.size() > 0)
    {
      for(auto datapoint : *(traces[0].get()))
        {
          writer.writeCell(i + 1);
          i++;
        }
    }

  writer.writeLine();
  i = 0;

  for(auto one_trace : traces)
    {
      writer.writeCell(mz_index[i]);

      for(auto datapoint : *(one_trace.get()))
        {
          writer.writeCell(datapoint.y);
        }
      writer.writeLine();
      i++;
    }

  writer.close();
}
