/*******************************************************************************
 * Copyright (c) 2023 Filippo Rusconi
 *<filippo.rusconi@universite-paris-saclay.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/

#pragma once

#include <qobject.h>

namespace pappso
{

class MsRunReadConfig
{

  public:
  MsRunReadConfig();
  MsRunReadConfig(const MsRunReadConfig &other);

  ~MsRunReadConfig();

  MsRunReadConfig &operator=(const MsRunReadConfig &other);

  void setRetentionTimeStart(double retention_time_start);
  double getRetentionTimeStart() const;

  void setRetentionTimeEnd(double retention_time_end);
  double getRetentionTimeEnd() const;

  void setMsLevels(std::vector<std::size_t> ms_levels);
  std::vector<std::size_t> getMsLevels(void);

  private:
  double m_retentionTimeStart = -1;
  double m_retentionTimeEnd   = -1;

  std::vector<std::size_t> m_msLevels = {0};
};

} // namespace pappso
