//===----------------------------------------------------------------------===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is dual licensed under the MIT and the University of Illinois Open
// Source Licenses. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//

// <locale>

// class num_put<charT, OutputIterator>

// iter_type put(iter_type s, ios_base& iob, char_type fill, long double v) const;

#include <locale>
#include <ios>
#include <cassert>
#include <streambuf>
#include <cmath>
#include "test_iterators.h"

typedef std::num_put<char, output_iterator<char*> > F;

class my_facet
    : public F
{
public:
    explicit my_facet(std::size_t refs = 0)
        : F(refs) {}
};

class my_numpunct
    : public std::numpunct<char>
{
public:
    my_numpunct() : std::numpunct<char>() {}

protected:
    virtual char_type do_decimal_point() const {return ';';}
    virtual char_type do_thousands_sep() const {return '_';}
    virtual std::string do_grouping() const {return std::string("\1\2\3");}
};

void test1()
{
    char str[200];
    output_iterator<char*> iter;
    std::locale lc = std::locale::classic();
    std::locale lg(lc, new my_numpunct);
    const my_facet f(1);
    {
        long double v = +0.;
        std::ios ios(0);
        // %g
        {
            ios.precision(0);
            {
                nouppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************+0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************+0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                uppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************+0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************+0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(1);
            {
                nouppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************+0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************+0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                uppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************+0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************+0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(6);
            {
                nouppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.00000******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******************0.00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******************0.00000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;00000******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******************0;00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******************0;00000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.00000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*****************+0.00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*****************0.00000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;00000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*****************+0;00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*****************0;00000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                uppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.00000******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******************0.00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******************0.00000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;00000******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******************0;00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******************0;00000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.00000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*****************+0.00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*****************0.00000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;00000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*****************+0;00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*****************0;00000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(16);
            {
                nouppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.000000000000000********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;000000000000000********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******+0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*******0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******+0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*******0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                uppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.000000000000000********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;000000000000000********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******+0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*******0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******+0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*******0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(60);
            {
                nouppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                uppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

void test2()
{
    char str[200];
    output_iterator<char*> iter;
    std::locale lc = std::locale::classic();
    std::locale lg(lc, new my_numpunct);
    const my_facet f(1);
    {
        long double v = -0.;
        std::ios ios(0);
        // %g
        {
            ios.precision(0);
            {
                nouppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                uppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(1);
            {
                nouppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                uppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(6);
            {
                nouppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.00000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*****************-0.00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*****************0.00000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;00000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*****************-0;00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*****************0;00000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.00000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*****************-0.00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*****************0.00000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;00000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*****************-0;00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*****************0;00000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                uppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.00000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*****************-0.00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*****************0.00000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;00000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*****************-0;00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*****************0;00000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.00000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*****************-0.00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*****************0.00000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;00000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*****************-0;00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*****************0;00000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(16);
            {
                nouppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******-0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*******0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******-0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*******0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******-0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*******0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******-0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*******0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                uppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******-0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*******0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******-0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*******0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******-0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*******0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******-0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*******0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(60);
            {
                nouppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                uppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

void test3()
{
    char str[200];
    output_iterator<char*> iter;
    std::locale lc = std::locale::classic();
    std::locale lg(lc, new my_numpunct);
    const my_facet f(1);
    {
        long double v = 1234567890.125;
        std::ios ios(0);
        // %g
        {
            ios.precision(0);
            {
                nouppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1e+09********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********************1e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********************1e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1e+09********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********************1e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********************1e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1.e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1.e+09*******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******************1.e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******************1.e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1;e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1;e+09*******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******************1;e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******************1;e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1e+09*******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******************+1e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*******************1e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1e+09*******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******************+1e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*******************1e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1.e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1.e+09******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******************+1.e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+******************1.e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1;e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1;e+09******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******************+1;e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+******************1;e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                uppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1E+09********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********************1E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********************1E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1E+09********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********************1E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********************1E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1.E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1.E+09*******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******************1.E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******************1.E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1;E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1;E+09*******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******************1;E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******************1;E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1E+09*******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******************+1E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*******************1E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1E+09*******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******************+1E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*******************1E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1.E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1.E+09******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******************+1.E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+******************1.E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1;E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1;E+09******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******************+1;E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+******************1;E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(1);
            {
                nouppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1e+09********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********************1e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********************1e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1e+09********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********************1e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********************1e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1.e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1.e+09*******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******************1.e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******************1.e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1;e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1;e+09*******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******************1;e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******************1;e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1e+09*******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******************+1e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*******************1e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1e+09*******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******************+1e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*******************1e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1.e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1.e+09******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******************+1.e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+******************1.e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1;e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1;e+09******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******************+1;e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+******************1;e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                uppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1E+09********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********************1E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********************1E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1E+09********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********************1E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********************1E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1.E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1.E+09*******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******************1.E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******************1.E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1;E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1;E+09*******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******************1;E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******************1;E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1E+09*******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******************+1E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*******************1E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1E+09*******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******************+1E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*******************1E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1.E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1.E+09******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******************+1.E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+******************1.E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1;E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1;E+09******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******************+1;E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+******************1;E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(6);
            {
                nouppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1.23457e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1.23457e+09**************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**************1.23457e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**************1.23457e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1;23457e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1;23457e+09**************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**************1;23457e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**************1;23457e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1.23457e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1.23457e+09**************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**************1.23457e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**************1.23457e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1;23457e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1;23457e+09**************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**************1;23457e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**************1;23457e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1.23457e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1.23457e+09*************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*************+1.23457e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*************1.23457e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1;23457e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1;23457e+09*************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*************+1;23457e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*************1;23457e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1.23457e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1.23457e+09*************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*************+1.23457e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*************1.23457e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1;23457e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1;23457e+09*************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*************+1;23457e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*************1;23457e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                uppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1.23457E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1.23457E+09**************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**************1.23457E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**************1.23457E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1;23457E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1;23457E+09**************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**************1;23457E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**************1;23457E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1.23457E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1.23457E+09**************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**************1.23457E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**************1.23457E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1;23457E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1;23457E+09**************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**************1;23457E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**************1;23457E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1.23457E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1.23457E+09*************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*************+1.23457E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*************1.23457E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1;23457E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1;23457E+09*************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*************+1;23457E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*************1;23457E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1.23457E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1.23457E+09*************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*************+1.23457E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*************1.23457E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1;23457E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1;23457E+09*************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*************+1;23457E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*************1;23457E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(16);
            {
                nouppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.125***********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********1234567890.125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********1234567890.125");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;125*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.125000********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********1234567890.125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********1234567890.125000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;125000****");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "****1_234_567_89_0;125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "****1_234_567_89_0;125000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.125**********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********+1234567890.125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+**********1234567890.125");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0;125******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******+1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+******1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.125000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******+1234567890.125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*******1234567890.125000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0;125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0;125000***");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***+1_234_567_89_0;125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+***1_234_567_89_0;125000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                uppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.125***********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********1234567890.125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********1234567890.125");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;125*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.125000********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********1234567890.125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********1234567890.125000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;125000****");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "****1_234_567_89_0;125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "****1_234_567_89_0;125000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.125**********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********+1234567890.125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+**********1234567890.125");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0;125******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******+1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+******1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.125000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******+1234567890.125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*******1234567890.125000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0;125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0;125000***");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***+1_234_567_89_0;125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+***1_234_567_89_0;125000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(60);
            {
                nouppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.125***********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********1234567890.125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********1234567890.125");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;125*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.125**********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********+1234567890.125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+**********1234567890.125");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0;125******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******+1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+******1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0;12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0;12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0;12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0;12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                uppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.125***********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********1234567890.125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********1234567890.125");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;125*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.125**********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********+1234567890.125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+**********1234567890.125");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0;125******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******+1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+******1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0;12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0;12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0;12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0;12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

void test4()
{
    char str[200];
    output_iterator<char*> iter;
    std::locale lc = std::locale::classic();
    std::locale lg(lc, new my_numpunct);
    const my_facet f(1);
    {
        long double v = -INFINITY;
        std::ios ios(0);
        // %g
        {
            ios.precision(0);
            {
                nouppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************inf");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************inf");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************inf");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************inf");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************inf");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************inf");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************inf");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************inf");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                uppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(1);
            {
                nouppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************inf");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************inf");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************inf");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************inf");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************inf");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************inf");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************inf");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************inf");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                uppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(6);
            {
                nouppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************inf");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************inf");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************inf");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************inf");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************inf");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************inf");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************inf");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-inf*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-inf");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************inf");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                uppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(16);
            {}
            ios.precision(60);
            {}
        }
    }
}

void test5()
{
    char str[200];
    output_iterator<char*> iter;
    std::locale lc = std::locale::classic();
    std::locale lg(lc, new my_numpunct);
    const my_facet f(1);
    {
        long double v = std::nan("");
        std::ios ios(0);
        // %g
        {
            ios.precision(0);
            {
                nouppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "nan");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "nan**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************nan");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************nan");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "nan");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "nan**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************nan");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************nan");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "nan");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "nan**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************nan");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************nan");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "nan");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "nan**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************nan");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************nan");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "nan");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "nan**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************nan");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************nan");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "nan");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "nan**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************nan");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************nan");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "nan");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "nan**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************nan");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************nan");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "nan");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "nan**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************nan");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************nan");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                uppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "NAN");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "NAN**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************NAN");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************NAN");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "NAN");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "NAN**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************NAN");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************NAN");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "NAN");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "NAN**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************NAN");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************NAN");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "NAN");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "NAN**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************NAN");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************NAN");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "NAN");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "NAN**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************NAN");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************NAN");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "NAN");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "NAN**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************NAN");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************NAN");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "NAN");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "NAN**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************NAN");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************NAN");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "NAN");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "NAN**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************NAN");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************NAN");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(1);
            {}
            ios.precision(6);
            {}
            ios.precision(16);
            {}
            ios.precision(60);
            {}
        }
    }
}

void test6()
{
    char str[200];
    output_iterator<char*> iter;
    std::locale lc = std::locale::classic();
    std::locale lg(lc, new my_numpunct);
    const my_facet f(1);
    {
        long double v = +0.;
        std::ios ios(0);
        fixed(ios);
        // %f
        {
            ios.precision(0);
            {
                nouppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************+0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************+0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                uppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************+0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************+0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(1);
            {
                nouppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.0**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************0.0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;0**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************0;0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.0**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************0.0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;0**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************0;0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************+0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*********************0.0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************+0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*********************0;0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************+0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*********************0.0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************+0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*********************0;0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                uppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.0**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************0.0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;0**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************0;0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.0**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************0.0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;0**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************0;0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************+0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*********************0.0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************+0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*********************0;0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************+0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*********************0.0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************+0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*********************0;0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(6);
            {
                nouppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.000000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*****************0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*****************0.000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;000000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*****************0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*****************0;000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.000000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*****************0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*****************0.000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;000000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*****************0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*****************0;000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "****************+0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+****************0.000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "****************+0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+****************0;000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "****************+0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+****************0.000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "****************+0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+****************0;000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                uppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.000000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*****************0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*****************0.000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;000000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*****************0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*****************0;000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.000000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*****************0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*****************0.000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;000000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*****************0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*****************0;000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "****************+0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+****************0.000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "****************+0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+****************0;000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "****************+0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+****************0.000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "****************+0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+****************0;000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(16);
            {
                nouppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.0000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;0000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.0000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;0000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******+0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******+0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******+0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******+0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                uppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.0000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;0000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.0000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;0000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******+0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******+0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******+0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******+0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(60);
            {
                nouppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                uppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

void test7()
{
    char str[200];
    output_iterator<char*> iter;
    std::locale lc = std::locale::classic();
    std::locale lg(lc, new my_numpunct);
    const my_facet f(1);
    {
        long double v = -0.;
        std::ios ios(0);
        fixed(ios);
        // %f
        {
            ios.precision(0);
            {
                nouppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                uppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********************-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(1);
            {
                nouppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************0.0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************0;0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************0.0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************0;0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************0.0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************0;0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************0.0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************0;0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                uppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************0.0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************0;0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************0.0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************0;0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************0.0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************0;0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************0.0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********************-0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-*********************0;0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(6);
            {
                nouppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "****************-0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-****************0.000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "****************-0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-****************0;000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "****************-0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-****************0.000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "****************-0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-****************0;000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "****************-0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-****************0.000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "****************-0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-****************0;000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "****************-0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-****************0.000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "****************-0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-****************0;000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                uppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "****************-0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-****************0.000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "****************-0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-****************0;000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "****************-0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-****************0.000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "****************-0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-****************0;000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "****************-0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-****************0.000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "****************-0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-****************0;000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "****************-0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-****************0.000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "****************-0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-****************0;000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(16);
            {
                nouppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******-0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******-0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******-0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******-0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******-0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******-0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******-0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******-0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                uppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******-0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******-0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******-0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******-0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******-0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******-0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******-0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "******-0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(60);
            {
                nouppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                uppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

void test8()
{
    char str[200];
    output_iterator<char*> iter;
    std::locale lc = std::locale::classic();
    std::locale lg(lc, new my_numpunct);
    const my_facet f(1);
    {
        long double v = 1234567890.125;
        std::ios ios(0);
        fixed(ios);
        // %f
        {
            ios.precision(0);
            {
                nouppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890***************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***************1234567890");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***************1234567890");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0***********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********1_234_567_89_0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********1_234_567_89_0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.**************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**************1234567890.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**************1234567890.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;**********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********1_234_567_89_0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********1_234_567_89_0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890**************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**************+1234567890");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+**************1234567890");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0**********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********+1_234_567_89_0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+**********1_234_567_89_0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.*************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*************+1234567890.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*************1234567890.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0;*********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********+1_234_567_89_0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*********1_234_567_89_0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                uppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890***************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***************1234567890");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***************1234567890");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0***********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********1_234_567_89_0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "***********1_234_567_89_0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.**************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**************1234567890.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**************1234567890.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;**********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********1_234_567_89_0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********1_234_567_89_0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890**************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**************+1234567890");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+**************1234567890");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0**********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "**********+1_234_567_89_0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+**********1_234_567_89_0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.*************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*************+1234567890.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*************1234567890.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0;*********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********+1_234_567_89_0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*********1_234_567_89_0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(1);
            {
                nouppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.1");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.1*************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*************1234567890.1");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*************1234567890.1");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;1");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;1*********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********1_234_567_89_0;1");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********1_234_567_89_0;1");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.1");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.1*************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*************1234567890.1");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*************1234567890.1");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;1");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;1*********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********1_234_567_89_0;1");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********1_234_567_89_0;1");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.1");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.1************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************+1234567890.1");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+************1234567890.1");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0;1");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0;1********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********+1_234_567_89_0;1");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+********1_234_567_89_0;1");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.1");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.1************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************+1234567890.1");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+************1234567890.1");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0;1");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0;1********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********+1_234_567_89_0;1");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+********1_234_567_89_0;1");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                uppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.1");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.1*************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*************1234567890.1");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*************1234567890.1");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;1");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;1*********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********1_234_567_89_0;1");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********1_234_567_89_0;1");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.1");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.1*************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*************1234567890.1");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*************1234567890.1");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;1");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;1*********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********1_234_567_89_0;1");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*********1_234_567_89_0;1");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.1");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.1************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************+1234567890.1");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+************1234567890.1");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0;1");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0;1********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********+1_234_567_89_0;1");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+********1_234_567_89_0;1");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.1");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.1************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "************+1234567890.1");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+************1234567890.1");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0;1");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0;1********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********+1_234_567_89_0;1");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+********1_234_567_89_0;1");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(6);
            {
                nouppercase(ios);
                {
                    noshowpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.125000********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********1234567890.125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********1234567890.125000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;125000****");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "****1_234_567_89_0;125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "****1_234_567_89_0;125000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1234567890.125000********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********1234567890.125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "********1234567890.125000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "1_234_567_89_0;125000****");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "****1_234_567_89_0;125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "****1_234_567_89_0;125000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    showpos(ios);
                    {
                        noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                left(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1234567890.125000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                right(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "*******+1234567890.125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                internal(ios);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+*******1234567890.125000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    iter = f.put(output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, iter.base());
                                    assert(ex == "+1_234_567_89_0;125000");
 