<?php
/*
# Copyright 2004, Revolution Linux Inc., Nicolas Dufresne
#
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
*/
	require_once 'Node.php';
	require_once 'Permissions.php';

	/*
	*  Nodes browser class
	*
	* This class read browser data and generate navigation path.
	*
	* Author: Nicolas Dufresne
	*/

	class NodesBrowser{

		var $node;
		var $childrens;
		var $parents;
		var $errors;
		var $isError;				// Can also be used to avoid other Configuration modules to be executed
		var $nb_find;
		var $node_id;
		var $type;
		var $message;
		var $permissions;
		var $hasPermission; //0|1

		/**
		* Constructor fro node browser
		*
		* Called with 0, it build the complete node and computer browser, called with 1
		* it build the node only browser.
		*
		* @access public
		* @param int Default 0
		*/

		function NodesBrowser($type = COMPUTER_TYPE, $message = NULL, $node_id = "node_id", $nb_find = "nb_find") {
		    $this->load($type, $message, $node_id, $nb_find);
		}

		/**
		* Load the browser (keeping Errors)
		* @access public
		*/
		function load($type = COMPUTER_TYPE, $message = NULL, $node_id = "node_id", $nb_find = "nb_find") {
		    	$this->isError = false;
			$nodeOK = false;
			// Don't allow empty search
			if (isset($_POST[$nb_find]) && $_POST[$nb_find]=="") {
				unset($_POST[$nb_find]);
			}

			if (isset($_POST[$nb_find])) {
				$nodeOK = $this->buildNode( strtr( $_POST[$nb_find], "-", ":" ) );
				if ($nodeOK) {
				    if (!$this->node->isNode() && $type == NODE_TYPE) $this->node = $this->node->getParent();
				    $_GET[$node_id] = $this->node->getID();
				}
			}

			// Allow search by the GET method (to access a node directly with links)
			if (isset($_GET[$nb_find])) {
				$nodeOK = $this->buildNode( strtr( $_GET[$nb_find], "-", ":" ) );
				if ($nodeOK) {
					if (!$this->node->isNode() && $type == NODE_TYPE) $this->node = $this->node->getParent();
					$_GET[$node_id] = $this->node->getID();
					unset($_GET[$nb_find]); // Remove nb_find from _GET
				}
			}

			if (isset($_GET[$node_id]) && !$nodeOK) {
				$nodeOK = $this->buildNode($_GET[$node_id]);
				if ($nodeOK) {
				    if (!$this->node->isNode() && $type == NODE_TYPE) $this->node = $this->node->getParent();
				    $_GET[$node_id] = $this->node->getID();
				}
			}
			if (!$nodeOK) {
				$nodeOK = $this->buildNode();
				$_GET[$node_id] = $this->node->getID();
			}

			if ($nodeOK) {
				$this->parents = $this->node->getParents();
				$this->childrens = $this->node->getChildrens();
			}
			else {
				$this->isFatalError = true;
			}
			$this->node_id = $node_id;
			$this->nb_find = $nb_find;
			$this->type = $type;
			$this->message = $message;
			return true;
		}



		/**
		* Print errors
		*
		* @access public
		*/
		function printErrors() {
			if (isset($this->errors[0])) print "<p>\n";
			else return;
			foreach ($this->errors as $error) {
				print "<font color=\"red\" size=\"-1\">".$error."</font><br>\n";
			}
			print "</p>\n";
		}

		function isError() {
			return $this->isError;
		}

		/**
		* Return selected node
		*
		* This function returns the selected node. It returns NULL if a
		* isFatalError is true.
		*
		* @access public
		* @return Node
		*/
		function getNode(){
			return $this->node;
		}

		/**
		* Build the node
		*
		* This function build a node and test for errors
		*
		* @access private
		* @param int/mac/ip Default 0
		* @return bool;
		*/
		function buildNode($id = "Default") {
			//JMD: remove spaces that got in there by copy-paste
			$id = trim($id);

			if ($id == "Default") {
			    $this->node = new Node();
			} else {
			    $this->node = new Node($id);
			}
			$this->permissions = new Permissions($this->node->getID());
			//Must have permission to read node
			$this->hasPermission = $this->permissions->canReadNode();
			if($this->hasPermission==0){
				//if we don't have the permission to read the node the default node is return'
				$this->errors[] = getMessage('no_permission_to_read_node').$this->node->getID();
				$this->node = new Node();
			}
			//Check for invalide_nodes_type
			switch ($this->node->nodetype) {
				case USER_TYPE:
				case GROUP_TYPE:
					$this->errors[] = getMessage('invalide_nodes_type');
					break;
				default:
					break;
			}

			if ($this->node->isError())
				$this->errors[] = $this->node->lastError();
			return !$this->node->isError();
		}

		/**
		* Print the browser HTML view
		*
		* @access public
		* @return stdout
		*/
		function printView() {
			global $termonly;
			if ($this->isError) {
			    $this->printErrors();
			}
			else {
			    include 'nodesBrowserView.php';
			}
		}
		/**
		 * getter for permissions
		 */
		 function getPermissions(){
		 	return $this->permissions;
		 }
	}
?>
