package latexDraw.util;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;

import javax.swing.JOptionPane;

import latexDraw.lang.LaTeXDrawLang;
import latexDraw.ui.LaTeXDrawFrame;

/** 
 * This class allows to check if a new version of LaTeXDraw is out. This class is a child of Thread
 * to avoid a freeze when the application start.<br>
 * <br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE.  See the GNU General Public License for more details.<br>
 * <br>
 * 
 * 09/11/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 * @since 1.8<br>
 */
public class VersionChecker extends Thread
{
    /** The path of the file containing the news */
    public static final String PATH_MSG = "http://latexdraw.sourceforge.net/news.txt"; //$NON-NLS-1$
    
    protected LaTeXDrawFrame parent;
    
    
	/**
	 * The constructor.
	 * @param frame The main frame of LaTeXDraw.
	 */
	public VersionChecker(LaTeXDrawFrame frame)
	{
		parent = frame;
	}

	
	
	@Override
	public void run() 
	{
        try 
        {
        	checkNewVersion();
        	
        }catch(Exception e) 
		{
        	parent.setStatusBarText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.213")); //$NON-NLS-1$
		}
	}
	
	
	
 	/**
  	 * Allows to check if a new version of latexdraw is out.
  	 */
	protected void checkNewVersion()
  	{
  		try
  		{
  			URL url = new URL(PATH_MSG);
  			InputStream is = url.openStream();
  			DataInputStream dis = new DataInputStream(is);
  			InputStreamReader isr = new InputStreamReader(dis);
  			BufferedReader br = new BufferedReader(isr);
  			String[] div = null;
  			String line = br.readLine();
  			
  			if(line!=null)
  				div = line.split("_");//$NON-NLS-1$
  			
			if(div!=null && div.length>3)
				if(div[3].compareTo(LaTeXDrawFrame.VERSION)>0)
				{
					JOptionPane.showMessageDialog(parent, 
			 		    "<html><span style=\"color: rgb(204, 0, 0); font-weight: bold;\">"//$NON-NLS-1$
			 		    +div[1]+ '/'+div[2]+'/'+div[0]+LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.208") //$NON-NLS-1$
			 		    +div[3]+LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.209"),  //$NON-NLS-1$
				 		   LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.210"),  //$NON-NLS-1$
				 		    JOptionPane.WARNING_MESSAGE); 
					parent.setStatusBarText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.211")); //$NON-NLS-1$
				}
				else parent.setStatusBarText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.212")); //$NON-NLS-1$
  			
			br.close();
			isr.close();
   			dis.close();
   			is.close();
  			
  		}catch(Exception e)
  		{
  			parent.setStatusBarText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.213")); //$NON-NLS-1$
  		}
  	}
}
