
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQXmlQuery.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QXmlQuery>
#include <QAbstractMessageHandler>
#include <QAbstractUriResolver>
#include <QAbstractXmlReceiver>
#include <QIODevice>
#include <QNetworkAccessManager>
#include <QUrl>
#include <QXmlItem>
#include <QXmlName>
#include <QXmlNamePool>
#include <QXmlResultItems>
#include "gsiQt.h"
#include "gsiQtXmlPatternsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QXmlQuery

//  Constructor QXmlQuery::QXmlQuery()


static void _init_ctor_QXmlQuery_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QXmlQuery> ();
}

static void _call_ctor_QXmlQuery_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QXmlQuery *> (new QXmlQuery ());
}


//  Constructor QXmlQuery::QXmlQuery(const QXmlQuery &other)


static void _init_ctor_QXmlQuery_2233 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QXmlQuery & > (argspec_0);
  decl->set_return_new<QXmlQuery> ();
}

static void _call_ctor_QXmlQuery_2233 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QXmlQuery &arg1 = gsi::arg_reader<const QXmlQuery & >() (args, heap);
  ret.write<QXmlQuery *> (new QXmlQuery (arg1));
}


//  Constructor QXmlQuery::QXmlQuery(const QXmlNamePool &np)


static void _init_ctor_QXmlQuery_2494 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("np");
  decl->add_arg<const QXmlNamePool & > (argspec_0);
  decl->set_return_new<QXmlQuery> ();
}

static void _call_ctor_QXmlQuery_2494 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QXmlNamePool &arg1 = gsi::arg_reader<const QXmlNamePool & >() (args, heap);
  ret.write<QXmlQuery *> (new QXmlQuery (arg1));
}


//  Constructor QXmlQuery::QXmlQuery(QXmlQuery::QueryLanguage queryLanguage, const QXmlNamePool &np)


static void _init_ctor_QXmlQuery_5196 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("queryLanguage");
  decl->add_arg<const qt_gsi::Converter<QXmlQuery::QueryLanguage>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("np", true, "QXmlNamePool()");
  decl->add_arg<const QXmlNamePool & > (argspec_1);
  decl->set_return_new<QXmlQuery> ();
}

static void _call_ctor_QXmlQuery_5196 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QXmlQuery::QueryLanguage>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QXmlQuery::QueryLanguage>::target_type & >() (args, heap);
  const QXmlNamePool &arg2 = args ? gsi::arg_reader<const QXmlNamePool & >() (args, heap) : gsi::arg_maker<const QXmlNamePool & >() (QXmlNamePool(), heap);
  ret.write<QXmlQuery *> (new QXmlQuery (qt_gsi::QtToCppAdaptor<QXmlQuery::QueryLanguage>(arg1).cref(), arg2));
}


// void QXmlQuery::bindVariable(const QXmlName &name, const QXmlItem &value)


static void _init_f_bindVariable_4074 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QXmlName & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QXmlItem & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_bindVariable_4074 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QXmlName &arg1 = gsi::arg_reader<const QXmlName & >() (args, heap);
  const QXmlItem &arg2 = gsi::arg_reader<const QXmlItem & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlQuery *)cls)->bindVariable (arg1, arg2);
}


// void QXmlQuery::bindVariable(const QString &localName, const QXmlItem &value)


static void _init_f_bindVariable_4015 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("localName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QXmlItem & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_bindVariable_4015 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QXmlItem &arg2 = gsi::arg_reader<const QXmlItem & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlQuery *)cls)->bindVariable (arg1, arg2);
}


// void QXmlQuery::bindVariable(const QXmlName &name, QIODevice *)


static void _init_f_bindVariable_3423 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QXmlName & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QIODevice * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_bindVariable_3423 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QXmlName &arg1 = gsi::arg_reader<const QXmlName & >() (args, heap);
  QIODevice *arg2 = gsi::arg_reader<QIODevice * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlQuery *)cls)->bindVariable (arg1, arg2);
}


// void QXmlQuery::bindVariable(const QString &localName, QIODevice *)


static void _init_f_bindVariable_3364 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("localName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QIODevice * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_bindVariable_3364 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  QIODevice *arg2 = gsi::arg_reader<QIODevice * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlQuery *)cls)->bindVariable (arg1, arg2);
}


// void QXmlQuery::bindVariable(const QXmlName &name, const QXmlQuery &query)


static void _init_f_bindVariable_4209 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QXmlName & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("query");
  decl->add_arg<const QXmlQuery & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_bindVariable_4209 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QXmlName &arg1 = gsi::arg_reader<const QXmlName & >() (args, heap);
  const QXmlQuery &arg2 = gsi::arg_reader<const QXmlQuery & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlQuery *)cls)->bindVariable (arg1, arg2);
}


// void QXmlQuery::bindVariable(const QString &localName, const QXmlQuery &query)


static void _init_f_bindVariable_4150 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("localName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("query");
  decl->add_arg<const QXmlQuery & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_bindVariable_4150 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QXmlQuery &arg2 = gsi::arg_reader<const QXmlQuery & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlQuery *)cls)->bindVariable (arg1, arg2);
}


// void QXmlQuery::evaluateTo(QXmlResultItems *result)


static void _init_f_evaluateTo_c2161 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("result");
  decl->add_arg<QXmlResultItems * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_evaluateTo_c2161 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QXmlResultItems *arg1 = gsi::arg_reader<QXmlResultItems * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlQuery *)cls)->evaluateTo (arg1);
}


// bool QXmlQuery::evaluateTo(QAbstractXmlReceiver *callback)


static void _init_f_evaluateTo_c2649 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("callback");
  decl->add_arg<QAbstractXmlReceiver * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_evaluateTo_c2649 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractXmlReceiver *arg1 = gsi::arg_reader<QAbstractXmlReceiver * >() (args, heap);
  ret.write<bool > ((bool)((QXmlQuery *)cls)->evaluateTo (arg1));
}


// bool QXmlQuery::evaluateTo(QStringList *target)


static void _init_f_evaluateTo_c1746 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("target");
  decl->add_arg<QStringList * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_evaluateTo_c1746 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStringList *arg1 = gsi::arg_reader<QStringList * >() (args, heap);
  ret.write<bool > ((bool)((QXmlQuery *)cls)->evaluateTo (arg1));
}


// bool QXmlQuery::evaluateTo(QIODevice *target)


static void _init_f_evaluateTo_c1447 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("target");
  decl->add_arg<QIODevice * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_evaluateTo_c1447 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QIODevice *arg1 = gsi::arg_reader<QIODevice * >() (args, heap);
  ret.write<bool > ((bool)((QXmlQuery *)cls)->evaluateTo (arg1));
}


// bool QXmlQuery::evaluateTo(QString *output)


static void _init_f_evaluateTo_c1334 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("output");
  decl->add_arg<QString * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_evaluateTo_c1334 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QString *arg1 = gsi::arg_reader<QString * >() (args, heap);
  ret.write<bool > ((bool)((QXmlQuery *)cls)->evaluateTo (arg1));
}


// QXmlName QXmlQuery::initialTemplateName()


static void _init_f_initialTemplateName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QXmlName > ();
}

static void _call_f_initialTemplateName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QXmlName > ((QXmlName)((QXmlQuery *)cls)->initialTemplateName ());
}


// bool QXmlQuery::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QXmlQuery *)cls)->isValid ());
}


// QAbstractMessageHandler *QXmlQuery::messageHandler()


static void _init_f_messageHandler_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractMessageHandler * > ();
}

static void _call_f_messageHandler_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAbstractMessageHandler * > ((QAbstractMessageHandler *)((QXmlQuery *)cls)->messageHandler ());
}


// QXmlNamePool QXmlQuery::namePool()


static void _init_f_namePool_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QXmlNamePool > ();
}

static void _call_f_namePool_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QXmlNamePool > ((QXmlNamePool)((QXmlQuery *)cls)->namePool ());
}


// QNetworkAccessManager *QXmlQuery::networkAccessManager()


static void _init_f_networkAccessManager_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QNetworkAccessManager * > ();
}

static void _call_f_networkAccessManager_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QNetworkAccessManager * > ((QNetworkAccessManager *)((QXmlQuery *)cls)->networkAccessManager ());
}


// QXmlQuery &QXmlQuery::operator=(const QXmlQuery &other)


static void _init_f_operator_eq__2233 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QXmlQuery & > (argspec_0);
  decl->set_return<QXmlQuery & > ();
}

static void _call_f_operator_eq__2233 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QXmlQuery &arg1 = gsi::arg_reader<const QXmlQuery & >() (args, heap);
  ret.write<QXmlQuery & > ((QXmlQuery &)((QXmlQuery *)cls)->operator= (arg1));
}


// QXmlQuery::QueryLanguage QXmlQuery::queryLanguage()


static void _init_f_queryLanguage_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QXmlQuery::QueryLanguage>::target_type > ();
}

static void _call_f_queryLanguage_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QXmlQuery::QueryLanguage>::target_type > ((qt_gsi::Converter<QXmlQuery::QueryLanguage>::target_type)qt_gsi::CppToQtAdaptor<QXmlQuery::QueryLanguage>(((QXmlQuery *)cls)->queryLanguage ()));
}


// void QXmlQuery::setFocus(const QXmlItem &item)


static void _init_f_setFocus_2098 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QXmlItem & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFocus_2098 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QXmlItem &arg1 = gsi::arg_reader<const QXmlItem & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlQuery *)cls)->setFocus (arg1);
}


// bool QXmlQuery::setFocus(const QUrl &documentURI)


static void _init_f_setFocus_1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("documentURI");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_setFocus_1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  ret.write<bool > ((bool)((QXmlQuery *)cls)->setFocus (arg1));
}


// bool QXmlQuery::setFocus(QIODevice *document)


static void _init_f_setFocus_1447 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("document");
  decl->add_arg<QIODevice * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_setFocus_1447 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QIODevice *arg1 = gsi::arg_reader<QIODevice * >() (args, heap);
  ret.write<bool > ((bool)((QXmlQuery *)cls)->setFocus (arg1));
}


// bool QXmlQuery::setFocus(const QString &focus)


static void _init_f_setFocus_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("focus");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_setFocus_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<bool > ((bool)((QXmlQuery *)cls)->setFocus (arg1));
}


// void QXmlQuery::setInitialTemplateName(const QXmlName &name)


static void _init_f_setInitialTemplateName_2084 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QXmlName & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setInitialTemplateName_2084 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QXmlName &arg1 = gsi::arg_reader<const QXmlName & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlQuery *)cls)->setInitialTemplateName (arg1);
}


// void QXmlQuery::setInitialTemplateName(const QString &name)


static void _init_f_setInitialTemplateName_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setInitialTemplateName_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlQuery *)cls)->setInitialTemplateName (arg1);
}


// void QXmlQuery::setMessageHandler(QAbstractMessageHandler *messageHandler)


static void _init_f_setMessageHandler_2934 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("messageHandler");
  decl->add_arg<QAbstractMessageHandler * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMessageHandler_2934 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractMessageHandler *arg1 = gsi::arg_reader<QAbstractMessageHandler * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlQuery *)cls)->setMessageHandler (arg1);
}


// void QXmlQuery::setNetworkAccessManager(QNetworkAccessManager *newManager)


static void _init_f_setNetworkAccessManager_2742 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newManager");
  decl->add_arg<QNetworkAccessManager * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNetworkAccessManager_2742 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QNetworkAccessManager *arg1 = gsi::arg_reader<QNetworkAccessManager * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlQuery *)cls)->setNetworkAccessManager (arg1);
}


// void QXmlQuery::setQuery(const QString &sourceCode, const QUrl &documentURI)


static void _init_f_setQuery_3618 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceCode");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("documentURI", true, "QUrl()");
  decl->add_arg<const QUrl & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setQuery_3618 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QUrl &arg2 = args ? gsi::arg_reader<const QUrl & >() (args, heap) : gsi::arg_maker<const QUrl & >() (QUrl(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlQuery *)cls)->setQuery (arg1, arg2);
}


// void QXmlQuery::setQuery(QIODevice *sourceCode, const QUrl &documentURI)


static void _init_f_setQuery_3040 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceCode");
  decl->add_arg<QIODevice * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("documentURI", true, "QUrl()");
  decl->add_arg<const QUrl & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setQuery_3040 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QIODevice *arg1 = gsi::arg_reader<QIODevice * >() (args, heap);
  const QUrl &arg2 = args ? gsi::arg_reader<const QUrl & >() (args, heap) : gsi::arg_maker<const QUrl & >() (QUrl(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlQuery *)cls)->setQuery (arg1, arg2);
}


// void QXmlQuery::setQuery(const QUrl &queryURI, const QUrl &baseURI)


static void _init_f_setQuery_3294 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("queryURI");
  decl->add_arg<const QUrl & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("baseURI", true, "QUrl()");
  decl->add_arg<const QUrl & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setQuery_3294 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  const QUrl &arg2 = args ? gsi::arg_reader<const QUrl & >() (args, heap) : gsi::arg_maker<const QUrl & >() (QUrl(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlQuery *)cls)->setQuery (arg1, arg2);
}


// void QXmlQuery::setUriResolver(const QAbstractUriResolver *resolver)


static void _init_f_setUriResolver_3372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("resolver");
  decl->add_arg<const QAbstractUriResolver * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setUriResolver_3372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QAbstractUriResolver *arg1 = gsi::arg_reader<const QAbstractUriResolver * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlQuery *)cls)->setUriResolver (arg1);
}


// const QAbstractUriResolver *QXmlQuery::uriResolver()


static void _init_f_uriResolver_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QAbstractUriResolver * > ();
}

static void _call_f_uriResolver_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QAbstractUriResolver * > ((const QAbstractUriResolver *)((QXmlQuery *)cls)->uriResolver ());
}



namespace gsi
{

static gsi::Methods methods_QXmlQuery () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QXmlQuery::QXmlQuery()\nThis method creates an object of class QXmlQuery.", &_init_ctor_QXmlQuery_0, &_call_ctor_QXmlQuery_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QXmlQuery::QXmlQuery(const QXmlQuery &other)\nThis method creates an object of class QXmlQuery.", &_init_ctor_QXmlQuery_2233, &_call_ctor_QXmlQuery_2233);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QXmlQuery::QXmlQuery(const QXmlNamePool &np)\nThis method creates an object of class QXmlQuery.", &_init_ctor_QXmlQuery_2494, &_call_ctor_QXmlQuery_2494);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QXmlQuery::QXmlQuery(QXmlQuery::QueryLanguage queryLanguage, const QXmlNamePool &np)\nThis method creates an object of class QXmlQuery.", &_init_ctor_QXmlQuery_5196, &_call_ctor_QXmlQuery_5196);
  methods += new qt_gsi::GenericMethod ("bindVariable", "@brief Method void QXmlQuery::bindVariable(const QXmlName &name, const QXmlItem &value)\n", false, &_init_f_bindVariable_4074, &_call_f_bindVariable_4074);
  methods += new qt_gsi::GenericMethod ("bindVariable", "@brief Method void QXmlQuery::bindVariable(const QString &localName, const QXmlItem &value)\n", false, &_init_f_bindVariable_4015, &_call_f_bindVariable_4015);
  methods += new qt_gsi::GenericMethod ("bindVariable", "@brief Method void QXmlQuery::bindVariable(const QXmlName &name, QIODevice *)\n", false, &_init_f_bindVariable_3423, &_call_f_bindVariable_3423);
  methods += new qt_gsi::GenericMethod ("bindVariable", "@brief Method void QXmlQuery::bindVariable(const QString &localName, QIODevice *)\n", false, &_init_f_bindVariable_3364, &_call_f_bindVariable_3364);
  methods += new qt_gsi::GenericMethod ("bindVariable", "@brief Method void QXmlQuery::bindVariable(const QXmlName &name, const QXmlQuery &query)\n", false, &_init_f_bindVariable_4209, &_call_f_bindVariable_4209);
  methods += new qt_gsi::GenericMethod ("bindVariable", "@brief Method void QXmlQuery::bindVariable(const QString &localName, const QXmlQuery &query)\n", false, &_init_f_bindVariable_4150, &_call_f_bindVariable_4150);
  methods += new qt_gsi::GenericMethod ("evaluateTo", "@brief Method void QXmlQuery::evaluateTo(QXmlResultItems *result)\n", true, &_init_f_evaluateTo_c2161, &_call_f_evaluateTo_c2161);
  methods += new qt_gsi::GenericMethod ("evaluateTo", "@brief Method bool QXmlQuery::evaluateTo(QAbstractXmlReceiver *callback)\n", true, &_init_f_evaluateTo_c2649, &_call_f_evaluateTo_c2649);
  methods += new qt_gsi::GenericMethod ("evaluateTo", "@brief Method bool QXmlQuery::evaluateTo(QStringList *target)\n", true, &_init_f_evaluateTo_c1746, &_call_f_evaluateTo_c1746);
  methods += new qt_gsi::GenericMethod ("evaluateTo", "@brief Method bool QXmlQuery::evaluateTo(QIODevice *target)\n", true, &_init_f_evaluateTo_c1447, &_call_f_evaluateTo_c1447);
  methods += new qt_gsi::GenericMethod ("evaluateTo", "@brief Method bool QXmlQuery::evaluateTo(QString *output)\n", true, &_init_f_evaluateTo_c1334, &_call_f_evaluateTo_c1334);
  methods += new qt_gsi::GenericMethod (":initialTemplateName", "@brief Method QXmlName QXmlQuery::initialTemplateName()\n", true, &_init_f_initialTemplateName_c0, &_call_f_initialTemplateName_c0);
  methods += new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QXmlQuery::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
  methods += new qt_gsi::GenericMethod (":messageHandler", "@brief Method QAbstractMessageHandler *QXmlQuery::messageHandler()\n", true, &_init_f_messageHandler_c0, &_call_f_messageHandler_c0);
  methods += new qt_gsi::GenericMethod ("namePool", "@brief Method QXmlNamePool QXmlQuery::namePool()\n", true, &_init_f_namePool_c0, &_call_f_namePool_c0);
  methods += new qt_gsi::GenericMethod (":networkAccessManager", "@brief Method QNetworkAccessManager *QXmlQuery::networkAccessManager()\n", true, &_init_f_networkAccessManager_c0, &_call_f_networkAccessManager_c0);
  methods += new qt_gsi::GenericMethod ("assign", "@brief Method QXmlQuery &QXmlQuery::operator=(const QXmlQuery &other)\n", false, &_init_f_operator_eq__2233, &_call_f_operator_eq__2233);
  methods += new qt_gsi::GenericMethod ("queryLanguage", "@brief Method QXmlQuery::QueryLanguage QXmlQuery::queryLanguage()\n", true, &_init_f_queryLanguage_c0, &_call_f_queryLanguage_c0);
  methods += new qt_gsi::GenericMethod ("setFocus", "@brief Method void QXmlQuery::setFocus(const QXmlItem &item)\n", false, &_init_f_setFocus_2098, &_call_f_setFocus_2098);
  methods += new qt_gsi::GenericMethod ("setFocus", "@brief Method bool QXmlQuery::setFocus(const QUrl &documentURI)\n", false, &_init_f_setFocus_1701, &_call_f_setFocus_1701);
  methods += new qt_gsi::GenericMethod ("setFocus", "@brief Method bool QXmlQuery::setFocus(QIODevice *document)\n", false, &_init_f_setFocus_1447, &_call_f_setFocus_1447);
  methods += new qt_gsi::GenericMethod ("setFocus", "@brief Method bool QXmlQuery::setFocus(const QString &focus)\n", false, &_init_f_setFocus_2025, &_call_f_setFocus_2025);
  methods += new qt_gsi::GenericMethod ("setInitialTemplateName|initialTemplateName=", "@brief Method void QXmlQuery::setInitialTemplateName(const QXmlName &name)\n", false, &_init_f_setInitialTemplateName_2084, &_call_f_setInitialTemplateName_2084);
  methods += new qt_gsi::GenericMethod ("setInitialTemplateName|initialTemplateName=", "@brief Method void QXmlQuery::setInitialTemplateName(const QString &name)\n", false, &_init_f_setInitialTemplateName_2025, &_call_f_setInitialTemplateName_2025);
  methods += new qt_gsi::GenericMethod ("setMessageHandler|messageHandler=", "@brief Method void QXmlQuery::setMessageHandler(QAbstractMessageHandler *messageHandler)\n", false, &_init_f_setMessageHandler_2934, &_call_f_setMessageHandler_2934);
  methods += new qt_gsi::GenericMethod ("setNetworkAccessManager|networkAccessManager=", "@brief Method void QXmlQuery::setNetworkAccessManager(QNetworkAccessManager *newManager)\n", false, &_init_f_setNetworkAccessManager_2742, &_call_f_setNetworkAccessManager_2742);
  methods += new qt_gsi::GenericMethod ("setQuery", "@brief Method void QXmlQuery::setQuery(const QString &sourceCode, const QUrl &documentURI)\n", false, &_init_f_setQuery_3618, &_call_f_setQuery_3618);
  methods += new qt_gsi::GenericMethod ("setQuery", "@brief Method void QXmlQuery::setQuery(QIODevice *sourceCode, const QUrl &documentURI)\n", false, &_init_f_setQuery_3040, &_call_f_setQuery_3040);
  methods += new qt_gsi::GenericMethod ("setQuery", "@brief Method void QXmlQuery::setQuery(const QUrl &queryURI, const QUrl &baseURI)\n", false, &_init_f_setQuery_3294, &_call_f_setQuery_3294);
  methods += new qt_gsi::GenericMethod ("setUriResolver|uriResolver=", "@brief Method void QXmlQuery::setUriResolver(const QAbstractUriResolver *resolver)\n", false, &_init_f_setUriResolver_3372, &_call_f_setUriResolver_3372);
  methods += new qt_gsi::GenericMethod (":uriResolver", "@brief Method const QAbstractUriResolver *QXmlQuery::uriResolver()\n", true, &_init_f_uriResolver_c0, &_call_f_uriResolver_c0);
  return methods;
}

gsi::Class<QXmlQuery> decl_QXmlQuery ("QtXmlPatterns", "QXmlQuery",
  methods_QXmlQuery (),
  "@qt\n@brief Binding of QXmlQuery");


GSI_QTXMLPATTERNS_PUBLIC gsi::Class<QXmlQuery> &qtdecl_QXmlQuery () { return decl_QXmlQuery; }

}


//  Implementation of the enum wrapper class for QXmlQuery::QueryLanguage
namespace qt_gsi
{

static gsi::Enum<QXmlQuery::QueryLanguage> decl_QXmlQuery_QueryLanguage_Enum ("QtXmlPatterns", "QXmlQuery_QueryLanguage",
    gsi::enum_const ("XQuery10", QXmlQuery::XQuery10, "@brief Enum constant QXmlQuery::XQuery10") +
    gsi::enum_const ("XSLT20", QXmlQuery::XSLT20, "@brief Enum constant QXmlQuery::XSLT20") +
    gsi::enum_const ("XmlSchema11IdentityConstraintSelector", QXmlQuery::XmlSchema11IdentityConstraintSelector, "@brief Enum constant QXmlQuery::XmlSchema11IdentityConstraintSelector") +
    gsi::enum_const ("XmlSchema11IdentityConstraintField", QXmlQuery::XmlSchema11IdentityConstraintField, "@brief Enum constant QXmlQuery::XmlSchema11IdentityConstraintField") +
    gsi::enum_const ("XPath20", QXmlQuery::XPath20, "@brief Enum constant QXmlQuery::XPath20"),
  "@qt\n@brief This class represents the QXmlQuery::QueryLanguage enum");

static gsi::QFlagsClass<QXmlQuery::QueryLanguage > decl_QXmlQuery_QueryLanguage_Enums ("QtXmlPatterns", "QXmlQuery_QFlags_QueryLanguage",
  "@qt\n@brief This class represents the QFlags<QXmlQuery::QueryLanguage> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QXmlQuery> inject_QXmlQuery_QueryLanguage_Enum_in_parent (decl_QXmlQuery_QueryLanguage_Enum.defs ());
static gsi::ClassExt<QXmlQuery> decl_QXmlQuery_QueryLanguage_Enum_as_child (decl_QXmlQuery_QueryLanguage_Enum, "QueryLanguage");
static gsi::ClassExt<QXmlQuery> decl_QXmlQuery_QueryLanguage_Enums_as_child (decl_QXmlQuery_QueryLanguage_Enums, "QFlags_QueryLanguage");

}

