#if 0
.if "0" == "1"
#endif
/*
 *	Universal Coded Character Set/ISO-10646 functions for JOE
 *	Copyright
 *		(C) 1992 Joseph H. Allen
 *	Copyright © 2014, 2017, 2020
 *		mirabilos <m@mirbsd.org>
 *
 *	This file is part of JOE (Joe's Own Editor)
 */

#include "config.h"
#include <stdlib.h>

__RCSID("$MirOS: contrib/code/jupp/i18n.c,v 1.40 2020/06/20 02:27:52 tg Exp $");

/*-
 * Parts Copyright © 1991–2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in
 *     https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

#include "charmap.h"
#include "utils.h"

/* From: X11/xc/programs/xterm/wcwidth.c,v 1.10 */

struct mb_ucsrange {
	unsigned int beg;
	unsigned int end;
};

static size_t mb_ucsbsearch(const struct mb_ucsrange arr[], size_t elems,
    unsigned int val);

/*
 * Generated from the UCD 13.0.0 - see /usr/share/doc/legal/LICENCE-BSD - by
 * MirOS: contrib/code/Snippets/eawparse,v 1.15 2020/06/15 20:31:13 tg Exp $
 */

static const struct mb_ucsrange mb_ucs_combining[] = {
	{ 0x0300, 0x036F },
	{ 0x0483, 0x0489 },
	{ 0x0591, 0x05BD },
	{ 0x05BF, 0x05BF },
	{ 0x05C1, 0x05C2 },
	{ 0x05C4, 0x05C5 },
	{ 0x05C7, 0x05C7 },
	{ 0x0610, 0x061A },
	{ 0x061C, 0x061C },
	{ 0x064B, 0x065F },
	{ 0x0670, 0x0670 },
	{ 0x06D6, 0x06DC },
	{ 0x06DF, 0x06E4 },
	{ 0x06E7, 0x06E8 },
	{ 0x06EA, 0x06ED },
	{ 0x0711, 0x0711 },
	{ 0x0730, 0x074A },
	{ 0x07A6, 0x07B0 },
	{ 0x07EB, 0x07F3 },
	{ 0x07FD, 0x07FD },
	{ 0x0816, 0x0819 },
	{ 0x081B, 0x0823 },
	{ 0x0825, 0x0827 },
	{ 0x0829, 0x082D },
	{ 0x0859, 0x085B },
	{ 0x08D3, 0x08E1 },
	{ 0x08E3, 0x0902 },
	{ 0x093A, 0x093A },
	{ 0x093C, 0x093C },
	{ 0x0941, 0x0948 },
	{ 0x094D, 0x094D },
	{ 0x0951, 0x0957 },
	{ 0x0962, 0x0963 },
	{ 0x0981, 0x0981 },
	{ 0x09BC, 0x09BC },
	{ 0x09C1, 0x09C4 },
	{ 0x09CD, 0x09CD },
	{ 0x09E2, 0x09E3 },
	{ 0x09FE, 0x09FE },
	{ 0x0A01, 0x0A02 },
	{ 0x0A3C, 0x0A3C },
	{ 0x0A41, 0x0A42 },
	{ 0x0A47, 0x0A48 },
	{ 0x0A4B, 0x0A4D },
	{ 0x0A51, 0x0A51 },
	{ 0x0A70, 0x0A71 },
	{ 0x0A75, 0x0A75 },
	{ 0x0A81, 0x0A82 },
	{ 0x0ABC, 0x0ABC },
	{ 0x0AC1, 0x0AC5 },
	{ 0x0AC7, 0x0AC8 },
	{ 0x0ACD, 0x0ACD },
	{ 0x0AE2, 0x0AE3 },
	{ 0x0AFA, 0x0AFF },
	{ 0x0B01, 0x0B01 },
	{ 0x0B3C, 0x0B3C },
	{ 0x0B3F, 0x0B3F },
	{ 0x0B41, 0x0B44 },
	{ 0x0B4D, 0x0B4D },
	{ 0x0B55, 0x0B56 },
	{ 0x0B62, 0x0B63 },
	{ 0x0B82, 0x0B82 },
	{ 0x0BC0, 0x0BC0 },
	{ 0x0BCD, 0x0BCD },
	{ 0x0C00, 0x0C00 },
	{ 0x0C04, 0x0C04 },
	{ 0x0C3E, 0x0C40 },
	{ 0x0C46, 0x0C48 },
	{ 0x0C4A, 0x0C4D },
	{ 0x0C55, 0x0C56 },
	{ 0x0C62, 0x0C63 },
	{ 0x0C81, 0x0C81 },
	{ 0x0CBC, 0x0CBC },
	{ 0x0CBF, 0x0CBF },
	{ 0x0CC6, 0x0CC6 },
	{ 0x0CCC, 0x0CCD },
	{ 0x0CE2, 0x0CE3 },
	{ 0x0D00, 0x0D01 },
	{ 0x0D3B, 0x0D3C },
	{ 0x0D41, 0x0D44 },
	{ 0x0D4D, 0x0D4D },
	{ 0x0D62, 0x0D63 },
	{ 0x0D81, 0x0D81 },
	{ 0x0DCA, 0x0DCA },
	{ 0x0DD2, 0x0DD4 },
	{ 0x0DD6, 0x0DD6 },
	{ 0x0E31, 0x0E31 },
	{ 0x0E34, 0x0E3A },
	{ 0x0E47, 0x0E4E },
	{ 0x0EB1, 0x0EB1 },
	{ 0x0EB4, 0x0EBC },
	{ 0x0EC8, 0x0ECD },
	{ 0x0F18, 0x0F19 },
	{ 0x0F35, 0x0F35 },
	{ 0x0F37, 0x0F37 },
	{ 0x0F39, 0x0F39 },
	{ 0x0F71, 0x0F7E },
	{ 0x0F80, 0x0F84 },
	{ 0x0F86, 0x0F87 },
	{ 0x0F8D, 0x0F97 },
	{ 0x0F99, 0x0FBC },
	{ 0x0FC6, 0x0FC6 },
	{ 0x102D, 0x1030 },
	{ 0x1032, 0x1037 },
	{ 0x1039, 0x103A },
	{ 0x103D, 0x103E },
	{ 0x1058, 0x1059 },
	{ 0x105E, 0x1060 },
	{ 0x1071, 0x1074 },
	{ 0x1082, 0x1082 },
	{ 0x1085, 0x1086 },
	{ 0x108D, 0x108D },
	{ 0x109D, 0x109D },
	{ 0x1160, 0x11FF },
	{ 0x135D, 0x135F },
	{ 0x1712, 0x1714 },
	{ 0x1732, 0x1734 },
	{ 0x1752, 0x1753 },
	{ 0x1772, 0x1773 },
	{ 0x17B4, 0x17B5 },
	{ 0x17B7, 0x17BD },
	{ 0x17C6, 0x17C6 },
	{ 0x17C9, 0x17D3 },
	{ 0x17DD, 0x17DD },
	{ 0x180B, 0x180E },
	{ 0x1885, 0x1886 },
	{ 0x18A9, 0x18A9 },
	{ 0x1920, 0x1922 },
	{ 0x1927, 0x1928 },
	{ 0x1932, 0x1932 },
	{ 0x1939, 0x193B },
	{ 0x1A17, 0x1A18 },
	{ 0x1A1B, 0x1A1B },
	{ 0x1A56, 0x1A56 },
	{ 0x1A58, 0x1A5E },
	{ 0x1A60, 0x1A60 },
	{ 0x1A62, 0x1A62 },
	{ 0x1A65, 0x1A6C },
	{ 0x1A73, 0x1A7C },
	{ 0x1A7F, 0x1A7F },
	{ 0x1AB0, 0x1AC0 },
	{ 0x1B00, 0x1B03 },
	{ 0x1B34, 0x1B34 },
	{ 0x1B36, 0x1B3A },
	{ 0x1B3C, 0x1B3C },
	{ 0x1B42, 0x1B42 },
	{ 0x1B6B, 0x1B73 },
	{ 0x1B80, 0x1B81 },
	{ 0x1BA2, 0x1BA5 },
	{ 0x1BA8, 0x1BA9 },
	{ 0x1BAB, 0x1BAD },
	{ 0x1BE6, 0x1BE6 },
	{ 0x1BE8, 0x1BE9 },
	{ 0x1BED, 0x1BED },
	{ 0x1BEF, 0x1BF1 },
	{ 0x1C2C, 0x1C33 },
	{ 0x1C36, 0x1C37 },
	{ 0x1CD0, 0x1CD2 },
	{ 0x1CD4, 0x1CE0 },
	{ 0x1CE2, 0x1CE8 },
	{ 0x1CED, 0x1CED },
	{ 0x1CF4, 0x1CF4 },
	{ 0x1CF8, 0x1CF9 },
	{ 0x1DC0, 0x1DF9 },
	{ 0x1DFB, 0x1DFF },
	{ 0x200B, 0x200F },
	{ 0x202A, 0x202E },
	{ 0x2060, 0x2064 },
	{ 0x2066, 0x206F },
	{ 0x20D0, 0x20F0 },
	{ 0x2CEF, 0x2CF1 },
	{ 0x2D7F, 0x2D7F },
	{ 0x2DE0, 0x2DFF },
	{ 0x302A, 0x302D },
	{ 0x3099, 0x309A },
	{ 0xA66F, 0xA672 },
	{ 0xA674, 0xA67D },
	{ 0xA69E, 0xA69F },
	{ 0xA6F0, 0xA6F1 },
	{ 0xA802, 0xA802 },
	{ 0xA806, 0xA806 },
	{ 0xA80B, 0xA80B },
	{ 0xA825, 0xA826 },
	{ 0xA82C, 0xA82C },
	{ 0xA8C4, 0xA8C5 },
	{ 0xA8E0, 0xA8F1 },
	{ 0xA8FF, 0xA8FF },
	{ 0xA926, 0xA92D },
	{ 0xA947, 0xA951 },
	{ 0xA980, 0xA982 },
	{ 0xA9B3, 0xA9B3 },
	{ 0xA9B6, 0xA9B9 },
	{ 0xA9BC, 0xA9BD },
	{ 0xA9E5, 0xA9E5 },
	{ 0xAA29, 0xAA2E },
	{ 0xAA31, 0xAA32 },
	{ 0xAA35, 0xAA36 },
	{ 0xAA43, 0xAA43 },
	{ 0xAA4C, 0xAA4C },
	{ 0xAA7C, 0xAA7C },
	{ 0xAAB0, 0xAAB0 },
	{ 0xAAB2, 0xAAB4 },
	{ 0xAAB7, 0xAAB8 },
	{ 0xAABE, 0xAABF },
	{ 0xAAC1, 0xAAC1 },
	{ 0xAAEC, 0xAAED },
	{ 0xAAF6, 0xAAF6 },
	{ 0xABE5, 0xABE5 },
	{ 0xABE8, 0xABE8 },
	{ 0xABED, 0xABED },
	{ 0xD7B0, 0xD7FF },
	{ 0xFB1E, 0xFB1E },
	{ 0xFE00, 0xFE0F },
	{ 0xFE20, 0xFE2F },
	{ 0xFEFF, 0xFEFF },
	{ 0xFFF9, 0xFFFB },
	{ 0x101FD, 0x101FD },
	{ 0x102E0, 0x102E0 },
	{ 0x10376, 0x1037A },
	{ 0x10A01, 0x10A03 },
	{ 0x10A05, 0x10A06 },
	{ 0x10A0C, 0x10A0F },
	{ 0x10A38, 0x10A3A },
	{ 0x10A3F, 0x10A3F },
	{ 0x10AE5, 0x10AE6 },
	{ 0x10D24, 0x10D27 },
	{ 0x10EAB, 0x10EAC },
	{ 0x10F46, 0x10F50 },
	{ 0x11001, 0x11001 },
	{ 0x11038, 0x11046 },
	{ 0x1107F, 0x11081 },
	{ 0x110B3, 0x110B6 },
	{ 0x110B9, 0x110BA },
	{ 0x11100, 0x11102 },
	{ 0x11127, 0x1112B },
	{ 0x1112D, 0x11134 },
	{ 0x11173, 0x11173 },
	{ 0x11180, 0x11181 },
	{ 0x111B6, 0x111BE },
	{ 0x111C9, 0x111CC },
	{ 0x111CF, 0x111CF },
	{ 0x1122F, 0x11231 },
	{ 0x11234, 0x11234 },
	{ 0x11236, 0x11237 },
	{ 0x1123E, 0x1123E },
	{ 0x112DF, 0x112DF },
	{ 0x112E3, 0x112EA },
	{ 0x11300, 0x11301 },
	{ 0x1133B, 0x1133C },
	{ 0x11340, 0x11340 },
	{ 0x11366, 0x1136C },
	{ 0x11370, 0x11374 },
	{ 0x11438, 0x1143F },
	{ 0x11442, 0x11444 },
	{ 0x11446, 0x11446 },
	{ 0x1145E, 0x1145E },
	{ 0x114B3, 0x114B8 },
	{ 0x114BA, 0x114BA },
	{ 0x114BF, 0x114C0 },
	{ 0x114C2, 0x114C3 },
	{ 0x115B2, 0x115B5 },
	{ 0x115BC, 0x115BD },
	{ 0x115BF, 0x115C0 },
	{ 0x115DC, 0x115DD },
	{ 0x11633, 0x1163A },
	{ 0x1163D, 0x1163D },
	{ 0x1163F, 0x11640 },
	{ 0x116AB, 0x116AB },
	{ 0x116AD, 0x116AD },
	{ 0x116B0, 0x116B5 },
	{ 0x116B7, 0x116B7 },
	{ 0x1171D, 0x1171F },
	{ 0x11722, 0x11725 },
	{ 0x11727, 0x1172B },
	{ 0x1182F, 0x11837 },
	{ 0x11839, 0x1183A },
	{ 0x1193B, 0x1193C },
	{ 0x1193E, 0x1193E },
	{ 0x11943, 0x11943 },
	{ 0x119D4, 0x119D7 },
	{ 0x119DA, 0x119DB },
	{ 0x119E0, 0x119E0 },
	{ 0x11A01, 0x11A0A },
	{ 0x11A33, 0x11A38 },
	{ 0x11A3B, 0x11A3E },
	{ 0x11A47, 0x11A47 },
	{ 0x11A51, 0x11A56 },
	{ 0x11A59, 0x11A5B },
	{ 0x11A8A, 0x11A96 },
	{ 0x11A98, 0x11A99 },
	{ 0x11C30, 0x11C36 },
	{ 0x11C38, 0x11C3D },
	{ 0x11C3F, 0x11C3F },
	{ 0x11C92, 0x11CA7 },
	{ 0x11CAA, 0x11CB0 },
	{ 0x11CB2, 0x11CB3 },
	{ 0x11CB5, 0x11CB6 },
	{ 0x11D31, 0x11D36 },
	{ 0x11D3A, 0x11D3A },
	{ 0x11D3C, 0x11D3D },
	{ 0x11D3F, 0x11D45 },
	{ 0x11D47, 0x11D47 },
	{ 0x11D90, 0x11D91 },
	{ 0x11D95, 0x11D95 },
	{ 0x11D97, 0x11D97 },
	{ 0x11EF3, 0x11EF4 },
	{ 0x13430, 0x13438 },
	{ 0x16AF0, 0x16AF4 },
	{ 0x16B30, 0x16B36 },
	{ 0x16F4F, 0x16F4F },
	{ 0x16F8F, 0x16F92 },
	{ 0x16FE4, 0x16FE4 },
	{ 0x1BC9D, 0x1BC9E },
	{ 0x1BCA0, 0x1BCA3 },
	{ 0x1D167, 0x1D169 },
	{ 0x1D173, 0x1D182 },
	{ 0x1D185, 0x1D18B },
	{ 0x1D1AA, 0x1D1AD },
	{ 0x1D242, 0x1D244 },
	{ 0x1DA00, 0x1DA36 },
	{ 0x1DA3B, 0x1DA6C },
	{ 0x1DA75, 0x1DA75 },
	{ 0x1DA84, 0x1DA84 },
	{ 0x1DA9B, 0x1DA9F },
	{ 0x1DAA1, 0x1DAAF },
	{ 0x1E000, 0x1E006 },
	{ 0x1E008, 0x1E018 },
	{ 0x1E01B, 0x1E021 },
	{ 0x1E023, 0x1E024 },
	{ 0x1E026, 0x1E02A },
	{ 0x1E130, 0x1E136 },
	{ 0x1E2EC, 0x1E2EF },
	{ 0x1E8D0, 0x1E8D6 },
	{ 0x1E944, 0x1E94A },
	{ 0xE0001, 0xE0001 },
	{ 0xE0020, 0xE007F },
	{ 0xE0100, 0xE01EF }
};

static const struct mb_ucsrange mb_ucs_fullwidth[] = {
	{ 0x1100, 0x115F },
	{ 0x231A, 0x231B },
	{ 0x2329, 0x232A },
	{ 0x23E9, 0x23EC },
	{ 0x23F0, 0x23F0 },
	{ 0x23F3, 0x23F3 },
	{ 0x25FD, 0x25FE },
	{ 0x2614, 0x2615 },
	{ 0x2648, 0x2653 },
	{ 0x267F, 0x267F },
	{ 0x2693, 0x2693 },
	{ 0x26A1, 0x26A1 },
	{ 0x26AA, 0x26AB },
	{ 0x26BD, 0x26BE },
	{ 0x26C4, 0x26C5 },
	{ 0x26CE, 0x26CE },
	{ 0x26D4, 0x26D4 },
	{ 0x26EA, 0x26EA },
	{ 0x26F2, 0x26F3 },
	{ 0x26F5, 0x26F5 },
	{ 0x26FA, 0x26FA },
	{ 0x26FD, 0x26FD },
	{ 0x2705, 0x2705 },
	{ 0x270A, 0x270B },
	{ 0x2728, 0x2728 },
	{ 0x274C, 0x274C },
	{ 0x274E, 0x274E },
	{ 0x2753, 0x2755 },
	{ 0x2757, 0x2757 },
	{ 0x2795, 0x2797 },
	{ 0x27B0, 0x27B0 },
	{ 0x27BF, 0x27BF },
	{ 0x2B1B, 0x2B1C },
	{ 0x2B50, 0x2B50 },
	{ 0x2B55, 0x2B55 },
	{ 0x2E80, 0x3029 },
	{ 0x302E, 0x303E },
	{ 0x3040, 0x3098 },
	{ 0x309B, 0xA4CF },
	{ 0xA960, 0xA97F },
	{ 0xAC00, 0xD7A3 },
	{ 0xF900, 0xFAFF },
	{ 0xFE10, 0xFE19 },
	{ 0xFE30, 0xFE6F },
	{ 0xFF01, 0xFF60 },
	{ 0xFFE0, 0xFFE6 },
	{ 0x16FE0, 0x16FE3 },
	{ 0x16FF0, 0x16FF1 },
	{ 0x17000, 0x187F7 },
	{ 0x18800, 0x18CD5 },
	{ 0x18D00, 0x18D08 },
	{ 0x1B000, 0x1B11E },
	{ 0x1B150, 0x1B152 },
	{ 0x1B164, 0x1B167 },
	{ 0x1B170, 0x1B2FB },
	{ 0x1F004, 0x1F004 },
	{ 0x1F0CF, 0x1F0CF },
	{ 0x1F18E, 0x1F18E },
	{ 0x1F191, 0x1F19A },
	{ 0x1F200, 0x1F202 },
	{ 0x1F210, 0x1F23B },
	{ 0x1F240, 0x1F248 },
	{ 0x1F250, 0x1F251 },
	{ 0x1F260, 0x1F265 },
	{ 0x1F300, 0x1F320 },
	{ 0x1F32D, 0x1F335 },
	{ 0x1F337, 0x1F37C },
	{ 0x1F37E, 0x1F393 },
	{ 0x1F3A0, 0x1F3CA },
	{ 0x1F3CF, 0x1F3D3 },
	{ 0x1F3E0, 0x1F3F0 },
	{ 0x1F3F4, 0x1F3F4 },
	{ 0x1F3F8, 0x1F43E },
	{ 0x1F440, 0x1F440 },
	{ 0x1F442, 0x1F4FC },
	{ 0x1F4FF, 0x1F53D },
	{ 0x1F54B, 0x1F54E },
	{ 0x1F550, 0x1F567 },
	{ 0x1F57A, 0x1F57A },
	{ 0x1F595, 0x1F596 },
	{ 0x1F5A4, 0x1F5A4 },
	{ 0x1F5FB, 0x1F64F },
	{ 0x1F680, 0x1F6C5 },
	{ 0x1F6CC, 0x1F6CC },
	{ 0x1F6D0, 0x1F6D2 },
	{ 0x1F6D5, 0x1F6D7 },
	{ 0x1F6EB, 0x1F6EC },
	{ 0x1F6F4, 0x1F6FC },
	{ 0x1F7E0, 0x1F7EB },
	{ 0x1F90C, 0x1F93A },
	{ 0x1F93C, 0x1F945 },
	{ 0x1F947, 0x1F978 },
	{ 0x1F97A, 0x1F9CB },
	{ 0x1F9CD, 0x1F9FF },
	{ 0x1FA70, 0x1FA74 },
	{ 0x1FA78, 0x1FA7A },
	{ 0x1FA80, 0x1FA86 },
	{ 0x1FA90, 0x1FAA8 },
	{ 0x1FAB0, 0x1FAB6 },
	{ 0x1FAC0, 0x1FAC2 },
	{ 0x1FAD0, 0x1FAD6 },
	{ 0x20000, 0x2FFFD },
	{ 0x30000, 0x3FFFD }
};

/* simple binary search in ranges, with bounds optimisation */
static size_t
mb_ucsbsearch(const struct mb_ucsrange arr[], size_t elems, unsigned int val)
{
	size_t min = 0, mid, max = elems;

	if (val < arr[min].beg || val > arr[max - 1].end)
		return ((size_t)-1);

	while (min < max) {
		mid = (min + max) / 2;

		if (val < arr[mid].beg)
			max = mid;
		else if (val > arr[mid].end)
			min = mid + 1;
		else
			return (mid);
	}
	return ((size_t)-1);
}

/* Modified for JOE: returns printed width of control and other non-printable
   characters */

/*XXX possibly more */
static const struct mb_ucsrange joe_ctrlchars[] = {
	{ 0x0080, 0x009F },
	{ 0x200B, 0x200F },
	{ 0x2028, 0x202E },
	{ 0x2060, 0x2063 },
	{ 0x2066, 0x206F },
	{ 0xD800, 0xDFFF },
	{ 0xFDD0, 0xFDEF },
	{ 0xFEFF, 0xFEFF },
	{ 0xFFF9, 0xFFFB }
};

/* returns column width of control character, 0 for regular */
unsigned char unictrlbuf[11];
int unictrl(unsigned int ucs)
{
	*unictrlbuf = 0;

	/* C0 control characters and raw octets use one screen column */
	if (ucs < 32 || ucs == 0x7F || (ucs & 0x80000000))
		return (1);

	/* not a control or noncharacter? */
	if (mb_ucsbsearch(joe_ctrlchars, NELEM(joe_ctrlchars),
	    ucs) == (size_t)-1 && (ucs & 0xFFFE) != 0xFFFE && ucs <= 0x10FFFF)
		return (0);

	return (joe_snprintf_1((char *)unictrlbuf, sizeof(unictrlbuf),
	    "<%X>", ucs));
}

int
joe_wcwidth(unsigned int ucs)
{
	int wide;

#ifndef TEST
	/* If terminal is not UTF-8 or file is not UTF-8: width is 1 */
	/* FIXME */
	if (!joe_maputf(locale_map))
		return (1);
#endif

	if ((wide = unictrl(ucs)))
		return (wide);

	/* combining characters use 0 screen columns */
	if (mb_ucsbsearch(mb_ucs_combining, NELEM(mb_ucs_combining), ucs) != (size_t)-1)
		return (0);

	/* all others use 1 or 2 screen columns */
	if (mb_ucsbsearch(mb_ucs_fullwidth, NELEM(mb_ucs_fullwidth), ucs) != (size_t)-1)
		return (2);
	return (1);
}

/* Macro for generating joe_iswXXX functions */

#define MAKE_ISW(what)						\
	int joe_isw##what(int c)				\
	{							\
		return ((mb_ucsbsearch(data_wctype_##what,	\
		    NELEM(data_wctype_##what),			\
		    c) != (size_t)-1) ? 1 : 0);			\
	}

/* MAKE_ISW functions... */

/* From: contrib/hosted/tg/jupptables,v 1.4 2017/07/08 14:53:45 tg Exp $ */

#ifdef TEST_I18N
static const struct mb_ucsrange data_wctype_upper[] = {
	{ 0x0041, 0x005A },
	{ 0x00C0, 0x00D6 },
	{ 0x00D8, 0x00DE },
	{ 0x0100, 0x0100 },
	{ 0x0102, 0x0102 },
	{ 0x0104, 0x0104 },
	{ 0x0106, 0x0106 },
	{ 0x0108, 0x0108 },
	{ 0x010A, 0x010A },
	{ 0x010C, 0x010C },
	{ 0x010E, 0x010E },
	{ 0x0110, 0x0110 },
	{ 0x0112, 0x0112 },
	{ 0x0114, 0x0114 },
	{ 0x0116, 0x0116 },
	{ 0x0118, 0x0118 },
	{ 0x011A, 0x011A },
	{ 0x011C, 0x011C },
	{ 0x011E, 0x011E },
	{ 0x0120, 0x0120 },
	{ 0x0122, 0x0122 },
	{ 0x0124, 0x0124 },
	{ 0x0126, 0x0126 },
	{ 0x0128, 0x0128 },
	{ 0x012A, 0x012A },
	{ 0x012C, 0x012C },
	{ 0x012E, 0x012E },
	{ 0x0130, 0x0130 },
	{ 0x0132, 0x0132 },
	{ 0x0134, 0x0134 },
	{ 0x0136, 0x0136 },
	{ 0x0139, 0x0139 },
	{ 0x013B, 0x013B },
	{ 0x013D, 0x013D },
	{ 0x013F, 0x013F },
	{ 0x0141, 0x0141 },
	{ 0x0143, 0x0143 },
	{ 0x0145, 0x0145 },
	{ 0x0147, 0x0147 },
	{ 0x014A, 0x014A },
	{ 0x014C, 0x014C },
	{ 0x014E, 0x014E },
	{ 0x0150, 0x0150 },
	{ 0x0152, 0x0152 },
	{ 0x0154, 0x0154 },
	{ 0x0156, 0x0156 },
	{ 0x0158, 0x0158 },
	{ 0x015A, 0x015A },
	{ 0x015C, 0x015C },
	{ 0x015E, 0x015E },
	{ 0x0160, 0x0160 },
	{ 0x0162, 0x0162 },
	{ 0x0164, 0x0164 },
	{ 0x0166, 0x0166 },
	{ 0x0168, 0x0168 },
	{ 0x016A, 0x016A },
	{ 0x016C, 0x016C },
	{ 0x016E, 0x016E },
	{ 0x0170, 0x0170 },
	{ 0x0172, 0x0172 },
	{ 0x0174, 0x0174 },
	{ 0x0176, 0x0176 },
	{ 0x0178, 0x0179 },
	{ 0x017B, 0x017B },
	{ 0x017D, 0x017D },
	{ 0x0181, 0x0182 },
	{ 0x0184, 0x0184 },
	{ 0x0186, 0x0187 },
	{ 0x0189, 0x018B },
	{ 0x018E, 0x0191 },
	{ 0x0193, 0x0194 },
	{ 0x0196, 0x0198 },
	{ 0x019C, 0x019D },
	{ 0x019F, 0x01A0 },
	{ 0x01A2, 0x01A2 },
	{ 0x01A4, 0x01A4 },
	{ 0x01A6, 0x01A7 },
	{ 0x01A9, 0x01A9 },
	{ 0x01AC, 0x01AC },
	{ 0x01AE, 0x01AF },
	{ 0x01B1, 0x01B3 },
	{ 0x01B5, 0x01B5 },
	{ 0x01B7, 0x01B8 },
	{ 0x01BC, 0x01BC },
	{ 0x01C4, 0x01C5 },
	{ 0x01C7, 0x01C8 },
	{ 0x01CA, 0x01CB },
	{ 0x01CD, 0x01CD },
	{ 0x01CF, 0x01CF },
	{ 0x01D1, 0x01D1 },
	{ 0x01D3, 0x01D3 },
	{ 0x01D5, 0x01D5 },
	{ 0x01D7, 0x01D7 },
	{ 0x01D9, 0x01D9 },
	{ 0x01DB, 0x01DB },
	{ 0x01DE, 0x01DE },
	{ 0x01E0, 0x01E0 },
	{ 0x01E2, 0x01E2 },
	{ 0x01E4, 0x01E4 },
	{ 0x01E6, 0x01E6 },
	{ 0x01E8, 0x01E8 },
	{ 0x01EA, 0x01EA },
	{ 0x01EC, 0x01EC },
	{ 0x01EE, 0x01EE },
	{ 0x01F1, 0x01F2 },
	{ 0x01F4, 0x01F4 },
	{ 0x01F6, 0x01F8 },
	{ 0x01FA, 0x01FA },
	{ 0x01FC, 0x01FC },
	{ 0x01FE, 0x01FE },
	{ 0x0200, 0x0200 },
	{ 0x0202, 0x0202 },
	{ 0x0204, 0x0204 },
	{ 0x0206, 0x0206 },
	{ 0x0208, 0x0208 },
	{ 0x020A, 0x020A },
	{ 0x020C, 0x020C },
	{ 0x020E, 0x020E },
	{ 0x0210, 0x0210 },
	{ 0x0212, 0x0212 },
	{ 0x0214, 0x0214 },
	{ 0x0216, 0x0216 },
	{ 0x0218, 0x0218 },
	{ 0x021A, 0x021A },
	{ 0x021C, 0x021C },
	{ 0x021E, 0x021E },
	{ 0x0220, 0x0220 },
	{ 0x0222, 0x0222 },
	{ 0x0224, 0x0224 },
	{ 0x0226, 0x0226 },
	{ 0x0228, 0x0228 },
	{ 0x022A, 0x022A },
	{ 0x022C, 0x022C },
	{ 0x022E, 0x022E },
	{ 0x0230, 0x0230 },
	{ 0x0232, 0x0232 },
	{ 0x023A, 0x023B },
	{ 0x023D, 0x023E },
	{ 0x0241, 0x0241 },
	{ 0x0243, 0x0246 },
	{ 0x0248, 0x0248 },
	{ 0x024A, 0x024A },
	{ 0x024C, 0x024C },
	{ 0x024E, 0x024E },
	{ 0x0370, 0x0370 },
	{ 0x0372, 0x0372 },
	{ 0x0376, 0x0376 },
	{ 0x037F, 0x037F },
	{ 0x0386, 0x0386 },
	{ 0x0388, 0x038A },
	{ 0x038C, 0x038C },
	{ 0x038E, 0x038F },
	{ 0x0391, 0x03A1 },
	{ 0x03A3, 0x03AB },
	{ 0x03CF, 0x03CF },
	{ 0x03D8, 0x03D8 },
	{ 0x03DA, 0x03DA },
	{ 0x03DC, 0x03DC },
	{ 0x03DE, 0x03DE },
	{ 0x03E0, 0x03E0 },
	{ 0x03E2, 0x03E2 },
	{ 0x03E4, 0x03E4 },
	{ 0x03E6, 0x03E6 },
	{ 0x03E8, 0x03E8 },
	{ 0x03EA, 0x03EA },
	{ 0x03EC, 0x03EC },
	{ 0x03EE, 0x03EE },
	{ 0x03F4, 0x03F4 },
	{ 0x03F7, 0x03F7 },
	{ 0x03F9, 0x03FA },
	{ 0x03FD, 0x042F },
	{ 0x0460, 0x0460 },
	{ 0x0462, 0x0462 },
	{ 0x0464, 0x0464 },
	{ 0x0466, 0x0466 },
	{ 0x0468, 0x0468 },
	{ 0x046A, 0x046A },
	{ 0x046C, 0x046C },
	{ 0x046E, 0x046E },
	{ 0x0470, 0x0470 },
	{ 0x0472, 0x0472 },
	{ 0x0474, 0x0474 },
	{ 0x0476, 0x0476 },
	{ 0x0478, 0x0478 },
	{ 0x047A, 0x047A },
	{ 0x047C, 0x047C },
	{ 0x047E, 0x047E },
	{ 0x0480, 0x0480 },
	{ 0x048A, 0x048A },
	{ 0x048C, 0x048C },
	{ 0x048E, 0x048E },
	{ 0x0490, 0x0490 },
	{ 0x0492, 0x0492 },
	{ 0x0494, 0x0494 },
	{ 0x0496, 0x0496 },
	{ 0x0498, 0x0498 },
	{ 0x049A, 0x049A },
	{ 0x049C, 0x049C },
	{ 0x049E, 0x049E },
	{ 0x04A0, 0x04A0 },
	{ 0x04A2, 0x04A2 },
	{ 0x04A4, 0x04A4 },
	{ 0x04A6, 0x04A6 },
	{ 0x04A8, 0x04A8 },
	{ 0x04AA, 0x04AA },
	{ 0x04AC, 0x04AC },
	{ 0x04AE, 0x04AE },
	{ 0x04B0, 0x04B0 },
	{ 0x04B2, 0x04B2 },
	{ 0x04B4, 0x04B4 },
	{ 0x04B6, 0x04B6 },
	{ 0x04B8, 0x04B8 },
	{ 0x04BA, 0x04BA },
	{ 0x04BC, 0x04BC },
	{ 0x04BE, 0x04BE },
	{ 0x04C0, 0x04C1 },
	{ 0x04C3, 0x04C3 },
	{ 0x04C5, 0x04C5 },
	{ 0x04C7, 0x04C7 },
	{ 0x04C9, 0x04C9 },
	{ 0x04CB, 0x04CB },
	{ 0x04CD, 0x04CD },
	{ 0x04D0, 0x04D0 },
	{ 0x04D2, 0x04D2 },
	{ 0x04D4, 0x04D4 },
	{ 0x04D6, 0x04D6 },
	{ 0x04D8, 0x04D8 },
	{ 0x04DA, 0x04DA },
	{ 0x04DC, 0x04DC },
	{ 0x04DE, 0x04DE },
	{ 0x04E0, 0x04E0 },
	{ 0x04E2, 0x04E2 },
	{ 0x04E4, 0x04E4 },
	{ 0x04E6, 0x04E6 },
	{ 0x04E8, 0x04E8 },
	{ 0x04EA, 0x04EA },
	{ 0x04EC, 0x04EC },
	{ 0x04EE, 0x04EE },
	{ 0x04F0, 0x04F0 },
	{ 0x04F2, 0x04F2 },
	{ 0x04F4, 0x04F4 },
	{ 0x04F6, 0x04F6 },
	{ 0x04F8, 0x04F8 },
	{ 0x04FA, 0x04FA },
	{ 0x04FC, 0x04FC },
	{ 0x04FE, 0x04FE },
	{ 0x0500, 0x0500 },
	{ 0x0502, 0x0502 },
	{ 0x0504, 0x0504 },
	{ 0x0506, 0x0506 },
	{ 0x0508, 0x0508 },
	{ 0x050A, 0x050A },
	{ 0x050C, 0x050C },
	{ 0x050E, 0x050E },
	{ 0x0510, 0x0510 },
	{ 0x0512, 0x0512 },
	{ 0x0514, 0x0514 },
	{ 0x0516, 0x0516 },
	{ 0x0518, 0x0518 },
	{ 0x051A, 0x051A },
	{ 0x051C, 0x051C },
	{ 0x051E, 0x051E },
	{ 0x0520, 0x0520 },
	{ 0x0522, 0x0522 },
	{ 0x0524, 0x0524 },
	{ 0x0526, 0x0526 },
	{ 0x0528, 0x0528 },
	{ 0x052A, 0x052A },
	{ 0x052C, 0x052C },
	{ 0x052E, 0x052E },
	{ 0x0531, 0x0556 },
	{ 0x10A0, 0x10C5 },
	{ 0x10C7, 0x10C7 },
	{ 0x10CD, 0x10CD },
	{ 0x13A0, 0x13F5 },
	{ 0x1C90, 0x1CBA },
	{ 0x1CBD, 0x1CBF },
	{ 0x1E00, 0x1E00 },
	{ 0x1E02, 0x1E02 },
	{ 0x1E04, 0x1E04 },
	{ 0x1E06, 0x1E06 },
	{ 0x1E08, 0x1E08 },
	{ 0x1E0A, 0x1E0A },
	{ 0x1E0C, 0x1E0C },
	{ 0x1E0E, 0x1E0E },
	{ 0x1E10, 0x1E10 },
	{ 0x1E12, 0x1E12 },
	{ 0x1E14, 0x1E14 },
	{ 0x1E16, 0x1E16 },
	{ 0x1E18, 0x1E18 },
	{ 0x1E1A, 0x1E1A },
	{ 0x1E1C, 0x1E1C },
	{ 0x1E1E, 0x1E1E },
	{ 0x1E20, 0x1E20 },
	{ 0x1E22, 0x1E22 },
	{ 0x1E24, 0x1E24 },
	{ 0x1E26, 0x1E26 },
	{ 0x1E28, 0x1E28 },
	{ 0x1E2A, 0x1E2A },
	{ 0x1E2C, 0x1E2C },
	{ 0x1E2E, 0x1E2E },
	{ 0x1E30, 0x1E30 },
	{ 0x1E32, 0x1E32 },
	{ 0x1E34, 0x1E34 },
	{ 0x1E36, 0x1E36 },
	{ 0x1E38, 0x1E38 },
	{ 0x1E3A, 0x1E3A },
	{ 0x1E3C, 0x1E3C },
	{ 0x1E3E, 0x1E3E },
	{ 0x1E40, 0x1E40 },
	{ 0x1E42, 0x1E42 },
	{ 0x1E44, 0x1E44 },
	{ 0x1E46, 0x1E46 },
	{ 0x1E48, 0x1E48 },
	{ 0x1E4A, 0x1E4A },
	{ 0x1E4C, 0x1E4C },
	{ 0x1E4E, 0x1E4E },
	{ 0x1E50, 0x1E50 },
	{ 0x1E52, 0x1E52 },
	{ 0x1E54, 0x1E54 },
	{ 0x1E56, 0x1E56 },
	{ 0x1E58, 0x1E58 },
	{ 0x1E5A, 0x1E5A },
	{ 0x1E5C, 0x1E5C },
	{ 0x1E5E, 0x1E5E },
	{ 0x1E60, 0x1E60 },
	{ 0x1E62, 0x1E62 },
	{ 0x1E64, 0x1E64 },
	{ 0x1E66, 0x1E66 },
	{ 0x1E68, 0x1E68 },
	{ 0x1E6A, 0x1E6A },
	{ 0x1E6C, 0x1E6C },
	{ 0x1E6E, 0x1E6E },
	{ 0x1E70, 0x1E70 },
	{ 0x1E72, 0x1E72 },
	{ 0x1E74, 0x1E74 },
	{ 0x1E76, 0x1E76 },
	{ 0x1E78, 0x1E78 },
	{ 0x1E7A, 0x1E7A },
	{ 0x1E7C, 0x1E7C },
	{ 0x1E7E, 0x1E7E },
	{ 0x1E80, 0x1E80 },
	{ 0x1E82, 0x1E82 },
	{ 0x1E84, 0x1E84 },
	{ 0x1E86, 0x1E86 },
	{ 0x1E88, 0x1E88 },
	{ 0x1E8A, 0x1E8A },
	{ 0x1E8C, 0x1E8C },
	{ 0x1E8E, 0x1E8E },
	{ 0x1E90, 0x1E90 },
	{ 0x1E92, 0x1E92 },
	{ 0x1E94, 0x1E94 },
	{ 0x1E9E, 0x1E9E },
	{ 0x1EA0, 0x1EA0 },
	{ 0x1EA2, 0x1EA2 },
	{ 0x1EA4, 0x1EA4 },
	{ 0x1EA6, 0x1EA6 },
	{ 0x1EA8, 0x1EA8 },
	{ 0x1EAA, 0x1EAA },
	{ 0x1EAC, 0x1EAC },
	{ 0x1EAE, 0x1EAE },
	{ 0x1EB0, 0x1EB0 },
	{ 0x1EB2, 0x1EB2 },
	{ 0x1EB4, 0x1EB4 },
	{ 0x1EB6, 0x1EB6 },
	{ 0x1EB8, 0x1EB8 },
	{ 0x1EBA, 0x1EBA },
	{ 0x1EBC, 0x1EBC },
	{ 0x1EBE, 0x1EBE },
	{ 0x1EC0, 0x1EC0 },
	{ 0x1EC2, 0x1EC2 },
	{ 0x1EC4, 0x1EC4 },
	{ 0x1EC6, 0x1EC6 },
	{ 0x1EC8, 0x1EC8 },
	{ 0x1ECA, 0x1ECA },
	{ 0x1ECC, 0x1ECC },
	{ 0x1ECE, 0x1ECE },
	{ 0x1ED0, 0x1ED0 },
	{ 0x1ED2, 0x1ED2 },
	{ 0x1ED4, 0x1ED4 },
	{ 0x1ED6, 0x1ED6 },
	{ 0x1ED8, 0x1ED8 },
	{ 0x1EDA, 0x1EDA },
	{ 0x1EDC, 0x1EDC },
	{ 0x1EDE, 0x1EDE },
	{ 0x1EE0, 0x1EE0 },
	{ 0x1EE2, 0x1EE2 },
	{ 0x1EE4, 0x1EE4 },
	{ 0x1EE6, 0x1EE6 },
	{ 0x1EE8, 0x1EE8 },
	{ 0x1EEA, 0x1EEA },
	{ 0x1EEC, 0x1EEC },
	{ 0x1EEE, 0x1EEE },
	{ 0x1EF0, 0x1EF0 },
	{ 0x1EF2, 0x1EF2 },
	{ 0x1EF4, 0x1EF4 },
	{ 0x1EF6, 0x1EF6 },
	{ 0x1EF8, 0x1EF8 },
	{ 0x1EFA, 0x1EFA },
	{ 0x1EFC, 0x1EFC },
	{ 0x1EFE, 0x1EFE },
	{ 0x1F08, 0x1F0F },
	{ 0x1F18, 0x1F1D },
	{ 0x1F28, 0x1F2F },
	{ 0x1F38, 0x1F3F },
	{ 0x1F48, 0x1F4D },
	{ 0x1F59, 0x1F59 },
	{ 0x1F5B, 0x1F5B },
	{ 0x1F5D, 0x1F5D },
	{ 0x1F5F, 0x1F5F },
	{ 0x1F68, 0x1F6F },
	{ 0x1F88, 0x1F8F },
	{ 0x1F98, 0x1F9F },
	{ 0x1FA8, 0x1FAF },
	{ 0x1FB8, 0x1FBC },
	{ 0x1FC8, 0x1FCC },
	{ 0x1FD8, 0x1FDB },
	{ 0x1FE8, 0x1FEC },
	{ 0x1FF8, 0x1FFC },
	{ 0x2126, 0x2126 },
	{ 0x212A, 0x212B },
	{ 0x2132, 0x2132 },
	{ 0x2160, 0x216F },
	{ 0x2183, 0x2183 },
	{ 0x24B6, 0x24CF },
	{ 0x2C00, 0x2C2E },
	{ 0x2C60, 0x2C60 },
	{ 0x2C62, 0x2C64 },
	{ 0x2C67, 0x2C67 },
	{ 0x2C69, 0x2C69 },
	{ 0x2C6B, 0x2C6B },
	{ 0x2C6D, 0x2C70 },
	{ 0x2C72, 0x2C72 },
	{ 0x2C75, 0x2C75 },
	{ 0x2C7E, 0x2C80 },
	{ 0x2C82, 0x2C82 },
	{ 0x2C84, 0x2C84 },
	{ 0x2C86, 0x2C86 },
	{ 0x2C88, 0x2C88 },
	{ 0x2C8A, 0x2C8A },
	{ 0x2C8C, 0x2C8C },
	{ 0x2C8E, 0x2C8E },
	{ 0x2C90, 0x2C90 },
	{ 0x2C92, 0x2C92 },
	{ 0x2C94, 0x2C94 },
	{ 0x2C96, 0x2C96 },
	{ 0x2C98, 0x2C98 },
	{ 0x2C9A, 0x2C9A },
	{ 0x2C9C, 0x2C9C },
	{ 0x2C9E, 0x2C9E },
	{ 0x2CA0, 0x2CA0 },
	{ 0x2CA2, 0x2CA2 },
	{ 0x2CA4, 0x2CA4 },
	{ 0x2CA6, 0x2CA6 },
	{ 0x2CA8, 0x2CA8 },
	{ 0x2CAA, 0x2CAA },
	{ 0x2CAC, 0x2CAC },
	{ 0x2CAE, 0x2CAE },
	{ 0x2CB0, 0x2CB0 },
	{ 0x2CB2, 0x2CB2 },
	{ 0x2CB4, 0x2CB4 },
	{ 0x2CB6, 0x2CB6 },
	{ 0x2CB8, 0x2CB8 },
	{ 0x2CBA, 0x2CBA },
	{ 0x2CBC, 0x2CBC },
	{ 0x2CBE, 0x2CBE },
	{ 0x2CC0, 0x2CC0 },
	{ 0x2CC2, 0x2CC2 },
	{ 0x2CC4, 0x2CC4 },
	{ 0x2CC6, 0x2CC6 },
	{ 0x2CC8, 0x2CC8 },
	{ 0x2CCA, 0x2CCA },
	{ 0x2CCC, 0x2CCC },
	{ 0x2CCE, 0x2CCE },
	{ 0x2CD0, 0x2CD0 },
	{ 0x2CD2, 0x2CD2 },
	{ 0x2CD4, 0x2CD4 },
	{ 0x2CD6, 0x2CD6 },
	{ 0x2CD8, 0x2CD8 },
	{ 0x2CDA, 0x2CDA },
	{ 0x2CDC, 0x2CDC },
	{ 0x2CDE, 0x2CDE },
	{ 0x2CE0, 0x2CE0 },
	{ 0x2CE2, 0x2CE2 },
	{ 0x2CEB, 0x2CEB },
	{ 0x2CED, 0x2CED },
	{ 0x2CF2, 0x2CF2 },
	{ 0xA640, 0xA640 },
	{ 0xA642, 0xA642 },
	{ 0xA644, 0xA644 },
	{ 0xA646, 0xA646 },
	{ 0xA648, 0xA648 },
	{ 0xA64A, 0xA64A },
	{ 0xA64C, 0xA64C },
	{ 0xA64E, 0xA64E },
	{ 0xA650, 0xA650 },
	{ 0xA652, 0xA652 },
	{ 0xA654, 0xA654 },
	{ 0xA656, 0xA656 },
	{ 0xA658, 0xA658 },
	{ 0xA65A, 0xA65A },
	{ 0xA65C, 0xA65C },
	{ 0xA65E, 0xA65E },
	{ 0xA660, 0xA660 },
	{ 0xA662, 0xA662 },
	{ 0xA664, 0xA664 },
	{ 0xA666, 0xA666 },
	{ 0xA668, 0xA668 },
	{ 0xA66A, 0xA66A },
	{ 0xA66C, 0xA66C },
	{ 0xA680, 0xA680 },
	{ 0xA682, 0xA682 },
	{ 0xA684, 0xA684 },
	{ 0xA686, 0xA686 },
	{ 0xA688, 0xA688 },
	{ 0xA68A, 0xA68A },
	{ 0xA68C, 0xA68C },
	{ 0xA68E, 0xA68E },
	{ 0xA690, 0xA690 },
	{ 0xA692, 0xA692 },
	{ 0xA694, 0xA694 },
	{ 0xA696, 0xA696 },
	{ 0xA698, 0xA698 },
	{ 0xA69A, 0xA69A },
	{ 0xA722, 0xA722 },
	{ 0xA724, 0xA724 },
	{ 0xA726, 0xA726 },
	{ 0xA728, 0xA728 },
	{ 0xA72A, 0xA72A },
	{ 0xA72C, 0xA72C },
	{ 0xA72E, 0xA72E },
	{ 0xA732, 0xA732 },
	{ 0xA734, 0xA734 },
	{ 0xA736, 0xA736 },
	{ 0xA738, 0xA738 },
	{ 0xA73A, 0xA73A },
	{ 0xA73C, 0xA73C },
	{ 0xA73E, 0xA73E },
	{ 0xA740, 0xA740 },
	{ 0xA742, 0xA742 },
	{ 0xA744, 0xA744 },
	{ 0xA746, 0xA746 },
	{ 0xA748, 0xA748 },
	{ 0xA74A, 0xA74A },
	{ 0xA74C, 0xA74C },
	{ 0xA74E, 0xA74E },
	{ 0xA750, 0xA750 },
	{ 0xA752, 0xA752 },
	{ 0xA754, 0xA754 },
	{ 0xA756, 0xA756 },
	{ 0xA758, 0xA758 },
	{ 0xA75A, 0xA75A },
	{ 0xA75C, 0xA75C },
	{ 0xA75E, 0xA75E },
	{ 0xA760, 0xA760 },
	{ 0xA762, 0xA762 },
	{ 0xA764, 0xA764 },
	{ 0xA766, 0xA766 },
	{ 0xA768, 0xA768 },
	{ 0xA76A, 0xA76A },
	{ 0xA76C, 0xA76C },
	{ 0xA76E, 0xA76E },
	{ 0xA779, 0xA779 },
	{ 0xA77B, 0xA77B },
	{ 0xA77D, 0xA77E },
	{ 0xA780, 0xA780 },
	{ 0xA782, 0xA782 },
	{ 0xA784, 0xA784 },
	{ 0xA786, 0xA786 },
	{ 0xA78B, 0xA78B },
	{ 0xA78D, 0xA78D },
	{ 0xA790, 0xA790 },
	{ 0xA792, 0xA792 },
	{ 0xA796, 0xA796 },
	{ 0xA798, 0xA798 },
	{ 0xA79A, 0xA79A },
	{ 0xA79C, 0xA79C },
	{ 0xA79E, 0xA79E },
	{ 0xA7A0, 0xA7A0 },
	{ 0xA7A2, 0xA7A2 },
	{ 0xA7A4, 0xA7A4 },
	{ 0xA7A6, 0xA7A6 },
	{ 0xA7A8, 0xA7A8 },
	{ 0xA7AA, 0xA7AE },
	{ 0xA7B0, 0xA7B4 },
	{ 0xA7B6, 0xA7B6 },
	{ 0xA7B8, 0xA7B8 },
	{ 0xA7BA, 0xA7BA },
	{ 0xA7BC, 0xA7BC },
	{ 0xA7BE, 0xA7BE },
	{ 0xA7C2, 0xA7C2 },
	{ 0xA7C4, 0xA7C7 },
	{ 0xA7C9, 0xA7C9 },
	{ 0xA7F5, 0xA7F5 },
	{ 0xFF21, 0xFF3A },
	{ 0x10400, 0x10427 },
	{ 0x104B0, 0x104D3 },
	{ 0x10C80, 0x10CB2 },
	{ 0x118A0, 0x118BF },
	{ 0x16E40, 0x16E5F },
	{ 0x1E900, 0x1E921 }
};

MAKE_ISW(upper)

static const struct mb_ucsrange data_wctype_lower[] = {
	{ 0x0061, 0x007A },
	{ 0x00B5, 0x00B5 },
	{ 0x00E0, 0x00F6 },
	{ 0x00F8, 0x00FF },
	{ 0x0101, 0x0101 },
	{ 0x0103, 0x0103 },
	{ 0x0105, 0x0105 },
	{ 0x0107, 0x0107 },
	{ 0x0109, 0x0109 },
	{ 0x010B, 0x010B },
	{ 0x010D, 0x010D },
	{ 0x010F, 0x010F },
	{ 0x0111, 0x0111 },
	{ 0x0113, 0x0113 },
	{ 0x0115, 0x0115 },
	{ 0x0117, 0x0117 },
	{ 0x0119, 0x0119 },
	{ 0x011B, 0x011B },
	{ 0x011D, 0x011D },
	{ 0x011F, 0x011F },
	{ 0x0121, 0x0121 },
	{ 0x0123, 0x0123 },
	{ 0x0125, 0x0125 },
	{ 0x0127, 0x0127 },
	{ 0x0129, 0x0129 },
	{ 0x012B, 0x012B },
	{ 0x012D, 0x012D },
	{ 0x012F, 0x012F },
	{ 0x0131, 0x0131 },
	{ 0x0133, 0x0133 },
	{ 0x0135, 0x0135 },
	{ 0x0137, 0x0137 },
	{ 0x013A, 0x013A },
	{ 0x013C, 0x013C },
	{ 0x013E, 0x013E },
	{ 0x0140, 0x0140 },
	{ 0x0142, 0x0142 },
	{ 0x0144, 0x0144 },
	{ 0x0146, 0x0146 },
	{ 0x0148, 0x0148 },
	{ 0x014B, 0x014B },
	{ 0x014D, 0x014D },
	{ 0x014F, 0x014F },
	{ 0x0151, 0x0151 },
	{ 0x0153, 0x0153 },
	{ 0x0155, 0x0155 },
	{ 0x0157, 0x0157 },
	{ 0x0159, 0x0159 },
	{ 0x015B, 0x015B },
	{ 0x015D, 0x015D },
	{ 0x015F, 0x015F },
	{ 0x0161, 0x0161 },
	{ 0x0163, 0x0163 },
	{ 0x0165, 0x0165 },
	{ 0x0167, 0x0167 },
	{ 0x0169, 0x0169 },
	{ 0x016B, 0x016B },
	{ 0x016D, 0x016D },
	{ 0x016F, 0x016F },
	{ 0x0171, 0x0171 },
	{ 0x0173, 0x0173 },
	{ 0x0175, 0x0175 },
	{ 0x0177, 0x0177 },
	{ 0x017A, 0x017A },
	{ 0x017C, 0x017C },
	{ 0x017E, 0x0180 },
	{ 0x0183, 0x0183 },
	{ 0x0185, 0x0185 },
	{ 0x0188, 0x0188 },
	{ 0x018C, 0x018C },
	{ 0x0192, 0x0192 },
	{ 0x0195, 0x0195 },
	{ 0x0199, 0x019A },
	{ 0x019E, 0x019E },
	{ 0x01A1, 0x01A1 },
	{ 0x01A3, 0x01A3 },
	{ 0x01A5, 0x01A5 },
	{ 0x01A8, 0x01A8 },
	{ 0x01AD, 0x01AD },
	{ 0x01B0, 0x01B0 },
	{ 0x01B4, 0x01B4 },
	{ 0x01B6, 0x01B6 },
	{ 0x01B9, 0x01B9 },
	{ 0x01BD, 0x01BD },
	{ 0x01BF, 0x01BF },
	{ 0x01C6, 0x01C6 },
	{ 0x01C9, 0x01C9 },
	{ 0x01CC, 0x01CC },
	{ 0x01CE, 0x01CE },
	{ 0x01D0, 0x01D0 },
	{ 0x01D2, 0x01D2 },
	{ 0x01D4, 0x01D4 },
	{ 0x01D6, 0x01D6 },
	{ 0x01D8, 0x01D8 },
	{ 0x01DA, 0x01DA },
	{ 0x01DC, 0x01DD },
	{ 0x01DF, 0x01DF },
	{ 0x01E1, 0x01E1 },
	{ 0x01E3, 0x01E3 },
	{ 0x01E5, 0x01E5 },
	{ 0x01E7, 0x01E7 },
	{ 0x01E9, 0x01E9 },
	{ 0x01EB, 0x01EB },
	{ 0x01ED, 0x01ED },
	{ 0x01EF, 0x01EF },
	{ 0x01F3, 0x01F3 },
	{ 0x01F5, 0x01F5 },
	{ 0x01F9, 0x01F9 },
	{ 0x01FB, 0x01FB },
	{ 0x01FD, 0x01FD },
	{ 0x01FF, 0x01FF },
	{ 0x0201, 0x0201 },
	{ 0x0203, 0x0203 },
	{ 0x0205, 0x0205 },
	{ 0x0207, 0x0207 },
	{ 0x0209, 0x0209 },
	{ 0x020B, 0x020B },
	{ 0x020D, 0x020D },
	{ 0x020F, 0x020F },
	{ 0x0211, 0x0211 },
	{ 0x0213, 0x0213 },
	{ 0x0215, 0x0215 },
	{ 0x0217, 0x0217 },
	{ 0x0219, 0x0219 },
	{ 0x021B, 0x021B },
	{ 0x021D, 0x021D },
	{ 0x021F, 0x021F },
	{ 0x0223, 0x0223 },
	{ 0x0225, 0x0225 },
	{ 0x0227, 0x0227 },
	{ 0x0229, 0x0229 },
	{ 0x022B, 0x022B },
	{ 0x022D, 0x022D },
	{ 0x022F, 0x022F },
	{ 0x0231, 0x0231 },
	{ 0x0233, 0x0233 },
	{ 0x023C, 0x023C },
	{ 0x023F, 0x0240 },
	{ 0x0242, 0x0242 },
	{ 0x0247, 0x0247 },
	{ 0x0249, 0x0249 },
	{ 0x024B, 0x024B },
	{ 0x024D, 0x024D },
	{ 0x024F, 0x0254 },
	{ 0x0256, 0x0257 },
	{ 0x0259, 0x0259 },
	{ 0x025B, 0x025C },
	{ 0x0260, 0x0261 },
	{ 0x0263, 0x0263 },
	{ 0x0265, 0x0266 },
	{ 0x0268, 0x026C },
	{ 0x026F, 0x026F },
	{ 0x0271, 0x0272 },
	{ 0x0275, 0x0275 },
	{ 0x027D, 0x027D },
	{ 0x0280, 0x0280 },
	{ 0x0282, 0x0283 },
	{ 0x0287, 0x028C },
	{ 0x0292, 0x0292 },
	{ 0x029D, 0x029E },
	{ 0x0345, 0x0345 },
	{ 0x0371, 0x0371 },
	{ 0x0373, 0x0373 },
	{ 0x0377, 0x0377 },
	{ 0x037B, 0x037D },
	{ 0x03AC, 0x03AF },
	{ 0x03B1, 0x03CE },
	{ 0x03D0, 0x03D1 },
	{ 0x03D5, 0x03D7 },
	{ 0x03D9, 0x03D9 },
	{ 0x03DB, 0x03DB },
	{ 0x03DD, 0x03DD },
	{ 0x03DF, 0x03DF },
	{ 0x03E1, 0x03E1 },
	{ 0x03E3, 0x03E3 },
	{ 0x03E5, 0x03E5 },
	{ 0x03E7, 0x03E7 },
	{ 0x03E9, 0x03E9 },
	{ 0x03EB, 0x03EB },
	{ 0x03ED, 0x03ED },
	{ 0x03EF, 0x03F3 },
	{ 0x03F5, 0x03F5 },
	{ 0x03F8, 0x03F8 },
	{ 0x03FB, 0x03FB },
	{ 0x0430, 0x045F },
	{ 0x0461, 0x0461 },
	{ 0x0463, 0x0463 },
	{ 0x0465, 0x0465 },
	{ 0x0467, 0x0467 },
	{ 0x0469, 0x0469 },
	{ 0x046B, 0x046B },
	{ 0x046D, 0x046D },
	{ 0x046F, 0x046F },
	{ 0x0471, 0x0471 },
	{ 0x0473, 0x0473 },
	{ 0x0475, 0x0475 },
	{ 0x0477, 0x0477 },
	{ 0x0479, 0x0479 },
	{ 0x047B, 0x047B },
	{ 0x047D, 0x047D },
	{ 0x047F, 0x047F },
	{ 0x0481, 0x0481 },
	{ 0x048B, 0x048B },
	{ 0x048D, 0x048D },
	{ 0x048F, 0x048F },
	{ 0x0491, 0x0491 },
	{ 0x0493, 0x0493 },
	{ 0x0495, 0x0495 },
	{ 0x0497, 0x0497 },
	{ 0x0499, 0x0499 },
	{ 0x049B, 0x049B },
	{ 0x049D, 0x049D },
	{ 0x049F, 0x049F },
	{ 0x04A1, 0x04A1 },
	{ 0x04A3, 0x04A3 },
	{ 0x04A5, 0x04A5 },
	{ 0x04A7, 0x04A7 },
	{ 0x04A9, 0x04A9 },
	{ 0x04AB, 0x04AB },
	{ 0x04AD, 0x04AD },
	{ 0x04AF, 0x04AF },
	{ 0x04B1, 0x04B1 },
	{ 0x04B3, 0x04B3 },
	{ 0x04B5, 0x04B5 },
	{ 0x04B7, 0x04B7 },
	{ 0x04B9, 0x04B9 },
	{ 0x04BB, 0x04BB },
	{ 0x04BD, 0x04BD },
	{ 0x04BF, 0x04BF },
	{ 0x04C2, 0x04C2 },
	{ 0x04C4, 0x04C4 },
	{ 0x04C6, 0x04C6 },
	{ 0x04C8, 0x04C8 },
	{ 0x04CA, 0x04CA },
	{ 0x04CC, 0x04CC },
	{ 0x04CE, 0x04CF },
	{ 0x04D1, 0x04D1 },
	{ 0x04D3, 0x04D3 },
	{ 0x04D5, 0x04D5 },
	{ 0x04D7, 0x04D7 },
	{ 0x04D9, 0x04D9 },
	{ 0x04DB, 0x04DB },
	{ 0x04DD, 0x04DD },
	{ 0x04DF, 0x04DF },
	{ 0x04E1, 0x04E1 },
	{ 0x04E3, 0x04E3 },
	{ 0x04E5, 0x04E5 },
	{ 0x04E7, 0x04E7 },
	{ 0x04E9, 0x04E9 },
	{ 0x04EB, 0x04EB },
	{ 0x04ED, 0x04ED },
	{ 0x04EF, 0x04EF },
	{ 0x04F1, 0x04F1 },
	{ 0x04F3, 0x04F3 },
	{ 0x04F5, 0x04F5 },
	{ 0x04F7, 0x04F7 },
	{ 0x04F9, 0x04F9 },
	{ 0x04FB, 0x04FB },
	{ 0x04FD, 0x04FD },
	{ 0x04FF, 0x04FF },
	{ 0x0501, 0x0501 },
	{ 0x0503, 0x0503 },
	{ 0x0505, 0x0505 },
	{ 0x0507, 0x0507 },
	{ 0x0509, 0x0509 },
	{ 0x050B, 0x050B },
	{ 0x050D, 0x050D },
	{ 0x050F, 0x050F },
	{ 0x0511, 0x0511 },
	{ 0x0513, 0x0513 },
	{ 0x0515, 0x0515 },
	{ 0x0517, 0x0517 },
	{ 0x0519, 0x0519 },
	{ 0x051B, 0x051B },
	{ 0x051D, 0x051D },
	{ 0x051F, 0x051F },
	{ 0x0521, 0x0521 },
	{ 0x0523, 0x0523 },
	{ 0x0525, 0x0525 },
	{ 0x0527, 0x0527 },
	{ 0x0529, 0x0529 },
	{ 0x052B, 0x052B },
	{ 0x052D, 0x052D },
	{ 0x052F, 0x052F },
	{ 0x0561, 0x0586 },
	{ 0x10D0, 0x10FA },
	{ 0x10FD, 0x10FF },
	{ 0x13F8, 0x13FD },
	{ 0x1C80, 0x1C88 },
	{ 0x1D79, 0x1D79 },
	{ 0x1D7D, 0x1D7D },
	{ 0x1D8E, 0x1D8E },
	{ 0x1E01, 0x1E01 },
	{ 0x1E03, 0x1E03 },
	{ 0x1E05, 0x1E05 },
	{ 0x1E07, 0x1E07 },
	{ 0x1E09, 0x1E09 },
	{ 0x1E0B, 0x1E0B },
	{ 0x1E0D, 0x1E0D },
	{ 0x1E0F, 0x1E0F },
	{ 0x1E11, 0x1E11 },
	{ 0x1E13, 0x1E13 },
	{ 0x1E15, 0x1E15 },
	{ 0x1E17, 0x1E17 },
	{ 0x1E19, 0x1E19 },
	{ 0x1E1B, 0x1E1B },
	{ 0x1E1D, 0x1E1D },
	{ 0x1E1F, 0x1E1F },
	{ 0x1E21, 0x1E21 },
	{ 0x1E23, 0x1E23 },
	{ 0x1E25, 0x1E25 },
	{ 0x1E27, 0x1E27 },
	{ 0x1E29, 0x1E29 },
	{ 0x1E2B, 0x1E2B },
	{ 0x1E2D, 0x1E2D },
	{ 0x1E2F, 0x1E2F },
	{ 0x1E31, 0x1E31 },
	{ 0x1E33, 0x1E33 },
	{ 0x1E35, 0x1E35 },
	{ 0x1E37, 0x1E37 },
	{ 0x1E39, 0x1E39 },
	{ 0x1E3B, 0x1E3B },
	{ 0x1E3D, 0x1E3D },
	{ 0x1E3F, 0x1E3F },
	{ 0x1E41, 0x1E41 },
	{ 0x1E43, 0x1E43 },
	{ 0x1E45, 0x1E45 },
	{ 0x1E47, 0x1E47 },
	{ 0x1E49, 0x1E49 },
	{ 0x1E4B, 0x1E4B },
	{ 0x1E4D, 0x1E4D },
	{ 0x1E4F, 0x1E4F },
	{ 0x1E51, 0x1E51 },
	{ 0x1E53, 0x1E53 },
	{ 0x1E55, 0x1E55 },
	{ 0x1E57, 0x1E57 },
	{ 0x1E59, 0x1E59 },
	{ 0x1E5B, 0x1E5B },
	{ 0x1E5D, 0x1E5D },
	{ 0x1E5F, 0x1E5F },
	{ 0x1E61, 0x1E61 },
	{ 0x1E63, 0x1E63 },
	{ 0x1E65, 0x1E65 },
	{ 0x1E67, 0x1E67 },
	{ 0x1E69, 0x1E69 },
	{ 0x1E6B, 0x1E6B },
	{ 0x1E6D, 0x1E6D },
	{ 0x1E6F, 0x1E6F },
	{ 0x1E71, 0x1E71 },
	{ 0x1E73, 0x1E73 },
	{ 0x1E75, 0x1E75 },
	{ 0x1E77, 0x1E77 },
	{ 0x1E79, 0x1E79 },
	{ 0x1E7B, 0x1E7B },
	{ 0x1E7D, 0x1E7D },
	{ 0x1E7F, 0x1E7F },
	{ 0x1E81, 0x1E81 },
	{ 0x1E83, 0x1E83 },
	{ 0x1E85, 0x1E85 },
	{ 0x1E87, 0x1E87 },
	{ 0x1E89, 0x1E89 },
	{ 0x1E8B, 0x1E8B },
	{ 0x1E8D, 0x1E8D },
	{ 0x1E8F, 0x1E8F },
	{ 0x1E91, 0x1E91 },
	{ 0x1E93, 0x1E93 },
	{ 0x1E95, 0x1E95 },
	{ 0x1E9B, 0x1E9B },
	{ 0x1EA1, 0x1EA1 },
	{ 0x1EA3, 0x1EA3 },
	{ 0x1EA5, 0x1EA5 },
	{ 0x1EA7, 0x1EA7 },
	{ 0x1EA9, 0x1EA9 },
	{ 0x1EAB, 0x1EAB },
	{ 0x1EAD, 0x1EAD },
	{ 0x1EAF, 0x1EAF },
	{ 0x1EB1, 0x1EB1 },
	{ 0x1EB3, 0x1EB3 },
	{ 0x1EB5, 0x1EB5 },
	{ 0x1EB7, 0x1EB7 },
	{ 0x1EB9, 0x1EB9 },
	{ 0x1EBB, 0x1EBB },
	{ 0x1EBD, 0x1EBD },
	{ 0x1EBF, 0x1EBF },
	{ 0x1EC1, 0x1EC1 },
	{ 0x1EC3, 0x1EC3 },
	{ 0x1EC5, 0x1EC5 },
	{ 0x1EC7, 0x1EC7 },
	{ 0x1EC9, 0x1EC9 },
	{ 0x1ECB, 0x1ECB },
	{ 0x1ECD, 0x1ECD },
	{ 0x1ECF, 0x1ECF },
	{ 0x1ED1, 0x1ED1 },
	{ 0x1ED3, 0x1ED3 },
	{ 0x1ED5, 0x1ED5 },
	{ 0x1ED7, 0x1ED7 },
	{ 0x1ED9, 0x1ED9 },
	{ 0x1EDB, 0x1EDB },
	{ 0x1EDD, 0x1EDD },
	{ 0x1EDF, 0x1EDF },
	{ 0x1EE1, 0x1EE1 },
	{ 0x1EE3, 0x1EE3 },
	{ 0x1EE5, 0x1EE5 },
	{ 0x1EE7, 0x1EE7 },
	{ 0x1EE9, 0x1EE9 },
	{ 0x1EEB, 0x1EEB },
	{ 0x1EED, 0x1EED },
	{ 0x1EEF, 0x1EEF },
	{ 0x1EF1, 0x1EF1 },
	{ 0x1EF3, 0x1EF3 },
	{ 0x1EF5, 0x1EF5 },
	{ 0x1EF7, 0x1EF7 },
	{ 0x1EF9, 0x1EF9 },
	{ 0x1EFB, 0x1EFB },
	{ 0x1EFD, 0x1EFD },
	{ 0x1EFF, 0x1F07 },
	{ 0x1F10, 0x1F15 },
	{ 0x1F20, 0x1F27 },
	{ 0x1F30, 0x1F37 },
	{ 0x1F40, 0x1F45 },
	{ 0x1F51, 0x1F51 },
	{ 0x1F53, 0x1F53 },
	{ 0x1F55, 0x1F55 },
	{ 0x1F57, 0x1F57 },
	{ 0x1F60, 0x1F67 },
	{ 0x1F70, 0x1F7D },
	{ 0x1F80, 0x1F87 },
	{ 0x1F90, 0x1F97 },
	{ 0x1FA0, 0x1FA7 },
	{ 0x1FB0, 0x1FB1 },
	{ 0x1FB3, 0x1FB3 },
	{ 0x1FBE, 0x1FBE },
	{ 0x1FC3, 0x1FC3 },
	{ 0x1FD0, 0x1FD1 },
	{ 0x1FE0, 0x1FE1 },
	{ 0x1FE5, 0x1FE5 },
	{ 0x1FF3, 0x1FF3 },
	{ 0x214E, 0x214E },
	{ 0x2170, 0x217F },
	{ 0x2184, 0x2184 },
	{ 0x24D0, 0x24E9 },
	{ 0x2C30, 0x2C5E },
	{ 0x2C61, 0x2C61 },
	{ 0x2C65, 0x2C66 },
	{ 0x2C68, 0x2C68 },
	{ 0x2C6A, 0x2C6A },
	{ 0x2C6C, 0x2C6C },
	{ 0x2C73, 0x2C73 },
	{ 0x2C76, 0x2C76 },
	{ 0x2C81, 0x2C81 },
	{ 0x2C83, 0x2C83 },
	{ 0x2C85, 0x2C85 },
	{ 0x2C87, 0x2C87 },
	{ 0x2C89, 0x2C89 },
	{ 0x2C8B, 0x2C8B },
	{ 0x2C8D, 0x2C8D },
	{ 0x2C8F, 0x2C8F },
	{ 0x2C91, 0x2C91 },
	{ 0x2C93, 0x2C93 },
	{ 0x2C95, 0x2C95 },
	{ 0x2C97, 0x2C97 },
	{ 0x2C99, 0x2C99 },
	{ 0x2C9B, 0x2C9B },
	{ 0x2C9D, 0x2C9D },
	{ 0x2C9F, 0x2C9F },
	{ 0x2CA1, 0x2CA1 },
	{ 0x2CA3, 0x2CA3 },
	{ 0x2CA5, 0x2CA5 },
	{ 0x2CA7, 0x2CA7 },
	{ 0x2CA9, 0x2CA9 },
	{ 0x2CAB, 0x2CAB },
	{ 0x2CAD, 0x2CAD },
	{ 0x2CAF, 0x2CAF },
	{ 0x2CB1, 0x2CB1 },
	{ 0x2CB3, 0x2CB3 },
	{ 0x2CB5, 0x2CB5 },
	{ 0x2CB7, 0x2CB7 },
	{ 0x2CB9, 0x2CB9 },
	{ 0x2CBB, 0x2CBB },
	{ 0x2CBD, 0x2CBD },
	{ 0x2CBF, 0x2CBF },
	{ 0x2CC1, 0x2CC1 },
	{ 0x2CC3, 0x2CC3 },
	{ 0x2CC5, 0x2CC5 },
	{ 0x2CC7, 0x2CC7 },
	{ 0x2CC9, 0x2CC9 },
	{ 0x2CCB, 0x2CCB },
	{ 0x2CCD, 0x2CCD },
	{ 0x2CCF, 0x2CCF },
	{ 0x2CD1, 0x2CD1 },
	{ 0x2CD3, 0x2CD3 },
	{ 0x2CD5, 0x2CD5 },
	{ 0x2CD7, 0x2CD7 },
	{ 0x2CD9, 0x2CD9 },
	{ 0x2CDB, 0x2CDB },
	{ 0x2CDD, 0x2CDD },
	{ 0x2CDF, 0x2CDF },
	{ 0x2CE1, 0x2CE1 },
	{ 0x2CE3, 0x2CE3 },
	{ 0x2CEC, 0x2CEC },
	{ 0x2CEE, 0x2CEE },
	{ 0x2CF3, 0x2CF3 },
	{ 0x2D00, 0x2D25 },
	{ 0x2D27, 0x2D27 },
	{ 0x2D2D, 0x2D2D },
	{ 0xA641, 0xA641 },
	{ 0xA643, 0xA643 },
	{ 0xA645, 0xA645 },
	{ 0xA647, 0xA647 },
	{ 0xA649, 0xA649 },
	{ 0xA64B, 0xA64B },
	{ 0xA64D, 0xA64D },
	{ 0xA64F, 0xA64F },
	{ 0xA651, 0xA651 },
	{ 0xA653, 0xA653 },
	{ 0xA655, 0xA655 },
	{ 0xA657, 0xA657 },
	{ 0xA659, 0xA659 },
	{ 0xA65B, 0xA65B },
	{ 0xA65D, 0xA65D },
	{ 0xA65F, 0xA65F },
	{ 0xA661, 0xA661 },
	{ 0xA663, 0xA663 },
	{ 0xA665, 0xA665 },
	{ 0xA667, 0xA667 },
	{ 0xA669, 0xA669 },
	{ 0xA66B, 0xA66B },
	{ 0xA66D, 0xA66D },
	{ 0xA681, 0xA681 },
	{ 0xA683, 0xA683 },
	{ 0xA685, 0xA685 },
	{ 0xA687, 0xA687 },
	{ 0xA689, 0xA689 },
	{ 0xA68B, 0xA68B },
	{ 0xA68D, 0xA68D },
	{ 0xA68F, 0xA68F },
	{ 0xA691, 0xA691 },
	{ 0xA693, 0xA693 },
	{ 0xA695, 0xA695 },
	{ 0xA697, 0xA697 },
	{ 0xA699, 0xA699 },
	{ 0xA69B, 0xA69B },
	{ 0xA723, 0xA723 },
	{ 0xA725, 0xA725 },
	{ 0xA727, 0xA727 },
	{ 0xA729, 0xA729 },
	{ 0xA72B, 0xA72B },
	{ 0xA72D, 0xA72D },
	{ 0xA72F, 0xA72F },
	{ 0xA733, 0xA733 },
	{ 0xA735, 0xA735 },
	{ 0xA737, 0xA737 },
	{ 0xA739, 0xA739 },
	{ 0xA73B, 0xA73B },
	{ 0xA73D, 0xA73D },
	{ 0xA73F, 0xA73F },
	{ 0xA741, 0xA741 },
	{ 0xA743, 0xA743 },
	{ 0xA745, 0xA745 },
	{ 0xA747, 0xA747 },
	{ 0xA749, 0xA749 },
	{ 0xA74B, 0xA74B },
	{ 0xA74D, 0xA74D },
	{ 0xA74F, 0xA74F },
	{ 0xA751, 0xA751 },
	{ 0xA753, 0xA753 },
	{ 0xA755, 0xA755 },
	{ 0xA757, 0xA757 },
	{ 0xA759, 0xA759 },
	{ 0xA75B, 0xA75B },
	{ 0xA75D, 0xA75D },
	{ 0xA75F, 0xA75F },
	{ 0xA761, 0xA761 },
	{ 0xA763, 0xA763 },
	{ 0xA765, 0xA765 },
	{ 0xA767, 0xA767 },
	{ 0xA769, 0xA769 },
	{ 0xA76B, 0xA76B },
	{ 0xA76D, 0xA76D },
	{ 0xA76F, 0xA76F },
	{ 0xA77A, 0xA77A },
	{ 0xA77C, 0xA77C },
	{ 0xA77F, 0xA77F },
	{ 0xA781, 0xA781 },
	{ 0xA783, 0xA783 },
	{ 0xA785, 0xA785 },
	{ 0xA787, 0xA787 },
	{ 0xA78C, 0xA78C },
	{ 0xA791, 0xA791 },
	{ 0xA793, 0xA794 },
	{ 0xA797, 0xA797 },
	{ 0xA799, 0xA799 },
	{ 0xA79B, 0xA79B },
	{ 0xA79D, 0xA79D },
	{ 0xA79F, 0xA79F },
	{ 0xA7A1, 0xA7A1 },
	{ 0xA7A3, 0xA7A3 },
	{ 0xA7A5, 0xA7A5 },
	{ 0xA7A7, 0xA7A7 },
	{ 0xA7A9, 0xA7A9 },
	{ 0xA7B5, 0xA7B5 },
	{ 0xA7B7, 0xA7B7 },
	{ 0xA7B9, 0xA7B9 },
	{ 0xA7BB, 0xA7BB },
	{ 0xA7BD, 0xA7BD },
	{ 0xA7BF, 0xA7BF },
	{ 0xA7C3, 0xA7C3 },
	{ 0xA7C8, 0xA7C8 },
	{ 0xA7CA, 0xA7CA },
	{ 0xA7F6, 0xA7F6 },
	{ 0xAB53, 0xAB53 },
	{ 0xAB70, 0xABBF },
	{ 0xFF41, 0xFF5A },
	{ 0x10428, 0x1044F },
	{ 0x104D8, 0x104FB },
	{ 0x10CC0, 0x10CF2 },
	{ 0x118C0, 0x118DF },
	{ 0x16E60, 0x16E7F },
	{ 0x1E922, 0x1E943 }
};

MAKE_ISW(lower)
#endif

static const struct mb_ucsrange data_wctype_alpha[] = {
	{ 0x0041, 0x005A },
	{ 0x005F, 0x005F },
	{ 0x0061, 0x007A },
	{ 0x00AA, 0x00AA },
	{ 0x00B5, 0x00B5 },
	{ 0x00BA, 0x00BA },
	{ 0x00C0, 0x00D6 },
	{ 0x00D8, 0x00F6 },
	{ 0x00F8, 0x02C1 },
	{ 0x02C6, 0x02D1 },
	{ 0x02E0, 0x02E4 },
	{ 0x02EC, 0x02EC },
	{ 0x02EE, 0x02EE },
	{ 0x0345, 0x0345 },
	{ 0x0370, 0x0374 },
	{ 0x0376, 0x0377 },
	{ 0x037A, 0x037D },
	{ 0x037F, 0x037F },
	{ 0x0386, 0x0386 },
	{ 0x0388, 0x038A },
	{ 0x038C, 0x038C },
	{ 0x038E, 0x03A1 },
	{ 0x03A3, 0x03F5 },
	{ 0x03F7, 0x0481 },
	{ 0x048A, 0x052F },
	{ 0x0531, 0x0556 },
	{ 0x0559, 0x0559 },
	{ 0x0560, 0x0588 },
	{ 0x05D0, 0x05EA },
	{ 0x05EF, 0x05F2 },
	{ 0x0620, 0x064A },
	{ 0x066E, 0x066F },
	{ 0x0671, 0x06D3 },
	{ 0x06D5, 0x06D5 },
	{ 0x06E5, 0x06E6 },
	{ 0x06EE, 0x06EF },
	{ 0x06FA, 0x06FC },
	{ 0x06FF, 0x06FF },
	{ 0x0710, 0x0710 },
	{ 0x0712, 0x072F },
	{ 0x074D, 0x07A5 },
	{ 0x07B1, 0x07B1 },
	{ 0x07CA, 0x07EA },
	{ 0x07F4, 0x07F5 },
	{ 0x07FA, 0x07FA },
	{ 0x0800, 0x0815 },
	{ 0x081A, 0x081A },
	{ 0x0824, 0x0824 },
	{ 0x0828, 0x0828 },
	{ 0x0840, 0x0858 },
	{ 0x0860, 0x086A },
	{ 0x08A0, 0x08B4 },
	{ 0x08B6, 0x08C7 },
	{ 0x0904, 0x0939 },
	{ 0x093D, 0x093D },
	{ 0x0950, 0x0950 },
	{ 0x0958, 0x0961 },
	{ 0x0971, 0x0980 },
	{ 0x0985, 0x098C },
	{ 0x098F, 0x0990 },
	{ 0x0993, 0x09A8 },
	{ 0x09AA, 0x09B0 },
	{ 0x09B2, 0x09B2 },
	{ 0x09B6, 0x09B9 },
	{ 0x09BD, 0x09BD },
	{ 0x09CE, 0x09CE },
	{ 0x09DC, 0x09DD },
	{ 0x09DF, 0x09E1 },
	{ 0x09F0, 0x09F1 },
	{ 0x09FC, 0x09FC },
	{ 0x0A05, 0x0A0A },
	{ 0x0A0F, 0x0A10 },
	{ 0x0A13, 0x0A28 },
	{ 0x0A2A, 0x0A30 },
	{ 0x0A32, 0x0A33 },
	{ 0x0A35, 0x0A36 },
	{ 0x0A38, 0x0A39 },
	{ 0x0A59, 0x0A5C },
	{ 0x0A5E, 0x0A5E },
	{ 0x0A72, 0x0A74 },
	{ 0x0A85, 0x0A8D },
	{ 0x0A8F, 0x0A91 },
	{ 0x0A93, 0x0AA8 },
	{ 0x0AAA, 0x0AB0 },
	{ 0x0AB2, 0x0AB3 },
	{ 0x0AB5, 0x0AB9 },
	{ 0x0ABD, 0x0ABD },
	{ 0x0AD0, 0x0AD0 },
	{ 0x0AE0, 0x0AE1 },
	{ 0x0AF9, 0x0AF9 },
	{ 0x0B05, 0x0B0C },
	{ 0x0B0F, 0x0B10 },
	{ 0x0B13, 0x0B28 },
	{ 0x0B2A, 0x0B30 },
	{ 0x0B32, 0x0B33 },
	{ 0x0B35, 0x0B39 },
	{ 0x0B3D, 0x0B3D },
	{ 0x0B5C, 0x0B5D },
	{ 0x0B5F, 0x0B61 },
	{ 0x0B71, 0x0B71 },
	{ 0x0B83, 0x0B83 },
	{ 0x0B85, 0x0B8A },
	{ 0x0B8E, 0x0B90 },
	{ 0x0B92, 0x0B95 },
	{ 0x0B99, 0x0B9A },
	{ 0x0B9C, 0x0B9C },
	{ 0x0B9E, 0x0B9F },
	{ 0x0BA3, 0x0BA4 },
	{ 0x0BA8, 0x0BAA },
	{ 0x0BAE, 0x0BB9 },
	{ 0x0BD0, 0x0BD0 },
	{ 0x0C05, 0x0C0C },
	{ 0x0C0E, 0x0C10 },
	{ 0x0C12, 0x0C28 },
	{ 0x0C2A, 0x0C39 },
	{ 0x0C3D, 0x0C3D },
	{ 0x0C58, 0x0C5A },
	{ 0x0C60, 0x0C61 },
	{ 0x0C80, 0x0C80 },
	{ 0x0C85, 0x0C8C },
	{ 0x0C8E, 0x0C90 },
	{ 0x0C92, 0x0CA8 },
	{ 0x0CAA, 0x0CB3 },
	{ 0x0CB5, 0x0CB9 },
	{ 0x0CBD, 0x0CBD },
	{ 0x0CDE, 0x0CDE },
	{ 0x0CE0, 0x0CE1 },
	{ 0x0CF1, 0x0CF2 },
	{ 0x0D04, 0x0D0C },
	{ 0x0D0E, 0x0D10 },
	{ 0x0D12, 0x0D3A },
	{ 0x0D3D, 0x0D3D },
	{ 0x0D4E, 0x0D4E },
	{ 0x0D54, 0x0D56 },
	{ 0x0D5F, 0x0D61 },
	{ 0x0D7A, 0x0D7F },
	{ 0x0D85, 0x0D96 },
	{ 0x0D9A, 0x0DB1 },
	{ 0x0DB3, 0x0DBB },
	{ 0x0DBD, 0x0DBD },
	{ 0x0DC0, 0x0DC6 },
	{ 0x0E01, 0x0E30 },
	{ 0x0E32, 0x0E33 },
	{ 0x0E40, 0x0E46 },
	{ 0x0E81, 0x0E82 },
	{ 0x0E84, 0x0E84 },
	{ 0x0E86, 0x0E8A },
	{ 0x0E8C, 0x0EA3 },
	{ 0x0EA5, 0x0EA5 },
	{ 0x0EA7, 0x0EB0 },
	{ 0x0EB2, 0x0EB3 },
	{ 0x0EBD, 0x0EBD },
	{ 0x0EC0, 0x0EC4 },
	{ 0x0EC6, 0x0EC6 },
	{ 0x0EDC, 0x0EDF },
	{ 0x0F00, 0x0F00 },
	{ 0x0F40, 0x0F47 },
	{ 0x0F49, 0x0F6C },
	{ 0x0F88, 0x0F8C },
	{ 0x1000, 0x102A },
	{ 0x103F, 0x103F },
	{ 0x1050, 0x1055 },
	{ 0x105A, 0x105D },
	{ 0x1061, 0x1061 },
	{ 0x1065, 0x1066 },
	{ 0x106E, 0x1070 },
	{ 0x1075, 0x1081 },
	{ 0x108E, 0x108E },
	{ 0x10A0, 0x10C5 },
	{ 0x10C7, 0x10C7 },
	{ 0x10CD, 0x10CD },
	{ 0x10D0, 0x10FA },
	{ 0x10FC, 0x1248 },
	{ 0x124A, 0x124D },
	{ 0x1250, 0x1256 },
	{ 0x1258, 0x1258 },
	{ 0x125A, 0x125D },
	{ 0x1260, 0x1288 },
	{ 0x128A, 0x128D },
	{ 0x1290, 0x12B0 },
	{ 0x12B2, 0x12B5 },
	{ 0x12B8, 0x12BE },
	{ 0x12C0, 0x12C0 },
	{ 0x12C2, 0x12C5 },
	{ 0x12C8, 0x12D6 },
	{ 0x12D8, 0x1310 },
	{ 0x1312, 0x1315 },
	{ 0x1318, 0x135A },
	{ 0x1380, 0x138F },
	{ 0x13A0, 0x13F5 },
	{ 0x13F8, 0x13FD },
	{ 0x1401, 0x166C },
	{ 0x166F, 0x167F },
	{ 0x1681, 0x169A },
	{ 0x16A0, 0x16EA },
	{ 0x16F1, 0x16F8 },
	{ 0x1700, 0x170C },
	{ 0x170E, 0x1711 },
	{ 0x1720, 0x1731 },
	{ 0x1740, 0x1751 },
	{ 0x1760, 0x176C },
	{ 0x176E, 0x1770 },
	{ 0x1780, 0x17B3 },
	{ 0x17D7, 0x17D7 },
	{ 0x17DC, 0x17DC },
	{ 0x1820, 0x1878 },
	{ 0x1880, 0x1884 },
	{ 0x1887, 0x18A8 },
	{ 0x18AA, 0x18AA },
	{ 0x18B0, 0x18F5 },
	{ 0x1900, 0x191E },
	{ 0x1950, 0x196D },
	{ 0x1970, 0x1974 },
	{ 0x1980, 0x19AB },
	{ 0x19B0, 0x19C9 },
	{ 0x1A00, 0x1A16 },
	{ 0x1A20, 0x1A54 },
	{ 0x1AA7, 0x1AA7 },
	{ 0x1B05, 0x1B33 },
	{ 0x1B45, 0x1B4B },
	{ 0x1B83, 0x1BA0 },
	{ 0x1BAE, 0x1BAF },
	{ 0x1BBA, 0x1BE5 },
	{ 0x1C00, 0x1C23 },
	{ 0x1C4D, 0x1C4F },
	{ 0x1C5A, 0x1C7D },
	{ 0x1C80, 0x1C88 },
	{ 0x1C90, 0x1CBA },
	{ 0x1CBD, 0x1CBF },
	{ 0x1CE9, 0x1CEC },
	{ 0x1CEE, 0x1CF3 },
	{ 0x1CF5, 0x1CF6 },
	{ 0x1CFA, 0x1CFA },
	{ 0x1D00, 0x1DBF },
	{ 0x1E00, 0x1F15 },
	{ 0x1F18, 0x1F1D },
	{ 0x1F20, 0x1F45 },
	{ 0x1F48, 0x1F4D },
	{ 0x1F50, 0x1F57 },
	{ 0x1F59, 0x1F59 },
	{ 0x1F5B, 0x1F5B },
	{ 0x1F5D, 0x1F5D },
	{ 0x1F5F, 0x1F7D },
	{ 0x1F80, 0x1FB4 },
	{ 0x1FB6, 0x1FBC },
	{ 0x1FBE, 0x1FBE },
	{ 0x1FC2, 0x1FC4 },
	{ 0x1FC6, 0x1FCC },
	{ 0x1FD0, 0x1FD3 },
	{ 0x1FD6, 0x1FDB },
	{ 0x1FE0, 0x1FEC },
	{ 0x1FF2, 0x1FF4 },
	{ 0x1FF6, 0x1FFC },
	{ 0x2071, 0x2071 },
	{ 0x207F, 0x207F },
	{ 0x2090, 0x209C },
	{ 0x2102, 0x2102 },
	{ 0x2107, 0x2107 },
	{ 0x210A, 0x2113 },
	{ 0x2115, 0x2115 },
	{ 0x2119, 0x211D },
	{ 0x2124, 0x2124 },
	{ 0x2126, 0x2126 },
	{ 0x2128, 0x2128 },
	{ 0x212A, 0x212D },
	{ 0x212F, 0x2139 },
	{ 0x213C, 0x213F },
	{ 0x2145, 0x2149 },
	{ 0x214E, 0x214E },
	{ 0x2160, 0x217F },
	{ 0x2183, 0x2184 },
	{ 0x24B6, 0x24E9 },
	{ 0x2C00, 0x2C2E },
	{ 0x2C30, 0x2C5E },
	{ 0x2C60, 0x2CE4 },
	{ 0x2CEB, 0x2CEE },
	{ 0x2CF2, 0x2CF3 },
	{ 0x2D00, 0x2D25 },
	{ 0x2D27, 0x2D27 },
	{ 0x2D2D, 0x2D2D },
	{ 0x2D30, 0x2D67 },
	{ 0x2D6F, 0x2D6F },
	{ 0x2D80, 0x2D96 },
	{ 0x2DA0, 0x2DA6 },
	{ 0x2DA8, 0x2DAE },
	{ 0x2DB0, 0x2DB6 },
	{ 0x2DB8, 0x2DBE },
	{ 0x2DC0, 0x2DC6 },
	{ 0x2DC8, 0x2DCE },
	{ 0x2DD0, 0x2DD6 },
	{ 0x2DD8, 0x2DDE },
	{ 0x2E2F, 0x2E2F },
	{ 0x3005, 0x3006 },
	{ 0x3031, 0x3035 },
	{ 0x303B, 0x303C },
	{ 0x3041, 0x3096 },
	{ 0x309D, 0x309F },
	{ 0x30A1, 0x30FA },
	{ 0x30FC, 0x30FF },
	{ 0x3105, 0x312F },
	{ 0x3131, 0x318E },
	{ 0x31A0, 0x31BF },
	{ 0x31F0, 0x31FF },
	{ 0x3400, 0x4DBF },
	{ 0x4E00, 0x9FFC },
	{ 0xA000, 0xA48C },
	{ 0xA4D0, 0xA4FD },
	{ 0xA500, 0xA60C },
	{ 0xA610, 0xA61F },
	{ 0xA62A, 0xA62B },
	{ 0xA640, 0xA66E },
	{ 0xA67F, 0xA69D },
	{ 0xA6A0, 0xA6E5 },
	{ 0xA717, 0xA71F },
	{ 0xA722, 0xA788 },
	{ 0xA78B, 0xA7BF },
	{ 0xA7C2, 0xA7CA },
	{ 0xA7F5, 0xA801 },
	{ 0xA803, 0xA805 },
	{ 0xA807, 0xA80A },
	{ 0xA80C, 0xA822 },
	{ 0xA840, 0xA873 },
	{ 0xA882, 0xA8B3 },
	{ 0xA8F2, 0xA8F7 },
	{ 0xA8FB, 0xA8FB },
	{ 0xA8FD, 0xA8FE },
	{ 0xA90A, 0xA925 },
	{ 0xA930, 0xA946 },
	{ 0xA960, 0xA97C },
	{ 0xA984, 0xA9B2 },
	{ 0xA9CF, 0xA9CF },
	{ 0xA9E0, 0xA9E4 },
	{ 0xA9E6, 0xA9EF },
	{ 0xA9FA, 0xA9FE },
	{ 0xAA00, 0xAA28 },
	{ 0xAA40, 0xAA42 },
	{ 0xAA44, 0xAA4B },
	{ 0xAA60, 0xAA76 },
	{ 0xAA7A, 0xAA7A },
	{ 0xAA7E, 0xAAAF },
	{ 0xAAB1, 0xAAB1 },
	{ 0xAAB5, 0xAAB6 },
	{ 0xAAB9, 0xAABD },
	{ 0xAAC0, 0xAAC0 },
	{ 0xAAC2, 0xAAC2 },
	{ 0xAADB, 0xAADD },
	{ 0xAAE0, 0xAAEA },
	{ 0xAAF2, 0xAAF4 },
	{ 0xAB01, 0xAB06 },
	{ 0xAB09, 0xAB0E },
	{ 0xAB11, 0xAB16 },
	{ 0xAB20, 0xAB26 },
	{ 0xAB28, 0xAB2E },
	{ 0xAB30, 0xAB5A },
	{ 0xAB5C, 0xAB69 },
	{ 0xAB70, 0xABE2 },
	{ 0xAC00, 0xD7A3 },
	{ 0xD7B0, 0xD7C6 },
	{ 0xD7CB, 0xD7FB },
	{ 0xF900, 0xFA6D },
	{ 0xFA70, 0xFAD9 },
	{ 0xFB00, 0xFB06 },
	{ 0xFB13, 0xFB17 },
	{ 0xFB1D, 0xFB1D },
	{ 0xFB1F, 0xFB28 },
	{ 0xFB2A, 0xFB36 },
	{ 0xFB38, 0xFB3C },
	{ 0xFB3E, 0xFB3E },
	{ 0xFB40, 0xFB41 },
	{ 0xFB43, 0xFB44 },
	{ 0xFB46, 0xFBB1 },
	{ 0xFBD3, 0xFD3D },
	{ 0xFD50, 0xFD8F },
	{ 0xFD92, 0xFDC7 },
	{ 0xFDF0, 0xFDFB },
	{ 0xFE70, 0xFE74 },
	{ 0xFE76, 0xFEFC },
	{ 0xFF21, 0xFF3A },
	{ 0xFF41, 0xFF5A },
	{ 0xFF66, 0xFFBE },
	{ 0xFFC2, 0xFFC7 },
	{ 0xFFCA, 0xFFCF },
	{ 0xFFD2, 0xFFD7 },
	{ 0xFFDA, 0xFFDC },
	{ 0x10000, 0x1000B },
	{ 0x1000D, 0x10026 },
	{ 0x10028, 0x1003A },
	{ 0x1003C, 0x1003D },
	{ 0x1003F, 0x1004D },
	{ 0x10050, 0x1005D },
	{ 0x10080, 0x100FA },
	{ 0x10280, 0x1029C },
	{ 0x102A0, 0x102D0 },
	{ 0x10300, 0x1031F },
	{ 0x1032D, 0x10340 },
	{ 0x10342, 0x10349 },
	{ 0x10350, 0x10375 },
	{ 0x10380, 0x1039D },
	{ 0x103A0, 0x103C3 },
	{ 0x103C8, 0x103CF },
	{ 0x10400, 0x1049D },
	{ 0x104B0, 0x104D3 },
	{ 0x104D8, 0x104FB },
	{ 0x10500, 0x10527 },
	{ 0x10530, 0x10563 },
	{ 0x10600, 0x10736 },
	{ 0x10740, 0x10755 },
	{ 0x10760, 0x10767 },
	{ 0x10800, 0x10805 },
	{ 0x10808, 0x10808 },
	{ 0x1080A, 0x10835 },
	{ 0x10837, 0x10838 },
	{ 0x1083C, 0x1083C },
	{ 0x1083F, 0x10855 },
	{ 0x10860, 0x10876 },
	{ 0x10880, 0x1089E },
	{ 0x108E0, 0x108F2 },
	{ 0x108F4, 0x108F5 },
	{ 0x10900, 0x10915 },
	{ 0x10920, 0x10939 },
	{ 0x10980, 0x109B7 },
	{ 0x109BE, 0x109BF },
	{ 0x10A00, 0x10A00 },
	{ 0x10A10, 0x10A13 },
	{ 0x10A15, 0x10A17 },
	{ 0x10A19, 0x10A35 },
	{ 0x10A60, 0x10A7C },
	{ 0x10A80, 0x10A9C },
	{ 0x10AC0, 0x10AC7 },
	{ 0x10AC9, 0x10AE4 },
	{ 0x10B00, 0x10B35 },
	{ 0x10B40, 0x10B55 },
	{ 0x10B60, 0x10B72 },
	{ 0x10B80, 0x10B91 },
	{ 0x10C00, 0x10C48 },
	{ 0x10C80, 0x10CB2 },
	{ 0x10CC0, 0x10CF2 },
	{ 0x10D00, 0x10D23 },
	{ 0x10E80, 0x10EA9 },
	{ 0x10EB0, 0x10EB1 },
	{ 0x10F00, 0x10F1C },
	{ 0x10F27, 0x10F27 },
	{ 0x10F30, 0x10F45 },
	{ 0x10FB0, 0x10FC4 },
	{ 0x10FE0, 0x10FF6 },
	{ 0x11003, 0x11037 },
	{ 0x11083, 0x110AF },
	{ 0x110D0, 0x110E8 },
	{ 0x11103, 0x11126 },
	{ 0x11144, 0x11144 },
	{ 0x11147, 0x11147 },
	{ 0x11150, 0x11172 },
	{ 0x11176, 0x11176 },
	{ 0x11183, 0x111B2 },
	{ 0x111C1, 0x111C4 },
	{ 0x111DA, 0x111DA },
	{ 0x111DC, 0x111DC },
	{ 0x11200, 0x11211 },
	{ 0x11213, 0x1122B },
	{ 0x11280, 0x11286 },
	{ 0x11288, 0x11288 },
	{ 0x1128A, 0x1128D },
	{ 0x1128F, 0x1129D },
	{ 0x1129F, 0x112A8 },
	{ 0x112B0, 0x112DE },
	{ 0x11305, 0x1130C },
	{ 0x1130F, 0x11310 },
	{ 0x11313, 0x11328 },
	{ 0x1132A, 0x11330 },
	{ 0x11332, 0x11333 },
	{ 0x11335, 0x11339 },
	{ 0x1133D, 0x1133D },
	{ 0x11350, 0x11350 },
	{ 0x1135D, 0x11361 },
	{ 0x11400, 0x11434 },
	{ 0x11447, 0x1144A },
	{ 0x1145F, 0x11461 },
	{ 0x11480, 0x114AF },
	{ 0x114C4, 0x114C5 },
	{ 0x114C7, 0x114C7 },
	{ 0x11580, 0x115AE },
	{ 0x115D8, 0x115DB },
	{ 0x11600, 0x1162F },
	{ 0x11644, 0x11644 },
	{ 0x11680, 0x116AA },
	{ 0x116B8, 0x116B8 },
	{ 0x11700, 0x1171A },
	{ 0x11800, 0x1182B },
	{ 0x118A0, 0x118DF },
	{ 0x118FF, 0x11906 },
	{ 0x11909, 0x11909 },
	{ 0x1190C, 0x11913 },
	{ 0x11915, 0x11916 },
	{ 0x11918, 0x1192F },
	{ 0x1193F, 0x1193F },
	{ 0x11941, 0x11941 },
	{ 0x119A0, 0x119A7 },
	{ 0x119AA, 0x119D0 },
	{ 0x119E1, 0x119E1 },
	{ 0x119E3, 0x119E3 },
	{ 0x11A00, 0x11A00 },
	{ 0x11A0B, 0x11A32 },
	{ 0x11A3A, 0x11A3A },
	{ 0x11A50, 0x11A50 },
	{ 0x11A5C, 0x11A89 },
	{ 0x11A9D, 0x11A9D },
	{ 0x11AC0, 0x11AF8 },
	{ 0x11C00, 0x11C08 },
	{ 0x11C0A, 0x11C2E },
	{ 0x11C40, 0x11C40 },
	{ 0x11C72, 0x11C8F },
	{ 0x11D00, 0x11D06 },
	{ 0x11D08, 0x11D09 },
	{ 0x11D0B, 0x11D30 },
	{ 0x11D46, 0x11D46 },
	{ 0x11D60, 0x11D65 },
	{ 0x11D67, 0x11D68 },
	{ 0x11D6A, 0x11D89 },
	{ 0x11D98, 0x11D98 },
	{ 0x11EE0, 0x11EF2 },
	{ 0x11FB0, 0x11FB0 },
	{ 0x12000, 0x12399 },
	{ 0x12480, 0x12543 },
	{ 0x13000, 0x1342E },
	{ 0x14400, 0x14646 },
	{ 0x16800, 0x16A38 },
	{ 0x16A40, 0x16A5E },
	{ 0x16AD0, 0x16AED },
	{ 0x16B00, 0x16B2F },
	{ 0x16B40, 0x16B43 },
	{ 0x16B63, 0x16B77 },
	{ 0x16B7D, 0x16B8F },
	{ 0x16E40, 0x16E7F },
	{ 0x16F00, 0x16F4A },
	{ 0x16F50, 0x16F50 },
	{ 0x16F93, 0x16F9F },
	{ 0x16FE0, 0x16FE1 },
	{ 0x16FE3, 0x16FE3 },
	{ 0x17000, 0x187F7 },
	{ 0x18800, 0x18CD5 },
	{ 0x18D00, 0x18D08 },
	{ 0x1B000, 0x1B11E },
	{ 0x1B150, 0x1B152 },
	{ 0x1B164, 0x1B167 },
	{ 0x1B170, 0x1B2FB },
	{ 0x1BC00, 0x1BC6A },
	{ 0x1BC70, 0x1BC7C },
	{ 0x1BC80, 0x1BC88 },
	{ 0x1BC90, 0x1BC99 },
	{ 0x1D400, 0x1D454 },
	{ 0x1D456, 0x1D49C },
	{ 0x1D49E, 0x1D49F },
	{ 0x1D4A2, 0x1D4A2 },
	{ 0x1D4A5, 0x1D4A6 },
	{ 0x1D4A9, 0x1D4AC },
	{ 0x1D4AE, 0x1D4B9 },
	{ 0x1D4BB, 0x1D4BB },
	{ 0x1D4BD, 0x1D4C3 },
	{ 0x1D4C5, 0x1D505 },
	{ 0x1D507, 0x1D50A },
	{ 0x1D50D, 0x1D514 },
	{ 0x1D516, 0x1D51C },
	{ 0x1D51E, 0x1D539 },
	{ 0x1D53B, 0x1D53E },
	{ 0x1D540, 0x1D544 },
	{ 0x1D546, 0x1D546 },
	{ 0x1D54A, 0x1D550 },
	{ 0x1D552, 0x1D6A5 },
	{ 0x1D6A8, 0x1D6C0 },
	{ 0x1D6C2, 0x1D6DA },
	{ 0x1D6DC, 0x1D6FA },
	{ 0x1D6FC, 0x1D714 },
	{ 0x1D716, 0x1D734 },
	{ 0x1D736, 0x1D74E },
	{ 0x1D750, 0x1D76E },
	{ 0x1D770, 0x1D788 },
	{ 0x1D78A, 0x1D7A8 },
	{ 0x1D7AA, 0x1D7C2 },
	{ 0x1D7C4, 0x1D7CB },
	{ 0x1E100, 0x1E12C },
	{ 0x1E137, 0x1E13D },
	{ 0x1E14E, 0x1E14E },
	{ 0x1E2C0, 0x1E2EB },
	{ 0x1E800, 0x1E8C4 },
	{ 0x1E900, 0x1E943 },
	{ 0x1E94B, 0x1E94B },
	{ 0x1EE00, 0x1EE03 },
	{ 0x1EE05, 0x1EE1F },
	{ 0x1EE21, 0x1EE22 },
	{ 0x1EE24, 0x1EE24 },
	{ 0x1EE27, 0x1EE27 },
	{ 0x1EE29, 0x1EE32 },
	{ 0x1EE34, 0x1EE37 },
	{ 0x1EE39, 0x1EE39 },
	{ 0x1EE3B, 0x1EE3B },
	{ 0x1EE42, 0x1EE42 },
	{ 0x1EE47, 0x1EE47 },
	{ 0x1EE49, 0x1EE49 },
	{ 0x1EE4B, 0x1EE4B },
	{ 0x1EE4D, 0x1EE4F },
	{ 0x1EE51, 0x1EE52 },
	{ 0x1EE54, 0x1EE54 },
	{ 0x1EE57, 0x1EE57 },
	{ 0x1EE59, 0x1EE59 },
	{ 0x1EE5B, 0x1EE5B },
	{ 0x1EE5D, 0x1EE5D },
	{ 0x1EE5F, 0x1EE5F },
	{ 0x1EE61, 0x1EE62 },
	{ 0x1EE64, 0x1EE64 },
	{ 0x1EE67, 0x1EE6A },
	{ 0x1EE6C, 0x1EE72 },
	{ 0x1EE74, 0x1EE77 },
	{ 0x1EE79, 0x1EE7C },
	{ 0x1EE7E, 0x1EE7E },
	{ 0x1EE80, 0x1EE89 },
	{ 0x1EE8B, 0x1EE9B },
	{ 0x1EEA1, 0x1EEA3 },
	{ 0x1EEA5, 0x1EEA9 },
	{ 0x1EEAB, 0x1EEBB },
	{ 0x20000, 0x2A6DD },
	{ 0x2A700, 0x2B734 },
	{ 0x2B740, 0x2B81D },
	{ 0x2B820, 0x2CEA1 },
	{ 0x2CEB0, 0x2EBE0 },
	{ 0x2F800, 0x2FA1D },
	{ 0x30000, 0x3134A }
};

MAKE_ISW(alpha)

int joe_iswalnum(int c)
{
	return ((c >= 0x30 && c <= 0x39) ? 1 : joe_iswalpha(c));
}

int joe_iswdigit(int c)
{
	return ((c >= 0x30 && c <= 0x39) ? 1 : 0);
}

static const struct mb_ucsrange data_wctype_space[] = {
	{ 0x0009, 0x000D },
	{ 0x0020, 0x0020 },
	{ 0x1680, 0x1680 },
	{ 0x2000, 0x2006 },
	{ 0x2008, 0x200B },
	{ 0x2028, 0x2029 },
	{ 0x205F, 0x205F },
	{ 0x3000, 0x3000 }
};

MAKE_ISW(space)

#ifdef TEST_I18N
static const struct mb_ucsrange data_wctype_cntrl[] = {
	{ 0x0000, 0x001F },
	{ 0x007F, 0x009F },
	{ 0x2028, 0x2029 }
};

MAKE_ISW(cntrl)
#endif

static const struct mb_ucsrange data_wctype_punct[] = {
	{ 0x0021, 0x002F },
	{ 0x003A, 0x0040 },
	{ 0x005B, 0x0060 },
	{ 0x007B, 0x007E },
	{ 0x00A0, 0x00A9 },
	{ 0x00AB, 0x00B4 },
	{ 0x00B6, 0x00B9 },
	{ 0x00BB, 0x00BF },
	{ 0x00D7, 0x00D7 },
	{ 0x00F7, 0x00F7 },
	{ 0x02C2, 0x02C5 },
	{ 0x02D2, 0x02DF },
	{ 0x02E5, 0x02EB },
	{ 0x02ED, 0x02ED },
	{ 0x02EF, 0x0344 },
	{ 0x0346, 0x036F },
	{ 0x0375, 0x0375 },
	{ 0x037E, 0x037E },
	{ 0x0384, 0x0385 },
	{ 0x0387, 0x0387 },
	{ 0x03F6, 0x03F6 },
	{ 0x0482, 0x0489 },
	{ 0x055A, 0x055F },
	{ 0x0589, 0x058A },
	{ 0x058D, 0x058F },
	{ 0x0591, 0x05C7 },
	{ 0x05F3, 0x05F4 },
	{ 0x0600, 0x061C },
	{ 0x061E, 0x061F },
	{ 0x064B, 0x066D },
	{ 0x0670, 0x0670 },
	{ 0x06D4, 0x06D4 },
	{ 0x06D6, 0x06E4 },
	{ 0x06E7, 0x06ED },
	{ 0x06F0, 0x06F9 },
	{ 0x06FD, 0x06FE },
	{ 0x0700, 0x070D },
	{ 0x070F, 0x070F },
	{ 0x0711, 0x0711 },
	{ 0x0730, 0x074A },
	{ 0x07A6, 0x07B0 },
	{ 0x07C0, 0x07C9 },
	{ 0x07EB, 0x07F3 },
	{ 0x07F6, 0x07F9 },
	{ 0x07FD, 0x07FF },
	{ 0x0816, 0x0819 },
	{ 0x081B, 0x0823 },
	{ 0x0825, 0x0827 },
	{ 0x0829, 0x082D },
	{ 0x0830, 0x083E },
	{ 0x0859, 0x085B },
	{ 0x085E, 0x085E },
	{ 0x08D3, 0x0903 },
	{ 0x093A, 0x093C },
	{ 0x093E, 0x094F },
	{ 0x0951, 0x0957 },
	{ 0x0962, 0x0970 },
	{ 0x0981, 0x0983 },
	{ 0x09BC, 0x09BC },
	{ 0x09BE, 0x09C4 },
	{ 0x09C7, 0x09C8 },
	{ 0x09CB, 0x09CD },
	{ 0x09D7, 0x09D7 },
	{ 0x09E2, 0x09E3 },
	{ 0x09E6, 0x09EF },
	{ 0x09F2, 0x09FB },
	{ 0x09FD, 0x09FE },
	{ 0x0A01, 0x0A03 },
	{ 0x0A3C, 0x0A3C },
	{ 0x0A3E, 0x0A42 },
	{ 0x0A47, 0x0A48 },
	{ 0x0A4B, 0x0A4D },
	{ 0x0A51, 0x0A51 },
	{ 0x0A66, 0x0A71 },
	{ 0x0A75, 0x0A76 },
	{ 0x0A81, 0x0A83 },
	{ 0x0ABC, 0x0ABC },
	{ 0x0ABE, 0x0AC5 },
	{ 0x0AC7, 0x0AC9 },
	{ 0x0ACB, 0x0ACD },
	{ 0x0AE2, 0x0AE3 },
	{ 0x0AE6, 0x0AF1 },
	{ 0x0AFA, 0x0AFF },
	{ 0x0B01, 0x0B03 },
	{ 0x0B3C, 0x0B3C },
	{ 0x0B3E, 0x0B44 },
	{ 0x0B47, 0x0B48 },
	{ 0x0B4B, 0x0B4D },
	{ 0x0B55, 0x0B57 },
	{ 0x0B62, 0x0B63 },
	{ 0x0B66, 0x0B70 },
	{ 0x0B72, 0x0B77 },
	{ 0x0B82, 0x0B82 },
	{ 0x0BBE, 0x0BC2 },
	{ 0x0BC6, 0x0BC8 },
	{ 0x0BCA, 0x0BCD },
	{ 0x0BD7, 0x0BD7 },
	{ 0x0BE6, 0x0BFA },
	{ 0x0C00, 0x0C04 },
	{ 0x0C3E, 0x0C44 },
	{ 0x0C46, 0x0C48 },
	{ 0x0C4A, 0x0C4D },
	{ 0x0C55, 0x0C56 },
	{ 0x0C62, 0x0C63 },
	{ 0x0C66, 0x0C6F },
	{ 0x0C77, 0x0C7F },
	{ 0x0C81, 0x0C84 },
	{ 0x0CBC, 0x0CBC },
	{ 0x0CBE, 0x0CC4 },
	{ 0x0CC6, 0x0CC8 },
	{ 0x0CCA, 0x0CCD },
	{ 0x0CD5, 0x0CD6 },
	{ 0x0CE2, 0x0CE3 },
	{ 0x0CE6, 0x0CEF },
	{ 0x0D00, 0x0D03 },
	{ 0x0D3B, 0x0D3C },
	{ 0x0D3E, 0x0D44 },
	{ 0x0D46, 0x0D48 },
	{ 0x0D4A, 0x0D4D },
	{ 0x0D4F, 0x0D4F },
	{ 0x0D57, 0x0D5E },
	{ 0x0D62, 0x0D63 },
	{ 0x0D66, 0x0D79 },
	{ 0x0D81, 0x0D83 },
	{ 0x0DCA, 0x0DCA },
	{ 0x0DCF, 0x0DD4 },
	{ 0x0DD6, 0x0DD6 },
	{ 0x0DD8, 0x0DDF },
	{ 0x0DE6, 0x0DEF },
	{ 0x0DF2, 0x0DF4 },
	{ 0x0E31, 0x0E31 },
	{ 0x0E34, 0x0E3A },
	{ 0x0E3F, 0x0E3F },
	{ 0x0E47, 0x0E5B },
	{ 0x0EB1, 0x0EB1 },
	{ 0x0EB4, 0x0EBC },
	{ 0x0EC8, 0x0ECD },
	{ 0x0ED0, 0x0ED9 },
	{ 0x0F01, 0x0F3F },
	{ 0x0F71, 0x0F87 },
	{ 0x0F8D, 0x0F97 },
	{ 0x0F99, 0x0FBC },
	{ 0x0FBE, 0x0FCC },
	{ 0x0FCE, 0x0FDA },
	{ 0x102B, 0x103E },
	{ 0x1040, 0x104F },
	{ 0x1056, 0x1059 },
	{ 0x105E, 0x1060 },
	{ 0x1062, 0x1064 },
	{ 0x1067, 0x106D },
	{ 0x1071, 0x1074 },
	{ 0x1082, 0x108D },
	{ 0x108F, 0x109F },
	{ 0x10FB, 0x10FB },
	{ 0x135D, 0x137C },
	{ 0x1390, 0x1399 },
	{ 0x1400, 0x1400 },
	{ 0x166D, 0x166E },
	{ 0x1680, 0x1680 },
	{ 0x169B, 0x169C },
	{ 0x16EB, 0x16F0 },
	{ 0x1712, 0x1714 },
	{ 0x1732, 0x1736 },
	{ 0x1752, 0x1753 },
	{ 0x1772, 0x1773 },
	{ 0x17B4, 0x17D6 },
	{ 0x17D8, 0x17DB },
	{ 0x17DD, 0x17DD },
	{ 0x17E0, 0x17E9 },
	{ 0x17F0, 0x17F9 },
	{ 0x1800, 0x180E },
	{ 0x1810, 0x1819 },
	{ 0x1885, 0x1886 },
	{ 0x18A9, 0x18A9 },
	{ 0x1920, 0x192B },
	{ 0x1930, 0x193B },
	{ 0x1940, 0x1940 },
	{ 0x1944, 0x194F },
	{ 0x19D0, 0x19DA },
	{ 0x19DE, 0x19FF },
	{ 0x1A17, 0x1A1B },
	{ 0x1A1E, 0x1A1F },
	{ 0x1A55, 0x1A5E },
	{ 0x1A60, 0x1A7C },
	{ 0x1A7F, 0x1A89 },
	{ 0x1A90, 0x1A99 },
	{ 0x1AA0, 0x1AA6 },
	{ 0x1AA8, 0x1AAD },
	{ 0x1AB0, 0x1AC0 },
	{ 0x1B00, 0x1B04 },
	{ 0x1B34, 0x1B44 },
	{ 0x1B50, 0x1B7C },
	{ 0x1B80, 0x1B82 },
	{ 0x1BA1, 0x1BAD },
	{ 0x1BB0, 0x1BB9 },
	{ 0x1BE6, 0x1BF3 },
	{ 0x1BFC, 0x1BFF },
	{ 0x1C24, 0x1C37 },
	{ 0x1C3B, 0x1C49 },
	{ 0x1C50, 0x1C59 },
	{ 0x1C7E, 0x1C7F },
	{ 0x1CC0, 0x1CC7 },
	{ 0x1CD0, 0x1CE8 },
	{ 0x1CED, 0x1CED },
	{ 0x1CF4, 0x1CF4 },
	{ 0x1CF7, 0x1CF9 },
	{ 0x1DC0, 0x1DF9 },
	{ 0x1DFB, 0x1DFF },
	{ 0x1FBD, 0x1FBD },
	{ 0x1FBF, 0x1FC1 },
	{ 0x1FCD, 0x1FCF },
	{ 0x1FDD, 0x1FDF },
	{ 0x1FED, 0x1FEF },
	{ 0x1FFD, 0x1FFE },
	{ 0x2000, 0x2064 },
	{ 0x2066, 0x2070 },
	{ 0x2074, 0x207E },
	{ 0x2080, 0x208E },
	{ 0x20A0, 0x20BF },
	{ 0x20D0, 0x20F0 },
	{ 0x2100, 0x2101 },
	{ 0x2103, 0x2106 },
	{ 0x2108, 0x2109 },
	{ 0x2114, 0x2114 },
	{ 0x2116, 0x2118 },
	{ 0x211E, 0x2123 },
	{ 0x2125, 0x2125 },
	{ 0x2127, 0x2127 },
	{ 0x2129, 0x2129 },
	{ 0x212E, 0x212E },
	{ 0x213A, 0x213B },
	{ 0x2140, 0x2144 },
	{ 0x214A, 0x214D },
	{ 0x214F, 0x215F },
	{ 0x2180, 0x2182 },
	{ 0x2185, 0x218B },
	{ 0x2190, 0x2426 },
	{ 0x2440, 0x244A },
	{ 0x2460, 0x24B5 },
	{ 0x24EA, 0x2B73 },
	{ 0x2B76, 0x2B95 },
	{ 0x2B97, 0x2BFF },
	{ 0x2CE5, 0x2CEA },
	{ 0x2CEF, 0x2CF1 },
	{ 0x2CF9, 0x2CFF },
	{ 0x2D70, 0x2D70 },
	{ 0x2D7F, 0x2D7F },
	{ 0x2DE0, 0x2E2E },
	{ 0x2E30, 0x2E52 },
	{ 0x2E80, 0x2E99 },
	{ 0x2E9B, 0x2EF3 },
	{ 0x2F00, 0x2FD5 },
	{ 0x2FF0, 0x2FFB },
	{ 0x3000, 0x3004 },
	{ 0x3007, 0x3030 },
	{ 0x3036, 0x303A },
	{ 0x303D, 0x303F },
	{ 0x3099, 0x309C },
	{ 0x30A0, 0x30A0 },
	{ 0x30FB, 0x30FB },
	{ 0x3190, 0x319F },
	{ 0x31C0, 0x31E3 },
	{ 0x3200, 0x321E },
	{ 0x3220, 0x33FF },
	{ 0x4DC0, 0x4DFF },
	{ 0xA490, 0xA4C6 },
	{ 0xA4FE, 0xA4FF },
	{ 0xA60D, 0xA60F },
	{ 0xA620, 0xA629 },
	{ 0xA66F, 0xA67E },
	{ 0xA69E, 0xA69F },
	{ 0xA6E6, 0xA6F7 },
	{ 0xA700, 0xA716 },
	{ 0xA720, 0xA721 },
	{ 0xA789, 0xA78A },
	{ 0xA802, 0xA802 },
	{ 0xA806, 0xA806 },
	{ 0xA80B, 0xA80B },
	{ 0xA823, 0xA82C },
	{ 0xA830, 0xA839 },
	{ 0xA874, 0xA877 },
	{ 0xA880, 0xA881 },
	{ 0xA8B4, 0xA8C5 },
	{ 0xA8CE, 0xA8D9 },
	{ 0xA8E0, 0xA8F1 },
	{ 0xA8F8, 0xA8FA },
	{ 0xA8FC, 0xA8FC },
	{ 0xA8FF, 0xA909 },
	{ 0xA926, 0xA92F },
	{ 0xA947, 0xA953 },
	{ 0xA95F, 0xA95F },
	{ 0xA980, 0xA983 },
	{ 0xA9B3, 0xA9CD },
	{ 0xA9D0, 0xA9D9 },
	{ 0xA9DE, 0xA9DF },
	{ 0xA9E5, 0xA9E5 },
	{ 0xA9F0, 0xA9F9 },
	{ 0xAA29, 0xAA36 },
	{ 0xAA43, 0xAA43 },
	{ 0xAA4C, 0xAA4D },
	{ 0xAA50, 0xAA59 },
	{ 0xAA5C, 0xAA5F },
	{ 0xAA77, 0xAA79 },
	{ 0xAA7B, 0xAA7D },
	{ 0xAAB0, 0xAAB0 },
	{ 0xAAB2, 0xAAB4 },
	{ 0xAAB7, 0xAAB8 },
	{ 0xAABE, 0xAABF },
	{ 0xAAC1, 0xAAC1 },
	{ 0xAADE, 0xAADF },
	{ 0xAAEB, 0xAAF1 },
	{ 0xAAF5, 0xAAF6 },
	{ 0xAB5B, 0xAB5B },
	{ 0xAB6A, 0xAB6B },
	{ 0xABE3, 0xABED },
	{ 0xABF0, 0xABF9 },
	{ 0xE000, 0xF8FF },
	{ 0xFB1E, 0xFB1E },
	{ 0xFB29, 0xFB29 },
	{ 0xFBB2, 0xFBC1 },
	{ 0xFD3E, 0xFD3F },
	{ 0xFDFC, 0xFDFD },
	{ 0xFE00, 0xFE19 },
	{ 0xFE20, 0xFE52 },
	{ 0xFE54, 0xFE66 },
	{ 0xFE68, 0xFE6B },
	{ 0xFEFF, 0xFEFF },
	{ 0xFF01, 0xFF20 },
	{ 0xFF3B, 0xFF40 },
	{ 0xFF5B, 0xFF65 },
	{ 0xFFE0, 0xFFE6 },
	{ 0xFFE8, 0xFFEE },
	{ 0xFFF9, 0xFFFD },
	{ 0x10100, 0x10102 },
	{ 0x10107, 0x10133 },
	{ 0x10137, 0x1018E },
	{ 0x10190, 0x1019C },
	{ 0x101A0, 0x101A0 },
	{ 0x101D0, 0x101FD },
	{ 0x102E0, 0x102FB },
	{ 0x10320, 0x10323 },
	{ 0x10341, 0x10341 },
	{ 0x1034A, 0x1034A },
	{ 0x10376, 0x1037A },
	{ 0x1039F, 0x1039F },
	{ 0x103D0, 0x103D5 },
	{ 0x104A0, 0x104A9 },
	{ 0x1056F, 0x1056F },
	{ 0x10857, 0x1085F },
	{ 0x10877, 0x1087F },
	{ 0x108A7, 0x108AF },
	{ 0x108FB, 0x108FF },
	{ 0x10916, 0x1091B },
	{ 0x1091F, 0x1091F },
	{ 0x1093F, 0x1093F },
	{ 0x109BC, 0x109BD },
	{ 0x109C0, 0x109CF },
	{ 0x109D2, 0x109FF },
	{ 0x10A01, 0x10A03 },
	{ 0x10A05, 0x10A06 },
	{ 0x10A0C, 0x10A0F },
	{ 0x10A38, 0x10A3A },
	{ 0x10A3F, 0x10A48 },
	{ 0x10A50, 0x10A58 },
	{ 0x10A7D, 0x10A7F },
	{ 0x10A9D, 0x10A9F },
	{ 0x10AC8, 0x10AC8 },
	{ 0x10AE5, 0x10AE6 },
	{ 0x10AEB, 0x10AF6 },
	{ 0x10B39, 0x10B3F },
	{ 0x10B58, 0x10B5F },
	{ 0x10B78, 0x10B7F },
	{ 0x10B99, 0x10B9C },
	{ 0x10BA9, 0x10BAF },
	{ 0x10CFA, 0x10CFF },
	{ 0x10D24, 0x10D27 },
	{ 0x10D30, 0x10D39 },
	{ 0x10E60, 0x10E7E },
	{ 0x10EAB, 0x10EAD },
	{ 0x10F1D, 0x10F26 },
	{ 0x10F46, 0x10F59 },
	{ 0x10FC5, 0x10FCB },
	{ 0x11000, 0x11002 },
	{ 0x11038, 0x1104D },
	{ 0x11052, 0x1106F },
	{ 0x1107F, 0x11082 },
	{ 0x110B0, 0x110C1 },
	{ 0x110CD, 0x110CD },
	{ 0x110F0, 0x110F9 },
	{ 0x11100, 0x11102 },
	{ 0x11127, 0x11134 },
	{ 0x11136, 0x11143 },
	{ 0x11145, 0x11146 },
	{ 0x11173, 0x11175 },
	{ 0x11180, 0x11182 },
	{ 0x111B3, 0x111C0 },
	{ 0x111C5, 0x111D9 },
	{ 0x111DB, 0x111DB },
	{ 0x111DD, 0x111DF },
	{ 0x111E1, 0x111F4 },
	{ 0x1122C, 0x1123E },
	{ 0x112A9, 0x112A9 },
	{ 0x112DF, 0x112EA },
	{ 0x112F0, 0x112F9 },
	{ 0x11300, 0x11303 },
	{ 0x1133B, 0x1133C },
	{ 0x1133E, 0x11344 },
	{ 0x11347, 0x11348 },
	{ 0x1134B, 0x1134D },
	{ 0x11357, 0x11357 },
	{ 0x11362, 0x11363 },
	{ 0x11366, 0x1136C },
	{ 0x11370, 0x11374 },
	{ 0x11435, 0x11446 },
	{ 0x1144B, 0x1145B },
	{ 0x1145D, 0x1145E },
	{ 0x114B0, 0x114C3 },
	{ 0x114C6, 0x114C6 },
	{ 0x114D0, 0x114D9 },
	{ 0x115AF, 0x115B5 },
	{ 0x115B8, 0x115D7 },
	{ 0x115DC, 0x115DD },
	{ 0x11630, 0x11643 },
	{ 0x11650, 0x11659 },
	{ 0x11660, 0x1166C },
	{ 0x116AB, 0x116B7 },
	{ 0x116C0, 0x116C9 },
	{ 0x1171D, 0x1172B },
	{ 0x11730, 0x1173F },
	{ 0x1182C, 0x1183B },
	{ 0x118E0, 0x118F2 },
	{ 0x11930, 0x11935 },
	{ 0x11937, 0x11938 },
	{ 0x1193B, 0x1193E },
	{ 0x11940, 0x11940 },
	{ 0x11942, 0x11946 },
	{ 0x11950, 0x11959 },
	{ 0x119D1, 0x119D7 },
	{ 0x119DA, 0x119E0 },
	{ 0x119E2, 0x119E2 },
	{ 0x119E4, 0x119E4 },
	{ 0x11A01, 0x11A0A },
	{ 0x11A33, 0x11A39 },
	{ 0x11A3B, 0x11A47 },
	{ 0x11A51, 0x11A5B },
	{ 0x11A8A, 0x11A9C },
	{ 0x11A9E, 0x11AA2 },
	{ 0x11C2F, 0x11C36 },
	{ 0x11C38, 0x11C3F },
	{ 0x11C41, 0x11C45 },
	{ 0x11C50, 0x11C6C },
	{ 0x11C70, 0x11C71 },
	{ 0x11C92, 0x11CA7 },
	{ 0x11CA9, 0x11CB6 },
	{ 0x11D31, 0x11D36 },
	{ 0x11D3A, 0x11D3A },
	{ 0x11D3C, 0x11D3D },
	{ 0x11D3F, 0x11D45 },
	{ 0x11D47, 0x11D47 },
	{ 0x11D50, 0x11D59 },
	{ 0x11D8A, 0x11D8E },
	{ 0x11D90, 0x11D91 },
	{ 0x11D93, 0x11D97 },
	{ 0x11DA0, 0x11DA9 },
	{ 0x11EF3, 0x11EF8 },
	{ 0x11FC0, 0x11FF1 },
	{ 0x11FFF, 0x11FFF },
	{ 0x12400, 0x1246E },
	{ 0x12470, 0x12474 },
	{ 0x13430, 0x13438 },
	{ 0x16A60, 0x16A69 },
	{ 0x16A6E, 0x16A6F },
	{ 0x16AF0, 0x16AF5 },
	{ 0x16B30, 0x16B3F },
	{ 0x16B44, 0x16B45 },
	{ 0x16B50, 0x16B59 },
	{ 0x16B5B, 0x16B61 },
	{ 0x16E80, 0x16E9A },
	{ 0x16F4F, 0x16F4F },
	{ 0x16F51, 0x16F87 },
	{ 0x16F8F, 0x16F92 },
	{ 0x16FE2, 0x16FE2 },
	{ 0x16FE4, 0x16FE4 },
	{ 0x16FF0, 0x16FF1 },
	{ 0x1BC9C, 0x1BCA3 },
	{ 0x1D000, 0x1D0F5 },
	{ 0x1D100, 0x1D126 },
	{ 0x1D129, 0x1D1E8 },
	{ 0x1D200, 0x1D245 },
	{ 0x1D2E0, 0x1D2F3 },
	{ 0x1D300, 0x1D356 },
	{ 0x1D360, 0x1D378 },
	{ 0x1D6C1, 0x1D6C1 },
	{ 0x1D6DB, 0x1D6DB },
	{ 0x1D6FB, 0x1D6FB },
	{ 0x1D715, 0x1D715 },
	{ 0x1D735, 0x1D735 },
	{ 0x1D74F, 0x1D74F },
	{ 0x1D76F, 0x1D76F },
	{ 0x1D789, 0x1D789 },
	{ 0x1D7A9, 0x1D7A9 },
	{ 0x1D7C3, 0x1D7C3 },
	{ 0x1D7CE, 0x1DA8B },
	{ 0x1DA9B, 0x1DA9F },
	{ 0x1DAA1, 0x1DAAF },
	{ 0x1E000, 0x1E006 },
	{ 0x1E008, 0x1E018 },
	{ 0x1E01B, 0x1E021 },
	{ 0x1E023, 0x1E024 },
	{ 0x1E026, 0x1E02A },
	{ 0x1E130, 0x1E136 },
	{ 0x1E140, 0x1E149 },
	{ 0x1E14F, 0x1E14F },
	{ 0x1E2EC, 0x1E2F9 },
	{ 0x1E2FF, 0x1E2FF },
	{ 0x1E8C7, 0x1E8D6 },
	{ 0x1E944, 0x1E94A },
	{ 0x1E950, 0x1E959 },
	{ 0x1E95E, 0x1E95F },
	{ 0x1EC71, 0x1ECB4 },
	{ 0x1ED01, 0x1ED3D },
	{ 0x1EEF0, 0x1EEF1 },
	{ 0x1F000, 0x1F02B },
	{ 0x1F030, 0x1F093 },
	{ 0x1F0A0, 0x1F0AE },
	{ 0x1F0B1, 0x1F0BF },
	{ 0x1F0C1, 0x1F0CF },
	{ 0x1F0D1, 0x1F0F5 },
	{ 0x1F100, 0x1F1AD },
	{ 0x1F1E6, 0x1F202 },
	{ 0x1F210, 0x1F23B },
	{ 0x1F240, 0x1F248 },
	{ 0x1F250, 0x1F251 },
	{ 0x1F260, 0x1F265 },
	{ 0x1F300, 0x1F6D7 },
	{ 0x1F6E0, 0x1F6EC },
	{ 0x1F6F0, 0x1F6FC },
	{ 0x1F700, 0x1F773 },
	{ 0x1F780, 0x1F7D8 },
	{ 0x1F7E0, 0x1F7EB },
	{ 0x1F800, 0x1F80B },
	{ 0x1F810, 0x1F847 },
	{ 0x1F850, 0x1F859 },
	{ 0x1F860, 0x1F887 },
	{ 0x1F890, 0x1F8AD },
	{ 0x1F8B0, 0x1F8B1 },
	{ 0x1F900, 0x1F978 },
	{ 0x1F97A, 0x1F9CB },
	{ 0x1F9CD, 0x1FA53 },
	{ 0x1FA60, 0x1FA6D },
	{ 0x1FA70, 0x1FA74 },
	{ 0x1FA78, 0x1FA7A },
	{ 0x1FA80, 0x1FA86 },
	{ 0x1FA90, 0x1FAA8 },
	{ 0x1FAB0, 0x1FAB6 },
	{ 0x1FAC0, 0x1FAC2 },
	{ 0x1FAD0, 0x1FAD6 },
	{ 0x1FB00, 0x1FB92 },
	{ 0x1FB94, 0x1FBCA },
	{ 0x1FBF0, 0x1FBF9 },
	{ 0xE0001, 0xE0001 },
	{ 0xE0020, 0xE007F },
	{ 0xE0100, 0xE01EF },
	{ 0xF0000, 0xFFFFD },
	{ 0x100000, 0x10FFFD }
};

MAKE_ISW(punct)

#ifdef TEST_I18N
static const struct mb_ucsrange data_wctype_graph[] = {
	{ 0x0021, 0x007E },
	{ 0x00A0, 0x0377 },
	{ 0x037A, 0x037F },
	{ 0x0384, 0x038A },
	{ 0x038C, 0x038C },
	{ 0x038E, 0x03A1 },
	{ 0x03A3, 0x052F },
	{ 0x0531, 0x0556 },
	{ 0x0559, 0x058A },
	{ 0x058D, 0x058F },
	{ 0x0591, 0x05C7 },
	{ 0x05D0, 0x05EA },
	{ 0x05EF, 0x05F4 },
	{ 0x0600, 0x061C },
	{ 0x061E, 0x070D },
	{ 0x070F, 0x074A },
	{ 0x074D, 0x07B1 },
	{ 0x07C0, 0x07FA },
	{ 0x07FD, 0x082D },
	{ 0x0830, 0x083E },
	{ 0x0840, 0x085B },
	{ 0x085E, 0x085E },
	{ 0x0860, 0x086A },
	{ 0x08A0, 0x08B4 },
	{ 0x08B6, 0x08C7 },
	{ 0x08D3, 0x0983 },
	{ 0x0985, 0x098C },
	{ 0x098F, 0x0990 },
	{ 0x0993, 0x09A8 },
	{ 0x09AA, 0x09B0 },
	{ 0x09B2, 0x09B2 },
	{ 0x09B6, 0x09B9 },
	{ 0x09BC, 0x09C4 },
	{ 0x09C7, 0x09C8 },
	{ 0x09CB, 0x09CE },
	{ 0x09D7, 0x09D7 },
	{ 0x09DC, 0x09DD },
	{ 0x09DF, 0x09E3 },
	{ 0x09E6, 0x09FE },
	{ 0x0A01, 0x0A03 },
	{ 0x0A05, 0x0A0A },
	{ 0x0A0F, 0x0A10 },
	{ 0x0A13, 0x0A28 },
	{ 0x0A2A, 0x0A30 },
	{ 0x0A32, 0x0A33 },
	{ 0x0A35, 0x0A36 },
	{ 0x0A38, 0x0A39 },
	{ 0x0A3C, 0x0A3C },
	{ 0x0A3E, 0x0A42 },
	{ 0x0A47, 0x0A48 },
	{ 0x0A4B, 0x0A4D },
	{ 0x0A51, 0x0A51 },
	{ 0x0A59, 0x0A5C },
	{ 0x0A5E, 0x0A5E },
	{ 0x0A66, 0x0A76 },
	{ 0x0A81, 0x0A83 },
	{ 0x0A85, 0x0A8D },
	{ 0x0A8F, 0x0A91 },
	{ 0x0A93, 0x0AA8 },
	{ 0x0AAA, 0x0AB0 },
	{ 0x0AB2, 0x0AB3 },
	{ 0x0AB5, 0x0AB9 },
	{ 0x0ABC, 0x0AC5 },
	{ 0x0AC7, 0x0AC9 },
	{ 0x0ACB, 0x0ACD },
	{ 0x0AD0, 0x0AD0 },
	{ 0x0AE0, 0x0AE3 },
	{ 0x0AE6, 0x0AF1 },
	{ 0x0AF9, 0x0AFF },
	{ 0x0B01, 0x0B03 },
	{ 0x0B05, 0x0B0C },
	{ 0x0B0F, 0x0B10 },
	{ 0x0B13, 0x0B28 },
	{ 0x0B2A, 0x0B30 },
	{ 0x0B32, 0x0B33 },
	{ 0x0B35, 0x0B39 },
	{ 0x0B3C, 0x0B44 },
	{ 0x0B47, 0x0B48 },
	{ 0x0B4B, 0x0B4D },
	{ 0x0B55, 0x0B57 },
	{ 0x0B5C, 0x0B5D },
	{ 0x0B5F, 0x0B63 },
	{ 0x0B66, 0x0B77 },
	{ 0x0B82, 0x0B83 },
	{ 0x0B85, 0x0B8A },
	{ 0x0B8E, 0x0B90 },
	{ 0x0B92, 0x0B95 },
	{ 0x0B99, 0x0B9A },
	{ 0x0B9C, 0x0B9C },
	{ 0x0B9E, 0x0B9F },
	{ 0x0BA3, 0x0BA4 },
	{ 0x0BA8, 0x0BAA },
	{ 0x0BAE, 0x0BB9 },
	{ 0x0BBE, 0x0BC2 },
	{ 0x0BC6, 0x0BC8 },
	{ 0x0BCA, 0x0BCD },
	{ 0x0BD0, 0x0BD0 },
	{ 0x0BD7, 0x0BD7 },
	{ 0x0BE6, 0x0BFA },
	{ 0x0C00, 0x0C0C },
	{ 0x0C0E, 0x0C10 },
	{ 0x0C12, 0x0C28 },
	{ 0x0C2A, 0x0C39 },
	{ 0x0C3D, 0x0C44 },
	{ 0x0C46, 0x0C48 },
	{ 0x0C4A, 0x0C4D },
	{ 0x0C55, 0x0C56 },
	{ 0x0C58, 0x0C5A },
	{ 0x0C60, 0x0C63 },
	{ 0x0C66, 0x0C6F },
	{ 0x0C77, 0x0C8C },
	{ 0x0C8E, 0x0C90 },
	{ 0x0C92, 0x0CA8 },
	{ 0x0CAA, 0x0CB3 },
	{ 0x0CB5, 0x0CB9 },
	{ 0x0CBC, 0x0CC4 },
	{ 0x0CC6, 0x0CC8 },
	{ 0x0CCA, 0x0CCD },
	{ 0x0CD5, 0x0CD6 },
	{ 0x0CDE, 0x0CDE },
	{ 0x0CE0, 0x0CE3 },
	{ 0x0CE6, 0x0CEF },
	{ 0x0CF1, 0x0CF2 },
	{ 0x0D00, 0x0D0C },
	{ 0x0D0E, 0x0D10 },
	{ 0x0D12, 0x0D44 },
	{ 0x0D46, 0x0D48 },
	{ 0x0D4A, 0x0D4F },
	{ 0x0D54, 0x0D63 },
	{ 0x0D66, 0x0D7F },
	{ 0x0D81, 0x0D83 },
	{ 0x0D85, 0x0D96 },
	{ 0x0D9A, 0x0DB1 },
	{ 0x0DB3, 0x0DBB },
	{ 0x0DBD, 0x0DBD },
	{ 0x0DC0, 0x0DC6 },
	{ 0x0DCA, 0x0DCA },
	{ 0x0DCF, 0x0DD4 },
	{ 0x0DD6, 0x0DD6 },
	{ 0x0DD8, 0x0DDF },
	{ 0x0DE6, 0x0DEF },
	{ 0x0DF2, 0x0DF4 },
	{ 0x0E01, 0x0E3A },
	{ 0x0E3F, 0x0E5B },
	{ 0x0E81, 0x0E82 },
	{ 0x0E84, 0x0E84 },
	{ 0x0E86, 0x0E8A },
	{ 0x0E8C, 0x0EA3 },
	{ 0x0EA5, 0x0EA5 },
	{ 0x0EA7, 0x0EBD },
	{ 0x0EC0, 0x0EC4 },
	{ 0x0EC6, 0x0EC6 },
	{ 0x0EC8, 0x0ECD },
	{ 0x0ED0, 0x0ED9 },
	{ 0x0EDC, 0x0EDF },
	{ 0x0F00, 0x0F47 },
	{ 0x0F49, 0x0F6C },
	{ 0x0F71, 0x0F97 },
	{ 0x0F99, 0x0FBC },
	{ 0x0FBE, 0x0FCC },
	{ 0x0FCE, 0x0FDA },
	{ 0x1000, 0x10C5 },
	{ 0x10C7, 0x10C7 },
	{ 0x10CD, 0x10CD },
	{ 0x10D0, 0x1248 },
	{ 0x124A, 0x124D },
	{ 0x1250, 0x1256 },
	{ 0x1258, 0x1258 },
	{ 0x125A, 0x125D },
	{ 0x1260, 0x1288 },
	{ 0x128A, 0x128D },
	{ 0x1290, 0x12B0 },
	{ 0x12B2, 0x12B5 },
	{ 0x12B8, 0x12BE },
	{ 0x12C0, 0x12C0 },
	{ 0x12C2, 0x12C5 },
	{ 0x12C8, 0x12D6 },
	{ 0x12D8, 0x1310 },
	{ 0x1312, 0x1315 },
	{ 0x1318, 0x135A },
	{ 0x135D, 0x137C },
	{ 0x1380, 0x1399 },
	{ 0x13A0, 0x13F5 },
	{ 0x13F8, 0x13FD },
	{ 0x1400, 0x169C },
	{ 0x16A0, 0x16F8 },
	{ 0x1700, 0x170C },
	{ 0x170E, 0x1714 },
	{ 0x1720, 0x1736 },
	{ 0x1740, 0x1753 },
	{ 0x1760, 0x176C },
	{ 0x176E, 0x1770 },
	{ 0x1772, 0x1773 },
	{ 0x1780, 0x17DD },
	{ 0x17E0, 0x17E9 },
	{ 0x17F0, 0x17F9 },
	{ 0x1800, 0x180E },
	{ 0x1810, 0x1819 },
	{ 0x1820, 0x1878 },
	{ 0x1880, 0x18AA },
	{ 0x18B0, 0x18F5 },
	{ 0x1900, 0x191E },
	{ 0x1920, 0x192B },
	{ 0x1930, 0x193B },
	{ 0x1940, 0x1940 },
	{ 0x1944, 0x196D },
	{ 0x1970, 0x1974 },
	{ 0x1980, 0x19AB },
	{ 0x19B0, 0x19C9 },
	{ 0x19D0, 0x19DA },
	{ 0x19DE, 0x1A1B },
	{ 0x1A1E, 0x1A5E },
	{ 0x1A60, 0x1A7C },
	{ 0x1A7F, 0x1A89 },
	{ 0x1A90, 0x1A99 },
	{ 0x1AA0, 0x1AAD },
	{ 0x1AB0, 0x1AC0 },
	{ 0x1B00, 0x1B4B },
	{ 0x1B50, 0x1B7C },
	{ 0x1B80, 0x1BF3 },
	{ 0x1BFC, 0x1C37 },
	{ 0x1C3B, 0x1C49 },
	{ 0x1C4D, 0x1C88 },
	{ 0x1C90, 0x1CBA },
	{ 0x1CBD, 0x1CC7 },
	{ 0x1CD0, 0x1CFA },
	{ 0x1D00, 0x1DF9 },
	{ 0x1DFB, 0x1F15 },
	{ 0x1F18, 0x1F1D },
	{ 0x1F20, 0x1F45 },
	{ 0x1F48, 0x1F4D },
	{ 0x1F50, 0x1F57 },
	{ 0x1F59, 0x1F59 },
	{ 0x1F5B, 0x1F5B },
	{ 0x1F5D, 0x1F5D },
	{ 0x1F5F, 0x1F7D },
	{ 0x1F80, 0x1FB4 },
	{ 0x1FB6, 0x1FC4 },
	{ 0x1FC6, 0x1FD3 },
	{ 0x1FD6, 0x1FDB },
	{ 0x1FDD, 0x1FEF },
	{ 0x1FF2, 0x1FF4 },
	{ 0x1FF6, 0x1FFE },
	{ 0x2000, 0x2064 },
	{ 0x2066, 0x2071 },
	{ 0x2074, 0x208E },
	{ 0x2090, 0x209C },
	{ 0x20A0, 0x20BF },
	{ 0x20D0, 0x20F0 },
	{ 0x2100, 0x218B },
	{ 0x2190, 0x2426 },
	{ 0x2440, 0x244A },
	{ 0x2460, 0x2B73 },
	{ 0x2B76, 0x2B95 },
	{ 0x2B97, 0x2C2E },
	{ 0x2C30, 0x2C5E },
	{ 0x2C60, 0x2CF3 },
	{ 0x2CF9, 0x2D25 },
	{ 0x2D27, 0x2D27 },
	{ 0x2D2D, 0x2D2D },
	{ 0x2D30, 0x2D67 },
	{ 0x2D6F, 0x2D70 },
	{ 0x2D7F, 0x2D96 },
	{ 0x2DA0, 0x2DA6 },
	{ 0x2DA8, 0x2DAE },
	{ 0x2DB0, 0x2DB6 },
	{ 0x2DB8, 0x2DBE },
	{ 0x2DC0, 0x2DC6 },
	{ 0x2DC8, 0x2DCE },
	{ 0x2DD0, 0x2DD6 },
	{ 0x2DD8, 0x2DDE },
	{ 0x2DE0, 0x2E52 },
	{ 0x2E80, 0x2E99 },
	{ 0x2E9B, 0x2EF3 },
	{ 0x2F00, 0x2FD5 },
	{ 0x2FF0, 0x2FFB },
	{ 0x3000, 0x303F },
	{ 0x3041, 0x3096 },
	{ 0x3099, 0x30FF },
	{ 0x3105, 0x312F },
	{ 0x3131, 0x318E },
	{ 0x3190, 0x31E3 },
	{ 0x31F0, 0x321E },
	{ 0x3220, 0x9FFC },
	{ 0xA000, 0xA48C },
	{ 0xA490, 0xA4C6 },
	{ 0xA4D0, 0xA62B },
	{ 0xA640, 0xA6F7 },
	{ 0xA700, 0xA7BF },
	{ 0xA7C2, 0xA7CA },
	{ 0xA7F5, 0xA82C },
	{ 0xA830, 0xA839 },
	{ 0xA840, 0xA877 },
	{ 0xA880, 0xA8C5 },
	{ 0xA8CE, 0xA8D9 },
	{ 0xA8E0, 0xA953 },
	{ 0xA95F, 0xA97C },
	{ 0xA980, 0xA9CD },
	{ 0xA9CF, 0xA9D9 },
	{ 0xA9DE, 0xA9FE },
	{ 0xAA00, 0xAA36 },
	{ 0xAA40, 0xAA4D },
	{ 0xAA50, 0xAA59 },
	{ 0xAA5C, 0xAAC2 },
	{ 0xAADB, 0xAAF6 },
	{ 0xAB01, 0xAB06 },
	{ 0xAB09, 0xAB0E },
	{ 0xAB11, 0xAB16 },
	{ 0xAB20, 0xAB26 },
	{ 0xAB28, 0xAB2E },
	{ 0xAB30, 0xAB6B },
	{ 0xAB70, 0xABED },
	{ 0xABF0, 0xABF9 },
	{ 0xAC00, 0xD7A3 },
	{ 0xD7B0, 0xD7C6 },
	{ 0xD7CB, 0xD7FB },
	{ 0xE000, 0xFA6D },
	{ 0xFA70, 0xFAD9 },
	{ 0xFB00, 0xFB06 },
	{ 0xFB13, 0xFB17 },
	{ 0xFB1D, 0xFB36 },
	{ 0xFB38, 0xFB3C },
	{ 0xFB3E, 0xFB3E },
	{ 0xFB40, 0xFB41 },
	{ 0xFB43, 0xFB44 },
	{ 0xFB46, 0xFBC1 },
	{ 0xFBD3, 0xFD3F },
	{ 0xFD50, 0xFD8F },
	{ 0xFD92, 0xFDC7 },
	{ 0xFDF0, 0xFDFD },
	{ 0xFE00, 0xFE19 },
	{ 0xFE20, 0xFE52 },
	{ 0xFE54, 0xFE66 },
	{ 0xFE68, 0xFE6B },
	{ 0xFE70, 0xFE74 },
	{ 0xFE76, 0xFEFC },
	{ 0xFEFF, 0xFEFF },
	{ 0xFF01, 0xFFBE },
	{ 0xFFC2, 0xFFC7 },
	{ 0xFFCA, 0xFFCF },
	{ 0xFFD2, 0xFFD7 },
	{ 0xFFDA, 0xFFDC },
	{ 0xFFE0, 0xFFE6 },
	{ 0xFFE8, 0xFFEE },
	{ 0xFFF9, 0xFFFD },
	{ 0x10000, 0x1000B },
	{ 0x1000D, 0x10026 },
	{ 0x10028, 0x1003A },
	{ 0x1003C, 0x1003D },
	{ 0x1003F, 0x1004D },
	{ 0x10050, 0x1005D },
	{ 0x10080, 0x100FA },
	{ 0x10100, 0x10102 },
	{ 0x10107, 0x10133 },
	{ 0x10137, 0x1018E },
	{ 0x10190, 0x1019C },
	{ 0x101A0, 0x101A0 },
	{ 0x101D0, 0x101FD },
	{ 0x10280, 0x1029C },
	{ 0x102A0, 0x102D0 },
	{ 0x102E0, 0x102FB },
	{ 0x10300, 0x10323 },
	{ 0x1032D, 0x1034A },
	{ 0x10350, 0x1037A },
	{ 0x10380, 0x1039D },
	{ 0x1039F, 0x103C3 },
	{ 0x103C8, 0x103D5 },
	{ 0x10400, 0x1049D },
	{ 0x104A0, 0x104A9 },
	{ 0x104B0, 0x104D3 },
	{ 0x104D8, 0x104FB },
	{ 0x10500, 0x10527 },
	{ 0x10530, 0x10563 },
	{ 0x1056F, 0x1056F },
	{ 0x10600, 0x10736 },
	{ 0x10740, 0x10755 },
	{ 0x10760, 0x10767 },
	{ 0x10800, 0x10805 },
	{ 0x10808, 0x10808 },
	{ 0x1080A, 0x10835 },
	{ 0x10837, 0x10838 },
	{ 0x1083C, 0x1083C },
	{ 0x1083F, 0x10855 },
	{ 0x10857, 0x1089E },
	{ 0x108A7, 0x108AF },
	{ 0x108E0, 0x108F2 },
	{ 0x108F4, 0x108F5 },
	{ 0x108FB, 0x1091B },
	{ 0x1091F, 0x10939 },
	{ 0x1093F, 0x1093F },
	{ 0x10980, 0x109B7 },
	{ 0x109BC, 0x109CF },
	{ 0x109D2, 0x10A03 },
	{ 0x10A05, 0x10A06 },
	{ 0x10A0C, 0x10A13 },
	{ 0x10A15, 0x10A17 },
	{ 0x10A19, 0x10A35 },
	{ 0x10A38, 0x10A3A },
	{ 0x10A3F, 0x10A48 },
	{ 0x10A50, 0x10A58 },
	{ 0x10A60, 0x10A9F },
	{ 0x10AC0, 0x10AE6 },
	{ 0x10AEB, 0x10AF6 },
	{ 0x10B00, 0x10B35 },
	{ 0x10B39, 0x10B55 },
	{ 0x10B58, 0x10B72 },
	{ 0x10B78, 0x10B91 },
	{ 0x10B99, 0x10B9C },
	{ 0x10BA9, 0x10BAF },
	{ 0x10C00, 0x10C48 },
	{ 0x10C80, 0x10CB2 },
	{ 0x10CC0, 0x10CF2 },
	{ 0x10CFA, 0x10D27 },
	{ 0x10D30, 0x10D39 },
	{ 0x10E60, 0x10E7E },
	{ 0x10E80, 0x10EA9 },
	{ 0x10EAB, 0x10EAD },
	{ 0x10EB0, 0x10EB1 },
	{ 0x10F00, 0x10F27 },
	{ 0x10F30, 0x10F59 },
	{ 0x10FB0, 0x10FCB },
	{ 0x10FE0, 0x10FF6 },
	{ 0x11000, 0x1104D },
	{ 0x11052, 0x1106F },
	{ 0x1107F, 0x110C1 },
	{ 0x110CD, 0x110CD },
	{ 0x110D0, 0x110E8 },
	{ 0x110F0, 0x110F9 },
	{ 0x11100, 0x11134 },
	{ 0x11136, 0x11147 },
	{ 0x11150, 0x11176 },
	{ 0x11180, 0x111DF },
	{ 0x111E1, 0x111F4 },
	{ 0x11200, 0x11211 },
	{ 0x11213, 0x1123E },
	{ 0x11280, 0x11286 },
	{ 0x11288, 0x11288 },
	{ 0x1128A, 0x1128D },
	{ 0x1128F, 0x1129D },
	{ 0x1129F, 0x112A9 },
	{ 0x112B0, 0x112EA },
	{ 0x112F0, 0x112F9 },
	{ 0x11300, 0x11303 },
	{ 0x11305, 0x1130C },
	{ 0x1130F, 0x11310 },
	{ 0x11313, 0x11328 },
	{ 0x1132A, 0x11330 },
	{ 0x11332, 0x11333 },
	{ 0x11335, 0x11339 },
	{ 0x1133B, 0x11344 },
	{ 0x11347, 0x11348 },
	{ 0x1134B, 0x1134D },
	{ 0x11350, 0x11350 },
	{ 0x11357, 0x11357 },
	{ 0x1135D, 0x11363 },
	{ 0x11366, 0x1136C },
	{ 0x11370, 0x11374 },
	{ 0x11400, 0x1145B },
	{ 0x1145D, 0x11461 },
	{ 0x11480, 0x114C7 },
	{ 0x114D0, 0x114D9 },
	{ 0x11580, 0x115B5 },
	{ 0x115B8, 0x115DD },
	{ 0x11600, 0x11644 },
	{ 0x11650, 0x11659 },
	{ 0x11660, 0x1166C },
	{ 0x11680, 0x116B8 },
	{ 0x116C0, 0x116C9 },
	{ 0x11700, 0x1171A },
	{ 0x1171D, 0x1172B },
	{ 0x11730, 0x1173F },
	{ 0x11800, 0x1183B },
	{ 0x118A0, 0x118F2 },
	{ 0x118FF, 0x11906 },
	{ 0x11909, 0x11909 },
	{ 0x1190C, 0x11913 },
	{ 0x11915, 0x11916 },
	{ 0x11918, 0x11935 },
	{ 0x11937, 0x11938 },
	{ 0x1193B, 0x11946 },
	{ 0x11950, 0x11959 },
	{ 0x119A0, 0x119A7 },
	{ 0x119AA, 0x119D7 },
	{ 0x119DA, 0x119E4 },
	{ 0x11A00, 0x11A47 },
	{ 0x11A50, 0x11AA2 },
	{ 0x11AC0, 0x11AF8 },
	{ 0x11C00, 0x11C08 },
	{ 0x11C0A, 0x11C36 },
	{ 0x11C38, 0x11C45 },
	{ 0x11C50, 0x11C6C },
	{ 0x11C70, 0x11C8F },
	{ 0x11C92, 0x11CA7 },
	{ 0x11CA9, 0x11CB6 },
	{ 0x11D00, 0x11D06 },
	{ 0x11D08, 0x11D09 },
	{ 0x11D0B, 0x11D36 },
	{ 0x11D3A, 0x11D3A },
	{ 0x11D3C, 0x11D3D },
	{ 0x11D3F, 0x11D47 },
	{ 0x11D50, 0x11D59 },
	{ 0x11D60, 0x11D65 },
	{ 0x11D67, 0x11D68 },
	{ 0x11D6A, 0x11D8E },
	{ 0x11D90, 0x11D91 },
	{ 0x11D93, 0x11D98 },
	{ 0x11DA0, 0x11DA9 },
	{ 0x11EE0, 0x11EF8 },
	{ 0x11FB0, 0x11FB0 },
	{ 0x11FC0, 0x11FF1 },
	{ 0x11FFF, 0x12399 },
	{ 0x12400, 0x1246E },
	{ 0x12470, 0x12474 },
	{ 0x12480, 0x12543 },
	{ 0x13000, 0x1342E },
	{ 0x13430, 0x13438 },
	{ 0x14400, 0x14646 },
	{ 0x16800, 0x16A38 },
	{ 0x16A40, 0x16A5E },
	{ 0x16A60, 0x16A69 },
	{ 0x16A6E, 0x16A6F },
	{ 0x16AD0, 0x16AED },
	{ 0x16AF0, 0x16AF5 },
	{ 0x16B00, 0x16B45 },
	{ 0x16B50, 0x16B59 },
	{ 0x16B5B, 0x16B61 },
	{ 0x16B63, 0x16B77 },
	{ 0x16B7D, 0x16B8F },
	{ 0x16E40, 0x16E9A },
	{ 0x16F00, 0x16F4A },
	{ 0x16F4F, 0x16F87 },
	{ 0x16F8F, 0x16F9F },
	{ 0x16FE0, 0x16FE4 },
	{ 0x16FF0, 0x16FF1 },
	{ 0x17000, 0x187F7 },
	{ 0x18800, 0x18CD5 },
	{ 0x18D00, 0x18D08 },
	{ 0x1B000, 0x1B11E },
	{ 0x1B150, 0x1B152 },
	{ 0x1B164, 0x1B167 },
	{ 0x1B170, 0x1B2FB },
	{ 0x1BC00, 0x1BC6A },
	{ 0x1BC70, 0x1BC7C },
	{ 0x1BC80, 0x1BC88 },
	{ 0x1BC90, 0x1BC99 },
	{ 0x1BC9C, 0x1BCA3 },
	{ 0x1D000, 0x1D0F5 },
	{ 0x1D100, 0x1D126 },
	{ 0x1D129, 0x1D1E8 },
	{ 0x1D200, 0x1D245 },
	{ 0x1D2E0, 0x1D2F3 },
	{ 0x1D300, 0x1D356 },
	{ 0x1D360, 0x1D378 },
	{ 0x1D400, 0x1D454 },
	{ 0x1D456, 0x1D49C },
	{ 0x1D49E, 0x1D49F },
	{ 0x1D4A2, 0x1D4A2 },
	{ 0x1D4A5, 0x1D4A6 },
	{ 0x1D4A9, 0x1D4AC },
	{ 0x1D4AE, 0x1D4B9 },
	{ 0x1D4BB, 0x1D4BB },
	{ 0x1D4BD, 0x1D4C3 },
	{ 0x1D4C5, 0x1D505 },
	{ 0x1D507, 0x1D50A },
	{ 0x1D50D, 0x1D514 },
	{ 0x1D516, 0x1D51C },
	{ 0x1D51E, 0x1D539 },
	{ 0x1D53B, 0x1D53E },
	{ 0x1D540, 0x1D544 },
	{ 0x1D546, 0x1D546 },
	{ 0x1D54A, 0x1D550 },
	{ 0x1D552, 0x1D6A5 },
	{ 0x1D6A8, 0x1D7CB },
	{ 0x1D7CE, 0x1DA8B },
	{ 0x1DA9B, 0x1DA9F },
	{ 0x1DAA1, 0x1DAAF },
	{ 0x1E000, 0x1E006 },
	{ 0x1E008, 0x1E018 },
	{ 0x1E01B, 0x1E021 },
	{ 0x1E023, 0x1E024 },
	{ 0x1E026, 0x1E02A },
	{ 0x1E100, 0x1E12C },
	{ 0x1E130, 0x1E13D },
	{ 0x1E140, 0x1E149 },
	{ 0x1E14E, 0x1E14F },
	{ 0x1E2C0, 0x1E2F9 },
	{ 0x1E2FF, 0x1E2FF },
	{ 0x1E800, 0x1E8C4 },
	{ 0x1E8C7, 0x1E8D6 },
	{ 0x1E900, 0x1E94B },
	{ 0x1E950, 0x1E959 },
	{ 0x1E95E, 0x1E95F },
	{ 0x1EC71, 0x1ECB4 },
	{ 0x1ED01, 0x1ED3D },
	{ 0x1EE00, 0x1EE03 },
	{ 0x1EE05, 0x1EE1F },
	{ 0x1EE21, 0x1EE22 },
	{ 0x1EE24, 0x1EE24 },
	{ 0x1EE27, 0x1EE27 },
	{ 0x1EE29, 0x1EE32 },
	{ 0x1EE34, 0x1EE37 },
	{ 0x1EE39, 0x1EE39 },
	{ 0x1EE3B, 0x1EE3B },
	{ 0x1EE42, 0x1EE42 },
	{ 0x1EE47, 0x1EE47 },
	{ 0x1EE49, 0x1EE49 },
	{ 0x1EE4B, 0x1EE4B },
	{ 0x1EE4D, 0x1EE4F },
	{ 0x1EE51, 0x1EE52 },
	{ 0x1EE54, 0x1EE54 },
	{ 0x1EE57, 0x1EE57 },
	{ 0x1EE59, 0x1EE59 },
	{ 0x1EE5B, 0x1EE5B },
	{ 0x1EE5D, 0x1EE5D },
	{ 0x1EE5F, 0x1EE5F },
	{ 0x1EE61, 0x1EE62 },
	{ 0x1EE64, 0x1EE64 },
	{ 0x1EE67, 0x1EE6A },
	{ 0x1EE6C, 0x1EE72 },
	{ 0x1EE74, 0x1EE77 },
	{ 0x1EE79, 0x1EE7C },
	{ 0x1EE7E, 0x1EE7E },
	{ 0x1EE80, 0x1EE89 },
	{ 0x1EE8B, 0x1EE9B },
	{ 0x1EEA1, 0x1EEA3 },
	{ 0x1EEA5, 0x1EEA9 },
	{ 0x1EEAB, 0x1EEBB },
	{ 0x1EEF0, 0x1EEF1 },
	{ 0x1F000, 0x1F02B },
	{ 0x1F030, 0x1F093 },
	{ 0x1F0A0, 0x1F0AE },
	{ 0x1F0B1, 0x1F0BF },
	{ 0x1F0C1, 0x1F0CF },
	{ 0x1F0D1, 0x1F0F5 },
	{ 0x1F100, 0x1F1AD },
	{ 0x1F1E6, 0x1F202 },
	{ 0x1F210, 0x1F23B },
	{ 0x1F240, 0x1F248 },
	{ 0x1F250, 0x1F251 },
	{ 0x1F260, 0x1F265 },
	{ 0x1F300, 0x1F6D7 },
	{ 0x1F6E0, 0x1F6EC },
	{ 0x1F6F0, 0x1F6FC },
	{ 0x1F700, 0x1F773 },
	{ 0x1F780, 0x1F7D8 },
	{ 0x1F7E0, 0x1F7EB },
	{ 0x1F800, 0x1F80B },
	{ 0x1F810, 0x1F847 },
	{ 0x1F850, 0x1F859 },
	{ 0x1F860, 0x1F887 },
	{ 0x1F890, 0x1F8AD },
	{ 0x1F8B0, 0x1F8B1 },
	{ 0x1F900, 0x1F978 },
	{ 0x1F97A, 0x1F9CB },
	{ 0x1F9CD, 0x1FA53 },
	{ 0x1FA60, 0x1FA6D },
	{ 0x1FA70, 0x1FA74 },
	{ 0x1FA78, 0x1FA7A },
	{ 0x1FA80, 0x1FA86 },
	{ 0x1FA90, 0x1FAA8 },
	{ 0x1FAB0, 0x1FAB6 },
	{ 0x1FAC0, 0x1FAC2 },
	{ 0x1FAD0, 0x1FAD6 },
	{ 0x1FB00, 0x1FB92 },
	{ 0x1FB94, 0x1FBCA },
	{ 0x1FBF0, 0x1FBF9 },
	{ 0x20000, 0x2A6DD },
	{ 0x2A700, 0x2B734 },
	{ 0x2B740, 0x2B81D },
	{ 0x2B820, 0x2CEA1 },
	{ 0x2CEB0, 0x2EBE0 },
	{ 0x2F800, 0x2FA1D },
	{ 0x30000, 0x3134A },
	{ 0xE0001, 0xE0001 },
	{ 0xE0020, 0xE007F },
	{ 0xE0100, 0xE01EF },
	{ 0xF0000, 0xFFFFD },
	{ 0x100000, 0x10FFFD }
};

MAKE_ISW(graph)
#endif

static const struct mb_ucsrange data_wctype_print[] = {
	{ 0x0020, 0x007E },
	{ 0x00A0, 0x0377 },
	{ 0x037A, 0x037F },
	{ 0x0384, 0x038A },
	{ 0x038C, 0x038C },
	{ 0x038E, 0x03A1 },
	{ 0x03A3, 0x052F },
	{ 0x0531, 0x0556 },
	{ 0x0559, 0x058A },
	{ 0x058D, 0x058F },
	{ 0x0591, 0x05C7 },
	{ 0x05D0, 0x05EA },
	{ 0x05EF, 0x05F4 },
	{ 0x0600, 0x061C },
	{ 0x061E, 0x070D },
	{ 0x070F, 0x074A },
	{ 0x074D, 0x07B1 },
	{ 0x07C0, 0x07FA },
	{ 0x07FD, 0x082D },
	{ 0x0830, 0x083E },
	{ 0x0840, 0x085B },
	{ 0x085E, 0x085E },
	{ 0x0860, 0x086A },
	{ 0x08A0, 0x08B4 },
	{ 0x08B6, 0x08C7 },
	{ 0x08D3, 0x0983 },
	{ 0x0985, 0x098C },
	{ 0x098F, 0x0990 },
	{ 0x0993, 0x09A8 },
	{ 0x09AA, 0x09B0 },
	{ 0x09B2, 0x09B2 },
	{ 0x09B6, 0x09B9 },
	{ 0x09BC, 0x09C4 },
	{ 0x09C7, 0x09C8 },
	{ 0x09CB, 0x09CE },
	{ 0x09D7, 0x09D7 },
	{ 0x09DC, 0x09DD },
	{ 0x09DF, 0x09E3 },
	{ 0x09E6, 0x09FE },
	{ 0x0A01, 0x0A03 },
	{ 0x0A05, 0x0A0A },
	{ 0x0A0F, 0x0A10 },
	{ 0x0A13, 0x0A28 },
	{ 0x0A2A, 0x0A30 },
	{ 0x0A32, 0x0A33 },
	{ 0x0A35, 0x0A36 },
	{ 0x0A38, 0x0A39 },
	{ 0x0A3C, 0x0A3C },
	{ 0x0A3E, 0x0A42 },
	{ 0x0A47, 0x0A48 },
	{ 0x0A4B, 0x0A4D },
	{ 0x0A51, 0x0A51 },
	{ 0x0A59, 0x0A5C },
	{ 0x0A5E, 0x0A5E },
	{ 0x0A66, 0x0A76 },
	{ 0x0A81, 0x0A83 },
	{ 0x0A85, 0x0A8D },
	{ 0x0A8F, 0x0A91 },
	{ 0x0A93, 0x0AA8 },
	{ 0x0AAA, 0x0AB0 },
	{ 0x0AB2, 0x0AB3 },
	{ 0x0AB5, 0x0AB9 },
	{ 0x0ABC, 0x0AC5 },
	{ 0x0AC7, 0x0AC9 },
	{ 0x0ACB, 0x0ACD },
	{ 0x0AD0, 0x0AD0 },
	{ 0x0AE0, 0x0AE3 },
	{ 0x0AE6, 0x0AF1 },
	{ 0x0AF9, 0x0AFF },
	{ 0x0B01, 0x0B03 },
	{ 0x0B05, 0x0B0C },
	{ 0x0B0F, 0x0B10 },
	{ 0x0B13, 0x0B28 },
	{ 0x0B2A, 0x0B30 },
	{ 0x0B32, 0x0B33 },
	{ 0x0B35, 0x0B39 },
	{ 0x0B3C, 0x0B44 },
	{ 0x0B47, 0x0B48 },
	{ 0x0B4B, 0x0B4D },
	{ 0x0B55, 0x0B57 },
	{ 0x0B5C, 0x0B5D },
	{ 0x0B5F, 0x0B63 },
	{ 0x0B66, 0x0B77 },
	{ 0x0B82, 0x0B83 },
	{ 0x0B85, 0x0B8A },
	{ 0x0B8E, 0x0B90 },
	{ 0x0B92, 0x0B95 },
	{ 0x0B99, 0x0B9A },
	{ 0x0B9C, 0x0B9C },
	{ 0x0B9E, 0x0B9F },
	{ 0x0BA3, 0x0BA4 },
	{ 0x0BA8, 0x0BAA },
	{ 0x0BAE, 0x0BB9 },
	{ 0x0BBE, 0x0BC2 },
	{ 0x0BC6, 0x0BC8 },
	{ 0x0BCA, 0x0BCD },
	{ 0x0BD0, 0x0BD0 },
	{ 0x0BD7, 0x0BD7 },
	{ 0x0BE6, 0x0BFA },
	{ 0x0C00, 0x0C0C },
	{ 0x0C0E, 0x0C10 },
	{ 0x0C12, 0x0C28 },
	{ 0x0C2A, 0x0C39 },
	{ 0x0C3D, 0x0C44 },
	{ 0x0C46, 0x0C48 },
	{ 0x0C4A, 0x0C4D },
	{ 0x0C55, 0x0C56 },
	{ 0x0C58, 0x0C5A },
	{ 0x0C60, 0x0C63 },
	{ 0x0C66, 0x0C6F },
	{ 0x0C77, 0x0C8C },
	{ 0x0C8E, 0x0C90 },
	{ 0x0C92, 0x0CA8 },
	{ 0x0CAA, 0x0CB3 },
	{ 0x0CB5, 0x0CB9 },
	{ 0x0CBC, 0x0CC4 },
	{ 0x0CC6, 0x0CC8 },
	{ 0x0CCA, 0x0CCD },
	{ 0x0CD5, 0x0CD6 },
	{ 0x0CDE, 0x0CDE },
	{ 0x0CE0, 0x0CE3 },
	{ 0x0CE6, 0x0CEF },
	{ 0x0CF1, 0x0CF2 },
	{ 0x0D00, 0x0D0C },
	{ 0x0D0E, 0x0D10 },
	{ 0x0D12, 0x0D44 },
	{ 0x0D46, 0x0D48 },
	{ 0x0D4A, 0x0D4F },
	{ 0x0D54, 0x0D63 },
	{ 0x0D66, 0x0D7F },
	{ 0x0D81, 0x0D83 },
	{ 0x0D85, 0x0D96 },
	{ 0x0D9A, 0x0DB1 },
	{ 0x0DB3, 0x0DBB },
	{ 0x0DBD, 0x0DBD },
	{ 0x0DC0, 0x0DC6 },
	{ 0x0DCA, 0x0DCA },
	{ 0x0DCF, 0x0DD4 },
	{ 0x0DD6, 0x0DD6 },
	{ 0x0DD8, 0x0DDF },
	{ 0x0DE6, 0x0DEF },
	{ 0x0DF2, 0x0DF4 },
	{ 0x0E01, 0x0E3A },
	{ 0x0E3F, 0x0E5B },
	{ 0x0E81, 0x0E82 },
	{ 0x0E84, 0x0E84 },
	{ 0x0E86, 0x0E8A },
	{ 0x0E8C, 0x0EA3 },
	{ 0x0EA5, 0x0EA5 },
	{ 0x0EA7, 0x0EBD },
	{ 0x0EC0, 0x0EC4 },
	{ 0x0EC6, 0x0EC6 },
	{ 0x0EC8, 0x0ECD },
	{ 0x0ED0, 0x0ED9 },
	{ 0x0EDC, 0x0EDF },
	{ 0x0F00, 0x0F47 },
	{ 0x0F49, 0x0F6C },
	{ 0x0F71, 0x0F97 },
	{ 0x0F99, 0x0FBC },
	{ 0x0FBE, 0x0FCC },
	{ 0x0FCE, 0x0FDA },
	{ 0x1000, 0x10C5 },
	{ 0x10C7, 0x10C7 },
	{ 0x10CD, 0x10CD },
	{ 0x10D0, 0x1248 },
	{ 0x124A, 0x124D },
	{ 0x1250, 0x1256 },
	{ 0x1258, 0x1258 },
	{ 0x125A, 0x125D },
	{ 0x1260, 0x1288 },
	{ 0x128A, 0x128D },
	{ 0x1290, 0x12B0 },
	{ 0x12B2, 0x12B5 },
	{ 0x12B8, 0x12BE },
	{ 0x12C0, 0x12C0 },
	{ 0x12C2, 0x12C5 },
	{ 0x12C8, 0x12D6 },
	{ 0x12D8, 0x1310 },
	{ 0x1312, 0x1315 },
	{ 0x1318, 0x135A },
	{ 0x135D, 0x137C },
	{ 0x1380, 0x1399 },
	{ 0x13A0, 0x13F5 },
	{ 0x13F8, 0x13FD },
	{ 0x1400, 0x169C },
	{ 0x16A0, 0x16F8 },
	{ 0x1700, 0x170C },
	{ 0x170E, 0x1714 },
	{ 0x1720, 0x1736 },
	{ 0x1740, 0x1753 },
	{ 0x1760, 0x176C },
	{ 0x176E, 0x1770 },
	{ 0x1772, 0x1773 },
	{ 0x1780, 0x17DD },
	{ 0x17E0, 0x17E9 },
	{ 0x17F0, 0x17F9 },
	{ 0x1800, 0x180E },
	{ 0x1810, 0x1819 },
	{ 0x1820, 0x1878 },
	{ 0x1880, 0x18AA },
	{ 0x18B0, 0x18F5 },
	{ 0x1900, 0x191E },
	{ 0x1920, 0x192B },
	{ 0x1930, 0x193B },
	{ 0x1940, 0x1940 },
	{ 0x1944, 0x196D },
	{ 0x1970, 0x1974 },
	{ 0x1980, 0x19AB },
	{ 0x19B0, 0x19C9 },
	{ 0x19D0, 0x19DA },
	{ 0x19DE, 0x1A1B },
	{ 0x1A1E, 0x1A5E },
	{ 0x1A60, 0x1A7C },
	{ 0x1A7F, 0x1A89 },
	{ 0x1A90, 0x1A99 },
	{ 0x1AA0, 0x1AAD },
	{ 0x1AB0, 0x1AC0 },
	{ 0x1B00, 0x1B4B },
	{ 0x1B50, 0x1B7C },
	{ 0x1B80, 0x1BF3 },
	{ 0x1BFC, 0x1C37 },
	{ 0x1C3B, 0x1C49 },
	{ 0x1C4D, 0x1C88 },
	{ 0x1C90, 0x1CBA },
	{ 0x1CBD, 0x1CC7 },
	{ 0x1CD0, 0x1CFA },
	{ 0x1D00, 0x1DF9 },
	{ 0x1DFB, 0x1F15 },
	{ 0x1F18, 0x1F1D },
	{ 0x1F20, 0x1F45 },
	{ 0x1F48, 0x1F4D },
	{ 0x1F50, 0x1F57 },
	{ 0x1F59, 0x1F59 },
	{ 0x1F5B, 0x1F5B },
	{ 0x1F5D, 0x1F5D },
	{ 0x1F5F, 0x1F7D },
	{ 0x1F80, 0x1FB4 },
	{ 0x1FB6, 0x1FC4 },
	{ 0x1FC6, 0x1FD3 },
	{ 0x1FD6, 0x1FDB },
	{ 0x1FDD, 0x1FEF },
	{ 0x1FF2, 0x1FF4 },
	{ 0x1FF6, 0x1FFE },
#ifdef __CYGWIN__
	/* WTF?! https://blogs.msdn.microsoft.com/oldnewthing/20070104-12/?p=28513 */
	{ 0x2000, 0x2021 },
	{ 0x2023, 0x2064 },
#else
	{ 0x2000, 0x2064 },
#endif
	{ 0x2066, 0x2071 },
	{ 0x2074, 0x208E },
	{ 0x2090, 0x209C },
	{ 0x20A0, 0x20BF },
	{ 0x20D0, 0x20F0 },
	{ 0x2100, 0x218B },
	{ 0x2190, 0x2426 },
	{ 0x2440, 0x244A },
	{ 0x2460, 0x2B73 },
	{ 0x2B76, 0x2B95 },
	{ 0x2B97, 0x2C2E },
	{ 0x2C30, 0x2C5E },
	{ 0x2C60, 0x2CF3 },
	{ 0x2CF9, 0x2D25 },
	{ 0x2D27, 0x2D27 },
	{ 0x2D2D, 0x2D2D },
	{ 0x2D30, 0x2D67 },
	{ 0x2D6F, 0x2D70 },
	{ 0x2D7F, 0x2D96 },
	{ 0x2DA0, 0x2DA6 },
	{ 0x2DA8, 0x2DAE },
	{ 0x2DB0, 0x2DB6 },
	{ 0x2DB8, 0x2DBE },
	{ 0x2DC0, 0x2DC6 },
	{ 0x2DC8, 0x2DCE },
	{ 0x2DD0, 0x2DD6 },
	{ 0x2DD8, 0x2DDE },
	{ 0x2DE0, 0x2E52 },
	{ 0x2E80, 0x2E99 },
	{ 0x2E9B, 0x2EF3 },
	{ 0x2F00, 0x2FD5 },
	{ 0x2FF0, 0x2FFB },
	{ 0x3000, 0x303F },
	{ 0x3041, 0x3096 },
	{ 0x3099, 0x30FF },
	{ 0x3105, 0x312F },
	{ 0x3131, 0x318E },
	{ 0x3190, 0x31E3 },
	{ 0x31F0, 0x321E },
	{ 0x3220, 0x9FFC },
	{ 0xA000, 0xA48C },
	{ 0xA490, 0xA4C6 },
	{ 0xA4D0, 0xA62B },
	{ 0xA640, 0xA6F7 },
	{ 0xA700, 0xA7BF },
	{ 0xA7C2, 0xA7CA },
	{ 0xA7F5, 0xA82C },
	{ 0xA830, 0xA839 },
	{ 0xA840, 0xA877 },
	{ 0xA880, 0xA8C5 },
	{ 0xA8CE, 0xA8D9 },
	{ 0xA8E0, 0xA953 },
	{ 0xA95F, 0xA97C },
	{ 0xA980, 0xA9CD },
	{ 0xA9CF, 0xA9D9 },
	{ 0xA9DE, 0xA9FE },
	{ 0xAA00, 0xAA36 },
	{ 0xAA40, 0xAA4D },
	{ 0xAA50, 0xAA59 },
	{ 0xAA5C, 0xAAC2 },
	{ 0xAADB, 0xAAF6 },
	{ 0xAB01, 0xAB06 },
	{ 0xAB09, 0xAB0E },
	{ 0xAB11, 0xAB16 },
	{ 0xAB20, 0xAB26 },
	{ 0xAB28, 0xAB2E },
	{ 0xAB30, 0xAB6B },
	{ 0xAB70, 0xABED },
	{ 0xABF0, 0xABF9 },
	{ 0xAC00, 0xD7A3 },
	{ 0xD7B0, 0xD7C6 },
	{ 0xD7CB, 0xD7FB },
	{ 0xE000, 0xFA6D },
	{ 0xFA70, 0xFAD9 },
	{ 0xFB00, 0xFB06 },
	{ 0xFB13, 0xFB17 },
	{ 0xFB1D, 0xFB36 },
	{ 0xFB38, 0xFB3C },
	{ 0xFB3E, 0xFB3E },
	{ 0xFB40, 0xFB41 },
	{ 0xFB43, 0xFB44 },
	{ 0xFB46, 0xFBC1 },
	{ 0xFBD3, 0xFD3F },
	{ 0xFD50, 0xFD8F },
	{ 0xFD92, 0xFDC7 },
	{ 0xFDF0, 0xFDFD },
	{ 0xFE00, 0xFE19 },
	{ 0xFE20, 0xFE52 },
	{ 0xFE54, 0xFE66 },
	{ 0xFE68, 0xFE6B },
	{ 0xFE70, 0xFE74 },
	{ 0xFE76, 0xFEFC },
	{ 0xFEFF, 0xFEFF },
	{ 0xFF01, 0xFFBE },
	{ 0xFFC2, 0xFFC7 },
	{ 0xFFCA, 0xFFCF },
	{ 0xFFD2, 0xFFD7 },
	{ 0xFFDA, 0xFFDC },
	{ 0xFFE0, 0xFFE6 },
	{ 0xFFE8, 0xFFEE },
	{ 0xFFF9, 0xFFFD },
	{ 0x10000, 0x1000B },
	{ 0x1000D, 0x10026 },
	{ 0x10028, 0x1003A },
	{ 0x1003C, 0x1003D },
	{ 0x1003F, 0x1004D },
	{ 0x10050, 0x1005D },
	{ 0x10080, 0x100FA },
	{ 0x10100, 0x10102 },
	{ 0x10107, 0x10133 },
	{ 0x10137, 0x1018E },
	{ 0x10190, 0x1019C },
	{ 0x101A0, 0x101A0 },
	{ 0x101D0, 0x101FD },
	{ 0x10280, 0x1029C },
	{ 0x102A0, 0x102D0 },
	{ 0x102E0, 0x102FB },
	{ 0x10300, 0x10323 },
	{ 0x1032D, 0x1034A },
	{ 0x10350, 0x1037A },
	{ 0x10380, 0x1039D },
	{ 0x1039F, 0x103C3 },
	{ 0x103C8, 0x103D5 },
	{ 0x10400, 0x1049D },
	{ 0x104A0, 0x104A9 },
	{ 0x104B0, 0x104D3 },
	{ 0x104D8, 0x104FB },
	{ 0x10500, 0x10527 },
	{ 0x10530, 0x10563 },
	{ 0x1056F, 0x1056F },
	{ 0x10600, 0x10736 },
	{ 0x10740, 0x10755 },
	{ 0x10760, 0x10767 },
	{ 0x10800, 0x10805 },
	{ 0x10808, 0x10808 },
	{ 0x1080A, 0x10835 },
	{ 0x10837, 0x10838 },
	{ 0x1083C, 0x1083C },
	{ 0x1083F, 0x10855 },
	{ 0x10857, 0x1089E },
	{ 0x108A7, 0x108AF },
	{ 0x108E0, 0x108F2 },
	{ 0x108F4, 0x108F5 },
	{ 0x108FB, 0x1091B },
	{ 0x1091F, 0x10939 },
	{ 0x1093F, 0x1093F },
	{ 0x10980, 0x109B7 },
	{ 0x109BC, 0x109CF },
	{ 0x109D2, 0x10A03 },
	{ 0x10A05, 0x10A06 },
	{ 0x10A0C, 0x10A13 },
	{ 0x10A15, 0x10A17 },
	{ 0x10A19, 0x10A35 },
	{ 0x10A38, 0x10A3A },
	{ 0x10A3F, 0x10A48 },
	{ 0x10A50, 0x10A58 },
	{ 0x10A60, 0x10A9F },
	{ 0x10AC0, 0x10AE6 },
	{ 0x10AEB, 0x10AF6 },
	{ 0x10B00, 0x10B35 },
	{ 0x10B39, 0x10B55 },
	{ 0x10B58, 0x10B72 },
	{ 0x10B78, 0x10B91 },
	{ 0x10B99, 0x10B9C },
	{ 0x10BA9, 0x10BAF },
	{ 0x10C00, 0x10C48 },
	{ 0x10C80, 0x10CB2 },
	{ 0x10CC0, 0x10CF2 },
	{ 0x10CFA, 0x10D27 },
	{ 0x10D30, 0x10D39 },
	{ 0x10E60, 0x10E7E },
	{ 0x10E80, 0x10EA9 },
	{ 0x10EAB, 0x10EAD },
	{ 0x10EB0, 0x10EB1 },
	{ 0x10F00, 0x10F27 },
	{ 0x10F30, 0x10F59 },
	{ 0x10FB0, 0x10FCB },
	{ 0x10FE0, 0x10FF6 },
	{ 0x11000, 0x1104D },
	{ 0x11052, 0x1106F },
	{ 0x1107F, 0x110C1 },
	{ 0x110CD, 0x110CD },
	{ 0x110D0, 0x110E8 },
	{ 0x110F0, 0x110F9 },
	{ 0x11100, 0x11134 },
	{ 0x11136, 0x11147 },
	{ 0x11150, 0x11176 },
	{ 0x11180, 0x111DF },
	{ 0x111E1, 0x111F4 },
	{ 0x11200, 0x11211 },
	{ 0x11213, 0x1123E },
	{ 0x11280, 0x11286 },
	{ 0x11288, 0x11288 },
	{ 0x1128A, 0x1128D },
	{ 0x1128F, 0x1129D },
	{ 0x1129F, 0x112A9 },
	{ 0x112B0, 0x112EA },
	{ 0x112F0, 0x112F9 },
	{ 0x11300, 0x11303 },
	{ 0x11305, 0x1130C },
	{ 0x1130F, 0x11310 },
	{ 0x11313, 0x11328 },
	{ 0x1132A, 0x11330 },
	{ 0x11332, 0x11333 },
	{ 0x11335, 0x11339 },
	{ 0x1133B, 0x11344 },
	{ 0x11347, 0x11348 },
	{ 0x1134B, 0x1134D },
	{ 0x11350, 0x11350 },
	{ 0x11357, 0x11357 },
	{ 0x1135D, 0x11363 },
	{ 0x11366, 0x1136C },
	{ 0x11370, 0x11374 },
	{ 0x11400, 0x1145B },
	{ 0x1145D, 0x11461 },
	{ 0x11480, 0x114C7 },
	{ 0x114D0, 0x114D9 },
	{ 0x11580, 0x115B5 },
	{ 0x115B8, 0x115DD },
	{ 0x11600, 0x11644 },
	{ 0x11650, 0x11659 },
	{ 0x11660, 0x1166C },
	{ 0x11680, 0x116B8 },
	{ 0x116C0, 0x116C9 },
	{ 0x11700, 0x1171A },
	{ 0x1171D, 0x1172B },
	{ 0x11730, 0x1173F },
	{ 0x11800, 0x1183B },
	{ 0x118A0, 0x118F2 },
	{ 0x118FF, 0x11906 },
	{ 0x11909, 0x11909 },
	{ 0x1190C, 0x11913 },
	{ 0x11915, 0x11916 },
	{ 0x11918, 0x11935 },
	{ 0x11937, 0x11938 },
	{ 0x1193B, 0x11946 },
	{ 0x11950, 0x11959 },
	{ 0x119A0, 0x119A7 },
	{ 0x119AA, 0x119D7 },
	{ 0x119DA, 0x119E4 },
	{ 0x11A00, 0x11A47 },
	{ 0x11A50, 0x11AA2 },
	{ 0x11AC0, 0x11AF8 },
	{ 0x11C00, 0x11C08 },
	{ 0x11C0A, 0x11C36 },
	{ 0x11C38, 0x11C45 },
	{ 0x11C50, 0x11C6C },
	{ 0x11C70, 0x11C8F },
	{ 0x11C92, 0x11CA7 },
	{ 0x11CA9, 0x11CB6 },
	{ 0x11D00, 0x11D06 },
	{ 0x11D08, 0x11D09 },
	{ 0x11D0B, 0x11D36 },
	{ 0x11D3A, 0x11D3A },
	{ 0x11D3C, 0x11D3D },
	{ 0x11D3F, 0x11D47 },
	{ 0x11D50, 0x11D59 },
	{ 0x11D60, 0x11D65 },
	{ 0x11D67, 0x11D68 },
	{ 0x11D6A, 0x11D8E },
	{ 0x11D90, 0x11D91 },
	{ 0x11D93, 0x11D98 },
	{ 0x11DA0, 0x11DA9 },
	{ 0x11EE0, 0x11EF8 },
	{ 0x11FB0, 0x11FB0 },
	{ 0x11FC0, 0x11FF1 },
	{ 0x11FFF, 0x12399 },
	{ 0x12400, 0x1246E },
	{ 0x12470, 0x12474 },
	{ 0x12480, 0x12543 },
	{ 0x13000, 0x1342E },
	{ 0x13430, 0x13438 },
	{ 0x14400, 0x14646 },
	{ 0x16800, 0x16A38 },
	{ 0x16A40, 0x16A5E },
	{ 0x16A60, 0x16A69 },
	{ 0x16A6E, 0x16A6F },
	{ 0x16AD0, 0x16AED },
	{ 0x16AF0, 0x16AF5 },
	{ 0x16B00, 0x16B45 },
	{ 0x16B50, 0x16B59 },
	{ 0x16B5B, 0x16B61 },
	{ 0x16B63, 0x16B77 },
	{ 0x16B7D, 0x16B8F },
	{ 0x16E40, 0x16E9A },
	{ 0x16F00, 0x16F4A },
	{ 0x16F4F, 0x16F87 },
	{ 0x16F8F, 0x16F9F },
	{ 0x16FE0, 0x16FE4 },
	{ 0x16FF0, 0x16FF1 },
	{ 0x17000, 0x187F7 },
	{ 0x18800, 0x18CD5 },
	{ 0x18D00, 0x18D08 },
	{ 0x1B000, 0x1B11E },
	{ 0x1B150, 0x1B152 },
	{ 0x1B164, 0x1B167 },
	{ 0x1B170, 0x1B2FB },
	{ 0x1BC00, 0x1BC6A },
	{ 0x1BC70, 0x1BC7C },
	{ 0x1BC80, 0x1BC88 },
	{ 0x1BC90, 0x1BC99 },
	{ 0x1BC9C, 0x1BCA3 },
	{ 0x1D000, 0x1D0F5 },
	{ 0x1D100, 0x1D126 },
	{ 0x1D129, 0x1D1E8 },
	{ 0x1D200, 0x1D245 },
	{ 0x1D2E0, 0x1D2F3 },
	{ 0x1D300, 0x1D356 },
	{ 0x1D360, 0x1D378 },
	{ 0x1D400, 0x1D454 },
	{ 0x1D456, 0x1D49C },
	{ 0x1D49E, 0x1D49F },
	{ 0x1D4A2, 0x1D4A2 },
	{ 0x1D4A5, 0x1D4A6 },
	{ 0x1D4A9, 0x1D4AC },
	{ 0x1D4AE, 0x1D4B9 },
	{ 0x1D4BB, 0x1D4BB },
	{ 0x1D4BD, 0x1D4C3 },
	{ 0x1D4C5, 0x1D505 },
	{ 0x1D507, 0x1D50A },
	{ 0x1D50D, 0x1D514 },
	{ 0x1D516, 0x1D51C },
	{ 0x1D51E, 0x1D539 },
	{ 0x1D53B, 0x1D53E },
	{ 0x1D540, 0x1D544 },
	{ 0x1D546, 0x1D546 },
	{ 0x1D54A, 0x1D550 },
	{ 0x1D552, 0x1D6A5 },
	{ 0x1D6A8, 0x1D7CB },
	{ 0x1D7CE, 0x1DA8B },
	{ 0x1DA9B, 0x1DA9F },
	{ 0x1DAA1, 0x1DAAF },
	{ 0x1E000, 0x1E006 },
	{ 0x1E008, 0x1E018 },
	{ 0x1E01B, 0x1E021 },
	{ 0x1E023, 0x1E024 },
	{ 0x1E026, 0x1E02A },
	{ 0x1E100, 0x1E12C },
	{ 0x1E130, 0x1E13D },
	{ 0x1E140, 0x1E149 },
	{ 0x1E14E, 0x1E14F },
	{ 0x1E2C0, 0x1E2F9 },
	{ 0x1E2FF, 0x1E2FF },
	{ 0x1E800, 0x1E8C4 },
	{ 0x1E8C7, 0x1E8D6 },
	{ 0x1E900, 0x1E94B },
	{ 0x1E950, 0x1E959 },
	{ 0x1E95E, 0x1E95F },
	{ 0x1EC71, 0x1ECB4 },
	{ 0x1ED01, 0x1ED3D },
	{ 0x1EE00, 0x1EE03 },
	{ 0x1EE05, 0x1EE1F },
	{ 0x1EE21, 0x1EE22 },
	{ 0x1EE24, 0x1EE24 },
	{ 0x1EE27, 0x1EE27 },
	{ 0x1EE29, 0x1EE32 },
	{ 0x1EE34, 0x1EE37 },
	{ 0x1EE39, 0x1EE39 },
	{ 0x1EE3B, 0x1EE3B },
	{ 0x1EE42, 0x1EE42 },
	{ 0x1EE47, 0x1EE47 },
	{ 0x1EE49, 0x1EE49 },
	{ 0x1EE4B, 0x1EE4B },
	{ 0x1EE4D, 0x1EE4F },
	{ 0x1EE51, 0x1EE52 },
	{ 0x1EE54, 0x1EE54 },
	{ 0x1EE57, 0x1EE57 },
	{ 0x1EE59, 0x1EE59 },
	{ 0x1EE5B, 0x1EE5B },
	{ 0x1EE5D, 0x1EE5D },
	{ 0x1EE5F, 0x1EE5F },
	{ 0x1EE61, 0x1EE62 },
	{ 0x1EE64, 0x1EE64 },
	{ 0x1EE67, 0x1EE6A },
	{ 0x1EE6C, 0x1EE72 },
	{ 0x1EE74, 0x1EE77 },
	{ 0x1EE79, 0x1EE7C },
	{ 0x1EE7E, 0x1EE7E },
	{ 0x1EE80, 0x1EE89 },
	{ 0x1EE8B, 0x1EE9B },
	{ 0x1EEA1, 0x1EEA3 },
	{ 0x1EEA5, 0x1EEA9 },
	{ 0x1EEAB, 0x1EEBB },
	{ 0x1EEF0, 0x1EEF1 },
	{ 0x1F000, 0x1F02B },
	{ 0x1F030, 0x1F093 },
	{ 0x1F0A0, 0x1F0AE },
	{ 0x1F0B1, 0x1F0BF },
	{ 0x1F0C1, 0x1F0CF },
	{ 0x1F0D1, 0x1F0F5 },
	{ 0x1F100, 0x1F1AD },
	{ 0x1F1E6, 0x1F202 },
	{ 0x1F210, 0x1F23B },
	{ 0x1F240, 0x1F248 },
	{ 0x1F250, 0x1F251 },
	{ 0x1F260, 0x1F265 },
	{ 0x1F300, 0x1F6D7 },
	{ 0x1F6E0, 0x1F6EC },
	{ 0x1F6F0, 0x1F6FC },
	{ 0x1F700, 0x1F773 },
	{ 0x1F780, 0x1F7D8 },
	{ 0x1F7E0, 0x1F7EB },
	{ 0x1F800, 0x1F80B },
	{ 0x1F810, 0x1F847 },
	{ 0x1F850, 0x1F859 },
	{ 0x1F860, 0x1F887 },
	{ 0x1F890, 0x1F8AD },
	{ 0x1F8B0, 0x1F8B1 },
	{ 0x1F900, 0x1F978 },
	{ 0x1F97A, 0x1F9CB },
	{ 0x1F9CD, 0x1FA53 },
	{ 0x1FA60, 0x1FA6D },
	{ 0x1FA70, 0x1FA74 },
	{ 0x1FA78, 0x1FA7A },
	{ 0x1FA80, 0x1FA86 },
	{ 0x1FA90, 0x1FAA8 },
	{ 0x1FAB0, 0x1FAB6 },
	{ 0x1FAC0, 0x1FAC2 },
	{ 0x1FAD0, 0x1FAD6 },
	{ 0x1FB00, 0x1FB92 },
	{ 0x1FB94, 0x1FBCA },
	{ 0x1FBF0, 0x1FBF9 },
	{ 0x20000, 0x2A6DD },
	{ 0x2A700, 0x2B734 },
	{ 0x2B740, 0x2B81D },
	{ 0x2B820, 0x2CEA1 },
	{ 0x2CEB0, 0x2EBE0 },
	{ 0x2F800, 0x2FA1D },
	{ 0x30000, 0x3134A },
	{ 0xE0001, 0xE0001 },
	{ 0xE0020, 0xE007F },
	{ 0xE0100, 0xE01EF },
	{ 0xF0000, 0xFFFFD },
	{ 0x100000, 0x10FFFD }
};

MAKE_ISW(print)

#ifdef TEST_I18N
static const struct mb_ucsrange data_wctype_xdigit[] = {
	{ 0x0030, 0x0039 },
	{ 0x0041, 0x0046 },
	{ 0x0061, 0x0066 }
};

MAKE_ISW(xdigit)

static const struct mb_ucsrange data_wctype_blank[] = {
	{ 0x0009, 0x0009 },
	{ 0x0020, 0x0020 },
	{ 0x1680, 0x1680 },
	{ 0x2000, 0x2006 },
	{ 0x2008, 0x200B },
	{ 0x205F, 0x205F },
	{ 0x3000, 0x3000 }
};

MAKE_ISW(blank)
#endif

/* Conversion functions */

static const struct mb_ucsrange data_wcrange_toupper[] = {
	{ 0x0061, 0x007A },
	{ 0x00B5, 0x00B5 },
	{ 0x00E0, 0x00F6 },
	{ 0x00F8, 0x00FE },
	{ 0x00FF, 0x00FF },
	{ 0x0101, 0x0101 },
	{ 0x0103, 0x0103 },
	{ 0x0105, 0x0105 },
	{ 0x0107, 0x0107 },
	{ 0x0109, 0x0109 },
	{ 0x010B, 0x010B },
	{ 0x010D, 0x010D },
	{ 0x010F, 0x010F },
	{ 0x0111, 0x0111 },
	{ 0x0113, 0x0113 },
	{ 0x0115, 0x0115 },
	{ 0x0117, 0x0117 },
	{ 0x0119, 0x0119 },
	{ 0x011B, 0x011B },
	{ 0x011D, 0x011D },
	{ 0x011F, 0x011F },
	{ 0x0121, 0x0121 },
	{ 0x0123, 0x0123 },
	{ 0x0125, 0x0125 },
	{ 0x0127, 0x0127 },
	{ 0x0129, 0x0129 },
	{ 0x012B, 0x012B },
	{ 0x012D, 0x012D },
	{ 0x012F, 0x012F },
	{ 0x0131, 0x0131 },
	{ 0x0133, 0x0133 },
	{ 0x0135, 0x0135 },
	{ 0x0137, 0x0137 },
	{ 0x013A, 0x013A },
	{ 0x013C, 0x013C },
	{ 0x013E, 0x013E },
	{ 0x0140, 0x0140 },
	{ 0x0142, 0x0142 },
	{ 0x0144, 0x0144 },
	{ 0x0146, 0x0146 },
	{ 0x0148, 0x0148 },
	{ 0x014B, 0x014B },
	{ 0x014D, 0x014D },
	{ 0x014F, 0x014F },
	{ 0x0151, 0x0151 },
	{ 0x0153, 0x0153 },
	{ 0x0155, 0x0155 },
	{ 0x0157, 0x0157 },
	{ 0x0159, 0x0159 },
	{ 0x015B, 0x015B },
	{ 0x015D, 0x015D },
	{ 0x015F, 0x015F },
	{ 0x0161, 0x0161 },
	{ 0x0163, 0x0163 },
	{ 0x0165, 0x0165 },
	{ 0x0167, 0x0167 },
	{ 0x0169, 0x0169 },
	{ 0x016B, 0x016B },
	{ 0x016D, 0x016D },
	{ 0x016F, 0x016F },
	{ 0x0171, 0x0171 },
	{ 0x0173, 0x0173 },
	{ 0x0175, 0x0175 },
	{ 0x0177, 0x0177 },
	{ 0x017A, 0x017A },
	{ 0x017C, 0x017C },
	{ 0x017E, 0x017E },
	{ 0x017F, 0x017F },
	{ 0x0180, 0x0180 },
	{ 0x0183, 0x0183 },
	{ 0x0185, 0x0185 },
	{ 0x0188, 0x0188 },
	{ 0x018C, 0x018C },
	{ 0x0192, 0x0192 },
	{ 0x0195, 0x0195 },
	{ 0x0199, 0x0199 },
	{ 0x019A, 0x019A },
	{ 0x019E, 0x019E },
	{ 0x01A1, 0x01A1 },
	{ 0x01A3, 0x01A3 },
	{ 0x01A5, 0x01A5 },
	{ 0x01A8, 0x01A8 },
	{ 0x01AD, 0x01AD },
	{ 0x01B0, 0x01B0 },
	{ 0x01B4, 0x01B4 },
	{ 0x01B6, 0x01B6 },
	{ 0x01B9, 0x01B9 },
	{ 0x01BD, 0x01BD },
	{ 0x01BF, 0x01BF },
	{ 0x01C5, 0x01C5 },
	{ 0x01C6, 0x01C6 },
	{ 0x01C8, 0x01C8 },
	{ 0x01C9, 0x01C9 },
	{ 0x01CB, 0x01CB },
	{ 0x01CC, 0x01CC },
	{ 0x01CE, 0x01CE },
	{ 0x01D0, 0x01D0 },
	{ 0x01D2, 0x01D2 },
	{ 0x01D4, 0x01D4 },
	{ 0x01D6, 0x01D6 },
	{ 0x01D8, 0x01D8 },
	{ 0x01DA, 0x01DA },
	{ 0x01DC, 0x01DC },
	{ 0x01DD, 0x01DD },
	{ 0x01DF, 0x01DF },
	{ 0x01E1, 0x01E1 },
	{ 0x01E3, 0x01E3 },
	{ 0x01E5, 0x01E5 },
	{ 0x01E7, 0x01E7 },
	{ 0x01E9, 0x01E9 },
	{ 0x01EB, 0x01EB },
	{ 0x01ED, 0x01ED },
	{ 0x01EF, 0x01EF },
	{ 0x01F2, 0x01F2 },
	{ 0x01F3, 0x01F3 },
	{ 0x01F5, 0x01F5 },
	{ 0x01F9, 0x01F9 },
	{ 0x01FB, 0x01FB },
	{ 0x01FD, 0x01FD },
	{ 0x01FF, 0x01FF },
	{ 0x0201, 0x0201 },
	{ 0x0203, 0x0203 },
	{ 0x0205, 0x0205 },
	{ 0x0207, 0x0207 },
	{ 0x0209, 0x0209 },
	{ 0x020B, 0x020B },
	{ 0x020D, 0x020D },
	{ 0x020F, 0x020F },
	{ 0x0211, 0x0211 },
	{ 0x0213, 0x0213 },
	{ 0x0215, 0x0215 },
	{ 0x0217, 0x0217 },
	{ 0x0219, 0x0219 },
	{ 0x021B, 0x021B },
	{ 0x021D, 0x021D },
	{ 0x021F, 0x021F },
	{ 0x0223, 0x0223 },
	{ 0x0225, 0x0225 },
	{ 0x0227, 0x0227 },
	{ 0x0229, 0x0229 },
	{ 0x022B, 0x022B },
	{ 0x022D, 0x022D },
	{ 0x022F, 0x022F },
	{ 0x0231, 0x0231 },
	{ 0x0233, 0x0233 },
	{ 0x023C, 0x023C },
	{ 0x023F, 0x0240 },
	{ 0x0242, 0x0242 },
	{ 0x0247, 0x0247 },
	{ 0x0249, 0x0249 },
	{ 0x024B, 0x024B },
	{ 0x024D, 0x024D },
	{ 0x024F, 0x024F },
	{ 0x0250, 0x0250 },
	{ 0x0251, 0x0251 },
	{ 0x0252, 0x0252 },
	{ 0x0253, 0x0253 },
	{ 0x0254, 0x0254 },
	{ 0x0256, 0x0257 },
	{ 0x0259, 0x0259 },
	{ 0x025B, 0x025B },
	{ 0x025C, 0x025C },
	{ 0x0260, 0x0260 },
	{ 0x0261, 0x0261 },
	{ 0x0263, 0x0263 },
	{ 0x0265, 0x0265 },
	{ 0x0266, 0x0266 },
	{ 0x0268, 0x0268 },
	{ 0x0269, 0x0269 },
	{ 0x026A, 0x026A },
	{ 0x026B, 0x026B },
	{ 0x026C, 0x026C },
	{ 0x026F, 0x026F },
	{ 0x0271, 0x0271 },
	{ 0x0272, 0x0272 },
	{ 0x0275, 0x0275 },
	{ 0x027D, 0x027D },
	{ 0x0280, 0x0280 },
	{ 0x0282, 0x0282 },
	{ 0x0283, 0x0283 },
	{ 0x0287, 0x0287 },
	{ 0x0288, 0x0288 },
	{ 0x0289, 0x0289 },
	{ 0x028A, 0x028B },
	{ 0x028C, 0x028C },
	{ 0x0292, 0x0292 },
	{ 0x029D, 0x029D },
	{ 0x029E, 0x029E },
	{ 0x0345, 0x0345 },
	{ 0x0371, 0x0371 },
	{ 0x0373, 0x0373 },
	{ 0x0377, 0x0377 },
	{ 0x037B, 0x037D },
	{ 0x03AC, 0x03AC },
	{ 0x03AD, 0x03AF },
	{ 0x03B1, 0x03C1 },
	{ 0x03C2, 0x03C2 },
	{ 0x03C3, 0x03CB },
	{ 0x03CC, 0x03CC },
	{ 0x03CD, 0x03CE },
	{ 0x03D0, 0x03D0 },
	{ 0x03D1, 0x03D1 },
	{ 0x03D5, 0x03D5 },
	{ 0x03D6, 0x03D6 },
	{ 0x03D7, 0x03D7 },
	{ 0x03D9, 0x03D9 },
	{ 0x03DB, 0x03DB },
	{ 0x03DD, 0x03DD },
	{ 0x03DF, 0x03DF },
	{ 0x03E1, 0x03E1 },
	{ 0x03E3, 0x03E3 },
	{ 0x03E5, 0x03E5 },
	{ 0x03E7, 0x03E7 },
	{ 0x03E9, 0x03E9 },
	{ 0x03EB, 0x03EB },
	{ 0x03ED, 0x03ED },
	{ 0x03EF, 0x03EF },
	{ 0x03F0, 0x03F0 },
	{ 0x03F1, 0x03F1 },
	{ 0x03F2, 0x03F2 },
	{ 0x03F3, 0x03F3 },
	{ 0x03F5, 0x03F5 },
	{ 0x03F8, 0x03F8 },
	{ 0x03FB, 0x03FB },
	{ 0x0430, 0x044F },
	{ 0x0450, 0x045F },
	{ 0x0461, 0x0461 },
	{ 0x0463, 0x0463 },
	{ 0x0465, 0x0465 },
	{ 0x0467, 0x0467 },
	{ 0x0469, 0x0469 },
	{ 0x046B, 0x046B },
	{ 0x046D, 0x046D },
	{ 0x046F, 0x046F },
	{ 0x0471, 0x0471 },
	{ 0x0473, 0x0473 },
	{ 0x0475, 0x0475 },
	{ 0x0477, 0x0477 },
	{ 0x0479, 0x0479 },
	{ 0x047B, 0x047B },
	{ 0x047D, 0x047D },
	{ 0x047F, 0x047F },
	{ 0x0481, 0x0481 },
	{ 0x048B, 0x048B },
	{ 0x048D, 0x048D },
	{ 0x048F, 0x048F },
	{ 0x0491, 0x0491 },
	{ 0x0493, 0x0493 },
	{ 0x0495, 0x0495 },
	{ 0x0497, 0x0497 },
	{ 0x0499, 0x0499 },
	{ 0x049B, 0x049B },
	{ 0x049D, 0x049D },
	{ 0x049F, 0x049F },
	{ 0x04A1, 0x04A1 },
	{ 0x04A3, 0x04A3 },
	{ 0x04A5, 0x04A5 },
	{ 0x04A7, 0x04A7 },
	{ 0x04A9, 0x04A9 },
	{ 0x04AB, 0x04AB },
	{ 0x04AD, 0x04AD },
	{ 0x04AF, 0x04AF },
	{ 0x04B1, 0x04B1 },
	{ 0x04B3, 0x04B3 },
	{ 0x04B5, 0x04B5 },
	{ 0x04B7, 0x04B7 },
	{ 0x04B9, 0x04B9 },
	{ 0x04BB, 0x04BB },
	{ 0x04BD, 0x04BD },
	{ 0x04BF, 0x04BF },
	{ 0x04C2, 0x04C2 },
	{ 0x04C4, 0x04C4 },
	{ 0x04C6, 0x04C6 },
	{ 0x04C8, 0x04C8 },
	{ 0x04CA, 0x04CA },
	{ 0x04CC, 0x04CC },
	{ 0x04CE, 0x04CE },
	{ 0x04CF, 0x04CF },
	{ 0x04D1, 0x04D1 },
	{ 0x04D3, 0x04D3 },
	{ 0x04D5, 0x04D5 },
	{ 0x04D7, 0x04D7 },
	{ 0x04D9, 0x04D9 },
	{ 0x04DB, 0x04DB },
	{ 0x04DD, 0x04DD },
	{ 0x04DF, 0x04DF },
	{ 0x04E1, 0x04E1 },
	{ 0x04E3, 0x04E3 },
	{ 0x04E5, 0x04E5 },
	{ 0x04E7, 0x04E7 },
	{ 0x04E9, 0x04E9 },
	{ 0x04EB, 0x04EB },
	{ 0x04ED, 0x04ED },
	{ 0x04EF, 0x04EF },
	{ 0x04F1, 0x04F1 },
	{ 0x04F3, 0x04F3 },
	{ 0x04F5, 0x04F5 },
	{ 0x04F7, 0x04F7 },
	{ 0x04F9, 0x04F9 },
	{ 0x04FB, 0x04FB },
	{ 0x04FD, 0x04FD },
	{ 0x04FF, 0x04FF },
	{ 0x0501, 0x0501 },
	{ 0x0503, 0x0503 },
	{ 0x0505, 0x0505 },
	{ 0x0507, 0x0507 },
	{ 0x0509, 0x0509 },
	{ 0x050B, 0x050B },
	{ 0x050D, 0x050D },
	{ 0x050F, 0x050F },
	{ 0x0511, 0x0511 },
	{ 0x0513, 0x0513 },
	{ 0x0515, 0x0515 },
	{ 0x0517, 0x0517 },
	{ 0x0519, 0x0519 },
	{ 0x051B, 0x051B },
	{ 0x051D, 0x051D },
	{ 0x051F, 0x051F },
	{ 0x0521, 0x0521 },
	{ 0x0523, 0x0523 },
	{ 0x0525, 0x0525 },
	{ 0x0527, 0x0527 },
	{ 0x0529, 0x0529 },
	{ 0x052B, 0x052B },
	{ 0x052D, 0x052D },
	{ 0x052F, 0x052F },
	{ 0x0561, 0x0586 },
	{ 0x10D0, 0x10FA },
	{ 0x10FD, 0x10FF },
	{ 0x13F8, 0x13FD },
	{ 0x1C80, 0x1C80 },
	{ 0x1C81, 0x1C81 },
	{ 0x1C82, 0x1C82 },
	{ 0x1C83, 0x1C84 },
	{ 0x1C85, 0x1C85 },
	{ 0x1C86, 0x1C86 },
	{ 0x1C87, 0x1C87 },
	{ 0x1C88, 0x1C88 },
	{ 0x1D79, 0x1D79 },
	{ 0x1D7D, 0x1D7D },
	{ 0x1D8E, 0x1D8E },
	{ 0x1E01, 0x1E01 },
	{ 0x1E03, 0x1E03 },
	{ 0x1E05, 0x1E05 },
	{ 0x1E07, 0x1E07 },
	{ 0x1E09, 0x1E09 },
	{ 0x1E0B, 0x1E0B },
	{ 0x1E0D, 0x1E0D },
	{ 0x1E0F, 0x1E0F },
	{ 0x1E11, 0x1E11 },
	{ 0x1E13, 0x1E13 },
	{ 0x1E15, 0x1E15 },
	{ 0x1E17, 0x1E17 },
	{ 0x1E19, 0x1E19 },
	{ 0x1E1B, 0x1E1B },
	{ 0x1E1D, 0x1E1D },
	{ 0x1E1F, 0x1E1F },
	{ 0x1E21, 0x1E21 },
	{ 0x1E23, 0x1E23 },
	{ 0x1E25, 0x1E25 },
	{ 0x1E27, 0x1E27 },
	{ 0x1E29, 0x1E29 },
	{ 0x1E2B, 0x1E2B },
	{ 0x1E2D, 0x1E2D },
	{ 0x1E2F, 0x1E2F },
	{ 0x1E31, 0x1E31 },
	{ 0x1E33, 0x1E33 },
	{ 0x1E35, 0x1E35 },
	{ 0x1E37, 0x1E37 },
	{ 0x1E39, 0x1E39 },
	{ 0x1E3B, 0x1E3B },
	{ 0x1E3D, 0x1E3D },
	{ 0x1E3F, 0x1E3F },
	{ 0x1E41, 0x1E41 },
	{ 0x1E43, 0x1E43 },
	{ 0x1E45, 0x1E45 },
	{ 0x1E47, 0x1E47 },
	{ 0x1E49, 0x1E49 },
	{ 0x1E4B, 0x1E4B },
	{ 0x1E4D, 0x1E4D },
	{ 0x1E4F, 0x1E4F },
	{ 0x1E51, 0x1E51 },
	{ 0x1E53, 0x1E53 },
	{ 0x1E55, 0x1E55 },
	{ 0x1E57, 0x1E57 },
	{ 0x1E59, 0x1E59 },
	{ 0x1E5B, 0x1E5B },
	{ 0x1E5D, 0x1E5D },
	{ 0x1E5F, 0x1E5F },
	{ 0x1E61, 0x1E61 },
	{ 0x1E63, 0x1E63 },
	{ 0x1E65, 0x1E65 },
	{ 0x1E67, 0x1E67 },
	{ 0x1E69, 0x1E69 },
	{ 0x1E6B, 0x1E6B },
	{ 0x1E6D, 0x1E6D },
	{ 0x1E6F, 0x1E6F },
	{ 0x1E71, 0x1E71 },
	{ 0x1E73, 0x1E73 },
	{ 0x1E75, 0x1E75 },
	{ 0x1E77, 0x1E77 },
	{ 0x1E79, 0x1E79 },
	{ 0x1E7B, 0x1E7B },
	{ 0x1E7D, 0x1E7D },
	{ 0x1E7F, 0x1E7F },
	{ 0x1E81, 0x1E81 },
	{ 0x1E83, 0x1E83 },
	{ 0x1E85, 0x1E85 },
	{ 0x1E87, 0x1E87 },
	{ 0x1E89, 0x1E89 },
	{ 0x1E8B, 0x1E8B },
	{ 0x1E8D, 0x1E8D },
	{ 0x1E8F, 0x1E8F },
	{ 0x1E91, 0x1E91 },
	{ 0x1E93, 0x1E93 },
	{ 0x1E95, 0x1E95 },
	{ 0x1E9B, 0x1E9B },
	{ 0x1EA1, 0x1EA1 },
	{ 0x1EA3, 0x1EA3 },
	{ 0x1EA5, 0x1EA5 },
	{ 0x1EA7, 0x1EA7 },
	{ 0x1EA9, 0x1EA9 },
	{ 0x1EAB, 0x1EAB },
	{ 0x1EAD, 0x1EAD },
	{ 0x1EAF, 0x1EAF },
	{ 0x1EB1, 0x1EB1 },
	{ 0x1EB3, 0x1EB3 },
	{ 0x1EB5, 0x1EB5 },
	{ 0x1EB7, 0x1EB7 },
	{ 0x1EB9, 0x1EB9 },
	{ 0x1EBB, 0x1EBB },
	{ 0x1EBD, 0x1EBD },
	{ 0x1EBF, 0x1EBF },
	{ 0x1EC1, 0x1EC1 },
	{ 0x1EC3, 0x1EC3 },
	{ 0x1EC5, 0x1EC5 },
	{ 0x1EC7, 0x1EC7 },
	{ 0x1EC9, 0x1EC9 },
	{ 0x1ECB, 0x1ECB },
	{ 0x1ECD, 0x1ECD },
	{ 0x1ECF, 0x1ECF },
	{ 0x1ED1, 0x1ED1 },
	{ 0x1ED3, 0x1ED3 },
	{ 0x1ED5, 0x1ED5 },
	{ 0x1ED7, 0x1ED7 },
	{ 0x1ED9, 0x1ED9 },
	{ 0x1EDB, 0x1EDB },
	{ 0x1EDD, 0x1EDD },
	{ 0x1EDF, 0x1EDF },
	{ 0x1EE1, 0x1EE1 },
	{ 0x1EE3, 0x1EE3 },
	{ 0x1EE5, 0x1EE5 },
	{ 0x1EE7, 0x1EE7 },
	{ 0x1EE9, 0x1EE9 },
	{ 0x1EEB, 0x1EEB },
	{ 0x1EED, 0x1EED },
	{ 0x1EEF, 0x1EEF },
	{ 0x1EF1, 0x1EF1 },
	{ 0x1EF3, 0x1EF3 },
	{ 0x1EF5, 0x1EF5 },
	{ 0x1EF7, 0x1EF7 },
	{ 0x1EF9, 0x1EF9 },
	{ 0x1EFB, 0x1EFB },
	{ 0x1EFD, 0x1EFD },
	{ 0x1EFF, 0x1EFF },
	{ 0x1F00, 0x1F07 },
	{ 0x1F10, 0x1F15 },
	{ 0x1F20, 0x1F27 },
	{ 0x1F30, 0x1F37 },
	{ 0x1F40, 0x1F45 },
	{ 0x1F51, 0x1F51 },
	{ 0x1F53, 0x1F53 },
	{ 0x1F55, 0x1F55 },
	{ 0x1F57, 0x1F57 },
	{ 0x1F60, 0x1F67 },
	{ 0x1F70, 0x1F71 },
	{ 0x1F72, 0x1F75 },
	{ 0x1F76, 0x1F77 },
	{ 0x1F78, 0x1F79 },
	{ 0x1F7A, 0x1F7B },
	{ 0x1F7C, 0x1F7D },
	{ 0x1F80, 0x1F87 },
	{ 0x1F90, 0x1F97 },
	{ 0x1FA0, 0x1FA7 },
	{ 0x1FB0, 0x1FB1 },
	{ 0x1FB3, 0x1FB3 },
	{ 0x1FBE, 0x1FBE },
	{ 0x1FC3, 0x1FC3 },
	{ 0x1FD0, 0x1FD1 },
	{ 0x1FE0, 0x1FE1 },
	{ 0x1FE5, 0x1FE5 },
	{ 0x1FF3, 0x1FF3 },
	{ 0x214E, 0x214E },
	{ 0x2170, 0x217F },
	{ 0x2184, 0x2184 },
	{ 0x24D0, 0x24E9 },
	{ 0x2C30, 0x2C5E },
	{ 0x2C61, 0x2C61 },
	{ 0x2C65, 0x2C65 },
	{ 0x2C66, 0x2C66 },
	{ 0x2C68, 0x2C68 },
	{ 0x2C6A, 0x2C6A },
	{ 0x2C6C, 0x2C6C },
	{ 0x2C73, 0x2C73 },
	{ 0x2C76, 0x2C76 },
	{ 0x2C81, 0x2C81 },
	{ 0x2C83, 0x2C83 },
	{ 0x2C85, 0x2C85 },
	{ 0x2C87, 0x2C87 },
	{ 0x2C89, 0x2C89 },
	{ 0x2C8B, 0x2C8B },
	{ 0x2C8D, 0x2C8D },
	{ 0x2C8F, 0x2C8F },
	{ 0x2C91, 0x2C91 },
	{ 0x2C93, 0x2C93 },
	{ 0x2C95, 0x2C95 },
	{ 0x2C97, 0x2C97 },
	{ 0x2C99, 0x2C99 },
	{ 0x2C9B, 0x2C9B },
	{ 0x2C9D, 0x2C9D },
	{ 0x2C9F, 0x2C9F },
	{ 0x2CA1, 0x2CA1 },
	{ 0x2CA3, 0x2CA3 },
	{ 0x2CA5, 0x2CA5 },
	{ 0x2CA7, 0x2CA7 },
	{ 0x2CA9, 0x2CA9 },
	{ 0x2CAB, 0x2CAB },
	{ 0x2CAD, 0x2CAD },
	{ 0x2CAF, 0x2CAF },
	{ 0x2CB1, 0x2CB1 },
	{ 0x2CB3, 0x2CB3 },
	{ 0x2CB5, 0x2CB5 },
	{ 0x2CB7, 0x2CB7 },
	{ 0x2CB9, 0x2CB9 },
	{ 0x2CBB, 0x2CBB },
	{ 0x2CBD, 0x2CBD },
	{ 0x2CBF, 0x2CBF },
	{ 0x2CC1, 0x2CC1 },
	{ 0x2CC3, 0x2CC3 },
	{ 0x2CC5, 0x2CC5 },
	{ 0x2CC7, 0x2CC7 },
	{ 0x2CC9, 0x2CC9 },
	{ 0x2CCB, 0x2CCB },
	{ 0x2CCD, 0x2CCD },
	{ 0x2CCF, 0x2CCF },
	{ 0x2CD1, 0x2CD1 },
	{ 0x2CD3, 0x2CD3 },
	{ 0x2CD5, 0x2CD5 },
	{ 0x2CD7, 0x2CD7 },
	{ 0x2CD9, 0x2CD9 },
	{ 0x2CDB, 0x2CDB },
	{ 0x2CDD, 0x2CDD },
	{ 0x2CDF, 0x2CDF },
	{ 0x2CE1, 0x2CE1 },
	{ 0x2CE3, 0x2CE3 },
	{ 0x2CEC, 0x2CEC },
	{ 0x2CEE, 0x2CEE },
	{ 0x2CF3, 0x2CF3 },
	{ 0x2D00, 0x2D25 },
	{ 0x2D27, 0x2D27 },
	{ 0x2D2D, 0x2D2D },
	{ 0xA641, 0xA641 },
	{ 0xA643, 0xA643 },
	{ 0xA645, 0xA645 },
	{ 0xA647, 0xA647 },
	{ 0xA649, 0xA649 },
	{ 0xA64B, 0xA64B },
	{ 0xA64D, 0xA64D },
	{ 0xA64F, 0xA64F },
	{ 0xA651, 0xA651 },
	{ 0xA653, 0xA653 },
	{ 0xA655, 0xA655 },
	{ 0xA657, 0xA657 },
	{ 0xA659, 0xA659 },
	{ 0xA65B, 0xA65B },
	{ 0xA65D, 0xA65D },
	{ 0xA65F, 0xA65F },
	{ 0xA661, 0xA661 },
	{ 0xA663, 0xA663 },
	{ 0xA665, 0xA665 },
	{ 0xA667, 0xA667 },
	{ 0xA669, 0xA669 },
	{ 0xA66B, 0xA66B },
	{ 0xA66D, 0xA66D },
	{ 0xA681, 0xA681 },
	{ 0xA683, 0xA683 },
	{ 0xA685, 0xA685 },
	{ 0xA687, 0xA687 },
	{ 0xA689, 0xA689 },
	{ 0xA68B, 0xA68B },
	{ 0xA68D, 0xA68D },
	{ 0xA68F, 0xA68F },
	{ 0xA691, 0xA691 },
	{ 0xA693, 0xA693 },
	{ 0xA695, 0xA695 },
	{ 0xA697, 0xA697 },
	{ 0xA699, 0xA699 },
	{ 0xA69B, 0xA69B },
	{ 0xA723, 0xA723 },
	{ 0xA725, 0xA725 },
	{ 0xA727, 0xA727 },
	{ 0xA729, 0xA729 },
	{ 0xA72B, 0xA72B },
	{ 0xA72D, 0xA72D },
	{ 0xA72F, 0xA72F },
	{ 0xA733, 0xA733 },
	{ 0xA735, 0xA735 },
	{ 0xA737, 0xA737 },
	{ 0xA739, 0xA739 },
	{ 0xA73B, 0xA73B },
	{ 0xA73D, 0xA73D },
	{ 0xA73F, 0xA73F },
	{ 0xA741, 0xA741 },
	{ 0xA743, 0xA743 },
	{ 0xA745, 0xA745 },
	{ 0xA747, 0xA747 },
	{ 0xA749, 0xA749 },
	{ 0xA74B, 0xA74B },
	{ 0xA74D, 0xA74D },
	{ 0xA74F, 0xA74F },
	{ 0xA751, 0xA751 },
	{ 0xA753, 0xA753 },
	{ 0xA755, 0xA755 },
	{ 0xA757, 0xA757 },
	{ 0xA759, 0xA759 },
	{ 0xA75B, 0xA75B },
	{ 0xA75D, 0xA75D },
	{ 0xA75F, 0xA75F },
	{ 0xA761, 0xA761 },
	{ 0xA763, 0xA763 },
	{ 0xA765, 0xA765 },
	{ 0xA767, 0xA767 },
	{ 0xA769, 0xA769 },
	{ 0xA76B, 0xA76B },
	{ 0xA76D, 0xA76D },
	{ 0xA76F, 0xA76F },
	{ 0xA77A, 0xA77A },
	{ 0xA77C, 0xA77C },
	{ 0xA77F, 0xA77F },
	{ 0xA781, 0xA781 },
	{ 0xA783, 0xA783 },
	{ 0xA785, 0xA785 },
	{ 0xA787, 0xA787 },
	{ 0xA78C, 0xA78C },
	{ 0xA791, 0xA791 },
	{ 0xA793, 0xA793 },
	{ 0xA794, 0xA794 },
	{ 0xA797, 0xA797 },
	{ 0xA799, 0xA799 },
	{ 0xA79B, 0xA79B },
	{ 0xA79D, 0xA79D },
	{ 0xA79F, 0xA79F },
	{ 0xA7A1, 0xA7A1 },
	{ 0xA7A3, 0xA7A3 },
	{ 0xA7A5, 0xA7A5 },
	{ 0xA7A7, 0xA7A7 },
	{ 0xA7A9, 0xA7A9 },
	{ 0xA7B5, 0xA7B5 },
	{ 0xA7B7, 0xA7B7 },
	{ 0xA7B9, 0xA7B9 },
	{ 0xA7BB, 0xA7BB },
	{ 0xA7BD, 0xA7BD },
	{ 0xA7BF, 0xA7BF },
	{ 0xA7C3, 0xA7C3 },
	{ 0xA7C8, 0xA7C8 },
	{ 0xA7CA, 0xA7CA },
	{ 0xA7F6, 0xA7F6 },
	{ 0xAB53, 0xAB53 },
	{ 0xAB70, 0xABBF },
	{ 0xFF41, 0xFF5A },
	{ 0x10428, 0x1044F },
	{ 0x104D8, 0x104FB },
	{ 0x10CC0, 0x10CF2 },
	{ 0x118C0, 0x118DF },
	{ 0x16E60, 0x16E7F },
	{ 0x1E922, 0x1E943 }
};

static const int data_wcdelta_toupper[] = {
	32,
	-743,
	32,
	32,
	-121,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	232,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	300,
	-195,
	1,
	1,
	1,
	1,
	1,
	-97,
	1,
	-163,
	-130,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	-56,
	1,
	2,
	1,
	2,
	1,
	2,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	79,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	2,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	-10815,
	1,
	1,
	1,
	1,
	1,
	1,
	-10783,
	-10780,
	-10782,
	210,
	206,
	205,
	202,
	203,
	-42319,
	205,
	-42315,
	207,
	-42280,
	-42308,
	209,
	211,
	-42308,
	-10743,
	-42305,
	211,
	-10749,
	213,
	214,
	-10727,
	218,
	-42307,
	218,
	-42282,
	218,
	69,
	217,
	71,
	219,
	-42261,
	-42258,
	-84,
	1,
	1,
	1,
	-130,
	38,
	37,
	32,
	31,
	32,
	64,
	63,
	62,
	57,
	47,
	54,
	8,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	86,
	80,
	-7,
	116,
	96,
	1,
	1,
	32,
	80,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	15,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	48,
	-3008,
	-3008,
	8,
	6254,
	6253,
	6244,
	6242,
	6243,
	6236,
	6181,
	-35266,
	-35332,
	-3814,
	-35384,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	59,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	-8,
	-8,
	-8,
	-8,
	-8,
	-8,
	-8,
	-8,
	-8,
	-8,
	-74,
	-86,
	-100,
	-128,
	-112,
	-126,
	-8,
	-8,
	-8,
	-8,
	-9,
	7205,
	-9,
	-8,
	-8,
	-7,
	-9,
	28,
	16,
	1,
	26,
	48,
	1,
	10795,
	10792,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	7264,
	7264,
	7264,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	-48,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	928,
	38864,
	32,
	40,
	40,
	64,
	32,
	32,
	34
};

int joe_towupper(int c)
{
	size_t idx;

	if ((idx = mb_ucsbsearch(data_wcrange_toupper,
	    NELEM(data_wcrange_toupper), c)) == (size_t)-1)
		return (c);
	return (c - data_wcdelta_toupper[idx]);
}

static const struct mb_ucsrange data_wcrange_tolower[] = {
	{ 0x0041, 0x005A },
	{ 0x00C0, 0x00D6 },
	{ 0x00D8, 0x00DE },
	{ 0x0100, 0x0100 },
	{ 0x0102, 0x0102 },
	{ 0x0104, 0x0104 },
	{ 0x0106, 0x0106 },
	{ 0x0108, 0x0108 },
	{ 0x010A, 0x010A },
	{ 0x010C, 0x010C },
	{ 0x010E, 0x010E },
	{ 0x0110, 0x0110 },
	{ 0x0112, 0x0112 },
	{ 0x0114, 0x0114 },
	{ 0x0116, 0x0116 },
	{ 0x0118, 0x0118 },
	{ 0x011A, 0x011A },
	{ 0x011C, 0x011C },
	{ 0x011E, 0x011E },
	{ 0x0120, 0x0120 },
	{ 0x0122, 0x0122 },
	{ 0x0124, 0x0124 },
	{ 0x0126, 0x0126 },
	{ 0x0128, 0x0128 },
	{ 0x012A, 0x012A },
	{ 0x012C, 0x012C },
	{ 0x012E, 0x012E },
	{ 0x0130, 0x0130 },
	{ 0x0132, 0x0132 },
	{ 0x0134, 0x0134 },
	{ 0x0136, 0x0136 },
	{ 0x0139, 0x0139 },
	{ 0x013B, 0x013B },
	{ 0x013D, 0x013D },
	{ 0x013F, 0x013F },
	{ 0x0141, 0x0141 },
	{ 0x0143, 0x0143 },
	{ 0x0145, 0x0145 },
	{ 0x0147, 0x0147 },
	{ 0x014A, 0x014A },
	{ 0x014C, 0x014C },
	{ 0x014E, 0x014E },
	{ 0x0150, 0x0150 },
	{ 0x0152, 0x0152 },
	{ 0x0154, 0x0154 },
	{ 0x0156, 0x0156 },
	{ 0x0158, 0x0158 },
	{ 0x015A, 0x015A },
	{ 0x015C, 0x015C },
	{ 0x015E, 0x015E },
	{ 0x0160, 0x0160 },
	{ 0x0162, 0x0162 },
	{ 0x0164, 0x0164 },
	{ 0x0166, 0x0166 },
	{ 0x0168, 0x0168 },
	{ 0x016A, 0x016A },
	{ 0x016C, 0x016C },
	{ 0x016E, 0x016E },
	{ 0x0170, 0x0170 },
	{ 0x0172, 0x0172 },
	{ 0x0174, 0x0174 },
	{ 0x0176, 0x0176 },
	{ 0x0178, 0x0178 },
	{ 0x0179, 0x0179 },
	{ 0x017B, 0x017B },
	{ 0x017D, 0x017D },
	{ 0x0181, 0x0181 },
	{ 0x0182, 0x0182 },
	{ 0x0184, 0x0184 },
	{ 0x0186, 0x0186 },
	{ 0x0187, 0x0187 },
	{ 0x0189, 0x018A },
	{ 0x018B, 0x018B },
	{ 0x018E, 0x018E },
	{ 0x018F, 0x018F },
	{ 0x0190, 0x0190 },
	{ 0x0191, 0x0191 },
	{ 0x0193, 0x0193 },
	{ 0x0194, 0x0194 },
	{ 0x0196, 0x0196 },
	{ 0x0197, 0x0197 },
	{ 0x0198, 0x0198 },
	{ 0x019C, 0x019C },
	{ 0x019D, 0x019D },
	{ 0x019F, 0x019F },
	{ 0x01A0, 0x01A0 },
	{ 0x01A2, 0x01A2 },
	{ 0x01A4, 0x01A4 },
	{ 0x01A6, 0x01A6 },
	{ 0x01A7, 0x01A7 },
	{ 0x01A9, 0x01A9 },
	{ 0x01AC, 0x01AC },
	{ 0x01AE, 0x01AE },
	{ 0x01AF, 0x01AF },
	{ 0x01B1, 0x01B2 },
	{ 0x01B3, 0x01B3 },
	{ 0x01B5, 0x01B5 },
	{ 0x01B7, 0x01B7 },
	{ 0x01B8, 0x01B8 },
	{ 0x01BC, 0x01BC },
	{ 0x01C4, 0x01C4 },
	{ 0x01C5, 0x01C5 },
	{ 0x01C7, 0x01C7 },
	{ 0x01C8, 0x01C8 },
	{ 0x01CA, 0x01CA },
	{ 0x01CB, 0x01CB },
	{ 0x01CD, 0x01CD },
	{ 0x01CF, 0x01CF },
	{ 0x01D1, 0x01D1 },
	{ 0x01D3, 0x01D3 },
	{ 0x01D5, 0x01D5 },
	{ 0x01D7, 0x01D7 },
	{ 0x01D9, 0x01D9 },
	{ 0x01DB, 0x01DB },
	{ 0x01DE, 0x01DE },
	{ 0x01E0, 0x01E0 },
	{ 0x01E2, 0x01E2 },
	{ 0x01E4, 0x01E4 },
	{ 0x01E6, 0x01E6 },
	{ 0x01E8, 0x01E8 },
	{ 0x01EA, 0x01EA },
	{ 0x01EC, 0x01EC },
	{ 0x01EE, 0x01EE },
	{ 0x01F1, 0x01F1 },
	{ 0x01F2, 0x01F2 },
	{ 0x01F4, 0x01F4 },
	{ 0x01F6, 0x01F6 },
	{ 0x01F7, 0x01F7 },
	{ 0x01F8, 0x01F8 },
	{ 0x01FA, 0x01FA },
	{ 0x01FC, 0x01FC },
	{ 0x01FE, 0x01FE },
	{ 0x0200, 0x0200 },
	{ 0x0202, 0x0202 },
	{ 0x0204, 0x0204 },
	{ 0x0206, 0x0206 },
	{ 0x0208, 0x0208 },
	{ 0x020A, 0x020A },
	{ 0x020C, 0x020C },
	{ 0x020E, 0x020E },
	{ 0x0210, 0x0210 },
	{ 0x0212, 0x0212 },
	{ 0x0214, 0x0214 },
	{ 0x0216, 0x0216 },
	{ 0x0218, 0x0218 },
	{ 0x021A, 0x021A },
	{ 0x021C, 0x021C },
	{ 0x021E, 0x021E },
	{ 0x0220, 0x0220 },
	{ 0x0222, 0x0222 },
	{ 0x0224, 0x0224 },
	{ 0x0226, 0x0226 },
	{ 0x0228, 0x0228 },
	{ 0x022A, 0x022A },
	{ 0x022C, 0x022C },
	{ 0x022E, 0x022E },
	{ 0x0230, 0x0230 },
	{ 0x0232, 0x0232 },
	{ 0x023A, 0x023A },
	{ 0x023B, 0x023B },
	{ 0x023D, 0x023D },
	{ 0x023E, 0x023E },
	{ 0x0241, 0x0241 },
	{ 0x0243, 0x0243 },
	{ 0x0244, 0x0244 },
	{ 0x0245, 0x0245 },
	{ 0x0246, 0x0246 },
	{ 0x0248, 0x0248 },
	{ 0x024A, 0x024A },
	{ 0x024C, 0x024C },
	{ 0x024E, 0x024E },
	{ 0x0370, 0x0370 },
	{ 0x0372, 0x0372 },
	{ 0x0376, 0x0376 },
	{ 0x037F, 0x037F },
	{ 0x0386, 0x0386 },
	{ 0x0388, 0x038A },
	{ 0x038C, 0x038C },
	{ 0x038E, 0x038F },
	{ 0x0391, 0x03A1 },
	{ 0x03A3, 0x03AB },
	{ 0x03CF, 0x03CF },
	{ 0x03D8, 0x03D8 },
	{ 0x03DA, 0x03DA },
	{ 0x03DC, 0x03DC },
	{ 0x03DE, 0x03DE },
	{ 0x03E0, 0x03E0 },
	{ 0x03E2, 0x03E2 },
	{ 0x03E4, 0x03E4 },
	{ 0x03E6, 0x03E6 },
	{ 0x03E8, 0x03E8 },
	{ 0x03EA, 0x03EA },
	{ 0x03EC, 0x03EC },
	{ 0x03EE, 0x03EE },
	{ 0x03F4, 0x03F4 },
	{ 0x03F7, 0x03F7 },
	{ 0x03F9, 0x03F9 },
	{ 0x03FA, 0x03FA },
	{ 0x03FD, 0x03FF },
	{ 0x0400, 0x040F },
	{ 0x0410, 0x042F },
	{ 0x0460, 0x0460 },
	{ 0x0462, 0x0462 },
	{ 0x0464, 0x0464 },
	{ 0x0466, 0x0466 },
	{ 0x0468, 0x0468 },
	{ 0x046A, 0x046A },
	{ 0x046C, 0x046C },
	{ 0x046E, 0x046E },
	{ 0x0470, 0x0470 },
	{ 0x0472, 0x0472 },
	{ 0x0474, 0x0474 },
	{ 0x0476, 0x0476 },
	{ 0x0478, 0x0478 },
	{ 0x047A, 0x047A },
	{ 0x047C, 0x047C },
	{ 0x047E, 0x047E },
	{ 0x0480, 0x0480 },
	{ 0x048A, 0x048A },
	{ 0x048C, 0x048C },
	{ 0x048E, 0x048E },
	{ 0x0490, 0x0490 },
	{ 0x0492, 0x0492 },
	{ 0x0494, 0x0494 },
	{ 0x0496, 0x0496 },
	{ 0x0498, 0x0498 },
	{ 0x049A, 0x049A },
	{ 0x049C, 0x049C },
	{ 0x049E, 0x049E },
	{ 0x04A0, 0x04A0 },
	{ 0x04A2, 0x04A2 },
	{ 0x04A4, 0x04A4 },
	{ 0x04A6, 0x04A6 },
	{ 0x04A8, 0x04A8 },
	{ 0x04AA, 0x04AA },
	{ 0x04AC, 0x04AC },
	{ 0x04AE, 0x04AE },
	{ 0x04B0, 0x04B0 },
	{ 0x04B2, 0x04B2 },
	{ 0x04B4, 0x04B4 },
	{ 0x04B6, 0x04B6 },
	{ 0x04B8, 0x04B8 },
	{ 0x04BA, 0x04BA },
	{ 0x04BC, 0x04BC },
	{ 0x04BE, 0x04BE },
	{ 0x04C0, 0x04C0 },
	{ 0x04C1, 0x04C1 },
	{ 0x04C3, 0x04C3 },
	{ 0x04C5, 0x04C5 },
	{ 0x04C7, 0x04C7 },
	{ 0x04C9, 0x04C9 },
	{ 0x04CB, 0x04CB },
	{ 0x04CD, 0x04CD },
	{ 0x04D0, 0x04D0 },
	{ 0x04D2, 0x04D2 },
	{ 0x04D4, 0x04D4 },
	{ 0x04D6, 0x04D6 },
	{ 0x04D8, 0x04D8 },
	{ 0x04DA, 0x04DA },
	{ 0x04DC, 0x04DC },
	{ 0x04DE, 0x04DE },
	{ 0x04E0, 0x04E0 },
	{ 0x04E2, 0x04E2 },
	{ 0x04E4, 0x04E4 },
	{ 0x04E6, 0x04E6 },
	{ 0x04E8, 0x04E8 },
	{ 0x04EA, 0x04EA },
	{ 0x04EC, 0x04EC },
	{ 0x04EE, 0x04EE },
	{ 0x04F0, 0x04F0 },
	{ 0x04F2, 0x04F2 },
	{ 0x04F4, 0x04F4 },
	{ 0x04F6, 0x04F6 },
	{ 0x04F8, 0x04F8 },
	{ 0x04FA, 0x04FA },
	{ 0x04FC, 0x04FC },
	{ 0x04FE, 0x04FE },
	{ 0x0500, 0x0500 },
	{ 0x0502, 0x0502 },
	{ 0x0504, 0x0504 },
	{ 0x0506, 0x0506 },
	{ 0x0508, 0x0508 },
	{ 0x050A, 0x050A },
	{ 0x050C, 0x050C },
	{ 0x050E, 0x050E },
	{ 0x0510, 0x0510 },
	{ 0x0512, 0x0512 },
	{ 0x0514, 0x0514 },
	{ 0x0516, 0x0516 },
	{ 0x0518, 0x0518 },
	{ 0x051A, 0x051A },
	{ 0x051C, 0x051C },
	{ 0x051E, 0x051E },
	{ 0x0520, 0x0520 },
	{ 0x0522, 0x0522 },
	{ 0x0524, 0x0524 },
	{ 0x0526, 0x0526 },
	{ 0x0528, 0x0528 },
	{ 0x052A, 0x052A },
	{ 0x052C, 0x052C },
	{ 0x052E, 0x052E },
	{ 0x0531, 0x0556 },
	{ 0x10A0, 0x10C5 },
	{ 0x10C7, 0x10C7 },
	{ 0x10CD, 0x10CD },
	{ 0x13A0, 0x13EF },
	{ 0x13F0, 0x13F5 },
	{ 0x1C90, 0x1CBA },
	{ 0x1CBD, 0x1CBF },
	{ 0x1E00, 0x1E00 },
	{ 0x1E02, 0x1E02 },
	{ 0x1E04, 0x1E04 },
	{ 0x1E06, 0x1E06 },
	{ 0x1E08, 0x1E08 },
	{ 0x1E0A, 0x1E0A },
	{ 0x1E0C, 0x1E0C },
	{ 0x1E0E, 0x1E0E },
	{ 0x1E10, 0x1E10 },
	{ 0x1E12, 0x1E12 },
	{ 0x1E14, 0x1E14 },
	{ 0x1E16, 0x1E16 },
	{ 0x1E18, 0x1E18 },
	{ 0x1E1A, 0x1E1A },
	{ 0x1E1C, 0x1E1C },
	{ 0x1E1E, 0x1E1E },
	{ 0x1E20, 0x1E20 },
	{ 0x1E22, 0x1E22 },
	{ 0x1E24, 0x1E24 },
	{ 0x1E26, 0x1E26 },
	{ 0x1E28, 0x1E28 },
	{ 0x1E2A, 0x1E2A },
	{ 0x1E2C, 0x1E2C },
	{ 0x1E2E, 0x1E2E },
	{ 0x1E30, 0x1E30 },
	{ 0x1E32, 0x1E32 },
	{ 0x1E34, 0x1E34 },
	{ 0x1E36, 0x1E36 },
	{ 0x1E38, 0x1E38 },
	{ 0x1E3A, 0x1E3A },
	{ 0x1E3C, 0x1E3C },
	{ 0x1E3E, 0x1E3E },
	{ 0x1E40, 0x1E40 },
	{ 0x1E42, 0x1E42 },
	{ 0x1E44, 0x1E44 },
	{ 0x1E46, 0x1E46 },
	{ 0x1E48, 0x1E48 },
	{ 0x1E4A, 0x1E4A },
	{ 0x1E4C, 0x1E4C },
	{ 0x1E4E, 0x1E4E },
	{ 0x1E50, 0x1E50 },
	{ 0x1E52, 0x1E52 },
	{ 0x1E54, 0x1E54 },
	{ 0x1E56, 0x1E56 },
	{ 0x1E58, 0x1E58 },
	{ 0x1E5A, 0x1E5A },
	{ 0x1E5C, 0x1E5C },
	{ 0x1E5E, 0x1E5E },
	{ 0x1E60, 0x1E60 },
	{ 0x1E62, 0x1E62 },
	{ 0x1E64, 0x1E64 },
	{ 0x1E66, 0x1E66 },
	{ 0x1E68, 0x1E68 },
	{ 0x1E6A, 0x1E6A },
	{ 0x1E6C, 0x1E6C },
	{ 0x1E6E, 0x1E6E },
	{ 0x1E70, 0x1E70 },
	{ 0x1E72, 0x1E72 },
	{ 0x1E74, 0x1E74 },
	{ 0x1E76, 0x1E76 },
	{ 0x1E78, 0x1E78 },
	{ 0x1E7A, 0x1E7A },
	{ 0x1E7C, 0x1E7C },
	{ 0x1E7E, 0x1E7E },
	{ 0x1E80, 0x1E80 },
	{ 0x1E82, 0x1E82 },
	{ 0x1E84, 0x1E84 },
	{ 0x1E86, 0x1E86 },
	{ 0x1E88, 0x1E88 },
	{ 0x1E8A, 0x1E8A },
	{ 0x1E8C, 0x1E8C },
	{ 0x1E8E, 0x1E8E },
	{ 0x1E90, 0x1E90 },
	{ 0x1E92, 0x1E92 },
	{ 0x1E94, 0x1E94 },
	{ 0x1E9E, 0x1E9E },
	{ 0x1EA0, 0x1EA0 },
	{ 0x1EA2, 0x1EA2 },
	{ 0x1EA4, 0x1EA4 },
	{ 0x1EA6, 0x1EA6 },
	{ 0x1EA8, 0x1EA8 },
	{ 0x1EAA, 0x1EAA },
	{ 0x1EAC, 0x1EAC },
	{ 0x1EAE, 0x1EAE },
	{ 0x1EB0, 0x1EB0 },
	{ 0x1EB2, 0x1EB2 },
	{ 0x1EB4, 0x1EB4 },
	{ 0x1EB6, 0x1EB6 },
	{ 0x1EB8, 0x1EB8 },
	{ 0x1EBA, 0x1EBA },
	{ 0x1EBC, 0x1EBC },
	{ 0x1EBE, 0x1EBE },
	{ 0x1EC0, 0x1EC0 },
	{ 0x1EC2, 0x1EC2 },
	{ 0x1EC4, 0x1EC4 },
	{ 0x1EC6, 0x1EC6 },
	{ 0x1EC8, 0x1EC8 },
	{ 0x1ECA, 0x1ECA },
	{ 0x1ECC, 0x1ECC },
	{ 0x1ECE, 0x1ECE },
	{ 0x1ED0, 0x1ED0 },
	{ 0x1ED2, 0x1ED2 },
	{ 0x1ED4, 0x1ED4 },
	{ 0x1ED6, 0x1ED6 },
	{ 0x1ED8, 0x1ED8 },
	{ 0x1EDA, 0x1EDA },
	{ 0x1EDC, 0x1EDC },
	{ 0x1EDE, 0x1EDE },
	{ 0x1EE0, 0x1EE0 },
	{ 0x1EE2, 0x1EE2 },
	{ 0x1EE4, 0x1EE4 },
	{ 0x1EE6, 0x1EE6 },
	{ 0x1EE8, 0x1EE8 },
	{ 0x1EEA, 0x1EEA },
	{ 0x1EEC, 0x1EEC },
	{ 0x1EEE, 0x1EEE },
	{ 0x1EF0, 0x1EF0 },
	{ 0x1EF2, 0x1EF2 },
	{ 0x1EF4, 0x1EF4 },
	{ 0x1EF6, 0x1EF6 },
	{ 0x1EF8, 0x1EF8 },
	{ 0x1EFA, 0x1EFA },
	{ 0x1EFC, 0x1EFC },
	{ 0x1EFE, 0x1EFE },
	{ 0x1F08, 0x1F0F },
	{ 0x1F18, 0x1F1D },
	{ 0x1F28, 0x1F2F },
	{ 0x1F38, 0x1F3F },
	{ 0x1F48, 0x1F4D },
	{ 0x1F59, 0x1F59 },
	{ 0x1F5B, 0x1F5B },
	{ 0x1F5D, 0x1F5D },
	{ 0x1F5F, 0x1F5F },
	{ 0x1F68, 0x1F6F },
	{ 0x1F88, 0x1F8F },
	{ 0x1F98, 0x1F9F },
	{ 0x1FA8, 0x1FAF },
	{ 0x1FB8, 0x1FB9 },
	{ 0x1FBA, 0x1FBB },
	{ 0x1FBC, 0x1FBC },
	{ 0x1FC8, 0x1FCB },
	{ 0x1FCC, 0x1FCC },
	{ 0x1FD8, 0x1FD9 },
	{ 0x1FDA, 0x1FDB },
	{ 0x1FE8, 0x1FE9 },
	{ 0x1FEA, 0x1FEB },
	{ 0x1FEC, 0x1FEC },
	{ 0x1FF8, 0x1FF9 },
	{ 0x1FFA, 0x1FFB },
	{ 0x1FFC, 0x1FFC },
	{ 0x2126, 0x2126 },
	{ 0x212A, 0x212A },
	{ 0x212B, 0x212B },
	{ 0x2132, 0x2132 },
	{ 0x2160, 0x216F },
	{ 0x2183, 0x2183 },
	{ 0x24B6, 0x24CF },
	{ 0x2C00, 0x2C2E },
	{ 0x2C60, 0x2C60 },
	{ 0x2C62, 0x2C62 },
	{ 0x2C63, 0x2C63 },
	{ 0x2C64, 0x2C64 },
	{ 0x2C67, 0x2C67 },
	{ 0x2C69, 0x2C69 },
	{ 0x2C6B, 0x2C6B },
	{ 0x2C6D, 0x2C6D },
	{ 0x2C6E, 0x2C6E },
	{ 0x2C6F, 0x2C6F },
	{ 0x2C70, 0x2C70 },
	{ 0x2C72, 0x2C72 },
	{ 0x2C75, 0x2C75 },
	{ 0x2C7E, 0x2C7F },
	{ 0x2C80, 0x2C80 },
	{ 0x2C82, 0x2C82 },
	{ 0x2C84, 0x2C84 },
	{ 0x2C86, 0x2C86 },
	{ 0x2C88, 0x2C88 },
	{ 0x2C8A, 0x2C8A },
	{ 0x2C8C, 0x2C8C },
	{ 0x2C8E, 0x2C8E },
	{ 0x2C90, 0x2C90 },
	{ 0x2C92, 0x2C92 },
	{ 0x2C94, 0x2C94 },
	{ 0x2C96, 0x2C96 },
	{ 0x2C98, 0x2C98 },
	{ 0x2C9A, 0x2C9A },
	{ 0x2C9C, 0x2C9C },
	{ 0x2C9E, 0x2C9E },
	{ 0x2CA0, 0x2CA0 },
	{ 0x2CA2, 0x2CA2 },
	{ 0x2CA4, 0x2CA4 },
	{ 0x2CA6, 0x2CA6 },
	{ 0x2CA8, 0x2CA8 },
	{ 0x2CAA, 0x2CAA },
	{ 0x2CAC, 0x2CAC },
	{ 0x2CAE, 0x2CAE },
	{ 0x2CB0, 0x2CB0 },
	{ 0x2CB2, 0x2CB2 },
	{ 0x2CB4, 0x2CB4 },
	{ 0x2CB6, 0x2CB6 },
	{ 0x2CB8, 0x2CB8 },
	{ 0x2CBA, 0x2CBA },
	{ 0x2CBC, 0x2CBC },
	{ 0x2CBE, 0x2CBE },
	{ 0x2CC0, 0x2CC0 },
	{ 0x2CC2, 0x2CC2 },
	{ 0x2CC4, 0x2CC4 },
	{ 0x2CC6, 0x2CC6 },
	{ 0x2CC8, 0x2CC8 },
	{ 0x2CCA, 0x2CCA },
	{ 0x2CCC, 0x2CCC },
	{ 0x2CCE, 0x2CCE },
	{ 0x2CD0, 0x2CD0 },
	{ 0x2CD2, 0x2CD2 },
	{ 0x2CD4, 0x2CD4 },
	{ 0x2CD6, 0x2CD6 },
	{ 0x2CD8, 0x2CD8 },
	{ 0x2CDA, 0x2CDA },
	{ 0x2CDC, 0x2CDC },
	{ 0x2CDE, 0x2CDE },
	{ 0x2CE0, 0x2CE0 },
	{ 0x2CE2, 0x2CE2 },
	{ 0x2CEB, 0x2CEB },
	{ 0x2CED, 0x2CED },
	{ 0x2CF2, 0x2CF2 },
	{ 0xA640, 0xA640 },
	{ 0xA642, 0xA642 },
	{ 0xA644, 0xA644 },
	{ 0xA646, 0xA646 },
	{ 0xA648, 0xA648 },
	{ 0xA64A, 0xA64A },
	{ 0xA64C, 0xA64C },
	{ 0xA64E, 0xA64E },
	{ 0xA650, 0xA650 },
	{ 0xA652, 0xA652 },
	{ 0xA654, 0xA654 },
	{ 0xA656, 0xA656 },
	{ 0xA658, 0xA658 },
	{ 0xA65A, 0xA65A },
	{ 0xA65C, 0xA65C },
	{ 0xA65E, 0xA65E },
	{ 0xA660, 0xA660 },
	{ 0xA662, 0xA662 },
	{ 0xA664, 0xA664 },
	{ 0xA666, 0xA666 },
	{ 0xA668, 0xA668 },
	{ 0xA66A, 0xA66A },
	{ 0xA66C, 0xA66C },
	{ 0xA680, 0xA680 },
	{ 0xA682, 0xA682 },
	{ 0xA684, 0xA684 },
	{ 0xA686, 0xA686 },
	{ 0xA688, 0xA688 },
	{ 0xA68A, 0xA68A },
	{ 0xA68C, 0xA68C },
	{ 0xA68E, 0xA68E },
	{ 0xA690, 0xA690 },
	{ 0xA692, 0xA692 },
	{ 0xA694, 0xA694 },
	{ 0xA696, 0xA696 },
	{ 0xA698, 0xA698 },
	{ 0xA69A, 0xA69A },
	{ 0xA722, 0xA722 },
	{ 0xA724, 0xA724 },
	{ 0xA726, 0xA726 },
	{ 0xA728, 0xA728 },
	{ 0xA72A, 0xA72A },
	{ 0xA72C, 0xA72C },
	{ 0xA72E, 0xA72E },
	{ 0xA732, 0xA732 },
	{ 0xA734, 0xA734 },
	{ 0xA736, 0xA736 },
	{ 0xA738, 0xA738 },
	{ 0xA73A, 0xA73A },
	{ 0xA73C, 0xA73C },
	{ 0xA73E, 0xA73E },
	{ 0xA740, 0xA740 },
	{ 0xA742, 0xA742 },
	{ 0xA744, 0xA744 },
	{ 0xA746, 0xA746 },
	{ 0xA748, 0xA748 },
	{ 0xA74A, 0xA74A },
	{ 0xA74C, 0xA74C },
	{ 0xA74E, 0xA74E },
	{ 0xA750, 0xA750 },
	{ 0xA752, 0xA752 },
	{ 0xA754, 0xA754 },
	{ 0xA756, 0xA756 },
	{ 0xA758, 0xA758 },
	{ 0xA75A, 0xA75A },
	{ 0xA75C, 0xA75C },
	{ 0xA75E, 0xA75E },
	{ 0xA760, 0xA760 },
	{ 0xA762, 0xA762 },
	{ 0xA764, 0xA764 },
	{ 0xA766, 0xA766 },
	{ 0xA768, 0xA768 },
	{ 0xA76A, 0xA76A },
	{ 0xA76C, 0xA76C },
	{ 0xA76E, 0xA76E },
	{ 0xA779, 0xA779 },
	{ 0xA77B, 0xA77B },
	{ 0xA77D, 0xA77D },
	{ 0xA77E, 0xA77E },
	{ 0xA780, 0xA780 },
	{ 0xA782, 0xA782 },
	{ 0xA784, 0xA784 },
	{ 0xA786, 0xA786 },
	{ 0xA78B, 0xA78B },
	{ 0xA78D, 0xA78D },
	{ 0xA790, 0xA790 },
	{ 0xA792, 0xA792 },
	{ 0xA796, 0xA796 },
	{ 0xA798, 0xA798 },
	{ 0xA79A, 0xA79A },
	{ 0xA79C, 0xA79C },
	{ 0xA79E, 0xA79E },
	{ 0xA7A0, 0xA7A0 },
	{ 0xA7A2, 0xA7A2 },
	{ 0xA7A4, 0xA7A4 },
	{ 0xA7A6, 0xA7A6 },
	{ 0xA7A8, 0xA7A8 },
	{ 0xA7AA, 0xA7AA },
	{ 0xA7AB, 0xA7AB },
	{ 0xA7AC, 0xA7AC },
	{ 0xA7AD, 0xA7AD },
	{ 0xA7AE, 0xA7AE },
	{ 0xA7B0, 0xA7B0 },
	{ 0xA7B1, 0xA7B1 },
	{ 0xA7B2, 0xA7B2 },
	{ 0xA7B3, 0xA7B3 },
	{ 0xA7B4, 0xA7B4 },
	{ 0xA7B6, 0xA7B6 },
	{ 0xA7B8, 0xA7B8 },
	{ 0xA7BA, 0xA7BA },
	{ 0xA7BC, 0xA7BC },
	{ 0xA7BE, 0xA7BE },
	{ 0xA7C2, 0xA7C2 },
	{ 0xA7C4, 0xA7C4 },
	{ 0xA7C5, 0xA7C5 },
	{ 0xA7C6, 0xA7C6 },
	{ 0xA7C7, 0xA7C7 },
	{ 0xA7C9, 0xA7C9 },
	{ 0xA7F5, 0xA7F5 },
	{ 0xFF21, 0xFF3A },
	{ 0x10400, 0x10427 },
	{ 0x104B0, 0x104D3 },
	{ 0x10C80, 0x10CB2 },
	{ 0x118A0, 0x118BF },
	{ 0x16E40, 0x16E5F },
	{ 0x1E900, 0x1E921 }
};

static const int data_wcdelta_tolower[] = {
	32,
	32,
	32,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	-199,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	-121,
	1,
	1,
	1,
	210,
	1,
	1,
	206,
	1,
	205,
	1,
	79,
	202,
	203,
	1,
	205,
	207,
	211,
	209,
	1,
	211,
	213,
	214,
	1,
	1,
	1,
	218,
	1,
	218,
	1,
	218,
	1,
	217,
	1,
	1,
	219,
	1,
	1,
	2,
	1,
	2,
	1,
	2,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	2,
	1,
	1,
	-97,
	-56,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	-130,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	10795,
	1,
	-163,
	10792,
	1,
	-195,
	69,
	71,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	116,
	38,
	37,
	64,
	63,
	32,
	32,
	8,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	-60,
	1,
	-7,
	1,
	-130,
	80,
	32,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	15,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	48,
	7264,
	7264,
	7264,
	38864,
	8,
	-3008,
	-3008,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	-7615,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	-8,
	-8,
	-8,
	-8,
	-8,
	-8,
	-8,
	-8,
	-8,
	-8,
	-8,
	-8,
	-8,
	-8,
	-74,
	-9,
	-86,
	-9,
	-8,
	-100,
	-8,
	-112,
	-7,
	-128,
	-126,
	-9,
	-7517,
	-8383,
	-8262,
	28,
	16,
	1,
	26,
	48,
	1,
	-10743,
	-3814,
	-10727,
	1,
	1,
	1,
	-10780,
	-10749,
	-10783,
	-10782,
	1,
	1,
	-10815,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	-35332,
	1,
	1,
	1,
	1,
	1,
	1,
	-42280,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	-42308,
	-42319,
	-42315,
	-42305,
	-42308,
	-42258,
	-42282,
	-42261,
	928,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	-48,
	-42307,
	-35384,
	1,
	1,
	1,
	32,
	40,
	40,
	64,
	32,
	32,
	34
};

int joe_towlower(int c)
{
	size_t idx;

	if ((idx = mb_ucsbsearch(data_wcrange_tolower,
	    NELEM(data_wcrange_tolower), c)) == (size_t)-1)
		return (c);
	return (c + data_wcdelta_tolower[idx]);
}

/* Test the functions */

#ifdef TEST_I18N
int
main(int argc,char *argv[])
{
	int c;
	void *vp;

	if (argc != 2)
		return (1);
	c = ustolb(argv[1], &vp, 0, 0x10FFFF, USTOL_TRIM | USTOL_EOS);
	if (!vp)
		return (1);
	printf("Properties of character %X:\n",c);
	printf("upper=%X\n",joe_iswupper(c));
	printf("lower=%X\n",joe_iswlower(c));
	printf("alpha=%X\n",joe_iswalpha(c));
	printf("digit=%X\n",joe_iswdigit(c));
	printf("cntrl=%X\n",joe_iswcntrl(c));
	printf("punct=%X\n",joe_iswpunct(c));
	printf("graph=%X\n",joe_iswgraph(c));
	printf("print=%X\n",joe_iswprint(c));
	printf("xdigit=%X\n",joe_iswxdigit(c));
	printf("blank=%X\n",joe_iswblank(c));
	printf("width=%X\n",joe_wcwidth(c));
	printf("toupper=%X\n",joe_towupper(c));
	printf("tolower=%X\n",joe_towlower(c));
	return (0);
}
#endif

#if 0
.endif

PROG=		i18n
SRCS=		compat.c i18n.c
NOMAN=		Yes
CPPFLAGS+=	-DTEST -DTEST_I18N

.include <bsd.own.mk>

.ifdef __CRAZY
.  if exists(/usr/include/jupp.tmp.h) && !defined(wnostrict)
CPPFLAGS+=	-DGCC_Wstrict_prototypes
.  else
COPTS+=		-Wno-strict-prototypes
.  endif
.endif

.include <bsd.prog.mk>
#endif
