/*
  Copyright (c) 2024, Intel Corporation

  SPDX-License-Identifier: BSD-3-Clause
*/

// Builtins are target-specific functions implemented using LLVM IR. They are
// located in builtins directory. Their names typically start with double
// underscores. Unlike Standard Library functions, they are not guaranteed to
// be stable as compiler evolves. But they are used to implement the Standard
// Library.
//
// During compilation flow ISPC compiler sometimes needs to treat builtins
// differently than user functions or stdlib functions, or does optimizations
// that recognize certain builtins (like gather/scatter optimization flow).
// Addressing builtins by string representation of the name in the source code
// is error prone, so this file solves this problem by defining the pointer
// with builtin name pointing to a C-string representing the name. For example,
// instead of using "__any" identifier, it's available as builtin::__any.
//
// This file has to be the only place to declare builtin names that used across
// ISPC code base. The list is alphabetically sorted for convenience.

namespace ispc {

namespace builtin {

extern const char *const __acos_uniform_double;
extern const char *const __acos_uniform_float;
extern const char *const __acos_uniform_half;
extern const char *const __acos_varying_double;
extern const char *const __acos_varying_float;
extern const char *const __acos_varying_half;
extern const char *const __add_float;
extern const char *const __add_int32;
extern const char *const __add_uniform_double;
extern const char *const __add_uniform_int32;
extern const char *const __add_uniform_int64;
extern const char *const __add_varying_double;
extern const char *const __add_varying_int32;
extern const char *const __add_varying_int64;
extern const char *const __all;
extern const char *const __any;
extern const char *const __aos_to_soa2_double;
extern const char *const __aos_to_soa2_double1;
extern const char *const __aos_to_soa2_double16;
extern const char *const __aos_to_soa2_double32;
extern const char *const __aos_to_soa2_double4;
extern const char *const __aos_to_soa2_double64;
extern const char *const __aos_to_soa2_double8;
extern const char *const __aos_to_soa2_float;
extern const char *const __aos_to_soa2_float1;
extern const char *const __aos_to_soa2_float16;
extern const char *const __aos_to_soa2_float32;
extern const char *const __aos_to_soa2_float4;
extern const char *const __aos_to_soa2_float64;
extern const char *const __aos_to_soa2_float8;
extern const char *const __aos_to_soa3_double;
extern const char *const __aos_to_soa3_double1;
extern const char *const __aos_to_soa3_double16;
extern const char *const __aos_to_soa3_double32;
extern const char *const __aos_to_soa3_double4;
extern const char *const __aos_to_soa3_double64;
extern const char *const __aos_to_soa3_double8;
extern const char *const __aos_to_soa3_float;
extern const char *const __aos_to_soa3_float1;
extern const char *const __aos_to_soa3_float16;
extern const char *const __aos_to_soa3_float32;
extern const char *const __aos_to_soa3_float4;
extern const char *const __aos_to_soa3_float64;
extern const char *const __aos_to_soa3_float8;
extern const char *const __aos_to_soa4_double;
extern const char *const __aos_to_soa4_double1;
extern const char *const __aos_to_soa4_double16;
extern const char *const __aos_to_soa4_double32;
extern const char *const __aos_to_soa4_double4;
extern const char *const __aos_to_soa4_double64;
extern const char *const __aos_to_soa4_double8;
extern const char *const __aos_to_soa4_float;
extern const char *const __aos_to_soa4_float1;
extern const char *const __aos_to_soa4_float16;
extern const char *const __aos_to_soa4_float32;
extern const char *const __aos_to_soa4_float4;
extern const char *const __aos_to_soa4_float64;
extern const char *const __aos_to_soa4_float8;
extern const char *const __asin_uniform_double;
extern const char *const __asin_uniform_float;
extern const char *const __asin_uniform_half;
extern const char *const __asin_varying_double;
extern const char *const __asin_varying_float;
extern const char *const __asin_varying_half;
extern const char *const __atan2_uniform_double;
extern const char *const __atan2_uniform_float;
extern const char *const __atan2_uniform_half;
extern const char *const __atan2_varying_double;
extern const char *const __atan2_varying_float;
extern const char *const __atan2_varying_half;
extern const char *const __atan_uniform_double;
extern const char *const __atan_uniform_float;
extern const char *const __atan_uniform_half;
extern const char *const __atan_varying_double;
extern const char *const __atan_varying_float;
extern const char *const __atan_varying_half;
extern const char *const __atomic_add_int32_global;
extern const char *const __atomic_add_int64_global;
extern const char *const __atomic_add_uniform_int32_global;
extern const char *const __atomic_add_uniform_int64_global;
extern const char *const __atomic_and_int32_global;
extern const char *const __atomic_and_int64_global;
extern const char *const __atomic_and_uniform_int32_global;
extern const char *const __atomic_and_uniform_int64_global;
extern const char *const __atomic_compare_exchange_double_global;
extern const char *const __atomic_compare_exchange_float_global;
extern const char *const __atomic_compare_exchange_int32_global;
extern const char *const __atomic_compare_exchange_int64_global;
extern const char *const __atomic_compare_exchange_uniform_double_global;
extern const char *const __atomic_compare_exchange_uniform_float_global;
extern const char *const __atomic_compare_exchange_uniform_int32_global;
extern const char *const __atomic_compare_exchange_uniform_int64_global;
extern const char *const __atomic_max_uniform_int32_global;
extern const char *const __atomic_max_uniform_int64_global;
extern const char *const __atomic_min_uniform_int32_global;
extern const char *const __atomic_min_uniform_int64_global;
extern const char *const __atomic_or_int32_global;
extern const char *const __atomic_or_int64_global;
extern const char *const __atomic_or_uniform_int32_global;
extern const char *const __atomic_or_uniform_int64_global;
extern const char *const __atomic_sub_int32_global;
extern const char *const __atomic_sub_int64_global;
extern const char *const __atomic_sub_uniform_int32_global;
extern const char *const __atomic_sub_uniform_int64_global;
extern const char *const __atomic_swap_double_global;
extern const char *const __atomic_swap_float_global;
extern const char *const __atomic_swap_int32_global;
extern const char *const __atomic_swap_int64_global;
extern const char *const __atomic_swap_uniform_double_global;
extern const char *const __atomic_swap_uniform_float_global;
extern const char *const __atomic_swap_uniform_int32_global;
extern const char *const __atomic_swap_uniform_int64_global;
extern const char *const __atomic_umax_uniform_uint32_global;
extern const char *const __atomic_umax_uniform_uint64_global;
extern const char *const __atomic_umin_uniform_uint32_global;
extern const char *const __atomic_umin_uniform_uint64_global;
extern const char *const __atomic_xor_int32_global;
extern const char *const __atomic_xor_int64_global;
extern const char *const __atomic_xor_uniform_int32_global;
extern const char *const __atomic_xor_uniform_int64_global;
extern const char *const __avg_down_int16;
extern const char *const __avg_down_int8;
extern const char *const __avg_down_uint16;
extern const char *const __avg_down_uint8;
extern const char *const __avg_up_int16;
extern const char *const __avg_up_int8;
extern const char *const __avg_up_uint16;
extern const char *const __avg_up_uint8;
extern const char *const __broadcast_double;
extern const char *const __broadcast_float;
extern const char *const __broadcast_half;
extern const char *const __broadcast_i16;
extern const char *const __broadcast_i32;
extern const char *const __broadcast_i64;
extern const char *const __broadcast_i8;
extern const char *const __cast_mask_to_i1;
extern const char *const __cast_mask_to_i16;
extern const char *const __cast_mask_to_i32;
extern const char *const __cast_mask_to_i64;
extern const char *const __cast_mask_to_i8;
extern const char *const __ceil_uniform_double;
extern const char *const __ceil_uniform_float;
extern const char *const __ceil_uniform_half;
extern const char *const __ceil_varying_double;
extern const char *const __ceil_varying_float;
extern const char *const __ceil_varying_half;
extern const char *const __clock;
extern const char *const __cos_uniform_double;
extern const char *const __cos_uniform_float;
extern const char *const __cos_uniform_half;
extern const char *const __cos_varying_double;
extern const char *const __cos_varying_float;
extern const char *const __cos_varying_half;
extern const char *const __count_leading_zeros_i32;
extern const char *const __count_leading_zeros_i64;
extern const char *const __count_trailing_zeros_i32;
extern const char *const __count_trailing_zeros_i64;
extern const char *const __delete_uniform_32rt;
extern const char *const __delete_uniform_64rt;
extern const char *const __delete_varying_32rt;
extern const char *const __delete_varying_64rt;
extern const char *const __do_assert_uniform;
extern const char *const __do_assert_varying;
extern const char *const __do_assume_uniform;
extern const char *const __do_print;
extern const char *const __dot2add_i16packed;
extern const char *const __dot2add_i16packed_sat;
extern const char *const __dot4add_u8i8packed;
extern const char *const __dot4add_u8i8packed_sat;
extern const char *const __doublebits_uniform_int64;
extern const char *const __doublebits_varying_int64;
extern const char *const __exclusive_scan_add_double;
extern const char *const __exclusive_scan_add_float;
extern const char *const __exclusive_scan_add_half;
extern const char *const __exclusive_scan_add_i32;
extern const char *const __exclusive_scan_add_i64;
extern const char *const __exclusive_scan_and_i32;
extern const char *const __exclusive_scan_and_i64;
extern const char *const __exclusive_scan_or_i32;
extern const char *const __exclusive_scan_or_i64;
extern const char *const __exp_uniform_double;
extern const char *const __exp_uniform_float;
extern const char *const __exp_uniform_half;
extern const char *const __exp_varying_double;
extern const char *const __exp_varying_float;
extern const char *const __exp_varying_half;
extern const char *const __extract_bool;
extern const char *const __extract_int16;
extern const char *const __extract_int32;
extern const char *const __extract_int64;
extern const char *const __extract_int8;
extern const char *const __extract_mask_hi;
extern const char *const __extract_mask_low;
extern const char *const __fast_masked_vload;
extern const char *const __fastmath;
extern const char *const __floatbits_uniform_int32;
extern const char *const __floatbits_varying_int32;
extern const char *const __float_to_half_uniform;
extern const char *const __float_to_half_varying;
extern const char *const __floor_uniform_double;
extern const char *const __floor_uniform_float;
extern const char *const __floor_uniform_half;
extern const char *const __floor_varying_double;
extern const char *const __floor_varying_float;
extern const char *const __floor_varying_half;
extern const char *const __gather32_double;
extern const char *const __gather32_float;
extern const char *const __gather32_generic_double;
extern const char *const __gather32_generic_float;
extern const char *const __gather32_generic_half;
extern const char *const __gather32_generic_i16;
extern const char *const __gather32_generic_i32;
extern const char *const __gather32_generic_i64;
extern const char *const __gather32_generic_i8;
extern const char *const __gather32_half;
extern const char *const __gather32_i16;
extern const char *const __gather32_i32;
extern const char *const __gather32_i64;
extern const char *const __gather32_i8;
extern const char *const __gather64_double;
extern const char *const __gather64_float;
extern const char *const __gather64_generic_double;
extern const char *const __gather64_generic_float;
extern const char *const __gather64_generic_half;
extern const char *const __gather64_generic_i16;
extern const char *const __gather64_generic_i32;
extern const char *const __gather64_generic_i64;
extern const char *const __gather64_generic_i8;
extern const char *const __gather64_half;
extern const char *const __gather64_i16;
extern const char *const __gather64_i32;
extern const char *const __gather64_i64;
extern const char *const __gather64_i8;
extern const char *const __gather_base_offsets32_double;
extern const char *const __gather_base_offsets32_float;
extern const char *const __gather_base_offsets32_half;
extern const char *const __gather_base_offsets32_i16;
extern const char *const __gather_base_offsets32_i32;
extern const char *const __gather_base_offsets32_i64;
extern const char *const __gather_base_offsets32_i8;
extern const char *const __gather_base_offsets64_double;
extern const char *const __gather_base_offsets64_float;
extern const char *const __gather_base_offsets64_half;
extern const char *const __gather_base_offsets64_i16;
extern const char *const __gather_base_offsets64_i32;
extern const char *const __gather_base_offsets64_i64;
extern const char *const __gather_base_offsets64_i8;
extern const char *const __gather_elt32_double;
extern const char *const __gather_elt32_float;
extern const char *const __gather_elt32_half;
extern const char *const __gather_elt32_i16;
extern const char *const __gather_elt32_i32;
extern const char *const __gather_elt32_i64;
extern const char *const __gather_elt32_i8;
extern const char *const __gather_elt64_double;
extern const char *const __gather_elt64_float;
extern const char *const __gather_elt64_half;
extern const char *const __gather_elt64_i16;
extern const char *const __gather_elt64_i32;
extern const char *const __gather_elt64_i64;
extern const char *const __gather_elt64_i8;
extern const char *const __gather_factored_base_offsets32_double;
extern const char *const __gather_factored_base_offsets32_float;
extern const char *const __gather_factored_base_offsets32_half;
extern const char *const __gather_factored_base_offsets32_i16;
extern const char *const __gather_factored_base_offsets32_i32;
extern const char *const __gather_factored_base_offsets32_i64;
extern const char *const __gather_factored_base_offsets32_i8;
extern const char *const __gather_factored_base_offsets64_double;
extern const char *const __gather_factored_base_offsets64_float;
extern const char *const __gather_factored_base_offsets64_half;
extern const char *const __gather_factored_base_offsets64_i16;
extern const char *const __gather_factored_base_offsets64_i32;
extern const char *const __gather_factored_base_offsets64_i64;
extern const char *const __gather_factored_base_offsets64_i8;
extern const char *const __get_system_isa;
extern const char *const __halfbits_uniform_int16;
extern const char *const __halfbits_varying_int16;
extern const char *const __half_to_float_uniform;
extern const char *const __half_to_float_varying;
extern const char *const __idiv_int16;
extern const char *const __idiv_int32;
extern const char *const __idiv_int8;
extern const char *const __idiv_uint16;
extern const char *const __idiv_uint32;
extern const char *const __idiv_uint8;
extern const char *const __insert_bool;
extern const char *const __insert_int16;
extern const char *const __insert_int32;
extern const char *const __insert_int64;
extern const char *const __insert_int8;
extern const char *const __intbits_uniform_double;
extern const char *const __intbits_uniform_float;
extern const char *const __intbits_uniform_half;
extern const char *const __intbits_varying_double;
extern const char *const __intbits_varying_float;
extern const char *const __intbits_varying_half;
extern const char *const __is_compile_time_constant_mask;
extern const char *const __is_compile_time_constant_uniform_int32;
extern const char *const __is_compile_time_constant_varying_int32;
extern const char *const ISPCAlloc;
extern const char *const ISPCLaunch;
extern const char *const ISPCSync;
extern const char *const __keep_funcs_live;
extern const char *const __log_uniform_double;
extern const char *const __log_uniform_float;
extern const char *const __log_uniform_half;
extern const char *const __log_varying_double;
extern const char *const __log_varying_float;
extern const char *const __log_varying_half;
extern const char *const __masked_load_blend_double;
extern const char *const __masked_load_blend_float;
extern const char *const __masked_load_blend_half;
extern const char *const __masked_load_blend_i16;
extern const char *const __masked_load_blend_i32;
extern const char *const __masked_load_blend_i64;
extern const char *const __masked_load_blend_i8;
extern const char *const __masked_load_double;
extern const char *const __masked_load_float;
extern const char *const __masked_load_half;
extern const char *const __masked_load_i16;
extern const char *const __masked_load_i32;
extern const char *const __masked_load_i64;
extern const char *const __masked_load_i8;
extern const char *const __masked_store_blend_double;
extern const char *const __masked_store_blend_float;
extern const char *const __masked_store_blend_half;
extern const char *const __masked_store_blend_i16;
extern const char *const __masked_store_blend_i32;
extern const char *const __masked_store_blend_i64;
extern const char *const __masked_store_blend_i8;
extern const char *const __masked_store_double;
extern const char *const __masked_store_float;
extern const char *const __masked_store_half;
extern const char *const __masked_store_i16;
extern const char *const __masked_store_i32;
extern const char *const __masked_store_i64;
extern const char *const __masked_store_i8;
extern const char *const __max_uniform_double;
extern const char *const __max_uniform_float;
extern const char *const __max_uniform_half;
extern const char *const __max_uniform_int32;
extern const char *const __max_uniform_int64;
extern const char *const __max_uniform_uint32;
extern const char *const __max_uniform_uint64;
extern const char *const __max_varying_double;
extern const char *const __max_varying_float;
extern const char *const __max_varying_half;
extern const char *const __max_varying_int32;
extern const char *const __max_varying_int64;
extern const char *const __max_varying_uint32;
extern const char *const __max_varying_uint64;
extern const char *const __memcpy32;
extern const char *const __memcpy64;
extern const char *const __memmove32;
extern const char *const __memmove64;
extern const char *const __memory_barrier;
extern const char *const __memset32;
extern const char *const __memset64;
extern const char *const __min_uniform_double;
extern const char *const __min_uniform_float;
extern const char *const __min_uniform_half;
extern const char *const __min_uniform_int32;
extern const char *const __min_uniform_int64;
extern const char *const __min_uniform_uint32;
extern const char *const __min_uniform_uint64;
extern const char *const __min_varying_double;
extern const char *const __min_varying_float;
extern const char *const __min_varying_half;
extern const char *const __min_varying_int32;
extern const char *const __min_varying_int64;
extern const char *const __min_varying_uint32;
extern const char *const __min_varying_uint64;
extern const char *const __movmsk;
extern const char *const __new_uniform_32rt;
extern const char *const __new_uniform_64rt;
extern const char *const __new_varying32_32rt;
extern const char *const __new_varying32_64rt;
extern const char *const __new_varying64_64rt;
extern const char *const __none;
extern const char *const __num_cores;
extern const char *const __packed_load_activei32;
extern const char *const __packed_load_activei64;
extern const char *const __packed_store_active2i32;
extern const char *const __packed_store_active2i64;
extern const char *const __packed_store_activei32;
extern const char *const __packed_store_activei64;
extern const char *const __padds_ui16;
extern const char *const __padds_ui32;
extern const char *const __padds_ui64;
extern const char *const __padds_ui8;
extern const char *const __padds_vi16;
extern const char *const __padds_vi32;
extern const char *const __padds_vi64;
extern const char *const __padds_vi8;
extern const char *const __paddus_ui16;
extern const char *const __paddus_ui32;
extern const char *const __paddus_ui64;
extern const char *const __paddus_ui8;
extern const char *const __paddus_vi16;
extern const char *const __paddus_vi32;
extern const char *const __paddus_vi64;
extern const char *const __paddus_vi8;
extern const char *const __pmuls_ui16;
extern const char *const __pmuls_ui32;
extern const char *const __pmuls_ui8;
extern const char *const __pmuls_vi16;
extern const char *const __pmuls_vi32;
extern const char *const __pmuls_vi8;
extern const char *const __pmulus_ui16;
extern const char *const __pmulus_ui32;
extern const char *const __pmulus_ui8;
extern const char *const __pmulus_vi16;
extern const char *const __pmulus_vi32;
extern const char *const __pmulus_vi8;
extern const char *const __popcnt_int32;
extern const char *const __popcnt_int64;
extern const char *const __pow_uniform_double;
extern const char *const __pow_uniform_float;
extern const char *const __pow_uniform_half;
extern const char *const __pow_varying_double;
extern const char *const __pow_varying_float;
extern const char *const __pow_varying_half;
extern const char *const __prefetch_read_sized_uniform_1;
extern const char *const __prefetch_read_sized_uniform_2;
extern const char *const __prefetch_read_sized_uniform_3;
extern const char *const __prefetch_read_sized_uniform_nt;
extern const char *const __prefetch_read_sized_varying_1;
extern const char *const __prefetch_read_sized_varying_2;
extern const char *const __prefetch_read_sized_varying_3;
extern const char *const __prefetch_read_sized_varying_nt;
extern const char *const __prefetch_read_uniform_1;
extern const char *const __prefetch_read_uniform_2;
extern const char *const __prefetch_read_uniform_3;
extern const char *const __prefetch_read_uniform_nt;
extern const char *const __prefetch_read_varying_1;
extern const char *const __prefetch_read_varying_1_native;
extern const char *const __prefetch_read_varying_2;
extern const char *const __prefetch_read_varying_2_native;
extern const char *const __prefetch_read_varying_3;
extern const char *const __prefetch_read_varying_3_native;
extern const char *const __prefetch_read_varying_nt;
extern const char *const __prefetch_read_varying_nt_native;
extern const char *const __prefetch_write_uniform_1;
extern const char *const __prefetch_write_uniform_2;
extern const char *const __prefetch_write_uniform_3;
extern const char *const __prefetch_write_varying_1;
extern const char *const __prefetch_write_varying_1_native;
extern const char *const __prefetch_write_varying_2;
extern const char *const __prefetch_write_varying_2_native;
extern const char *const __prefetch_write_varying_3;
extern const char *const __prefetch_write_varying_3_native;
extern const char *const __pseudo_gather32_double;
extern const char *const __pseudo_gather32_float;
extern const char *const __pseudo_gather32_half;
extern const char *const __pseudo_gather32_i16;
extern const char *const __pseudo_gather32_i32;
extern const char *const __pseudo_gather32_i64;
extern const char *const __pseudo_gather32_i8;
extern const char *const __pseudo_gather64_double;
extern const char *const __pseudo_gather64_float;
extern const char *const __pseudo_gather64_half;
extern const char *const __pseudo_gather64_i16;
extern const char *const __pseudo_gather64_i32;
extern const char *const __pseudo_gather64_i64;
extern const char *const __pseudo_gather64_i8;
extern const char *const __pseudo_gather_base_offsets32_double;
extern const char *const __pseudo_gather_base_offsets32_float;
extern const char *const __pseudo_gather_base_offsets32_half;
extern const char *const __pseudo_gather_base_offsets32_i16;
extern const char *const __pseudo_gather_base_offsets32_i32;
extern const char *const __pseudo_gather_base_offsets32_i64;
extern const char *const __pseudo_gather_base_offsets32_i8;
extern const char *const __pseudo_gather_base_offsets64_double;
extern const char *const __pseudo_gather_base_offsets64_float;
extern const char *const __pseudo_gather_base_offsets64_half;
extern const char *const __pseudo_gather_base_offsets64_i16;
extern const char *const __pseudo_gather_base_offsets64_i32;
extern const char *const __pseudo_gather_base_offsets64_i64;
extern const char *const __pseudo_gather_base_offsets64_i8;
extern const char *const __pseudo_gather_factored_base_offsets32_double;
extern const char *const __pseudo_gather_factored_base_offsets32_float;
extern const char *const __pseudo_gather_factored_base_offsets32_half;
extern const char *const __pseudo_gather_factored_base_offsets32_i16;
extern const char *const __pseudo_gather_factored_base_offsets32_i32;
extern const char *const __pseudo_gather_factored_base_offsets32_i64;
extern const char *const __pseudo_gather_factored_base_offsets32_i8;
extern const char *const __pseudo_gather_factored_base_offsets64_double;
extern const char *const __pseudo_gather_factored_base_offsets64_float;
extern const char *const __pseudo_gather_factored_base_offsets64_half;
extern const char *const __pseudo_gather_factored_base_offsets64_i16;
extern const char *const __pseudo_gather_factored_base_offsets64_i32;
extern const char *const __pseudo_gather_factored_base_offsets64_i64;
extern const char *const __pseudo_gather_factored_base_offsets64_i8;
extern const char *const __pseudo_masked_store_double;
extern const char *const __pseudo_masked_store_float;
extern const char *const __pseudo_masked_store_half;
extern const char *const __pseudo_masked_store_i16;
extern const char *const __pseudo_masked_store_i32;
extern const char *const __pseudo_masked_store_i64;
extern const char *const __pseudo_masked_store_i8;
extern const char *const __pseudo_prefetch_read_varying_1;
extern const char *const __pseudo_prefetch_read_varying_1_native;
extern const char *const __pseudo_prefetch_read_varying_2;
extern const char *const __pseudo_prefetch_read_varying_2_native;
extern const char *const __pseudo_prefetch_read_varying_3;
extern const char *const __pseudo_prefetch_read_varying_3_native;
extern const char *const __pseudo_prefetch_read_varying_nt;
extern const char *const __pseudo_prefetch_read_varying_nt_native;
extern const char *const __pseudo_prefetch_write_varying_1;
extern const char *const __pseudo_prefetch_write_varying_1_native;
extern const char *const __pseudo_prefetch_write_varying_2;
extern const char *const __pseudo_prefetch_write_varying_2_native;
extern const char *const __pseudo_prefetch_write_varying_3;
extern const char *const __pseudo_prefetch_write_varying_3_native;
extern const char *const __pseudo_scatter32_double;
extern const char *const __pseudo_scatter32_float;
extern const char *const __pseudo_scatter32_half;
extern const char *const __pseudo_scatter32_i16;
extern const char *const __pseudo_scatter32_i32;
extern const char *const __pseudo_scatter32_i64;
extern const char *const __pseudo_scatter32_i8;
extern const char *const __pseudo_scatter64_double;
extern const char *const __pseudo_scatter64_float;
extern const char *const __pseudo_scatter64_half;
extern const char *const __pseudo_scatter64_i16;
extern const char *const __pseudo_scatter64_i32;
extern const char *const __pseudo_scatter64_i64;
extern const char *const __pseudo_scatter64_i8;
extern const char *const __pseudo_scatter_base_offsets32_double;
extern const char *const __pseudo_scatter_base_offsets32_float;
extern const char *const __pseudo_scatter_base_offsets32_half;
extern const char *const __pseudo_scatter_base_offsets32_i16;
extern const char *const __pseudo_scatter_base_offsets32_i32;
extern const char *const __pseudo_scatter_base_offsets32_i64;
extern const char *const __pseudo_scatter_base_offsets32_i8;
extern const char *const __pseudo_scatter_base_offsets64_double;
extern const char *const __pseudo_scatter_base_offsets64_float;
extern const char *const __pseudo_scatter_base_offsets64_half;
extern const char *const __pseudo_scatter_base_offsets64_i16;
extern const char *const __pseudo_scatter_base_offsets64_i32;
extern const char *const __pseudo_scatter_base_offsets64_i64;
extern const char *const __pseudo_scatter_base_offsets64_i8;
extern const char *const __pseudo_scatter_factored_base_offsets32_double;
extern const char *const __pseudo_scatter_factored_base_offsets32_float;
extern const char *const __pseudo_scatter_factored_base_offsets32_half;
extern const char *const __pseudo_scatter_factored_base_offsets32_i16;
extern const char *const __pseudo_scatter_factored_base_offsets32_i32;
extern const char *const __pseudo_scatter_factored_base_offsets32_i64;
extern const char *const __pseudo_scatter_factored_base_offsets32_i8;
extern const char *const __pseudo_scatter_factored_base_offsets64_double;
extern const char *const __pseudo_scatter_factored_base_offsets64_float;
extern const char *const __pseudo_scatter_factored_base_offsets64_half;
extern const char *const __pseudo_scatter_factored_base_offsets64_i16;
extern const char *const __pseudo_scatter_factored_base_offsets64_i32;
extern const char *const __pseudo_scatter_factored_base_offsets64_i64;
extern const char *const __pseudo_scatter_factored_base_offsets64_i8;
extern const char *const __psubs_ui16;
extern const char *const __psubs_ui32;
extern const char *const __psubs_ui64;
extern const char *const __psubs_ui8;
extern const char *const __psubs_vi16;
extern const char *const __psubs_vi32;
extern const char *const __psubs_vi64;
extern const char *const __psubs_vi8;
extern const char *const __psubus_ui16;
extern const char *const __psubus_ui32;
extern const char *const __psubus_ui64;
extern const char *const __psubus_ui8;
extern const char *const __psubus_vi16;
extern const char *const __psubus_vi32;
extern const char *const __psubus_vi64;
extern const char *const __psubus_vi8;
extern const char *const __rcp_fast_uniform_double;
extern const char *const __rcp_fast_uniform_float;
extern const char *const __rcp_fast_uniform_half;
extern const char *const __rcp_fast_varying_double;
extern const char *const __rcp_fast_varying_float;
extern const char *const __rcp_fast_varying_half;
extern const char *const __rcp_uniform_double;
extern const char *const __rcp_uniform_float;
extern const char *const __rcp_uniform_half;
extern const char *const __rcp_varying_double;
extern const char *const __rcp_varying_float;
extern const char *const __rcp_varying_half;
extern const char *const __rdrand_i16;
extern const char *const __rdrand_i32;
extern const char *const __rdrand_i64;
extern const char *const __reduce_add_double;
extern const char *const __reduce_add_float;
extern const char *const __reduce_add_half;
extern const char *const __reduce_add_int16;
extern const char *const __reduce_add_int32;
extern const char *const __reduce_add_int64;
extern const char *const __reduce_add_int8;
extern const char *const __reduce_equal_double;
extern const char *const __reduce_equal_float;
extern const char *const __reduce_equal_half;
extern const char *const __reduce_equal_int32;
extern const char *const __reduce_equal_int64;
extern const char *const __reduce_max_double;
extern const char *const __reduce_max_float;
extern const char *const __reduce_max_half;
extern const char *const __reduce_max_int32;
extern const char *const __reduce_max_int64;
extern const char *const __reduce_max_uint32;
extern const char *const __reduce_max_uint64;
extern const char *const __reduce_min_double;
extern const char *const __reduce_min_float;
extern const char *const __reduce_min_half;
extern const char *const __reduce_min_int32;
extern const char *const __reduce_min_int64;
extern const char *const __reduce_min_uint32;
extern const char *const __reduce_min_uint64;
extern const char *const __restore_ftz_daz_flags;
extern const char *const __rotate_double;
extern const char *const __rotate_float;
extern const char *const __rotate_half;
extern const char *const __rotate_i16;
extern const char *const __rotate_i32;
extern const char *const __rotate_i64;
extern const char *const __rotate_i8;
extern const char *const __round_uniform_double;
extern const char *const __round_uniform_float;
extern const char *const __round_uniform_half;
extern const char *const __round_varying_double;
extern const char *const __round_varying_float;
extern const char *const __round_varying_half;
extern const char *const __rsqrt_fast_uniform_double;
extern const char *const __rsqrt_fast_uniform_float;
extern const char *const __rsqrt_fast_varying_double;
extern const char *const __rsqrt_fast_varying_float;
extern const char *const __rsqrt_uniform_double;
extern const char *const __rsqrt_uniform_float;
extern const char *const __rsqrt_uniform_half;
extern const char *const __rsqrt_varying_double;
extern const char *const __rsqrt_varying_float;
extern const char *const __rsqrt_varying_half;
extern const char *const __saturating_add_i16;
extern const char *const __saturating_add_i32;
extern const char *const __saturating_add_i64;
extern const char *const __saturating_add_i8;
extern const char *const __saturating_add_ui16;
extern const char *const __saturating_add_ui32;
extern const char *const __saturating_add_ui64;
extern const char *const __saturating_add_ui8;
extern const char *const __saturating_mul_i16;
extern const char *const __saturating_mul_i32;
extern const char *const __saturating_mul_i8;
extern const char *const __saturating_mul_ui16;
extern const char *const __saturating_mul_ui32;
extern const char *const __saturating_mul_ui8;
extern const char *const __scatter32_double;
extern const char *const __scatter32_float;
extern const char *const __scatter32_generic_double;
extern const char *const __scatter32_generic_float;
extern const char *const __scatter32_generic_half;
extern const char *const __scatter32_generic_i16;
extern const char *const __scatter32_generic_i32;
extern const char *const __scatter32_generic_i64;
extern const char *const __scatter32_generic_i8;
extern const char *const __scatter32_half;
extern const char *const __scatter32_i16;
extern const char *const __scatter32_i32;
extern const char *const __scatter32_i64;
extern const char *const __scatter32_i8;
extern const char *const __scatter64_double;
extern const char *const __scatter64_float;
extern const char *const __scatter64_generic_double;
extern const char *const __scatter64_generic_float;
extern const char *const __scatter64_generic_half;
extern const char *const __scatter64_generic_i16;
extern const char *const __scatter64_generic_i32;
extern const char *const __scatter64_generic_i64;
extern const char *const __scatter64_generic_i8;
extern const char *const __scatter64_half;
extern const char *const __scatter64_i16;
extern const char *const __scatter64_i32;
extern const char *const __scatter64_i64;
extern const char *const __scatter64_i8;
extern const char *const __scatter_base_offsets32_double;
extern const char *const __scatter_base_offsets32_float;
extern const char *const __scatter_base_offsets32_half;
extern const char *const __scatter_base_offsets32_i16;
extern const char *const __scatter_base_offsets32_i32;
extern const char *const __scatter_base_offsets32_i64;
extern const char *const __scatter_base_offsets32_i8;
extern const char *const __scatter_base_offsets64_double;
extern const char *const __scatter_base_offsets64_float;
extern const char *const __scatter_base_offsets64_half;
extern const char *const __scatter_base_offsets64_i16;
extern const char *const __scatter_base_offsets64_i32;
extern const char *const __scatter_base_offsets64_i64;
extern const char *const __scatter_base_offsets64_i8;
extern const char *const __scatter_elt32_double;
extern const char *const __scatter_elt32_float;
extern const char *const __scatter_elt32_half;
extern const char *const __scatter_elt32_i16;
extern const char *const __scatter_elt32_i32;
extern const char *const __scatter_elt32_i64;
extern const char *const __scatter_elt32_i8;
extern const char *const __scatter_elt64_double;
extern const char *const __scatter_elt64_float;
extern const char *const __scatter_elt64_half;
extern const char *const __scatter_elt64_i16;
extern const char *const __scatter_elt64_i32;
extern const char *const __scatter_elt64_i64;
extern const char *const __scatter_elt64_i8;
extern const char *const __scatter_factored_base_offsets32_double;
extern const char *const __scatter_factored_base_offsets32_float;
extern const char *const __scatter_factored_base_offsets32_half;
extern const char *const __scatter_factored_base_offsets32_i16;
extern const char *const __scatter_factored_base_offsets32_i32;
extern const char *const __scatter_factored_base_offsets32_i64;
extern const char *const __scatter_factored_base_offsets32_i8;
extern const char *const __scatter_factored_base_offsets64_double;
extern const char *const __scatter_factored_base_offsets64_float;
extern const char *const __scatter_factored_base_offsets64_half;
extern const char *const __scatter_factored_base_offsets64_i16;
extern const char *const __scatter_factored_base_offsets64_i32;
extern const char *const __scatter_factored_base_offsets64_i64;
extern const char *const __scatter_factored_base_offsets64_i8;
extern const char *const __send_eot;
extern const char *const __set_ftz_daz_flags;
extern const char *const __set_system_isa;
extern const char *const __sext_uniform_bool;
extern const char *const __sext_varying_bool;
extern const char *const __shift_double;
extern const char *const __shift_float;
extern const char *const __shift_half;
extern const char *const __shift_i16;
extern const char *const __shift_i32;
extern const char *const __shift_i64;
extern const char *const __shift_i8;
extern const char *const __shuffle2_double;
extern const char *const __shuffle2_float;
extern const char *const __shuffle2_half;
extern const char *const __shuffle2_i16;
extern const char *const __shuffle2_i32;
extern const char *const __shuffle2_i64;
extern const char *const __shuffle2_i8;
extern const char *const __shuffle_double;
extern const char *const __shuffle_float;
extern const char *const __shuffle_half;
extern const char *const __shuffle_i16;
extern const char *const __shuffle_i32;
extern const char *const __shuffle_i64;
extern const char *const __shuffle_i8;
extern const char *const __sincos_uniform_double;
extern const char *const __sincos_uniform_float;
extern const char *const __sincos_uniform_half;
extern const char *const __sincos_varying_double;
extern const char *const __sincos_varying_float;
extern const char *const __sincos_varying_half;
extern const char *const __sin_uniform_double;
extern const char *const __sin_uniform_float;
extern const char *const __sin_uniform_half;
extern const char *const __sin_varying_double;
extern const char *const __sin_varying_float;
extern const char *const __sin_varying_half;
extern const char *const __soa_to_aos2_double;
extern const char *const __soa_to_aos2_double1;
extern const char *const __soa_to_aos2_double16;
extern const char *const __soa_to_aos2_double32;
extern const char *const __soa_to_aos2_double4;
extern const char *const __soa_to_aos2_double64;
extern const char *const __soa_to_aos2_double8;
extern const char *const __soa_to_aos2_float;
extern const char *const __soa_to_aos2_float1;
extern const char *const __soa_to_aos2_float16;
extern const char *const __soa_to_aos2_float32;
extern const char *const __soa_to_aos2_float4;
extern const char *const __soa_to_aos2_float64;
extern const char *const __soa_to_aos2_float8;
extern const char *const __soa_to_aos3_double;
extern const char *const __soa_to_aos3_double1;
extern const char *const __soa_to_aos3_double16;
extern const char *const __soa_to_aos3_double32;
extern const char *const __soa_to_aos3_double4;
extern const char *const __soa_to_aos3_double64;
extern const char *const __soa_to_aos3_double8;
extern const char *const __soa_to_aos3_float;
extern const char *const __soa_to_aos3_float1;
extern const char *const __soa_to_aos3_float16;
extern const char *const __soa_to_aos3_float32;
extern const char *const __soa_to_aos3_float4;
extern const char *const __soa_to_aos3_float64;
extern const char *const __soa_to_aos3_float8;
extern const char *const __soa_to_aos4_double;
extern const char *const __soa_to_aos4_double1;
extern const char *const __soa_to_aos4_double16;
extern const char *const __soa_to_aos4_double32;
extern const char *const __soa_to_aos4_double4;
extern const char *const __soa_to_aos4_double64;
extern const char *const __soa_to_aos4_double8;
extern const char *const __soa_to_aos4_float;
extern const char *const __soa_to_aos4_float1;
extern const char *const __soa_to_aos4_float16;
extern const char *const __soa_to_aos4_float32;
extern const char *const __soa_to_aos4_float4;
extern const char *const __soa_to_aos4_float64;
extern const char *const __soa_to_aos4_float8;
extern const char *const __sqrt_uniform_double;
extern const char *const __sqrt_uniform_float;
extern const char *const __sqrt_uniform_half;
extern const char *const __sqrt_varying_double;
extern const char *const __sqrt_varying_float;
extern const char *const __sqrt_varying_half;
extern const char *const __stdlib_acosf;
extern const char *const __stdlib_asin;
extern const char *const __stdlib_asinf;
extern const char *const __stdlib_atan;
extern const char *const __stdlib_atan2;
extern const char *const __stdlib_atan2f;
extern const char *const __stdlib_atanf;
extern const char *const __stdlib_cos;
extern const char *const __stdlib_cosf;
extern const char *const __stdlib_exp;
extern const char *const __stdlib_expf;
extern const char *const __stdlib_log;
extern const char *const __stdlib_logf;
extern const char *const __stdlib_pow;
extern const char *const __stdlib_powf;
extern const char *const __stdlib_sin;
extern const char *const __stdlib_sincos;
extern const char *const __stdlib_sincosf;
extern const char *const __stdlib_sinf;
extern const char *const __stdlib_tan;
extern const char *const __stdlib_tanf;
extern const char *const __streaming_load_uniform_double;
extern const char *const __streaming_load_uniform_float;
extern const char *const __streaming_load_uniform_half;
extern const char *const __streaming_load_uniform_i16;
extern const char *const __streaming_load_uniform_i32;
extern const char *const __streaming_load_uniform_i64;
extern const char *const __streaming_load_uniform_i8;
extern const char *const __streaming_load_varying_double;
extern const char *const __streaming_load_varying_float;
extern const char *const __streaming_load_varying_half;
extern const char *const __streaming_load_varying_i16;
extern const char *const __streaming_load_varying_i32;
extern const char *const __streaming_load_varying_i64;
extern const char *const __streaming_load_varying_i8;
extern const char *const __streaming_store_uniform_double;
extern const char *const __streaming_store_uniform_float;
extern const char *const __streaming_store_uniform_half;
extern const char *const __streaming_store_uniform_i16;
extern const char *const __streaming_store_uniform_i32;
extern const char *const __streaming_store_uniform_i64;
extern const char *const __streaming_store_uniform_i8;
extern const char *const __streaming_store_varying_double;
extern const char *const __streaming_store_varying_float;
extern const char *const __streaming_store_varying_half;
extern const char *const __streaming_store_varying_i16;
extern const char *const __streaming_store_varying_i32;
extern const char *const __streaming_store_varying_i64;
extern const char *const __streaming_store_varying_i8;
extern const char *const __svml_acosd;
extern const char *const __svml_acosf;
extern const char *const __svml_asind;
extern const char *const __svml_asinf;
extern const char *const __svml_atan2d;
extern const char *const __svml_atan2f;
extern const char *const __svml_atand;
extern const char *const __svml_atanf;
extern const char *const __svml_cosd;
extern const char *const __svml_cosf;
extern const char *const __svml_expd;
extern const char *const __svml_expf;
extern const char *const __svml_invsqrtd;
extern const char *const __svml_invsqrtf;
extern const char *const __svml_logd;
extern const char *const __svml_logf;
extern const char *const __svml_powd;
extern const char *const __svml_powf;
extern const char *const __svml_sincosd;
extern const char *const __svml_sincosf;
extern const char *const __svml_sind;
extern const char *const __svml_sinf;
extern const char *const __svml_sqrtd;
extern const char *const __svml_sqrtf;
extern const char *const __svml_tand;
extern const char *const __svml_tanf;
extern const char *const __tan_uniform_double;
extern const char *const __tan_uniform_float;
extern const char *const __tan_uniform_half;
extern const char *const __tan_varying_double;
extern const char *const __tan_varying_float;
extern const char *const __tan_varying_half;
extern const char *const __task_count;
extern const char *const __task_count0;
extern const char *const __task_count1;
extern const char *const __task_count2;
extern const char *const __task_index;
extern const char *const __task_index0;
extern const char *const __task_index1;
extern const char *const __task_index2;
extern const char *const __trunc_uniform_double;
extern const char *const __trunc_uniform_float;
extern const char *const __trunc_uniform_half;
extern const char *const __trunc_varying_double;
extern const char *const __trunc_varying_float;
extern const char *const __trunc_varying_half;
extern const char *const __undef_uniform;
extern const char *const __undef_varying;
extern const char *const __vec4_add_float;
extern const char *const __vec4_add_int32;
extern const char *const __vselect_float;
extern const char *const __vselect_i32;

} // namespace builtin

} // namespace ispc
