/*
 * Copyright (C) 2021-2023 Intel Corporation
 *
 * SPDX-License-Identifier: MIT
 *
 */

#if SUPPORT_XE_HPC_CORE
#ifdef SUPPORT_PVC
DEVICE_CONFIG(PVC_XL_A0, PvcHwConfig, pvcXlDeviceIds, XE_FAMILY, XE_HPC_RELEASE)
DEVICE_CONFIG(PVC_XL_A0P, PvcHwConfig, pvcXlDeviceIds, XE_FAMILY, XE_HPC_RELEASE)
DEVICE_CONFIG(PVC_XT_A0, PvcHwConfig, pvcXtDeviceIds, XE_FAMILY, XE_HPC_RELEASE)
DEVICE_CONFIG(PVC_XT_B0, PvcHwConfig, pvcXtDeviceIds, XE_FAMILY, XE_HPC_RELEASE)
DEVICE_CONFIG(PVC_XT_B1, PvcHwConfig, pvcXtDeviceIds, XE_FAMILY, XE_HPC_RELEASE)
DEVICE_CONFIG(PVC_XT_C0, PvcHwConfig, pvcXtDeviceIds, XE_FAMILY, XE_HPC_RELEASE)
DEVICE_CONFIG(PVC_XT_C0_VG, PvcHwConfig, pvcXtVgDeviceIds, XE_FAMILY, XE_HPC_RELEASE)

#endif
#endif

#ifdef SUPPORT_XE_HPG_CORE
#ifdef SUPPORT_MTL
DEVICE_CONFIG(MTL_M_A0, MtlHwConfig, mtlmDeviceIds, XE_FAMILY, XE_LPG_RELEASE)
DEVICE_CONFIG(MTL_M_B0, MtlHwConfig, mtlmDeviceIds, XE_FAMILY, XE_LPG_RELEASE)
DEVICE_CONFIG(MTL_P_A0, MtlHwConfig, mtlpDeviceIds, XE_FAMILY, XE_LPG_RELEASE)
DEVICE_CONFIG(MTL_P_B0, MtlHwConfig, mtlpDeviceIds, XE_FAMILY, XE_LPG_RELEASE)
#endif
#ifdef SUPPORT_DG2
DEVICE_CONFIG(DG2_G10_A0, Dg2HwConfig, dg2G10DeviceIds, XE_FAMILY, XE_HPG_RELEASE)
DEVICE_CONFIG(DG2_G10_A1, Dg2HwConfig, dg2G10DeviceIds, XE_FAMILY, XE_HPG_RELEASE)
DEVICE_CONFIG(DG2_G10_B0, Dg2HwConfig, dg2G10DeviceIds, XE_FAMILY, XE_HPG_RELEASE)
DEVICE_CONFIG(DG2_G10_C0, Dg2HwConfig, dg2G10DeviceIds, XE_FAMILY, XE_HPG_RELEASE)
DEVICE_CONFIG(DG2_G11_A0, Dg2HwConfig, dg2G11DeviceIds, XE_FAMILY, XE_HPG_RELEASE)
DEVICE_CONFIG(DG2_G11_B0, Dg2HwConfig, dg2G11DeviceIds, XE_FAMILY, XE_HPG_RELEASE)
DEVICE_CONFIG(DG2_G11_B1, Dg2HwConfig, dg2G11DeviceIds, XE_FAMILY, XE_HPG_RELEASE)
DEVICE_CONFIG(DG2_G12_A0, Dg2HwConfig, dg2G12DeviceIds, XE_FAMILY, XE_HPG_RELEASE)
#endif
#ifdef SUPPORT_ARL
DEVICE_CONFIG(XE_LPGPLUS_A0, ArlHwConfig, arlDeviceIds, XE_FAMILY, XE_LPGPLUS_RELEASE)
DEVICE_CONFIG(XE_LPGPLUS_B0, ArlHwConfig, arlDeviceIds, XE_FAMILY, XE_LPGPLUS_RELEASE)
#endif
#endif

#ifdef SUPPORT_GEN12LP
#ifdef SUPPORT_TGLLP
DEVICE_CONFIG(TGL, TgllpHw1x6x16, tgllpDeviceIds, GEN12LP_FAMILY, GEN12LP_RELEASE)
#endif
#ifdef SUPPORT_DG1
DEVICE_CONFIG(DG1, Dg1HwConfig, dg1DeviceIds, GEN12LP_FAMILY, GEN12LP_RELEASE)
#endif
#ifdef SUPPORT_RKL
DEVICE_CONFIG(RKL, RklHwConfig, rklDeviceIds, GEN12LP_FAMILY, GEN12LP_RELEASE)
#endif
#ifdef SUPPORT_ADLS
DEVICE_CONFIG(ADL_S, AdlsHwConfig, adlsDeviceIds, GEN12LP_FAMILY, GEN12LP_RELEASE)
#endif
#ifdef SUPPORT_ADLP
DEVICE_CONFIG(ADL_P, AdlpHwConfig, adlpDeviceIds, GEN12LP_FAMILY, GEN12LP_RELEASE)
#endif
#ifdef SUPPORT_ADLN
DEVICE_CONFIG(ADL_N, AdlnHwConfig, adlnDeviceIds, GEN12LP_FAMILY, GEN12LP_RELEASE)
#endif
#endif

#ifdef SUPPORT_GEN11
#ifdef SUPPORT_ICLLP
DEVICE_CONFIG(ICL, IcllpHw1x8x8, icllpDeviceIds, GEN11_FAMILY, GEN11_RELEASE)
#endif
#ifdef SUPPORT_EHL
DEVICE_CONFIG(EHL, EhlHwConfig, ehlDeviceIds, GEN11_FAMILY, GEN11_RELEASE)
#endif
#ifdef SUPPORT_LKF
DEVICE_CONFIG(LKF, LkfHw1x8x8, lkfDeviceIds, GEN11_FAMILY, GEN11_RELEASE)
#endif
#endif

#ifdef SUPPORT_GEN9
#ifdef SUPPORT_SKL
DEVICE_CONFIG(SKL, SklHw1x3x8, sklDeviceIds, GEN9_FAMILY, GEN9_RELEASE)
#endif
#ifdef SUPPORT_KBL
DEVICE_CONFIG(KBL, KblHw1x3x6, kblDeviceIds, GEN9_FAMILY, GEN9_RELEASE)
DEVICE_CONFIG(AML, KblHw1x3x6, amlDeviceIds, GEN9_FAMILY, GEN9_RELEASE)
#endif
#ifdef SUPPORT_CFL
DEVICE_CONFIG(CFL, CflHw1x3x6, cflDeviceIds, GEN9_FAMILY, GEN9_RELEASE)
DEVICE_CONFIG(CML, CflHw1x3x6, cmlDeviceIds, GEN9_FAMILY, GEN9_RELEASE)
DEVICE_CONFIG(WHL, CflHw1x3x6, whlDeviceIds, GEN9_FAMILY, GEN9_RELEASE)
#endif
#ifdef SUPPORT_GLK
DEVICE_CONFIG(GLK, GlkHw1x3x6, glkDeviceIds, GEN9_FAMILY, GEN9_RELEASE)
#endif
#ifdef SUPPORT_BXT
DEVICE_CONFIG(APL, BxtHw1x3x6, bxtDeviceIds, GEN9_FAMILY, GEN9_RELEASE)
#endif
#endif

#ifdef SUPPORT_GEN8
DEVICE_CONFIG(BDW, BdwHw1x3x8, bdwDeviceIds, GEN8_FAMILY, GEN8_RELEASE)
#endif
