{- This module was generated from data in the Kate syntax
   highlighting file gnuassembler.xml, version 1.10, by John Zaitseff (J.Zaitseff@zap.org.au), Roland Pabel (roland@pabel.name), Miquel Sabaté (mikisabate@gmail.com) -}

module Text.Highlighting.Kate.Syntax.Gnuassembler
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "GNU Assembler"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.s;*.S"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("GNU Assembler","Normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("GNU Assembler","Normal") -> return ()
      ("GNU Assembler","Commentar 1") -> return ()
      ("GNU Assembler","Commentar 2") -> (popContext) >> pEndLine
      ("GNU Assembler","String") -> (popContext) >> pEndLine
      ("GNU Assembler","Preprocessor") -> (popContext) >> pEndLine
      ("GNU Assembler","Define") -> (popContext) >> pEndLine
      ("GNU Assembler","Some Context") -> (popContext) >> pEndLine
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_keywords = Set.fromList $ words $ ".abort .align .app-file .appline .ascii .asciz .att_syntax .balign .balignl .balignw .byte .code16 .code32 .comm .common.s .common .data .dc.b .dc.d .dc.l .dc.s .dc.w .dc.x .dc .dcb.b .dcb.d .dcb.l .dcb.s .dcb.w .dcb.x .dcb .debug .def .desc .dim .double .ds.b .ds.d .ds.l .ds.p .ds.s .ds.w .ds.x .ds .dsect .eject .else .elsec .elseif .end .endc .endef .endfunc .endif .endm .endr .equ .equiv .err .exitm .extend .extern .fail .file .fill .float .format .func .global .globl .hidden .hword .ident .if .ifc .ifdef .ifeq .ifeqs .ifge .ifgt .ifle .iflt .ifnc .ifndef .ifne .ifnes .ifnotdef .include .int .intel_syntax .internal .irep .irepc .irp .irpc .lcomm .lflags .line .linkonce .list .llen .ln .long .lsym .macro .mexit .name .noformat .nolist .nopage noprefix .octa .offset .org .p2align .p2alignl .p2alignw .page .plen .popsection .previous .print .protected .psize .purgem .pushsection .quad .rodata .rep .rept .rva .sbttl .scl .sect.s .sect .section.s .section .set .short .single .size .skip .sleb128 .space .spc .stabd .stabn .stabs .string .struct .subsection .symver .tag .text .title .ttl .type .uleb128 .use .val .version .vtable_entry .vtable_inherit .weak .word .xcom .xdef .xref .xstabs .zero .arm .bss .code .even .force_thumb .ldouble .loc .ltorg .packed .pool .req .thumb .thumb_func .thumb_set"

regex_'5b'5f'5cw'5cd'2d'5d'2a'5cs'2a'3a = compileRegex True "[_\\w\\d-]*\\s*:"
regex_0'5bbB'5d'5b01'5d'2b = compileRegex True "0[bB][01]+"
regex_0'5bfFeEdD'5d'5b'2d'2b'5d'3f'5b0'2d9'5d'2a'5c'2e'3f'5b0'2d9'5d'2a'5beE'5d'3f'5b'2d'2b'5d'3f'5b0'2d9'5d'2b = compileRegex True "0[fFeEdD][-+]?[0-9]*\\.?[0-9]*[eE]?[-+]?[0-9]+"
regex_'5bA'2dZa'2dz'5f'2e'24'5d'5bA'2dZa'2dz0'2d9'5f'2e'24'5d'2a = compileRegex True "[A-Za-z_.$][A-Za-z0-9_.$]*"
regex_'27'28'5c'5cx'5b0'2d9a'2dfA'2dF'5d'5b0'2d9a'2dfA'2dF'5d'3f'7c'5c'5c'5b0'2d7'5d'3f'5b0'2d7'5d'3f'5b0'2d7'5d'3f'7c'5c'5c'2e'7c'2e'29 = compileRegex True "'(\\\\x[0-9a-fA-F][0-9a-fA-F]?|\\\\[0-7]?[0-7]?[0-7]?|\\\\.|.)"
regex_'23'5cs'2aif'28'3f'3adef'7cndef'29'3f'28'3f'3d'5cs'2b'5cS'29 = compileRegex True "#\\s*if(?:def|ndef)?(?=\\s+\\S)"
regex_'23'5cs'2aendif = compileRegex True "#\\s*endif"
regex_'23'5cs'2adefine'2e'2a'28'28'3f'3d'5c'5c'29'29 = compileRegex True "#\\s*define.*((?=\\\\))"
regex_'23'5cs'2a'28'3f'3ael'28'3f'3ase'7cif'29'7cinclude'28'3f'3a'5fnext'29'3f'7cdefine'7cundef'7cline'7cerror'7cwarning'7cpragma'29 = compileRegex True "#\\s*(?:el(?:se|if)|include(?:_next)?|define|undef|line|error|warning|pragma)"

parseRules ("GNU Assembler","Normal") =
  (((pRegExpr regex_'5b'5f'5cw'5cd'2d'5d'2a'5cs'2a'3a >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pHlCOct >>= withAttribute BaseNTok))
   <|>
   ((pHlCHex >>= withAttribute BaseNTok))
   <|>
   ((pRegExpr regex_0'5bbB'5d'5b01'5d'2b >>= withAttribute BaseNTok))
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_0'5bfFeEdD'5d'5b'2d'2b'5d'3f'5b0'2d9'5d'2a'5c'2e'3f'5b0'2d9'5d'2a'5beE'5d'3f'5b'2d'2b'5d'3f'5b0'2d9'5d'2b >>= withAttribute FloatTok))
   <|>
   ((pRegExpr regex_'5bA'2dZa'2dz'5f'2e'24'5d'5bA'2dZa'2dz0'2d9'5f'2e'24'5d'2a >>= withAttribute NormalTok))
   <|>
   ((pHlCChar >>= withAttribute CharTok))
   <|>
   ((pRegExpr regex_'27'28'5c'5cx'5b0'2d9a'2dfA'2dF'5d'5b0'2d9a'2dfA'2dF'5d'3f'7c'5c'5c'5b0'2d7'5d'3f'5b0'2d7'5d'3f'5b0'2d7'5d'3f'7c'5c'5c'2e'7c'2e'29 >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("GNU Assembler","String"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aif'28'3f'3adef'7cndef'29'3f'28'3f'3d'5cs'2b'5cS'29 >>= withAttribute OtherTok) >>~ pushContext ("GNU Assembler","Preprocessor"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aendif >>= withAttribute OtherTok) >>~ pushContext ("GNU Assembler","Preprocessor"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2adefine'2e'2a'28'28'3f'3d'5c'5c'29'29 >>= withAttribute OtherTok) >>~ pushContext ("GNU Assembler","Define"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2a'28'3f'3ael'28'3f'3ase'7cif'29'7cinclude'28'3f'3a'5fnext'29'3f'7cdefine'7cundef'7cline'7cerror'7cwarning'7cpragma'29 >>= withAttribute OtherTok) >>~ pushContext ("GNU Assembler","Preprocessor"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("GNU Assembler","Commentar 1"))
   <|>
   ((pAnyChar "@;#" >>= withAttribute CommentTok) >>~ pushContext ("GNU Assembler","Commentar 2"))
   <|>
   ((pAnyChar "!#%&*()+,-<=>?/:[]^{|}~" >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("GNU Assembler","Normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("GNU Assembler","Commentar 1") =
  (((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("GNU Assembler","Commentar 1")) >> pDefault >>= withAttribute CommentTok))

parseRules ("GNU Assembler","Commentar 2") =
  (((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("GNU Assembler","Commentar 2")) >> pDefault >>= withAttribute CommentTok))

parseRules ("GNU Assembler","String") =
  (((pLineContinue >>= withAttribute StringTok) >>~ pushContext ("GNU Assembler","Some Context"))
   <|>
   ((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("GNU Assembler","String")) >> pDefault >>= withAttribute StringTok))

parseRules ("GNU Assembler","Preprocessor") =
  (currentContext >>= \x -> guard (x == ("GNU Assembler","Preprocessor")) >> pDefault >>= withAttribute OtherTok)

parseRules ("GNU Assembler","Define") =
  (((pLineContinue >>= withAttribute OtherTok))
   <|>
   (currentContext >>= \x -> guard (x == ("GNU Assembler","Define")) >> pDefault >>= withAttribute OtherTok))

parseRules ("GNU Assembler","Some Context") =
  (currentContext >>= \x -> guard (x == ("GNU Assembler","Some Context")) >> pDefault >>= withAttribute NormalTok)

parseRules ("Alerts", _) = Text.Highlighting.Kate.Syntax.Alert.parseExpression Nothing

parseRules x = parseRules ("GNU Assembler","Normal") <|> fail ("Unknown context" ++ show x)
