// Code generated by protoc-gen-go. DO NOT EDIT.
// source: tests.proto

package google_cloud_conformance_firestore_v1

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	v1 "google.golang.org/genproto/googleapis/firestore/v1"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type DocChange_Kind int32

const (
	DocChange_KIND_UNSPECIFIED DocChange_Kind = 0
	DocChange_ADDED            DocChange_Kind = 1
	DocChange_REMOVED          DocChange_Kind = 2
	DocChange_MODIFIED         DocChange_Kind = 3
)

var DocChange_Kind_name = map[int32]string{
	0: "KIND_UNSPECIFIED",
	1: "ADDED",
	2: "REMOVED",
	3: "MODIFIED",
}

var DocChange_Kind_value = map[string]int32{
	"KIND_UNSPECIFIED": 0,
	"ADDED":            1,
	"REMOVED":          2,
	"MODIFIED":         3,
}

func (x DocChange_Kind) String() string {
	return proto.EnumName(DocChange_Kind_name, int32(x))
}

func (DocChange_Kind) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e49b496f4919bda1, []int{19, 0}
}

// A collection of tests.
type TestFile struct {
	Tests                []*Test  `protobuf:"bytes,1,rep,name=tests,proto3" json:"tests,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestFile) Reset()         { *m = TestFile{} }
func (m *TestFile) String() string { return proto.CompactTextString(m) }
func (*TestFile) ProtoMessage()    {}
func (*TestFile) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49b496f4919bda1, []int{0}
}

func (m *TestFile) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestFile.Unmarshal(m, b)
}
func (m *TestFile) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestFile.Marshal(b, m, deterministic)
}
func (m *TestFile) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestFile.Merge(m, src)
}
func (m *TestFile) XXX_Size() int {
	return xxx_messageInfo_TestFile.Size(m)
}
func (m *TestFile) XXX_DiscardUnknown() {
	xxx_messageInfo_TestFile.DiscardUnknown(m)
}

var xxx_messageInfo_TestFile proto.InternalMessageInfo

func (m *TestFile) GetTests() []*Test {
	if m != nil {
		return m.Tests
	}
	return nil
}

// A Test describes a single client method call and its expected result.
type Test struct {
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	Comment     string `protobuf:"bytes,10,opt,name=comment,proto3" json:"comment,omitempty"`
	// Types that are valid to be assigned to Test:
	//	*Test_Get
	//	*Test_Create
	//	*Test_Set
	//	*Test_Update
	//	*Test_UpdatePaths
	//	*Test_Delete
	//	*Test_Query
	//	*Test_Listen
	Test                 isTest_Test `protobuf_oneof:"test"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *Test) Reset()         { *m = Test{} }
func (m *Test) String() string { return proto.CompactTextString(m) }
func (*Test) ProtoMessage()    {}
func (*Test) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49b496f4919bda1, []int{1}
}

func (m *Test) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Test.Unmarshal(m, b)
}
func (m *Test) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Test.Marshal(b, m, deterministic)
}
func (m *Test) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Test.Merge(m, src)
}
func (m *Test) XXX_Size() int {
	return xxx_messageInfo_Test.Size(m)
}
func (m *Test) XXX_DiscardUnknown() {
	xxx_messageInfo_Test.DiscardUnknown(m)
}

var xxx_messageInfo_Test proto.InternalMessageInfo

func (m *Test) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Test) GetComment() string {
	if m != nil {
		return m.Comment
	}
	return ""
}

type isTest_Test interface {
	isTest_Test()
}

type Test_Get struct {
	Get *GetTest `protobuf:"bytes,2,opt,name=get,proto3,oneof"`
}

type Test_Create struct {
	Create *CreateTest `protobuf:"bytes,3,opt,name=create,proto3,oneof"`
}

type Test_Set struct {
	Set *SetTest `protobuf:"bytes,4,opt,name=set,proto3,oneof"`
}

type Test_Update struct {
	Update *UpdateTest `protobuf:"bytes,5,opt,name=update,proto3,oneof"`
}

type Test_UpdatePaths struct {
	UpdatePaths *UpdatePathsTest `protobuf:"bytes,6,opt,name=update_paths,json=updatePaths,proto3,oneof"`
}

type Test_Delete struct {
	Delete *DeleteTest `protobuf:"bytes,7,opt,name=delete,proto3,oneof"`
}

type Test_Query struct {
	Query *QueryTest `protobuf:"bytes,8,opt,name=query,proto3,oneof"`
}

type Test_Listen struct {
	Listen *ListenTest `protobuf:"bytes,9,opt,name=listen,proto3,oneof"`
}

func (*Test_Get) isTest_Test() {}

func (*Test_Create) isTest_Test() {}

func (*Test_Set) isTest_Test() {}

func (*Test_Update) isTest_Test() {}

func (*Test_UpdatePaths) isTest_Test() {}

func (*Test_Delete) isTest_Test() {}

func (*Test_Query) isTest_Test() {}

func (*Test_Listen) isTest_Test() {}

func (m *Test) GetTest() isTest_Test {
	if m != nil {
		return m.Test
	}
	return nil
}

func (m *Test) GetGet() *GetTest {
	if x, ok := m.GetTest().(*Test_Get); ok {
		return x.Get
	}
	return nil
}

func (m *Test) GetCreate() *CreateTest {
	if x, ok := m.GetTest().(*Test_Create); ok {
		return x.Create
	}
	return nil
}

func (m *Test) GetSet() *SetTest {
	if x, ok := m.GetTest().(*Test_Set); ok {
		return x.Set
	}
	return nil
}

func (m *Test) GetUpdate() *UpdateTest {
	if x, ok := m.GetTest().(*Test_Update); ok {
		return x.Update
	}
	return nil
}

func (m *Test) GetUpdatePaths() *UpdatePathsTest {
	if x, ok := m.GetTest().(*Test_UpdatePaths); ok {
		return x.UpdatePaths
	}
	return nil
}

func (m *Test) GetDelete() *DeleteTest {
	if x, ok := m.GetTest().(*Test_Delete); ok {
		return x.Delete
	}
	return nil
}

func (m *Test) GetQuery() *QueryTest {
	if x, ok := m.GetTest().(*Test_Query); ok {
		return x.Query
	}
	return nil
}

func (m *Test) GetListen() *ListenTest {
	if x, ok := m.GetTest().(*Test_Listen); ok {
		return x.Listen
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Test) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Test_Get)(nil),
		(*Test_Create)(nil),
		(*Test_Set)(nil),
		(*Test_Update)(nil),
		(*Test_UpdatePaths)(nil),
		(*Test_Delete)(nil),
		(*Test_Query)(nil),
		(*Test_Listen)(nil),
	}
}

// Call to the DocumentRef.Get method.
type GetTest struct {
	// The path of the doc, e.g. "projects/projectID/databases/(default)/documents/C/d"
	DocRefPath string `protobuf:"bytes,1,opt,name=doc_ref_path,json=docRefPath,proto3" json:"doc_ref_path,omitempty"`
	// The request that the call should send to the Firestore service.
	Request              *v1.GetDocumentRequest `protobuf:"bytes,2,opt,name=request,proto3" json:"request,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *GetTest) Reset()         { *m = GetTest{} }
func (m *GetTest) String() string { return proto.CompactTextString(m) }
func (*GetTest) ProtoMessage()    {}
func (*GetTest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49b496f4919bda1, []int{2}
}

func (m *GetTest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetTest.Unmarshal(m, b)
}
func (m *GetTest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetTest.Marshal(b, m, deterministic)
}
func (m *GetTest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetTest.Merge(m, src)
}
func (m *GetTest) XXX_Size() int {
	return xxx_messageInfo_GetTest.Size(m)
}
func (m *GetTest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetTest.DiscardUnknown(m)
}

var xxx_messageInfo_GetTest proto.InternalMessageInfo

func (m *GetTest) GetDocRefPath() string {
	if m != nil {
		return m.DocRefPath
	}
	return ""
}

func (m *GetTest) GetRequest() *v1.GetDocumentRequest {
	if m != nil {
		return m.Request
	}
	return nil
}

// Call to DocumentRef.Create.
type CreateTest struct {
	// The path of the doc, e.g. "projects/projectID/databases/(default)/documents/C/d"
	DocRefPath string `protobuf:"bytes,1,opt,name=doc_ref_path,json=docRefPath,proto3" json:"doc_ref_path,omitempty"`
	// The data passed to Create, as JSON. The strings "Delete" and "ServerTimestamp"
	// denote the two special sentinel values. Values that could be interpreted as integers
	// (i.e. digit strings) should be treated as integers.
	JsonData string `protobuf:"bytes,2,opt,name=json_data,json=jsonData,proto3" json:"json_data,omitempty"`
	// The request that the call should generate.
	Request *v1.CommitRequest `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
	// If true, the call should result in an error without generating a request.
	// If this is true, request should not be set.
	IsError              bool     `protobuf:"varint,4,opt,name=is_error,json=isError,proto3" json:"is_error,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateTest) Reset()         { *m = CreateTest{} }
func (m *CreateTest) String() string { return proto.CompactTextString(m) }
func (*CreateTest) ProtoMessage()    {}
func (*CreateTest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49b496f4919bda1, []int{3}
}

func (m *CreateTest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTest.Unmarshal(m, b)
}
func (m *CreateTest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTest.Marshal(b, m, deterministic)
}
func (m *CreateTest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTest.Merge(m, src)
}
func (m *CreateTest) XXX_Size() int {
	return xxx_messageInfo_CreateTest.Size(m)
}
func (m *CreateTest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTest proto.InternalMessageInfo

func (m *CreateTest) GetDocRefPath() string {
	if m != nil {
		return m.DocRefPath
	}
	return ""
}

func (m *CreateTest) GetJsonData() string {
	if m != nil {
		return m.JsonData
	}
	return ""
}

func (m *CreateTest) GetRequest() *v1.CommitRequest {
	if m != nil {
		return m.Request
	}
	return nil
}

func (m *CreateTest) GetIsError() bool {
	if m != nil {
		return m.IsError
	}
	return false
}

// A call to DocumentRef.Set.
type SetTest struct {
	DocRefPath           string            `protobuf:"bytes,1,opt,name=doc_ref_path,json=docRefPath,proto3" json:"doc_ref_path,omitempty"`
	Option               *SetOption        `protobuf:"bytes,2,opt,name=option,proto3" json:"option,omitempty"`
	JsonData             string            `protobuf:"bytes,3,opt,name=json_data,json=jsonData,proto3" json:"json_data,omitempty"`
	Request              *v1.CommitRequest `protobuf:"bytes,4,opt,name=request,proto3" json:"request,omitempty"`
	IsError              bool              `protobuf:"varint,5,opt,name=is_error,json=isError,proto3" json:"is_error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *SetTest) Reset()         { *m = SetTest{} }
func (m *SetTest) String() string { return proto.CompactTextString(m) }
func (*SetTest) ProtoMessage()    {}
func (*SetTest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49b496f4919bda1, []int{4}
}

func (m *SetTest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetTest.Unmarshal(m, b)
}
func (m *SetTest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetTest.Marshal(b, m, deterministic)
}
func (m *SetTest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetTest.Merge(m, src)
}
func (m *SetTest) XXX_Size() int {
	return xxx_messageInfo_SetTest.Size(m)
}
func (m *SetTest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetTest.DiscardUnknown(m)
}

var xxx_messageInfo_SetTest proto.InternalMessageInfo

func (m *SetTest) GetDocRefPath() string {
	if m != nil {
		return m.DocRefPath
	}
	return ""
}

func (m *SetTest) GetOption() *SetOption {
	if m != nil {
		return m.Option
	}
	return nil
}

func (m *SetTest) GetJsonData() string {
	if m != nil {
		return m.JsonData
	}
	return ""
}

func (m *SetTest) GetRequest() *v1.CommitRequest {
	if m != nil {
		return m.Request
	}
	return nil
}

func (m *SetTest) GetIsError() bool {
	if m != nil {
		return m.IsError
	}
	return false
}

// A call to the form of DocumentRef.Update that represents the data as a map
// or dictionary.
type UpdateTest struct {
	DocRefPath           string            `protobuf:"bytes,1,opt,name=doc_ref_path,json=docRefPath,proto3" json:"doc_ref_path,omitempty"`
	Precondition         *v1.Precondition  `protobuf:"bytes,2,opt,name=precondition,proto3" json:"precondition,omitempty"`
	JsonData             string            `protobuf:"bytes,3,opt,name=json_data,json=jsonData,proto3" json:"json_data,omitempty"`
	Request              *v1.CommitRequest `protobuf:"bytes,4,opt,name=request,proto3" json:"request,omitempty"`
	IsError              bool              `protobuf:"varint,5,opt,name=is_error,json=isError,proto3" json:"is_error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *UpdateTest) Reset()         { *m = UpdateTest{} }
func (m *UpdateTest) String() string { return proto.CompactTextString(m) }
func (*UpdateTest) ProtoMessage()    {}
func (*UpdateTest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49b496f4919bda1, []int{5}
}

func (m *UpdateTest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateTest.Unmarshal(m, b)
}
func (m *UpdateTest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateTest.Marshal(b, m, deterministic)
}
func (m *UpdateTest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateTest.Merge(m, src)
}
func (m *UpdateTest) XXX_Size() int {
	return xxx_messageInfo_UpdateTest.Size(m)
}
func (m *UpdateTest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateTest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateTest proto.InternalMessageInfo

func (m *UpdateTest) GetDocRefPath() string {
	if m != nil {
		return m.DocRefPath
	}
	return ""
}

func (m *UpdateTest) GetPrecondition() *v1.Precondition {
	if m != nil {
		return m.Precondition
	}
	return nil
}

func (m *UpdateTest) GetJsonData() string {
	if m != nil {
		return m.JsonData
	}
	return ""
}

func (m *UpdateTest) GetRequest() *v1.CommitRequest {
	if m != nil {
		return m.Request
	}
	return nil
}

func (m *UpdateTest) GetIsError() bool {
	if m != nil {
		return m.IsError
	}
	return false
}

// A call to the form of DocumentRef.Update that represents the data as a list
// of field paths and their values.
type UpdatePathsTest struct {
	DocRefPath   string           `protobuf:"bytes,1,opt,name=doc_ref_path,json=docRefPath,proto3" json:"doc_ref_path,omitempty"`
	Precondition *v1.Precondition `protobuf:"bytes,2,opt,name=precondition,proto3" json:"precondition,omitempty"`
	// parallel sequences: field_paths[i] corresponds to json_values[i]
	FieldPaths           []*FieldPath      `protobuf:"bytes,3,rep,name=field_paths,json=fieldPaths,proto3" json:"field_paths,omitempty"`
	JsonValues           []string          `protobuf:"bytes,4,rep,name=json_values,json=jsonValues,proto3" json:"json_values,omitempty"`
	Request              *v1.CommitRequest `protobuf:"bytes,5,opt,name=request,proto3" json:"request,omitempty"`
	IsError              bool              `protobuf:"varint,6,opt,name=is_error,json=isError,proto3" json:"is_error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *UpdatePathsTest) Reset()         { *m = UpdatePathsTest{} }
func (m *UpdatePathsTest) String() string { return proto.CompactTextString(m) }
func (*UpdatePathsTest) ProtoMessage()    {}
func (*UpdatePathsTest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49b496f4919bda1, []int{6}
}

func (m *UpdatePathsTest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdatePathsTest.Unmarshal(m, b)
}
func (m *UpdatePathsTest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdatePathsTest.Marshal(b, m, deterministic)
}
func (m *UpdatePathsTest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdatePathsTest.Merge(m, src)
}
func (m *UpdatePathsTest) XXX_Size() int {
	return xxx_messageInfo_UpdatePathsTest.Size(m)
}
func (m *UpdatePathsTest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdatePathsTest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdatePathsTest proto.InternalMessageInfo

func (m *UpdatePathsTest) GetDocRefPath() string {
	if m != nil {
		return m.DocRefPath
	}
	return ""
}

func (m *UpdatePathsTest) GetPrecondition() *v1.Precondition {
	if m != nil {
		return m.Precondition
	}
	return nil
}

func (m *UpdatePathsTest) GetFieldPaths() []*FieldPath {
	if m != nil {
		return m.FieldPaths
	}
	return nil
}

func (m *UpdatePathsTest) GetJsonValues() []string {
	if m != nil {
		return m.JsonValues
	}
	return nil
}

func (m *UpdatePathsTest) GetRequest() *v1.CommitRequest {
	if m != nil {
		return m.Request
	}
	return nil
}

func (m *UpdatePathsTest) GetIsError() bool {
	if m != nil {
		return m.IsError
	}
	return false
}

// A call to DocmentRef.Delete
type DeleteTest struct {
	DocRefPath           string            `protobuf:"bytes,1,opt,name=doc_ref_path,json=docRefPath,proto3" json:"doc_ref_path,omitempty"`
	Precondition         *v1.Precondition  `protobuf:"bytes,2,opt,name=precondition,proto3" json:"precondition,omitempty"`
	Request              *v1.CommitRequest `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
	IsError              bool              `protobuf:"varint,4,opt,name=is_error,json=isError,proto3" json:"is_error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *DeleteTest) Reset()         { *m = DeleteTest{} }
func (m *DeleteTest) String() string { return proto.CompactTextString(m) }
func (*DeleteTest) ProtoMessage()    {}
func (*DeleteTest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49b496f4919bda1, []int{7}
}

func (m *DeleteTest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteTest.Unmarshal(m, b)
}
func (m *DeleteTest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteTest.Marshal(b, m, deterministic)
}
func (m *DeleteTest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteTest.Merge(m, src)
}
func (m *DeleteTest) XXX_Size() int {
	return xxx_messageInfo_DeleteTest.Size(m)
}
func (m *DeleteTest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteTest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteTest proto.InternalMessageInfo

func (m *DeleteTest) GetDocRefPath() string {
	if m != nil {
		return m.DocRefPath
	}
	return ""
}

func (m *DeleteTest) GetPrecondition() *v1.Precondition {
	if m != nil {
		return m.Precondition
	}
	return nil
}

func (m *DeleteTest) GetRequest() *v1.CommitRequest {
	if m != nil {
		return m.Request
	}
	return nil
}

func (m *DeleteTest) GetIsError() bool {
	if m != nil {
		return m.IsError
	}
	return false
}

// An option to the DocumentRef.Set call.
type SetOption struct {
	All                  bool         `protobuf:"varint,1,opt,name=all,proto3" json:"all,omitempty"`
	Fields               []*FieldPath `protobuf:"bytes,2,rep,name=fields,proto3" json:"fields,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *SetOption) Reset()         { *m = SetOption{} }
func (m *SetOption) String() string { return proto.CompactTextString(m) }
func (*SetOption) ProtoMessage()    {}
func (*SetOption) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49b496f4919bda1, []int{8}
}

func (m *SetOption) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetOption.Unmarshal(m, b)
}
func (m *SetOption) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetOption.Marshal(b, m, deterministic)
}
func (m *SetOption) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetOption.Merge(m, src)
}
func (m *SetOption) XXX_Size() int {
	return xxx_messageInfo_SetOption.Size(m)
}
func (m *SetOption) XXX_DiscardUnknown() {
	xxx_messageInfo_SetOption.DiscardUnknown(m)
}

var xxx_messageInfo_SetOption proto.InternalMessageInfo

func (m *SetOption) GetAll() bool {
	if m != nil {
		return m.All
	}
	return false
}

func (m *SetOption) GetFields() []*FieldPath {
	if m != nil {
		return m.Fields
	}
	return nil
}

type QueryTest struct {
	CollPath             string              `protobuf:"bytes,1,opt,name=coll_path,json=collPath,proto3" json:"coll_path,omitempty"`
	Clauses              []*Clause           `protobuf:"bytes,2,rep,name=clauses,proto3" json:"clauses,omitempty"`
	Query                *v1.StructuredQuery `protobuf:"bytes,3,opt,name=query,proto3" json:"query,omitempty"`
	IsError              bool                `protobuf:"varint,4,opt,name=is_error,json=isError,proto3" json:"is_error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *QueryTest) Reset()         { *m = QueryTest{} }
func (m *QueryTest) String() string { return proto.CompactTextString(m) }
func (*QueryTest) ProtoMessage()    {}
func (*QueryTest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49b496f4919bda1, []int{9}
}

func (m *QueryTest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryTest.Unmarshal(m, b)
}
func (m *QueryTest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryTest.Marshal(b, m, deterministic)
}
func (m *QueryTest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryTest.Merge(m, src)
}
func (m *QueryTest) XXX_Size() int {
	return xxx_messageInfo_QueryTest.Size(m)
}
func (m *QueryTest) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryTest.DiscardUnknown(m)
}

var xxx_messageInfo_QueryTest proto.InternalMessageInfo

func (m *QueryTest) GetCollPath() string {
	if m != nil {
		return m.CollPath
	}
	return ""
}

func (m *QueryTest) GetClauses() []*Clause {
	if m != nil {
		return m.Clauses
	}
	return nil
}

func (m *QueryTest) GetQuery() *v1.StructuredQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *QueryTest) GetIsError() bool {
	if m != nil {
		return m.IsError
	}
	return false
}

type Clause struct {
	// Types that are valid to be assigned to Clause:
	//	*Clause_Select
	//	*Clause_Where
	//	*Clause_OrderBy
	//	*Clause_Offset
	//	*Clause_Limit
	//	*Clause_StartAt
	//	*Clause_StartAfter
	//	*Clause_EndAt
	//	*Clause_EndBefore
	Clause               isClause_Clause `protobuf_oneof:"clause"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *Clause) Reset()         { *m = Clause{} }
func (m *Clause) String() string { return proto.CompactTextString(m) }
func (*Clause) ProtoMessage()    {}
func (*Clause) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49b496f4919bda1, []int{10}
}

func (m *Clause) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Clause.Unmarshal(m, b)
}
func (m *Clause) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Clause.Marshal(b, m, deterministic)
}
func (m *Clause) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Clause.Merge(m, src)
}
func (m *Clause) XXX_Size() int {
	return xxx_messageInfo_Clause.Size(m)
}
func (m *Clause) XXX_DiscardUnknown() {
	xxx_messageInfo_Clause.DiscardUnknown(m)
}

var xxx_messageInfo_Clause proto.InternalMessageInfo

type isClause_Clause interface {
	isClause_Clause()
}

type Clause_Select struct {
	Select *Select `protobuf:"bytes,1,opt,name=select,proto3,oneof"`
}

type Clause_Where struct {
	Where *Where `protobuf:"bytes,2,opt,name=where,proto3,oneof"`
}

type Clause_OrderBy struct {
	OrderBy *OrderBy `protobuf:"bytes,3,opt,name=order_by,json=orderBy,proto3,oneof"`
}

type Clause_Offset struct {
	Offset int32 `protobuf:"varint,4,opt,name=offset,proto3,oneof"`
}

type Clause_Limit struct {
	Limit int32 `protobuf:"varint,5,opt,name=limit,proto3,oneof"`
}

type Clause_StartAt struct {
	StartAt *Cursor `protobuf:"bytes,6,opt,name=start_at,json=startAt,proto3,oneof"`
}

type Clause_StartAfter struct {
	StartAfter *Cursor `protobuf:"bytes,7,opt,name=start_after,json=startAfter,proto3,oneof"`
}

type Clause_EndAt struct {
	EndAt *Cursor `protobuf:"bytes,8,opt,name=end_at,json=endAt,proto3,oneof"`
}

type Clause_EndBefore struct {
	EndBefore *Cursor `protobuf:"bytes,9,opt,name=end_before,json=endBefore,proto3,oneof"`
}

func (*Clause_Select) isClause_Clause() {}

func (*Clause_Where) isClause_Clause() {}

func (*Clause_OrderBy) isClause_Clause() {}

func (*Clause_Offset) isClause_Clause() {}

func (*Clause_Limit) isClause_Clause() {}

func (*Clause_StartAt) isClause_Clause() {}

func (*Clause_StartAfter) isClause_Clause() {}

func (*Clause_EndAt) isClause_Clause() {}

func (*Clause_EndBefore) isClause_Clause() {}

func (m *Clause) GetClause() isClause_Clause {
	if m != nil {
		return m.Clause
	}
	return nil
}

func (m *Clause) GetSelect() *Select {
	if x, ok := m.GetClause().(*Clause_Select); ok {
		return x.Select
	}
	return nil
}

func (m *Clause) GetWhere() *Where {
	if x, ok := m.GetClause().(*Clause_Where); ok {
		return x.Where
	}
	return nil
}

func (m *Clause) GetOrderBy() *OrderBy {
	if x, ok := m.GetClause().(*Clause_OrderBy); ok {
		return x.OrderBy
	}
	return nil
}

func (m *Clause) GetOffset() int32 {
	if x, ok := m.GetClause().(*Clause_Offset); ok {
		return x.Offset
	}
	return 0
}

func (m *Clause) GetLimit() int32 {
	if x, ok := m.GetClause().(*Clause_Limit); ok {
		return x.Limit
	}
	return 0
}

func (m *Clause) GetStartAt() *Cursor {
	if x, ok := m.GetClause().(*Clause_StartAt); ok {
		return x.StartAt
	}
	return nil
}

func (m *Clause) GetStartAfter() *Cursor {
	if x, ok := m.GetClause().(*Clause_StartAfter); ok {
		return x.StartAfter
	}
	return nil
}

func (m *Clause) GetEndAt() *Cursor {
	if x, ok := m.GetClause().(*Clause_EndAt); ok {
		return x.EndAt
	}
	return nil
}

func (m *Clause) GetEndBefore() *Cursor {
	if x, ok := m.GetClause().(*Clause_EndBefore); ok {
		return x.EndBefore
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Clause) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Clause_Select)(nil),
		(*Clause_Where)(nil),
		(*Clause_OrderBy)(nil),
		(*Clause_Offset)(nil),
		(*Clause_Limit)(nil),
		(*Clause_StartAt)(nil),
		(*Clause_StartAfter)(nil),
		(*Clause_EndAt)(nil),
		(*Clause_EndBefore)(nil),
	}
}

type Select struct {
	Fields               []*FieldPath `protobuf:"bytes,1,rep,name=fields,proto3" json:"fields,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Select) Reset()         { *m = Select{} }
func (m *Select) String() string { return proto.CompactTextString(m) }
func (*Select) ProtoMessage()    {}
func (*Select) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49b496f4919bda1, []int{11}
}

func (m *Select) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Select.Unmarshal(m, b)
}
func (m *Select) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Select.Marshal(b, m, deterministic)
}
func (m *Select) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Select.Merge(m, src)
}
func (m *Select) XXX_Size() int {
	return xxx_messageInfo_Select.Size(m)
}
func (m *Select) XXX_DiscardUnknown() {
	xxx_messageInfo_Select.DiscardUnknown(m)
}

var xxx_messageInfo_Select proto.InternalMessageInfo

func (m *Select) GetFields() []*FieldPath {
	if m != nil {
		return m.Fields
	}
	return nil
}

type Where struct {
	Path                 *FieldPath `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	Op                   string     `protobuf:"bytes,2,opt,name=op,proto3" json:"op,omitempty"`
	JsonValue            string     `protobuf:"bytes,3,opt,name=json_value,json=jsonValue,proto3" json:"json_value,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Where) Reset()         { *m = Where{} }
func (m *Where) String() string { return proto.CompactTextString(m) }
func (*Where) ProtoMessage()    {}
func (*Where) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49b496f4919bda1, []int{12}
}

func (m *Where) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Where.Unmarshal(m, b)
}
func (m *Where) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Where.Marshal(b, m, deterministic)
}
func (m *Where) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Where.Merge(m, src)
}
func (m *Where) XXX_Size() int {
	return xxx_messageInfo_Where.Size(m)
}
func (m *Where) XXX_DiscardUnknown() {
	xxx_messageInfo_Where.DiscardUnknown(m)
}

var xxx_messageInfo_Where proto.InternalMessageInfo

func (m *Where) GetPath() *FieldPath {
	if m != nil {
		return m.Path
	}
	return nil
}

func (m *Where) GetOp() string {
	if m != nil {
		return m.Op
	}
	return ""
}

func (m *Where) GetJsonValue() string {
	if m != nil {
		return m.JsonValue
	}
	return ""
}

type OrderBy struct {
	Path                 *FieldPath `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	Direction            string     `protobuf:"bytes,2,opt,name=direction,proto3" json:"direction,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *OrderBy) Reset()         { *m = OrderBy{} }
func (m *OrderBy) String() string { return proto.CompactTextString(m) }
func (*OrderBy) ProtoMessage()    {}
func (*OrderBy) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49b496f4919bda1, []int{13}
}

func (m *OrderBy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OrderBy.Unmarshal(m, b)
}
func (m *OrderBy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OrderBy.Marshal(b, m, deterministic)
}
func (m *OrderBy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OrderBy.Merge(m, src)
}
func (m *OrderBy) XXX_Size() int {
	return xxx_messageInfo_OrderBy.Size(m)
}
func (m *OrderBy) XXX_DiscardUnknown() {
	xxx_messageInfo_OrderBy.DiscardUnknown(m)
}

var xxx_messageInfo_OrderBy proto.InternalMessageInfo

func (m *OrderBy) GetPath() *FieldPath {
	if m != nil {
		return m.Path
	}
	return nil
}

func (m *OrderBy) GetDirection() string {
	if m != nil {
		return m.Direction
	}
	return ""
}

type Cursor struct {
	// one of:
	DocSnapshot          *DocSnapshot `protobuf:"bytes,1,opt,name=doc_snapshot,json=docSnapshot,proto3" json:"doc_snapshot,omitempty"`
	JsonValues           []string     `protobuf:"bytes,2,rep,name=json_values,json=jsonValues,proto3" json:"json_values,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Cursor) Reset()         { *m = Cursor{} }
func (m *Cursor) String() string { return proto.CompactTextString(m) }
func (*Cursor) ProtoMessage()    {}
func (*Cursor) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49b496f4919bda1, []int{14}
}

func (m *Cursor) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Cursor.Unmarshal(m, b)
}
func (m *Cursor) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Cursor.Marshal(b, m, deterministic)
}
func (m *Cursor) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cursor.Merge(m, src)
}
func (m *Cursor) XXX_Size() int {
	return xxx_messageInfo_Cursor.Size(m)
}
func (m *Cursor) XXX_DiscardUnknown() {
	xxx_messageInfo_Cursor.DiscardUnknown(m)
}

var xxx_messageInfo_Cursor proto.InternalMessageInfo

func (m *Cursor) GetDocSnapshot() *DocSnapshot {
	if m != nil {
		return m.DocSnapshot
	}
	return nil
}

func (m *Cursor) GetJsonValues() []string {
	if m != nil {
		return m.JsonValues
	}
	return nil
}

type DocSnapshot struct {
	Path                 string   `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	JsonData             string   `protobuf:"bytes,2,opt,name=json_data,json=jsonData,proto3" json:"json_data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DocSnapshot) Reset()         { *m = DocSnapshot{} }
func (m *DocSnapshot) String() string { return proto.CompactTextString(m) }
func (*DocSnapshot) ProtoMessage()    {}
func (*DocSnapshot) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49b496f4919bda1, []int{15}
}

func (m *DocSnapshot) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DocSnapshot.Unmarshal(m, b)
}
func (m *DocSnapshot) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DocSnapshot.Marshal(b, m, deterministic)
}
func (m *DocSnapshot) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DocSnapshot.Merge(m, src)
}
func (m *DocSnapshot) XXX_Size() int {
	return xxx_messageInfo_DocSnapshot.Size(m)
}
func (m *DocSnapshot) XXX_DiscardUnknown() {
	xxx_messageInfo_DocSnapshot.DiscardUnknown(m)
}

var xxx_messageInfo_DocSnapshot proto.InternalMessageInfo

func (m *DocSnapshot) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *DocSnapshot) GetJsonData() string {
	if m != nil {
		return m.JsonData
	}
	return ""
}

type FieldPath struct {
	Field                []string `protobuf:"bytes,1,rep,name=field,proto3" json:"field,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FieldPath) Reset()         { *m = FieldPath{} }
func (m *FieldPath) String() string { return proto.CompactTextString(m) }
func (*FieldPath) ProtoMessage()    {}
func (*FieldPath) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49b496f4919bda1, []int{16}
}

func (m *FieldPath) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FieldPath.Unmarshal(m, b)
}
func (m *FieldPath) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FieldPath.Marshal(b, m, deterministic)
}
func (m *FieldPath) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FieldPath.Merge(m, src)
}
func (m *FieldPath) XXX_Size() int {
	return xxx_messageInfo_FieldPath.Size(m)
}
func (m *FieldPath) XXX_DiscardUnknown() {
	xxx_messageInfo_FieldPath.DiscardUnknown(m)
}

var xxx_messageInfo_FieldPath proto.InternalMessageInfo

func (m *FieldPath) GetField() []string {
	if m != nil {
		return m.Field
	}
	return nil
}

// A test of the Listen streaming RPC (a.k.a. FireStore watch).
// If the sequence of responses is provided to the implementation,
// it should produce the sequence of snapshots.
// If is_error is true, an error should occur after the snapshots.
//
// The tests assume that the query is
// Collection("projects/projectID/databases/(default)/documents/C").OrderBy("a", Ascending)
//
// The watch target ID used in these tests is 1. Test interpreters
// should either change their client's ID for testing,
// or change the ID in the tests before running them.
type ListenTest struct {
	Responses            []*v1.ListenResponse `protobuf:"bytes,1,rep,name=responses,proto3" json:"responses,omitempty"`
	Snapshots            []*Snapshot          `protobuf:"bytes,2,rep,name=snapshots,proto3" json:"snapshots,omitempty"`
	IsError              bool                 `protobuf:"varint,3,opt,name=is_error,json=isError,proto3" json:"is_error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ListenTest) Reset()         { *m = ListenTest{} }
func (m *ListenTest) String() string { return proto.CompactTextString(m) }
func (*ListenTest) ProtoMessage()    {}
func (*ListenTest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49b496f4919bda1, []int{17}
}

func (m *ListenTest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListenTest.Unmarshal(m, b)
}
func (m *ListenTest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListenTest.Marshal(b, m, deterministic)
}
func (m *ListenTest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListenTest.Merge(m, src)
}
func (m *ListenTest) XXX_Size() int {
	return xxx_messageInfo_ListenTest.Size(m)
}
func (m *ListenTest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListenTest.DiscardUnknown(m)
}

var xxx_messageInfo_ListenTest proto.InternalMessageInfo

func (m *ListenTest) GetResponses() []*v1.ListenResponse {
	if m != nil {
		return m.Responses
	}
	return nil
}

func (m *ListenTest) GetSnapshots() []*Snapshot {
	if m != nil {
		return m.Snapshots
	}
	return nil
}

func (m *ListenTest) GetIsError() bool {
	if m != nil {
		return m.IsError
	}
	return false
}

type Snapshot struct {
	Docs                 []*v1.Document       `protobuf:"bytes,1,rep,name=docs,proto3" json:"docs,omitempty"`
	Changes              []*DocChange         `protobuf:"bytes,2,rep,name=changes,proto3" json:"changes,omitempty"`
	ReadTime             *timestamp.Timestamp `protobuf:"bytes,3,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Snapshot) Reset()         { *m = Snapshot{} }
func (m *Snapshot) String() string { return proto.CompactTextString(m) }
func (*Snapshot) ProtoMessage()    {}
func (*Snapshot) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49b496f4919bda1, []int{18}
}

func (m *Snapshot) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Snapshot.Unmarshal(m, b)
}
func (m *Snapshot) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Snapshot.Marshal(b, m, deterministic)
}
func (m *Snapshot) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Snapshot.Merge(m, src)
}
func (m *Snapshot) XXX_Size() int {
	return xxx_messageInfo_Snapshot.Size(m)
}
func (m *Snapshot) XXX_DiscardUnknown() {
	xxx_messageInfo_Snapshot.DiscardUnknown(m)
}

var xxx_messageInfo_Snapshot proto.InternalMessageInfo

func (m *Snapshot) GetDocs() []*v1.Document {
	if m != nil {
		return m.Docs
	}
	return nil
}

func (m *Snapshot) GetChanges() []*DocChange {
	if m != nil {
		return m.Changes
	}
	return nil
}

func (m *Snapshot) GetReadTime() *timestamp.Timestamp {
	if m != nil {
		return m.ReadTime
	}
	return nil
}

type DocChange struct {
	Kind                 DocChange_Kind `protobuf:"varint,1,opt,name=kind,proto3,enum=google.cloud.conformance.firestore.v1.DocChange_Kind" json:"kind,omitempty"`
	Doc                  *v1.Document   `protobuf:"bytes,2,opt,name=doc,proto3" json:"doc,omitempty"`
	OldIndex             int32          `protobuf:"varint,3,opt,name=old_index,json=oldIndex,proto3" json:"old_index,omitempty"`
	NewIndex             int32          `protobuf:"varint,4,opt,name=new_index,json=newIndex,proto3" json:"new_index,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *DocChange) Reset()         { *m = DocChange{} }
func (m *DocChange) String() string { return proto.CompactTextString(m) }
func (*DocChange) ProtoMessage()    {}
func (*DocChange) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49b496f4919bda1, []int{19}
}

func (m *DocChange) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DocChange.Unmarshal(m, b)
}
func (m *DocChange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DocChange.Marshal(b, m, deterministic)
}
func (m *DocChange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DocChange.Merge(m, src)
}
func (m *DocChange) XXX_Size() int {
	return xxx_messageInfo_DocChange.Size(m)
}
func (m *DocChange) XXX_DiscardUnknown() {
	xxx_messageInfo_DocChange.DiscardUnknown(m)
}

var xxx_messageInfo_DocChange proto.InternalMessageInfo

func (m *DocChange) GetKind() DocChange_Kind {
	if m != nil {
		return m.Kind
	}
	return DocChange_KIND_UNSPECIFIED
}

func (m *DocChange) GetDoc() *v1.Document {
	if m != nil {
		return m.Doc
	}
	return nil
}

func (m *DocChange) GetOldIndex() int32 {
	if m != nil {
		return m.OldIndex
	}
	return 0
}

func (m *DocChange) GetNewIndex() int32 {
	if m != nil {
		return m.NewIndex
	}
	return 0
}

func init() {
	proto.RegisterEnum("google.cloud.conformance.firestore.v1.DocChange_Kind", DocChange_Kind_name, DocChange_Kind_value)
	proto.RegisterType((*TestFile)(nil), "google.cloud.conformance.firestore.v1.TestFile")
	proto.RegisterType((*Test)(nil), "google.cloud.conformance.firestore.v1.Test")
	proto.RegisterType((*GetTest)(nil), "google.cloud.conformance.firestore.v1.GetTest")
	proto.RegisterType((*CreateTest)(nil), "google.cloud.conformance.firestore.v1.CreateTest")
	proto.RegisterType((*SetTest)(nil), "google.cloud.conformance.firestore.v1.SetTest")
	proto.RegisterType((*UpdateTest)(nil), "google.cloud.conformance.firestore.v1.UpdateTest")
	proto.RegisterType((*UpdatePathsTest)(nil), "google.cloud.conformance.firestore.v1.UpdatePathsTest")
	proto.RegisterType((*DeleteTest)(nil), "google.cloud.conformance.firestore.v1.DeleteTest")
	proto.RegisterType((*SetOption)(nil), "google.cloud.conformance.firestore.v1.SetOption")
	proto.RegisterType((*QueryTest)(nil), "google.cloud.conformance.firestore.v1.QueryTest")
	proto.RegisterType((*Clause)(nil), "google.cloud.conformance.firestore.v1.Clause")
	proto.RegisterType((*Select)(nil), "google.cloud.conformance.firestore.v1.Select")
	proto.RegisterType((*Where)(nil), "google.cloud.conformance.firestore.v1.Where")
	proto.RegisterType((*OrderBy)(nil), "google.cloud.conformance.firestore.v1.OrderBy")
	proto.RegisterType((*Cursor)(nil), "google.cloud.conformance.firestore.v1.Cursor")
	proto.RegisterType((*DocSnapshot)(nil), "google.cloud.conformance.firestore.v1.DocSnapshot")
	proto.RegisterType((*FieldPath)(nil), "google.cloud.conformance.firestore.v1.FieldPath")
	proto.RegisterType((*ListenTest)(nil), "google.cloud.conformance.firestore.v1.ListenTest")
	proto.RegisterType((*Snapshot)(nil), "google.cloud.conformance.firestore.v1.Snapshot")
	proto.RegisterType((*DocChange)(nil), "google.cloud.conformance.firestore.v1.DocChange")
}

func init() { proto.RegisterFile("tests.proto", fileDescriptor_e49b496f4919bda1) }

var fileDescriptor_e49b496f4919bda1 = []byte{
	// 1340 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x58, 0xdf, 0x8e, 0xdb, 0xc4,
	0x17, 0xae, 0x93, 0xd8, 0xb1, 0x4f, 0x56, 0xfd, 0xad, 0x46, 0xd5, 0x4f, 0xa6, 0x50, 0x35, 0x75,
	0x41, 0x2c, 0x02, 0xb2, 0xec, 0x22, 0x40, 0x42, 0x08, 0x69, 0x13, 0x67, 0xff, 0x74, 0xd9, 0xee,
	0xd6, 0x69, 0xcb, 0x05, 0x2b, 0x45, 0x5e, 0xfb, 0x64, 0xd7, 0xe0, 0x78, 0xd2, 0xf1, 0xa4, 0xa5,
	0x12, 0x17, 0xdc, 0x70, 0xc5, 0x6b, 0x70, 0x85, 0xc4, 0x03, 0x70, 0xcb, 0x0d, 0x88, 0x0b, 0x2e,
	0x79, 0x09, 0x5e, 0x02, 0xcd, 0x1f, 0xc7, 0xd9, 0x6d, 0x28, 0x4e, 0x0b, 0xe5, 0xce, 0x33, 0x73,
	0xbe, 0x6f, 0xbe, 0x73, 0xe6, 0x9c, 0x33, 0x93, 0x40, 0x8b, 0x63, 0xce, 0xf3, 0xce, 0x84, 0x51,
	0x4e, 0xc9, 0x6b, 0xa7, 0x94, 0x9e, 0xa6, 0xd8, 0x89, 0x52, 0x3a, 0x8d, 0x3b, 0x11, 0xcd, 0x46,
	0x94, 0x8d, 0xc3, 0x2c, 0xc2, 0xce, 0x28, 0x61, 0x98, 0x73, 0xca, 0xb0, 0xf3, 0x70, 0xe3, 0x6a,
	0x5b, 0x99, 0xad, 0xcf, 0x26, 0xd7, 0x1f, 0x6e, 0xac, 0x47, 0x74, 0x3c, 0xa6, 0x99, 0x22, 0xba,
	0xea, 0x2d, 0xb2, 0x88, 0x69, 0x34, 0x1d, 0x63, 0xc6, 0xb5, 0xcd, 0xcd, 0x45, 0x36, 0xe5, 0x3e,
	0xca, 0xe8, 0xfa, 0x22, 0xa3, 0x07, 0x53, 0x64, 0x8f, 0x2f, 0x18, 0xc8, 0xd1, 0xc9, 0x74, 0xb4,
	0xce, 0x93, 0x31, 0xe6, 0x3c, 0x1c, 0x4f, 0x94, 0x81, 0x77, 0x00, 0xf6, 0x5d, 0xcc, 0xf9, 0x76,
	0x92, 0x22, 0xd9, 0x02, 0x53, 0xba, 0xeb, 0x1a, 0xed, 0xfa, 0x5a, 0x6b, 0xf3, 0xcd, 0x4e, 0x25,
	0x7f, 0x3b, 0x02, 0x1f, 0x28, 0xa4, 0xf7, 0x83, 0x09, 0x0d, 0x31, 0x26, 0x6d, 0x68, 0xc5, 0x98,
	0x47, 0x2c, 0x99, 0xf0, 0x84, 0x66, 0xae, 0xd1, 0x36, 0xd6, 0x9c, 0x60, 0x7e, 0x8a, 0xb8, 0xd0,
	0x14, 0x41, 0xc1, 0x8c, 0xbb, 0x20, 0x57, 0x8b, 0x21, 0xe9, 0x42, 0xfd, 0x14, 0xb9, 0x5b, 0x6b,
	0x1b, 0x6b, 0xad, 0xcd, 0x4e, 0x45, 0x15, 0x3b, 0xc8, 0xc5, 0xc6, 0xbb, 0x97, 0x02, 0x01, 0x26,
	0xfb, 0x60, 0x45, 0x0c, 0x43, 0x8e, 0x6e, 0x5d, 0xd2, 0x6c, 0x54, 0xa4, 0xe9, 0x49, 0x90, 0x66,
	0xd2, 0x14, 0x42, 0x50, 0x8e, 0xdc, 0x6d, 0x2c, 0x25, 0x68, 0x50, 0x0a, 0xca, 0x95, 0xa0, 0xe9,
	0x24, 0x16, 0x82, 0xcc, 0xa5, 0x04, 0xdd, 0x93, 0xa0, 0x42, 0x90, 0xa2, 0x20, 0x9f, 0xc1, 0x8a,
	0xfa, 0x1a, 0x4e, 0x42, 0x7e, 0x96, 0xbb, 0x96, 0xa4, 0x7c, 0x7f, 0x29, 0xca, 0x23, 0x81, 0xd4,
	0xbc, 0xad, 0x69, 0x39, 0x25, 0x94, 0xc6, 0x98, 0x22, 0x47, 0xb7, 0xb9, 0x94, 0x52, 0x5f, 0x82,
	0x0a, 0xa5, 0x8a, 0x82, 0xec, 0x82, 0x29, 0xf3, 0xd1, 0xb5, 0x25, 0xd7, 0x3b, 0x15, 0xb9, 0xee,
	0x08, 0x8c, 0xa6, 0x52, 0x04, 0x42, 0x56, 0x9a, 0xe4, 0x1c, 0x33, 0xd7, 0x59, 0x4a, 0xd6, 0x27,
	0x12, 0x54, 0xc8, 0x52, 0x14, 0x5d, 0x0b, 0x1a, 0x22, 0x61, 0xbd, 0x0c, 0x9a, 0x3a, 0x71, 0x48,
	0x1b, 0x56, 0x62, 0x1a, 0x0d, 0x19, 0x8e, 0x64, 0x50, 0x75, 0xca, 0x42, 0x4c, 0xa3, 0x00, 0x47,
	0x22, 0x32, 0x64, 0x0b, 0x9a, 0x0c, 0x1f, 0x4c, 0x31, 0x2f, 0x72, 0xf3, 0xf5, 0x42, 0xc2, 0xc5,
	0x4c, 0xf4, 0x75, 0x2d, 0x07, 0xca, 0x3c, 0x28, 0x70, 0xde, 0x77, 0x06, 0x40, 0x99, 0x62, 0x15,
	0xf6, 0x7c, 0x19, 0x9c, 0xcf, 0x73, 0x9a, 0x0d, 0xe3, 0x90, 0x87, 0x72, 0x57, 0x27, 0xb0, 0xc5,
	0x84, 0x1f, 0xf2, 0x90, 0x7c, 0x54, 0x0a, 0x52, 0x59, 0xee, 0x2d, 0x14, 0xd4, 0xa3, 0xe3, 0x71,
	0xf2, 0x84, 0x16, 0xf2, 0x12, 0xd8, 0x49, 0x3e, 0x44, 0xc6, 0x28, 0x93, 0xa9, 0x6d, 0x07, 0xcd,
	0x24, 0xef, 0x8b, 0xa1, 0xf7, 0x87, 0x01, 0xcd, 0x41, 0xe5, 0xb8, 0xec, 0x82, 0x45, 0x55, 0x99,
	0xd7, 0x96, 0x3a, 0xe4, 0x01, 0xf2, 0x43, 0x89, 0x0b, 0x34, 0xfe, 0xbc, 0xb7, 0xf5, 0xbf, 0xf6,
	0xb6, 0xf1, 0x7c, 0xde, 0x9a, 0x4f, 0x78, 0x0b, 0x65, 0x99, 0x55, 0x70, 0xb8, 0x0f, 0x2b, 0x13,
	0x86, 0x11, 0xcd, 0xe2, 0x64, 0xce, 0xed, 0x1b, 0x0b, 0xe5, 0x1c, 0xcd, 0x19, 0x06, 0xe7, 0x60,
	0xff, 0x91, 0xb7, 0x3f, 0xd7, 0xe0, 0x7f, 0x17, 0x3a, 0xc0, 0x8b, 0x73, 0xf9, 0x0e, 0xb4, 0x46,
	0x09, 0xa6, 0xb1, 0xee, 0x5b, 0x75, 0x79, 0xd1, 0x54, 0xcd, 0x97, 0x6d, 0x81, 0x14, 0x6a, 0x02,
	0x18, 0x15, 0x9f, 0x39, 0xb9, 0x0e, 0x2d, 0x19, 0xc5, 0x87, 0x61, 0x3a, 0xc5, 0xdc, 0x6d, 0xb4,
	0xeb, 0x42, 0xba, 0x98, 0xba, 0x2f, 0x67, 0xe6, 0x23, 0x69, 0x3e, 0x5f, 0x24, 0xad, 0xf3, 0x91,
	0xfc, 0xcd, 0x00, 0x28, 0x9b, 0xde, 0x8b, 0x0b, 0xe2, 0xbf, 0x56, 0xf6, 0xa7, 0xe0, 0xcc, 0x6a,
	0x92, 0xac, 0x42, 0x3d, 0x4c, 0x53, 0xe9, 0x85, 0x1d, 0x88, 0x4f, 0x51, 0xe7, 0x32, 0xee, 0xb9,
	0x5b, 0x7b, 0xc6, 0x73, 0xd3, 0x78, 0xef, 0x17, 0x03, 0x9c, 0x59, 0x8b, 0x17, 0x75, 0x10, 0xd1,
	0x34, 0x9d, 0x8f, 0x9a, 0x2d, 0x26, 0x64, 0xcc, 0x76, 0xa0, 0x19, 0xa5, 0xe1, 0x34, 0xc7, 0x62,
	0xd7, 0xb7, 0xab, 0xde, 0xe4, 0x12, 0x15, 0x14, 0x68, 0xf2, 0x61, 0x71, 0x13, 0xa9, 0x98, 0xbd,
	0xba, 0x30, 0x66, 0x03, 0xce, 0xa6, 0x11, 0x9f, 0x32, 0x8c, 0xa5, 0xbc, 0xe2, 0xee, 0x79, 0x4a,
	0xcc, 0x7e, 0x6f, 0x80, 0xa5, 0xb6, 0x22, 0x3b, 0x60, 0xe5, 0x98, 0x62, 0xc4, 0xa5, 0x13, 0xd5,
	0x95, 0x0e, 0x24, 0x48, 0xdc, 0x4e, 0x0a, 0x4e, 0x7c, 0x30, 0x1f, 0x9d, 0x21, 0x43, 0x9d, 0x20,
	0x6f, 0x55, 0xe4, 0xf9, 0x54, 0x60, 0xc4, 0x85, 0x29, 0xc1, 0x64, 0x1f, 0x6c, 0xca, 0x62, 0x64,
	0xc3, 0x93, 0xc2, 0xe7, 0xaa, 0x4f, 0x97, 0x43, 0x01, 0xeb, 0x3e, 0xde, 0xbd, 0x14, 0x34, 0xa9,
	0xfa, 0x24, 0x2e, 0x58, 0x74, 0x34, 0x2a, 0x5e, 0x41, 0xa6, 0x10, 0xab, 0xc6, 0xe4, 0xff, 0x60,
	0xa6, 0xc9, 0x38, 0x51, 0xc5, 0x25, 0x16, 0xd4, 0x90, 0xdc, 0x02, 0x3b, 0xe7, 0x21, 0xe3, 0xc3,
	0x90, 0xeb, 0xf7, 0x49, 0xe5, 0x93, 0x9b, 0xb2, 0x9c, 0x32, 0xb1, 0xbb, 0x24, 0xd8, 0xe2, 0xe4,
	0x08, 0x5a, 0x9a, 0x6b, 0xc4, 0x91, 0xe9, 0x77, 0xc9, 0xd2, 0x74, 0xa0, 0xe8, 0x04, 0x05, 0xd9,
	0x06, 0x0b, 0xb3, 0x58, 0x68, 0xb3, 0x9f, 0x8d, 0xcc, 0xc4, 0x2c, 0xde, 0xe2, 0xe4, 0x36, 0x80,
	0xe0, 0x39, 0xc1, 0x11, 0x65, 0xa8, 0x5f, 0x26, 0x4b, 0x73, 0x39, 0x98, 0xc5, 0x5d, 0xc9, 0xd0,
	0xb5, 0xc1, 0x52, 0x09, 0xeb, 0x05, 0x60, 0xa9, 0xc4, 0x98, 0xab, 0x3b, 0xe3, 0x39, 0xeb, 0xee,
	0x2b, 0x30, 0x65, 0x92, 0x10, 0x1f, 0x1a, 0xb3, 0x6a, 0x7b, 0x16, 0x42, 0x89, 0x26, 0x97, 0xa1,
	0x46, 0x27, 0xfa, 0x55, 0x52, 0xa3, 0x13, 0x72, 0x0d, 0xa0, 0x6c, 0xc5, 0xfa, 0x46, 0x73, 0x66,
	0x9d, 0xd8, 0x1b, 0x43, 0x53, 0x67, 0xd6, 0x3f, 0xb4, 0xff, 0x2b, 0xe0, 0xc4, 0x09, 0xc3, 0x68,
	0xd6, 0x4c, 0x9d, 0xa0, 0x9c, 0xf0, 0xbe, 0x36, 0xc0, 0x52, 0x21, 0x26, 0xf7, 0x54, 0x6b, 0xce,
	0xb3, 0x70, 0x92, 0x9f, 0xd1, 0xa2, 0x3e, 0x37, 0xab, 0x3e, 0x6c, 0x69, 0x34, 0xd0, 0xc8, 0xa0,
	0x15, 0x97, 0x83, 0x8b, 0x57, 0x4f, 0xed, 0xe2, 0xd5, 0xe3, 0x7d, 0x0c, 0xad, 0x39, 0x30, 0x21,
	0x73, 0x5e, 0x3b, 0xda, 0x87, 0xa7, 0x3d, 0xf0, 0xbc, 0x1b, 0xe0, 0xcc, 0x7c, 0x26, 0x57, 0xc0,
	0x94, 0xc7, 0x28, 0xb3, 0xc0, 0x09, 0xd4, 0xc0, 0xfb, 0xd1, 0x00, 0x28, 0x9f, 0xb8, 0x64, 0x0b,
	0x1c, 0x86, 0xf9, 0x84, 0x66, 0xa2, 0x61, 0xaa, 0x74, 0xb9, 0xb9, 0xb0, 0xd3, 0x29, 0x4c, 0xa0,
	0x6d, 0x83, 0x12, 0x45, 0x0e, 0xc0, 0x29, 0x02, 0x55, 0xf4, 0xdc, 0xf5, 0xaa, 0x9d, 0xac, 0x08,
	0x53, 0xc9, 0x70, 0xae, 0x77, 0xd6, 0xcf, 0xf7, 0xce, 0x9f, 0x0c, 0xb0, 0x67, 0xc1, 0xd9, 0x80,
	0x46, 0x4c, 0xa3, 0x42, 0xf4, 0xb5, 0x85, 0xa2, 0x67, 0xef, 0x6a, 0x69, 0x4a, 0x6e, 0x41, 0x33,
	0x3a, 0x0b, 0xb3, 0x53, 0x5c, 0xf6, 0x46, 0xf2, 0x69, 0xd4, 0x93, 0xc0, 0xa0, 0x20, 0x20, 0x1f,
	0x88, 0xc0, 0x85, 0xf1, 0x50, 0xfc, 0x40, 0xd6, 0xed, 0xf2, 0x6a, 0xc1, 0x56, 0xfc, 0x7a, 0xee,
	0xdc, 0x2d, 0x7e, 0x3d, 0x07, 0xb6, 0x30, 0x16, 0x43, 0xef, 0x9b, 0x1a, 0x38, 0x33, 0x3e, 0xb2,
	0x07, 0x8d, 0x2f, 0x92, 0x2c, 0x96, 0x47, 0x7c, 0x79, 0xf3, 0xbd, 0x65, 0xf5, 0x74, 0xf6, 0x93,
	0x2c, 0x0e, 0x24, 0x05, 0x59, 0x87, 0x7a, 0x4c, 0x23, 0x7d, 0x07, 0xfc, 0x4d, 0x3c, 0x84, 0xa5,
	0x48, 0x25, 0x9a, 0xc6, 0xc3, 0x24, 0x8b, 0xf1, 0x4b, 0xe9, 0x82, 0x19, 0xd8, 0x34, 0x8d, 0xf7,
	0xc4, 0x58, 0x2c, 0x66, 0xf8, 0x48, 0x2f, 0x36, 0xd4, 0x62, 0x86, 0x8f, 0xe4, 0xa2, 0xd7, 0x85,
	0x86, 0xd8, 0x98, 0x5c, 0x81, 0xd5, 0xfd, 0xbd, 0xdb, 0xfe, 0xf0, 0xde, 0xed, 0xc1, 0x51, 0xbf,
	0xb7, 0xb7, 0xbd, 0xd7, 0xf7, 0x57, 0x2f, 0x11, 0x07, 0xcc, 0x2d, 0xdf, 0xef, 0xfb, 0xab, 0x06,
	0x69, 0x41, 0x33, 0xe8, 0x1f, 0x1c, 0xde, 0xef, 0xfb, 0xab, 0x35, 0xb2, 0x02, 0xf6, 0xc1, 0xa1,
	0xaf, 0xac, 0xea, 0xdd, 0x6f, 0x0d, 0x78, 0x23, 0xa2, 0xe3, 0x6a, 0x1e, 0x77, 0x2f, 0x8b, 0x6c,
	0xf5, 0x71, 0x94, 0x64, 0xf2, 0x4d, 0xf3, 0x7d, 0xcd, 0xdb, 0x51, 0xb8, 0x9e, 0xc4, 0x6d, 0xcf,
	0x6c, 0xef, 0xca, 0x3f, 0x60, 0x8e, 0xc4, 0x09, 0xfc, 0x5a, 0x5b, 0x53, 0x46, 0xc7, 0xd2, 0xe8,
	0x78, 0x66, 0x74, 0x2c, 0x8d, 0x8e, 0x7b, 0xe5, 0x66, 0x27, 0x96, 0x3c, 0xb3, 0x77, 0xff, 0x0c,
	0x00, 0x00, 0xff, 0xff, 0xe0, 0x87, 0x8a, 0x65, 0xc1, 0x11, 0x00, 0x00,
}
