// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Contains the details for an AS2 connector object. The connector object is used
// for AS2 outbound processes, to connect the Transfer Family customer with the
// trading partner.
type As2ConnectorConfig struct {

	// Provides Basic authentication support to the AS2 Connectors API. To use Basic
	// authentication, you must provide the name or Amazon Resource Name (ARN) of a
	// secret in Secrets Manager. The default value for this parameter is null , which
	// indicates that Basic authentication is not enabled for the connector. If the
	// connector should use Basic authentication, the secret needs to be in the
	// following format: { "Username": "user-name", "Password": "user-password" }
	// Replace user-name and user-password with the credentials for the actual user
	// that is being authenticated. Note the following:
	//   - You are storing these credentials in Secrets Manager, not passing them
	//   directly into this API.
	//   - If you are using the API, SDKs, or CloudFormation to configure your
	//   connector, then you must create the secret before you can enable Basic
	//   authentication. However, if you are using the Amazon Web Services management
	//   console, you can have the system create the secret for you.
	// If you have previously enabled Basic authentication for a connector, you can
	// disable it by using the UpdateConnector API call. For example, if you are using
	// the CLI, you can run the following command to remove Basic authentication:
	// update-connector --connector-id my-connector-id --as2-config
	// 'BasicAuthSecretId=""'
	BasicAuthSecretId *string

	// Specifies whether the AS2 file is compressed.
	Compression CompressionEnum

	// The algorithm that is used to encrypt the file. Note the following:
	//   - Do not use the DES_EDE3_CBC algorithm unless you must support a legacy
	//   client that requires it, as it is a weak encryption algorithm.
	//   - You can only specify NONE if the URL for your connector uses HTTPS. Using
	//   HTTPS ensures that no traffic is sent in clear text.
	EncryptionAlgorithm EncryptionAlg

	// A unique identifier for the AS2 local profile.
	LocalProfileId *string

	// Used for outbound requests (from an Transfer Family server to a partner AS2
	// server) to determine whether the partner response for transfers is synchronous
	// or asynchronous. Specify either of the following values:
	//   - SYNC : The system expects a synchronous MDN response, confirming that the
	//   file was transferred successfully (or not).
	//   - NONE : Specifies that no MDN response is required.
	MdnResponse MdnResponse

	// The signing algorithm for the MDN response. If set to DEFAULT (or not set at
	// all), the value for SigningAlgorithm is used.
	MdnSigningAlgorithm MdnSigningAlg

	// Used as the Subject HTTP header attribute in AS2 messages that are being sent
	// with the connector.
	MessageSubject *string

	// A unique identifier for the partner profile for the connector.
	PartnerProfileId *string

	// The algorithm that is used to sign the AS2 messages sent with the connector.
	SigningAlgorithm SigningAlg

	noSmithyDocumentSerde
}

// Each step type has its own StepDetails structure.
type CopyStepDetails struct {

	// Specifies the location for the file being copied. Use ${Transfer:UserName} or
	// ${Transfer:UploadDate} in this field to parametrize the destination prefix by
	// username or uploaded date.
	//   - Set the value of DestinationFileLocation to ${Transfer:UserName} to copy
	//   uploaded files to an Amazon S3 bucket that is prefixed with the name of the
	//   Transfer Family user that uploaded the file.
	//   - Set the value of DestinationFileLocation to ${Transfer:UploadDate} to copy
	//   uploaded files to an Amazon S3 bucket that is prefixed with the date of the
	//   upload. The system resolves UploadDate to a date format of YYYY-MM-DD, based
	//   on the date the file is uploaded in UTC.
	DestinationFileLocation *InputFileLocation

	// The name of the step, used as an identifier.
	Name *string

	// A flag that indicates whether to overwrite an existing file of the same name.
	// The default is FALSE . If the workflow is processing a file that has the same
	// name as an existing file, the behavior is as follows:
	//   - If OverwriteExisting is TRUE , the existing file is replaced with the file
	//   being processed.
	//   - If OverwriteExisting is FALSE , nothing happens, and the workflow processing
	//   stops.
	OverwriteExisting OverwriteExisting

	// Specifies which file to use as input to the workflow step: either the output
	// from the previous step, or the originally uploaded file for the workflow.
	//   - To use the previous file as the input, enter ${previous.file} . In this
	//   case, this workflow step uses the output file from the previous workflow step as
	//   input. This is the default value.
	//   - To use the originally uploaded file location as input for this step, enter
	//   ${original.file} .
	SourceFileLocation *string

	noSmithyDocumentSerde
}

// Each step type has its own StepDetails structure.
type CustomStepDetails struct {

	// The name of the step, used as an identifier.
	Name *string

	// Specifies which file to use as input to the workflow step: either the output
	// from the previous step, or the originally uploaded file for the workflow.
	//   - To use the previous file as the input, enter ${previous.file} . In this
	//   case, this workflow step uses the output file from the previous workflow step as
	//   input. This is the default value.
	//   - To use the originally uploaded file location as input for this step, enter
	//   ${original.file} .
	SourceFileLocation *string

	// The ARN for the Lambda function that is being called.
	Target *string

	// Timeout, in seconds, for the step.
	TimeoutSeconds *int32

	noSmithyDocumentSerde
}

// Each step type has its own StepDetails structure.
type DecryptStepDetails struct {

	// Specifies the location for the file being decrypted. Use ${Transfer:UserName}
	// or ${Transfer:UploadDate} in this field to parametrize the destination prefix
	// by username or uploaded date.
	//   - Set the value of DestinationFileLocation to ${Transfer:UserName} to decrypt
	//   uploaded files to an Amazon S3 bucket that is prefixed with the name of the
	//   Transfer Family user that uploaded the file.
	//   - Set the value of DestinationFileLocation to ${Transfer:UploadDate} to
	//   decrypt uploaded files to an Amazon S3 bucket that is prefixed with the date of
	//   the upload. The system resolves UploadDate to a date format of YYYY-MM-DD,
	//   based on the date the file is uploaded in UTC.
	//
	// This member is required.
	DestinationFileLocation *InputFileLocation

	// The type of encryption used. Currently, this value must be PGP .
	//
	// This member is required.
	Type EncryptionType

	// The name of the step, used as an identifier.
	Name *string

	// A flag that indicates whether to overwrite an existing file of the same name.
	// The default is FALSE . If the workflow is processing a file that has the same
	// name as an existing file, the behavior is as follows:
	//   - If OverwriteExisting is TRUE , the existing file is replaced with the file
	//   being processed.
	//   - If OverwriteExisting is FALSE , nothing happens, and the workflow processing
	//   stops.
	OverwriteExisting OverwriteExisting

	// Specifies which file to use as input to the workflow step: either the output
	// from the previous step, or the originally uploaded file for the workflow.
	//   - To use the previous file as the input, enter ${previous.file} . In this
	//   case, this workflow step uses the output file from the previous workflow step as
	//   input. This is the default value.
	//   - To use the originally uploaded file location as input for this step, enter
	//   ${original.file} .
	SourceFileLocation *string

	noSmithyDocumentSerde
}

// The name of the step, used to identify the delete step.
type DeleteStepDetails struct {

	// The name of the step, used as an identifier.
	Name *string

	// Specifies which file to use as input to the workflow step: either the output
	// from the previous step, or the originally uploaded file for the workflow.
	//   - To use the previous file as the input, enter ${previous.file} . In this
	//   case, this workflow step uses the output file from the previous workflow step as
	//   input. This is the default value.
	//   - To use the originally uploaded file location as input for this step, enter
	//   ${original.file} .
	SourceFileLocation *string

	noSmithyDocumentSerde
}

// Describes the properties of the access that was specified.
type DescribedAccess struct {

	// A unique identifier that is required to identify specific groups within your
	// directory. The users of the group that you associate have access to your Amazon
	// S3 or Amazon EFS resources over the enabled protocols using Transfer Family. If
	// you know the group name, you can view the SID values by running the following
	// command using Windows PowerShell. Get-ADGroup -Filter {samAccountName -like
	// "YourGroupName*"} -Properties * | Select SamAccountName,ObjectSid In that
	// command, replace YourGroupName with the name of your Active Directory group. The
	// regular expression used to validate this parameter is a string of characters
	// consisting of uppercase and lowercase alphanumeric characters with no spaces.
	// You can also include underscores or any of the following characters: =,.@:/-
	ExternalId *string

	// The landing directory (folder) for a user when they log in to the server using
	// the client. A HomeDirectory example is /bucket_name/home/mydirectory . The
	// HomeDirectory parameter is only used if HomeDirectoryType is set to PATH .
	HomeDirectory *string

	// Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and
	// keys should be visible to your user and how you want to make them visible. You
	// must specify the Entry and Target pair, where Entry shows how the path is made
	// visible and Target is the actual Amazon S3 or Amazon EFS path. If you only
	// specify a target, it is displayed as is. You also must ensure that your Identity
	// and Access Management (IAM) role provides access to paths in Target . This value
	// can be set only when HomeDirectoryType is set to LOGICAL. In most cases, you
	// can use this value instead of the session policy to lock down the associated
	// access to the designated home directory (" chroot "). To do this, you can set
	// Entry to '/' and set Target to the HomeDirectory parameter value.
	HomeDirectoryMappings []HomeDirectoryMapEntry

	// The type of landing directory (folder) that you want your users' home directory
	// to be when they log in to the server. If you set it to PATH , the user will see
	// the absolute Amazon S3 bucket or Amazon EFS path as is in their file transfer
	// protocol clients. If you set it to LOGICAL , you need to provide mappings in the
	// HomeDirectoryMappings for how you want to make Amazon S3 or Amazon EFS paths
	// visible to your users. If HomeDirectoryType is LOGICAL , you must provide
	// mappings, using the HomeDirectoryMappings parameter. If, on the other hand,
	// HomeDirectoryType is PATH , you provide an absolute path using the HomeDirectory
	// parameter. You cannot have both HomeDirectory and HomeDirectoryMappings in your
	// template.
	HomeDirectoryType HomeDirectoryType

	// A session policy for your user so that you can use the same Identity and Access
	// Management (IAM) role across multiple users. This policy scopes down a user's
	// access to portions of their Amazon S3 bucket. Variables that you can use inside
	// this policy include ${Transfer:UserName} , ${Transfer:HomeDirectory} , and
	// ${Transfer:HomeBucket} .
	Policy *string

	// The full POSIX identity, including user ID ( Uid ), group ID ( Gid ), and any
	// secondary groups IDs ( SecondaryGids ), that controls your users' access to your
	// Amazon EFS file systems. The POSIX permissions that are set on files and
	// directories in your file system determine the level of access your users get
	// when transferring files into and out of your Amazon EFS file systems.
	PosixProfile *PosixProfile

	// The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role
	// that controls your users' access to your Amazon S3 bucket or Amazon EFS file
	// system. The policies attached to this role determine the level of access that
	// you want to provide your users when transferring files into and out of your
	// Amazon S3 bucket or Amazon EFS file system. The IAM role should also contain a
	// trust relationship that allows the server to access your resources when
	// servicing your users' transfer requests.
	Role *string

	noSmithyDocumentSerde
}

// Describes the properties of an agreement.
type DescribedAgreement struct {

	// The unique Amazon Resource Name (ARN) for the agreement.
	//
	// This member is required.
	Arn *string

	// Connectors are used to send files using either the AS2 or SFTP protocol. For
	// the access role, provide the Amazon Resource Name (ARN) of the Identity and
	// Access Management role to use. For AS2 connectors With AS2, you can send files
	// by calling StartFileTransfer and specifying the file paths in the request
	// parameter, SendFilePaths . We use the file’s parent directory (for example, for
	// --send-file-paths /bucket/dir/file.txt , parent directory is /bucket/dir/ ) to
	// temporarily store a processed AS2 message file, store the MDN when we receive
	// them from the partner, and write a final JSON file containing relevant metadata
	// of the transmission. So, the AccessRole needs to provide read and write access
	// to the parent directory of the file location used in the StartFileTransfer
	// request. Additionally, you need to provide read and write access to the parent
	// directory of the files that you intend to send with StartFileTransfer . If you
	// are using Basic authentication for your AS2 connector, the access role requires
	// the secretsmanager:GetSecretValue permission for the secret. If the secret is
	// encrypted using a customer-managed key instead of the Amazon Web Services
	// managed key in Secrets Manager, then the role also needs the kms:Decrypt
	// permission for that key. For SFTP connectors Make sure that the access role
	// provides read and write access to the parent directory of the file location
	// that's used in the StartFileTransfer request. Additionally, make sure that the
	// role provides secretsmanager:GetSecretValue permission to Secrets Manager.
	AccessRole *string

	// A unique identifier for the agreement. This identifier is returned when you
	// create an agreement.
	AgreementId *string

	// The landing directory (folder) for files that are transferred by using the AS2
	// protocol.
	BaseDirectory *string

	// The name or short description that's used to identify the agreement.
	Description *string

	// A unique identifier for the AS2 local profile.
	LocalProfileId *string

	// A unique identifier for the partner profile used in the agreement.
	PartnerProfileId *string

	// A system-assigned unique identifier for a server instance. This identifier
	// indicates the specific server that the agreement uses.
	ServerId *string

	// The current status of the agreement, either ACTIVE or INACTIVE .
	Status AgreementStatusType

	// Key-value pairs that can be used to group and search for agreements.
	Tags []Tag

	noSmithyDocumentSerde
}

// Describes the properties of a certificate.
type DescribedCertificate struct {

	// The unique Amazon Resource Name (ARN) for the certificate.
	//
	// This member is required.
	Arn *string

	// An optional date that specifies when the certificate becomes active.
	ActiveDate *time.Time

	// The file name for the certificate.
	Certificate *string

	// The list of certificates that make up the chain for the certificate.
	CertificateChain *string

	// An array of identifiers for the imported certificates. You use this identifier
	// for working with profiles and partner profiles.
	CertificateId *string

	// The name or description that's used to identity the certificate.
	Description *string

	// An optional date that specifies when the certificate becomes inactive.
	InactiveDate *time.Time

	// The final date that the certificate is valid.
	NotAfterDate *time.Time

	// The earliest date that the certificate is valid.
	NotBeforeDate *time.Time

	// The serial number for the certificate.
	Serial *string

	// The certificate can be either ACTIVE , PENDING_ROTATION , or INACTIVE .
	// PENDING_ROTATION means that this certificate will replace the current
	// certificate when it expires.
	Status CertificateStatusType

	// Key-value pairs that can be used to group and search for certificates.
	Tags []Tag

	// If a private key has been specified for the certificate, its type is
	// CERTIFICATE_WITH_PRIVATE_KEY . If there is no private key, the type is
	// CERTIFICATE .
	Type CertificateType

	// Specifies whether this certificate is used for signing or encryption.
	Usage CertificateUsageType

	noSmithyDocumentSerde
}

// Describes the parameters for the connector, as identified by the ConnectorId .
type DescribedConnector struct {

	// The unique Amazon Resource Name (ARN) for the connector.
	//
	// This member is required.
	Arn *string

	// Connectors are used to send files using either the AS2 or SFTP protocol. For
	// the access role, provide the Amazon Resource Name (ARN) of the Identity and
	// Access Management role to use. For AS2 connectors With AS2, you can send files
	// by calling StartFileTransfer and specifying the file paths in the request
	// parameter, SendFilePaths . We use the file’s parent directory (for example, for
	// --send-file-paths /bucket/dir/file.txt , parent directory is /bucket/dir/ ) to
	// temporarily store a processed AS2 message file, store the MDN when we receive
	// them from the partner, and write a final JSON file containing relevant metadata
	// of the transmission. So, the AccessRole needs to provide read and write access
	// to the parent directory of the file location used in the StartFileTransfer
	// request. Additionally, you need to provide read and write access to the parent
	// directory of the files that you intend to send with StartFileTransfer . If you
	// are using Basic authentication for your AS2 connector, the access role requires
	// the secretsmanager:GetSecretValue permission for the secret. If the secret is
	// encrypted using a customer-managed key instead of the Amazon Web Services
	// managed key in Secrets Manager, then the role also needs the kms:Decrypt
	// permission for that key. For SFTP connectors Make sure that the access role
	// provides read and write access to the parent directory of the file location
	// that's used in the StartFileTransfer request. Additionally, make sure that the
	// role provides secretsmanager:GetSecretValue permission to Secrets Manager.
	AccessRole *string

	// A structure that contains the parameters for an AS2 connector object.
	As2Config *As2ConnectorConfig

	// The unique identifier for the connector.
	ConnectorId *string

	// The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role
	// that allows a connector to turn on CloudWatch logging for Amazon S3 events. When
	// set, you can view connector activity in your CloudWatch logs.
	LoggingRole *string

	// The list of egress IP addresses of this connector. These IP addresses are
	// assigned automatically when you create the connector.
	ServiceManagedEgressIpAddresses []string

	// A structure that contains the parameters for an SFTP connector object.
	SftpConfig *SftpConnectorConfig

	// Key-value pairs that can be used to group and search for connectors.
	Tags []Tag

	// The URL of the partner's AS2 or SFTP endpoint.
	Url *string

	noSmithyDocumentSerde
}

// The details for an execution object.
type DescribedExecution struct {

	// A unique identifier for the execution of a workflow.
	ExecutionId *string

	// The IAM role associated with the execution.
	ExecutionRole *string

	// A structure that describes the Amazon S3 or EFS file location. This is the file
	// location when the execution begins: if the file is being copied, this is the
	// initial (as opposed to destination) file location.
	InitialFileLocation *FileLocation

	// The IAM logging role associated with the execution.
	LoggingConfiguration *LoggingConfiguration

	// The full POSIX identity, including user ID ( Uid ), group ID ( Gid ), and any
	// secondary groups IDs ( SecondaryGids ), that controls your users' access to your
	// Amazon EFS file systems. The POSIX permissions that are set on files and
	// directories in your file system determine the level of access your users get
	// when transferring files into and out of your Amazon EFS file systems.
	PosixProfile *PosixProfile

	// A structure that describes the execution results. This includes a list of the
	// steps along with the details of each step, error type and message (if any), and
	// the OnExceptionSteps structure.
	Results *ExecutionResults

	// A container object for the session details that are associated with a workflow.
	ServiceMetadata *ServiceMetadata

	// The status is one of the execution. Can be in progress, completed, exception
	// encountered, or handling the exception.
	Status ExecutionStatus

	noSmithyDocumentSerde
}

// The details for a server host key.
type DescribedHostKey struct {

	// The unique Amazon Resource Name (ARN) for the host key.
	//
	// This member is required.
	Arn *string

	// The date on which the host key was added to the server.
	DateImported *time.Time

	// The text description for this host key.
	Description *string

	// The public key fingerprint, which is a short sequence of bytes used to identify
	// the longer public key.
	HostKeyFingerprint *string

	// A unique identifier for the host key.
	HostKeyId *string

	// Key-value pairs that can be used to group and search for host keys.
	Tags []Tag

	// The encryption algorithm that is used for the host key. The Type parameter is
	// specified by using one of the following values:
	//   - ssh-rsa
	//   - ssh-ed25519
	//   - ecdsa-sha2-nistp256
	//   - ecdsa-sha2-nistp384
	//   - ecdsa-sha2-nistp521
	Type *string

	noSmithyDocumentSerde
}

// The details for a local or partner AS2 profile.
type DescribedProfile struct {

	// The unique Amazon Resource Name (ARN) for the profile.
	//
	// This member is required.
	Arn *string

	// The As2Id is the AS2-name, as defined in the RFC 4130 (https://datatracker.ietf.org/doc/html/rfc4130)
	// . For inbound transfers, this is the AS2-From header for the AS2 messages sent
	// from the partner. For outbound connectors, this is the AS2-To header for the
	// AS2 messages sent to the partner using the StartFileTransfer API operation.
	// This ID cannot include spaces.
	As2Id *string

	// An array of identifiers for the imported certificates. You use this identifier
	// for working with profiles and partner profiles.
	CertificateIds []string

	// A unique identifier for the local or partner AS2 profile.
	ProfileId *string

	// Indicates whether to list only LOCAL type profiles or only PARTNER type
	// profiles. If not supplied in the request, the command lists all types of
	// profiles.
	ProfileType ProfileType

	// Key-value pairs that can be used to group and search for profiles.
	Tags []Tag

	noSmithyDocumentSerde
}

// Describes the properties of a security policy that was specified. For more
// information about security policies, see Working with security policies (https://docs.aws.amazon.com/transfer/latest/userguide/security-policies.html)
// .
type DescribedSecurityPolicy struct {

	// Specifies the name of the security policy that is attached to the server.
	//
	// This member is required.
	SecurityPolicyName *string

	// Specifies whether this policy enables Federal Information Processing Standards
	// (FIPS).
	Fips *bool

	// Specifies the enabled Secure Shell (SSH) cipher encryption algorithms in the
	// security policy that is attached to the server.
	SshCiphers []string

	// Specifies the enabled SSH key exchange (KEX) encryption algorithms in the
	// security policy that is attached to the server.
	SshKexs []string

	// Specifies the enabled SSH message authentication code (MAC) encryption
	// algorithms in the security policy that is attached to the server.
	SshMacs []string

	// Specifies the enabled Transport Layer Security (TLS) cipher encryption
	// algorithms in the security policy that is attached to the server.
	TlsCiphers []string

	noSmithyDocumentSerde
}

// Describes the properties of a file transfer protocol-enabled server that was
// specified.
type DescribedServer struct {

	// Specifies the unique Amazon Resource Name (ARN) of the server.
	//
	// This member is required.
	Arn *string

	// The list of egress IP addresses of this server. These IP addresses are only
	// relevant for servers that use the AS2 protocol. They are used for sending
	// asynchronous MDNs. These IP addresses are assigned automatically when you create
	// an AS2 server. Additionally, if you update an existing server and add the AS2
	// protocol, static IP addresses are assigned as well.
	As2ServiceManagedEgressIpAddresses []string

	// Specifies the ARN of the Amazon Web ServicesCertificate Manager (ACM)
	// certificate. Required when Protocols is set to FTPS .
	Certificate *string

	// Specifies the domain of the storage system that is used for file transfers.
	Domain Domain

	// The virtual private cloud (VPC) endpoint settings that are configured for your
	// server. When you host your endpoint within your VPC, you can make your endpoint
	// accessible only to resources within your VPC, or you can attach Elastic IP
	// addresses and make your endpoint accessible to clients over the internet. Your
	// VPC's default security groups are automatically assigned to your endpoint.
	EndpointDetails *EndpointDetails

	// Defines the type of endpoint that your server is connected to. If your server
	// is connected to a VPC endpoint, your server isn't accessible over the public
	// internet.
	EndpointType EndpointType

	// Specifies the Base64-encoded SHA256 fingerprint of the server's host key. This
	// value is equivalent to the output of the ssh-keygen -l -f my-new-server-key
	// command.
	HostKeyFingerprint *string

	// Specifies information to call a customer-supplied authentication API. This
	// field is not populated when the IdentityProviderType of a server is
	// AWS_DIRECTORY_SERVICE or SERVICE_MANAGED .
	IdentityProviderDetails *IdentityProviderDetails

	// The mode of authentication for a server. The default value is SERVICE_MANAGED ,
	// which allows you to store and access user credentials within the Transfer Family
	// service. Use AWS_DIRECTORY_SERVICE to provide access to Active Directory groups
	// in Directory Service for Microsoft Active Directory or Microsoft Active
	// Directory in your on-premises environment or in Amazon Web Services using AD
	// Connector. This option also requires you to provide a Directory ID by using the
	// IdentityProviderDetails parameter. Use the API_GATEWAY value to integrate with
	// an identity provider of your choosing. The API_GATEWAY setting requires you to
	// provide an Amazon API Gateway endpoint URL to call for authentication by using
	// the IdentityProviderDetails parameter. Use the AWS_LAMBDA value to directly use
	// an Lambda function as your identity provider. If you choose this value, you must
	// specify the ARN for the Lambda function in the Function parameter for the
	// IdentityProviderDetails data type.
	IdentityProviderType IdentityProviderType

	// The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role
	// that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or
	// Amazon EFSevents. When set, you can view user activity in your CloudWatch logs.
	LoggingRole *string

	// Specifies a string to display when users connect to a server. This string is
	// displayed after the user authenticates. The SFTP protocol does not support
	// post-authentication display banners.
	PostAuthenticationLoginBanner *string

	// Specifies a string to display when users connect to a server. This string is
	// displayed before the user authenticates. For example, the following banner
	// displays details about using the system: This system is for the use of
	// authorized users only. Individuals using this computer system without authority,
	// or in excess of their authority, are subject to having all of their activities
	// on this system monitored and recorded by system personnel.
	PreAuthenticationLoginBanner *string

	// The protocol settings that are configured for your server.
	//   - To indicate passive mode (for FTP and FTPS protocols), use the PassiveIp
	//   parameter. Enter a single dotted-quad IPv4 address, such as the external IP
	//   address of a firewall, router, or load balancer.
	//   - To ignore the error that is generated when the client attempts to use the
	//   SETSTAT command on a file that you are uploading to an Amazon S3 bucket, use
	//   the SetStatOption parameter. To have the Transfer Family server ignore the
	//   SETSTAT command and upload files without needing to make any changes to your
	//   SFTP client, set the value to ENABLE_NO_OP . If you set the SetStatOption
	//   parameter to ENABLE_NO_OP , Transfer Family generates a log entry to Amazon
	//   CloudWatch Logs, so that you can determine when the client is making a SETSTAT
	//   call.
	//   - To determine whether your Transfer Family server resumes recent, negotiated
	//   sessions through a unique session ID, use the TlsSessionResumptionMode
	//   parameter.
	//   - As2Transports indicates the transport method for the AS2 messages.
	//   Currently, only HTTP is supported.
	ProtocolDetails *ProtocolDetails

	// Specifies the file transfer protocol or protocols over which your file transfer
	// protocol client can connect to your server's endpoint. The available protocols
	// are:
	//   - SFTP (Secure Shell (SSH) File Transfer Protocol): File transfer over SSH
	//   - FTPS (File Transfer Protocol Secure): File transfer with TLS encryption
	//   - FTP (File Transfer Protocol): Unencrypted file transfer
	//   - AS2 (Applicability Statement 2): used for transporting structured
	//   business-to-business data
	//
	//   - If you select FTPS , you must choose a certificate stored in Certificate
	//   Manager (ACM) which is used to identify your server when clients connect to it
	//   over FTPS.
	//   - If Protocol includes either FTP or FTPS , then the EndpointType must be VPC
	//   and the IdentityProviderType must be either AWS_DIRECTORY_SERVICE , AWS_LAMBDA
	//   , or API_GATEWAY .
	//   - If Protocol includes FTP , then AddressAllocationIds cannot be associated.
	//   - If Protocol is set only to SFTP , the EndpointType can be set to PUBLIC and
	//   the IdentityProviderType can be set any of the supported identity types:
	//   SERVICE_MANAGED , AWS_DIRECTORY_SERVICE , AWS_LAMBDA , or API_GATEWAY .
	//   - If Protocol includes AS2 , then the EndpointType must be VPC , and domain
	//   must be Amazon S3.
	Protocols []Protocol

	// Specifies whether or not performance for your Amazon S3 directories is
	// optimized. This is disabled by default. By default, home directory mappings have
	// a TYPE of DIRECTORY . If you enable this option, you would then need to
	// explicitly set the HomeDirectoryMapEntry Type to FILE if you want a mapping to
	// have a file target.
	S3StorageOptions *S3StorageOptions

	// Specifies the name of the security policy that is attached to the server.
	SecurityPolicyName *string

	// Specifies the unique system-assigned identifier for a server that you
	// instantiate.
	ServerId *string

	// The condition of the server that was described. A value of ONLINE indicates
	// that the server can accept jobs and transfer files. A State value of OFFLINE
	// means that the server cannot perform file transfer operations. The states of
	// STARTING and STOPPING indicate that the server is in an intermediate state,
	// either not fully able to respond, or not fully offline. The values of
	// START_FAILED or STOP_FAILED can indicate an error condition.
	State State

	// Specifies the log groups to which your server logs are sent. To specify a log
	// group, you must provide the ARN for an existing log group. In this case, the
	// format of the log group is as follows:
	// arn:aws:logs:region-name:amazon-account-id:log-group:log-group-name:* For
	// example, arn:aws:logs:us-east-1:111122223333:log-group:mytestgroup:* If you
	// have previously specified a log group for a server, you can clear it, and in
	// effect turn off structured logging, by providing an empty value for this
	// parameter in an update-server call. For example: update-server --server-id
	// s-1234567890abcdef0 --structured-log-destinations
	StructuredLogDestinations []string

	// Specifies the key-value pairs that you can use to search for and group servers
	// that were assigned to the server that was described.
	Tags []Tag

	// Specifies the number of users that are assigned to a server you specified with
	// the ServerId .
	UserCount *int32

	// Specifies the workflow ID for the workflow to assign and the execution role
	// that's used for executing the workflow. In addition to a workflow to execute
	// when a file is uploaded completely, WorkflowDetails can also contain a workflow
	// ID (and execution role) for a workflow to execute on partial upload. A partial
	// upload occurs when the server session disconnects while the file is still being
	// uploaded.
	WorkflowDetails *WorkflowDetails

	noSmithyDocumentSerde
}

// Describes the properties of a user that was specified.
type DescribedUser struct {

	// Specifies the unique Amazon Resource Name (ARN) for the user that was requested
	// to be described.
	//
	// This member is required.
	Arn *string

	// The landing directory (folder) for a user when they log in to the server using
	// the client. A HomeDirectory example is /bucket_name/home/mydirectory . The
	// HomeDirectory parameter is only used if HomeDirectoryType is set to PATH .
	HomeDirectory *string

	// Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and
	// keys should be visible to your user and how you want to make them visible. You
	// must specify the Entry and Target pair, where Entry shows how the path is made
	// visible and Target is the actual Amazon S3 or Amazon EFS path. If you only
	// specify a target, it is displayed as is. You also must ensure that your Identity
	// and Access Management (IAM) role provides access to paths in Target . This value
	// can be set only when HomeDirectoryType is set to LOGICAL. In most cases, you
	// can use this value instead of the session policy to lock your user down to the
	// designated home directory (" chroot "). To do this, you can set Entry to '/'
	// and set Target to the HomeDirectory parameter value.
	HomeDirectoryMappings []HomeDirectoryMapEntry

	// The type of landing directory (folder) that you want your users' home directory
	// to be when they log in to the server. If you set it to PATH , the user will see
	// the absolute Amazon S3 bucket or Amazon EFS path as is in their file transfer
	// protocol clients. If you set it to LOGICAL , you need to provide mappings in the
	// HomeDirectoryMappings for how you want to make Amazon S3 or Amazon EFS paths
	// visible to your users. If HomeDirectoryType is LOGICAL , you must provide
	// mappings, using the HomeDirectoryMappings parameter. If, on the other hand,
	// HomeDirectoryType is PATH , you provide an absolute path using the HomeDirectory
	// parameter. You cannot have both HomeDirectory and HomeDirectoryMappings in your
	// template.
	HomeDirectoryType HomeDirectoryType

	// A session policy for your user so that you can use the same Identity and Access
	// Management (IAM) role across multiple users. This policy scopes down a user's
	// access to portions of their Amazon S3 bucket. Variables that you can use inside
	// this policy include ${Transfer:UserName} , ${Transfer:HomeDirectory} , and
	// ${Transfer:HomeBucket} .
	Policy *string

	// Specifies the full POSIX identity, including user ID ( Uid ), group ID ( Gid ),
	// and any secondary groups IDs ( SecondaryGids ), that controls your users' access
	// to your Amazon Elastic File System (Amazon EFS) file systems. The POSIX
	// permissions that are set on files and directories in your file system determine
	// the level of access your users get when transferring files into and out of your
	// Amazon EFS file systems.
	PosixProfile *PosixProfile

	// The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role
	// that controls your users' access to your Amazon S3 bucket or Amazon EFS file
	// system. The policies attached to this role determine the level of access that
	// you want to provide your users when transferring files into and out of your
	// Amazon S3 bucket or Amazon EFS file system. The IAM role should also contain a
	// trust relationship that allows the server to access your resources when
	// servicing your users' transfer requests.
	Role *string

	// Specifies the public key portion of the Secure Shell (SSH) keys stored for the
	// described user.
	SshPublicKeys []SshPublicKey

	// Specifies the key-value pairs for the user requested. Tag can be used to search
	// for and group users for a variety of purposes.
	Tags []Tag

	// Specifies the name of the user that was requested to be described. User names
	// are used for authentication purposes. This is the string that will be used by
	// your user when they log in to your server.
	UserName *string

	noSmithyDocumentSerde
}

// Describes the properties of the specified workflow
type DescribedWorkflow struct {

	// Specifies the unique Amazon Resource Name (ARN) for the workflow.
	//
	// This member is required.
	Arn *string

	// Specifies the text description for the workflow.
	Description *string

	// Specifies the steps (actions) to take if errors are encountered during
	// execution of the workflow.
	OnExceptionSteps []WorkflowStep

	// Specifies the details for the steps that are in the specified workflow.
	Steps []WorkflowStep

	// Key-value pairs that can be used to group and search for workflows. Tags are
	// metadata attached to workflows for any purpose.
	Tags []Tag

	// A unique identifier for the workflow.
	WorkflowId *string

	noSmithyDocumentSerde
}

// Specifies the details for the file location for the file that's being used in
// the workflow. Only applicable if you are using Amazon Elastic File Systems
// (Amazon EFS) for storage.
type EfsFileLocation struct {

	// The identifier of the file system, assigned by Amazon EFS.
	FileSystemId *string

	// The pathname for the folder being used by a workflow.
	Path *string

	noSmithyDocumentSerde
}

// The virtual private cloud (VPC) endpoint settings that are configured for your
// file transfer protocol-enabled server. With a VPC endpoint, you can restrict
// access to your server and resources only within your VPC. To control incoming
// internet traffic, invoke the UpdateServer API and attach an Elastic IP address
// to your server's endpoint. After May 19, 2021, you won't be able to create a
// server using EndpointType=VPC_ENDPOINT in your Amazon Web Servicesaccount if
// your account hasn't already done so before May 19, 2021. If you have already
// created servers with EndpointType=VPC_ENDPOINT in your Amazon Web
// Servicesaccount on or before May 19, 2021, you will not be affected. After this
// date, use EndpointType = VPC . For more information, see
// https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.
type EndpointDetails struct {

	// A list of address allocation IDs that are required to attach an Elastic IP
	// address to your server's endpoint. An address allocation ID corresponds to the
	// allocation ID of an Elastic IP address. This value can be retrieved from the
	// allocationId field from the Amazon EC2 Address (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_Address.html)
	// data type. One way to retrieve this value is by calling the EC2
	// DescribeAddresses (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAddresses.html)
	// API. This parameter is optional. Set this parameter if you want to make your VPC
	// endpoint public-facing. For details, see Create an internet-facing endpoint for
	// your server (https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#create-internet-facing-endpoint)
	// . This property can only be set as follows:
	//   - EndpointType must be set to VPC
	//   - The Transfer Family server must be offline.
	//   - You cannot set this parameter for Transfer Family servers that use the FTP
	//   protocol.
	//   - The server must already have SubnetIds populated ( SubnetIds and
	//   AddressAllocationIds cannot be updated simultaneously).
	//   - AddressAllocationIds can't contain duplicates, and must be equal in length
	//   to SubnetIds . For example, if you have three subnet IDs, you must also
	//   specify three address allocation IDs.
	//   - Call the UpdateServer API to set or change this parameter.
	AddressAllocationIds []string

	// A list of security groups IDs that are available to attach to your server's
	// endpoint. This property can only be set when EndpointType is set to VPC . You
	// can edit the SecurityGroupIds property in the UpdateServer (https://docs.aws.amazon.com/transfer/latest/userguide/API_UpdateServer.html)
	// API only if you are changing the EndpointType from PUBLIC or VPC_ENDPOINT to VPC
	// . To change security groups associated with your server's VPC endpoint after
	// creation, use the Amazon EC2 ModifyVpcEndpoint (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcEndpoint.html)
	// API.
	SecurityGroupIds []string

	// A list of subnet IDs that are required to host your server endpoint in your
	// VPC. This property can only be set when EndpointType is set to VPC .
	SubnetIds []string

	// The identifier of the VPC endpoint. This property can only be set when
	// EndpointType is set to VPC_ENDPOINT . For more information, see
	// https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.
	VpcEndpointId *string

	// The VPC identifier of the VPC in which a server's endpoint will be hosted. This
	// property can only be set when EndpointType is set to VPC .
	VpcId *string

	noSmithyDocumentSerde
}

// Specifies the error message and type, for an error that occurs during the
// execution of the workflow.
type ExecutionError struct {

	// Specifies the descriptive message that corresponds to the ErrorType .
	//
	// This member is required.
	Message *string

	// Specifies the error type.
	//   - ALREADY_EXISTS : occurs for a copy step, if the overwrite option is not
	//   selected and a file with the same name already exists in the target location.
	//   - BAD_REQUEST : a general bad request: for example, a step that attempts to
	//   tag an EFS file returns BAD_REQUEST , as only S3 files can be tagged.
	//   - CUSTOM_STEP_FAILED : occurs when the custom step provided a callback that
	//   indicates failure.
	//   - INTERNAL_SERVER_ERROR : a catch-all error that can occur for a variety of
	//   reasons.
	//   - NOT_FOUND : occurs when a requested entity, for example a source file for a
	//   copy step, does not exist.
	//   - PERMISSION_DENIED : occurs if your policy does not contain the correct
	//   permissions to complete one or more of the steps in the workflow.
	//   - TIMEOUT : occurs when the execution times out. You can set the
	//   TimeoutSeconds for a custom step, anywhere from 1 second to 1800 seconds (30
	//   minutes).
	//   - THROTTLED : occurs if you exceed the new execution refill rate of one
	//   workflow per second.
	//
	// This member is required.
	Type ExecutionErrorType

	noSmithyDocumentSerde
}

// Specifies the steps in the workflow, as well as the steps to execute in case of
// any errors during workflow execution.
type ExecutionResults struct {

	// Specifies the steps (actions) to take if errors are encountered during
	// execution of the workflow.
	OnExceptionSteps []ExecutionStepResult

	// Specifies the details for the steps that are in the specified workflow.
	Steps []ExecutionStepResult

	noSmithyDocumentSerde
}

// Specifies the following details for the step: error (if any), outputs (if any),
// and the step type.
type ExecutionStepResult struct {

	// Specifies the details for an error, if it occurred during execution of the
	// specified workflow step.
	Error *ExecutionError

	// The values for the key/value pair applied as a tag to the file. Only applicable
	// if the step type is TAG .
	Outputs *string

	// One of the available step types.
	//   - COPY - Copy the file to another location.
	//   - CUSTOM - Perform a custom step with an Lambda function target.
	//   - DECRYPT - Decrypt a file that was encrypted before it was uploaded.
	//   - DELETE - Delete the file.
	//   - TAG - Add a tag to the file.
	StepType WorkflowStepType

	noSmithyDocumentSerde
}

// Specifies the Amazon S3 or EFS file details to be used in the step.
type FileLocation struct {

	// Specifies the Amazon EFS identifier and the path for the file being used.
	EfsFileLocation *EfsFileLocation

	// Specifies the S3 details for the file being used, such as bucket, ETag, and so
	// forth.
	S3FileLocation *S3FileLocation

	noSmithyDocumentSerde
}

// Represents an object that contains entries and targets for HomeDirectoryMappings
// . The following is an Entry and Target pair example for chroot . [ { "Entry":
// "/", "Target": "/bucket_name/home/mydirectory" } ]
type HomeDirectoryMapEntry struct {

	// Represents an entry for HomeDirectoryMappings .
	//
	// This member is required.
	Entry *string

	// Represents the map target that is used in a HomeDirectoryMapEntry .
	//
	// This member is required.
	Target *string

	// Specifies the type of mapping. Set the type to FILE if you want the mapping to
	// point to a file, or DIRECTORY for the directory to point to a directory. By
	// default, home directory mappings have a Type of DIRECTORY when you create a
	// Transfer Family server. You would need to explicitly set Type to FILE if you
	// want a mapping to have a file target.
	Type MapType

	noSmithyDocumentSerde
}

// Returns information related to the type of user authentication that is in use
// for a file transfer protocol-enabled server's users. A server can have only one
// method of authentication.
type IdentityProviderDetails struct {

	// The identifier of the Directory Service directory that you want to use as your
	// identity provider.
	DirectoryId *string

	// The ARN for a Lambda function to use for the Identity provider.
	Function *string

	// This parameter is only applicable if your IdentityProviderType is API_GATEWAY .
	// Provides the type of InvocationRole used to authenticate the user account.
	InvocationRole *string

	// For SFTP-enabled servers, and for custom identity providers only, you can
	// specify whether to authenticate using a password, SSH key pair, or both.
	//   - PASSWORD - users must provide their password to connect.
	//   - PUBLIC_KEY - users must provide their private key to connect.
	//   - PUBLIC_KEY_OR_PASSWORD - users can authenticate with either their password
	//   or their key. This is the default value.
	//   - PUBLIC_KEY_AND_PASSWORD - users must provide both their private key and
	//   their password to connect. The server checks the key first, and then if the key
	//   is valid, the system prompts for a password. If the private key provided does
	//   not match the public key that is stored, authentication fails.
	SftpAuthenticationMethods SftpAuthenticationMethods

	// Provides the location of the service endpoint used to authenticate users.
	Url *string

	noSmithyDocumentSerde
}

// Specifies the location for the file that's being processed.
type InputFileLocation struct {

	// Specifies the details for the Amazon Elastic File System (Amazon EFS) file
	// that's being decrypted.
	EfsFileLocation *EfsFileLocation

	// Specifies the details for the Amazon S3 file that's being copied or decrypted.
	S3FileLocation *S3InputFileLocation

	noSmithyDocumentSerde
}

// Lists the properties for one or more specified associated accesses.
type ListedAccess struct {

	// A unique identifier that is required to identify specific groups within your
	// directory. The users of the group that you associate have access to your Amazon
	// S3 or Amazon EFS resources over the enabled protocols using Transfer Family. If
	// you know the group name, you can view the SID values by running the following
	// command using Windows PowerShell. Get-ADGroup -Filter {samAccountName -like
	// "YourGroupName*"} -Properties * | Select SamAccountName,ObjectSid In that
	// command, replace YourGroupName with the name of your Active Directory group. The
	// regular expression used to validate this parameter is a string of characters
	// consisting of uppercase and lowercase alphanumeric characters with no spaces.
	// You can also include underscores or any of the following characters: =,.@:/-
	ExternalId *string

	// The landing directory (folder) for a user when they log in to the server using
	// the client. A HomeDirectory example is /bucket_name/home/mydirectory . The
	// HomeDirectory parameter is only used if HomeDirectoryType is set to PATH .
	HomeDirectory *string

	// The type of landing directory (folder) that you want your users' home directory
	// to be when they log in to the server. If you set it to PATH , the user will see
	// the absolute Amazon S3 bucket or Amazon EFS path as is in their file transfer
	// protocol clients. If you set it to LOGICAL , you need to provide mappings in the
	// HomeDirectoryMappings for how you want to make Amazon S3 or Amazon EFS paths
	// visible to your users. If HomeDirectoryType is LOGICAL , you must provide
	// mappings, using the HomeDirectoryMappings parameter. If, on the other hand,
	// HomeDirectoryType is PATH , you provide an absolute path using the HomeDirectory
	// parameter. You cannot have both HomeDirectory and HomeDirectoryMappings in your
	// template.
	HomeDirectoryType HomeDirectoryType

	// The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role
	// that controls your users' access to your Amazon S3 bucket or Amazon EFS file
	// system. The policies attached to this role determine the level of access that
	// you want to provide your users when transferring files into and out of your
	// Amazon S3 bucket or Amazon EFS file system. The IAM role should also contain a
	// trust relationship that allows the server to access your resources when
	// servicing your users' transfer requests.
	Role *string

	noSmithyDocumentSerde
}

// Describes the properties of an agreement.
type ListedAgreement struct {

	// A unique identifier for the agreement. This identifier is returned when you
	// create an agreement.
	AgreementId *string

	// The Amazon Resource Name (ARN) of the specified agreement.
	Arn *string

	// The current description for the agreement. You can change it by calling the
	// UpdateAgreement operation and providing a new description.
	Description *string

	// A unique identifier for the AS2 local profile.
	LocalProfileId *string

	// A unique identifier for the partner profile.
	PartnerProfileId *string

	// The unique identifier for the agreement.
	ServerId *string

	// The agreement can be either ACTIVE or INACTIVE .
	Status AgreementStatusType

	noSmithyDocumentSerde
}

// Describes the properties of a certificate.
type ListedCertificate struct {

	// An optional date that specifies when the certificate becomes active.
	ActiveDate *time.Time

	// The Amazon Resource Name (ARN) of the specified certificate.
	Arn *string

	// An array of identifiers for the imported certificates. You use this identifier
	// for working with profiles and partner profiles.
	CertificateId *string

	// The name or short description that's used to identify the certificate.
	Description *string

	// An optional date that specifies when the certificate becomes inactive.
	InactiveDate *time.Time

	// The certificate can be either ACTIVE , PENDING_ROTATION , or INACTIVE .
	// PENDING_ROTATION means that this certificate will replace the current
	// certificate when it expires.
	Status CertificateStatusType

	// The type for the certificate. If a private key has been specified for the
	// certificate, its type is CERTIFICATE_WITH_PRIVATE_KEY . If there is no private
	// key, the type is CERTIFICATE .
	Type CertificateType

	// Specifies whether this certificate is used for signing or encryption.
	Usage CertificateUsageType

	noSmithyDocumentSerde
}

// Returns details of the connector that is specified.
type ListedConnector struct {

	// The Amazon Resource Name (ARN) of the specified connector.
	Arn *string

	// The unique identifier for the connector.
	ConnectorId *string

	// The URL of the partner's AS2 or SFTP endpoint.
	Url *string

	noSmithyDocumentSerde
}

// Returns properties of the execution that is specified.
type ListedExecution struct {

	// A unique identifier for the execution of a workflow.
	ExecutionId *string

	// A structure that describes the Amazon S3 or EFS file location. This is the file
	// location when the execution begins: if the file is being copied, this is the
	// initial (as opposed to destination) file location.
	InitialFileLocation *FileLocation

	// A container object for the session details that are associated with a workflow.
	ServiceMetadata *ServiceMetadata

	// The status is one of the execution. Can be in progress, completed, exception
	// encountered, or handling the exception.
	Status ExecutionStatus

	noSmithyDocumentSerde
}

// Returns properties of the host key that's specified.
type ListedHostKey struct {

	// The unique Amazon Resource Name (ARN) of the host key.
	//
	// This member is required.
	Arn *string

	// The date on which the host key was added to the server.
	DateImported *time.Time

	// The current description for the host key. You can change it by calling the
	// UpdateHostKey operation and providing a new description.
	Description *string

	// The public key fingerprint, which is a short sequence of bytes used to identify
	// the longer public key.
	Fingerprint *string

	// A unique identifier for the host key.
	HostKeyId *string

	// The encryption algorithm that is used for the host key. The Type parameter is
	// specified by using one of the following values:
	//   - ssh-rsa
	//   - ssh-ed25519
	//   - ecdsa-sha2-nistp256
	//   - ecdsa-sha2-nistp384
	//   - ecdsa-sha2-nistp521
	Type *string

	noSmithyDocumentSerde
}

// Returns the properties of the profile that was specified.
type ListedProfile struct {

	// The Amazon Resource Name (ARN) of the specified profile.
	Arn *string

	// The As2Id is the AS2-name, as defined in the RFC 4130 (https://datatracker.ietf.org/doc/html/rfc4130)
	// . For inbound transfers, this is the AS2-From header for the AS2 messages sent
	// from the partner. For outbound connectors, this is the AS2-To header for the
	// AS2 messages sent to the partner using the StartFileTransfer API operation.
	// This ID cannot include spaces.
	As2Id *string

	// A unique identifier for the local or partner AS2 profile.
	ProfileId *string

	// Indicates whether to list only LOCAL type profiles or only PARTNER type
	// profiles. If not supplied in the request, the command lists all types of
	// profiles.
	ProfileType ProfileType

	noSmithyDocumentSerde
}

// Returns properties of a file transfer protocol-enabled server that was
// specified.
type ListedServer struct {

	// Specifies the unique Amazon Resource Name (ARN) for a server to be listed.
	//
	// This member is required.
	Arn *string

	// Specifies the domain of the storage system that is used for file transfers.
	Domain Domain

	// Specifies the type of VPC endpoint that your server is connected to. If your
	// server is connected to a VPC endpoint, your server isn't accessible over the
	// public internet.
	EndpointType EndpointType

	// The mode of authentication for a server. The default value is SERVICE_MANAGED ,
	// which allows you to store and access user credentials within the Transfer Family
	// service. Use AWS_DIRECTORY_SERVICE to provide access to Active Directory groups
	// in Directory Service for Microsoft Active Directory or Microsoft Active
	// Directory in your on-premises environment or in Amazon Web Services using AD
	// Connector. This option also requires you to provide a Directory ID by using the
	// IdentityProviderDetails parameter. Use the API_GATEWAY value to integrate with
	// an identity provider of your choosing. The API_GATEWAY setting requires you to
	// provide an Amazon API Gateway endpoint URL to call for authentication by using
	// the IdentityProviderDetails parameter. Use the AWS_LAMBDA value to directly use
	// an Lambda function as your identity provider. If you choose this value, you must
	// specify the ARN for the Lambda function in the Function parameter for the
	// IdentityProviderDetails data type.
	IdentityProviderType IdentityProviderType

	// The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role
	// that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or
	// Amazon EFSevents. When set, you can view user activity in your CloudWatch logs.
	LoggingRole *string

	// Specifies the unique system assigned identifier for the servers that were
	// listed.
	ServerId *string

	// The condition of the server that was described. A value of ONLINE indicates
	// that the server can accept jobs and transfer files. A State value of OFFLINE
	// means that the server cannot perform file transfer operations. The states of
	// STARTING and STOPPING indicate that the server is in an intermediate state,
	// either not fully able to respond, or not fully offline. The values of
	// START_FAILED or STOP_FAILED can indicate an error condition.
	State State

	// Specifies the number of users that are assigned to a server you specified with
	// the ServerId .
	UserCount *int32

	noSmithyDocumentSerde
}

// Returns properties of the user that you specify.
type ListedUser struct {

	// Provides the unique Amazon Resource Name (ARN) for the user that you want to
	// learn about.
	//
	// This member is required.
	Arn *string

	// The landing directory (folder) for a user when they log in to the server using
	// the client. A HomeDirectory example is /bucket_name/home/mydirectory . The
	// HomeDirectory parameter is only used if HomeDirectoryType is set to PATH .
	HomeDirectory *string

	// The type of landing directory (folder) that you want your users' home directory
	// to be when they log in to the server. If you set it to PATH , the user will see
	// the absolute Amazon S3 bucket or Amazon EFS path as is in their file transfer
	// protocol clients. If you set it to LOGICAL , you need to provide mappings in the
	// HomeDirectoryMappings for how you want to make Amazon S3 or Amazon EFS paths
	// visible to your users. If HomeDirectoryType is LOGICAL , you must provide
	// mappings, using the HomeDirectoryMappings parameter. If, on the other hand,
	// HomeDirectoryType is PATH , you provide an absolute path using the HomeDirectory
	// parameter. You cannot have both HomeDirectory and HomeDirectoryMappings in your
	// template.
	HomeDirectoryType HomeDirectoryType

	// The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role
	// that controls your users' access to your Amazon S3 bucket or Amazon EFS file
	// system. The policies attached to this role determine the level of access that
	// you want to provide your users when transferring files into and out of your
	// Amazon S3 bucket or Amazon EFS file system. The IAM role should also contain a
	// trust relationship that allows the server to access your resources when
	// servicing your users' transfer requests. The IAM role that controls your users'
	// access to your Amazon S3 bucket for servers with Domain=S3 , or your EFS file
	// system for servers with Domain=EFS . The policies attached to this role
	// determine the level of access you want to provide your users when transferring
	// files into and out of your S3 buckets or EFS file systems.
	Role *string

	// Specifies the number of SSH public keys stored for the user you specified.
	SshPublicKeyCount *int32

	// Specifies the name of the user whose ARN was specified. User names are used for
	// authentication purposes.
	UserName *string

	noSmithyDocumentSerde
}

// Contains the identifier, text description, and Amazon Resource Name (ARN) for
// the workflow.
type ListedWorkflow struct {

	// Specifies the unique Amazon Resource Name (ARN) for the workflow.
	Arn *string

	// Specifies the text description for the workflow.
	Description *string

	// A unique identifier for the workflow.
	WorkflowId *string

	noSmithyDocumentSerde
}

// Consists of the logging role and the log group name.
type LoggingConfiguration struct {

	// The name of the CloudWatch logging group for the Transfer Family server to
	// which this workflow belongs.
	LogGroupName *string

	// The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role
	// that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or
	// Amazon EFSevents. When set, you can view user activity in your CloudWatch logs.
	LoggingRole *string

	noSmithyDocumentSerde
}

// The full POSIX identity, including user ID ( Uid ), group ID ( Gid ), and any
// secondary groups IDs ( SecondaryGids ), that controls your users' access to your
// Amazon EFS file systems. The POSIX permissions that are set on files and
// directories in your file system determine the level of access your users get
// when transferring files into and out of your Amazon EFS file systems.
type PosixProfile struct {

	// The POSIX group ID used for all EFS operations by this user.
	//
	// This member is required.
	Gid *int64

	// The POSIX user ID used for all EFS operations by this user.
	//
	// This member is required.
	Uid *int64

	// The secondary POSIX group IDs used for all EFS operations by this user.
	SecondaryGids []int64

	noSmithyDocumentSerde
}

// The protocol settings that are configured for your server.
type ProtocolDetails struct {

	// Indicates the transport method for the AS2 messages. Currently, only HTTP is
	// supported.
	As2Transports []As2Transport

	// Indicates passive mode, for FTP and FTPS protocols. Enter a single IPv4
	// address, such as the public IP address of a firewall, router, or load balancer.
	// For example: aws transfer update-server --protocol-details PassiveIp=0.0.0.0
	// Replace 0.0.0.0 in the example above with the actual IP address you want to
	// use. If you change the PassiveIp value, you must stop and then restart your
	// Transfer Family server for the change to take effect. For details on using
	// passive mode (PASV) in a NAT environment, see Configuring your FTPS server
	// behind a firewall or NAT with Transfer Family (http://aws.amazon.com/blogs/storage/configuring-your-ftps-server-behind-a-firewall-or-nat-with-aws-transfer-family/)
	// . Special values The AUTO and 0.0.0.0 are special values for the PassiveIp
	// parameter. The value PassiveIp=AUTO is assigned by default to FTP and FTPS type
	// servers. In this case, the server automatically responds with one of the
	// endpoint IPs within the PASV response. PassiveIp=0.0.0.0 has a more unique
	// application for its usage. For example, if you have a High Availability (HA)
	// Network Load Balancer (NLB) environment, where you have 3 subnets, you can only
	// specify a single IP address using the PassiveIp parameter. This reduces the
	// effectiveness of having High Availability. In this case, you can specify
	// PassiveIp=0.0.0.0 . This tells the client to use the same IP address as the
	// Control connection and utilize all AZs for their connections. Note, however,
	// that not all FTP clients support the PassiveIp=0.0.0.0 response. FileZilla and
	// WinSCP do support it. If you are using other clients, check to see if your
	// client supports the PassiveIp=0.0.0.0 response.
	PassiveIp *string

	// Use the SetStatOption to ignore the error that is generated when the client
	// attempts to use SETSTAT on a file you are uploading to an S3 bucket. Some SFTP
	// file transfer clients can attempt to change the attributes of remote files,
	// including timestamp and permissions, using commands, such as SETSTAT when
	// uploading the file. However, these commands are not compatible with object
	// storage systems, such as Amazon S3. Due to this incompatibility, file uploads
	// from these clients can result in errors even when the file is otherwise
	// successfully uploaded. Set the value to ENABLE_NO_OP to have the Transfer
	// Family server ignore the SETSTAT command, and upload files without needing to
	// make any changes to your SFTP client. While the SetStatOption ENABLE_NO_OP
	// setting ignores the error, it does generate a log entry in Amazon CloudWatch
	// Logs, so you can determine when the client is making a SETSTAT call. If you
	// want to preserve the original timestamp for your file, and modify other file
	// attributes using SETSTAT , you can use Amazon EFS as backend storage with
	// Transfer Family.
	SetStatOption SetStatOption

	// A property used with Transfer Family servers that use the FTPS protocol. TLS
	// Session Resumption provides a mechanism to resume or share a negotiated secret
	// key between the control and data connection for an FTPS session.
	// TlsSessionResumptionMode determines whether or not the server resumes recent,
	// negotiated sessions through a unique session ID. This property is available
	// during CreateServer and UpdateServer calls. If a TlsSessionResumptionMode value
	// is not specified during CreateServer , it is set to ENFORCED by default.
	//   - DISABLED : the server does not process TLS session resumption client
	//   requests and creates a new TLS session for each request.
	//   - ENABLED : the server processes and accepts clients that are performing TLS
	//   session resumption. The server doesn't reject client data connections that do
	//   not perform the TLS session resumption client processing.
	//   - ENFORCED : the server processes and accepts clients that are performing TLS
	//   session resumption. The server rejects client data connections that do not
	//   perform the TLS session resumption client processing. Before you set the value
	//   to ENFORCED , test your clients. Not all FTPS clients perform TLS session
	//   resumption. So, if you choose to enforce TLS session resumption, you prevent any
	//   connections from FTPS clients that don't perform the protocol negotiation. To
	//   determine whether or not you can use the ENFORCED value, you need to test your
	//   clients.
	TlsSessionResumptionMode TlsSessionResumptionMode

	noSmithyDocumentSerde
}

// Specifies the details for the file location for the file that's being used in
// the workflow. Only applicable if you are using S3 storage.
type S3FileLocation struct {

	// Specifies the S3 bucket that contains the file being used.
	Bucket *string

	// The entity tag is a hash of the object. The ETag reflects changes only to the
	// contents of an object, not its metadata.
	Etag *string

	// The name assigned to the file when it was created in Amazon S3. You use the
	// object key to retrieve the object.
	Key *string

	// Specifies the file version.
	VersionId *string

	noSmithyDocumentSerde
}

// Specifies the customer input Amazon S3 file location. If it is used inside
// copyStepDetails.DestinationFileLocation , it should be the S3 copy destination.
// You need to provide the bucket and key. The key can represent either a path or a
// file. This is determined by whether or not you end the key value with the
// forward slash (/) character. If the final character is "/", then your file is
// copied to the folder, and its name does not change. If, rather, the final
// character is alphanumeric, your uploaded file is renamed to the path value. In
// this case, if a file with that name already exists, it is overwritten. For
// example, if your path is shared-files/bob/ , your uploaded files are copied to
// the shared-files/bob/ , folder. If your path is shared-files/today , each
// uploaded file is copied to the shared-files folder and named today : each upload
// overwrites the previous version of the bob file.
type S3InputFileLocation struct {

	// Specifies the S3 bucket for the customer input file.
	Bucket *string

	// The name assigned to the file when it was created in Amazon S3. You use the
	// object key to retrieve the object.
	Key *string

	noSmithyDocumentSerde
}

// The Amazon S3 storage options that are configured for your server.
type S3StorageOptions struct {

	// Specifies whether or not performance for your Amazon S3 directories is
	// optimized. This is disabled by default. By default, home directory mappings have
	// a TYPE of DIRECTORY . If you enable this option, you would then need to
	// explicitly set the HomeDirectoryMapEntry Type to FILE if you want a mapping to
	// have a file target.
	DirectoryListingOptimization DirectoryListingOptimization

	noSmithyDocumentSerde
}

// Specifies the key-value pair that are assigned to a file during the execution
// of a Tagging step.
type S3Tag struct {

	// The name assigned to the tag that you create.
	//
	// This member is required.
	Key *string

	// The value that corresponds to the key.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// A container object for the session details that are associated with a workflow.
type ServiceMetadata struct {

	// The Server ID ( ServerId ), Session ID ( SessionId ) and user ( UserName ) make
	// up the UserDetails .
	//
	// This member is required.
	UserDetails *UserDetails

	noSmithyDocumentSerde
}

// Contains the details for an SFTP connector object. The connector object is used
// for transferring files to and from a partner's SFTP server. Because the
// SftpConnectorConfig data type is used for both creating and updating SFTP
// connectors, its parameters, TrustedHostKeys and UserSecretId are marked as not
// required. This is a bit misleading, as they are not required when you are
// updating an existing SFTP connector, but are required when you are creating a
// new SFTP connector.
type SftpConnectorConfig struct {

	// The public portion of the host key, or keys, that are used to identify the
	// external server to which you are connecting. You can use the ssh-keyscan
	// command against the SFTP server to retrieve the necessary key. The three
	// standard SSH public key format elements are <key type> , <body base64> , and an
	// optional <comment> , with spaces between each element. Specify only the <key
	// type> and <body base64> : do not enter the <comment> portion of the key. For
	// the trusted host key, Transfer Family accepts RSA and ECDSA keys.
	//   - For RSA keys, the <key type> string is ssh-rsa .
	//   - For ECDSA keys, the <key type> string is either ecdsa-sha2-nistp256 ,
	//   ecdsa-sha2-nistp384 , or ecdsa-sha2-nistp521 , depending on the size of the
	//   key you generated.
	// Run this command to retrieve the SFTP server host key, where your SFTP server
	// name is ftp.host.com . ssh-keyscan ftp.host.com This prints the public host key
	// to standard output. ftp.host.com ssh-rsa AAAAB3Nza...<long-string-for-public-key
	// Copy and paste this string into the TrustedHostKeys field for the
	// create-connector command or into the Trusted host keys field in the console.
	TrustedHostKeys []string

	// The identifier for the secret (in Amazon Web Services Secrets Manager) that
	// contains the SFTP user's private key, password, or both. The identifier must be
	// the Amazon Resource Name (ARN) of the secret.
	UserSecretId *string

	noSmithyDocumentSerde
}

// Provides information about the public Secure Shell (SSH) key that is associated
// with a Transfer Family user for the specific file transfer protocol-enabled
// server (as identified by ServerId ). The information returned includes the date
// the key was imported, the public key contents, and the public key ID. A user can
// store more than one SSH public key associated with their user name on a specific
// server.
type SshPublicKey struct {

	// Specifies the date that the public key was added to the Transfer Family user.
	//
	// This member is required.
	DateImported *time.Time

	// Specifies the content of the SSH public key as specified by the PublicKeyId .
	// Transfer Family accepts RSA, ECDSA, and ED25519 keys.
	//
	// This member is required.
	SshPublicKeyBody *string

	// Specifies the SshPublicKeyId parameter contains the identifier of the public
	// key.
	//
	// This member is required.
	SshPublicKeyId *string

	noSmithyDocumentSerde
}

// Creates a key-value pair for a specific resource. Tags are metadata that you
// can use to search for and group a resource for various purposes. You can apply
// tags to servers, users, and roles. A tag key can take more than one value. For
// example, to group servers for accounting purposes, you might create a tag called
// Group and assign the values Research and Accounting to that group.
type Tag struct {

	// The name assigned to the tag that you create.
	//
	// This member is required.
	Key *string

	// Contains one or more values that you assigned to the key name you create.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Each step type has its own StepDetails structure. The key/value pairs used to
// tag a file during the execution of a workflow step.
type TagStepDetails struct {

	// The name of the step, used as an identifier.
	Name *string

	// Specifies which file to use as input to the workflow step: either the output
	// from the previous step, or the originally uploaded file for the workflow.
	//   - To use the previous file as the input, enter ${previous.file} . In this
	//   case, this workflow step uses the output file from the previous workflow step as
	//   input. This is the default value.
	//   - To use the originally uploaded file location as input for this step, enter
	//   ${original.file} .
	SourceFileLocation *string

	// Array that contains from 1 to 10 key/value pairs.
	Tags []S3Tag

	noSmithyDocumentSerde
}

// Specifies the user name, server ID, and session ID for a workflow.
type UserDetails struct {

	// The system-assigned unique identifier for a Transfer server instance.
	//
	// This member is required.
	ServerId *string

	// A unique string that identifies a Transfer Family user associated with a server.
	//
	// This member is required.
	UserName *string

	// The system-assigned unique identifier for a session that corresponds to the
	// workflow.
	SessionId *string

	noSmithyDocumentSerde
}

// Specifies the workflow ID for the workflow to assign and the execution role
// that's used for executing the workflow. In addition to a workflow to execute
// when a file is uploaded completely, WorkflowDetails can also contain a workflow
// ID (and execution role) for a workflow to execute on partial upload. A partial
// upload occurs when the server session disconnects while the file is still being
// uploaded.
type WorkflowDetail struct {

	// Includes the necessary permissions for S3, EFS, and Lambda operations that
	// Transfer can assume, so that all workflow steps can operate on the required
	// resources
	//
	// This member is required.
	ExecutionRole *string

	// A unique identifier for the workflow.
	//
	// This member is required.
	WorkflowId *string

	noSmithyDocumentSerde
}

// Container for the WorkflowDetail data type. It is used by actions that trigger
// a workflow to begin execution.
type WorkflowDetails struct {

	// A trigger that starts a workflow if a file is only partially uploaded. You can
	// attach a workflow to a server that executes whenever there is a partial upload.
	// A partial upload occurs when a file is open when the session disconnects.
	OnPartialUpload []WorkflowDetail

	// A trigger that starts a workflow: the workflow begins to execute after a file
	// is uploaded. To remove an associated workflow from a server, you can provide an
	// empty OnUpload object, as in the following example. aws transfer update-server
	// --server-id s-01234567890abcdef --workflow-details '{"OnUpload":[]}'
	OnUpload []WorkflowDetail

	noSmithyDocumentSerde
}

// The basic building block of a workflow.
type WorkflowStep struct {

	// Details for a step that performs a file copy. Consists of the following values:
	//   - A description
	//   - An Amazon S3 location for the destination of the file copy.
	//   - A flag that indicates whether to overwrite an existing file of the same
	//   name. The default is FALSE .
	CopyStepDetails *CopyStepDetails

	// Details for a step that invokes an Lambda function. Consists of the Lambda
	// function's name, target, and timeout (in seconds).
	CustomStepDetails *CustomStepDetails

	// Details for a step that decrypts an encrypted file. Consists of the following
	// values:
	//   - A descriptive name
	//   - An Amazon S3 or Amazon Elastic File System (Amazon EFS) location for the
	//   source file to decrypt.
	//   - An S3 or Amazon EFS location for the destination of the file decryption.
	//   - A flag that indicates whether to overwrite an existing file of the same
	//   name. The default is FALSE .
	//   - The type of encryption that's used. Currently, only PGP encryption is
	//   supported.
	DecryptStepDetails *DecryptStepDetails

	// Details for a step that deletes the file.
	DeleteStepDetails *DeleteStepDetails

	// Details for a step that creates one or more tags. You specify one or more tags.
	// Each tag contains a key-value pair.
	TagStepDetails *TagStepDetails

	// Currently, the following step types are supported.
	//   - COPY - Copy the file to another location.
	//   - CUSTOM - Perform a custom step with an Lambda function target.
	//   - DECRYPT - Decrypt a file that was encrypted before it was uploaded.
	//   - DELETE - Delete the file.
	//   - TAG - Add a tag to the file.
	Type WorkflowStepType

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
